"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Parser = void 0;

var _events = require("events");

var _streamParser = _interopRequireDefault(require("./stream-parser"));

var _stream = require("stream");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Parser extends _events.EventEmitter {
  constructor(message, debug, handler, options) {
    super();
    this.debug = void 0;
    this.options = void 0;
    this.parser = void 0;
    this.debug = debug;
    this.options = options;
    this.parser = _stream.Readable.from(_streamParser.default.parseTokens(message, this.debug, this.options));
    this.parser.on('data', token => {
      handler[token.handlerName](token);
    });
    this.parser.on('drain', () => {
      this.emit('drain');
    });
    this.parser.on('end', () => {
      this.emit('end');
    });
  }

  pause() {
    return this.parser.pause();
  }

  resume() {
    return this.parser.resume();
  }

}

exports.Parser = Parser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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