"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _valueParser = _interopRequireDefault(require("../value-parser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// s2.2.7.17
async function rowParser(parser) {
  const colMetadata = parser.colMetadata;
  const length = colMetadata.length;
  const columns = [];

  for (let i = 0; i < length; i++) {
    const currColMetadata = colMetadata[i];
    let value;
    (0, _valueParser.default)(parser, currColMetadata, parser.options, v => {
      value = v;
    });

    while (parser.suspended) {
      await parser.streamBuffer.waitForChunk();
      parser.suspended = false;
      const next = parser.next;
      next();
    }

    columns.push({
      value,
      metadata: currColMetadata
    });
  }

  if (parser.options.useColumnNames) {
    const columnsMap = Object.create(null);
    columns.forEach(column => {
      const colName = column.metadata.colName;

      if (columnsMap[colName] == null) {
        columnsMap[colName] = column;
      }
    });
    return new _token.RowToken(columnsMap);
  } else {
    return new _token.RowToken(columns);
  }
}

var _default = rowParser;
exports.default = _default;
module.exports = rowParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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