"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

// s2.2.7.14
function orderParser(parser, _options, callback) {
  parser.readUInt16LE(length => {
    const columnCount = length / 2;
    const orderColumns = [];
    let i = 0;

    function next(done) {
      if (i === columnCount) {
        return done();
      }

      parser.readUInt16LE(column => {
        orderColumns.push(column);
        i++;
        next(done);
      });
    }

    next(() => {
      callback(new _token.OrderToken(orderColumns));
    });
  });
}

var _default = orderParser;
exports.default = _default;
module.exports = orderParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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