"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

var _valueParser = _interopRequireDefault(require("../value-parser"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// s2.2.7.13 (introduced in TDS 7.3.B)
function nullHandler(_parser, _columnMetadata, _options, callback) {
  callback(null);
}

async function nbcRowParser(parser) {
  const colMetadata = parser.colMetadata;
  const bitmapByteLength = Math.ceil(colMetadata.length / 8);
  const columns = [];
  const bitmap = [];

  while (parser.buffer.length - parser.position < bitmapByteLength) {
    await parser.streamBuffer.waitForChunk();
  }

  const bytes = parser.buffer.slice(parser.position, parser.position + bitmapByteLength);
  parser.position += bitmapByteLength;

  for (let i = 0, len = bytes.length; i < len; i++) {
    const byte = bytes[i];
    bitmap.push(byte & 0b1 ? true : false);
    bitmap.push(byte & 0b10 ? true : false);
    bitmap.push(byte & 0b100 ? true : false);
    bitmap.push(byte & 0b1000 ? true : false);
    bitmap.push(byte & 0b10000 ? true : false);
    bitmap.push(byte & 0b100000 ? true : false);
    bitmap.push(byte & 0b1000000 ? true : false);
    bitmap.push(byte & 0b10000000 ? true : false);
  }

  for (let i = 0; i < colMetadata.length; i++) {
    const currColMetadata = colMetadata[i];
    let value;
    (bitmap[i] ? nullHandler : _valueParser.default)(parser, currColMetadata, parser.options, v => {
      value = v;
    });

    while (parser.suspended) {
      await parser.streamBuffer.waitForChunk();
      parser.suspended = false;
      const next = parser.next;
      next();
    }

    columns.push({
      value,
      metadata: currColMetadata
    });
  }

  if (parser.options.useColumnNames) {
    const columnsMap = {};
    columns.forEach(column => {
      const colName = column.metadata.colName;

      if (columnsMap[colName] == null) {
        columnsMap[colName] = column;
      }
    });
    return new _token.NBCRowToken(columnsMap);
  } else {
    return new _token.NBCRowToken(columns);
  }
}

var _default = nbcRowParser;
exports.default = _default;
module.exports = nbcRowParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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