"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.doneParser = doneParser;
exports.doneInProcParser = doneInProcParser;
exports.doneProcParser = doneProcParser;

var _jsbi = _interopRequireDefault(require("jsbi"));

var _token = require("./token");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// s2.2.7.5/6/7
const STATUS = {
  MORE: 0x0001,
  ERROR: 0x0002,
  // This bit is not yet in use by SQL Server, so is not exposed in the returned token
  INXACT: 0x0004,
  COUNT: 0x0010,
  ATTN: 0x0020,
  SRVERROR: 0x0100
};

function parseToken(parser, options, callback) {
  parser.readUInt16LE(status => {
    const more = !!(status & STATUS.MORE);
    const sqlError = !!(status & STATUS.ERROR);
    const rowCountValid = !!(status & STATUS.COUNT);
    const attention = !!(status & STATUS.ATTN);
    const serverError = !!(status & STATUS.SRVERROR);
    parser.readUInt16LE(curCmd => {
      const next = rowCount => {
        callback({
          more: more,
          sqlError: sqlError,
          attention: attention,
          serverError: serverError,
          rowCount: rowCountValid ? rowCount : undefined,
          curCmd: curCmd
        });
      };

      if (options.tdsVersion < '7_2') {
        parser.readUInt32LE(next);
      } else {
        parser.readBigUInt64LE(rowCount => {
          next(_jsbi.default.toNumber(rowCount));
        });
      }
    });
  });
}

function doneParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.DoneToken(data));
  });
}

function doneInProcParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.DoneInProcToken(data));
  });
}

function doneProcParser(parser, options, callback) {
  parseToken(parser, options, data => {
    callback(new _token.DoneProcToken(data));
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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