"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var tls = _interopRequireWildcard(require("tls"));

var _events = require("events");

var _message = _interopRequireDefault(require("./message"));

var _packet = require("./packet");

var _incomingMessageStream = _interopRequireDefault(require("./incoming-message-stream"));

var _outgoingMessageStream = _interopRequireDefault(require("./outgoing-message-stream"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// eslint-disable-next-line @typescript-eslint/no-var-requires
const DuplexPair = require('native-duplexpair');

class MessageIO extends _events.EventEmitter {
  constructor(socket, packetSize, debug) {
    super();
    this.socket = void 0;
    this.debug = void 0;
    this.tlsNegotiationComplete = void 0;
    this.incomingMessageStream = void 0;
    this.outgoingMessageStream = void 0;
    this.securePair = void 0;
    this.incomingMessageIterator = void 0;
    this.socket = socket;
    this.debug = debug;
    this.tlsNegotiationComplete = false;
    this.incomingMessageStream = new _incomingMessageStream.default(this.debug);
    this.incomingMessageIterator = this.incomingMessageStream[Symbol.asyncIterator]();
    this.outgoingMessageStream = new _outgoingMessageStream.default(this.debug, {
      packetSize: packetSize
    });
    this.socket.pipe(this.incomingMessageStream);
    this.outgoingMessageStream.pipe(this.socket);
  }

  packetSize(...args) {
    if (args.length > 0) {
      const packetSize = args[0];
      this.debug.log('Packet size changed from ' + this.outgoingMessageStream.packetSize + ' to ' + packetSize);
      this.outgoingMessageStream.packetSize = packetSize;
    }

    if (this.securePair) {
      this.securePair.cleartext.setMaxSendFragment(this.outgoingMessageStream.packetSize);
    }

    return this.outgoingMessageStream.packetSize;
  }

  startTls(secureContext, hostname, trustServerCertificate) {
    const duplexpair = new DuplexPair();
    const securePair = this.securePair = {
      cleartext: tls.connect({
        socket: duplexpair.socket1,
        servername: hostname,
        secureContext: secureContext,
        rejectUnauthorized: !trustServerCertificate
      }),
      encrypted: duplexpair.socket2
    }; // If an error happens in the TLS layer, there is nothing we can do about it.
    // Forward the error to the socket so the connection gets properly cleaned up.

    securePair.cleartext.on('error', err => {
      // Streams in node.js versions before 8.0.0 don't support `.destroy`
      if (typeof securePair.encrypted.destroy === 'function') {
        securePair.encrypted.destroy();
      }

      this.socket.destroy(err);
    });
    securePair.cleartext.on('secureConnect', () => {
      const cipher = securePair.cleartext.getCipher();

      if (cipher) {
        this.debug.log('TLS negotiated (' + cipher.name + ', ' + cipher.version + ')');
      }

      this.emit('secure', securePair.cleartext);
      this.encryptAllFutureTraffic();
    });
    securePair.encrypted.on('data', data => {
      this.sendMessage(_packet.TYPE.PRELOGIN, data, false);
    });
  }

  encryptAllFutureTraffic() {
    const securePair = this.securePair;
    securePair.cleartext.setMaxSendFragment(this.outgoingMessageStream.packetSize);
    securePair.encrypted.removeAllListeners('data');
    this.outgoingMessageStream.unpipe(this.socket);
    this.socket.unpipe(this.incomingMessageStream);
    this.socket.pipe(securePair.encrypted);
    securePair.encrypted.pipe(this.socket);
    securePair.cleartext.pipe(this.incomingMessageStream);
    this.outgoingMessageStream.pipe(securePair.cleartext);
    this.tlsNegotiationComplete = true;
  }

  tlsHandshakeData(data) {
    const securePair = this.securePair;
    securePair.encrypted.write(data);
  } // TODO listen for 'drain' event when socket.write returns false.
  // TODO implement incomplete request cancelation (2.2.1.6)


  sendMessage(packetType, data, resetConnection) {
    const message = new _message.default({
      type: packetType,
      resetConnection: resetConnection
    });
    message.end(data);
    this.outgoingMessageStream.write(message);
    return message;
  }
  /**
   * Read the next incoming message from the socket.
   */


  async readMessage() {
    const result = await this.incomingMessageIterator.next();

    if (result.done) {
      throw new Error('unexpected end of message stream');
    }

    return result.value;
  } // Temporarily suspends the flow of incoming packets.


  pause() {
    this.incomingMessageStream.pause();
  } // Resumes the flow of incoming packets.


  resume() {
    this.incomingMessageStream.resume();
  }

}

var _default = MessageIO;
exports.default = _default;
module.exports = MessageIO;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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