"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconvLite = _interopRequireDefault(require("iconv-lite"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const Text = {
  id: 0x23,
  type: 'TEXT',
  name: 'Text',
  hasTableName: true,
  declaration: function () {
    return 'text';
  },
  resolveLength: function (parameter) {
    const value = parameter.value;

    if (value != null) {
      return value.length;
    } else {
      return -1;
    }
  },

  generateTypeInfo(parameter, _options) {
    const buffer = Buffer.alloc(10);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);

    if (parameter.collation) {
      parameter.collation.toBuffer().copy(buffer, 5, 0, 5);
    }

    return buffer;
  },

  generateParameterLength(parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(value.length, 0);
    return buffer;
  },

  generateParameterData: function* (parameter, options) {
    const value = parameter.value;

    if (value == null) {
      return;
    }

    yield value;
  },
  validate: function (value, collation) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    if (!collation) {
      throw new Error('No collation was set by the server for the current connection.');
    }

    if (!collation.codepage) {
      throw new Error('The collation set by the server has no associated encoding.');
    }

    return _iconvLite.default.encode(value, collation.codepage);
  }
};
var _default = Text;
exports.default = _default;
module.exports = Text;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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