"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x02]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallInt = {
  id: 0x34,
  type: 'INT2',
  name: 'SmallInt',
  declaration: function () {
    return 'smallint';
  },

  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x02]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(2);
    buffer.writeInt16LE(Number(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < -32768 || value > 32767) {
      throw new TypeError('Value must be between -32768 and 32767, inclusive.');
    }

    return value | 0;
  }
};
var _default = SmallInt;
exports.default = _default;
module.exports = SmallInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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