"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@js-joda/core");

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EPOCH_DATE = _core.LocalDate.ofYearDay(1, 1);

const NULL_LENGTH = Buffer.from([0x00]);
const DateTimeOffset = {
  id: 0x2B,
  type: 'DATETIMEOFFSETN',
  name: 'DateTimeOffset',
  declaration: function (parameter) {
    return 'datetimeoffset(' + this.resolveScale(parameter) + ')';
  },
  resolveScale: function (parameter) {
    if (parameter.scale != null) {
      return parameter.scale;
    } else if (parameter.value === null) {
      return 0;
    } else {
      return 7;
    }
  },

  generateTypeInfo(parameter) {
    return Buffer.from([this.id, parameter.scale]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    switch (parameter.scale) {
      case 0:
      case 1:
      case 2:
        return Buffer.from([0x08]);

      case 3:
      case 4:
        return Buffer.from([0x09]);

      case 5:
      case 6:
      case 7:
        return Buffer.from([0x0A]);

      default:
        throw new Error('invalid scale');
    }
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value;
    let scale = parameter.scale;
    const buffer = new _writableTrackingBuffer.default(16);
    scale = scale;
    let timestamp;
    timestamp = ((value.getUTCHours() * 60 + value.getUTCMinutes()) * 60 + value.getUTCSeconds()) * 1000 + value.getMilliseconds();
    timestamp = timestamp * Math.pow(10, scale - 3);
    timestamp += (value.nanosecondDelta != null ? value.nanosecondDelta : 0) * Math.pow(10, scale);
    timestamp = Math.round(timestamp);

    switch (scale) {
      case 0:
      case 1:
      case 2:
        buffer.writeUInt24LE(timestamp);
        break;

      case 3:
      case 4:
        buffer.writeUInt32LE(timestamp);
        break;

      case 5:
      case 6:
      case 7:
        buffer.writeUInt40LE(timestamp);
    }

    const date = _core.LocalDate.of(value.getUTCFullYear(), value.getUTCMonth() + 1, value.getUTCDate());

    const days = EPOCH_DATE.until(date, _core.ChronoUnit.DAYS);
    buffer.writeUInt24LE(days);
    const offset = -value.getTimezoneOffset();
    buffer.writeInt16LE(offset);
    yield buffer.data;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = DateTimeOffset;
exports.default = _default;
module.exports = DateTimeOffset;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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