"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _intn = _interopRequireDefault(require("./intn"));

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DATA_LENGTH = Buffer.from([0x08]);
const NULL_LENGTH = Buffer.from([0x00]);
const BigInt = {
  id: 0x7F,
  type: 'INT8',
  name: 'BigInt',
  declaration: function () {
    return 'bigint';
  },

  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x08]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = new _writableTrackingBuffer.default(8);
    buffer.writeInt64LE(Number(parameter.value));
    yield buffer.data;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'number') {
      value = Number(value);
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    if (value < Number.MIN_SAFE_INTEGER || value > Number.MAX_SAFE_INTEGER) {
      throw new TypeError(`Value must be between ${Number.MIN_SAFE_INTEGER} and ${Number.MAX_SAFE_INTEGER}, inclusive.  For smaller or bigger numbers, use VarChar type.`);
    }

    return value;
  }
};
var _default = BigInt;
exports.default = _default;
module.exports = BigInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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