"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldHonorAE = void 0;

var _types = require("./types");

// This code is based on the `mssql-jdbc` library published under the conditions of MIT license.
// Copyright (c) 2019 Microsoft Corporation
const shouldHonorAE = (stmtColumnEncryptionSetting, columnEncryptionSetting) => {
  switch (stmtColumnEncryptionSetting) {
    case _types.SQLServerStatementColumnEncryptionSetting.Disabled:
    case _types.SQLServerStatementColumnEncryptionSetting.ResultSetOnly:
      return false;

    case _types.SQLServerStatementColumnEncryptionSetting.Enabled:
      return true;

    default:
      return columnEncryptionSetting;
  }
};

exports.shouldHonorAE = shouldHonorAE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hbHdheXMtZW5jcnlwdGVkL3V0aWxzLnRzIl0sIm5hbWVzIjpbInNob3VsZEhvbm9yQUUiLCJzdG10Q29sdW1uRW5jcnlwdGlvblNldHRpbmciLCJjb2x1bW5FbmNyeXB0aW9uU2V0dGluZyIsIlNRTFNlcnZlclN0YXRlbWVudENvbHVtbkVuY3J5cHRpb25TZXR0aW5nIiwiRGlzYWJsZWQiLCJSZXN1bHRTZXRPbmx5IiwiRW5hYmxlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUdBOztBQUhBO0FBQ0E7QUFJTyxNQUFNQSxhQUFhLEdBQUcsQ0FBQ0MsMkJBQUQsRUFBeUVDLHVCQUF6RSxLQUF1SDtBQUNsSixVQUFRRCwyQkFBUjtBQUNFLFNBQUtFLGlEQUEwQ0MsUUFBL0M7QUFDQSxTQUFLRCxpREFBMENFLGFBQS9DO0FBQ0UsYUFBTyxLQUFQOztBQUNGLFNBQUtGLGlEQUEwQ0csT0FBL0M7QUFDRSxhQUFPLElBQVA7O0FBQ0Y7QUFDRSxhQUFPSix1QkFBUDtBQVBKO0FBU0QsQ0FWTSIsInNvdXJjZXNDb250ZW50IjpbIi8vIFRoaXMgY29kZSBpcyBiYXNlZCBvbiB0aGUgYG1zc3FsLWpkYmNgIGxpYnJhcnkgcHVibGlzaGVkIHVuZGVyIHRoZSBjb25kaXRpb25zIG9mIE1JVCBsaWNlbnNlLlxuLy8gQ29weXJpZ2h0IChjKSAyMDE5IE1pY3Jvc29mdCBDb3Jwb3JhdGlvblxuXG5pbXBvcnQgeyBTUUxTZXJ2ZXJTdGF0ZW1lbnRDb2x1bW5FbmNyeXB0aW9uU2V0dGluZyB9IGZyb20gJy4vdHlwZXMnO1xuXG5leHBvcnQgY29uc3Qgc2hvdWxkSG9ub3JBRSA9IChzdG10Q29sdW1uRW5jcnlwdGlvblNldHRpbmc6IFNRTFNlcnZlclN0YXRlbWVudENvbHVtbkVuY3J5cHRpb25TZXR0aW5nLCBjb2x1bW5FbmNyeXB0aW9uU2V0dGluZzogYm9vbGVhbik6IGJvb2xlYW4gPT4ge1xuICBzd2l0Y2ggKHN0bXRDb2x1bW5FbmNyeXB0aW9uU2V0dGluZykge1xuICAgIGNhc2UgU1FMU2VydmVyU3RhdGVtZW50Q29sdW1uRW5jcnlwdGlvblNldHRpbmcuRGlzYWJsZWQ6XG4gICAgY2FzZSBTUUxTZXJ2ZXJTdGF0ZW1lbnRDb2x1bW5FbmNyeXB0aW9uU2V0dGluZy5SZXN1bHRTZXRPbmx5OlxuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIGNhc2UgU1FMU2VydmVyU3RhdGVtZW50Q29sdW1uRW5jcnlwdGlvblNldHRpbmcuRW5hYmxlZDpcbiAgICAgIHJldHVybiB0cnVlO1xuICAgIGRlZmF1bHQ6XG4gICAgICByZXR1cm4gY29sdW1uRW5jcnlwdGlvblNldHRpbmc7XG4gIH1cbn07XG4iXX0=