"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.build = exports.parseMetadata = exports.parse = void 0;
const xlsx_1 = __importStar(require("xlsx"));
const helpers_1 = require("./helpers");
const workbook_1 = require("./workbook");
const parse = (mixed, options = {}) => {
    const { dateNF, header = 1, range, blankrows, defval, raw = true, rawNumbers, ...otherOptions } = options;
    const workBook = (0, helpers_1.isString)(mixed)
        ? xlsx_1.default.readFile(mixed, { dateNF, raw, ...otherOptions })
        : xlsx_1.default.read(mixed, { dateNF, raw, ...otherOptions });
    return Object.keys(workBook.Sheets).map((name) => {
        const sheet = workBook.Sheets[name];
        return {
            name,
            data: xlsx_1.default.utils.sheet_to_json(sheet, {
                dateNF,
                header,
                range: typeof range === 'function' ? range(sheet) : range,
                blankrows,
                defval,
                raw,
                rawNumbers,
            }),
        };
    });
};
exports.parse = parse;
const parseMetadata = (mixed, options = {}) => {
    const workBook = (0, helpers_1.isString)(mixed) ? xlsx_1.default.readFile(mixed, options) : xlsx_1.default.read(mixed, options);
    return Object.keys(workBook.Sheets).map((name) => {
        const sheet = workBook.Sheets[name];
        return { name, data: sheet['!ref'] ? xlsx_1.default.utils.decode_range(sheet['!ref']) : null };
    });
};
exports.parseMetadata = parseMetadata;
const build = (worksheets, { parseOptions = {}, writeOptions = {}, sheetOptions = {}, ...otherOptions } = {}) => {
    const { bookType = 'xlsx', bookSST = false, type = 'buffer', ...otherWriteOptions } = writeOptions;
    const legacyOptions = Object.keys(otherOptions).filter((key) => {
        if (['!cols', '!rows', '!merges', '!protect', '!autofilter'].includes(key)) {
            console.debug(`Deprecated options['${key}'], please use options.sheetOptions['${key}'] instead.`);
            return true;
        }
        console.debug(`Unknown options['${key}'], please use options.parseOptions / options.writeOptions`);
        return false;
    });
    const workBook = worksheets.reduce((soFar, { name, data, options = {} }, index) => {
        const sheetName = name || `Sheet_${index}`;
        const sheetData = xlsx_1.utils.aoa_to_sheet(data, parseOptions);
        soFar.SheetNames.push(sheetName);
        soFar.Sheets[sheetName] = sheetData;
        Object.assign(soFar.Sheets[sheetName], legacyOptions, sheetOptions, options);
        return soFar;
    }, new workbook_1.WorkBook());
    return xlsx_1.default.write(workBook, { bookType, bookSST, type, ...otherWriteOptions });
};
exports.build = build;
exports.default = { parse: exports.parse, parseMetadata: exports.parseMetadata, build: exports.build };
