/// <reference types="node" />
import XLSX, { AOA2SheetOpts, AutoFilterInfo, ColInfo, ParsingOptions, ProtectInfo, Range, RowInfo, Sheet2JSONOpts, WritingOptions } from 'xlsx';
export declare const parse: (mixed: unknown, options?: Sheet2JSONOpts & ParsingOptions) => {
    name: string;
    data: unknown[];
}[];
export declare const parseMetadata: (mixed: unknown, options?: ParsingOptions) => {
    name: string;
    data: XLSX.Range | null;
}[];
export declare type WorkSheetOptions = {
    /** Column Info */
    '!cols'?: ColInfo[];
    /** Row Info */
    '!rows'?: RowInfo[];
    /** Merge Ranges */
    '!merges'?: Range[];
    /** Worksheet Protection info */
    '!protect'?: ProtectInfo;
    /** AutoFilter info */
    '!autofilter'?: AutoFilterInfo;
};
export declare type WorkSheet<T = unknown> = {
    name: string;
    data: T[][];
    options: WorkSheetOptions;
};
export declare type BuildOptions = WorkSheetOptions & {
    parseOptions?: AOA2SheetOpts;
    writeOptions?: WritingOptions;
    sheetOptions?: WorkSheetOptions;
};
export declare const build: (worksheets: WorkSheet[], { parseOptions, writeOptions, sheetOptions, ...otherOptions }?: BuildOptions) => Buffer;
declare const _default: {
    parse: (mixed: unknown, options?: XLSX.Sheet2JSONOpts & XLSX.ParsingOptions) => {
        name: string;
        data: unknown[];
    }[];
    parseMetadata: (mixed: unknown, options?: XLSX.ParsingOptions) => {
        name: string;
        data: XLSX.Range | null;
    }[];
    build: (worksheets: WorkSheet<unknown>[], { parseOptions, writeOptions, sheetOptions, ...otherOptions }?: BuildOptions) => Buffer;
};
export default _default;
