// const _parent = Symbol("parent");
const util = require('../util.js')

export class Component {
  constructor(__tfp, typeName, dataModel, parent) {
    this._tfp = __tfp;
    this.dataModel = dataModel;
    if (!this.dataModel.type) this.dataModel.type = typeName;
    if (!this.dataModel.vid) this.dataModel.vid = escape(this.dataModel.id).replaceAll("%", "");
    this.parent = parent;
    // this[_parent] = parent;
  }
}
// 隐藏元素
export class InvisibleComponent extends Component {
  constructor(__tfp, typeName, dataModel, parent) {
    super(__tfp, typeName, dataModel, parent);
  }
}
// 显示元素
export class VisibleComponent extends Component {
  constructor(__tfp, typeName, dataModel, parent) {
    super(__tfp, typeName, dataModel, parent);
  }

  set style(value) {
    this._tfp._page.setData({
      [this.dataModel.vid + "_style"]: value
    })
  }

  set hiden(value) {
    this._tfp._page.setData({
      [this.dataModel.vid + "_hide"]: value
    })
  }

  hide() {
    this._tfp._page.setData({
      [this.dataModel.vid + "_hidden"]: true
    })
  }

  show() {
    this._tfp._page.setData({
      [this.dataModel.vid + "_hidden"]: false
    })
  }

  css(name, value) {
    let styleDataId = this.dataModel.id+"_style";
    let oldStyle = this._tfp._page.data[styleDataId];
    if(!value) {
      if(!oldStyle) return "";
      let arr = oldStyle.split(";");
      for(let i=0;i<arr.length;i++) {
        if(arr[i].trim()=="") continue;
        let style = arr[i].split(":");
        if(style.length<0) continue;
        //如果找到，就返回对应值
        if(style[0].trim()==name) {
          return style.length>1 ? style[1].trim() : "";
        }
      }
      //如果没有找到就返回空
      return "";
    }
    let newStyle = "";
    if(oldStyle) {
      let arr = oldStyle.split(";");
      for(let i=0;i<arr.length;i++) {
        if(arr[i].trim()=="") continue;
        let style = arr[i].split(":");
        if(style.length<0) continue;
        //如果样式已经存在，要先删除原来的样式值
        if(style[0].trim()!=name) {
          newStyle += arr[i]+";";
        }
      }
    }
    newStyle += name+":"+value+";";
    let styleData = {};
    styleData[this.dataModel.id+"_style"] = newStyle;
    this._tfp._page.setData(styleData);
  }
}

export class ContainerComponent extends VisibleComponent {
  constructor(__tfp, typeName, dataModel, parent) {
    super(__tfp, typeName, dataModel, parent);
  }
}

export class FormInput extends VisibleComponent {
  constructor(__tfp, typeName, dataModel, parent) {
    super(__tfp, typeName, dataModel, parent);
  }

  get isFormInput() { return true }

  //页面->模型->公开
  get value() {
    if (this._tfp._page) {
      this.getValue();
    }

    if (this.dataModel.value || this.dataModel.value == 0) return this.dataModel.value;
    return "";
  }

  //公开->模型->页面
  set value(value) {
    let val = value;
    if (util.isNull(value)) {
      val = "";
    }
    else {
      if (this.dataModel.formula) {
        val = (val + "").trim().replaceAll(",", "");
        if (isNaN(val)) val = "";
      }
      try {
        if (this.dataModel.dataType == "int") {
          val = parseInt(val);
        }
        else if (this.dataModel.dataType == "float") {
          val = parseFloat(val);
        }
        else if (this.dataModel.dataType == "money") {
          val = this._tfp.formatMoney(val, 2);
        }
      }
      catch (err) {
        return;
      }
    }
    this.dataModel.value = val;

    if (this._tfp._page) {
      this.setValue();
    }
  }


  //页面->模型
  getValue() {
    // this.dataModel.value = this._tfp._page.data[this.dataModel.vid];
    this.dataModel.value = this.getData();
  }

  //模型->页面
  setValue() {
    // this._tfp._page.setData({
    //   [this.dataModel.vid]: this.dataModel.value
    // })
    this.setData(this.dataModel.value);
  }

  //页面->公开
  getData() {
    return this._tfp._page.data[this.dataModel.vid];
  }

  //公开->页面
  setData(value) {
    this._tfp._page.setData({
      [this.dataModel.vid]: value
    });
  }

  getAttrValue(attrId) {
    this[attrId] = this._tfp._page.data[this.dataModel.vid + "_" + attrId];
  }

  setAttrValue(attrId, val) {
    this._tfp._page.setData({
      [this.dataModel.vid + "_" + attrId]: val
    })
  }

  returnValue(sourceVal, targetData) {
    targetData[this.dataModel.vid] = sourceVal;
  }

  returnAttrValue(attrId, sourceVal, targetData) {
    targetData[this.dataModel.vid + "_" + attrId] = sourceVal;
  }

}