const CryptoJS = require('aes');

var _sessionId;
var _loginname;
var _pwd;

var _orgCode;
var _userId;
var _orgKey;
var _isinit = false;

const otherArgsData = function (othercode, keycode) {
  var args = {};
  args.dts = new Date().getTime();
  // args.othercode = othercode;
  args.keycode = keycode;
  var keytmp = [keycode, "mini", args.dts];
  var iv = CryptoJS.MD5(JSON.stringify(keytmp)).toString().substr(0, 16);
  keytmp.push(iv);
  var key = CryptoJS.MD5(JSON.stringify(keytmp)).toString();
  var text = [othercode, "mini", args.dts];

  args.otherdata = CryptoJS.AES.encrypt(JSON.stringify(text), CryptoJS.enc.Utf8.parse(key), {
    iv: CryptoJS.enc.Utf8.parse(iv),
    mode: CryptoJS.mode.CBC
  }).toString();
  return args;
};

const loginArgsData = function (loginname, password) {
  var args = {};
  args.ts = new Date().getTime();
  args.ln = loginname;
  args.pwd = CryptoJS.MD5(password).toString();
  var ivData = [args.ln, args.pwd, 'web', args.ts];
  var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
  ivData.push(iv);
  var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();
  args.data = CryptoJS.AES.encrypt(JSON.stringify(ivData),
    CryptoJS.enc.Utf8.parse(key), {
    iv: CryptoJS.enc.Utf8.parse(iv),
    mode: CryptoJS.mode.CBC
  }).toString();
  ivData = null;
  return args;
};

const loginAuthData = function (obj) {
  wx.setStorageSync('s', obj.sessionId);
  wx.setStorageSync('l', obj.loginname);
  wx.setStorageSync('p', obj.pwd);
  wx.setStorageSync('d', obj.data);
  wx.setStorageSync('t', obj.ts);
};

const loadAuthData = function () {
  _sessionId = wx.getStorageSync("s");
  _loginname = wx.getStorageSync("l");
  _pwd = wx.getStorageSync("p");
  var authData = wx.getStorageSync("d");
  var authTs = wx.getStorageSync("t");

  if (authData) {
    var ivData = [_loginname, _pwd, 'web', parseInt(authTs)];
    var iv = CryptoJS.MD5(JSON.stringify(ivData)).toString().substr(0, 16);
    ivData.push(iv);
    var key = CryptoJS.MD5(JSON.stringify(ivData)).toString();
    var data = CryptoJS.AES.decrypt(authData,
      CryptoJS.enc.Utf8.parse(key), {
      iv: CryptoJS.enc.Utf8.parse(iv),
      mode: CryptoJS.mode.CBC
    }).toString(CryptoJS.enc.Utf8);
    var arr = JSON.parse(data);
    _orgCode = arr[0];
    _userId = arr[1];
    _orgKey = arr[2];
    arr = null;
    data = null;
    ivData = null;
    _isinit = true;
  }
};

const setAuthData = function (service) {
  if (!_orgCode || !_orgKey) {
    return;
  }
  if (!service.args) service.args = {};
  service.args.sessionId = _sessionId;
  service.args._auth_ts = (new Date()).getTime();
  service.args._auth_org = _orgCode;
  var signData = [_orgCode, _orgKey, service.args._auth_ts];
  var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
  signData.push(iv);
  var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
  var loginData = ['userid', _userId, 'web'];
  signData.push(_pwd);
  //暂时不对请求参数进行签名，因为服务器端怎么校验还没想清楚
  //for(p in msg) {
  //signData.push(msg[p]);
  //}
  loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
  signData = null;
  if (service.encArgs) loginData.push(JSON.stringify(service.encArgs));
  service.args._auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
    CryptoJS.enc.Utf8.parse(key), {
    iv: CryptoJS.enc.Utf8.parse(iv),
    mode: CryptoJS.mode.CBC
  }).toString();
};

const getAuthUrl = function (url) {
  if (!_orgCode || !_orgKey) {
    return url;
  }
  var ret = url;
  if (ret.indexOf('?') < 0) ret += "?";
  if (ret.indexOf('sessionId') < 0) ret += "&sessionId=" + _sessionId;
  var ts = (new Date()).getTime();
  ret += "&_auth_ts=" + ts + "&_auth_org=" + _orgCode;
  var signData = [_orgCode, _orgKey, ts];
  var iv = CryptoJS.MD5(JSON.stringify(signData)).toString().substr(0, 16);
  signData.push(iv);
  var key = CryptoJS.MD5(JSON.stringify(signData)).toString();
  var loginData = ['userid', _userId, 'web'];
  signData.push(_pwd);
  //暂时不对请求参数进行签名，因为服务器端怎么校验还没想清楚
  //for(p in msg) {
  //signData.push(msg[p]);
  //}
  loginData.push(CryptoJS.MD5(JSON.stringify(signData)).toString());
  signData = null;
  var auth_data = CryptoJS.AES.encrypt(JSON.stringify(loginData),
    CryptoJS.enc.Utf8.parse(key), {
    iv: CryptoJS.enc.Utf8.parse(iv),
    mode: CryptoJS.mode.CBC
  }).toString();
  ret += "&_auth_data=" + encodeURIComponent(auth_data);
  return ret;
};

const getWSLoginData = function () {
  var loginMsg = {
    service: 'login',
    orgCode: _orgCode,
    ts: (new Date()).getTime()
  };
  var ivData = _orgCode + "," + _orgKey + "," + loginMsg.ts;
  var iv = CryptoJS.MD5(ivData).toString().substr(0, 16);
  var key = CryptoJS.MD5(ivData + "," + iv).toString();
  ivData = null;
  loginMsg.data = CryptoJS.AES.encrypt(_userId + ",websocket," + _sessionId,
    CryptoJS.enc.Utf8.parse(key), {
    iv: CryptoJS.enc.Utf8.parse(iv),
    mode: CryptoJS.mode.CBC
  }).toString();
  return loginMsg;
};

const encryptString = function (data) {
  var key = CryptoJS.enc.Utf8.parse(_orgCode + "," + _orgKey);
  var iv = CryptoJS.enc.Utf8.parse(CryptoJS.MD5(_orgCode + "," + _orgKey).toString().substr(0, 16));
  var encrypted = CryptoJS.AES.encrypt(data, key, {
    iv: iv,
    mode: CryptoJS.mode.CBC,
    padding: CryptoJS.pad.Pkcs7
  });
  return encrypted.toString();
};

const decryptString = function (data) {
  var key = CryptoJS.enc.Utf8.parse(_orgCode + "," + _orgKey);
  var iv = CryptoJS.enc.Utf8.parse(CryptoJS.MD5(_orgCode + "," + _orgKey).toString().substr(0, 16));
  var decrypted = CryptoJS.AES.decrypt(data, key, {
    iv: iv,
    mode: CryptoJS.mode.CBC,
    padding: CryptoJS.pad.Pkcs7
  });
  return decrypted.toString(CryptoJS.enc.Utf8);
};

module.exports = {
  otherArgsData,
  loginArgsData,
  loginAuthData,
  loadAuthData,
  setAuthData,
  getAuthUrl,
  getWSLoginData,
  encryptString,
  decryptString
}