#!/bin/sh

if [ $# != 2 ] ; then
echo "USAGE: $0 mysql用户名 mysql密码"   
echo " e.g.: $0 root xigeweiwubaqi" 
exit 1;
fi

echo 开始初始化任擎+++++
echo
cd /home/taskmsg/tasgine
chmod +x tasgine

#配置防火墙
echo 正在配置防火墙+++++
firewall-cmd --zone=public --add-port=8001/tcp --permanent
firewall-cmd --reload
echo 配置防火墙完成-----
echo

#注册自启动服务
echo 正在安装任擎服务+++++
/bin/cp -rf /home/taskmsg/tasgine/tasgineServer /etc/init.d
chmod +x /etc/init.d/tasgineServer
chkconfig --add tasgineServer
chkconfig tasgineServer on
echo 任擎服务安装完成-----
echo

#初始化数据库
echo 正在初始化数据库+++++
mysql -u$1 -p$2 <<EOF
create database tasgine;
use tasgine;
source db/tasgine_mysql.sql;
exit
EOF
echo 数据库初始化完成-----
echo

#初始化配置文件
echo 正在初始化配置文件+++++
sed -i "s/\"user\": \"root\"/\"user\": \"$1\"/g" /home/taskmsg/tasgine/config/Tasgine.json
sed -i "s/\"password\": \"123456\"/\"password\": \"$2\"/g" /home/taskmsg/tasgine/config/Tasgine.json
echo 配置文件初始化完成-----
echo

#启动服务
service tasgineServer start

echo 任擎初始化完成-----
