DROP TABLE IF EXISTS `sys_app`;

CREATE TABLE `sys_app` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `name` varchar(200) NOT NULL,
  `description` varchar(2000) DEFAULT NULL,
  `version` varchar(20) NOT NULL,
  `developer_id` int(11) DEFAULT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `status` smallint(6) DEFAULT NULL,
  `deploy` varchar(10) DEFAULT NULL,
  `terminal` varchar(45) DEFAULT NULL,
  `url_phone` varchar(500) DEFAULT NULL,
  `url_pad` varchar(500) DEFAULT NULL,
  `url_web` varchar(500) DEFAULT NULL,
  `icon_path` varchar(500) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `lastupdate` datetime DEFAULT NULL,
  `mark` int(11) DEFAULT NULL,
  `install_count` int(11) DEFAULT NULL,
  `market_status` int(11) DEFAULT NULL,
  `order_no` int(11) DEFAULT NULL,
  `url_phone_detail` varchar(500) DEFAULT NULL,
  `url_pad_detail` varchar(500) DEFAULT NULL,
  `url_web_detail` varchar(500) DEFAULT NULL,
  `icon_code` varchar(45) DEFAULT NULL,
  `titlebar_color` varchar(10) DEFAULT NULL,
  `init_service` varchar(100) DEFAULT NULL,
  `default` smallint(6) DEFAULT NULL,
  `free` smallint(6) DEFAULT NULL,
  `msg_group` smallint(6) DEFAULT NULL,
  `get_badge_service` varchar(300) DEFAULT NULL,
  `pc_open_type` smallint(6) DEFAULT NULL,
  `pc_show_on_sysbar` smallint(6) DEFAULT NULL,
  `url_pc` varchar(500) DEFAULT NULL,
  `url_pc_detail` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `sys_app` VALUES (1,'sys/org','组织结构',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/user/index.tfp',
'{"icon":"iconfont icon-org","color":"#ffffff","bg":"#0288d1"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/user/index.tfp',NULL),
(2,'sys/role','系统群组',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/role/index.tfp',
'{"icon":"iconfont icon-role","color":"#ffffff","bg":"#ff8f00"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/role/index.tfp',NULL),
(3,'sys/appManage','应用管理',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/app/index.tfp',
'{"icon":"iconfont icon-project","color":"#ffffff","bg":"#0288d1"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/app/index.tfp',NULL),
(4,'sys/scheduleTask','计划任务','','1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/scheduled_task/index.tfp',
'{"icon":"iconfont icon-plan","color":"#ffffff","bg":"#fbc02d"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/scheduled_task/index.tfp',NULL),
(5,'sys/bgService','后台服务',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/bg_service/index.tfp',
'{"icon":"iconfont icon-default","color":"#ffffff","bg":"#0277bd"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/bg_service/index.tfp',NULL),
(6,'sys/attach','附件管理','','1.0.000',1,1,0,'url','web','','','/app/sys/app_attach/index.tfp',
'{"type":"iconfont","class":"iconfont icon-file","color":"#ffffff","bgColor":"#9c27b0"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/app_attach/index.tfp',NULL),
(7,'sys/datadic','数据字典','','1.0.000',1,1,0,'url','web','','','/app/sys/data_dic/index.tfp',
'{"type":"iconfont","class":"iconfont icon-regulations","color":"#ffffff","bgColor":"#7b1fa2"}','2023-03-31 22:16:31','2023-03-31 22:16:31',
NULL,NULL,NULL,98,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/data_dic/index.tfp',NULL),
(8,'sys/encodingrule','编码规则','','1.0.000',1,1,0,'url','web','','','/app/sys/encoding_rule/index.tfp',
'{"type":"iconfont","class":"iconfont icon-journal","color":"#ffffff","bgColor":"#c41411"}','2023-03-31 22:16:31','2023-03-31 22:16:31',
NULL,NULL,NULL,98,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/encoding_rule/index.tfp',NULL),
(18,'sys/log','系统日志','','1.0.000',1,1,0,'url','web','','','/app/sys/log/index.tfp',
'{"icon":"iconfont icon-news","color":"#ffffff","bg":"#42bd41"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,98,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/log/index.tfp',NULL),
(19,'sys/setting','系统设置',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/settings/index.tfp',
'{"icon":"iconfont icon-systemset","color":"#ffffff","bg":"#d01716"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,99,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/sysinfo/index.tfp',NULL),
(20,'sys/info','系统信息',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/sysinfo/index.tfp',
'{"icon":"iconfont icon-journal","color":"#ffffff","bg":"#6a1b9a"}','2022-02-12 15:16:31','2022-02-12 15:16:31',
NULL,NULL,NULL,100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/sysinfo/index.tfp',NULL);

DROP TABLE IF EXISTS `sys_app_attach_type`;

CREATE TABLE `sys_app_attach_type`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用代码',
  `app_name` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '应用名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `creater_id` int(11) NULL DEFAULT NULL COMMENT '创建人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4;

DROP TABLE IF EXISTS `sys_app_attach`;

CREATE TABLE `sys_app_attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `name` varchar(200) NOT NULL,
  `size` int(11) NOT NULL,
  `type` varchar(20) DEFAULT NULL,
  `app_code` varchar(20) NOT NULL,
  `app_data_id` int(11) DEFAULT NULL,
  `uploader_id` int(11) NOT NULL,
  `upload_time` datetime NOT NULL,
  `save_path` varchar(500) NOT NULL,
  `org_id` int(11) NOT NULL,
  `uploader_name` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_app_auth`;

CREATE TABLE `sys_app_auth` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `app_id` int(11) DEFAULT NULL,
  `owner_type` varchar(10) DEFAULT NULL,
  `owner_id` int(11) DEFAULT NULL,
  `opration_id` int(11) DEFAULT NULL,
  `terminal` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `sys_app_auth` VALUES (1,1,1,'role',1,NULL,'web'),(2,1,2,'role',1,NULL,'web'),(3,1,3,'role',1,NULL,'web'),
(4,1,4,'role',1,NULL,'web'),(5,1,5,'role',1,NULL,'web'),(6,1,6,'role',1,NULL,'web'),(7,1,7,'role',1,NULL,'web'),
(8,1,8,'role',1,NULL,'web'),(18,1,18,'role',1,NULL,'web'),(19,1,19,'role',1,NULL,'web'),(20,1,20,'role',1,NULL,'web');

DROP TABLE IF EXISTS `sys_app_category`;

CREATE TABLE `sys_app_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `icon_code` varchar(200) DEFAULT NULL,
  `group_apps` smallint(4) DEFAULT NULL,
  `order_no` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `sys_app_category` VALUES (1,'系统维护',0,NULL,NULL,NULL);

DROP TABLE IF EXISTS `sys_app_opration`;

CREATE TABLE `sys_app_opration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `service_path` varchar(200) NOT NULL,
  `terminal` varchar(10) DEFAULT NULL COMMENT 'all,pc,mobile',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '添加部门信息', '/app/sys/service/dep/add', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '修改部门信息', '/app/sys/service/dep/update', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '删除部门信息', '/app/sys/service/dep/delete', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '添加用户信息', '/app/sys/service/user/add', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '修改用户信息', '/app/sys/service/user/update', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '删除用户信息', '/app/sys/service/user/delete', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '禁用用户信息', '/app/sys/service/user/disable', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '启用用户信息', '/app/sys/service/user/enable', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '恢复用户密码', '/app/sys/service/user/recoveryPwd', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '导出用户信息', '/app/sys/service/user/exportGetList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '查看用户信息', '/app/sys/service/user/preUpdate', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '设置用户头像', '/app/sys/service/user/setHeadManage', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '查看操作权限', '/app/sys/service/user/getDataPageOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '添加操作权限', '/app/sys/service/app/addOprationAuth', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '删除操作权限', '/app/sys/service/app/deleteOprationAuth', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '查看管辖部门', '/app/sys/service/user/getSubDepList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '添加管辖部门', '/app/sys/service/user/addSubDep', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '删除管辖部门', '/app/sys/service/user/deleteSubDep', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '查看任职部门', '/app/sys/service/user/getDepList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '添加任职部门', '/app/sys/service/user/addDep', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (1, '删除任职部门', '/app/sys/service/user/deleteDep', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '添加群组信息', '/app/sys/service/role/add', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '修改群组信息', '/app/sys/service/role/update', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '删除群组信息', '/app/sys/service/role/delete', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '添加用户信息', '/app/sys/service/role/addUser', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '删除用户信息', '/app/sys/service/role/deleteUser', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '查看操作权限', '/app/sys/service/role/getDataPageOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '添加操作权限', '/app/sys/service/app/addOprationAuth', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '删除操作权限', '/app/sys/service/app/deleteOprationAuth', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (2, '设置管理员', '/app/sys/service/role/setAdmin', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '添加应用分类', '/app/sys/service/app/addCategory', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '修改应用分类', '/app/sys/service/app/updateCategory', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '删除应用分类', '/app/sys/service/app/deleteCategory', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '查询应用列表', '/app/sys/service/app/getList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '添加应用信息', '/app/sys/service/app/add', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '修改应用信息', '/app/sys/service/app/update', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '删除应用信息', '/app/sys/service/app/delete', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '禁用应用信息', '/app/sys/service/app/disable', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '启用应用信息', '/app/sys/service/app/enable', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '查询访问权限列表', '/app/sys/service/app/getAuthList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '删除访问权限信息', '/app/sys/service/app/deleteAuth', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '查询操作权限', '/app/sys/service/app/getOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '添加操作权限', '/app/sys/service/app/addOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '修改操作权限', '/app/sys/service/app/updateOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '删除操作权限', '/app/sys/service/app/deleteOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '添加权限信息', '/app/sys/service/app/addAuth', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '查询应用信息', '/app/sys/service/app/get', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '查询应用分类', '/app/sys/service/app/getCategory', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (3, '查看操作列表', '/app/sys/service/app/getDataPageOpration', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '查询任务列表', '/app/sys/service/scheduled_task/getList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '添加任务信息', '/app/sys/service/scheduled_task/add', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '修改任务信息', '/app/sys/service/scheduled_task/update', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '删除任务信息', '/app/sys/service/scheduled_task/delete', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '禁用任务信息', '/app/sys/service/scheduled_task/disable', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '启用任务信息', '/app/sys/service/scheduled_task/enable', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (4, '查询任务信息', '/app/sys/service/scheduled_task/get', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '查询服务列表', '/app/sys/service/bg_service/getList', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '添加服务信息', '/app/sys/service/bg_service/add', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '修改服务信息', '/app/sys/service/bg_service/update', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '删除服务信息', '/app/sys/service/bg_service/delete', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '停止服务信息', '/app/sys/service/bg_service/stop', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '启用服务信息', '/app/sys/service/bg_service/start', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (5, '查询服务信息', '/app/sys/service/bg_service/get', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询文件下载列表', '/app/sys/service/log/getListDownload', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询错误日志列表', '/app/sys/service/log/getListError', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询登录日志列表', '/app/sys/service/log/getListLogin', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询请求日志列表', '/app/sys/service/log/getListRequest', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询动态请求列表', '/app/sys/service/log/getListService', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询文件上传列表', '/app/sys/service/log/getListUpload', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询静态请求列表', '/app/sys/service/log/getListStatic', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询数据库操作列表', '/app/sys/service/log/getListSql', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询错误详细信息', '/app/sys/service/log/getDetailError', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询动态服务请求信息', '/app/sys/service/log/getDetailService', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (18, '查询数据库操作信息', '/app/sys/service/log/getDetailSql', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '查询系统激活信息', '/app/sys/service/org/get', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '生成SI文件', '/app/sys/service/org/createSI', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '查询附件信息', '/app/sys/service/setting/getAttachInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '修改附件信息', '/app/sys/service/setting/setAttachInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '查询基本参数信息', '/app/sys/service/setting/getBaseInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '修改基本参数信息', '/app/sys/service/setting/setBaseInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '查询日志信息', '/app/sys/service/setting/getLogInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '修改日志信息', '/app/sys/service/setting/setLogInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '查询数据库信息', '/app/sys/service/setting/getDBInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '修改数据库信息', '/app/sys/service/setting/setDBInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '查询Web服务器信息', '/app/sys/service/setting/getWebServerInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (19, '修改Web服务器信息', '/app/sys/service/setting/setWebServerInfo', 'all');
INSERT INTO `sys_app_opration` (`app_id`, `name`, `service_path`, `terminal`) VALUES (20, '查询系统信息', '/app/sys/service/setting/getSysInfo', 'all');

DROP TABLE IF EXISTS `sys_app_update`;

CREATE TABLE `sys_app_update` (
  `app_id` int(11) NOT NULL,
  `description` varchar(5000) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `version` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_dep`;

CREATE TABLE `sys_dep` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL,
  `fullname` varchar(200) DEFAULT NULL,
  `org_id` int(11) NOT NULL,
  `status` smallint(4) NOT NULL,
  `description` varchar(500) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `creater_id` int(11) NOT NULL,
  `createtime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `sys_dep` VALUES (1,'1001','默认部门','默认部门',1,0,'',0,1,'2022-02-12 18:59:26');

DROP TABLE IF EXISTS `sys_dep_user`;

CREATE TABLE `sys_dep_user` (
  `org_id` int(11) NOT NULL,
  `dep_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  PRIMARY KEY (`org_id`,`dep_id`,`user_id`),
  KEY `index_sys_dep_user_dep_id` (`dep_id`),
  KEY `index_sys_dep_user_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `sys_dep_user` VALUES (1,1,1,1,'2022-02-12 13:22:16');

DROP TABLE IF EXISTS `sys_log_download`;
CREATE TABLE `sys_log_download` (
  `id` INT NOT NULL AUTO_INCREMENT COMMENT '编号',
  `req_id` VARCHAR(20) COMMENT '请求编号 req_id~',
  `req_time` DATETIME COMMENT '请求时间 req_time',
  `session_id` VARCHAR(50) COMMENT '会话编号',
  `org_id` INT COMMENT '组织编号!',
  `org_code` VARCHAR(50) COMMENT '组织代码!',
  `user_id` INT COMMENT '用户编号!',
  `login_name` VARCHAR(200) COMMENT '登录名称!',
  `terminal` VARCHAR(20) COMMENT '请求终端',
  `app_code` VARCHAR(50) COMMENT '应用代码',
  `app_data_id` INT COMMENT '数据编号',
  `file_id` INT COMMENT '文件编号',
  `file_code` VARCHAR(50) COMMENT '文件代码',
  `file_name` VARCHAR(200) COMMENT '文件名称',
  `file_size` INT COMMENT '文件大小',
  `file_path` VARCHAR(500) COMMENT '文件地址',
  `thumbnail` SMALLINT COMMENT '是否压缩',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（下载）';

DROP TABLE IF EXISTS `sys_log_error`;
CREATE TABLE `sys_log_error` (
  `id` INT NOT NULL AUTO_INCREMENT COMMENT '编号',
  `req_id` VARCHAR(20) COMMENT '请求编号 req_id',
  `req_time` DATETIME COMMENT '请求时间 req_time~',
  `session_id` VARCHAR(50) COMMENT '会话编号',
  `org_id` INT COMMENT '组织编号!',
  `org_code` VARCHAR(50) COMMENT '组织代码!',
  `user_id` INT COMMENT '用户编号!',
  `login_name` VARCHAR(200) COMMENT '登录名称!',
  `type` VARCHAR(20) COMMENT '类型',
  `message` VARCHAR(500) COMMENT '错误',
  `stack` TEXT COMMENT '堆栈',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（错误）';

DROP TABLE IF EXISTS `sys_log_request`;
CREATE TABLE `sys_log_request` (
  `id` VARCHAR(20) NOT NULL COMMENT '请求编号 req_id',
  `ip` VARCHAR(50) COMMENT '客户ip',
  `port` INT COMMENT '客户port',
  `req_time` DATETIME COMMENT '请求时间',
  `req_ms` SMALLINT COMMENT '请求毫秒',
  `type` VARCHAR(20) COMMENT '请求类型',
  `path` VARCHAR(500) COMMENT '请求地址 url',
  `host` VARCHAR(50) COMMENT '请求主机 host',
  `protocol` VARCHAR(10) COMMENT '请求协议 protocol',
  `method` VARCHAR(10) COMMENT '请求方法',
  `user_agent` VARCHAR(500) COMMENT '客户信息!',
  `response_code` INT COMMENT '响应代码',
  `response_message` VARCHAR(500) COMMENT '响应消息',
  `res_time` DATETIME COMMENT '响应时间',
  `res_ms` SMALLINT COMMENT '响应毫秒',
  `use_time` INT COMMENT '运行时间',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（访问）';

DROP TABLE IF EXISTS `sys_log_service`;
CREATE TABLE `sys_log_service` (
  `id` VARCHAR(20) NOT NULL COMMENT '请求编号 req_id',
  `session_id` VARCHAR(50) COMMENT '会话编号',
  `org_id` INT COMMENT '组织编号!',
  `org_code` VARCHAR(50) COMMENT '组织代码!',
  `user_id` INT COMMENT '用户编号!',
  `login_name` VARCHAR(200) COMMENT '登录名称!',
  `app_code` VARCHAR(50) COMMENT '应用代码',
  `terminal` VARCHAR(20) COMMENT '请求终端',
  `path` VARCHAR(500) COMMENT '服务地址',
  `header_data` TEXT COMMENT '包头数据',
  `req_data` TEXT COMMENT '请求数据',
  `res_data` TEXT COMMENT '响应数据',
  `res_code` SMALLINT COMMENT '响应代码',
  `err_msg` VARCHAR(500) COMMENT '错误信息',
  `start_time` DATETIME COMMENT '开始时间',
  `start_ms` SMALLINT COMMENT '开始毫秒',
  `end_time` DATETIME COMMENT '结束时间',
  `end_ms` SMALLINT COMMENT '结束毫秒',
  `use_time` INT COMMENT '运行时间',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（服务）';

DROP TABLE IF EXISTS `sys_log_sql`;
CREATE TABLE `sys_log_sql` (
  `id` INT NOT NULL AUTO_INCREMENT COMMENT '编号',
  `req_id` VARCHAR(20) COMMENT '请求编号',
  `session_id` VARCHAR(50) COMMENT '会话编号',
  `org_id` INT COMMENT '组织编号!',
  `org_code` VARCHAR(50) COMMENT '组织代码!',
  `user_id` INT COMMENT '用户编号!',
  `login_name` VARCHAR(200) COMMENT '登录名称!',
  `sql_text` TEXT COMMENT '语句~',
  `params` TEXT COMMENT '参数',
  `err_code` SMALLINT COMMENT '返回代码',
  `err_msg` TEXT COMMENT '错误信息',
  `start_time` DATETIME COMMENT '开始时间',
  `start_ms` SMALLINT COMMENT '开始毫秒',
  `end_time` DATETIME COMMENT '结束时间',
  `end_ms` SMALLINT COMMENT '结束毫秒',
  `use_time` INT COMMENT '运行时间',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（语句）';

DROP TABLE IF EXISTS `sys_log_static`;
CREATE TABLE `sys_log_static` (
  `id` VARCHAR(20) NOT NULL COMMENT '请求编号 req_id',
  `req_time` DATETIME COMMENT '请求时间 req_time',
  `real_url` VARCHAR(500) COMMENT '实际路径',
  `content_type` VARCHAR(50) COMMENT '内容类型',
  `content_size` INT COMMENT '内容大小',
  `range_start` INT COMMENT '范围开始',
  `range_end` INT COMMENT '范围结束',
  `compress_type` VARCHAR(50) COMMENT '压缩类型',
  `last_modified` DATETIME COMMENT '最后修改',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（静态）';

DROP TABLE IF EXISTS `sys_log_upload`;
CREATE TABLE `sys_log_upload` (
  `id` INT NOT NULL AUTO_INCREMENT COMMENT '编号',
  `req_id` VARCHAR(20) COMMENT '请求编号 req_id~',
  `req_time` DATETIME COMMENT '请求时间 req_time',
  `session_id` VARCHAR(50) COMMENT '会话编号',
  `org_id` INT COMMENT '组织编号!',
  `org_code` VARCHAR(50) COMMENT '组织代码!',
  `user_id` INT COMMENT '用户编号!',
  `login_name` VARCHAR(200) COMMENT '登录名称!',
  `terminal` VARCHAR(20) COMMENT '请求终端',
  `app_code` VARCHAR(50) COMMENT '应用代码',
  `app_data_id` INT COMMENT '数据编号',
  `file_code` VARCHAR(50) COMMENT '文件代码',
  `file_name` VARCHAR(200) COMMENT '文件名称',
  `file_size` INT COMMENT '文件大小',
  PRIMARY KEY(`id`)
) ENGINE=INNODB CHARSET=UTF8MB4 COMMENT='日志（上传）';

DROP TABLE IF EXISTS `sys_msg`;

CREATE TABLE `sys_msg` (
  `id` int(11) NOT NULL,
  `org_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL,
  `sender_id` int(11) NOT NULL,
  `sender_ctype` varchar(20) DEFAULT NULL,
  `send_time` datetime NOT NULL,
  `title` varchar(200) DEFAULT NULL,
  `summary` varchar(500) DEFAULT NULL,
  `icon` varchar(200) DEFAULT NULL,
  `sound` varchar(200) DEFAULT NULL,
  `open_type` smallint(6) DEFAULT NULL,
  `open_content` varchar(200) DEFAULT NULL,
  `group_display` smallint(6) DEFAULT NULL,
  `receiver_ctype` varchar(20) DEFAULT NULL,
  `to_self` smallint(6) DEFAULT NULL,
  `to_all` smallint(6) DEFAULT NULL,
  `retain_days` int(11) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_msg_receive`;

CREATE TABLE `sys_msg_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `msg_id` int(11) DEFAULT NULL COMMENT '消息编号~',
  `receiver_id` int(11) DEFAULT NULL COMMENT '接收人编号',
  `receiver_name` varchar(50) DEFAULT NULL,
  `receive_status_phone` smallint(6) DEFAULT NULL COMMENT '接收状态手机端',
  `receive_status_pad` smallint(6) DEFAULT NULL,
  `receive_status_pc` smallint(6) DEFAULT NULL COMMENT '接收状态电脑端',
  `receive_status_web` smallint(6) DEFAULT NULL COMMENT '接收状态网页端',
  `receive_time_phone` datetime DEFAULT NULL COMMENT '接收时间手机端',
  `receive_time_pad` datetime DEFAULT NULL,
  `receive_time_pc` datetime DEFAULT NULL COMMENT '接收时间电脑端',
  `receive_time_web` datetime DEFAULT NULL COMMENT '接收时间网页端',
  `read_time` datetime DEFAULT NULL COMMENT '阅读时间',
  `read_client_type` varchar(50) DEFAULT NULL COMMENT '阅读客户端类型',
  `delete_status` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='消息发送';

DROP TABLE IF EXISTS `sys_org`;

CREATE TABLE `sys_org` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `code` varchar(16) NOT NULL DEFAULT '' COMMENT '代码',
  `name` varchar(200) NOT NULL COMMENT '名称',
  `description` varchar(500) DEFAULT NULL COMMENT '描述',
  `status` tinyint(4) NOT NULL COMMENT '已禁用',
  `user_count` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `default_pwd` varchar(100) DEFAULT NULL,
  `look_all` smallint(1) DEFAULT NULL,
  `look_self_bureau` smallint(1) DEFAULT NULL,
  `look_self_dep` smallint(1) DEFAULT NULL,
  `look_leader` smallint(1) DEFAULT NULL,
  `look_under` smallint(1) DEFAULT NULL,
  `create_group` smallint(1) DEFAULT NULL,
  `disable_chat` smallint(1) DEFAULT NULL,
  `only_app_center` smallint(1) DEFAULT NULL,
  `logo_image` varchar(200) DEFAULT NULL,
  `launch_image` varchar(200) DEFAULT NULL,
  `custom_install_package` smallint(1) DEFAULT NULL,
  `allow_add_friend` smallint(1) DEFAULT NULL,
  `show_nickname_in_user_list` smallint(1) DEFAULT NULL,
  `show_post_in_user_list` smallint(1) DEFAULT NULL,
  `show_motto_in_user_list` smallint(1) DEFAULT NULL,
  `show_type_in_role_list` smallint(1) DEFAULT NULL,
  `show_description_in_role_list` smallint(1) DEFAULT NULL,
  `client_view_title_bgcolor` varchar(45) DEFAULT NULL,
  `client_button_bgcolor` varchar(45) DEFAULT NULL,
  `disable_work_circle` smallint(1) DEFAULT NULL,
  `app_center_url` varchar(200) DEFAULT NULL,
  `app_center_title` varchar(45) DEFAULT NULL,
  `work_circle_title` varchar(45) DEFAULT NULL,
  `disable_address_book` smallint(1) DEFAULT NULL,
  `allow_regist` smallint(1) DEFAULT NULL,
  `agent_id` int(11) DEFAULT NULL,
  `msg_center_title` varchar(20) DEFAULT NULL,
  `show_netstatus_in_user_list` smallint(1) DEFAULT NULL,
  `user_cell_left_info` varchar(45) DEFAULT NULL,
  `user_cell_right_info` varchar(45) DEFAULT NULL,
  `user_cell_bottom_info` varchar(45) DEFAULT NULL,
  `regist_url` varchar(200) DEFAULT NULL,
  `disable_appmarket` smallint(6) DEFAULT NULL,
  `show_app_center_banner` smallint(1) DEFAULT NULL,
  `app_center_banner_height` int(11) DEFAULT NULL,
  `bind_client_device` smallint(1) DEFAULT NULL,
  `disable_chpwd` int(11) DEFAULT NULL,
  `disable_taskmsg` int(11) DEFAULT NULL,
  `disable_msg_center` int(11) DEFAULT NULL,
  `appcenter_netdisk` int(11) DEFAULT NULL,
  `bottom_mail` int(11) DEFAULT NULL,
  `disable_app_center` int(11) DEFAULT NULL,
  `disable_set_ad` int(11) DEFAULT NULL,
  `disable_set_logo` int(11) DEFAULT NULL,
  `disable_set_slogan` int(11) DEFAULT NULL,
  `disable_set_launch_image` int(11) DEFAULT NULL,
  `remark` varchar(500) DEFAULT NULL,
  `apns_channel` int(11) DEFAULT NULL,
  `server_device_code` varchar(64) DEFAULT NULL,
  `mps_addr` varchar(100) DEFAULT NULL,
  `mps_port` int(11) DEFAULT NULL,
  `web_addr` varchar(100) DEFAULT NULL,
  `web_port` int(11) DEFAULT NULL,
  `tcpfile_addr` varchar(100) DEFAULT NULL,
  `tcpfile_port` int(11) DEFAULT NULL,
  `httpfile_addr` varchar(100) DEFAULT NULL,
  `httpfile_port` int(11) DEFAULT NULL,
  `ddns_type` varchar(10) DEFAULT NULL,
  `disk_limit` int(11) DEFAULT NULL,
  `disk_limit_unit` varchar(2) DEFAULT NULL,
  `file_size_limit` int(11) DEFAULT NULL,
  `auth_end_date` datetime DEFAULT NULL,
  `online_play_addr` varchar(200) DEFAULT NULL,
  `watermark_path` varchar(200) DEFAULT NULL,
  `ignore_pc_online` smallint(6) DEFAULT NULL,
  `hide_about` smallint(6) DEFAULT NULL,
  `auth_key` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `sys_org` VALUES (1,'taskmsg','任讯信息','',0,20,'2022-02-12 18:18:31',1,'2022-02-12 23:05:58','f9429ab0b5f04baf1e9dd1cef50cbd8f',1,1,0,1,0,1,0,0,NULL,NULL,0,0,0,0,0,1,0,NULL,NULL,0,'','','',0,0,NULL,NULL,0,'loginname','tel_work','email',NULL,NULL,1,400,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f84707a40cf74ec18b3eefb76f16d58a');

DROP TABLE IF EXISTS `sys_org_app`;

CREATE TABLE `sys_org_app` (
  `org_id` int(11) NOT NULL,
  `app_id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `installer_id` int(11) NOT NULL,
  `install_time` datetime NOT NULL,
  `order_no` int(11) DEFAULT NULL,
  `titlebar_color` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`org_id`,`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO `sys_org_app` VALUES (1,1,0,1,1,'2022-02-12 15:16:31',1,NULL),(1,2,0,1,1,'2022-02-12 15:16:31',2,NULL),
(1,3,0,1,1,'2022-02-12 15:16:31',3,NULL),(1,4,0,1,1,'2022-02-12 15:16:31',4,NULL),(1,5,0,1,1,'2022-02-12 15:16:31',5,NULL),
(1,6,0,1,1,'2022-02-12 15:16:31',6,NULL),(1,7,0,1,1,'2022-02-12 17:04:04',7,NULL),(1,8,0,1,1,'2022-02-12 17:04:41',8,NULL),
(1,18,0,1,1,'2022-02-12 17:07:04',18,NULL),(1,19,0,1,1,'2022-02-12 17:38:36',19,NULL),(1,20,0,1,1,'2022-02-12 17:38:36',20,NULL);

DROP TABLE IF EXISTS `sys_org_app_category`;

CREATE TABLE `sys_org_app_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) DEFAULT NULL,
  `name` varchar(45) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `org_id` int(11) NOT NULL,
  `group_apps` smallint(4) DEFAULT NULL,
  `icon_code` varchar(200) DEFAULT NULL,
  `order_no` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `sys_org_app_category` VALUES (1,'sys','系统维护',0,1,NULL,NULL,9999);

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `org_id` int(11) NOT NULL,
  `code` varchar(4) NOT NULL,
  `description` varchar(500) DEFAULT NULL,
  `creater_id` int(11) NOT NULL,
  `createtime` datetime NOT NULL,
  `status` tinyint(4) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `allow_apply_join` smallint(1) DEFAULT NULL,
  `head_id` int(11) DEFAULT NULL,
  `only_app_center` smallint(1) DEFAULT NULL,
  `disable_address_book` smallint(1) DEFAULT NULL,
  `disable_work_circle` smallint(1) DEFAULT NULL,
  `disable_app_center` smallint(6) DEFAULT NULL,
  `disable_taskmsg` smallint(6) DEFAULT NULL,
  `disk_limit` smallint(6) DEFAULT NULL,
  `disk_limit_unit` varchar(45) DEFAULT NULL,
  `file_size_limit` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `sys_role` VALUES (1,'系统管理员',1,'1',NULL,1,'2022-02-12 16:41:49',0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'所有人',1,'9999',NULL,1,'2022-02-12 16:41:49',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

DROP TABLE IF EXISTS `sys_role_type`;

CREATE TABLE `sys_role_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_role_user`;

CREATE TABLE `sys_role_user` (
  `org_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `is_admin` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`org_id`,`role_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `sys_role_user` VALUES (1,1,1,1,'2022-02-12 16:09:26',1);

DROP TABLE IF EXISTS `sys_scheduled_task`;

CREATE TABLE `sys_scheduled_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` smallint(6) DEFAULT NULL,
  `exe_time` varchar(45) DEFAULT NULL,
  `period_type` varchar(45) DEFAULT NULL,
  `period_range` varchar(100) DEFAULT NULL,
  `service` varchar(200) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `last_exe_time` datetime DEFAULT NULL,
  `next_exe_time` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `server_id` varchar(45) DEFAULT NULL,
  `tag` varchar(200) DEFAULT NULL,
  `sys_task` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `sys_scheduled_task` VALUES (1,1,'清理附件缓存',1,'00:10:00','day',NULL,'/sys/service/app/clearAttachCache',0,1,'2022-02-12 09:00:00',NULL,NULL,'2022-02-12 09:00:00',NULL,'Tasgine',NULL,1);

DROP TABLE IF EXISTS `sys_session`;

CREATE TABLE `sys_session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(45) DEFAULT NULL,
  `org_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `last_address` varchar(45) DEFAULT NULL,
  `last_port` int(11) DEFAULT NULL,
  `server_type` varchar(25) DEFAULT NULL,
  `client_type` varchar(15) DEFAULT NULL,
  `client_version` varchar(10) DEFAULT NULL,
  `client_net_type` varchar(45) DEFAULT NULL,
  `client_os` varchar(45) DEFAULT NULL,
  `client_os_version` varchar(45) DEFAULT NULL,
  `device_manufactor` varchar(45) DEFAULT NULL,
  `device_model` varchar(45) DEFAULT NULL,
  `device_id` varchar(45) DEFAULT NULL,
  `device_token` varchar(200) DEFAULT NULL,
  `operator_name` varchar(45) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2172 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `code` varchar(16) NOT NULL COMMENT '代码',
  `name` varchar(20) NOT NULL COMMENT '姓名',
  `loginname` varchar(20) NOT NULL COMMENT '登录名',
  `password` varchar(50) NOT NULL COMMENT '密码',
  `org_id` int(11) NOT NULL COMMENT '组织编号',
  `status` tinyint(4) NOT NULL COMMENT '状态',
  `mobile` varchar(20) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `motto` varchar(100) DEFAULT NULL,
  `creater_id` int(11) NOT NULL,
  `createtime` datetime NOT NULL,
  `lastLoginTime` datetime DEFAULT NULL,
  `lastLoginIp` varchar(30) DEFAULT NULL,
  `sex` smallint(1) DEFAULT NULL,
  `post` varchar(50) DEFAULT NULL,
  `create_group` smallint(1) DEFAULT NULL,
  `look_all` smallint(1) DEFAULT NULL,
  `look_self_bureau` smallint(1) DEFAULT NULL,
  `look_self_dep` smallint(1) DEFAULT NULL,
  `look_leader` smallint(1) DEFAULT NULL,
  `look_under` smallint(1) DEFAULT NULL,
  `province` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `district` varchar(45) DEFAULT NULL,
  `address` varchar(500) DEFAULT NULL,
  `nickname` varchar(45) DEFAULT NULL,
  `tel_short` varchar(10) DEFAULT NULL,
  `tel_work` varchar(20) DEFAULT NULL,
  `tel_home` varchar(20) DEFAULT NULL,
  `tel_other` varchar(20) DEFAULT NULL,
  `only_app_center` smallint(1) DEFAULT NULL,
  `disable_address_book` smallint(1) DEFAULT NULL,
  `disable_work_circle` smallint(1) DEFAULT NULL,
  `device_manufactor` varchar(20) DEFAULT NULL,
  `device_model` varchar(50) DEFAULT NULL,
  `device_id` varchar(50) DEFAULT NULL,
  `not_bind_device` smallint(1) DEFAULT NULL,
  `client_type` varchar(20) DEFAULT NULL,
  `client_version` varchar(10) DEFAULT NULL,
  `client_os_version` varchar(10) DEFAULT NULL,
  `operator_name` varchar(10) DEFAULT NULL,
  `net_type` varchar(10) DEFAULT NULL,
  `head_id` int(11) DEFAULT NULL,
  `last_update_pwd` datetime DEFAULT NULL,
  `disable_app_center` smallint(6) DEFAULT NULL,
  `disable_taskmsg` smallint(6) DEFAULT NULL,
  `disable_chpwd` int(11) DEFAULT NULL,
  `disk_limit` int(11) DEFAULT NULL,
  `disk_limit_unit` varchar(2) DEFAULT NULL,
  `file_size_limit` int(11) DEFAULT NULL,
  `bind_ca` int(11) DEFAULT NULL,
  `bind_ca_id` varchar(45) DEFAULT NULL,
  `theme_id` varchar(45) DEFAULT NULL,
  `othercode` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='用户信息';

INSERT INTO `sys_user` VALUES (1,'999999','管理员','admin','f9429ab0b5f04baf1e9dd1cef50cbd8f',1,0,'','','tasgine',1,'2022-02-12 19:01:54','2022-02-12 14:09:24',NULL,0,NULL,1,1,1,1,1,1,NULL,NULL,NULL,NULL,'123123','2','3','4','5',NULL,NULL,NULL,NULL,NULL,NULL,0,'','',NULL,NULL,'3g',27,'2022-02-12 12:03:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL);

DROP TABLE IF EXISTS `sys_user_post`;

CREATE TABLE `sys_user_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_user_subdep`;

CREATE TABLE `sys_user_subdep` (
  `user_id` int(11) NOT NULL,
  `dep_id` int(11) NOT NULL,
  `org_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`dep_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_setting`;

CREATE TABLE `sys_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) NOT NULL COMMENT '组织编号',
  `json` varchar(500) DEFAULT NULL COMMENT '设置',
  `param` varchar(500) DEFAULT NULL COMMENT '参数',
  `web_json` varchar(500) DEFAULT NULL,
  `web_param` varchar(500) DEFAULT NULL,
  `mobile_json` varchar(500) DEFAULT NULL,
  `mobile_param` varchar(500) DEFAULT NULL,
  `pad_json` varchar(500) DEFAULT NULL,
  `pad_param` varchar(500) DEFAULT NULL,
  `pc_json` varchar(500) DEFAULT NULL,
  `pc_param` varchar(500) DEFAULT NULL,
  `safe_json` varchar(2000) DEFAULT NULL COMMENT '安全设置',
  `safe_param` varchar(2000) DEFAULT NULL COMMENT '安全参数',
  `msg_json` varchar(2000) DEFAULT NULL COMMENT '消息设置',
  `msg_param` varchar(2000) DEFAULT NULL COMMENT '消息参数',
  `address_json` varchar(2000) DEFAULT NULL COMMENT '通讯录设置',
  `address_param` varchar(2000) DEFAULT NULL COMMENT '通讯录参数',
  `file_json` varchar(2000) DEFAULT NULL,
  `file_param` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='系统设置';

DROP TABLE IF EXISTS `sys_client_version`;

CREATE TABLE `sys_client_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `client_type` varchar(50) DEFAULT NULL COMMENT '客户端类型',
  `client_code` varchar(50) DEFAULT NULL COMMENT '客户端编码',
  `version` varchar(50) DEFAULT NULL COMMENT '版本号',
  `os_type` varchar(50) DEFAULT NULL COMMENT '系统类型',
  `description` text COMMENT '描述',
  `url` varchar(200) DEFAULT NULL COMMENT '地址',
  `enforce` int(11) DEFAULT NULL COMMENT '执行',
  `creator_id` int(11) DEFAULT NULL COMMENT '创建人编号',
  `createtime` datetime DEFAULT NULL COMMENT '创建时间',
  `status` int(11) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `sys_post`;

CREATE TABLE `sys_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `parent_ids` varchar(400) DEFAULT NULL,
  `description` varchar(400) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `last_modifier_id` int(11) DEFAULT NULL,
  `last_modify_time` datetime DEFAULT NULL,
  `deleter_id` int(11) DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_level`;

CREATE TABLE `sys_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` varchar(400) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `last_modifier_id` int(11) DEFAULT NULL,
  `last_modify_time` datetime DEFAULT NULL,
  `deleter_id` int(11) DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_layer`;

CREATE TABLE `sys_layer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` varchar(400) DEFAULT NULL,
  `status` smallint(6) DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `last_modifier_id` int(11) DEFAULT NULL,
  `last_modify_time` datetime DEFAULT NULL,
  `deleter_id` int(11) DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_user_friend`;

CREATE TABLE `sys_user_friend` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `user_id` int(11) DEFAULT NULL COMMENT '职员编号',
  `group_id` int(11) DEFAULT NULL COMMENT '分组编号',
  `friend_id` int(11) DEFAULT NULL COMMENT '好友编号',
  `status` smallint(6) DEFAULT NULL COMMENT '状态!',
  `createtime` datetime DEFAULT NULL COMMENT '创建时间!',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间!',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户好友';

DROP TABLE IF EXISTS `sys_user_friend_group`;

CREATE TABLE `sys_user_friend_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `user_id` int(11) DEFAULT NULL COMMENT '用户编号',
  `code` varchar(50) DEFAULT NULL COMMENT '代码',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `status` smallint(6) DEFAULT NULL COMMENT '状态!',
  `createtime` datetime DEFAULT NULL COMMENT '创建时间!',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间!',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户好友分组';

DROP TABLE IF EXISTS `sys_user_sign`;

CREATE TABLE `sys_user_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '单位编号',
  `user_id` int(11) DEFAULT NULL COMMENT '用户编号',
  `sign_type` varchar(20) DEFAULT NULL COMMENT '签章类型',
  `sign_code` varchar(50) DEFAULT NULL COMMENT '签章代码',
  `sign_password` varchar(50) DEFAULT NULL COMMENT '签章密码',
  `sign_comment` varchar(200) DEFAULT NULL COMMENT '签章备注',
  `sign_status` smallint(6) DEFAULT NULL COMMENT '签章状态',
  `creater_id` int(11) DEFAULT NULL COMMENT '创建人编号!',
  `createtime` datetime DEFAULT NULL COMMENT '创建时间!',
  `deleter_id` int(11) DEFAULT NULL COMMENT '删除编号!',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间!',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户签章';

DROP TABLE IF EXISTS `sys_data_dictype`;

CREATE TABLE `sys_data_dictype` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '类别编号',
  `name` varchar(20) NOT NULL COMMENT '类别名称',
  `parent_id` int(11) DEFAULT '0' COMMENT '父类别编号',
  `id_full_path` varchar(100) DEFAULT NULL COMMENT '编号路径',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `status` int(11) DEFAULT NULL COMMENT '状态',
  `code` varchar(45) DEFAULT NULL COMMENT '编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_data_dic`;

CREATE TABLE `sys_data_dic` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(200) NOT NULL COMMENT '名称',
  `type_id` int(11) NOT NULL COMMENT '类别编号',
  `code` varchar(10) DEFAULT NULL COMMENT '编码',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `type_code` varchar(50) DEFAULT NULL COMMENT '类别编码',
  `tacit` varchar(50) DEFAULT NULL COMMENT '默认显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_data_region`;

CREATE TABLE `sys_data_region` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '编号',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `level` tinyint(4) NOT NULL COMMENT '级别',
  `parent_code` varchar(20) DEFAULT NULL COMMENT '父级编码',
  `code` varchar(20) DEFAULT NULL COMMENT '编码',
  `first_letter` varchar(2) DEFAULT NULL COMMENT '首字母',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='区域';

DROP TABLE IF EXISTS `sys_encodingrule`;

CREATE TABLE `sys_encodingrule` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `pk_type` varchar(50) DEFAULT NULL COMMENT '相关类型',
  `pk_code` varchar(50) DEFAULT NULL COMMENT '相关代码',
  `clear_mode` char(2) DEFAULT NULL COMMENT '清零方式',
  `update_mode` char(2) DEFAULT NULL COMMENT '更新方式',
  `sn_type` char(2) DEFAULT NULL COMMENT '流水号类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_encodingrule_item`;

CREATE TABLE `sys_encodingrule_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `encodingrule_id` int(11) DEFAULT NULL,
  `order_number` int(11) DEFAULT NULL,
  `encoding_type` varchar(20) DEFAULT NULL,
  `encoding_count` int(11) DEFAULT NULL,
  `encoding_content` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sys_encodingrule_sn`;

CREATE TABLE `sys_encodingrule_sn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `encodingrule_id` int(11) DEFAULT NULL,
  `fk_type` varchar(50) DEFAULT NULL,
  `fk_code` varchar(200) DEFAULT NULL,
  `encoding_year` int(11) DEFAULT NULL,
  `encoding_month` int(11) DEFAULT NULL,
  `encoding_date` int(11) DEFAULT NULL,
  `sn` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) values('系统数据',0,1,0,'system');

update sys_data_dictype set `id_full_path`=concat('/',`id`,'/') where `name`='系统数据';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '编码规则',`id`,1,0,'encodingrule' from sys_data_dictype where `name`='系统数据';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`name`='编码规则' and b.id=a.parent_id;

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '清零方式',`id`,1,0,'encodingrule-clear-mode' from sys_data_dictype where `name`='编码规则';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`name`='清零方式' and b.id=a.parent_id;

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '更新方式',`id`,1,0,'encodingrule-update-mode' from sys_data_dictype where `name`='编码规则';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`name`='更新方式' and b.id=a.parent_id;

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '流水号类型',`id`,1,0,'encodingrule-sn-type' from sys_data_dictype where `name`='编码规则';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`name`='流水号类型' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '不清零', id, 'N', 0, 1, code from sys_data_dictype where code='encodingrule-clear-mode';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按月清零', id, 'M', 0, 1, code from sys_data_dictype where code='encodingrule-clear-mode';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按日清零', id, 'D', 0, 1, code from sys_data_dictype where code='encodingrule-clear-mode';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '读取时更新', id, 'R', 0, 1, code from sys_data_dictype where code='encodingrule-update-mode';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '写入时更新', id, 'W', 0, 1, code from sys_data_dictype where code='encodingrule-update-mode';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按组织生成', id, 'O', 0, 1, code from sys_data_dictype where code='encodingrule-sn-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按部门生成', id, 'D', 0, 1, code from sys_data_dictype where code='encodingrule-sn-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按用户生成', id, 'U', 0, 1, code from sys_data_dictype where code='encodingrule-sn-type';


DROP TABLE IF EXISTS `im_dep_mute`;

CREATE TABLE `im_dep_mute` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `dep_id` int(11) DEFAULT NULL COMMENT '部门编号',
  `user_id` int(11) DEFAULT NULL COMMENT '用户编号',
  `mute_time` datetime DEFAULT NULL COMMENT '免打扰时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='部门群组免打扰';

DROP TABLE IF EXISTS `im_group`;

CREATE TABLE `im_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `code` varchar(50) DEFAULT NULL COMMENT '代码',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `description` varchar(500) DEFAULT NULL COMMENT '描述',
  `type` varchar(20) DEFAULT NULL COMMENT '类型（user app temp）',
  `user_id` int(11) DEFAULT NULL COMMENT '群主*',
  `app_code` varchar(50) DEFAULT NULL COMMENT '应用代码',
  `app_data_id` int(11) DEFAULT NULL COMMENT '应用数据编号',
  `set_name` smallint(6) DEFAULT NULL COMMENT '允许重命名',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  `createtime` datetime DEFAULT NULL COMMENT '创建时间',
  `creater_id` int(11) DEFAULT NULL COMMENT '创建人编号*',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间',
  `delete_user_id` int(11) DEFAULT NULL COMMENT '删除人编号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='群组';

DROP TABLE IF EXISTS `im_group_mute`;

CREATE TABLE `im_group_mute` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `group_id` int(11) DEFAULT NULL COMMENT '群组编号',
  `user_id` int(11) DEFAULT NULL COMMENT '用户编号',
  `mute_time` datetime DEFAULT NULL COMMENT '免打扰时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='群组免打扰';

DROP TABLE IF EXISTS `im_group_user`;

CREATE TABLE `im_group_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号*',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `group_id` int(11) DEFAULT NULL COMMENT '群组编号',
  `user_id` int(11) DEFAULT NULL COMMENT '用户编号',
  `favorite` smallint(6) DEFAULT NULL COMMENT '收藏标志',
  `param_json` varchar(500) DEFAULT NULL COMMENT '参数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='群组用户';

DROP TABLE IF EXISTS `im_msg`;

CREATE TABLE `im_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `content_type` varchar(20) DEFAULT NULL COMMENT '内容类型',
  `group_type` varchar(20) DEFAULT NULL COMMENT '群组类型',
  `group_id` int(11) DEFAULT NULL COMMENT '群组编号',
  `group_name` varchar(200) DEFAULT NULL COMMENT '群组名称',
  `receiver_id` int(11) DEFAULT NULL COMMENT '接收人编号',
  `receiver_name` varchar(200) DEFAULT NULL COMMENT '接收人名称',
  `at_user_ids` varchar(200) DEFAULT NULL COMMENT '@人员编号数组',
  `content` text COMMENT '内容',
  `revoke_time` datetime DEFAULT NULL COMMENT '撤回时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='消息';

DROP TABLE IF EXISTS `im_msg_dir`;

CREATE TABLE `im_msg_dir` (
  `id` int(11) NOT NULL COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `dir_name` varchar(200) DEFAULT NULL COMMENT '目录名称',
  `dir_size` int(11) DEFAULT NULL COMMENT '目录大小',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息目录';

DROP TABLE IF EXISTS `im_msg_dir_file`;

CREATE TABLE `im_msg_dir_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `msg_id` int(11) DEFAULT NULL COMMENT '消息编号',
  `file_code` varchar(50) DEFAULT NULL COMMENT '文件代码',
  `file_name` varchar(200) DEFAULT NULL COMMENT '文件名称',
  `file_path` varchar(2000) DEFAULT NULL COMMENT '文件路径',
  `file_size` int(11) DEFAULT NULL COMMENT '文件大小',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息目录文件';

DROP TABLE IF EXISTS `im_msg_file`;

CREATE TABLE `im_msg_file` (
  `id` int(11) NOT NULL COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `file_code` varchar(50) DEFAULT NULL COMMENT '文件代码',
  `file_name` varchar(200) DEFAULT NULL COMMENT '文件名称',
  `file_path` varchar(2000) DEFAULT NULL COMMENT '文件路径',
  `file_size` int(11) DEFAULT NULL COMMENT '文件大小',
  `file_type` varchar(50) DEFAULT NULL COMMENT '文件类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息文件';

DROP TABLE IF EXISTS `im_msg_image`;

CREATE TABLE `im_msg_image` (
  `id` int(11) NOT NULL COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `width` int(11) DEFAULT NULL COMMENT '宽度',
  `height` int(11) DEFAULT NULL COMMENT '高度',
  `thumbnail` int(11) DEFAULT NULL COMMENT '缩略图',
  `thumbnail_size` int(11) DEFAULT NULL COMMENT '缩略图大小',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息图片';

DROP TABLE IF EXISTS `im_msg_video`;

CREATE TABLE `im_msg_video` (
  `id` int(11) NOT NULL COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `seconds` int(11) DEFAULT NULL COMMENT '秒',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息视频';

DROP TABLE IF EXISTS `im_msg_voice`;

CREATE TABLE `im_msg_voice` (
  `id` int(11) NOT NULL COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `seconds` int(11) DEFAULT NULL COMMENT '秒',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='消息语音';

DROP TABLE IF EXISTS `im_role_mute`;

CREATE TABLE `im_role_mute` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `role_id` int(11) DEFAULT NULL COMMENT '角色编号',
  `user_id` int(11) DEFAULT NULL COMMENT '用户编号',
  `mute_time` datetime DEFAULT NULL COMMENT '免打扰时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统群组（角色）免打扰';

DROP TABLE IF EXISTS `im_setting`;

CREATE TABLE `im_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) NOT NULL COMMENT '组织编号',
  `mobile_json` varchar(500) DEFAULT NULL COMMENT '手机设置',
  `mobile_param` varchar(500) DEFAULT NULL COMMENT '手机参数',
  `pc_json` varchar(500) DEFAULT NULL COMMENT '电脑设置',
  `pc_param` varchar(500) DEFAULT NULL COMMENT '电脑参数',
  `pad_json` varchar(500) DEFAULT NULL COMMENT '平板设置',
  `pad_param` varchar(500) DEFAULT NULL COMMENT '平板参数',
  `look_json` varchar(500) DEFAULT NULL COMMENT '查看设置',
  `look_param` varchar(500) DEFAULT NULL COMMENT '查看参数',
  `show_json` varchar(500) DEFAULT NULL COMMENT '显示设置',
  `show_param` varchar(500) DEFAULT NULL COMMENT '显示参数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='通讯设置';

DROP TABLE IF EXISTS `im_user_view`;

CREATE TABLE `im_user_view` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '组织编号',
  `user_id` int(11) DEFAULT NULL COMMENT '职员编号',
  `view_type` smallint(6) DEFAULT NULL COMMENT '公开标志（0 不公开 1公开）',
  `range_mark` int(11) DEFAULT NULL COMMENT '范围标志（1全部 2指定范围）',
  `range_auth` varchar(4000) DEFAULT NULL COMMENT '查看权限（指定范围）',
  `status` smallint(6) DEFAULT NULL COMMENT '状态!',
  `creater_id` int(11) DEFAULT NULL COMMENT '创建人编号!',
  `createtime` datetime DEFAULT NULL COMMENT '创建时间!',
  `deleter_id` int(11) DEFAULT NULL COMMENT '删除编号!',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间!',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户被查看权';

DROP TABLE IF EXISTS `im_user_view_power`;

CREATE TABLE `im_user_view_power` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `org_id` int(11) DEFAULT NULL COMMENT '单位编号',
  `view_id` int(11) DEFAULT NULL COMMENT '查看编号',
  `range_type` varchar(20) DEFAULT NULL COMMENT '范围类型（user dep role）',
  `relation_id` int(11) DEFAULT NULL COMMENT '关联编号',
  `relation_name` varchar(50) DEFAULT NULL COMMENT '关联名称',
  `relation_remarks` varchar(200) DEFAULT NULL COMMENT '关联备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户被查看权权限';

DROP VIEW IF EXISTS `vsys_org_app`;

CREATE VIEW `vsys_org_app` AS select `a`.`id` AS `app_id`,`a`.`name` AS `app_name`,`a`.`code` AS `app_code`,`a`.`description` AS `description`,`a`.`developer_id` AS `developer_id`,`c`.`code` AS `developer_code`,`c`.`name` AS `developer_name`,`a`.`version` AS `version`,`a`.`deploy` AS `deploy`,`a`.`terminal` AS `terminal`,`a`.`url_phone` AS `url_phone`,`a`.`url_pad` AS `url_pad`,`a`.`url_pc` AS `url_pc`,`a`.`url_web` AS `url_web`,`a`.`url_phone_detail` AS `url_phone_detail`,`a`.`url_pad_detail` AS `url_pad_detail`,`a`.`url_pc_detail` AS `url_pc_detail`,`a`.`url_web_detail` AS `url_web_detail`,`a`.`icon_path` AS `icon_path`,`a`.`icon_code` AS `icon_code`,`a`.`titlebar_color` AS `titlebar_color`,`a`.`get_badge_service` AS `get_badge_service`,`a`.`msg_group` AS `msg_group`,`a`.`createtime` AS `createtime`,`a`.`lastupdate` AS `lastupdate`,`a`.`pc_open_type` AS `pc_open_type`,`a`.`pc_show_on_sysbar` AS `pc_show_on_sysbar`,`b`.`org_id` AS `org_id`,`b`.`status` AS `status`,`b`.`category_id` AS `category_id`,`b`.`installer_id` AS `installer_id`,`b`.`install_time` AS `install_time`,`b`.`order_no` AS `order_no` from ((`sys_app` `a` join `sys_org_app` `b`) join `sys_org` `c`) where ((`a`.`id` = `b`.`app_id`) and (`a`.`developer_id` = `c`.`id`));

DROP VIEW IF EXISTS `vsys_app_auth`;

CREATE VIEW `vsys_app_auth` AS select `a`.`id` AS `id`,`a`.`owner_type` AS `owner_type`,`a`.`owner_id` AS `owner_id`,`a`.`opration_id` AS `opration_id`,`c`.`name` AS `opration_name`,`c`.`service_path` AS `service_path`,(case when isnull(`a`.`opration_id`) then `a`.`terminal` else `c`.`terminal` end) AS `auth_terminal`,(case `a`.`owner_type` when 'role' then (select `sys_role`.`name` from `sys_role` where ((`sys_role`.`id` = `a`.`owner_id`) and (`sys_role`.`org_id` = `a`.`org_id`))) when 'dep' then (select `sys_dep`.`name` from `sys_dep` where ((`sys_dep`.`id` = `a`.`owner_id`) and (`sys_dep`.`org_id` = `a`.`org_id`))) else (select `sys_user`.`name` from `sys_user` where ((`sys_user`.`id` = `a`.`owner_id`) and (`sys_user`.`org_id` = `a`.`org_id`))) end) AS `owner_name`,`b`.`app_id` AS `app_id`,`b`.`app_name` AS `app_name`,`b`.`app_code` AS `app_code`,`b`.`description` AS `description`,`b`.`developer_id` AS `developer_id`,`b`.`developer_code` AS `developer_code`,`b`.`developer_name` AS `developer_name`,`b`.`version` AS `version`,`b`.`deploy` AS `deploy`,`b`.`terminal` AS `terminal`,`b`.`url_phone` AS `url_phone`,`b`.`url_pad` AS `url_pad`,`b`.`url_pc` AS `url_pc`,`b`.`url_web` AS `url_web`,`b`.`icon_path` AS `icon_path`,`b`.`icon_code` AS `icon_code`,`b`.`url_phone_detail` AS `url_phone_detail`,`b`.`url_pad_detail` AS `url_pad_detail`,`b`.`url_pc_detail` AS `url_pc_detail`,`b`.`url_web_detail` AS `url_web_detail`,`b`.`titlebar_color` AS `titlebar_color`,`b`.`msg_group` AS `msg_group`,`b`.`createtime` AS `createtime`,`b`.`lastupdate` AS `lastupdate`,`b`.`org_id` AS `org_id`,`b`.`status` AS `status`,`b`.`category_id` AS `category_id`,`b`.`installer_id` AS `installer_id`,`b`.`install_time` AS `install_time`,`b`.`order_no` AS `order_no`,`b`.`get_badge_service` AS `get_badge_service`,`b`.`pc_open_type` AS `pc_open_type`,`b`.`pc_show_on_sysbar` AS `pc_show_on_sysbar` from ((`sys_app_auth` `a` join `vsys_org_app` `b`) left join `sys_app_opration` `c` on((`c`.`id` = `a`.`opration_id`))) where ((`a`.`app_id` = `b`.`app_id`) and (`a`.`org_id` = `b`.`org_id`));

DROP VIEW IF EXISTS `vsys_log_download`;

CREATE VIEW `vsys_log_download` AS 
select `a`.`id` AS `id`,`a`.`file_id` AS `file_id`,`a`.`file_code` AS `file_code`,
`a`.`file_name` AS `file_name`,`a`.`file_size` AS `file_size`,`a`.`file_path` AS `file_path`,
`a`.`app_code` AS `app_code`,`a`.`app_data_id` AS `app_data_id`,`a`.`thumbnail` AS `thumbnail`,
`a`.`session_id` AS `session_id`,`b`.`req_time` AS `req_time`,`b`.`req_ms` AS `req_ms`,
`b`.`ip` AS `ip`,`b`.`res_time` AS `res_time`,`b`.`res_ms` AS `res_ms`,`b`.`use_time` AS `use_time` 
from (`sys_log_download` `a` left join `sys_log_request` `b` on((`a`.`req_id` = `b`.`id`)));

DROP VIEW IF EXISTS `vsys_log_service`;

CREATE VIEW `vsys_log_service` AS select `a`.`id` AS `id`,`a`.`session_id` AS `session_id`,`a`.`path` AS `path`,`a`.`req_data` AS `req_data`,`a`.`res_data` AS `res_data`,`a`.`res_code` AS `res_code`,`a`.`err_msg` AS `err_msg`,`b`.`req_time` AS `req_time`,`b`.`req_ms` AS `req_ms`,`b`.`ip` AS `ip`,`b`.`res_time` AS `res_time`,`b`.`res_ms` AS `res_ms`,`b`.`use_time` AS `use_time` from (`sys_log_service` `a` join `sys_log_request` `b`) where (`a`.`id` = `b`.`id`);

DROP VIEW IF EXISTS `vsys_log_static`;

CREATE VIEW `vsys_log_static` AS select `a`.`id` AS `id`,`a`.`content_type` AS `content_type`,`a`.`content_size` AS `content_size`,`a`.`range_start` AS `range_start`,`a`.`range_end` AS `range_end`,`a`.`compress_type` AS `compress_type`,`a`.`last_modified` AS `last_modified`,`b`.`req_time` AS `req_time`,`b`.`req_ms` AS `req_ms`,`b`.`ip` AS `ip`,`b`.`path` AS `path`,`b`.`response_code` AS `response_code`,`b`.`res_time` AS `res_time`,`b`.`res_ms` AS `res_ms`,`b`.`use_time` AS `use_time` from (`sys_log_static` `a` join `sys_log_request` `b`) where (`a`.`id` = `b`.`id`);

DROP VIEW IF EXISTS `vsys_log_upload`;

CREATE VIEW `vsys_log_upload` AS select `a`.`id` AS `id`,`a`.`file_code` AS `file_code`,`a`.`file_name` AS `file_name`,`a`.`file_size` AS `file_size`,`a`.`app_code` AS `app_code`,`a`.`app_data_id` AS `app_data_id`,`a`.`session_id` AS `session_id`,`b`.`req_time` AS `req_time`,`b`.`req_ms` AS `req_ms`,`b`.`ip` AS `ip`,`b`.`res_time` AS `res_time`,`b`.`res_ms` AS `res_ms`,`b`.`use_time` AS `use_time` from (`sys_log_upload` `a` join `sys_log_request` `b`) where (`a`.`id` = `b`.`id`);

DROP VIEW IF EXISTS `vsys_role_user`;

CREATE VIEW `vsys_role_user` AS select `a`.`org_id` AS `org_id`,`a`.`role_id` AS `role_id`,`a`.`user_id` AS `user_id`,`a`.`creater_id` AS `creater_id`,`a`.`createtime` AS `createtime`,`a`.`is_admin` AS `is_admin`,`b`.`name` AS `role_name`,`c`.`name` AS `user_name`,`c`.`code` AS `user_code`,`c`.`sex` AS `user_sex`,`c`.`status` AS `user_status` from ((`sys_role_user` `a` join `sys_role` `b`) join `sys_user` `c`) where ((`a`.`org_id` = `b`.`org_id`) and (`a`.`role_id` = `b`.`id`) and (`a`.`org_id` = `c`.`org_id`) and (`a`.`user_id` = `c`.`id`));

DROP VIEW IF EXISTS `vsys_user`;

CREATE VIEW `vsys_user` AS
    SELECT 
        `a`.`id` AS `id`,
        `a`.`code` AS `code`,
        `a`.`name` AS `name`,
        `a`.`loginname` AS `loginname`,
        `a`.`password` AS `password`,
        `a`.`org_id` AS `org_id`,
        `a`.`status` AS `status`,
        `a`.`mobile` AS `mobile`,
        `a`.`email` AS `email`,
        `a`.`motto` AS `motto`,
        `a`.`creater_id` AS `creater_id`,
        `a`.`createtime` AS `createtime`,
        `a`.`lastLoginTime` AS `lastLoginTime`,
        `a`.`lastLoginIp` AS `lastLoginIp`,
        `a`.`sex` AS `sex`,
        `a`.`post` AS `post`,
        `a`.`create_group` AS `create_group`,
        `a`.`look_all` AS `look_all`,
        `a`.`look_self_bureau` AS `look_self_bureau`,
        `a`.`look_self_dep` AS `look_self_dep`,
        `a`.`look_leader` AS `look_leader`,
        `a`.`look_under` AS `look_under`,
        `a`.`province` AS `province`,
        `a`.`city` AS `city`,
        `a`.`district` AS `district`,
        `a`.`address` AS `address`,
        `a`.`nickname` AS `nickname`,
        `a`.`tel_short` AS `tel_short`,
        `a`.`tel_work` AS `tel_work`,
        `a`.`tel_home` AS `tel_home`,
        `a`.`tel_other` AS `tel_other`,
        `a`.`only_app_center` AS `only_app_center`,
        `a`.`disable_address_book` AS `disable_address_book`,
        `a`.`disable_work_circle` AS `disable_work_circle`,
        `a`.`device_id` AS `device_id`,
        `a`.`not_bind_device` AS `not_bind_device`,
        `a`.`head_id` AS `head_id`,
        `a`.`disable_taskmsg` AS `disable_taskmsg`,
        `a`.`disable_app_center` AS `disable_app_center`,
        `a`.`client_version` AS `client_version`,
        `a`.`disable_chpwd` AS `disable_chpwd`,
        `a`.`disk_limit` AS `disk_limit`,
        `a`.`disk_limit_unit` AS `disk_limit_unit`,
        `a`.`file_size_limit` AS `file_size_limit`,
        `a`.`bind_ca` AS `bind_ca`,
        `a`.`bind_ca_id` AS `bind_ca_id`,
        `a`.`theme_id` AS `theme_id`,
        `a`.`othercode` AS `othercode`,
        (SELECT 
                `c`.`dep_id`
            FROM
                `sys_dep_user` `c`
            WHERE
                ((`a`.`org_id` = `c`.`org_id`)
                    AND (`c`.`user_id` = `a`.`id`))
            LIMIT 1) AS `dep_id`,
        (SELECT 
                `e`.`name`
            FROM
                (`sys_dep_user` `d`
                JOIN `sys_dep` `e`)
            WHERE
                ((`d`.`org_id` = `e`.`org_id`)
                    AND (`d`.`org_id` = `a`.`org_id`)
                    AND (`d`.`dep_id` = `e`.`id`)
                    AND (`d`.`user_id` = `a`.`id`))
            LIMIT 1) AS `dep_name`,
        (SELECT 
                `e`.`code`
            FROM
                (`sys_dep_user` `d`
                JOIN `sys_dep` `e`)
            WHERE
                ((`d`.`org_id` = `e`.`org_id`)
                    AND (`d`.`org_id` = `a`.`org_id`)
                    AND (`d`.`dep_id` = `e`.`id`)
                    AND (`d`.`user_id` = `a`.`id`))
            LIMIT 1) AS `dep_code`
    FROM
        `sys_user` `a`;

DROP VIEW IF EXISTS `vsys_user_sign`;

CREATE VIEW `vsys_user_sign` AS 
select `u`.`org_id` AS `org_id`,`u`.`id` AS `user_id`,`u`.`name` AS `user_name`,`u`.`dep_id` AS `dep_id`,`u`.`dep_name` AS `dep_name`,'' AS `post_id`,'' AS `post_name`,`u`.`status` AS `status`,`us`.`sign_type` AS `sign_type`,ifnull(`us`.`sign_password`,`u`.`password`) AS `sign_password`,`us`.`sign_code` AS `sign_code`,`us`.`id` AS `sign_id` from (`vsys_user` `u` left join `sys_user_sign` `us` on(((`u`.`org_id` = `us`.`org_id`) and (`u`.`id` = `us`.`user_id`) and (`us`.`sign_status` = 0))));

DROP VIEW IF EXISTS `vim_msg_send`;

CREATE view `vim_msg_send` as
  select
      `a`.`id` as `id`,
      `a`.`org_id` as `org_id`,
      `a`.`type` as `type`,
      `a`.`sender_id` as `sender_id`,
      `a`.`sender_ctype` as `sender_ctype`,
      `a`.`send_time` as `send_time`,
      `a`.`title` as `title`,
      `a`.`summary` as `summary`,
      `a`.`icon` as `icon`,
      `a`.`sound` as `sound`,
      `a`.`open_type` as `open_type`,
      `a`.`open_content` as `open_content`,
      `a`.`group_display` as `group_display`,
      `a`.`receiver_ctype` as `receiver_ctype`,
      `a`.`to_self` as `to_self`,
      `a`.`to_all` as `to_all`,
      `a`.`retain_days` as `retain_days`,
      `b`.`content_type` as `content_type`,
      `b`.`group_type` as `group_type`,
      `b`.`group_id` as `group_id`,
      `b`.`group_name` as `group_name`,
      `b`.`receiver_id` as `receiver_id`,
      `b`.`receiver_name` as `receiver_name`,
      `b`.`at_user_ids` as `at_user_ids`,
      `b`.`content` as `content`,
      `b`.`revoke_time` as `revoke_time`,
      `c`.`file_code` as `file_code`,
      `c`.`file_name` as `file_name`,
      `c`.`file_size` as `file_size`,
      `c`.`file_type` as `file_type`,
      `d`.`width` as `width`,
      `d`.`height` as `height`,
      `d`.`thumbnail` as `thumbnail`,
      `d`.`thumbnail_size` as `thumbnail_size`,
      `e`.`seconds` as `voice_seconds`,
      `f`.`seconds` as `video_seconds`,
      `g`.`dir_name` as `dir_name`,
      `g`.`dir_size` as `dir_size`
  from
      ((((((`sys_msg` `a`
  join `im_msg` `b` on
      ((`b`.`id` = `a`.`id`)))
  left join `im_msg_file` `c` on
      ((`c`.`id` = `a`.`id`)))
  left join `im_msg_image` `d` on
      ((`d`.`id` = `a`.`id`)))
  left join `im_msg_voice` `e` on
      ((`e`.`id` = `a`.`id`)))
  left join `im_msg_video` `f` on
      ((`f`.`id` = `a`.`id`)))
  left join `im_msg_dir` `g` on
      ((`g`.`id` = `a`.`id`)));

SET GLOBAL log_bin_trust_function_creators = 1;


DROP FUNCTION IF EXISTS `fsys_encodingrule_get`;

DELIMITER $$
CREATE FUNCTION `fsys_encodingrule_get`(
p_org_id int,
p_pk_type VARCHAR(200),
p_pk_code VARCHAR(200),
p_date datetime,
p_user_id int,
p_fk_type VARCHAR(200),
p_fk_code VARCHAR(200),
p_update_mode char(2)) RETURNS varchar(200) CHARSET utf8
begin
  declare p_encoding VARCHAR(200);
  declare f_encodingrule_id int;
  declare f_clear_mode char(2);
  declare f_update_mode char(2);
  declare f_sn_type char(2);
  declare f_encoding_type varchar(50);
  declare f_encoding_count int;
  declare f_encoding_content varchar(50);
  declare f_user_name VARCHAR(200);
  declare f_user_code VARCHAR(50);
  declare f_com_id int;
  declare f_com_name VARCHAR(200);
  declare f_com_code VARCHAR(50);
  declare f_dep_id int;
  declare f_dep_name VARCHAR(200);
  declare f_dep_code VARCHAR(50);
  declare f_fk_type VARCHAR(200);
  declare f_fk_code VARCHAR(200);
  declare f_encoding_sn_id int;
  declare f_encoding_year int;
  declare f_encoding_month int;
  declare f_encoding_date int;
  declare f_sn int;
  declare done int default 0;
  declare c_item cursor for select encoding_type,encoding_count,encoding_content from sys_encodingrule_item where org_id=p_org_id and encodingrule_id=f_encodingrule_id order by order_number;
  declare continue handler for not found set done = 1;
  select ifnull(code,''),ifnull(name,''),0 as com_id,'','',dep_id,ifnull(dep_code,''),ifnull(dep_name,'') 
    into f_user_code,f_user_name,f_com_id,f_com_code,f_com_name,f_dep_id,f_dep_code,f_dep_name from vsys_user where org_id=p_org_id and id=p_user_id;
  select id,clear_mode,update_mode,sn_type 
    into f_encodingrule_id,f_clear_mode,f_update_mode,f_sn_type from sys_encodingrule where org_id=p_org_id and pk_type=p_pk_type and pk_code=p_pk_code;
  set p_encoding='';
  if f_encodingrule_id is not null then
    open c_item;
    while done != 1 do
      fetch c_item into f_encoding_type,f_encoding_count,f_encoding_content;
        if done != 1 then
          CASE  f_encoding_type
            WHEN 'YYYYMMDD' THEN set p_encoding=concat(p_encoding,DATE_FORMAT(p_date,'%Y%m%d'));
            WHEN 'YYYY' THEN set p_encoding=concat(p_encoding,YEAR(p_date));
            WHEN 'YY' THEN set p_encoding=concat(p_encoding,RIGHT(YEAR(p_date),2));
            WHEN 'MM' THEN set p_encoding=concat(p_encoding,LPAD(MONTH(p_date),2,'0'));
            WHEN 'DD' THEN set p_encoding=concat(p_encoding,LPAD(DAY(p_date),2,'0'));
            WHEN 'COMID' THEN set p_encoding=concat(p_encoding,f_com_id);
            WHEN 'COMCODE' THEN set p_encoding=concat(p_encoding,f_com_code);
            WHEN 'COMNAME' THEN set p_encoding=concat(p_encoding,f_com_name);
            WHEN 'USERID' THEN set p_encoding=concat(p_encoding,p_user_id);
            WHEN 'USERCODE' THEN set p_encoding=concat(p_encoding,f_user_code);
            WHEN 'USERNAME' THEN set p_encoding=concat(p_encoding,f_user_name);
            WHEN 'DEPID' THEN set p_encoding=concat(p_encoding,f_dep_id);
            WHEN 'DEPCODE' THEN set p_encoding=concat(p_encoding,f_dep_code);
            WHEN 'DEPNAME' THEN set p_encoding=concat(p_encoding,f_dep_name);
            WHEN 'OTHER' THEN set p_encoding=concat(p_encoding,p_fk_code);
            WHEN 'SN' THEN 
              CASE f_sn_type
                WHEN 'C' THEN 
                  set f_fk_type='C';
                  set f_fk_code=f_com_id;
                WHEN 'D' THEN 
                  set f_fk_type='D';
                  set f_fk_code=f_dep_id;
                WHEN 'U' THEN 
                  set f_fk_type='U';
                  set f_fk_code=p_user_id;
                WHEN 'F' THEN 
                  set f_fk_type=p_fk_type;
                  set f_fk_code=p_fk_code;
                ELSE 
                  set f_fk_type='';
                  set f_fk_code='';
                END CASE;
              select id,encoding_year,encoding_month,encoding_date,sn into f_encoding_sn_id,f_encoding_year,f_encoding_month,f_encoding_date,f_sn from sys_encodingrule_sn where org_id=p_org_id and encodingrule_id=f_encodingrule_id and fk_type=f_fk_type and fk_code=f_fk_code;
              if f_encoding_sn_id is null then
                set f_sn=1;
                if f_update_mode=p_update_mode then
                  insert into sys_encodingrule_sn(org_id,encodingrule_id,fk_type,fk_code,encoding_year,encoding_month,encoding_date,sn) values(p_org_id,f_encodingrule_id,f_fk_type,f_fk_code,YEAR(p_date),MONTH(p_date),DAY(p_date),1);
                else
                  insert into sys_encodingrule_sn(org_id,encodingrule_id,fk_type,fk_code,encoding_year,encoding_month,encoding_date,sn) values(p_org_id,f_encodingrule_id,f_fk_type,f_fk_code,YEAR(p_date),MONTH(p_date),DAY(p_date),0);
                end if;
              else
                CASE f_clear_mode
                  WHEN 'Y' THEN
                    if f_encoding_year<>YEAR(p_date) then
                      set f_sn=0;
                    end if;
                  WHEN 'M' THEN
                    if f_encoding_year<>YEAR(p_date) || f_encoding_month<>MONTH(p_date) then
                      set f_sn=0;
                    end if;
                  WHEN 'D' THEN
                    if f_encoding_year<>YEAR(p_date) || f_encoding_month<>MONTH(p_date) || f_encoding_date<>DAY(p_date) then
                      set f_sn=0;
                    end if;
                  ELSE
                    set f_clear_mode='N';
                  END CASE;
                set f_encoding_year=YEAR(p_date);
                set f_encoding_month=MONTH(p_date);
                set f_encoding_date=DAY(p_date);
                set f_sn=f_sn+1;
                if f_update_mode=p_update_mode then
                  update sys_encodingrule_sn set sn=f_sn,encoding_year=f_encoding_year,encoding_month=f_encoding_month,encoding_date=f_encoding_date where org_id=p_org_id and encodingrule_id=f_encodingrule_id and fk_type=f_fk_type and fk_code=f_fk_code;
                end if;
            end if;
              set p_encoding=concat(p_encoding,LPAD(f_sn,f_encoding_count,'0'));
            ELSE
              set p_encoding=concat(p_encoding,f_encoding_content);
            END CASE;
        end if;
    end while;
    close c_item;
  end if;
  return p_encoding;
end;
$$
DELIMITER ;

DROP TABLE IF EXISTS `pm_customer`;
CREATE TABLE `pm_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '客户编号',
  `code` varchar(10) DEFAULT NULL COMMENT '客户编码',
  `name` varchar(200) NOT NULL COMMENT '客户名称',
  `scale` varchar(4) DEFAULT NULL COMMENT '客户规模',
  `trade` varchar(4) DEFAULT NULL COMMENT '所属行业',
  `grade` varchar(4) DEFAULT NULL COMMENT '客户等级',
  `source` varchar(4) DEFAULT NULL COMMENT '客户来源',
  `telephone` varchar(45) DEFAULT NULL COMMENT '联系电话',
  `contacts` varchar(20) DEFAULT NULL COMMENT '联系人',
  `site` varchar(200) DEFAULT NULL COMMENT '公司网址',
  `province` varchar(10) DEFAULT NULL COMMENT '所在省份',
  `city` varchar(10) DEFAULT NULL COMMENT '所在城市',
  `district` varchar(16) DEFAULT NULL COMMENT '所在区县',
  `address` varchar(500) DEFAULT NULL COMMENT '详细地址',
  `tax_number` varchar(20) DEFAULT NULL COMMENT '税号',
  `bank_name` varchar(200) DEFAULT NULL COMMENT '开户银行',
  `bank_account` varchar(20) DEFAULT NULL COMMENT '银行账号',
  `status` varchar(4) DEFAULT NULL COMMENT '客户状态',
  `remarks` varchar(2000) DEFAULT NULL COMMENT '客户备注',
  `salesman_id` int(11) DEFAULT NULL COMMENT '所属销售人员id',
  `creater_id` int(11) DEFAULT NULL COMMENT '创建人id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_entry_warehouse_bill`;

CREATE TABLE `pm_entry_warehouse_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '入库单编号',
  `code` varchar(20) NOT NULL COMMENT '入库单编码',
  `business_bill_id` int(11) DEFAULT NULL COMMENT '业务单据编号',
  `business_bill_type` varchar(10) DEFAULT NULL COMMENT '业务单据类型',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '合计金额',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `operator_id` int(11) NOT NULL COMMENT '经办人编号',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  `storehouse_id` int(11) DEFAULT NULL COMMENT '仓库编号',
  `business_bill_code` varchar(45) DEFAULT NULL COMMENT '业务单据编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_entry_warehouse_detail`;
CREATE TABLE `pm_entry_warehouse_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `bill_id` int(11) DEFAULT NULL COMMENT '入库单编号',
  `matter_id` int(11) DEFAULT NULL COMMENT '物料编号',
  `quantity` decimal(16,4) DEFAULT NULL COMMENT '数量',
  `unit` varchar(10) DEFAULT NULL COMMENT '单位',
  `price` decimal(16,2) DEFAULT NULL COMMENT '单价',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '金额',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_financial_accounts`;
CREATE TABLE `pm_financial_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `code` varchar(20) NOT NULL COMMENT '编码',
  `name` varchar(45) NOT NULL COMMENT '名称',
  `type` varchar(10) NOT NULL COMMENT '类型',
  `bank` varchar(200) DEFAULT NULL COMMENT '开户银行',
  `account` varchar(45) DEFAULT NULL COMMENT '银行账号',
  `remaining_sum` decimal(16,2) DEFAULT NULL COMMENT '余额',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_financial_expense`;
CREATE TABLE `pm_financial_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '单据编号',
  `code` varchar(20) DEFAULT NULL COMMENT '单据编码',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '金额合计',
  `comment` varchar(200) DEFAULT NULL COMMENT '单据备注',
  `status` int(11) DEFAULT NULL COMMENT '单据状态',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人编号',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `audit_comment` varchar(200) DEFAULT NULL COMMENT '审核备注',
  `account_id` int(11) DEFAULT NULL COMMENT '账户编号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_financial_expense_details`;
CREATE TABLE `pm_financial_expense_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `bill_id` int(11) DEFAULT NULL COMMENT '单据编号',
  `subject_id` int(11) DEFAULT NULL COMMENT '科目编号',
  `expend_date` datetime DEFAULT NULL COMMENT '支出日期',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '金额',
  `abstract` varchar(200) DEFAULT NULL COMMENT '摘要',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_financial_income_pay_details`;
CREATE TABLE `pm_financial_income_pay_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '记录编号',
  `bill_id` int(11) DEFAULT NULL COMMENT '单据编号',
  `bill_no` varchar(20) DEFAULT NULL COMMENT '单据编码',
  `type` varchar(4) DEFAULT NULL COMMENT '收支类型',
  `subject_code` varchar(10) DEFAULT NULL COMMENT '科目代码',
  `billing_date` datetime DEFAULT NULL COMMENT '经办日期',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '金额',
  `account_id` int(11) DEFAULT NULL COMMENT '账户编号',
  `summary` varchar(500) DEFAULT NULL COMMENT '摘要',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_financial_subject`;
CREATE TABLE `pm_financial_subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '科目编号',
  `code` varchar(10) DEFAULT NULL COMMENT '科目代码',
  `name` varchar(20) DEFAULT NULL COMMENT '科目名称',
  `type` varchar(10) DEFAULT NULL COMMENT '科目类型',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_matter`;
CREATE TABLE `pm_matter` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `code` varchar(10) NOT NULL COMMENT '编码',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `model` varchar(200) DEFAULT NULL COMMENT '规格型号',
  `unit` varchar(10) NOT NULL COMMENT '计量单位',
  `price` decimal(16,2) DEFAULT NULL COMMENT '单价',
  `comment` varchar(500) DEFAULT NULL COMMENT '备注',
  `type_id` int(11) DEFAULT NULL COMMENT '类别编号',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_matter_type`;
CREATE TABLE `pm_matter_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '类别编号',
  `code` varchar(45) DEFAULT NULL COMMENT '编码',
  `name` varchar(20) NOT NULL COMMENT '类别名称',
  `parent_id` int(11) DEFAULT '0' COMMENT '父类别编号',
  `id_full_path` varchar(100) DEFAULT NULL COMMENT '编号路径',
  `status` int(11) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_out_warehouse_bill`;
CREATE TABLE `pm_out_warehouse_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '出库单编号',
  `code` varchar(20) DEFAULT NULL COMMENT '出库单编码',
  `business_bill_id` int(11) DEFAULT NULL COMMENT '业务单据编号',
  `business_bill_type` varchar(10) DEFAULT NULL COMMENT '业务单据类型',
  `business_bill_code` varchar(10) DEFAULT NULL COMMENT '业务单据编码',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '合计金额',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  `storehouse_id` int(11) DEFAULT NULL COMMENT '仓库编号',
  `sale_order_id` int(11) DEFAULT NULL COMMENT '销售订单编号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_out_warehouse_detail`;
CREATE TABLE `pm_out_warehouse_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `bill_id` int(11) DEFAULT NULL COMMENT '出库单编号',
  `matter_id` int(11) DEFAULT NULL COMMENT '物料编号',
  `quantity` decimal(16,4) DEFAULT NULL COMMENT '数量',
  `unit` varchar(10) DEFAULT NULL COMMENT '单位',
  `price` decimal(16,2) DEFAULT NULL COMMENT '单价',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '金额',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_purchase_order`;
CREATE TABLE `pm_purchase_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '采购单编号',
  `code` varchar(20) NOT NULL COMMENT '采购单编码',
  `supplier_id` int(11) NOT NULL COMMENT '供应商编号',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `total_amount` decimal(16,2) NOT NULL COMMENT '金额合计',
  `order_amount` decimal(16,2) NOT NULL COMMENT '采购单总金额',
  `discount_amount` decimal(16,2) DEFAULT NULL COMMENT '优惠金额',
  `actual_amount` decimal(16,2) NOT NULL COMMENT '实付金额',
  `pay_amount` decimal(16,2) DEFAULT NULL COMMENT '预付金额',
  `pay_account` int(11) DEFAULT NULL COMMENT '付款账户',
  `create_time` datetime NOT NULL COMMENT '下单时间',
  `operator_id` int(11) NOT NULL COMMENT '经办人编号',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人编号',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `audit_comment` varchar(200) DEFAULT NULL COMMENT '审核备注',
  `status` smallint(6) NOT NULL COMMENT '状态',
  `apply_date` date DEFAULT NULL COMMENT '申请日期',
  `storehouse_id` int(11) DEFAULT NULL COMMENT '仓库编号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_purchase_order_detail`;
CREATE TABLE `pm_purchase_order_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `bill_id` int(11) NOT NULL COMMENT '采购单编号',
  `matter_id` int(11) DEFAULT NULL COMMENT '物料编号',
  `quantity` decimal(16,4) DEFAULT NULL COMMENT '数量',
  `unit` varchar(20) DEFAULT NULL COMMENT '单位',
  `price` decimal(16,2) DEFAULT NULL COMMENT '单价',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '金额',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_purchase_payment`;
CREATE TABLE `pm_purchase_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '单据编号',
  `bill_code` varchar(20) DEFAULT NULL COMMENT '单据编码',
  `pay_date` datetime DEFAULT NULL COMMENT '付款日期',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `supplier_id` int(11) DEFAULT NULL COMMENT '供应商编号',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '合计金额',
  `discount_amount` decimal(16,2) DEFAULT NULL COMMENT '优惠金额',
  `actual_amount` decimal(16,2) DEFAULT NULL COMMENT '实付金额',
  `pay_account` int(11) DEFAULT NULL COMMENT '收款账户编号',
  `comment` varchar(500) DEFAULT NULL COMMENT '备注',
  `audit_status` smallint(6) DEFAULT NULL COMMENT '审核状态',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人编号',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `audit_result` varchar(10) DEFAULT NULL COMMENT '审核结果',
  `audit_comment` varchar(45) DEFAULT NULL COMMENT '审核意见',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_purchase_payment_details`;
CREATE TABLE `pm_purchase_payment_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `purchase_bill_id` int(11) DEFAULT NULL COMMENT '采购单编号',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '付款金额',
  `payment_bill_id` int(11) DEFAULT NULL COMMENT '付款单编号',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_sale_order`;
CREATE TABLE `pm_sale_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '订单编号',
  `code` varchar(20) DEFAULT NULL COMMENT '订单编码',
  `customer_id` int(11) DEFAULT NULL COMMENT '客户编号',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `contact_number` varchar(45) DEFAULT NULL COMMENT '联系电话',
  `delivery_method` varchar(10) DEFAULT NULL COMMENT '交付方式',
  `delivery_date` date DEFAULT NULL COMMENT '交付日期',
  `shipping_address` varchar(200) DEFAULT NULL COMMENT '送货地址',
  `invoice_type` varchar(10) DEFAULT NULL COMMENT '开票类型',
  `invoice_status` smallint(6) DEFAULT NULL COMMENT '开票状态',
  `invoice_date` date DEFAULT NULL COMMENT '开票日期',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '金额合计',
  `tax_rate` decimal(16,2) DEFAULT NULL COMMENT '税率',
  `tax_amount` decimal(16,2) DEFAULT NULL COMMENT '税额',
  `order_amount` decimal(16,2) DEFAULT NULL COMMENT '订单金额',
  `discount_amount` decimal(16,2) DEFAULT NULL COMMENT '折扣金额',
  `actual_amount` decimal(16,2) DEFAULT NULL COMMENT '实际金额',
  `received_amount` decimal(16,2) DEFAULT NULL COMMENT '已收金额',
  `order_time` datetime DEFAULT NULL COMMENT '下单时间',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `order_status` smallint(6) DEFAULT NULL COMMENT '订单状态',
  `comment` varchar(45) DEFAULT NULL COMMENT '备注',
  `designer_id` int(11) DEFAULT NULL COMMENT '设计人编号',
  `design_finish_time` datetime DEFAULT NULL COMMENT '设计完成时间',
  `maker_id` int(11) DEFAULT NULL COMMENT '制作人编号',
  `make_finish_time` datetime DEFAULT NULL COMMENT '制作完成时间',
  `installer_id` int(11) DEFAULT NULL COMMENT '安装人编号',
  `install_finish_time` datetime DEFAULT NULL COMMENT '安装完成时间',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人编号',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `audit_comment` varchar(500) DEFAULT NULL COMMENT '审核意见',
  `collection_account` int(11) DEFAULT NULL COMMENT '预收款账户编号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_sale_order_detail`;
CREATE TABLE `pm_sale_order_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `order_id` int(11) NOT NULL COMMENT '订单编号',
  `service_id` int(11) NOT NULL COMMENT '服务项目id',
  `pricing_method_name` varchar(20) DEFAULT NULL COMMENT '计价方式',
  `quantity` decimal(16,2) NOT NULL COMMENT '数量',
  `unit` varchar(20) NOT NULL COMMENT '计量单位',
  `price` decimal(16,2) NOT NULL COMMENT '单价',
  `amount` decimal(16,2) NOT NULL COMMENT '金额',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_sale_payment`;
CREATE TABLE `pm_sale_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '单据编号',
  `bill_code` varchar(20) DEFAULT NULL COMMENT '单据编码',
  `receipt_date` datetime DEFAULT NULL COMMENT '收款日期',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `customer_id` int(11) DEFAULT NULL COMMENT '客户编号',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '合计金额',
  `discount_amount` decimal(16,2) DEFAULT NULL COMMENT '优惠金额',
  `actual_amount` decimal(16,2) DEFAULT NULL COMMENT '实收金额',
  `collection_account` int(11) DEFAULT NULL COMMENT '收款账户编号',
  `comment` varchar(500) DEFAULT NULL COMMENT '备注',
  `audit_status` smallint(6) DEFAULT NULL COMMENT '审核状态',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人编号',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `audit_result` varchar(10) DEFAULT NULL COMMENT '审核结果',
  `audit_comment` varchar(45) DEFAULT NULL COMMENT '审核意见',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_sale_payment_details`;
CREATE TABLE `pm_sale_payment_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `order_id` int(11) DEFAULT NULL COMMENT '订单编号',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '收款金额',
  `payment_id` int(11) DEFAULT NULL COMMENT '收款单编号',
  `comment` varchar(200) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_sale_refund`;
CREATE TABLE `pm_sale_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '单据编号',
  `bill_code` varchar(20) DEFAULT NULL COMMENT '单据编码',
  `refund_date` datetime DEFAULT NULL COMMENT '退款日期',
  `operator_id` int(11) DEFAULT NULL COMMENT '经办人编号',
  `customer_id` int(11) DEFAULT NULL COMMENT '客户编号',
  `total_amount` decimal(16,2) DEFAULT NULL COMMENT '合计金额',
  `actual_amount` decimal(16,2) DEFAULT NULL COMMENT '退款金额',
  `refund_account` int(11) DEFAULT NULL COMMENT '退款账户编号',
  `comment` varchar(500) DEFAULT NULL COMMENT '备注',
  `audit_status` smallint(6) DEFAULT NULL COMMENT '审核状态',
  `auditor_id` int(11) DEFAULT NULL COMMENT '审核人编号',
  `audit_time` datetime DEFAULT NULL COMMENT '审核时间',
  `audit_result` varchar(10) DEFAULT NULL COMMENT '审核结果',
  `audit_comment` varchar(45) DEFAULT NULL COMMENT '审核意见',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_sale_refund_details`;
CREATE TABLE `pm_sale_refund_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '明细编号',
  `order_id` int(11) DEFAULT NULL COMMENT '订单编号',
  `amount` decimal(16,2) DEFAULT NULL COMMENT '退款金额',
  `refund_id` int(11) DEFAULT NULL COMMENT '退款单编号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_service_item`;
CREATE TABLE `pm_service_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `code` varchar(10) NOT NULL COMMENT '编码',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `model` varchar(200) DEFAULT NULL COMMENT '规格型号',
  `pricing_method` varchar(45) DEFAULT NULL COMMENT '计价方式',
  `unit` varchar(10) NOT NULL COMMENT '计量单位',
  `price` decimal(16,2) DEFAULT NULL COMMENT '单价',
  `comment` varchar(500) DEFAULT NULL COMMENT '备注',
  `type_id` int(11) DEFAULT NULL COMMENT '类别编号',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_service_type`;
CREATE TABLE `pm_service_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '类别编号',
  `code` varchar(45) DEFAULT NULL COMMENT '编码',
  `name` varchar(20) NOT NULL COMMENT '类别名称',
  `parent_id` int(11) DEFAULT '0' COMMENT '父类别编号',
  `id_full_path` varchar(100) DEFAULT NULL COMMENT '编号路径',
  `status` int(11) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_stock`;
CREATE TABLE `pm_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `matter_id` int(11) DEFAULT NULL COMMENT '物料编号',
  `storehouse_id` int(11) DEFAULT NULL COMMENT '仓库编号',
  `quantity` decimal(16,4) DEFAULT NULL COMMENT '数量',
  `price` decimal(16,2) DEFAULT NULL COMMENT '单价',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_storehouse`;
CREATE TABLE `pm_storehouse` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '仓库编号',
  `code` varchar(10) DEFAULT NULL COMMENT '仓库编码',
  `name` varchar(45) NOT NULL COMMENT '仓库名称',
  `address` varchar(200) DEFAULT NULL COMMENT '仓库地址',
  `comment` varchar(200) DEFAULT NULL COMMENT '仓库备注',
  `status` smallint(6) DEFAULT NULL COMMENT '仓库状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP TABLE IF EXISTS `pm_supplier`;
CREATE TABLE `pm_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '供应商编号',
  `code` varchar(10) DEFAULT NULL COMMENT '供应商代码',
  `name` varchar(200) DEFAULT NULL COMMENT '供应商名称',
  `contacts` varchar(10) DEFAULT NULL COMMENT '联系人',
  `telephone` varchar(20) DEFAULT NULL COMMENT '联系电话',
  `address` varchar(200) DEFAULT NULL COMMENT '地址',
  `tax_number` varchar(20) DEFAULT NULL COMMENT '税号',
  `bank_name` varchar(100) DEFAULT NULL COMMENT '开户银行',
  `bank_account` varchar(45) DEFAULT NULL COMMENT '银行账号',
  `remarks` varchar(200) DEFAULT NULL COMMENT '备注',
  `status` smallint(6) DEFAULT NULL COMMENT '状态',
  `creater_id` int(11) DEFAULT NULL COMMENT '创建人编号',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;

DROP VIEW IF EXISTS `vpm_customer`;
CREATE VIEW `vpm_customer` AS select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`name` AS `name`,
`a`.`scale` AS `scale`,`a`.`trade` AS `trade`,`a`.`grade` AS `grade`,`a`.`source` AS `source`,
`a`.`telephone` AS `telephone`,`a`.`contacts` AS `contacts`,`a`.`site` AS `site`,`a`.`province` AS `province`,
`a`.`city` AS `city`,`a`.`district` AS `district`,`a`.`address` AS `address`,`a`.`tax_number` AS `tax_number`,
`a`.`bank_name` AS `bank_name`,`a`.`bank_account` AS `bank_account`,`a`.`status` AS `status`,
`a`.`remarks` AS `remarks`,`a`.`salesman_id` AS `salesman_id`,`a`.`creater_id` AS `creater_id`,
`a`.`create_time` AS `create_time`,`b`.`name` AS `salesman_name`,`c`.`name` AS `creater_name`,
(select `sys_data_dic`.`name` from `sys_data_dic` where ((`sys_data_dic`.`type_code` = 'customer-scale') 
and (`sys_data_dic`.`code` = `a`.`scale`))) AS `scale_name`,(select `sys_data_dic`.`name` from `sys_data_dic` 
where ((`sys_data_dic`.`type_code` = 'customer-trade') and (`sys_data_dic`.`code` = `a`.`trade`))) AS `trade_name`,
(select `sys_data_dic`.`name` from `sys_data_dic` where ((`sys_data_dic`.`type_code` = 'customer-grade') 
and (`sys_data_dic`.`code` = `a`.`grade`))) AS `grade_name`,(select `sys_data_dic`.`name` from `sys_data_dic` 
where ((`sys_data_dic`.`type_code` = 'customer-source') and (`sys_data_dic`.`code` = `a`.`source`))) AS `source_name`,
(select `sys_data_dic`.`name` from `sys_data_dic` where ((`sys_data_dic`.`type_code` = 'customer-status') 
and (`sys_data_dic`.`code` = `a`.`status`))) AS `status_name`,(select `sys_data_region`.`name` from `sys_data_region` 
where (`sys_data_region`.`code` = `a`.`province`)) AS `province_name`,(select `sys_data_region`.`name` 
from `sys_data_region` where (`sys_data_region`.`code` = `a`.`city`)) AS `city_name`,
(select `sys_data_region`.`name` from `sys_data_region` where (`sys_data_region`.`code` = `a`.`district`)) AS `district_name` 
from ((`pm_customer` `a` join `sys_user` `b`) join `sys_user` `c`) 
where ((`a`.`salesman_id` = `b`.`id`) and (`a`.`creater_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_entry_warehouse_bill`;
CREATE VIEW `vpm_entry_warehouse_bill` AS 
select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`business_bill_id` AS `business_bill_id`,
`a`.`business_bill_type` AS `business_bill_type`,`a`.`total_amount` AS `total_amount`,
`a`.`create_time` AS `create_time`,`a`.`operator_id` AS `operator_id`,`a`.`comment` AS `comment`,
`a`.`storehouse_id` AS `storehouse_id`,`a`.`business_bill_code` AS `business_bill_code`,
`b`.`name` AS `operator_name`,`c`.`name` AS `storehouse_name` 
from ((`pm_entry_warehouse_bill` `a` join `sys_user` `b`) join `pm_storehouse` `c`) 
where ((`a`.`operator_id` = `b`.`id`) and (`a`.`storehouse_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_entry_warehouse_detail`;
CREATE VIEW `vpm_entry_warehouse_detail` AS 
select `a`.`id` AS `id`,`a`.`bill_id` AS `bill_id`,`a`.`matter_id` AS `matter_id`,
`a`.`quantity` AS `quantity`,`a`.`unit` AS `unit`,`a`.`price` AS `price`,`a`.`amount` AS `amount`,
`a`.`comment` AS `comment`,`b`.`code` AS `matter_code`,`b`.`name` AS `matter_name`,
`b`.`model` AS `matter_model`,`c`.`code` AS `bill_code`,`c`.`business_bill_id` AS `business_bill_id`,
`c`.`business_bill_type` AS `business_bill_type`,`c`.`create_time` AS `create_time`,
`c`.`operator_id` AS `operator_id`,`c`.`storehouse_id` AS `storehouse_id`,`c`.`business_bill_code` AS `business_bill_code`,
`c`.`operator_name` AS `operator_name`,`c`.`storehouse_name` AS `storehouse_name` 
from ((`pm_entry_warehouse_detail` `a` join `pm_matter` `b`) join `vpm_entry_warehouse_bill` `c`) 
where ((`a`.`matter_id` = `b`.`id`) and (`a`.`bill_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_financial_expense`;
CREATE VIEW `vpm_financial_expense` AS select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`operator_id` AS `operator_id`,
`a`.`create_time` AS `create_time`,`a`.`total_amount` AS `total_amount`,`a`.`comment` AS `comment`,
`a`.`status` AS `status`,`a`.`auditor_id` AS `auditor_id`,`a`.`audit_time` AS `audit_time`,
`a`.`audit_comment` AS `audit_comment`,`a`.`account_id` AS `account_id`,`b`.`name` AS `operator_name`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `a`.`auditor_id`)) AS `auditor_name`,
(select `pm_financial_accounts`.`name` from `pm_financial_accounts` where (`pm_financial_accounts`.`id` = `a`.`account_id`)) 
AS `account_name` from (`pm_financial_expense` `a` join `sys_user` `b`) where (`a`.`operator_id` = `b`.`id`);

DROP VIEW IF EXISTS `vpm_financial_expense_details`;
CREATE VIEW `vpm_financial_expense_details` AS select `a`.`id` AS `id`,`a`.`bill_id` AS `bill_id`,
`a`.`subject_id` AS `subject_id`,`a`.`expend_date` AS `expend_date`,`a`.`amount` AS `amount`,
`a`.`abstract` AS `abstract`,`b`.`code` AS `subject_code`,`b`.`name` AS `subject_name` 
from (`pm_financial_expense_details` `a` join `pm_financial_subject` `b`) where (`a`.`subject_id` = `b`.`id`);

DROP VIEW IF EXISTS `vpm_financial_income_pay_details`;
CREATE VIEW `vpm_financial_income_pay_details` AS select `a`.`id` AS `id`,`a`.`bill_id` AS `bill_id`,
`a`.`bill_no` AS `bill_no`,`a`.`type` AS `type`,`a`.`subject_code` AS `subject_code`,
`a`.`billing_date` AS `billing_date`,`a`.`operator_id` AS `operator_id`,`a`.`amount` AS `amount`,
`a`.`account_id` AS `account_id`,`a`.`summary` AS `summary`,`b`.`name` AS `operator_name`,
`c`.`name` AS `account_name`,`d`.`name` AS `subject_name` from (((`pm_financial_income_pay_details` `a` 
join `sys_user` `b`) join `pm_financial_accounts` `c`) join `pm_financial_subject` `d`) 
where ((`a`.`operator_id` = `b`.`id`) and (`a`.`account_id` = `c`.`id`) and (`a`.`subject_code` = `d`.`code`));

DROP VIEW IF EXISTS `vpm_out_warehouse_bill`;
CREATE VIEW `vpm_out_warehouse_bill` AS 
select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`business_bill_id` AS `business_bill_id`,
`a`.`business_bill_type` AS `business_bill_type`,`a`.`business_bill_code` AS `business_bill_code`,
`a`.`total_amount` AS `total_amount`,`a`.`create_time` AS `create_time`,`a`.`operator_id` AS `operator_id`,
`a`.`comment` AS `comment`,`a`.`storehouse_id` AS `storehouse_id`,`a`.`sale_order_id` AS `sale_order_id`,
`b`.`name` AS `operator_name`,`c`.`name` AS `storehouse_name`,(select `pm_sale_order`.`code` 
from `pm_sale_order` where (`pm_sale_order`.`id` = `a`.`sale_order_id`)) AS `sale_order_code` 
from ((`pm_out_warehouse_bill` `a` join `sys_user` `b`) join `pm_storehouse` `c`) 
where ((`a`.`operator_id` = `b`.`id`) and (`a`.`storehouse_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_out_warehouse_detail`;
CREATE VIEW `vpm_out_warehouse_detail` AS 
select `a`.`id` AS `id`,`a`.`bill_id` AS `bill_id`,`a`.`matter_id` AS `matter_id`,`a`.`quantity` AS `quantity`,
`a`.`unit` AS `unit`,`a`.`price` AS `price`,`a`.`amount` AS `amount`,`a`.`comment` AS `comment`,
`b`.`name` AS `matter_name`,`b`.`model` AS `matter_model`,`c`.`code` AS `bill_code`,
`c`.`business_bill_id` AS `business_bill_id`,`c`.`business_bill_type` AS `business_bill_type`,
`c`.`create_time` AS `create_time`,`c`.`operator_id` AS `operator_id`,`c`.`storehouse_id` AS `storehouse_id`,
`c`.`business_bill_code` AS `business_bill_code`,`c`.`operator_name` AS `operator_name`,
`c`.`storehouse_name` AS `storehouse_name` from ((`pm_out_warehouse_detail` `a` join `pm_matter` `b`) 
join `vpm_out_warehouse_bill` `c`) where ((`a`.`matter_id` = `b`.`id`) and (`a`.`bill_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_purchase_order`;
CREATE VIEW `vpm_purchase_order` AS select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`supplier_id` AS `supplier_id`,
`a`.`apply_date` AS `apply_date`,`a`.`contacts` AS `contacts`,`a`.`contact_number` AS `contact_number`,
`a`.`total_amount` AS `total_amount`,`a`.`order_amount` AS `order_amount`,`a`.`discount_amount` AS `discount_amount`,
`a`.`actual_amount` AS `actual_amount`,`a`.`pay_amount` AS `pay_amount`,`a`.`pay_account` AS `pay_account`,
`a`.`create_time` AS `create_time`,`a`.`operator_id` AS `operator_id`,`a`.`comment` AS `comment`,
`a`.`auditor_id` AS `auditor_id`,`a`.`audit_time` AS `audit_time`,`a`.`audit_comment` AS `audit_comment`,
`a`.`status` AS `status`,`a`.`storehouse_id` AS `storehouse_id`,`b`.`name` AS `supplier_name`,
`c`.`name` AS `operator_name`,`d`.`name` AS `storehouse_name`,(select `pm_financial_accounts`.`name` 
from `pm_financial_accounts` where (`pm_financial_accounts`.`id` = `a`.`pay_account`)) AS `account_name`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `a`.`auditor_id`)) AS `auditor_name` 
from (((`pm_purchase_order` `a` join `pm_supplier` `b`) join `sys_user` `c`) join `pm_storehouse` `d`) 
where ((`a`.`supplier_id` = `b`.`id`) and (`a`.`operator_id` = `c`.`id`) and (`a`.`storehouse_id` = `d`.`id`));

DROP VIEW IF EXISTS `vpm_purchase_order_detail`;
CREATE VIEW `vpm_purchase_order_detail` AS select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`apply_date` AS `apply_date`,
`a`.`supplier_id` AS `supplier_id`,`a`.`contacts` AS `contacts`,`a`.`contact_number` AS `contact_number`,
`a`.`total_amount` AS `total_amount`,`a`.`order_amount` AS `order_amount`,`a`.`discount_amount` AS `discount_amount`,
`a`.`actual_amount` AS `actual_amount`,`a`.`pay_amount` AS `pay_amount`,`a`.`pay_account` AS `pay_account`,
`a`.`create_time` AS `create_time`,`a`.`operator_id` AS `operator_id`,`a`.`comment` AS `comment`,
`a`.`auditor_id` AS `auditor_id`,`a`.`audit_time` AS `audit_time`,`a`.`audit_comment` AS `audit_comment`,
`a`.`status` AS `status`,`a`.`supplier_name` AS `supplier_name`,`a`.`operator_name` AS `operator_name`,
`a`.`account_name` AS `account_name`,`a`.`auditor_name` AS `auditor_name`,`b`.`id` AS `detail_id`,
`b`.`matter_id` AS `matter_id`,`b`.`quantity` AS `quantity`,`b`.`unit` AS `unit`,`b`.`price` AS `price`,
`b`.`amount` AS `amount`,`b`.`comment` AS `detail_comment`,`c`.`code` AS `matter_code`,`c`.`name` AS `matter_name`,
`c`.`model` AS `matter_model` from ((`vpm_purchase_order` `a` join `pm_purchase_order_detail` `b`) join `pm_matter` `c`) 
where ((`a`.`id` = `b`.`bill_id`) and (`b`.`matter_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_purchase_payment`;
CREATE VIEW `vpm_purchase_payment` AS select `a`.`id` AS `id`,`a`.`bill_code` AS `bill_code`,
`a`.`pay_date` AS `pay_date`,`a`.`operator_id` AS `operator_id`,`a`.`supplier_id` AS `supplier_id`,
`a`.`total_amount` AS `total_amount`,`a`.`discount_amount` AS `discount_amount`,`a`.`actual_amount` AS `actual_amount`,
`a`.`pay_account` AS `pay_account`,`a`.`comment` AS `comment`,`a`.`audit_status` AS `audit_status`,
`a`.`auditor_id` AS `auditor_id`,`a`.`audit_time` AS `audit_time`,`a`.`audit_result` AS `audit_result`,
`a`.`audit_comment` AS `audit_comment`,`a`.`create_time` AS `create_time`,`b`.`name` AS `operator_name`,
`c`.`name` AS `supplier_name`,`d`.`name` AS `account_name`,(select `sys_user`.`name` from `sys_user` 
where (`sys_user`.`id` = `a`.`auditor_id`)) AS `auditor_name` from (((`pm_purchase_payment` `a` join `sys_user` `b`) 
join `pm_supplier` `c`) join `pm_financial_accounts` `d`) where ((`a`.`operator_id` = `b`.`id`) 
and (`a`.`supplier_id` = `c`.`id`) and (`a`.`pay_account` = `d`.`id`));

DROP VIEW IF EXISTS `vpm_purchase_payment_details`;
CREATE VIEW `vpm_purchase_payment_details` AS select `a`.`id` AS `id`,`a`.`purchase_bill_id` AS `purchase_bill_id`,
`a`.`amount` AS `amount`,`a`.`payment_bill_id` AS `payment_bill_id`,`a`.`comment` AS `comment`,`b`.`code` AS `code`,
`b`.`apply_date` AS `apply_date`,`b`.`actual_amount` AS `actual_amount` from (`pm_purchase_payment_details` `a` 
join `vpm_purchase_order` `b`) where (`a`.`purchase_bill_id` = `b`.`id`);

DROP VIEW IF EXISTS `vpm_sale_order`;
CREATE VIEW `vpm_sale_order` AS select `a`.`id` AS `id`,`a`.`code` AS `code`,`a`.`customer_id` AS `customer_id`,
`a`.`contacts` AS `contacts`,`a`.`contact_number` AS `contact_number`,`a`.`delivery_method` AS `delivery_method`,
`a`.`delivery_date` AS `delivery_date`,`a`.`shipping_address` AS `shipping_address`,`a`.`invoice_type` AS `invoice_type`,
`a`.`invoice_status` AS `invoice_status`,`a`.`invoice_date` AS `invoice_date`,`a`.`total_amount` AS `total_amount`,
`a`.`tax_rate` AS `tax_rate`,`a`.`tax_amount` AS `tax_amount`,`a`.`order_amount` AS `order_amount`,
`a`.`discount_amount` AS `discount_amount`,`a`.`actual_amount` AS `actual_amount`,`a`.`received_amount` AS `received_amount`,
`a`.`order_time` AS `order_time`,`a`.`operator_id` AS `operator_id`,`a`.`order_status` AS `order_status`,
`a`.`comment` AS `comment`,`b`.`name` AS `operator_name`,`c`.`name` AS `customer_name`,`a`.`designer_id` AS `designer_id`,
`a`.`design_finish_time` AS `design_finish_time`,`a`.`maker_id` AS `maker_id`,`a`.`make_finish_time` AS `make_finish_time`,
`a`.`installer_id` AS `installer_id`,`a`.`install_finish_time` AS `install_finish_time`,`a`.`auditor_id` AS `auditor_id`,
`a`.`audit_time` AS `audit_time`,`a`.`audit_comment` AS `audit_comment`,`a`.`collection_account` AS `collection_account`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `a`.`designer_id`)) AS `designer_name`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `a`.`maker_id`)) AS `maker_name`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `a`.`installer_id`)) AS `installer_name`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `a`.`auditor_id`)) AS `auditor_name`,
(select `sys_data_dic`.`name` from `sys_data_dic` where ((`sys_data_dic`.`type_code` = 'delivery-method') 
and (`sys_data_dic`.`code` = `a`.`delivery_method`))) AS `delivery_method_name` 
from ((`pm_sale_order` `a` join `sys_user` `b`) join `pm_customer` `c`) 
where ((`a`.`operator_id` = `b`.`id`) and (`c`.`id` = `a`.`customer_id`));

DROP VIEW IF EXISTS `vpm_sale_order_detail`;
CREATE VIEW `vpm_sale_order_detail` AS 
select `a`.`id` AS `id`,`a`.`order_id` AS `order_id`,`a`.`service_id` AS `service_id`,
`a`.`pricing_method_name` AS `pricing_method_name`,`a`.`quantity` AS `quantity`,`a`.`unit` AS `unit`,
`a`.`price` AS `price`,`a`.`amount` AS `amount`,`a`.`comment` AS `comment`,`b`.`name` AS `service_name`,
`b`.`type_id` AS `service_type_id`,`c`.`name` AS `service_type_name`,`d`.`order_time` AS `order_time`,
`d`.`operator_id` AS `operator_id`,`d`.`order_status` AS `order_status`,`d`.`customer_id` AS `customer_id` 
from (((`pm_sale_order_detail` `a` join `pm_service_item` `b`) join `pm_service_type` `c`) join `pm_sale_order` `d`) 
where ((`a`.`service_id` = `b`.`id`) and (`b`.`type_id` = `c`.`id`) and (`a`.`order_id` = `d`.`id`));

DROP VIEW IF EXISTS `vpm_sale_payment`;
CREATE VIEW `vpm_sale_payment` AS select `p`.`id` AS `id`,`p`.`bill_code` AS `bill_code`,
`p`.`receipt_date` AS `receipt_date`,`p`.`operator_id` AS `operator_id`,`p`.`customer_id` AS `customer_id`,
`p`.`total_amount` AS `total_amount`,`p`.`discount_amount` AS `discount_amount`,`p`.`actual_amount` AS `actual_amount`,
`p`.`collection_account` AS `collection_account`,`p`.`comment` AS `comment`,`p`.`audit_status` AS `audit_status`,
`p`.`auditor_id` AS `auditor_id`,`p`.`audit_time` AS `audit_time`,`p`.`audit_result` AS `audit_result`,
`p`.`audit_comment` AS `audit_comment`,`p`.`create_time` AS `create_time`,`u`.`name` AS `operator_name`,
`c`.`name` AS `customer_name`,`a`.`name` AS `account_name`,(select `sys_user`.`name` from `sys_user` 
where (`sys_user`.`id` = `p`.`auditor_id`)) AS `auditor_name` from (((`pm_sale_payment` `p` join `sys_user` `u`) 
join `pm_customer` `c`) join `pm_financial_accounts` `a`) where ((`p`.`operator_id` = `u`.`id`) 
and (`p`.`customer_id` = `c`.`id`) and (`p`.`collection_account` = `a`.`id`));

DROP VIEW IF EXISTS `vpm_sale_payment_details`;
CREATE VIEW `vpm_sale_payment_details` AS select `a`.`id` AS `id`,`a`.`bill_code` AS `bill_code`,
`a`.`receipt_date` AS `receipt_date`,`a`.`operator_id` AS `operator_id`,`a`.`customer_id` AS `customer_id`,
`a`.`total_amount` AS `total_amount`,`a`.`discount_amount` AS `discount_amount`,`a`.`actual_amount` AS `actual_amount`,
`a`.`collection_account` AS `collection_account`,`a`.`comment` AS `comment`,`a`.`audit_status` AS `audit_status`,
`a`.`auditor_id` AS `auditor_id`,`a`.`audit_time` AS `audit_time`,`a`.`audit_result` AS `audit_result`,
`a`.`audit_comment` AS `audit_comment`,`a`.`create_time` AS `create_time`,`a`.`operator_name` AS `operator_name`,
`a`.`customer_name` AS `customer_name`,`a`.`account_name` AS `account_name`,`a`.`auditor_name` AS `auditor_name`,
`b`.`id` AS `detail_id`,`b`.`amount` AS `amount`,`b`.`order_id` AS `order_id`,`c`.`code` AS `order_code`,
`c`.`order_time` AS `order_time`,`c`.`operator_name` AS `order_operator_name`,`c`.`actual_amount` AS `order_actual_amount`,
`c`.`received_amount` AS `order_received_amount` from ((`vpm_sale_payment` `a` join `pm_sale_payment_details` `b`) 
join `vpm_sale_order` `c`) where ((`b`.`payment_id` = `a`.`id`) and (`b`.`order_id` = `c`.`id`));


DROP VIEW IF EXISTS `vpm_sale_refund`;
CREATE VIEW `vpm_sale_refund` AS select `p`.`id` AS `id`,`p`.`bill_code` AS `bill_code`,`p`.`refund_date` AS `refund_date`,
`p`.`operator_id` AS `operator_id`,`p`.`customer_id` AS `customer_id`,`p`.`total_amount` AS `total_amount`,
`p`.`actual_amount` AS `actual_amount`,`p`.`refund_account` AS `refund_account`,`p`.`comment` AS `comment`,
`p`.`audit_status` AS `audit_status`,`p`.`auditor_id` AS `auditor_id`,`p`.`audit_time` AS `audit_time`,
`p`.`audit_result` AS `audit_result`,`p`.`audit_comment` AS `audit_comment`,`p`.`create_time` AS `create_time`,
`u`.`name` AS `operator_name`,`c`.`name` AS `customer_name`,`a`.`name` AS `account_name`,
(select `sys_user`.`name` from `sys_user` where (`sys_user`.`id` = `p`.`auditor_id`)) AS `auditor_name` 
from (((`pm_sale_refund` `p` join `sys_user` `u`) join `pm_customer` `c`) join `pm_financial_accounts` `a`) 
where ((`p`.`operator_id` = `u`.`id`) and (`p`.`customer_id` = `c`.`id`) and (`p`.`refund_account` = `a`.`id`));

DROP VIEW IF EXISTS `vpm_sale_refund_details`;
CREATE VIEW `vpm_sale_refund_details` AS select `a`.`id` AS `id`,`a`.`bill_code` AS `bill_code`,
`a`.`refund_date` AS `refund_date`,`a`.`operator_id` AS `operator_id`,`a`.`customer_id` AS `customer_id`,
`a`.`total_amount` AS `total_amount`,`a`.`actual_amount` AS `actual_amount`,`a`.`refund_account` AS `refund_account`,
`a`.`comment` AS `comment`,`a`.`audit_status` AS `audit_status`,`a`.`auditor_id` AS `auditor_id`,
`a`.`audit_time` AS `audit_time`,`a`.`audit_result` AS `audit_result`,`a`.`audit_comment` AS `audit_comment`,
`a`.`create_time` AS `create_time`,`a`.`operator_name` AS `operator_name`,`a`.`customer_name` AS `customer_name`,
`a`.`account_name` AS `account_name`,`a`.`auditor_name` AS `auditor_name`,`b`.`id` AS `detail_id`,`b`.`amount` AS `amount`,
`b`.`order_id` AS `order_id`,`c`.`code` AS `order_code`,`c`.`order_time` AS `order_time`,
`c`.`operator_name` AS `order_operator_name`,`c`.`actual_amount` AS `order_actual_amount`,
`c`.`received_amount` AS `order_received_amount` from ((`vpm_sale_refund` `a` join `pm_sale_refund_details` `b`) 
join `vpm_sale_order` `c`) where ((`b`.`refund_id` = `a`.`id`) and (`b`.`order_id` = `c`.`id`));

DROP VIEW IF EXISTS `vpm_stock`;
CREATE VIEW `vpm_stock` AS select `a`.`id` AS `id`,`a`.`matter_id` AS `matter_id`,`a`.`storehouse_id` AS `storehouse_id`,
`a`.`quantity` AS `quantity`,`a`.`price` AS `price`,`b`.`code` AS `matter_code`,`b`.`name` AS `matter_name`,
`b`.`model` AS `matter_model`,`c`.`name` AS `storehouse_name` from ((`pm_stock` `a` join `pm_matter` `b`) 
join `pm_storehouse` `c`) where ((`a`.`matter_id` = `b`.`id`) and (`a`.`storehouse_id` = `c`.`id`));

INSERT INTO `pm_financial_accounts` VALUES (1,'01','现金','01',NULL,'',0.00,0),
(2,'02','工商银行','02','工商银行','8888888',0.00,0),(3,'03','建设银行','02','建设银行','6666666',0.00,0),
(4,'04','支付宝','03',NULL,'',0.00,0),(5,'05','微信','03','',NULL,0.00,0);

INSERT INTO `pm_financial_subject` VALUES (1,'1001','销售收入','10',NULL,NULL),(2,'1001','销售收入','10',NULL,0),
(3,'1002','其他收入','10',NULL,0),(4,'2001','销售退单','20',NULL,0),(5,'2002','材料采购','20',NULL,0),
(6,'2003','外协加工','20',NULL,0),(7,'2004','其他支出','20',NULL,0),(8,'2005','物流费','20',NULL,0),
(9,'3001','办公用品','30',NULL,0),(10,'3002','水电费','30',NULL,0),(11,'3003','通讯费','30',NULL,0);

INSERT INTO `pm_service_type` VALUES (1,'01','喷绘',0,'/1/',0),(2,'02','标识标牌',0,'/2/',0),(3,'03','雕刻切割',0,'/3/',0),
(4,'04','公关策划',0,'/4/',0),(5,'05','活动物料',0,'/5/',0),(6,'06','图文快印',0,'/6/',0),(7,'07','商务印刷',0,'/7/',0),
(8,'08','光电产品',0,'/8/',0),(9,'09','其他',0,'/9/',0),(10,'0101','室外写真',1,'/1/10/',0),(11,'0102','UV户外写真',1,'/1/11/',0),
(12,'0103','UV5米卷材喷印',1,'/1/12/',0),(13,'0106','喷绘',1,'/1/13/',0),(14,'0110','条幅',1,'/1/14/',0),
(15,'0201','立体字',2,'/2/15/',0),(16,'0202','科室门牌',2,'/2/16/',0),(17,'0203','形象标识',2,'/2/17/',0),
(18,'0204','奖牌/铭牌',2,'/2/18/',0),(19,'0301','装饰艺术',3,'/3/19/',0),(20,'0302','来料代工',3,'/3/20/',0),
(21,'0401','道具制作',4,'/4/21/',0),(22,'0402','设计/策划',4,'/4/22/',0),(23,'0501','轻工',5,'/5/23/',0),
(24,'0502','重工',5,'/5/24/',0),(25,'0601','工程图',6,'/6/25/',0),(26,'0602','彩色',6,'/6/26/',0),
(27,'0603','黑白',6,'/6/27/',0),(28,'0701','单页类',7,'/7/28/',0),(29,'0702','折页类',7,'/7/29/',0),
(30,'0704','书刊类',7,'/7/30/',0),(31,'0801','室内',8,'/8/31/',0),(32,'0802','室外',8,'/8/32/',0),
(33,'0803','开关电源',8,'/8/33/',0);

INSERT INTO `pm_service_item` VALUES (1,'010101','加厚背胶PP',NULL,'01','01',15.00,NULL,13,0),
(2,'010102','010102',NULL,'01','01',35.00,NULL,13,-1),(3,'010102','背胶+冷裱板',NULL,'01','01',30.00,NULL,13,0),
(4,'010301','UV灯片',NULL,'01','01',10.00,NULL,11,0),(5,'010302','PET灯片',NULL,'01','01',10.00,NULL,1,0),
(6,'010303','宣影布',NULL,'01','01',20.00,NULL,11,0),(7,'020101','LED冲孔字>1m',NULL,'01','01',760.00,NULL,15,0),
(8,'020103','侧光冲孔字>1m',NULL,'01','01',600.00,NULL,15,0),(9,'020105','芙蓉板字>1m',NULL,'01','01',90.00,NULL,15,0),
(10,'040901','040901',NULL,'05','05',10.00,NULL,28,0),(11,'040902','200克铜板纸',NULL,'05','05',10.00,NULL,28,0);

INSERT INTO `sys_app`(code,name,version,developer_id,category_id,status,deploy,terminal,url_web,icon_path,createtime,lastupdate)
VALUES ('pm_sale_customer','客户管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/customer/index.tfp',
'{"type":"iconfont","class":"iconfont icon-dep","color":"#ffffff","bgColor":"#039be5"}',now(),now()),
('pm_sale_service','服务项目','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/service/index.tfp',
'{"type":"iconfont","class":"iconfont icon-gongyingshangxinxi","color":"#ffffff","bgColor":"#ff8f00"}',now(),now()),
('pm_sale_order','销售下单','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/order/index.tfp',
'{"type":"iconfont","class":"iconfont icon-achievement","color":"#ffffff","bgColor":"#ffa000"}',now(),now()),
('pm_sale_order_audit','订单审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/order/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-get","color":"#ffffff","bgColor":"#ff8f00"}',now(),now()),
('pm_sale_my_orders','我的订单','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/order/indexMy.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-account","color":"#ffffff","bgColor":"#0277bd"}',now(),now()),
('pm_sale_refund','销售退单','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/refund/index.tfp',
'{"type":"iconfont","class":"iconfont icon-payment","color":"#ffffff","bgColor":"#e91e63"}',now(),now()),
('pm_sale_payment','销售收款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/payment/index.tfp',
'{"type":"iconfont","class":"iconfont icon-collection","color":"#ffffff","bgColor":"#f48fb1"}',now(),now()),
('pm_sale_stat','销售统计','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/stat/index.tfp',
'{"type":"iconfont","class":"iconfont icon-chart","color":"#ffffff","bgColor":"#6a1b9a"}',now(),now()),
('pm_purchase_supplier','供应商管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/supplier/index.tfp',
'{"type":"iconfont","class":"iconfont icon-role","color":"#ffffff","bgColor":"#0288d1"}',now(),now()),
('pm_purchase_order','采购申请','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/order/index.tfp',
'{"type":"iconfont","class":"iconfont icon-purchase","color":"#ffffff","bgColor":"#9c27b0"}',now(),now()),
('pm_purchase_order_audit','采购审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/order/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-get","color":"#ffffff","bgColor":"#0277bd"}',now(),now()),
('pm_purchase_payment','采购付款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/payment/index.tfp',
'{"type":"iconfont","class":"iconfont icon-payment","color":"#ffffff","bgColor":"#ff8f00"}',now(),now()),
('pm_purchase_payment_audit','付款审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/payment/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-signature","color":"#ffffff","bgColor":"#ffa000"}',now(),now()),
('pm_purchase_stat','采购统计','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/stat/index.tfp',
'{"type":"iconfont","class":"iconfont icon-chart","color":"#ffffff","bgColor":"#c41411"}',now(),now()),
('pm_stock_storehouse','仓库管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/storehouse/index.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-inventory","color":"#ffffff","bgColor":"#ff8f00"}',now(),now()),
('pm_stock_matter','物料管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/matter/index.tfp',
'{"type":"iconfont","class":"iconfont icon-kucun","color":"#ffffff","bgColor":"#ff8f00"}',now(),now()),
('pm_stock_matter_receive','物料领用','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/receive/index.tfp',
'{"type":"iconfont","class":"iconfont icon-record","color":"#ffffff","bgColor":"#0a7e07"}',now(),now()),
('pm_stock_now','即时库存','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/stock/index.tfp',
'{"type":"iconfont","class":"iconfont icon-shangpinguanli","color":"#ffffff","bgColor":"#c41411"}',now(),now()),
('pm_stock_entry_warehouse','入库明细','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/matter/indexEntry.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-enter","color":"#ffffff","bgColor":"#0a7e07"}',now(),now()),
('pm_stock_out_warehouse','出库明细','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/matter/indexOut.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-leave","color":"#ffffff","bgColor":"#d81b60"}',now(),now()),
('pm_finance_accounts','账户管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/account/index.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-balance","color":"#ffffff","bgColor":"#0a8f08"}',now(),now()),
('pm_finance_subject','科目管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/subject/index.tfp',
'{"type":"iconfont","class":"iconfont icon-budget","color":"#ffffff","bgColor":"#9c27b0"}',now(),now()),
('pm_finance_income_pay_details','收支明细','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/income_pay_details/index.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-voucher","color":"#ffffff","bgColor":"#ff8f00"}',now(),now()),
('pm_finance_receivable','应收账款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/receivable/index.tfp',
'{"type":"iconfont","class":"iconfont icon-assignment","color":"#ffffff","bgColor":"#259b24"}',now(),now()),
('pm_finance_payable','应付账款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/payable/index.tfp',
'{"type":"iconfont","class":"iconfont icon-reporting","color":"#ffffff","bgColor":"#0277bd"}',now(),now()),
('pm_finance_expense','费用报销','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/expense/index.tfp',
'{"type":"iconfont","class":"iconfont icon-invoice","color":"#ffffff","bgColor":"#c41411"}',now(),now()),
('pm_finance_expense_audit','报销审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/expense/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-get","color":"#ffffff","bgColor":"#0277bd"}',now(),now()),
('pm_finance_stat','财务统计','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/stat/index.tfp',
'{"type":"iconfont","class":"iconfont icon-chart","color":"#ffffff","bgColor":"#c41411"}',now(),now());

insert into sys_app_auth(org_id,app_id,owner_type,owner_id,terminal)
select 1,id,'role',1,'web' from sys_app where url_web like '/app/ProjectMaster/%';

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_sale','销售管理',0,1,'{"type":"iconfont","class":"iconfont icon-app","color":"#ffffff","bgColor":"#ffc107"}', 31);

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_purchase','采购管理',0,1,'{"type":"iconfont","class":"iconfont icon-erp-enter","color":"#ffffff","bgColor":"#0288d1"}', 32);

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_stock','库存管理',0,1,'{"type":"iconfont","class":"iconfont icon-kucun","color":"#ffffff","bgColor":"#9c27b0"}', 33);

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_finance','财务管理',0,1,'{"type":"iconfont","class":"iconfont icon-erp-voucher","color":"#ffffff","bgColor":"#c41411"}', 34);

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_sale'),1,now(),id from sys_app where code like 'pm_sale_%';

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_purchase'),1,now(),id from sys_app where code like 'pm_purchase_%';

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_stock'),1,now(),id from sys_app where code like 'pm_stock%';

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_finance'),1,now(),id from sys_app where code like 'pm_finance_%';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '计量单位',`id`,1,0,'unit' from sys_data_dictype where `name`='系统数据';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`name`='计量单位' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '平方米', id, '01', 0, 1, code from sys_data_dictype where code='unit';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) values('财务管理',0,1,0,'finance');

update sys_data_dictype set `id_full_path`=concat('/',`id`,'/') where `code`='finance';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '账户类型',`id`,1,0,'financial-accounts-type' from sys_data_dictype where `code`='finance';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='financial-accounts-type' and b.id=a.parent_id;

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '科目类型',`id`,1,0,'financial-subject-type' from sys_data_dictype where `code`='finance';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='financial-subject-type' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '现金', id, '01', 0, 1, code from sys_data_dictype where code='financial-accounts-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '银行', id, '02', 0, 1, code from sys_data_dictype where code='financial-accounts-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '虚拟账户', id, '03', 0, 1, code from sys_data_dictype where code='financial-accounts-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '经营收入', id, '10', 0, 1, code from sys_data_dictype where code='financial-subject-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '经营支出', id, '20', 0, 1, code from sys_data_dictype where code='financial-subject-type';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '管理费用', id, '30', 0, 1, code from sys_data_dictype where code='financial-subject-type';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) values('销售管理',0,1,0,'sale');

update sys_data_dictype set `id_full_path`=concat('/',`id`,'/') where `code`='sale';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '客户来源',`id`,1,0,'customer-source' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='customer-source' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '电话咨询', id, '01', 0, 1, code from sys_data_dictype where code='customer-source';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '朋友介绍', id, '02', 0, 1, code from sys_data_dictype where code='customer-source';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '网站咨询', id, '03', 0, 1, code from sys_data_dictype where code='customer-source';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '客户等级',`id`,1,0,'customer-grade' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='customer-grade' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select 'A级', id, '01', 0, 1, code from sys_data_dictype where code='customer-grade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select 'C级', id, '02', 0, 1, code from sys_data_dictype where code='customer-grade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select 'C级', id, '03', 0, 1, code from sys_data_dictype where code='customer-grade';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '客户规模',`id`,1,0,'customer-scale' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='customer-scale' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '小微', id, '01', 0, 1, code from sys_data_dictype where code='customer-scale';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '中型', id, '02', 0, 1, code from sys_data_dictype where code='customer-scale';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '大型', id, '03', 0, 1, code from sys_data_dictype where code='customer-scale';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '所属行业',`id`,1,0,'customer-trade' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='customer-trade' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '政府', id, '01', 0, 1, code from sys_data_dictype where code='customer-trade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '教育', id, '02', 0, 1, code from sys_data_dictype where code='customer-trade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '医疗', id, '03', 0, 1, code from sys_data_dictype where code='customer-trade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '金融', id, '04', 0, 1, code from sys_data_dictype where code='customer-trade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '商贸', id, '05', 0, 1, code from sys_data_dictype where code='customer-trade';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '生产制造', id, '06', 0, 1, code from sys_data_dictype where code='customer-trade';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '客户状态',`id`,1,0,'customer-status' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='customer-status' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '潜在客户', id, '01', 0, 1, code from sys_data_dictype where code='customer-status';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '目标客户', id, '02', 0, 1, code from sys_data_dictype where code='customer-status';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '签约客户', id, '03', 0, 1, code from sys_data_dictype where code='customer-status';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '流失客户', id, '04', 0, 1, code from sys_data_dictype where code='customer-status';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '非目标客户', id, '05', 0, 1, code from sys_data_dictype where code='customer-status';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '计价方式',`id`,1,0,'pricing-method' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='pricing-method' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '面积', id, '01', 0, 1, code from sys_data_dictype where code='pricing-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '次数', id, '02', 0, 1, code from sys_data_dictype where code='pricing-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '时间', id, '03', 0, 1, code from sys_data_dictype where code='pricing-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '人天', id, '04', 0, 1, code from sys_data_dictype where code='pricing-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '数量', id, '05', 0, 1, code from sys_data_dictype where code='pricing-method';

insert into sys_data_dictype(`name`,`parent_id`,`org_id`,`status`,`code`) 
select '交付方式',`id`,1,0,'delivery-method' from sys_data_dictype where `code`='sale';

update sys_data_dictype a,sys_data_dictype b set a.`id_full_path`=concat(b.id_full_path,a.`id`,'/') 
where a.`code`='delivery-method' and b.id=a.parent_id;

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '客户自提', id, '01', 0, 1, code from sys_data_dictype where code='delivery-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '送货上门', id, '02', 0, 1, code from sys_data_dictype where code='delivery-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '送货安装', id, '03', 0, 1, code from sys_data_dictype where code='delivery-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '物流发货', id, '04', 0, 1, code from sys_data_dictype where code='delivery-method';

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '快递发货', id, '05', 0, 1, code from sys_data_dictype where code='delivery-method';

INSERT INTO `sys_encodingrule` VALUES 
(1,1,'销售订单编码','sale_order','Y','R','O'),
(2,1,'销售收款单编码','sale_payment','Y','R','O'),
(3,1,'销售退款单编码','sale_refund','Y','R','O'),
(4,1,'采购单编码','purchase_order','Y','R','O'),
(5,1,'采购付款单编码','purchase_payment','Y','R','O'),
(6,1,'物料领用单编码','matter_receive','Y','R','O'),
(7,1,'物料入库单编码','matter_entry','Y','R','O'),
(8,1,'物料出库单编码','matter_out','Y','R','O'),
(9,1,'费用报销单编码','financial_expense','Y','R','O');

INSERT INTO `sys_encodingrule_item` VALUES 
(10,1,1,1,'NO',NULL,'XS'),
(11,1,1,2,'YYYY',NULL,NULL),
(12,1,1,3,'SN',4,NULL),
(13,1,2,1,'NO',NULL,'XSSK'),
(14,1,2,2,'YYYY',NULL,NULL),
(15,1,2,3,'SN',4,NULL),
(16,1,3,1,'NO',NULL,'XSTK'),
(17,1,3,2,'YYYY',NULL,NULL),
(18,1,3,3,'SN',4,NULL),
(19,1,4,1,'NO',NULL,'CG'),
(20,1,4,2,'YYYY',NULL,NULL),
(21,1,4,3,'SN',4,NULL),
(22,1,5,1,'NO',NULL,'CGFK'),
(23,1,5,2,'YYYY',NULL,NULL),
(24,1,5,3,'SN',4,NULL),
(25,1,6,1,'NO',NULL,'WLLY'),
(26,1,6,2,'YYYY',NULL,NULL),
(27,1,6,3,'SN',4,NULL),
(28,1,7,1,'NO',NULL,'WLRK'),
(29,1,7,2,'YYYY',NULL,NULL),
(30,1,7,3,'SN',4,NULL),
(31,1,8,1,'NO',NULL,'WLCK'),
(32,1,8,2,'YYYY',NULL,NULL),
(33,1,8,3,'SN',4,NULL),
(34,1,9,1,'NO',NULL,'FY'),
(35,1,9,2,'YYYY',NULL,NULL),
(36,1,9,3,'SN',4,NULL);


DROP FUNCTION IF EXISTS `currenttime`;

DELIMITER $$
CREATE FUNCTION `currenttime`() 
RETURNS datetime 
BEGIN
  RETURN now();
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `datetimetovarchar`;

DELIMITER $$
CREATE FUNCTION `datetimetovarchar`(v datetime) 
RETURNS varchar(20) CHARSET UTF8 
BEGIN
  RETURN date_format(v,'%Y-%m-%d %H:%i:%S');
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `datetovarchar`;

DELIMITER $$
CREATE FUNCTION `datetovarchar`(v datetime) 
RETURNS varchar(20) CHARSET UTF8 
BEGIN
  RETURN date_format(v,'%Y-%m-%d');
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `decimaltovarchar`;

DELIMITER $$
CREATE FUNCTION `decimaltovarchar`(v decimal(18,6)) 
RETURNS varchar(20) CHARSET UTF8 
BEGIN
  RETURN CONCAT(v,'');
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `getdatediff`;

DELIMITER $$
CREATE FUNCTION `getdatediff`(d1 datetime,d2 datetime) 
RETURNS int
BEGIN
  RETURN timestampdiff(day,d1,d2);
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `getdatetimediff`;

DELIMITER $$
CREATE FUNCTION `getdatetimediff`(d1 datetime,d2 datetime) 
RETURNS int
BEGIN
  RETURN timestampdiff(second,d1,d2);
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `getname`;

DELIMITER $$
CREATE FUNCTION `getname`(c varchar(1000) CHARSET UTF8) 
RETURNS varchar(1000) CHARSET UTF8 
BEGIN
  Declare v_i int;
  DECLARE v_return varchar(1000);
  SET v_i=instr(c,',');
  IF v_i>0 THEN
    SET v_return=substring(c,v_i+1);
  ELSE
    SET v_return=c;
  END IF;
  RETURN v_return;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `getnames`;

DELIMITER $$
CREATE FUNCTION `getnames`(c varchar(1000) CHARSET UTF8) 
RETURNS varchar(1000) CHARSET UTF8 
BEGIN
  Declare v_i int;
  DECLARE v_return varchar(1000);
  SET v_i=instr(c,'#');
  IF v_i>0 THEN
    SET v_return=substring(c,v_i+1);
  ELSE
    SET v_return=c;
  END IF;
  RETURN v_return;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `getnumber`;

DELIMITER $$
CREATE FUNCTION `getnumber`(c varchar(1000) CHARSET UTF8) 
RETURNS varchar(1000) CHARSET UTF8 
BEGIN
  Declare v_i int;
  DECLARE v_return varchar(1000);
  SET v_i=instr(c,',');
  IF v_i>0 THEN
    SET v_return=substring(c,1,v_i-1);
  ELSE
    SET v_return=c;
  END IF;
  RETURN v_return;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `getnumbers`;

DELIMITER $$
CREATE FUNCTION `getnumbers`(c varchar(1000) CHARSET UTF8) 
RETURNS varchar(1000) CHARSET utf8
BEGIN
  Declare v_i int;
  DECLARE v_return varchar(1000);
  SET v_i=instr(c,'#');
  IF v_i>0 THEN
    SET v_return=substring(c,1,v_i-1);
  ELSE
    SET v_return=c;
  END IF;
  RETURN v_return;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `ifisnull`;

DELIMITER $$
CREATE FUNCTION `ifisnull`(a varchar(1000) CHARSET UTF8,b varchar(1000) CHARSET UTF8) 
RETURNS varchar(1000) CHARSET UTF8 
BEGIN
  RETURN ifnull(a,b);
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `inttovarchar`;

DELIMITER $$
CREATE FUNCTION `inttovarchar`(v int) 
RETURNS varchar(20) CHARSET UTF8 
BEGIN
  RETURN CONCAT(v,'');
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `moneytovarchar`;

DELIMITER $$
CREATE FUNCTION `moneytovarchar`(v decimal(18,2)) 
RETURNS varchar(20) CHARSET UTF8 
BEGIN
  RETURN CONCAT(v,'');
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `split`;

DELIMITER $$
CREATE FUNCTION `split`(str varchar(1000) CHARSET UTF8,s varchar(100) CHARSET UTF8,i int) 
RETURNS varchar(1000) CHARSET UTF8 
BEGIN
  Declare ls int;
  Declare ll int;
  Declare lc int;
  set ls = length(s);
  set ll = length(str)-length(replace(str,s,''));
  set lc = ll/ls;
  if i>0 and i<=lc+1 then 
    return substring_index(substring_index(str,s,i),s,-1);
  ELSEIF i<0 and -i<=lc+1 then 
    return substring_index(substring_index(str,s,i),s,1);
  else 
    return '';
  end if;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `strindex`;

DELIMITER $$
CREATE FUNCTION `strindex`(a1 varchar(1000) CHARSET UTF8,a2 varchar(1000) CHARSET UTF8) 
RETURNS int
BEGIN
  RETURN instr(a1,a2);
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `varchartodate`;

DELIMITER $$
CREATE FUNCTION `varchartodate`(c varchar(20)) 
RETURNS datetime
BEGIN
  DECLARE r datetime;
  DECLARE CONTINUE HANDLER FOR 1366,1292,1411 SET r=null;
  IF c='' THEN 
    set r=null;
  ELSE 
    SET r=STR_TO_DATE(c, '%Y-%m-%d');
  END IF;
  RETURN r;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `varchartodatetime`;

DELIMITER $$
CREATE FUNCTION `varchartodatetime`(c varchar(20)) 
RETURNS datetime
BEGIN
  DECLARE r datetime;
  DECLARE CONTINUE HANDLER FOR 1366,1292,1411 SET r=null;
  IF c='' THEN 
    set r=null;
  ELSE 
    SET r=STR_TO_DATE(c, '%Y-%m-%d %H:%i:%S');
  END IF;
  RETURN r;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `varchartodecimal`;

DELIMITER $$
CREATE FUNCTION `varchartodecimal`(c varchar(20)) 
RETURNS decimal(18,6)
BEGIN
  DECLARE r decimal(18,6);
  DECLARE CONTINUE HANDLER FOR 1366,1292,1411 SET r=null;
  IF c='' THEN 
    set r=null;
  ELSE 
    SET r=cast(c as decimal(18,6));
  END IF;
  RETURN r;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `varchartoint`;

DELIMITER $$
CREATE FUNCTION `varchartoint`(c varchar(20)) 
RETURNS int
BEGIN
  DECLARE r int;
  DECLARE CONTINUE HANDLER FOR 1366,1292,1411 SET r=null;
  IF c='' THEN
    set r=null;
  ELSE
    SET r=cast(c as signed);
  END IF;
  RETURN r;
END;
$$
DELIMITER ;


DROP FUNCTION IF EXISTS `varchartomoney`;

DELIMITER $$
CREATE FUNCTION `varchartomoney`(c varchar(20)) 
RETURNS decimal(18,2)
BEGIN
  DECLARE r decimal(18,2);
  DECLARE CONTINUE HANDLER FOR 1366,1292,1411 SET r=null;
  IF c='' THEN 
    set r=null;
  ELSE 
    SET r=cast(c as decimal(18,2));
  END IF;
  RETURN r;
END;
$$
DELIMITER ;




INSERT INTO `sys_data_region` VALUES (1, '北京', 1, '0', '11', 'b');
INSERT INTO `sys_data_region` VALUES (2, '北京', 2, '11', '1101', 'b');
INSERT INTO `sys_data_region` VALUES (3, '东城', 3, '1101', '110101', 'd');
INSERT INTO `sys_data_region` VALUES (4, '东华门', 4, '110101', '110101001', 'd');
INSERT INTO `sys_data_region` VALUES (5, '景山', 4, '110101', '110101002', 'j');
INSERT INTO `sys_data_region` VALUES (6, '交道口', 4, '110101', '110101003', 'j');
INSERT INTO `sys_data_region` VALUES (7, '安定门', 4, '110101', '110101004', 'a');
INSERT INTO `sys_data_region` VALUES (8, '北新桥', 4, '110101', '110101005', 'b');
INSERT INTO `sys_data_region` VALUES (9, '东四', 4, '110101', '110101006', 'd');
INSERT INTO `sys_data_region` VALUES (10, '朝阳门', 4, '110101', '110101007', 'z');
INSERT INTO `sys_data_region` VALUES (11, '建国门', 4, '110101', '110101008', 'j');
INSERT INTO `sys_data_region` VALUES (12, '东直门', 4, '110101', '110101009', 'd');
INSERT INTO `sys_data_region` VALUES (13, '和平里', 4, '110101', '110101010', 'h');
INSERT INTO `sys_data_region` VALUES (14, '前门', 4, '110101', '110101011', 'q');
INSERT INTO `sys_data_region` VALUES (15, '崇文门外', 4, '110101', '110101012', 'c');
INSERT INTO `sys_data_region` VALUES (16, '东花市', 4, '110101', '110101013', 'd');
INSERT INTO `sys_data_region` VALUES (17, '龙潭', 4, '110101', '110101014', 'l');
INSERT INTO `sys_data_region` VALUES (18, '体育馆路', 4, '110101', '110101015', 't');
INSERT INTO `sys_data_region` VALUES (19, '天坛', 4, '110101', '110101016', 't');
INSERT INTO `sys_data_region` VALUES (20, '永定门外', 4, '110101', '110101017', 'y');
INSERT INTO `sys_data_region` VALUES (21, '西城', 3, '1101', '110102', 'x');
INSERT INTO `sys_data_region` VALUES (22, '西长安街', 4, '110102', '110102001', 'x');
INSERT INTO `sys_data_region` VALUES (23, '新街口', 4, '110102', '110102003', 'x');
INSERT INTO `sys_data_region` VALUES (24, '月坛', 4, '110102', '110102007', 'y');
INSERT INTO `sys_data_region` VALUES (25, '展览路', 4, '110102', '110102009', 'z');
INSERT INTO `sys_data_region` VALUES (26, '德胜', 4, '110102', '110102010', 'd');
INSERT INTO `sys_data_region` VALUES (27, '金融街', 4, '110102', '110102011', 'j');
INSERT INTO `sys_data_region` VALUES (28, '什刹海', 4, '110102', '110102012', 's');
INSERT INTO `sys_data_region` VALUES (29, '大栅栏', 4, '110102', '110102013', 'd');
INSERT INTO `sys_data_region` VALUES (30, '天桥', 4, '110102', '110102014', 't');
INSERT INTO `sys_data_region` VALUES (31, '椿树', 4, '110102', '110102015', 'c');
INSERT INTO `sys_data_region` VALUES (32, '陶然亭', 4, '110102', '110102016', 't');
INSERT INTO `sys_data_region` VALUES (33, '广安门内', 4, '110102', '110102017', 'g');
INSERT INTO `sys_data_region` VALUES (34, '牛街', 4, '110102', '110102018', 'n');
INSERT INTO `sys_data_region` VALUES (35, '白纸坊', 4, '110102', '110102019', 'b');
INSERT INTO `sys_data_region` VALUES (36, '广安门外', 4, '110102', '110102020', 'g');
INSERT INTO `sys_data_region` VALUES (37, '朝阳', 3, '1101', '110105', 'c');
INSERT INTO `sys_data_region` VALUES (38, '建外', 4, '110105', '110105001', 'j');
INSERT INTO `sys_data_region` VALUES (39, '朝外', 4, '110105', '110105002', 'c');
INSERT INTO `sys_data_region` VALUES (40, '呼家楼', 4, '110105', '110105003', 'h');
INSERT INTO `sys_data_region` VALUES (41, '三里屯', 4, '110105', '110105004', 's');
INSERT INTO `sys_data_region` VALUES (42, '左家庄', 4, '110105', '110105005', 'z');
INSERT INTO `sys_data_region` VALUES (43, '香河园', 4, '110105', '110105006', 'x');
INSERT INTO `sys_data_region` VALUES (44, '和平街', 4, '110105', '110105007', 'h');
INSERT INTO `sys_data_region` VALUES (45, '安贞', 4, '110105', '110105008', 'a');
INSERT INTO `sys_data_region` VALUES (46, '亚运村', 4, '110105', '110105009', 'y');
INSERT INTO `sys_data_region` VALUES (47, '小关', 4, '110105', '110105010', 'x');
INSERT INTO `sys_data_region` VALUES (48, '酒仙桥', 4, '110105', '110105011', 'j');
INSERT INTO `sys_data_region` VALUES (49, '麦子店', 4, '110105', '110105012', 'm');
INSERT INTO `sys_data_region` VALUES (50, '团结湖', 4, '110105', '110105013', 't');
INSERT INTO `sys_data_region` VALUES (51, '六里屯', 4, '110105', '110105014', 'l');
INSERT INTO `sys_data_region` VALUES (52, '八里庄', 4, '110105', '110105015', 'b');
INSERT INTO `sys_data_region` VALUES (53, '双井', 4, '110105', '110105016', 's');
INSERT INTO `sys_data_region` VALUES (54, '劲松', 4, '110105', '110105017', 'j');
INSERT INTO `sys_data_region` VALUES (55, '潘家园', 4, '110105', '110105018', 'p');
INSERT INTO `sys_data_region` VALUES (56, '垡头', 4, '110105', '110105019', 'f');
INSERT INTO `sys_data_region` VALUES (57, '大屯', 4, '110105', '110105025', 'd');
INSERT INTO `sys_data_region` VALUES (58, '望京', 4, '110105', '110105026', 'w');
INSERT INTO `sys_data_region` VALUES (59, '奥运村', 4, '110105', '110105031', 'a');
INSERT INTO `sys_data_region` VALUES (60, '首都机场', 4, '110105', '110105043', 's');
INSERT INTO `sys_data_region` VALUES (61, '东湖', 4, '110105', '110105044', 'd');
INSERT INTO `sys_data_region` VALUES (62, '南磨房', 4, '110105', '110105221', 'n');
INSERT INTO `sys_data_region` VALUES (63, '高碑店', 4, '110105', '110105222', 'g');
INSERT INTO `sys_data_region` VALUES (64, '将台', 4, '110105', '110105223', 'j');
INSERT INTO `sys_data_region` VALUES (65, '太阳宫', 4, '110105', '110105224', 't');
INSERT INTO `sys_data_region` VALUES (66, '小红门', 4, '110105', '110105227', 'x');
INSERT INTO `sys_data_region` VALUES (67, '十八里店', 4, '110105', '110105228', 's');
INSERT INTO `sys_data_region` VALUES (68, '平房', 4, '110105', '110105229', 'p');
INSERT INTO `sys_data_region` VALUES (69, '东风', 4, '110105', '110105230', 'd');
INSERT INTO `sys_data_region` VALUES (70, '来广营', 4, '110105', '110105232', 'l');
INSERT INTO `sys_data_region` VALUES (71, '常营', 4, '110105', '110105233', 'c');
INSERT INTO `sys_data_region` VALUES (72, '三间房', 4, '110105', '110105234', 's');
INSERT INTO `sys_data_region` VALUES (73, '管庄', 4, '110105', '110105235', 'g');
INSERT INTO `sys_data_region` VALUES (74, '金盏', 4, '110105', '110105236', 'j');
INSERT INTO `sys_data_region` VALUES (75, '孙河', 4, '110105', '110105237', 's');
INSERT INTO `sys_data_region` VALUES (76, '崔各庄', 4, '110105', '110105238', 'c');
INSERT INTO `sys_data_region` VALUES (77, '东坝', 4, '110105', '110105239', 'd');
INSERT INTO `sys_data_region` VALUES (78, '黑庄户', 4, '110105', '110105240', 'h');
INSERT INTO `sys_data_region` VALUES (79, '豆各庄', 4, '110105', '110105241', 'd');
INSERT INTO `sys_data_region` VALUES (80, '王四营', 4, '110105', '110105242', 'w');
INSERT INTO `sys_data_region` VALUES (81, '丰台', 3, '1101', '110106', 'f');
INSERT INTO `sys_data_region` VALUES (82, '右安门', 4, '110106', '110106001', 'y');
INSERT INTO `sys_data_region` VALUES (83, '太平桥', 4, '110106', '110106002', 't');
INSERT INTO `sys_data_region` VALUES (84, '西罗园', 4, '110106', '110106003', 'x');
INSERT INTO `sys_data_region` VALUES (85, '大红门', 4, '110106', '110106004', 'd');
INSERT INTO `sys_data_region` VALUES (86, '南苑', 4, '110106', '110106005', 'n');
INSERT INTO `sys_data_region` VALUES (87, '东高地', 4, '110106', '110106006', 'd');
INSERT INTO `sys_data_region` VALUES (88, '东铁匠营', 4, '110106', '110106007', 'd');
INSERT INTO `sys_data_region` VALUES (89, '六里桥', 4, '110106', '110106008', 'l');
INSERT INTO `sys_data_region` VALUES (90, '丰台街道', 4, '110106', '110106009', 'f');
INSERT INTO `sys_data_region` VALUES (91, '新村', 4, '110106', '110106010', 'x');
INSERT INTO `sys_data_region` VALUES (92, '长辛店', 4, '110106', '110106011', 'c');
INSERT INTO `sys_data_region` VALUES (93, '云岗', 4, '110106', '110106012', 'y');
INSERT INTO `sys_data_region` VALUES (94, '方庄', 4, '110106', '110106013', 'f');
INSERT INTO `sys_data_region` VALUES (95, '宛平城', 4, '110106', '110106014', 'w');
INSERT INTO `sys_data_region` VALUES (96, '马家堡', 4, '110106', '110106015', 'm');
INSERT INTO `sys_data_region` VALUES (97, '和义', 4, '110106', '110106016', 'h');
INSERT INTO `sys_data_region` VALUES (98, '花乡', 4, '110106', '110106018', 'h');
INSERT INTO `sys_data_region` VALUES (99, '成寿寺', 4, '110106', '110106020', 'c');
INSERT INTO `sys_data_region` VALUES (100, '石榴庄', 4, '110106', '110106021', 's');
INSERT INTO `sys_data_region` VALUES (101, '北宫', 4, '110106', '110106100', 'b');
INSERT INTO `sys_data_region` VALUES (102, '王佐', 4, '110106', '110106101', 'w');
INSERT INTO `sys_data_region` VALUES (103, '卢沟桥', 4, '110106', '110106201', 'l');
INSERT INTO `sys_data_region` VALUES (104, '石景山', 3, '1101', '110107', 's');
INSERT INTO `sys_data_region` VALUES (105, '八宝山', 4, '110107', '110107001', 'b');
INSERT INTO `sys_data_region` VALUES (106, '老山', 4, '110107', '110107002', 'l');
INSERT INTO `sys_data_region` VALUES (107, '八角', 4, '110107', '110107003', 'b');
INSERT INTO `sys_data_region` VALUES (108, '古城', 4, '110107', '110107004', 'g');
INSERT INTO `sys_data_region` VALUES (109, '苹果园', 4, '110107', '110107005', 'p');
INSERT INTO `sys_data_region` VALUES (110, '金顶街', 4, '110107', '110107006', 'j');
INSERT INTO `sys_data_region` VALUES (111, '广宁', 4, '110107', '110107009', 'g');
INSERT INTO `sys_data_region` VALUES (112, '五里坨', 4, '110107', '110107010', 'w');
INSERT INTO `sys_data_region` VALUES (113, '鲁谷', 4, '110107', '110107011', 'l');
INSERT INTO `sys_data_region` VALUES (114, '海淀', 3, '1101', '110108', 'h');
INSERT INTO `sys_data_region` VALUES (115, '万寿路', 4, '110108', '110108001', 'w');
INSERT INTO `sys_data_region` VALUES (116, '永定路', 4, '110108', '110108002', 'y');
INSERT INTO `sys_data_region` VALUES (117, '羊坊店', 4, '110108', '110108003', 'y');
INSERT INTO `sys_data_region` VALUES (118, '甘家口', 4, '110108', '110108004', 'g');
INSERT INTO `sys_data_region` VALUES (119, '八里庄', 4, '110108', '110108005', 'b');
INSERT INTO `sys_data_region` VALUES (120, '紫竹院', 4, '110108', '110108006', 'z');
INSERT INTO `sys_data_region` VALUES (121, '北下关', 4, '110108', '110108007', 'b');
INSERT INTO `sys_data_region` VALUES (122, '北太平庄', 4, '110108', '110108008', 'b');
INSERT INTO `sys_data_region` VALUES (123, '学院路', 4, '110108', '110108010', 'x');
INSERT INTO `sys_data_region` VALUES (124, '中关村', 4, '110108', '110108011', 'z');
INSERT INTO `sys_data_region` VALUES (125, '海淀街道', 4, '110108', '110108012', 'h');
INSERT INTO `sys_data_region` VALUES (126, '青龙桥', 4, '110108', '110108013', 'q');
INSERT INTO `sys_data_region` VALUES (127, '清华园', 4, '110108', '110108014', 'q');
INSERT INTO `sys_data_region` VALUES (128, '燕园', 4, '110108', '110108015', 'y');
INSERT INTO `sys_data_region` VALUES (129, '香山', 4, '110108', '110108016', 'x');
INSERT INTO `sys_data_region` VALUES (130, '清河', 4, '110108', '110108017', 'q');
INSERT INTO `sys_data_region` VALUES (131, '花园路', 4, '110108', '110108018', 'h');
INSERT INTO `sys_data_region` VALUES (132, '西三旗', 4, '110108', '110108019', 'x');
INSERT INTO `sys_data_region` VALUES (133, '马连洼', 4, '110108', '110108020', 'm');
INSERT INTO `sys_data_region` VALUES (134, '田村路', 4, '110108', '110108021', 't');
INSERT INTO `sys_data_region` VALUES (135, '上地', 4, '110108', '110108022', 's');
INSERT INTO `sys_data_region` VALUES (136, '曙光', 4, '110108', '110108025', 's');
INSERT INTO `sys_data_region` VALUES (137, '温泉', 4, '110108', '110108101', 'w');
INSERT INTO `sys_data_region` VALUES (138, '四季青', 4, '110108', '110108102', 's');
INSERT INTO `sys_data_region` VALUES (139, '西北旺', 4, '110108', '110108103', 'x');
INSERT INTO `sys_data_region` VALUES (140, '苏家坨', 4, '110108', '110108104', 's');
INSERT INTO `sys_data_region` VALUES (141, '上庄', 4, '110108', '110108105', 's');
INSERT INTO `sys_data_region` VALUES (142, '海淀镇', 4, '110108', '110108123', 'h');
INSERT INTO `sys_data_region` VALUES (143, '东升', 4, '110108', '110108124', 'd');
INSERT INTO `sys_data_region` VALUES (144, '门头沟', 3, '1101', '110109', 'm');
INSERT INTO `sys_data_region` VALUES (145, '大峪', 4, '110109', '110109001', 'd');
INSERT INTO `sys_data_region` VALUES (146, '城子', 4, '110109', '110109002', 'c');
INSERT INTO `sys_data_region` VALUES (147, '东辛房', 4, '110109', '110109003', 'd');
INSERT INTO `sys_data_region` VALUES (148, '大台', 4, '110109', '110109004', 'd');
INSERT INTO `sys_data_region` VALUES (149, '潭柘寺', 4, '110109', '110109101', 't');
INSERT INTO `sys_data_region` VALUES (150, '永定', 4, '110109', '110109102', 'y');
INSERT INTO `sys_data_region` VALUES (151, '龙泉', 4, '110109', '110109103', 'l');
INSERT INTO `sys_data_region` VALUES (152, '军庄', 4, '110109', '110109104', 'j');
INSERT INTO `sys_data_region` VALUES (153, '雁翅', 4, '110109', '110109105', 'y');
INSERT INTO `sys_data_region` VALUES (154, '斋堂', 4, '110109', '110109106', 'z');
INSERT INTO `sys_data_region` VALUES (155, '清水', 4, '110109', '110109107', 'q');
INSERT INTO `sys_data_region` VALUES (156, '妙峰山', 4, '110109', '110109108', 'm');
INSERT INTO `sys_data_region` VALUES (157, '王平', 4, '110109', '110109109', 'w');
INSERT INTO `sys_data_region` VALUES (158, '房山', 3, '1101', '110111', 'f');
INSERT INTO `sys_data_region` VALUES (159, '城关', 4, '110111', '110111001', 'c');
INSERT INTO `sys_data_region` VALUES (160, '新镇', 4, '110111', '110111002', 'x');
INSERT INTO `sys_data_region` VALUES (161, '向阳', 4, '110111', '110111004', 'x');
INSERT INTO `sys_data_region` VALUES (162, '东风', 4, '110111', '110111005', 'd');
INSERT INTO `sys_data_region` VALUES (163, '迎风', 4, '110111', '110111006', 'y');
INSERT INTO `sys_data_region` VALUES (164, '星城', 4, '110111', '110111007', 'x');
INSERT INTO `sys_data_region` VALUES (165, '拱辰', 4, '110111', '110111011', 'g');
INSERT INTO `sys_data_region` VALUES (166, '西潞', 4, '110111', '110111012', 'x');
INSERT INTO `sys_data_region` VALUES (167, '阎村', 4, '110111', '110111101', 'y');
INSERT INTO `sys_data_region` VALUES (168, '窦店', 4, '110111', '110111103', 'd');
INSERT INTO `sys_data_region` VALUES (169, '石楼', 4, '110111', '110111104', 's');
INSERT INTO `sys_data_region` VALUES (170, '长阳', 4, '110111', '110111105', 'c');
INSERT INTO `sys_data_region` VALUES (171, '河北', 4, '110111', '110111107', 'h');
INSERT INTO `sys_data_region` VALUES (172, '长沟', 4, '110111', '110111108', 'c');
INSERT INTO `sys_data_region` VALUES (173, '大石窝', 4, '110111', '110111109', 'd');
INSERT INTO `sys_data_region` VALUES (174, '张坊', 4, '110111', '110111110', 'z');
INSERT INTO `sys_data_region` VALUES (175, '十渡', 4, '110111', '110111111', 's');
INSERT INTO `sys_data_region` VALUES (176, '青龙湖', 4, '110111', '110111112', 'q');
INSERT INTO `sys_data_region` VALUES (177, '韩村河', 4, '110111', '110111115', 'h');
INSERT INTO `sys_data_region` VALUES (178, '良乡', 4, '110111', '110111116', 'l');
INSERT INTO `sys_data_region` VALUES (179, '周口店', 4, '110111', '110111117', 'z');
INSERT INTO `sys_data_region` VALUES (180, '琉璃河', 4, '110111', '110111118', 'l');
INSERT INTO `sys_data_region` VALUES (181, '霞云岭', 4, '110111', '110111208', 'x');
INSERT INTO `sys_data_region` VALUES (182, '南窖', 4, '110111', '110111209', 'n');
INSERT INTO `sys_data_region` VALUES (183, '佛子庄', 4, '110111', '110111210', 'f');
INSERT INTO `sys_data_region` VALUES (184, '大安山', 4, '110111', '110111211', 'd');
INSERT INTO `sys_data_region` VALUES (185, '史家营', 4, '110111', '110111212', 's');
INSERT INTO `sys_data_region` VALUES (186, '蒲洼', 4, '110111', '110111213', 'p');
INSERT INTO `sys_data_region` VALUES (187, '通州', 3, '1101', '110112', 't');
INSERT INTO `sys_data_region` VALUES (188, '中仓', 4, '110112', '110112001', 'z');
INSERT INTO `sys_data_region` VALUES (189, '新华', 4, '110112', '110112002', 'x');
INSERT INTO `sys_data_region` VALUES (190, '北苑', 4, '110112', '110112003', 'b');
INSERT INTO `sys_data_region` VALUES (191, '玉桥', 4, '110112', '110112004', 'y');
INSERT INTO `sys_data_region` VALUES (192, '潞源', 4, '110112', '110112005', 'l');
INSERT INTO `sys_data_region` VALUES (193, '通运', 4, '110112', '110112006', 't');
INSERT INTO `sys_data_region` VALUES (194, '文景', 4, '110112', '110112009', 'w');
INSERT INTO `sys_data_region` VALUES (195, '九棵树', 4, '110112', '110112010', 'j');
INSERT INTO `sys_data_region` VALUES (196, '临河里', 4, '110112', '110112011', 'l');
INSERT INTO `sys_data_region` VALUES (197, '杨庄', 4, '110112', '110112012', 'y');
INSERT INTO `sys_data_region` VALUES (198, '潞邑', 4, '110112', '110112013', 'l');
INSERT INTO `sys_data_region` VALUES (199, '宋庄', 4, '110112', '110112104', 's');
INSERT INTO `sys_data_region` VALUES (200, '张家湾', 4, '110112', '110112105', 'z');
INSERT INTO `sys_data_region` VALUES (201, '漷县', 4, '110112', '110112106', 'h');
INSERT INTO `sys_data_region` VALUES (202, '马驹桥', 4, '110112', '110112109', 'm');
INSERT INTO `sys_data_region` VALUES (203, '西集', 4, '110112', '110112110', 'x');
INSERT INTO `sys_data_region` VALUES (204, '台湖', 4, '110112', '110112114', 't');
INSERT INTO `sys_data_region` VALUES (205, '永乐店', 4, '110112', '110112117', 'y');
INSERT INTO `sys_data_region` VALUES (206, '潞城', 4, '110112', '110112119', 'l');
INSERT INTO `sys_data_region` VALUES (207, '永顺', 4, '110112', '110112120', 'y');
INSERT INTO `sys_data_region` VALUES (208, '梨园', 4, '110112', '110112121', 'l');
INSERT INTO `sys_data_region` VALUES (209, '于家务', 4, '110112', '110112209', 'y');
INSERT INTO `sys_data_region` VALUES (210, '顺义', 3, '1101', '110113', 's');
INSERT INTO `sys_data_region` VALUES (211, '胜利', 4, '110113', '110113001', 's');
INSERT INTO `sys_data_region` VALUES (212, '光明', 4, '110113', '110113002', 'g');
INSERT INTO `sys_data_region` VALUES (213, '石园', 4, '110113', '110113010', 's');
INSERT INTO `sys_data_region` VALUES (214, '空港', 4, '110113', '110113011', 'k');
INSERT INTO `sys_data_region` VALUES (215, '双丰', 4, '110113', '110113012', 's');
INSERT INTO `sys_data_region` VALUES (216, '旺泉', 4, '110113', '110113013', 'w');
INSERT INTO `sys_data_region` VALUES (217, '高丽营', 4, '110113', '110113101', 'g');
INSERT INTO `sys_data_region` VALUES (218, '李桥', 4, '110113', '110113104', 'l');
INSERT INTO `sys_data_region` VALUES (219, '李遂', 4, '110113', '110113105', 'l');
INSERT INTO `sys_data_region` VALUES (220, '南彩', 4, '110113', '110113106', 'n');
INSERT INTO `sys_data_region` VALUES (221, '北务', 4, '110113', '110113108', 'b');
INSERT INTO `sys_data_region` VALUES (222, '大孙各庄', 4, '110113', '110113109', 'd');
INSERT INTO `sys_data_region` VALUES (223, '张镇', 4, '110113', '110113110', 'z');
INSERT INTO `sys_data_region` VALUES (224, '龙湾屯', 4, '110113', '110113111', 'l');
INSERT INTO `sys_data_region` VALUES (225, '木林', 4, '110113', '110113112', 'm');
INSERT INTO `sys_data_region` VALUES (226, '北小营', 4, '110113', '110113113', 'b');
INSERT INTO `sys_data_region` VALUES (227, '北石槽', 4, '110113', '110113115', 'b');
INSERT INTO `sys_data_region` VALUES (228, '赵全营', 4, '110113', '110113116', 'z');
INSERT INTO `sys_data_region` VALUES (229, '仁和', 4, '110113', '110113117', 'r');
INSERT INTO `sys_data_region` VALUES (230, '后沙峪', 4, '110113', '110113118', 'h');
INSERT INTO `sys_data_region` VALUES (231, '天竺', 4, '110113', '110113119', 't');
INSERT INTO `sys_data_region` VALUES (232, '杨镇', 4, '110113', '110113120', 'y');
INSERT INTO `sys_data_region` VALUES (233, '牛栏山', 4, '110113', '110113121', 'n');
INSERT INTO `sys_data_region` VALUES (234, '南法信', 4, '110113', '110113122', 'n');
INSERT INTO `sys_data_region` VALUES (235, '马坡', 4, '110113', '110113123', 'm');
INSERT INTO `sys_data_region` VALUES (236, '昌平', 3, '1101', '110114', 'c');
INSERT INTO `sys_data_region` VALUES (237, '城北', 4, '110114', '110114001', 'c');
INSERT INTO `sys_data_region` VALUES (238, '城南', 4, '110114', '110114005', 'c');
INSERT INTO `sys_data_region` VALUES (239, '天通苑北', 4, '110114', '110114006', 't');
INSERT INTO `sys_data_region` VALUES (240, '天通苑南', 4, '110114', '110114007', 't');
INSERT INTO `sys_data_region` VALUES (241, '霍营', 4, '110114', '110114008', 'h');
INSERT INTO `sys_data_region` VALUES (242, '回龙观', 4, '110114', '110114009', 'h');
INSERT INTO `sys_data_region` VALUES (243, '龙泽园', 4, '110114', '110114010', 'l');
INSERT INTO `sys_data_region` VALUES (244, '史各庄', 4, '110114', '110114011', 's');
INSERT INTO `sys_data_region` VALUES (245, '阳坊', 4, '110114', '110114104', 'y');
INSERT INTO `sys_data_region` VALUES (246, '小汤山', 4, '110114', '110114110', 'x');
INSERT INTO `sys_data_region` VALUES (247, '南邵', 4, '110114', '110114111', 'n');
INSERT INTO `sys_data_region` VALUES (248, '崔村', 4, '110114', '110114112', 'c');
INSERT INTO `sys_data_region` VALUES (249, '百善', 4, '110114', '110114113', 'b');
INSERT INTO `sys_data_region` VALUES (250, '北七家', 4, '110114', '110114115', 'b');
INSERT INTO `sys_data_region` VALUES (251, '兴寿', 4, '110114', '110114116', 'x');
INSERT INTO `sys_data_region` VALUES (252, '流村', 4, '110114', '110114118', 'l');
INSERT INTO `sys_data_region` VALUES (253, '十三陵', 4, '110114', '110114119', 's');
INSERT INTO `sys_data_region` VALUES (254, '延寿', 4, '110114', '110114120', 'y');
INSERT INTO `sys_data_region` VALUES (255, '南口', 4, '110114', '110114121', 'n');
INSERT INTO `sys_data_region` VALUES (256, '马池口', 4, '110114', '110114122', 'm');
INSERT INTO `sys_data_region` VALUES (257, '沙河', 4, '110114', '110114123', 's');
INSERT INTO `sys_data_region` VALUES (258, '东小口', 4, '110114', '110114125', 'd');
INSERT INTO `sys_data_region` VALUES (259, '大兴', 3, '1101', '110115', 'd');
INSERT INTO `sys_data_region` VALUES (260, '兴丰', 4, '110115', '110115001', 'x');
INSERT INTO `sys_data_region` VALUES (261, '林校路', 4, '110115', '110115002', 'l');
INSERT INTO `sys_data_region` VALUES (262, '清源', 4, '110115', '110115003', 'q');
INSERT INTO `sys_data_region` VALUES (263, '观音寺', 4, '110115', '110115009', 'g');
INSERT INTO `sys_data_region` VALUES (264, '天宫院', 4, '110115', '110115010', 't');
INSERT INTO `sys_data_region` VALUES (265, '高米店', 4, '110115', '110115011', 'g');
INSERT INTO `sys_data_region` VALUES (266, '荣华', 4, '110115', '110115012', 'r');
INSERT INTO `sys_data_region` VALUES (267, '博兴', 4, '110115', '110115013', 'b');
INSERT INTO `sys_data_region` VALUES (268, '青云店', 4, '110115', '110115103', 'q');
INSERT INTO `sys_data_region` VALUES (269, '采育', 4, '110115', '110115104', 'c');
INSERT INTO `sys_data_region` VALUES (270, '安定', 4, '110115', '110115105', 'a');
INSERT INTO `sys_data_region` VALUES (271, '礼贤', 4, '110115', '110115106', 'l');
INSERT INTO `sys_data_region` VALUES (272, '榆垡', 4, '110115', '110115107', 'y');
INSERT INTO `sys_data_region` VALUES (273, '庞各庄', 4, '110115', '110115108', 'p');
INSERT INTO `sys_data_region` VALUES (274, '北臧村', 4, '110115', '110115109', 'b');
INSERT INTO `sys_data_region` VALUES (275, '魏善庄', 4, '110115', '110115110', 'w');
INSERT INTO `sys_data_region` VALUES (276, '长子营', 4, '110115', '110115111', 'z');
INSERT INTO `sys_data_region` VALUES (277, '亦庄', 4, '110115', '110115112', 'y');
INSERT INTO `sys_data_region` VALUES (278, '黄村', 4, '110115', '110115113', 'h');
INSERT INTO `sys_data_region` VALUES (279, '旧宫', 4, '110115', '110115114', 'j');
INSERT INTO `sys_data_region` VALUES (280, '西红门', 4, '110115', '110115115', 'x');
INSERT INTO `sys_data_region` VALUES (281, '瀛海', 4, '110115', '110115116', 'y');
INSERT INTO `sys_data_region` VALUES (282, '怀柔', 3, '1101', '110116', 'h');
INSERT INTO `sys_data_region` VALUES (283, '泉河', 4, '110116', '110116001', 'q');
INSERT INTO `sys_data_region` VALUES (284, '龙山', 4, '110116', '110116002', 'l');
INSERT INTO `sys_data_region` VALUES (285, '北房', 4, '110116', '110116102', 'b');
INSERT INTO `sys_data_region` VALUES (286, '杨宋', 4, '110116', '110116103', 'y');
INSERT INTO `sys_data_region` VALUES (287, '桥梓', 4, '110116', '110116105', 'q');
INSERT INTO `sys_data_region` VALUES (288, '怀北', 4, '110116', '110116106', 'h');
INSERT INTO `sys_data_region` VALUES (289, '汤河口', 4, '110116', '110116107', 't');
INSERT INTO `sys_data_region` VALUES (290, '渤海', 4, '110116', '110116108', 'b');
INSERT INTO `sys_data_region` VALUES (291, '九渡河', 4, '110116', '110116109', 'j');
INSERT INTO `sys_data_region` VALUES (292, '琉璃庙', 4, '110116', '110116110', 'l');
INSERT INTO `sys_data_region` VALUES (293, '宝山', 4, '110116', '110116111', 'b');
INSERT INTO `sys_data_region` VALUES (294, '怀柔镇', 4, '110116', '110116112', 'h');
INSERT INTO `sys_data_region` VALUES (295, '雁栖', 4, '110116', '110116113', 'y');
INSERT INTO `sys_data_region` VALUES (296, '庙城', 4, '110116', '110116114', 'm');
INSERT INTO `sys_data_region` VALUES (297, '长哨营', 4, '110116', '110116211', 'c');
INSERT INTO `sys_data_region` VALUES (298, '喇叭沟门', 4, '110116', '110116213', 'l');
INSERT INTO `sys_data_region` VALUES (299, '平谷', 3, '1101', '110117', 'p');
INSERT INTO `sys_data_region` VALUES (300, '滨河', 4, '110117', '110117001', 'b');
INSERT INTO `sys_data_region` VALUES (301, '兴谷', 4, '110117', '110117002', 'x');
INSERT INTO `sys_data_region` VALUES (302, '东高村', 4, '110117', '110117101', 'd');
INSERT INTO `sys_data_region` VALUES (303, '山东庄', 4, '110117', '110117102', 's');
INSERT INTO `sys_data_region` VALUES (304, '南独乐河', 4, '110117', '110117104', 'n');
INSERT INTO `sys_data_region` VALUES (305, '大华山', 4, '110117', '110117105', 'd');
INSERT INTO `sys_data_region` VALUES (306, '夏各庄', 4, '110117', '110117106', 'x');
INSERT INTO `sys_data_region` VALUES (307, '马昌营', 4, '110117', '110117108', 'm');
INSERT INTO `sys_data_region` VALUES (308, '王辛庄', 4, '110117', '110117110', 'w');
INSERT INTO `sys_data_region` VALUES (309, '大兴庄', 4, '110117', '110117111', 'd');
INSERT INTO `sys_data_region` VALUES (310, '刘家店', 4, '110117', '110117112', 'l');
INSERT INTO `sys_data_region` VALUES (311, '镇罗营', 4, '110117', '110117114', 'z');
INSERT INTO `sys_data_region` VALUES (312, '平谷镇', 4, '110117', '110117115', 'p');
INSERT INTO `sys_data_region` VALUES (313, '峪口', 4, '110117', '110117116', 'y');
INSERT INTO `sys_data_region` VALUES (314, '马坊', 4, '110117', '110117117', 'm');
INSERT INTO `sys_data_region` VALUES (315, '金海湖', 4, '110117', '110117118', 'j');
INSERT INTO `sys_data_region` VALUES (316, '黄松峪', 4, '110117', '110117213', 'h');
INSERT INTO `sys_data_region` VALUES (317, '熊儿寨', 4, '110117', '110117214', 'x');
INSERT INTO `sys_data_region` VALUES (318, '密云', 3, '1101', '110118', 'm');
INSERT INTO `sys_data_region` VALUES (319, '鼓楼', 4, '110118', '110118001', 'g');
INSERT INTO `sys_data_region` VALUES (320, '果园', 4, '110118', '110118002', 'g');
INSERT INTO `sys_data_region` VALUES (321, '密云镇', 4, '110118', '110118100', 'm');
INSERT INTO `sys_data_region` VALUES (322, '溪翁庄', 4, '110118', '110118101', 'x');
INSERT INTO `sys_data_region` VALUES (323, '西田各庄', 4, '110118', '110118102', 'x');
INSERT INTO `sys_data_region` VALUES (324, '十里堡', 4, '110118', '110118103', 's');
INSERT INTO `sys_data_region` VALUES (325, '河南寨', 4, '110118', '110118104', 'h');
INSERT INTO `sys_data_region` VALUES (326, '巨各庄', 4, '110118', '110118105', 'j');
INSERT INTO `sys_data_region` VALUES (327, '穆家峪', 4, '110118', '110118106', 'm');
INSERT INTO `sys_data_region` VALUES (328, '太师屯', 4, '110118', '110118107', 't');
INSERT INTO `sys_data_region` VALUES (329, '高岭', 4, '110118', '110118108', 'g');
INSERT INTO `sys_data_region` VALUES (330, '不老屯', 4, '110118', '110118109', 'b');
INSERT INTO `sys_data_region` VALUES (331, '冯家峪', 4, '110118', '110118110', 'f');
INSERT INTO `sys_data_region` VALUES (332, '古北口', 4, '110118', '110118111', 'g');
INSERT INTO `sys_data_region` VALUES (333, '大城子', 4, '110118', '110118112', 'd');
INSERT INTO `sys_data_region` VALUES (334, '东邵渠', 4, '110118', '110118113', 'd');
INSERT INTO `sys_data_region` VALUES (335, '北庄', 4, '110118', '110118114', 'b');
INSERT INTO `sys_data_region` VALUES (336, '新城子', 4, '110118', '110118115', 'x');
INSERT INTO `sys_data_region` VALUES (337, '石城', 4, '110118', '110118116', 's');
INSERT INTO `sys_data_region` VALUES (338, '檀营满族蒙族', 4, '110118', '110118203', 't');
INSERT INTO `sys_data_region` VALUES (339, '延庆', 3, '1101', '110119', 'y');
INSERT INTO `sys_data_region` VALUES (340, '百泉', 4, '110119', '110119001', 'b');
INSERT INTO `sys_data_region` VALUES (341, '香水园', 4, '110119', '110119002', 'x');
INSERT INTO `sys_data_region` VALUES (342, '儒林', 4, '110119', '110119003', 'r');
INSERT INTO `sys_data_region` VALUES (343, '延庆镇', 4, '110119', '110119100', 'y');
INSERT INTO `sys_data_region` VALUES (344, '康庄', 4, '110119', '110119101', 'k');
INSERT INTO `sys_data_region` VALUES (345, '八达岭', 4, '110119', '110119102', 'b');
INSERT INTO `sys_data_region` VALUES (346, '永宁', 4, '110119', '110119103', 'y');
INSERT INTO `sys_data_region` VALUES (347, '旧县', 4, '110119', '110119104', 'j');
INSERT INTO `sys_data_region` VALUES (348, '张山营', 4, '110119', '110119105', 'z');
INSERT INTO `sys_data_region` VALUES (349, '四海', 4, '110119', '110119106', 's');
INSERT INTO `sys_data_region` VALUES (350, '千家店', 4, '110119', '110119107', 'q');
INSERT INTO `sys_data_region` VALUES (351, '沈家营', 4, '110119', '110119108', 's');
INSERT INTO `sys_data_region` VALUES (352, '大榆树', 4, '110119', '110119109', 'd');
INSERT INTO `sys_data_region` VALUES (353, '井庄', 4, '110119', '110119110', 'j');
INSERT INTO `sys_data_region` VALUES (354, '大庄科', 4, '110119', '110119207', 'd');
INSERT INTO `sys_data_region` VALUES (355, '刘斌堡', 4, '110119', '110119209', 'l');
INSERT INTO `sys_data_region` VALUES (356, '香营', 4, '110119', '110119210', 'x');
INSERT INTO `sys_data_region` VALUES (357, '珍珠泉', 4, '110119', '110119214', 'z');
INSERT INTO `sys_data_region` VALUES (358, '天津', 1, '0', '12', 't');
INSERT INTO `sys_data_region` VALUES (359, '天津', 2, '12', '1201', 't');
INSERT INTO `sys_data_region` VALUES (360, '和平', 3, '1201', '120101', 'h');
INSERT INTO `sys_data_region` VALUES (361, '劝业场', 4, '120101', '120101001', 'q');
INSERT INTO `sys_data_region` VALUES (362, '小白楼', 4, '120101', '120101002', 'x');
INSERT INTO `sys_data_region` VALUES (363, '五大道', 4, '120101', '120101003', 'w');
INSERT INTO `sys_data_region` VALUES (364, '新兴', 4, '120101', '120101004', 'x');
INSERT INTO `sys_data_region` VALUES (365, '南营门', 4, '120101', '120101005', 'n');
INSERT INTO `sys_data_region` VALUES (366, '南市', 4, '120101', '120101006', 'n');
INSERT INTO `sys_data_region` VALUES (367, '河东', 3, '1201', '120102', 'h');
INSERT INTO `sys_data_region` VALUES (368, '大王庄', 4, '120102', '120102001', 'd');
INSERT INTO `sys_data_region` VALUES (369, '大直沽', 4, '120102', '120102002', 'd');
INSERT INTO `sys_data_region` VALUES (370, '中山门', 4, '120102', '120102003', 'z');
INSERT INTO `sys_data_region` VALUES (371, '富民路', 4, '120102', '120102004', 'f');
INSERT INTO `sys_data_region` VALUES (372, '二号桥', 4, '120102', '120102005', 'e');
INSERT INTO `sys_data_region` VALUES (373, '春华', 4, '120102', '120102006', 'c');
INSERT INTO `sys_data_region` VALUES (374, '唐家口', 4, '120102', '120102007', 't');
INSERT INTO `sys_data_region` VALUES (375, '向阳楼', 4, '120102', '120102008', 'x');
INSERT INTO `sys_data_region` VALUES (376, '常州道', 4, '120102', '120102009', 'c');
INSERT INTO `sys_data_region` VALUES (377, '上杭路', 4, '120102', '120102010', 's');
INSERT INTO `sys_data_region` VALUES (378, '东新', 4, '120102', '120102011', 'd');
INSERT INTO `sys_data_region` VALUES (379, '鲁山道', 4, '120102', '120102012', 'l');
INSERT INTO `sys_data_region` VALUES (380, '河西', 3, '1201', '120103', 'h');
INSERT INTO `sys_data_region` VALUES (381, '大营门', 4, '120103', '120103001', 'd');
INSERT INTO `sys_data_region` VALUES (382, '下瓦房', 4, '120103', '120103002', 'x');
INSERT INTO `sys_data_region` VALUES (383, '桃园', 4, '120103', '120103003', 't');
INSERT INTO `sys_data_region` VALUES (384, '挂甲寺', 4, '120103', '120103004', 'g');
INSERT INTO `sys_data_region` VALUES (385, '马场', 4, '120103', '120103005', 'm');
INSERT INTO `sys_data_region` VALUES (386, '越秀路', 4, '120103', '120103006', 'y');
INSERT INTO `sys_data_region` VALUES (387, '友谊路', 4, '120103', '120103007', 'y');
INSERT INTO `sys_data_region` VALUES (388, '天塔', 4, '120103', '120103008', 't');
INSERT INTO `sys_data_region` VALUES (389, '尖山', 4, '120103', '120103009', 'j');
INSERT INTO `sys_data_region` VALUES (390, '陈塘庄', 4, '120103', '120103010', 'c');
INSERT INTO `sys_data_region` VALUES (391, '柳林', 4, '120103', '120103011', 'l');
INSERT INTO `sys_data_region` VALUES (392, '东海', 4, '120103', '120103012', 'd');
INSERT INTO `sys_data_region` VALUES (393, '梅江', 4, '120103', '120103013', 'm');
INSERT INTO `sys_data_region` VALUES (394, '太湖路', 4, '120103', '120103014', 't');
INSERT INTO `sys_data_region` VALUES (395, '南开', 3, '1201', '120104', 'n');
INSERT INTO `sys_data_region` VALUES (396, '长虹', 4, '120104', '120104001', 'c');
INSERT INTO `sys_data_region` VALUES (397, '鼓楼', 4, '120104', '120104002', 'g');
INSERT INTO `sys_data_region` VALUES (398, '兴南', 4, '120104', '120104003', 'x');
INSERT INTO `sys_data_region` VALUES (399, '广开', 4, '120104', '120104004', 'g');
INSERT INTO `sys_data_region` VALUES (400, '万兴', 4, '120104', '120104005', 'w');
INSERT INTO `sys_data_region` VALUES (401, '学府', 4, '120104', '120104006', 'x');
INSERT INTO `sys_data_region` VALUES (402, '向阳路', 4, '120104', '120104007', 'x');
INSERT INTO `sys_data_region` VALUES (403, '嘉陵道', 4, '120104', '120104008', 'j');
INSERT INTO `sys_data_region` VALUES (404, '王顶堤', 4, '120104', '120104009', 'w');
INSERT INTO `sys_data_region` VALUES (405, '水上公园', 4, '120104', '120104010', 's');
INSERT INTO `sys_data_region` VALUES (406, '体育中心', 4, '120104', '120104011', 't');
INSERT INTO `sys_data_region` VALUES (407, '华苑', 4, '120104', '120104012', 'h');
INSERT INTO `sys_data_region` VALUES (408, '河北', 3, '1201', '120105', 'h');
INSERT INTO `sys_data_region` VALUES (409, '光复道', 4, '120105', '120105001', 'g');
INSERT INTO `sys_data_region` VALUES (410, '望海楼', 4, '120105', '120105002', 'w');
INSERT INTO `sys_data_region` VALUES (411, '鸿顺里', 4, '120105', '120105003', 'h');
INSERT INTO `sys_data_region` VALUES (412, '新开河', 4, '120105', '120105004', 'x');
INSERT INTO `sys_data_region` VALUES (413, '铁东路', 4, '120105', '120105005', 't');
INSERT INTO `sys_data_region` VALUES (414, '建昌道', 4, '120105', '120105006', 'j');
INSERT INTO `sys_data_region` VALUES (415, '宁园', 4, '120105', '120105007', 'n');
INSERT INTO `sys_data_region` VALUES (416, '王串场', 4, '120105', '120105008', 'w');
INSERT INTO `sys_data_region` VALUES (417, '江都路', 4, '120105', '120105009', 'j');
INSERT INTO `sys_data_region` VALUES (418, '月牙河', 4, '120105', '120105010', 'y');
INSERT INTO `sys_data_region` VALUES (419, '红桥', 3, '1201', '120106', 'h');
INSERT INTO `sys_data_region` VALUES (420, '西于庄', 4, '120106', '120106001', 'x');
INSERT INTO `sys_data_region` VALUES (421, '咸阳北路', 4, '120106', '120106003', 'x');
INSERT INTO `sys_data_region` VALUES (422, '丁字沽', 4, '120106', '120106004', 'd');
INSERT INTO `sys_data_region` VALUES (423, '西沽', 4, '120106', '120106005', 'x');
INSERT INTO `sys_data_region` VALUES (424, '三条石', 4, '120106', '120106006', 's');
INSERT INTO `sys_data_region` VALUES (425, '邵公庄', 4, '120106', '120106008', 's');
INSERT INTO `sys_data_region` VALUES (426, '芥园', 4, '120106', '120106009', 'j');
INSERT INTO `sys_data_region` VALUES (427, '铃铛阁', 4, '120106', '120106010', 'l');
INSERT INTO `sys_data_region` VALUES (428, '大胡同', 4, '120106', '120106011', 'd');
INSERT INTO `sys_data_region` VALUES (429, '东丽', 3, '1201', '120110', 'd');
INSERT INTO `sys_data_region` VALUES (430, '张贵庄', 4, '120110', '120110001', 'z');
INSERT INTO `sys_data_region` VALUES (431, '丰年村', 4, '120110', '120110002', 'f');
INSERT INTO `sys_data_region` VALUES (432, '万新', 4, '120110', '120110003', 'w');
INSERT INTO `sys_data_region` VALUES (433, '无瑕', 4, '120110', '120110004', 'w');
INSERT INTO `sys_data_region` VALUES (434, '新立', 4, '120110', '120110005', 'x');
INSERT INTO `sys_data_region` VALUES (435, '华明', 4, '120110', '120110006', 'h');
INSERT INTO `sys_data_region` VALUES (436, '金钟', 4, '120110', '120110007', 'j');
INSERT INTO `sys_data_region` VALUES (437, '军粮城', 4, '120110', '120110008', 'j');
INSERT INTO `sys_data_region` VALUES (438, '金桥', 4, '120110', '120110009', 'j');
INSERT INTO `sys_data_region` VALUES (439, '东丽湖', 4, '120110', '120110010', 'd');
INSERT INTO `sys_data_region` VALUES (440, '天津开发区西区', 4, '120110', '120110400', 't');
INSERT INTO `sys_data_region` VALUES (441, '天津航空物流区', 4, '120110', '120110401', 't');
INSERT INTO `sys_data_region` VALUES (442, '天津空港经济区', 4, '120110', '120110402', 't');
INSERT INTO `sys_data_region` VALUES (443, '东丽区开发区', 4, '120110', '120110403', 'd');
INSERT INTO `sys_data_region` VALUES (444, '综合保税区', 4, '120110', '120110405', 'z');
INSERT INTO `sys_data_region` VALUES (445, '滨海新区建设管理委员会', 4, '120110', '120110407', 'b');
INSERT INTO `sys_data_region` VALUES (446, '西青', 3, '1201', '120111', 'x');
INSERT INTO `sys_data_region` VALUES (447, '西营门', 4, '120111', '120111001', 'x');
INSERT INTO `sys_data_region` VALUES (448, '李七庄', 4, '120111', '120111002', 'l');
INSERT INTO `sys_data_region` VALUES (449, '津门湖', 4, '120111', '120111005', 'j');
INSERT INTO `sys_data_region` VALUES (450, '中北', 4, '120111', '120111100', 'z');
INSERT INTO `sys_data_region` VALUES (451, '杨柳青', 4, '120111', '120111101', 'y');
INSERT INTO `sys_data_region` VALUES (452, '辛口', 4, '120111', '120111102', 'x');
INSERT INTO `sys_data_region` VALUES (453, '张家窝', 4, '120111', '120111103', 'z');
INSERT INTO `sys_data_region` VALUES (454, '精武', 4, '120111', '120111104', 'j');
INSERT INTO `sys_data_region` VALUES (455, '大寺', 4, '120111', '120111105', 'd');
INSERT INTO `sys_data_region` VALUES (456, '王稳庄', 4, '120111', '120111106', 'w');
INSERT INTO `sys_data_region` VALUES (457, '开发区西青微电子小区', 4, '120111', '120111400', 'k');
INSERT INTO `sys_data_region` VALUES (458, '新技术产业园区', 4, '120111', '120111401', 'x');
INSERT INTO `sys_data_region` VALUES (459, '西青区开发区', 4, '120111', '120111450', 'x');
INSERT INTO `sys_data_region` VALUES (460, '津南', 3, '1201', '120112', 'j');
INSERT INTO `sys_data_region` VALUES (461, '双林', 4, '120112', '120112002', 's');
INSERT INTO `sys_data_region` VALUES (462, '咸水沽', 4, '120112', '120112100', 'x');
INSERT INTO `sys_data_region` VALUES (463, '葛沽', 4, '120112', '120112101', 'g');
INSERT INTO `sys_data_region` VALUES (464, '小站', 4, '120112', '120112102', 'x');
INSERT INTO `sys_data_region` VALUES (465, '双港', 4, '120112', '120112103', 's');
INSERT INTO `sys_data_region` VALUES (466, '辛庄', 4, '120112', '120112104', 'x');
INSERT INTO `sys_data_region` VALUES (467, '双桥河', 4, '120112', '120112106', 's');
INSERT INTO `sys_data_region` VALUES (468, '八里台', 4, '120112', '120112107', 'b');
INSERT INTO `sys_data_region` VALUES (469, '北闸口', 4, '120112', '120112108', 'b');
INSERT INTO `sys_data_region` VALUES (470, '铁路十八局', 4, '120112', '120112401', 't');
INSERT INTO `sys_data_region` VALUES (471, '津南开发区东区', 4, '120112', '120112404', 'j');
INSERT INTO `sys_data_region` VALUES (472, '津南开发区西区', 4, '120112', '120112405', 'j');
INSERT INTO `sys_data_region` VALUES (473, '海河教育园区', 4, '120112', '120112407', 'h');
INSERT INTO `sys_data_region` VALUES (474, '北辰', 3, '1201', '120113', 'b');
INSERT INTO `sys_data_region` VALUES (475, '果园新村', 4, '120113', '120113001', 'g');
INSERT INTO `sys_data_region` VALUES (476, '集贤里', 4, '120113', '120113002', 'j');
INSERT INTO `sys_data_region` VALUES (477, '普东', 4, '120113', '120113003', 'p');
INSERT INTO `sys_data_region` VALUES (478, '瑞景', 4, '120113', '120113004', 'r');
INSERT INTO `sys_data_region` VALUES (479, '佳荣里', 4, '120113', '120113005', 'j');
INSERT INTO `sys_data_region` VALUES (480, '天穆', 4, '120113', '120113100', 't');
INSERT INTO `sys_data_region` VALUES (481, '北仓', 4, '120113', '120113101', 'b');
INSERT INTO `sys_data_region` VALUES (482, '双街', 4, '120113', '120113102', 's');
INSERT INTO `sys_data_region` VALUES (483, '双口', 4, '120113', '120113103', 's');
INSERT INTO `sys_data_region` VALUES (484, '青光', 4, '120113', '120113104', 'q');
INSERT INTO `sys_data_region` VALUES (485, '宜兴埠', 4, '120113', '120113106', 'y');
INSERT INTO `sys_data_region` VALUES (486, '小淀', 4, '120113', '120113107', 'x');
INSERT INTO `sys_data_region` VALUES (487, '大张庄', 4, '120113', '120113108', 'd');
INSERT INTO `sys_data_region` VALUES (488, '西堤头', 4, '120113', '120113111', 'x');
INSERT INTO `sys_data_region` VALUES (489, '科技园区北区', 4, '120113', '120113400', 'k');
INSERT INTO `sys_data_region` VALUES (490, '科技园区南区', 4, '120113', '120113401', 'k');
INSERT INTO `sys_data_region` VALUES (491, '天津医药医疗器械工业园', 4, '120113', '120113402', 't');
INSERT INTO `sys_data_region` VALUES (492, '天津陆路港物流装备产业园', 4, '120113', '120113403', 't');
INSERT INTO `sys_data_region` VALUES (493, '天津风电产业园', 4, '120113', '120113404', 't');
INSERT INTO `sys_data_region` VALUES (494, '曙光农场', 4, '120113', '120113501', 's');
INSERT INTO `sys_data_region` VALUES (495, '武清', 3, '1201', '120114', 'w');
INSERT INTO `sys_data_region` VALUES (496, '杨村', 4, '120114', '120114001', 'y');
INSERT INTO `sys_data_region` VALUES (497, '下朱庄', 4, '120114', '120114002', 'x');
INSERT INTO `sys_data_region` VALUES (498, '东蒲洼', 4, '120114', '120114003', 'd');
INSERT INTO `sys_data_region` VALUES (499, '黄庄', 4, '120114', '120114004', 'h');
INSERT INTO `sys_data_region` VALUES (500, '徐官屯', 4, '120114', '120114005', 'x');
INSERT INTO `sys_data_region` VALUES (501, '运河西', 4, '120114', '120114006', 'y');
INSERT INTO `sys_data_region` VALUES (502, '梅厂', 4, '120114', '120114101', 'm');
INSERT INTO `sys_data_region` VALUES (503, '大碱厂', 4, '120114', '120114102', 'd');
INSERT INTO `sys_data_region` VALUES (504, '崔黄口', 4, '120114', '120114103', 'c');
INSERT INTO `sys_data_region` VALUES (505, '大良', 4, '120114', '120114104', 'd');
INSERT INTO `sys_data_region` VALUES (506, '下伍旗', 4, '120114', '120114105', 'x');
INSERT INTO `sys_data_region` VALUES (507, '南蔡村', 4, '120114', '120114106', 'n');
INSERT INTO `sys_data_region` VALUES (508, '大孟庄', 4, '120114', '120114107', 'd');
INSERT INTO `sys_data_region` VALUES (509, '泗村店', 4, '120114', '120114108', 's');
INSERT INTO `sys_data_region` VALUES (510, '河西务', 4, '120114', '120114109', 'h');
INSERT INTO `sys_data_region` VALUES (511, '城关', 4, '120114', '120114110', 'c');
INSERT INTO `sys_data_region` VALUES (512, '东马圈', 4, '120114', '120114111', 'd');
INSERT INTO `sys_data_region` VALUES (513, '黄花店', 4, '120114', '120114112', 'h');
INSERT INTO `sys_data_region` VALUES (514, '石各庄', 4, '120114', '120114113', 's');
INSERT INTO `sys_data_region` VALUES (515, '王庆坨', 4, '120114', '120114114', 'w');
INSERT INTO `sys_data_region` VALUES (516, '汊沽港', 4, '120114', '120114115', 'c');
INSERT INTO `sys_data_region` VALUES (517, '河北屯', 4, '120114', '120114116', 'h');
INSERT INTO `sys_data_region` VALUES (518, '上马台', 4, '120114', '120114117', 's');
INSERT INTO `sys_data_region` VALUES (519, '大王古庄', 4, '120114', '120114118', 'd');
INSERT INTO `sys_data_region` VALUES (520, '陈咀', 4, '120114', '120114119', 'c');
INSERT INTO `sys_data_region` VALUES (521, '白古屯', 4, '120114', '120114120', 'b');
INSERT INTO `sys_data_region` VALUES (522, '曹子里', 4, '120114', '120114121', 'c');
INSERT INTO `sys_data_region` VALUES (523, '大黄堡', 4, '120114', '120114122', 'd');
INSERT INTO `sys_data_region` VALUES (524, '豆张庄', 4, '120114', '120114123', 'd');
INSERT INTO `sys_data_region` VALUES (525, '高村', 4, '120114', '120114124', 'g');
INSERT INTO `sys_data_region` VALUES (526, '天津开发区逸仙科学工业园', 4, '120114', '120114400', 't');
INSERT INTO `sys_data_region` VALUES (527, '武清区开发区', 4, '120114', '120114401', 'w');
INSERT INTO `sys_data_region` VALUES (528, '武清商务区', 4, '120114', '120114402', 'w');
INSERT INTO `sys_data_region` VALUES (529, '武清京滨园', 4, '120114', '120114403', 'w');
INSERT INTO `sys_data_region` VALUES (530, '武清汽车园', 4, '120114', '120114405', 'w');
INSERT INTO `sys_data_region` VALUES (531, '武清科技谷', 4, '120114', '120114406', 'w');
INSERT INTO `sys_data_region` VALUES (532, '武清农场', 4, '120114', '120114500', 'w');
INSERT INTO `sys_data_region` VALUES (533, '宝坻', 3, '1201', '120115', 'b');
INSERT INTO `sys_data_region` VALUES (534, '海滨', 4, '120115', '120115001', 'h');
INSERT INTO `sys_data_region` VALUES (535, '宝平', 4, '120115', '120115002', 'b');
INSERT INTO `sys_data_region` VALUES (536, '钰华', 4, '120115', '120115003', 'y');
INSERT INTO `sys_data_region` VALUES (537, '周良', 4, '120115', '120115004', 'z');
INSERT INTO `sys_data_region` VALUES (538, '朝霞', 4, '120115', '120115007', 'z');
INSERT INTO `sys_data_region` VALUES (539, '潮阳', 4, '120115', '120115008', 'c');
INSERT INTO `sys_data_region` VALUES (540, '大口屯', 4, '120115', '120115101', 'd');
INSERT INTO `sys_data_region` VALUES (541, '王卜庄', 4, '120115', '120115103', 'w');
INSERT INTO `sys_data_region` VALUES (542, '方家庄', 4, '120115', '120115104', 'f');
INSERT INTO `sys_data_region` VALUES (543, '林亭口', 4, '120115', '120115105', 'l');
INSERT INTO `sys_data_region` VALUES (544, '八门城', 4, '120115', '120115106', 'b');
INSERT INTO `sys_data_region` VALUES (545, '大钟庄', 4, '120115', '120115107', 'd');
INSERT INTO `sys_data_region` VALUES (546, '新安', 4, '120115', '120115108', 'x');
INSERT INTO `sys_data_region` VALUES (547, '霍各庄', 4, '120115', '120115111', 'h');
INSERT INTO `sys_data_region` VALUES (548, '新开口', 4, '120115', '120115113', 'x');
INSERT INTO `sys_data_region` VALUES (549, '大唐庄', 4, '120115', '120115115', 'd');
INSERT INTO `sys_data_region` VALUES (550, '牛道口', 4, '120115', '120115119', 'n');
INSERT INTO `sys_data_region` VALUES (551, '史各庄', 4, '120115', '120115120', 's');
INSERT INTO `sys_data_region` VALUES (552, '郝各庄', 4, '120115', '120115121', 'h');
INSERT INTO `sys_data_region` VALUES (553, '牛家牌', 4, '120115', '120115123', 'n');
INSERT INTO `sys_data_region` VALUES (554, '尔王庄', 4, '120115', '120115124', 'e');
INSERT INTO `sys_data_region` VALUES (555, '黄庄', 4, '120115', '120115125', 'h');
INSERT INTO `sys_data_region` VALUES (556, '口东', 4, '120115', '120115126', 'k');
INSERT INTO `sys_data_region` VALUES (557, '大白庄', 4, '120115', '120115127', 'd');
INSERT INTO `sys_data_region` VALUES (558, '天宝工业园区', 4, '120115', '120115453', 't');
INSERT INTO `sys_data_region` VALUES (559, '九园工业园区', 4, '120115', '120115454', 'j');
INSERT INTO `sys_data_region` VALUES (560, '京津新城', 4, '120115', '120115455', 'j');
INSERT INTO `sys_data_region` VALUES (561, '里自沽农场', 4, '120115', '120115500', 'l');
INSERT INTO `sys_data_region` VALUES (562, '大钟农场', 4, '120115', '120115502', 'd');
INSERT INTO `sys_data_region` VALUES (563, '滨海新区', 3, '1201', '120116', 'b');
INSERT INTO `sys_data_region` VALUES (564, '杭州道', 4, '120116', '120116005', 'h');
INSERT INTO `sys_data_region` VALUES (565, '新河', 4, '120116', '120116006', 'x');
INSERT INTO `sys_data_region` VALUES (566, '大沽', 4, '120116', '120116007', 'd');
INSERT INTO `sys_data_region` VALUES (567, '新北', 4, '120116', '120116008', 'x');
INSERT INTO `sys_data_region` VALUES (568, '北塘', 4, '120116', '120116009', 'b');
INSERT INTO `sys_data_region` VALUES (569, '胡家园', 4, '120116', '120116011', 'h');
INSERT INTO `sys_data_region` VALUES (570, '泰达', 4, '120116', '120116012', 't');
INSERT INTO `sys_data_region` VALUES (571, '汉沽', 4, '120116', '120116021', 'h');
INSERT INTO `sys_data_region` VALUES (572, '寨上', 4, '120116', '120116022', 'z');
INSERT INTO `sys_data_region` VALUES (573, '古林', 4, '120116', '120116033', 'g');
INSERT INTO `sys_data_region` VALUES (574, '海滨', 4, '120116', '120116034', 'h');
INSERT INTO `sys_data_region` VALUES (575, '塘沽', 4, '120116', '120116036', 't');
INSERT INTO `sys_data_region` VALUES (576, '茶淀', 4, '120116', '120116037', 'c');
INSERT INTO `sys_data_region` VALUES (577, '大港', 4, '120116', '120116038', 'd');
INSERT INTO `sys_data_region` VALUES (578, '新城', 4, '120116', '120116100', 'x');
INSERT INTO `sys_data_region` VALUES (579, '杨家泊', 4, '120116', '120116102', 'y');
INSERT INTO `sys_data_region` VALUES (580, '太平', 4, '120116', '120116105', 't');
INSERT INTO `sys_data_region` VALUES (581, '小王庄', 4, '120116', '120116106', 'x');
INSERT INTO `sys_data_region` VALUES (582, '中塘', 4, '120116', '120116107', 'z');
INSERT INTO `sys_data_region` VALUES (583, '保税区', 4, '120116', '120116401', 'b');
INSERT INTO `sys_data_region` VALUES (584, '天津滨海新区高新技术产业开发区', 4, '120116', '120116402', 't');
INSERT INTO `sys_data_region` VALUES (585, '东疆保税港区', 4, '120116', '120116403', 'd');
INSERT INTO `sys_data_region` VALUES (586, '临港经济区', 4, '120116', '120116405', 'l');
INSERT INTO `sys_data_region` VALUES (587, '中新天津生态城', 4, '120116', '120116406', 'z');
INSERT INTO `sys_data_region` VALUES (588, '南港工业区', 4, '120116', '120116408', 'n');
INSERT INTO `sys_data_region` VALUES (589, '宁河', 3, '1201', '120117', 'n');
INSERT INTO `sys_data_region` VALUES (590, '芦台', 4, '120117', '120117001', 'l');
INSERT INTO `sys_data_region` VALUES (591, '桥北', 4, '120117', '120117002', 'q');
INSERT INTO `sys_data_region` VALUES (592, '宁河镇', 4, '120117', '120117101', 'n');
INSERT INTO `sys_data_region` VALUES (593, '苗庄', 4, '120117', '120117102', 'm');
INSERT INTO `sys_data_region` VALUES (594, '丰台', 4, '120117', '120117103', 'f');
INSERT INTO `sys_data_region` VALUES (595, '岳龙', 4, '120117', '120117104', 'y');
INSERT INTO `sys_data_region` VALUES (596, '板桥', 4, '120117', '120117105', 'b');
INSERT INTO `sys_data_region` VALUES (597, '潘庄', 4, '120117', '120117106', 'p');
INSERT INTO `sys_data_region` VALUES (598, '造甲城', 4, '120117', '120117107', 'z');
INSERT INTO `sys_data_region` VALUES (599, '七里海', 4, '120117', '120117108', 'q');
INSERT INTO `sys_data_region` VALUES (600, '大北涧沽', 4, '120117', '120117109', 'd');
INSERT INTO `sys_data_region` VALUES (601, '东棘坨', 4, '120117', '120117110', 'd');
INSERT INTO `sys_data_region` VALUES (602, '俵口', 4, '120117', '120117111', 'b');
INSERT INTO `sys_data_region` VALUES (603, '廉庄', 4, '120117', '120117112', 'l');
INSERT INTO `sys_data_region` VALUES (604, '北淮淀', 4, '120117', '120117113', 'b');
INSERT INTO `sys_data_region` VALUES (605, '宁河区贸易开发区', 4, '120117', '120117400', 'n');
INSERT INTO `sys_data_region` VALUES (606, '宁河区经济开发区', 4, '120117', '120117401', 'n');
INSERT INTO `sys_data_region` VALUES (607, '宁河县现代产业园区', 4, '120117', '120117451', 'n');
INSERT INTO `sys_data_region` VALUES (608, '天津潘庄工业区', 4, '120117', '120117452', 't');
INSERT INTO `sys_data_region` VALUES (609, '潘庄农场', 4, '120117', '120117500', 'p');
INSERT INTO `sys_data_region` VALUES (610, '静海', 3, '1201', '120118', 'j');
INSERT INTO `sys_data_region` VALUES (611, '静海镇', 4, '120118', '120118100', 'j');
INSERT INTO `sys_data_region` VALUES (612, '唐官屯', 4, '120118', '120118101', 't');
INSERT INTO `sys_data_region` VALUES (613, '独流', 4, '120118', '120118102', 'd');
INSERT INTO `sys_data_region` VALUES (614, '王口', 4, '120118', '120118103', 'w');
INSERT INTO `sys_data_region` VALUES (615, '台头', 4, '120118', '120118104', 't');
INSERT INTO `sys_data_region` VALUES (616, '子牙', 4, '120118', '120118105', 'z');
INSERT INTO `sys_data_region` VALUES (617, '陈官屯', 4, '120118', '120118106', 'c');
INSERT INTO `sys_data_region` VALUES (618, '中旺', 4, '120118', '120118107', 'z');
INSERT INTO `sys_data_region` VALUES (619, '大邱庄', 4, '120118', '120118108', 'd');
INSERT INTO `sys_data_region` VALUES (620, '蔡公庄', 4, '120118', '120118109', 'c');
INSERT INTO `sys_data_region` VALUES (621, '梁头', 4, '120118', '120118110', 'l');
INSERT INTO `sys_data_region` VALUES (622, '团泊', 4, '120118', '120118111', 't');
INSERT INTO `sys_data_region` VALUES (623, '双塘', 4, '120118', '120118112', 's');
INSERT INTO `sys_data_region` VALUES (624, '大丰堆', 4, '120118', '120118113', 'd');
INSERT INTO `sys_data_region` VALUES (625, '沿庄', 4, '120118', '120118114', 'y');
INSERT INTO `sys_data_region` VALUES (626, '西翟庄', 4, '120118', '120118115', 'x');
INSERT INTO `sys_data_region` VALUES (627, '良王庄', 4, '120118', '120118200', 'l');
INSERT INTO `sys_data_region` VALUES (628, '杨成庄', 4, '120118', '120118201', 'y');
INSERT INTO `sys_data_region` VALUES (629, '天津静海经济开发区', 4, '120118', '120118400', 't');
INSERT INTO `sys_data_region` VALUES (630, '天津子牙工业园区', 4, '120118', '120118402', 't');
INSERT INTO `sys_data_region` VALUES (631, '团泊新城', 4, '120118', '120118403', 't');
INSERT INTO `sys_data_region` VALUES (632, '蓟州', 3, '1201', '120119', 'j');
INSERT INTO `sys_data_region` VALUES (633, '文昌', 4, '120119', '120119001', 'w');
INSERT INTO `sys_data_region` VALUES (634, '渔阳', 4, '120119', '120119100', 'y');
INSERT INTO `sys_data_region` VALUES (635, '洇溜', 4, '120119', '120119101', 'y');
INSERT INTO `sys_data_region` VALUES (636, '官庄', 4, '120119', '120119102', 'g');
INSERT INTO `sys_data_region` VALUES (637, '马伸桥', 4, '120119', '120119103', 'm');
INSERT INTO `sys_data_region` VALUES (638, '下营', 4, '120119', '120119104', 'x');
INSERT INTO `sys_data_region` VALUES (639, '邦均', 4, '120119', '120119105', 'b');
INSERT INTO `sys_data_region` VALUES (640, '别山', 4, '120119', '120119106', 'b');
INSERT INTO `sys_data_region` VALUES (641, '尤古庄', 4, '120119', '120119108', 'y');
INSERT INTO `sys_data_region` VALUES (642, '上仓', 4, '120119', '120119109', 's');
INSERT INTO `sys_data_region` VALUES (643, '下仓', 4, '120119', '120119111', 'x');
INSERT INTO `sys_data_region` VALUES (644, '罗庄子', 4, '120119', '120119112', 'l');
INSERT INTO `sys_data_region` VALUES (645, '白涧', 4, '120119', '120119113', 'b');
INSERT INTO `sys_data_region` VALUES (646, '侯家营', 4, '120119', '120119115', 'h');
INSERT INTO `sys_data_region` VALUES (647, '桑梓', 4, '120119', '120119116', 's');
INSERT INTO `sys_data_region` VALUES (648, '东施古', 4, '120119', '120119117', 'd');
INSERT INTO `sys_data_region` VALUES (649, '下窝头', 4, '120119', '120119118', 'x');
INSERT INTO `sys_data_region` VALUES (650, '杨津庄', 4, '120119', '120119119', 'y');
INSERT INTO `sys_data_region` VALUES (651, '出头岭', 4, '120119', '120119120', 'c');
INSERT INTO `sys_data_region` VALUES (652, '西龙虎峪', 4, '120119', '120119121', 'x');
INSERT INTO `sys_data_region` VALUES (653, '穿芳峪', 4, '120119', '120119122', 'c');
INSERT INTO `sys_data_region` VALUES (654, '东二营', 4, '120119', '120119123', 'd');
INSERT INTO `sys_data_region` VALUES (655, '许家台', 4, '120119', '120119124', 'x');
INSERT INTO `sys_data_region` VALUES (656, '礼明庄', 4, '120119', '120119125', 'l');
INSERT INTO `sys_data_region` VALUES (657, '东赵各庄', 4, '120119', '120119126', 'd');
INSERT INTO `sys_data_region` VALUES (658, '州河湾', 4, '120119', '120119127', 'z');
INSERT INTO `sys_data_region` VALUES (659, '孙各庄', 4, '120119', '120119203', 's');
INSERT INTO `sys_data_region` VALUES (660, '河北', 1, '0', '13', 'h');
INSERT INTO `sys_data_region` VALUES (661, '石家庄', 2, '13', '1301', 's');
INSERT INTO `sys_data_region` VALUES (662, '长安', 3, '1301', '130102', 'c');
INSERT INTO `sys_data_region` VALUES (663, '建北', 4, '130102', '130102001', 'j');
INSERT INTO `sys_data_region` VALUES (664, '青园', 4, '130102', '130102002', 'q');
INSERT INTO `sys_data_region` VALUES (665, '广安', 4, '130102', '130102003', 'g');
INSERT INTO `sys_data_region` VALUES (666, '育才', 4, '130102', '130102004', 'y');
INSERT INTO `sys_data_region` VALUES (667, '跃进', 4, '130102', '130102005', 'y');
INSERT INTO `sys_data_region` VALUES (668, '河东', 4, '130102', '130102007', 'h');
INSERT INTO `sys_data_region` VALUES (669, '长丰', 4, '130102', '130102010', 'c');
INSERT INTO `sys_data_region` VALUES (670, '谈固', 4, '130102', '130102011', 't');
INSERT INTO `sys_data_region` VALUES (671, '中山东路', 4, '130102', '130102012', 'z');
INSERT INTO `sys_data_region` VALUES (672, '阜康', 4, '130102', '130102013', 'f');
INSERT INTO `sys_data_region` VALUES (673, '建安', 4, '130102', '130102014', 'j');
INSERT INTO `sys_data_region` VALUES (674, '胜北', 4, '130102', '130102015', 's');
INSERT INTO `sys_data_region` VALUES (675, '西兆通', 4, '130102', '130102100', 'x');
INSERT INTO `sys_data_region` VALUES (676, '南村', 4, '130102', '130102101', 'n');
INSERT INTO `sys_data_region` VALUES (677, '高营', 4, '130102', '130102102', 'g');
INSERT INTO `sys_data_region` VALUES (678, '桃园', 4, '130102', '130102103', 't');
INSERT INTO `sys_data_region` VALUES (679, '桥西', 3, '1301', '130104', 'q');
INSERT INTO `sys_data_region` VALUES (680, '东里', 4, '130104', '130104001', 'd');
INSERT INTO `sys_data_region` VALUES (681, '中山', 4, '130104', '130104002', 'z');
INSERT INTO `sys_data_region` VALUES (682, '南长', 4, '130104', '130104004', 'n');
INSERT INTO `sys_data_region` VALUES (683, '维明', 4, '130104', '130104005', 'w');
INSERT INTO `sys_data_region` VALUES (684, '友谊', 4, '130104', '130104007', 'y');
INSERT INTO `sys_data_region` VALUES (685, '红旗', 4, '130104', '130104008', 'h');
INSERT INTO `sys_data_region` VALUES (686, '新石', 4, '130104', '130104009', 'x');
INSERT INTO `sys_data_region` VALUES (687, '苑东', 4, '130104', '130104010', 'y');
INSERT INTO `sys_data_region` VALUES (688, '西里', 4, '130104', '130104011', 'x');
INSERT INTO `sys_data_region` VALUES (689, '振头', 4, '130104', '130104012', 'z');
INSERT INTO `sys_data_region` VALUES (690, '留营', 4, '130104', '130104013', 'l');
INSERT INTO `sys_data_region` VALUES (691, '长兴', 4, '130104', '130104014', 'c');
INSERT INTO `sys_data_region` VALUES (692, '东华', 4, '130104', '130104015', 'd');
INSERT INTO `sys_data_region` VALUES (693, '休门', 4, '130104', '130104016', 'x');
INSERT INTO `sys_data_region` VALUES (694, '彭后', 4, '130104', '130104017', 'p');
INSERT INTO `sys_data_region` VALUES (695, '东风', 4, '130104', '130104018', 'd');
INSERT INTO `sys_data_region` VALUES (696, '汇通', 4, '130104', '130104019', 'h');
INSERT INTO `sys_data_region` VALUES (697, '新华', 3, '1301', '130105', 'x');
INSERT INTO `sys_data_region` VALUES (698, '革新街', 4, '130105', '130105001', 'g');
INSERT INTO `sys_data_region` VALUES (699, '新华路', 4, '130105', '130105003', 'x');
INSERT INTO `sys_data_region` VALUES (700, '宁安', 4, '130105', '130105004', 'n');
INSERT INTO `sys_data_region` VALUES (701, '东焦', 4, '130105', '130105005', 'd');
INSERT INTO `sys_data_region` VALUES (702, '西苑', 4, '130105', '130105006', 'x');
INSERT INTO `sys_data_region` VALUES (703, '合作路', 4, '130105', '130105007', 'h');
INSERT INTO `sys_data_region` VALUES (704, '联盟', 4, '130105', '130105008', 'l');
INSERT INTO `sys_data_region` VALUES (705, '石岗', 4, '130105', '130105009', 's');
INSERT INTO `sys_data_region` VALUES (706, '天苑', 4, '130105', '130105011', 't');
INSERT INTO `sys_data_region` VALUES (707, '北苑', 4, '130105', '130105012', 'b');
INSERT INTO `sys_data_region` VALUES (708, '赵陵铺路', 4, '130105', '130105013', 'z');
INSERT INTO `sys_data_region` VALUES (709, '赵佗路', 4, '130105', '130105014', 'z');
INSERT INTO `sys_data_region` VALUES (710, '大郭', 4, '130105', '130105015', 'd');
INSERT INTO `sys_data_region` VALUES (711, '西三庄', 4, '130105', '130105016', 'x');
INSERT INTO `sys_data_region` VALUES (712, '杜北', 4, '130105', '130105017', 'd');
INSERT INTO `sys_data_region` VALUES (713, '井陉矿区', 3, '1301', '130107', 'j');
INSERT INTO `sys_data_region` VALUES (714, '矿市', 4, '130107', '130107001', 'k');
INSERT INTO `sys_data_region` VALUES (715, '四微', 4, '130107', '130107002', 's');
INSERT INTO `sys_data_region` VALUES (716, '贾庄', 4, '130107', '130107100', 'j');
INSERT INTO `sys_data_region` VALUES (717, '凤山', 4, '130107', '130107101', 'f');
INSERT INTO `sys_data_region` VALUES (718, '横涧', 4, '130107', '130107200', 'h');
INSERT INTO `sys_data_region` VALUES (719, '裕华', 3, '1301', '130108', 'y');
INSERT INTO `sys_data_region` VALUES (720, '裕兴', 4, '130108', '130108001', 'y');
INSERT INTO `sys_data_region` VALUES (721, '裕强', 4, '130108', '130108002', 'y');
INSERT INTO `sys_data_region` VALUES (722, '东苑', 4, '130108', '130108003', 'd');
INSERT INTO `sys_data_region` VALUES (723, '建通', 4, '130108', '130108004', 'j');
INSERT INTO `sys_data_region` VALUES (724, '槐底', 4, '130108', '130108005', 'h');
INSERT INTO `sys_data_region` VALUES (725, '裕华路', 4, '130108', '130108006', 'y');
INSERT INTO `sys_data_region` VALUES (726, '裕东', 4, '130108', '130108007', 'y');
INSERT INTO `sys_data_region` VALUES (727, '长江', 4, '130108', '130108008', 'c');
INSERT INTO `sys_data_region` VALUES (728, '太行', 4, '130108', '130108009', 't');
INSERT INTO `sys_data_region` VALUES (729, '裕翔', 4, '130108', '130108010', 'y');
INSERT INTO `sys_data_region` VALUES (730, '建华南', 4, '130108', '130108011', 'j');
INSERT INTO `sys_data_region` VALUES (731, '宋营', 4, '130108', '130108100', 's');
INSERT INTO `sys_data_region` VALUES (732, '方村', 4, '130108', '130108101', 'f');
INSERT INTO `sys_data_region` VALUES (733, '藁城', 3, '1301', '130109', 'g');
INSERT INTO `sys_data_region` VALUES (734, '廉州', 4, '130109', '130109100', 'l');
INSERT INTO `sys_data_region` VALUES (735, '兴安', 4, '130109', '130109101', 'x');
INSERT INTO `sys_data_region` VALUES (736, '贾市庄', 4, '130109', '130109102', 'j');
INSERT INTO `sys_data_region` VALUES (737, '南营', 4, '130109', '130109103', 'n');
INSERT INTO `sys_data_region` VALUES (738, '梅花', 4, '130109', '130109104', 'm');
INSERT INTO `sys_data_region` VALUES (739, '岗上', 4, '130109', '130109105', 'g');
INSERT INTO `sys_data_region` VALUES (740, '丘头', 4, '130109', '130109106', 'q');
INSERT INTO `sys_data_region` VALUES (741, '南董', 4, '130109', '130109107', 'n');
INSERT INTO `sys_data_region` VALUES (742, '张家庄', 4, '130109', '130109108', 'z');
INSERT INTO `sys_data_region` VALUES (743, '南孟', 4, '130109', '130109109', 'n');
INSERT INTO `sys_data_region` VALUES (744, '增村', 4, '130109', '130109110', 'z');
INSERT INTO `sys_data_region` VALUES (745, '常安', 4, '130109', '130109111', 'c');
INSERT INTO `sys_data_region` VALUES (746, '西关', 4, '130109', '130109112', 'x');
INSERT INTO `sys_data_region` VALUES (747, '九门', 4, '130109', '130109200', 'j');
INSERT INTO `sys_data_region` VALUES (748, '鹿泉', 3, '1301', '130110', 'l');
INSERT INTO `sys_data_region` VALUES (749, '获鹿', 4, '130110', '130110100', 'h');
INSERT INTO `sys_data_region` VALUES (750, '铜冶', 4, '130110', '130110101', 't');
INSERT INTO `sys_data_region` VALUES (751, '寺家庄', 4, '130110', '130110102', 's');
INSERT INTO `sys_data_region` VALUES (752, '上庄', 4, '130110', '130110103', 's');
INSERT INTO `sys_data_region` VALUES (753, '李村', 4, '130110', '130110104', 'l');
INSERT INTO `sys_data_region` VALUES (754, '宜安', 4, '130110', '130110105', 'y');
INSERT INTO `sys_data_region` VALUES (755, '黄壁庄', 4, '130110', '130110106', 'h');
INSERT INTO `sys_data_region` VALUES (756, '大河', 4, '130110', '130110107', 'd');
INSERT INTO `sys_data_region` VALUES (757, '山尹村', 4, '130110', '130110108', 's');
INSERT INTO `sys_data_region` VALUES (758, '石井', 4, '130110', '130110200', 's');
INSERT INTO `sys_data_region` VALUES (759, '白鹿泉', 4, '130110', '130110201', 'b');
INSERT INTO `sys_data_region` VALUES (760, '上寨', 4, '130110', '130110202', 's');
INSERT INTO `sys_data_region` VALUES (761, '河北鹿泉经济开发区', 4, '130110', '130110500', 'h');
INSERT INTO `sys_data_region` VALUES (762, '栾城', 3, '1301', '130111', 'l');
INSERT INTO `sys_data_region` VALUES (763, '栾城镇', 4, '130111', '130111100', 'l');
INSERT INTO `sys_data_region` VALUES (764, '郄马', 4, '130111', '130111101', 'q');
INSERT INTO `sys_data_region` VALUES (765, '冶河', 4, '130111', '130111102', 'y');
INSERT INTO `sys_data_region` VALUES (766, '窦妪', 4, '130111', '130111103', 'd');
INSERT INTO `sys_data_region` VALUES (767, '楼底', 4, '130111', '130111104', 'l');
INSERT INTO `sys_data_region` VALUES (768, '南高', 4, '130111', '130111200', 'n');
INSERT INTO `sys_data_region` VALUES (769, '柳林屯', 4, '130111', '130111201', 'l');
INSERT INTO `sys_data_region` VALUES (770, '西营', 4, '130111', '130111202', 'x');
INSERT INTO `sys_data_region` VALUES (771, '井陉', 3, '1301', '130121', 'j');
INSERT INTO `sys_data_region` VALUES (772, '微水', 4, '130121', '130121100', 'w');
INSERT INTO `sys_data_region` VALUES (773, '上安', 4, '130121', '130121101', 's');
INSERT INTO `sys_data_region` VALUES (774, '天长', 4, '130121', '130121102', 't');
INSERT INTO `sys_data_region` VALUES (775, '秀林', 4, '130121', '130121103', 'x');
INSERT INTO `sys_data_region` VALUES (776, '南峪', 4, '130121', '130121104', 'n');
INSERT INTO `sys_data_region` VALUES (777, '威州', 4, '130121', '130121105', 'w');
INSERT INTO `sys_data_region` VALUES (778, '小作', 4, '130121', '130121106', 'x');
INSERT INTO `sys_data_region` VALUES (779, '南障城', 4, '130121', '130121107', 'n');
INSERT INTO `sys_data_region` VALUES (780, '苍岩山', 4, '130121', '130121108', 'c');
INSERT INTO `sys_data_region` VALUES (781, '测鱼', 4, '130121', '130121109', 'c');
INSERT INTO `sys_data_region` VALUES (782, '吴家窑', 4, '130121', '130121200', 'w');
INSERT INTO `sys_data_region` VALUES (783, '北正', 4, '130121', '130121201', 'b');
INSERT INTO `sys_data_region` VALUES (784, '于家', 4, '130121', '130121202', 'y');
INSERT INTO `sys_data_region` VALUES (785, '孙庄', 4, '130121', '130121203', 's');
INSERT INTO `sys_data_region` VALUES (786, '南陉', 4, '130121', '130121204', 'n');
INSERT INTO `sys_data_region` VALUES (787, '辛庄', 4, '130121', '130121205', 'x');
INSERT INTO `sys_data_region` VALUES (788, '南王庄', 4, '130121', '130121206', 'n');
INSERT INTO `sys_data_region` VALUES (789, '正定', 3, '1301', '130123', 'z');
INSERT INTO `sys_data_region` VALUES (790, '诸福屯', 4, '130123', '130123001', 'z');
INSERT INTO `sys_data_region` VALUES (791, '三里屯', 4, '130123', '130123002', 's');
INSERT INTO `sys_data_region` VALUES (792, '正定镇', 4, '130123', '130123100', 'z');
INSERT INTO `sys_data_region` VALUES (793, '新城铺', 4, '130123', '130123102', 'x');
INSERT INTO `sys_data_region` VALUES (794, '新安', 4, '130123', '130123103', 'x');
INSERT INTO `sys_data_region` VALUES (795, '南岗', 4, '130123', '130123104', 'n');
INSERT INTO `sys_data_region` VALUES (796, '曲阳桥', 4, '130123', '130123105', 'q');
INSERT INTO `sys_data_region` VALUES (797, '南牛', 4, '130123', '130123200', 'n');
INSERT INTO `sys_data_region` VALUES (798, '南楼', 4, '130123', '130123201', 'n');
INSERT INTO `sys_data_region` VALUES (799, '西平乐', 4, '130123', '130123202', 'x');
INSERT INTO `sys_data_region` VALUES (800, '行唐', 3, '1301', '130125', 'x');
INSERT INTO `sys_data_region` VALUES (801, '龙州', 4, '130125', '130125100', 'l');
INSERT INTO `sys_data_region` VALUES (802, '南桥', 4, '130125', '130125101', 'n');
INSERT INTO `sys_data_region` VALUES (803, '上碑', 4, '130125', '130125102', 's');
INSERT INTO `sys_data_region` VALUES (804, '口头', 4, '130125', '130125103', 'k');
INSERT INTO `sys_data_region` VALUES (805, '独羊岗', 4, '130125', '130125200', 'd');
INSERT INTO `sys_data_region` VALUES (806, '安香', 4, '130125', '130125201', 'a');
INSERT INTO `sys_data_region` VALUES (807, '只里', 4, '130125', '130125202', 'z');
INSERT INTO `sys_data_region` VALUES (808, '市同', 4, '130125', '130125203', 's');
INSERT INTO `sys_data_region` VALUES (809, '翟营', 4, '130125', '130125204', 'd');
INSERT INTO `sys_data_region` VALUES (810, '城寨', 4, '130125', '130125205', 'c');
INSERT INTO `sys_data_region` VALUES (811, '上方', 4, '130125', '130125206', 's');
INSERT INTO `sys_data_region` VALUES (812, '玉亭', 4, '130125', '130125207', 'y');
INSERT INTO `sys_data_region` VALUES (813, '北河', 4, '130125', '130125208', 'b');
INSERT INTO `sys_data_region` VALUES (814, '上阎庄', 4, '130125', '130125209', 's');
INSERT INTO `sys_data_region` VALUES (815, '九口子', 4, '130125', '130125210', 'j');
INSERT INTO `sys_data_region` VALUES (816, '灵寿', 3, '1301', '130126', 'l');
INSERT INTO `sys_data_region` VALUES (817, '灵寿镇', 4, '130126', '130126100', 'l');
INSERT INTO `sys_data_region` VALUES (818, '青同', 4, '130126', '130126101', 'q');
INSERT INTO `sys_data_region` VALUES (819, '塔上', 4, '130126', '130126102', 't');
INSERT INTO `sys_data_region` VALUES (820, '陈庄', 4, '130126', '130126103', 'c');
INSERT INTO `sys_data_region` VALUES (821, '慈峪', 4, '130126', '130126104', 'c');
INSERT INTO `sys_data_region` VALUES (822, '岔头', 4, '130126', '130126105', 'c');
INSERT INTO `sys_data_region` VALUES (823, '三圣院', 4, '130126', '130126200', 's');
INSERT INTO `sys_data_region` VALUES (824, '北洼', 4, '130126', '130126201', 'b');
INSERT INTO `sys_data_region` VALUES (825, '牛城', 4, '130126', '130126202', 'n');
INSERT INTO `sys_data_region` VALUES (826, '狗台', 4, '130126', '130126203', 'g');
INSERT INTO `sys_data_region` VALUES (827, '南寨', 4, '130126', '130126204', 'n');
INSERT INTO `sys_data_region` VALUES (828, '南燕川', 4, '130126', '130126205', 'n');
INSERT INTO `sys_data_region` VALUES (829, '北谭庄', 4, '130126', '130126206', 'b');
INSERT INTO `sys_data_region` VALUES (830, '寨头', 4, '130126', '130126207', 'z');
INSERT INTO `sys_data_region` VALUES (831, '南营', 4, '130126', '130126208', 'n');
INSERT INTO `sys_data_region` VALUES (832, '高邑', 3, '1301', '130127', 'g');
INSERT INTO `sys_data_region` VALUES (833, '高邑镇', 4, '130127', '130127100', 'g');
INSERT INTO `sys_data_region` VALUES (834, '大营', 4, '130127', '130127101', 'd');
INSERT INTO `sys_data_region` VALUES (835, '富村', 4, '130127', '130127102', 'f');
INSERT INTO `sys_data_region` VALUES (836, '万城', 4, '130127', '130127103', 'w');
INSERT INTO `sys_data_region` VALUES (837, '中韩', 4, '130127', '130127104', 'z');
INSERT INTO `sys_data_region` VALUES (838, '深泽', 3, '1301', '130128', 's');
INSERT INTO `sys_data_region` VALUES (839, '深泽镇', 4, '130128', '130128100', 's');
INSERT INTO `sys_data_region` VALUES (840, '铁杆', 4, '130128', '130128101', 't');
INSERT INTO `sys_data_region` VALUES (841, '赵八', 4, '130128', '130128102', 'z');
INSERT INTO `sys_data_region` VALUES (842, '大桥头', 4, '130128', '130128103', 'd');
INSERT INTO `sys_data_region` VALUES (843, '白庄', 4, '130128', '130128200', 'b');
INSERT INTO `sys_data_region` VALUES (844, '留村', 4, '130128', '130128201', 'l');
INSERT INTO `sys_data_region` VALUES (845, '赞皇', 3, '1301', '130129', 'z');
INSERT INTO `sys_data_region` VALUES (846, '赞皇镇', 4, '130129', '130129100', 'z');
INSERT INTO `sys_data_region` VALUES (847, '院头', 4, '130129', '130129101', 'y');
INSERT INTO `sys_data_region` VALUES (848, '南邢郭', 4, '130129', '130129102', 'n');
INSERT INTO `sys_data_region` VALUES (849, '嶂石岩', 4, '130129', '130129103', 'z');
INSERT INTO `sys_data_region` VALUES (850, '西龙门', 4, '130129', '130129200', 'x');
INSERT INTO `sys_data_region` VALUES (851, '南清河', 4, '130129', '130129202', 'n');
INSERT INTO `sys_data_region` VALUES (852, '西阳泽', 4, '130129', '130129203', 'x');
INSERT INTO `sys_data_region` VALUES (853, '土门', 4, '130129', '130129204', 't');
INSERT INTO `sys_data_region` VALUES (854, '黄北坪', 4, '130129', '130129205', 'h');
INSERT INTO `sys_data_region` VALUES (855, '许亭', 4, '130129', '130129207', 'x');
INSERT INTO `sys_data_region` VALUES (856, '张楞', 4, '130129', '130129208', 'z');
INSERT INTO `sys_data_region` VALUES (857, '无极', 3, '1301', '130130', 'w');
INSERT INTO `sys_data_region` VALUES (858, '无极镇', 4, '130130', '130130100', 'w');
INSERT INTO `sys_data_region` VALUES (859, '七汲', 4, '130130', '130130101', 'q');
INSERT INTO `sys_data_region` VALUES (860, '张段固', 4, '130130', '130130102', 'z');
INSERT INTO `sys_data_region` VALUES (861, '北苏', 4, '130130', '130130103', 'b');
INSERT INTO `sys_data_region` VALUES (862, '郭庄', 4, '130130', '130130104', 'g');
INSERT INTO `sys_data_region` VALUES (863, '大陈', 4, '130130', '130130105', 'd');
INSERT INTO `sys_data_region` VALUES (864, '高头', 4, '130130', '130130200', 'g');
INSERT INTO `sys_data_region` VALUES (865, '郝庄', 4, '130130', '130130201', 'h');
INSERT INTO `sys_data_region` VALUES (866, '东侯坊', 4, '130130', '130130202', 'd');
INSERT INTO `sys_data_region` VALUES (867, '里城道', 4, '130130', '130130203', 'l');
INSERT INTO `sys_data_region` VALUES (868, '南流', 4, '130130', '130130204', 'n');
INSERT INTO `sys_data_region` VALUES (869, '平山', 3, '1301', '130131', 'p');
INSERT INTO `sys_data_region` VALUES (870, '平山镇', 4, '130131', '130131100', 'p');
INSERT INTO `sys_data_region` VALUES (871, '东回舍', 4, '130131', '130131101', 'd');
INSERT INTO `sys_data_region` VALUES (872, '温塘', 4, '130131', '130131102', 'w');
INSERT INTO `sys_data_region` VALUES (873, '南甸', 4, '130131', '130131103', 'n');
INSERT INTO `sys_data_region` VALUES (874, '岗南', 4, '130131', '130131104', 'g');
INSERT INTO `sys_data_region` VALUES (875, '古月', 4, '130131', '130131105', 'g');
INSERT INTO `sys_data_region` VALUES (876, '下槐', 4, '130131', '130131106', 'x');
INSERT INTO `sys_data_region` VALUES (877, '孟家庄', 4, '130131', '130131107', 'm');
INSERT INTO `sys_data_region` VALUES (878, '小觉', 4, '130131', '130131108', 'x');
INSERT INTO `sys_data_region` VALUES (879, '蛟潭庄', 4, '130131', '130131109', 'j');
INSERT INTO `sys_data_region` VALUES (880, '西柏坡', 4, '130131', '130131110', 'x');
INSERT INTO `sys_data_region` VALUES (881, '下口', 4, '130131', '130131111', 'x');
INSERT INTO `sys_data_region` VALUES (882, '西大吾', 4, '130131', '130131200', 'x');
INSERT INTO `sys_data_region` VALUES (883, '上三汲', 4, '130131', '130131201', 's');
INSERT INTO `sys_data_region` VALUES (884, '两河', 4, '130131', '130131202', 'l');
INSERT INTO `sys_data_region` VALUES (885, '东王坡', 4, '130131', '130131203', 'd');
INSERT INTO `sys_data_region` VALUES (886, '苏家庄', 4, '130131', '130131204', 's');
INSERT INTO `sys_data_region` VALUES (887, '宅北', 4, '130131', '130131205', 'z');
INSERT INTO `sys_data_region` VALUES (888, '北冶', 4, '130131', '130131207', 'b');
INSERT INTO `sys_data_region` VALUES (889, '上观音堂', 4, '130131', '130131209', 's');
INSERT INTO `sys_data_region` VALUES (890, '杨家桥', 4, '130131', '130131210', 'y');
INSERT INTO `sys_data_region` VALUES (891, '营里', 4, '130131', '130131211', 'y');
INSERT INTO `sys_data_region` VALUES (892, '合河口', 4, '130131', '130131212', 'h');
INSERT INTO `sys_data_region` VALUES (893, '元氏', 3, '1301', '130132', 'y');
INSERT INTO `sys_data_region` VALUES (894, '城区', 4, '130132', '130132001', 'c');
INSERT INTO `sys_data_region` VALUES (895, '槐阳', 4, '130132', '130132100', 'h');
INSERT INTO `sys_data_region` VALUES (896, '殷村', 4, '130132', '130132101', 'y');
INSERT INTO `sys_data_region` VALUES (897, '南佐', 4, '130132', '130132102', 'n');
INSERT INTO `sys_data_region` VALUES (898, '宋曹', 4, '130132', '130132103', 's');
INSERT INTO `sys_data_region` VALUES (899, '南因', 4, '130132', '130132104', 'n');
INSERT INTO `sys_data_region` VALUES (900, '姬村', 4, '130132', '130132105', 'j');
INSERT INTO `sys_data_region` VALUES (901, '北褚', 4, '130132', '130132106', 'b');
INSERT INTO `sys_data_region` VALUES (902, '马村', 4, '130132', '130132107', 'm');
INSERT INTO `sys_data_region` VALUES (903, '东张', 4, '130132', '130132201', 'd');
INSERT INTO `sys_data_region` VALUES (904, '赵同', 4, '130132', '130132202', 'z');
INSERT INTO `sys_data_region` VALUES (905, '苏村', 4, '130132', '130132204', 's');
INSERT INTO `sys_data_region` VALUES (906, '苏阳', 4, '130132', '130132205', 's');
INSERT INTO `sys_data_region` VALUES (907, '北正', 4, '130132', '130132206', 'b');
INSERT INTO `sys_data_region` VALUES (908, '前仙', 4, '130132', '130132207', 'q');
INSERT INTO `sys_data_region` VALUES (909, '黑水河', 4, '130132', '130132208', 'h');
INSERT INTO `sys_data_region` VALUES (910, '赵县', 3, '1301', '130133', 'z');
INSERT INTO `sys_data_region` VALUES (911, '赵州', 4, '130133', '130133100', 'z');
INSERT INTO `sys_data_region` VALUES (912, '范庄', 4, '130133', '130133101', 'f');
INSERT INTO `sys_data_region` VALUES (913, '北王里', 4, '130133', '130133102', 'b');
INSERT INTO `sys_data_region` VALUES (914, '新寨店', 4, '130133', '130133103', 'x');
INSERT INTO `sys_data_region` VALUES (915, '韩村', 4, '130133', '130133104', 'h');
INSERT INTO `sys_data_region` VALUES (916, '南柏舍', 4, '130133', '130133105', 'n');
INSERT INTO `sys_data_region` VALUES (917, '沙河店', 4, '130133', '130133106', 's');
INSERT INTO `sys_data_region` VALUES (918, '王西章', 4, '130133', '130133107', 'w');
INSERT INTO `sys_data_region` VALUES (919, '前大章', 4, '130133', '130133200', 'q');
INSERT INTO `sys_data_region` VALUES (920, '谢庄', 4, '130133', '130133201', 'x');
INSERT INTO `sys_data_region` VALUES (921, '高村', 4, '130133', '130133202', 'g');
INSERT INTO `sys_data_region` VALUES (922, '辛集', 3, '1301', '130181', 'x');
INSERT INTO `sys_data_region` VALUES (923, '辛集镇', 4, '130181', '130181100', 'x');
INSERT INTO `sys_data_region` VALUES (924, '旧城', 4, '130181', '130181101', 'j');
INSERT INTO `sys_data_region` VALUES (925, '张古庄', 4, '130181', '130181102', 'z');
INSERT INTO `sys_data_region` VALUES (926, '位伯', 4, '130181', '130181103', 'w');
INSERT INTO `sys_data_region` VALUES (927, '新垒头', 4, '130181', '130181104', 'x');
INSERT INTO `sys_data_region` VALUES (928, '新城', 4, '130181', '130181105', 'x');
INSERT INTO `sys_data_region` VALUES (929, '南智丘', 4, '130181', '130181106', 'n');
INSERT INTO `sys_data_region` VALUES (930, '王口', 4, '130181', '130181107', 'w');
INSERT INTO `sys_data_region` VALUES (931, '天宫营', 4, '130181', '130181200', 't');
INSERT INTO `sys_data_region` VALUES (932, '前营', 4, '130181', '130181201', 'q');
INSERT INTO `sys_data_region` VALUES (933, '马庄', 4, '130181', '130181202', 'm');
INSERT INTO `sys_data_region` VALUES (934, '和睦井', 4, '130181', '130181203', 'h');
INSERT INTO `sys_data_region` VALUES (935, '田家庄', 4, '130181', '130181204', 't');
INSERT INTO `sys_data_region` VALUES (936, '中里厢', 4, '130181', '130181205', 'z');
INSERT INTO `sys_data_region` VALUES (937, '小辛庄', 4, '130181', '130181206', 'x');
INSERT INTO `sys_data_region` VALUES (938, '晋州', 3, '1301', '130183', 'j');
INSERT INTO `sys_data_region` VALUES (939, '晋州镇', 4, '130183', '130183100', 'j');
INSERT INTO `sys_data_region` VALUES (940, '总十庄', 4, '130183', '130183101', 'z');
INSERT INTO `sys_data_region` VALUES (941, '营里', 4, '130183', '130183102', 'y');
INSERT INTO `sys_data_region` VALUES (942, '桃园', 4, '130183', '130183103', 't');
INSERT INTO `sys_data_region` VALUES (943, '东卓宿', 4, '130183', '130183104', 'd');
INSERT INTO `sys_data_region` VALUES (944, '马于', 4, '130183', '130183105', 'm');
INSERT INTO `sys_data_region` VALUES (945, '小樵', 4, '130183', '130183106', 'x');
INSERT INTO `sys_data_region` VALUES (946, '槐树', 4, '130183', '130183107', 'h');
INSERT INTO `sys_data_region` VALUES (947, '东里庄', 4, '130183', '130183108', 'd');
INSERT INTO `sys_data_region` VALUES (948, '周家庄', 4, '130183', '130183201', 'z');
INSERT INTO `sys_data_region` VALUES (949, '新乐', 3, '1301', '130184', 'x');
INSERT INTO `sys_data_region` VALUES (950, '长寿', 4, '130184', '130184001', 'c');
INSERT INTO `sys_data_region` VALUES (951, '化皮', 4, '130184', '130184101', 'h');
INSERT INTO `sys_data_region` VALUES (952, '承安', 4, '130184', '130184102', 'c');
INSERT INTO `sys_data_region` VALUES (953, '正莫', 4, '130184', '130184103', 'z');
INSERT INTO `sys_data_region` VALUES (954, '南大岳', 4, '130184', '130184104', 'n');
INSERT INTO `sys_data_region` VALUES (955, '杜固', 4, '130184', '130184105', 'd');
INSERT INTO `sys_data_region` VALUES (956, '邯邰', 4, '130184', '130184106', 'h');
INSERT INTO `sys_data_region` VALUES (957, '东王', 4, '130184', '130184107', 'd');
INSERT INTO `sys_data_region` VALUES (958, '马头铺', 4, '130184', '130184108', 'm');
INSERT INTO `sys_data_region` VALUES (959, '协神', 4, '130184', '130184200', 'x');
INSERT INTO `sys_data_region` VALUES (960, '木村', 4, '130184', '130184201', 'm');
INSERT INTO `sys_data_region` VALUES (961, '彭家庄', 4, '130184', '130184202', 'p');
INSERT INTO `sys_data_region` VALUES (962, '唐山', 2, '13', '1302', 't');
INSERT INTO `sys_data_region` VALUES (963, '路南', 3, '1302', '130202', 'l');
INSERT INTO `sys_data_region` VALUES (964, '学院南路', 4, '130202', '130202001', 'x');
INSERT INTO `sys_data_region` VALUES (965, '友谊', 4, '130202', '130202002', 'y');
INSERT INTO `sys_data_region` VALUES (966, '广场', 4, '130202', '130202003', 'g');
INSERT INTO `sys_data_region` VALUES (967, '永红桥', 4, '130202', '130202004', 'y');
INSERT INTO `sys_data_region` VALUES (968, '小山', 4, '130202', '130202005', 'x');
INSERT INTO `sys_data_region` VALUES (969, '文化北后街', 4, '130202', '130202006', 'w');
INSERT INTO `sys_data_region` VALUES (970, '钱家营矿区', 4, '130202', '130202007', 'q');
INSERT INTO `sys_data_region` VALUES (971, '惠民', 4, '130202', '130202008', 'h');
INSERT INTO `sys_data_region` VALUES (972, '梁家屯', 4, '130202', '130202009', 'l');
INSERT INTO `sys_data_region` VALUES (973, '稻地', 4, '130202', '130202100', 'd');
INSERT INTO `sys_data_region` VALUES (974, '女织寨', 4, '130202', '130202101', 'n');
INSERT INTO `sys_data_region` VALUES (975, '路北', 3, '1302', '130203', 'l');
INSERT INTO `sys_data_region` VALUES (976, '乔屯', 4, '130203', '130203001', 'q');
INSERT INTO `sys_data_region` VALUES (977, '文化路', 4, '130203', '130203002', 'w');
INSERT INTO `sys_data_region` VALUES (978, '钓鱼台', 4, '130203', '130203003', 'd');
INSERT INTO `sys_data_region` VALUES (979, '东新村', 4, '130203', '130203004', 'd');
INSERT INTO `sys_data_region` VALUES (980, '缸窑', 4, '130203', '130203005', 'g');
INSERT INTO `sys_data_region` VALUES (981, '机场路', 4, '130203', '130203006', 'j');
INSERT INTO `sys_data_region` VALUES (982, '河北路', 4, '130203', '130203007', 'h');
INSERT INTO `sys_data_region` VALUES (983, '龙东', 4, '130203', '130203008', 'l');
INSERT INTO `sys_data_region` VALUES (984, '大里', 4, '130203', '130203009', 'd');
INSERT INTO `sys_data_region` VALUES (985, '光明', 4, '130203', '130203010', 'g');
INSERT INTO `sys_data_region` VALUES (986, '翔云道', 4, '130203', '130203011', 'x');
INSERT INTO `sys_data_region` VALUES (987, '高新技术开发区', 4, '130203', '130203012', 'g');
INSERT INTO `sys_data_region` VALUES (988, '韩城', 4, '130203', '130203100', 'h');
INSERT INTO `sys_data_region` VALUES (989, '果园', 4, '130203', '130203101', 'g');
INSERT INTO `sys_data_region` VALUES (990, '古冶', 3, '1302', '130204', 'g');
INSERT INTO `sys_data_region` VALUES (991, '林西', 4, '130204', '130204001', 'l');
INSERT INTO `sys_data_region` VALUES (992, '唐家庄', 4, '130204', '130204002', 't');
INSERT INTO `sys_data_region` VALUES (993, '古冶街道', 4, '130204', '130204003', 'g');
INSERT INTO `sys_data_region` VALUES (994, '赵各庄', 4, '130204', '130204004', 'z');
INSERT INTO `sys_data_region` VALUES (995, '京华', 4, '130204', '130204005', 'j');
INSERT INTO `sys_data_region` VALUES (996, '范各庄', 4, '130204', '130204100', 'f');
INSERT INTO `sys_data_region` VALUES (997, '卑家店', 4, '130204', '130204101', 'b');
INSERT INTO `sys_data_region` VALUES (998, '王辇庄', 4, '130204', '130204201', 'w');
INSERT INTO `sys_data_region` VALUES (999, '习家套', 4, '130204', '130204202', 'x');
INSERT INTO `sys_data_region` VALUES (1000, '大庄坨', 4, '130204', '130204203', 'd');
INSERT INTO `sys_data_region` VALUES (1001, '开平', 3, '1302', '130205', 'k');
INSERT INTO `sys_data_region` VALUES (1002, '马家沟', 4, '130205', '130205001', 'm');
INSERT INTO `sys_data_region` VALUES (1003, '开平街道', 4, '130205', '130205002', 'k');
INSERT INTO `sys_data_region` VALUES (1004, '税务庄', 4, '130205', '130205003', 's');
INSERT INTO `sys_data_region` VALUES (1005, '陡电', 4, '130205', '130205005', 'd');
INSERT INTO `sys_data_region` VALUES (1006, '荆各庄', 4, '130205', '130205006', 'j');
INSERT INTO `sys_data_region` VALUES (1007, '开平镇', 4, '130205', '130205100', 'k');
INSERT INTO `sys_data_region` VALUES (1008, '栗园', 4, '130205', '130205101', 'l');
INSERT INTO `sys_data_region` VALUES (1009, '越河', 4, '130205', '130205102', 'y');
INSERT INTO `sys_data_region` VALUES (1010, '双桥', 4, '130205', '130205103', 's');
INSERT INTO `sys_data_region` VALUES (1011, '郑庄子', 4, '130205', '130205104', 'z');
INSERT INTO `sys_data_region` VALUES (1012, '洼里', 4, '130205', '130205105', 'w');
INSERT INTO `sys_data_region` VALUES (1013, '丰南', 3, '1302', '130207', 'f');
INSERT INTO `sys_data_region` VALUES (1014, '新华路', 4, '130207', '130207002', 'x');
INSERT INTO `sys_data_region` VALUES (1015, '丰南镇', 4, '130207', '130207100', 'f');
INSERT INTO `sys_data_region` VALUES (1016, '小集', 4, '130207', '130207103', 'x');
INSERT INTO `sys_data_region` VALUES (1017, '黄各庄', 4, '130207', '130207104', 'h');
INSERT INTO `sys_data_region` VALUES (1018, '西葛', 4, '130207', '130207105', 'x');
INSERT INTO `sys_data_region` VALUES (1019, '大新庄', 4, '130207', '130207106', 'd');
INSERT INTO `sys_data_region` VALUES (1020, '钱营', 4, '130207', '130207107', 'q');
INSERT INTO `sys_data_region` VALUES (1021, '唐坊', 4, '130207', '130207108', 't');
INSERT INTO `sys_data_region` VALUES (1022, '王兰庄', 4, '130207', '130207109', 'w');
INSERT INTO `sys_data_region` VALUES (1023, '柳树酄', 4, '130207', '130207110', 'l');
INSERT INTO `sys_data_region` VALUES (1024, '黑沿子', 4, '130207', '130207111', 'h');
INSERT INTO `sys_data_region` VALUES (1025, '大齐各庄', 4, '130207', '130207113', 'd');
INSERT INTO `sys_data_region` VALUES (1026, '海北', 4, '130207', '130207114', 'h');
INSERT INTO `sys_data_region` VALUES (1027, '南孙庄', 4, '130207', '130207116', 'n');
INSERT INTO `sys_data_region` VALUES (1028, '东田庄', 4, '130207', '130207202', 'd');
INSERT INTO `sys_data_region` VALUES (1029, '尖字沽', 4, '130207', '130207203', 'j');
INSERT INTO `sys_data_region` VALUES (1030, '丰润', 3, '1302', '130208', 'f');
INSERT INTO `sys_data_region` VALUES (1031, '太平路', 4, '130208', '130208001', 't');
INSERT INTO `sys_data_region` VALUES (1032, '燕山路', 4, '130208', '130208002', 'y');
INSERT INTO `sys_data_region` VALUES (1033, '浭阳', 4, '130208', '130208003', 'g');
INSERT INTO `sys_data_region` VALUES (1034, '丰润镇', 4, '130208', '130208100', 'f');
INSERT INTO `sys_data_region` VALUES (1035, '老庄子', 4, '130208', '130208101', 'l');
INSERT INTO `sys_data_region` VALUES (1036, '任各庄', 4, '130208', '130208102', 'r');
INSERT INTO `sys_data_region` VALUES (1037, '左家坞', 4, '130208', '130208103', 'z');
INSERT INTO `sys_data_region` VALUES (1038, '泉河头', 4, '130208', '130208104', 'q');
INSERT INTO `sys_data_region` VALUES (1039, '王官营', 4, '130208', '130208105', 'w');
INSERT INTO `sys_data_region` VALUES (1040, '火石营', 4, '130208', '130208106', 'h');
INSERT INTO `sys_data_region` VALUES (1041, '岔河', 4, '130208', '130208108', 'c');
INSERT INTO `sys_data_region` VALUES (1042, '新军屯', 4, '130208', '130208109', 'x');
INSERT INTO `sys_data_region` VALUES (1043, '小张各庄', 4, '130208', '130208110', 'x');
INSERT INTO `sys_data_region` VALUES (1044, '丰登坞', 4, '130208', '130208111', 'f');
INSERT INTO `sys_data_region` VALUES (1045, '李钊庄', 4, '130208', '130208112', 'l');
INSERT INTO `sys_data_region` VALUES (1046, '白官屯', 4, '130208', '130208113', 'b');
INSERT INTO `sys_data_region` VALUES (1047, '石各庄', 4, '130208', '130208114', 's');
INSERT INTO `sys_data_region` VALUES (1048, '沙流河', 4, '130208', '130208115', 's');
INSERT INTO `sys_data_region` VALUES (1049, '七树庄', 4, '130208', '130208116', 'q');
INSERT INTO `sys_data_region` VALUES (1050, '杨官林', 4, '130208', '130208117', 'y');
INSERT INTO `sys_data_region` VALUES (1051, '银城铺', 4, '130208', '130208118', 'y');
INSERT INTO `sys_data_region` VALUES (1052, '常庄', 4, '130208', '130208119', 'c');
INSERT INTO `sys_data_region` VALUES (1053, '姜家营', 4, '130208', '130208202', 'j');
INSERT INTO `sys_data_region` VALUES (1054, '欢喜庄', 4, '130208', '130208205', 'h');
INSERT INTO `sys_data_region` VALUES (1055, '刘家营', 4, '130208', '130208208', 'l');
INSERT INTO `sys_data_region` VALUES (1056, '曹妃甸', 3, '1302', '130209', 'c');
INSERT INTO `sys_data_region` VALUES (1057, '唐海', 4, '130209', '130209100', 't');
INSERT INTO `sys_data_region` VALUES (1058, '柳赞', 4, '130209', '130209101', 'l');
INSERT INTO `sys_data_region` VALUES (1059, '滨海', 4, '130209', '130209102', 'b');
INSERT INTO `sys_data_region` VALUES (1060, '一农场', 4, '130209', '130209401', 'y');
INSERT INTO `sys_data_region` VALUES (1061, '三农场', 4, '130209', '130209403', 's');
INSERT INTO `sys_data_region` VALUES (1062, '四农场', 4, '130209', '130209404', 's');
INSERT INTO `sys_data_region` VALUES (1063, '五农场', 4, '130209', '130209405', 'w');
INSERT INTO `sys_data_region` VALUES (1064, '六农场', 4, '130209', '130209406', 'l');
INSERT INTO `sys_data_region` VALUES (1065, '七农场', 4, '130209', '130209407', 'q');
INSERT INTO `sys_data_region` VALUES (1066, '八农场', 4, '130209', '130209408', 'b');
INSERT INTO `sys_data_region` VALUES (1067, '九农场', 4, '130209', '130209409', 'j');
INSERT INTO `sys_data_region` VALUES (1068, '十农场', 4, '130209', '130209410', 's');
INSERT INTO `sys_data_region` VALUES (1069, '十一农场', 4, '130209', '130209411', 's');
INSERT INTO `sys_data_region` VALUES (1070, '十里海养殖场', 4, '130209', '130209413', 's');
INSERT INTO `sys_data_region` VALUES (1071, '南堡经济开发区', 4, '130209', '130209450', 'n');
INSERT INTO `sys_data_region` VALUES (1072, '曹妃甸工业区', 4, '130209', '130209451', 'c');
INSERT INTO `sys_data_region` VALUES (1073, '滦南', 3, '1302', '130224', 'l');
INSERT INTO `sys_data_region` VALUES (1074, '友谊路', 4, '130224', '130224001', 'y');
INSERT INTO `sys_data_region` VALUES (1075, '倴城', 4, '130224', '130224100', 'b');
INSERT INTO `sys_data_region` VALUES (1076, '宋道口', 4, '130224', '130224101', 's');
INSERT INTO `sys_data_region` VALUES (1077, '长凝', 4, '130224', '130224102', 'c');
INSERT INTO `sys_data_region` VALUES (1078, '胡各庄', 4, '130224', '130224103', 'h');
INSERT INTO `sys_data_region` VALUES (1079, '坨里', 4, '130224', '130224104', 't');
INSERT INTO `sys_data_region` VALUES (1080, '姚王庄', 4, '130224', '130224105', 'y');
INSERT INTO `sys_data_region` VALUES (1081, '司各庄', 4, '130224', '130224106', 's');
INSERT INTO `sys_data_region` VALUES (1082, '安各庄', 4, '130224', '130224107', 'a');
INSERT INTO `sys_data_region` VALUES (1083, '扒齿港', 4, '130224', '130224108', 'b');
INSERT INTO `sys_data_region` VALUES (1084, '程庄', 4, '130224', '130224109', 'c');
INSERT INTO `sys_data_region` VALUES (1085, '青坨营', 4, '130224', '130224110', 'q');
INSERT INTO `sys_data_region` VALUES (1086, '柏各庄', 4, '130224', '130224111', 'b');
INSERT INTO `sys_data_region` VALUES (1087, '南堡', 4, '130224', '130224114', 'n');
INSERT INTO `sys_data_region` VALUES (1088, '方各庄', 4, '130224', '130224115', 'f');
INSERT INTO `sys_data_region` VALUES (1089, '东黄坨', 4, '130224', '130224116', 'd');
INSERT INTO `sys_data_region` VALUES (1090, '马城', 4, '130224', '130224117', 'm');
INSERT INTO `sys_data_region` VALUES (1091, '乐亭', 3, '1302', '130225', 'l');
INSERT INTO `sys_data_region` VALUES (1092, '乐安', 4, '130225', '130225001', 'l');
INSERT INTO `sys_data_region` VALUES (1093, '乐亭镇', 4, '130225', '130225100', 'l');
INSERT INTO `sys_data_region` VALUES (1094, '汤家河', 4, '130225', '130225101', 't');
INSERT INTO `sys_data_region` VALUES (1095, '胡家坨', 4, '130225', '130225102', 'h');
INSERT INTO `sys_data_region` VALUES (1096, '王滩', 4, '130225', '130225103', 'w');
INSERT INTO `sys_data_region` VALUES (1097, '闫各庄', 4, '130225', '130225104', 'y');
INSERT INTO `sys_data_region` VALUES (1098, '马头营', 4, '130225', '130225105', 'm');
INSERT INTO `sys_data_region` VALUES (1099, '新寨', 4, '130225', '130225106', 'x');
INSERT INTO `sys_data_region` VALUES (1100, '汀流河', 4, '130225', '130225107', 't');
INSERT INTO `sys_data_region` VALUES (1101, '姜各庄', 4, '130225', '130225108', 'j');
INSERT INTO `sys_data_region` VALUES (1102, '毛庄', 4, '130225', '130225109', 'm');
INSERT INTO `sys_data_region` VALUES (1103, '中堡', 4, '130225', '130225110', 'z');
INSERT INTO `sys_data_region` VALUES (1104, '大相各庄', 4, '130225', '130225111', 'd');
INSERT INTO `sys_data_region` VALUES (1105, '庞各庄', 4, '130225', '130225201', 'p');
INSERT INTO `sys_data_region` VALUES (1106, '古河', 4, '130225', '130225203', 'g');
INSERT INTO `sys_data_region` VALUES (1107, '迁西', 3, '1302', '130227', 'q');
INSERT INTO `sys_data_region` VALUES (1108, '栗乡', 4, '130227', '130227008', 'l');
INSERT INTO `sys_data_region` VALUES (1109, '兴城', 4, '130227', '130227100', 'x');
INSERT INTO `sys_data_region` VALUES (1110, '金厂峪', 4, '130227', '130227101', 'j');
INSERT INTO `sys_data_region` VALUES (1111, '洒河桥', 4, '130227', '130227102', 's');
INSERT INTO `sys_data_region` VALUES (1112, '太平寨', 4, '130227', '130227103', 't');
INSERT INTO `sys_data_region` VALUES (1113, '罗家屯', 4, '130227', '130227104', 'l');
INSERT INTO `sys_data_region` VALUES (1114, '东荒峪', 4, '130227', '130227105', 'd');
INSERT INTO `sys_data_region` VALUES (1115, '新集', 4, '130227', '130227106', 'x');
INSERT INTO `sys_data_region` VALUES (1116, '三屯营', 4, '130227', '130227107', 's');
INSERT INTO `sys_data_region` VALUES (1117, '滦阳', 4, '130227', '130227108', 'l');
INSERT INTO `sys_data_region` VALUES (1118, '汉儿庄', 4, '130227', '130227109', 'h');
INSERT INTO `sys_data_region` VALUES (1119, '新庄子', 4, '130227', '130227110', 'x');
INSERT INTO `sys_data_region` VALUES (1120, '东莲花院', 4, '130227', '130227111', 'd');
INSERT INTO `sys_data_region` VALUES (1121, '白庙子', 4, '130227', '130227112', 'b');
INSERT INTO `sys_data_region` VALUES (1122, '上营', 4, '130227', '130227113', 's');
INSERT INTO `sys_data_region` VALUES (1123, '渔户寨', 4, '130227', '130227203', 'y');
INSERT INTO `sys_data_region` VALUES (1124, '旧城', 4, '130227', '130227204', 'j');
INSERT INTO `sys_data_region` VALUES (1125, '尹庄', 4, '130227', '130227205', 'y');
INSERT INTO `sys_data_region` VALUES (1126, '玉田', 3, '1302', '130229', 'y');
INSERT INTO `sys_data_region` VALUES (1127, '玉田镇', 4, '130229', '130229100', 'y');
INSERT INTO `sys_data_region` VALUES (1128, '亮甲店', 4, '130229', '130229101', 'l');
INSERT INTO `sys_data_region` VALUES (1129, '鸦鸿桥', 4, '130229', '130229102', 'y');
INSERT INTO `sys_data_region` VALUES (1130, '窝洛沽', 4, '130229', '130229103', 'w');
INSERT INTO `sys_data_region` VALUES (1131, '石臼窝', 4, '130229', '130229104', 's');
INSERT INTO `sys_data_region` VALUES (1132, '虹桥', 4, '130229', '130229105', 'h');
INSERT INTO `sys_data_region` VALUES (1133, '散水头', 4, '130229', '130229106', 's');
INSERT INTO `sys_data_region` VALUES (1134, '林南仓', 4, '130229', '130229107', 'l');
INSERT INTO `sys_data_region` VALUES (1135, '林西', 4, '130229', '130229108', 'l');
INSERT INTO `sys_data_region` VALUES (1136, '杨家板桥', 4, '130229', '130229109', 'y');
INSERT INTO `sys_data_region` VALUES (1137, '彩亭桥', 4, '130229', '130229110', 'c');
INSERT INTO `sys_data_region` VALUES (1138, '孤树', 4, '130229', '130229111', 'g');
INSERT INTO `sys_data_region` VALUES (1139, '大安', 4, '130229', '130229112', 'd');
INSERT INTO `sys_data_region` VALUES (1140, '唐自头', 4, '130229', '130229113', 't');
INSERT INTO `sys_data_region` VALUES (1141, '郭家屯', 4, '130229', '130229114', 'g');
INSERT INTO `sys_data_region` VALUES (1142, '杨家套', 4, '130229', '130229115', 'y');
INSERT INTO `sys_data_region` VALUES (1143, '陈家铺', 4, '130229', '130229116', 'c');
INSERT INTO `sys_data_region` VALUES (1144, '林头屯', 4, '130229', '130229201', 'l');
INSERT INTO `sys_data_region` VALUES (1145, '潮洛窝', 4, '130229', '130229203', 'c');
INSERT INTO `sys_data_region` VALUES (1146, '郭家桥', 4, '130229', '130229205', 'g');
INSERT INTO `sys_data_region` VALUES (1147, '遵化', 3, '1302', '130281', 'z');
INSERT INTO `sys_data_region` VALUES (1148, '华明路', 4, '130281', '130281001', 'h');
INSERT INTO `sys_data_region` VALUES (1149, '文化路', 4, '130281', '130281002', 'w');
INSERT INTO `sys_data_region` VALUES (1150, '遵化镇', 4, '130281', '130281100', 'z');
INSERT INTO `sys_data_region` VALUES (1151, '堡子店', 4, '130281', '130281101', 'b');
INSERT INTO `sys_data_region` VALUES (1152, '马兰峪', 4, '130281', '130281102', 'm');
INSERT INTO `sys_data_region` VALUES (1153, '平安城', 4, '130281', '130281103', 'p');
INSERT INTO `sys_data_region` VALUES (1154, '东新庄', 4, '130281', '130281104', 'd');
INSERT INTO `sys_data_region` VALUES (1155, '新店子', 4, '130281', '130281105', 'x');
INSERT INTO `sys_data_region` VALUES (1156, '党峪', 4, '130281', '130281106', 'd');
INSERT INTO `sys_data_region` VALUES (1157, '地北头', 4, '130281', '130281107', 'd');
INSERT INTO `sys_data_region` VALUES (1158, '东旧寨', 4, '130281', '130281108', 'd');
INSERT INTO `sys_data_region` VALUES (1159, '铁厂', 4, '130281', '130281109', 't');
INSERT INTO `sys_data_region` VALUES (1160, '苏家洼', 4, '130281', '130281110', 's');
INSERT INTO `sys_data_region` VALUES (1161, '建明', 4, '130281', '130281111', 'j');
INSERT INTO `sys_data_region` VALUES (1162, '石门', 4, '130281', '130281112', 's');
INSERT INTO `sys_data_region` VALUES (1163, '崔家庄', 4, '130281', '130281113', 'c');
INSERT INTO `sys_data_region` VALUES (1164, '西留村', 4, '130281', '130281114', 'x');
INSERT INTO `sys_data_region` VALUES (1165, '兴旺寨', 4, '130281', '130281115', 'x');
INSERT INTO `sys_data_region` VALUES (1166, '西三里', 4, '130281', '130281116', 'x');
INSERT INTO `sys_data_region` VALUES (1167, '西下营', 4, '130281', '130281203', 'x');
INSERT INTO `sys_data_region` VALUES (1168, '汤泉', 4, '130281', '130281204', 't');
INSERT INTO `sys_data_region` VALUES (1169, '东陵', 4, '130281', '130281205', 'd');
INSERT INTO `sys_data_region` VALUES (1170, '刘备寨', 4, '130281', '130281206', 'l');
INSERT INTO `sys_data_region` VALUES (1171, '团瓢庄', 4, '130281', '130281207', 't');
INSERT INTO `sys_data_region` VALUES (1172, '娘娘庄', 4, '130281', '130281208', 'n');
INSERT INTO `sys_data_region` VALUES (1173, '候家寨', 4, '130281', '130281210', 'h');
INSERT INTO `sys_data_region` VALUES (1174, '小厂', 4, '130281', '130281211', 'x');
INSERT INTO `sys_data_region` VALUES (1175, '迁安', 3, '1302', '130283', 'q');
INSERT INTO `sys_data_region` VALUES (1176, '杨店子', 4, '130283', '130283004', 'y');
INSERT INTO `sys_data_region` VALUES (1177, '迁安镇', 4, '130283', '130283100', 'q');
INSERT INTO `sys_data_region` VALUES (1178, '夏官营', 4, '130283', '130283101', 'x');
INSERT INTO `sys_data_region` VALUES (1179, '杨各庄', 4, '130283', '130283102', 'y');
INSERT INTO `sys_data_region` VALUES (1180, '建昌营', 4, '130283', '130283103', 'j');
INSERT INTO `sys_data_region` VALUES (1181, '赵店子', 4, '130283', '130283104', 'z');
INSERT INTO `sys_data_region` VALUES (1182, '野鸡坨', 4, '130283', '130283105', 'y');
INSERT INTO `sys_data_region` VALUES (1183, '大崔庄', 4, '130283', '130283106', 'd');
INSERT INTO `sys_data_region` VALUES (1184, '蔡园', 4, '130283', '130283108', 'c');
INSERT INTO `sys_data_region` VALUES (1185, '马兰庄', 4, '130283', '130283109', 'm');
INSERT INTO `sys_data_region` VALUES (1186, '沙河驿', 4, '130283', '130283110', 's');
INSERT INTO `sys_data_region` VALUES (1187, '木厂口', 4, '130283', '130283111', 'm');
INSERT INTO `sys_data_region` VALUES (1188, '上射雁庄', 4, '130283', '130283112', 's');
INSERT INTO `sys_data_region` VALUES (1189, '太平庄', 4, '130283', '130283113', 't');
INSERT INTO `sys_data_region` VALUES (1190, '扣庄', 4, '130283', '130283114', 'k');
INSERT INTO `sys_data_region` VALUES (1191, '大五里', 4, '130283', '130283115', 'd');
INSERT INTO `sys_data_region` VALUES (1192, '五重安', 4, '130283', '130283116', 'w');
INSERT INTO `sys_data_region` VALUES (1193, '彭店子', 4, '130283', '130283117', 'p');
INSERT INTO `sys_data_region` VALUES (1194, '阎家店', 4, '130283', '130283118', 'y');
INSERT INTO `sys_data_region` VALUES (1195, '滦州', 3, '1302', '130284', 'l');
INSERT INTO `sys_data_region` VALUES (1196, '古城', 4, '130284', '130284002', 'g');
INSERT INTO `sys_data_region` VALUES (1197, '滦城路', 4, '130284', '130284003', 'l');
INSERT INTO `sys_data_region` VALUES (1198, '响嘡', 4, '130284', '130284004', 'x');
INSERT INTO `sys_data_region` VALUES (1199, '东安各庄', 4, '130284', '130284102', 'd');
INSERT INTO `sys_data_region` VALUES (1200, '雷庄', 4, '130284', '130284103', 'l');
INSERT INTO `sys_data_region` VALUES (1201, '茨榆坨', 4, '130284', '130284104', 'c');
INSERT INTO `sys_data_region` VALUES (1202, '榛子', 4, '130284', '130284105', 'z');
INSERT INTO `sys_data_region` VALUES (1203, '杨柳庄', 4, '130284', '130284106', 'y');
INSERT INTO `sys_data_region` VALUES (1204, '油榨', 4, '130284', '130284107', 'y');
INSERT INTO `sys_data_region` VALUES (1205, '古马', 4, '130284', '130284108', 'g');
INSERT INTO `sys_data_region` VALUES (1206, '小马庄', 4, '130284', '130284109', 'x');
INSERT INTO `sys_data_region` VALUES (1207, '九百户', 4, '130284', '130284110', 'j');
INSERT INTO `sys_data_region` VALUES (1208, '王店子', 4, '130284', '130284111', 'w');
INSERT INTO `sys_data_region` VALUES (1209, '秦皇岛', 2, '13', '1303', 'q');
INSERT INTO `sys_data_region` VALUES (1210, '海港', 3, '1303', '130302', 'h');
INSERT INTO `sys_data_region` VALUES (1211, '文化路', 4, '130302', '130302001', 'w');
INSERT INTO `sys_data_region` VALUES (1212, '海滨路', 4, '130302', '130302002', 'h');
INSERT INTO `sys_data_region` VALUES (1213, '北环路', 4, '130302', '130302003', 'b');
INSERT INTO `sys_data_region` VALUES (1214, '建设大街', 4, '130302', '130302004', 'j');
INSERT INTO `sys_data_region` VALUES (1215, '河东', 4, '130302', '130302005', 'h');
INSERT INTO `sys_data_region` VALUES (1216, '西港路', 4, '130302', '130302006', 'x');
INSERT INTO `sys_data_region` VALUES (1217, '燕山大街', 4, '130302', '130302007', 'y');
INSERT INTO `sys_data_region` VALUES (1218, '港城大街', 4, '130302', '130302008', 'g');
INSERT INTO `sys_data_region` VALUES (1219, '东环路', 4, '130302', '130302009', 'd');
INSERT INTO `sys_data_region` VALUES (1220, '白塔岭', 4, '130302', '130302010', 'b');
INSERT INTO `sys_data_region` VALUES (1221, '珠江道', 4, '130302', '130302011', 'z');
INSERT INTO `sys_data_region` VALUES (1222, '黄河道', 4, '130302', '130302012', 'h');
INSERT INTO `sys_data_region` VALUES (1223, '腾飞路', 4, '130302', '130302013', 't');
INSERT INTO `sys_data_region` VALUES (1224, '东港', 4, '130302', '130302100', 'd');
INSERT INTO `sys_data_region` VALUES (1225, '西港', 4, '130302', '130302102', 'x');
INSERT INTO `sys_data_region` VALUES (1226, '海阳', 4, '130302', '130302103', 'h');
INSERT INTO `sys_data_region` VALUES (1227, '北港', 4, '130302', '130302104', 'b');
INSERT INTO `sys_data_region` VALUES (1228, '杜庄', 4, '130302', '130302105', 'd');
INSERT INTO `sys_data_region` VALUES (1229, '石门寨', 4, '130302', '130302106', 's');
INSERT INTO `sys_data_region` VALUES (1230, '驻操营', 4, '130302', '130302107', 'z');
INSERT INTO `sys_data_region` VALUES (1231, '山海关', 3, '1303', '130303', 's');
INSERT INTO `sys_data_region` VALUES (1232, '南关', 4, '130303', '130303001', 'n');
INSERT INTO `sys_data_region` VALUES (1233, '东街', 4, '130303', '130303002', 'd');
INSERT INTO `sys_data_region` VALUES (1234, '西街', 4, '130303', '130303003', 'x');
INSERT INTO `sys_data_region` VALUES (1235, '路南', 4, '130303', '130303004', 'l');
INSERT INTO `sys_data_region` VALUES (1236, '船厂路', 4, '130303', '130303005', 'c');
INSERT INTO `sys_data_region` VALUES (1237, '第一关', 4, '130303', '130303100', 'd');
INSERT INTO `sys_data_region` VALUES (1238, '石河', 4, '130303', '130303101', 's');
INSERT INTO `sys_data_region` VALUES (1239, '孟姜', 4, '130303', '130303102', 'm');
INSERT INTO `sys_data_region` VALUES (1240, '渤海', 4, '130303', '130303200', 'b');
INSERT INTO `sys_data_region` VALUES (1241, '北戴河', 3, '1303', '130304', 'b');
INSERT INTO `sys_data_region` VALUES (1242, '西山', 4, '130304', '130304001', 'x');
INSERT INTO `sys_data_region` VALUES (1243, '东山', 4, '130304', '130304002', 'd');
INSERT INTO `sys_data_region` VALUES (1244, '海滨', 4, '130304', '130304100', 'h');
INSERT INTO `sys_data_region` VALUES (1245, '戴河', 4, '130304', '130304101', 'd');
INSERT INTO `sys_data_region` VALUES (1246, '牛头崖', 4, '130304', '130304102', 'n');
INSERT INTO `sys_data_region` VALUES (1247, '抚宁', 3, '1303', '130306', 'f');
INSERT INTO `sys_data_region` VALUES (1248, '骊城', 4, '130306', '130306001', 'l');
INSERT INTO `sys_data_region` VALUES (1249, '抚宁镇', 4, '130306', '130306100', 'f');
INSERT INTO `sys_data_region` VALUES (1250, '留守营', 4, '130306', '130306101', 'l');
INSERT INTO `sys_data_region` VALUES (1251, '榆关', 4, '130306', '130306102', 'y');
INSERT INTO `sys_data_region` VALUES (1252, '台营', 4, '130306', '130306105', 't');
INSERT INTO `sys_data_region` VALUES (1253, '大新寨', 4, '130306', '130306106', 'd');
INSERT INTO `sys_data_region` VALUES (1254, '坟坨', 4, '130306', '130306107', 'f');
INSERT INTO `sys_data_region` VALUES (1255, '茶棚', 4, '130306', '130306200', 'c');
INSERT INTO `sys_data_region` VALUES (1256, '青龙', 3, '1303', '130321', 'q');
INSERT INTO `sys_data_region` VALUES (1257, '青龙镇', 4, '130321', '130321100', 'q');
INSERT INTO `sys_data_region` VALUES (1258, '祖山', 4, '130321', '130321101', 'z');
INSERT INTO `sys_data_region` VALUES (1259, '木头凳', 4, '130321', '130321102', 'm');
INSERT INTO `sys_data_region` VALUES (1260, '双山子', 4, '130321', '130321103', 's');
INSERT INTO `sys_data_region` VALUES (1261, '马圈子', 4, '130321', '130321104', 'm');
INSERT INTO `sys_data_region` VALUES (1262, '肖营子', 4, '130321', '130321105', 'x');
INSERT INTO `sys_data_region` VALUES (1263, '大巫岚', 4, '130321', '130321106', 'd');
INSERT INTO `sys_data_region` VALUES (1264, '土门子', 4, '130321', '130321107', 't');
INSERT INTO `sys_data_region` VALUES (1265, '八道河', 4, '130321', '130321108', 'b');
INSERT INTO `sys_data_region` VALUES (1266, '隔河头', 4, '130321', '130321109', 'g');
INSERT INTO `sys_data_region` VALUES (1267, '娄杖子', 4, '130321', '130321111', 'l');
INSERT INTO `sys_data_region` VALUES (1268, '凤凰山', 4, '130321', '130321200', 'f');
INSERT INTO `sys_data_region` VALUES (1269, '龙王庙', 4, '130321', '130321201', 'l');
INSERT INTO `sys_data_region` VALUES (1270, '三星口', 4, '130321', '130321202', 's');
INSERT INTO `sys_data_region` VALUES (1271, '干沟', 4, '130321', '130321203', 'g');
INSERT INTO `sys_data_region` VALUES (1272, '大石岭', 4, '130321', '130321206', 'd');
INSERT INTO `sys_data_region` VALUES (1273, '官场', 4, '130321', '130321208', 'g');
INSERT INTO `sys_data_region` VALUES (1274, '茨榆山', 4, '130321', '130321209', 'c');
INSERT INTO `sys_data_region` VALUES (1275, '平方子', 4, '130321', '130321210', 'p');
INSERT INTO `sys_data_region` VALUES (1276, '安子岭', 4, '130321', '130321211', 'a');
INSERT INTO `sys_data_region` VALUES (1277, '朱杖子', 4, '130321', '130321212', 'z');
INSERT INTO `sys_data_region` VALUES (1278, '草碾', 4, '130321', '130321213', 'c');
INSERT INTO `sys_data_region` VALUES (1279, '七道河', 4, '130321', '130321214', 'q');
INSERT INTO `sys_data_region` VALUES (1280, '三拨子', 4, '130321', '130321217', 's');
INSERT INTO `sys_data_region` VALUES (1281, '凉水河', 4, '130321', '130321218', 'l');
INSERT INTO `sys_data_region` VALUES (1282, '昌黎', 3, '1303', '130322', 'c');
INSERT INTO `sys_data_region` VALUES (1283, '昌黎镇', 4, '130322', '130322100', 'c');
INSERT INTO `sys_data_region` VALUES (1284, '靖安', 4, '130322', '130322101', 'j');
INSERT INTO `sys_data_region` VALUES (1285, '安山', 4, '130322', '130322102', 'a');
INSERT INTO `sys_data_region` VALUES (1286, '龙家店', 4, '130322', '130322103', 'l');
INSERT INTO `sys_data_region` VALUES (1287, '泥井', 4, '130322', '130322104', 'n');
INSERT INTO `sys_data_region` VALUES (1288, '大蒲河', 4, '130322', '130322105', 'd');
INSERT INTO `sys_data_region` VALUES (1289, '新集', 4, '130322', '130322106', 'x');
INSERT INTO `sys_data_region` VALUES (1290, '刘台庄', 4, '130322', '130322107', 'l');
INSERT INTO `sys_data_region` VALUES (1291, '朱各庄', 4, '130322', '130322108', 'z');
INSERT INTO `sys_data_region` VALUES (1292, '荒佃庄', 4, '130322', '130322109', 'h');
INSERT INTO `sys_data_region` VALUES (1293, '茹荷', 4, '130322', '130322110', 'r');
INSERT INTO `sys_data_region` VALUES (1294, '团林', 4, '130322', '130322201', 't');
INSERT INTO `sys_data_region` VALUES (1295, '葛条港', 4, '130322', '130322202', 'g');
INSERT INTO `sys_data_region` VALUES (1296, '马坨店', 4, '130322', '130322203', 'm');
INSERT INTO `sys_data_region` VALUES (1297, '两山', 4, '130322', '130322206', 'l');
INSERT INTO `sys_data_region` VALUES (1298, '十里铺', 4, '130322', '130322207', 's');
INSERT INTO `sys_data_region` VALUES (1299, '卢龙', 3, '1303', '130324', 'l');
INSERT INTO `sys_data_region` VALUES (1300, '卢龙镇', 4, '130324', '130324100', 'l');
INSERT INTO `sys_data_region` VALUES (1301, '潘庄', 4, '130324', '130324101', 'p');
INSERT INTO `sys_data_region` VALUES (1302, '燕河营', 4, '130324', '130324102', 'y');
INSERT INTO `sys_data_region` VALUES (1303, '双望', 4, '130324', '130324103', 's');
INSERT INTO `sys_data_region` VALUES (1304, '刘田各庄', 4, '130324', '130324104', 'l');
INSERT INTO `sys_data_region` VALUES (1305, '石门', 4, '130324', '130324105', 's');
INSERT INTO `sys_data_region` VALUES (1306, '木井', 4, '130324', '130324106', 'm');
INSERT INTO `sys_data_region` VALUES (1307, '陈官屯', 4, '130324', '130324107', 'c');
INSERT INTO `sys_data_region` VALUES (1308, '蛤泊', 4, '130324', '130324108', 'g');
INSERT INTO `sys_data_region` VALUES (1309, '下寨', 4, '130324', '130324200', 'x');
INSERT INTO `sys_data_region` VALUES (1310, '刘家营', 4, '130324', '130324201', 'l');
INSERT INTO `sys_data_region` VALUES (1311, '印庄', 4, '130324', '130324203', 'y');
INSERT INTO `sys_data_region` VALUES (1312, '邯郸', 2, '13', '1304', 'h');
INSERT INTO `sys_data_region` VALUES (1313, '邯山', 3, '1304', '130402', 'h');
INSERT INTO `sys_data_region` VALUES (1314, '火磨', 4, '130402', '130402001', 'h');
INSERT INTO `sys_data_region` VALUES (1315, '陵园', 4, '130402', '130402002', 'l');
INSERT INTO `sys_data_region` VALUES (1316, '光明路', 4, '130402', '130402003', 'g');
INSERT INTO `sys_data_region` VALUES (1317, '滏东', 4, '130402', '130402004', 'f');
INSERT INTO `sys_data_region` VALUES (1318, '罗城头', 4, '130402', '130402005', 'l');
INSERT INTO `sys_data_region` VALUES (1319, '渚河路', 4, '130402', '130402006', 'z');
INSERT INTO `sys_data_region` VALUES (1320, '浴新南', 4, '130402', '130402007', 'y');
INSERT INTO `sys_data_region` VALUES (1321, '农林路', 4, '130402', '130402008', 'n');
INSERT INTO `sys_data_region` VALUES (1322, '贸东', 4, '130402', '130402009', 'm');
INSERT INTO `sys_data_region` VALUES (1323, '贸西', 4, '130402', '130402010', 'm');
INSERT INTO `sys_data_region` VALUES (1324, '北张庄', 4, '130402', '130402100', 'b');
INSERT INTO `sys_data_region` VALUES (1325, '马头', 4, '130402', '130402101', 'm');
INSERT INTO `sys_data_region` VALUES (1326, '河沙镇', 4, '130402', '130402102', 'h');
INSERT INTO `sys_data_region` VALUES (1327, '高臾', 4, '130402', '130402103', 'g');
INSERT INTO `sys_data_region` VALUES (1328, '光禄', 4, '130402', '130402104', 'g');
INSERT INTO `sys_data_region` VALUES (1329, '马庄', 4, '130402', '130402200', 'm');
INSERT INTO `sys_data_region` VALUES (1330, '南堡', 4, '130402', '130402201', 'n');
INSERT INTO `sys_data_region` VALUES (1331, '代召', 4, '130402', '130402202', 'd');
INSERT INTO `sys_data_region` VALUES (1332, '辛庄营', 4, '130402', '130402203', 'x');
INSERT INTO `sys_data_region` VALUES (1333, '花官营', 4, '130402', '130402204', 'h');
INSERT INTO `sys_data_region` VALUES (1334, '台城', 4, '130402', '130402206', 't');
INSERT INTO `sys_data_region` VALUES (1335, '丛台', 3, '1304', '130403', 'c');
INSERT INTO `sys_data_region` VALUES (1336, '丛台西', 4, '130403', '130403001', 'c');
INSERT INTO `sys_data_region` VALUES (1337, '联纺西', 4, '130403', '130403002', 'l');
INSERT INTO `sys_data_region` VALUES (1338, '联纺东', 4, '130403', '130403003', 'l');
INSERT INTO `sys_data_region` VALUES (1339, '光明桥', 4, '130403', '130403004', 'g');
INSERT INTO `sys_data_region` VALUES (1340, '丛台东', 4, '130403', '130403005', 'c');
INSERT INTO `sys_data_region` VALUES (1341, '四季青', 4, '130403', '130403006', 's');
INSERT INTO `sys_data_region` VALUES (1342, '和平', 4, '130403', '130403007', 'h');
INSERT INTO `sys_data_region` VALUES (1343, '中华', 4, '130403', '130403008', 'z');
INSERT INTO `sys_data_region` VALUES (1344, '人民路', 4, '130403', '130403009', 'r');
INSERT INTO `sys_data_region` VALUES (1345, '柳林桥', 4, '130403', '130403010', 'l');
INSERT INTO `sys_data_region` VALUES (1346, '尚璧', 4, '130403', '130403101', 's');
INSERT INTO `sys_data_region` VALUES (1347, '南沿村', 4, '130403', '130403102', 'n');
INSERT INTO `sys_data_region` VALUES (1348, '黄粱梦', 4, '130403', '130403103', 'h');
INSERT INTO `sys_data_region` VALUES (1349, '苏曹', 4, '130403', '130403200', 's');
INSERT INTO `sys_data_region` VALUES (1350, '南吕固', 4, '130403', '130403201', 'n');
INSERT INTO `sys_data_region` VALUES (1351, '兼庄', 4, '130403', '130403202', 'j');
INSERT INTO `sys_data_region` VALUES (1352, '三陵', 4, '130403', '130403203', 's');
INSERT INTO `sys_data_region` VALUES (1353, '小西堡', 4, '130403', '130403204', 'x');
INSERT INTO `sys_data_region` VALUES (1354, '姚寨', 4, '130403', '130403205', 'y');
INSERT INTO `sys_data_region` VALUES (1355, '复兴', 3, '1304', '130404', 'f');
INSERT INTO `sys_data_region` VALUES (1356, '胜利桥', 4, '130404', '130404001', 's');
INSERT INTO `sys_data_region` VALUES (1357, '百家村', 4, '130404', '130404002', 'b');
INSERT INTO `sys_data_region` VALUES (1358, '铁路大院', 4, '130404', '130404003', 't');
INSERT INTO `sys_data_region` VALUES (1359, '化林路', 4, '130404', '130404004', 'h');
INSERT INTO `sys_data_region` VALUES (1360, '庞村', 4, '130404', '130404005', 'p');
INSERT INTO `sys_data_region` VALUES (1361, '石化', 4, '130404', '130404007', 's');
INSERT INTO `sys_data_region` VALUES (1362, '户村', 4, '130404', '130404100', 'h');
INSERT INTO `sys_data_region` VALUES (1363, '林坛', 4, '130404', '130404101', 'l');
INSERT INTO `sys_data_region` VALUES (1364, '彭家寨', 4, '130404', '130404200', 'p');
INSERT INTO `sys_data_region` VALUES (1365, '康庄', 4, '130404', '130404201', 'k');
INSERT INTO `sys_data_region` VALUES (1366, '南城', 4, '130404', '130404202', 'n');
INSERT INTO `sys_data_region` VALUES (1367, '峰峰矿区', 3, '1304', '130406', 'f');
INSERT INTO `sys_data_region` VALUES (1368, '滏阳东路', 4, '130406', '130406001', 'f');
INSERT INTO `sys_data_region` VALUES (1369, '临水', 4, '130406', '130406100', 'l');
INSERT INTO `sys_data_region` VALUES (1370, '峰峰', 4, '130406', '130406101', 'f');
INSERT INTO `sys_data_region` VALUES (1371, '新坡', 4, '130406', '130406102', 'x');
INSERT INTO `sys_data_region` VALUES (1372, '大社', 4, '130406', '130406103', 'd');
INSERT INTO `sys_data_region` VALUES (1373, '和村', 4, '130406', '130406104', 'h');
INSERT INTO `sys_data_region` VALUES (1374, '义井', 4, '130406', '130406105', 'y');
INSERT INTO `sys_data_region` VALUES (1375, '彭城', 4, '130406', '130406106', 'p');
INSERT INTO `sys_data_region` VALUES (1376, '界城', 4, '130406', '130406107', 'j');
INSERT INTO `sys_data_region` VALUES (1377, '大峪', 4, '130406', '130406108', 'd');
INSERT INTO `sys_data_region` VALUES (1378, '肥乡', 3, '1304', '130407', 'f');
INSERT INTO `sys_data_region` VALUES (1379, '肥乡镇', 4, '130407', '130407100', 'f');
INSERT INTO `sys_data_region` VALUES (1380, '天台山', 4, '130407', '130407101', 't');
INSERT INTO `sys_data_region` VALUES (1381, '辛安镇', 4, '130407', '130407102', 'x');
INSERT INTO `sys_data_region` VALUES (1382, '大寺上', 4, '130407', '130407103', 'd');
INSERT INTO `sys_data_region` VALUES (1383, '东漳堡', 4, '130407', '130407104', 'd');
INSERT INTO `sys_data_region` VALUES (1384, '毛演堡', 4, '130407', '130407105', 'm');
INSERT INTO `sys_data_region` VALUES (1385, '西吕营', 4, '130407', '130407106', 'x');
INSERT INTO `sys_data_region` VALUES (1386, '元固', 4, '130407', '130407107', 'y');
INSERT INTO `sys_data_region` VALUES (1387, '北高', 4, '130407', '130407108', 'b');
INSERT INTO `sys_data_region` VALUES (1388, '永年', 3, '1304', '130408', 'y');
INSERT INTO `sys_data_region` VALUES (1389, '临洺关', 4, '130408', '130408100', 'l');
INSERT INTO `sys_data_region` VALUES (1390, '大北汪', 4, '130408', '130408101', 'd');
INSERT INTO `sys_data_region` VALUES (1391, '张西堡', 4, '130408', '130408102', 'z');
INSERT INTO `sys_data_region` VALUES (1392, '广府', 4, '130408', '130408103', 'g');
INSERT INTO `sys_data_region` VALUES (1393, '永合会', 4, '130408', '130408105', 'y');
INSERT INTO `sys_data_region` VALUES (1394, '刘营', 4, '130408', '130408106', 'l');
INSERT INTO `sys_data_region` VALUES (1395, '东杨庄', 4, '130408', '130408107', 'd');
INSERT INTO `sys_data_region` VALUES (1396, '讲武', 4, '130408', '130408108', 'j');
INSERT INTO `sys_data_region` VALUES (1397, '西苏', 4, '130408', '130408109', 'x');
INSERT INTO `sys_data_region` VALUES (1398, '界河店', 4, '130408', '130408201', 'j');
INSERT INTO `sys_data_region` VALUES (1399, '刘汉', 4, '130408', '130408203', 'l');
INSERT INTO `sys_data_region` VALUES (1400, '正西', 4, '130408', '130408204', 'z');
INSERT INTO `sys_data_region` VALUES (1401, '曲陌', 4, '130408', '130408206', 'q');
INSERT INTO `sys_data_region` VALUES (1402, '辛庄堡', 4, '130408', '130408207', 'x');
INSERT INTO `sys_data_region` VALUES (1403, '小龙马', 4, '130408', '130408208', 'x');
INSERT INTO `sys_data_region` VALUES (1404, '西河庄', 4, '130408', '130408211', 'x');
INSERT INTO `sys_data_region` VALUES (1405, '西阳城', 4, '130408', '130408213', 'x');
INSERT INTO `sys_data_region` VALUES (1406, '临漳', 3, '1304', '130423', 'l');
INSERT INTO `sys_data_region` VALUES (1407, '临漳镇', 4, '130423', '130423100', 'l');
INSERT INTO `sys_data_region` VALUES (1408, '南东坊', 4, '130423', '130423101', 'n');
INSERT INTO `sys_data_region` VALUES (1409, '孙陶集', 4, '130423', '130423102', 's');
INSERT INTO `sys_data_region` VALUES (1410, '柳园', 4, '130423', '130423103', 'l');
INSERT INTO `sys_data_region` VALUES (1411, '称勾集', 4, '130423', '130423104', 'c');
INSERT INTO `sys_data_region` VALUES (1412, '邺城', 4, '130423', '130423105', 'y');
INSERT INTO `sys_data_region` VALUES (1413, '章里集', 4, '130423', '130423106', 'z');
INSERT INTO `sys_data_region` VALUES (1414, '张村集', 4, '130423', '130423107', 'z');
INSERT INTO `sys_data_region` VALUES (1415, '砖寨营', 4, '130423', '130423108', 'z');
INSERT INTO `sys_data_region` VALUES (1416, '习文', 4, '130423', '130423109', 'x');
INSERT INTO `sys_data_region` VALUES (1417, '狄邱', 4, '130423', '130423200', 'd');
INSERT INTO `sys_data_region` VALUES (1418, '西羊羔', 4, '130423', '130423202', 'x');
INSERT INTO `sys_data_region` VALUES (1419, '杜村集', 4, '130423', '130423204', 'd');
INSERT INTO `sys_data_region` VALUES (1420, '柏鹤集', 4, '130423', '130423208', 'b');
INSERT INTO `sys_data_region` VALUES (1421, '成安', 3, '1304', '130424', 'c');
INSERT INTO `sys_data_region` VALUES (1422, '成安镇', 4, '130424', '130424100', 'c');
INSERT INTO `sys_data_region` VALUES (1423, '商城', 4, '130424', '130424101', 's');
INSERT INTO `sys_data_region` VALUES (1424, '漳河店', 4, '130424', '130424102', 'z');
INSERT INTO `sys_data_region` VALUES (1425, '李家疃', 4, '130424', '130424103', 'l');
INSERT INTO `sys_data_region` VALUES (1426, '北乡义', 4, '130424', '130424104', 'b');
INSERT INTO `sys_data_region` VALUES (1427, '道东堡', 4, '130424', '130424105', 'd');
INSERT INTO `sys_data_region` VALUES (1428, '辛义', 4, '130424', '130424200', 'x');
INSERT INTO `sys_data_region` VALUES (1429, '柏寺营', 4, '130424', '130424201', 'b');
INSERT INTO `sys_data_region` VALUES (1430, '长巷', 4, '130424', '130424204', 'c');
INSERT INTO `sys_data_region` VALUES (1431, '大名', 3, '1304', '130425', 'd');
INSERT INTO `sys_data_region` VALUES (1432, '大名镇', 4, '130425', '130425100', 'd');
INSERT INTO `sys_data_region` VALUES (1433, '杨桥', 4, '130425', '130425101', 'y');
INSERT INTO `sys_data_region` VALUES (1434, '万堤', 4, '130425', '130425102', 'w');
INSERT INTO `sys_data_region` VALUES (1435, '龙王庙', 4, '130425', '130425103', 'l');
INSERT INTO `sys_data_region` VALUES (1436, '束馆', 4, '130425', '130425104', 's');
INSERT INTO `sys_data_region` VALUES (1437, '金滩', 4, '130425', '130425105', 'j');
INSERT INTO `sys_data_region` VALUES (1438, '沙圪塔', 4, '130425', '130425106', 's');
INSERT INTO `sys_data_region` VALUES (1439, '大街', 4, '130425', '130425107', 'd');
INSERT INTO `sys_data_region` VALUES (1440, '铺上', 4, '130425', '130425108', 'p');
INSERT INTO `sys_data_region` VALUES (1441, '孙甘店', 4, '130425', '130425109', 's');
INSERT INTO `sys_data_region` VALUES (1442, '北峰', 4, '130425', '130425110', 'b');
INSERT INTO `sys_data_region` VALUES (1443, '黄金堤', 4, '130425', '130425111', 'h');
INSERT INTO `sys_data_region` VALUES (1444, '王村', 4, '130425', '130425201', 'w');
INSERT INTO `sys_data_region` VALUES (1445, '旧治', 4, '130425', '130425205', 'j');
INSERT INTO `sys_data_region` VALUES (1446, '西未庄', 4, '130425', '130425206', 'x');
INSERT INTO `sys_data_region` VALUES (1447, '西付集', 4, '130425', '130425208', 'x');
INSERT INTO `sys_data_region` VALUES (1448, '埝头', 4, '130425', '130425209', 'n');
INSERT INTO `sys_data_region` VALUES (1449, '张铁集', 4, '130425', '130425211', 'z');
INSERT INTO `sys_data_region` VALUES (1450, '红庙', 4, '130425', '130425212', 'h');
INSERT INTO `sys_data_region` VALUES (1451, '营镇', 4, '130425', '130425213', 'y');
INSERT INTO `sys_data_region` VALUES (1452, '涉县', 3, '1304', '130426', 's');
INSERT INTO `sys_data_region` VALUES (1453, '平安', 4, '130426', '130426001', 'p');
INSERT INTO `sys_data_region` VALUES (1454, '涉城', 4, '130426', '130426100', 's');
INSERT INTO `sys_data_region` VALUES (1455, '河南店', 4, '130426', '130426101', 'h');
INSERT INTO `sys_data_region` VALUES (1456, '索堡', 4, '130426', '130426102', 's');
INSERT INTO `sys_data_region` VALUES (1457, '西戌', 4, '130426', '130426103', 'x');
INSERT INTO `sys_data_region` VALUES (1458, '井店', 4, '130426', '130426104', 'j');
INSERT INTO `sys_data_region` VALUES (1459, '更乐', 4, '130426', '130426105', 'g');
INSERT INTO `sys_data_region` VALUES (1460, '固新', 4, '130426', '130426106', 'g');
INSERT INTO `sys_data_region` VALUES (1461, '西达', 4, '130426', '130426107', 'x');
INSERT INTO `sys_data_region` VALUES (1462, '偏城', 4, '130426', '130426108', 'p');
INSERT INTO `sys_data_region` VALUES (1463, '神头', 4, '130426', '130426200', 's');
INSERT INTO `sys_data_region` VALUES (1464, '辽城', 4, '130426', '130426201', 'l');
INSERT INTO `sys_data_region` VALUES (1465, '偏店', 4, '130426', '130426202', 'p');
INSERT INTO `sys_data_region` VALUES (1466, '龙虎', 4, '130426', '130426203', 'l');
INSERT INTO `sys_data_region` VALUES (1467, '木井', 4, '130426', '130426204', 'm');
INSERT INTO `sys_data_region` VALUES (1468, '关防', 4, '130426', '130426205', 'g');
INSERT INTO `sys_data_region` VALUES (1469, '合漳', 4, '130426', '130426206', 'h');
INSERT INTO `sys_data_region` VALUES (1470, '鹿头', 4, '130426', '130426207', 'l');
INSERT INTO `sys_data_region` VALUES (1471, '磁县', 3, '1304', '130427', 'c');
INSERT INTO `sys_data_region` VALUES (1472, '磁州', 4, '130427', '130427100', 'c');
INSERT INTO `sys_data_region` VALUES (1473, '讲武城', 4, '130427', '130427103', 'j');
INSERT INTO `sys_data_region` VALUES (1474, '岳城', 4, '130427', '130427104', 'y');
INSERT INTO `sys_data_region` VALUES (1475, '观台', 4, '130427', '130427105', 'g');
INSERT INTO `sys_data_region` VALUES (1476, '白土', 4, '130427', '130427107', 'b');
INSERT INTO `sys_data_region` VALUES (1477, '黄沙', 4, '130427', '130427108', 'h');
INSERT INTO `sys_data_region` VALUES (1478, '路村营', 4, '130427', '130427200', 'l');
INSERT INTO `sys_data_region` VALUES (1479, '西固义', 4, '130427', '130427201', 'x');
INSERT INTO `sys_data_region` VALUES (1480, '时村营', 4, '130427', '130427204', 's');
INSERT INTO `sys_data_region` VALUES (1481, '陶泉', 4, '130427', '130427207', 't');
INSERT INTO `sys_data_region` VALUES (1482, '都党', 4, '130427', '130427208', 'd');
INSERT INTO `sys_data_region` VALUES (1483, '北贾璧', 4, '130427', '130427209', 'b');
INSERT INTO `sys_data_region` VALUES (1484, '邱县', 3, '1304', '130430', 'q');
INSERT INTO `sys_data_region` VALUES (1485, '新马头', 4, '130430', '130430100', 'x');
INSERT INTO `sys_data_region` VALUES (1486, '邱城', 4, '130430', '130430101', 'q');
INSERT INTO `sys_data_region` VALUES (1487, '梁二庄', 4, '130430', '130430102', 'l');
INSERT INTO `sys_data_region` VALUES (1488, '香城固', 4, '130430', '130430103', 'x');
INSERT INTO `sys_data_region` VALUES (1489, '古城营', 4, '130430', '130430104', 'g');
INSERT INTO `sys_data_region` VALUES (1490, '南辛店', 4, '130430', '130430201', 'n');
INSERT INTO `sys_data_region` VALUES (1491, '陈村', 4, '130430', '130430204', 'c');
INSERT INTO `sys_data_region` VALUES (1492, '鸡泽', 3, '1304', '130431', 'j');
INSERT INTO `sys_data_region` VALUES (1493, '鸡泽镇', 4, '130431', '130431100', 'j');
INSERT INTO `sys_data_region` VALUES (1494, '小寨', 4, '130431', '130431101', 'x');
INSERT INTO `sys_data_region` VALUES (1495, '双塔', 4, '130431', '130431102', 's');
INSERT INTO `sys_data_region` VALUES (1496, '曹庄', 4, '130431', '130431103', 'c');
INSERT INTO `sys_data_region` VALUES (1497, '浮图店', 4, '130431', '130431104', 'f');
INSERT INTO `sys_data_region` VALUES (1498, '吴官营', 4, '130431', '130431105', 'w');
INSERT INTO `sys_data_region` VALUES (1499, '风正', 4, '130431', '130431202', 'f');
INSERT INTO `sys_data_region` VALUES (1500, '广平', 3, '1304', '130432', 'g');
INSERT INTO `sys_data_region` VALUES (1501, '广平镇', 4, '130432', '130432100', 'g');
INSERT INTO `sys_data_region` VALUES (1502, '平固店', 4, '130432', '130432101', 'p');
INSERT INTO `sys_data_region` VALUES (1503, '胜营', 4, '130432', '130432102', 's');
INSERT INTO `sys_data_region` VALUES (1504, '南阳堡', 4, '130432', '130432103', 'n');
INSERT INTO `sys_data_region` VALUES (1505, '十里铺', 4, '130432', '130432104', 's');
INSERT INTO `sys_data_region` VALUES (1506, '南韩村', 4, '130432', '130432105', 'n');
INSERT INTO `sys_data_region` VALUES (1507, '东张孟', 4, '130432', '130432106', 'd');
INSERT INTO `sys_data_region` VALUES (1508, '馆陶', 3, '1304', '130433', 'g');
INSERT INTO `sys_data_region` VALUES (1509, '馆陶镇', 4, '130433', '130433100', 'g');
INSERT INTO `sys_data_region` VALUES (1510, '房寨', 4, '130433', '130433101', 'f');
INSERT INTO `sys_data_region` VALUES (1511, '柴堡', 4, '130433', '130433102', 'c');
INSERT INTO `sys_data_region` VALUES (1512, '魏僧寨', 4, '130433', '130433103', 'w');
INSERT INTO `sys_data_region` VALUES (1513, '寿山寺', 4, '130433', '130433200', 's');
INSERT INTO `sys_data_region` VALUES (1514, '王桥', 4, '130433', '130433201', 'w');
INSERT INTO `sys_data_region` VALUES (1515, '南徐村', 4, '130433', '130433202', 'n');
INSERT INTO `sys_data_region` VALUES (1516, '路桥', 4, '130433', '130433203', 'l');
INSERT INTO `sys_data_region` VALUES (1517, '魏县', 3, '1304', '130434', 'w');
INSERT INTO `sys_data_region` VALUES (1518, '魏城', 4, '130434', '130434100', 'w');
INSERT INTO `sys_data_region` VALUES (1519, '德政', 4, '130434', '130434101', 'd');
INSERT INTO `sys_data_region` VALUES (1520, '北皋', 4, '130434', '130434102', 'b');
INSERT INTO `sys_data_region` VALUES (1521, '双井', 4, '130434', '130434103', 's');
INSERT INTO `sys_data_region` VALUES (1522, '牙里', 4, '130434', '130434104', 'y');
INSERT INTO `sys_data_region` VALUES (1523, '车往', 4, '130434', '130434105', 'c');
INSERT INTO `sys_data_region` VALUES (1524, '回隆', 4, '130434', '130434106', 'h');
INSERT INTO `sys_data_region` VALUES (1525, '张二庄', 4, '130434', '130434107', 'z');
INSERT INTO `sys_data_region` VALUES (1526, '东代固', 4, '130434', '130434108', 'd');
INSERT INTO `sys_data_region` VALUES (1527, '院堡', 4, '130434', '130434109', 'y');
INSERT INTO `sys_data_region` VALUES (1528, '南双庙', 4, '130434', '130434110', 'n');
INSERT INTO `sys_data_region` VALUES (1529, '棘针寨', 4, '130434', '130434111', 'j');
INSERT INTO `sys_data_region` VALUES (1530, '边马', 4, '130434', '130434112', 'b');
INSERT INTO `sys_data_region` VALUES (1531, '泊口', 4, '130434', '130434113', 'b');
INSERT INTO `sys_data_region` VALUES (1532, '仕望集', 4, '130434', '130434114', 's');
INSERT INTO `sys_data_region` VALUES (1533, '沙口集', 4, '130434', '130434202', 's');
INSERT INTO `sys_data_region` VALUES (1534, '野胡拐', 4, '130434', '130434203', 'y');
INSERT INTO `sys_data_region` VALUES (1535, '前大磨', 4, '130434', '130434205', 'q');
INSERT INTO `sys_data_region` VALUES (1536, '大辛庄', 4, '130434', '130434208', 'd');
INSERT INTO `sys_data_region` VALUES (1537, '大马村', 4, '130434', '130434209', 'd');
INSERT INTO `sys_data_region` VALUES (1538, '北台头', 4, '130434', '130434212', 'b');
INSERT INTO `sys_data_region` VALUES (1539, '曲周', 3, '1304', '130435', 'q');
INSERT INTO `sys_data_region` VALUES (1540, '曲周镇', 4, '130435', '130435100', 'q');
INSERT INTO `sys_data_region` VALUES (1541, '安寨', 4, '130435', '130435101', 'a');
INSERT INTO `sys_data_region` VALUES (1542, '侯村', 4, '130435', '130435102', 'h');
INSERT INTO `sys_data_region` VALUES (1543, '河南疃', 4, '130435', '130435103', 'h');
INSERT INTO `sys_data_region` VALUES (1544, '第四疃', 4, '130435', '130435104', 'd');
INSERT INTO `sys_data_region` VALUES (1545, '白寨', 4, '130435', '130435105', 'b');
INSERT INTO `sys_data_region` VALUES (1546, '槐桥', 4, '130435', '130435200', 'h');
INSERT INTO `sys_data_region` VALUES (1547, '南里岳', 4, '130435', '130435201', 'n');
INSERT INTO `sys_data_region` VALUES (1548, '大河道', 4, '130435', '130435203', 'd');
INSERT INTO `sys_data_region` VALUES (1549, '依庄', 4, '130435', '130435204', 'y');
INSERT INTO `sys_data_region` VALUES (1550, '武安', 3, '1304', '130481', 'w');
INSERT INTO `sys_data_region` VALUES (1551, '武安镇', 4, '130481', '130481100', 'w');
INSERT INTO `sys_data_region` VALUES (1552, '康二城', 4, '130481', '130481101', 'k');
INSERT INTO `sys_data_region` VALUES (1553, '午汲', 4, '130481', '130481102', 'w');
INSERT INTO `sys_data_region` VALUES (1554, '磁山', 4, '130481', '130481103', 'c');
INSERT INTO `sys_data_region` VALUES (1555, '伯延', 4, '130481', '130481104', 'b');
INSERT INTO `sys_data_region` VALUES (1556, '淑村', 4, '130481', '130481105', 's');
INSERT INTO `sys_data_region` VALUES (1557, '大同', 4, '130481', '130481106', 'd');
INSERT INTO `sys_data_region` VALUES (1558, '邑城', 4, '130481', '130481107', 'y');
INSERT INTO `sys_data_region` VALUES (1559, '矿山', 4, '130481', '130481108', 'k');
INSERT INTO `sys_data_region` VALUES (1560, '贺进', 4, '130481', '130481109', 'h');
INSERT INTO `sys_data_region` VALUES (1561, '阳邑', 4, '130481', '130481110', 'y');
INSERT INTO `sys_data_region` VALUES (1562, '徘徊', 4, '130481', '130481111', 'p');
INSERT INTO `sys_data_region` VALUES (1563, '冶陶', 4, '130481', '130481112', 'y');
INSERT INTO `sys_data_region` VALUES (1564, '上团城', 4, '130481', '130481200', 's');
INSERT INTO `sys_data_region` VALUES (1565, '北安庄', 4, '130481', '130481201', 'b');
INSERT INTO `sys_data_region` VALUES (1566, '北安乐', 4, '130481', '130481202', 'b');
INSERT INTO `sys_data_region` VALUES (1567, '西土山', 4, '130481', '130481203', 'x');
INSERT INTO `sys_data_region` VALUES (1568, '西寺庄', 4, '130481', '130481204', 'x');
INSERT INTO `sys_data_region` VALUES (1569, '活水', 4, '130481', '130481205', 'h');
INSERT INTO `sys_data_region` VALUES (1570, '石洞', 4, '130481', '130481206', 's');
INSERT INTO `sys_data_region` VALUES (1571, '管陶', 4, '130481', '130481207', 'g');
INSERT INTO `sys_data_region` VALUES (1572, '马家庄', 4, '130481', '130481208', 'm');
INSERT INTO `sys_data_region` VALUES (1573, '邢台', 2, '13', '1305', 'x');
INSERT INTO `sys_data_region` VALUES (1574, '襄都', 3, '1305', '130502', 'x');
INSERT INTO `sys_data_region` VALUES (1575, '南长街', 4, '130502', '130502001', 'n');
INSERT INTO `sys_data_region` VALUES (1576, '北大街', 4, '130502', '130502002', 'b');
INSERT INTO `sys_data_region` VALUES (1577, '西大街', 4, '130502', '130502003', 'x');
INSERT INTO `sys_data_region` VALUES (1578, '西门里', 4, '130502', '130502004', 'x');
INSERT INTO `sys_data_region` VALUES (1579, '豫让桥', 4, '130502', '130502005', 'y');
INSERT INTO `sys_data_region` VALUES (1580, '泉东', 4, '130502', '130502006', 'q');
INSERT INTO `sys_data_region` VALUES (1581, '东郭村', 4, '130502', '130502100', 'd');
INSERT INTO `sys_data_region` VALUES (1582, '王快', 4, '130502', '130502101', 'w');
INSERT INTO `sys_data_region` VALUES (1583, '晏家屯', 4, '130502', '130502102', 'y');
INSERT INTO `sys_data_region` VALUES (1584, '祝村', 4, '130502', '130502103', 'z');
INSERT INTO `sys_data_region` VALUES (1585, '东汪', 4, '130502', '130502104', 'd');
INSERT INTO `sys_data_region` VALUES (1586, '大梁庄', 4, '130502', '130502200', 'd');
INSERT INTO `sys_data_region` VALUES (1587, '市高新技术开发区', 4, '130502', '130502400', 's');
INSERT INTO `sys_data_region` VALUES (1588, '信都', 3, '1305', '130503', 'x');
INSERT INTO `sys_data_region` VALUES (1589, '钢铁路', 4, '130503', '130503001', 'g');
INSERT INTO `sys_data_region` VALUES (1590, '中兴路', 4, '130503', '130503002', 'z');
INSERT INTO `sys_data_region` VALUES (1591, '达活泉', 4, '130503', '130503003', 'd');
INSERT INTO `sys_data_region` VALUES (1592, '张宽', 4, '130503', '130503004', 'z');
INSERT INTO `sys_data_region` VALUES (1593, '章村', 4, '130503', '130503005', 'z');
INSERT INTO `sys_data_region` VALUES (1594, '中华大街', 4, '130503', '130503006', 'z');
INSERT INTO `sys_data_region` VALUES (1595, '团结路', 4, '130503', '130503007', 't');
INSERT INTO `sys_data_region` VALUES (1596, '泉西', 4, '130503', '130503008', 'q');
INSERT INTO `sys_data_region` VALUES (1597, '南大郭', 4, '130503', '130503100', 'n');
INSERT INTO `sys_data_region` VALUES (1598, '李村', 4, '130503', '130503101', 'l');
INSERT INTO `sys_data_region` VALUES (1599, '南石门', 4, '130503', '130503102', 'n');
INSERT INTO `sys_data_region` VALUES (1600, '羊范', 4, '130503', '130503103', 'y');
INSERT INTO `sys_data_region` VALUES (1601, '皇寺', 4, '130503', '130503104', 'h');
INSERT INTO `sys_data_region` VALUES (1602, '会宁', 4, '130503', '130503105', 'h');
INSERT INTO `sys_data_region` VALUES (1603, '西黄村', 4, '130503', '130503106', 'x');
INSERT INTO `sys_data_region` VALUES (1604, '路罗', 4, '130503', '130503107', 'l');
INSERT INTO `sys_data_region` VALUES (1605, '将军墓', 4, '130503', '130503108', 'j');
INSERT INTO `sys_data_region` VALUES (1606, '浆水', 4, '130503', '130503109', 'j');
INSERT INTO `sys_data_region` VALUES (1607, '宋家庄', 4, '130503', '130503110', 's');
INSERT INTO `sys_data_region` VALUES (1608, '太子井', 4, '130503', '130503200', 't');
INSERT INTO `sys_data_region` VALUES (1609, '龙泉寺', 4, '130503', '130503201', 'l');
INSERT INTO `sys_data_region` VALUES (1610, '北小庄', 4, '130503', '130503202', 'b');
INSERT INTO `sys_data_region` VALUES (1611, '城计头', 4, '130503', '130503203', 'c');
INSERT INTO `sys_data_region` VALUES (1612, '白岸', 4, '130503', '130503204', 'b');
INSERT INTO `sys_data_region` VALUES (1613, '冀家村', 4, '130503', '130503205', 'j');
INSERT INTO `sys_data_region` VALUES (1614, '任泽', 3, '1305', '130505', 'r');
INSERT INTO `sys_data_region` VALUES (1615, '任城', 4, '130505', '130505100', 'r');
INSERT INTO `sys_data_region` VALUES (1616, '邢家湾', 4, '130505', '130505101', 'x');
INSERT INTO `sys_data_region` VALUES (1617, '辛店', 4, '130505', '130505102', 'x');
INSERT INTO `sys_data_region` VALUES (1618, '天口', 4, '130505', '130505103', 't');
INSERT INTO `sys_data_region` VALUES (1619, '西固城', 4, '130505', '130505200', 'x');
INSERT INTO `sys_data_region` VALUES (1620, '永福庄', 4, '130505', '130505201', 'y');
INSERT INTO `sys_data_region` VALUES (1621, '大屯', 4, '130505', '130505202', 'd');
INSERT INTO `sys_data_region` VALUES (1622, '骆庄', 4, '130505', '130505204', 'l');
INSERT INTO `sys_data_region` VALUES (1623, '南和', 3, '1305', '130506', 'n');
INSERT INTO `sys_data_region` VALUES (1624, '和阳', 4, '130506', '130506100', 'h');
INSERT INTO `sys_data_region` VALUES (1625, '贾宋', 4, '130506', '130506101', 'j');
INSERT INTO `sys_data_region` VALUES (1626, '郝桥', 4, '130506', '130506102', 'h');
INSERT INTO `sys_data_region` VALUES (1627, '三思', 4, '130506', '130506103', 's');
INSERT INTO `sys_data_region` VALUES (1628, '河郭', 4, '130506', '130506104', 'h');
INSERT INTO `sys_data_region` VALUES (1629, '东三召', 4, '130506', '130506200', 'd');
INSERT INTO `sys_data_region` VALUES (1630, '阎里', 4, '130506', '130506201', 'y');
INSERT INTO `sys_data_region` VALUES (1631, '史召', 4, '130506', '130506203', 's');
INSERT INTO `sys_data_region` VALUES (1632, '临城', 3, '1305', '130522', 'l');
INSERT INTO `sys_data_region` VALUES (1633, '临城镇', 4, '130522', '130522100', 'l');
INSERT INTO `sys_data_region` VALUES (1634, '东镇', 4, '130522', '130522101', 'd');
INSERT INTO `sys_data_region` VALUES (1635, '郝庄', 4, '130522', '130522102', 'h');
INSERT INTO `sys_data_region` VALUES (1636, '西竖', 4, '130522', '130522103', 'x');
INSERT INTO `sys_data_region` VALUES (1637, '黑城', 4, '130522', '130522104', 'h');
INSERT INTO `sys_data_region` VALUES (1638, '鸭鸽营', 4, '130522', '130522201', 'y');
INSERT INTO `sys_data_region` VALUES (1639, '石城', 4, '130522', '130522203', 's');
INSERT INTO `sys_data_region` VALUES (1640, '赵庄', 4, '130522', '130522205', 'z');
INSERT INTO `sys_data_region` VALUES (1641, '内丘', 3, '1305', '130523', 'n');
INSERT INTO `sys_data_region` VALUES (1642, '内丘镇', 4, '130523', '130523100', 'n');
INSERT INTO `sys_data_region` VALUES (1643, '大孟村', 4, '130523', '130523101', 'd');
INSERT INTO `sys_data_region` VALUES (1644, '金店', 4, '130523', '130523102', 'j');
INSERT INTO `sys_data_region` VALUES (1645, '官庄', 4, '130523', '130523103', 'g');
INSERT INTO `sys_data_region` VALUES (1646, '柳林', 4, '130523', '130523104', 'l');
INSERT INTO `sys_data_region` VALUES (1647, '五郭店', 4, '130523', '130523200', 'w');
INSERT INTO `sys_data_region` VALUES (1648, '南赛', 4, '130523', '130523203', 'n');
INSERT INTO `sys_data_region` VALUES (1649, '獐獏', 4, '130523', '130523204', 'z');
INSERT INTO `sys_data_region` VALUES (1650, '侯家庄', 4, '130523', '130523205', 'h');
INSERT INTO `sys_data_region` VALUES (1651, '柏乡', 3, '1305', '130524', 'b');
INSERT INTO `sys_data_region` VALUES (1652, '柏乡镇', 4, '130524', '130524100', 'b');
INSERT INTO `sys_data_region` VALUES (1653, '固城店', 4, '130524', '130524101', 'g');
INSERT INTO `sys_data_region` VALUES (1654, '西汪', 4, '130524', '130524102', 'x');
INSERT INTO `sys_data_region` VALUES (1655, '龙华', 4, '130524', '130524103', 'l');
INSERT INTO `sys_data_region` VALUES (1656, '王家庄', 4, '130524', '130524200', 'w');
INSERT INTO `sys_data_region` VALUES (1657, '内步', 4, '130524', '130524203', 'n');
INSERT INTO `sys_data_region` VALUES (1658, '隆尧', 3, '1305', '130525', 'l');
INSERT INTO `sys_data_region` VALUES (1659, '隆尧镇', 4, '130525', '130525100', 'l');
INSERT INTO `sys_data_region` VALUES (1660, '魏家庄', 4, '130525', '130525101', 'w');
INSERT INTO `sys_data_region` VALUES (1661, '尹村', 4, '130525', '130525102', 'y');
INSERT INTO `sys_data_region` VALUES (1662, '山口', 4, '130525', '130525103', 's');
INSERT INTO `sys_data_region` VALUES (1663, '莲子', 4, '130525', '130525104', 'l');
INSERT INTO `sys_data_region` VALUES (1664, '固城', 4, '130525', '130525105', 'g');
INSERT INTO `sys_data_region` VALUES (1665, '东良', 4, '130525', '130525106', 'd');
INSERT INTO `sys_data_region` VALUES (1666, '北楼', 4, '130525', '130525200', 'b');
INSERT INTO `sys_data_region` VALUES (1667, '双碑', 4, '130525', '130525202', 's');
INSERT INTO `sys_data_region` VALUES (1668, '牛家桥', 4, '130525', '130525203', 'n');
INSERT INTO `sys_data_region` VALUES (1669, '千户营', 4, '130525', '130525204', 'q');
INSERT INTO `sys_data_region` VALUES (1670, '大张庄', 4, '130525', '130525205', 'd');
INSERT INTO `sys_data_region` VALUES (1671, '宁晋', 3, '1305', '130528', 'n');
INSERT INTO `sys_data_region` VALUES (1672, '宁北', 4, '130528', '130528001', 'n');
INSERT INTO `sys_data_region` VALUES (1673, '凤凰', 4, '130528', '130528100', 'f');
INSERT INTO `sys_data_region` VALUES (1674, '河渠', 4, '130528', '130528101', 'h');
INSERT INTO `sys_data_region` VALUES (1675, '北河庄', 4, '130528', '130528102', 'b');
INSERT INTO `sys_data_region` VALUES (1676, '耿庄桥', 4, '130528', '130528103', 'g');
INSERT INTO `sys_data_region` VALUES (1677, '东汪', 4, '130528', '130528104', 'd');
INSERT INTO `sys_data_region` VALUES (1678, '贾家口', 4, '130528', '130528105', 'j');
INSERT INTO `sys_data_region` VALUES (1679, '四芝兰', 4, '130528', '130528106', 's');
INSERT INTO `sys_data_region` VALUES (1680, '大陆村', 4, '130528', '130528107', 'd');
INSERT INTO `sys_data_region` VALUES (1681, '换马店', 4, '130528', '130528108', 'h');
INSERT INTO `sys_data_region` VALUES (1682, '苏家庄', 4, '130528', '130528109', 's');
INSERT INTO `sys_data_region` VALUES (1683, '唐邱', 4, '130528', '130528110', 't');
INSERT INTO `sys_data_region` VALUES (1684, '大曹庄', 4, '130528', '130528111', 'd');
INSERT INTO `sys_data_region` VALUES (1685, '侯口', 4, '130528', '130528112', 'h');
INSERT INTO `sys_data_region` VALUES (1686, '纪昌庄', 4, '130528', '130528202', 'j');
INSERT INTO `sys_data_region` VALUES (1687, '北鱼', 4, '130528', '130528205', 'b');
INSERT INTO `sys_data_region` VALUES (1688, '徐家河', 4, '130528', '130528206', 'x');
INSERT INTO `sys_data_region` VALUES (1689, '巨鹿', 3, '1305', '130529', 'j');
INSERT INTO `sys_data_region` VALUES (1690, '巨鹿镇', 4, '130529', '130529100', 'j');
INSERT INTO `sys_data_region` VALUES (1691, '王虎寨', 4, '130529', '130529101', 'w');
INSERT INTO `sys_data_region` VALUES (1692, '西郭城', 4, '130529', '130529102', 'x');
INSERT INTO `sys_data_region` VALUES (1693, '官亭', 4, '130529', '130529103', 'g');
INSERT INTO `sys_data_region` VALUES (1694, '阎疃', 4, '130529', '130529104', 'y');
INSERT INTO `sys_data_region` VALUES (1695, '小吕寨', 4, '130529', '130529105', 'x');
INSERT INTO `sys_data_region` VALUES (1696, '苏家营', 4, '130529', '130529106', 's');
INSERT INTO `sys_data_region` VALUES (1697, '观寨', 4, '130529', '130529107', 'g');
INSERT INTO `sys_data_region` VALUES (1698, '堤村', 4, '130529', '130529200', 'd');
INSERT INTO `sys_data_region` VALUES (1699, '张王疃', 4, '130529', '130529201', 'z');
INSERT INTO `sys_data_region` VALUES (1700, '新河', 3, '1305', '130530', 'x');
INSERT INTO `sys_data_region` VALUES (1701, '新河镇', 4, '130530', '130530100', 'x');
INSERT INTO `sys_data_region` VALUES (1702, '寻寨', 4, '130530', '130530101', 'x');
INSERT INTO `sys_data_region` VALUES (1703, '白神首', 4, '130530', '130530200', 'b');
INSERT INTO `sys_data_region` VALUES (1704, '荆家庄', 4, '130530', '130530201', 'j');
INSERT INTO `sys_data_region` VALUES (1705, '西流', 4, '130530', '130530202', 'x');
INSERT INTO `sys_data_region` VALUES (1706, '仁让里', 4, '130530', '130530203', 'r');
INSERT INTO `sys_data_region` VALUES (1707, '广宗', 3, '1305', '130531', 'g');
INSERT INTO `sys_data_region` VALUES (1708, '广宗镇', 4, '130531', '130531100', 'g');
INSERT INTO `sys_data_region` VALUES (1709, '冯家寨', 4, '130531', '130531101', 'f');
INSERT INTO `sys_data_region` VALUES (1710, '北塘疃', 4, '130531', '130531102', 'b');
INSERT INTO `sys_data_region` VALUES (1711, '核桃园', 4, '130531', '130531103', 'h');
INSERT INTO `sys_data_region` VALUES (1712, '葫芦', 4, '130531', '130531200', 'h');
INSERT INTO `sys_data_region` VALUES (1713, '大平台', 4, '130531', '130531201', 'd');
INSERT INTO `sys_data_region` VALUES (1714, '件只', 4, '130531', '130531202', 'j');
INSERT INTO `sys_data_region` VALUES (1715, '东召', 4, '130531', '130531204', 'd');
INSERT INTO `sys_data_region` VALUES (1716, '平乡', 3, '1305', '130532', 'p');
INSERT INTO `sys_data_region` VALUES (1717, '丰州', 4, '130532', '130532100', 'f');
INSERT INTO `sys_data_region` VALUES (1718, '平乡镇', 4, '130532', '130532101', 'p');
INSERT INTO `sys_data_region` VALUES (1719, '河古庙', 4, '130532', '130532102', 'h');
INSERT INTO `sys_data_region` VALUES (1720, '节固', 4, '130532', '130532200', 'j');
INSERT INTO `sys_data_region` VALUES (1721, '油召', 4, '130532', '130532201', 'y');
INSERT INTO `sys_data_region` VALUES (1722, '田付村', 4, '130532', '130532202', 't');
INSERT INTO `sys_data_region` VALUES (1723, '寻召', 4, '130532', '130532203', 'x');
INSERT INTO `sys_data_region` VALUES (1724, '威县', 3, '1305', '130533', 'w');
INSERT INTO `sys_data_region` VALUES (1725, '洺州', 4, '130533', '130533100', 'm');
INSERT INTO `sys_data_region` VALUES (1726, '梨园屯', 4, '130533', '130533101', 'l');
INSERT INTO `sys_data_region` VALUES (1727, '章台', 4, '130533', '130533102', 'z');
INSERT INTO `sys_data_region` VALUES (1728, '侯贯', 4, '130533', '130533103', 'h');
INSERT INTO `sys_data_region` VALUES (1729, '七级', 4, '130533', '130533104', 'q');
INSERT INTO `sys_data_region` VALUES (1730, '贺营', 4, '130533', '130533105', 'h');
INSERT INTO `sys_data_region` VALUES (1731, '方家营', 4, '130533', '130533106', 'f');
INSERT INTO `sys_data_region` VALUES (1732, '常庄', 4, '130533', '130533107', 'c');
INSERT INTO `sys_data_region` VALUES (1733, '第什营', 4, '130533', '130533108', 'd');
INSERT INTO `sys_data_region` VALUES (1734, '赵村', 4, '130533', '130533109', 'z');
INSERT INTO `sys_data_region` VALUES (1735, '贺钊', 4, '130533', '130533110', 'h');
INSERT INTO `sys_data_region` VALUES (1736, '固献', 4, '130533', '130533111', 'g');
INSERT INTO `sys_data_region` VALUES (1737, '枣园', 4, '130533', '130533202', 'z');
INSERT INTO `sys_data_region` VALUES (1738, '张家营', 4, '130533', '130533206', 'z');
INSERT INTO `sys_data_region` VALUES (1739, '常屯', 4, '130533', '130533207', 'c');
INSERT INTO `sys_data_region` VALUES (1740, '高公庄', 4, '130533', '130533209', 'g');
INSERT INTO `sys_data_region` VALUES (1741, '清河', 3, '1305', '130534', 'q');
INSERT INTO `sys_data_region` VALUES (1742, '葛仙庄', 4, '130534', '130534100', 'g');
INSERT INTO `sys_data_region` VALUES (1743, '连庄', 4, '130534', '130534101', 'l');
INSERT INTO `sys_data_region` VALUES (1744, '油坊', 4, '130534', '130534102', 'y');
INSERT INTO `sys_data_region` VALUES (1745, '谢炉', 4, '130534', '130534103', 'x');
INSERT INTO `sys_data_region` VALUES (1746, '王官庄', 4, '130534', '130534104', 'w');
INSERT INTO `sys_data_region` VALUES (1747, '坝营', 4, '130534', '130534105', 'b');
INSERT INTO `sys_data_region` VALUES (1748, '临西', 3, '1305', '130535', 'l');
INSERT INTO `sys_data_region` VALUES (1749, '临西镇', 4, '130535', '130535100', 'l');
INSERT INTO `sys_data_region` VALUES (1750, '河西', 4, '130535', '130535101', 'h');
INSERT INTO `sys_data_region` VALUES (1751, '下堡寺', 4, '130535', '130535102', 'x');
INSERT INTO `sys_data_region` VALUES (1752, '尖冢', 4, '130535', '130535103', 'j');
INSERT INTO `sys_data_region` VALUES (1753, '老官寨', 4, '130535', '130535104', 'l');
INSERT INTO `sys_data_region` VALUES (1754, '吕寨', 4, '130535', '130535105', 'l');
INSERT INTO `sys_data_region` VALUES (1755, '大刘庄', 4, '130535', '130535106', 'd');
INSERT INTO `sys_data_region` VALUES (1756, '东枣园', 4, '130535', '130535200', 'd');
INSERT INTO `sys_data_region` VALUES (1757, '摇鞍镇', 4, '130535', '130535203', 'y');
INSERT INTO `sys_data_region` VALUES (1758, '南宫', 3, '1305', '130581', 'n');
INSERT INTO `sys_data_region` VALUES (1759, '凤岗', 4, '130581', '130581001', 'f');
INSERT INTO `sys_data_region` VALUES (1760, '南杜', 4, '130581', '130581002', 'n');
INSERT INTO `sys_data_region` VALUES (1761, '北胡', 4, '130581', '130581003', 'b');
INSERT INTO `sys_data_region` VALUES (1762, '西丁', 4, '130581', '130581004', 'x');
INSERT INTO `sys_data_region` VALUES (1763, '苏村', 4, '130581', '130581100', 's');
INSERT INTO `sys_data_region` VALUES (1764, '大高村', 4, '130581', '130581101', 'd');
INSERT INTO `sys_data_region` VALUES (1765, '垂杨', 4, '130581', '130581102', 'c');
INSERT INTO `sys_data_region` VALUES (1766, '明化', 4, '130581', '130581103', 'm');
INSERT INTO `sys_data_region` VALUES (1767, '段芦头', 4, '130581', '130581104', 'd');
INSERT INTO `sys_data_region` VALUES (1768, '紫冢', 4, '130581', '130581105', 'z');
INSERT INTO `sys_data_region` VALUES (1769, '大村', 4, '130581', '130581200', 'd');
INSERT INTO `sys_data_region` VALUES (1770, '南便村', 4, '130581', '130581201', 'n');
INSERT INTO `sys_data_region` VALUES (1771, '大屯', 4, '130581', '130581202', 'd');
INSERT INTO `sys_data_region` VALUES (1772, '王道寨', 4, '130581', '130581203', 'w');
INSERT INTO `sys_data_region` VALUES (1773, '薛吴村', 4, '130581', '130581204', 'x');
INSERT INTO `sys_data_region` VALUES (1774, '沙河', 3, '1305', '130582', 's');
INSERT INTO `sys_data_region` VALUES (1775, '褡裢', 4, '130582', '130582001', 'd');
INSERT INTO `sys_data_region` VALUES (1776, '桥东', 4, '130582', '130582002', 'q');
INSERT INTO `sys_data_region` VALUES (1777, '桥西', 4, '130582', '130582003', 'q');
INSERT INTO `sys_data_region` VALUES (1778, '赞善', 4, '130582', '130582004', 'z');
INSERT INTO `sys_data_region` VALUES (1779, '周庄', 4, '130582', '130582005', 'z');
INSERT INTO `sys_data_region` VALUES (1780, '新城', 4, '130582', '130582101', 'x');
INSERT INTO `sys_data_region` VALUES (1781, '白塔', 4, '130582', '130582102', 'b');
INSERT INTO `sys_data_region` VALUES (1782, '十里亭', 4, '130582', '130582103', 's');
INSERT INTO `sys_data_region` VALUES (1783, '綦村', 4, '130582', '130582104', 'q');
INSERT INTO `sys_data_region` VALUES (1784, '沙河城', 4, '130582', '130582105', 's');
INSERT INTO `sys_data_region` VALUES (1785, '留村', 4, '130582', '130582106', 'l');
INSERT INTO `sys_data_region` VALUES (1786, '册井', 4, '130582', '130582201', 'c');
INSERT INTO `sys_data_region` VALUES (1787, '刘石岗', 4, '130582', '130582202', 'l');
INSERT INTO `sys_data_region` VALUES (1788, '柴关', 4, '130582', '130582203', 'c');
INSERT INTO `sys_data_region` VALUES (1789, '蝉房', 4, '130582', '130582204', 'c');
INSERT INTO `sys_data_region` VALUES (1790, '保定', 2, '13', '1306', 'b');
INSERT INTO `sys_data_region` VALUES (1791, '竞秀', 3, '1306', '130602', 'j');
INSERT INTO `sys_data_region` VALUES (1792, '先锋', 4, '130602', '130602001', 'x');
INSERT INTO `sys_data_region` VALUES (1793, '新市场', 4, '130602', '130602002', 'x');
INSERT INTO `sys_data_region` VALUES (1794, '东风路', 4, '130602', '130602003', 'd');
INSERT INTO `sys_data_region` VALUES (1795, '建南', 4, '130602', '130602004', 'j');
INSERT INTO `sys_data_region` VALUES (1796, '韩北', 4, '130602', '130602005', 'h');
INSERT INTO `sys_data_region` VALUES (1797, '大激店', 4, '130602', '130602100', 'd');
INSERT INTO `sys_data_region` VALUES (1798, '颉庄', 4, '130602', '130602200', 'j');
INSERT INTO `sys_data_region` VALUES (1799, '富昌', 4, '130602', '130602201', 'f');
INSERT INTO `sys_data_region` VALUES (1800, '韩村', 4, '130602', '130602202', 'h');
INSERT INTO `sys_data_region` VALUES (1801, '南奇', 4, '130602', '130602203', 'n');
INSERT INTO `sys_data_region` VALUES (1802, '大马坊', 4, '130602', '130602205', 'd');
INSERT INTO `sys_data_region` VALUES (1803, '保定国家高新区', 4, '130602', '130602400', 'b');
INSERT INTO `sys_data_region` VALUES (1804, '莲池', 3, '1306', '130606', 'l');
INSERT INTO `sys_data_region` VALUES (1805, '和平里', 4, '130606', '130606001', 'h');
INSERT INTO `sys_data_region` VALUES (1806, '五四路', 4, '130606', '130606002', 'w');
INSERT INTO `sys_data_region` VALUES (1807, '西关', 4, '130606', '130606003', 'x');
INSERT INTO `sys_data_region` VALUES (1808, '中华路', 4, '130606', '130606004', 'z');
INSERT INTO `sys_data_region` VALUES (1809, '东关', 4, '130606', '130606005', 'd');
INSERT INTO `sys_data_region` VALUES (1810, '联盟路', 4, '130606', '130606006', 'l');
INSERT INTO `sys_data_region` VALUES (1811, '红星', 4, '130606', '130606007', 'h');
INSERT INTO `sys_data_region` VALUES (1812, '裕华', 4, '130606', '130606008', 'y');
INSERT INTO `sys_data_region` VALUES (1813, '永华', 4, '130606', '130606009', 'y');
INSERT INTO `sys_data_region` VALUES (1814, '南关', 4, '130606', '130606010', 'n');
INSERT INTO `sys_data_region` VALUES (1815, '百楼', 4, '130606', '130606100', 'b');
INSERT INTO `sys_data_region` VALUES (1816, '韩庄', 4, '130606', '130606200', 'h');
INSERT INTO `sys_data_region` VALUES (1817, '东金庄', 4, '130606', '130606201', 'd');
INSERT INTO `sys_data_region` VALUES (1818, '杨庄', 4, '130606', '130606203', 'y');
INSERT INTO `sys_data_region` VALUES (1819, '南大园', 4, '130606', '130606204', 'n');
INSERT INTO `sys_data_region` VALUES (1820, '焦庄', 4, '130606', '130606205', 'j');
INSERT INTO `sys_data_region` VALUES (1821, '五尧', 4, '130606', '130606206', 'w');
INSERT INTO `sys_data_region` VALUES (1822, '满城', 3, '1306', '130607', 'm');
INSERT INTO `sys_data_region` VALUES (1823, '满城镇', 4, '130607', '130607100', 'm');
INSERT INTO `sys_data_region` VALUES (1824, '大册营', 4, '130607', '130607101', 'd');
INSERT INTO `sys_data_region` VALUES (1825, '神星', 4, '130607', '130607102', 's');
INSERT INTO `sys_data_region` VALUES (1826, '南韩村', 4, '130607', '130607103', 'n');
INSERT INTO `sys_data_region` VALUES (1827, '方顺桥', 4, '130607', '130607104', 'f');
INSERT INTO `sys_data_region` VALUES (1828, '于家庄', 4, '130607', '130607105', 'y');
INSERT INTO `sys_data_region` VALUES (1829, '要庄', 4, '130607', '130607203', 'y');
INSERT INTO `sys_data_region` VALUES (1830, '白龙', 4, '130607', '130607204', 'b');
INSERT INTO `sys_data_region` VALUES (1831, '石井', 4, '130607', '130607205', 's');
INSERT INTO `sys_data_region` VALUES (1832, '坨南', 4, '130607', '130607206', 't');
INSERT INTO `sys_data_region` VALUES (1833, '刘家台', 4, '130607', '130607207', 'l');
INSERT INTO `sys_data_region` VALUES (1834, '贤台', 4, '130607', '130607208', 'x');
INSERT INTO `sys_data_region` VALUES (1835, '清苑', 3, '1306', '130608', 'q');
INSERT INTO `sys_data_region` VALUES (1836, '清苑镇', 4, '130608', '130608100', 'q');
INSERT INTO `sys_data_region` VALUES (1837, '冉庄', 4, '130608', '130608101', 'r');
INSERT INTO `sys_data_region` VALUES (1838, '阳城', 4, '130608', '130608102', 'y');
INSERT INTO `sys_data_region` VALUES (1839, '魏村', 4, '130608', '130608103', 'w');
INSERT INTO `sys_data_region` VALUES (1840, '温仁', 4, '130608', '130608104', 'w');
INSERT INTO `sys_data_region` VALUES (1841, '张登', 4, '130608', '130608105', 'z');
INSERT INTO `sys_data_region` VALUES (1842, '大庄', 4, '130608', '130608106', 'd');
INSERT INTO `sys_data_region` VALUES (1843, '臧村', 4, '130608', '130608107', 'z');
INSERT INTO `sys_data_region` VALUES (1844, '望亭', 4, '130608', '130608108', 'w');
INSERT INTO `sys_data_region` VALUES (1845, '东闾', 4, '130608', '130608109', 'd');
INSERT INTO `sys_data_region` VALUES (1846, '白团', 4, '130608', '130608200', 'b');
INSERT INTO `sys_data_region` VALUES (1847, '北店', 4, '130608', '130608201', 'b');
INSERT INTO `sys_data_region` VALUES (1848, '石桥', 4, '130608', '130608202', 's');
INSERT INTO `sys_data_region` VALUES (1849, '李庄', 4, '130608', '130608203', 'l');
INSERT INTO `sys_data_region` VALUES (1850, '北王力', 4, '130608', '130608204', 'b');
INSERT INTO `sys_data_region` VALUES (1851, '何桥', 4, '130608', '130608206', 'h');
INSERT INTO `sys_data_region` VALUES (1852, '孙村', 4, '130608', '130608207', 's');
INSERT INTO `sys_data_region` VALUES (1853, '阎庄', 4, '130608', '130608208', 'y');
INSERT INTO `sys_data_region` VALUES (1854, '徐水', 3, '1306', '130609', 'x');
INSERT INTO `sys_data_region` VALUES (1855, '安肃', 4, '130609', '130609100', 'a');
INSERT INTO `sys_data_region` VALUES (1856, '崔庄', 4, '130609', '130609101', 'c');
INSERT INTO `sys_data_region` VALUES (1857, '大因', 4, '130609', '130609102', 'd');
INSERT INTO `sys_data_region` VALUES (1858, '遂城', 4, '130609', '130609103', 's');
INSERT INTO `sys_data_region` VALUES (1859, '高林村', 4, '130609', '130609104', 'g');
INSERT INTO `sys_data_region` VALUES (1860, '大王店', 4, '130609', '130609105', 'd');
INSERT INTO `sys_data_region` VALUES (1861, '漕河', 4, '130609', '130609106', 'c');
INSERT INTO `sys_data_region` VALUES (1862, '留村', 4, '130609', '130609107', 'l');
INSERT INTO `sys_data_region` VALUES (1863, '东史端', 4, '130609', '130609108', 'd');
INSERT INTO `sys_data_region` VALUES (1864, '正村', 4, '130609', '130609109', 'z');
INSERT INTO `sys_data_region` VALUES (1865, '户木', 4, '130609', '130609203', 'h');
INSERT INTO `sys_data_region` VALUES (1866, '瀑河', 4, '130609', '130609204', 'p');
INSERT INTO `sys_data_region` VALUES (1867, '东釜山', 4, '130609', '130609205', 'd');
INSERT INTO `sys_data_region` VALUES (1868, '义联庄', 4, '130609', '130609206', 'y');
INSERT INTO `sys_data_region` VALUES (1869, '涞水', 3, '1306', '130623', 'l');
INSERT INTO `sys_data_region` VALUES (1870, '涞水镇', 4, '130623', '130623100', 'l');
INSERT INTO `sys_data_region` VALUES (1871, '永阳', 4, '130623', '130623101', 'y');
INSERT INTO `sys_data_region` VALUES (1872, '义安', 4, '130623', '130623102', 'y');
INSERT INTO `sys_data_region` VALUES (1873, '石亭', 4, '130623', '130623103', 's');
INSERT INTO `sys_data_region` VALUES (1874, '赵各庄', 4, '130623', '130623104', 'z');
INSERT INTO `sys_data_region` VALUES (1875, '九龙', 4, '130623', '130623105', 'j');
INSERT INTO `sys_data_region` VALUES (1876, '三坡', 4, '130623', '130623106', 's');
INSERT INTO `sys_data_region` VALUES (1877, '一渡', 4, '130623', '130623107', 'y');
INSERT INTO `sys_data_region` VALUES (1878, '娄村', 4, '130623', '130623108', 'l');
INSERT INTO `sys_data_region` VALUES (1879, '王村', 4, '130623', '130623109', 'w');
INSERT INTO `sys_data_region` VALUES (1880, '明义', 4, '130623', '130623110', 'm');
INSERT INTO `sys_data_region` VALUES (1881, '东文山', 4, '130623', '130623111', 'd');
INSERT INTO `sys_data_region` VALUES (1882, '其中口', 4, '130623', '130623205', 'q');
INSERT INTO `sys_data_region` VALUES (1883, '龙门口', 4, '130623', '130623206', 'l');
INSERT INTO `sys_data_region` VALUES (1884, '胡家庄', 4, '130623', '130623207', 'h');
INSERT INTO `sys_data_region` VALUES (1885, '阜平', 3, '1306', '130624', 'f');
INSERT INTO `sys_data_region` VALUES (1886, '阜平镇', 4, '130624', '130624100', 'f');
INSERT INTO `sys_data_region` VALUES (1887, '龙泉关', 4, '130624', '130624101', 'l');
INSERT INTO `sys_data_region` VALUES (1888, '平阳', 4, '130624', '130624102', 'p');
INSERT INTO `sys_data_region` VALUES (1889, '城南庄', 4, '130624', '130624103', 'c');
INSERT INTO `sys_data_region` VALUES (1890, '天生桥', 4, '130624', '130624104', 't');
INSERT INTO `sys_data_region` VALUES (1891, '王林口', 4, '130624', '130624105', 'w');
INSERT INTO `sys_data_region` VALUES (1892, '砂窝', 4, '130624', '130624106', 's');
INSERT INTO `sys_data_region` VALUES (1893, '北果园', 4, '130624', '130624107', 'b');
INSERT INTO `sys_data_region` VALUES (1894, '台峪', 4, '130624', '130624202', 't');
INSERT INTO `sys_data_region` VALUES (1895, '大台', 4, '130624', '130624203', 'd');
INSERT INTO `sys_data_region` VALUES (1896, '史家寨', 4, '130624', '130624204', 's');
INSERT INTO `sys_data_region` VALUES (1897, '吴王口', 4, '130624', '130624206', 'w');
INSERT INTO `sys_data_region` VALUES (1898, '下庄', 4, '130624', '130624207', 'x');
INSERT INTO `sys_data_region` VALUES (1899, '定兴', 3, '1306', '130626', 'd');
INSERT INTO `sys_data_region` VALUES (1900, '定兴镇', 4, '130626', '130626100', 'd');
INSERT INTO `sys_data_region` VALUES (1901, '固城', 4, '130626', '130626101', 'g');
INSERT INTO `sys_data_region` VALUES (1902, '贤寓', 4, '130626', '130626102', 'x');
INSERT INTO `sys_data_region` VALUES (1903, '北河', 4, '130626', '130626103', 'b');
INSERT INTO `sys_data_region` VALUES (1904, '天宫寺', 4, '130626', '130626104', 't');
INSERT INTO `sys_data_region` VALUES (1905, '小朱庄', 4, '130626', '130626105', 'x');
INSERT INTO `sys_data_region` VALUES (1906, '姚村', 4, '130626', '130626106', 'y');
INSERT INTO `sys_data_region` VALUES (1907, '杨村', 4, '130626', '130626107', 'y');
INSERT INTO `sys_data_region` VALUES (1908, '高里', 4, '130626', '130626108', 'g');
INSERT INTO `sys_data_region` VALUES (1909, '内章', 4, '130626', '130626109', 'n');
INSERT INTO `sys_data_region` VALUES (1910, '东落堡', 4, '130626', '130626200', 'd');
INSERT INTO `sys_data_region` VALUES (1911, '张家庄', 4, '130626', '130626202', 'z');
INSERT INTO `sys_data_region` VALUES (1912, '肖村', 4, '130626', '130626204', 'x');
INSERT INTO `sys_data_region` VALUES (1913, '柳卓', 4, '130626', '130626205', 'l');
INSERT INTO `sys_data_region` VALUES (1914, '北南蔡', 4, '130626', '130626208', 'b');
INSERT INTO `sys_data_region` VALUES (1915, '李郁庄', 4, '130626', '130626209', 'l');
INSERT INTO `sys_data_region` VALUES (1916, '唐县', 3, '1306', '130627', 't');
INSERT INTO `sys_data_region` VALUES (1917, '仁厚', 4, '130627', '130627100', 'r');
INSERT INTO `sys_data_region` VALUES (1918, '王京', 4, '130627', '130627101', 'w');
INSERT INTO `sys_data_region` VALUES (1919, '高昌', 4, '130627', '130627102', 'g');
INSERT INTO `sys_data_region` VALUES (1920, '北罗', 4, '130627', '130627103', 'b');
INSERT INTO `sys_data_region` VALUES (1921, '白合', 4, '130627', '130627104', 'b');
INSERT INTO `sys_data_region` VALUES (1922, '军城', 4, '130627', '130627105', 'j');
INSERT INTO `sys_data_region` VALUES (1923, '川里', 4, '130627', '130627106', 'c');
INSERT INTO `sys_data_region` VALUES (1924, '长古城', 4, '130627', '130627107', 'c');
INSERT INTO `sys_data_region` VALUES (1925, '罗庄', 4, '130627', '130627108', 'l');
INSERT INTO `sys_data_region` VALUES (1926, '北店头', 4, '130627', '130627109', 'b');
INSERT INTO `sys_data_region` VALUES (1927, '齐家佐', 4, '130627', '130627110', 'q');
INSERT INTO `sys_data_region` VALUES (1928, '都亭', 4, '130627', '130627201', 'd');
INSERT INTO `sys_data_region` VALUES (1929, '南店头', 4, '130627', '130627202', 'n');
INSERT INTO `sys_data_region` VALUES (1930, '雹水', 4, '130627', '130627205', 'b');
INSERT INTO `sys_data_region` VALUES (1931, '大洋', 4, '130627', '130627206', 'd');
INSERT INTO `sys_data_region` VALUES (1932, '迷城', 4, '130627', '130627207', 'm');
INSERT INTO `sys_data_region` VALUES (1933, '羊角', 4, '130627', '130627209', 'y');
INSERT INTO `sys_data_region` VALUES (1934, '石门', 4, '130627', '130627210', 's');
INSERT INTO `sys_data_region` VALUES (1935, '黄石口', 4, '130627', '130627211', 'h');
INSERT INTO `sys_data_region` VALUES (1936, '倒马关', 4, '130627', '130627212', 'd');
INSERT INTO `sys_data_region` VALUES (1937, '高阳', 3, '1306', '130628', 'g');
INSERT INTO `sys_data_region` VALUES (1938, '锦华', 4, '130628', '130628001', 'j');
INSERT INTO `sys_data_region` VALUES (1939, '庞口', 4, '130628', '130628101', 'p');
INSERT INTO `sys_data_region` VALUES (1940, '西演', 4, '130628', '130628102', 'x');
INSERT INTO `sys_data_region` VALUES (1941, '邢家南', 4, '130628', '130628103', 'x');
INSERT INTO `sys_data_region` VALUES (1942, '晋庄', 4, '130628', '130628104', 'j');
INSERT INTO `sys_data_region` VALUES (1943, '小王果庄', 4, '130628', '130628105', 'x');
INSERT INTO `sys_data_region` VALUES (1944, '蒲口', 4, '130628', '130628106', 'p');
INSERT INTO `sys_data_region` VALUES (1945, '庞家佐', 4, '130628', '130628107', 'p');
INSERT INTO `sys_data_region` VALUES (1946, '龙化', 4, '130628', '130628204', 'l');
INSERT INTO `sys_data_region` VALUES (1947, '容城', 3, '1306', '130629', 'r');
INSERT INTO `sys_data_region` VALUES (1948, '容城镇', 4, '130629', '130629100', 'r');
INSERT INTO `sys_data_region` VALUES (1949, '小里', 4, '130629', '130629101', 'x');
INSERT INTO `sys_data_region` VALUES (1950, '南张', 4, '130629', '130629102', 'n');
INSERT INTO `sys_data_region` VALUES (1951, '大河', 4, '130629', '130629103', 'd');
INSERT INTO `sys_data_region` VALUES (1952, '晾马台', 4, '130629', '130629104', 'l');
INSERT INTO `sys_data_region` VALUES (1953, '八于', 4, '130629', '130629200', 'b');
INSERT INTO `sys_data_region` VALUES (1954, '贾光', 4, '130629', '130629201', 'j');
INSERT INTO `sys_data_region` VALUES (1955, '平王', 4, '130629', '130629203', 'p');
INSERT INTO `sys_data_region` VALUES (1956, '涞源', 3, '1306', '130630', 'l');
INSERT INTO `sys_data_region` VALUES (1957, '涞源镇', 4, '130630', '130630100', 'l');
INSERT INTO `sys_data_region` VALUES (1958, '银坊', 4, '130630', '130630101', 'y');
INSERT INTO `sys_data_region` VALUES (1959, '走马驿', 4, '130630', '130630102', 'z');
INSERT INTO `sys_data_region` VALUES (1960, '水堡', 4, '130630', '130630103', 's');
INSERT INTO `sys_data_region` VALUES (1961, '王安', 4, '130630', '130630104', 'w');
INSERT INTO `sys_data_region` VALUES (1962, '白石山', 4, '130630', '130630106', 'b');
INSERT INTO `sys_data_region` VALUES (1963, '南屯', 4, '130630', '130630107', 'n');
INSERT INTO `sys_data_region` VALUES (1964, '杨家庄', 4, '130630', '130630108', 'y');
INSERT INTO `sys_data_region` VALUES (1965, '泉坊', 4, '130630', '130630109', 'q');
INSERT INTO `sys_data_region` VALUES (1966, '北石佛', 4, '130630', '130630110', 'b');
INSERT INTO `sys_data_region` VALUES (1967, '南马庄', 4, '130630', '130630202', 'n');
INSERT INTO `sys_data_region` VALUES (1968, '金家井', 4, '130630', '130630204', 'j');
INSERT INTO `sys_data_region` VALUES (1969, '留家庄', 4, '130630', '130630205', 'l');
INSERT INTO `sys_data_region` VALUES (1970, '上庄', 4, '130630', '130630206', 's');
INSERT INTO `sys_data_region` VALUES (1971, '东团堡', 4, '130630', '130630207', 'd');
INSERT INTO `sys_data_region` VALUES (1972, '塔崖驿', 4, '130630', '130630208', 't');
INSERT INTO `sys_data_region` VALUES (1973, '乌龙沟', 4, '130630', '130630209', 'w');
INSERT INTO `sys_data_region` VALUES (1974, '望都', 3, '1306', '130631', 'w');
INSERT INTO `sys_data_region` VALUES (1975, '望都镇', 4, '130631', '130631100', 'w');
INSERT INTO `sys_data_region` VALUES (1976, '固店', 4, '130631', '130631101', 'g');
INSERT INTO `sys_data_region` VALUES (1977, '贾村', 4, '130631', '130631102', 'j');
INSERT INTO `sys_data_region` VALUES (1978, '中韩庄', 4, '130631', '130631103', 'z');
INSERT INTO `sys_data_region` VALUES (1979, '寺庄', 4, '130631', '130631104', 's');
INSERT INTO `sys_data_region` VALUES (1980, '赵庄', 4, '130631', '130631105', 'z');
INSERT INTO `sys_data_region` VALUES (1981, '高岭', 4, '130631', '130631106', 'g');
INSERT INTO `sys_data_region` VALUES (1982, '黑堡', 4, '130631', '130631202', 'h');
INSERT INTO `sys_data_region` VALUES (1983, '安新', 3, '1306', '130632', 'a');
INSERT INTO `sys_data_region` VALUES (1984, '安新镇', 4, '130632', '130632100', 'a');
INSERT INTO `sys_data_region` VALUES (1985, '大王', 4, '130632', '130632101', 'd');
INSERT INTO `sys_data_region` VALUES (1986, '三台', 4, '130632', '130632102', 's');
INSERT INTO `sys_data_region` VALUES (1987, '端村', 4, '130632', '130632103', 'd');
INSERT INTO `sys_data_region` VALUES (1988, '赵北口', 4, '130632', '130632104', 'z');
INSERT INTO `sys_data_region` VALUES (1989, '同口', 4, '130632', '130632105', 't');
INSERT INTO `sys_data_region` VALUES (1990, '刘李庄', 4, '130632', '130632106', 'l');
INSERT INTO `sys_data_region` VALUES (1991, '安州', 4, '130632', '130632107', 'a');
INSERT INTO `sys_data_region` VALUES (1992, '老河头', 4, '130632', '130632108', 'l');
INSERT INTO `sys_data_region` VALUES (1993, '圈头', 4, '130632', '130632200', 'q');
INSERT INTO `sys_data_region` VALUES (1994, '寨里', 4, '130632', '130632201', 'z');
INSERT INTO `sys_data_region` VALUES (1995, '芦庄', 4, '130632', '130632202', 'l');
INSERT INTO `sys_data_region` VALUES (1996, '易县', 3, '1306', '130633', 'y');
INSERT INTO `sys_data_region` VALUES (1997, '易州', 4, '130633', '130633100', 'y');
INSERT INTO `sys_data_region` VALUES (1998, '梁格庄', 4, '130633', '130633101', 'l');
INSERT INTO `sys_data_region` VALUES (1999, '西陵', 4, '130633', '130633102', 'x');
INSERT INTO `sys_data_region` VALUES (2000, '裴山', 4, '130633', '130633103', 'p');
INSERT INTO `sys_data_region` VALUES (2001, '塘湖', 4, '130633', '130633104', 't');
INSERT INTO `sys_data_region` VALUES (2002, '狼牙山', 4, '130633', '130633105', 'l');
INSERT INTO `sys_data_region` VALUES (2003, '良岗', 4, '130633', '130633106', 'l');
INSERT INTO `sys_data_region` VALUES (2004, '紫荆关', 4, '130633', '130633107', 'z');
INSERT INTO `sys_data_region` VALUES (2005, '高村', 4, '130633', '130633108', 'g');
INSERT INTO `sys_data_region` VALUES (2006, '桥头', 4, '130633', '130633200', 'q');
INSERT INTO `sys_data_region` VALUES (2007, '白马', 4, '130633', '130633201', 'b');
INSERT INTO `sys_data_region` VALUES (2008, '流井', 4, '130633', '130633202', 'l');
INSERT INTO `sys_data_region` VALUES (2009, '高陌', 4, '130633', '130633204', 'g');
INSERT INTO `sys_data_region` VALUES (2010, '大龙华', 4, '130633', '130633205', 'd');
INSERT INTO `sys_data_region` VALUES (2011, '安格庄', 4, '130633', '130633206', 'a');
INSERT INTO `sys_data_region` VALUES (2012, '凌云册', 4, '130633', '130633207', 'l');
INSERT INTO `sys_data_region` VALUES (2013, '西山北', 4, '130633', '130633208', 'x');
INSERT INTO `sys_data_region` VALUES (2014, '尉都', 4, '130633', '130633209', 'w');
INSERT INTO `sys_data_region` VALUES (2015, '独乐', 4, '130633', '130633210', 'd');
INSERT INTO `sys_data_region` VALUES (2016, '七峪', 4, '130633', '130633211', 'q');
INSERT INTO `sys_data_region` VALUES (2017, '富岗', 4, '130633', '130633212', 'f');
INSERT INTO `sys_data_region` VALUES (2018, '坡仓', 4, '130633', '130633213', 'p');
INSERT INTO `sys_data_region` VALUES (2019, '牛岗', 4, '130633', '130633214', 'n');
INSERT INTO `sys_data_region` VALUES (2020, '桥家河', 4, '130633', '130633215', 'q');
INSERT INTO `sys_data_region` VALUES (2021, '甘河净', 4, '130633', '130633216', 'g');
INSERT INTO `sys_data_region` VALUES (2022, '蔡家峪', 4, '130633', '130633217', 'c');
INSERT INTO `sys_data_region` VALUES (2023, '南城司', 4, '130633', '130633218', 'n');
INSERT INTO `sys_data_region` VALUES (2024, '曲阳', 3, '1306', '130634', 'q');
INSERT INTO `sys_data_region` VALUES (2025, '恒州', 4, '130634', '130634100', 'h');
INSERT INTO `sys_data_region` VALUES (2026, '灵山', 4, '130634', '130634101', 'l');
INSERT INTO `sys_data_region` VALUES (2027, '燕赵', 4, '130634', '130634102', 'y');
INSERT INTO `sys_data_region` VALUES (2028, '羊平', 4, '130634', '130634103', 'y');
INSERT INTO `sys_data_region` VALUES (2029, '文德', 4, '130634', '130634104', 'w');
INSERT INTO `sys_data_region` VALUES (2030, '晓林', 4, '130634', '130634105', 'x');
INSERT INTO `sys_data_region` VALUES (2031, '邸村', 4, '130634', '130634106', 'd');
INSERT INTO `sys_data_region` VALUES (2032, '齐村', 4, '130634', '130634107', 'q');
INSERT INTO `sys_data_region` VALUES (2033, '孝墓', 4, '130634', '130634108', 'x');
INSERT INTO `sys_data_region` VALUES (2034, '产德', 4, '130634', '130634109', 'c');
INSERT INTO `sys_data_region` VALUES (2035, '下河', 4, '130634', '130634110', 'x');
INSERT INTO `sys_data_region` VALUES (2036, '路庄子', 4, '130634', '130634200', 'l');
INSERT INTO `sys_data_region` VALUES (2037, '庄窠', 4, '130634', '130634202', 'z');
INSERT INTO `sys_data_region` VALUES (2038, '东旺', 4, '130634', '130634205', 'd');
INSERT INTO `sys_data_region` VALUES (2039, '党城', 4, '130634', '130634210', 'd');
INSERT INTO `sys_data_region` VALUES (2040, '郎家庄', 4, '130634', '130634211', 'l');
INSERT INTO `sys_data_region` VALUES (2041, '范家庄', 4, '130634', '130634212', 'f');
INSERT INTO `sys_data_region` VALUES (2042, '北台', 4, '130634', '130634213', 'b');
INSERT INTO `sys_data_region` VALUES (2043, '蠡县', 3, '1306', '130635', 'l');
INSERT INTO `sys_data_region` VALUES (2044, '蠡吾', 4, '130635', '130635100', 'l');
INSERT INTO `sys_data_region` VALUES (2045, '留史', 4, '130635', '130635101', 'l');
INSERT INTO `sys_data_region` VALUES (2046, '大百尺', 4, '130635', '130635102', 'd');
INSERT INTO `sys_data_region` VALUES (2047, '辛兴', 4, '130635', '130635103', 'x');
INSERT INTO `sys_data_region` VALUES (2048, '北郭丹', 4, '130635', '130635104', 'b');
INSERT INTO `sys_data_region` VALUES (2049, '万安', 4, '130635', '130635105', 'w');
INSERT INTO `sys_data_region` VALUES (2050, '桑园', 4, '130635', '130635106', 's');
INSERT INTO `sys_data_region` VALUES (2051, '南庄', 4, '130635', '130635107', 'n');
INSERT INTO `sys_data_region` VALUES (2052, '大曲堤', 4, '130635', '130635108', 'd');
INSERT INTO `sys_data_region` VALUES (2053, '鲍墟', 4, '130635', '130635109', 'b');
INSERT INTO `sys_data_region` VALUES (2054, '小陈', 4, '130635', '130635110', 'x');
INSERT INTO `sys_data_region` VALUES (2055, '林堡', 4, '130635', '130635201', 'l');
INSERT INTO `sys_data_region` VALUES (2056, '北埝头', 4, '130635', '130635202', 'b');
INSERT INTO `sys_data_region` VALUES (2057, '顺平', 3, '1306', '130636', 's');
INSERT INTO `sys_data_region` VALUES (2058, '蒲阳', 4, '130636', '130636100', 'p');
INSERT INTO `sys_data_region` VALUES (2059, '高于铺', 4, '130636', '130636101', 'g');
INSERT INTO `sys_data_region` VALUES (2060, '腰山', 4, '130636', '130636102', 'y');
INSERT INTO `sys_data_region` VALUES (2061, '蒲上', 4, '130636', '130636103', 'p');
INSERT INTO `sys_data_region` VALUES (2062, '神南', 4, '130636', '130636104', 's');
INSERT INTO `sys_data_region` VALUES (2063, '安阳', 4, '130636', '130636105', 'a');
INSERT INTO `sys_data_region` VALUES (2064, '白云', 4, '130636', '130636106', 'b');
INSERT INTO `sys_data_region` VALUES (2065, '河口', 4, '130636', '130636202', 'h');
INSERT INTO `sys_data_region` VALUES (2066, '台鱼', 4, '130636', '130636204', 't');
INSERT INTO `sys_data_region` VALUES (2067, '大悲', 4, '130636', '130636205', 'd');
INSERT INTO `sys_data_region` VALUES (2068, '博野', 3, '1306', '130637', 'b');
INSERT INTO `sys_data_region` VALUES (2069, '博野镇', 4, '130637', '130637100', 'b');
INSERT INTO `sys_data_region` VALUES (2070, '小店', 4, '130637', '130637101', 'x');
INSERT INTO `sys_data_region` VALUES (2071, '程委', 4, '130637', '130637102', 'c');
INSERT INTO `sys_data_region` VALUES (2072, '东墟', 4, '130637', '130637103', 'd');
INSERT INTO `sys_data_region` VALUES (2073, '北杨', 4, '130637', '130637104', 'b');
INSERT INTO `sys_data_region` VALUES (2074, '城东', 4, '130637', '130637105', 'c');
INSERT INTO `sys_data_region` VALUES (2075, '南小王', 4, '130637', '130637106', 'n');
INSERT INTO `sys_data_region` VALUES (2076, '雄县', 3, '1306', '130638', 'x');
INSERT INTO `sys_data_region` VALUES (2077, '雄州', 4, '130638', '130638100', 'x');
INSERT INTO `sys_data_region` VALUES (2078, '昝岗', 4, '130638', '130638101', 'z');
INSERT INTO `sys_data_region` VALUES (2079, '大营', 4, '130638', '130638102', 'd');
INSERT INTO `sys_data_region` VALUES (2080, '龙湾', 4, '130638', '130638103', 'l');
INSERT INTO `sys_data_region` VALUES (2081, '朱各庄', 4, '130638', '130638104', 'z');
INSERT INTO `sys_data_region` VALUES (2082, '米家务', 4, '130638', '130638105', 'm');
INSERT INTO `sys_data_region` VALUES (2083, '双堂', 4, '130638', '130638203', 's');
INSERT INTO `sys_data_region` VALUES (2084, '张岗', 4, '130638', '130638204', 'z');
INSERT INTO `sys_data_region` VALUES (2085, '北沙口', 4, '130638', '130638205', 'b');
INSERT INTO `sys_data_region` VALUES (2086, '涿州', 3, '1306', '130681', 'z');
INSERT INTO `sys_data_region` VALUES (2087, '双塔', 4, '130681', '130681001', 's');
INSERT INTO `sys_data_region` VALUES (2088, '桃园', 4, '130681', '130681002', 't');
INSERT INTO `sys_data_region` VALUES (2089, '清凉寺', 4, '130681', '130681003', 'q');
INSERT INTO `sys_data_region` VALUES (2090, '松林店', 4, '130681', '130681100', 's');
INSERT INTO `sys_data_region` VALUES (2091, '码头', 4, '130681', '130681101', 'm');
INSERT INTO `sys_data_region` VALUES (2092, '东城坊', 4, '130681', '130681102', 'd');
INSERT INTO `sys_data_region` VALUES (2093, '高官庄', 4, '130681', '130681103', 'g');
INSERT INTO `sys_data_region` VALUES (2094, '百尺竿', 4, '130681', '130681104', 'b');
INSERT INTO `sys_data_region` VALUES (2095, '东仙坡', 4, '130681', '130681105', 'd');
INSERT INTO `sys_data_region` VALUES (2096, '义和庄', 4, '130681', '130681106', 'y');
INSERT INTO `sys_data_region` VALUES (2097, '豆庄', 4, '130681', '130681107', 'd');
INSERT INTO `sys_data_region` VALUES (2098, '刁窝', 4, '130681', '130681108', 'd');
INSERT INTO `sys_data_region` VALUES (2099, '林家屯', 4, '130681', '130681109', 'l');
INSERT INTO `sys_data_region` VALUES (2100, '孙家庄', 4, '130681', '130681204', 's');
INSERT INTO `sys_data_region` VALUES (2101, '开发区管理委员会', 4, '130681', '130681400', 'k');
INSERT INTO `sys_data_region` VALUES (2102, '定州', 3, '1306', '130682', 'd');
INSERT INTO `sys_data_region` VALUES (2103, '南城区', 4, '130682', '130682001', 'n');
INSERT INTO `sys_data_region` VALUES (2104, '北城区', 4, '130682', '130682002', 'b');
INSERT INTO `sys_data_region` VALUES (2105, '西城区', 4, '130682', '130682003', 'x');
INSERT INTO `sys_data_region` VALUES (2106, '长安路', 4, '130682', '130682004', 'c');
INSERT INTO `sys_data_region` VALUES (2107, '留早', 4, '130682', '130682100', 'l');
INSERT INTO `sys_data_region` VALUES (2108, '清风店', 4, '130682', '130682101', 'q');
INSERT INTO `sys_data_region` VALUES (2109, '庞村', 4, '130682', '130682102', 'p');
INSERT INTO `sys_data_region` VALUES (2110, '砖路', 4, '130682', '130682103', 'z');
INSERT INTO `sys_data_region` VALUES (2111, '明月店', 4, '130682', '130682104', 'm');
INSERT INTO `sys_data_region` VALUES (2112, '叮咛店', 4, '130682', '130682105', 'd');
INSERT INTO `sys_data_region` VALUES (2113, '东亭', 4, '130682', '130682106', 'd');
INSERT INTO `sys_data_region` VALUES (2114, '大辛庄', 4, '130682', '130682107', 'd');
INSERT INTO `sys_data_region` VALUES (2115, '东旺', 4, '130682', '130682108', 'd');
INSERT INTO `sys_data_region` VALUES (2116, '高蓬', 4, '130682', '130682109', 'g');
INSERT INTO `sys_data_region` VALUES (2117, '邢邑', 4, '130682', '130682110', 'x');
INSERT INTO `sys_data_region` VALUES (2118, '李亲顾', 4, '130682', '130682111', 'l');
INSERT INTO `sys_data_region` VALUES (2119, '子位', 4, '130682', '130682112', 'z');
INSERT INTO `sys_data_region` VALUES (2120, '息冢', 4, '130682', '130682113', 'x');
INSERT INTO `sys_data_region` VALUES (2121, '周村', 4, '130682', '130682114', 'z');
INSERT INTO `sys_data_region` VALUES (2122, '开元', 4, '130682', '130682116', 'k');
INSERT INTO `sys_data_region` VALUES (2123, '东留春', 4, '130682', '130682203', 'd');
INSERT INTO `sys_data_region` VALUES (2124, '号头庄', 4, '130682', '130682204', 'h');
INSERT INTO `sys_data_region` VALUES (2125, '杨家庄', 4, '130682', '130682205', 'y');
INSERT INTO `sys_data_region` VALUES (2126, '大鹿庄', 4, '130682', '130682206', 'd');
INSERT INTO `sys_data_region` VALUES (2127, '西城', 4, '130682', '130682208', 'x');
INSERT INTO `sys_data_region` VALUES (2128, '安国', 3, '1306', '130683', 'a');
INSERT INTO `sys_data_region` VALUES (2129, '药都', 4, '130683', '130683001', 'y');
INSERT INTO `sys_data_region` VALUES (2130, '祁州路', 4, '130683', '130683002', 'q');
INSERT INTO `sys_data_region` VALUES (2131, '伍仁桥', 4, '130683', '130683101', 'w');
INSERT INTO `sys_data_region` VALUES (2132, '石佛', 4, '130683', '130683102', 's');
INSERT INTO `sys_data_region` VALUES (2133, '郑章', 4, '130683', '130683103', 'z');
INSERT INTO `sys_data_region` VALUES (2134, '大五女', 4, '130683', '130683104', 'd');
INSERT INTO `sys_data_region` VALUES (2135, '西伏落', 4, '130683', '130683105', 'x');
INSERT INTO `sys_data_region` VALUES (2136, '西城', 4, '130683', '130683106', 'x');
INSERT INTO `sys_data_region` VALUES (2137, '明官店', 4, '130683', '130683200', 'm');
INSERT INTO `sys_data_region` VALUES (2138, '南娄底', 4, '130683', '130683201', 'n');
INSERT INTO `sys_data_region` VALUES (2139, '北段村', 4, '130683', '130683204', 'b');
INSERT INTO `sys_data_region` VALUES (2140, '高碑店', 3, '1306', '130684', 'g');
INSERT INTO `sys_data_region` VALUES (2141, '和平', 4, '130684', '130684001', 'h');
INSERT INTO `sys_data_region` VALUES (2142, '军城', 4, '130684', '130684002', 'j');
INSERT INTO `sys_data_region` VALUES (2143, '东盛', 4, '130684', '130684003', 'd');
INSERT INTO `sys_data_region` VALUES (2144, '北城', 4, '130684', '130684004', 'b');
INSERT INTO `sys_data_region` VALUES (2145, '兴华', 4, '130684', '130684005', 'x');
INSERT INTO `sys_data_region` VALUES (2146, '方官', 4, '130684', '130684100', 'f');
INSERT INTO `sys_data_region` VALUES (2147, '新城', 4, '130684', '130684101', 'x');
INSERT INTO `sys_data_region` VALUES (2148, '泗庄', 4, '130684', '130684102', 's');
INSERT INTO `sys_data_region` VALUES (2149, '辛立庄', 4, '130684', '130684104', 'x');
INSERT INTO `sys_data_region` VALUES (2150, '东马营', 4, '130684', '130684105', 'd');
INSERT INTO `sys_data_region` VALUES (2151, '白沟', 4, '130684', '130684106', 'b');
INSERT INTO `sys_data_region` VALUES (2152, '张六庄', 4, '130684', '130684107', 'z');
INSERT INTO `sys_data_region` VALUES (2153, '肖官营', 4, '130684', '130684108', 'x');
INSERT INTO `sys_data_region` VALUES (2154, '辛桥', 4, '130684', '130684109', 'x');
INSERT INTO `sys_data_region` VALUES (2155, '梁家营', 4, '130684', '130684110', 'l');
INSERT INTO `sys_data_region` VALUES (2156, '张家口', 2, '13', '1307', 'z');
INSERT INTO `sys_data_region` VALUES (2157, '桥东', 3, '1307', '130702', 'q');
INSERT INTO `sys_data_region` VALUES (2158, '红旗楼', 4, '130702', '130702001', 'h');
INSERT INTO `sys_data_region` VALUES (2159, '胜利北路', 4, '130702', '130702002', 's');
INSERT INTO `sys_data_region` VALUES (2160, '五一路', 4, '130702', '130702003', 'w');
INSERT INTO `sys_data_region` VALUES (2161, '花园街', 4, '130702', '130702004', 'h');
INSERT INTO `sys_data_region` VALUES (2162, '工业路', 4, '130702', '130702005', 'g');
INSERT INTO `sys_data_region` VALUES (2163, '南站', 4, '130702', '130702006', 'n');
INSERT INTO `sys_data_region` VALUES (2164, '马路东', 4, '130702', '130702007', 'm');
INSERT INTO `sys_data_region` VALUES (2165, '姚家庄', 4, '130702', '130702100', 'y');
INSERT INTO `sys_data_region` VALUES (2166, '大仓盖', 4, '130702', '130702101', 'd');
INSERT INTO `sys_data_region` VALUES (2167, '老鸦庄', 4, '130702', '130702102', 'l');
INSERT INTO `sys_data_region` VALUES (2168, '东望山', 4, '130702', '130702200', 'd');
INSERT INTO `sys_data_region` VALUES (2169, '桥西', 3, '1307', '130703', 'q');
INSERT INTO `sys_data_region` VALUES (2170, '明德南街', 4, '130703', '130703001', 'm');
INSERT INTO `sys_data_region` VALUES (2171, '大境门', 4, '130703', '130703002', 'd');
INSERT INTO `sys_data_region` VALUES (2172, '明德北', 4, '130703', '130703003', 'm');
INSERT INTO `sys_data_region` VALUES (2173, '新华街', 4, '130703', '130703004', 'x');
INSERT INTO `sys_data_region` VALUES (2174, '堡子里', 4, '130703', '130703005', 'b');
INSERT INTO `sys_data_region` VALUES (2175, '南营坊', 4, '130703', '130703006', 'n');
INSERT INTO `sys_data_region` VALUES (2176, '工人新村', 4, '130703', '130703007', 'g');
INSERT INTO `sys_data_region` VALUES (2177, '东窑子', 4, '130703', '130703100', 'd');
INSERT INTO `sys_data_region` VALUES (2178, '沈家屯', 4, '130703', '130703101', 's');
INSERT INTO `sys_data_region` VALUES (2179, '姚家房', 4, '130703', '130703104', 'y');
INSERT INTO `sys_data_region` VALUES (2180, '宣化', 3, '1307', '130705', 'x');
INSERT INTO `sys_data_region` VALUES (2181, '天泰寺街', 4, '130705', '130705001', 't');
INSERT INTO `sys_data_region` VALUES (2182, '皇城', 4, '130705', '130705002', 'h');
INSERT INTO `sys_data_region` VALUES (2183, '南关', 4, '130705', '130705003', 'n');
INSERT INTO `sys_data_region` VALUES (2184, '南大街', 4, '130705', '130705004', 'n');
INSERT INTO `sys_data_region` VALUES (2185, '大北街', 4, '130705', '130705005', 'd');
INSERT INTO `sys_data_region` VALUES (2186, '工业街', 4, '130705', '130705006', 'g');
INSERT INTO `sys_data_region` VALUES (2187, '建国街', 4, '130705', '130705007', 'j');
INSERT INTO `sys_data_region` VALUES (2188, '庞家堡', 4, '130705', '130705100', 'p');
INSERT INTO `sys_data_region` VALUES (2189, '洋河南', 4, '130705', '130705101', 'y');
INSERT INTO `sys_data_region` VALUES (2190, '深井', 4, '130705', '130705102', 's');
INSERT INTO `sys_data_region` VALUES (2191, '崞村', 4, '130705', '130705103', 'g');
INSERT INTO `sys_data_region` VALUES (2192, '贾家营', 4, '130705', '130705104', 'j');
INSERT INTO `sys_data_region` VALUES (2193, '顾家营', 4, '130705', '130705105', 'g');
INSERT INTO `sys_data_region` VALUES (2194, '沙岭子', 4, '130705', '130705107', 's');
INSERT INTO `sys_data_region` VALUES (2195, '赵川', 4, '130705', '130705108', 'z');
INSERT INTO `sys_data_region` VALUES (2196, '江家屯', 4, '130705', '130705109', 'j');
INSERT INTO `sys_data_region` VALUES (2197, '河子西', 4, '130705', '130705110', 'h');
INSERT INTO `sys_data_region` VALUES (2198, '侯家庙', 4, '130705', '130705112', 'h');
INSERT INTO `sys_data_region` VALUES (2199, '春光', 4, '130705', '130705201', 'c');
INSERT INTO `sys_data_region` VALUES (2200, '王家湾', 4, '130705', '130705203', 'w');
INSERT INTO `sys_data_region` VALUES (2201, '塔儿村', 4, '130705', '130705204', 't');
INSERT INTO `sys_data_region` VALUES (2202, '李家堡', 4, '130705', '130705206', 'l');
INSERT INTO `sys_data_region` VALUES (2203, '下花园', 3, '1307', '130706', 'x');
INSERT INTO `sys_data_region` VALUES (2204, '城镇', 4, '130706', '130706001', 'c');
INSERT INTO `sys_data_region` VALUES (2205, '煤矿', 4, '130706', '130706002', 'm');
INSERT INTO `sys_data_region` VALUES (2206, '花园', 4, '130706', '130706200', 'h');
INSERT INTO `sys_data_region` VALUES (2207, '辛庄子', 4, '130706', '130706201', 'x');
INSERT INTO `sys_data_region` VALUES (2208, '定方水', 4, '130706', '130706202', 'd');
INSERT INTO `sys_data_region` VALUES (2209, '段家堡', 4, '130706', '130706203', 'd');
INSERT INTO `sys_data_region` VALUES (2210, '万全', 3, '1307', '130708', 'w');
INSERT INTO `sys_data_region` VALUES (2211, '孔家庄', 4, '130708', '130708100', 'k');
INSERT INTO `sys_data_region` VALUES (2212, '万全镇', 4, '130708', '130708101', 'w');
INSERT INTO `sys_data_region` VALUES (2213, '洗马林', 4, '130708', '130708102', 'x');
INSERT INTO `sys_data_region` VALUES (2214, '郭磊庄', 4, '130708', '130708103', 'g');
INSERT INTO `sys_data_region` VALUES (2215, '膳房堡', 4, '130708', '130708200', 's');
INSERT INTO `sys_data_region` VALUES (2216, '北新屯', 4, '130708', '130708201', 'b');
INSERT INTO `sys_data_region` VALUES (2217, '宣平堡', 4, '130708', '130708202', 'x');
INSERT INTO `sys_data_region` VALUES (2218, '高庙堡', 4, '130708', '130708203', 'g');
INSERT INTO `sys_data_region` VALUES (2219, '旧堡', 4, '130708', '130708204', 'j');
INSERT INTO `sys_data_region` VALUES (2220, '安家堡', 4, '130708', '130708205', 'a');
INSERT INTO `sys_data_region` VALUES (2221, '北沙城', 4, '130708', '130708206', 'b');
INSERT INTO `sys_data_region` VALUES (2222, '崇礼', 3, '1307', '130709', 'c');
INSERT INTO `sys_data_region` VALUES (2223, '西湾子街道', 4, '130709', '130709001', 'x');
INSERT INTO `sys_data_region` VALUES (2224, '西湾子镇', 4, '130709', '130709100', 'x');
INSERT INTO `sys_data_region` VALUES (2225, '高家营', 4, '130709', '130709101', 'g');
INSERT INTO `sys_data_region` VALUES (2226, '四台嘴', 4, '130709', '130709200', 's');
INSERT INTO `sys_data_region` VALUES (2227, '红旗营', 4, '130709', '130709201', 'h');
INSERT INTO `sys_data_region` VALUES (2228, '石窑子', 4, '130709', '130709202', 's');
INSERT INTO `sys_data_region` VALUES (2229, '驿马图', 4, '130709', '130709203', 'y');
INSERT INTO `sys_data_region` VALUES (2230, '石嘴子', 4, '130709', '130709204', 's');
INSERT INTO `sys_data_region` VALUES (2231, '狮子沟', 4, '130709', '130709205', 's');
INSERT INTO `sys_data_region` VALUES (2232, '清三营', 4, '130709', '130709206', 'q');
INSERT INTO `sys_data_region` VALUES (2233, '白旗', 4, '130709', '130709207', 'b');
INSERT INTO `sys_data_region` VALUES (2234, '张北', 3, '1307', '130722', 'z');
INSERT INTO `sys_data_region` VALUES (2235, '张北镇', 4, '130722', '130722100', 'z');
INSERT INTO `sys_data_region` VALUES (2236, '公会', 4, '130722', '130722101', 'g');
INSERT INTO `sys_data_region` VALUES (2237, '二台', 4, '130722', '130722102', 'e');
INSERT INTO `sys_data_region` VALUES (2238, '大囫囵', 4, '130722', '130722103', 'd');
INSERT INTO `sys_data_region` VALUES (2239, '小二台', 4, '130722', '130722104', 'x');
INSERT INTO `sys_data_region` VALUES (2240, '沙沟', 4, '130722', '130722105', 's');
INSERT INTO `sys_data_region` VALUES (2241, '油篓沟', 4, '130722', '130722106', 'y');
INSERT INTO `sys_data_region` VALUES (2242, '大河', 4, '130722', '130722107', 'd');
INSERT INTO `sys_data_region` VALUES (2243, '台路沟', 4, '130722', '130722200', 't');
INSERT INTO `sys_data_region` VALUES (2244, '馒头营', 4, '130722', '130722202', 'm');
INSERT INTO `sys_data_region` VALUES (2245, '二泉井', 4, '130722', '130722203', 'e');
INSERT INTO `sys_data_region` VALUES (2246, '单晶河', 4, '130722', '130722204', 'd');
INSERT INTO `sys_data_region` VALUES (2247, '海流图', 4, '130722', '130722206', 'h');
INSERT INTO `sys_data_region` VALUES (2248, '两面井', 4, '130722', '130722207', 'l');
INSERT INTO `sys_data_region` VALUES (2249, '大西湾', 4, '130722', '130722208', 'd');
INSERT INTO `sys_data_region` VALUES (2250, '郝家营', 4, '130722', '130722209', 'h');
INSERT INTO `sys_data_region` VALUES (2251, '白庙滩', 4, '130722', '130722210', 'b');
INSERT INTO `sys_data_region` VALUES (2252, '战海', 4, '130722', '130722212', 'z');
INSERT INTO `sys_data_region` VALUES (2253, '三号', 4, '130722', '130722213', 's');
INSERT INTO `sys_data_region` VALUES (2254, '宇宙营', 4, '130722', '130722214', 'y');
INSERT INTO `sys_data_region` VALUES (2255, '康保', 3, '1307', '130723', 'k');
INSERT INTO `sys_data_region` VALUES (2256, '康保镇', 4, '130723', '130723100', 'k');
INSERT INTO `sys_data_region` VALUES (2257, '张纪', 4, '130723', '130723101', 'z');
INSERT INTO `sys_data_region` VALUES (2258, '土城子', 4, '130723', '130723102', 't');
INSERT INTO `sys_data_region` VALUES (2259, '邓油坊', 4, '130723', '130723103', 'd');
INSERT INTO `sys_data_region` VALUES (2260, '李家地', 4, '130723', '130723104', 'l');
INSERT INTO `sys_data_region` VALUES (2261, '照阳河', 4, '130723', '130723105', 'z');
INSERT INTO `sys_data_region` VALUES (2262, '屯垦', 4, '130723', '130723106', 't');
INSERT INTO `sys_data_region` VALUES (2263, '阎油房', 4, '130723', '130723200', 'y');
INSERT INTO `sys_data_region` VALUES (2264, '丹清河', 4, '130723', '130723201', 'd');
INSERT INTO `sys_data_region` VALUES (2265, '哈咇嘎', 4, '130723', '130723202', 'h');
INSERT INTO `sys_data_region` VALUES (2266, '二号卜', 4, '130723', '130723203', 'e');
INSERT INTO `sys_data_region` VALUES (2267, '芦家营', 4, '130723', '130723204', 'l');
INSERT INTO `sys_data_region` VALUES (2268, '忠义', 4, '130723', '130723205', 'z');
INSERT INTO `sys_data_region` VALUES (2269, '处长地', 4, '130723', '130723206', 'c');
INSERT INTO `sys_data_region` VALUES (2270, '满德堂', 4, '130723', '130723207', 'm');
INSERT INTO `sys_data_region` VALUES (2271, '康保牧场', 4, '130723', '130723500', 'k');
INSERT INTO `sys_data_region` VALUES (2272, '沽源', 3, '1307', '130724', 'g');
INSERT INTO `sys_data_region` VALUES (2273, '平定堡', 4, '130724', '130724100', 'p');
INSERT INTO `sys_data_region` VALUES (2274, '小厂', 4, '130724', '130724101', 'x');
INSERT INTO `sys_data_region` VALUES (2275, '黄盖淖', 4, '130724', '130724102', 'h');
INSERT INTO `sys_data_region` VALUES (2276, '九连城', 4, '130724', '130724103', 'j');
INSERT INTO `sys_data_region` VALUES (2277, '高山堡', 4, '130724', '130724200', 'g');
INSERT INTO `sys_data_region` VALUES (2278, '小河子', 4, '130724', '130724201', 'x');
INSERT INTO `sys_data_region` VALUES (2279, '二道渠', 4, '130724', '130724202', 'e');
INSERT INTO `sys_data_region` VALUES (2280, '大二号', 4, '130724', '130724203', 'd');
INSERT INTO `sys_data_region` VALUES (2281, '闪电河', 4, '130724', '130724204', 's');
INSERT INTO `sys_data_region` VALUES (2282, '长梁', 4, '130724', '130724205', 'c');
INSERT INTO `sys_data_region` VALUES (2283, '丰源店', 4, '130724', '130724206', 'f');
INSERT INTO `sys_data_region` VALUES (2284, '西辛营', 4, '130724', '130724207', 'x');
INSERT INTO `sys_data_region` VALUES (2285, '莲花滩', 4, '130724', '130724208', 'l');
INSERT INTO `sys_data_region` VALUES (2286, '白土窑', 4, '130724', '130724209', 'b');
INSERT INTO `sys_data_region` VALUES (2287, '尚义', 3, '1307', '130725', 's');
INSERT INTO `sys_data_region` VALUES (2288, '南壕堑', 4, '130725', '130725100', 'n');
INSERT INTO `sys_data_region` VALUES (2289, '大青沟', 4, '130725', '130725101', 'd');
INSERT INTO `sys_data_region` VALUES (2290, '八道沟', 4, '130725', '130725102', 'b');
INSERT INTO `sys_data_region` VALUES (2291, '红土梁', 4, '130725', '130725103', 'h');
INSERT INTO `sys_data_region` VALUES (2292, '小蒜沟', 4, '130725', '130725104', 'x');
INSERT INTO `sys_data_region` VALUES (2293, '三工地', 4, '130725', '130725105', 's');
INSERT INTO `sys_data_region` VALUES (2294, '满井', 4, '130725', '130725106', 'm');
INSERT INTO `sys_data_region` VALUES (2295, '大营盘', 4, '130725', '130725200', 'd');
INSERT INTO `sys_data_region` VALUES (2296, '大苏计', 4, '130725', '130725201', 'd');
INSERT INTO `sys_data_region` VALUES (2297, '石井', 4, '130725', '130725202', 's');
INSERT INTO `sys_data_region` VALUES (2298, '七甲', 4, '130725', '130725205', 'q');
INSERT INTO `sys_data_region` VALUES (2299, '套里庄', 4, '130725', '130725206', 't');
INSERT INTO `sys_data_region` VALUES (2300, '甲石河', 4, '130725', '130725207', 'j');
INSERT INTO `sys_data_region` VALUES (2301, '下马圈', 4, '130725', '130725208', 'x');
INSERT INTO `sys_data_region` VALUES (2302, '蔚县', 3, '1307', '130726', 'y');
INSERT INTO `sys_data_region` VALUES (2303, '蔚州', 4, '130726', '130726100', 'w');
INSERT INTO `sys_data_region` VALUES (2304, '代王城', 4, '130726', '130726101', 'd');
INSERT INTO `sys_data_region` VALUES (2305, '西合营', 4, '130726', '130726102', 'x');
INSERT INTO `sys_data_region` VALUES (2306, '吉家庄', 4, '130726', '130726103', 'j');
INSERT INTO `sys_data_region` VALUES (2307, '白乐', 4, '130726', '130726104', 'b');
INSERT INTO `sys_data_region` VALUES (2308, '暖泉', 4, '130726', '130726105', 'n');
INSERT INTO `sys_data_region` VALUES (2309, '南留庄', 4, '130726', '130726106', 'n');
INSERT INTO `sys_data_region` VALUES (2310, '北水泉', 4, '130726', '130726107', 'b');
INSERT INTO `sys_data_region` VALUES (2311, '桃花', 4, '130726', '130726108', 't');
INSERT INTO `sys_data_region` VALUES (2312, '阳眷', 4, '130726', '130726109', 'y');
INSERT INTO `sys_data_region` VALUES (2313, '宋家庄', 4, '130726', '130726110', 's');
INSERT INTO `sys_data_region` VALUES (2314, '下宫村', 4, '130726', '130726200', 'x');
INSERT INTO `sys_data_region` VALUES (2315, '南杨庄', 4, '130726', '130726202', 'n');
INSERT INTO `sys_data_region` VALUES (2316, '柏树', 4, '130726', '130726203', 'b');
INSERT INTO `sys_data_region` VALUES (2317, '常宁', 4, '130726', '130726204', 'c');
INSERT INTO `sys_data_region` VALUES (2318, '涌泉庄', 4, '130726', '130726205', 'y');
INSERT INTO `sys_data_region` VALUES (2319, '杨庄窠', 4, '130726', '130726206', 'y');
INSERT INTO `sys_data_region` VALUES (2320, '南岭庄', 4, '130726', '130726207', 'n');
INSERT INTO `sys_data_region` VALUES (2321, '陈家洼', 4, '130726', '130726208', 'c');
INSERT INTO `sys_data_region` VALUES (2322, '黄梅', 4, '130726', '130726209', 'h');
INSERT INTO `sys_data_region` VALUES (2323, '白草村', 4, '130726', '130726210', 'b');
INSERT INTO `sys_data_region` VALUES (2324, '草沟堡', 4, '130726', '130726211', 'c');
INSERT INTO `sys_data_region` VALUES (2325, '阳原', 3, '1307', '130727', 'y');
INSERT INTO `sys_data_region` VALUES (2326, '西城', 4, '130727', '130727100', 'x');
INSERT INTO `sys_data_region` VALUES (2327, '东城', 4, '130727', '130727101', 'd');
INSERT INTO `sys_data_region` VALUES (2328, '化稍营', 4, '130727', '130727102', 'h');
INSERT INTO `sys_data_region` VALUES (2329, '揣骨疃', 4, '130727', '130727103', 'c');
INSERT INTO `sys_data_region` VALUES (2330, '东井集', 4, '130727', '130727104', 'd');
INSERT INTO `sys_data_region` VALUES (2331, '要家庄', 4, '130727', '130727200', 'y');
INSERT INTO `sys_data_region` VALUES (2332, '东坊城堡', 4, '130727', '130727201', 'd');
INSERT INTO `sys_data_region` VALUES (2333, '井儿沟', 4, '130727', '130727202', 'j');
INSERT INTO `sys_data_region` VALUES (2334, '三马坊', 4, '130727', '130727203', 's');
INSERT INTO `sys_data_region` VALUES (2335, '高墙', 4, '130727', '130727204', 'g');
INSERT INTO `sys_data_region` VALUES (2336, '大田洼', 4, '130727', '130727205', 'd');
INSERT INTO `sys_data_region` VALUES (2337, '辛堡', 4, '130727', '130727206', 'x');
INSERT INTO `sys_data_region` VALUES (2338, '马圈堡', 4, '130727', '130727207', 'm');
INSERT INTO `sys_data_region` VALUES (2339, '浮图讲', 4, '130727', '130727208', 'f');
INSERT INTO `sys_data_region` VALUES (2340, '怀安', 3, '1307', '130728', 'h');
INSERT INTO `sys_data_region` VALUES (2341, '柴沟堡', 4, '130728', '130728100', 'c');
INSERT INTO `sys_data_region` VALUES (2342, '左卫', 4, '130728', '130728101', 'z');
INSERT INTO `sys_data_region` VALUES (2343, '头百户', 4, '130728', '130728102', 't');
INSERT INTO `sys_data_region` VALUES (2344, '怀安城', 4, '130728', '130728103', 'h');
INSERT INTO `sys_data_region` VALUES (2345, '渡口堡', 4, '130728', '130728200', 'd');
INSERT INTO `sys_data_region` VALUES (2346, '第六屯', 4, '130728', '130728201', 'd');
INSERT INTO `sys_data_region` VALUES (2347, '西湾堡', 4, '130728', '130728202', 'x');
INSERT INTO `sys_data_region` VALUES (2348, '西沙城', 4, '130728', '130728203', 'x');
INSERT INTO `sys_data_region` VALUES (2349, '太平庄', 4, '130728', '130728204', 't');
INSERT INTO `sys_data_region` VALUES (2350, '王虎屯', 4, '130728', '130728205', 'w');
INSERT INTO `sys_data_region` VALUES (2351, '第三堡', 4, '130728', '130728206', 'd');
INSERT INTO `sys_data_region` VALUES (2352, '怀来', 3, '1307', '130730', 'h');
INSERT INTO `sys_data_region` VALUES (2353, '沙城', 4, '130730', '130730100', 's');
INSERT INTO `sys_data_region` VALUES (2354, '北辛堡', 4, '130730', '130730101', 'b');
INSERT INTO `sys_data_region` VALUES (2355, '新保安', 4, '130730', '130730102', 'x');
INSERT INTO `sys_data_region` VALUES (2356, '东花园', 4, '130730', '130730103', 'd');
INSERT INTO `sys_data_region` VALUES (2357, '官厅', 4, '130730', '130730104', 'g');
INSERT INTO `sys_data_region` VALUES (2358, '桑园', 4, '130730', '130730105', 's');
INSERT INTO `sys_data_region` VALUES (2359, '存瑞', 4, '130730', '130730106', 'c');
INSERT INTO `sys_data_region` VALUES (2360, '土木', 4, '130730', '130730107', 't');
INSERT INTO `sys_data_region` VALUES (2361, '大黄庄', 4, '130730', '130730108', 'd');
INSERT INTO `sys_data_region` VALUES (2362, '西八里', 4, '130730', '130730109', 'x');
INSERT INTO `sys_data_region` VALUES (2363, '小南辛堡', 4, '130730', '130730110', 'x');
INSERT INTO `sys_data_region` VALUES (2364, '狼山', 4, '130730', '130730200', 'l');
INSERT INTO `sys_data_region` VALUES (2365, '鸡鸣驿', 4, '130730', '130730203', 'j');
INSERT INTO `sys_data_region` VALUES (2366, '东八里', 4, '130730', '130730205', 'd');
INSERT INTO `sys_data_region` VALUES (2367, '瑞云观', 4, '130730', '130730207', 'r');
INSERT INTO `sys_data_region` VALUES (2368, '孙庄子', 4, '130730', '130730208', 's');
INSERT INTO `sys_data_region` VALUES (2369, '王家楼', 4, '130730', '130730210', 'w');
INSERT INTO `sys_data_region` VALUES (2370, '涿鹿', 3, '1307', '130731', 'z');
INSERT INTO `sys_data_region` VALUES (2371, '涿鹿镇', 4, '130731', '130731100', 'z');
INSERT INTO `sys_data_region` VALUES (2372, '张家堡', 4, '130731', '130731101', 'z');
INSERT INTO `sys_data_region` VALUES (2373, '武家沟', 4, '130731', '130731102', 'w');
INSERT INTO `sys_data_region` VALUES (2374, '五堡', 4, '130731', '130731103', 'w');
INSERT INTO `sys_data_region` VALUES (2375, '保岱', 4, '130731', '130731104', 'b');
INSERT INTO `sys_data_region` VALUES (2376, '矾山', 4, '130731', '130731105', 'f');
INSERT INTO `sys_data_region` VALUES (2377, '大堡', 4, '130731', '130731106', 'd');
INSERT INTO `sys_data_region` VALUES (2378, '河东', 4, '130731', '130731107', 'h');
INSERT INTO `sys_data_region` VALUES (2379, '东小庄', 4, '130731', '130731108', 'd');
INSERT INTO `sys_data_region` VALUES (2380, '温泉屯', 4, '130731', '130731109', 'w');
INSERT INTO `sys_data_region` VALUES (2381, '大河南', 4, '130731', '130731110', 'd');
INSERT INTO `sys_data_region` VALUES (2382, '蟒石口', 4, '130731', '130731111', 'm');
INSERT INTO `sys_data_region` VALUES (2383, '辉耀', 4, '130731', '130731112', 'h');
INSERT INTO `sys_data_region` VALUES (2384, '卧佛寺', 4, '130731', '130731113', 'w');
INSERT INTO `sys_data_region` VALUES (2385, '栾庄', 4, '130731', '130731201', 'l');
INSERT INTO `sys_data_region` VALUES (2386, '黑山寺', 4, '130731', '130731204', 'h');
INSERT INTO `sys_data_region` VALUES (2387, '谢家堡', 4, '130731', '130731206', 'x');
INSERT INTO `sys_data_region` VALUES (2388, '赤城', 3, '1307', '130732', 'c');
INSERT INTO `sys_data_region` VALUES (2389, '赤城镇', 4, '130732', '130732100', 'c');
INSERT INTO `sys_data_region` VALUES (2390, '田家窑', 4, '130732', '130732101', 't');
INSERT INTO `sys_data_region` VALUES (2391, '龙关', 4, '130732', '130732102', 'l');
INSERT INTO `sys_data_region` VALUES (2392, '雕鹗', 4, '130732', '130732103', 'd');
INSERT INTO `sys_data_region` VALUES (2393, '独石口', 4, '130732', '130732104', 'd');
INSERT INTO `sys_data_region` VALUES (2394, '白草', 4, '130732', '130732105', 'b');
INSERT INTO `sys_data_region` VALUES (2395, '龙门所', 4, '130732', '130732106', 'l');
INSERT INTO `sys_data_region` VALUES (2396, '后城', 4, '130732', '130732107', 'h');
INSERT INTO `sys_data_region` VALUES (2397, '东卯', 4, '130732', '130732108', 'd');
INSERT INTO `sys_data_region` VALUES (2398, '炮梁', 4, '130732', '130732200', 'p');
INSERT INTO `sys_data_region` VALUES (2399, '大海陀', 4, '130732', '130732201', 'd');
INSERT INTO `sys_data_region` VALUES (2400, '镇宁堡', 4, '130732', '130732202', 'z');
INSERT INTO `sys_data_region` VALUES (2401, '马营', 4, '130732', '130732203', 'm');
INSERT INTO `sys_data_region` VALUES (2402, '云州', 4, '130732', '130732204', 'y');
INSERT INTO `sys_data_region` VALUES (2403, '三道川', 4, '130732', '130732205', 's');
INSERT INTO `sys_data_region` VALUES (2404, '东万口', 4, '130732', '130732206', 'd');
INSERT INTO `sys_data_region` VALUES (2405, '茨营子', 4, '130732', '130732207', 'c');
INSERT INTO `sys_data_region` VALUES (2406, '样田', 4, '130732', '130732208', 'y');
INSERT INTO `sys_data_region` VALUES (2407, '承德', 2, '13', '1308', 'c');
INSERT INTO `sys_data_region` VALUES (2408, '双桥', 3, '1308', '130802', 's');
INSERT INTO `sys_data_region` VALUES (2409, '西大街', 4, '130802', '130802001', 'x');
INSERT INTO `sys_data_region` VALUES (2410, '头道牌楼', 4, '130802', '130802002', 't');
INSERT INTO `sys_data_region` VALUES (2411, '潘家沟', 4, '130802', '130802003', 'p');
INSERT INTO `sys_data_region` VALUES (2412, '中华路', 4, '130802', '130802004', 'z');
INSERT INTO `sys_data_region` VALUES (2413, '新华路', 4, '130802', '130802005', 'x');
INSERT INTO `sys_data_region` VALUES (2414, '石洞子沟', 4, '130802', '130802006', 's');
INSERT INTO `sys_data_region` VALUES (2415, '桥东', 4, '130802', '130802007', 'q');
INSERT INTO `sys_data_region` VALUES (2416, '水泉沟', 4, '130802', '130802100', 's');
INSERT INTO `sys_data_region` VALUES (2417, '狮子沟', 4, '130802', '130802101', 's');
INSERT INTO `sys_data_region` VALUES (2418, '牛圈子沟', 4, '130802', '130802102', 'n');
INSERT INTO `sys_data_region` VALUES (2419, '大石庙', 4, '130802', '130802103', 'd');
INSERT INTO `sys_data_region` VALUES (2420, '冯营子', 4, '130802', '130802104', 'f');
INSERT INTO `sys_data_region` VALUES (2421, '双峰寺', 4, '130802', '130802105', 's');
INSERT INTO `sys_data_region` VALUES (2422, '上板城', 4, '130802', '130802106', 's');
INSERT INTO `sys_data_region` VALUES (2423, '承德市高新技术开发区', 4, '130802', '130802401', 'c');
INSERT INTO `sys_data_region` VALUES (2424, '双滦', 3, '1308', '130803', 's');
INSERT INTO `sys_data_region` VALUES (2425, '钢城', 4, '130803', '130803001', 'g');
INSERT INTO `sys_data_region` VALUES (2426, '元宝山', 4, '130803', '130803002', 'y');
INSERT INTO `sys_data_region` VALUES (2427, '秀水', 4, '130803', '130803003', 'x');
INSERT INTO `sys_data_region` VALUES (2428, '双塔山', 4, '130803', '130803100', 's');
INSERT INTO `sys_data_region` VALUES (2429, '滦河', 4, '130803', '130803101', 'l');
INSERT INTO `sys_data_region` VALUES (2430, '大庙', 4, '130803', '130803102', 'd');
INSERT INTO `sys_data_region` VALUES (2431, '偏桥子', 4, '130803', '130803103', 'p');
INSERT INTO `sys_data_region` VALUES (2432, '西地', 4, '130803', '130803104', 'x');
INSERT INTO `sys_data_region` VALUES (2433, '陈栅子', 4, '130803', '130803105', 'c');
INSERT INTO `sys_data_region` VALUES (2434, '鹰手营子矿区', 3, '1308', '130804', 'y');
INSERT INTO `sys_data_region` VALUES (2435, '铁北路', 4, '130804', '130804001', 't');
INSERT INTO `sys_data_region` VALUES (2436, '鹰手营子', 4, '130804', '130804100', 'y');
INSERT INTO `sys_data_region` VALUES (2437, '北马圈子', 4, '130804', '130804101', 'b');
INSERT INTO `sys_data_region` VALUES (2438, '寿王坟', 4, '130804', '130804102', 's');
INSERT INTO `sys_data_region` VALUES (2439, '汪家庄', 4, '130804', '130804103', 'w');
INSERT INTO `sys_data_region` VALUES (2440, '承德县', 3, '1308', '130821', 'c');
INSERT INTO `sys_data_region` VALUES (2441, '下板城', 4, '130821', '130821100', 'x');
INSERT INTO `sys_data_region` VALUES (2442, '甲山', 4, '130821', '130821102', 'j');
INSERT INTO `sys_data_region` VALUES (2443, '六沟', 4, '130821', '130821103', 'l');
INSERT INTO `sys_data_region` VALUES (2444, '三沟', 4, '130821', '130821104', 's');
INSERT INTO `sys_data_region` VALUES (2445, '头沟', 4, '130821', '130821105', 't');
INSERT INTO `sys_data_region` VALUES (2446, '高寺台', 4, '130821', '130821106', 'g');
INSERT INTO `sys_data_region` VALUES (2447, '三家', 4, '130821', '130821107', 's');
INSERT INTO `sys_data_region` VALUES (2448, '鞍匠', 4, '130821', '130821108', 'a');
INSERT INTO `sys_data_region` VALUES (2449, '上谷', 4, '130821', '130821109', 's');
INSERT INTO `sys_data_region` VALUES (2450, '磴上', 4, '130821', '130821110', 'd');
INSERT INTO `sys_data_region` VALUES (2451, '石灰窑', 4, '130821', '130821111', 's');
INSERT INTO `sys_data_region` VALUES (2452, '新杖子', 4, '130821', '130821112', 'x');
INSERT INTO `sys_data_region` VALUES (2453, '东小白旗', 4, '130821', '130821200', 'd');
INSERT INTO `sys_data_region` VALUES (2454, '刘杖子', 4, '130821', '130821202', 'l');
INSERT INTO `sys_data_region` VALUES (2455, '孟家院', 4, '130821', '130821204', 'm');
INSERT INTO `sys_data_region` VALUES (2456, '大营子', 4, '130821', '130821205', 'd');
INSERT INTO `sys_data_region` VALUES (2457, '八家', 4, '130821', '130821206', 'b');
INSERT INTO `sys_data_region` VALUES (2458, '满杖子', 4, '130821', '130821208', 'm');
INSERT INTO `sys_data_region` VALUES (2459, '五道河', 4, '130821', '130821210', 'w');
INSERT INTO `sys_data_region` VALUES (2460, '岔沟', 4, '130821', '130821211', 'c');
INSERT INTO `sys_data_region` VALUES (2461, '岗子', 4, '130821', '130821212', 'g');
INSERT INTO `sys_data_region` VALUES (2462, '两家', 4, '130821', '130821214', 'l');
INSERT INTO `sys_data_region` VALUES (2463, '仓子', 4, '130821', '130821216', 'c');
INSERT INTO `sys_data_region` VALUES (2464, '兴隆', 3, '1308', '130822', 'x');
INSERT INTO `sys_data_region` VALUES (2465, '兴隆镇', 4, '130822', '130822100', 'x');
INSERT INTO `sys_data_region` VALUES (2466, '半壁山', 4, '130822', '130822101', 'b');
INSERT INTO `sys_data_region` VALUES (2467, '挂兰峪', 4, '130822', '130822102', 'g');
INSERT INTO `sys_data_region` VALUES (2468, '青松岭', 4, '130822', '130822103', 'q');
INSERT INTO `sys_data_region` VALUES (2469, '六道河', 4, '130822', '130822104', 'l');
INSERT INTO `sys_data_region` VALUES (2470, '平安堡', 4, '130822', '130822105', 'p');
INSERT INTO `sys_data_region` VALUES (2471, '北营房', 4, '130822', '130822106', 'b');
INSERT INTO `sys_data_region` VALUES (2472, '孤山子', 4, '130822', '130822107', 'g');
INSERT INTO `sys_data_region` VALUES (2473, '蓝旗营', 4, '130822', '130822108', 'l');
INSERT INTO `sys_data_region` VALUES (2474, '雾灵山', 4, '130822', '130822109', 'w');
INSERT INTO `sys_data_region` VALUES (2475, '李家营', 4, '130822', '130822110', 'l');
INSERT INTO `sys_data_region` VALUES (2476, '大杖子', 4, '130822', '130822111', 'd');
INSERT INTO `sys_data_region` VALUES (2477, '三道河', 4, '130822', '130822112', 's');
INSERT INTO `sys_data_region` VALUES (2478, '蘑菇峪', 4, '130822', '130822113', 'm');
INSERT INTO `sys_data_region` VALUES (2479, '大水泉', 4, '130822', '130822114', 'd');
INSERT INTO `sys_data_region` VALUES (2480, '南天门', 4, '130822', '130822200', 'n');
INSERT INTO `sys_data_region` VALUES (2481, '八卦岭', 4, '130822', '130822202', 'b');
INSERT INTO `sys_data_region` VALUES (2482, '陡子峪', 4, '130822', '130822203', 'd');
INSERT INTO `sys_data_region` VALUES (2483, '上石洞', 4, '130822', '130822204', 's');
INSERT INTO `sys_data_region` VALUES (2484, '安子岭', 4, '130822', '130822211', 'a');
INSERT INTO `sys_data_region` VALUES (2485, '滦平', 3, '1308', '130824', 'l');
INSERT INTO `sys_data_region` VALUES (2486, '中兴路', 4, '130824', '130824001', 'z');
INSERT INTO `sys_data_region` VALUES (2487, '滦平镇', 4, '130824', '130824100', 'l');
INSERT INTO `sys_data_region` VALUES (2488, '长山峪', 4, '130824', '130824101', 'c');
INSERT INTO `sys_data_region` VALUES (2489, '红旗', 4, '130824', '130824102', 'h');
INSERT INTO `sys_data_region` VALUES (2490, '金沟屯', 4, '130824', '130824103', 'j');
INSERT INTO `sys_data_region` VALUES (2491, '虎什哈', 4, '130824', '130824104', 'h');
INSERT INTO `sys_data_region` VALUES (2492, '巴克什营', 4, '130824', '130824105', 'b');
INSERT INTO `sys_data_region` VALUES (2493, '张百湾', 4, '130824', '130824106', 'z');
INSERT INTO `sys_data_region` VALUES (2494, '付营子', 4, '130824', '130824107', 'f');
INSERT INTO `sys_data_region` VALUES (2495, '大屯', 4, '130824', '130824108', 'd');
INSERT INTO `sys_data_region` VALUES (2496, '火斗山', 4, '130824', '130824109', 'h');
INSERT INTO `sys_data_region` VALUES (2497, '两间房', 4, '130824', '130824110', 'l');
INSERT INTO `sys_data_region` VALUES (2498, '小营', 4, '130824', '130824111', 'x');
INSERT INTO `sys_data_region` VALUES (2499, '平坊', 4, '130824', '130824200', 'p');
INSERT INTO `sys_data_region` VALUES (2500, '安纯沟门', 4, '130824', '130824201', 'a');
INSERT INTO `sys_data_region` VALUES (2501, '西沟', 4, '130824', '130824206', 'x');
INSERT INTO `sys_data_region` VALUES (2502, '邓厂', 4, '130824', '130824207', 'd');
INSERT INTO `sys_data_region` VALUES (2503, '五道营子', 4, '130824', '130824208', 'w');
INSERT INTO `sys_data_region` VALUES (2504, '马营子', 4, '130824', '130824209', 'm');
INSERT INTO `sys_data_region` VALUES (2505, '付家店', 4, '130824', '130824210', 'f');
INSERT INTO `sys_data_region` VALUES (2506, '隆化', 3, '1308', '130825', 'l');
INSERT INTO `sys_data_region` VALUES (2507, '安州', 4, '130825', '130825001', 'a');
INSERT INTO `sys_data_region` VALUES (2508, '隆化镇', 4, '130825', '130825100', 'l');
INSERT INTO `sys_data_region` VALUES (2509, '韩麻营', 4, '130825', '130825101', 'h');
INSERT INTO `sys_data_region` VALUES (2510, '中关', 4, '130825', '130825102', 'z');
INSERT INTO `sys_data_region` VALUES (2511, '七家', 4, '130825', '130825103', 'q');
INSERT INTO `sys_data_region` VALUES (2512, '汤头沟', 4, '130825', '130825104', 't');
INSERT INTO `sys_data_region` VALUES (2513, '张三营', 4, '130825', '130825105', 'z');
INSERT INTO `sys_data_region` VALUES (2514, '唐三营', 4, '130825', '130825106', 't');
INSERT INTO `sys_data_region` VALUES (2515, '蓝旗', 4, '130825', '130825107', 'l');
INSERT INTO `sys_data_region` VALUES (2516, '步古沟', 4, '130825', '130825108', 'b');
INSERT INTO `sys_data_region` VALUES (2517, '郭家屯', 4, '130825', '130825109', 'g');
INSERT INTO `sys_data_region` VALUES (2518, '茅荆坝', 4, '130825', '130825110', 'm');
INSERT INTO `sys_data_region` VALUES (2519, '荒地', 4, '130825', '130825200', 'h');
INSERT INTO `sys_data_region` VALUES (2520, '章吉营', 4, '130825', '130825201', 'z');
INSERT INTO `sys_data_region` VALUES (2521, '尹家营', 4, '130825', '130825203', 'y');
INSERT INTO `sys_data_region` VALUES (2522, '庙子沟', 4, '130825', '130825204', 'm');
INSERT INTO `sys_data_region` VALUES (2523, '偏坡营', 4, '130825', '130825205', 'p');
INSERT INTO `sys_data_region` VALUES (2524, '山湾', 4, '130825', '130825206', 's');
INSERT INTO `sys_data_region` VALUES (2525, '八达营', 4, '130825', '130825207', 'b');
INSERT INTO `sys_data_region` VALUES (2526, '太平庄', 4, '130825', '130825208', 't');
INSERT INTO `sys_data_region` VALUES (2527, '旧屯', 4, '130825', '130825209', 'j');
INSERT INTO `sys_data_region` VALUES (2528, '西阿超', 4, '130825', '130825210', 'x');
INSERT INTO `sys_data_region` VALUES (2529, '碱房', 4, '130825', '130825212', 'j');
INSERT INTO `sys_data_region` VALUES (2530, '韩家店', 4, '130825', '130825213', 'h');
INSERT INTO `sys_data_region` VALUES (2531, '湾沟门', 4, '130825', '130825214', 'w');
INSERT INTO `sys_data_region` VALUES (2532, '丰宁', 3, '1308', '130826', 'f');
INSERT INTO `sys_data_region` VALUES (2533, '新丰路', 4, '130826', '130826001', 'x');
INSERT INTO `sys_data_region` VALUES (2534, '大阁', 4, '130826', '130826100', 'd');
INSERT INTO `sys_data_region` VALUES (2535, '大滩', 4, '130826', '130826101', 'd');
INSERT INTO `sys_data_region` VALUES (2536, '鱼儿山', 4, '130826', '130826102', 'y');
INSERT INTO `sys_data_region` VALUES (2537, '土城', 4, '130826', '130826103', 't');
INSERT INTO `sys_data_region` VALUES (2538, '黄旗', 4, '130826', '130826104', 'h');
INSERT INTO `sys_data_region` VALUES (2539, '凤山', 4, '130826', '130826105', 'f');
INSERT INTO `sys_data_region` VALUES (2540, '波罗诺', 4, '130826', '130826106', 'b');
INSERT INTO `sys_data_region` VALUES (2541, '黑山咀', 4, '130826', '130826107', 'h');
INSERT INTO `sys_data_region` VALUES (2542, '天桥', 4, '130826', '130826108', 't');
INSERT INTO `sys_data_region` VALUES (2543, '胡麻营', 4, '130826', '130826109', 'h');
INSERT INTO `sys_data_region` VALUES (2544, '将军营', 4, '130826', '130826110', 'j');
INSERT INTO `sys_data_region` VALUES (2545, '万胜永', 4, '130826', '130826200', 'w');
INSERT INTO `sys_data_region` VALUES (2546, '四岔口', 4, '130826', '130826201', 's');
INSERT INTO `sys_data_region` VALUES (2547, '苏家店', 4, '130826', '130826202', 's');
INSERT INTO `sys_data_region` VALUES (2548, '外沟门', 4, '130826', '130826203', 'w');
INSERT INTO `sys_data_region` VALUES (2549, '草原', 4, '130826', '130826204', 'c');
INSERT INTO `sys_data_region` VALUES (2550, '窟窿山', 4, '130826', '130826205', 'k');
INSERT INTO `sys_data_region` VALUES (2551, '小坝子', 4, '130826', '130826206', 'x');
INSERT INTO `sys_data_region` VALUES (2552, '五道营', 4, '130826', '130826207', 'w');
INSERT INTO `sys_data_region` VALUES (2553, '选将营', 4, '130826', '130826209', 'x');
INSERT INTO `sys_data_region` VALUES (2554, '西官营', 4, '130826', '130826210', 'x');
INSERT INTO `sys_data_region` VALUES (2555, '王营', 4, '130826', '130826211', 'w');
INSERT INTO `sys_data_region` VALUES (2556, '北头营', 4, '130826', '130826212', 'b');
INSERT INTO `sys_data_region` VALUES (2557, '石人沟', 4, '130826', '130826214', 's');
INSERT INTO `sys_data_region` VALUES (2558, '汤河', 4, '130826', '130826215', 't');
INSERT INTO `sys_data_region` VALUES (2559, '杨木栅子', 4, '130826', '130826216', 'y');
INSERT INTO `sys_data_region` VALUES (2560, '宽城', 3, '1308', '130827', 'k');
INSERT INTO `sys_data_region` VALUES (2561, '宽城镇', 4, '130827', '130827100', 'k');
INSERT INTO `sys_data_region` VALUES (2562, '龙须门', 4, '130827', '130827101', 'l');
INSERT INTO `sys_data_region` VALUES (2563, '峪耳崖', 4, '130827', '130827102', 'y');
INSERT INTO `sys_data_region` VALUES (2564, '板城', 4, '130827', '130827103', 'b');
INSERT INTO `sys_data_region` VALUES (2565, '汤道河', 4, '130827', '130827104', 't');
INSERT INTO `sys_data_region` VALUES (2566, '桲罗台', 4, '130827', '130827105', 'b');
INSERT INTO `sys_data_region` VALUES (2567, '碾子峪', 4, '130827', '130827106', 'n');
INSERT INTO `sys_data_region` VALUES (2568, '亮甲台', 4, '130827', '130827107', 'l');
INSERT INTO `sys_data_region` VALUES (2569, '化皮溜子', 4, '130827', '130827108', 'h');
INSERT INTO `sys_data_region` VALUES (2570, '松岭', 4, '130827', '130827109', 's');
INSERT INTO `sys_data_region` VALUES (2571, '塌山', 4, '130827', '130827201', 't');
INSERT INTO `sys_data_region` VALUES (2572, '孟子岭', 4, '130827', '130827203', 'm');
INSERT INTO `sys_data_region` VALUES (2573, '独石沟', 4, '130827', '130827204', 'd');
INSERT INTO `sys_data_region` VALUES (2574, '铧尖', 4, '130827', '130827207', 'h');
INSERT INTO `sys_data_region` VALUES (2575, '东黄花川', 4, '130827', '130827208', 'd');
INSERT INTO `sys_data_region` VALUES (2576, '苇子沟', 4, '130827', '130827210', 'w');
INSERT INTO `sys_data_region` VALUES (2577, '大字沟门', 4, '130827', '130827211', 'd');
INSERT INTO `sys_data_region` VALUES (2578, '大石柱子', 4, '130827', '130827212', 'd');
INSERT INTO `sys_data_region` VALUES (2579, '围场', 3, '1308', '130828', 'w');
INSERT INTO `sys_data_region` VALUES (2580, '围场镇', 4, '130828', '130828100', 'w');
INSERT INTO `sys_data_region` VALUES (2581, '四合永', 4, '130828', '130828101', 's');
INSERT INTO `sys_data_region` VALUES (2582, '克勒沟', 4, '130828', '130828102', 'k');
INSERT INTO `sys_data_region` VALUES (2583, '棋盘山', 4, '130828', '130828103', 'q');
INSERT INTO `sys_data_region` VALUES (2584, '半截塔', 4, '130828', '130828104', 'b');
INSERT INTO `sys_data_region` VALUES (2585, '朝阳地', 4, '130828', '130828105', 'z');
INSERT INTO `sys_data_region` VALUES (2586, '朝阳湾', 4, '130828', '130828106', 'z');
INSERT INTO `sys_data_region` VALUES (2587, '腰站', 4, '130828', '130828107', 'y');
INSERT INTO `sys_data_region` VALUES (2588, '龙头山', 4, '130828', '130828108', 'l');
INSERT INTO `sys_data_region` VALUES (2589, '新拨', 4, '130828', '130828109', 'x');
INSERT INTO `sys_data_region` VALUES (2590, '御道口', 4, '130828', '130828110', 'y');
INSERT INTO `sys_data_region` VALUES (2591, '城子', 4, '130828', '130828111', 'c');
INSERT INTO `sys_data_region` VALUES (2592, '道坝子', 4, '130828', '130828200', 'd');
INSERT INTO `sys_data_region` VALUES (2593, '黄土坎', 4, '130828', '130828203', 'h');
INSERT INTO `sys_data_region` VALUES (2594, '四道沟', 4, '130828', '130828204', 's');
INSERT INTO `sys_data_region` VALUES (2595, '蓝旗卡伦', 4, '130828', '130828205', 'l');
INSERT INTO `sys_data_region` VALUES (2596, '银窝沟', 4, '130828', '130828206', 'y');
INSERT INTO `sys_data_region` VALUES (2597, '新地', 4, '130828', '130828207', 'x');
INSERT INTO `sys_data_region` VALUES (2598, '广发永', 4, '130828', '130828208', 'g');
INSERT INTO `sys_data_region` VALUES (2599, '育太和', 4, '130828', '130828209', 'y');
INSERT INTO `sys_data_region` VALUES (2600, '郭家湾', 4, '130828', '130828210', 'g');
INSERT INTO `sys_data_region` VALUES (2601, '杨家湾', 4, '130828', '130828211', 'y');
INSERT INTO `sys_data_region` VALUES (2602, '大唤起', 4, '130828', '130828212', 'd');
INSERT INTO `sys_data_region` VALUES (2603, '哈里哈', 4, '130828', '130828213', 'h');
INSERT INTO `sys_data_region` VALUES (2604, '张家湾', 4, '130828', '130828215', 'z');
INSERT INTO `sys_data_region` VALUES (2605, '宝元栈', 4, '130828', '130828216', 'b');
INSERT INTO `sys_data_region` VALUES (2606, '山湾子', 4, '130828', '130828217', 's');
INSERT INTO `sys_data_region` VALUES (2607, '三义永', 4, '130828', '130828218', 's');
INSERT INTO `sys_data_region` VALUES (2608, '姜家店', 4, '130828', '130828219', 'j');
INSERT INTO `sys_data_region` VALUES (2609, '下伙房', 4, '130828', '130828220', 'x');
INSERT INTO `sys_data_region` VALUES (2610, '燕格柏', 4, '130828', '130828221', 'y');
INSERT INTO `sys_data_region` VALUES (2611, '牌楼', 4, '130828', '130828222', 'p');
INSERT INTO `sys_data_region` VALUES (2612, '老窝铺', 4, '130828', '130828224', 'l');
INSERT INTO `sys_data_region` VALUES (2613, '石桌子', 4, '130828', '130828226', 's');
INSERT INTO `sys_data_region` VALUES (2614, '大头山', 4, '130828', '130828227', 'd');
INSERT INTO `sys_data_region` VALUES (2615, '南山嘴', 4, '130828', '130828228', 'n');
INSERT INTO `sys_data_region` VALUES (2616, '西龙头', 4, '130828', '130828229', 'x');
INSERT INTO `sys_data_region` VALUES (2617, '塞罕坝机械林场', 4, '130828', '130828450', 's');
INSERT INTO `sys_data_region` VALUES (2618, '国营御道口牧场', 4, '130828', '130828500', 'g');
INSERT INTO `sys_data_region` VALUES (2619, '平泉', 3, '1308', '130881', 'p');
INSERT INTO `sys_data_region` VALUES (2620, '平泉镇', 4, '130881', '130881100', 'p');
INSERT INTO `sys_data_region` VALUES (2621, '黄土梁子', 4, '130881', '130881101', 'h');
INSERT INTO `sys_data_region` VALUES (2622, '榆树林子', 4, '130881', '130881102', 'y');
INSERT INTO `sys_data_region` VALUES (2623, '杨树岭', 4, '130881', '130881103', 'y');
INSERT INTO `sys_data_region` VALUES (2624, '七沟', 4, '130881', '130881104', 'q');
INSERT INTO `sys_data_region` VALUES (2625, '小寺沟', 4, '130881', '130881105', 'x');
INSERT INTO `sys_data_region` VALUES (2626, '党坝', 4, '130881', '130881106', 'd');
INSERT INTO `sys_data_region` VALUES (2627, '卧龙', 4, '130881', '130881109', 'w');
INSERT INTO `sys_data_region` VALUES (2628, '南五十家子', 4, '130881', '130881110', 'n');
INSERT INTO `sys_data_region` VALUES (2629, '北五十家子', 4, '130881', '130881111', 'b');
INSERT INTO `sys_data_region` VALUES (2630, '桲椤树', 4, '130881', '130881112', 'b');
INSERT INTO `sys_data_region` VALUES (2631, '柳溪', 4, '130881', '130881113', 'l');
INSERT INTO `sys_data_region` VALUES (2632, '王土房', 4, '130881', '130881200', 'w');
INSERT INTO `sys_data_region` VALUES (2633, '七家岱', 4, '130881', '130881203', 'q');
INSERT INTO `sys_data_region` VALUES (2634, '平北', 4, '130881', '130881204', 'p');
INSERT INTO `sys_data_region` VALUES (2635, '茅兰沟', 4, '130881', '130881206', 'm');
INSERT INTO `sys_data_region` VALUES (2636, '台头山', 4, '130881', '130881207', 't');
INSERT INTO `sys_data_region` VALUES (2637, '松树台', 4, '130881', '130881209', 's');
INSERT INTO `sys_data_region` VALUES (2638, '道虎沟', 4, '130881', '130881210', 'd');
INSERT INTO `sys_data_region` VALUES (2639, '沧州', 2, '13', '1309', 'c');
INSERT INTO `sys_data_region` VALUES (2640, '新华', 3, '1309', '130902', 'x');
INSERT INTO `sys_data_region` VALUES (2641, '建设北街', 4, '130902', '130902001', 'j');
INSERT INTO `sys_data_region` VALUES (2642, '车站', 4, '130902', '130902002', 'c');
INSERT INTO `sys_data_region` VALUES (2643, '南大街', 4, '130902', '130902003', 'n');
INSERT INTO `sys_data_region` VALUES (2644, '东环中街', 4, '130902', '130902004', 'd');
INSERT INTO `sys_data_region` VALUES (2645, '道东', 4, '130902', '130902005', 'd');
INSERT INTO `sys_data_region` VALUES (2646, '小赵庄', 4, '130902', '130902200', 'x');
INSERT INTO `sys_data_region` VALUES (2647, '沧州开发区', 4, '130902', '130902400', 'c');
INSERT INTO `sys_data_region` VALUES (2648, '运河', 3, '1309', '130903', 'y');
INSERT INTO `sys_data_region` VALUES (2649, '水月寺街', 4, '130903', '130903001', 's');
INSERT INTO `sys_data_region` VALUES (2650, '南环中路', 4, '130903', '130903002', 'n');
INSERT INTO `sys_data_region` VALUES (2651, '南湖', 4, '130903', '130903003', 'n');
INSERT INTO `sys_data_region` VALUES (2652, '市场', 4, '130903', '130903004', 's');
INSERT INTO `sys_data_region` VALUES (2653, '西环中街', 4, '130903', '130903005', 'x');
INSERT INTO `sys_data_region` VALUES (2654, '公园', 4, '130903', '130903006', 'g');
INSERT INTO `sys_data_region` VALUES (2655, '小王庄', 4, '130903', '130903100', 'x');
INSERT INTO `sys_data_region` VALUES (2656, '南陈屯', 4, '130903', '130903101', 'n');
INSERT INTO `sys_data_region` VALUES (2657, '沧县', 3, '1309', '130921', 'c');
INSERT INTO `sys_data_region` VALUES (2658, '旧州', 4, '130921', '130921100', 'j');
INSERT INTO `sys_data_region` VALUES (2659, '兴济', 4, '130921', '130921101', 'x');
INSERT INTO `sys_data_region` VALUES (2660, '杜生', 4, '130921', '130921102', 'd');
INSERT INTO `sys_data_region` VALUES (2661, '崔尔庄', 4, '130921', '130921103', 'c');
INSERT INTO `sys_data_region` VALUES (2662, '李天木', 4, '130921', '130921104', 'l');
INSERT INTO `sys_data_region` VALUES (2663, '姚官屯', 4, '130921', '130921105', 'y');
INSERT INTO `sys_data_region` VALUES (2664, '纸房头', 4, '130921', '130921106', 'z');
INSERT INTO `sys_data_region` VALUES (2665, '薛官屯', 4, '130921', '130921200', 'x');
INSERT INTO `sys_data_region` VALUES (2666, '捷地', 4, '130921', '130921201', 'j');
INSERT INTO `sys_data_region` VALUES (2667, '张官屯', 4, '130921', '130921202', 'z');
INSERT INTO `sys_data_region` VALUES (2668, '风化店', 4, '130921', '130921204', 'f');
INSERT INTO `sys_data_region` VALUES (2669, '杜林', 4, '130921', '130921206', 'd');
INSERT INTO `sys_data_region` VALUES (2670, '汪家铺', 4, '130921', '130921207', 'w');
INSERT INTO `sys_data_region` VALUES (2671, '刘家庙', 4, '130921', '130921208', 'l');
INSERT INTO `sys_data_region` VALUES (2672, '仵龙堂', 4, '130921', '130921209', 'w');
INSERT INTO `sys_data_region` VALUES (2673, '大官厅', 4, '130921', '130921210', 'd');
INSERT INTO `sys_data_region` VALUES (2674, '高川', 4, '130921', '130921211', 'g');
INSERT INTO `sys_data_region` VALUES (2675, '黄递铺', 4, '130921', '130921212', 'h');
INSERT INTO `sys_data_region` VALUES (2676, '大褚村', 4, '130921', '130921213', 'd');
INSERT INTO `sys_data_region` VALUES (2677, '青县', 3, '1309', '130922', 'q');
INSERT INTO `sys_data_region` VALUES (2678, '清州', 4, '130922', '130922100', 'q');
INSERT INTO `sys_data_region` VALUES (2679, '金牛', 4, '130922', '130922101', 'j');
INSERT INTO `sys_data_region` VALUES (2680, '新兴', 4, '130922', '130922102', 'x');
INSERT INTO `sys_data_region` VALUES (2681, '流河', 4, '130922', '130922103', 'l');
INSERT INTO `sys_data_region` VALUES (2682, '木门店', 4, '130922', '130922104', 'm');
INSERT INTO `sys_data_region` VALUES (2683, '马厂', 4, '130922', '130922105', 'm');
INSERT INTO `sys_data_region` VALUES (2684, '盘古', 4, '130922', '130922106', 'p');
INSERT INTO `sys_data_region` VALUES (2685, '曹寺', 4, '130922', '130922107', 'c');
INSERT INTO `sys_data_region` VALUES (2686, '上伍', 4, '130922', '130922200', 's');
INSERT INTO `sys_data_region` VALUES (2687, '陈嘴', 4, '130922', '130922203', 'c');
INSERT INTO `sys_data_region` VALUES (2688, '青县农场', 4, '130922', '130922400', 'q');
INSERT INTO `sys_data_region` VALUES (2689, '东光', 3, '1309', '130923', 'd');
INSERT INTO `sys_data_region` VALUES (2690, '东光镇', 4, '130923', '130923100', 'd');
INSERT INTO `sys_data_region` VALUES (2691, '连镇', 4, '130923', '130923101', 'l');
INSERT INTO `sys_data_region` VALUES (2692, '找王', 4, '130923', '130923102', 'z');
INSERT INTO `sys_data_region` VALUES (2693, '秦村', 4, '130923', '130923103', 'q');
INSERT INTO `sys_data_region` VALUES (2694, '灯明寺', 4, '130923', '130923104', 'd');
INSERT INTO `sys_data_region` VALUES (2695, '南霞口', 4, '130923', '130923105', 'n');
INSERT INTO `sys_data_region` VALUES (2696, '大单', 4, '130923', '130923106', 'd');
INSERT INTO `sys_data_region` VALUES (2697, '龙王李', 4, '130923', '130923107', 'l');
INSERT INTO `sys_data_region` VALUES (2698, '于桥', 4, '130923', '130923201', 'y');
INSERT INTO `sys_data_region` VALUES (2699, '海兴', 3, '1309', '130924', 'h');
INSERT INTO `sys_data_region` VALUES (2700, '苏基', 4, '130924', '130924100', 's');
INSERT INTO `sys_data_region` VALUES (2701, '辛集', 4, '130924', '130924101', 'x');
INSERT INTO `sys_data_region` VALUES (2702, '高湾', 4, '130924', '130924102', 'g');
INSERT INTO `sys_data_region` VALUES (2703, '赵毛陶', 4, '130924', '130924103', 'z');
INSERT INTO `sys_data_region` VALUES (2704, '香坊', 4, '130924', '130924201', 'x');
INSERT INTO `sys_data_region` VALUES (2705, '小山', 4, '130924', '130924202', 'x');
INSERT INTO `sys_data_region` VALUES (2706, '张会亭', 4, '130924', '130924203', 'z');
INSERT INTO `sys_data_region` VALUES (2707, '海兴县农场', 4, '130924', '130924400', 'h');
INSERT INTO `sys_data_region` VALUES (2708, '青先农场', 4, '130924', '130924401', 'q');
INSERT INTO `sys_data_region` VALUES (2709, '青锋农场', 4, '130924', '130924402', 'q');
INSERT INTO `sys_data_region` VALUES (2710, '盐山', 3, '1309', '130925', 'y');
INSERT INTO `sys_data_region` VALUES (2711, '盐山镇', 4, '130925', '130925100', 'y');
INSERT INTO `sys_data_region` VALUES (2712, '望树', 4, '130925', '130925101', 'w');
INSERT INTO `sys_data_region` VALUES (2713, '庆云', 4, '130925', '130925102', 'q');
INSERT INTO `sys_data_region` VALUES (2714, '韩集', 4, '130925', '130925103', 'h');
INSERT INTO `sys_data_region` VALUES (2715, '千童', 4, '130925', '130925104', 'q');
INSERT INTO `sys_data_region` VALUES (2716, '圣佛', 4, '130925', '130925105', 's');
INSERT INTO `sys_data_region` VALUES (2717, '边务', 4, '130925', '130925106', 'b');
INSERT INTO `sys_data_region` VALUES (2718, '小庄', 4, '130925', '130925107', 'x');
INSERT INTO `sys_data_region` VALUES (2719, '杨集', 4, '130925', '130925108', 'y');
INSERT INTO `sys_data_region` VALUES (2720, '小营', 4, '130925', '130925201', 'x');
INSERT INTO `sys_data_region` VALUES (2721, '孟店', 4, '130925', '130925203', 'm');
INSERT INTO `sys_data_region` VALUES (2722, '常庄', 4, '130925', '130925204', 'c');
INSERT INTO `sys_data_region` VALUES (2723, '肃宁', 3, '1309', '130926', 's');
INSERT INTO `sys_data_region` VALUES (2724, '肃宁镇', 4, '130926', '130926100', 's');
INSERT INTO `sys_data_region` VALUES (2725, '梁家村', 4, '130926', '130926101', 'l');
INSERT INTO `sys_data_region` VALUES (2726, '窝北', 4, '130926', '130926102', 'w');
INSERT INTO `sys_data_region` VALUES (2727, '尚村', 4, '130926', '130926103', 's');
INSERT INTO `sys_data_region` VALUES (2728, '万里', 4, '130926', '130926104', 'w');
INSERT INTO `sys_data_region` VALUES (2729, '师素', 4, '130926', '130926105', 's');
INSERT INTO `sys_data_region` VALUES (2730, '河北留善寺', 4, '130926', '130926106', 'h');
INSERT INTO `sys_data_region` VALUES (2731, '付家佐', 4, '130926', '130926107', 'f');
INSERT INTO `sys_data_region` VALUES (2732, '邵庄', 4, '130926', '130926205', 's');
INSERT INTO `sys_data_region` VALUES (2733, '南皮', 3, '1309', '130927', 'n');
INSERT INTO `sys_data_region` VALUES (2734, '南皮镇', 4, '130927', '130927100', 'n');
INSERT INTO `sys_data_region` VALUES (2735, '冯家口', 4, '130927', '130927101', 'f');
INSERT INTO `sys_data_region` VALUES (2736, '寨子', 4, '130927', '130927102', 'z');
INSERT INTO `sys_data_region` VALUES (2737, '鲍官屯', 4, '130927', '130927103', 'b');
INSERT INTO `sys_data_region` VALUES (2738, '王寺', 4, '130927', '130927104', 'w');
INSERT INTO `sys_data_region` VALUES (2739, '乌马营', 4, '130927', '130927105', 'w');
INSERT INTO `sys_data_region` VALUES (2740, '潞灌', 4, '130927', '130927106', 'l');
INSERT INTO `sys_data_region` VALUES (2741, '大浪淀', 4, '130927', '130927200', 'd');
INSERT INTO `sys_data_region` VALUES (2742, '刘八里', 4, '130927', '130927201', 'l');
INSERT INTO `sys_data_region` VALUES (2743, '吴桥', 3, '1309', '130928', 'w');
INSERT INTO `sys_data_region` VALUES (2744, '桑园', 4, '130928', '130928100', 's');
INSERT INTO `sys_data_region` VALUES (2745, '铁城', 4, '130928', '130928101', 't');
INSERT INTO `sys_data_region` VALUES (2746, '于集', 4, '130928', '130928102', 'y');
INSERT INTO `sys_data_region` VALUES (2747, '梁集', 4, '130928', '130928103', 'l');
INSERT INTO `sys_data_region` VALUES (2748, '安陵', 4, '130928', '130928104', 'a');
INSERT INTO `sys_data_region` VALUES (2749, '曹家洼', 4, '130928', '130928200', 'c');
INSERT INTO `sys_data_region` VALUES (2750, '宋门', 4, '130928', '130928201', 's');
INSERT INTO `sys_data_region` VALUES (2751, '杨家寺', 4, '130928', '130928202', 'y');
INSERT INTO `sys_data_region` VALUES (2752, '沟店铺', 4, '130928', '130928203', 'g');
INSERT INTO `sys_data_region` VALUES (2753, '何庄', 4, '130928', '130928204', 'h');
INSERT INTO `sys_data_region` VALUES (2754, '献县', 3, '1309', '130929', 'x');
INSERT INTO `sys_data_region` VALUES (2755, '乐寿', 4, '130929', '130929100', 'l');
INSERT INTO `sys_data_region` VALUES (2756, '淮镇', 4, '130929', '130929101', 'h');
INSERT INTO `sys_data_region` VALUES (2757, '郭庄', 4, '130929', '130929102', 'g');
INSERT INTO `sys_data_region` VALUES (2758, '河城街', 4, '130929', '130929103', 'h');
INSERT INTO `sys_data_region` VALUES (2759, '韩村', 4, '130929', '130929104', 'h');
INSERT INTO `sys_data_region` VALUES (2760, '陌南', 4, '130929', '130929105', 'm');
INSERT INTO `sys_data_region` VALUES (2761, '陈庄', 4, '130929', '130929106', 'c');
INSERT INTO `sys_data_region` VALUES (2762, '段村', 4, '130929', '130929107', 'd');
INSERT INTO `sys_data_region` VALUES (2763, '高官', 4, '130929', '130929108', 'g');
INSERT INTO `sys_data_region` VALUES (2764, '十五级', 4, '130929', '130929109', 's');
INSERT INTO `sys_data_region` VALUES (2765, '商林', 4, '130929', '130929206', 's');
INSERT INTO `sys_data_region` VALUES (2766, '本斋', 4, '130929', '130929208', 'b');
INSERT INTO `sys_data_region` VALUES (2767, '张村', 4, '130929', '130929209', 'z');
INSERT INTO `sys_data_region` VALUES (2768, '临河', 4, '130929', '130929210', 'l');
INSERT INTO `sys_data_region` VALUES (2769, '小平王', 4, '130929', '130929211', 'x');
INSERT INTO `sys_data_region` VALUES (2770, '垒头', 4, '130929', '130929213', 'l');
INSERT INTO `sys_data_region` VALUES (2771, '南河头', 4, '130929', '130929214', 'n');
INSERT INTO `sys_data_region` VALUES (2772, '西城', 4, '130929', '130929215', 'x');
INSERT INTO `sys_data_region` VALUES (2773, '孟村', 3, '1309', '130930', 'm');
INSERT INTO `sys_data_region` VALUES (2774, '孟村镇', 4, '130930', '130930100', 'm');
INSERT INTO `sys_data_region` VALUES (2775, '新县', 4, '130930', '130930101', 'x');
INSERT INTO `sys_data_region` VALUES (2776, '辛店', 4, '130930', '130930102', 'x');
INSERT INTO `sys_data_region` VALUES (2777, '高寨', 4, '130930', '130930103', 'g');
INSERT INTO `sys_data_region` VALUES (2778, '宋庄子', 4, '130930', '130930200', 's');
INSERT INTO `sys_data_region` VALUES (2779, '牛进庄', 4, '130930', '130930201', 'n');
INSERT INTO `sys_data_region` VALUES (2780, '泊头', 3, '1309', '130981', 'b');
INSERT INTO `sys_data_region` VALUES (2781, '解放', 4, '130981', '130981001', 'j');
INSERT INTO `sys_data_region` VALUES (2782, '河东', 4, '130981', '130981002', 'h');
INSERT INTO `sys_data_region` VALUES (2783, '鼓楼', 4, '130981', '130981003', 'g');
INSERT INTO `sys_data_region` VALUES (2784, '泊镇', 4, '130981', '130981100', 'b');
INSERT INTO `sys_data_region` VALUES (2785, '交河', 4, '130981', '130981101', 'j');
INSERT INTO `sys_data_region` VALUES (2786, '齐桥', 4, '130981', '130981102', 'q');
INSERT INTO `sys_data_region` VALUES (2787, '寺门村', 4, '130981', '130981103', 's');
INSERT INTO `sys_data_region` VALUES (2788, '郝村', 4, '130981', '130981104', 'h');
INSERT INTO `sys_data_region` VALUES (2789, '富镇', 4, '130981', '130981105', 'f');
INSERT INTO `sys_data_region` VALUES (2790, '文庙', 4, '130981', '130981106', 'w');
INSERT INTO `sys_data_region` VALUES (2791, '洼里王', 4, '130981', '130981107', 'w');
INSERT INTO `sys_data_region` VALUES (2792, '四营', 4, '130981', '130981108', 's');
INSERT INTO `sys_data_region` VALUES (2793, '王武庄', 4, '130981', '130981201', 'w');
INSERT INTO `sys_data_region` VALUES (2794, '营子', 4, '130981', '130981202', 'y');
INSERT INTO `sys_data_region` VALUES (2795, '西辛店', 4, '130981', '130981204', 'x');
INSERT INTO `sys_data_region` VALUES (2796, '任丘', 3, '1309', '130982', 'r');
INSERT INTO `sys_data_region` VALUES (2797, '新华路', 4, '130982', '130982001', 'x');
INSERT INTO `sys_data_region` VALUES (2798, '西环路', 4, '130982', '130982002', 'x');
INSERT INTO `sys_data_region` VALUES (2799, '永丰路', 4, '130982', '130982003', 'y');
INSERT INTO `sys_data_region` VALUES (2800, '中华路', 4, '130982', '130982004', 'z');
INSERT INTO `sys_data_region` VALUES (2801, '出岸', 4, '130982', '130982100', 'c');
INSERT INTO `sys_data_region` VALUES (2802, '石门桥', 4, '130982', '130982101', 's');
INSERT INTO `sys_data_region` VALUES (2803, '吕公堡', 4, '130982', '130982102', 'l');
INSERT INTO `sys_data_region` VALUES (2804, '长丰', 4, '130982', '130982103', 'c');
INSERT INTO `sys_data_region` VALUES (2805, '鄚州', 4, '130982', '130982104', 'm');
INSERT INTO `sys_data_region` VALUES (2806, '苟各庄', 4, '130982', '130982105', 'g');
INSERT INTO `sys_data_region` VALUES (2807, '辛中驿', 4, '130982', '130982106', 'x');
INSERT INTO `sys_data_region` VALUES (2808, '梁召', 4, '130982', '130982107', 'l');
INSERT INTO `sys_data_region` VALUES (2809, '麻家坞', 4, '130982', '130982108', 'm');
INSERT INTO `sys_data_region` VALUES (2810, '北辛庄', 4, '130982', '130982109', 'b');
INSERT INTO `sys_data_region` VALUES (2811, '议论堡', 4, '130982', '130982110', 'y');
INSERT INTO `sys_data_region` VALUES (2812, '青塔', 4, '130982', '130982204', 'q');
INSERT INTO `sys_data_region` VALUES (2813, '七间房', 4, '130982', '130982206', 'q');
INSERT INTO `sys_data_region` VALUES (2814, '北汉', 4, '130982', '130982207', 'b');
INSERT INTO `sys_data_region` VALUES (2815, '于村', 4, '130982', '130982208', 'y');
INSERT INTO `sys_data_region` VALUES (2816, '华北石油管理局', 4, '130982', '130982400', 'h');
INSERT INTO `sys_data_region` VALUES (2817, '开发区管理委员会', 4, '130982', '130982500', 'k');
INSERT INTO `sys_data_region` VALUES (2818, '黄骅', 3, '1309', '130983', 'h');
INSERT INTO `sys_data_region` VALUES (2819, '骅东', 4, '130983', '130983001', 'h');
INSERT INTO `sys_data_region` VALUES (2820, '骅中', 4, '130983', '130983002', 'h');
INSERT INTO `sys_data_region` VALUES (2821, '骅西', 4, '130983', '130983003', 'h');
INSERT INTO `sys_data_region` VALUES (2822, '黄骅镇', 4, '130983', '130983100', 'h');
INSERT INTO `sys_data_region` VALUES (2823, '南排河', 4, '130983', '130983101', 'n');
INSERT INTO `sys_data_region` VALUES (2824, '吕桥', 4, '130983', '130983102', 'l');
INSERT INTO `sys_data_region` VALUES (2825, '旧城', 4, '130983', '130983103', 'j');
INSERT INTO `sys_data_region` VALUES (2826, '齐家务', 4, '130983', '130983104', 'q');
INSERT INTO `sys_data_region` VALUES (2827, '滕庄子', 4, '130983', '130983105', 't');
INSERT INTO `sys_data_region` VALUES (2828, '羊二庄', 4, '130983', '130983106', 'y');
INSERT INTO `sys_data_region` VALUES (2829, '常郭', 4, '130983', '130983107', 'c');
INSERT INTO `sys_data_region` VALUES (2830, '官庄', 4, '130983', '130983204', 'g');
INSERT INTO `sys_data_region` VALUES (2831, '新村', 4, '130983', '130983206', 'x');
INSERT INTO `sys_data_region` VALUES (2832, '羊三木', 4, '130983', '130983207', 'y');
INSERT INTO `sys_data_region` VALUES (2833, '南大港管理区', 4, '130983', '130983400', 'n');
INSERT INTO `sys_data_region` VALUES (2834, '国营中捷农场', 4, '130983', '130983401', 'g');
INSERT INTO `sys_data_region` VALUES (2835, '临港化工园区', 4, '130983', '130983403', 'l');
INSERT INTO `sys_data_region` VALUES (2836, '河间', 3, '1309', '130984', 'h');
INSERT INTO `sys_data_region` VALUES (2837, '瀛州路', 4, '130984', '130984001', 'y');
INSERT INTO `sys_data_region` VALUES (2838, '城垣西路', 4, '130984', '130984002', 'c');
INSERT INTO `sys_data_region` VALUES (2839, '米各庄', 4, '130984', '130984101', 'm');
INSERT INTO `sys_data_region` VALUES (2840, '景和', 4, '130984', '130984102', 'j');
INSERT INTO `sys_data_region` VALUES (2841, '卧佛堂', 4, '130984', '130984103', 'w');
INSERT INTO `sys_data_region` VALUES (2842, '束城', 4, '130984', '130984104', 's');
INSERT INTO `sys_data_region` VALUES (2843, '留古寺', 4, '130984', '130984105', 'l');
INSERT INTO `sys_data_region` VALUES (2844, '沙河桥', 4, '130984', '130984106', 's');
INSERT INTO `sys_data_region` VALUES (2845, '诗经村', 4, '130984', '130984107', 's');
INSERT INTO `sys_data_region` VALUES (2846, '尊祖庄', 4, '130984', '130984108', 'z');
INSERT INTO `sys_data_region` VALUES (2847, '兴村', 4, '130984', '130984109', 'x');
INSERT INTO `sys_data_region` VALUES (2848, '行别营', 4, '130984', '130984110', 'x');
INSERT INTO `sys_data_region` VALUES (2849, '故仙', 4, '130984', '130984111', 'g');
INSERT INTO `sys_data_region` VALUES (2850, '黎民居', 4, '130984', '130984201', 'l');
INSERT INTO `sys_data_region` VALUES (2851, '沙洼', 4, '130984', '130984203', 's');
INSERT INTO `sys_data_region` VALUES (2852, '西九吉', 4, '130984', '130984204', 'x');
INSERT INTO `sys_data_region` VALUES (2853, '北石槽', 4, '130984', '130984205', 'b');
INSERT INTO `sys_data_region` VALUES (2854, '果子洼', 4, '130984', '130984206', 'g');
INSERT INTO `sys_data_region` VALUES (2855, '时村', 4, '130984', '130984209', 's');
INSERT INTO `sys_data_region` VALUES (2856, '龙华店', 4, '130984', '130984212', 'l');
INSERT INTO `sys_data_region` VALUES (2857, '廊坊', 2, '13', '1310', 'l');
INSERT INTO `sys_data_region` VALUES (2858, '安次', 3, '1310', '131002', 'a');
INSERT INTO `sys_data_region` VALUES (2859, '银河南路', 4, '131002', '131002001', 'y');
INSERT INTO `sys_data_region` VALUES (2860, '光明西道', 4, '131002', '131002002', 'g');
INSERT INTO `sys_data_region` VALUES (2861, '永华道', 4, '131002', '131002003', 'y');
INSERT INTO `sys_data_region` VALUES (2862, '落垡', 4, '131002', '131002100', 'l');
INSERT INTO `sys_data_region` VALUES (2863, '码头', 4, '131002', '131002101', 'm');
INSERT INTO `sys_data_region` VALUES (2864, '葛渔城', 4, '131002', '131002102', 'g');
INSERT INTO `sys_data_region` VALUES (2865, '东沽港', 4, '131002', '131002103', 'd');
INSERT INTO `sys_data_region` VALUES (2866, '杨税务', 4, '131002', '131002104', 'y');
INSERT INTO `sys_data_region` VALUES (2867, '北史家务', 4, '131002', '131002105', 'b');
INSERT INTO `sys_data_region` VALUES (2868, '调河头', 4, '131002', '131002106', 't');
INSERT INTO `sys_data_region` VALUES (2869, '仇庄', 4, '131002', '131002107', 'c');
INSERT INTO `sys_data_region` VALUES (2870, '广阳', 3, '1310', '131003', 'g');
INSERT INTO `sys_data_region` VALUES (2871, '银河北路', 4, '131003', '131003001', 'y');
INSERT INTO `sys_data_region` VALUES (2872, '爱民东道', 4, '131003', '131003002', 'a');
INSERT INTO `sys_data_region` VALUES (2873, '解放道', 4, '131003', '131003003', 'j');
INSERT INTO `sys_data_region` VALUES (2874, '新开路', 4, '131003', '131003004', 'x');
INSERT INTO `sys_data_region` VALUES (2875, '新源道', 4, '131003', '131003005', 'x');
INSERT INTO `sys_data_region` VALUES (2876, '南尖塔', 4, '131003', '131003100', 'n');
INSERT INTO `sys_data_region` VALUES (2877, '万庄', 4, '131003', '131003101', 'w');
INSERT INTO `sys_data_region` VALUES (2878, '九州', 4, '131003', '131003102', 'j');
INSERT INTO `sys_data_region` VALUES (2879, '北旺', 4, '131003', '131003103', 'b');
INSERT INTO `sys_data_region` VALUES (2880, '廊坊经济技术开发区', 4, '131003', '131003450', 'l');
INSERT INTO `sys_data_region` VALUES (2881, '固安', 3, '1310', '131022', 'g');
INSERT INTO `sys_data_region` VALUES (2882, '固安镇', 4, '131022', '131022100', 'g');
INSERT INTO `sys_data_region` VALUES (2883, '宫村', 4, '131022', '131022101', 'g');
INSERT INTO `sys_data_region` VALUES (2884, '柳泉', 4, '131022', '131022102', 'l');
INSERT INTO `sys_data_region` VALUES (2885, '牛驼', 4, '131022', '131022103', 'n');
INSERT INTO `sys_data_region` VALUES (2886, '马庄', 4, '131022', '131022104', 'm');
INSERT INTO `sys_data_region` VALUES (2887, '东湾', 4, '131022', '131022105', 'd');
INSERT INTO `sys_data_region` VALUES (2888, '渠沟', 4, '131022', '131022106', 'q');
INSERT INTO `sys_data_region` VALUES (2889, '彭村', 4, '131022', '131022201', 'p');
INSERT INTO `sys_data_region` VALUES (2890, '礼让店', 4, '131022', '131022203', 'l');
INSERT INTO `sys_data_region` VALUES (2891, '永清', 3, '1310', '131023', 'y');
INSERT INTO `sys_data_region` VALUES (2892, '城区', 4, '131023', '131023001', 'c');
INSERT INTO `sys_data_region` VALUES (2893, '永清镇', 4, '131023', '131023100', 'y');
INSERT INTO `sys_data_region` VALUES (2894, '韩村', 4, '131023', '131023101', 'h');
INSERT INTO `sys_data_region` VALUES (2895, '后弈', 4, '131023', '131023102', 'h');
INSERT INTO `sys_data_region` VALUES (2896, '别古庄', 4, '131023', '131023103', 'b');
INSERT INTO `sys_data_region` VALUES (2897, '里澜城', 4, '131023', '131023104', 'l');
INSERT INTO `sys_data_region` VALUES (2898, '管家务', 4, '131023', '131023200', 'g');
INSERT INTO `sys_data_region` VALUES (2899, '曹家务', 4, '131023', '131023201', 'c');
INSERT INTO `sys_data_region` VALUES (2900, '龙虎庄', 4, '131023', '131023202', 'l');
INSERT INTO `sys_data_region` VALUES (2901, '刘街', 4, '131023', '131023203', 'l');
INSERT INTO `sys_data_region` VALUES (2902, '三圣口', 4, '131023', '131023204', 's');
INSERT INTO `sys_data_region` VALUES (2903, '香河', 3, '1310', '131024', 'x');
INSERT INTO `sys_data_region` VALUES (2904, '淑阳', 4, '131024', '131024100', 's');
INSERT INTO `sys_data_region` VALUES (2905, '蒋辛屯', 4, '131024', '131024101', 'j');
INSERT INTO `sys_data_region` VALUES (2906, '渠口', 4, '131024', '131024102', 'q');
INSERT INTO `sys_data_region` VALUES (2907, '安头屯', 4, '131024', '131024103', 'a');
INSERT INTO `sys_data_region` VALUES (2908, '安平', 4, '131024', '131024104', 'a');
INSERT INTO `sys_data_region` VALUES (2909, '刘宋', 4, '131024', '131024105', 'l');
INSERT INTO `sys_data_region` VALUES (2910, '五百户', 4, '131024', '131024106', 'w');
INSERT INTO `sys_data_region` VALUES (2911, '钳屯', 4, '131024', '131024107', 'q');
INSERT INTO `sys_data_region` VALUES (2912, '钱旺', 4, '131024', '131024108', 'q');
INSERT INTO `sys_data_region` VALUES (2913, '大城', 3, '1310', '131025', 'd');
INSERT INTO `sys_data_region` VALUES (2914, '平舒', 4, '131025', '131025100', 'p');
INSERT INTO `sys_data_region` VALUES (2915, '旺村', 4, '131025', '131025101', 'w');
INSERT INTO `sys_data_region` VALUES (2916, '大尚屯', 4, '131025', '131025102', 'd');
INSERT INTO `sys_data_region` VALUES (2917, '南赵扶', 4, '131025', '131025103', 'n');
INSERT INTO `sys_data_region` VALUES (2918, '留各庄', 4, '131025', '131025104', 'l');
INSERT INTO `sys_data_region` VALUES (2919, '权村', 4, '131025', '131025105', 'q');
INSERT INTO `sys_data_region` VALUES (2920, '里坦', 4, '131025', '131025106', 'l');
INSERT INTO `sys_data_region` VALUES (2921, '广安', 4, '131025', '131025107', 'g');
INSERT INTO `sys_data_region` VALUES (2922, '北魏', 4, '131025', '131025108', 'b');
INSERT INTO `sys_data_region` VALUES (2923, '臧屯', 4, '131025', '131025109', 'z');
INSERT INTO `sys_data_region` VALUES (2924, '摩配园区管委会', 4, '131025', '131025400', 'm');
INSERT INTO `sys_data_region` VALUES (2925, '文安', 3, '1310', '131026', 'w');
INSERT INTO `sys_data_region` VALUES (2926, '文安镇', 4, '131026', '131026100', 'w');
INSERT INTO `sys_data_region` VALUES (2927, '新镇', 4, '131026', '131026101', 'x');
INSERT INTO `sys_data_region` VALUES (2928, '苏桥', 4, '131026', '131026102', 's');
INSERT INTO `sys_data_region` VALUES (2929, '大柳河', 4, '131026', '131026103', 'd');
INSERT INTO `sys_data_region` VALUES (2930, '左各庄', 4, '131026', '131026104', 'z');
INSERT INTO `sys_data_region` VALUES (2931, '滩里', 4, '131026', '131026105', 't');
INSERT INTO `sys_data_region` VALUES (2932, '史各庄', 4, '131026', '131026106', 's');
INSERT INTO `sys_data_region` VALUES (2933, '赵各庄', 4, '131026', '131026107', 'z');
INSERT INTO `sys_data_region` VALUES (2934, '兴隆宫', 4, '131026', '131026108', 'x');
INSERT INTO `sys_data_region` VALUES (2935, '大留镇', 4, '131026', '131026109', 'd');
INSERT INTO `sys_data_region` VALUES (2936, '孙氏', 4, '131026', '131026110', 's');
INSERT INTO `sys_data_region` VALUES (2937, '德归', 4, '131026', '131026111', 'd');
INSERT INTO `sys_data_region` VALUES (2938, '大围河', 4, '131026', '131026200', 'd');
INSERT INTO `sys_data_region` VALUES (2939, '大厂', 3, '1310', '131028', 'd');
INSERT INTO `sys_data_region` VALUES (2940, '大厂镇', 4, '131028', '131028100', 'd');
INSERT INTO `sys_data_region` VALUES (2941, '夏垫', 4, '131028', '131028101', 'x');
INSERT INTO `sys_data_region` VALUES (2942, '祁各庄', 4, '131028', '131028102', 'q');
INSERT INTO `sys_data_region` VALUES (2943, '陈府', 4, '131028', '131028103', 'c');
INSERT INTO `sys_data_region` VALUES (2944, '邵府', 4, '131028', '131028104', 's');
INSERT INTO `sys_data_region` VALUES (2945, '霸州', 3, '1310', '131081', 'b');
INSERT INTO `sys_data_region` VALUES (2946, '裕华', 4, '131081', '131081001', 'y');
INSERT INTO `sys_data_region` VALUES (2947, '霸州镇', 4, '131081', '131081100', 'b');
INSERT INTO `sys_data_region` VALUES (2948, '南孟', 4, '131081', '131081101', 'n');
INSERT INTO `sys_data_region` VALUES (2949, '信安', 4, '131081', '131081102', 'x');
INSERT INTO `sys_data_region` VALUES (2950, '堂二里', 4, '131081', '131081103', 't');
INSERT INTO `sys_data_region` VALUES (2951, '煎茶铺', 4, '131081', '131081104', 'j');
INSERT INTO `sys_data_region` VALUES (2952, '胜芳', 4, '131081', '131081105', 's');
INSERT INTO `sys_data_region` VALUES (2953, '扬芬港', 4, '131081', '131081106', 'y');
INSERT INTO `sys_data_region` VALUES (2954, '康仙庄', 4, '131081', '131081107', 'k');
INSERT INTO `sys_data_region` VALUES (2955, '王庄子', 4, '131081', '131081108', 'w');
INSERT INTO `sys_data_region` VALUES (2956, '岔河集', 4, '131081', '131081200', 'c');
INSERT INTO `sys_data_region` VALUES (2957, '东杨庄', 4, '131081', '131081202', 'd');
INSERT INTO `sys_data_region` VALUES (2958, '东段', 4, '131081', '131081204', 'd');
INSERT INTO `sys_data_region` VALUES (2959, '三河', 3, '1310', '131082', 's');
INSERT INTO `sys_data_region` VALUES (2960, '鼎盛东', 4, '131082', '131082001', 'd');
INSERT INTO `sys_data_region` VALUES (2961, '泃阳西', 4, '131082', '131082002', 'j');
INSERT INTO `sys_data_region` VALUES (2962, '泃阳', 4, '131082', '131082100', 'j');
INSERT INTO `sys_data_region` VALUES (2963, '李旗庄', 4, '131082', '131082101', 'l');
INSERT INTO `sys_data_region` VALUES (2964, '杨庄', 4, '131082', '131082102', 'y');
INSERT INTO `sys_data_region` VALUES (2965, '皇庄', 4, '131082', '131082103', 'h');
INSERT INTO `sys_data_region` VALUES (2966, '新集', 4, '131082', '131082104', 'x');
INSERT INTO `sys_data_region` VALUES (2967, '段甲岭', 4, '131082', '131082105', 'd');
INSERT INTO `sys_data_region` VALUES (2968, '黄土庄', 4, '131082', '131082106', 'h');
INSERT INTO `sys_data_region` VALUES (2969, '高楼', 4, '131082', '131082107', 'g');
INSERT INTO `sys_data_region` VALUES (2970, '齐心庄', 4, '131082', '131082108', 'q');
INSERT INTO `sys_data_region` VALUES (2971, '燕郊', 4, '131082', '131082109', 'y');
INSERT INTO `sys_data_region` VALUES (2972, '燕郊经济技术开发区', 4, '131082', '131082450', 'y');
INSERT INTO `sys_data_region` VALUES (2973, '衡水', 2, '13', '1311', 'h');
INSERT INTO `sys_data_region` VALUES (2974, '桃城', 3, '1311', '131102', 't');
INSERT INTO `sys_data_region` VALUES (2975, '河西', 4, '131102', '131102001', 'h');
INSERT INTO `sys_data_region` VALUES (2976, '河东', 4, '131102', '131102002', 'h');
INSERT INTO `sys_data_region` VALUES (2977, '路北', 4, '131102', '131102003', 'l');
INSERT INTO `sys_data_region` VALUES (2978, '中华大街', 4, '131102', '131102004', 'z');
INSERT INTO `sys_data_region` VALUES (2979, '郑家河沿', 4, '131102', '131102100', 'z');
INSERT INTO `sys_data_region` VALUES (2980, '赵家圈', 4, '131102', '131102101', 'z');
INSERT INTO `sys_data_region` VALUES (2981, '邓庄', 4, '131102', '131102102', 'd');
INSERT INTO `sys_data_region` VALUES (2982, '何家庄', 4, '131102', '131102200', 'h');
INSERT INTO `sys_data_region` VALUES (2983, '大麻森', 4, '131102', '131102201', 'd');
INSERT INTO `sys_data_region` VALUES (2984, '彭杜村', 4, '131102', '131102203', 'p');
INSERT INTO `sys_data_region` VALUES (2985, '衡水高新技术产业开发区', 4, '131102', '131102400', 'h');
INSERT INTO `sys_data_region` VALUES (2986, '衡水湖自然保护区管理处', 4, '131102', '131102401', 'h');
INSERT INTO `sys_data_region` VALUES (2987, '冀州', 3, '1311', '131103', 'j');
INSERT INTO `sys_data_region` VALUES (2988, '冀州镇', 4, '131103', '131103100', 'j');
INSERT INTO `sys_data_region` VALUES (2989, '官道李', 4, '131103', '131103101', 'g');
INSERT INTO `sys_data_region` VALUES (2990, '南午村', 4, '131103', '131103102', 'n');
INSERT INTO `sys_data_region` VALUES (2991, '周村', 4, '131103', '131103103', 'z');
INSERT INTO `sys_data_region` VALUES (2992, '码头李', 4, '131103', '131103104', 'm');
INSERT INTO `sys_data_region` VALUES (2993, '西王', 4, '131103', '131103105', 'x');
INSERT INTO `sys_data_region` VALUES (2994, '魏家屯', 4, '131103', '131103107', 'w');
INSERT INTO `sys_data_region` VALUES (2995, '门家庄', 4, '131103', '131103200', 'm');
INSERT INTO `sys_data_region` VALUES (2996, '徐家庄', 4, '131103', '131103201', 'x');
INSERT INTO `sys_data_region` VALUES (2997, '北漳淮', 4, '131103', '131103202', 'b');
INSERT INTO `sys_data_region` VALUES (2998, '小寨', 4, '131103', '131103203', 'x');
INSERT INTO `sys_data_region` VALUES (2999, '枣强', 3, '1311', '131121', 'z');
INSERT INTO `sys_data_region` VALUES (3000, '枣强镇', 4, '131121', '131121100', 'z');
INSERT INTO `sys_data_region` VALUES (3001, '恩察', 4, '131121', '131121101', 'e');
INSERT INTO `sys_data_region` VALUES (3002, '大营', 4, '131121', '131121102', 'd');
INSERT INTO `sys_data_region` VALUES (3003, '嘉会', 4, '131121', '131121103', 'j');
INSERT INTO `sys_data_region` VALUES (3004, '马屯', 4, '131121', '131121104', 'm');
INSERT INTO `sys_data_region` VALUES (3005, '肖张', 4, '131121', '131121105', 'x');
INSERT INTO `sys_data_region` VALUES (3006, '张秀屯', 4, '131121', '131121106', 'z');
INSERT INTO `sys_data_region` VALUES (3007, '新屯', 4, '131121', '131121107', 'x');
INSERT INTO `sys_data_region` VALUES (3008, '唐林', 4, '131121', '131121108', 't');
INSERT INTO `sys_data_region` VALUES (3009, '王均', 4, '131121', '131121202', 'w');
INSERT INTO `sys_data_region` VALUES (3010, '王常', 4, '131121', '131121204', 'w');
INSERT INTO `sys_data_region` VALUES (3011, '武邑', 3, '1311', '131122', 'w');
INSERT INTO `sys_data_region` VALUES (3012, '武邑镇', 4, '131122', '131122100', 'w');
INSERT INTO `sys_data_region` VALUES (3013, '清凉店', 4, '131122', '131122101', 'q');
INSERT INTO `sys_data_region` VALUES (3014, '审坡', 4, '131122', '131122102', 's');
INSERT INTO `sys_data_region` VALUES (3015, '赵桥', 4, '131122', '131122103', 'z');
INSERT INTO `sys_data_region` VALUES (3016, '韩庄', 4, '131122', '131122104', 'h');
INSERT INTO `sys_data_region` VALUES (3017, '肖桥头', 4, '131122', '131122105', 'x');
INSERT INTO `sys_data_region` VALUES (3018, '龙店', 4, '131122', '131122106', 'l');
INSERT INTO `sys_data_region` VALUES (3019, '圈头', 4, '131122', '131122201', 'q');
INSERT INTO `sys_data_region` VALUES (3020, '大紫塔', 4, '131122', '131122203', 'd');
INSERT INTO `sys_data_region` VALUES (3021, '武强', 3, '1311', '131123', 'w');
INSERT INTO `sys_data_region` VALUES (3022, '武强镇', 4, '131123', '131123100', 'w');
INSERT INTO `sys_data_region` VALUES (3023, '街关', 4, '131123', '131123101', 'j');
INSERT INTO `sys_data_region` VALUES (3024, '周窝', 4, '131123', '131123102', 'z');
INSERT INTO `sys_data_region` VALUES (3025, '东孙庄', 4, '131123', '131123103', 'd');
INSERT INTO `sys_data_region` VALUES (3026, '豆村', 4, '131123', '131123104', 'd');
INSERT INTO `sys_data_region` VALUES (3027, '北代', 4, '131123', '131123201', 'b');
INSERT INTO `sys_data_region` VALUES (3028, '饶阳', 3, '1311', '131124', 'r');
INSERT INTO `sys_data_region` VALUES (3029, '饶阳镇', 4, '131124', '131124100', 'r');
INSERT INTO `sys_data_region` VALUES (3030, '大尹村', 4, '131124', '131124101', 'd');
INSERT INTO `sys_data_region` VALUES (3031, '五公', 4, '131124', '131124102', 'w');
INSERT INTO `sys_data_region` VALUES (3032, '大官亭', 4, '131124', '131124103', 'd');
INSERT INTO `sys_data_region` VALUES (3033, '王同岳', 4, '131124', '131124104', 'w');
INSERT INTO `sys_data_region` VALUES (3034, '东里满', 4, '131124', '131124105', 'd');
INSERT INTO `sys_data_region` VALUES (3035, '留楚', 4, '131124', '131124106', 'l');
INSERT INTO `sys_data_region` VALUES (3036, '安平', 3, '1311', '131125', 'a');
INSERT INTO `sys_data_region` VALUES (3037, '安平镇', 4, '131125', '131125100', 'a');
INSERT INTO `sys_data_region` VALUES (3038, '马店', 4, '131125', '131125101', 'm');
INSERT INTO `sys_data_region` VALUES (3039, '南王庄', 4, '131125', '131125102', 'n');
INSERT INTO `sys_data_region` VALUES (3040, '大子文', 4, '131125', '131125103', 't');
INSERT INTO `sys_data_region` VALUES (3041, '东黄城', 4, '131125', '131125104', 'd');
INSERT INTO `sys_data_region` VALUES (3042, '大何庄', 4, '131125', '131125200', 'd');
INSERT INTO `sys_data_region` VALUES (3043, '程油子', 4, '131125', '131125201', 'c');
INSERT INTO `sys_data_region` VALUES (3044, '西两洼', 4, '131125', '131125202', 'x');
INSERT INTO `sys_data_region` VALUES (3045, '故城', 3, '1311', '131126', 'g');
INSERT INTO `sys_data_region` VALUES (3046, '郑口', 4, '131126', '131126100', 'z');
INSERT INTO `sys_data_region` VALUES (3047, '夏庄', 4, '131126', '131126101', 'x');
INSERT INTO `sys_data_region` VALUES (3048, '青罕', 4, '131126', '131126102', 'q');
INSERT INTO `sys_data_region` VALUES (3049, '故城镇', 4, '131126', '131126103', 'g');
INSERT INTO `sys_data_region` VALUES (3050, '武官寨', 4, '131126', '131126104', 'w');
INSERT INTO `sys_data_region` VALUES (3051, '饶阳店', 4, '131126', '131126105', 'r');
INSERT INTO `sys_data_region` VALUES (3052, '军屯', 4, '131126', '131126106', 'j');
INSERT INTO `sys_data_region` VALUES (3053, '建国', 4, '131126', '131126107', 'j');
INSERT INTO `sys_data_region` VALUES (3054, '西半屯', 4, '131126', '131126108', 'x');
INSERT INTO `sys_data_region` VALUES (3055, '房庄', 4, '131126', '131126109', 'f');
INSERT INTO `sys_data_region` VALUES (3056, '三朗', 4, '131126', '131126110', 's');
INSERT INTO `sys_data_region` VALUES (3057, '辛庄', 4, '131126', '131126200', 'x');
INSERT INTO `sys_data_region` VALUES (3058, '里老', 4, '131126', '131126201', 'l');
INSERT INTO `sys_data_region` VALUES (3059, '景县', 3, '1311', '131127', 'j');
INSERT INTO `sys_data_region` VALUES (3060, '景州', 4, '131127', '131127100', 'j');
INSERT INTO `sys_data_region` VALUES (3061, '龙华', 4, '131127', '131127101', 'l');
INSERT INTO `sys_data_region` VALUES (3062, '广川', 4, '131127', '131127102', 'g');
INSERT INTO `sys_data_region` VALUES (3063, '王瞳', 4, '131127', '131127103', 'w');
INSERT INTO `sys_data_region` VALUES (3064, '洚河流', 4, '131127', '131127104', 'j');
INSERT INTO `sys_data_region` VALUES (3065, '安陵', 4, '131127', '131127105', 'a');
INSERT INTO `sys_data_region` VALUES (3066, '杜桥', 4, '131127', '131127106', 'd');
INSERT INTO `sys_data_region` VALUES (3067, '王谦寺', 4, '131127', '131127107', 'w');
INSERT INTO `sys_data_region` VALUES (3068, '留智庙', 4, '131127', '131127108', 'l');
INSERT INTO `sys_data_region` VALUES (3069, '北留智', 4, '131127', '131127109', 'b');
INSERT INTO `sys_data_region` VALUES (3070, '梁集', 4, '131127', '131127110', 'l');
INSERT INTO `sys_data_region` VALUES (3071, '刘集', 4, '131127', '131127200', 'l');
INSERT INTO `sys_data_region` VALUES (3072, '连镇', 4, '131127', '131127201', 'l');
INSERT INTO `sys_data_region` VALUES (3073, '温城', 4, '131127', '131127203', 'w');
INSERT INTO `sys_data_region` VALUES (3074, '后留名府', 4, '131127', '131127204', 'h');
INSERT INTO `sys_data_region` VALUES (3075, '青兰', 4, '131127', '131127205', 'q');
INSERT INTO `sys_data_region` VALUES (3076, '阜城', 3, '1311', '131128', 'f');
INSERT INTO `sys_data_region` VALUES (3077, '阜城镇', 4, '131128', '131128100', 'f');
INSERT INTO `sys_data_region` VALUES (3078, '古城', 4, '131128', '131128101', 'g');
INSERT INTO `sys_data_region` VALUES (3079, '码头', 4, '131128', '131128102', 'm');
INSERT INTO `sys_data_region` VALUES (3080, '霞口', 4, '131128', '131128103', 'x');
INSERT INTO `sys_data_region` VALUES (3081, '崔家庙', 4, '131128', '131128104', 'c');
INSERT INTO `sys_data_region` VALUES (3082, '漫河', 4, '131128', '131128105', 'm');
INSERT INTO `sys_data_region` VALUES (3083, '建桥', 4, '131128', '131128201', 'j');
INSERT INTO `sys_data_region` VALUES (3084, '蒋坊', 4, '131128', '131128202', 'j');
INSERT INTO `sys_data_region` VALUES (3085, '大白', 4, '131128', '131128203', 'd');
INSERT INTO `sys_data_region` VALUES (3086, '王集', 4, '131128', '131128204', 'w');
INSERT INTO `sys_data_region` VALUES (3087, '深州', 3, '1311', '131182', 's');
INSERT INTO `sys_data_region` VALUES (3088, '唐奉', 4, '131182', '131182100', 't');
INSERT INTO `sys_data_region` VALUES (3089, '深州镇', 4, '131182', '131182101', 's');
INSERT INTO `sys_data_region` VALUES (3090, '辰时', 4, '131182', '131182102', 'c');
INSERT INTO `sys_data_region` VALUES (3091, '榆科', 4, '131182', '131182103', 'y');
INSERT INTO `sys_data_region` VALUES (3092, '魏家桥', 4, '131182', '131182104', 'w');
INSERT INTO `sys_data_region` VALUES (3093, '大堤', 4, '131182', '131182105', 'd');
INSERT INTO `sys_data_region` VALUES (3094, '前磨头', 4, '131182', '131182106', 'q');
INSERT INTO `sys_data_region` VALUES (3095, '王家井', 4, '131182', '131182107', 'w');
INSERT INTO `sys_data_region` VALUES (3096, '护驾迟', 4, '131182', '131182108', 'h');
INSERT INTO `sys_data_region` VALUES (3097, '大屯', 4, '131182', '131182109', 'd');
INSERT INTO `sys_data_region` VALUES (3098, '高古庄', 4, '131182', '131182110', 'g');
INSERT INTO `sys_data_region` VALUES (3099, '北溪村', 4, '131182', '131182111', 'b');
INSERT INTO `sys_data_region` VALUES (3100, '大冯营', 4, '131182', '131182112', 'd');
INSERT INTO `sys_data_region` VALUES (3101, '兵曹', 4, '131182', '131182200', 'b');
INSERT INTO `sys_data_region` VALUES (3102, '穆村', 4, '131182', '131182201', 'm');
INSERT INTO `sys_data_region` VALUES (3103, '东安庄', 4, '131182', '131182202', 'd');
INSERT INTO `sys_data_region` VALUES (3104, '乔屯', 4, '131182', '131182206', 'q');
INSERT INTO `sys_data_region` VALUES (3105, '山西', 1, '0', '14', 's');
INSERT INTO `sys_data_region` VALUES (3106, '太原', 2, '14', '1401', 't');
INSERT INTO `sys_data_region` VALUES (3107, '小店', 3, '1401', '140105', 'x');
INSERT INTO `sys_data_region` VALUES (3108, '坞城', 4, '140105', '140105001', 'w');
INSERT INTO `sys_data_region` VALUES (3109, '营盘', 4, '140105', '140105002', 'y');
INSERT INTO `sys_data_region` VALUES (3110, '北营', 4, '140105', '140105003', 'b');
INSERT INTO `sys_data_region` VALUES (3111, '平阳路', 4, '140105', '140105004', 'p');
INSERT INTO `sys_data_region` VALUES (3112, '黄陵', 4, '140105', '140105005', 'h');
INSERT INTO `sys_data_region` VALUES (3113, '小店街道', 4, '140105', '140105006', 'x');
INSERT INTO `sys_data_region` VALUES (3114, '龙城', 4, '140105', '140105007', 'l');
INSERT INTO `sys_data_region` VALUES (3115, '北格', 4, '140105', '140105100', 'b');
INSERT INTO `sys_data_region` VALUES (3116, '西温庄', 4, '140105', '140105200', 'x');
INSERT INTO `sys_data_region` VALUES (3117, '刘家堡', 4, '140105', '140105201', 'l');
INSERT INTO `sys_data_region` VALUES (3118, '太原高新技术产业开发区', 4, '140105', '140105401', 't');
INSERT INTO `sys_data_region` VALUES (3119, '太原经济技术开发区', 4, '140105', '140105501', 't');
INSERT INTO `sys_data_region` VALUES (3120, '迎泽', 3, '1401', '140106', 'y');
INSERT INTO `sys_data_region` VALUES (3121, '柳巷', 4, '140106', '140106001', 'l');
INSERT INTO `sys_data_region` VALUES (3122, '文庙', 4, '140106', '140106002', 'w');
INSERT INTO `sys_data_region` VALUES (3123, '庙前', 4, '140106', '140106003', 'm');
INSERT INTO `sys_data_region` VALUES (3124, '迎泽街道', 4, '140106', '140106004', 'y');
INSERT INTO `sys_data_region` VALUES (3125, '桥东', 4, '140106', '140106005', 'q');
INSERT INTO `sys_data_region` VALUES (3126, '老军营', 4, '140106', '140106006', 'l');
INSERT INTO `sys_data_region` VALUES (3127, '郝庄', 4, '140106', '140106100', 'h');
INSERT INTO `sys_data_region` VALUES (3128, '杏花岭', 3, '1401', '140107', 'x');
INSERT INTO `sys_data_region` VALUES (3129, '巨轮', 4, '140107', '140107001', 'j');
INSERT INTO `sys_data_region` VALUES (3130, '三桥', 4, '140107', '140107002', 's');
INSERT INTO `sys_data_region` VALUES (3131, '鼓楼', 4, '140107', '140107003', 'g');
INSERT INTO `sys_data_region` VALUES (3132, '杏花岭街道', 4, '140107', '140107004', 'x');
INSERT INTO `sys_data_region` VALUES (3133, '坝陵桥', 4, '140107', '140107005', 'b');
INSERT INTO `sys_data_region` VALUES (3134, '大东关', 4, '140107', '140107006', 'd');
INSERT INTO `sys_data_region` VALUES (3135, '职工新街', 4, '140107', '140107007', 'z');
INSERT INTO `sys_data_region` VALUES (3136, '敦化坊', 4, '140107', '140107008', 'd');
INSERT INTO `sys_data_region` VALUES (3137, '涧河', 4, '140107', '140107009', 'j');
INSERT INTO `sys_data_region` VALUES (3138, '杨家峪', 4, '140107', '140107010', 'y');
INSERT INTO `sys_data_region` VALUES (3139, '中涧河', 4, '140107', '140107100', 'z');
INSERT INTO `sys_data_region` VALUES (3140, '尖草坪', 3, '1401', '140108', 'j');
INSERT INTO `sys_data_region` VALUES (3141, '尖草坪街道', 4, '140108', '140108001', 'j');
INSERT INTO `sys_data_region` VALUES (3142, '光社', 4, '140108', '140108002', 'g');
INSERT INTO `sys_data_region` VALUES (3143, '上兰', 4, '140108', '140108003', 's');
INSERT INTO `sys_data_region` VALUES (3144, '南寨', 4, '140108', '140108004', 'n');
INSERT INTO `sys_data_region` VALUES (3145, '迎新', 4, '140108', '140108005', 'y');
INSERT INTO `sys_data_region` VALUES (3146, '古城', 4, '140108', '140108006', 'g');
INSERT INTO `sys_data_region` VALUES (3147, '汇丰', 4, '140108', '140108007', 'h');
INSERT INTO `sys_data_region` VALUES (3148, '柴村', 4, '140108', '140108008', 'c');
INSERT INTO `sys_data_region` VALUES (3149, '新城', 4, '140108', '140108009', 'x');
INSERT INTO `sys_data_region` VALUES (3150, '向阳', 4, '140108', '140108100', 'x');
INSERT INTO `sys_data_region` VALUES (3151, '阳曲', 4, '140108', '140108101', 'y');
INSERT INTO `sys_data_region` VALUES (3152, '柏板', 4, '140108', '140108201', 'b');
INSERT INTO `sys_data_region` VALUES (3153, '西墕', 4, '140108', '140108202', 'x');
INSERT INTO `sys_data_region` VALUES (3154, '万柏林', 3, '1401', '140109', 'w');
INSERT INTO `sys_data_region` VALUES (3155, '千峰', 4, '140109', '140109001', 'q');
INSERT INTO `sys_data_region` VALUES (3156, '下元', 4, '140109', '140109002', 'x');
INSERT INTO `sys_data_region` VALUES (3157, '和平', 4, '140109', '140109003', 'h');
INSERT INTO `sys_data_region` VALUES (3158, '兴华', 4, '140109', '140109004', 'x');
INSERT INTO `sys_data_region` VALUES (3159, '万柏林街道', 4, '140109', '140109005', 'w');
INSERT INTO `sys_data_region` VALUES (3160, '杜儿坪', 4, '140109', '140109006', 'd');
INSERT INTO `sys_data_region` VALUES (3161, '白家庄', 4, '140109', '140109007', 'b');
INSERT INTO `sys_data_region` VALUES (3162, '南寒', 4, '140109', '140109008', 'n');
INSERT INTO `sys_data_region` VALUES (3163, '西铭', 4, '140109', '140109009', 'x');
INSERT INTO `sys_data_region` VALUES (3164, '小井峪', 4, '140109', '140109010', 'x');
INSERT INTO `sys_data_region` VALUES (3165, '东社', 4, '140109', '140109012', 'd');
INSERT INTO `sys_data_region` VALUES (3166, '长风西街', 4, '140109', '140109014', 'c');
INSERT INTO `sys_data_region` VALUES (3167, '神堂沟', 4, '140109', '140109015', 's');
INSERT INTO `sys_data_region` VALUES (3168, '王化', 4, '140109', '140109016', 'w');
INSERT INTO `sys_data_region` VALUES (3169, '晋源', 3, '1401', '140110', 'j');
INSERT INTO `sys_data_region` VALUES (3170, '义井', 4, '140110', '140110001', 'y');
INSERT INTO `sys_data_region` VALUES (3171, '罗城', 4, '140110', '140110002', 'l');
INSERT INTO `sys_data_region` VALUES (3172, '晋源街道', 4, '140110', '140110003', 'j');
INSERT INTO `sys_data_region` VALUES (3173, '金胜', 4, '140110', '140110100', 'j');
INSERT INTO `sys_data_region` VALUES (3174, '晋祠', 4, '140110', '140110101', 'j');
INSERT INTO `sys_data_region` VALUES (3175, '姚村', 4, '140110', '140110102', 'y');
INSERT INTO `sys_data_region` VALUES (3176, '清徐', 3, '1401', '140121', 'q');
INSERT INTO `sys_data_region` VALUES (3177, '清源', 4, '140121', '140121100', 'q');
INSERT INTO `sys_data_region` VALUES (3178, '徐沟', 4, '140121', '140121101', 'x');
INSERT INTO `sys_data_region` VALUES (3179, '东于', 4, '140121', '140121102', 'd');
INSERT INTO `sys_data_region` VALUES (3180, '孟封', 4, '140121', '140121103', 'm');
INSERT INTO `sys_data_region` VALUES (3181, '马峪', 4, '140121', '140121200', 'm');
INSERT INTO `sys_data_region` VALUES (3182, '柳杜', 4, '140121', '140121201', 'l');
INSERT INTO `sys_data_region` VALUES (3183, '西谷', 4, '140121', '140121202', 'x');
INSERT INTO `sys_data_region` VALUES (3184, '王答', 4, '140121', '140121203', 'w');
INSERT INTO `sys_data_region` VALUES (3185, '集义', 4, '140121', '140121204', 'j');
INSERT INTO `sys_data_region` VALUES (3186, '阳曲', 3, '1401', '140122', 'y');
INSERT INTO `sys_data_region` VALUES (3187, '黄寨', 4, '140122', '140122100', 'h');
INSERT INTO `sys_data_region` VALUES (3188, '大盂', 4, '140122', '140122101', 'd');
INSERT INTO `sys_data_region` VALUES (3189, '东黄水', 4, '140122', '140122102', 'd');
INSERT INTO `sys_data_region` VALUES (3190, '泥屯', 4, '140122', '140122103', 'n');
INSERT INTO `sys_data_region` VALUES (3191, '高村', 4, '140122', '140122200', 'g');
INSERT INTO `sys_data_region` VALUES (3192, '侯村', 4, '140122', '140122201', 'h');
INSERT INTO `sys_data_region` VALUES (3193, '凌井店', 4, '140122', '140122202', 'l');
INSERT INTO `sys_data_region` VALUES (3194, '西凌井', 4, '140122', '140122203', 'x');
INSERT INTO `sys_data_region` VALUES (3195, '杨兴', 4, '140122', '140122205', 'y');
INSERT INTO `sys_data_region` VALUES (3196, '娄烦', 3, '1401', '140123', 'l');
INSERT INTO `sys_data_region` VALUES (3197, '娄烦镇', 4, '140123', '140123100', 'l');
INSERT INTO `sys_data_region` VALUES (3198, '静游', 4, '140123', '140123101', 'j');
INSERT INTO `sys_data_region` VALUES (3199, '杜交曲', 4, '140123', '140123102', 'd');
INSERT INTO `sys_data_region` VALUES (3200, '马家庄', 4, '140123', '140123201', 'm');
INSERT INTO `sys_data_region` VALUES (3201, '盖家庄', 4, '140123', '140123202', 'g');
INSERT INTO `sys_data_region` VALUES (3202, '米峪镇', 4, '140123', '140123203', 'm');
INSERT INTO `sys_data_region` VALUES (3203, '天池店', 4, '140123', '140123204', 't');
INSERT INTO `sys_data_region` VALUES (3204, '古交', 3, '1401', '140181', 'g');
INSERT INTO `sys_data_region` VALUES (3205, '东曲', 4, '140181', '140181001', 'd');
INSERT INTO `sys_data_region` VALUES (3206, '西曲', 4, '140181', '140181002', 'x');
INSERT INTO `sys_data_region` VALUES (3207, '桃园', 4, '140181', '140181003', 't');
INSERT INTO `sys_data_region` VALUES (3208, '屯兰', 4, '140181', '140181004', 't');
INSERT INTO `sys_data_region` VALUES (3209, '河口', 4, '140181', '140181100', 'h');
INSERT INTO `sys_data_region` VALUES (3210, '镇城底', 4, '140181', '140181101', 'z');
INSERT INTO `sys_data_region` VALUES (3211, '马兰', 4, '140181', '140181102', 'm');
INSERT INTO `sys_data_region` VALUES (3212, '嘉乐泉', 4, '140181', '140181201', 'j');
INSERT INTO `sys_data_region` VALUES (3213, '梭峪', 4, '140181', '140181202', 's');
INSERT INTO `sys_data_region` VALUES (3214, '岔口', 4, '140181', '140181203', 'c');
INSERT INTO `sys_data_region` VALUES (3215, '常安', 4, '140181', '140181204', 'c');
INSERT INTO `sys_data_region` VALUES (3216, '原相', 4, '140181', '140181205', 'y');
INSERT INTO `sys_data_region` VALUES (3217, '邢家社', 4, '140181', '140181206', 'x');
INSERT INTO `sys_data_region` VALUES (3218, '大同', 2, '14', '1402', 'd');
INSERT INTO `sys_data_region` VALUES (3219, '新荣', 3, '1402', '140212', 'x');
INSERT INTO `sys_data_region` VALUES (3220, '新荣镇', 4, '140212', '140212100', 'x');
INSERT INTO `sys_data_region` VALUES (3221, '古店', 4, '140212', '140212101', 'g');
INSERT INTO `sys_data_region` VALUES (3222, '花园屯', 4, '140212', '140212102', 'h');
INSERT INTO `sys_data_region` VALUES (3223, '破鲁堡', 4, '140212', '140212200', 'p');
INSERT INTO `sys_data_region` VALUES (3224, '郭家窑', 4, '140212', '140212202', 'g');
INSERT INTO `sys_data_region` VALUES (3225, '西村', 4, '140212', '140212206', 'x');
INSERT INTO `sys_data_region` VALUES (3226, '堡子湾', 4, '140212', '140212209', 'b');
INSERT INTO `sys_data_region` VALUES (3227, '平城', 3, '1402', '140213', 'p');
INSERT INTO `sys_data_region` VALUES (3228, '水泊寺', 4, '140213', '140213013', 's');
INSERT INTO `sys_data_region` VALUES (3229, '新旺', 4, '140213', '140213201', 'x');
INSERT INTO `sys_data_region` VALUES (3230, '马军营', 4, '140213', '140213205', 'm');
INSERT INTO `sys_data_region` VALUES (3231, '云冈', 3, '1402', '140214', 'y');
INSERT INTO `sys_data_region` VALUES (3232, '高山', 4, '140214', '140214101', 'g');
INSERT INTO `sys_data_region` VALUES (3233, '云冈镇', 4, '140214', '140214102', 'y');
INSERT INTO `sys_data_region` VALUES (3234, '口泉', 4, '140214', '140214200', 'k');
INSERT INTO `sys_data_region` VALUES (3235, '西韩岭', 4, '140214', '140214206', 'x');
INSERT INTO `sys_data_region` VALUES (3236, '平旺', 4, '140214', '140214207', 'p');
INSERT INTO `sys_data_region` VALUES (3237, '鸦儿崖', 4, '140214', '140214210', 'y');
INSERT INTO `sys_data_region` VALUES (3238, '云州', 3, '1402', '140215', 'y');
INSERT INTO `sys_data_region` VALUES (3239, '西坪', 4, '140215', '140215100', 'x');
INSERT INTO `sys_data_region` VALUES (3240, '倍加造', 4, '140215', '140215101', 'b');
INSERT INTO `sys_data_region` VALUES (3241, '周士庄', 4, '140215', '140215102', 'z');
INSERT INTO `sys_data_region` VALUES (3242, '吉家庄', 4, '140215', '140215201', 'j');
INSERT INTO `sys_data_region` VALUES (3243, '峰峪', 4, '140215', '140215202', 'f');
INSERT INTO `sys_data_region` VALUES (3244, '杜庄', 4, '140215', '140215204', 'd');
INSERT INTO `sys_data_region` VALUES (3245, '党留庄', 4, '140215', '140215205', 'd');
INSERT INTO `sys_data_region` VALUES (3246, '聚乐', 4, '140215', '140215209', 'j');
INSERT INTO `sys_data_region` VALUES (3247, '许堡', 4, '140215', '140215211', 'x');
INSERT INTO `sys_data_region` VALUES (3248, '阳高', 3, '1402', '140221', 'y');
INSERT INTO `sys_data_region` VALUES (3249, '龙泉', 4, '140221', '140221100', 'l');
INSERT INTO `sys_data_region` VALUES (3250, '罗文皂', 4, '140221', '140221101', 'l');
INSERT INTO `sys_data_region` VALUES (3251, '大白登', 4, '140221', '140221102', 'd');
INSERT INTO `sys_data_region` VALUES (3252, '王官屯', 4, '140221', '140221103', 'w');
INSERT INTO `sys_data_region` VALUES (3253, '古城', 4, '140221', '140221104', 'g');
INSERT INTO `sys_data_region` VALUES (3254, '东小村', 4, '140221', '140221105', 'd');
INSERT INTO `sys_data_region` VALUES (3255, '友宰', 4, '140221', '140221106', 'y');
INSERT INTO `sys_data_region` VALUES (3256, '长城', 4, '140221', '140221201', 'c');
INSERT INTO `sys_data_region` VALUES (3257, '狮子屯', 4, '140221', '140221204', 's');
INSERT INTO `sys_data_region` VALUES (3258, '下深井', 4, '140221', '140221209', 'x');
INSERT INTO `sys_data_region` VALUES (3259, '鳌石', 4, '140221', '140221212', 'a');
INSERT INTO `sys_data_region` VALUES (3260, '天镇', 3, '1402', '140222', 't');
INSERT INTO `sys_data_region` VALUES (3261, '玉泉', 4, '140222', '140222100', 'y');
INSERT INTO `sys_data_region` VALUES (3262, '谷前堡', 4, '140222', '140222101', 'g');
INSERT INTO `sys_data_region` VALUES (3263, '米薪关', 4, '140222', '140222102', 'm');
INSERT INTO `sys_data_region` VALUES (3264, '逯家湾', 4, '140222', '140222103', 'l');
INSERT INTO `sys_data_region` VALUES (3265, '新平堡', 4, '140222', '140222104', 'x');
INSERT INTO `sys_data_region` VALUES (3266, '三十里铺', 4, '140222', '140222200', 's');
INSERT INTO `sys_data_region` VALUES (3267, '贾家屯', 4, '140222', '140222204', 'j');
INSERT INTO `sys_data_region` VALUES (3268, '赵家沟', 4, '140222', '140222206', 'z');
INSERT INTO `sys_data_region` VALUES (3269, '南高崖', 4, '140222', '140222208', 'n');
INSERT INTO `sys_data_region` VALUES (3270, '张西河', 4, '140222', '140222209', 'z');
INSERT INTO `sys_data_region` VALUES (3271, '马家皂', 4, '140222', '140222210', 'm');
INSERT INTO `sys_data_region` VALUES (3272, '广灵', 3, '1402', '140223', 'g');
INSERT INTO `sys_data_region` VALUES (3273, '壶泉', 4, '140223', '140223100', 'h');
INSERT INTO `sys_data_region` VALUES (3274, '南村', 4, '140223', '140223101', 'n');
INSERT INTO `sys_data_region` VALUES (3275, '梁庄', 4, '140223', '140223102', 'l');
INSERT INTO `sys_data_region` VALUES (3276, '加斗', 4, '140223', '140223103', 'j');
INSERT INTO `sys_data_region` VALUES (3277, '作疃', 4, '140223', '140223104', 'z');
INSERT INTO `sys_data_region` VALUES (3278, '一斗泉', 4, '140223', '140223200', 'y');
INSERT INTO `sys_data_region` VALUES (3279, '蕉山', 4, '140223', '140223202', 'j');
INSERT INTO `sys_data_region` VALUES (3280, '宜兴', 4, '140223', '140223206', 'y');
INSERT INTO `sys_data_region` VALUES (3281, '灵丘', 3, '1402', '140224', 'l');
INSERT INTO `sys_data_region` VALUES (3282, '武灵', 4, '140224', '140224100', 'w');
INSERT INTO `sys_data_region` VALUES (3283, '东河南', 4, '140224', '140224101', 'd');
INSERT INTO `sys_data_region` VALUES (3284, '上寨', 4, '140224', '140224102', 's');
INSERT INTO `sys_data_region` VALUES (3285, '落水河', 4, '140224', '140224200', 'l');
INSERT INTO `sys_data_region` VALUES (3286, '赵北', 4, '140224', '140224205', 'z');
INSERT INTO `sys_data_region` VALUES (3287, '石家田', 4, '140224', '140224206', 's');
INSERT INTO `sys_data_region` VALUES (3288, '柳科', 4, '140224', '140224207', 'l');
INSERT INTO `sys_data_region` VALUES (3289, '白崖台', 4, '140224', '140224208', 'b');
INSERT INTO `sys_data_region` VALUES (3290, '红石塄', 4, '140224', '140224210', 'h');
INSERT INTO `sys_data_region` VALUES (3291, '下关', 4, '140224', '140224212', 'x');
INSERT INTO `sys_data_region` VALUES (3292, '独峪', 4, '140224', '140224213', 'd');
INSERT INTO `sys_data_region` VALUES (3293, '浑源', 3, '1402', '140225', 'h');
INSERT INTO `sys_data_region` VALUES (3294, '永安', 4, '140225', '140225100', 'y');
INSERT INTO `sys_data_region` VALUES (3295, '西坊城', 4, '140225', '140225101', 'x');
INSERT INTO `sys_data_region` VALUES (3296, '蔡村', 4, '140225', '140225102', 'c');
INSERT INTO `sys_data_region` VALUES (3297, '沙圪坨', 4, '140225', '140225103', 's');
INSERT INTO `sys_data_region` VALUES (3298, '王庄堡', 4, '140225', '140225104', 'w');
INSERT INTO `sys_data_region` VALUES (3299, '青磁窑', 4, '140225', '140225106', 'q');
INSERT INTO `sys_data_region` VALUES (3300, '东坊城', 4, '140225', '140225201', 'd');
INSERT INTO `sys_data_region` VALUES (3301, '裴村', 4, '140225', '140225203', 'p');
INSERT INTO `sys_data_region` VALUES (3302, '驼峰', 4, '140225', '140225204', 't');
INSERT INTO `sys_data_region` VALUES (3303, '西留村', 4, '140225', '140225205', 'x');
INSERT INTO `sys_data_region` VALUES (3304, '下韩村', 4, '140225', '140225206', 'x');
INSERT INTO `sys_data_region` VALUES (3305, '南榆林', 4, '140225', '140225208', 'n');
INSERT INTO `sys_data_region` VALUES (3306, '吴城', 4, '140225', '140225210', 'w');
INSERT INTO `sys_data_region` VALUES (3307, '大仁庄', 4, '140225', '140225213', 'd');
INSERT INTO `sys_data_region` VALUES (3308, '千佛岭', 4, '140225', '140225215', 'q');
INSERT INTO `sys_data_region` VALUES (3309, '官儿', 4, '140225', '140225218', 'g');
INSERT INTO `sys_data_region` VALUES (3310, '左云', 3, '1402', '140226', 'z');
INSERT INTO `sys_data_region` VALUES (3311, '云兴', 4, '140226', '140226100', 'y');
INSERT INTO `sys_data_region` VALUES (3312, '鹊儿山', 4, '140226', '140226101', 'q');
INSERT INTO `sys_data_region` VALUES (3313, '店湾', 4, '140226', '140226102', 'd');
INSERT INTO `sys_data_region` VALUES (3314, '管家堡', 4, '140226', '140226200', 'g');
INSERT INTO `sys_data_region` VALUES (3315, '张家场', 4, '140226', '140226201', 'z');
INSERT INTO `sys_data_region` VALUES (3316, '三屯', 4, '140226', '140226205', 's');
INSERT INTO `sys_data_region` VALUES (3317, '马道头', 4, '140226', '140226206', 'm');
INSERT INTO `sys_data_region` VALUES (3318, '小京庄', 4, '140226', '140226207', 'x');
INSERT INTO `sys_data_region` VALUES (3319, '阳泉', 2, '14', '1403', 'y');
INSERT INTO `sys_data_region` VALUES (3320, '城区', 3, '1403', '140302', 'c');
INSERT INTO `sys_data_region` VALUES (3321, '上站', 4, '140302', '140302001', 's');
INSERT INTO `sys_data_region` VALUES (3322, '下站', 4, '140302', '140302002', 'x');
INSERT INTO `sys_data_region` VALUES (3323, '北大街', 4, '140302', '140302003', 'b');
INSERT INTO `sys_data_region` VALUES (3324, '南山路', 4, '140302', '140302004', 'n');
INSERT INTO `sys_data_region` VALUES (3325, '义井', 4, '140302', '140302005', 'y');
INSERT INTO `sys_data_region` VALUES (3326, '矿区', 3, '1403', '140303', 'k');
INSERT INTO `sys_data_region` VALUES (3327, '平潭街', 4, '140303', '140303001', 'p');
INSERT INTO `sys_data_region` VALUES (3328, '桥头', 4, '140303', '140303002', 'q');
INSERT INTO `sys_data_region` VALUES (3329, '蔡洼', 4, '140303', '140303003', 'c');
INSERT INTO `sys_data_region` VALUES (3330, '赛鱼', 4, '140303', '140303004', 's');
INSERT INTO `sys_data_region` VALUES (3331, '沙坪', 4, '140303', '140303005', 's');
INSERT INTO `sys_data_region` VALUES (3332, '贵石沟', 4, '140303', '140303006', 'g');
INSERT INTO `sys_data_region` VALUES (3333, '郊区', 3, '1403', '140311', 'j');
INSERT INTO `sys_data_region` VALUES (3334, '荫营', 4, '140311', '140311100', 'y');
INSERT INTO `sys_data_region` VALUES (3335, '河底', 4, '140311', '140311101', 'h');
INSERT INTO `sys_data_region` VALUES (3336, '义井', 4, '140311', '140311102', 'y');
INSERT INTO `sys_data_region` VALUES (3337, '平坦', 4, '140311', '140311103', 'p');
INSERT INTO `sys_data_region` VALUES (3338, '西南舁', 4, '140311', '140311200', 'x');
INSERT INTO `sys_data_region` VALUES (3339, '杨家庄', 4, '140311', '140311201', 'y');
INSERT INTO `sys_data_region` VALUES (3340, '李家庄', 4, '140311', '140311202', 'l');
INSERT INTO `sys_data_region` VALUES (3341, '旧街', 4, '140311', '140311203', 'j');
INSERT INTO `sys_data_region` VALUES (3342, '开发区', 4, '140311', '140311400', 'k');
INSERT INTO `sys_data_region` VALUES (3343, '平定', 3, '1403', '140321', 'p');
INSERT INTO `sys_data_region` VALUES (3344, '冠山', 4, '140321', '140321100', 'g');
INSERT INTO `sys_data_region` VALUES (3345, '冶西', 4, '140321', '140321101', 'y');
INSERT INTO `sys_data_region` VALUES (3346, '锁簧', 4, '140321', '140321102', 's');
INSERT INTO `sys_data_region` VALUES (3347, '张庄', 4, '140321', '140321103', 'z');
INSERT INTO `sys_data_region` VALUES (3348, '东回', 4, '140321', '140321104', 'd');
INSERT INTO `sys_data_region` VALUES (3349, '柏井', 4, '140321', '140321105', 'b');
INSERT INTO `sys_data_region` VALUES (3350, '娘子关', 4, '140321', '140321106', 'n');
INSERT INTO `sys_data_region` VALUES (3351, '巨城', 4, '140321', '140321107', 'j');
INSERT INTO `sys_data_region` VALUES (3352, '石门口', 4, '140321', '140321200', 's');
INSERT INTO `sys_data_region` VALUES (3353, '岔口', 4, '140321', '140321201', 'c');
INSERT INTO `sys_data_region` VALUES (3354, '盂县', 3, '1403', '140322', 'y');
INSERT INTO `sys_data_region` VALUES (3355, '秀水', 4, '140322', '140322100', 'x');
INSERT INTO `sys_data_region` VALUES (3356, '孙家庄', 4, '140322', '140322101', 's');
INSERT INTO `sys_data_region` VALUES (3357, '路家村', 4, '140322', '140322102', 'l');
INSERT INTO `sys_data_region` VALUES (3358, '南娄', 4, '140322', '140322103', 'n');
INSERT INTO `sys_data_region` VALUES (3359, '牛村', 4, '140322', '140322104', 'n');
INSERT INTO `sys_data_region` VALUES (3360, '苌池', 4, '140322', '140322105', 'c');
INSERT INTO `sys_data_region` VALUES (3361, '上社', 4, '140322', '140322106', 's');
INSERT INTO `sys_data_region` VALUES (3362, '西烟', 4, '140322', '140322107', 'x');
INSERT INTO `sys_data_region` VALUES (3363, '仙人', 4, '140322', '140322200', 'x');
INSERT INTO `sys_data_region` VALUES (3364, '北下庄', 4, '140322', '140322201', 'b');
INSERT INTO `sys_data_region` VALUES (3365, '梁家寨', 4, '140322', '140322203', 'l');
INSERT INTO `sys_data_region` VALUES (3366, '西潘', 4, '140322', '140322204', 'x');
INSERT INTO `sys_data_region` VALUES (3367, '东梁', 4, '140322', '140322205', 'd');
INSERT INTO `sys_data_region` VALUES (3368, '长治', 2, '14', '1404', 'c');
INSERT INTO `sys_data_region` VALUES (3369, '潞州', 3, '1404', '140403', 'l');
INSERT INTO `sys_data_region` VALUES (3370, '东街', 4, '140403', '140403001', 'd');
INSERT INTO `sys_data_region` VALUES (3371, '西街', 4, '140403', '140403002', 'x');
INSERT INTO `sys_data_region` VALUES (3372, '英雄南路', 4, '140403', '140403003', 'y');
INSERT INTO `sys_data_region` VALUES (3373, '英雄中路', 4, '140403', '140403004', 'y');
INSERT INTO `sys_data_region` VALUES (3374, '紫金街', 4, '140403', '140403005', 'z');
INSERT INTO `sys_data_region` VALUES (3375, '太行东街', 4, '140403', '140403006', 't');
INSERT INTO `sys_data_region` VALUES (3376, '太行西街', 4, '140403', '140403007', 't');
INSERT INTO `sys_data_region` VALUES (3377, '延安南路', 4, '140403', '140403008', 'y');
INSERT INTO `sys_data_region` VALUES (3378, '常青', 4, '140403', '140403009', 'c');
INSERT INTO `sys_data_region` VALUES (3379, '五马', 4, '140403', '140403010', 'w');
INSERT INTO `sys_data_region` VALUES (3380, '堠北庄', 4, '140403', '140403013', 'h');
INSERT INTO `sys_data_region` VALUES (3381, '老顶山', 4, '140403', '140403014', 'l');
INSERT INTO `sys_data_region` VALUES (3382, '大辛庄', 4, '140403', '140403015', 'd');
INSERT INTO `sys_data_region` VALUES (3383, '马厂', 4, '140403', '140403103', 'm');
INSERT INTO `sys_data_region` VALUES (3384, '黄碾', 4, '140403', '140403104', 'h');
INSERT INTO `sys_data_region` VALUES (3385, '西白兔', 4, '140403', '140403105', 'x');
INSERT INTO `sys_data_region` VALUES (3386, '上党', 3, '1404', '140404', 's');
INSERT INTO `sys_data_region` VALUES (3387, '韩店', 4, '140404', '140404001', 'h');
INSERT INTO `sys_data_region` VALUES (3388, '苏店', 4, '140404', '140404101', 's');
INSERT INTO `sys_data_region` VALUES (3389, '荫城', 4, '140404', '140404102', 'y');
INSERT INTO `sys_data_region` VALUES (3390, '西火', 4, '140404', '140404103', 'x');
INSERT INTO `sys_data_region` VALUES (3391, '八义', 4, '140404', '140404104', 'b');
INSERT INTO `sys_data_region` VALUES (3392, '郝家庄', 4, '140404', '140404106', 'h');
INSERT INTO `sys_data_region` VALUES (3393, '西池', 4, '140404', '140404201', 'x');
INSERT INTO `sys_data_region` VALUES (3394, '北呈', 4, '140404', '140404202', 'b');
INSERT INTO `sys_data_region` VALUES (3395, '东和', 4, '140404', '140404203', 'd');
INSERT INTO `sys_data_region` VALUES (3396, '南宋', 4, '140404', '140404205', 'n');
INSERT INTO `sys_data_region` VALUES (3397, '屯留', 3, '1404', '140405', 't');
INSERT INTO `sys_data_region` VALUES (3398, '麟绛', 4, '140405', '140405001', 'l');
INSERT INTO `sys_data_region` VALUES (3399, '上村', 4, '140405', '140405101', 's');
INSERT INTO `sys_data_region` VALUES (3400, '渔泽', 4, '140405', '140405102', 'y');
INSERT INTO `sys_data_region` VALUES (3401, '余吾', 4, '140405', '140405103', 'y');
INSERT INTO `sys_data_region` VALUES (3402, '吾元', 4, '140405', '140405104', 'w');
INSERT INTO `sys_data_region` VALUES (3403, '张店', 4, '140405', '140405105', 'z');
INSERT INTO `sys_data_region` VALUES (3404, '丰宜', 4, '140405', '140405106', 'f');
INSERT INTO `sys_data_region` VALUES (3405, '李高', 4, '140405', '140405200', 'l');
INSERT INTO `sys_data_region` VALUES (3406, '路村', 4, '140405', '140405201', 'l');
INSERT INTO `sys_data_region` VALUES (3407, '河神庙', 4, '140405', '140405202', 'h');
INSERT INTO `sys_data_region` VALUES (3408, '潞城', 3, '1404', '140406', 'l');
INSERT INTO `sys_data_region` VALUES (3409, '潞华', 4, '140406', '140406001', 'l');
INSERT INTO `sys_data_region` VALUES (3410, '成家川', 4, '140406', '140406002', 'c');
INSERT INTO `sys_data_region` VALUES (3411, '翟店', 4, '140406', '140406004', 'd');
INSERT INTO `sys_data_region` VALUES (3412, '店上', 4, '140406', '140406100', 'd');
INSERT INTO `sys_data_region` VALUES (3413, '微子', 4, '140406', '140406101', 'w');
INSERT INTO `sys_data_region` VALUES (3414, '辛安泉', 4, '140406', '140406102', 'x');
INSERT INTO `sys_data_region` VALUES (3415, '史回', 4, '140406', '140406104', 's');
INSERT INTO `sys_data_region` VALUES (3416, '黄牛蹄', 4, '140406', '140406201', 'h');
INSERT INTO `sys_data_region` VALUES (3417, '襄垣', 3, '1404', '140423', 'x');
INSERT INTO `sys_data_region` VALUES (3418, '古韩', 4, '140423', '140423100', 'g');
INSERT INTO `sys_data_region` VALUES (3419, '王桥', 4, '140423', '140423101', 'w');
INSERT INTO `sys_data_region` VALUES (3420, '侯堡', 4, '140423', '140423102', 'h');
INSERT INTO `sys_data_region` VALUES (3421, '夏店', 4, '140423', '140423103', 'x');
INSERT INTO `sys_data_region` VALUES (3422, '虒亭', 4, '140423', '140423104', 's');
INSERT INTO `sys_data_region` VALUES (3423, '西营', 4, '140423', '140423105', 'x');
INSERT INTO `sys_data_region` VALUES (3424, '王村', 4, '140423', '140423106', 'w');
INSERT INTO `sys_data_region` VALUES (3425, '下良', 4, '140423', '140423107', 'x');
INSERT INTO `sys_data_region` VALUES (3426, '善福', 4, '140423', '140423109', 's');
INSERT INTO `sys_data_region` VALUES (3427, '平顺', 3, '1404', '140425', 'p');
INSERT INTO `sys_data_region` VALUES (3428, '青羊', 4, '140425', '140425100', 'q');
INSERT INTO `sys_data_region` VALUES (3429, '龙溪', 4, '140425', '140425101', 'l');
INSERT INTO `sys_data_region` VALUES (3430, '石城', 4, '140425', '140425102', 's');
INSERT INTO `sys_data_region` VALUES (3431, '苗庄', 4, '140425', '140425103', 'm');
INSERT INTO `sys_data_region` VALUES (3432, '玉峡关', 4, '140425', '140425106', 'y');
INSERT INTO `sys_data_region` VALUES (3433, '西沟', 4, '140425', '140425200', 'x');
INSERT INTO `sys_data_region` VALUES (3434, '东寺头', 4, '140425', '140425201', 'd');
INSERT INTO `sys_data_region` VALUES (3435, '虹梯关', 4, '140425', '140425202', 'h');
INSERT INTO `sys_data_region` VALUES (3436, '阳高', 4, '140425', '140425203', 'y');
INSERT INTO `sys_data_region` VALUES (3437, '北耽车', 4, '140425', '140425204', 'b');
INSERT INTO `sys_data_region` VALUES (3438, '北社', 4, '140425', '140425206', 'b');
INSERT INTO `sys_data_region` VALUES (3439, '黎城', 3, '1404', '140426', 'l');
INSERT INTO `sys_data_region` VALUES (3440, '东阳关', 4, '140426', '140426101', 'd');
INSERT INTO `sys_data_region` VALUES (3441, '上遥', 4, '140426', '140426102', 's');
INSERT INTO `sys_data_region` VALUES (3442, '西井', 4, '140426', '140426103', 'x');
INSERT INTO `sys_data_region` VALUES (3443, '黄崖洞', 4, '140426', '140426104', 'h');
INSERT INTO `sys_data_region` VALUES (3444, '黎侯', 4, '140426', '140426105', 'l');
INSERT INTO `sys_data_region` VALUES (3445, '洪井', 4, '140426', '140426106', 'h');
INSERT INTO `sys_data_region` VALUES (3446, '西仵', 4, '140426', '140426107', 'x');
INSERT INTO `sys_data_region` VALUES (3447, '程家山', 4, '140426', '140426108', 'c');
INSERT INTO `sys_data_region` VALUES (3448, '壶关', 3, '1404', '140427', 'h');
INSERT INTO `sys_data_region` VALUES (3449, '龙泉', 4, '140427', '140427100', 'l');
INSERT INTO `sys_data_region` VALUES (3450, '百尺', 4, '140427', '140427101', 'b');
INSERT INTO `sys_data_region` VALUES (3451, '店上', 4, '140427', '140427102', 'd');
INSERT INTO `sys_data_region` VALUES (3452, '晋庄', 4, '140427', '140427103', 'j');
INSERT INTO `sys_data_region` VALUES (3453, '树掌', 4, '140427', '140427104', 's');
INSERT INTO `sys_data_region` VALUES (3454, '大峡谷', 4, '140427', '140427105', 'd');
INSERT INTO `sys_data_region` VALUES (3455, '集店', 4, '140427', '140427108', 'j');
INSERT INTO `sys_data_region` VALUES (3456, '黄山', 4, '140427', '140427201', 'h');
INSERT INTO `sys_data_region` VALUES (3457, '东井岭', 4, '140427', '140427202', 'd');
INSERT INTO `sys_data_region` VALUES (3458, '石坡', 4, '140427', '140427203', 's');
INSERT INTO `sys_data_region` VALUES (3459, '长子', 3, '1404', '140428', 'z');
INSERT INTO `sys_data_region` VALUES (3460, '丹朱', 4, '140428', '140428100', 'd');
INSERT INTO `sys_data_region` VALUES (3461, '鲍店', 4, '140428', '140428101', 'b');
INSERT INTO `sys_data_region` VALUES (3462, '石哲', 4, '140428', '140428102', 's');
INSERT INTO `sys_data_region` VALUES (3463, '大堡头', 4, '140428', '140428103', 'd');
INSERT INTO `sys_data_region` VALUES (3464, '慈林', 4, '140428', '140428104', 'c');
INSERT INTO `sys_data_region` VALUES (3465, '色头', 4, '140428', '140428105', 's');
INSERT INTO `sys_data_region` VALUES (3466, '南漳', 4, '140428', '140428106', 'n');
INSERT INTO `sys_data_region` VALUES (3467, '宋村', 4, '140428', '140428108', 's');
INSERT INTO `sys_data_region` VALUES (3468, '南陈', 4, '140428', '140428109', 'n');
INSERT INTO `sys_data_region` VALUES (3469, '碾张', 4, '140428', '140428201', 'n');
INSERT INTO `sys_data_region` VALUES (3470, '常张', 4, '140428', '140428202', 'c');
INSERT INTO `sys_data_region` VALUES (3471, '武乡', 3, '1404', '140429', 'w');
INSERT INTO `sys_data_region` VALUES (3472, '丰州', 4, '140429', '140429100', 'f');
INSERT INTO `sys_data_region` VALUES (3473, '洪水', 4, '140429', '140429101', 'h');
INSERT INTO `sys_data_region` VALUES (3474, '蟠龙', 4, '140429', '140429102', 'p');
INSERT INTO `sys_data_region` VALUES (3475, '监漳', 4, '140429', '140429103', 'j');
INSERT INTO `sys_data_region` VALUES (3476, '故城', 4, '140429', '140429104', 'g');
INSERT INTO `sys_data_region` VALUES (3477, '韩北', 4, '140429', '140429107', 'h');
INSERT INTO `sys_data_region` VALUES (3478, '大有', 4, '140429', '140429202', 'd');
INSERT INTO `sys_data_region` VALUES (3479, '贾豁', 4, '140429', '140429203', 'j');
INSERT INTO `sys_data_region` VALUES (3480, '上司', 4, '140429', '140429205', 's');
INSERT INTO `sys_data_region` VALUES (3481, '石北', 4, '140429', '140429206', 's');
INSERT INTO `sys_data_region` VALUES (3482, '涌泉', 4, '140429', '140429207', 'y');
INSERT INTO `sys_data_region` VALUES (3483, '分水岭', 4, '140429', '140429208', 'f');
INSERT INTO `sys_data_region` VALUES (3484, '沁县', 3, '1404', '140430', 'q');
INSERT INTO `sys_data_region` VALUES (3485, '定昌', 4, '140430', '140430100', 'd');
INSERT INTO `sys_data_region` VALUES (3486, '郭村', 4, '140430', '140430101', 'g');
INSERT INTO `sys_data_region` VALUES (3487, '故县', 4, '140430', '140430102', 'g');
INSERT INTO `sys_data_region` VALUES (3488, '新店', 4, '140430', '140430103', 'x');
INSERT INTO `sys_data_region` VALUES (3489, '漳源', 4, '140430', '140430104', 'z');
INSERT INTO `sys_data_region` VALUES (3490, '册村', 4, '140430', '140430105', 'c');
INSERT INTO `sys_data_region` VALUES (3491, '沁州黄', 4, '140430', '140430107', 'q');
INSERT INTO `sys_data_region` VALUES (3492, '南里', 4, '140430', '140430108', 'n');
INSERT INTO `sys_data_region` VALUES (3493, '松村', 4, '140430', '140430109', 's');
INSERT INTO `sys_data_region` VALUES (3494, '牛寺', 4, '140430', '140430203', 'n');
INSERT INTO `sys_data_region` VALUES (3495, '杨安', 4, '140430', '140430206', 'y');
INSERT INTO `sys_data_region` VALUES (3496, '沁源', 3, '1404', '140431', 'q');
INSERT INTO `sys_data_region` VALUES (3497, '沁河', 4, '140431', '140431100', 'q');
INSERT INTO `sys_data_region` VALUES (3498, '灵空山', 4, '140431', '140431102', 'l');
INSERT INTO `sys_data_region` VALUES (3499, '王和', 4, '140431', '140431103', 'w');
INSERT INTO `sys_data_region` VALUES (3500, '王陶', 4, '140431', '140431105', 'w');
INSERT INTO `sys_data_region` VALUES (3501, '景凤', 4, '140431', '140431107', 'j');
INSERT INTO `sys_data_region` VALUES (3502, '郭道', 4, '140431', '140431108', 'g');
INSERT INTO `sys_data_region` VALUES (3503, '中峪', 4, '140431', '140431200', 'z');
INSERT INTO `sys_data_region` VALUES (3504, '法中', 4, '140431', '140431201', 'f');
INSERT INTO `sys_data_region` VALUES (3505, '交口', 4, '140431', '140431202', 'j');
INSERT INTO `sys_data_region` VALUES (3506, '聪子峪', 4, '140431', '140431203', 'c');
INSERT INTO `sys_data_region` VALUES (3507, '韩洪', 4, '140431', '140431204', 'h');
INSERT INTO `sys_data_region` VALUES (3508, '赤石桥', 4, '140431', '140431207', 'c');
INSERT INTO `sys_data_region` VALUES (3509, '晋城', 2, '14', '1405', 'j');
INSERT INTO `sys_data_region` VALUES (3510, '城区', 3, '1405', '140502', 'c');
INSERT INTO `sys_data_region` VALUES (3511, '东街', 4, '140502', '140502001', 'd');
INSERT INTO `sys_data_region` VALUES (3512, '西街', 4, '140502', '140502002', 'x');
INSERT INTO `sys_data_region` VALUES (3513, '南街', 4, '140502', '140502003', 'n');
INSERT INTO `sys_data_region` VALUES (3514, '北街', 4, '140502', '140502004', 'b');
INSERT INTO `sys_data_region` VALUES (3515, '钟家庄', 4, '140502', '140502006', 'z');
INSERT INTO `sys_data_region` VALUES (3516, '西上庄', 4, '140502', '140502007', 'x');
INSERT INTO `sys_data_region` VALUES (3517, '开发区', 4, '140502', '140502009', 'k');
INSERT INTO `sys_data_region` VALUES (3518, '北石店', 4, '140502', '140502100', 'b');
INSERT INTO `sys_data_region` VALUES (3519, '沁水', 3, '1405', '140521', 'q');
INSERT INTO `sys_data_region` VALUES (3520, '龙港', 4, '140521', '140521100', 'l');
INSERT INTO `sys_data_region` VALUES (3521, '中村', 4, '140521', '140521101', 'z');
INSERT INTO `sys_data_region` VALUES (3522, '郑庄', 4, '140521', '140521102', 'z');
INSERT INTO `sys_data_region` VALUES (3523, '端氏', 4, '140521', '140521103', 'd');
INSERT INTO `sys_data_region` VALUES (3524, '嘉峰', 4, '140521', '140521104', 'j');
INSERT INTO `sys_data_region` VALUES (3525, '郑村', 4, '140521', '140521105', 'z');
INSERT INTO `sys_data_region` VALUES (3526, '柿庄', 4, '140521', '140521106', 's');
INSERT INTO `sys_data_region` VALUES (3527, '土沃', 4, '140521', '140521201', 't');
INSERT INTO `sys_data_region` VALUES (3528, '张村', 4, '140521', '140521202', 'z');
INSERT INTO `sys_data_region` VALUES (3529, '胡底', 4, '140521', '140521204', 'h');
INSERT INTO `sys_data_region` VALUES (3530, '固县', 4, '140521', '140521205', 'g');
INSERT INTO `sys_data_region` VALUES (3531, '十里', 4, '140521', '140521206', 's');
INSERT INTO `sys_data_region` VALUES (3532, '阳城', 3, '1405', '140522', 'y');
INSERT INTO `sys_data_region` VALUES (3533, '凤城', 4, '140522', '140522100', 'f');
INSERT INTO `sys_data_region` VALUES (3534, '北留', 4, '140522', '140522101', 'b');
INSERT INTO `sys_data_region` VALUES (3535, '润城', 4, '140522', '140522102', 'r');
INSERT INTO `sys_data_region` VALUES (3536, '町店', 4, '140522', '140522103', 't');
INSERT INTO `sys_data_region` VALUES (3537, '芹池', 4, '140522', '140522104', 'q');
INSERT INTO `sys_data_region` VALUES (3538, '次营', 4, '140522', '140522105', 'c');
INSERT INTO `sys_data_region` VALUES (3539, '横河', 4, '140522', '140522106', 'h');
INSERT INTO `sys_data_region` VALUES (3540, '河北', 4, '140522', '140522107', 'h');
INSERT INTO `sys_data_region` VALUES (3541, '蟒河', 4, '140522', '140522108', 'm');
INSERT INTO `sys_data_region` VALUES (3542, '东冶', 4, '140522', '140522109', 'd');
INSERT INTO `sys_data_region` VALUES (3543, '白桑', 4, '140522', '140522113', 'b');
INSERT INTO `sys_data_region` VALUES (3544, '演礼', 4, '140522', '140522114', 'y');
INSERT INTO `sys_data_region` VALUES (3545, '寺头', 4, '140522', '140522201', 's');
INSERT INTO `sys_data_region` VALUES (3546, '西河', 4, '140522', '140522202', 'x');
INSERT INTO `sys_data_region` VALUES (3547, '董封', 4, '140522', '140522205', 'd');
INSERT INTO `sys_data_region` VALUES (3548, '陵川', 3, '1405', '140524', 'l');
INSERT INTO `sys_data_region` VALUES (3549, '崇文', 4, '140524', '140524100', 'c');
INSERT INTO `sys_data_region` VALUES (3550, '礼义', 4, '140524', '140524101', 'l');
INSERT INTO `sys_data_region` VALUES (3551, '附城', 4, '140524', '140524102', 'f');
INSERT INTO `sys_data_region` VALUES (3552, '西河底', 4, '140524', '140524103', 'x');
INSERT INTO `sys_data_region` VALUES (3553, '平城', 4, '140524', '140524104', 'p');
INSERT INTO `sys_data_region` VALUES (3554, '杨村', 4, '140524', '140524105', 'y');
INSERT INTO `sys_data_region` VALUES (3555, '潞城', 4, '140524', '140524106', 'l');
INSERT INTO `sys_data_region` VALUES (3556, '夺火', 4, '140524', '140524204', 'd');
INSERT INTO `sys_data_region` VALUES (3557, '马圪当', 4, '140524', '140524206', 'm');
INSERT INTO `sys_data_region` VALUES (3558, '古郊', 4, '140524', '140524207', 'g');
INSERT INTO `sys_data_region` VALUES (3559, '六泉', 4, '140524', '140524209', 'l');
INSERT INTO `sys_data_region` VALUES (3560, '泽州', 3, '1405', '140525', 'z');
INSERT INTO `sys_data_region` VALUES (3561, '南村', 4, '140525', '140525100', 'n');
INSERT INTO `sys_data_region` VALUES (3562, '下村', 4, '140525', '140525101', 'x');
INSERT INTO `sys_data_region` VALUES (3563, '大东沟', 4, '140525', '140525102', 'd');
INSERT INTO `sys_data_region` VALUES (3564, '周村', 4, '140525', '140525103', 'z');
INSERT INTO `sys_data_region` VALUES (3565, '犁川', 4, '140525', '140525104', 'l');
INSERT INTO `sys_data_region` VALUES (3566, '晋庙铺', 4, '140525', '140525105', 'j');
INSERT INTO `sys_data_region` VALUES (3567, '金村', 4, '140525', '140525106', 'j');
INSERT INTO `sys_data_region` VALUES (3568, '高都', 4, '140525', '140525107', 'g');
INSERT INTO `sys_data_region` VALUES (3569, '巴公', 4, '140525', '140525108', 'b');
INSERT INTO `sys_data_region` VALUES (3570, '大阳', 4, '140525', '140525109', 'd');
INSERT INTO `sys_data_region` VALUES (3571, '山河', 4, '140525', '140525110', 's');
INSERT INTO `sys_data_region` VALUES (3572, '大箕', 4, '140525', '140525111', 'd');
INSERT INTO `sys_data_region` VALUES (3573, '柳树口', 4, '140525', '140525112', 'l');
INSERT INTO `sys_data_region` VALUES (3574, '北义城', 4, '140525', '140525113', 'b');
INSERT INTO `sys_data_region` VALUES (3575, '南岭', 4, '140525', '140525114', 'n');
INSERT INTO `sys_data_region` VALUES (3576, '川底', 4, '140525', '140525115', 'c');
INSERT INTO `sys_data_region` VALUES (3577, '高平', 3, '1405', '140581', 'g');
INSERT INTO `sys_data_region` VALUES (3578, '北城', 4, '140581', '140581001', 'b');
INSERT INTO `sys_data_region` VALUES (3579, '东城', 4, '140581', '140581002', 'd');
INSERT INTO `sys_data_region` VALUES (3580, '南城', 4, '140581', '140581003', 'n');
INSERT INTO `sys_data_region` VALUES (3581, '米山', 4, '140581', '140581100', 'm');
INSERT INTO `sys_data_region` VALUES (3582, '三甲', 4, '140581', '140581101', 's');
INSERT INTO `sys_data_region` VALUES (3583, '陈区', 4, '140581', '140581102', 'c');
INSERT INTO `sys_data_region` VALUES (3584, '北诗', 4, '140581', '140581103', 'b');
INSERT INTO `sys_data_region` VALUES (3585, '河西', 4, '140581', '140581104', 'h');
INSERT INTO `sys_data_region` VALUES (3586, '马村', 4, '140581', '140581105', 'm');
INSERT INTO `sys_data_region` VALUES (3587, '野川', 4, '140581', '140581106', 'y');
INSERT INTO `sys_data_region` VALUES (3588, '寺庄', 4, '140581', '140581107', 's');
INSERT INTO `sys_data_region` VALUES (3589, '神农', 4, '140581', '140581108', 's');
INSERT INTO `sys_data_region` VALUES (3590, '建宁', 4, '140581', '140581202', 'j');
INSERT INTO `sys_data_region` VALUES (3591, '石末', 4, '140581', '140581204', 's');
INSERT INTO `sys_data_region` VALUES (3592, '原村', 4, '140581', '140581207', 'y');
INSERT INTO `sys_data_region` VALUES (3593, '朔州', 2, '14', '1406', 's');
INSERT INTO `sys_data_region` VALUES (3594, '朔城', 3, '1406', '140602', 's');
INSERT INTO `sys_data_region` VALUES (3595, '北城', 4, '140602', '140602001', 'b');
INSERT INTO `sys_data_region` VALUES (3596, '南城', 4, '140602', '140602002', 'n');
INSERT INTO `sys_data_region` VALUES (3597, '神头街道', 4, '140602', '140602003', 's');
INSERT INTO `sys_data_region` VALUES (3598, '北旺庄', 4, '140602', '140602004', 'b');
INSERT INTO `sys_data_region` VALUES (3599, '神头镇', 4, '140602', '140602100', 's');
INSERT INTO `sys_data_region` VALUES (3600, '利民', 4, '140602', '140602101', 'l');
INSERT INTO `sys_data_region` VALUES (3601, '下团堡', 4, '140602', '140602200', 'x');
INSERT INTO `sys_data_region` VALUES (3602, '小平易', 4, '140602', '140602201', 'x');
INSERT INTO `sys_data_region` VALUES (3603, '滋润', 4, '140602', '140602202', 'z');
INSERT INTO `sys_data_region` VALUES (3604, '南榆林', 4, '140602', '140602204', 'n');
INSERT INTO `sys_data_region` VALUES (3605, '贾庄', 4, '140602', '140602205', 'j');
INSERT INTO `sys_data_region` VALUES (3606, '沙塄河', 4, '140602', '140602206', 's');
INSERT INTO `sys_data_region` VALUES (3607, '窑子头', 4, '140602', '140602207', 'y');
INSERT INTO `sys_data_region` VALUES (3608, '张蔡庄', 4, '140602', '140602208', 'z');
INSERT INTO `sys_data_region` VALUES (3609, '平鲁', 3, '1406', '140603', 'p');
INSERT INTO `sys_data_region` VALUES (3610, '井坪', 4, '140603', '140603100', 'j');
INSERT INTO `sys_data_region` VALUES (3611, '凤凰城', 4, '140603', '140603101', 'f');
INSERT INTO `sys_data_region` VALUES (3612, '白堂', 4, '140603', '140603200', 'b');
INSERT INTO `sys_data_region` VALUES (3613, '陶村', 4, '140603', '140603201', 't');
INSERT INTO `sys_data_region` VALUES (3614, '下水头', 4, '140603', '140603202', 'x');
INSERT INTO `sys_data_region` VALUES (3615, '双碾', 4, '140603', '140603203', 's');
INSERT INTO `sys_data_region` VALUES (3616, '阻虎', 4, '140603', '140603204', 'z');
INSERT INTO `sys_data_region` VALUES (3617, '高石庄', 4, '140603', '140603205', 'g');
INSERT INTO `sys_data_region` VALUES (3618, '西水界', 4, '140603', '140603206', 'x');
INSERT INTO `sys_data_region` VALUES (3619, '下面高', 4, '140603', '140603207', 'x');
INSERT INTO `sys_data_region` VALUES (3620, '向阳堡', 4, '140603', '140603209', 'x');
INSERT INTO `sys_data_region` VALUES (3621, '榆岭', 4, '140603', '140603210', 'y');
INSERT INTO `sys_data_region` VALUES (3622, '山阴', 3, '1406', '140621', 's');
INSERT INTO `sys_data_region` VALUES (3623, '玉井', 4, '140621', '140621100', 'y');
INSERT INTO `sys_data_region` VALUES (3624, '北周庄', 4, '140621', '140621101', 'b');
INSERT INTO `sys_data_region` VALUES (3625, '古城', 4, '140621', '140621102', 'g');
INSERT INTO `sys_data_region` VALUES (3626, '岱岳', 4, '140621', '140621103', 'd');
INSERT INTO `sys_data_region` VALUES (3627, '广武', 4, '140621', '140621104', 'g');
INSERT INTO `sys_data_region` VALUES (3628, '吴马营', 4, '140621', '140621200', 'w');
INSERT INTO `sys_data_region` VALUES (3629, '马营', 4, '140621', '140621201', 'm');
INSERT INTO `sys_data_region` VALUES (3630, '下喇叭', 4, '140621', '140621202', 'x');
INSERT INTO `sys_data_region` VALUES (3631, '合盛堡', 4, '140621', '140621203', 'h');
INSERT INTO `sys_data_region` VALUES (3632, '安荣', 4, '140621', '140621205', 'a');
INSERT INTO `sys_data_region` VALUES (3633, '薛圐圙', 4, '140621', '140621206', 'x');
INSERT INTO `sys_data_region` VALUES (3634, '马营庄', 4, '140621', '140621209', 'm');
INSERT INTO `sys_data_region` VALUES (3635, '应县', 3, '1406', '140622', 'y');
INSERT INTO `sys_data_region` VALUES (3636, '金城', 4, '140622', '140622100', 'j');
INSERT INTO `sys_data_region` VALUES (3637, '南河种', 4, '140622', '140622101', 'n');
INSERT INTO `sys_data_region` VALUES (3638, '下社', 4, '140622', '140622102', 'x');
INSERT INTO `sys_data_region` VALUES (3639, '镇子梁', 4, '140622', '140622200', 'z');
INSERT INTO `sys_data_region` VALUES (3640, '义井', 4, '140622', '140622201', 'y');
INSERT INTO `sys_data_region` VALUES (3641, '臧寨', 4, '140622', '140622202', 'z');
INSERT INTO `sys_data_region` VALUES (3642, '大黄巍', 4, '140622', '140622203', 'd');
INSERT INTO `sys_data_region` VALUES (3643, '杏寨', 4, '140622', '140622204', 'x');
INSERT INTO `sys_data_region` VALUES (3644, '下马峪', 4, '140622', '140622205', 'x');
INSERT INTO `sys_data_region` VALUES (3645, '南泉', 4, '140622', '140622206', 'n');
INSERT INTO `sys_data_region` VALUES (3646, '大临河', 4, '140622', '140622207', 'd');
INSERT INTO `sys_data_region` VALUES (3647, '白马石', 4, '140622', '140622208', 'b');
INSERT INTO `sys_data_region` VALUES (3648, '右玉', 3, '1406', '140623', 'y');
INSERT INTO `sys_data_region` VALUES (3649, '新城', 4, '140623', '140623100', 'x');
INSERT INTO `sys_data_region` VALUES (3650, '右卫', 4, '140623', '140623101', 'y');
INSERT INTO `sys_data_region` VALUES (3651, '威远', 4, '140623', '140623102', 'w');
INSERT INTO `sys_data_region` VALUES (3652, '元堡子', 4, '140623', '140623103', 'y');
INSERT INTO `sys_data_region` VALUES (3653, '牛心堡', 4, '140623', '140623200', 'n');
INSERT INTO `sys_data_region` VALUES (3654, '高家堡', 4, '140623', '140623202', 'g');
INSERT INTO `sys_data_region` VALUES (3655, '杨千河', 4, '140623', '140623204', 'y');
INSERT INTO `sys_data_region` VALUES (3656, '李达窑', 4, '140623', '140623205', 'l');
INSERT INTO `sys_data_region` VALUES (3657, '怀仁', 3, '1406', '140681', 'h');
INSERT INTO `sys_data_region` VALUES (3658, '云西', 4, '140681', '140681001', 'y');
INSERT INTO `sys_data_region` VALUES (3659, '云中', 4, '140681', '140681002', 'y');
INSERT INTO `sys_data_region` VALUES (3660, '云东', 4, '140681', '140681003', 'y');
INSERT INTO `sys_data_region` VALUES (3661, '吴家窑', 4, '140681', '140681101', 'w');
INSERT INTO `sys_data_region` VALUES (3662, '金沙滩', 4, '140681', '140681102', 'j');
INSERT INTO `sys_data_region` VALUES (3663, '毛家皂', 4, '140681', '140681103', 'm');
INSERT INTO `sys_data_region` VALUES (3664, '何家堡', 4, '140681', '140681200', 'h');
INSERT INTO `sys_data_region` VALUES (3665, '新家园', 4, '140681', '140681201', 'x');
INSERT INTO `sys_data_region` VALUES (3666, '亲和', 4, '140681', '140681202', 'q');
INSERT INTO `sys_data_region` VALUES (3667, '海北头', 4, '140681', '140681203', 'h');
INSERT INTO `sys_data_region` VALUES (3668, '河头', 4, '140681', '140681205', 'h');
INSERT INTO `sys_data_region` VALUES (3669, '晋中', 2, '14', '1407', 'j');
INSERT INTO `sys_data_region` VALUES (3670, '榆次', 3, '1407', '140702', 'y');
INSERT INTO `sys_data_region` VALUES (3671, '北关', 4, '140702', '140702001', 'b');
INSERT INTO `sys_data_region` VALUES (3672, '锦纶', 4, '140702', '140702002', 'j');
INSERT INTO `sys_data_region` VALUES (3673, '新华', 4, '140702', '140702003', 'x');
INSERT INTO `sys_data_region` VALUES (3674, '西南', 4, '140702', '140702004', 'x');
INSERT INTO `sys_data_region` VALUES (3675, '路西', 4, '140702', '140702005', 'l');
INSERT INTO `sys_data_region` VALUES (3676, '经纬', 4, '140702', '140702006', 'j');
INSERT INTO `sys_data_region` VALUES (3677, '安宁', 4, '140702', '140702007', 'a');
INSERT INTO `sys_data_region` VALUES (3678, '新建', 4, '140702', '140702008', 'x');
INSERT INTO `sys_data_region` VALUES (3679, '晋华', 4, '140702', '140702009', 'j');
INSERT INTO `sys_data_region` VALUES (3680, '乌金山', 4, '140702', '140702100', 'w');
INSERT INTO `sys_data_region` VALUES (3681, '东阳', 4, '140702', '140702101', 'd');
INSERT INTO `sys_data_region` VALUES (3682, '长凝', 4, '140702', '140702103', 'c');
INSERT INTO `sys_data_region` VALUES (3683, '北田', 4, '140702', '140702104', 'b');
INSERT INTO `sys_data_region` VALUES (3684, '修文', 4, '140702', '140702105', 'x');
INSERT INTO `sys_data_region` VALUES (3685, '郭家堡', 4, '140702', '140702200', 'g');
INSERT INTO `sys_data_region` VALUES (3686, '张庆', 4, '140702', '140702201', 'z');
INSERT INTO `sys_data_region` VALUES (3687, '庄子', 4, '140702', '140702202', 'z');
INSERT INTO `sys_data_region` VALUES (3688, '东赵', 4, '140702', '140702203', 'd');
INSERT INTO `sys_data_region` VALUES (3689, '晋中经济开发区', 4, '140702', '140702400', 'j');
INSERT INTO `sys_data_region` VALUES (3690, '太谷', 3, '1407', '140703', 't');
INSERT INTO `sys_data_region` VALUES (3691, '胡村', 4, '140703', '140703101', 'h');
INSERT INTO `sys_data_region` VALUES (3692, '范村', 4, '140703', '140703102', 'f');
INSERT INTO `sys_data_region` VALUES (3693, '水秀', 4, '140703', '140703103', 's');
INSERT INTO `sys_data_region` VALUES (3694, '侯城', 4, '140703', '140703200', 'h');
INSERT INTO `sys_data_region` VALUES (3695, '北洸', 4, '140703', '140703201', 'b');
INSERT INTO `sys_data_region` VALUES (3696, '阳邑', 4, '140703', '140703203', 'y');
INSERT INTO `sys_data_region` VALUES (3697, '小白', 4, '140703', '140703204', 'x');
INSERT INTO `sys_data_region` VALUES (3698, '任村', 4, '140703', '140703205', 'r');
INSERT INTO `sys_data_region` VALUES (3699, '榆社', 3, '1407', '140721', 'y');
INSERT INTO `sys_data_region` VALUES (3700, '箕城', 4, '140721', '140721100', 'j');
INSERT INTO `sys_data_region` VALUES (3701, '云簇', 4, '140721', '140721101', 'y');
INSERT INTO `sys_data_region` VALUES (3702, '郝北', 4, '140721', '140721102', 'h');
INSERT INTO `sys_data_region` VALUES (3703, '社城', 4, '140721', '140721103', 's');
INSERT INTO `sys_data_region` VALUES (3704, '河峪', 4, '140721', '140721200', 'h');
INSERT INTO `sys_data_region` VALUES (3705, '北寨', 4, '140721', '140721201', 'b');
INSERT INTO `sys_data_region` VALUES (3706, '西马', 4, '140721', '140721202', 'x');
INSERT INTO `sys_data_region` VALUES (3707, '左权', 3, '1407', '140722', 'z');
INSERT INTO `sys_data_region` VALUES (3708, '辽阳', 4, '140722', '140722100', 'l');
INSERT INTO `sys_data_region` VALUES (3709, '桐峪', 4, '140722', '140722101', 't');
INSERT INTO `sys_data_region` VALUES (3710, '麻田', 4, '140722', '140722102', 'm');
INSERT INTO `sys_data_region` VALUES (3711, '芹泉', 4, '140722', '140722103', 'q');
INSERT INTO `sys_data_region` VALUES (3712, '拐儿', 4, '140722', '140722104', 'g');
INSERT INTO `sys_data_region` VALUES (3713, '石匣', 4, '140722', '140722200', 's');
INSERT INTO `sys_data_region` VALUES (3714, '羊角', 4, '140722', '140722202', 'y');
INSERT INTO `sys_data_region` VALUES (3715, '寒王', 4, '140722', '140722203', 'h');
INSERT INTO `sys_data_region` VALUES (3716, '和顺', 3, '1407', '140723', 'h');
INSERT INTO `sys_data_region` VALUES (3717, '义兴', 4, '140723', '140723100', 'y');
INSERT INTO `sys_data_region` VALUES (3718, '李阳', 4, '140723', '140723101', 'l');
INSERT INTO `sys_data_region` VALUES (3719, '松烟', 4, '140723', '140723102', 's');
INSERT INTO `sys_data_region` VALUES (3720, '青城', 4, '140723', '140723103', 'q');
INSERT INTO `sys_data_region` VALUES (3721, '横岭', 4, '140723', '140723104', 'h');
INSERT INTO `sys_data_region` VALUES (3722, '喂马', 4, '140723', '140723200', 'w');
INSERT INTO `sys_data_region` VALUES (3723, '平松', 4, '140723', '140723201', 'p');
INSERT INTO `sys_data_region` VALUES (3724, '马坊', 4, '140723', '140723203', 'm');
INSERT INTO `sys_data_region` VALUES (3725, '昔阳', 3, '1407', '140724', 'x');
INSERT INTO `sys_data_region` VALUES (3726, '乐平', 4, '140724', '140724100', 'l');
INSERT INTO `sys_data_region` VALUES (3727, '皋落', 4, '140724', '140724101', 'g');
INSERT INTO `sys_data_region` VALUES (3728, '冶头', 4, '140724', '140724102', 'y');
INSERT INTO `sys_data_region` VALUES (3729, '沾尚', 4, '140724', '140724103', 'z');
INSERT INTO `sys_data_region` VALUES (3730, '大寨', 4, '140724', '140724104', 'd');
INSERT INTO `sys_data_region` VALUES (3731, '李家庄', 4, '140724', '140724201', 'l');
INSERT INTO `sys_data_region` VALUES (3732, '界都', 4, '140724', '140724202', 'j');
INSERT INTO `sys_data_region` VALUES (3733, '三都', 4, '140724', '140724203', 's');
INSERT INTO `sys_data_region` VALUES (3734, '赵壁', 4, '140724', '140724204', 'z');
INSERT INTO `sys_data_region` VALUES (3735, '孔氏', 4, '140724', '140724205', 'k');
INSERT INTO `sys_data_region` VALUES (3736, '寿阳', 3, '1407', '140725', 's');
INSERT INTO `sys_data_region` VALUES (3737, '朝阳', 4, '140725', '140725100', 'z');
INSERT INTO `sys_data_region` VALUES (3738, '南燕竹', 4, '140725', '140725101', 'n');
INSERT INTO `sys_data_region` VALUES (3739, '宗艾', 4, '140725', '140725102', 'z');
INSERT INTO `sys_data_region` VALUES (3740, '平头', 4, '140725', '140725103', 'p');
INSERT INTO `sys_data_region` VALUES (3741, '松塔', 4, '140725', '140725104', 's');
INSERT INTO `sys_data_region` VALUES (3742, '西洛', 4, '140725', '140725105', 'x');
INSERT INTO `sys_data_region` VALUES (3743, '尹灵芝', 4, '140725', '140725106', 'y');
INSERT INTO `sys_data_region` VALUES (3744, '平舒', 4, '140725', '140725200', 'p');
INSERT INTO `sys_data_region` VALUES (3745, '解愁', 4, '140725', '140725201', 'j');
INSERT INTO `sys_data_region` VALUES (3746, '温家庄', 4, '140725', '140725202', 'w');
INSERT INTO `sys_data_region` VALUES (3747, '景尚', 4, '140725', '140725203', 'j');
INSERT INTO `sys_data_region` VALUES (3748, '羊头崖', 4, '140725', '140725205', 'y');
INSERT INTO `sys_data_region` VALUES (3749, '祁县', 3, '1407', '140727', 'q');
INSERT INTO `sys_data_region` VALUES (3750, '昭余', 4, '140727', '140727100', 'z');
INSERT INTO `sys_data_region` VALUES (3751, '东观', 4, '140727', '140727101', 'd');
INSERT INTO `sys_data_region` VALUES (3752, '古县', 4, '140727', '140727102', 'g');
INSERT INTO `sys_data_region` VALUES (3753, '贾令', 4, '140727', '140727103', 'j');
INSERT INTO `sys_data_region` VALUES (3754, '城赵', 4, '140727', '140727104', 'c');
INSERT INTO `sys_data_region` VALUES (3755, '来远', 4, '140727', '140727105', 'l');
INSERT INTO `sys_data_region` VALUES (3756, '峪口', 4, '140727', '140727201', 'y');
INSERT INTO `sys_data_region` VALUES (3757, '平遥', 3, '1407', '140728', 'p');
INSERT INTO `sys_data_region` VALUES (3758, '古城', 4, '140728', '140728001', 'g');
INSERT INTO `sys_data_region` VALUES (3759, '城东', 4, '140728', '140728002', 'c');
INSERT INTO `sys_data_region` VALUES (3760, '城西', 4, '140728', '140728003', 'c');
INSERT INTO `sys_data_region` VALUES (3761, '古陶', 4, '140728', '140728100', 'g');
INSERT INTO `sys_data_region` VALUES (3762, '段村', 4, '140728', '140728101', 'd');
INSERT INTO `sys_data_region` VALUES (3763, '东泉', 4, '140728', '140728102', 'd');
INSERT INTO `sys_data_region` VALUES (3764, '洪善', 4, '140728', '140728103', 'h');
INSERT INTO `sys_data_region` VALUES (3765, '宁固', 4, '140728', '140728104', 'n');
INSERT INTO `sys_data_region` VALUES (3766, '南政', 4, '140728', '140728200', 'n');
INSERT INTO `sys_data_region` VALUES (3767, '中都', 4, '140728', '140728201', 'z');
INSERT INTO `sys_data_region` VALUES (3768, '岳壁', 4, '140728', '140728202', 'y');
INSERT INTO `sys_data_region` VALUES (3769, '卜宜', 4, '140728', '140728203', 'b');
INSERT INTO `sys_data_region` VALUES (3770, '朱坑', 4, '140728', '140728205', 'z');
INSERT INTO `sys_data_region` VALUES (3771, '襄垣', 4, '140728', '140728206', 'x');
INSERT INTO `sys_data_region` VALUES (3772, '杜家庄', 4, '140728', '140728207', 'd');
INSERT INTO `sys_data_region` VALUES (3773, '香乐', 4, '140728', '140728208', 'x');
INSERT INTO `sys_data_region` VALUES (3774, '灵石', 3, '1407', '140729', 'l');
INSERT INTO `sys_data_region` VALUES (3775, '翠峰', 4, '140729', '140729101', 'c');
INSERT INTO `sys_data_region` VALUES (3776, '静升', 4, '140729', '140729102', 'j');
INSERT INTO `sys_data_region` VALUES (3777, '两渡', 4, '140729', '140729103', 'l');
INSERT INTO `sys_data_region` VALUES (3778, '夏门', 4, '140729', '140729104', 'x');
INSERT INTO `sys_data_region` VALUES (3779, '南关', 4, '140729', '140729105', 'n');
INSERT INTO `sys_data_region` VALUES (3780, '段纯', 4, '140729', '140729106', 'd');
INSERT INTO `sys_data_region` VALUES (3781, '王禹', 4, '140729', '140729202', 'w');
INSERT INTO `sys_data_region` VALUES (3782, '坛镇', 4, '140729', '140729203', 't');
INSERT INTO `sys_data_region` VALUES (3783, '梁家墕', 4, '140729', '140729204', 'l');
INSERT INTO `sys_data_region` VALUES (3784, '交口', 4, '140729', '140729205', 'j');
INSERT INTO `sys_data_region` VALUES (3785, '介休', 3, '1407', '140781', 'j');
INSERT INTO `sys_data_region` VALUES (3786, '北关', 4, '140781', '140781001', 'b');
INSERT INTO `sys_data_region` VALUES (3787, '西关', 4, '140781', '140781002', 'x');
INSERT INTO `sys_data_region` VALUES (3788, '东南', 4, '140781', '140781003', 'd');
INSERT INTO `sys_data_region` VALUES (3789, '西南', 4, '140781', '140781004', 'x');
INSERT INTO `sys_data_region` VALUES (3790, '北坛', 4, '140781', '140781005', 'b');
INSERT INTO `sys_data_region` VALUES (3791, '义安', 4, '140781', '140781100', 'y');
INSERT INTO `sys_data_region` VALUES (3792, '张兰', 4, '140781', '140781101', 'z');
INSERT INTO `sys_data_region` VALUES (3793, '连福', 4, '140781', '140781102', 'l');
INSERT INTO `sys_data_region` VALUES (3794, '洪山', 4, '140781', '140781103', 'h');
INSERT INTO `sys_data_region` VALUES (3795, '义棠', 4, '140781', '140781104', 'y');
INSERT INTO `sys_data_region` VALUES (3796, '龙凤', 4, '140781', '140781105', 'l');
INSERT INTO `sys_data_region` VALUES (3797, '绵山', 4, '140781', '140781106', 'm');
INSERT INTO `sys_data_region` VALUES (3798, '城关', 4, '140781', '140781200', 'c');
INSERT INTO `sys_data_region` VALUES (3799, '宋古', 4, '140781', '140781201', 's');
INSERT INTO `sys_data_region` VALUES (3800, '运城', 2, '14', '1408', 'y');
INSERT INTO `sys_data_region` VALUES (3801, '盐湖', 3, '1408', '140802', 'y');
INSERT INTO `sys_data_region` VALUES (3802, '中城', 4, '140802', '140802001', 'z');
INSERT INTO `sys_data_region` VALUES (3803, '东城', 4, '140802', '140802002', 'd');
INSERT INTO `sys_data_region` VALUES (3804, '西城', 4, '140802', '140802003', 'x');
INSERT INTO `sys_data_region` VALUES (3805, '南城', 4, '140802', '140802004', 'n');
INSERT INTO `sys_data_region` VALUES (3806, '北城', 4, '140802', '140802005', 'b');
INSERT INTO `sys_data_region` VALUES (3807, '安邑', 4, '140802', '140802006', 'a');
INSERT INTO `sys_data_region` VALUES (3808, '大渠', 4, '140802', '140802007', 'd');
INSERT INTO `sys_data_region` VALUES (3809, '姚孟', 4, '140802', '140802008', 'y');
INSERT INTO `sys_data_region` VALUES (3810, '龙居', 4, '140802', '140802100', 'l');
INSERT INTO `sys_data_region` VALUES (3811, '陶村', 4, '140802', '140802101', 't');
INSERT INTO `sys_data_region` VALUES (3812, '东郭', 4, '140802', '140802102', 'd');
INSERT INTO `sys_data_region` VALUES (3813, '三路里', 4, '140802', '140802103', 's');
INSERT INTO `sys_data_region` VALUES (3814, '北相', 4, '140802', '140802104', 'b');
INSERT INTO `sys_data_region` VALUES (3815, '泓芝驿', 4, '140802', '140802105', 'h');
INSERT INTO `sys_data_region` VALUES (3816, '解州', 4, '140802', '140802106', 'j');
INSERT INTO `sys_data_region` VALUES (3817, '席张', 4, '140802', '140802200', 'x');
INSERT INTO `sys_data_region` VALUES (3818, '金井', 4, '140802', '140802201', 'j');
INSERT INTO `sys_data_region` VALUES (3819, '冯村', 4, '140802', '140802202', 'f');
INSERT INTO `sys_data_region` VALUES (3820, '王范', 4, '140802', '140802203', 'w');
INSERT INTO `sys_data_region` VALUES (3821, '上郭', 4, '140802', '140802204', 's');
INSERT INTO `sys_data_region` VALUES (3822, '上王', 4, '140802', '140802205', 's');
INSERT INTO `sys_data_region` VALUES (3823, '临猗', 3, '1408', '140821', 'l');
INSERT INTO `sys_data_region` VALUES (3824, '猗氏', 4, '140821', '140821100', 'y');
INSERT INTO `sys_data_region` VALUES (3825, '嵋阳', 4, '140821', '140821101', 'm');
INSERT INTO `sys_data_region` VALUES (3826, '临晋', 4, '140821', '140821102', 'l');
INSERT INTO `sys_data_region` VALUES (3827, '七级', 4, '140821', '140821103', 'q');
INSERT INTO `sys_data_region` VALUES (3828, '东张', 4, '140821', '140821104', 'd');
INSERT INTO `sys_data_region` VALUES (3829, '孙吉', 4, '140821', '140821105', 's');
INSERT INTO `sys_data_region` VALUES (3830, '三管', 4, '140821', '140821106', 's');
INSERT INTO `sys_data_region` VALUES (3831, '牛杜', 4, '140821', '140821107', 'n');
INSERT INTO `sys_data_region` VALUES (3832, '耽子', 4, '140821', '140821108', 'd');
INSERT INTO `sys_data_region` VALUES (3833, '角杯', 4, '140821', '140821109', 'j');
INSERT INTO `sys_data_region` VALUES (3834, '楚侯', 4, '140821', '140821200', 'c');
INSERT INTO `sys_data_region` VALUES (3835, '庙上', 4, '140821', '140821201', 'm');
INSERT INTO `sys_data_region` VALUES (3836, '北辛', 4, '140821', '140821203', 'b');
INSERT INTO `sys_data_region` VALUES (3837, '北景', 4, '140821', '140821205', 'b');
INSERT INTO `sys_data_region` VALUES (3838, '万荣', 3, '1408', '140822', 'w');
INSERT INTO `sys_data_region` VALUES (3839, '解店', 4, '140822', '140822100', 'j');
INSERT INTO `sys_data_region` VALUES (3840, '通化', 4, '140822', '140822101', 't');
INSERT INTO `sys_data_region` VALUES (3841, '汉薛', 4, '140822', '140822102', 'h');
INSERT INTO `sys_data_region` VALUES (3842, '荣河', 4, '140822', '140822103', 'r');
INSERT INTO `sys_data_region` VALUES (3843, '高村', 4, '140822', '140822105', 'g');
INSERT INTO `sys_data_region` VALUES (3844, '万泉', 4, '140822', '140822200', 'w');
INSERT INTO `sys_data_region` VALUES (3845, '里望', 4, '140822', '140822201', 'l');
INSERT INTO `sys_data_region` VALUES (3846, '西村', 4, '140822', '140822202', 'x');
INSERT INTO `sys_data_region` VALUES (3847, '南张', 4, '140822', '140822203', 'n');
INSERT INTO `sys_data_region` VALUES (3848, '皇甫', 4, '140822', '140822205', 'h');
INSERT INTO `sys_data_region` VALUES (3849, '贾村', 4, '140822', '140822206', 'j');
INSERT INTO `sys_data_region` VALUES (3850, '王显', 4, '140822', '140822207', 'w');
INSERT INTO `sys_data_region` VALUES (3851, '光华', 4, '140822', '140822208', 'g');
INSERT INTO `sys_data_region` VALUES (3852, '裴庄', 4, '140822', '140822209', 'p');
INSERT INTO `sys_data_region` VALUES (3853, '闻喜', 3, '1408', '140823', 'w');
INSERT INTO `sys_data_region` VALUES (3854, '桐城', 4, '140823', '140823100', 't');
INSERT INTO `sys_data_region` VALUES (3855, '郭家庄', 4, '140823', '140823101', 'g');
INSERT INTO `sys_data_region` VALUES (3856, '畖底', 4, '140823', '140823102', 'w');
INSERT INTO `sys_data_region` VALUES (3857, '薛店', 4, '140823', '140823103', 'x');
INSERT INTO `sys_data_region` VALUES (3858, '东镇', 4, '140823', '140823104', 'd');
INSERT INTO `sys_data_region` VALUES (3859, '礼元', 4, '140823', '140823105', 'l');
INSERT INTO `sys_data_region` VALUES (3860, '河底', 4, '140823', '140823106', 'h');
INSERT INTO `sys_data_region` VALUES (3861, '阳隅', 4, '140823', '140823107', 'y');
INSERT INTO `sys_data_region` VALUES (3862, '侯村', 4, '140823', '140823108', 'h');
INSERT INTO `sys_data_region` VALUES (3863, '裴社', 4, '140823', '140823109', 'p');
INSERT INTO `sys_data_region` VALUES (3864, '后宫', 4, '140823', '140823204', 'h');
INSERT INTO `sys_data_region` VALUES (3865, '石门', 4, '140823', '140823205', 's');
INSERT INTO `sys_data_region` VALUES (3866, '稷山', 3, '1408', '140824', 'j');
INSERT INTO `sys_data_region` VALUES (3867, '稷峰', 4, '140824', '140824100', 'j');
INSERT INTO `sys_data_region` VALUES (3868, '西社', 4, '140824', '140824101', 'x');
INSERT INTO `sys_data_region` VALUES (3869, '化峪', 4, '140824', '140824102', 'h');
INSERT INTO `sys_data_region` VALUES (3870, '翟店', 4, '140824', '140824103', 'd');
INSERT INTO `sys_data_region` VALUES (3871, '清河', 4, '140824', '140824104', 'q');
INSERT INTO `sys_data_region` VALUES (3872, '蔡村', 4, '140824', '140824200', 'c');
INSERT INTO `sys_data_region` VALUES (3873, '太阳', 4, '140824', '140824201', 't');
INSERT INTO `sys_data_region` VALUES (3874, '新绛', 3, '1408', '140825', 'x');
INSERT INTO `sys_data_region` VALUES (3875, '龙兴', 4, '140825', '140825100', 'l');
INSERT INTO `sys_data_region` VALUES (3876, '三泉', 4, '140825', '140825101', 's');
INSERT INTO `sys_data_region` VALUES (3877, '泽掌', 4, '140825', '140825102', 'z');
INSERT INTO `sys_data_region` VALUES (3878, '北张', 4, '140825', '140825103', 'b');
INSERT INTO `sys_data_region` VALUES (3879, '古交', 4, '140825', '140825104', 'g');
INSERT INTO `sys_data_region` VALUES (3880, '万安', 4, '140825', '140825105', 'w');
INSERT INTO `sys_data_region` VALUES (3881, '阳王', 4, '140825', '140825106', 'y');
INSERT INTO `sys_data_region` VALUES (3882, '泉掌', 4, '140825', '140825107', 'q');
INSERT INTO `sys_data_region` VALUES (3883, '横桥', 4, '140825', '140825108', 'h');
INSERT INTO `sys_data_region` VALUES (3884, '绛县', 3, '1408', '140826', 'j');
INSERT INTO `sys_data_region` VALUES (3885, '古绛', 4, '140826', '140826100', 'g');
INSERT INTO `sys_data_region` VALUES (3886, '横水', 4, '140826', '140826101', 'h');
INSERT INTO `sys_data_region` VALUES (3887, '陈村', 4, '140826', '140826102', 'c');
INSERT INTO `sys_data_region` VALUES (3888, '卫庄', 4, '140826', '140826103', 'w');
INSERT INTO `sys_data_region` VALUES (3889, '磨里', 4, '140826', '140826104', 'm');
INSERT INTO `sys_data_region` VALUES (3890, '南樊', 4, '140826', '140826105', 'n');
INSERT INTO `sys_data_region` VALUES (3891, '安峪', 4, '140826', '140826106', 'a');
INSERT INTO `sys_data_region` VALUES (3892, '大交', 4, '140826', '140826107', 'd');
INSERT INTO `sys_data_region` VALUES (3893, '郝庄', 4, '140826', '140826200', 'h');
INSERT INTO `sys_data_region` VALUES (3894, '冷口', 4, '140826', '140826201', 'l');
INSERT INTO `sys_data_region` VALUES (3895, '垣曲', 3, '1408', '140827', 'y');
INSERT INTO `sys_data_region` VALUES (3896, '新城', 4, '140827', '140827100', 'x');
INSERT INTO `sys_data_region` VALUES (3897, '历山', 4, '140827', '140827101', 'l');
INSERT INTO `sys_data_region` VALUES (3898, '古城', 4, '140827', '140827102', 'g');
INSERT INTO `sys_data_region` VALUES (3899, '王茅', 4, '140827', '140827103', 'w');
INSERT INTO `sys_data_region` VALUES (3900, '毛家湾', 4, '140827', '140827104', 'm');
INSERT INTO `sys_data_region` VALUES (3901, '英言', 4, '140827', '140827105', 'y');
INSERT INTO `sys_data_region` VALUES (3902, '蒲掌', 4, '140827', '140827200', 'p');
INSERT INTO `sys_data_region` VALUES (3903, '解峪', 4, '140827', '140827202', 'j');
INSERT INTO `sys_data_region` VALUES (3904, '华峰', 4, '140827', '140827203', 'h');
INSERT INTO `sys_data_region` VALUES (3905, '长直', 4, '140827', '140827204', 'c');
INSERT INTO `sys_data_region` VALUES (3906, '皋落', 4, '140827', '140827205', 'g');
INSERT INTO `sys_data_region` VALUES (3907, '夏县', 3, '1408', '140828', 'x');
INSERT INTO `sys_data_region` VALUES (3908, '瑶峰', 4, '140828', '140828100', 'y');
INSERT INTO `sys_data_region` VALUES (3909, '庙前', 4, '140828', '140828101', 'm');
INSERT INTO `sys_data_region` VALUES (3910, '裴介', 4, '140828', '140828102', 'p');
INSERT INTO `sys_data_region` VALUES (3911, '水头', 4, '140828', '140828103', 's');
INSERT INTO `sys_data_region` VALUES (3912, '埝掌', 4, '140828', '140828104', 'n');
INSERT INTO `sys_data_region` VALUES (3913, '泗交', 4, '140828', '140828105', 's');
INSERT INTO `sys_data_region` VALUES (3914, '禹王', 4, '140828', '140828106', 'y');
INSERT INTO `sys_data_region` VALUES (3915, '尉郭', 4, '140828', '140828200', 'w');
INSERT INTO `sys_data_region` VALUES (3916, '胡张', 4, '140828', '140828202', 'h');
INSERT INTO `sys_data_region` VALUES (3917, '南大里', 4, '140828', '140828203', 'n');
INSERT INTO `sys_data_region` VALUES (3918, '祁家河', 4, '140828', '140828204', 'q');
INSERT INTO `sys_data_region` VALUES (3919, '平陆', 3, '1408', '140829', 'p');
INSERT INTO `sys_data_region` VALUES (3920, '圣人涧', 4, '140829', '140829100', 's');
INSERT INTO `sys_data_region` VALUES (3921, '常乐', 4, '140829', '140829101', 'c');
INSERT INTO `sys_data_region` VALUES (3922, '张店', 4, '140829', '140829102', 'z');
INSERT INTO `sys_data_region` VALUES (3923, '张村', 4, '140829', '140829103', 'z');
INSERT INTO `sys_data_region` VALUES (3924, '曹川', 4, '140829', '140829104', 'c');
INSERT INTO `sys_data_region` VALUES (3925, '三门', 4, '140829', '140829105', 's');
INSERT INTO `sys_data_region` VALUES (3926, '部官', 4, '140829', '140829107', 'b');
INSERT INTO `sys_data_region` VALUES (3927, '洪池', 4, '140829', '140829200', 'h');
INSERT INTO `sys_data_region` VALUES (3928, '杜马', 4, '140829', '140829201', 'd');
INSERT INTO `sys_data_region` VALUES (3929, '芮城', 3, '1408', '140830', 'r');
INSERT INTO `sys_data_region` VALUES (3930, '古魏', 4, '140830', '140830100', 'g');
INSERT INTO `sys_data_region` VALUES (3931, '风陵渡', 4, '140830', '140830101', 'f');
INSERT INTO `sys_data_region` VALUES (3932, '陌南', 4, '140830', '140830102', 'm');
INSERT INTO `sys_data_region` VALUES (3933, '西陌', 4, '140830', '140830103', 'x');
INSERT INTO `sys_data_region` VALUES (3934, '永乐', 4, '140830', '140830104', 'y');
INSERT INTO `sys_data_region` VALUES (3935, '大王', 4, '140830', '140830105', 'd');
INSERT INTO `sys_data_region` VALUES (3936, '阳城', 4, '140830', '140830106', 'y');
INSERT INTO `sys_data_region` VALUES (3937, '南磑', 4, '140830', '140830107', 'n');
INSERT INTO `sys_data_region` VALUES (3938, '东垆', 4, '140830', '140830200', 'd');
INSERT INTO `sys_data_region` VALUES (3939, '学张', 4, '140830', '140830202', 'x');
INSERT INTO `sys_data_region` VALUES (3940, '永济', 3, '1408', '140881', 'y');
INSERT INTO `sys_data_region` VALUES (3941, '城西', 4, '140881', '140881001', 'c');
INSERT INTO `sys_data_region` VALUES (3942, '城北', 4, '140881', '140881002', 'c');
INSERT INTO `sys_data_region` VALUES (3943, '城东', 4, '140881', '140881003', 'c');
INSERT INTO `sys_data_region` VALUES (3944, '虞乡', 4, '140881', '140881100', 'y');
INSERT INTO `sys_data_region` VALUES (3945, '卿头', 4, '140881', '140881101', 'q');
INSERT INTO `sys_data_region` VALUES (3946, '开张', 4, '140881', '140881102', 'k');
INSERT INTO `sys_data_region` VALUES (3947, '栲栳', 4, '140881', '140881103', 'k');
INSERT INTO `sys_data_region` VALUES (3948, '蒲州', 4, '140881', '140881104', 'p');
INSERT INTO `sys_data_region` VALUES (3949, '韩阳', 4, '140881', '140881105', 'h');
INSERT INTO `sys_data_region` VALUES (3950, '张营', 4, '140881', '140881106', 'z');
INSERT INTO `sys_data_region` VALUES (3951, '河津', 3, '1408', '140882', 'h');
INSERT INTO `sys_data_region` VALUES (3952, '城区', 4, '140882', '140882001', 'c');
INSERT INTO `sys_data_region` VALUES (3953, '清涧', 4, '140882', '140882002', 'q');
INSERT INTO `sys_data_region` VALUES (3954, '赵家庄', 4, '140882', '140882003', 'z');
INSERT INTO `sys_data_region` VALUES (3955, '阳村', 4, '140882', '140882004', 'y');
INSERT INTO `sys_data_region` VALUES (3956, '樊村', 4, '140882', '140882100', 'f');
INSERT INTO `sys_data_region` VALUES (3957, '僧楼', 4, '140882', '140882101', 's');
INSERT INTO `sys_data_region` VALUES (3958, '柴家', 4, '140882', '140882102', 'c');
INSERT INTO `sys_data_region` VALUES (3959, '小梁', 4, '140882', '140882200', 'x');
INSERT INTO `sys_data_region` VALUES (3960, '下化', 4, '140882', '140882204', 'x');
INSERT INTO `sys_data_region` VALUES (3961, '忻州', 2, '14', '1409', 'x');
INSERT INTO `sys_data_region` VALUES (3962, '忻府', 3, '1409', '140902', 'x');
INSERT INTO `sys_data_region` VALUES (3963, '秀容', 4, '140902', '140902001', 'x');
INSERT INTO `sys_data_region` VALUES (3964, '长征', 4, '140902', '140902002', 'c');
INSERT INTO `sys_data_region` VALUES (3965, '新建路', 4, '140902', '140902003', 'x');
INSERT INTO `sys_data_region` VALUES (3966, '云中路', 4, '140902', '140902004', 'y');
INSERT INTO `sys_data_region` VALUES (3967, '九原街', 4, '140902', '140902005', 'j');
INSERT INTO `sys_data_region` VALUES (3968, '旭来街', 4, '140902', '140902006', 'x');
INSERT INTO `sys_data_region` VALUES (3969, '桥西', 4, '140902', '140902007', 'q');
INSERT INTO `sys_data_region` VALUES (3970, '奇村', 4, '140902', '140902101', 'q');
INSERT INTO `sys_data_region` VALUES (3971, '三交', 4, '140902', '140902102', 's');
INSERT INTO `sys_data_region` VALUES (3972, '庄磨', 4, '140902', '140902103', 'z');
INSERT INTO `sys_data_region` VALUES (3973, '豆罗', 4, '140902', '140902104', 'd');
INSERT INTO `sys_data_region` VALUES (3974, '董村', 4, '140902', '140902105', 'd');
INSERT INTO `sys_data_region` VALUES (3975, '西张', 4, '140902', '140902106', 'x');
INSERT INTO `sys_data_region` VALUES (3976, '忻口', 4, '140902', '140902109', 'x');
INSERT INTO `sys_data_region` VALUES (3977, '合索', 4, '140902', '140902110', 'h');
INSERT INTO `sys_data_region` VALUES (3978, '兰村', 4, '140902', '140902206', 'l');
INSERT INTO `sys_data_region` VALUES (3979, '东楼', 4, '140902', '140902209', 'd');
INSERT INTO `sys_data_region` VALUES (3980, '北义井', 4, '140902', '140902210', 'b');
INSERT INTO `sys_data_region` VALUES (3981, '定襄', 3, '1409', '140921', 'd');
INSERT INTO `sys_data_region` VALUES (3982, '晋昌', 4, '140921', '140921100', 'j');
INSERT INTO `sys_data_region` VALUES (3983, '河边', 4, '140921', '140921101', 'h');
INSERT INTO `sys_data_region` VALUES (3984, '宏道', 4, '140921', '140921102', 'h');
INSERT INTO `sys_data_region` VALUES (3985, '季庄', 4, '140921', '140921104', 'j');
INSERT INTO `sys_data_region` VALUES (3986, '蒋村', 4, '140921', '140921105', 'j');
INSERT INTO `sys_data_region` VALUES (3987, '南王', 4, '140921', '140921201', 'n');
INSERT INTO `sys_data_region` VALUES (3988, '神山', 4, '140921', '140921203', 's');
INSERT INTO `sys_data_region` VALUES (3989, '受禄', 4, '140921', '140921205', 's');
INSERT INTO `sys_data_region` VALUES (3990, '五台', 3, '1409', '140922', 'w');
INSERT INTO `sys_data_region` VALUES (3991, '台城', 4, '140922', '140922100', 't');
INSERT INTO `sys_data_region` VALUES (3992, '台怀', 4, '140922', '140922101', 't');
INSERT INTO `sys_data_region` VALUES (3993, '耿镇', 4, '140922', '140922102', 'g');
INSERT INTO `sys_data_region` VALUES (3994, '豆村', 4, '140922', '140922103', 'd');
INSERT INTO `sys_data_region` VALUES (3995, '白家庄', 4, '140922', '140922104', 'b');
INSERT INTO `sys_data_region` VALUES (3996, '东冶', 4, '140922', '140922105', 'd');
INSERT INTO `sys_data_region` VALUES (3997, '建安', 4, '140922', '140922107', 'j');
INSERT INTO `sys_data_region` VALUES (3998, '沟南', 4, '140922', '140922200', 'g');
INSERT INTO `sys_data_region` VALUES (3999, '东雷', 4, '140922', '140922201', 'd');
INSERT INTO `sys_data_region` VALUES (4000, '高洪口', 4, '140922', '140922202', 'g');
INSERT INTO `sys_data_region` VALUES (4001, '门限石', 4, '140922', '140922203', 'm');
INSERT INTO `sys_data_region` VALUES (4002, '陈家庄', 4, '140922', '140922204', 'c');
INSERT INTO `sys_data_region` VALUES (4003, '蒋坊', 4, '140922', '140922207', 'j');
INSERT INTO `sys_data_region` VALUES (4004, '阳白', 4, '140922', '140922209', 'y');
INSERT INTO `sys_data_region` VALUES (4005, '茹村', 4, '140922', '140922210', 'r');
INSERT INTO `sys_data_region` VALUES (4006, '石咀', 4, '140922', '140922211', 's');
INSERT INTO `sys_data_region` VALUES (4007, '金岗库', 4, '140922', '140922212', 'j');
INSERT INTO `sys_data_region` VALUES (4008, '代县', 3, '1409', '140923', 'd');
INSERT INTO `sys_data_region` VALUES (4009, '上馆', 4, '140923', '140923100', 's');
INSERT INTO `sys_data_region` VALUES (4010, '阳明堡', 4, '140923', '140923101', 'y');
INSERT INTO `sys_data_region` VALUES (4011, '峨口', 4, '140923', '140923102', 'e');
INSERT INTO `sys_data_region` VALUES (4012, '聂营', 4, '140923', '140923103', 'n');
INSERT INTO `sys_data_region` VALUES (4013, '枣林', 4, '140923', '140923104', 'z');
INSERT INTO `sys_data_region` VALUES (4014, '峪口', 4, '140923', '140923108', 'y');
INSERT INTO `sys_data_region` VALUES (4015, '新高', 4, '140923', '140923200', 'x');
INSERT INTO `sys_data_region` VALUES (4016, '上磨坊', 4, '140923', '140923202', 's');
INSERT INTO `sys_data_region` VALUES (4017, '雁门关', 4, '140923', '140923204', 'y');
INSERT INTO `sys_data_region` VALUES (4018, '繁峙', 3, '1409', '140924', 'f');
INSERT INTO `sys_data_region` VALUES (4019, '繁城', 4, '140924', '140924100', 'f');
INSERT INTO `sys_data_region` VALUES (4020, '砂河', 4, '140924', '140924101', 's');
INSERT INTO `sys_data_region` VALUES (4021, '大营', 4, '140924', '140924102', 'd');
INSERT INTO `sys_data_region` VALUES (4022, '平型关', 4, '140924', '140924103', 'p');
INSERT INTO `sys_data_region` VALUES (4023, '下茹越', 4, '140924', '140924201', 'x');
INSERT INTO `sys_data_region` VALUES (4024, '光裕堡', 4, '140924', '140924203', 'g');
INSERT INTO `sys_data_region` VALUES (4025, '集义庄', 4, '140924', '140924204', 'j');
INSERT INTO `sys_data_region` VALUES (4026, '东山', 4, '140924', '140924207', 'd');
INSERT INTO `sys_data_region` VALUES (4027, '金山铺', 4, '140924', '140924209', 'j');
INSERT INTO `sys_data_region` VALUES (4028, '神堂堡', 4, '140924', '140924213', 's');
INSERT INTO `sys_data_region` VALUES (4029, '岩头', 4, '140924', '140924215', 'y');
INSERT INTO `sys_data_region` VALUES (4030, '宁武', 3, '1409', '140925', 'n');
INSERT INTO `sys_data_region` VALUES (4031, '凤凰', 4, '140925', '140925100', 'f');
INSERT INTO `sys_data_region` VALUES (4032, '阳方口', 4, '140925', '140925101', 'y');
INSERT INTO `sys_data_region` VALUES (4033, '东寨', 4, '140925', '140925102', 'd');
INSERT INTO `sys_data_region` VALUES (4034, '石家庄', 4, '140925', '140925103', 's');
INSERT INTO `sys_data_region` VALUES (4035, '宁化', 4, '140925', '140925105', 'n');
INSERT INTO `sys_data_region` VALUES (4036, '薛家洼', 4, '140925', '140925200', 'x');
INSERT INTO `sys_data_region` VALUES (4037, '余庄', 4, '140925', '140925201', 'y');
INSERT INTO `sys_data_region` VALUES (4038, '涔山', 4, '140925', '140925202', 'c');
INSERT INTO `sys_data_region` VALUES (4039, '西马坊', 4, '140925', '140925204', 'x');
INSERT INTO `sys_data_region` VALUES (4040, '迭台寺', 4, '140925', '140925206', 'd');
INSERT INTO `sys_data_region` VALUES (4041, '怀道', 4, '140925', '140925208', 'h');
INSERT INTO `sys_data_region` VALUES (4042, '东马坊', 4, '140925', '140925209', 'd');
INSERT INTO `sys_data_region` VALUES (4043, '静乐', 3, '1409', '140926', 'j');
INSERT INTO `sys_data_region` VALUES (4044, '鹅城', 4, '140926', '140926100', 'e');
INSERT INTO `sys_data_region` VALUES (4045, '杜家村', 4, '140926', '140926101', 'd');
INSERT INTO `sys_data_region` VALUES (4046, '康家会', 4, '140926', '140926102', 'k');
INSERT INTO `sys_data_region` VALUES (4047, '丰润', 4, '140926', '140926103', 'f');
INSERT INTO `sys_data_region` VALUES (4048, '双路', 4, '140926', '140926104', 's');
INSERT INTO `sys_data_region` VALUES (4049, '王村', 4, '140926', '140926106', 'w');
INSERT INTO `sys_data_region` VALUES (4050, '段家寨', 4, '140926', '140926204', 'd');
INSERT INTO `sys_data_region` VALUES (4051, '辛村', 4, '140926', '140926205', 'x');
INSERT INTO `sys_data_region` VALUES (4052, '神峪沟', 4, '140926', '140926207', 's');
INSERT INTO `sys_data_region` VALUES (4053, '娘子神', 4, '140926', '140926208', 'n');
INSERT INTO `sys_data_region` VALUES (4054, '娑婆', 4, '140926', '140926209', 's');
INSERT INTO `sys_data_region` VALUES (4055, '赤泥窊', 4, '140926', '140926210', 'c');
INSERT INTO `sys_data_region` VALUES (4056, '神池', 3, '1409', '140927', 's');
INSERT INTO `sys_data_region` VALUES (4057, '龙泉', 4, '140927', '140927100', 'l');
INSERT INTO `sys_data_region` VALUES (4058, '义井', 4, '140927', '140927101', 'y');
INSERT INTO `sys_data_region` VALUES (4059, '八角', 4, '140927', '140927102', 'b');
INSERT INTO `sys_data_region` VALUES (4060, '东湖', 4, '140927', '140927200', 'd');
INSERT INTO `sys_data_region` VALUES (4061, '贺职', 4, '140927', '140927203', 'h');
INSERT INTO `sys_data_region` VALUES (4062, '长畛', 4, '140927', '140927204', 'c');
INSERT INTO `sys_data_region` VALUES (4063, '烈堡', 4, '140927', '140927205', 'l');
INSERT INTO `sys_data_region` VALUES (4064, '大严备', 4, '140927', '140927206', 'd');
INSERT INTO `sys_data_region` VALUES (4065, '五寨', 3, '1409', '140928', 'w');
INSERT INTO `sys_data_region` VALUES (4066, '砚城', 4, '140928', '140928100', 'y');
INSERT INTO `sys_data_region` VALUES (4067, '小河头', 4, '140928', '140928101', 'x');
INSERT INTO `sys_data_region` VALUES (4068, '三岔', 4, '140928', '140928102', 's');
INSERT INTO `sys_data_region` VALUES (4069, '前所', 4, '140928', '140928200', 'q');
INSERT INTO `sys_data_region` VALUES (4070, '李家坪', 4, '140928', '140928201', 'l');
INSERT INTO `sys_data_region` VALUES (4071, '孙家坪', 4, '140928', '140928202', 's');
INSERT INTO `sys_data_region` VALUES (4072, '胡会', 4, '140928', '140928204', 'h');
INSERT INTO `sys_data_region` VALUES (4073, '韩家楼', 4, '140928', '140928206', 'h');
INSERT INTO `sys_data_region` VALUES (4074, '东秀庄', 4, '140928', '140928207', 'd');
INSERT INTO `sys_data_region` VALUES (4075, '杏岭子', 4, '140928', '140928208', 'x');
INSERT INTO `sys_data_region` VALUES (4076, '岢岚', 3, '1409', '140929', 'k');
INSERT INTO `sys_data_region` VALUES (4077, '岚漪', 4, '140929', '140929100', 'l');
INSERT INTO `sys_data_region` VALUES (4078, '三井', 4, '140929', '140929101', 's');
INSERT INTO `sys_data_region` VALUES (4079, '宋家沟', 4, '140929', '140929102', 's');
INSERT INTO `sys_data_region` VALUES (4080, '高家会', 4, '140929', '140929201', 'g');
INSERT INTO `sys_data_region` VALUES (4081, '李家沟', 4, '140929', '140929203', 'l');
INSERT INTO `sys_data_region` VALUES (4082, '水峪贯', 4, '140929', '140929204', 's');
INSERT INTO `sys_data_region` VALUES (4083, '西豹峪', 4, '140929', '140929206', 'x');
INSERT INTO `sys_data_region` VALUES (4084, '温泉', 4, '140929', '140929208', 'w');
INSERT INTO `sys_data_region` VALUES (4085, '阳坪', 4, '140929', '140929209', 'y');
INSERT INTO `sys_data_region` VALUES (4086, '大涧', 4, '140929', '140929211', 'd');
INSERT INTO `sys_data_region` VALUES (4087, '河曲', 3, '1409', '140930', 'h');
INSERT INTO `sys_data_region` VALUES (4088, '西口', 4, '140930', '140930100', 'x');
INSERT INTO `sys_data_region` VALUES (4089, '楼子营', 4, '140930', '140930101', 'l');
INSERT INTO `sys_data_region` VALUES (4090, '刘家塔', 4, '140930', '140930102', 'l');
INSERT INTO `sys_data_region` VALUES (4091, '巡镇', 4, '140930', '140930103', 'x');
INSERT INTO `sys_data_region` VALUES (4092, '旧县', 4, '140930', '140930104', 'j');
INSERT INTO `sys_data_region` VALUES (4093, '沙泉', 4, '140930', '140930105', 's');
INSERT INTO `sys_data_region` VALUES (4094, '鹿固', 4, '140930', '140930200', 'l');
INSERT INTO `sys_data_region` VALUES (4095, '单寨', 4, '140930', '140930202', 'd');
INSERT INTO `sys_data_region` VALUES (4096, '土沟', 4, '140930', '140930203', 't');
INSERT INTO `sys_data_region` VALUES (4097, '沙坪', 4, '140930', '140930205', 's');
INSERT INTO `sys_data_region` VALUES (4098, '社梁', 4, '140930', '140930206', 's');
INSERT INTO `sys_data_region` VALUES (4099, '保德', 3, '1409', '140931', 'b');
INSERT INTO `sys_data_region` VALUES (4100, '东关', 4, '140931', '140931100', 'd');
INSERT INTO `sys_data_region` VALUES (4101, '义门', 4, '140931', '140931101', 'y');
INSERT INTO `sys_data_region` VALUES (4102, '桥头', 4, '140931', '140931102', 'q');
INSERT INTO `sys_data_region` VALUES (4103, '杨家湾', 4, '140931', '140931103', 'y');
INSERT INTO `sys_data_region` VALUES (4104, '孙家沟', 4, '140931', '140931105', 's');
INSERT INTO `sys_data_region` VALUES (4105, '腰庄', 4, '140931', '140931200', 'y');
INSERT INTO `sys_data_region` VALUES (4106, '韩家川', 4, '140931', '140931201', 'h');
INSERT INTO `sys_data_region` VALUES (4107, '林遮峪', 4, '140931', '140931202', 'l');
INSERT INTO `sys_data_region` VALUES (4108, '冯家川', 4, '140931', '140931203', 'f');
INSERT INTO `sys_data_region` VALUES (4109, '土崖塔', 4, '140931', '140931204', 't');
INSERT INTO `sys_data_region` VALUES (4110, '南河沟', 4, '140931', '140931208', 'n');
INSERT INTO `sys_data_region` VALUES (4111, '偏关', 3, '1409', '140932', 'p');
INSERT INTO `sys_data_region` VALUES (4112, '新关', 4, '140932', '140932100', 'x');
INSERT INTO `sys_data_region` VALUES (4113, '老营', 4, '140932', '140932102', 'l');
INSERT INTO `sys_data_region` VALUES (4114, '万家寨', 4, '140932', '140932103', 'w');
INSERT INTO `sys_data_region` VALUES (4115, '尚峪', 4, '140932', '140932106', 's');
INSERT INTO `sys_data_region` VALUES (4116, '老牛湾', 4, '140932', '140932108', 'l');
INSERT INTO `sys_data_region` VALUES (4117, '窑头', 4, '140932', '140932200', 'y');
INSERT INTO `sys_data_region` VALUES (4118, '楼沟', 4, '140932', '140932201', 'l');
INSERT INTO `sys_data_region` VALUES (4119, '水泉', 4, '140932', '140932204', 's');
INSERT INTO `sys_data_region` VALUES (4120, '原平', 3, '1409', '140981', 'y');
INSERT INTO `sys_data_region` VALUES (4121, '北城', 4, '140981', '140981001', 'b');
INSERT INTO `sys_data_region` VALUES (4122, '南城', 4, '140981', '140981002', 'n');
INSERT INTO `sys_data_region` VALUES (4123, '新原', 4, '140981', '140981004', 'x');
INSERT INTO `sys_data_region` VALUES (4124, '吉祥', 4, '140981', '140981005', 'j');
INSERT INTO `sys_data_region` VALUES (4125, '苏龙口', 4, '140981', '140981101', 's');
INSERT INTO `sys_data_region` VALUES (4126, '崞阳', 4, '140981', '140981102', 'g');
INSERT INTO `sys_data_region` VALUES (4127, '大牛店', 4, '140981', '140981103', 'd');
INSERT INTO `sys_data_region` VALUES (4128, '阎庄', 4, '140981', '140981104', 'y');
INSERT INTO `sys_data_region` VALUES (4129, '轩岗', 4, '140981', '140981106', 'x');
INSERT INTO `sys_data_region` VALUES (4130, '云水', 4, '140981', '140981107', 'y');
INSERT INTO `sys_data_region` VALUES (4131, '同川', 4, '140981', '140981108', 't');
INSERT INTO `sys_data_region` VALUES (4132, '子干', 4, '140981', '140981202', 'z');
INSERT INTO `sys_data_region` VALUES (4133, '中阳', 4, '140981', '140981203', 'z');
INSERT INTO `sys_data_region` VALUES (4134, '沿沟', 4, '140981', '140981204', 'y');
INSERT INTO `sys_data_region` VALUES (4135, '大林', 4, '140981', '140981205', 'd');
INSERT INTO `sys_data_region` VALUES (4136, '西镇', 4, '140981', '140981206', 'x');
INSERT INTO `sys_data_region` VALUES (4137, '王家庄', 4, '140981', '140981208', 'w');
INSERT INTO `sys_data_region` VALUES (4138, '段家堡', 4, '140981', '140981210', 'd');
INSERT INTO `sys_data_region` VALUES (4139, '临汾', 2, '14', '1410', 'l');
INSERT INTO `sys_data_region` VALUES (4140, '尧都', 3, '1410', '141002', 'y');
INSERT INTO `sys_data_region` VALUES (4141, '解放路', 4, '141002', '141002001', 'j');
INSERT INTO `sys_data_region` VALUES (4142, '鼓楼西', 4, '141002', '141002002', 'g');
INSERT INTO `sys_data_region` VALUES (4143, '水塔', 4, '141002', '141002003', 's');
INSERT INTO `sys_data_region` VALUES (4144, '南街', 4, '141002', '141002004', 'n');
INSERT INTO `sys_data_region` VALUES (4145, '乡贤', 4, '141002', '141002005', 'x');
INSERT INTO `sys_data_region` VALUES (4146, '辛寺', 4, '141002', '141002006', 'x');
INSERT INTO `sys_data_region` VALUES (4147, '路东', 4, '141002', '141002007', 'l');
INSERT INTO `sys_data_region` VALUES (4148, '车站', 4, '141002', '141002008', 'c');
INSERT INTO `sys_data_region` VALUES (4149, '汾河', 4, '141002', '141002009', 'f');
INSERT INTO `sys_data_region` VALUES (4150, '滨河', 4, '141002', '141002010', 'b');
INSERT INTO `sys_data_region` VALUES (4151, '屯里', 4, '141002', '141002100', 't');
INSERT INTO `sys_data_region` VALUES (4152, '乔李', 4, '141002', '141002101', 'q');
INSERT INTO `sys_data_region` VALUES (4153, '大阳', 4, '141002', '141002102', 'd');
INSERT INTO `sys_data_region` VALUES (4154, '县底', 4, '141002', '141002103', 'x');
INSERT INTO `sys_data_region` VALUES (4155, '刘村', 4, '141002', '141002104', 'l');
INSERT INTO `sys_data_region` VALUES (4156, '金殿', 4, '141002', '141002105', 'j');
INSERT INTO `sys_data_region` VALUES (4157, '吴村', 4, '141002', '141002106', 'w');
INSERT INTO `sys_data_region` VALUES (4158, '土门', 4, '141002', '141002107', 't');
INSERT INTO `sys_data_region` VALUES (4159, '魏村', 4, '141002', '141002108', 'w');
INSERT INTO `sys_data_region` VALUES (4160, '尧庙', 4, '141002', '141002109', 'y');
INSERT INTO `sys_data_region` VALUES (4161, '段店', 4, '141002', '141002200', 'd');
INSERT INTO `sys_data_region` VALUES (4162, '贾得', 4, '141002', '141002201', 'j');
INSERT INTO `sys_data_region` VALUES (4163, '一平垣', 4, '141002', '141002203', 'y');
INSERT INTO `sys_data_region` VALUES (4164, '枕头', 4, '141002', '141002204', 'z');
INSERT INTO `sys_data_region` VALUES (4165, '曲沃', 3, '1410', '141021', 'q');
INSERT INTO `sys_data_region` VALUES (4166, '乐昌', 4, '141021', '141021100', 'l');
INSERT INTO `sys_data_region` VALUES (4167, '史村', 4, '141021', '141021101', 's');
INSERT INTO `sys_data_region` VALUES (4168, '曲村', 4, '141021', '141021102', 'q');
INSERT INTO `sys_data_region` VALUES (4169, '高显', 4, '141021', '141021103', 'g');
INSERT INTO `sys_data_region` VALUES (4170, '里村', 4, '141021', '141021104', 'l');
INSERT INTO `sys_data_region` VALUES (4171, '北董', 4, '141021', '141021200', 'b');
INSERT INTO `sys_data_region` VALUES (4172, '杨谈', 4, '141021', '141021201', 'y');
INSERT INTO `sys_data_region` VALUES (4173, '翼城', 3, '1410', '141022', 'y');
INSERT INTO `sys_data_region` VALUES (4174, '唐兴', 4, '141022', '141022100', 't');
INSERT INTO `sys_data_region` VALUES (4175, '南梁', 4, '141022', '141022101', 'n');
INSERT INTO `sys_data_region` VALUES (4176, '里砦', 4, '141022', '141022102', 'l');
INSERT INTO `sys_data_region` VALUES (4177, '隆化', 4, '141022', '141022103', 'l');
INSERT INTO `sys_data_region` VALUES (4178, '桥上', 4, '141022', '141022104', 'q');
INSERT INTO `sys_data_region` VALUES (4179, '西阎', 4, '141022', '141022105', 'x');
INSERT INTO `sys_data_region` VALUES (4180, '王庄', 4, '141022', '141022107', 'w');
INSERT INTO `sys_data_region` VALUES (4181, '中卫', 4, '141022', '141022200', 'z');
INSERT INTO `sys_data_region` VALUES (4182, '南唐', 4, '141022', '141022201', 'n');
INSERT INTO `sys_data_region` VALUES (4183, '襄汾', 3, '1410', '141023', 'x');
INSERT INTO `sys_data_region` VALUES (4184, '新城', 4, '141023', '141023100', 'x');
INSERT INTO `sys_data_region` VALUES (4185, '赵康', 4, '141023', '141023101', 'z');
INSERT INTO `sys_data_region` VALUES (4186, '汾城', 4, '141023', '141023102', 'f');
INSERT INTO `sys_data_region` VALUES (4187, '南贾', 4, '141023', '141023103', 'n');
INSERT INTO `sys_data_region` VALUES (4188, '古城', 4, '141023', '141023104', 'g');
INSERT INTO `sys_data_region` VALUES (4189, '襄陵', 4, '141023', '141023105', 'x');
INSERT INTO `sys_data_region` VALUES (4190, '邓庄', 4, '141023', '141023106', 'd');
INSERT INTO `sys_data_region` VALUES (4191, '陶寺', 4, '141023', '141023200', 't');
INSERT INTO `sys_data_region` VALUES (4192, '永固', 4, '141023', '141023201', 'y');
INSERT INTO `sys_data_region` VALUES (4193, '景毛', 4, '141023', '141023202', 'j');
INSERT INTO `sys_data_region` VALUES (4194, '西贾', 4, '141023', '141023203', 'x');
INSERT INTO `sys_data_region` VALUES (4195, '南辛店', 4, '141023', '141023204', 'n');
INSERT INTO `sys_data_region` VALUES (4196, '大邓', 4, '141023', '141023205', 'd');
INSERT INTO `sys_data_region` VALUES (4197, '洪洞', 3, '1410', '141024', 'h');
INSERT INTO `sys_data_region` VALUES (4198, '大槐树', 4, '141024', '141024100', 'd');
INSERT INTO `sys_data_region` VALUES (4199, '甘亭', 4, '141024', '141024101', 'g');
INSERT INTO `sys_data_region` VALUES (4200, '曲亭', 4, '141024', '141024102', 'q');
INSERT INTO `sys_data_region` VALUES (4201, '苏堡', 4, '141024', '141024103', 's');
INSERT INTO `sys_data_region` VALUES (4202, '广胜寺', 4, '141024', '141024104', 'g');
INSERT INTO `sys_data_region` VALUES (4203, '明姜', 4, '141024', '141024105', 'm');
INSERT INTO `sys_data_region` VALUES (4204, '赵城', 4, '141024', '141024106', 'z');
INSERT INTO `sys_data_region` VALUES (4205, '万安', 4, '141024', '141024107', 'w');
INSERT INTO `sys_data_region` VALUES (4206, '刘家垣', 4, '141024', '141024108', 'l');
INSERT INTO `sys_data_region` VALUES (4207, '辛村', 4, '141024', '141024109', 'x');
INSERT INTO `sys_data_region` VALUES (4208, '淹底', 4, '141024', '141024200', 'y');
INSERT INTO `sys_data_region` VALUES (4209, '兴唐寺', 4, '141024', '141024201', 'x');
INSERT INTO `sys_data_region` VALUES (4210, '堤村', 4, '141024', '141024202', 'd');
INSERT INTO `sys_data_region` VALUES (4211, '龙马', 4, '141024', '141024204', 'l');
INSERT INTO `sys_data_region` VALUES (4212, '山目', 4, '141024', '141024207', 's');
INSERT INTO `sys_data_region` VALUES (4213, '古县', 3, '1410', '141025', 'g');
INSERT INTO `sys_data_region` VALUES (4214, '岳阳', 4, '141025', '141025100', 'y');
INSERT INTO `sys_data_region` VALUES (4215, '北平', 4, '141025', '141025101', 'b');
INSERT INTO `sys_data_region` VALUES (4216, '古阳', 4, '141025', '141025102', 'g');
INSERT INTO `sys_data_region` VALUES (4217, '旧县', 4, '141025', '141025103', 'j');
INSERT INTO `sys_data_region` VALUES (4218, '三合', 4, '141025', '141025104', 's');
INSERT INTO `sys_data_region` VALUES (4219, '南垣', 4, '141025', '141025202', 'n');
INSERT INTO `sys_data_region` VALUES (4220, '安泽', 3, '1410', '141026', 'a');
INSERT INTO `sys_data_region` VALUES (4221, '府城', 4, '141026', '141026100', 'f');
INSERT INTO `sys_data_region` VALUES (4222, '和川', 4, '141026', '141026101', 'h');
INSERT INTO `sys_data_region` VALUES (4223, '唐城', 4, '141026', '141026102', 't');
INSERT INTO `sys_data_region` VALUES (4224, '冀氏', 4, '141026', '141026103', 'j');
INSERT INTO `sys_data_region` VALUES (4225, '良马', 4, '141026', '141026104', 'l');
INSERT INTO `sys_data_region` VALUES (4226, '马壁', 4, '141026', '141026105', 'm');
INSERT INTO `sys_data_region` VALUES (4227, '浮山', 3, '1410', '141027', 'f');
INSERT INTO `sys_data_region` VALUES (4228, '天坛', 4, '141027', '141027100', 't');
INSERT INTO `sys_data_region` VALUES (4229, '响水河', 4, '141027', '141027101', 'x');
INSERT INTO `sys_data_region` VALUES (4230, '北王', 4, '141027', '141027102', 'b');
INSERT INTO `sys_data_region` VALUES (4231, '张庄', 4, '141027', '141027103', 'z');
INSERT INTO `sys_data_region` VALUES (4232, '东张', 4, '141027', '141027201', 'd');
INSERT INTO `sys_data_region` VALUES (4233, '槐埝', 4, '141027', '141027202', 'h');
INSERT INTO `sys_data_region` VALUES (4234, '寨圪塔', 4, '141027', '141027206', 'z');
INSERT INTO `sys_data_region` VALUES (4235, '吉县', 3, '1410', '141028', 'j');
INSERT INTO `sys_data_region` VALUES (4236, '吉昌', 4, '141028', '141028100', 'j');
INSERT INTO `sys_data_region` VALUES (4237, '屯里', 4, '141028', '141028101', 't');
INSERT INTO `sys_data_region` VALUES (4238, '壶口', 4, '141028', '141028102', 'h');
INSERT INTO `sys_data_region` VALUES (4239, '车城', 4, '141028', '141028200', 'c');
INSERT INTO `sys_data_region` VALUES (4240, '文城', 4, '141028', '141028201', 'w');
INSERT INTO `sys_data_region` VALUES (4241, '柏山寺', 4, '141028', '141028203', 'b');
INSERT INTO `sys_data_region` VALUES (4242, '中垛', 4, '141028', '141028204', 'z');
INSERT INTO `sys_data_region` VALUES (4243, '乡宁', 3, '1410', '141029', 'x');
INSERT INTO `sys_data_region` VALUES (4244, '昌宁', 4, '141029', '141029100', 'c');
INSERT INTO `sys_data_region` VALUES (4245, '光华', 4, '141029', '141029101', 'g');
INSERT INTO `sys_data_region` VALUES (4246, '台头', 4, '141029', '141029102', 't');
INSERT INTO `sys_data_region` VALUES (4247, '管头', 4, '141029', '141029103', 'g');
INSERT INTO `sys_data_region` VALUES (4248, '西坡', 4, '141029', '141029104', 'x');
INSERT INTO `sys_data_region` VALUES (4249, '双鹤', 4, '141029', '141029200', 's');
INSERT INTO `sys_data_region` VALUES (4250, '关王庙', 4, '141029', '141029201', 'g');
INSERT INTO `sys_data_region` VALUES (4251, '尉庄', 4, '141029', '141029202', 'w');
INSERT INTO `sys_data_region` VALUES (4252, '西交口', 4, '141029', '141029203', 'x');
INSERT INTO `sys_data_region` VALUES (4253, '枣岭', 4, '141029', '141029204', 'z');
INSERT INTO `sys_data_region` VALUES (4254, '大宁', 3, '1410', '141030', 'd');
INSERT INTO `sys_data_region` VALUES (4255, '昕水', 4, '141030', '141030100', 'x');
INSERT INTO `sys_data_region` VALUES (4256, '曲峨', 4, '141030', '141030101', 'q');
INSERT INTO `sys_data_region` VALUES (4257, '太古', 4, '141030', '141030102', 't');
INSERT INTO `sys_data_region` VALUES (4258, '三多', 4, '141030', '141030200', 's');
INSERT INTO `sys_data_region` VALUES (4259, '太德', 4, '141030', '141030201', 't');
INSERT INTO `sys_data_region` VALUES (4260, '隰县', 3, '1410', '141031', 'x');
INSERT INTO `sys_data_region` VALUES (4261, '龙泉', 4, '141031', '141031100', 'l');
INSERT INTO `sys_data_region` VALUES (4262, '午城', 4, '141031', '141031101', 'w');
INSERT INTO `sys_data_region` VALUES (4263, '黄土', 4, '141031', '141031102', 'h');
INSERT INTO `sys_data_region` VALUES (4264, '阳头升', 4, '141031', '141031200', 'y');
INSERT INTO `sys_data_region` VALUES (4265, '寨子', 4, '141031', '141031201', 'z');
INSERT INTO `sys_data_region` VALUES (4266, '下李', 4, '141031', '141031203', 'x');
INSERT INTO `sys_data_region` VALUES (4267, '城南', 4, '141031', '141031204', 'c');
INSERT INTO `sys_data_region` VALUES (4268, '永和', 3, '1410', '141032', 'y');
INSERT INTO `sys_data_region` VALUES (4269, '芝河', 4, '141032', '141032100', 'z');
INSERT INTO `sys_data_region` VALUES (4270, '桑壁', 4, '141032', '141032101', 's');
INSERT INTO `sys_data_region` VALUES (4271, '坡头', 4, '141032', '141032203', 'p');
INSERT INTO `sys_data_region` VALUES (4272, '望海寺', 4, '141032', '141032205', 'w');
INSERT INTO `sys_data_region` VALUES (4273, '乾坤湾', 4, '141032', '141032206', 'q');
INSERT INTO `sys_data_region` VALUES (4274, '楼山', 4, '141032', '141032207', 'l');
INSERT INTO `sys_data_region` VALUES (4275, '蒲县', 3, '1410', '141033', 'p');
INSERT INTO `sys_data_region` VALUES (4276, '蒲城', 4, '141033', '141033100', 'p');
INSERT INTO `sys_data_region` VALUES (4277, '薛关', 4, '141033', '141033101', 'x');
INSERT INTO `sys_data_region` VALUES (4278, '黑龙关', 4, '141033', '141033102', 'h');
INSERT INTO `sys_data_region` VALUES (4279, '克城', 4, '141033', '141033103', 'k');
INSERT INTO `sys_data_region` VALUES (4280, '乔家湾', 4, '141033', '141033105', 'q');
INSERT INTO `sys_data_region` VALUES (4281, '山中', 4, '141033', '141033200', 's');
INSERT INTO `sys_data_region` VALUES (4282, '古县', 4, '141033', '141033201', 'g');
INSERT INTO `sys_data_region` VALUES (4283, '太林', 4, '141033', '141033204', 't');
INSERT INTO `sys_data_region` VALUES (4284, '汾西', 3, '1410', '141034', 'f');
INSERT INTO `sys_data_region` VALUES (4285, '永安', 4, '141034', '141034100', 'y');
INSERT INTO `sys_data_region` VALUES (4286, '对竹', 4, '141034', '141034101', 'd');
INSERT INTO `sys_data_region` VALUES (4287, '勍香', 4, '141034', '141034102', 'q');
INSERT INTO `sys_data_region` VALUES (4288, '和平', 4, '141034', '141034103', 'h');
INSERT INTO `sys_data_region` VALUES (4289, '僧念', 4, '141034', '141034104', 's');
INSERT INTO `sys_data_region` VALUES (4290, '佃坪', 4, '141034', '141034200', 'd');
INSERT INTO `sys_data_region` VALUES (4291, '团柏', 4, '141034', '141034201', 't');
INSERT INTO `sys_data_region` VALUES (4292, '侯马', 3, '1410', '141081', 'h');
INSERT INTO `sys_data_region` VALUES (4293, '路东', 4, '141081', '141081001', 'l');
INSERT INTO `sys_data_region` VALUES (4294, '路西', 4, '141081', '141081002', 'l');
INSERT INTO `sys_data_region` VALUES (4295, '浍滨', 4, '141081', '141081003', 'k');
INSERT INTO `sys_data_region` VALUES (4296, '上马', 4, '141081', '141081004', 's');
INSERT INTO `sys_data_region` VALUES (4297, '张村', 4, '141081', '141081005', 'z');
INSERT INTO `sys_data_region` VALUES (4298, '新田', 4, '141081', '141081200', 'x');
INSERT INTO `sys_data_region` VALUES (4299, '高村', 4, '141081', '141081201', 'g');
INSERT INTO `sys_data_region` VALUES (4300, '凤城', 4, '141081', '141081202', 'f');
INSERT INTO `sys_data_region` VALUES (4301, '霍州', 3, '1410', '141082', 'h');
INSERT INTO `sys_data_region` VALUES (4302, '鼓楼', 4, '141082', '141082001', 'g');
INSERT INTO `sys_data_region` VALUES (4303, '北环路', 4, '141082', '141082002', 'b');
INSERT INTO `sys_data_region` VALUES (4304, '南环路', 4, '141082', '141082003', 'n');
INSERT INTO `sys_data_region` VALUES (4305, '开元街', 4, '141082', '141082004', 'k');
INSERT INTO `sys_data_region` VALUES (4306, '退沙', 4, '141082', '141082005', 't');
INSERT INTO `sys_data_region` VALUES (4307, '白龙', 4, '141082', '141082100', 'b');
INSERT INTO `sys_data_region` VALUES (4308, '辛置', 4, '141082', '141082101', 'x');
INSERT INTO `sys_data_region` VALUES (4309, '大张', 4, '141082', '141082102', 'd');
INSERT INTO `sys_data_region` VALUES (4310, '李曹', 4, '141082', '141082103', 'l');
INSERT INTO `sys_data_region` VALUES (4311, '陶唐峪', 4, '141082', '141082200', 't');
INSERT INTO `sys_data_region` VALUES (4312, '三教', 4, '141082', '141082201', 's');
INSERT INTO `sys_data_region` VALUES (4313, '师庄', 4, '141082', '141082202', 's');
INSERT INTO `sys_data_region` VALUES (4314, '吕梁', 2, '14', '1411', 'l');
INSERT INTO `sys_data_region` VALUES (4315, '离石', 3, '1411', '141102', 'l');
INSERT INTO `sys_data_region` VALUES (4316, '凤山', 4, '141102', '141102001', 'f');
INSERT INTO `sys_data_region` VALUES (4317, '城北', 4, '141102', '141102002', 'c');
INSERT INTO `sys_data_region` VALUES (4318, '滨河', 4, '141102', '141102003', 'b');
INSERT INTO `sys_data_region` VALUES (4319, '莲花池', 4, '141102', '141102004', 'l');
INSERT INTO `sys_data_region` VALUES (4320, '田家会', 4, '141102', '141102005', 't');
INSERT INTO `sys_data_region` VALUES (4321, '西属巴', 4, '141102', '141102006', 'x');
INSERT INTO `sys_data_region` VALUES (4322, '交口', 4, '141102', '141102007', 'j');
INSERT INTO `sys_data_region` VALUES (4323, '吴城', 4, '141102', '141102100', 'w');
INSERT INTO `sys_data_region` VALUES (4324, '信义', 4, '141102', '141102104', 'x');
INSERT INTO `sys_data_region` VALUES (4325, '枣林', 4, '141102', '141102201', 'z');
INSERT INTO `sys_data_region` VALUES (4326, '坪头', 4, '141102', '141102202', 'p');
INSERT INTO `sys_data_region` VALUES (4327, '文水', 3, '1411', '141121', 'w');
INSERT INTO `sys_data_region` VALUES (4328, '凤城', 4, '141121', '141121100', 'f');
INSERT INTO `sys_data_region` VALUES (4329, '开栅', 4, '141121', '141121101', 'k');
INSERT INTO `sys_data_region` VALUES (4330, '南庄', 4, '141121', '141121102', 'n');
INSERT INTO `sys_data_region` VALUES (4331, '南安', 4, '141121', '141121103', 'n');
INSERT INTO `sys_data_region` VALUES (4332, '刘胡兰', 4, '141121', '141121104', 'l');
INSERT INTO `sys_data_region` VALUES (4333, '下曲', 4, '141121', '141121105', 'x');
INSERT INTO `sys_data_region` VALUES (4334, '孝义', 4, '141121', '141121106', 'x');
INSERT INTO `sys_data_region` VALUES (4335, '南武', 4, '141121', '141121200', 'n');
INSERT INTO `sys_data_region` VALUES (4336, '西城', 4, '141121', '141121201', 'x');
INSERT INTO `sys_data_region` VALUES (4337, '北张', 4, '141121', '141121202', 'b');
INSERT INTO `sys_data_region` VALUES (4338, '马西', 4, '141121', '141121203', 'm');
INSERT INTO `sys_data_region` VALUES (4339, '西槽头', 4, '141121', '141121204', 'x');
INSERT INTO `sys_data_region` VALUES (4340, '交城', 3, '1411', '141122', 'j');
INSERT INTO `sys_data_region` VALUES (4341, '天宁', 4, '141122', '141122100', 't');
INSERT INTO `sys_data_region` VALUES (4342, '夏家营', 4, '141122', '141122101', 'x');
INSERT INTO `sys_data_region` VALUES (4343, '西营', 4, '141122', '141122102', 'x');
INSERT INTO `sys_data_region` VALUES (4344, '水峪贯', 4, '141122', '141122103', 's');
INSERT INTO `sys_data_region` VALUES (4345, '西社', 4, '141122', '141122104', 'x');
INSERT INTO `sys_data_region` VALUES (4346, '庞泉沟', 4, '141122', '141122105', 'p');
INSERT INTO `sys_data_region` VALUES (4347, '洪相', 4, '141122', '141122107', 'h');
INSERT INTO `sys_data_region` VALUES (4348, '东坡底', 4, '141122', '141122202', 'd');
INSERT INTO `sys_data_region` VALUES (4349, '兴县', 3, '1411', '141123', 'x');
INSERT INTO `sys_data_region` VALUES (4350, '蔚汾', 4, '141123', '141123100', 'w');
INSERT INTO `sys_data_region` VALUES (4351, '魏家滩', 4, '141123', '141123101', 'w');
INSERT INTO `sys_data_region` VALUES (4352, '瓦塘', 4, '141123', '141123102', 'w');
INSERT INTO `sys_data_region` VALUES (4353, '康宁', 4, '141123', '141123103', 'k');
INSERT INTO `sys_data_region` VALUES (4354, '高家村', 4, '141123', '141123104', 'g');
INSERT INTO `sys_data_region` VALUES (4355, '罗峪口', 4, '141123', '141123105', 'l');
INSERT INTO `sys_data_region` VALUES (4356, '蔡家会', 4, '141123', '141123106', 'c');
INSERT INTO `sys_data_region` VALUES (4357, '交楼申', 4, '141123', '141123200', 'j');
INSERT INTO `sys_data_region` VALUES (4358, '东会', 4, '141123', '141123202', 'd');
INSERT INTO `sys_data_region` VALUES (4359, '固贤', 4, '141123', '141123203', 'g');
INSERT INTO `sys_data_region` VALUES (4360, '奥家湾', 4, '141123', '141123204', 'a');
INSERT INTO `sys_data_region` VALUES (4361, '蔡家崖', 4, '141123', '141123205', 'c');
INSERT INTO `sys_data_region` VALUES (4362, '孟家坪', 4, '141123', '141123207', 'm');
INSERT INTO `sys_data_region` VALUES (4363, '赵家坪', 4, '141123', '141123208', 'z');
INSERT INTO `sys_data_region` VALUES (4364, '圪垯上', 4, '141123', '141123209', 'g');
INSERT INTO `sys_data_region` VALUES (4365, '临县', 3, '1411', '141124', 'l');
INSERT INTO `sys_data_region` VALUES (4366, '临泉', 4, '141124', '141124100', 'l');
INSERT INTO `sys_data_region` VALUES (4367, '白文', 4, '141124', '141124101', 'b');
INSERT INTO `sys_data_region` VALUES (4368, '城庄', 4, '141124', '141124102', 'c');
INSERT INTO `sys_data_region` VALUES (4369, '兔坂', 4, '141124', '141124103', 't');
INSERT INTO `sys_data_region` VALUES (4370, '克虎', 4, '141124', '141124104', 'k');
INSERT INTO `sys_data_region` VALUES (4371, '三交', 4, '141124', '141124105', 's');
INSERT INTO `sys_data_region` VALUES (4372, '湍水头', 4, '141124', '141124106', 't');
INSERT INTO `sys_data_region` VALUES (4373, '林家坪', 4, '141124', '141124107', 'l');
INSERT INTO `sys_data_region` VALUES (4374, '招贤', 4, '141124', '141124108', 'z');
INSERT INTO `sys_data_region` VALUES (4375, '碛口', 4, '141124', '141124109', 'q');
INSERT INTO `sys_data_region` VALUES (4376, '刘家会', 4, '141124', '141124110', 'l');
INSERT INTO `sys_data_region` VALUES (4377, '丛罗峪', 4, '141124', '141124111', 'c');
INSERT INTO `sys_data_region` VALUES (4378, '曲峪', 4, '141124', '141124112', 'q');
INSERT INTO `sys_data_region` VALUES (4379, '木瓜坪', 4, '141124', '141124200', 'm');
INSERT INTO `sys_data_region` VALUES (4380, '安业', 4, '141124', '141124201', 'a');
INSERT INTO `sys_data_region` VALUES (4381, '玉坪', 4, '141124', '141124202', 'y');
INSERT INTO `sys_data_region` VALUES (4382, '青凉寺', 4, '141124', '141124203', 'q');
INSERT INTO `sys_data_region` VALUES (4383, '石白头', 4, '141124', '141124204', 's');
INSERT INTO `sys_data_region` VALUES (4384, '雷家碛', 4, '141124', '141124205', 'l');
INSERT INTO `sys_data_region` VALUES (4385, '第八堡', 4, '141124', '141124206', 'd');
INSERT INTO `sys_data_region` VALUES (4386, '大禹', 4, '141124', '141124207', 'd');
INSERT INTO `sys_data_region` VALUES (4387, '车赶', 4, '141124', '141124208', 'c');
INSERT INTO `sys_data_region` VALUES (4388, '安家庄', 4, '141124', '141124209', 'a');
INSERT INTO `sys_data_region` VALUES (4389, '柳林', 3, '1411', '141125', 'l');
INSERT INTO `sys_data_region` VALUES (4390, '柳林镇', 4, '141125', '141125100', 'l');
INSERT INTO `sys_data_region` VALUES (4391, '穆村', 4, '141125', '141125101', 'm');
INSERT INTO `sys_data_region` VALUES (4392, '薛村', 4, '141125', '141125102', 'x');
INSERT INTO `sys_data_region` VALUES (4393, '庄上', 4, '141125', '141125103', 'z');
INSERT INTO `sys_data_region` VALUES (4394, '留誉', 4, '141125', '141125104', 'l');
INSERT INTO `sys_data_region` VALUES (4395, '下三交', 4, '141125', '141125105', 'x');
INSERT INTO `sys_data_region` VALUES (4396, '成家庄', 4, '141125', '141125106', 'c');
INSERT INTO `sys_data_region` VALUES (4397, '孟门', 4, '141125', '141125107', 'm');
INSERT INTO `sys_data_region` VALUES (4398, '金家庄', 4, '141125', '141125108', 'j');
INSERT INTO `sys_data_region` VALUES (4399, '陈家湾', 4, '141125', '141125109', 'c');
INSERT INTO `sys_data_region` VALUES (4400, '李家湾', 4, '141125', '141125200', 'l');
INSERT INTO `sys_data_region` VALUES (4401, '贾家垣', 4, '141125', '141125201', 'j');
INSERT INTO `sys_data_region` VALUES (4402, '高家沟', 4, '141125', '141125204', 'g');
INSERT INTO `sys_data_region` VALUES (4403, '石西', 4, '141125', '141125205', 's');
INSERT INTO `sys_data_region` VALUES (4404, '西王家沟', 4, '141125', '141125206', 'x');
INSERT INTO `sys_data_region` VALUES (4405, '石楼', 3, '1411', '141126', 's');
INSERT INTO `sys_data_region` VALUES (4406, '灵泉', 4, '141126', '141126100', 'l');
INSERT INTO `sys_data_region` VALUES (4407, '罗村', 4, '141126', '141126101', 'l');
INSERT INTO `sys_data_region` VALUES (4408, '义牒', 4, '141126', '141126102', 'y');
INSERT INTO `sys_data_region` VALUES (4409, '小蒜', 4, '141126', '141126103', 'x');
INSERT INTO `sys_data_region` VALUES (4410, '辛关', 4, '141126', '141126104', 'x');
INSERT INTO `sys_data_region` VALUES (4411, '龙交', 4, '141126', '141126200', 'l');
INSERT INTO `sys_data_region` VALUES (4412, '和合', 4, '141126', '141126201', 'h');
INSERT INTO `sys_data_region` VALUES (4413, '曹家垣', 4, '141126', '141126203', 'c');
INSERT INTO `sys_data_region` VALUES (4414, '裴沟', 4, '141126', '141126204', 'p');
INSERT INTO `sys_data_region` VALUES (4415, '岚县', 3, '1411', '141127', 'l');
INSERT INTO `sys_data_region` VALUES (4416, '东村', 4, '141127', '141127100', 'd');
INSERT INTO `sys_data_region` VALUES (4417, '岚城', 4, '141127', '141127101', 'l');
INSERT INTO `sys_data_region` VALUES (4418, '普明', 4, '141127', '141127102', 'p');
INSERT INTO `sys_data_region` VALUES (4419, '界河口', 4, '141127', '141127103', 'j');
INSERT INTO `sys_data_region` VALUES (4420, '上明', 4, '141127', '141127201', 's');
INSERT INTO `sys_data_region` VALUES (4421, '王狮', 4, '141127', '141127202', 'w');
INSERT INTO `sys_data_region` VALUES (4422, '梁家庄', 4, '141127', '141127203', 'l');
INSERT INTO `sys_data_region` VALUES (4423, '顺会', 4, '141127', '141127204', 's');
INSERT INTO `sys_data_region` VALUES (4424, '社科', 4, '141127', '141127206', 's');
INSERT INTO `sys_data_region` VALUES (4425, '方山', 3, '1411', '141128', 'f');
INSERT INTO `sys_data_region` VALUES (4426, '圪洞', 4, '141128', '141128100', 'g');
INSERT INTO `sys_data_region` VALUES (4427, '马坊', 4, '141128', '141128101', 'm');
INSERT INTO `sys_data_region` VALUES (4428, '峪口', 4, '141128', '141128102', 'y');
INSERT INTO `sys_data_region` VALUES (4429, '大武', 4, '141128', '141128103', 'd');
INSERT INTO `sys_data_region` VALUES (4430, '北武当', 4, '141128', '141128104', 'b');
INSERT INTO `sys_data_region` VALUES (4431, '积翠', 4, '141128', '141128105', 'j');
INSERT INTO `sys_data_region` VALUES (4432, '中阳', 3, '1411', '141129', 'z');
INSERT INTO `sys_data_region` VALUES (4433, '宁乡', 4, '141129', '141129100', 'n');
INSERT INTO `sys_data_region` VALUES (4434, '金罗', 4, '141129', '141129101', 'j');
INSERT INTO `sys_data_region` VALUES (4435, '枝柯', 4, '141129', '141129102', 'z');
INSERT INTO `sys_data_region` VALUES (4436, '武家庄', 4, '141129', '141129103', 'w');
INSERT INTO `sys_data_region` VALUES (4437, '暖泉', 4, '141129', '141129104', 'n');
INSERT INTO `sys_data_region` VALUES (4438, '下枣林', 4, '141129', '141129201', 'x');
INSERT INTO `sys_data_region` VALUES (4439, '交口', 3, '1411', '141130', 'j');
INSERT INTO `sys_data_region` VALUES (4440, '水头', 4, '141130', '141130100', 's');
INSERT INTO `sys_data_region` VALUES (4441, '康城', 4, '141130', '141130101', 'k');
INSERT INTO `sys_data_region` VALUES (4442, '双池', 4, '141130', '141130102', 's');
INSERT INTO `sys_data_region` VALUES (4443, '桃红坡', 4, '141130', '141130103', 't');
INSERT INTO `sys_data_region` VALUES (4444, '石口', 4, '141130', '141130104', 's');
INSERT INTO `sys_data_region` VALUES (4445, '回龙', 4, '141130', '141130105', 'h');
INSERT INTO `sys_data_region` VALUES (4446, '温泉', 4, '141130', '141130202', 'w');
INSERT INTO `sys_data_region` VALUES (4447, '孝义', 3, '1411', '141181', 'x');
INSERT INTO `sys_data_region` VALUES (4448, '新义', 4, '141181', '141181001', 'x');
INSERT INTO `sys_data_region` VALUES (4449, '中阳楼', 4, '141181', '141181002', 'z');
INSERT INTO `sys_data_region` VALUES (4450, '振兴', 4, '141181', '141181003', 'z');
INSERT INTO `sys_data_region` VALUES (4451, '胜溪湖', 4, '141181', '141181004', 's');
INSERT INTO `sys_data_region` VALUES (4452, '崇文', 4, '141181', '141181005', 'c');
INSERT INTO `sys_data_region` VALUES (4453, '兑镇', 4, '141181', '141181100', 'd');
INSERT INTO `sys_data_region` VALUES (4454, '阳泉曲', 4, '141181', '141181101', 'y');
INSERT INTO `sys_data_region` VALUES (4455, '下堡', 4, '141181', '141181102', 'x');
INSERT INTO `sys_data_region` VALUES (4456, '西辛庄', 4, '141181', '141181103', 'x');
INSERT INTO `sys_data_region` VALUES (4457, '高阳', 4, '141181', '141181104', 'g');
INSERT INTO `sys_data_region` VALUES (4458, '梧桐', 4, '141181', '141181105', 'w');
INSERT INTO `sys_data_region` VALUES (4459, '柱濮', 4, '141181', '141181106', 'z');
INSERT INTO `sys_data_region` VALUES (4460, '大孝堡', 4, '141181', '141181107', 'd');
INSERT INTO `sys_data_region` VALUES (4461, '下栅', 4, '141181', '141181201', 'x');
INSERT INTO `sys_data_region` VALUES (4462, '驿马', 4, '141181', '141181202', 'y');
INSERT INTO `sys_data_region` VALUES (4463, '杜村', 4, '141181', '141181204', 'd');
INSERT INTO `sys_data_region` VALUES (4464, '汾阳', 3, '1411', '141182', 'f');
INSERT INTO `sys_data_region` VALUES (4465, '文峰', 4, '141182', '141182001', 'w');
INSERT INTO `sys_data_region` VALUES (4466, '太和桥', 4, '141182', '141182002', 't');
INSERT INTO `sys_data_region` VALUES (4467, '西河', 4, '141182', '141182003', 'x');
INSERT INTO `sys_data_region` VALUES (4468, '贾家庄', 4, '141182', '141182100', 'j');
INSERT INTO `sys_data_region` VALUES (4469, '杏花村', 4, '141182', '141182101', 'x');
INSERT INTO `sys_data_region` VALUES (4470, '冀村', 4, '141182', '141182102', 'j');
INSERT INTO `sys_data_region` VALUES (4471, '肖家庄', 4, '141182', '141182103', 'x');
INSERT INTO `sys_data_region` VALUES (4472, '演武', 4, '141182', '141182104', 'y');
INSERT INTO `sys_data_region` VALUES (4473, '三泉', 4, '141182', '141182105', 's');
INSERT INTO `sys_data_region` VALUES (4474, '石庄', 4, '141182', '141182106', 's');
INSERT INTO `sys_data_region` VALUES (4475, '杨家庄', 4, '141182', '141182107', 'y');
INSERT INTO `sys_data_region` VALUES (4476, '峪道河', 4, '141182', '141182108', 'y');
INSERT INTO `sys_data_region` VALUES (4477, '栗家庄', 4, '141182', '141182109', 'l');
INSERT INTO `sys_data_region` VALUES (4478, '阳城', 4, '141182', '141182110', 'y');
INSERT INTO `sys_data_region` VALUES (4479, '内蒙古', 1, '0', '15', 'n');
INSERT INTO `sys_data_region` VALUES (4480, '呼和浩特', 2, '15', '1501', 'h');
INSERT INTO `sys_data_region` VALUES (4481, '新城', 3, '1501', '150102', 'x');
INSERT INTO `sys_data_region` VALUES (4482, '锡林路', 4, '150102', '150102002', 'x');
INSERT INTO `sys_data_region` VALUES (4483, '中山东路', 4, '150102', '150102003', 'z');
INSERT INTO `sys_data_region` VALUES (4484, '东街', 4, '150102', '150102004', 'd');
INSERT INTO `sys_data_region` VALUES (4485, '西街', 4, '150102', '150102005', 'x');
INSERT INTO `sys_data_region` VALUES (4486, '东风路', 4, '150102', '150102006', 'd');
INSERT INTO `sys_data_region` VALUES (4487, '迎新路', 4, '150102', '150102007', 'y');
INSERT INTO `sys_data_region` VALUES (4488, '成吉思汗大街', 4, '150102', '150102008', 'c');
INSERT INTO `sys_data_region` VALUES (4489, '保合少', 4, '150102', '150102101', 'b');
INSERT INTO `sys_data_region` VALUES (4490, '回民', 3, '1501', '150103', 'h');
INSERT INTO `sys_data_region` VALUES (4491, '新华西路', 4, '150103', '150103001', 'x');
INSERT INTO `sys_data_region` VALUES (4492, '中山西路', 4, '150103', '150103002', 'z');
INSERT INTO `sys_data_region` VALUES (4493, '光明路', 4, '150103', '150103003', 'g');
INSERT INTO `sys_data_region` VALUES (4494, '海拉尔西路', 4, '150103', '150103004', 'h');
INSERT INTO `sys_data_region` VALUES (4495, '环河路', 4, '150103', '150103005', 'h');
INSERT INTO `sys_data_region` VALUES (4496, '通道街', 4, '150103', '150103006', 't');
INSERT INTO `sys_data_region` VALUES (4497, '钢铁路', 4, '150103', '150103007', 'g');
INSERT INTO `sys_data_region` VALUES (4498, '攸攸板', 4, '150103', '150103100', 'y');
INSERT INTO `sys_data_region` VALUES (4499, '玉泉', 3, '1501', '150104', 'y');
INSERT INTO `sys_data_region` VALUES (4500, '大南街', 4, '150104', '150104001', 'd');
INSERT INTO `sys_data_region` VALUES (4501, '小召前街', 4, '150104', '150104002', 'x');
INSERT INTO `sys_data_region` VALUES (4502, '鄂尔多斯路', 4, '150104', '150104003', 'e');
INSERT INTO `sys_data_region` VALUES (4503, '兴隆巷', 4, '150104', '150104004', 'x');
INSERT INTO `sys_data_region` VALUES (4504, '长和廊', 4, '150104', '150104005', 'c');
INSERT INTO `sys_data_region` VALUES (4505, '石东路', 4, '150104', '150104006', 's');
INSERT INTO `sys_data_region` VALUES (4506, '西菜园', 4, '150104', '150104007', 'x');
INSERT INTO `sys_data_region` VALUES (4507, '昭君路', 4, '150104', '150104009', 'z');
INSERT INTO `sys_data_region` VALUES (4508, '小黑河', 4, '150104', '150104100', 'x');
INSERT INTO `sys_data_region` VALUES (4509, '赛罕', 3, '1501', '150105', 's');
INSERT INTO `sys_data_region` VALUES (4510, '人民路', 4, '150105', '150105001', 'r');
INSERT INTO `sys_data_region` VALUES (4511, '大学西路', 4, '150105', '150105002', 'd');
INSERT INTO `sys_data_region` VALUES (4512, '乌兰察布东路', 4, '150105', '150105003', 'w');
INSERT INTO `sys_data_region` VALUES (4513, '大学东路', 4, '150105', '150105004', 'd');
INSERT INTO `sys_data_region` VALUES (4514, '中专路', 4, '150105', '150105005', 'z');
INSERT INTO `sys_data_region` VALUES (4515, '昭乌达路', 4, '150105', '150105006', 'z');
INSERT INTO `sys_data_region` VALUES (4516, '巴彦', 4, '150105', '150105007', 'b');
INSERT INTO `sys_data_region` VALUES (4517, '敕勒川路', 4, '150105', '150105008', 'c');
INSERT INTO `sys_data_region` VALUES (4518, '榆林', 4, '150105', '150105101', 'y');
INSERT INTO `sys_data_region` VALUES (4519, '黄合少', 4, '150105', '150105103', 'h');
INSERT INTO `sys_data_region` VALUES (4520, '金河', 4, '150105', '150105104', 'j');
INSERT INTO `sys_data_region` VALUES (4521, '如意开发区', 4, '150105', '150105401', 'r');
INSERT INTO `sys_data_region` VALUES (4522, '土默特左旗', 3, '1501', '150121', 't');
INSERT INTO `sys_data_region` VALUES (4523, '察素齐', 4, '150121', '150121100', 'c');
INSERT INTO `sys_data_region` VALUES (4524, '毕克齐', 4, '150121', '150121101', 'b');
INSERT INTO `sys_data_region` VALUES (4525, '善岱', 4, '150121', '150121102', 's');
INSERT INTO `sys_data_region` VALUES (4526, '白庙子', 4, '150121', '150121103', 'b');
INSERT INTO `sys_data_region` VALUES (4527, '台阁牧', 4, '150121', '150121104', 't');
INSERT INTO `sys_data_region` VALUES (4528, '沙尔沁', 4, '150121', '150121105', 's');
INSERT INTO `sys_data_region` VALUES (4529, '敕勒川', 4, '150121', '150121106', 'c');
INSERT INTO `sys_data_region` VALUES (4530, '北什轴', 4, '150121', '150121207', 'b');
INSERT INTO `sys_data_region` VALUES (4531, '塔布赛', 4, '150121', '150121208', 't');
INSERT INTO `sys_data_region` VALUES (4532, '托克托', 3, '1501', '150122', 't');
INSERT INTO `sys_data_region` VALUES (4533, '双河', 4, '150122', '150122100', 's');
INSERT INTO `sys_data_region` VALUES (4534, '新营子', 4, '150122', '150122101', 'x');
INSERT INTO `sys_data_region` VALUES (4535, '五申', 4, '150122', '150122102', 'w');
INSERT INTO `sys_data_region` VALUES (4536, '古城', 4, '150122', '150122103', 'g');
INSERT INTO `sys_data_region` VALUES (4537, '伍什家', 4, '150122', '150122104', 'w');
INSERT INTO `sys_data_region` VALUES (4538, '和林格尔', 3, '1501', '150123', 'h');
INSERT INTO `sys_data_region` VALUES (4539, '城关', 4, '150123', '150123100', 'c');
INSERT INTO `sys_data_region` VALUES (4540, '盛乐', 4, '150123', '150123101', 's');
INSERT INTO `sys_data_region` VALUES (4541, '新店子', 4, '150123', '150123102', 'x');
INSERT INTO `sys_data_region` VALUES (4542, '巧什营', 4, '150123', '150123103', 'q');
INSERT INTO `sys_data_region` VALUES (4543, '舍必崖', 4, '150123', '150123203', 's');
INSERT INTO `sys_data_region` VALUES (4544, '大红城', 4, '150123', '150123205', 'd');
INSERT INTO `sys_data_region` VALUES (4545, '羊群沟', 4, '150123', '150123206', 'y');
INSERT INTO `sys_data_region` VALUES (4546, '黑老夭', 4, '150123', '150123207', 'h');
INSERT INTO `sys_data_region` VALUES (4547, '清水河', 3, '1501', '150124', 'q');
INSERT INTO `sys_data_region` VALUES (4548, '喇嘛湾', 4, '150124', '150124100', 'l');
INSERT INTO `sys_data_region` VALUES (4549, '城关', 4, '150124', '150124101', 'c');
INSERT INTO `sys_data_region` VALUES (4550, '宏河', 4, '150124', '150124102', 'h');
INSERT INTO `sys_data_region` VALUES (4551, '老牛湾', 4, '150124', '150124103', 'l');
INSERT INTO `sys_data_region` VALUES (4552, '窑沟', 4, '150124', '150124201', 'y');
INSERT INTO `sys_data_region` VALUES (4553, '北堡', 4, '150124', '150124203', 'b');
INSERT INTO `sys_data_region` VALUES (4554, '韭菜庄', 4, '150124', '150124208', 'j');
INSERT INTO `sys_data_region` VALUES (4555, '五良太', 4, '150124', '150124209', 'w');
INSERT INTO `sys_data_region` VALUES (4556, '武川', 3, '1501', '150125', 'w');
INSERT INTO `sys_data_region` VALUES (4557, '可可以力更', 4, '150125', '150125100', 'k');
INSERT INTO `sys_data_region` VALUES (4558, '哈乐', 4, '150125', '150125101', 'h');
INSERT INTO `sys_data_region` VALUES (4559, '西乌兰不浪', 4, '150125', '150125102', 'x');
INSERT INTO `sys_data_region` VALUES (4560, '大青山', 4, '150125', '150125200', 'd');
INSERT INTO `sys_data_region` VALUES (4561, '德胜沟', 4, '150125', '150125204', 'd');
INSERT INTO `sys_data_region` VALUES (4562, '上秃亥', 4, '150125', '150125205', 's');
INSERT INTO `sys_data_region` VALUES (4563, '哈拉合少', 4, '150125', '150125213', 'h');
INSERT INTO `sys_data_region` VALUES (4564, '二份子', 4, '150125', '150125214', 'e');
INSERT INTO `sys_data_region` VALUES (4565, '耗赖山', 4, '150125', '150125215', 'h');
INSERT INTO `sys_data_region` VALUES (4566, '武川金三角开发区', 4, '150125', '150125403', 'w');
INSERT INTO `sys_data_region` VALUES (4567, '包头', 2, '15', '1502', 'b');
INSERT INTO `sys_data_region` VALUES (4568, '东河', 3, '1502', '150202', 'd');
INSERT INTO `sys_data_region` VALUES (4569, '和平路', 4, '150202', '150202001', 'h');
INSERT INTO `sys_data_region` VALUES (4570, '财神庙', 4, '150202', '150202002', 'c');
INSERT INTO `sys_data_region` VALUES (4571, '西脑包', 4, '150202', '150202003', 'x');
INSERT INTO `sys_data_region` VALUES (4572, '南门外', 4, '150202', '150202004', 'n');
INSERT INTO `sys_data_region` VALUES (4573, '南圪洞', 4, '150202', '150202005', 'n');
INSERT INTO `sys_data_region` VALUES (4574, '东站', 4, '150202', '150202006', 'd');
INSERT INTO `sys_data_region` VALUES (4575, '回民', 4, '150202', '150202007', 'h');
INSERT INTO `sys_data_region` VALUES (4576, '二里半', 4, '150202', '150202008', 'e');
INSERT INTO `sys_data_region` VALUES (4577, '河东街道', 4, '150202', '150202009', 'h');
INSERT INTO `sys_data_region` VALUES (4578, '铁西', 4, '150202', '150202010', 't');
INSERT INTO `sys_data_region` VALUES (4579, '东兴', 4, '150202', '150202011', 'd');
INSERT INTO `sys_data_region` VALUES (4580, '杨圪塄', 4, '150202', '150202012', 'y');
INSERT INTO `sys_data_region` VALUES (4581, '河东镇', 4, '150202', '150202100', 'h');
INSERT INTO `sys_data_region` VALUES (4582, '沙尔沁', 4, '150202', '150202101', 's');
INSERT INTO `sys_data_region` VALUES (4583, '昆都仑', 3, '1502', '150203', 'k');
INSERT INTO `sys_data_region` VALUES (4584, '少先路', 4, '150203', '150203001', 's');
INSERT INTO `sys_data_region` VALUES (4585, '昆北', 4, '150203', '150203002', 'k');
INSERT INTO `sys_data_region` VALUES (4586, '沼潭', 4, '150203', '150203003', 'z');
INSERT INTO `sys_data_region` VALUES (4587, '林荫路', 4, '150203', '150203004', 'l');
INSERT INTO `sys_data_region` VALUES (4588, '友谊大街', 4, '150203', '150203005', 'y');
INSERT INTO `sys_data_region` VALUES (4589, '阿尔丁大街', 4, '150203', '150203006', 'a');
INSERT INTO `sys_data_region` VALUES (4590, '团结大街', 4, '150203', '150203007', 't');
INSERT INTO `sys_data_region` VALUES (4591, '鞍山道', 4, '150203', '150203008', 'a');
INSERT INTO `sys_data_region` VALUES (4592, '前进道', 4, '150203', '150203009', 'q');
INSERT INTO `sys_data_region` VALUES (4593, '市府东路', 4, '150203', '150203010', 's');
INSERT INTO `sys_data_region` VALUES (4594, '白云路', 4, '150203', '150203011', 'b');
INSERT INTO `sys_data_region` VALUES (4595, '黄河西路', 4, '150203', '150203012', 'h');
INSERT INTO `sys_data_region` VALUES (4596, '昆工路', 4, '150203', '150203013', 'k');
INSERT INTO `sys_data_region` VALUES (4597, '昆河', 4, '150203', '150203100', 'k');
INSERT INTO `sys_data_region` VALUES (4598, '卜尔汉图', 4, '150203', '150203101', 'b');
INSERT INTO `sys_data_region` VALUES (4599, '包钢厂区', 4, '150203', '150203400', 'b');
INSERT INTO `sys_data_region` VALUES (4600, '青山', 3, '1502', '150204', 'q');
INSERT INTO `sys_data_region` VALUES (4601, '先锋道', 4, '150204', '150204001', 'x');
INSERT INTO `sys_data_region` VALUES (4602, '幸福路', 4, '150204', '150204002', 'x');
INSERT INTO `sys_data_region` VALUES (4603, '万青路', 4, '150204', '150204003', 'w');
INSERT INTO `sys_data_region` VALUES (4604, '富强路', 4, '150204', '150204004', 'f');
INSERT INTO `sys_data_region` VALUES (4605, '科学路', 4, '150204', '150204005', 'k');
INSERT INTO `sys_data_region` VALUES (4606, '青山路', 4, '150204', '150204006', 'q');
INSERT INTO `sys_data_region` VALUES (4607, '自由路', 4, '150204', '150204007', 'z');
INSERT INTO `sys_data_region` VALUES (4608, '乌素图', 4, '150204', '150204008', 'w');
INSERT INTO `sys_data_region` VALUES (4609, '青福', 4, '150204', '150204100', 'q');
INSERT INTO `sys_data_region` VALUES (4610, '兴胜', 4, '150204', '150204101', 'x');
INSERT INTO `sys_data_region` VALUES (4611, '石拐', 3, '1502', '150205', 's');
INSERT INTO `sys_data_region` VALUES (4612, '石拐街道', 4, '150205', '150205001', 's');
INSERT INTO `sys_data_region` VALUES (4613, '大发', 4, '150205', '150205002', 'd');
INSERT INTO `sys_data_region` VALUES (4614, '大磁', 4, '150205', '150205003', 'd');
INSERT INTO `sys_data_region` VALUES (4615, '五当沟', 4, '150205', '150205004', 'w');
INSERT INTO `sys_data_region` VALUES (4616, '白狐沟', 4, '150205', '150205005', 'b');
INSERT INTO `sys_data_region` VALUES (4617, '大德恒', 4, '150205', '150205006', 'd');
INSERT INTO `sys_data_region` VALUES (4618, '五当召', 4, '150205', '150205100', 'w');
INSERT INTO `sys_data_region` VALUES (4619, '吉忽伦图苏木', 4, '150205', '150205200', 'j');
INSERT INTO `sys_data_region` VALUES (4620, '工业园区管理委员会', 4, '150205', '150205400', 'g');
INSERT INTO `sys_data_region` VALUES (4621, '白云鄂博矿区', 3, '1502', '150206', 'b');
INSERT INTO `sys_data_region` VALUES (4622, '矿山路', 4, '150206', '150206001', 'k');
INSERT INTO `sys_data_region` VALUES (4623, '通阳道', 4, '150206', '150206002', 't');
INSERT INTO `sys_data_region` VALUES (4624, '九原', 3, '1502', '150207', 'j');
INSERT INTO `sys_data_region` VALUES (4625, '沙河', 4, '150207', '150207001', 's');
INSERT INTO `sys_data_region` VALUES (4626, '赛汗', 4, '150207', '150207002', 's');
INSERT INTO `sys_data_region` VALUES (4627, '萨如拉', 4, '150207', '150207003', 's');
INSERT INTO `sys_data_region` VALUES (4628, '白音席勒', 4, '150207', '150207004', 'b');
INSERT INTO `sys_data_region` VALUES (4629, '稀土路', 4, '150207', '150207005', 'x');
INSERT INTO `sys_data_region` VALUES (4630, '麻池', 4, '150207', '150207103', 'm');
INSERT INTO `sys_data_region` VALUES (4631, '哈业胡同', 4, '150207', '150207104', 'h');
INSERT INTO `sys_data_region` VALUES (4632, '哈林格尔', 4, '150207', '150207105', 'h');
INSERT INTO `sys_data_region` VALUES (4633, '万水泉', 4, '150207', '150207106', 'w');
INSERT INTO `sys_data_region` VALUES (4634, '阿嘎如泰苏木', 4, '150207', '150207205', 'a');
INSERT INTO `sys_data_region` VALUES (4635, '土默特右旗', 3, '1502', '150221', 't');
INSERT INTO `sys_data_region` VALUES (4636, '萨拉齐', 4, '150221', '150221100', 's');
INSERT INTO `sys_data_region` VALUES (4637, '双龙', 4, '150221', '150221101', 's');
INSERT INTO `sys_data_region` VALUES (4638, '美岱召', 4, '150221', '150221102', 'm');
INSERT INTO `sys_data_region` VALUES (4639, '沟门', 4, '150221', '150221103', 'g');
INSERT INTO `sys_data_region` VALUES (4640, '将军尧', 4, '150221', '150221104', 'j');
INSERT INTO `sys_data_region` VALUES (4641, '明沙淖', 4, '150221', '150221202', 'm');
INSERT INTO `sys_data_region` VALUES (4642, '海子', 4, '150221', '150221203', 'h');
INSERT INTO `sys_data_region` VALUES (4643, '苏波盖', 4, '150221', '150221212', 's');
INSERT INTO `sys_data_region` VALUES (4644, '九峰山生态管理委员会', 4, '150221', '150221500', 'j');
INSERT INTO `sys_data_region` VALUES (4645, '固阳', 3, '1502', '150222', 'g');
INSERT INTO `sys_data_region` VALUES (4646, '金山', 4, '150222', '150222100', 'j');
INSERT INTO `sys_data_region` VALUES (4647, '西斗铺', 4, '150222', '150222101', 'x');
INSERT INTO `sys_data_region` VALUES (4648, '下湿壕', 4, '150222', '150222102', 'x');
INSERT INTO `sys_data_region` VALUES (4649, '银号', 4, '150222', '150222103', 'y');
INSERT INTO `sys_data_region` VALUES (4650, '怀朔', 4, '150222', '150222104', 'h');
INSERT INTO `sys_data_region` VALUES (4651, '兴顺西', 4, '150222', '150222105', 'x');
INSERT INTO `sys_data_region` VALUES (4652, '达尔罕茂明安联合旗', 3, '1502', '150223', 'd');
INSERT INTO `sys_data_region` VALUES (4653, '百灵庙', 4, '150223', '150223100', 'b');
INSERT INTO `sys_data_region` VALUES (4654, '满都拉', 4, '150223', '150223101', 'm');
INSERT INTO `sys_data_region` VALUES (4655, '希拉穆仁', 4, '150223', '150223102', 'x');
INSERT INTO `sys_data_region` VALUES (4656, '明安', 4, '150223', '150223103', 'm');
INSERT INTO `sys_data_region` VALUES (4657, '巴音花', 4, '150223', '150223104', 'b');
INSERT INTO `sys_data_region` VALUES (4658, '石宝', 4, '150223', '150223105', 's');
INSERT INTO `sys_data_region` VALUES (4659, '乌克忽洞', 4, '150223', '150223106', 'w');
INSERT INTO `sys_data_region` VALUES (4660, '达尔汗苏木', 4, '150223', '150223216', 'd');
INSERT INTO `sys_data_region` VALUES (4661, '巴音敖包苏木', 4, '150223', '150223217', 'b');
INSERT INTO `sys_data_region` VALUES (4662, '查干哈达苏木', 4, '150223', '150223218', 'c');
INSERT INTO `sys_data_region` VALUES (4663, '西河', 4, '150223', '150223219', 'x');
INSERT INTO `sys_data_region` VALUES (4664, '小文公', 4, '150223', '150223220', 'x');
INSERT INTO `sys_data_region` VALUES (4665, '乌海', 2, '15', '1503', 'w');
INSERT INTO `sys_data_region` VALUES (4666, '海勃湾', 3, '1503', '150302', 'h');
INSERT INTO `sys_data_region` VALUES (4667, '新华', 4, '150302', '150302001', 'x');
INSERT INTO `sys_data_region` VALUES (4668, '新华西', 4, '150302', '150302002', 'x');
INSERT INTO `sys_data_region` VALUES (4669, '凤凰岭', 4, '150302', '150302003', 'f');
INSERT INTO `sys_data_region` VALUES (4670, '海北', 4, '150302', '150302004', 'h');
INSERT INTO `sys_data_region` VALUES (4671, '滨河', 4, '150302', '150302005', 'b');
INSERT INTO `sys_data_region` VALUES (4672, '卡布其', 4, '150302', '150302006', 'k');
INSERT INTO `sys_data_region` VALUES (4673, '千里山', 4, '150302', '150302108', 'q');
INSERT INTO `sys_data_region` VALUES (4674, '海勃湾千里山工业园区', 4, '150302', '150302400', 'h');
INSERT INTO `sys_data_region` VALUES (4675, '海南', 3, '1503', '150303', 'h');
INSERT INTO `sys_data_region` VALUES (4676, '西卓子山', 4, '150303', '150303001', 'x');
INSERT INTO `sys_data_region` VALUES (4677, '拉僧仲', 4, '150303', '150303002', 'l');
INSERT INTO `sys_data_region` VALUES (4678, '拉僧庙', 4, '150303', '150303101', 'l');
INSERT INTO `sys_data_region` VALUES (4679, '公乌素', 4, '150303', '150303102', 'g');
INSERT INTO `sys_data_region` VALUES (4680, '巴音陶亥', 4, '150303', '150303103', 'b');
INSERT INTO `sys_data_region` VALUES (4681, '乌达', 3, '1503', '150304', 'w');
INSERT INTO `sys_data_region` VALUES (4682, '巴音赛', 4, '150304', '150304001', 'b');
INSERT INTO `sys_data_region` VALUES (4683, '三道坎', 4, '150304', '150304002', 's');
INSERT INTO `sys_data_region` VALUES (4684, '五虎山', 4, '150304', '150304003', 'w');
INSERT INTO `sys_data_region` VALUES (4685, '梁家沟', 4, '150304', '150304004', 'l');
INSERT INTO `sys_data_region` VALUES (4686, '新达', 4, '150304', '150304005', 'x');
INSERT INTO `sys_data_region` VALUES (4687, '滨海', 4, '150304', '150304006', 'b');
INSERT INTO `sys_data_region` VALUES (4688, '苏海图', 4, '150304', '150304007', 's');
INSERT INTO `sys_data_region` VALUES (4689, '乌兰淖尔', 4, '150304', '150304100', 'w');
INSERT INTO `sys_data_region` VALUES (4690, '乌达经济开发区', 4, '150304', '150304400', 'w');
INSERT INTO `sys_data_region` VALUES (4691, '赤峰', 2, '15', '1504', 'c');
INSERT INTO `sys_data_region` VALUES (4692, '红山', 3, '1504', '150402', 'h');
INSERT INTO `sys_data_region` VALUES (4693, '西屯', 4, '150402', '150402001', 'x');
INSERT INTO `sys_data_region` VALUES (4694, '三中街', 4, '150402', '150402002', 's');
INSERT INTO `sys_data_region` VALUES (4695, '永巨', 4, '150402', '150402003', 'y');
INSERT INTO `sys_data_region` VALUES (4696, '东城', 4, '150402', '150402004', 'd');
INSERT INTO `sys_data_region` VALUES (4697, '南新街', 4, '150402', '150402005', 'n');
INSERT INTO `sys_data_region` VALUES (4698, '站前', 4, '150402', '150402006', 'z');
INSERT INTO `sys_data_region` VALUES (4699, '铁南', 4, '150402', '150402007', 't');
INSERT INTO `sys_data_region` VALUES (4700, '长青', 4, '150402', '150402008', 'c');
INSERT INTO `sys_data_region` VALUES (4701, '哈达', 4, '150402', '150402009', 'h');
INSERT INTO `sys_data_region` VALUES (4702, '西城', 4, '150402', '150402010', 'x');
INSERT INTO `sys_data_region` VALUES (4703, '桥北', 4, '150402', '150402011', 'q');
INSERT INTO `sys_data_region` VALUES (4704, '红庙子', 4, '150402', '150402100', 'h');
INSERT INTO `sys_data_region` VALUES (4705, '文钟', 4, '150402', '150402102', 'w');
INSERT INTO `sys_data_region` VALUES (4706, '红山工业园区', 4, '150402', '150402400', 'h');
INSERT INTO `sys_data_region` VALUES (4707, '红山物流园区', 4, '150402', '150402401', 'h');
INSERT INTO `sys_data_region` VALUES (4708, '红山区农畜产品加工产业园区', 4, '150402', '150402402', 'h');
INSERT INTO `sys_data_region` VALUES (4709, '元宝山', 3, '1504', '150403', 'y');
INSERT INTO `sys_data_region` VALUES (4710, '西露天', 4, '150403', '150403001', 'x');
INSERT INTO `sys_data_region` VALUES (4711, '平庄城区', 4, '150403', '150403002', 'p');
INSERT INTO `sys_data_region` VALUES (4712, '平庄东城', 4, '150403', '150403003', 'p');
INSERT INTO `sys_data_region` VALUES (4713, '平庄西城', 4, '150403', '150403004', 'p');
INSERT INTO `sys_data_region` VALUES (4714, '云杉路', 4, '150403', '150403005', 'y');
INSERT INTO `sys_data_region` VALUES (4715, '马林', 4, '150403', '150403006', 'm');
INSERT INTO `sys_data_region` VALUES (4716, '风水沟', 4, '150403', '150403100', 'f');
INSERT INTO `sys_data_region` VALUES (4717, '元宝山镇', 4, '150403', '150403101', 'y');
INSERT INTO `sys_data_region` VALUES (4718, '美丽河', 4, '150403', '150403102', 'm');
INSERT INTO `sys_data_region` VALUES (4719, '平庄', 4, '150403', '150403103', 'p');
INSERT INTO `sys_data_region` VALUES (4720, '五家', 4, '150403', '150403104', 'w');
INSERT INTO `sys_data_region` VALUES (4721, '小五家', 4, '150403', '150403201', 'x');
INSERT INTO `sys_data_region` VALUES (4722, '赤峰市资源型经济转型开发试验区', 4, '150403', '150403400', 'c');
INSERT INTO `sys_data_region` VALUES (4723, '松山', 3, '1504', '150404', 's');
INSERT INTO `sys_data_region` VALUES (4724, '振兴', 4, '150404', '150404001', 'z');
INSERT INTO `sys_data_region` VALUES (4725, '向阳', 4, '150404', '150404002', 'x');
INSERT INTO `sys_data_region` VALUES (4726, '松州', 4, '150404', '150404003', 's');
INSERT INTO `sys_data_region` VALUES (4727, '铁东', 4, '150404', '150404004', 't');
INSERT INTO `sys_data_region` VALUES (4728, '穆家营子', 4, '150404', '150404100', 'm');
INSERT INTO `sys_data_region` VALUES (4729, '初头朗', 4, '150404', '150404101', 'c');
INSERT INTO `sys_data_region` VALUES (4730, '大庙', 4, '150404', '150404102', 'd');
INSERT INTO `sys_data_region` VALUES (4731, '王府', 4, '150404', '150404103', 'w');
INSERT INTO `sys_data_region` VALUES (4732, '老府', 4, '150404', '150404104', 'l');
INSERT INTO `sys_data_region` VALUES (4733, '哈拉道口', 4, '150404', '150404105', 'h');
INSERT INTO `sys_data_region` VALUES (4734, '上官地', 4, '150404', '150404106', 's');
INSERT INTO `sys_data_region` VALUES (4735, '安庆', 4, '150404', '150404107', 'a');
INSERT INTO `sys_data_region` VALUES (4736, '太平地', 4, '150404', '150404108', 't');
INSERT INTO `sys_data_region` VALUES (4737, '当铺地', 4, '150404', '150404200', 'd');
INSERT INTO `sys_data_region` VALUES (4738, '夏家店', 4, '150404', '150404201', 'x');
INSERT INTO `sys_data_region` VALUES (4739, '城子', 4, '150404', '150404202', 'c');
INSERT INTO `sys_data_region` VALUES (4740, '大夫营子', 4, '150404', '150404203', 'd');
INSERT INTO `sys_data_region` VALUES (4741, '岗子', 4, '150404', '150404204', 'g');
INSERT INTO `sys_data_region` VALUES (4742, '玉龙', 4, '150404', '150404400', 'y');
INSERT INTO `sys_data_region` VALUES (4743, '全宁', 4, '150404', '150404401', 'q');
INSERT INTO `sys_data_region` VALUES (4744, '兴安', 4, '150404', '150404407', 'x');
INSERT INTO `sys_data_region` VALUES (4745, '阿鲁科尔沁旗', 3, '1504', '150421', 'a');
INSERT INTO `sys_data_region` VALUES (4746, '天山', 4, '150421', '150421100', 't');
INSERT INTO `sys_data_region` VALUES (4747, '天山口', 4, '150421', '150421101', 't');
INSERT INTO `sys_data_region` VALUES (4748, '双胜', 4, '150421', '150421102', 's');
INSERT INTO `sys_data_region` VALUES (4749, '坤都', 4, '150421', '150421103', 'k');
INSERT INTO `sys_data_region` VALUES (4750, '巴彦花', 4, '150421', '150421104', 'b');
INSERT INTO `sys_data_region` VALUES (4751, '绍根', 4, '150421', '150421105', 's');
INSERT INTO `sys_data_region` VALUES (4752, '扎嘎斯台', 4, '150421', '150421106', 'z');
INSERT INTO `sys_data_region` VALUES (4753, '新民', 4, '150421', '150421200', 'x');
INSERT INTO `sys_data_region` VALUES (4754, '先锋', 4, '150421', '150421201', 'x');
INSERT INTO `sys_data_region` VALUES (4755, '罕苏木苏木', 4, '150421', '150421202', 'h');
INSERT INTO `sys_data_region` VALUES (4756, '赛汉塔拉苏木', 4, '150421', '150421203', 's');
INSERT INTO `sys_data_region` VALUES (4757, '巴拉奇如德苏木', 4, '150421', '150421204', 'b');
INSERT INTO `sys_data_region` VALUES (4758, '巴彦温都尔苏木', 4, '150421', '150421205', 'b');
INSERT INTO `sys_data_region` VALUES (4759, '乌兰哈达', 4, '150421', '150421206', 'w');
INSERT INTO `sys_data_region` VALUES (4760, '巴林左旗', 3, '1504', '150422', 'b');
INSERT INTO `sys_data_region` VALUES (4761, '林东', 4, '150422', '150422100', 'l');
INSERT INTO `sys_data_region` VALUES (4762, '隆昌', 4, '150422', '150422101', 'l');
INSERT INTO `sys_data_region` VALUES (4763, '十三敖包', 4, '150422', '150422102', 's');
INSERT INTO `sys_data_region` VALUES (4764, '碧流台', 4, '150422', '150422103', 'b');
INSERT INTO `sys_data_region` VALUES (4765, '富河', 4, '150422', '150422104', 'f');
INSERT INTO `sys_data_region` VALUES (4766, '白音勿拉', 4, '150422', '150422105', 'b');
INSERT INTO `sys_data_region` VALUES (4767, '哈拉哈达', 4, '150422', '150422106', 'h');
INSERT INTO `sys_data_region` VALUES (4768, '查干哈达苏木', 4, '150422', '150422200', 'c');
INSERT INTO `sys_data_region` VALUES (4769, '乌兰达坝苏木', 4, '150422', '150422201', 'w');
INSERT INTO `sys_data_region` VALUES (4770, '三山', 4, '150422', '150422202', 's');
INSERT INTO `sys_data_region` VALUES (4771, '花加拉嘎', 4, '150422', '150422203', 'h');
INSERT INTO `sys_data_region` VALUES (4772, '林东西城', 4, '150422', '150422403', 'l');
INSERT INTO `sys_data_region` VALUES (4773, '林东东城', 4, '150422', '150422404', 'l');
INSERT INTO `sys_data_region` VALUES (4774, '巴林右旗', 3, '1504', '150423', 'b');
INSERT INTO `sys_data_region` VALUES (4775, '大板', 4, '150423', '150423100', 'd');
INSERT INTO `sys_data_region` VALUES (4776, '索博日嘎', 4, '150423', '150423101', 's');
INSERT INTO `sys_data_region` VALUES (4777, '宝日勿苏', 4, '150423', '150423102', 'b');
INSERT INTO `sys_data_region` VALUES (4778, '查干诺尔', 4, '150423', '150423103', 'c');
INSERT INTO `sys_data_region` VALUES (4779, '巴彦琥硕', 4, '150423', '150423105', 'b');
INSERT INTO `sys_data_region` VALUES (4780, '西拉沐沦苏木', 4, '150423', '150423200', 'x');
INSERT INTO `sys_data_region` VALUES (4781, '巴彦塔拉苏木', 4, '150423', '150423201', 'b');
INSERT INTO `sys_data_region` VALUES (4782, '幸福之路苏木', 4, '150423', '150423202', 'x');
INSERT INTO `sys_data_region` VALUES (4783, '查干沐沦苏木', 4, '150423', '150423204', 'c');
INSERT INTO `sys_data_region` VALUES (4784, '林西', 3, '1504', '150424', 'l');
INSERT INTO `sys_data_region` VALUES (4785, '官地', 4, '150424', '150424100', 'g');
INSERT INTO `sys_data_region` VALUES (4786, '新城子', 4, '150424', '150424101', 'x');
INSERT INTO `sys_data_region` VALUES (4787, '新林', 4, '150424', '150424102', 'x');
INSERT INTO `sys_data_region` VALUES (4788, '五十家子', 4, '150424', '150424103', 'w');
INSERT INTO `sys_data_region` VALUES (4789, '林西镇', 4, '150424', '150424104', 'l');
INSERT INTO `sys_data_region` VALUES (4790, '大井', 4, '150424', '150424105', 'd');
INSERT INTO `sys_data_region` VALUES (4791, '统部', 4, '150424', '150424106', 't');
INSERT INTO `sys_data_region` VALUES (4792, '大营子', 4, '150424', '150424200', 'd');
INSERT INTO `sys_data_region` VALUES (4793, '十二吐', 4, '150424', '150424201', 's');
INSERT INTO `sys_data_region` VALUES (4794, '城北街道筹备处', 4, '150424', '150424400', 'c');
INSERT INTO `sys_data_region` VALUES (4795, '城南街道筹备处', 4, '150424', '150424401', 'c');
INSERT INTO `sys_data_region` VALUES (4796, '内蒙古林西工业园区', 4, '150424', '150424402', 'n');
INSERT INTO `sys_data_region` VALUES (4797, '克什克腾旗', 3, '1504', '150425', 'k');
INSERT INTO `sys_data_region` VALUES (4798, '经棚', 4, '150425', '150425100', 'j');
INSERT INTO `sys_data_region` VALUES (4799, '宇宙地', 4, '150425', '150425102', 'y');
INSERT INTO `sys_data_region` VALUES (4800, '土城子', 4, '150425', '150425103', 't');
INSERT INTO `sys_data_region` VALUES (4801, '达来诺日', 4, '150425', '150425104', 'd');
INSERT INTO `sys_data_region` VALUES (4802, '同兴', 4, '150425', '150425105', 't');
INSERT INTO `sys_data_region` VALUES (4803, '万合永', 4, '150425', '150425106', 'w');
INSERT INTO `sys_data_region` VALUES (4804, '芝瑞', 4, '150425', '150425108', 'z');
INSERT INTO `sys_data_region` VALUES (4805, '新开地', 4, '150425', '150425208', 'x');
INSERT INTO `sys_data_region` VALUES (4806, '红山子', 4, '150425', '150425214', 'h');
INSERT INTO `sys_data_region` VALUES (4807, '达日罕乌拉苏木', 4, '150425', '150425219', 'd');
INSERT INTO `sys_data_region` VALUES (4808, '巴彦查干苏木', 4, '150425', '150425221', 'b');
INSERT INTO `sys_data_region` VALUES (4809, '浩来呼热苏木', 4, '150425', '150425222', 'h');
INSERT INTO `sys_data_region` VALUES (4810, '乌兰布统苏木', 4, '150425', '150425223', 'w');
INSERT INTO `sys_data_region` VALUES (4811, '克旗经棚街道筹备处', 4, '150425', '150425400', 'k');
INSERT INTO `sys_data_region` VALUES (4812, '热水塘温泉疗养旅游开发区管委会', 4, '150425', '150425401', 'r');
INSERT INTO `sys_data_region` VALUES (4813, '翁牛特旗', 3, '1504', '150426', 'w');
INSERT INTO `sys_data_region` VALUES (4814, '乌丹', 4, '150426', '150426100', 'w');
INSERT INTO `sys_data_region` VALUES (4815, '乌敦套海', 4, '150426', '150426101', 'w');
INSERT INTO `sys_data_region` VALUES (4816, '五分地', 4, '150426', '150426102', 'w');
INSERT INTO `sys_data_region` VALUES (4817, '桥头', 4, '150426', '150426103', 'q');
INSERT INTO `sys_data_region` VALUES (4818, '广德公', 4, '150426', '150426104', 'g');
INSERT INTO `sys_data_region` VALUES (4819, '梧桐花', 4, '150426', '150426105', 'w');
INSERT INTO `sys_data_region` VALUES (4820, '海拉苏', 4, '150426', '150426106', 'h');
INSERT INTO `sys_data_region` VALUES (4821, '亿合公', 4, '150426', '150426107', 'y');
INSERT INTO `sys_data_region` VALUES (4822, '解放营子', 4, '150426', '150426200', 'j');
INSERT INTO `sys_data_region` VALUES (4823, '阿什罕苏木', 4, '150426', '150426201', 'a');
INSERT INTO `sys_data_region` VALUES (4824, '新苏莫苏木', 4, '150426', '150426202', 'x');
INSERT INTO `sys_data_region` VALUES (4825, '白音套海苏木', 4, '150426', '150426203', 'b');
INSERT INTO `sys_data_region` VALUES (4826, '毛山东', 4, '150426', '150426204', 'm');
INSERT INTO `sys_data_region` VALUES (4827, '格日僧苏木', 4, '150426', '150426205', 'g');
INSERT INTO `sys_data_region` VALUES (4828, '玉龙工业园区', 4, '150426', '150426400', 'y');
INSERT INTO `sys_data_region` VALUES (4829, '紫城街道筹备处', 4, '150426', '150426402', 'z');
INSERT INTO `sys_data_region` VALUES (4830, '全宁街道筹备处', 4, '150426', '150426403', 'q');
INSERT INTO `sys_data_region` VALUES (4831, '喀喇沁旗', 3, '1504', '150428', 'k');
INSERT INTO `sys_data_region` VALUES (4832, '锦山', 4, '150428', '150428100', 'j');
INSERT INTO `sys_data_region` VALUES (4833, '美林', 4, '150428', '150428101', 'm');
INSERT INTO `sys_data_region` VALUES (4834, '王爷府', 4, '150428', '150428102', 'w');
INSERT INTO `sys_data_region` VALUES (4835, '小牛群', 4, '150428', '150428103', 'x');
INSERT INTO `sys_data_region` VALUES (4836, '牛家营子', 4, '150428', '150428104', 'n');
INSERT INTO `sys_data_region` VALUES (4837, '乃林', 4, '150428', '150428105', 'n');
INSERT INTO `sys_data_region` VALUES (4838, '西桥', 4, '150428', '150428106', 'x');
INSERT INTO `sys_data_region` VALUES (4839, '十家', 4, '150428', '150428200', 's');
INSERT INTO `sys_data_region` VALUES (4840, '南台子', 4, '150428', '150428201', 'n');
INSERT INTO `sys_data_region` VALUES (4841, '赤峰市和美工贸园区', 4, '150428', '150428402', 'c');
INSERT INTO `sys_data_region` VALUES (4842, '宁城', 3, '1504', '150429', 'n');
INSERT INTO `sys_data_region` VALUES (4843, '天义', 4, '150429', '150429100', 't');
INSERT INTO `sys_data_region` VALUES (4844, '小城子', 4, '150429', '150429101', 'x');
INSERT INTO `sys_data_region` VALUES (4845, '大城子', 4, '150429', '150429102', 'd');
INSERT INTO `sys_data_region` VALUES (4846, '八里罕', 4, '150429', '150429103', 'b');
INSERT INTO `sys_data_region` VALUES (4847, '黑里河', 4, '150429', '150429104', 'h');
INSERT INTO `sys_data_region` VALUES (4848, '甸子', 4, '150429', '150429105', 'd');
INSERT INTO `sys_data_region` VALUES (4849, '大双庙', 4, '150429', '150429106', 'd');
INSERT INTO `sys_data_region` VALUES (4850, '汐子', 4, '150429', '150429107', 'x');
INSERT INTO `sys_data_region` VALUES (4851, '大明', 4, '150429', '150429108', 'd');
INSERT INTO `sys_data_region` VALUES (4852, '忙农', 4, '150429', '150429109', 'm');
INSERT INTO `sys_data_region` VALUES (4853, '五化', 4, '150429', '150429110', 'w');
INSERT INTO `sys_data_region` VALUES (4854, '必斯营子', 4, '150429', '150429111', 'b');
INSERT INTO `sys_data_region` VALUES (4855, '三座店', 4, '150429', '150429112', 's');
INSERT INTO `sys_data_region` VALUES (4856, '一肯中', 4, '150429', '150429202', 'y');
INSERT INTO `sys_data_region` VALUES (4857, '存金沟', 4, '150429', '150429203', 'c');
INSERT INTO `sys_data_region` VALUES (4858, '敖汉旗', 3, '1504', '150430', 'a');
INSERT INTO `sys_data_region` VALUES (4859, '新惠', 4, '150430', '150430100', 'x');
INSERT INTO `sys_data_region` VALUES (4860, '四家子', 4, '150430', '150430101', 's');
INSERT INTO `sys_data_region` VALUES (4861, '长胜', 4, '150430', '150430102', 'c');
INSERT INTO `sys_data_region` VALUES (4862, '贝子府', 4, '150430', '150430103', 'b');
INSERT INTO `sys_data_region` VALUES (4863, '四道湾子', 4, '150430', '150430104', 's');
INSERT INTO `sys_data_region` VALUES (4864, '下洼', 4, '150430', '150430105', 'x');
INSERT INTO `sys_data_region` VALUES (4865, '金厂沟梁', 4, '150430', '150430106', 'j');
INSERT INTO `sys_data_region` VALUES (4866, '兴隆洼', 4, '150430', '150430107', 'x');
INSERT INTO `sys_data_region` VALUES (4867, '黄羊洼', 4, '150430', '150430108', 'h');
INSERT INTO `sys_data_region` VALUES (4868, '古鲁板蒿', 4, '150430', '150430109', 'g');
INSERT INTO `sys_data_region` VALUES (4869, '牛古吐', 4, '150430', '150430110', 'n');
INSERT INTO `sys_data_region` VALUES (4870, '木头营子', 4, '150430', '150430202', 'm');
INSERT INTO `sys_data_region` VALUES (4871, '丰收', 4, '150430', '150430204', 'f');
INSERT INTO `sys_data_region` VALUES (4872, '玛尼罕', 4, '150430', '150430205', 'm');
INSERT INTO `sys_data_region` VALUES (4873, '萨力巴', 4, '150430', '150430206', 's');
INSERT INTO `sys_data_region` VALUES (4874, '敖润苏莫苏木', 4, '150430', '150430207', 'a');
INSERT INTO `sys_data_region` VALUES (4875, '敖汉旗新惠工业园区', 4, '150430', '150430401', 'a');
INSERT INTO `sys_data_region` VALUES (4876, '通辽', 2, '15', '1505', 't');
INSERT INTO `sys_data_region` VALUES (4877, '科尔沁', 3, '1505', '150502', 'k');
INSERT INTO `sys_data_region` VALUES (4878, '科尔沁街道', 4, '150502', '150502001', 'k');
INSERT INTO `sys_data_region` VALUES (4879, '西门', 4, '150502', '150502002', 'x');
INSERT INTO `sys_data_region` VALUES (4880, '永清', 4, '150502', '150502003', 'y');
INSERT INTO `sys_data_region` VALUES (4881, '明仁', 4, '150502', '150502004', 'm');
INSERT INTO `sys_data_region` VALUES (4882, '施介', 4, '150502', '150502005', 's');
INSERT INTO `sys_data_region` VALUES (4883, '团结', 4, '150502', '150502006', 't');
INSERT INTO `sys_data_region` VALUES (4884, '东郊', 4, '150502', '150502007', 'd');
INSERT INTO `sys_data_region` VALUES (4885, '铁路', 4, '150502', '150502008', 't');
INSERT INTO `sys_data_region` VALUES (4886, '电厂', 4, '150502', '150502009', 'd');
INSERT INTO `sys_data_region` VALUES (4887, '霍林河', 4, '150502', '150502010', 'h');
INSERT INTO `sys_data_region` VALUES (4888, '河西', 4, '150502', '150502011', 'h');
INSERT INTO `sys_data_region` VALUES (4889, '红星', 4, '150502', '150502012', 'h');
INSERT INTO `sys_data_region` VALUES (4890, '建国', 4, '150502', '150502013', 'j');
INSERT INTO `sys_data_region` VALUES (4891, '新城', 4, '150502', '150502014', 'x');
INSERT INTO `sys_data_region` VALUES (4892, '滨河', 4, '150502', '150502015', 'b');
INSERT INTO `sys_data_region` VALUES (4893, '大林', 4, '150502', '150502100', 'd');
INSERT INTO `sys_data_region` VALUES (4894, '钱家店', 4, '150502', '150502101', 'q');
INSERT INTO `sys_data_region` VALUES (4895, '余粮堡', 4, '150502', '150502102', 'y');
INSERT INTO `sys_data_region` VALUES (4896, '木里图', 4, '150502', '150502104', 'm');
INSERT INTO `sys_data_region` VALUES (4897, '丰田', 4, '150502', '150502106', 'f');
INSERT INTO `sys_data_region` VALUES (4898, '清河', 4, '150502', '150502108', 'q');
INSERT INTO `sys_data_region` VALUES (4899, '育新', 4, '150502', '150502110', 'y');
INSERT INTO `sys_data_region` VALUES (4900, '庆和', 4, '150502', '150502113', 'q');
INSERT INTO `sys_data_region` VALUES (4901, '敖力布皋', 4, '150502', '150502114', 'a');
INSERT INTO `sys_data_region` VALUES (4902, '辽河', 4, '150502', '150502130', 'l');
INSERT INTO `sys_data_region` VALUES (4903, '莫力庙苏木', 4, '150502', '150502200', 'm');
INSERT INTO `sys_data_region` VALUES (4904, '哲南农场', 4, '150502', '150502400', 'z');
INSERT INTO `sys_data_region` VALUES (4905, '三义堂农场', 4, '150502', '150502401', 's');
INSERT INTO `sys_data_region` VALUES (4906, '半截店牧场', 4, '150502', '150502405', 'b');
INSERT INTO `sys_data_region` VALUES (4907, '科尔沁左翼中旗', 3, '1505', '150521', 'k');
INSERT INTO `sys_data_region` VALUES (4908, '保康镇', 4, '150521', '150521100', 'b');
INSERT INTO `sys_data_region` VALUES (4909, '宝龙山', 4, '150521', '150521101', 'b');
INSERT INTO `sys_data_region` VALUES (4910, '舍伯吐', 4, '150521', '150521102', 's');
INSERT INTO `sys_data_region` VALUES (4911, '巴彦塔拉', 4, '150521', '150521103', 'b');
INSERT INTO `sys_data_region` VALUES (4912, '门达', 4, '150521', '150521104', 'm');
INSERT INTO `sys_data_region` VALUES (4913, '架玛吐', 4, '150521', '150521105', 'j');
INSERT INTO `sys_data_region` VALUES (4914, '腰林毛都', 4, '150521', '150521106', 'y');
INSERT INTO `sys_data_region` VALUES (4915, '希伯花', 4, '150521', '150521107', 'x');
INSERT INTO `sys_data_region` VALUES (4916, '花吐古拉', 4, '150521', '150521108', 'h');
INSERT INTO `sys_data_region` VALUES (4917, '代力吉', 4, '150521', '150521109', 'd');
INSERT INTO `sys_data_region` VALUES (4918, '努日木', 4, '150521', '150521110', 'n');
INSERT INTO `sys_data_region` VALUES (4919, '图布信苏木', 4, '150521', '150521204', 't');
INSERT INTO `sys_data_region` VALUES (4920, '协代苏木', 4, '150521', '150521207', 'x');
INSERT INTO `sys_data_region` VALUES (4921, '白兴吐苏木', 4, '150521', '150521210', 'b');
INSERT INTO `sys_data_region` VALUES (4922, '花胡硕苏木', 4, '150521', '150521212', 'h');
INSERT INTO `sys_data_region` VALUES (4923, '敖包苏木', 4, '150521', '150521213', 'a');
INSERT INTO `sys_data_region` VALUES (4924, '胜利', 4, '150521', '150521214', 's');
INSERT INTO `sys_data_region` VALUES (4925, '白音塔拉农场', 4, '150521', '150521400', 'b');
INSERT INTO `sys_data_region` VALUES (4926, '珠日河牧场', 4, '150521', '150521401', 'z');
INSERT INTO `sys_data_region` VALUES (4927, '丰库牧场', 4, '150521', '150521402', 'f');
INSERT INTO `sys_data_region` VALUES (4928, '保康街道', 4, '150521', '150521403', 'b');
INSERT INTO `sys_data_region` VALUES (4929, '科尔沁左翼后旗', 3, '1505', '150522', 'k');
INSERT INTO `sys_data_region` VALUES (4930, '金宝屯', 4, '150522', '150522101', 'j');
INSERT INTO `sys_data_region` VALUES (4931, '吉尔嘎朗', 4, '150522', '150522102', 'j');
INSERT INTO `sys_data_region` VALUES (4932, '双胜', 4, '150522', '150522103', 's');
INSERT INTO `sys_data_region` VALUES (4933, '阿古拉', 4, '150522', '150522107', 'a');
INSERT INTO `sys_data_region` VALUES (4934, '朝鲁吐', 4, '150522', '150522109', 'c');
INSERT INTO `sys_data_region` VALUES (4935, '海鲁吐', 4, '150522', '150522110', 'h');
INSERT INTO `sys_data_region` VALUES (4936, '甘旗卡', 4, '150522', '150522111', 'g');
INSERT INTO `sys_data_region` VALUES (4937, '常胜', 4, '150522', '150522112', 'c');
INSERT INTO `sys_data_region` VALUES (4938, '查日苏', 4, '150522', '150522113', 'c');
INSERT INTO `sys_data_region` VALUES (4939, '努古斯台', 4, '150522', '150522136', 'n');
INSERT INTO `sys_data_region` VALUES (4940, '阿都沁苏木', 4, '150522', '150522208', 'a');
INSERT INTO `sys_data_region` VALUES (4941, '茂道吐苏木', 4, '150522', '150522209', 'm');
INSERT INTO `sys_data_region` VALUES (4942, '巴胡塔苏木', 4, '150522', '150522210', 'b');
INSERT INTO `sys_data_region` VALUES (4943, '散都苏木', 4, '150522', '150522211', 's');
INSERT INTO `sys_data_region` VALUES (4944, '巴彦毛都苏木', 4, '150522', '150522212', 'b');
INSERT INTO `sys_data_region` VALUES (4945, '胜利农场', 4, '150522', '150522400', 's');
INSERT INTO `sys_data_region` VALUES (4946, '孟根达坝牧场', 4, '150522', '150522401', 'm');
INSERT INTO `sys_data_region` VALUES (4947, '查金台牧场', 4, '150522', '150522402', 'c');
INSERT INTO `sys_data_region` VALUES (4948, '大青沟管理局', 4, '150522', '150522404', 'd');
INSERT INTO `sys_data_region` VALUES (4949, '哈日乌苏种畜场', 4, '150522', '150522405', 'h');
INSERT INTO `sys_data_region` VALUES (4950, '朝鲁吐林场', 4, '150522', '150522408', 'c');
INSERT INTO `sys_data_region` VALUES (4951, '伊胡塔林场', 4, '150522', '150522410', 'y');
INSERT INTO `sys_data_region` VALUES (4952, '乌旦塔拉林场', 4, '150522', '150522411', 'w');
INSERT INTO `sys_data_region` VALUES (4953, '开鲁', 3, '1505', '150523', 'k');
INSERT INTO `sys_data_region` VALUES (4954, '开鲁镇', 4, '150523', '150523100', 'k');
INSERT INTO `sys_data_region` VALUES (4955, '大榆树', 4, '150523', '150523103', 'd');
INSERT INTO `sys_data_region` VALUES (4956, '黑龙坝', 4, '150523', '150523104', 'h');
INSERT INTO `sys_data_region` VALUES (4957, '麦新', 4, '150523', '150523105', 'm');
INSERT INTO `sys_data_region` VALUES (4958, '建华', 4, '150523', '150523108', 'j');
INSERT INTO `sys_data_region` VALUES (4959, '小街基', 4, '150523', '150523109', 'x');
INSERT INTO `sys_data_region` VALUES (4960, '东风', 4, '150523', '150523111', 'd');
INSERT INTO `sys_data_region` VALUES (4961, '吉日嘎郎吐', 4, '150523', '150523112', 'j');
INSERT INTO `sys_data_region` VALUES (4962, '东来', 4, '150523', '150523113', 'd');
INSERT INTO `sys_data_region` VALUES (4963, '义和塔拉', 4, '150523', '150523114', 'y');
INSERT INTO `sys_data_region` VALUES (4964, '清河牧场', 4, '150523', '150523400', 'q');
INSERT INTO `sys_data_region` VALUES (4965, '辽河农场', 4, '150523', '150523401', 'l');
INSERT INTO `sys_data_region` VALUES (4966, '库伦旗', 3, '1505', '150524', 'k');
INSERT INTO `sys_data_region` VALUES (4967, '库伦街道', 4, '150524', '150524000', 'k');
INSERT INTO `sys_data_region` VALUES (4968, '库伦镇', 4, '150524', '150524100', 'k');
INSERT INTO `sys_data_region` VALUES (4969, '六家子', 4, '150524', '150524101', 'l');
INSERT INTO `sys_data_region` VALUES (4970, '额勒顺', 4, '150524', '150524103', 'e');
INSERT INTO `sys_data_region` VALUES (4971, '扣河子', 4, '150524', '150524104', 'k');
INSERT INTO `sys_data_region` VALUES (4972, '白音花', 4, '150524', '150524105', 'b');
INSERT INTO `sys_data_region` VALUES (4973, '茫汗苏木', 4, '150524', '150524203', 'm');
INSERT INTO `sys_data_region` VALUES (4974, '水泉', 4, '150524', '150524204', 's');
INSERT INTO `sys_data_region` VALUES (4975, '先进苏木', 4, '150524', '150524205', 'x');
INSERT INTO `sys_data_region` VALUES (4976, '奈曼旗', 3, '1505', '150525', 'n');
INSERT INTO `sys_data_region` VALUES (4977, '大沁他拉', 4, '150525', '150525100', 'd');
INSERT INTO `sys_data_region` VALUES (4978, '八仙筒', 4, '150525', '150525101', 'b');
INSERT INTO `sys_data_region` VALUES (4979, '青龙山', 4, '150525', '150525102', 'q');
INSERT INTO `sys_data_region` VALUES (4980, '东明', 4, '150525', '150525103', 'd');
INSERT INTO `sys_data_region` VALUES (4981, '治安', 4, '150525', '150525104', 'z');
INSERT INTO `sys_data_region` VALUES (4982, '义隆永', 4, '150525', '150525105', 'y');
INSERT INTO `sys_data_region` VALUES (4983, '新镇', 4, '150525', '150525106', 'x');
INSERT INTO `sys_data_region` VALUES (4984, '沙日浩来', 4, '150525', '150525109', 's');
INSERT INTO `sys_data_region` VALUES (4985, '黄花塔拉苏木', 4, '150525', '150525201', 'h');
INSERT INTO `sys_data_region` VALUES (4986, '固日班花苏木', 4, '150525', '150525202', 'g');
INSERT INTO `sys_data_region` VALUES (4987, '白音他拉苏木', 4, '150525', '150525203', 'b');
INSERT INTO `sys_data_region` VALUES (4988, '明仁苏木', 4, '150525', '150525205', 'm');
INSERT INTO `sys_data_region` VALUES (4989, '土城子', 4, '150525', '150525206', 't');
INSERT INTO `sys_data_region` VALUES (4990, '苇莲苏', 4, '150525', '150525207', 'w');
INSERT INTO `sys_data_region` VALUES (4991, '国有六号农场', 4, '150525', '150525400', 'g');
INSERT INTO `sys_data_region` VALUES (4992, '扎鲁特旗', 3, '1505', '150526', 'z');
INSERT INTO `sys_data_region` VALUES (4993, '鲁北', 4, '150526', '150526100', 'l');
INSERT INTO `sys_data_region` VALUES (4994, '巨日河', 4, '150526', '150526101', 'j');
INSERT INTO `sys_data_region` VALUES (4995, '黄花山', 4, '150526', '150526103', 'h');
INSERT INTO `sys_data_region` VALUES (4996, '巴雅尔吐胡硕', 4, '150526', '150526104', 'b');
INSERT INTO `sys_data_region` VALUES (4997, '嘎亥图', 4, '150526', '150526105', 'g');
INSERT INTO `sys_data_region` VALUES (4998, '香山', 4, '150526', '150526106', 'x');
INSERT INTO `sys_data_region` VALUES (4999, '阿日昆都楞', 4, '150526', '150526107', 'a');
INSERT INTO `sys_data_region` VALUES (5000, '格日朝鲁苏木', 4, '150526', '150526203', 'g');
INSERT INTO `sys_data_region` VALUES (5001, '乌力吉木仁苏木', 4, '150526', '150526204', 'w');
INSERT INTO `sys_data_region` VALUES (5002, '巴彦塔拉苏木', 4, '150526', '150526209', 'b');
INSERT INTO `sys_data_region` VALUES (5003, '道老杜苏木', 4, '150526', '150526210', 'd');
INSERT INTO `sys_data_region` VALUES (5004, '前德门苏木', 4, '150526', '150526211', 'q');
INSERT INTO `sys_data_region` VALUES (5005, '乌兰哈达苏木', 4, '150526', '150526212', 'w');
INSERT INTO `sys_data_region` VALUES (5006, '查布嘎图苏木', 4, '150526', '150526213', 'c');
INSERT INTO `sys_data_region` VALUES (5007, '乌额格其苏木', 4, '150526', '150526214', 'w');
INSERT INTO `sys_data_region` VALUES (5008, '乌日根塔拉农场', 4, '150526', '150526402', 'w');
INSERT INTO `sys_data_region` VALUES (5009, '嘎达苏种畜场', 4, '150526', '150526403', 'g');
INSERT INTO `sys_data_region` VALUES (5010, '霍林郭勒', 3, '1505', '150581', 'h');
INSERT INTO `sys_data_region` VALUES (5011, '珠斯花', 4, '150581', '150581001', 'z');
INSERT INTO `sys_data_region` VALUES (5012, '莫斯台', 4, '150581', '150581002', 'm');
INSERT INTO `sys_data_region` VALUES (5013, '宝日呼吉尔', 4, '150581', '150581003', 'b');
INSERT INTO `sys_data_region` VALUES (5014, '达来胡硕', 4, '150581', '150581004', 'd');
INSERT INTO `sys_data_region` VALUES (5015, '沙尔呼热', 4, '150581', '150581005', 's');
INSERT INTO `sys_data_region` VALUES (5016, '鄂尔多斯', 2, '15', '1506', 'e');
INSERT INTO `sys_data_region` VALUES (5017, '东胜', 3, '1506', '150602', 'd');
INSERT INTO `sys_data_region` VALUES (5018, '交通', 4, '150602', '150602001', 'j');
INSERT INTO `sys_data_region` VALUES (5019, '公园', 4, '150602', '150602002', 'g');
INSERT INTO `sys_data_region` VALUES (5020, '林荫', 4, '150602', '150602003', 'l');
INSERT INTO `sys_data_region` VALUES (5021, '建设', 4, '150602', '150602004', 'j');
INSERT INTO `sys_data_region` VALUES (5022, '富兴', 4, '150602', '150602005', 'f');
INSERT INTO `sys_data_region` VALUES (5023, '天骄', 4, '150602', '150602006', 't');
INSERT INTO `sys_data_region` VALUES (5024, '诃额伦', 4, '150602', '150602007', 'h');
INSERT INTO `sys_data_region` VALUES (5025, '巴音门克', 4, '150602', '150602008', 'b');
INSERT INTO `sys_data_region` VALUES (5026, '民族', 4, '150602', '150602009', 'm');
INSERT INTO `sys_data_region` VALUES (5027, '幸福', 4, '150602', '150602010', 'x');
INSERT INTO `sys_data_region` VALUES (5028, '纺织', 4, '150602', '150602011', 'f');
INSERT INTO `sys_data_region` VALUES (5029, '兴胜路', 4, '150602', '150602012', 'x');
INSERT INTO `sys_data_region` VALUES (5030, '泊尔江海子', 4, '150602', '150602106', 'b');
INSERT INTO `sys_data_region` VALUES (5031, '罕台', 4, '150602', '150602107', 'h');
INSERT INTO `sys_data_region` VALUES (5032, '铜川', 4, '150602', '150602108', 't');
INSERT INTO `sys_data_region` VALUES (5033, '康巴什', 3, '1506', '150603', 'k');
INSERT INTO `sys_data_region` VALUES (5034, '哈巴格希', 4, '150603', '150603001', 'h');
INSERT INTO `sys_data_region` VALUES (5035, '青春山', 4, '150603', '150603002', 'q');
INSERT INTO `sys_data_region` VALUES (5036, '滨河', 4, '150603', '150603003', 'b');
INSERT INTO `sys_data_region` VALUES (5037, '达拉特旗', 3, '1506', '150621', 'd');
INSERT INTO `sys_data_region` VALUES (5038, '锡尼', 4, '150621', '150621001', 'x');
INSERT INTO `sys_data_region` VALUES (5039, '西园', 4, '150621', '150621002', 'x');
INSERT INTO `sys_data_region` VALUES (5040, '白塔', 4, '150621', '150621003', 'b');
INSERT INTO `sys_data_region` VALUES (5041, '工业', 4, '150621', '150621004', 'g');
INSERT INTO `sys_data_region` VALUES (5042, '昭君街道', 4, '150621', '150621005', 'z');
INSERT INTO `sys_data_region` VALUES (5043, '平原', 4, '150621', '150621006', 'p');
INSERT INTO `sys_data_region` VALUES (5044, '王爱召', 4, '150621', '150621108', 'w');
INSERT INTO `sys_data_region` VALUES (5045, '树林召', 4, '150621', '150621109', 's');
INSERT INTO `sys_data_region` VALUES (5046, '昭君镇', 4, '150621', '150621110', 'z');
INSERT INTO `sys_data_region` VALUES (5047, '白泥井', 4, '150621', '150621111', 'b');
INSERT INTO `sys_data_region` VALUES (5048, '吉格斯太', 4, '150621', '150621112', 'j');
INSERT INTO `sys_data_region` VALUES (5049, '中和西', 4, '150621', '150621113', 'z');
INSERT INTO `sys_data_region` VALUES (5050, '恩格贝', 4, '150621', '150621114', 'e');
INSERT INTO `sys_data_region` VALUES (5051, '展旦召苏木', 4, '150621', '150621201', 'z');
INSERT INTO `sys_data_region` VALUES (5052, '鄂尔多斯市生态示范区管理委员会', 4, '150621', '150621401', 'e');
INSERT INTO `sys_data_region` VALUES (5053, '准格尔旗', 3, '1506', '150622', 'z');
INSERT INTO `sys_data_region` VALUES (5054, '友谊', 4, '150622', '150622001', 'y');
INSERT INTO `sys_data_region` VALUES (5055, '蓝天', 4, '150622', '150622002', 'l');
INSERT INTO `sys_data_region` VALUES (5056, '兴隆', 4, '150622', '150622003', 'x');
INSERT INTO `sys_data_region` VALUES (5057, '迎泽', 4, '150622', '150622004', 'y');
INSERT INTO `sys_data_region` VALUES (5058, '薛家湾', 4, '150622', '150622114', 'x');
INSERT INTO `sys_data_region` VALUES (5059, '沙圪堵', 4, '150622', '150622115', 's');
INSERT INTO `sys_data_region` VALUES (5060, '龙口', 4, '150622', '150622116', 'l');
INSERT INTO `sys_data_region` VALUES (5061, '准格尔召', 4, '150622', '150622117', 'z');
INSERT INTO `sys_data_region` VALUES (5062, '纳日松', 4, '150622', '150622118', 'n');
INSERT INTO `sys_data_region` VALUES (5063, '大路', 4, '150622', '150622119', 'd');
INSERT INTO `sys_data_region` VALUES (5064, '布尔陶亥苏木', 4, '150622', '150622206', 'b');
INSERT INTO `sys_data_region` VALUES (5065, '十二连城', 4, '150622', '150622207', 's');
INSERT INTO `sys_data_region` VALUES (5066, '暖水', 4, '150622', '150622208', 'n');
INSERT INTO `sys_data_region` VALUES (5067, '准格尔经济开发区', 4, '150622', '150622400', 'z');
INSERT INTO `sys_data_region` VALUES (5068, '鄂托克前旗', 3, '1506', '150623', 'e');
INSERT INTO `sys_data_region` VALUES (5069, '敖勒召其', 4, '150623', '150623105', 'a');
INSERT INTO `sys_data_region` VALUES (5070, '上海庙', 4, '150623', '150623106', 's');
INSERT INTO `sys_data_region` VALUES (5071, '昂素', 4, '150623', '150623107', 'a');
INSERT INTO `sys_data_region` VALUES (5072, '城川', 4, '150623', '150623108', 'c');
INSERT INTO `sys_data_region` VALUES (5073, '鄂托克旗', 3, '1506', '150624', 'e');
INSERT INTO `sys_data_region` VALUES (5074, '蒙西', 4, '150624', '150624100', 'm');
INSERT INTO `sys_data_region` VALUES (5075, '乌兰', 4, '150624', '150624101', 'w');
INSERT INTO `sys_data_region` VALUES (5076, '棋盘井', 4, '150624', '150624102', 'q');
INSERT INTO `sys_data_region` VALUES (5077, '木凯淖尔', 4, '150624', '150624103', 'm');
INSERT INTO `sys_data_region` VALUES (5078, '苏米图苏木', 4, '150624', '150624200', 's');
INSERT INTO `sys_data_region` VALUES (5079, '阿尔巴斯苏木', 4, '150624', '150624203', 'a');
INSERT INTO `sys_data_region` VALUES (5080, '杭锦旗', 3, '1506', '150625', 'h');
INSERT INTO `sys_data_region` VALUES (5081, '锡尼', 4, '150625', '150625100', 'x');
INSERT INTO `sys_data_region` VALUES (5082, '巴拉贡', 4, '150625', '150625101', 'b');
INSERT INTO `sys_data_region` VALUES (5083, '吉日嘎朗图', 4, '150625', '150625102', 'j');
INSERT INTO `sys_data_region` VALUES (5084, '呼和木都', 4, '150625', '150625103', 'h');
INSERT INTO `sys_data_region` VALUES (5085, '独贵塔拉', 4, '150625', '150625104', 'd');
INSERT INTO `sys_data_region` VALUES (5086, '伊和乌素苏木', 4, '150625', '150625206', 'y');
INSERT INTO `sys_data_region` VALUES (5087, '乌审旗', 3, '1506', '150626', 'w');
INSERT INTO `sys_data_region` VALUES (5088, '乌审召', 4, '150626', '150626106', 'w');
INSERT INTO `sys_data_region` VALUES (5089, '图克', 4, '150626', '150626107', 't');
INSERT INTO `sys_data_region` VALUES (5090, '嘎鲁图', 4, '150626', '150626108', 'g');
INSERT INTO `sys_data_region` VALUES (5091, '乌兰陶勒盖', 4, '150626', '150626109', 'w');
INSERT INTO `sys_data_region` VALUES (5092, '无定河', 4, '150626', '150626110', 'w');
INSERT INTO `sys_data_region` VALUES (5093, '苏力德苏木', 4, '150626', '150626203', 's');
INSERT INTO `sys_data_region` VALUES (5094, '伊金霍洛旗', 3, '1506', '150627', 'y');
INSERT INTO `sys_data_region` VALUES (5095, '阿勒腾席热', 4, '150627', '150627100', 'a');
INSERT INTO `sys_data_region` VALUES (5096, '札萨克', 4, '150627', '150627107', 'z');
INSERT INTO `sys_data_region` VALUES (5097, '红庆河', 4, '150627', '150627108', 'h');
INSERT INTO `sys_data_region` VALUES (5098, '伊金霍洛', 4, '150627', '150627109', 'y');
INSERT INTO `sys_data_region` VALUES (5099, '乌兰木伦', 4, '150627', '150627110', 'w');
INSERT INTO `sys_data_region` VALUES (5100, '纳林陶亥', 4, '150627', '150627111', 'n');
INSERT INTO `sys_data_region` VALUES (5101, '苏布尔嘎', 4, '150627', '150627113', 's');
INSERT INTO `sys_data_region` VALUES (5102, '呼伦贝尔', 2, '15', '1507', 'h');
INSERT INTO `sys_data_region` VALUES (5103, '海拉尔', 3, '1507', '150702', 'h');
INSERT INTO `sys_data_region` VALUES (5104, '正阳', 4, '150702', '150702001', 'z');
INSERT INTO `sys_data_region` VALUES (5105, '靠山', 4, '150702', '150702003', 'k');
INSERT INTO `sys_data_region` VALUES (5106, '健康', 4, '150702', '150702004', 'j');
INSERT INTO `sys_data_region` VALUES (5107, '胜利', 4, '150702', '150702005', 's');
INSERT INTO `sys_data_region` VALUES (5108, '呼伦', 4, '150702', '150702006', 'h');
INSERT INTO `sys_data_region` VALUES (5109, '建设', 4, '150702', '150702007', 'j');
INSERT INTO `sys_data_region` VALUES (5110, '奋斗', 4, '150702', '150702101', 'f');
INSERT INTO `sys_data_region` VALUES (5111, '哈克', 4, '150702', '150702102', 'h');
INSERT INTO `sys_data_region` VALUES (5112, '扎赉诺尔区', 3, '1507', '150703', 'z');
INSERT INTO `sys_data_region` VALUES (5113, '第一', 4, '150703', '150703001', 'd');
INSERT INTO `sys_data_region` VALUES (5114, '第二', 4, '150703', '150703002', 'd');
INSERT INTO `sys_data_region` VALUES (5115, '第三', 4, '150703', '150703003', 'd');
INSERT INTO `sys_data_region` VALUES (5116, '第四', 4, '150703', '150703004', 'd');
INSERT INTO `sys_data_region` VALUES (5117, '第五', 4, '150703', '150703005', 'd');
INSERT INTO `sys_data_region` VALUES (5118, '灵泉', 4, '150703', '150703006', 'l');
INSERT INTO `sys_data_region` VALUES (5119, '阿荣旗', 3, '1507', '150721', 'a');
INSERT INTO `sys_data_region` VALUES (5120, '那吉', 4, '150721', '150721100', 'n');
INSERT INTO `sys_data_region` VALUES (5121, '六合', 4, '150721', '150721102', 'l');
INSERT INTO `sys_data_region` VALUES (5122, '亚东', 4, '150721', '150721104', 'y');
INSERT INTO `sys_data_region` VALUES (5123, '复兴', 4, '150721', '150721105', 'f');
INSERT INTO `sys_data_region` VALUES (5124, '霍尔奇', 4, '150721', '150721106', 'h');
INSERT INTO `sys_data_region` VALUES (5125, '向阳峪', 4, '150721', '150721108', 'x');
INSERT INTO `sys_data_region` VALUES (5126, '三岔河', 4, '150721', '150721109', 's');
INSERT INTO `sys_data_region` VALUES (5127, '得力其', 4, '150721', '150721200', 'd');
INSERT INTO `sys_data_region` VALUES (5128, '查巴奇', 4, '150721', '150721201', 'c');
INSERT INTO `sys_data_region` VALUES (5129, '音河', 4, '150721', '150721202', 'y');
INSERT INTO `sys_data_region` VALUES (5130, '新发', 4, '150721', '150721203', 'x');
INSERT INTO `sys_data_region` VALUES (5131, '那吉屯农场', 4, '150721', '150721400', 'n');
INSERT INTO `sys_data_region` VALUES (5132, '莫力达瓦', 3, '1507', '150722', 'm');
INSERT INTO `sys_data_region` VALUES (5133, '尼尔基', 4, '150722', '150722100', 'n');
INSERT INTO `sys_data_region` VALUES (5134, '红彦', 4, '150722', '150722101', 'h');
INSERT INTO `sys_data_region` VALUES (5135, '宝山', 4, '150722', '150722102', 'b');
INSERT INTO `sys_data_region` VALUES (5136, '哈达阳', 4, '150722', '150722103', 'h');
INSERT INTO `sys_data_region` VALUES (5137, '阿尔拉', 4, '150722', '150722104', 'a');
INSERT INTO `sys_data_region` VALUES (5138, '西瓦尔图', 4, '150722', '150722106', 'x');
INSERT INTO `sys_data_region` VALUES (5139, '腾克', 4, '150722', '150722108', 't');
INSERT INTO `sys_data_region` VALUES (5140, '塔温敖宝', 4, '150722', '150722110', 't');
INSERT INTO `sys_data_region` VALUES (5141, '汉古尔河', 4, '150722', '150722120', 'h');
INSERT INTO `sys_data_region` VALUES (5142, '奎勒河', 4, '150722', '150722121', 'k');
INSERT INTO `sys_data_region` VALUES (5143, '巴彦', 4, '150722', '150722200', 'b');
INSERT INTO `sys_data_region` VALUES (5144, '杜拉尔', 4, '150722', '150722203', 'd');
INSERT INTO `sys_data_region` VALUES (5145, '库如奇', 4, '150722', '150722204', 'k');
INSERT INTO `sys_data_region` VALUES (5146, '国营甘河农场', 4, '150722', '150722400', 'g');
INSERT INTO `sys_data_region` VALUES (5147, '国营巴彦农场', 4, '150722', '150722401', 'g');
INSERT INTO `sys_data_region` VALUES (5148, '国营欧肯河农场', 4, '150722', '150722402', 'g');
INSERT INTO `sys_data_region` VALUES (5149, '国营东方红农场', 4, '150722', '150722403', 'g');
INSERT INTO `sys_data_region` VALUES (5150, '鄂伦春自治旗', 3, '1507', '150723', 'e');
INSERT INTO `sys_data_region` VALUES (5151, '阿里河', 4, '150723', '150723100', 'a');
INSERT INTO `sys_data_region` VALUES (5152, '诺敏', 4, '150723', '150723102', 'n');
INSERT INTO `sys_data_region` VALUES (5153, '乌鲁布铁', 4, '150723', '150723104', 'w');
INSERT INTO `sys_data_region` VALUES (5154, '大杨树', 4, '150723', '150723105', 'd');
INSERT INTO `sys_data_region` VALUES (5155, '宜里', 4, '150723', '150723107', 'y');
INSERT INTO `sys_data_region` VALUES (5156, '甘河', 4, '150723', '150723109', 'g');
INSERT INTO `sys_data_region` VALUES (5157, '克一河', 4, '150723', '150723113', 'k');
INSERT INTO `sys_data_region` VALUES (5158, '吉文', 4, '150723', '150723114', 'j');
INSERT INTO `sys_data_region` VALUES (5159, '古里', 4, '150723', '150723200', 'g');
INSERT INTO `sys_data_region` VALUES (5160, '托扎敏', 4, '150723', '150723216', 't');
INSERT INTO `sys_data_region` VALUES (5161, '大兴安岭管理局诺敏河农场', 4, '150723', '150723400', 'd');
INSERT INTO `sys_data_region` VALUES (5162, '大兴安岭农场管理局扎赉河农场', 4, '150723', '150723402', 'd');
INSERT INTO `sys_data_region` VALUES (5163, '大兴安岭农场管理局古里农场', 4, '150723', '150723403', 'd');
INSERT INTO `sys_data_region` VALUES (5164, '大兴安岭农场管理局东方红农场', 4, '150723', '150723412', 'd');
INSERT INTO `sys_data_region` VALUES (5165, '大兴安岭农场管理局欧肯河农场', 4, '150723', '150723413', 'd');
INSERT INTO `sys_data_region` VALUES (5166, '大兴安岭林管局毕拉河林业局', 4, '150723', '150723414', 'd');
INSERT INTO `sys_data_region` VALUES (5167, '大兴安岭林管局乌尔其汗林业局', 4, '150723', '150723417', 'd');
INSERT INTO `sys_data_region` VALUES (5168, '鄂温克族自治旗', 3, '1507', '150724', 'e');
INSERT INTO `sys_data_region` VALUES (5169, '伊敏河', 4, '150724', '150724101', 'y');
INSERT INTO `sys_data_region` VALUES (5170, '巴彦托海', 4, '150724', '150724102', 'b');
INSERT INTO `sys_data_region` VALUES (5171, '红花尔基', 4, '150724', '150724104', 'h');
INSERT INTO `sys_data_region` VALUES (5172, '大雁', 4, '150724', '150724105', 'd');
INSERT INTO `sys_data_region` VALUES (5173, '巴彦塔拉', 4, '150724', '150724200', 'b');
INSERT INTO `sys_data_region` VALUES (5174, '伊敏苏木', 4, '150724', '150724201', 'y');
INSERT INTO `sys_data_region` VALUES (5175, '辉苏木', 4, '150724', '150724202', 'h');
INSERT INTO `sys_data_region` VALUES (5176, '锡尼河东苏木', 4, '150724', '150724203', 'x');
INSERT INTO `sys_data_region` VALUES (5177, '锡尼河西苏木', 4, '150724', '150724204', 'x');
INSERT INTO `sys_data_region` VALUES (5178, '巴彦嵯岗苏木', 4, '150724', '150724205', 'b');
INSERT INTO `sys_data_region` VALUES (5179, '陈巴尔虎旗', 3, '1507', '150725', 'c');
INSERT INTO `sys_data_region` VALUES (5180, '巴彦库仁', 4, '150725', '150725100', 'b');
INSERT INTO `sys_data_region` VALUES (5181, '宝日希勒', 4, '150725', '150725101', 'b');
INSERT INTO `sys_data_region` VALUES (5182, '呼和诺尔', 4, '150725', '150725102', 'h');
INSERT INTO `sys_data_region` VALUES (5183, '鄂温克民族苏木', 4, '150725', '150725201', 'e');
INSERT INTO `sys_data_region` VALUES (5184, '东乌珠尔苏木', 4, '150725', '150725202', 'd');
INSERT INTO `sys_data_region` VALUES (5185, '巴彦哈达苏木', 4, '150725', '150725203', 'b');
INSERT INTO `sys_data_region` VALUES (5186, '陈旗西乌珠尔苏木', 4, '150725', '150725204', 'c');
INSERT INTO `sys_data_region` VALUES (5187, '陈巴尔虎旗国营哈图达牧场', 4, '150725', '150725501', 'c');
INSERT INTO `sys_data_region` VALUES (5188, '陈旗国营浩特陶海农牧场', 4, '150725', '150725502', 'c');
INSERT INTO `sys_data_region` VALUES (5189, '陈旗国营特泥河牧场', 4, '150725', '150725503', 'c');
INSERT INTO `sys_data_region` VALUES (5190, '新巴尔虎左旗', 3, '1507', '150726', 'x');
INSERT INTO `sys_data_region` VALUES (5191, '阿木古郎', 4, '150726', '150726100', 'a');
INSERT INTO `sys_data_region` VALUES (5192, '嵯岗', 4, '150726', '150726101', 'c');
INSERT INTO `sys_data_region` VALUES (5193, '新宝力格苏木', 4, '150726', '150726202', 'x');
INSERT INTO `sys_data_region` VALUES (5194, '乌布尔宝力格苏木', 4, '150726', '150726203', 'w');
INSERT INTO `sys_data_region` VALUES (5195, '吉布胡郎图苏木', 4, '150726', '150726204', 'j');
INSERT INTO `sys_data_region` VALUES (5196, '罕达盖苏木', 4, '150726', '150726205', 'h');
INSERT INTO `sys_data_region` VALUES (5197, '甘珠尔苏木', 4, '150726', '150726206', 'g');
INSERT INTO `sys_data_region` VALUES (5198, '嵯岗双娃牧场', 4, '150726', '150726400', 'c');
INSERT INTO `sys_data_region` VALUES (5199, '新巴尔虎右旗', 3, '1507', '150727', 'x');
INSERT INTO `sys_data_region` VALUES (5200, '阿拉坦额莫勒', 4, '150727', '150727100', 'a');
INSERT INTO `sys_data_region` VALUES (5201, '呼伦', 4, '150727', '150727101', 'h');
INSERT INTO `sys_data_region` VALUES (5202, '阿日哈沙特', 4, '150727', '150727102', 'a');
INSERT INTO `sys_data_region` VALUES (5203, '克尔伦苏木', 4, '150727', '150727204', 'k');
INSERT INTO `sys_data_region` VALUES (5204, '贝尔苏木', 4, '150727', '150727206', 'b');
INSERT INTO `sys_data_region` VALUES (5205, '达赉苏木', 4, '150727', '150727207', 'd');
INSERT INTO `sys_data_region` VALUES (5206, '宝格德乌拉苏木', 4, '150727', '150727208', 'b');
INSERT INTO `sys_data_region` VALUES (5207, '敖尔金牧场', 4, '150727', '150727500', 'a');
INSERT INTO `sys_data_region` VALUES (5208, '满洲里', 3, '1507', '150781', 'm');
INSERT INTO `sys_data_region` VALUES (5209, '道北', 4, '150781', '150781001', 'd');
INSERT INTO `sys_data_region` VALUES (5210, '兴华', 4, '150781', '150781002', 'x');
INSERT INTO `sys_data_region` VALUES (5211, '东山', 4, '150781', '150781003', 'd');
INSERT INTO `sys_data_region` VALUES (5212, '道南', 4, '150781', '150781004', 'd');
INSERT INTO `sys_data_region` VALUES (5213, '新开河', 4, '150781', '150781100', 'x');
INSERT INTO `sys_data_region` VALUES (5214, '牙克石', 3, '1507', '150782', 'y');
INSERT INTO `sys_data_region` VALUES (5215, '胜利', 4, '150782', '150782001', 's');
INSERT INTO `sys_data_region` VALUES (5216, '红旗', 4, '150782', '150782002', 'h');
INSERT INTO `sys_data_region` VALUES (5217, '新工', 4, '150782', '150782003', 'x');
INSERT INTO `sys_data_region` VALUES (5218, '永兴', 4, '150782', '150782004', 'y');
INSERT INTO `sys_data_region` VALUES (5219, '建设', 4, '150782', '150782005', 'j');
INSERT INTO `sys_data_region` VALUES (5220, '暖泉', 4, '150782', '150782006', 'n');
INSERT INTO `sys_data_region` VALUES (5221, '东兴', 4, '150782', '150782007', 'd');
INSERT INTO `sys_data_region` VALUES (5222, '免渡河', 4, '150782', '150782101', 'm');
INSERT INTO `sys_data_region` VALUES (5223, '博克图', 4, '150782', '150782103', 'b');
INSERT INTO `sys_data_region` VALUES (5224, '绰河源', 4, '150782', '150782105', 'c');
INSERT INTO `sys_data_region` VALUES (5225, '乌尔其汉', 4, '150782', '150782108', 'w');
INSERT INTO `sys_data_region` VALUES (5226, '库都尔', 4, '150782', '150782109', 'k');
INSERT INTO `sys_data_region` VALUES (5227, '图里河', 4, '150782', '150782110', 't');
INSERT INTO `sys_data_region` VALUES (5228, '乌奴耳', 4, '150782', '150782111', 'w');
INSERT INTO `sys_data_region` VALUES (5229, '塔尔气', 4, '150782', '150782112', 't');
INSERT INTO `sys_data_region` VALUES (5230, '伊图里河', 4, '150782', '150782113', 'y');
INSERT INTO `sys_data_region` VALUES (5231, '莫拐农场', 4, '150782', '150782400', 'm');
INSERT INTO `sys_data_region` VALUES (5232, '牙克石农场', 4, '150782', '150782401', 'y');
INSERT INTO `sys_data_region` VALUES (5233, '免渡河农场', 4, '150782', '150782402', 'm');
INSERT INTO `sys_data_region` VALUES (5234, '扎兰屯', 3, '1507', '150783', 'z');
INSERT INTO `sys_data_region` VALUES (5235, '兴华', 4, '150783', '150783001', 'x');
INSERT INTO `sys_data_region` VALUES (5236, '正阳', 4, '150783', '150783002', 'z');
INSERT INTO `sys_data_region` VALUES (5237, '繁荣', 4, '150783', '150783003', 'f');
INSERT INTO `sys_data_region` VALUES (5238, '向阳', 4, '150783', '150783004', 'x');
INSERT INTO `sys_data_region` VALUES (5239, '铁东', 4, '150783', '150783005', 't');
INSERT INTO `sys_data_region` VALUES (5240, '河西', 4, '150783', '150783006', 'h');
INSERT INTO `sys_data_region` VALUES (5241, '高台子', 4, '150783', '150783007', 'g');
INSERT INTO `sys_data_region` VALUES (5242, '磨菇气', 4, '150783', '150783100', 'm');
INSERT INTO `sys_data_region` VALUES (5243, '卧牛河', 4, '150783', '150783106', 'w');
INSERT INTO `sys_data_region` VALUES (5244, '成吉思汗', 4, '150783', '150783108', 'c');
INSERT INTO `sys_data_region` VALUES (5245, '大河湾', 4, '150783', '150783109', 'd');
INSERT INTO `sys_data_region` VALUES (5246, '哈多河', 4, '150783', '150783110', 'h');
INSERT INTO `sys_data_region` VALUES (5247, '浩饶山', 4, '150783', '150783112', 'h');
INSERT INTO `sys_data_region` VALUES (5248, '柴河', 4, '150783', '150783113', 'c');
INSERT INTO `sys_data_region` VALUES (5249, '中和', 4, '150783', '150783114', 'z');
INSERT INTO `sys_data_region` VALUES (5250, '达斡尔民族', 4, '150783', '150783200', 'd');
INSERT INTO `sys_data_region` VALUES (5251, '鄂伦春民族', 4, '150783', '150783201', 'e');
INSERT INTO `sys_data_region` VALUES (5252, '萨马街', 4, '150783', '150783204', 's');
INSERT INTO `sys_data_region` VALUES (5253, '洼堤', 4, '150783', '150783205', 'w');
INSERT INTO `sys_data_region` VALUES (5254, '大河湾农场', 4, '150783', '150783400', 'd');
INSERT INTO `sys_data_region` VALUES (5255, '绰尔河农场', 4, '150783', '150783401', 'c');
INSERT INTO `sys_data_region` VALUES (5256, '扎兰屯马场', 4, '150783', '150783402', 'z');
INSERT INTO `sys_data_region` VALUES (5257, '成吉思汗牧场', 4, '150783', '150783403', 'c');
INSERT INTO `sys_data_region` VALUES (5258, '公安部后勤供应处农场', 4, '150783', '150783404', 'g');
INSERT INTO `sys_data_region` VALUES (5259, '南木林业局', 4, '150783', '150783405', 'n');
INSERT INTO `sys_data_region` VALUES (5260, '柴河林业局', 4, '150783', '150783406', 'c');
INSERT INTO `sys_data_region` VALUES (5261, '扎兰屯市林业局', 4, '150783', '150783407', 'z');
INSERT INTO `sys_data_region` VALUES (5262, '额尔古纳', 3, '1507', '150784', 'e');
INSERT INTO `sys_data_region` VALUES (5263, '拉布大林', 4, '150784', '150784001', 'l');
INSERT INTO `sys_data_region` VALUES (5264, '上库力', 4, '150784', '150784002', 's');
INSERT INTO `sys_data_region` VALUES (5265, '莫尔道嘎', 4, '150784', '150784100', 'm');
INSERT INTO `sys_data_region` VALUES (5266, '黑山头', 4, '150784', '150784101', 'h');
INSERT INTO `sys_data_region` VALUES (5267, '恩和哈达', 4, '150784', '150784102', 'e');
INSERT INTO `sys_data_region` VALUES (5268, '三河', 4, '150784', '150784200', 's');
INSERT INTO `sys_data_region` VALUES (5269, '蒙兀室韦苏木', 4, '150784', '150784201', 'm');
INSERT INTO `sys_data_region` VALUES (5270, '恩和', 4, '150784', '150784203', 'e');
INSERT INTO `sys_data_region` VALUES (5271, '奇乾', 4, '150784', '150784204', 'q');
INSERT INTO `sys_data_region` VALUES (5272, '根河', 3, '1507', '150785', 'g');
INSERT INTO `sys_data_region` VALUES (5273, '河东', 4, '150785', '150785001', 'h');
INSERT INTO `sys_data_region` VALUES (5274, '河西', 4, '150785', '150785002', 'h');
INSERT INTO `sys_data_region` VALUES (5275, '森工', 4, '150785', '150785003', 's');
INSERT INTO `sys_data_region` VALUES (5276, '金河', 4, '150785', '150785102', 'j');
INSERT INTO `sys_data_region` VALUES (5277, '阿龙山', 4, '150785', '150785103', 'a');
INSERT INTO `sys_data_region` VALUES (5278, '满归', 4, '150785', '150785104', 'm');
INSERT INTO `sys_data_region` VALUES (5279, '得耳布尔', 4, '150785', '150785105', 'd');
INSERT INTO `sys_data_region` VALUES (5280, '敖鲁古雅', 4, '150785', '150785200', 'a');
INSERT INTO `sys_data_region` VALUES (5281, '巴彦淖尔', 2, '15', '1508', 'b');
INSERT INTO `sys_data_region` VALUES (5282, '临河', 3, '1508', '150802', 'l');
INSERT INTO `sys_data_region` VALUES (5283, '团结', 4, '150802', '150802001', 't');
INSERT INTO `sys_data_region` VALUES (5284, '车站', 4, '150802', '150802002', 'c');
INSERT INTO `sys_data_region` VALUES (5285, '先锋', 4, '150802', '150802003', 'x');
INSERT INTO `sys_data_region` VALUES (5286, '解放', 4, '150802', '150802004', 'j');
INSERT INTO `sys_data_region` VALUES (5287, '新华街道', 4, '150802', '150802005', 'x');
INSERT INTO `sys_data_region` VALUES (5288, '东环', 4, '150802', '150802006', 'd');
INSERT INTO `sys_data_region` VALUES (5289, '铁南', 4, '150802', '150802007', 't');
INSERT INTO `sys_data_region` VALUES (5290, '西环', 4, '150802', '150802008', 'x');
INSERT INTO `sys_data_region` VALUES (5291, '北环', 4, '150802', '150802009', 'b');
INSERT INTO `sys_data_region` VALUES (5292, '金川', 4, '150802', '150802010', 'j');
INSERT INTO `sys_data_region` VALUES (5293, '汇丰', 4, '150802', '150802011', 'h');
INSERT INTO `sys_data_region` VALUES (5294, '狼山', 4, '150802', '150802100', 'l');
INSERT INTO `sys_data_region` VALUES (5295, '新华镇', 4, '150802', '150802101', 'x');
INSERT INTO `sys_data_region` VALUES (5296, '干召庙', 4, '150802', '150802102', 'g');
INSERT INTO `sys_data_region` VALUES (5297, '乌兰图克', 4, '150802', '150802104', 'w');
INSERT INTO `sys_data_region` VALUES (5298, '双河', 4, '150802', '150802107', 's');
INSERT INTO `sys_data_region` VALUES (5299, '城关', 4, '150802', '150802109', 'c');
INSERT INTO `sys_data_region` VALUES (5300, '白脑包', 4, '150802', '150802110', 'b');
INSERT INTO `sys_data_region` VALUES (5301, '八一', 4, '150802', '150802200', 'b');
INSERT INTO `sys_data_region` VALUES (5302, '曙光', 4, '150802', '150802201', 's');
INSERT INTO `sys_data_region` VALUES (5303, '狼山农场', 4, '150802', '150802400', 'l');
INSERT INTO `sys_data_region` VALUES (5304, '临河农场', 4, '150802', '150802401', 'l');
INSERT INTO `sys_data_region` VALUES (5305, '五原', 3, '1508', '150821', 'w');
INSERT INTO `sys_data_region` VALUES (5306, '隆兴昌', 4, '150821', '150821100', 'l');
INSERT INTO `sys_data_region` VALUES (5307, '塔尔湖', 4, '150821', '150821101', 't');
INSERT INTO `sys_data_region` VALUES (5308, '巴彦套海', 4, '150821', '150821102', 'b');
INSERT INTO `sys_data_region` VALUES (5309, '新公中', 4, '150821', '150821104', 'x');
INSERT INTO `sys_data_region` VALUES (5310, '天吉泰', 4, '150821', '150821105', 't');
INSERT INTO `sys_data_region` VALUES (5311, '胜丰', 4, '150821', '150821106', 's');
INSERT INTO `sys_data_region` VALUES (5312, '银定图', 4, '150821', '150821107', 'y');
INSERT INTO `sys_data_region` VALUES (5313, '复兴', 4, '150821', '150821108', 'f');
INSERT INTO `sys_data_region` VALUES (5314, '和胜', 4, '150821', '150821200', 'h');
INSERT INTO `sys_data_region` VALUES (5315, '磴口', 3, '1508', '150822', 'd');
INSERT INTO `sys_data_region` VALUES (5316, '巴彦高勒', 4, '150822', '150822100', 'b');
INSERT INTO `sys_data_region` VALUES (5317, '隆盛合', 4, '150822', '150822103', 'l');
INSERT INTO `sys_data_region` VALUES (5318, '渡口', 4, '150822', '150822104', 'd');
INSERT INTO `sys_data_region` VALUES (5319, '补隆淖', 4, '150822', '150822105', 'b');
INSERT INTO `sys_data_region` VALUES (5320, '沙金套海苏木', 4, '150822', '150822202', 's');
INSERT INTO `sys_data_region` VALUES (5321, '乌兰布和农场', 4, '150822', '150822500', 'w');
INSERT INTO `sys_data_region` VALUES (5322, '巴彦套海农场', 4, '150822', '150822501', 'b');
INSERT INTO `sys_data_region` VALUES (5323, '哈腾套海农场', 4, '150822', '150822502', 'h');
INSERT INTO `sys_data_region` VALUES (5324, '包尔盖农场', 4, '150822', '150822503', 'b');
INSERT INTO `sys_data_region` VALUES (5325, '纳林套海农场', 4, '150822', '150822504', 'n');
INSERT INTO `sys_data_region` VALUES (5326, '沙漠林业实验中心农场', 4, '150822', '150822505', 's');
INSERT INTO `sys_data_region` VALUES (5327, '乌拉特前旗', 3, '1508', '150823', 'w');
INSERT INTO `sys_data_region` VALUES (5328, '乌拉山', 4, '150823', '150823101', 'w');
INSERT INTO `sys_data_region` VALUES (5329, '白彦花', 4, '150823', '150823102', 'b');
INSERT INTO `sys_data_region` VALUES (5330, '新安', 4, '150823', '150823103', 'x');
INSERT INTO `sys_data_region` VALUES (5331, '大佘太', 4, '150823', '150823104', 'd');
INSERT INTO `sys_data_region` VALUES (5332, '西小召', 4, '150823', '150823106', 'x');
INSERT INTO `sys_data_region` VALUES (5333, '明安', 4, '150823', '150823108', 'm');
INSERT INTO `sys_data_region` VALUES (5334, '先锋', 4, '150823', '150823109', 'x');
INSERT INTO `sys_data_region` VALUES (5335, '小佘太', 4, '150823', '150823110', 'x');
INSERT INTO `sys_data_region` VALUES (5336, '苏独仑', 4, '150823', '150823111', 's');
INSERT INTO `sys_data_region` VALUES (5337, '额尔登布拉格苏木', 4, '150823', '150823209', 'e');
INSERT INTO `sys_data_region` VALUES (5338, '沙德格苏木', 4, '150823', '150823210', 's');
INSERT INTO `sys_data_region` VALUES (5339, '乌拉特中旗', 3, '1508', '150824', 'w');
INSERT INTO `sys_data_region` VALUES (5340, '德岭山', 4, '150824', '150824100', 'd');
INSERT INTO `sys_data_region` VALUES (5341, '石哈河', 4, '150824', '150824101', 's');
INSERT INTO `sys_data_region` VALUES (5342, '海流图', 4, '150824', '150824102', 'h');
INSERT INTO `sys_data_region` VALUES (5343, '乌加河', 4, '150824', '150824103', 'w');
INSERT INTO `sys_data_region` VALUES (5344, '甘其毛都', 4, '150824', '150824105', 'g');
INSERT INTO `sys_data_region` VALUES (5345, '温更', 4, '150824', '150824106', 'w');
INSERT INTO `sys_data_region` VALUES (5346, '巴音乌兰苏木', 4, '150824', '150824203', 'b');
INSERT INTO `sys_data_region` VALUES (5347, '呼勒斯太苏木', 4, '150824', '150824205', 'h');
INSERT INTO `sys_data_region` VALUES (5348, '新忽热苏木', 4, '150824', '150824207', 'x');
INSERT INTO `sys_data_region` VALUES (5349, '川井苏木', 4, '150824', '150824208', 'c');
INSERT INTO `sys_data_region` VALUES (5350, '乌拉特后旗', 3, '1508', '150825', 'w');
INSERT INTO `sys_data_region` VALUES (5351, '巴音宝力格', 4, '150825', '150825100', 'b');
INSERT INTO `sys_data_region` VALUES (5352, '呼和温都尔', 4, '150825', '150825101', 'h');
INSERT INTO `sys_data_region` VALUES (5353, '潮格温都尔', 4, '150825', '150825103', 'c');
INSERT INTO `sys_data_region` VALUES (5354, '获各琦苏木', 4, '150825', '150825204', 'h');
INSERT INTO `sys_data_region` VALUES (5355, '巴音前达门苏木', 4, '150825', '150825207', 'b');
INSERT INTO `sys_data_region` VALUES (5356, '乌盖苏木', 4, '150825', '150825208', 'w');
INSERT INTO `sys_data_region` VALUES (5357, '杭锦后旗', 3, '1508', '150826', 'h');
INSERT INTO `sys_data_region` VALUES (5358, '头道桥', 4, '150826', '150826101', 't');
INSERT INTO `sys_data_region` VALUES (5359, '二道桥', 4, '150826', '150826102', 'e');
INSERT INTO `sys_data_region` VALUES (5360, '三道桥', 4, '150826', '150826103', 's');
INSERT INTO `sys_data_region` VALUES (5361, '团结', 4, '150826', '150826104', 't');
INSERT INTO `sys_data_region` VALUES (5362, '双庙', 4, '150826', '150826105', 's');
INSERT INTO `sys_data_region` VALUES (5363, '蛮会', 4, '150826', '150826106', 'm');
INSERT INTO `sys_data_region` VALUES (5364, '陕坝', 4, '150826', '150826107', 's');
INSERT INTO `sys_data_region` VALUES (5365, '沙海', 4, '150826', '150826108', 's');
INSERT INTO `sys_data_region` VALUES (5366, '蒙海', 4, '150826', '150826109', 'm');
INSERT INTO `sys_data_region` VALUES (5367, '太阳庙农场', 4, '150826', '150826500', 't');
INSERT INTO `sys_data_region` VALUES (5368, '乌兰察布', 2, '15', '1509', 'w');
INSERT INTO `sys_data_region` VALUES (5369, '集宁', 3, '1509', '150902', 'j');
INSERT INTO `sys_data_region` VALUES (5370, '新体路', 4, '150902', '150902001', 'x');
INSERT INTO `sys_data_region` VALUES (5371, '桥东', 4, '150902', '150902002', 'q');
INSERT INTO `sys_data_region` VALUES (5372, '前进路', 4, '150902', '150902003', 'q');
INSERT INTO `sys_data_region` VALUES (5373, '常青', 4, '150902', '150902004', 'c');
INSERT INTO `sys_data_region` VALUES (5374, '虎山', 4, '150902', '150902005', 'h');
INSERT INTO `sys_data_region` VALUES (5375, '桥西', 4, '150902', '150902006', 'q');
INSERT INTO `sys_data_region` VALUES (5376, '新华街', 4, '150902', '150902007', 'x');
INSERT INTO `sys_data_region` VALUES (5377, '泉山', 4, '150902', '150902008', 'q');
INSERT INTO `sys_data_region` VALUES (5378, '白海子', 4, '150902', '150902101', 'b');
INSERT INTO `sys_data_region` VALUES (5379, '马莲渠', 4, '150902', '150902205', 'm');
INSERT INTO `sys_data_region` VALUES (5380, '卓资', 3, '1509', '150921', 'z');
INSERT INTO `sys_data_region` VALUES (5381, '卓资山', 4, '150921', '150921100', 'z');
INSERT INTO `sys_data_region` VALUES (5382, '旗下营', 4, '150921', '150921101', 'q');
INSERT INTO `sys_data_region` VALUES (5383, '十八台', 4, '150921', '150921102', 's');
INSERT INTO `sys_data_region` VALUES (5384, '巴音锡勒', 4, '150921', '150921103', 'b');
INSERT INTO `sys_data_region` VALUES (5385, '梨花', 4, '150921', '150921104', 'l');
INSERT INTO `sys_data_region` VALUES (5386, '大榆树', 4, '150921', '150921203', 'd');
INSERT INTO `sys_data_region` VALUES (5387, '红召', 4, '150921', '150921208', 'h');
INSERT INTO `sys_data_region` VALUES (5388, '复兴', 4, '150921', '150921209', 'f');
INSERT INTO `sys_data_region` VALUES (5389, '化德', 3, '1509', '150922', 'h');
INSERT INTO `sys_data_region` VALUES (5390, '长顺', 4, '150922', '150922100', 'c');
INSERT INTO `sys_data_region` VALUES (5391, '七号', 4, '150922', '150922101', 'q');
INSERT INTO `sys_data_region` VALUES (5392, '朝阳', 4, '150922', '150922102', 'z');
INSERT INTO `sys_data_region` VALUES (5393, '德包图', 4, '150922', '150922205', 'd');
INSERT INTO `sys_data_region` VALUES (5394, '公腊胡洞', 4, '150922', '150922207', 'g');
INSERT INTO `sys_data_region` VALUES (5395, '白音特拉', 4, '150922', '150922208', 'b');
INSERT INTO `sys_data_region` VALUES (5396, '商都', 3, '1509', '150923', 's');
INSERT INTO `sys_data_region` VALUES (5397, '七台', 4, '150923', '150923100', 'q');
INSERT INTO `sys_data_region` VALUES (5398, '十八顷', 4, '150923', '150923101', 's');
INSERT INTO `sys_data_region` VALUES (5399, '大黑沙土', 4, '150923', '150923102', 'd');
INSERT INTO `sys_data_region` VALUES (5400, '西井子', 4, '150923', '150923103', 'x');
INSERT INTO `sys_data_region` VALUES (5401, '屯垦队', 4, '150923', '150923104', 't');
INSERT INTO `sys_data_region` VALUES (5402, '小海子', 4, '150923', '150923105', 'x');
INSERT INTO `sys_data_region` VALUES (5403, '大库伦', 4, '150923', '150923205', 'd');
INSERT INTO `sys_data_region` VALUES (5404, '卯都', 4, '150923', '150923206', 'm');
INSERT INTO `sys_data_region` VALUES (5405, '玻璃忽镜', 4, '150923', '150923207', 'b');
INSERT INTO `sys_data_region` VALUES (5406, '三大顷', 4, '150923', '150923208', 's');
INSERT INTO `sys_data_region` VALUES (5407, '兴和', 3, '1509', '150924', 'x');
INSERT INTO `sys_data_region` VALUES (5408, '城关', 4, '150924', '150924100', 'c');
INSERT INTO `sys_data_region` VALUES (5409, '张皋', 4, '150924', '150924101', 'z');
INSERT INTO `sys_data_region` VALUES (5410, '赛乌素', 4, '150924', '150924102', 's');
INSERT INTO `sys_data_region` VALUES (5411, '鄂尔栋', 4, '150924', '150924103', 'e');
INSERT INTO `sys_data_region` VALUES (5412, '店子', 4, '150924', '150924105', 'd');
INSERT INTO `sys_data_region` VALUES (5413, '大库联', 4, '150924', '150924202', 'd');
INSERT INTO `sys_data_region` VALUES (5414, '民族团结', 4, '150924', '150924205', 'm');
INSERT INTO `sys_data_region` VALUES (5415, '大同夭', 4, '150924', '150924206', 'd');
INSERT INTO `sys_data_region` VALUES (5416, '五股泉', 4, '150924', '150924207', 'w');
INSERT INTO `sys_data_region` VALUES (5417, '凉城', 3, '1509', '150925', 'l');
INSERT INTO `sys_data_region` VALUES (5418, '岱海', 4, '150925', '150925100', 'd');
INSERT INTO `sys_data_region` VALUES (5419, '麦胡图', 4, '150925', '150925101', 'm');
INSERT INTO `sys_data_region` VALUES (5420, '永兴', 4, '150925', '150925102', 'y');
INSERT INTO `sys_data_region` VALUES (5421, '六苏木', 4, '150925', '150925103', 'l');
INSERT INTO `sys_data_region` VALUES (5422, '蛮汉', 4, '150925', '150925104', 'm');
INSERT INTO `sys_data_region` VALUES (5423, '鸿茅', 4, '150925', '150925105', 'h');
INSERT INTO `sys_data_region` VALUES (5424, '天成', 4, '150925', '150925204', 't');
INSERT INTO `sys_data_region` VALUES (5425, '曹碾', 4, '150925', '150925207', 'c');
INSERT INTO `sys_data_region` VALUES (5426, '察哈尔右翼前旗', 3, '1509', '150926', 'c');
INSERT INTO `sys_data_region` VALUES (5427, '土贵乌拉', 4, '150926', '150926100', 't');
INSERT INTO `sys_data_region` VALUES (5428, '平地泉', 4, '150926', '150926101', 'p');
INSERT INTO `sys_data_region` VALUES (5429, '玫瑰营', 4, '150926', '150926102', 'm');
INSERT INTO `sys_data_region` VALUES (5430, '巴音塔拉', 4, '150926', '150926104', 'b');
INSERT INTO `sys_data_region` VALUES (5431, '黄旗海', 4, '150926', '150926105', 'h');
INSERT INTO `sys_data_region` VALUES (5432, '乌拉哈', 4, '150926', '150926202', 'w');
INSERT INTO `sys_data_region` VALUES (5433, '黄茂营', 4, '150926', '150926203', 'h');
INSERT INTO `sys_data_region` VALUES (5434, '三岔口', 4, '150926', '150926208', 's');
INSERT INTO `sys_data_region` VALUES (5435, '老圈沟', 4, '150926', '150926209', 'l');
INSERT INTO `sys_data_region` VALUES (5436, '察右前旗天皮山冶金化工工业园区', 4, '150926', '150926400', 'c');
INSERT INTO `sys_data_region` VALUES (5437, '察哈尔右翼中旗', 3, '1509', '150927', 'c');
INSERT INTO `sys_data_region` VALUES (5438, '科布尔', 4, '150927', '150927100', 'k');
INSERT INTO `sys_data_region` VALUES (5439, '铁沙盖', 4, '150927', '150927101', 't');
INSERT INTO `sys_data_region` VALUES (5440, '乌素图', 4, '150927', '150927102', 'w');
INSERT INTO `sys_data_region` VALUES (5441, '广益隆', 4, '150927', '150927103', 'g');
INSERT INTO `sys_data_region` VALUES (5442, '黄羊城', 4, '150927', '150927104', 'h');
INSERT INTO `sys_data_region` VALUES (5443, '宏盘', 4, '150927', '150927203', 'h');
INSERT INTO `sys_data_region` VALUES (5444, '巴彦', 4, '150927', '150927204', 'b');
INSERT INTO `sys_data_region` VALUES (5445, '大滩', 4, '150927', '150927211', 'd');
INSERT INTO `sys_data_region` VALUES (5446, '乌兰哈页苏木', 4, '150927', '150927214', 'w');
INSERT INTO `sys_data_region` VALUES (5447, '库伦苏木', 4, '150927', '150927215', 'k');
INSERT INTO `sys_data_region` VALUES (5448, '察右中旗土城子', 4, '150927', '150927216', 'c');
INSERT INTO `sys_data_region` VALUES (5449, '辉腾锡勒园区管理委员会', 4, '150927', '150927400', 'h');
INSERT INTO `sys_data_region` VALUES (5450, '察哈尔右翼后旗', 3, '1509', '150928', 'c');
INSERT INTO `sys_data_region` VALUES (5451, '察哈尔右翼后旗土牧尔台', 4, '150928', '150928100', 'c');
INSERT INTO `sys_data_region` VALUES (5452, '红格尔图', 4, '150928', '150928101', 'h');
INSERT INTO `sys_data_region` VALUES (5453, '白音察干', 4, '150928', '150928102', 'b');
INSERT INTO `sys_data_region` VALUES (5454, '贲红', 4, '150928', '150928103', 'b');
INSERT INTO `sys_data_region` VALUES (5455, '大六号', 4, '150928', '150928105', 'd');
INSERT INTO `sys_data_region` VALUES (5456, '当郎忽洞苏木', 4, '150928', '150928204', 'd');
INSERT INTO `sys_data_region` VALUES (5457, '察哈尔右翼后旗锡勒', 4, '150928', '150928206', 'c');
INSERT INTO `sys_data_region` VALUES (5458, '乌兰哈达苏木', 4, '150928', '150928207', 'w');
INSERT INTO `sys_data_region` VALUES (5459, '四子王旗', 3, '1509', '150929', 's');
INSERT INTO `sys_data_region` VALUES (5460, '四子王旗乌兰花', 4, '150929', '150929100', 's');
INSERT INTO `sys_data_region` VALUES (5461, '供济堂', 4, '150929', '150929101', 'g');
INSERT INTO `sys_data_region` VALUES (5462, '吉生太', 4, '150929', '150929102', 'j');
INSERT INTO `sys_data_region` VALUES (5463, '库伦图', 4, '150929', '150929103', 'k');
INSERT INTO `sys_data_region` VALUES (5464, '白音朝克图', 4, '150929', '150929104', 'b');
INSERT INTO `sys_data_region` VALUES (5465, '东八号', 4, '150929', '150929208', 'd');
INSERT INTO `sys_data_region` VALUES (5466, '忽鸡图', 4, '150929', '150929211', 'h');
INSERT INTO `sys_data_region` VALUES (5467, '查干补力格苏木', 4, '150929', '150929215', 'c');
INSERT INTO `sys_data_region` VALUES (5468, '脑木更苏木', 4, '150929', '150929219', 'n');
INSERT INTO `sys_data_region` VALUES (5469, '红格尔苏木', 4, '150929', '150929223', 'h');
INSERT INTO `sys_data_region` VALUES (5470, '江岸苏木', 4, '150929', '150929225', 'j');
INSERT INTO `sys_data_region` VALUES (5471, '巴音敖包苏木', 4, '150929', '150929227', 'b');
INSERT INTO `sys_data_region` VALUES (5472, '大黑河', 4, '150929', '150929228', 'd');
INSERT INTO `sys_data_region` VALUES (5473, '丰镇', 3, '1509', '150981', 'f');
INSERT INTO `sys_data_region` VALUES (5474, '新城区', 4, '150981', '150981001', 'x');
INSERT INTO `sys_data_region` VALUES (5475, '旧城区', 4, '150981', '150981002', 'j');
INSERT INTO `sys_data_region` VALUES (5476, '北城区', 4, '150981', '150981003', 'b');
INSERT INTO `sys_data_region` VALUES (5477, '工业区', 4, '150981', '150981004', 'g');
INSERT INTO `sys_data_region` VALUES (5478, '南城区', 4, '150981', '150981005', 'n');
INSERT INTO `sys_data_region` VALUES (5479, '黑土台', 4, '150981', '150981101', 'h');
INSERT INTO `sys_data_region` VALUES (5480, '隆盛庄', 4, '150981', '150981102', 'l');
INSERT INTO `sys_data_region` VALUES (5481, '巨宝庄', 4, '150981', '150981103', 'j');
INSERT INTO `sys_data_region` VALUES (5482, '红砂坝', 4, '150981', '150981104', 'h');
INSERT INTO `sys_data_region` VALUES (5483, '三义泉', 4, '150981', '150981105', 's');
INSERT INTO `sys_data_region` VALUES (5484, '浑源窑', 4, '150981', '150981201', 'h');
INSERT INTO `sys_data_region` VALUES (5485, '官屯堡', 4, '150981', '150981205', 'g');
INSERT INTO `sys_data_region` VALUES (5486, '元山子', 4, '150981', '150981206', 'y');
INSERT INTO `sys_data_region` VALUES (5487, '兴安', 2, '15', '1522', 'x');
INSERT INTO `sys_data_region` VALUES (5488, '乌兰浩特', 3, '1522', '152201', 'w');
INSERT INTO `sys_data_region` VALUES (5489, '爱国', 4, '152201', '152201001', 'a');
INSERT INTO `sys_data_region` VALUES (5490, '和平', 4, '152201', '152201002', 'h');
INSERT INTO `sys_data_region` VALUES (5491, '兴安', 4, '152201', '152201003', 'x');
INSERT INTO `sys_data_region` VALUES (5492, '胜利', 4, '152201', '152201004', 's');
INSERT INTO `sys_data_region` VALUES (5493, '铁西', 4, '152201', '152201005', 't');
INSERT INTO `sys_data_region` VALUES (5494, '都林', 4, '152201', '152201006', 'd');
INSERT INTO `sys_data_region` VALUES (5495, '五一', 4, '152201', '152201007', 'w');
INSERT INTO `sys_data_region` VALUES (5496, '城郊', 4, '152201', '152201008', 'c');
INSERT INTO `sys_data_region` VALUES (5497, '乌兰哈达', 4, '152201', '152201101', 'w');
INSERT INTO `sys_data_region` VALUES (5498, '葛根庙', 4, '152201', '152201102', 'g');
INSERT INTO `sys_data_region` VALUES (5499, '太本站', 4, '152201', '152201103', 't');
INSERT INTO `sys_data_region` VALUES (5500, '义勒力特', 4, '152201', '152201104', 'y');
INSERT INTO `sys_data_region` VALUES (5501, '呼和马场', 4, '152201', '152201401', 'h');
INSERT INTO `sys_data_region` VALUES (5502, '阿尔山', 3, '1522', '152202', 'a');
INSERT INTO `sys_data_region` VALUES (5503, '林海', 4, '152202', '152202001', 'l');
INSERT INTO `sys_data_region` VALUES (5504, '新城', 4, '152202', '152202002', 'x');
INSERT INTO `sys_data_region` VALUES (5505, '温泉', 4, '152202', '152202003', 'w');
INSERT INTO `sys_data_region` VALUES (5506, '伊尔施', 4, '152202', '152202004', 'y');
INSERT INTO `sys_data_region` VALUES (5507, '阿尔山市天池', 4, '152202', '152202100', 'a');
INSERT INTO `sys_data_region` VALUES (5508, '白狼', 4, '152202', '152202101', 'b');
INSERT INTO `sys_data_region` VALUES (5509, '五岔沟', 4, '152202', '152202102', 'w');
INSERT INTO `sys_data_region` VALUES (5510, '明水河', 4, '152202', '152202103', 'm');
INSERT INTO `sys_data_region` VALUES (5511, '科尔沁右翼前旗', 3, '1522', '152221', 'k');
INSERT INTO `sys_data_region` VALUES (5512, '索伦', 4, '152221', '152221100', 's');
INSERT INTO `sys_data_region` VALUES (5513, '大石寨', 4, '152221', '152221101', 'd');
INSERT INTO `sys_data_region` VALUES (5514, '归流河', 4, '152221', '152221102', 'g');
INSERT INTO `sys_data_region` VALUES (5515, '察尔森', 4, '152221', '152221103', 'c');
INSERT INTO `sys_data_region` VALUES (5516, '科尔沁', 4, '152221', '152221104', 'k');
INSERT INTO `sys_data_region` VALUES (5517, '额尔格图', 4, '152221', '152221110', 'e');
INSERT INTO `sys_data_region` VALUES (5518, '德伯斯', 4, '152221', '152221111', 'd');
INSERT INTO `sys_data_region` VALUES (5519, '居力很', 4, '152221', '152221119', 'j');
INSERT INTO `sys_data_region` VALUES (5520, '俄体', 4, '152221', '152221120', 'e');
INSERT INTO `sys_data_region` VALUES (5521, '满族屯', 4, '152221', '152221203', 'm');
INSERT INTO `sys_data_region` VALUES (5522, '乌兰毛都苏木', 4, '152221', '152221205', 'w');
INSERT INTO `sys_data_region` VALUES (5523, '阿力得尔苏木', 4, '152221', '152221207', 'a');
INSERT INTO `sys_data_region` VALUES (5524, '巴日嘎斯台', 4, '152221', '152221208', 'b');
INSERT INTO `sys_data_region` VALUES (5525, '桃合木苏木', 4, '152221', '152221209', 't');
INSERT INTO `sys_data_region` VALUES (5526, '跃进马场', 4, '152221', '152221400', 'y');
INSERT INTO `sys_data_region` VALUES (5527, '索伦牧场', 4, '152221', '152221401', 's');
INSERT INTO `sys_data_region` VALUES (5528, '阿力得尔牧场', 4, '152221', '152221403', 'a');
INSERT INTO `sys_data_region` VALUES (5529, '公主陵牧场', 4, '152221', '152221404', 'g');
INSERT INTO `sys_data_region` VALUES (5530, '绿水种畜场', 4, '152221', '152221405', 'l');
INSERT INTO `sys_data_region` VALUES (5531, '科右前旗工业园区', 4, '152221', '152221407', 'k');
INSERT INTO `sys_data_region` VALUES (5532, '科尔沁右翼中旗', 3, '1522', '152222', 'k');
INSERT INTO `sys_data_region` VALUES (5533, '巴彦呼舒', 4, '152222', '152222100', 'b');
INSERT INTO `sys_data_region` VALUES (5534, '高力板', 4, '152222', '152222101', 'g');
INSERT INTO `sys_data_region` VALUES (5535, '吐列毛都', 4, '152222', '152222102', 't');
INSERT INTO `sys_data_region` VALUES (5536, '巴仁哲里木', 4, '152222', '152222103', 'b');
INSERT INTO `sys_data_region` VALUES (5537, '杜尔基', 4, '152222', '152222104', 'd');
INSERT INTO `sys_data_region` VALUES (5538, '好腰苏木', 4, '152222', '152222105', 'h');
INSERT INTO `sys_data_region` VALUES (5539, '新佳木苏木', 4, '152222', '152222203', 'x');
INSERT INTO `sys_data_region` VALUES (5540, '代钦塔拉苏木', 4, '152222', '152222206', 'd');
INSERT INTO `sys_data_region` VALUES (5541, '哈日诺尔苏木', 4, '152222', '152222207', 'h');
INSERT INTO `sys_data_region` VALUES (5542, '巴彦茫哈苏木', 4, '152222', '152222208', 'b');
INSERT INTO `sys_data_region` VALUES (5543, '巴彦淖尔苏木', 4, '152222', '152222209', 'b');
INSERT INTO `sys_data_region` VALUES (5544, '额木庭高勒苏木', 4, '152222', '152222210', 'e');
INSERT INTO `sys_data_region` VALUES (5545, '布敦化牧场', 4, '152222', '152222400', 'b');
INSERT INTO `sys_data_region` VALUES (5546, '吐列毛杜农场', 4, '152222', '152222401', 't');
INSERT INTO `sys_data_region` VALUES (5547, '孟恩套力盖矿区工作部', 4, '152222', '152222402', 'm');
INSERT INTO `sys_data_region` VALUES (5548, '布敦化矿区工作部', 4, '152222', '152222403', 'b');
INSERT INTO `sys_data_region` VALUES (5549, '扎赉特旗', 3, '1522', '152223', 'z');
INSERT INTO `sys_data_region` VALUES (5550, '音德尔', 4, '152223', '152223100', 'y');
INSERT INTO `sys_data_region` VALUES (5551, '新林', 4, '152223', '152223101', 'x');
INSERT INTO `sys_data_region` VALUES (5552, '巴彦高勒', 4, '152223', '152223102', 'b');
INSERT INTO `sys_data_region` VALUES (5553, '胡尔勒', 4, '152223', '152223103', 'h');
INSERT INTO `sys_data_region` VALUES (5554, '阿尔本格勒', 4, '152223', '152223104', 'a');
INSERT INTO `sys_data_region` VALUES (5555, '巴达尔胡', 4, '152223', '152223105', 'b');
INSERT INTO `sys_data_region` VALUES (5556, '图牧吉', 4, '152223', '152223107', 't');
INSERT INTO `sys_data_region` VALUES (5557, '好力保', 4, '152223', '152223108', 'h');
INSERT INTO `sys_data_region` VALUES (5558, '巴彦乌兰苏木', 4, '152223', '152223210', 'b');
INSERT INTO `sys_data_region` VALUES (5559, '努文木仁', 4, '152223', '152223211', 'n');
INSERT INTO `sys_data_region` VALUES (5560, '巴彦扎拉嘎', 4, '152223', '152223212', 'b');
INSERT INTO `sys_data_region` VALUES (5561, '阿拉达尔吐苏木', 4, '152223', '152223213', 'a');
INSERT INTO `sys_data_region` VALUES (5562, '宝力根花苏木', 4, '152223', '152223214', 'b');
INSERT INTO `sys_data_region` VALUES (5563, '种畜场', 4, '152223', '152223404', 'z');
INSERT INTO `sys_data_region` VALUES (5564, '八一牧场', 4, '152223', '152223405', 'b');
INSERT INTO `sys_data_region` VALUES (5565, '巴达尔胡农场', 4, '152223', '152223406', 'b');
INSERT INTO `sys_data_region` VALUES (5566, '突泉', 3, '1522', '152224', 't');
INSERT INTO `sys_data_region` VALUES (5567, '突泉镇', 4, '152224', '152224100', 't');
INSERT INTO `sys_data_region` VALUES (5568, '六户', 4, '152224', '152224101', 'l');
INSERT INTO `sys_data_region` VALUES (5569, '东杜尔基', 4, '152224', '152224102', 'd');
INSERT INTO `sys_data_region` VALUES (5570, '永安', 4, '152224', '152224103', 'y');
INSERT INTO `sys_data_region` VALUES (5571, '水泉', 4, '152224', '152224104', 's');
INSERT INTO `sys_data_region` VALUES (5572, '宝石', 4, '152224', '152224105', 'b');
INSERT INTO `sys_data_region` VALUES (5573, '九龙', 4, '152224', '152224200', 'j');
INSERT INTO `sys_data_region` VALUES (5574, '太平', 4, '152224', '152224201', 't');
INSERT INTO `sys_data_region` VALUES (5575, '学田', 4, '152224', '152224202', 'x');
INSERT INTO `sys_data_region` VALUES (5576, '东杜尔基国营农场', 4, '152224', '152224400', 'd');
INSERT INTO `sys_data_region` VALUES (5577, '锡林郭勒', 2, '15', '1525', 'x');
INSERT INTO `sys_data_region` VALUES (5578, '二连浩特', 3, '1525', '152501', 'e');
INSERT INTO `sys_data_region` VALUES (5579, '格日勒敖都苏木', 4, '152501', '152501200', 'g');
INSERT INTO `sys_data_region` VALUES (5580, '二连浩特市社区建设管理局', 4, '152501', '152501400', 'e');
INSERT INTO `sys_data_region` VALUES (5581, '二连边境经济技术合作区', 4, '152501', '152501401', 'e');
INSERT INTO `sys_data_region` VALUES (5582, '锡林浩特', 3, '1525', '152502', 'x');
INSERT INTO `sys_data_region` VALUES (5583, '希日塔拉', 4, '152502', '152502001', 'x');
INSERT INTO `sys_data_region` VALUES (5584, '宝力根', 4, '152502', '152502002', 'b');
INSERT INTO `sys_data_region` VALUES (5585, '杭盖', 4, '152502', '152502003', 'h');
INSERT INTO `sys_data_region` VALUES (5586, '楚古兰', 4, '152502', '152502004', 'c');
INSERT INTO `sys_data_region` VALUES (5587, '额尔敦', 4, '152502', '152502005', 'e');
INSERT INTO `sys_data_region` VALUES (5588, '南郊', 4, '152502', '152502006', 'n');
INSERT INTO `sys_data_region` VALUES (5589, '巴彦锡勒', 4, '152502', '152502007', 'b');
INSERT INTO `sys_data_region` VALUES (5590, '巴彦查干', 4, '152502', '152502008', 'b');
INSERT INTO `sys_data_region` VALUES (5591, '阿尔善宝拉格', 4, '152502', '152502100', 'a');
INSERT INTO `sys_data_region` VALUES (5592, '宝力根苏木', 4, '152502', '152502200', 'b');
INSERT INTO `sys_data_region` VALUES (5593, '朝克乌拉苏木', 4, '152502', '152502201', 'c');
INSERT INTO `sys_data_region` VALUES (5594, '巴彦宝拉格苏木', 4, '152502', '152502202', 'b');
INSERT INTO `sys_data_region` VALUES (5595, '阿旗德力格尔工业园区', 4, '152502', '152502401', 'a');
INSERT INTO `sys_data_region` VALUES (5596, '白音库伦牧场', 4, '152502', '152502500', 'b');
INSERT INTO `sys_data_region` VALUES (5597, '贝力克牧场', 4, '152502', '152502501', 'b');
INSERT INTO `sys_data_region` VALUES (5598, '毛登牧场', 4, '152502', '152502502', 'm');
INSERT INTO `sys_data_region` VALUES (5599, '阿巴嘎旗', 3, '1525', '152522', 'a');
INSERT INTO `sys_data_region` VALUES (5600, '别力古台', 4, '152522', '152522100', 'b');
INSERT INTO `sys_data_region` VALUES (5601, '洪格尔高勒', 4, '152522', '152522101', 'h');
INSERT INTO `sys_data_region` VALUES (5602, '查干淖尔', 4, '152522', '152522102', 'c');
INSERT INTO `sys_data_region` VALUES (5603, '那仁宝拉格苏木', 4, '152522', '152522200', 'n');
INSERT INTO `sys_data_region` VALUES (5604, '伊和高勒苏木', 4, '152522', '152522201', 'y');
INSERT INTO `sys_data_region` VALUES (5605, '吉尔嘎郎图苏木', 4, '152522', '152522202', 'j');
INSERT INTO `sys_data_region` VALUES (5606, '巴彦图嘎苏木', 4, '152522', '152522203', 'b');
INSERT INTO `sys_data_region` VALUES (5607, '苏尼特左旗', 3, '1525', '152523', 's');
INSERT INTO `sys_data_region` VALUES (5608, '满都拉图', 4, '152523', '152523100', 'm');
INSERT INTO `sys_data_region` VALUES (5609, '查干敖包', 4, '152523', '152523101', 'c');
INSERT INTO `sys_data_region` VALUES (5610, '巴彦淖尔', 4, '152523', '152523102', 'b');
INSERT INTO `sys_data_region` VALUES (5611, '巴彦乌拉苏木', 4, '152523', '152523200', 'b');
INSERT INTO `sys_data_region` VALUES (5612, '赛罕高毕苏木', 4, '152523', '152523201', 's');
INSERT INTO `sys_data_region` VALUES (5613, '洪格尔苏木', 4, '152523', '152523202', 'h');
INSERT INTO `sys_data_region` VALUES (5614, '达来苏木', 4, '152523', '152523203', 'd');
INSERT INTO `sys_data_region` VALUES (5615, '苏尼特左旗芒来循环经济产业园区', 4, '152523', '152523400', 's');
INSERT INTO `sys_data_region` VALUES (5616, '恩格尔河灌区', 4, '152523', '152523500', 'e');
INSERT INTO `sys_data_region` VALUES (5617, '苏尼特右旗', 3, '1525', '152524', 's');
INSERT INTO `sys_data_region` VALUES (5618, '赛汉塔拉', 4, '152524', '152524100', 's');
INSERT INTO `sys_data_region` VALUES (5619, '朱日和', 4, '152524', '152524101', 'z');
INSERT INTO `sys_data_region` VALUES (5620, '乌日根塔拉', 4, '152524', '152524102', 'w');
INSERT INTO `sys_data_region` VALUES (5621, '桑宝拉格苏木', 4, '152524', '152524200', 's');
INSERT INTO `sys_data_region` VALUES (5622, '额仁淖尔苏木', 4, '152524', '152524201', 'e');
INSERT INTO `sys_data_region` VALUES (5623, '赛罕乌力吉苏木', 4, '152524', '152524202', 's');
INSERT INTO `sys_data_region` VALUES (5624, '阿其图乌拉苏木', 4, '152524', '152524203', 'a');
INSERT INTO `sys_data_region` VALUES (5625, '东乌珠穆沁旗', 3, '1525', '152525', 'd');
INSERT INTO `sys_data_region` VALUES (5626, '乌里雅斯太', 4, '152525', '152525100', 'w');
INSERT INTO `sys_data_region` VALUES (5627, '道特淖尔', 4, '152525', '152525101', 'd');
INSERT INTO `sys_data_region` VALUES (5628, '嘎达布其', 4, '152525', '152525102', 'g');
INSERT INTO `sys_data_region` VALUES (5629, '满都胡宝拉格', 4, '152525', '152525103', 'm');
INSERT INTO `sys_data_region` VALUES (5630, '额吉淖尔', 4, '152525', '152525104', 'e');
INSERT INTO `sys_data_region` VALUES (5631, '巴彦胡硕', 4, '152525', '152525105', 'b');
INSERT INTO `sys_data_region` VALUES (5632, '呼热图淖尔苏木', 4, '152525', '152525200', 'h');
INSERT INTO `sys_data_region` VALUES (5633, '萨麦苏木', 4, '152525', '152525201', 's');
INSERT INTO `sys_data_region` VALUES (5634, '嘎海乐苏木', 4, '152525', '152525202', 'g');
INSERT INTO `sys_data_region` VALUES (5635, '阿拉坦合力苏木', 4, '152525', '152525203', 'a');
INSERT INTO `sys_data_region` VALUES (5636, '乌里雅斯太工业区', 4, '152525', '152525400', 'w');
INSERT INTO `sys_data_region` VALUES (5637, '哈拉盖图农牧场', 4, '152525', '152525500', 'h');
INSERT INTO `sys_data_region` VALUES (5638, '贺斯格乌拉农牧场', 4, '152525', '152525501', 'h');
INSERT INTO `sys_data_region` VALUES (5639, '乌拉盖牧场', 4, '152525', '152525502', 'w');
INSERT INTO `sys_data_region` VALUES (5640, '宝格达乌拉总场', 4, '152525', '152525503', 'b');
INSERT INTO `sys_data_region` VALUES (5641, '西乌珠穆沁旗', 3, '1525', '152526', 'x');
INSERT INTO `sys_data_region` VALUES (5642, '巴拉嘎尔高勒', 4, '152526', '152526100', 'b');
INSERT INTO `sys_data_region` VALUES (5643, '巴彦花', 4, '152526', '152526101', 'b');
INSERT INTO `sys_data_region` VALUES (5644, '吉仁高勒', 4, '152526', '152526102', 'j');
INSERT INTO `sys_data_region` VALUES (5645, '浩勒图高勒', 4, '152526', '152526103', 'h');
INSERT INTO `sys_data_region` VALUES (5646, '高日罕', 4, '152526', '152526104', 'g');
INSERT INTO `sys_data_region` VALUES (5647, '巴彦胡硕苏木', 4, '152526', '152526200', 'b');
INSERT INTO `sys_data_region` VALUES (5648, '乌兰哈拉嘎苏木', 4, '152526', '152526201', 'w');
INSERT INTO `sys_data_region` VALUES (5649, '林业总场', 4, '152526', '152526500', 'l');
INSERT INTO `sys_data_region` VALUES (5650, '太仆寺旗', 3, '1525', '152527', 't');
INSERT INTO `sys_data_region` VALUES (5651, '宝昌', 4, '152527', '152527100', 'b');
INSERT INTO `sys_data_region` VALUES (5652, '千斤沟', 4, '152527', '152527101', 'q');
INSERT INTO `sys_data_region` VALUES (5653, '红旗', 4, '152527', '152527102', 'h');
INSERT INTO `sys_data_region` VALUES (5654, '骆驼山', 4, '152527', '152527103', 'l');
INSERT INTO `sys_data_region` VALUES (5655, '永丰', 4, '152527', '152527104', 'y');
INSERT INTO `sys_data_region` VALUES (5656, '幸福', 4, '152527', '152527200', 'x');
INSERT INTO `sys_data_region` VALUES (5657, '贡宝拉格苏木', 4, '152527', '152527201', 'g');
INSERT INTO `sys_data_region` VALUES (5658, '镶黄旗', 3, '1525', '152528', 'x');
INSERT INTO `sys_data_region` VALUES (5659, '新宝拉格', 4, '152528', '152528100', 'x');
INSERT INTO `sys_data_region` VALUES (5660, '巴彦塔拉', 4, '152528', '152528101', 'b');
INSERT INTO `sys_data_region` VALUES (5661, '翁贡乌拉苏木', 4, '152528', '152528200', 'w');
INSERT INTO `sys_data_region` VALUES (5662, '宝格达音高勒苏木', 4, '152528', '152528201', 'b');
INSERT INTO `sys_data_region` VALUES (5663, '正镶白旗', 3, '1525', '152529', 'z');
INSERT INTO `sys_data_region` VALUES (5664, '明安图', 4, '152529', '152529100', 'm');
INSERT INTO `sys_data_region` VALUES (5665, '星耀', 4, '152529', '152529101', 'x');
INSERT INTO `sys_data_region` VALUES (5666, '伊和淖尔苏木', 4, '152529', '152529200', 'y');
INSERT INTO `sys_data_region` VALUES (5667, '乌兰查布苏木', 4, '152529', '152529201', 'w');
INSERT INTO `sys_data_region` VALUES (5668, '宝拉根陶海苏木', 4, '152529', '152529202', 'b');
INSERT INTO `sys_data_region` VALUES (5669, '额里图种畜场', 4, '152529', '152529500', 'e');
INSERT INTO `sys_data_region` VALUES (5670, '哲日根图林场', 4, '152529', '152529502', 'z');
INSERT INTO `sys_data_region` VALUES (5671, '正蓝旗', 3, '1525', '152530', 'z');
INSERT INTO `sys_data_region` VALUES (5672, '上都', 4, '152530', '152530100', 's');
INSERT INTO `sys_data_region` VALUES (5673, '桑根达来', 4, '152530', '152530101', 's');
INSERT INTO `sys_data_region` VALUES (5674, '哈毕日嘎', 4, '152530', '152530102', 'h');
INSERT INTO `sys_data_region` VALUES (5675, '宝绍代苏木', 4, '152530', '152530200', 'b');
INSERT INTO `sys_data_region` VALUES (5676, '那日图苏木', 4, '152530', '152530201', 'n');
INSERT INTO `sys_data_region` VALUES (5677, '赛音呼都嘎苏木', 4, '152530', '152530202', 's');
INSERT INTO `sys_data_region` VALUES (5678, '扎格斯台苏木', 4, '152530', '152530203', 'z');
INSERT INTO `sys_data_region` VALUES (5679, '五一种畜场总场', 4, '152530', '152530500', 'w');
INSERT INTO `sys_data_region` VALUES (5680, '黑城子示范区', 4, '152530', '152530501', 'h');
INSERT INTO `sys_data_region` VALUES (5681, '多伦', 3, '1525', '152531', 'd');
INSERT INTO `sys_data_region` VALUES (5682, '大北沟', 4, '152531', '152531100', 'd');
INSERT INTO `sys_data_region` VALUES (5683, '多伦淖尔', 4, '152531', '152531101', 'd');
INSERT INTO `sys_data_region` VALUES (5684, '滦源', 4, '152531', '152531102', 'l');
INSERT INTO `sys_data_region` VALUES (5685, '蔡木山', 4, '152531', '152531201', 'c');
INSERT INTO `sys_data_region` VALUES (5686, '西干沟', 4, '152531', '152531202', 'x');
INSERT INTO `sys_data_region` VALUES (5687, '阿拉善', 2, '15', '1529', 'a');
INSERT INTO `sys_data_region` VALUES (5688, '阿拉善左旗', 3, '1529', '152921', 'a');
INSERT INTO `sys_data_region` VALUES (5689, '巴彦浩特', 4, '152921', '152921100', 'b');
INSERT INTO `sys_data_region` VALUES (5690, '嘉尔嘎勒赛汉', 4, '152921', '152921101', 'j');
INSERT INTO `sys_data_region` VALUES (5691, '温都尔勒图', 4, '152921', '152921102', 'w');
INSERT INTO `sys_data_region` VALUES (5692, '吉兰泰', 4, '152921', '152921103', 'j');
INSERT INTO `sys_data_region` VALUES (5693, '乌斯太', 4, '152921', '152921104', 'w');
INSERT INTO `sys_data_region` VALUES (5694, '巴润别立', 4, '152921', '152921105', 'b');
INSERT INTO `sys_data_region` VALUES (5695, '宗别立', 4, '152921', '152921107', 'z');
INSERT INTO `sys_data_region` VALUES (5696, '敖伦布拉格', 4, '152921', '152921108', 'a');
INSERT INTO `sys_data_region` VALUES (5697, '腾格里额里斯', 4, '152921', '152921109', 't');
INSERT INTO `sys_data_region` VALUES (5698, '巴彦木仁苏木', 4, '152921', '152921203', 'b');
INSERT INTO `sys_data_region` VALUES (5699, '乌力吉苏木', 4, '152921', '152921207', 'w');
INSERT INTO `sys_data_region` VALUES (5700, '额尔克哈什哈苏木', 4, '152921', '152921210', 'e');
INSERT INTO `sys_data_region` VALUES (5701, '巴彦诺日公苏木', 4, '152921', '152921212', 'b');
INSERT INTO `sys_data_region` VALUES (5702, '银根苏木', 4, '152921', '152921213', 'y');
INSERT INTO `sys_data_region` VALUES (5703, '超格图呼热苏木', 4, '152921', '152921214', 'c');
INSERT INTO `sys_data_region` VALUES (5704, '巴彦浩特额鲁特', 4, '152921', '152921402', 'b');
INSERT INTO `sys_data_region` VALUES (5705, '巴彦浩特南环路', 4, '152921', '152921403', 'b');
INSERT INTO `sys_data_region` VALUES (5706, '巴彦浩特新华', 4, '152921', '152921404', 'b');
INSERT INTO `sys_data_region` VALUES (5707, '巴彦浩特王府', 4, '152921', '152921405', 'b');
INSERT INTO `sys_data_region` VALUES (5708, '阿拉善右旗', 3, '1529', '152922', 'a');
INSERT INTO `sys_data_region` VALUES (5709, '巴丹吉林', 4, '152922', '152922100', 'b');
INSERT INTO `sys_data_region` VALUES (5710, '雅布赖', 4, '152922', '152922101', 'y');
INSERT INTO `sys_data_region` VALUES (5711, '阿拉腾敖包', 4, '152922', '152922103', 'a');
INSERT INTO `sys_data_region` VALUES (5712, '阿拉腾朝格苏木', 4, '152922', '152922201', 'a');
INSERT INTO `sys_data_region` VALUES (5713, '曼德拉苏木', 4, '152922', '152922205', 'm');
INSERT INTO `sys_data_region` VALUES (5714, '塔木素布拉格苏木', 4, '152922', '152922206', 't');
INSERT INTO `sys_data_region` VALUES (5715, '巴彦高勒苏木', 4, '152922', '152922207', 'b');
INSERT INTO `sys_data_region` VALUES (5716, '额济纳旗', 3, '1529', '152923', 'e');
INSERT INTO `sys_data_region` VALUES (5717, '东风', 4, '152923', '152923101', 'd');
INSERT INTO `sys_data_region` VALUES (5718, '达来呼布', 4, '152923', '152923102', 'd');
INSERT INTO `sys_data_region` VALUES (5719, '哈日布日格德音乌拉', 4, '152923', '152923103', 'h');
INSERT INTO `sys_data_region` VALUES (5720, '赛汉陶来苏木', 4, '152923', '152923200', 's');
INSERT INTO `sys_data_region` VALUES (5721, '马鬃山苏木', 4, '152923', '152923204', 'm');
INSERT INTO `sys_data_region` VALUES (5722, '苏泊淖尔苏木', 4, '152923', '152923205', 's');
INSERT INTO `sys_data_region` VALUES (5723, '巴彦陶来苏木', 4, '152923', '152923206', 'b');
INSERT INTO `sys_data_region` VALUES (5724, '温图高勒苏木', 4, '152923', '152923207', 'w');
INSERT INTO `sys_data_region` VALUES (5725, '辽宁', 1, '0', '21', 'l');
INSERT INTO `sys_data_region` VALUES (5726, '沈阳', 2, '21', '2101', 's');
INSERT INTO `sys_data_region` VALUES (5727, '和平', 3, '2101', '210102', 'h');
INSERT INTO `sys_data_region` VALUES (5728, '浑河湾', 4, '210102', '210102001', 'h');
INSERT INTO `sys_data_region` VALUES (5729, '新华', 4, '210102', '210102002', 'x');
INSERT INTO `sys_data_region` VALUES (5730, '太原街', 4, '210102', '210102005', 't');
INSERT INTO `sys_data_region` VALUES (5731, '北市场', 4, '210102', '210102010', 'b');
INSERT INTO `sys_data_region` VALUES (5732, '南市场', 4, '210102', '210102014', 'n');
INSERT INTO `sys_data_region` VALUES (5733, '马路湾', 4, '210102', '210102016', 'm');
INSERT INTO `sys_data_region` VALUES (5734, '南湖', 4, '210102', '210102019', 'n');
INSERT INTO `sys_data_region` VALUES (5735, '长白', 4, '210102', '210102021', 'c');
INSERT INTO `sys_data_region` VALUES (5736, '沈水湾', 4, '210102', '210102022', 's');
INSERT INTO `sys_data_region` VALUES (5737, '浑河站西', 4, '210102', '210102023', 'h');
INSERT INTO `sys_data_region` VALUES (5738, '沈河', 3, '2101', '210103', 's');
INSERT INTO `sys_data_region` VALUES (5739, '滨河', 4, '210103', '210103005', 'b');
INSERT INTO `sys_data_region` VALUES (5740, '万莲', 4, '210103', '210103006', 'w');
INSERT INTO `sys_data_region` VALUES (5741, '朱剪炉', 4, '210103', '210103013', 'z');
INSERT INTO `sys_data_region` VALUES (5742, '北站', 4, '210103', '210103014', 'b');
INSERT INTO `sys_data_region` VALUES (5743, '风雨坛', 4, '210103', '210103015', 'f');
INSERT INTO `sys_data_region` VALUES (5744, '五里河', 4, '210103', '210103017', 'w');
INSERT INTO `sys_data_region` VALUES (5745, '皇城', 4, '210103', '210103018', 'h');
INSERT INTO `sys_data_region` VALUES (5746, '马官桥', 4, '210103', '210103019', 'm');
INSERT INTO `sys_data_region` VALUES (5747, '南塔', 4, '210103', '210103020', 'n');
INSERT INTO `sys_data_region` VALUES (5748, '东陵', 4, '210103', '210103021', 'd');
INSERT INTO `sys_data_region` VALUES (5749, '泉园', 4, '210103', '210103022', 'q');
INSERT INTO `sys_data_region` VALUES (5750, '大东', 3, '2101', '210104', 'd');
INSERT INTO `sys_data_region` VALUES (5751, '大北', 4, '210104', '210104002', 'd');
INSERT INTO `sys_data_region` VALUES (5752, '万泉', 4, '210104', '210104003', 'w');
INSERT INTO `sys_data_region` VALUES (5753, '文官', 4, '210104', '210104006', 'w');
INSERT INTO `sys_data_region` VALUES (5754, '二台子', 4, '210104', '210104007', 'e');
INSERT INTO `sys_data_region` VALUES (5755, '东站', 4, '210104', '210104009', 'd');
INSERT INTO `sys_data_region` VALUES (5756, '长安', 4, '210104', '210104012', 'c');
INSERT INTO `sys_data_region` VALUES (5757, '东塔', 4, '210104', '210104015', 'd');
INSERT INTO `sys_data_region` VALUES (5758, '津桥', 4, '210104', '210104016', 'j');
INSERT INTO `sys_data_region` VALUES (5759, '前进', 4, '210104', '210104017', 'q');
INSERT INTO `sys_data_region` VALUES (5760, '上园', 4, '210104', '210104018', 's');
INSERT INTO `sys_data_region` VALUES (5761, '皇姑', 3, '2101', '210105', 'h');
INSERT INTO `sys_data_region` VALUES (5762, '舍利塔', 4, '210105', '210105020', 's');
INSERT INTO `sys_data_region` VALUES (5763, '黄河', 4, '210105', '210105021', 'h');
INSERT INTO `sys_data_region` VALUES (5764, '三台子', 4, '210105', '210105022', 's');
INSERT INTO `sys_data_region` VALUES (5765, '新乐', 4, '210105', '210105023', 'x');
INSERT INTO `sys_data_region` VALUES (5766, '明廉', 4, '210105', '210105025', 'm');
INSERT INTO `sys_data_region` VALUES (5767, '华山', 4, '210105', '210105028', 'h');
INSERT INTO `sys_data_region` VALUES (5768, '北塔', 4, '210105', '210105029', 'b');
INSERT INTO `sys_data_region` VALUES (5769, '陵东', 4, '210105', '210105030', 'l');
INSERT INTO `sys_data_region` VALUES (5770, '四台子', 4, '210105', '210105031', 's');
INSERT INTO `sys_data_region` VALUES (5771, '鸭绿江', 4, '210105', '210105032', 'y');
INSERT INTO `sys_data_region` VALUES (5772, '铁西', 3, '2101', '210106', 't');
INSERT INTO `sys_data_region` VALUES (5773, '昆明湖', 4, '210106', '210106001', 'k');
INSERT INTO `sys_data_region` VALUES (5774, '工人村', 4, '210106', '210106003', 'g');
INSERT INTO `sys_data_region` VALUES (5775, '启工', 4, '210106', '210106007', 'q');
INSERT INTO `sys_data_region` VALUES (5776, '兴顺', 4, '210106', '210106011', 'x');
INSERT INTO `sys_data_region` VALUES (5777, '笃工', 4, '210106', '210106013', 'd');
INSERT INTO `sys_data_region` VALUES (5778, '兴华', 4, '210106', '210106015', 'x');
INSERT INTO `sys_data_region` VALUES (5779, '霁虹', 4, '210106', '210106019', 'j');
INSERT INTO `sys_data_region` VALUES (5780, '凌空', 4, '210106', '210106020', 'l');
INSERT INTO `sys_data_region` VALUES (5781, '重工', 4, '210106', '210106023', 'z');
INSERT INTO `sys_data_region` VALUES (5782, '翟家', 4, '210106', '210106025', 'd');
INSERT INTO `sys_data_region` VALUES (5783, '大青中朝友谊', 4, '210106', '210106026', 'd');
INSERT INTO `sys_data_region` VALUES (5784, '大潘', 4, '210106', '210106027', 'd');
INSERT INTO `sys_data_region` VALUES (5785, '高花', 4, '210106', '210106028', 'g');
INSERT INTO `sys_data_region` VALUES (5786, '彰驿站', 4, '210106', '210106029', 'z');
INSERT INTO `sys_data_region` VALUES (5787, '苏家屯', 3, '2101', '210111', 's');
INSERT INTO `sys_data_region` VALUES (5788, '解放', 4, '210111', '210111001', 'j');
INSERT INTO `sys_data_region` VALUES (5789, '民主', 4, '210111', '210111003', 'm');
INSERT INTO `sys_data_region` VALUES (5790, '中兴', 4, '210111', '210111005', 'z');
INSERT INTO `sys_data_region` VALUES (5791, '林盛', 4, '210111', '210111009', 'l');
INSERT INTO `sys_data_region` VALUES (5792, '沙河', 4, '210111', '210111010', 's');
INSERT INTO `sys_data_region` VALUES (5793, '十里河', 4, '210111', '210111011', 's');
INSERT INTO `sys_data_region` VALUES (5794, '陈相', 4, '210111', '210111012', 'c');
INSERT INTO `sys_data_region` VALUES (5795, '永乐', 4, '210111', '210111015', 'y');
INSERT INTO `sys_data_region` VALUES (5796, '佟沟', 4, '210111', '210111018', 't');
INSERT INTO `sys_data_region` VALUES (5797, '八一红菱', 4, '210111', '210111019', 'b');
INSERT INTO `sys_data_region` VALUES (5798, '沈水', 4, '210111', '210111020', 's');
INSERT INTO `sys_data_region` VALUES (5799, '白清姚千', 4, '210111', '210111021', 'b');
INSERT INTO `sys_data_region` VALUES (5800, '浑南', 3, '2101', '210112', 'h');
INSERT INTO `sys_data_region` VALUES (5801, '桃仙', 4, '210112', '210112005', 't');
INSERT INTO `sys_data_region` VALUES (5802, '深井子', 4, '210112', '210112006', 's');
INSERT INTO `sys_data_region` VALUES (5803, '祝家', 4, '210112', '210112007', 'z');
INSERT INTO `sys_data_region` VALUES (5804, '白塔', 4, '210112', '210112008', 'b');
INSERT INTO `sys_data_region` VALUES (5805, '李相', 4, '210112', '210112010', 'l');
INSERT INTO `sys_data_region` VALUES (5806, '五三', 4, '210112', '210112014', 'w');
INSERT INTO `sys_data_region` VALUES (5807, '浑河站东', 4, '210112', '210112015', 'h');
INSERT INTO `sys_data_region` VALUES (5808, '东湖', 4, '210112', '210112016', 'd');
INSERT INTO `sys_data_region` VALUES (5809, '高坎', 4, '210112', '210112017', 'g');
INSERT INTO `sys_data_region` VALUES (5810, '满堂', 4, '210112', '210112018', 'm');
INSERT INTO `sys_data_region` VALUES (5811, '王滨', 4, '210112', '210112019', 'w');
INSERT INTO `sys_data_region` VALUES (5812, '汪家', 4, '210112', '210112021', 'w');
INSERT INTO `sys_data_region` VALUES (5813, '沈北新区', 3, '2101', '210113', 's');
INSERT INTO `sys_data_region` VALUES (5814, '新城子', 4, '210113', '210113001', 'x');
INSERT INTO `sys_data_region` VALUES (5815, '清水台', 4, '210113', '210113002', 'q');
INSERT INTO `sys_data_region` VALUES (5816, '道义', 4, '210113', '210113003', 'd');
INSERT INTO `sys_data_region` VALUES (5817, '辉山', 4, '210113', '210113004', 'h');
INSERT INTO `sys_data_region` VALUES (5818, '虎石台', 4, '210113', '210113005', 'h');
INSERT INTO `sys_data_region` VALUES (5819, '财落', 4, '210113', '210113006', 'c');
INSERT INTO `sys_data_region` VALUES (5820, '兴隆台', 4, '210113', '210113008', 'x');
INSERT INTO `sys_data_region` VALUES (5821, '黄家', 4, '210113', '210113011', 'h');
INSERT INTO `sys_data_region` VALUES (5822, '马刚', 4, '210113', '210113014', 'm');
INSERT INTO `sys_data_region` VALUES (5823, '正良', 4, '210113', '210113015', 'z');
INSERT INTO `sys_data_region` VALUES (5824, '于洪', 3, '2101', '210114', 'y');
INSERT INTO `sys_data_region` VALUES (5825, '迎宾路', 4, '210114', '210114001', 'y');
INSERT INTO `sys_data_region` VALUES (5826, '陵西', 4, '210114', '210114003', 'l');
INSERT INTO `sys_data_region` VALUES (5827, '城东湖', 4, '210114', '210114004', 'c');
INSERT INTO `sys_data_region` VALUES (5828, '平罗', 4, '210114', '210114005', 'p');
INSERT INTO `sys_data_region` VALUES (5829, '马三家', 4, '210114', '210114006', 'm');
INSERT INTO `sys_data_region` VALUES (5830, '沙岭', 4, '210114', '210114007', 's');
INSERT INTO `sys_data_region` VALUES (5831, '造化', 4, '210114', '210114008', 'z');
INSERT INTO `sys_data_region` VALUES (5832, '北陵', 4, '210114', '210114011', 'b');
INSERT INTO `sys_data_region` VALUES (5833, '南阳湖', 4, '210114', '210114013', 'n');
INSERT INTO `sys_data_region` VALUES (5834, '光辉', 4, '210114', '210114014', 'g');
INSERT INTO `sys_data_region` VALUES (5835, '辽中', 3, '2101', '210115', 'l');
INSERT INTO `sys_data_region` VALUES (5836, '蒲西', 4, '210115', '210115001', 'p');
INSERT INTO `sys_data_region` VALUES (5837, '蒲东', 4, '210115', '210115002', 'p');
INSERT INTO `sys_data_region` VALUES (5838, '茨榆坨', 4, '210115', '210115003', 'c');
INSERT INTO `sys_data_region` VALUES (5839, '城郊', 4, '210115', '210115004', 'c');
INSERT INTO `sys_data_region` VALUES (5840, '于家房', 4, '210115', '210115101', 'y');
INSERT INTO `sys_data_region` VALUES (5841, '朱家房', 4, '210115', '210115102', 'z');
INSERT INTO `sys_data_region` VALUES (5842, '冷子堡', 4, '210115', '210115103', 'l');
INSERT INTO `sys_data_region` VALUES (5843, '刘二堡', 4, '210115', '210115104', 'l');
INSERT INTO `sys_data_region` VALUES (5844, '满都户', 4, '210115', '210115107', 'm');
INSERT INTO `sys_data_region` VALUES (5845, '杨士岗', 4, '210115', '210115108', 'y');
INSERT INTO `sys_data_region` VALUES (5846, '肖寨门', 4, '210115', '210115109', 'x');
INSERT INTO `sys_data_region` VALUES (5847, '六间房', 4, '210115', '210115110', 'l');
INSERT INTO `sys_data_region` VALUES (5848, '养士堡', 4, '210115', '210115111', 'y');
INSERT INTO `sys_data_region` VALUES (5849, '潘家堡', 4, '210115', '210115112', 'p');
INSERT INTO `sys_data_region` VALUES (5850, '老大房', 4, '210115', '210115118', 'l');
INSERT INTO `sys_data_region` VALUES (5851, '大黑岗子', 4, '210115', '210115119', 'd');
INSERT INTO `sys_data_region` VALUES (5852, '牛心坨', 4, '210115', '210115120', 'n');
INSERT INTO `sys_data_region` VALUES (5853, '四方台', 4, '210115', '210115121', 's');
INSERT INTO `sys_data_region` VALUES (5854, '长滩', 4, '210115', '210115122', 'c');
INSERT INTO `sys_data_region` VALUES (5855, '新民屯', 4, '210115', '210115123', 'x');
INSERT INTO `sys_data_region` VALUES (5856, '康平', 3, '2101', '210123', 'k');
INSERT INTO `sys_data_region` VALUES (5857, '北三家子', 4, '210123', '210123001', 'b');
INSERT INTO `sys_data_region` VALUES (5858, '胜利', 4, '210123', '210123002', 's');
INSERT INTO `sys_data_region` VALUES (5859, '东关', 4, '210123', '210123003', 'd');
INSERT INTO `sys_data_region` VALUES (5860, '小城子', 4, '210123', '210123101', 'x');
INSERT INTO `sys_data_region` VALUES (5861, '张强', 4, '210123', '210123102', 'z');
INSERT INTO `sys_data_region` VALUES (5862, '方家屯', 4, '210123', '210123103', 'f');
INSERT INTO `sys_data_region` VALUES (5863, '郝官屯', 4, '210123', '210123105', 'h');
INSERT INTO `sys_data_region` VALUES (5864, '二牛所口', 4, '210123', '210123106', 'e');
INSERT INTO `sys_data_region` VALUES (5865, '北四家子', 4, '210123', '210123203', 'b');
INSERT INTO `sys_data_region` VALUES (5866, '两家子', 4, '210123', '210123204', 'l');
INSERT INTO `sys_data_region` VALUES (5867, '海洲窝堡', 4, '210123', '210123206', 'h');
INSERT INTO `sys_data_region` VALUES (5868, '沙金台', 4, '210123', '210123208', 's');
INSERT INTO `sys_data_region` VALUES (5869, '柳树屯', 4, '210123', '210123209', 'l');
INSERT INTO `sys_data_region` VALUES (5870, '西关屯', 4, '210123', '210123210', 'x');
INSERT INTO `sys_data_region` VALUES (5871, '东升', 4, '210123', '210123211', 'd');
INSERT INTO `sys_data_region` VALUES (5872, '法库', 3, '2101', '210124', 'f');
INSERT INTO `sys_data_region` VALUES (5873, '吉祥', 4, '210124', '210124001', 'j');
INSERT INTO `sys_data_region` VALUES (5874, '龙山', 4, '210124', '210124002', 'l');
INSERT INTO `sys_data_region` VALUES (5875, '大孤家子', 4, '210124', '210124101', 'd');
INSERT INTO `sys_data_region` VALUES (5876, '三面船', 4, '210124', '210124102', 's');
INSERT INTO `sys_data_region` VALUES (5877, '秀水河子', 4, '210124', '210124103', 'x');
INSERT INTO `sys_data_region` VALUES (5878, '叶茂台', 4, '210124', '210124104', 'y');
INSERT INTO `sys_data_region` VALUES (5879, '登仕堡子', 4, '210124', '210124105', 'd');
INSERT INTO `sys_data_region` VALUES (5880, '柏家沟', 4, '210124', '210124106', 'b');
INSERT INTO `sys_data_region` VALUES (5881, '丁家房', 4, '210124', '210124107', 'd');
INSERT INTO `sys_data_region` VALUES (5882, '孟家', 4, '210124', '210124108', 'm');
INSERT INTO `sys_data_region` VALUES (5883, '十间房', 4, '210124', '210124109', 's');
INSERT INTO `sys_data_region` VALUES (5884, '冯贝堡', 4, '210124', '210124120', 'f');
INSERT INTO `sys_data_region` VALUES (5885, '依牛堡子', 4, '210124', '210124121', 'y');
INSERT INTO `sys_data_region` VALUES (5886, '包家屯', 4, '210124', '210124123', 'b');
INSERT INTO `sys_data_region` VALUES (5887, '慈恩寺', 4, '210124', '210124201', 'c');
INSERT INTO `sys_data_region` VALUES (5888, '和平', 4, '210124', '210124203', 'h');
INSERT INTO `sys_data_region` VALUES (5889, '四家子', 4, '210124', '210124208', 's');
INSERT INTO `sys_data_region` VALUES (5890, '双台子', 4, '210124', '210124209', 's');
INSERT INTO `sys_data_region` VALUES (5891, '卧牛石', 4, '210124', '210124210', 'w');
INSERT INTO `sys_data_region` VALUES (5892, '新民', 3, '2101', '210181', 'x');
INSERT INTO `sys_data_region` VALUES (5893, '东城', 4, '210181', '210181001', 'd');
INSERT INTO `sys_data_region` VALUES (5894, '辽滨', 4, '210181', '210181002', 'l');
INSERT INTO `sys_data_region` VALUES (5895, '西城', 4, '210181', '210181003', 'x');
INSERT INTO `sys_data_region` VALUES (5896, '新柳', 4, '210181', '210181004', 'x');
INSERT INTO `sys_data_region` VALUES (5897, '大红旗', 4, '210181', '210181101', 'd');
INSERT INTO `sys_data_region` VALUES (5898, '梁山', 4, '210181', '210181102', 'l');
INSERT INTO `sys_data_region` VALUES (5899, '公主屯', 4, '210181', '210181103', 'g');
INSERT INTO `sys_data_region` VALUES (5900, '兴隆', 4, '210181', '210181104', 'x');
INSERT INTO `sys_data_region` VALUES (5901, '前当堡', 4, '210181', '210181105', 'q');
INSERT INTO `sys_data_region` VALUES (5902, '大民屯', 4, '210181', '210181106', 'd');
INSERT INTO `sys_data_region` VALUES (5903, '大柳屯', 4, '210181', '210181107', 'd');
INSERT INTO `sys_data_region` VALUES (5904, '兴隆堡', 4, '210181', '210181108', 'x');
INSERT INTO `sys_data_region` VALUES (5905, '胡台', 4, '210181', '210181109', 'h');
INSERT INTO `sys_data_region` VALUES (5906, '法哈牛', 4, '210181', '210181110', 'f');
INSERT INTO `sys_data_region` VALUES (5907, '柳河沟', 4, '210181', '210181111', 'l');
INSERT INTO `sys_data_region` VALUES (5908, '高台子', 4, '210181', '210181112', 'g');
INSERT INTO `sys_data_region` VALUES (5909, '罗家房', 4, '210181', '210181113', 'l');
INSERT INTO `sys_data_region` VALUES (5910, '三道岗子', 4, '210181', '210181114', 's');
INSERT INTO `sys_data_region` VALUES (5911, '周坨子', 4, '210181', '210181115', 'z');
INSERT INTO `sys_data_region` VALUES (5912, '东蛇山子', 4, '210181', '210181116', 'd');
INSERT INTO `sys_data_region` VALUES (5913, '陶家屯', 4, '210181', '210181117', 't');
INSERT INTO `sys_data_region` VALUES (5914, '张家屯', 4, '210181', '210181118', 'z');
INSERT INTO `sys_data_region` VALUES (5915, '金五台子', 4, '210181', '210181119', 'j');
INSERT INTO `sys_data_region` VALUES (5916, '新农村', 4, '210181', '210181120', 'x');
INSERT INTO `sys_data_region` VALUES (5917, '红旗', 4, '210181', '210181205', 'h');
INSERT INTO `sys_data_region` VALUES (5918, '卢家屯', 4, '210181', '210181206', 'l');
INSERT INTO `sys_data_region` VALUES (5919, '姚堡', 4, '210181', '210181207', 'y');
INSERT INTO `sys_data_region` VALUES (5920, '于家窝堡', 4, '210181', '210181209', 'y');
INSERT INTO `sys_data_region` VALUES (5921, '大连', 2, '21', '2102', 'd');
INSERT INTO `sys_data_region` VALUES (5922, '中山', 3, '2102', '210202', 'z');
INSERT INTO `sys_data_region` VALUES (5923, '桃源', 4, '210202', '210202011', 't');
INSERT INTO `sys_data_region` VALUES (5924, '老虎滩', 4, '210202', '210202012', 'l');
INSERT INTO `sys_data_region` VALUES (5925, '海军广场', 4, '210202', '210202014', 'h');
INSERT INTO `sys_data_region` VALUES (5926, '人民路', 4, '210202', '210202019', 'r');
INSERT INTO `sys_data_region` VALUES (5927, '青泥洼桥', 4, '210202', '210202020', 'q');
INSERT INTO `sys_data_region` VALUES (5928, '葵英', 4, '210202', '210202021', 'k');
INSERT INTO `sys_data_region` VALUES (5929, '西岗', 3, '2102', '210203', 'x');
INSERT INTO `sys_data_region` VALUES (5930, '香炉礁', 4, '210203', '210203001', 'x');
INSERT INTO `sys_data_region` VALUES (5931, '八一路', 4, '210203', '210203010', 'b');
INSERT INTO `sys_data_region` VALUES (5932, '白云', 4, '210203', '210203013', 'b');
INSERT INTO `sys_data_region` VALUES (5933, '日新', 4, '210203', '210203016', 'r');
INSERT INTO `sys_data_region` VALUES (5934, '人民广场', 4, '210203', '210203017', 'r');
INSERT INTO `sys_data_region` VALUES (5935, '沙河口', 3, '2102', '210204', 's');
INSERT INTO `sys_data_region` VALUES (5936, '春柳', 4, '210204', '210204006', 'c');
INSERT INTO `sys_data_region` VALUES (5937, '马栏', 4, '210204', '210204008', 'm');
INSERT INTO `sys_data_region` VALUES (5938, '南沙河口', 4, '210204', '210204009', 'n');
INSERT INTO `sys_data_region` VALUES (5939, '黑石礁', 4, '210204', '210204010', 'h');
INSERT INTO `sys_data_region` VALUES (5940, '李家', 4, '210204', '210204011', 'l');
INSERT INTO `sys_data_region` VALUES (5941, '星海湾', 4, '210204', '210204017', 'x');
INSERT INTO `sys_data_region` VALUES (5942, '西安路', 4, '210204', '210204018', 'x');
INSERT INTO `sys_data_region` VALUES (5943, '甘井子', 3, '2102', '210211', 'g');
INSERT INTO `sys_data_region` VALUES (5944, '周水子', 4, '210211', '210211001', 'z');
INSERT INTO `sys_data_region` VALUES (5945, '甘井子街道', 4, '210211', '210211004', 'g');
INSERT INTO `sys_data_region` VALUES (5946, '南关岭', 4, '210211', '210211006', 'n');
INSERT INTO `sys_data_region` VALUES (5947, '泡崖', 4, '210211', '210211007', 'p');
INSERT INTO `sys_data_region` VALUES (5948, '机场', 4, '210211', '210211010', 'j');
INSERT INTO `sys_data_region` VALUES (5949, '辛寨子', 4, '210211', '210211014', 'x');
INSERT INTO `sys_data_region` VALUES (5950, '红旗', 4, '210211', '210211015', 'h');
INSERT INTO `sys_data_region` VALUES (5951, '大连湾', 4, '210211', '210211017', 'd');
INSERT INTO `sys_data_region` VALUES (5952, '椒金山', 4, '210211', '210211018', 'j');
INSERT INTO `sys_data_region` VALUES (5953, '泉水', 4, '210211', '210211019', 'q');
INSERT INTO `sys_data_region` VALUES (5954, '营城子', 4, '210211', '210211021', 'y');
INSERT INTO `sys_data_region` VALUES (5955, '革镇堡', 4, '210211', '210211022', 'g');
INSERT INTO `sys_data_region` VALUES (5956, '凌水', 4, '210211', '210211023', 'l');
INSERT INTO `sys_data_region` VALUES (5957, '七贤岭', 4, '210211', '210211024', 'q');
INSERT INTO `sys_data_region` VALUES (5958, '中华路', 4, '210211', '210211025', 'z');
INSERT INTO `sys_data_region` VALUES (5959, '旅顺口', 3, '2102', '210212', 'l');
INSERT INTO `sys_data_region` VALUES (5960, '水师营', 4, '210212', '210212005', 's');
INSERT INTO `sys_data_region` VALUES (5961, '铁山', 4, '210212', '210212006', 't');
INSERT INTO `sys_data_region` VALUES (5962, '双岛湾', 4, '210212', '210212007', 's');
INSERT INTO `sys_data_region` VALUES (5963, '长城', 4, '210212', '210212009', 'c');
INSERT INTO `sys_data_region` VALUES (5964, '龙头', 4, '210212', '210212010', 'l');
INSERT INTO `sys_data_region` VALUES (5965, '江西', 4, '210212', '210212013', 'j');
INSERT INTO `sys_data_region` VALUES (5966, '龙王塘', 4, '210212', '210212014', 'l');
INSERT INTO `sys_data_region` VALUES (5967, '得胜', 4, '210212', '210212015', 'd');
INSERT INTO `sys_data_region` VALUES (5968, '三涧堡', 4, '210212', '210212016', 's');
INSERT INTO `sys_data_region` VALUES (5969, '登峰', 4, '210212', '210212017', 'd');
INSERT INTO `sys_data_region` VALUES (5970, '金州', 3, '2102', '210213', 'j');
INSERT INTO `sys_data_region` VALUES (5971, '拥政', 4, '210213', '210213001', 'y');
INSERT INTO `sys_data_region` VALUES (5972, '友谊', 4, '210213', '210213002', 'y');
INSERT INTO `sys_data_region` VALUES (5973, '站前', 4, '210213', '210213008', 'z');
INSERT INTO `sys_data_region` VALUES (5974, '先进', 4, '210213', '210213009', 'x');
INSERT INTO `sys_data_region` VALUES (5975, '华家', 4, '210213', '210213010', 'h');
INSERT INTO `sys_data_region` VALUES (5976, '登沙河', 4, '210213', '210213014', 'd');
INSERT INTO `sys_data_region` VALUES (5977, '杏树', 4, '210213', '210213015', 'x');
INSERT INTO `sys_data_region` VALUES (5978, '大魏家', 4, '210213', '210213017', 'd');
INSERT INTO `sys_data_region` VALUES (5979, '向应', 4, '210213', '210213018', 'x');
INSERT INTO `sys_data_region` VALUES (5980, '七顶山', 4, '210213', '210213019', 'q');
INSERT INTO `sys_data_region` VALUES (5981, '马桥子', 4, '210213', '210213020', 'm');
INSERT INTO `sys_data_region` VALUES (5982, '海青岛', 4, '210213', '210213021', 'h');
INSERT INTO `sys_data_region` VALUES (5983, '大孤山', 4, '210213', '210213022', 'd');
INSERT INTO `sys_data_region` VALUES (5984, '湾里', 4, '210213', '210213023', 'w');
INSERT INTO `sys_data_region` VALUES (5985, '董家沟', 4, '210213', '210213024', 'd');
INSERT INTO `sys_data_region` VALUES (5986, '金石滩', 4, '210213', '210213025', 'j');
INSERT INTO `sys_data_region` VALUES (5987, '得胜', 4, '210213', '210213027', 'd');
INSERT INTO `sys_data_region` VALUES (5988, '大李家', 4, '210213', '210213028', 'd');
INSERT INTO `sys_data_region` VALUES (5989, '二十里堡', 4, '210213', '210213029', 'e');
INSERT INTO `sys_data_region` VALUES (5990, '亮甲店', 4, '210213', '210213030', 'l');
INSERT INTO `sys_data_region` VALUES (5991, '炮台', 4, '210213', '210213031', 'p');
INSERT INTO `sys_data_region` VALUES (5992, '复州湾', 4, '210213', '210213032', 'f');
INSERT INTO `sys_data_region` VALUES (5993, '三十里堡', 4, '210213', '210213033', 's');
INSERT INTO `sys_data_region` VALUES (5994, '石河', 4, '210213', '210213034', 's');
INSERT INTO `sys_data_region` VALUES (5995, '光中', 4, '210213', '210213035', 'g');
INSERT INTO `sys_data_region` VALUES (5996, '普兰店', 3, '2102', '210214', 'p');
INSERT INTO `sys_data_region` VALUES (5997, '丰荣', 4, '210214', '210214001', 'f');
INSERT INTO `sys_data_region` VALUES (5998, '铁西', 4, '210214', '210214002', 't');
INSERT INTO `sys_data_region` VALUES (5999, '大刘家', 4, '210214', '210214007', 'd');
INSERT INTO `sys_data_region` VALUES (6000, '杨树房', 4, '210214', '210214008', 'y');
INSERT INTO `sys_data_region` VALUES (6001, '皮口', 4, '210214', '210214009', 'p');
INSERT INTO `sys_data_region` VALUES (6002, '城子坦', 4, '210214', '210214010', 'c');
INSERT INTO `sys_data_region` VALUES (6003, '唐家房', 4, '210214', '210214011', 't');
INSERT INTO `sys_data_region` VALUES (6004, '大谭', 4, '210214', '210214012', 'd');
INSERT INTO `sys_data_region` VALUES (6005, '莲山', 4, '210214', '210214013', 'l');
INSERT INTO `sys_data_region` VALUES (6006, '安波', 4, '210214', '210214014', 'a');
INSERT INTO `sys_data_region` VALUES (6007, '沙包', 4, '210214', '210214015', 's');
INSERT INTO `sys_data_region` VALUES (6008, '星台', 4, '210214', '210214016', 'x');
INSERT INTO `sys_data_region` VALUES (6009, '乐甲', 4, '210214', '210214017', 'l');
INSERT INTO `sys_data_region` VALUES (6010, '墨盘', 4, '210214', '210214018', 'm');
INSERT INTO `sys_data_region` VALUES (6011, '同益', 4, '210214', '210214019', 't');
INSERT INTO `sys_data_region` VALUES (6012, '双塔', 4, '210214', '210214020', 's');
INSERT INTO `sys_data_region` VALUES (6013, '四平', 4, '210214', '210214021', 's');
INSERT INTO `sys_data_region` VALUES (6014, '太平', 4, '210214', '210214022', 't');
INSERT INTO `sys_data_region` VALUES (6015, '长海', 3, '2102', '210224', 'c');
INSERT INTO `sys_data_region` VALUES (6016, '大长山岛', 4, '210224', '210224100', 'd');
INSERT INTO `sys_data_region` VALUES (6017, '獐子岛', 4, '210224', '210224101', 'z');
INSERT INTO `sys_data_region` VALUES (6018, '广鹿岛', 4, '210224', '210224102', 'g');
INSERT INTO `sys_data_region` VALUES (6019, '小长山岛', 4, '210224', '210224103', 'x');
INSERT INTO `sys_data_region` VALUES (6020, '海洋岛', 4, '210224', '210224104', 'h');
INSERT INTO `sys_data_region` VALUES (6021, '瓦房店', 3, '2102', '210281', 'w');
INSERT INTO `sys_data_region` VALUES (6022, '新华', 4, '210281', '210281001', 'x');
INSERT INTO `sys_data_region` VALUES (6023, '文兰', 4, '210281', '210281002', 'w');
INSERT INTO `sys_data_region` VALUES (6024, '岭东', 4, '210281', '210281003', 'l');
INSERT INTO `sys_data_region` VALUES (6025, '共济', 4, '210281', '210281004', 'g');
INSERT INTO `sys_data_region` VALUES (6026, '铁东', 4, '210281', '210281005', 't');
INSERT INTO `sys_data_region` VALUES (6027, '祝华', 4, '210281', '210281006', 'z');
INSERT INTO `sys_data_region` VALUES (6028, '岗店', 4, '210281', '210281007', 'g');
INSERT INTO `sys_data_region` VALUES (6029, '九龙', 4, '210281', '210281008', 'j');
INSERT INTO `sys_data_region` VALUES (6030, '太阳', 4, '210281', '210281009', 't');
INSERT INTO `sys_data_region` VALUES (6031, '长兴岛', 4, '210281', '210281010', 'c');
INSERT INTO `sys_data_region` VALUES (6032, '交流岛', 4, '210281', '210281011', 'j');
INSERT INTO `sys_data_region` VALUES (6033, '复州城', 4, '210281', '210281101', 'f');
INSERT INTO `sys_data_region` VALUES (6034, '松树', 4, '210281', '210281103', 's');
INSERT INTO `sys_data_region` VALUES (6035, '得利寺', 4, '210281', '210281105', 'd');
INSERT INTO `sys_data_region` VALUES (6036, '万家岭', 4, '210281', '210281106', 'w');
INSERT INTO `sys_data_region` VALUES (6037, '许屯', 4, '210281', '210281107', 'x');
INSERT INTO `sys_data_region` VALUES (6038, '永宁', 4, '210281', '210281108', 'y');
INSERT INTO `sys_data_region` VALUES (6039, '谢屯', 4, '210281', '210281109', 'x');
INSERT INTO `sys_data_region` VALUES (6040, '老虎屯', 4, '210281', '210281112', 'l');
INSERT INTO `sys_data_region` VALUES (6041, '红沿河', 4, '210281', '210281113', 'h');
INSERT INTO `sys_data_region` VALUES (6042, '李官', 4, '210281', '210281115', 'l');
INSERT INTO `sys_data_region` VALUES (6043, '仙浴湾', 4, '210281', '210281116', 'x');
INSERT INTO `sys_data_region` VALUES (6044, '瓦窝', 4, '210281', '210281117', 'w');
INSERT INTO `sys_data_region` VALUES (6045, '元台', 4, '210281', '210281118', 'y');
INSERT INTO `sys_data_region` VALUES (6046, '赵屯', 4, '210281', '210281201', 'z');
INSERT INTO `sys_data_region` VALUES (6047, '土城', 4, '210281', '210281203', 't');
INSERT INTO `sys_data_region` VALUES (6048, '阎店', 4, '210281', '210281204', 'y');
INSERT INTO `sys_data_region` VALUES (6049, '西杨', 4, '210281', '210281205', 'x');
INSERT INTO `sys_data_region` VALUES (6050, '驼山', 4, '210281', '210281206', 't');
INSERT INTO `sys_data_region` VALUES (6051, '三台', 4, '210281', '210281208', 's');
INSERT INTO `sys_data_region` VALUES (6052, '泡崖', 4, '210281', '210281210', 'p');
INSERT INTO `sys_data_region` VALUES (6053, '杨家', 4, '210281', '210281212', 'y');
INSERT INTO `sys_data_region` VALUES (6054, '庄河', 3, '2102', '210283', 'z');
INSERT INTO `sys_data_region` VALUES (6055, '城关', 4, '210283', '210283001', 'c');
INSERT INTO `sys_data_region` VALUES (6056, '新华', 4, '210283', '210283002', 'x');
INSERT INTO `sys_data_region` VALUES (6057, '兴达', 4, '210283', '210283003', 'x');
INSERT INTO `sys_data_region` VALUES (6058, '昌盛', 4, '210283', '210283004', 'c');
INSERT INTO `sys_data_region` VALUES (6059, '明阳', 4, '210283', '210283005', 'm');
INSERT INTO `sys_data_region` VALUES (6060, '青堆', 4, '210283', '210283101', 'q');
INSERT INTO `sys_data_region` VALUES (6061, '徐岭', 4, '210283', '210283102', 'x');
INSERT INTO `sys_data_region` VALUES (6062, '黑岛', 4, '210283', '210283104', 'h');
INSERT INTO `sys_data_region` VALUES (6063, '栗子房', 4, '210283', '210283105', 'l');
INSERT INTO `sys_data_region` VALUES (6064, '大营', 4, '210283', '210283107', 'd');
INSERT INTO `sys_data_region` VALUES (6065, '塔岭', 4, '210283', '210283108', 't');
INSERT INTO `sys_data_region` VALUES (6066, '仙人洞', 4, '210283', '210283109', 'x');
INSERT INTO `sys_data_region` VALUES (6067, '蓉花山', 4, '210283', '210283110', 'r');
INSERT INTO `sys_data_region` VALUES (6068, '长岭', 4, '210283', '210283111', 'c');
INSERT INTO `sys_data_region` VALUES (6069, '荷花山', 4, '210283', '210283112', 'h');
INSERT INTO `sys_data_region` VALUES (6070, '城山', 4, '210283', '210283113', 'c');
INSERT INTO `sys_data_region` VALUES (6071, '光明山', 4, '210283', '210283114', 'g');
INSERT INTO `sys_data_region` VALUES (6072, '大郑', 4, '210283', '210283115', 'd');
INSERT INTO `sys_data_region` VALUES (6073, '王家', 4, '210283', '210283116', 'w');
INSERT INTO `sys_data_region` VALUES (6074, '吴炉', 4, '210283', '210283118', 'w');
INSERT INTO `sys_data_region` VALUES (6075, '鞍子山', 4, '210283', '210283204', 'a');
INSERT INTO `sys_data_region` VALUES (6076, '太平岭', 4, '210283', '210283208', 't');
INSERT INTO `sys_data_region` VALUES (6077, '步云山', 4, '210283', '210283209', 'b');
INSERT INTO `sys_data_region` VALUES (6078, '桂云花', 4, '210283', '210283211', 'g');
INSERT INTO `sys_data_region` VALUES (6079, '兰店', 4, '210283', '210283214', 'l');
INSERT INTO `sys_data_region` VALUES (6080, '石城', 4, '210283', '210283216', 's');
INSERT INTO `sys_data_region` VALUES (6081, '鞍山', 2, '21', '2103', 'a');
INSERT INTO `sys_data_region` VALUES (6082, '铁东', 3, '2103', '210302', 't');
INSERT INTO `sys_data_region` VALUES (6083, '解放', 4, '210302', '210302002', 'j');
INSERT INTO `sys_data_region` VALUES (6084, '山南', 4, '210302', '210302003', 's');
INSERT INTO `sys_data_region` VALUES (6085, '园林', 4, '210302', '210302004', 'y');
INSERT INTO `sys_data_region` VALUES (6086, '站前', 4, '210302', '210302006', 'z');
INSERT INTO `sys_data_region` VALUES (6087, '和平', 4, '210302', '210302008', 'h');
INSERT INTO `sys_data_region` VALUES (6088, '湖南', 4, '210302', '210302011', 'h');
INSERT INTO `sys_data_region` VALUES (6089, '新兴', 4, '210302', '210302013', 'x');
INSERT INTO `sys_data_region` VALUES (6090, '旧堡', 4, '210302', '210302014', 'j');
INSERT INTO `sys_data_region` VALUES (6091, '大孤山', 4, '210302', '210302015', 'd');
INSERT INTO `sys_data_region` VALUES (6092, '铁西', 3, '2103', '210303', 't');
INSERT INTO `sys_data_region` VALUES (6093, '繁荣', 4, '210303', '210303002', 'f');
INSERT INTO `sys_data_region` VALUES (6094, '八家子', 4, '210303', '210303003', 'b');
INSERT INTO `sys_data_region` VALUES (6095, '共和', 4, '210303', '210303005', 'g');
INSERT INTO `sys_data_region` VALUES (6096, '永乐', 4, '210303', '210303006', 'y');
INSERT INTO `sys_data_region` VALUES (6097, '南华', 4, '210303', '210303008', 'n');
INSERT INTO `sys_data_region` VALUES (6098, '大陆', 4, '210303', '210303009', 'd');
INSERT INTO `sys_data_region` VALUES (6099, '永发', 4, '210303', '210303012', 'y');
INSERT INTO `sys_data_region` VALUES (6100, '达道湾', 4, '210303', '210303013', 'd');
INSERT INTO `sys_data_region` VALUES (6101, '宁远', 4, '210303', '210303014', 'n');
INSERT INTO `sys_data_region` VALUES (6102, '立山', 3, '2103', '210304', 'l');
INSERT INTO `sys_data_region` VALUES (6103, '友好', 4, '210304', '210304001', 'y');
INSERT INTO `sys_data_region` VALUES (6104, '双山', 4, '210304', '210304004', 's');
INSERT INTO `sys_data_region` VALUES (6105, '立山街道', 4, '210304', '210304006', 'l');
INSERT INTO `sys_data_region` VALUES (6106, '曙光', 4, '210304', '210304008', 's');
INSERT INTO `sys_data_region` VALUES (6107, '灵山', 4, '210304', '210304009', 'l');
INSERT INTO `sys_data_region` VALUES (6108, '深沟寺', 4, '210304', '210304014', 's');
INSERT INTO `sys_data_region` VALUES (6109, '沙河', 4, '210304', '210304015', 's');
INSERT INTO `sys_data_region` VALUES (6110, '齐大山', 4, '210304', '210304019', 'q');
INSERT INTO `sys_data_region` VALUES (6111, '千山', 4, '210304', '210304020', 'q');
INSERT INTO `sys_data_region` VALUES (6112, '千山', 3, '2103', '210311', 'q');
INSERT INTO `sys_data_region` VALUES (6113, '汤岗子', 4, '210311', '210311001', 't');
INSERT INTO `sys_data_region` VALUES (6114, '东鞍山', 4, '210311', '210311002', 'd');
INSERT INTO `sys_data_region` VALUES (6115, '唐家房', 4, '210311', '210311102', 't');
INSERT INTO `sys_data_region` VALUES (6116, '甘泉', 4, '210311', '210311111', 'g');
INSERT INTO `sys_data_region` VALUES (6117, '大屯', 4, '210311', '210311112', 'd');
INSERT INTO `sys_data_region` VALUES (6118, '台安', 3, '2103', '210321', 't');
INSERT INTO `sys_data_region` VALUES (6119, '八角台', 4, '210321', '210321001', 'b');
INSERT INTO `sys_data_region` VALUES (6120, '台东', 4, '210321', '210321002', 't');
INSERT INTO `sys_data_region` VALUES (6121, '西佛', 4, '210321', '210321101', 'x');
INSERT INTO `sys_data_region` VALUES (6122, '新开河', 4, '210321', '210321102', 'x');
INSERT INTO `sys_data_region` VALUES (6123, '黄沙坨', 4, '210321', '210321103', 'h');
INSERT INTO `sys_data_region` VALUES (6124, '高力房', 4, '210321', '210321104', 'g');
INSERT INTO `sys_data_region` VALUES (6125, '桑林', 4, '210321', '210321105', 's');
INSERT INTO `sys_data_region` VALUES (6126, '富家', 4, '210321', '210321106', 'f');
INSERT INTO `sys_data_region` VALUES (6127, '达牛', 4, '210321', '210321107', 'd');
INSERT INTO `sys_data_region` VALUES (6128, '韭菜台', 4, '210321', '210321109', 'j');
INSERT INTO `sys_data_region` VALUES (6129, '新台', 4, '210321', '210321110', 'x');
INSERT INTO `sys_data_region` VALUES (6130, '桓洞', 4, '210321', '210321111', 'h');
INSERT INTO `sys_data_region` VALUES (6131, '岫岩', 3, '2103', '210323', 'x');
INSERT INTO `sys_data_region` VALUES (6132, '阜昌', 4, '210323', '210323001', 'f');
INSERT INTO `sys_data_region` VALUES (6133, '雅河', 4, '210323', '210323003', 'y');
INSERT INTO `sys_data_region` VALUES (6134, '兴隆', 4, '210323', '210323004', 'x');
INSERT INTO `sys_data_region` VALUES (6135, '三家子', 4, '210323', '210323101', 's');
INSERT INTO `sys_data_region` VALUES (6136, '石庙子', 4, '210323', '210323102', 's');
INSERT INTO `sys_data_region` VALUES (6137, '黄花甸', 4, '210323', '210323103', 'h');
INSERT INTO `sys_data_region` VALUES (6138, '大营子', 4, '210323', '210323104', 'd');
INSERT INTO `sys_data_region` VALUES (6139, '苏子沟', 4, '210323', '210323105', 's');
INSERT INTO `sys_data_region` VALUES (6140, '偏岭', 4, '210323', '210323106', 'p');
INSERT INTO `sys_data_region` VALUES (6141, '哈达碑', 4, '210323', '210323107', 'h');
INSERT INTO `sys_data_region` VALUES (6142, '新甸', 4, '210323', '210323108', 'x');
INSERT INTO `sys_data_region` VALUES (6143, '洋河', 4, '210323', '210323109', 'y');
INSERT INTO `sys_data_region` VALUES (6144, '杨家堡', 4, '210323', '210323111', 'y');
INSERT INTO `sys_data_region` VALUES (6145, '清凉山', 4, '210323', '210323112', 'q');
INSERT INTO `sys_data_region` VALUES (6146, '石灰窑', 4, '210323', '210323113', 's');
INSERT INTO `sys_data_region` VALUES (6147, '前营', 4, '210323', '210323114', 'q');
INSERT INTO `sys_data_region` VALUES (6148, '龙潭', 4, '210323', '210323115', 'l');
INSERT INTO `sys_data_region` VALUES (6149, '牧牛', 4, '210323', '210323116', 'm');
INSERT INTO `sys_data_region` VALUES (6150, '药山', 4, '210323', '210323117', 'y');
INSERT INTO `sys_data_region` VALUES (6151, '大房身', 4, '210323', '210323118', 'd');
INSERT INTO `sys_data_region` VALUES (6152, '朝阳', 4, '210323', '210323119', 'z');
INSERT INTO `sys_data_region` VALUES (6153, '红旗营子', 4, '210323', '210323206', 'h');
INSERT INTO `sys_data_region` VALUES (6154, '岭沟', 4, '210323', '210323211', 'l');
INSERT INTO `sys_data_region` VALUES (6155, '哨子河', 4, '210323', '210323212', 's');
INSERT INTO `sys_data_region` VALUES (6156, '海城', 3, '2103', '210381', 'h');
INSERT INTO `sys_data_region` VALUES (6157, '海州', 4, '210381', '210381001', 'h');
INSERT INTO `sys_data_region` VALUES (6158, '兴海', 4, '210381', '210381002', 'x');
INSERT INTO `sys_data_region` VALUES (6159, '响堂', 4, '210381', '210381003', 'x');
INSERT INTO `sys_data_region` VALUES (6160, '东四', 4, '210381', '210381004', 'd');
INSERT INTO `sys_data_region` VALUES (6161, '温泉', 4, '210381', '210381006', 'w');
INSERT INTO `sys_data_region` VALUES (6162, '孤山', 4, '210381', '210381101', 'g');
INSERT INTO `sys_data_region` VALUES (6163, '岔沟', 4, '210381', '210381102', 'c');
INSERT INTO `sys_data_region` VALUES (6164, '接文', 4, '210381', '210381103', 'j');
INSERT INTO `sys_data_region` VALUES (6165, '析木', 4, '210381', '210381104', 'x');
INSERT INTO `sys_data_region` VALUES (6166, '马风', 4, '210381', '210381105', 'm');
INSERT INTO `sys_data_region` VALUES (6167, '牌楼', 4, '210381', '210381107', 'p');
INSERT INTO `sys_data_region` VALUES (6168, '八里', 4, '210381', '210381108', 'b');
INSERT INTO `sys_data_region` VALUES (6169, '毛祁', 4, '210381', '210381109', 'm');
INSERT INTO `sys_data_region` VALUES (6170, '英落', 4, '210381', '210381110', 'y');
INSERT INTO `sys_data_region` VALUES (6171, '感王', 4, '210381', '210381111', 'g');
INSERT INTO `sys_data_region` VALUES (6172, '西柳', 4, '210381', '210381112', 'x');
INSERT INTO `sys_data_region` VALUES (6173, '中小', 4, '210381', '210381113', 'z');
INSERT INTO `sys_data_region` VALUES (6174, '王石', 4, '210381', '210381114', 'w');
INSERT INTO `sys_data_region` VALUES (6175, '南台', 4, '210381', '210381115', 'n');
INSERT INTO `sys_data_region` VALUES (6176, '腾鳌', 4, '210381', '210381118', 't');
INSERT INTO `sys_data_region` VALUES (6177, '耿庄', 4, '210381', '210381121', 'g');
INSERT INTO `sys_data_region` VALUES (6178, '牛庄', 4, '210381', '210381123', 'n');
INSERT INTO `sys_data_region` VALUES (6179, '西四', 4, '210381', '210381124', 'x');
INSERT INTO `sys_data_region` VALUES (6180, '望台', 4, '210381', '210381125', 'w');
INSERT INTO `sys_data_region` VALUES (6181, '温香', 4, '210381', '210381126', 'w');
INSERT INTO `sys_data_region` VALUES (6182, '高坨', 4, '210381', '210381127', 'g');
INSERT INTO `sys_data_region` VALUES (6183, '抚顺', 2, '21', '2104', 'f');
INSERT INTO `sys_data_region` VALUES (6184, '新抚', 3, '2104', '210402', 'x');
INSERT INTO `sys_data_region` VALUES (6185, '站前', 4, '210402', '210402001', 'z');
INSERT INTO `sys_data_region` VALUES (6186, '福民', 4, '210402', '210402005', 'f');
INSERT INTO `sys_data_region` VALUES (6187, '新抚街道', 4, '210402', '210402007', 'x');
INSERT INTO `sys_data_region` VALUES (6188, '榆林', 4, '210402', '210402009', 'y');
INSERT INTO `sys_data_region` VALUES (6189, '永安台', 4, '210402', '210402011', 'y');
INSERT INTO `sys_data_region` VALUES (6190, '刘山', 4, '210402', '210402019', 'l');
INSERT INTO `sys_data_region` VALUES (6191, '千金', 4, '210402', '210402200', 'q');
INSERT INTO `sys_data_region` VALUES (6192, '东洲', 3, '2104', '210403', 'd');
INSERT INTO `sys_data_region` VALUES (6193, '东洲街道', 4, '210403', '210403002', 'd');
INSERT INTO `sys_data_region` VALUES (6194, '搭连', 4, '210403', '210403004', 'd');
INSERT INTO `sys_data_region` VALUES (6195, '龙凤', 4, '210403', '210403005', 'l');
INSERT INTO `sys_data_region` VALUES (6196, '新屯', 4, '210403', '210403006', 'x');
INSERT INTO `sys_data_region` VALUES (6197, '万新', 4, '210403', '210403007', 'w');
INSERT INTO `sys_data_region` VALUES (6198, '老虎台', 4, '210403', '210403008', 'l');
INSERT INTO `sys_data_region` VALUES (6199, '章党街道', 4, '210403', '210403012', 'z');
INSERT INTO `sys_data_region` VALUES (6200, '章党镇', 4, '210403', '210403100', 'z');
INSERT INTO `sys_data_region` VALUES (6201, '哈达', 4, '210403', '210403101', 'h');
INSERT INTO `sys_data_region` VALUES (6202, '碾盘', 4, '210403', '210403202', 'n');
INSERT INTO `sys_data_region` VALUES (6203, '兰山', 4, '210403', '210403203', 'l');
INSERT INTO `sys_data_region` VALUES (6204, '望花', 3, '2104', '210404', 'w');
INSERT INTO `sys_data_region` VALUES (6205, '工农', 4, '210404', '210404002', 'g');
INSERT INTO `sys_data_region` VALUES (6206, '建设', 4, '210404', '210404003', 'j');
INSERT INTO `sys_data_region` VALUES (6207, '和平', 4, '210404', '210404004', 'h');
INSERT INTO `sys_data_region` VALUES (6208, '光明', 4, '210404', '210404005', 'g');
INSERT INTO `sys_data_region` VALUES (6209, '朴屯', 4, '210404', '210404006', 'p');
INSERT INTO `sys_data_region` VALUES (6210, '演武', 4, '210404', '210404007', 'y');
INSERT INTO `sys_data_region` VALUES (6211, '李石', 4, '210404', '210404011', 'l');
INSERT INTO `sys_data_region` VALUES (6212, '塔峪', 4, '210404', '210404101', 't');
INSERT INTO `sys_data_region` VALUES (6213, '拉古', 4, '210404', '210404200', 'l');
INSERT INTO `sys_data_region` VALUES (6214, '顺城', 3, '2104', '210411', 's');
INSERT INTO `sys_data_region` VALUES (6215, '长春', 4, '210411', '210411002', 'c');
INSERT INTO `sys_data_region` VALUES (6216, '葛布', 4, '210411', '210411003', 'g');
INSERT INTO `sys_data_region` VALUES (6217, '将军堡', 4, '210411', '210411004', 'j');
INSERT INTO `sys_data_region` VALUES (6218, '新华', 4, '210411', '210411005', 'x');
INSERT INTO `sys_data_region` VALUES (6219, '抚顺城', 4, '210411', '210411007', 'f');
INSERT INTO `sys_data_region` VALUES (6220, '前甸', 4, '210411', '210411102', 'q');
INSERT INTO `sys_data_region` VALUES (6221, '河北', 4, '210411', '210411201', 'h');
INSERT INTO `sys_data_region` VALUES (6222, '会元', 4, '210411', '210411205', 'h');
INSERT INTO `sys_data_region` VALUES (6223, '抚顺县', 3, '2104', '210421', 'f');
INSERT INTO `sys_data_region` VALUES (6224, '石文', 4, '210421', '210421101', 's');
INSERT INTO `sys_data_region` VALUES (6225, '后安', 4, '210421', '210421102', 'h');
INSERT INTO `sys_data_region` VALUES (6226, '救兵', 4, '210421', '210421103', 'j');
INSERT INTO `sys_data_region` VALUES (6227, '上马', 4, '210421', '210421104', 's');
INSERT INTO `sys_data_region` VALUES (6228, '马圈子', 4, '210421', '210421204', 'm');
INSERT INTO `sys_data_region` VALUES (6229, '峡河', 4, '210421', '210421209', 'x');
INSERT INTO `sys_data_region` VALUES (6230, '海浪', 4, '210421', '210421211', 'h');
INSERT INTO `sys_data_region` VALUES (6231, '汤图', 4, '210421', '210421216', 't');
INSERT INTO `sys_data_region` VALUES (6232, '新宾', 3, '2104', '210422', 'x');
INSERT INTO `sys_data_region` VALUES (6233, '新宾镇', 4, '210422', '210422100', 'x');
INSERT INTO `sys_data_region` VALUES (6234, '旺清门', 4, '210422', '210422101', 'w');
INSERT INTO `sys_data_region` VALUES (6235, '永陵', 4, '210422', '210422102', 'y');
INSERT INTO `sys_data_region` VALUES (6236, '平顶山', 4, '210422', '210422103', 'p');
INSERT INTO `sys_data_region` VALUES (6237, '大四平', 4, '210422', '210422104', 'd');
INSERT INTO `sys_data_region` VALUES (6238, '苇子峪', 4, '210422', '210422105', 'w');
INSERT INTO `sys_data_region` VALUES (6239, '木奇', 4, '210422', '210422106', 'm');
INSERT INTO `sys_data_region` VALUES (6240, '上夹河', 4, '210422', '210422108', 's');
INSERT INTO `sys_data_region` VALUES (6241, '南杂木', 4, '210422', '210422109', 'n');
INSERT INTO `sys_data_region` VALUES (6242, '红升', 4, '210422', '210422202', 'h');
INSERT INTO `sys_data_region` VALUES (6243, '响水河子', 4, '210422', '210422203', 'x');
INSERT INTO `sys_data_region` VALUES (6244, '红庙子', 4, '210422', '210422204', 'h');
INSERT INTO `sys_data_region` VALUES (6245, '北四平', 4, '210422', '210422205', 'b');
INSERT INTO `sys_data_region` VALUES (6246, '榆树', 4, '210422', '210422207', 'y');
INSERT INTO `sys_data_region` VALUES (6247, '下夹河', 4, '210422', '210422208', 'x');
INSERT INTO `sys_data_region` VALUES (6248, '清原', 3, '2104', '210423', 'q');
INSERT INTO `sys_data_region` VALUES (6249, '清原镇', 4, '210423', '210423100', 'q');
INSERT INTO `sys_data_region` VALUES (6250, '红透山', 4, '210423', '210423101', 'h');
INSERT INTO `sys_data_region` VALUES (6251, '北三家', 4, '210423', '210423102', 'b');
INSERT INTO `sys_data_region` VALUES (6252, '草市', 4, '210423', '210423103', 'c');
INSERT INTO `sys_data_region` VALUES (6253, '英额门', 4, '210423', '210423104', 'y');
INSERT INTO `sys_data_region` VALUES (6254, '南口前', 4, '210423', '210423105', 'n');
INSERT INTO `sys_data_region` VALUES (6255, '南山城', 4, '210423', '210423106', 'n');
INSERT INTO `sys_data_region` VALUES (6256, '湾甸子', 4, '210423', '210423107', 'w');
INSERT INTO `sys_data_region` VALUES (6257, '大孤家', 4, '210423', '210423108', 'd');
INSERT INTO `sys_data_region` VALUES (6258, '夏家堡', 4, '210423', '210423109', 'x');
INSERT INTO `sys_data_region` VALUES (6259, '土口子', 4, '210423', '210423203', 't');
INSERT INTO `sys_data_region` VALUES (6260, '敖家堡', 4, '210423', '210423206', 'a');
INSERT INTO `sys_data_region` VALUES (6261, '大苏河', 4, '210423', '210423207', 'd');
INSERT INTO `sys_data_region` VALUES (6262, '枸乃甸', 4, '210423', '210423208', 'g');
INSERT INTO `sys_data_region` VALUES (6263, '本溪', 2, '21', '2105', 'b');
INSERT INTO `sys_data_region` VALUES (6264, '平山', 3, '2105', '210502', 'p');
INSERT INTO `sys_data_region` VALUES (6265, '南地', 4, '210502', '210502001', 'n');
INSERT INTO `sys_data_region` VALUES (6266, '平山街道', 4, '210502', '210502003', 'p');
INSERT INTO `sys_data_region` VALUES (6267, '东明', 4, '210502', '210502004', 'd');
INSERT INTO `sys_data_region` VALUES (6268, '崔东', 4, '210502', '210502005', 'c');
INSERT INTO `sys_data_region` VALUES (6269, '站前', 4, '210502', '210502007', 'z');
INSERT INTO `sys_data_region` VALUES (6270, '千金', 4, '210502', '210502008', 'q');
INSERT INTO `sys_data_region` VALUES (6271, '桥北', 4, '210502', '210502012', 'q');
INSERT INTO `sys_data_region` VALUES (6272, '溪湖', 3, '2105', '210503', 'x');
INSERT INTO `sys_data_region` VALUES (6273, '河东', 4, '210503', '210503001', 'h');
INSERT INTO `sys_data_region` VALUES (6274, '河西', 4, '210503', '210503003', 'h');
INSERT INTO `sys_data_region` VALUES (6275, '彩屯', 4, '210503', '210503005', 'c');
INSERT INTO `sys_data_region` VALUES (6276, '东风', 4, '210503', '210503009', 'd');
INSERT INTO `sys_data_region` VALUES (6277, '石桥子', 4, '210503', '210503010', 's');
INSERT INTO `sys_data_region` VALUES (6278, '日月岛', 4, '210503', '210503012', 'r');
INSERT INTO `sys_data_region` VALUES (6279, '火连寨', 4, '210503', '210503013', 'h');
INSERT INTO `sys_data_region` VALUES (6280, '明山', 3, '2105', '210504', 'm');
INSERT INTO `sys_data_region` VALUES (6281, '北地', 4, '210504', '210504002', 'b');
INSERT INTO `sys_data_region` VALUES (6282, '高峪', 4, '210504', '210504004', 'g');
INSERT INTO `sys_data_region` VALUES (6283, '明山街道', 4, '210504', '210504005', 'm');
INSERT INTO `sys_data_region` VALUES (6284, '新明', 4, '210504', '210504008', 'x');
INSERT INTO `sys_data_region` VALUES (6285, '牛心台', 4, '210504', '210504009', 'n');
INSERT INTO `sys_data_region` VALUES (6286, '卧龙', 4, '210504', '210504010', 'w');
INSERT INTO `sys_data_region` VALUES (6287, '高台子', 4, '210504', '210504011', 'g');
INSERT INTO `sys_data_region` VALUES (6288, '南芬', 3, '2105', '210505', 'n');
INSERT INTO `sys_data_region` VALUES (6289, '南芬街道', 4, '210505', '210505001', 'n');
INSERT INTO `sys_data_region` VALUES (6290, '思山岭', 4, '210505', '210505004', 's');
INSERT INTO `sys_data_region` VALUES (6291, '下马塘', 4, '210505', '210505005', 'x');
INSERT INTO `sys_data_region` VALUES (6292, '本溪满族自治县', 3, '2105', '210521', 'b');
INSERT INTO `sys_data_region` VALUES (6293, '观音阁', 4, '210521', '210521003', 'g');
INSERT INTO `sys_data_region` VALUES (6294, '小市', 4, '210521', '210521100', 'x');
INSERT INTO `sys_data_region` VALUES (6295, '草河掌', 4, '210521', '210521101', 'c');
INSERT INTO `sys_data_region` VALUES (6296, '草河城', 4, '210521', '210521102', 'c');
INSERT INTO `sys_data_region` VALUES (6297, '草河口', 4, '210521', '210521103', 'c');
INSERT INTO `sys_data_region` VALUES (6298, '连山关', 4, '210521', '210521104', 'l');
INSERT INTO `sys_data_region` VALUES (6299, '清河城', 4, '210521', '210521106', 'q');
INSERT INTO `sys_data_region` VALUES (6300, '田师傅', 4, '210521', '210521109', 't');
INSERT INTO `sys_data_region` VALUES (6301, '南甸子', 4, '210521', '210521110', 'n');
INSERT INTO `sys_data_region` VALUES (6302, '碱厂', 4, '210521', '210521111', 'j');
INSERT INTO `sys_data_region` VALUES (6303, '高官', 4, '210521', '210521112', 'g');
INSERT INTO `sys_data_region` VALUES (6304, '东营坊', 4, '210521', '210521202', 'd');
INSERT INTO `sys_data_region` VALUES (6305, '桓仁', 3, '2105', '210522', 'h');
INSERT INTO `sys_data_region` VALUES (6306, '八卦城', 4, '210522', '210522001', 'b');
INSERT INTO `sys_data_region` VALUES (6307, '桓仁镇', 4, '210522', '210522100', 'h');
INSERT INTO `sys_data_region` VALUES (6308, '普乐堡', 4, '210522', '210522101', 'p');
INSERT INTO `sys_data_region` VALUES (6309, '二棚甸子', 4, '210522', '210522102', 'e');
INSERT INTO `sys_data_region` VALUES (6310, '沙尖子', 4, '210522', '210522103', 's');
INSERT INTO `sys_data_region` VALUES (6311, '五里甸子', 4, '210522', '210522104', 'w');
INSERT INTO `sys_data_region` VALUES (6312, '八里甸子', 4, '210522', '210522108', 'b');
INSERT INTO `sys_data_region` VALUES (6313, '华来', 4, '210522', '210522110', 'h');
INSERT INTO `sys_data_region` VALUES (6314, '古城', 4, '210522', '210522111', 'g');
INSERT INTO `sys_data_region` VALUES (6315, '雅河', 4, '210522', '210522201', 'y');
INSERT INTO `sys_data_region` VALUES (6316, '向阳', 4, '210522', '210522202', 'x');
INSERT INTO `sys_data_region` VALUES (6317, '黑沟', 4, '210522', '210522206', 'h');
INSERT INTO `sys_data_region` VALUES (6318, '北甸子', 4, '210522', '210522208', 'b');
INSERT INTO `sys_data_region` VALUES (6319, '丹东', 2, '21', '2106', 'd');
INSERT INTO `sys_data_region` VALUES (6320, '元宝', 3, '2106', '210602', 'y');
INSERT INTO `sys_data_region` VALUES (6321, '七道', 4, '210602', '210602002', 'q');
INSERT INTO `sys_data_region` VALUES (6322, '九道', 4, '210602', '210602004', 'j');
INSERT INTO `sys_data_region` VALUES (6323, '兴东', 4, '210602', '210602006', 'x');
INSERT INTO `sys_data_region` VALUES (6324, '广济', 4, '210602', '210602007', 'g');
INSERT INTO `sys_data_region` VALUES (6325, '金山', 4, '210602', '210602101', 'j');
INSERT INTO `sys_data_region` VALUES (6326, '振兴', 3, '2106', '210603', 'z');
INSERT INTO `sys_data_region` VALUES (6327, '站前', 4, '210603', '210603002', 'z');
INSERT INTO `sys_data_region` VALUES (6328, '临江', 4, '210603', '210603003', 'l');
INSERT INTO `sys_data_region` VALUES (6329, '帽盔山', 4, '210603', '210603005', 'm');
INSERT INTO `sys_data_region` VALUES (6330, '纤维', 4, '210603', '210603006', 'x');
INSERT INTO `sys_data_region` VALUES (6331, '永昌', 4, '210603', '210603007', 'y');
INSERT INTO `sys_data_region` VALUES (6332, '花园', 4, '210603', '210603008', 'h');
INSERT INTO `sys_data_region` VALUES (6333, '浪头', 4, '210603', '210603101', 'l');
INSERT INTO `sys_data_region` VALUES (6334, '安民', 4, '210603', '210603102', 'a');
INSERT INTO `sys_data_region` VALUES (6335, '汤池', 4, '210603', '210603103', 't');
INSERT INTO `sys_data_region` VALUES (6336, '振安', 3, '2106', '210604', 'z');
INSERT INTO `sys_data_region` VALUES (6337, '鸭绿江', 4, '210604', '210604001', 'y');
INSERT INTO `sys_data_region` VALUES (6338, '金矿', 4, '210604', '210604003', 'j');
INSERT INTO `sys_data_region` VALUES (6339, '珍珠', 4, '210604', '210604004', 'z');
INSERT INTO `sys_data_region` VALUES (6340, '太平湾', 4, '210604', '210604005', 't');
INSERT INTO `sys_data_region` VALUES (6341, '同兴', 4, '210604', '210604102', 't');
INSERT INTO `sys_data_region` VALUES (6342, '五龙背', 4, '210604', '210604104', 'w');
INSERT INTO `sys_data_region` VALUES (6343, '楼房', 4, '210604', '210604105', 'l');
INSERT INTO `sys_data_region` VALUES (6344, '九连城', 4, '210604', '210604106', 'j');
INSERT INTO `sys_data_region` VALUES (6345, '汤山城', 4, '210604', '210604107', 't');
INSERT INTO `sys_data_region` VALUES (6346, '宽甸', 3, '2106', '210624', 'k');
INSERT INTO `sys_data_region` VALUES (6347, '宽甸镇', 4, '210624', '210624100', 'k');
INSERT INTO `sys_data_region` VALUES (6348, '灌水', 4, '210624', '210624101', 'g');
INSERT INTO `sys_data_region` VALUES (6349, '硼海', 4, '210624', '210624102', 'p');
INSERT INTO `sys_data_region` VALUES (6350, '红石', 4, '210624', '210624103', 'h');
INSERT INTO `sys_data_region` VALUES (6351, '毛甸子', 4, '210624', '210624104', 'm');
INSERT INTO `sys_data_region` VALUES (6352, '长甸', 4, '210624', '210624105', 'c');
INSERT INTO `sys_data_region` VALUES (6353, '永甸', 4, '210624', '210624106', 'y');
INSERT INTO `sys_data_region` VALUES (6354, '太平哨', 4, '210624', '210624108', 't');
INSERT INTO `sys_data_region` VALUES (6355, '青山沟', 4, '210624', '210624109', 'q');
INSERT INTO `sys_data_region` VALUES (6356, '牛毛坞', 4, '210624', '210624110', 'n');
INSERT INTO `sys_data_region` VALUES (6357, '大川头', 4, '210624', '210624111', 'd');
INSERT INTO `sys_data_region` VALUES (6358, '青椅山', 4, '210624', '210624112', 'q');
INSERT INTO `sys_data_region` VALUES (6359, '杨木川', 4, '210624', '210624113', 'y');
INSERT INTO `sys_data_region` VALUES (6360, '虎山', 4, '210624', '210624114', 'h');
INSERT INTO `sys_data_region` VALUES (6361, '振江', 4, '210624', '210624115', 'z');
INSERT INTO `sys_data_region` VALUES (6362, '步达远', 4, '210624', '210624116', 'b');
INSERT INTO `sys_data_region` VALUES (6363, '大西岔', 4, '210624', '210624117', 'd');
INSERT INTO `sys_data_region` VALUES (6364, '八河川', 4, '210624', '210624118', 'b');
INSERT INTO `sys_data_region` VALUES (6365, '双山子', 4, '210624', '210624119', 's');
INSERT INTO `sys_data_region` VALUES (6366, '石湖沟', 4, '210624', '210624201', 's');
INSERT INTO `sys_data_region` VALUES (6367, '下露河', 4, '210624', '210624202', 'x');
INSERT INTO `sys_data_region` VALUES (6368, '古楼子', 4, '210624', '210624206', 'g');
INSERT INTO `sys_data_region` VALUES (6369, '东港', 3, '2106', '210681', 'd');
INSERT INTO `sys_data_region` VALUES (6370, '大东', 4, '210681', '210681001', 'd');
INSERT INTO `sys_data_region` VALUES (6371, '新兴', 4, '210681', '210681002', 'x');
INSERT INTO `sys_data_region` VALUES (6372, '新城', 4, '210681', '210681003', 'x');
INSERT INTO `sys_data_region` VALUES (6373, '孤山', 4, '210681', '210681101', 'g');
INSERT INTO `sys_data_region` VALUES (6374, '前阳', 4, '210681', '210681104', 'q');
INSERT INTO `sys_data_region` VALUES (6375, '长安', 4, '210681', '210681105', 'c');
INSERT INTO `sys_data_region` VALUES (6376, '十字街', 4, '210681', '210681106', 's');
INSERT INTO `sys_data_region` VALUES (6377, '长山', 4, '210681', '210681107', 'c');
INSERT INTO `sys_data_region` VALUES (6378, '北井子', 4, '210681', '210681108', 'b');
INSERT INTO `sys_data_region` VALUES (6379, '椅圈', 4, '210681', '210681109', 'y');
INSERT INTO `sys_data_region` VALUES (6380, '黄土坎', 4, '210681', '210681110', 'h');
INSERT INTO `sys_data_region` VALUES (6381, '马家店', 4, '210681', '210681113', 'm');
INSERT INTO `sys_data_region` VALUES (6382, '龙王庙', 4, '210681', '210681114', 'l');
INSERT INTO `sys_data_region` VALUES (6383, '小甸子', 4, '210681', '210681115', 'x');
INSERT INTO `sys_data_region` VALUES (6384, '菩萨庙', 4, '210681', '210681117', 'p');
INSERT INTO `sys_data_region` VALUES (6385, '黑沟', 4, '210681', '210681118', 'h');
INSERT INTO `sys_data_region` VALUES (6386, '新农', 4, '210681', '210681119', 'x');
INSERT INTO `sys_data_region` VALUES (6387, '合隆', 4, '210681', '210681204', 'h');
INSERT INTO `sys_data_region` VALUES (6388, '凤城', 3, '2106', '210682', 'f');
INSERT INTO `sys_data_region` VALUES (6389, '凤凰城', 4, '210682', '210682001', 'f');
INSERT INTO `sys_data_region` VALUES (6390, '凤山', 4, '210682', '210682002', 'f');
INSERT INTO `sys_data_region` VALUES (6391, '草河', 4, '210682', '210682003', 'c');
INSERT INTO `sys_data_region` VALUES (6392, '宝山', 4, '210682', '210682101', 'b');
INSERT INTO `sys_data_region` VALUES (6393, '白旗', 4, '210682', '210682102', 'b');
INSERT INTO `sys_data_region` VALUES (6394, '沙里寨', 4, '210682', '210682103', 's');
INSERT INTO `sys_data_region` VALUES (6395, '红旗', 4, '210682', '210682104', 'h');
INSERT INTO `sys_data_region` VALUES (6396, '蓝旗', 4, '210682', '210682105', 'l');
INSERT INTO `sys_data_region` VALUES (6397, '边门', 4, '210682', '210682107', 'b');
INSERT INTO `sys_data_region` VALUES (6398, '东汤', 4, '210682', '210682110', 'd');
INSERT INTO `sys_data_region` VALUES (6399, '石城', 4, '210682', '210682111', 's');
INSERT INTO `sys_data_region` VALUES (6400, '大兴', 4, '210682', '210682112', 'd');
INSERT INTO `sys_data_region` VALUES (6401, '爱阳', 4, '210682', '210682113', 'a');
INSERT INTO `sys_data_region` VALUES (6402, '赛马', 4, '210682', '210682114', 's');
INSERT INTO `sys_data_region` VALUES (6403, '弟兄山', 4, '210682', '210682115', 'd');
INSERT INTO `sys_data_region` VALUES (6404, '鸡冠山', 4, '210682', '210682116', 'j');
INSERT INTO `sys_data_region` VALUES (6405, '刘家河', 4, '210682', '210682117', 'l');
INSERT INTO `sys_data_region` VALUES (6406, '通远堡', 4, '210682', '210682118', 't');
INSERT INTO `sys_data_region` VALUES (6407, '四门子', 4, '210682', '210682119', 's');
INSERT INTO `sys_data_region` VALUES (6408, '青城子', 4, '210682', '210682120', 'q');
INSERT INTO `sys_data_region` VALUES (6409, '大堡', 4, '210682', '210682201', 'd');
INSERT INTO `sys_data_region` VALUES (6410, '锦州', 2, '21', '2107', 'j');
INSERT INTO `sys_data_region` VALUES (6411, '古塔', 3, '2107', '210702', 'g');
INSERT INTO `sys_data_region` VALUES (6412, '石油', 4, '210702', '210702002', 's');
INSERT INTO `sys_data_region` VALUES (6413, '敬业', 4, '210702', '210702004', 'j');
INSERT INTO `sys_data_region` VALUES (6414, '保安', 4, '210702', '210702005', 'b');
INSERT INTO `sys_data_region` VALUES (6415, '士英', 4, '210702', '210702009', 's');
INSERT INTO `sys_data_region` VALUES (6416, '古城', 4, '210702', '210702011', 'g');
INSERT INTO `sys_data_region` VALUES (6417, '凌河', 3, '2107', '210703', 'l');
INSERT INTO `sys_data_region` VALUES (6418, '石桥子', 4, '210703', '210703002', 's');
INSERT INTO `sys_data_region` VALUES (6419, '龙江', 4, '210703', '210703003', 'l');
INSERT INTO `sys_data_region` VALUES (6420, '榴花', 4, '210703', '210703004', 'l');
INSERT INTO `sys_data_region` VALUES (6421, '康宁', 4, '210703', '210703008', 'k');
INSERT INTO `sys_data_region` VALUES (6422, '锦铁', 4, '210703', '210703009', 'j');
INSERT INTO `sys_data_region` VALUES (6423, '紫荆', 4, '210703', '210703011', 'z');
INSERT INTO `sys_data_region` VALUES (6424, '太和', 3, '2107', '210711', 't');
INSERT INTO `sys_data_region` VALUES (6425, '太和街道', 4, '210711', '210711004', 't');
INSERT INTO `sys_data_region` VALUES (6426, '大薛', 4, '210711', '210711008', 'd');
INSERT INTO `sys_data_region` VALUES (6427, '天桥', 4, '210711', '210711010', 't');
INSERT INTO `sys_data_region` VALUES (6428, '新民', 4, '210711', '210711011', 'x');
INSERT INTO `sys_data_region` VALUES (6429, '营盘', 4, '210711', '210711012', 'y');
INSERT INTO `sys_data_region` VALUES (6430, '女儿河', 4, '210711', '210711013', 'n');
INSERT INTO `sys_data_region` VALUES (6431, '杏山', 4, '210711', '210711014', 'x');
INSERT INTO `sys_data_region` VALUES (6432, '凌南', 4, '210711', '210711015', 'l');
INSERT INTO `sys_data_region` VALUES (6433, '松山', 4, '210711', '210711016', 's');
INSERT INTO `sys_data_region` VALUES (6434, '娘娘宫', 4, '210711', '210711017', 'n');
INSERT INTO `sys_data_region` VALUES (6435, '黑山', 3, '2107', '210726', 'h');
INSERT INTO `sys_data_region` VALUES (6436, '黑山街道', 4, '210726', '210726001', 'h');
INSERT INTO `sys_data_region` VALUES (6437, '大虎山', 4, '210726', '210726002', 'd');
INSERT INTO `sys_data_region` VALUES (6438, '芳山', 4, '210726', '210726101', 'f');
INSERT INTO `sys_data_region` VALUES (6439, '白厂门', 4, '210726', '210726102', 'b');
INSERT INTO `sys_data_region` VALUES (6440, '常兴', 4, '210726', '210726103', 'c');
INSERT INTO `sys_data_region` VALUES (6441, '姜屯', 4, '210726', '210726104', 'j');
INSERT INTO `sys_data_region` VALUES (6442, '励家', 4, '210726', '210726105', 'l');
INSERT INTO `sys_data_region` VALUES (6443, '绕阳河', 4, '210726', '210726106', 'r');
INSERT INTO `sys_data_region` VALUES (6444, '半拉门', 4, '210726', '210726107', 'b');
INSERT INTO `sys_data_region` VALUES (6445, '无梁殿', 4, '210726', '210726108', 'w');
INSERT INTO `sys_data_region` VALUES (6446, '胡家', 4, '210726', '210726109', 'h');
INSERT INTO `sys_data_region` VALUES (6447, '新立屯', 4, '210726', '210726110', 'x');
INSERT INTO `sys_data_region` VALUES (6448, '八道壕', 4, '210726', '210726111', 'b');
INSERT INTO `sys_data_region` VALUES (6449, '四家子', 4, '210726', '210726113', 's');
INSERT INTO `sys_data_region` VALUES (6450, '新兴', 4, '210726', '210726114', 'x');
INSERT INTO `sys_data_region` VALUES (6451, '小东', 4, '210726', '210726115', 'x');
INSERT INTO `sys_data_region` VALUES (6452, '太和', 4, '210726', '210726116', 't');
INSERT INTO `sys_data_region` VALUES (6453, '镇安', 4, '210726', '210726117', 'z');
INSERT INTO `sys_data_region` VALUES (6454, '英城子', 4, '210726', '210726201', 'y');
INSERT INTO `sys_data_region` VALUES (6455, '段家', 4, '210726', '210726209', 'd');
INSERT INTO `sys_data_region` VALUES (6456, '大兴', 4, '210726', '210726210', 'd');
INSERT INTO `sys_data_region` VALUES (6457, '薛屯', 4, '210726', '210726212', 'x');
INSERT INTO `sys_data_region` VALUES (6458, '义县', 3, '2107', '210727', 'y');
INSERT INTO `sys_data_region` VALUES (6459, '义州', 4, '210727', '210727001', 'y');
INSERT INTO `sys_data_region` VALUES (6460, '城关', 4, '210727', '210727002', 'c');
INSERT INTO `sys_data_region` VALUES (6461, '刘龙台', 4, '210727', '210727101', 'l');
INSERT INTO `sys_data_region` VALUES (6462, '七里河', 4, '210727', '210727102', 'q');
INSERT INTO `sys_data_region` VALUES (6463, '大榆树堡', 4, '210727', '210727103', 'd');
INSERT INTO `sys_data_region` VALUES (6464, '稍户营子', 4, '210727', '210727104', 's');
INSERT INTO `sys_data_region` VALUES (6465, '九道岭', 4, '210727', '210727105', 'j');
INSERT INTO `sys_data_region` VALUES (6466, '高台子', 4, '210727', '210727106', 'g');
INSERT INTO `sys_data_region` VALUES (6467, '瓦子峪', 4, '210727', '210727108', 'w');
INSERT INTO `sys_data_region` VALUES (6468, '头台', 4, '210727', '210727109', 't');
INSERT INTO `sys_data_region` VALUES (6469, '张家堡', 4, '210727', '210727110', 'z');
INSERT INTO `sys_data_region` VALUES (6470, '前杨', 4, '210727', '210727111', 'q');
INSERT INTO `sys_data_region` VALUES (6471, '头道河', 4, '210727', '210727112', 't');
INSERT INTO `sys_data_region` VALUES (6472, '留龙沟', 4, '210727', '210727113', 'l');
INSERT INTO `sys_data_region` VALUES (6473, '聚粮屯', 4, '210727', '210727114', 'j');
INSERT INTO `sys_data_region` VALUES (6474, '白庙子', 4, '210727', '210727115', 'b');
INSERT INTO `sys_data_region` VALUES (6475, '地藏寺', 4, '210727', '210727203', 'd');
INSERT INTO `sys_data_region` VALUES (6476, '大定堡', 4, '210727', '210727205', 'd');
INSERT INTO `sys_data_region` VALUES (6477, '凌海', 3, '2107', '210781', 'l');
INSERT INTO `sys_data_region` VALUES (6478, '大凌河', 4, '210781', '210781001', 'd');
INSERT INTO `sys_data_region` VALUES (6479, '金城', 4, '210781', '210781002', 'j');
INSERT INTO `sys_data_region` VALUES (6480, '八千', 4, '210781', '210781003', 'b');
INSERT INTO `sys_data_region` VALUES (6481, '石山', 4, '210781', '210781101', 's');
INSERT INTO `sys_data_region` VALUES (6482, '余积', 4, '210781', '210781102', 'y');
INSERT INTO `sys_data_region` VALUES (6483, '双羊', 4, '210781', '210781103', 's');
INSERT INTO `sys_data_region` VALUES (6484, '班吉塔', 4, '210781', '210781104', 'b');
INSERT INTO `sys_data_region` VALUES (6485, '沈家台', 4, '210781', '210781105', 's');
INSERT INTO `sys_data_region` VALUES (6486, '三台子', 4, '210781', '210781106', 's');
INSERT INTO `sys_data_region` VALUES (6487, '右卫', 4, '210781', '210781107', 'y');
INSERT INTO `sys_data_region` VALUES (6488, '阎家', 4, '210781', '210781108', 'y');
INSERT INTO `sys_data_region` VALUES (6489, '新庄子', 4, '210781', '210781109', 'x');
INSERT INTO `sys_data_region` VALUES (6490, '翠岩', 4, '210781', '210781112', 'c');
INSERT INTO `sys_data_region` VALUES (6491, '安屯', 4, '210781', '210781113', 'a');
INSERT INTO `sys_data_region` VALUES (6492, '大业', 4, '210781', '210781114', 'd');
INSERT INTO `sys_data_region` VALUES (6493, '白台子', 4, '210781', '210781116', 'b');
INSERT INTO `sys_data_region` VALUES (6494, '温滴楼', 4, '210781', '210781117', 'w');
INSERT INTO `sys_data_region` VALUES (6495, '建业', 4, '210781', '210781118', 'j');
INSERT INTO `sys_data_region` VALUES (6496, '板石沟', 4, '210781', '210781212', 'b');
INSERT INTO `sys_data_region` VALUES (6497, '谢屯', 4, '210781', '210781217', 'x');
INSERT INTO `sys_data_region` VALUES (6498, '北镇', 3, '2107', '210782', 'b');
INSERT INTO `sys_data_region` VALUES (6499, '北镇街道', 4, '210782', '210782004', 'b');
INSERT INTO `sys_data_region` VALUES (6500, '广宁', 4, '210782', '210782006', 'g');
INSERT INTO `sys_data_region` VALUES (6501, '富屯', 4, '210782', '210782007', 'f');
INSERT INTO `sys_data_region` VALUES (6502, '沟帮子', 4, '210782', '210782008', 'g');
INSERT INTO `sys_data_region` VALUES (6503, '大市', 4, '210782', '210782101', 'd');
INSERT INTO `sys_data_region` VALUES (6504, '罗罗堡', 4, '210782', '210782102', 'l');
INSERT INTO `sys_data_region` VALUES (6505, '常兴店', 4, '210782', '210782103', 'c');
INSERT INTO `sys_data_region` VALUES (6506, '正安', 4, '210782', '210782104', 'z');
INSERT INTO `sys_data_region` VALUES (6507, '闾阳', 4, '210782', '210782105', 'l');
INSERT INTO `sys_data_region` VALUES (6508, '中安', 4, '210782', '210782106', 'z');
INSERT INTO `sys_data_region` VALUES (6509, '廖屯', 4, '210782', '210782107', 'l');
INSERT INTO `sys_data_region` VALUES (6510, '赵屯', 4, '210782', '210782109', 'z');
INSERT INTO `sys_data_region` VALUES (6511, '青堆子', 4, '210782', '210782110', 'q');
INSERT INTO `sys_data_region` VALUES (6512, '高山子', 4, '210782', '210782111', 'g');
INSERT INTO `sys_data_region` VALUES (6513, '吴家', 4, '210782', '210782113', 'w');
INSERT INTO `sys_data_region` VALUES (6514, '鲍家', 4, '210782', '210782203', 'b');
INSERT INTO `sys_data_region` VALUES (6515, '大屯', 4, '210782', '210782206', 'd');
INSERT INTO `sys_data_region` VALUES (6516, '柳家', 4, '210782', '210782209', 'l');
INSERT INTO `sys_data_region` VALUES (6517, '营口', 2, '21', '2108', 'y');
INSERT INTO `sys_data_region` VALUES (6518, '站前', 3, '2108', '210802', 'z');
INSERT INTO `sys_data_region` VALUES (6519, '八田地', 4, '210802', '210802001', 'b');
INSERT INTO `sys_data_region` VALUES (6520, '建丰', 4, '210802', '210802002', 'j');
INSERT INTO `sys_data_region` VALUES (6521, '建设', 4, '210802', '210802003', 'j');
INSERT INTO `sys_data_region` VALUES (6522, '跃进', 4, '210802', '210802004', 'y');
INSERT INTO `sys_data_region` VALUES (6523, '东兴', 4, '210802', '210802008', 'd');
INSERT INTO `sys_data_region` VALUES (6524, '西市', 3, '2108', '210803', 'x');
INSERT INTO `sys_data_region` VALUES (6525, '得胜', 4, '210803', '210803004', 'd');
INSERT INTO `sys_data_region` VALUES (6526, '五台子', 4, '210803', '210803005', 'w');
INSERT INTO `sys_data_region` VALUES (6527, '渔市', 4, '210803', '210803010', 'y');
INSERT INTO `sys_data_region` VALUES (6528, '滨海', 4, '210803', '210803011', 'b');
INSERT INTO `sys_data_region` VALUES (6529, '清华', 4, '210803', '210803012', 'q');
INSERT INTO `sys_data_region` VALUES (6530, '辽宁营口沿海产业基地', 4, '210803', '210803401', 'l');
INSERT INTO `sys_data_region` VALUES (6531, '鲅鱼圈', 3, '2108', '210804', 'b');
INSERT INTO `sys_data_region` VALUES (6532, '红海', 4, '210804', '210804001', 'h');
INSERT INTO `sys_data_region` VALUES (6533, '海星', 4, '210804', '210804002', 'h');
INSERT INTO `sys_data_region` VALUES (6534, '望海', 4, '210804', '210804005', 'w');
INSERT INTO `sys_data_region` VALUES (6535, '熊岳', 4, '210804', '210804100', 'x');
INSERT INTO `sys_data_region` VALUES (6536, '芦屯', 4, '210804', '210804102', 'l');
INSERT INTO `sys_data_region` VALUES (6537, '红旗', 4, '210804', '210804103', 'h');
INSERT INTO `sys_data_region` VALUES (6538, '老边', 3, '2108', '210811', 'l');
INSERT INTO `sys_data_region` VALUES (6539, '老边街道', 4, '210811', '210811003', 'l');
INSERT INTO `sys_data_region` VALUES (6540, '路南', 4, '210811', '210811101', 'l');
INSERT INTO `sys_data_region` VALUES (6541, '柳树', 4, '210811', '210811102', 'l');
INSERT INTO `sys_data_region` VALUES (6542, '边城', 4, '210811', '210811103', 'b');
INSERT INTO `sys_data_region` VALUES (6543, '盖州', 3, '2108', '210881', 'g');
INSERT INTO `sys_data_region` VALUES (6544, '鼓楼', 4, '210881', '210881001', 'g');
INSERT INTO `sys_data_region` VALUES (6545, '西城', 4, '210881', '210881002', 'x');
INSERT INTO `sys_data_region` VALUES (6546, '东城', 4, '210881', '210881003', 'd');
INSERT INTO `sys_data_region` VALUES (6547, '太阳升', 4, '210881', '210881004', 't');
INSERT INTO `sys_data_region` VALUES (6548, '团山', 4, '210881', '210881005', 't');
INSERT INTO `sys_data_region` VALUES (6549, '西海', 4, '210881', '210881006', 'x');
INSERT INTO `sys_data_region` VALUES (6550, '九垅地', 4, '210881', '210881007', 'j');
INSERT INTO `sys_data_region` VALUES (6551, '归州', 4, '210881', '210881008', 'g');
INSERT INTO `sys_data_region` VALUES (6552, '高屯', 4, '210881', '210881102', 'g');
INSERT INTO `sys_data_region` VALUES (6553, '沙岗', 4, '210881', '210881105', 's');
INSERT INTO `sys_data_region` VALUES (6554, '九寨', 4, '210881', '210881109', 'j');
INSERT INTO `sys_data_region` VALUES (6555, '万福', 4, '210881', '210881110', 'w');
INSERT INTO `sys_data_region` VALUES (6556, '卧龙泉', 4, '210881', '210881111', 'w');
INSERT INTO `sys_data_region` VALUES (6557, '青石岭', 4, '210881', '210881112', 'q');
INSERT INTO `sys_data_region` VALUES (6558, '暖泉', 4, '210881', '210881113', 'n');
INSERT INTO `sys_data_region` VALUES (6559, '榜式堡', 4, '210881', '210881116', 'b');
INSERT INTO `sys_data_region` VALUES (6560, '团甸', 4, '210881', '210881117', 't');
INSERT INTO `sys_data_region` VALUES (6561, '双台', 4, '210881', '210881118', 's');
INSERT INTO `sys_data_region` VALUES (6562, '杨运', 4, '210881', '210881119', 'y');
INSERT INTO `sys_data_region` VALUES (6563, '徐屯', 4, '210881', '210881120', 'x');
INSERT INTO `sys_data_region` VALUES (6564, '什字街', 4, '210881', '210881121', 's');
INSERT INTO `sys_data_region` VALUES (6565, '矿洞沟', 4, '210881', '210881122', 'k');
INSERT INTO `sys_data_region` VALUES (6566, '陈屯', 4, '210881', '210881123', 'c');
INSERT INTO `sys_data_region` VALUES (6567, '梁屯', 4, '210881', '210881124', 'l');
INSERT INTO `sys_data_region` VALUES (6568, '小石棚', 4, '210881', '210881216', 'x');
INSERT INTO `sys_data_region` VALUES (6569, '果园', 4, '210881', '210881217', 'g');
INSERT INTO `sys_data_region` VALUES (6570, '二台', 4, '210881', '210881218', 'e');
INSERT INTO `sys_data_region` VALUES (6571, '大石桥', 3, '2108', '210882', 'd');
INSERT INTO `sys_data_region` VALUES (6572, '金桥', 4, '210882', '210882003', 'j');
INSERT INTO `sys_data_region` VALUES (6573, '钢都', 4, '210882', '210882004', 'g');
INSERT INTO `sys_data_region` VALUES (6574, '南楼', 4, '210882', '210882005', 'n');
INSERT INTO `sys_data_region` VALUES (6575, '镁都', 4, '210882', '210882007', 'm');
INSERT INTO `sys_data_region` VALUES (6576, '水源', 4, '210882', '210882101', 's');
INSERT INTO `sys_data_region` VALUES (6577, '沟沿', 4, '210882', '210882102', 'g');
INSERT INTO `sys_data_region` VALUES (6578, '石佛', 4, '210882', '210882103', 's');
INSERT INTO `sys_data_region` VALUES (6579, '高坎', 4, '210882', '210882104', 'g');
INSERT INTO `sys_data_region` VALUES (6580, '旗口', 4, '210882', '210882105', 'q');
INSERT INTO `sys_data_region` VALUES (6581, '虎庄', 4, '210882', '210882106', 'h');
INSERT INTO `sys_data_region` VALUES (6582, '官屯', 4, '210882', '210882107', 'g');
INSERT INTO `sys_data_region` VALUES (6583, '博洛铺', 4, '210882', '210882112', 'b');
INSERT INTO `sys_data_region` VALUES (6584, '永安', 4, '210882', '210882113', 'y');
INSERT INTO `sys_data_region` VALUES (6585, '汤池', 4, '210882', '210882114', 't');
INSERT INTO `sys_data_region` VALUES (6586, '建一', 4, '210882', '210882115', 'j');
INSERT INTO `sys_data_region` VALUES (6587, '黄土岭', 4, '210882', '210882116', 'h');
INSERT INTO `sys_data_region` VALUES (6588, '周家', 4, '210882', '210882117', 'z');
INSERT INTO `sys_data_region` VALUES (6589, '阜新', 2, '21', '2109', 'f');
INSERT INTO `sys_data_region` VALUES (6590, '海州', 3, '2109', '210902', 'h');
INSERT INTO `sys_data_region` VALUES (6591, '和平', 4, '210902', '210902001', 'h');
INSERT INTO `sys_data_region` VALUES (6592, '站前', 4, '210902', '210902002', 'z');
INSERT INTO `sys_data_region` VALUES (6593, '五龙', 4, '210902', '210902003', 'w');
INSERT INTO `sys_data_region` VALUES (6594, '西山', 4, '210902', '210902004', 'x');
INSERT INTO `sys_data_region` VALUES (6595, '河北', 4, '210902', '210902005', 'h');
INSERT INTO `sys_data_region` VALUES (6596, '平安西部', 4, '210902', '210902006', 'p');
INSERT INTO `sys_data_region` VALUES (6597, '韩家店', 4, '210902', '210902101', 'h');
INSERT INTO `sys_data_region` VALUES (6598, '新邱', 3, '2109', '210903', 'x');
INSERT INTO `sys_data_region` VALUES (6599, '街基', 4, '210903', '210903001', 'j');
INSERT INTO `sys_data_region` VALUES (6600, '新发屯', 4, '210903', '210903002', 'x');
INSERT INTO `sys_data_region` VALUES (6601, '长营子', 4, '210903', '210903101', 'c');
INSERT INTO `sys_data_region` VALUES (6602, '太平', 3, '2109', '210904', 't');
INSERT INTO `sys_data_region` VALUES (6603, '红树', 4, '210904', '210904001', 'h');
INSERT INTO `sys_data_region` VALUES (6604, '高德', 4, '210904', '210904002', 'g');
INSERT INTO `sys_data_region` VALUES (6605, '孙家湾', 4, '210904', '210904003', 's');
INSERT INTO `sys_data_region` VALUES (6606, '水泉', 4, '210904', '210904101', 's');
INSERT INTO `sys_data_region` VALUES (6607, '清河门', 3, '2109', '210905', 'q');
INSERT INTO `sys_data_region` VALUES (6608, '清河', 4, '210905', '210905001', 'q');
INSERT INTO `sys_data_region` VALUES (6609, '新北', 4, '210905', '210905002', 'x');
INSERT INTO `sys_data_region` VALUES (6610, '河西', 4, '210905', '210905101', 'h');
INSERT INTO `sys_data_region` VALUES (6611, '乌龙坝', 4, '210905', '210905102', 'w');
INSERT INTO `sys_data_region` VALUES (6612, '细河', 3, '2109', '210911', 'x');
INSERT INTO `sys_data_region` VALUES (6613, '玉新', 4, '210911', '210911001', 'y');
INSERT INTO `sys_data_region` VALUES (6614, '玉龙', 4, '210911', '210911002', 'y');
INSERT INTO `sys_data_region` VALUES (6615, '玉丰', 4, '210911', '210911003', 'y');
INSERT INTO `sys_data_region` VALUES (6616, '四合', 4, '210911', '210911102', 's');
INSERT INTO `sys_data_region` VALUES (6617, '阜新蒙古族自治县', 3, '2109', '210921', 'f');
INSERT INTO `sys_data_region` VALUES (6618, '城区', 4, '210921', '210921001', 'c');
INSERT INTO `sys_data_region` VALUES (6619, '阜新镇', 4, '210921', '210921100', 'f');
INSERT INTO `sys_data_region` VALUES (6620, '东梁', 4, '210921', '210921102', 'd');
INSERT INTO `sys_data_region` VALUES (6621, '佛寺', 4, '210921', '210921103', 'f');
INSERT INTO `sys_data_region` VALUES (6622, '伊吗图', 4, '210921', '210921104', 'y');
INSERT INTO `sys_data_region` VALUES (6623, '旧庙', 4, '210921', '210921105', 'j');
INSERT INTO `sys_data_region` VALUES (6624, '务欢池', 4, '210921', '210921106', 'w');
INSERT INTO `sys_data_region` VALUES (6625, '建设', 4, '210921', '210921107', 'j');
INSERT INTO `sys_data_region` VALUES (6626, '大巴', 4, '210921', '210921108', 'd');
INSERT INTO `sys_data_region` VALUES (6627, '泡子', 4, '210921', '210921109', 'p');
INSERT INTO `sys_data_region` VALUES (6628, '十家子', 4, '210921', '210921110', 's');
INSERT INTO `sys_data_region` VALUES (6629, '王府', 4, '210921', '210921111', 'w');
INSERT INTO `sys_data_region` VALUES (6630, '于寺', 4, '210921', '210921112', 'y');
INSERT INTO `sys_data_region` VALUES (6631, '富荣', 4, '210921', '210921113', 'f');
INSERT INTO `sys_data_region` VALUES (6632, '新民', 4, '210921', '210921114', 'x');
INSERT INTO `sys_data_region` VALUES (6633, '福兴地', 4, '210921', '210921115', 'f');
INSERT INTO `sys_data_region` VALUES (6634, '平安地', 4, '210921', '210921116', 'p');
INSERT INTO `sys_data_region` VALUES (6635, '沙拉', 4, '210921', '210921117', 's');
INSERT INTO `sys_data_region` VALUES (6636, '大固本', 4, '210921', '210921118', 'd');
INSERT INTO `sys_data_region` VALUES (6637, '大五家子', 4, '210921', '210921119', 'd');
INSERT INTO `sys_data_region` VALUES (6638, '大板', 4, '210921', '210921120', 'd');
INSERT INTO `sys_data_region` VALUES (6639, '招束沟', 4, '210921', '210921121', 'z');
INSERT INTO `sys_data_region` VALUES (6640, '八家子', 4, '210921', '210921122', 'b');
INSERT INTO `sys_data_region` VALUES (6641, '扎兰营子', 4, '210921', '210921123', 'z');
INSERT INTO `sys_data_region` VALUES (6642, '塔营子', 4, '210921', '210921124', 't');
INSERT INTO `sys_data_region` VALUES (6643, '红帽子', 4, '210921', '210921125', 'h');
INSERT INTO `sys_data_region` VALUES (6644, '蜘蛛山', 4, '210921', '210921126', 'z');
INSERT INTO `sys_data_region` VALUES (6645, '七家子', 4, '210921', '210921127', 'q');
INSERT INTO `sys_data_region` VALUES (6646, '紫都台', 4, '210921', '210921128', 'z');
INSERT INTO `sys_data_region` VALUES (6647, '化石戈', 4, '210921', '210921129', 'h');
INSERT INTO `sys_data_region` VALUES (6648, '哈达户稍', 4, '210921', '210921130', 'h');
INSERT INTO `sys_data_region` VALUES (6649, '老河土', 4, '210921', '210921131', 'l');
INSERT INTO `sys_data_region` VALUES (6650, '太平', 4, '210921', '210921132', 't');
INSERT INTO `sys_data_region` VALUES (6651, '卧凤沟', 4, '210921', '210921203', 'w');
INSERT INTO `sys_data_region` VALUES (6652, '苍土', 4, '210921', '210921211', 'c');
INSERT INTO `sys_data_region` VALUES (6653, '国华', 4, '210921', '210921222', 'g');
INSERT INTO `sys_data_region` VALUES (6654, '彰武', 3, '2109', '210922', 'z');
INSERT INTO `sys_data_region` VALUES (6655, '彰武镇', 4, '210922', '210922100', 'z');
INSERT INTO `sys_data_region` VALUES (6656, '哈尔套', 4, '210922', '210922101', 'h');
INSERT INTO `sys_data_region` VALUES (6657, '章古台', 4, '210922', '210922102', 'z');
INSERT INTO `sys_data_region` VALUES (6658, '五峰', 4, '210922', '210922103', 'w');
INSERT INTO `sys_data_region` VALUES (6659, '冯家', 4, '210922', '210922104', 'f');
INSERT INTO `sys_data_region` VALUES (6660, '后新秋', 4, '210922', '210922105', 'h');
INSERT INTO `sys_data_region` VALUES (6661, '东六家子', 4, '210922', '210922106', 'd');
INSERT INTO `sys_data_region` VALUES (6662, '阿尔乡', 4, '210922', '210922107', 'a');
INSERT INTO `sys_data_region` VALUES (6663, '前福兴地', 4, '210922', '210922108', 'q');
INSERT INTO `sys_data_region` VALUES (6664, '双庙', 4, '210922', '210922109', 's');
INSERT INTO `sys_data_region` VALUES (6665, '大四家子', 4, '210922', '210922110', 'd');
INSERT INTO `sys_data_region` VALUES (6666, '苇子沟', 4, '210922', '210922111', 'w');
INSERT INTO `sys_data_region` VALUES (6667, '兴隆山', 4, '210922', '210922112', 'x');
INSERT INTO `sys_data_region` VALUES (6668, '满堂红', 4, '210922', '210922113', 'm');
INSERT INTO `sys_data_region` VALUES (6669, '四合城', 4, '210922', '210922114', 's');
INSERT INTO `sys_data_region` VALUES (6670, '大冷', 4, '210922', '210922115', 'd');
INSERT INTO `sys_data_region` VALUES (6671, '平安', 4, '210922', '210922116', 'p');
INSERT INTO `sys_data_region` VALUES (6672, '两家子', 4, '210922', '210922117', 'l');
INSERT INTO `sys_data_region` VALUES (6673, '兴隆堡', 4, '210922', '210922118', 'x');
INSERT INTO `sys_data_region` VALUES (6674, '四堡子', 4, '210922', '210922119', 's');
INSERT INTO `sys_data_region` VALUES (6675, '西六家子', 4, '210922', '210922120', 'x');
INSERT INTO `sys_data_region` VALUES (6676, '大德', 4, '210922', '210922121', 'd');
INSERT INTO `sys_data_region` VALUES (6677, '二道河子', 4, '210922', '210922202', 'e');
INSERT INTO `sys_data_region` VALUES (6678, '丰田', 4, '210922', '210922209', 'f');
INSERT INTO `sys_data_region` VALUES (6679, '辽阳', 2, '21', '2110', 'l');
INSERT INTO `sys_data_region` VALUES (6680, '白塔', 3, '2110', '211002', 'b');
INSERT INTO `sys_data_region` VALUES (6681, '文圣', 4, '211002', '211002016', 'w');
INSERT INTO `sys_data_region` VALUES (6682, '武圣', 4, '211002', '211002017', 'w');
INSERT INTO `sys_data_region` VALUES (6683, '南门', 4, '211002', '211002018', 'n');
INSERT INTO `sys_data_region` VALUES (6684, '襄平', 4, '211002', '211002019', 'x');
INSERT INTO `sys_data_region` VALUES (6685, '文圣', 3, '2110', '211003', 'w');
INSERT INTO `sys_data_region` VALUES (6686, '庆阳', 4, '211003', '211003004', 'q');
INSERT INTO `sys_data_region` VALUES (6687, '东京陵', 4, '211003', '211003008', 'd');
INSERT INTO `sys_data_region` VALUES (6688, '新城', 4, '211003', '211003009', 'x');
INSERT INTO `sys_data_region` VALUES (6689, '罗大台', 4, '211003', '211003100', 'l');
INSERT INTO `sys_data_region` VALUES (6690, '小屯', 4, '211003', '211003101', 'x');
INSERT INTO `sys_data_region` VALUES (6691, '宏伟', 3, '2110', '211004', 'h');
INSERT INTO `sys_data_region` VALUES (6692, '工农', 4, '211004', '211004001', 'g');
INSERT INTO `sys_data_region` VALUES (6693, '光华', 4, '211004', '211004002', 'g');
INSERT INTO `sys_data_region` VALUES (6694, '新村', 4, '211004', '211004003', 'x');
INSERT INTO `sys_data_region` VALUES (6695, '长征', 4, '211004', '211004004', 'c');
INSERT INTO `sys_data_region` VALUES (6696, '曙光', 4, '211004', '211004101', 's');
INSERT INTO `sys_data_region` VALUES (6697, '兰家', 4, '211004', '211004102', 'l');
INSERT INTO `sys_data_region` VALUES (6698, '弓长岭', 3, '2110', '211005', 'g');
INSERT INTO `sys_data_region` VALUES (6699, '苏家', 4, '211005', '211005001', 's');
INSERT INTO `sys_data_region` VALUES (6700, '团山', 4, '211005', '211005002', 't');
INSERT INTO `sys_data_region` VALUES (6701, '安平街道', 4, '211005', '211005003', 'a');
INSERT INTO `sys_data_region` VALUES (6702, '汤河', 4, '211005', '211005101', 't');
INSERT INTO `sys_data_region` VALUES (6703, '安平乡', 4, '211005', '211005201', 'a');
INSERT INTO `sys_data_region` VALUES (6704, '太子河', 3, '2110', '211011', 't');
INSERT INTO `sys_data_region` VALUES (6705, '铁西', 4, '211011', '211011004', 't');
INSERT INTO `sys_data_region` VALUES (6706, '祁家', 4, '211011', '211011101', 'q');
INSERT INTO `sys_data_region` VALUES (6707, '王家', 4, '211011', '211011102', 'w');
INSERT INTO `sys_data_region` VALUES (6708, '沙岭', 4, '211011', '211011103', 's');
INSERT INTO `sys_data_region` VALUES (6709, '东宁卫', 4, '211011', '211011204', 'd');
INSERT INTO `sys_data_region` VALUES (6710, '辽阳县', 3, '2110', '211021', 'l');
INSERT INTO `sys_data_region` VALUES (6711, '首山', 4, '211021', '211021100', 's');
INSERT INTO `sys_data_region` VALUES (6712, '刘二堡', 4, '211021', '211021101', 'l');
INSERT INTO `sys_data_region` VALUES (6713, '小北河', 4, '211021', '211021103', 'x');
INSERT INTO `sys_data_region` VALUES (6714, '黄泥洼', 4, '211021', '211021104', 'h');
INSERT INTO `sys_data_region` VALUES (6715, '唐马寨', 4, '211021', '211021106', 't');
INSERT INTO `sys_data_region` VALUES (6716, '穆家', 4, '211021', '211021107', 'm');
INSERT INTO `sys_data_region` VALUES (6717, '柳壕', 4, '211021', '211021108', 'l');
INSERT INTO `sys_data_region` VALUES (6718, '河栏', 4, '211021', '211021110', 'h');
INSERT INTO `sys_data_region` VALUES (6719, '隆昌', 4, '211021', '211021111', 'l');
INSERT INTO `sys_data_region` VALUES (6720, '八会', 4, '211021', '211021112', 'b');
INSERT INTO `sys_data_region` VALUES (6721, '寒岭', 4, '211021', '211021113', 'h');
INSERT INTO `sys_data_region` VALUES (6722, '兴隆', 4, '211021', '211021115', 'x');
INSERT INTO `sys_data_region` VALUES (6723, '下达河', 4, '211021', '211021201', 'x');
INSERT INTO `sys_data_region` VALUES (6724, '吉洞峪', 4, '211021', '211021202', 'j');
INSERT INTO `sys_data_region` VALUES (6725, '甜水', 4, '211021', '211021206', 't');
INSERT INTO `sys_data_region` VALUES (6726, '灯塔', 3, '2110', '211081', 'd');
INSERT INTO `sys_data_region` VALUES (6727, '烟台', 4, '211081', '211081001', 'y');
INSERT INTO `sys_data_region` VALUES (6728, '万宝桥', 4, '211081', '211081002', 'w');
INSERT INTO `sys_data_region` VALUES (6729, '古城', 4, '211081', '211081003', 'g');
INSERT INTO `sys_data_region` VALUES (6730, '佟二堡', 4, '211081', '211081101', 't');
INSERT INTO `sys_data_region` VALUES (6731, '铧子', 4, '211081', '211081102', 'h');
INSERT INTO `sys_data_region` VALUES (6732, '张台子', 4, '211081', '211081103', 'z');
INSERT INTO `sys_data_region` VALUES (6733, '西大窑', 4, '211081', '211081104', 'x');
INSERT INTO `sys_data_region` VALUES (6734, '沈旦堡', 4, '211081', '211081105', 's');
INSERT INTO `sys_data_region` VALUES (6735, '西马峰', 4, '211081', '211081106', 'x');
INSERT INTO `sys_data_region` VALUES (6736, '柳条寨', 4, '211081', '211081107', 'l');
INSERT INTO `sys_data_region` VALUES (6737, '柳河子', 4, '211081', '211081108', 'l');
INSERT INTO `sys_data_region` VALUES (6738, '大河南', 4, '211081', '211081111', 'd');
INSERT INTO `sys_data_region` VALUES (6739, '五星', 4, '211081', '211081114', 'w');
INSERT INTO `sys_data_region` VALUES (6740, '鸡冠山', 4, '211081', '211081205', 'j');
INSERT INTO `sys_data_region` VALUES (6741, '盘锦', 2, '21', '2111', 'p');
INSERT INTO `sys_data_region` VALUES (6742, '双台子', 3, '2111', '211102', 's');
INSERT INTO `sys_data_region` VALUES (6743, '胜利', 4, '211102', '211102002', 's');
INSERT INTO `sys_data_region` VALUES (6744, '建设', 4, '211102', '211102003', 'j');
INSERT INTO `sys_data_region` VALUES (6745, '红旗', 4, '211102', '211102004', 'h');
INSERT INTO `sys_data_region` VALUES (6746, '辽河', 4, '211102', '211102005', 'l');
INSERT INTO `sys_data_region` VALUES (6747, '铁东', 4, '211102', '211102008', 't');
INSERT INTO `sys_data_region` VALUES (6748, '双盛', 4, '211102', '211102009', 's');
INSERT INTO `sys_data_region` VALUES (6749, '陆家', 4, '211102', '211102100', 'l');
INSERT INTO `sys_data_region` VALUES (6750, '兴隆台', 3, '2111', '211103', 'x');
INSERT INTO `sys_data_region` VALUES (6751, '振兴', 4, '211103', '211103001', 'z');
INSERT INTO `sys_data_region` VALUES (6752, '兴隆', 4, '211103', '211103002', 'x');
INSERT INTO `sys_data_region` VALUES (6753, '渤海', 4, '211103', '211103003', 'b');
INSERT INTO `sys_data_region` VALUES (6754, '新工', 4, '211103', '211103004', 'x');
INSERT INTO `sys_data_region` VALUES (6755, '曙光', 4, '211103', '211103007', 's');
INSERT INTO `sys_data_region` VALUES (6756, '欢喜岭', 4, '211103', '211103008', 'h');
INSERT INTO `sys_data_region` VALUES (6757, '创新', 4, '211103', '211103016', 'c');
INSERT INTO `sys_data_region` VALUES (6758, '兴盛', 4, '211103', '211103017', 'x');
INSERT INTO `sys_data_region` VALUES (6759, '兴海', 4, '211103', '211103018', 'x');
INSERT INTO `sys_data_region` VALUES (6760, '东郭', 4, '211103', '211103019', 'd');
INSERT INTO `sys_data_region` VALUES (6761, '惠宾', 4, '211103', '211103020', 'h');
INSERT INTO `sys_data_region` VALUES (6762, '大洼', 3, '2111', '211104', 'd');
INSERT INTO `sys_data_region` VALUES (6763, '大洼街道', 4, '211104', '211104001', 'd');
INSERT INTO `sys_data_region` VALUES (6764, '榆树', 4, '211104', '211104002', 'y');
INSERT INTO `sys_data_region` VALUES (6765, '田家', 4, '211104', '211104003', 't');
INSERT INTO `sys_data_region` VALUES (6766, '王家', 4, '211104', '211104004', 'w');
INSERT INTO `sys_data_region` VALUES (6767, '于楼', 4, '211104', '211104006', 'y');
INSERT INTO `sys_data_region` VALUES (6768, '二界沟', 4, '211104', '211104009', 'e');
INSERT INTO `sys_data_region` VALUES (6769, '东风', 4, '211104', '211104103', 'd');
INSERT INTO `sys_data_region` VALUES (6770, '新开', 4, '211104', '211104104', 'x');
INSERT INTO `sys_data_region` VALUES (6771, '清水', 4, '211104', '211104106', 'q');
INSERT INTO `sys_data_region` VALUES (6772, '新兴', 4, '211104', '211104107', 'x');
INSERT INTO `sys_data_region` VALUES (6773, '西安', 4, '211104', '211104108', 'x');
INSERT INTO `sys_data_region` VALUES (6774, '新立', 4, '211104', '211104109', 'x');
INSERT INTO `sys_data_region` VALUES (6775, '唐家', 4, '211104', '211104112', 't');
INSERT INTO `sys_data_region` VALUES (6776, '平安', 4, '211104', '211104113', 'p');
INSERT INTO `sys_data_region` VALUES (6777, '赵圈河', 4, '211104', '211104114', 'z');
INSERT INTO `sys_data_region` VALUES (6778, '田庄台', 4, '211104', '211104115', 't');
INSERT INTO `sys_data_region` VALUES (6779, '盘山', 3, '2111', '211122', 'p');
INSERT INTO `sys_data_region` VALUES (6780, '太平', 4, '211122', '211122001', 't');
INSERT INTO `sys_data_region` VALUES (6781, '高升', 4, '211122', '211122002', 'g');
INSERT INTO `sys_data_region` VALUES (6782, '得胜', 4, '211122', '211122003', 'd');
INSERT INTO `sys_data_region` VALUES (6783, '沙岭', 4, '211122', '211122101', 's');
INSERT INTO `sys_data_region` VALUES (6784, '胡家', 4, '211122', '211122103', 'h');
INSERT INTO `sys_data_region` VALUES (6785, '古城子', 4, '211122', '211122107', 'g');
INSERT INTO `sys_data_region` VALUES (6786, '坝墙子', 4, '211122', '211122108', 'b');
INSERT INTO `sys_data_region` VALUES (6787, '陈家', 4, '211122', '211122110', 'c');
INSERT INTO `sys_data_region` VALUES (6788, '甜水', 4, '211122', '211122111', 't');
INSERT INTO `sys_data_region` VALUES (6789, '吴家', 4, '211122', '211122112', 'w');
INSERT INTO `sys_data_region` VALUES (6790, '石新', 4, '211122', '211122114', 's');
INSERT INTO `sys_data_region` VALUES (6791, '羊圈子', 4, '211122', '211122115', 'y');
INSERT INTO `sys_data_region` VALUES (6792, '铁岭', 2, '21', '2112', 't');
INSERT INTO `sys_data_region` VALUES (6793, '银州', 3, '2112', '211202', 'y');
INSERT INTO `sys_data_region` VALUES (6794, '红旗', 4, '211202', '211202001', 'h');
INSERT INTO `sys_data_region` VALUES (6795, '工人', 4, '211202', '211202002', 'g');
INSERT INTO `sys_data_region` VALUES (6796, '铁西', 4, '211202', '211202003', 't');
INSERT INTO `sys_data_region` VALUES (6797, '铜钟', 4, '211202', '211202004', 't');
INSERT INTO `sys_data_region` VALUES (6798, '柴河', 4, '211202', '211202005', 'c');
INSERT INTO `sys_data_region` VALUES (6799, '岭东', 4, '211202', '211202006', 'l');
INSERT INTO `sys_data_region` VALUES (6800, '辽海', 4, '211202', '211202007', 'l');
INSERT INTO `sys_data_region` VALUES (6801, '龙山', 4, '211202', '211202201', 'l');
INSERT INTO `sys_data_region` VALUES (6802, '铁岭经济开发区', 4, '211202', '211202401', 't');
INSERT INTO `sys_data_region` VALUES (6803, '清河', 3, '2112', '211204', 'q');
INSERT INTO `sys_data_region` VALUES (6804, '红旗', 4, '211204', '211204001', 'h');
INSERT INTO `sys_data_region` VALUES (6805, '向阳', 4, '211204', '211204002', 'x');
INSERT INTO `sys_data_region` VALUES (6806, '张相', 4, '211204', '211204101', 'z');
INSERT INTO `sys_data_region` VALUES (6807, '杨木林子', 4, '211204', '211204102', 'y');
INSERT INTO `sys_data_region` VALUES (6808, '聂家', 4, '211204', '211204203', 'n');
INSERT INTO `sys_data_region` VALUES (6809, '铁岭县', 3, '2112', '211221', 't');
INSERT INTO `sys_data_region` VALUES (6810, '新台子', 4, '211221', '211221101', 'x');
INSERT INTO `sys_data_region` VALUES (6811, '阿吉', 4, '211221', '211221102', 'a');
INSERT INTO `sys_data_region` VALUES (6812, '平顶堡', 4, '211221', '211221103', 'p');
INSERT INTO `sys_data_region` VALUES (6813, '大甸子', 4, '211221', '211221104', 'd');
INSERT INTO `sys_data_region` VALUES (6814, '凡河', 4, '211221', '211221105', 'f');
INSERT INTO `sys_data_region` VALUES (6815, '腰堡', 4, '211221', '211221106', 'y');
INSERT INTO `sys_data_region` VALUES (6816, '镇西堡', 4, '211221', '211221107', 'z');
INSERT INTO `sys_data_region` VALUES (6817, '蔡牛', 4, '211221', '211221108', 'c');
INSERT INTO `sys_data_region` VALUES (6818, '李千户', 4, '211221', '211221109', 'l');
INSERT INTO `sys_data_region` VALUES (6819, '熊官屯', 4, '211221', '211221111', 'x');
INSERT INTO `sys_data_region` VALUES (6820, '横道河子', 4, '211221', '211221112', 'h');
INSERT INTO `sys_data_region` VALUES (6821, '双井子', 4, '211221', '211221113', 's');
INSERT INTO `sys_data_region` VALUES (6822, '鸡冠山', 4, '211221', '211221208', 'j');
INSERT INTO `sys_data_region` VALUES (6823, '白旗寨', 4, '211221', '211221209', 'b');
INSERT INTO `sys_data_region` VALUES (6824, '西丰', 3, '2112', '211223', 'x');
INSERT INTO `sys_data_region` VALUES (6825, '西丰镇', 4, '211223', '211223100', 'x');
INSERT INTO `sys_data_region` VALUES (6826, '平岗', 4, '211223', '211223101', 'p');
INSERT INTO `sys_data_region` VALUES (6827, '郜家店', 4, '211223', '211223102', 'g');
INSERT INTO `sys_data_region` VALUES (6828, '凉泉', 4, '211223', '211223103', 'l');
INSERT INTO `sys_data_region` VALUES (6829, '振兴', 4, '211223', '211223104', 'z');
INSERT INTO `sys_data_region` VALUES (6830, '安民', 4, '211223', '211223105', 'a');
INSERT INTO `sys_data_region` VALUES (6831, '天德', 4, '211223', '211223106', 't');
INSERT INTO `sys_data_region` VALUES (6832, '房木', 4, '211223', '211223107', 'f');
INSERT INTO `sys_data_region` VALUES (6833, '柏榆', 4, '211223', '211223109', 'b');
INSERT INTO `sys_data_region` VALUES (6834, '更刻', 4, '211223', '211223110', 'g');
INSERT INTO `sys_data_region` VALUES (6835, '钓鱼', 4, '211223', '211223111', 'd');
INSERT INTO `sys_data_region` VALUES (6836, '陶然', 4, '211223', '211223112', 't');
INSERT INTO `sys_data_region` VALUES (6837, '德兴', 4, '211223', '211223204', 'd');
INSERT INTO `sys_data_region` VALUES (6838, '明德', 4, '211223', '211223206', 'm');
INSERT INTO `sys_data_region` VALUES (6839, '成平', 4, '211223', '211223209', 'c');
INSERT INTO `sys_data_region` VALUES (6840, '和隆', 4, '211223', '211223211', 'h');
INSERT INTO `sys_data_region` VALUES (6841, '营厂', 4, '211223', '211223212', 'y');
INSERT INTO `sys_data_region` VALUES (6842, '金星', 4, '211223', '211223213', 'j');
INSERT INTO `sys_data_region` VALUES (6843, '昌图', 3, '2112', '211224', 'c');
INSERT INTO `sys_data_region` VALUES (6844, '昌图镇', 4, '211224', '211224100', 'c');
INSERT INTO `sys_data_region` VALUES (6845, '老城', 4, '211224', '211224101', 'l');
INSERT INTO `sys_data_region` VALUES (6846, '八面城', 4, '211224', '211224102', 'b');
INSERT INTO `sys_data_region` VALUES (6847, '三江口', 4, '211224', '211224103', 's');
INSERT INTO `sys_data_region` VALUES (6848, '金家', 4, '211224', '211224104', 'j');
INSERT INTO `sys_data_region` VALUES (6849, '宝力', 4, '211224', '211224105', 'b');
INSERT INTO `sys_data_region` VALUES (6850, '泉头', 4, '211224', '211224106', 'q');
INSERT INTO `sys_data_region` VALUES (6851, '双庙子', 4, '211224', '211224107', 's');
INSERT INTO `sys_data_region` VALUES (6852, '亮中桥', 4, '211224', '211224108', 'l');
INSERT INTO `sys_data_region` VALUES (6853, '马仲河', 4, '211224', '211224109', 'm');
INSERT INTO `sys_data_region` VALUES (6854, '毛家店', 4, '211224', '211224110', 'm');
INSERT INTO `sys_data_region` VALUES (6855, '老四平', 4, '211224', '211224111', 'l');
INSERT INTO `sys_data_region` VALUES (6856, '大洼', 4, '211224', '211224112', 'd');
INSERT INTO `sys_data_region` VALUES (6857, '头道', 4, '211224', '211224113', 't');
INSERT INTO `sys_data_region` VALUES (6858, '鴜鹭树', 4, '211224', '211224114', 'c');
INSERT INTO `sys_data_region` VALUES (6859, '傅家', 4, '211224', '211224115', 'f');
INSERT INTO `sys_data_region` VALUES (6860, '四合', 4, '211224', '211224117', 's');
INSERT INTO `sys_data_region` VALUES (6861, '朝阳', 4, '211224', '211224118', 'z');
INSERT INTO `sys_data_region` VALUES (6862, '古榆树', 4, '211224', '211224119', 'g');
INSERT INTO `sys_data_region` VALUES (6863, '七家子', 4, '211224', '211224120', 'q');
INSERT INTO `sys_data_region` VALUES (6864, '东嘎', 4, '211224', '211224121', 'd');
INSERT INTO `sys_data_region` VALUES (6865, '四面城', 4, '211224', '211224122', 's');
INSERT INTO `sys_data_region` VALUES (6866, '前双井', 4, '211224', '211224123', 'q');
INSERT INTO `sys_data_region` VALUES (6867, '通江口', 4, '211224', '211224124', 't');
INSERT INTO `sys_data_region` VALUES (6868, '大四家子', 4, '211224', '211224125', 'd');
INSERT INTO `sys_data_region` VALUES (6869, '曲家店', 4, '211224', '211224126', 'q');
INSERT INTO `sys_data_region` VALUES (6870, '平安堡', 4, '211224', '211224130', 'p');
INSERT INTO `sys_data_region` VALUES (6871, '下二台', 4, '211224', '211224131', 'x');
INSERT INTO `sys_data_region` VALUES (6872, '太平', 4, '211224', '211224132', 't');
INSERT INTO `sys_data_region` VALUES (6873, '十八家子', 4, '211224', '211224133', 's');
INSERT INTO `sys_data_region` VALUES (6874, '后窑', 4, '211224', '211224134', 'h');
INSERT INTO `sys_data_region` VALUES (6875, '大兴', 4, '211224', '211224135', 'd');
INSERT INTO `sys_data_region` VALUES (6876, '长发', 4, '211224', '211224136', 'c');
INSERT INTO `sys_data_region` VALUES (6877, '调兵山', 3, '2112', '211281', 'd');
INSERT INTO `sys_data_region` VALUES (6878, '兀术', 4, '211281', '211281001', 'w');
INSERT INTO `sys_data_region` VALUES (6879, '调兵山街道', 4, '211281', '211281002', 't');
INSERT INTO `sys_data_region` VALUES (6880, '晓明', 4, '211281', '211281102', 'x');
INSERT INTO `sys_data_region` VALUES (6881, '大明', 4, '211281', '211281103', 'd');
INSERT INTO `sys_data_region` VALUES (6882, '晓南', 4, '211281', '211281105', 'x');
INSERT INTO `sys_data_region` VALUES (6883, '开原', 3, '2112', '211282', 'k');
INSERT INTO `sys_data_region` VALUES (6884, '新城', 4, '211282', '211282001', 'x');
INSERT INTO `sys_data_region` VALUES (6885, '老城', 4, '211282', '211282002', 'l');
INSERT INTO `sys_data_region` VALUES (6886, '开原街道', 4, '211282', '211282003', 'k');
INSERT INTO `sys_data_region` VALUES (6887, '威远堡', 4, '211282', '211282102', 'w');
INSERT INTO `sys_data_region` VALUES (6888, '庆云堡', 4, '211282', '211282103', 'q');
INSERT INTO `sys_data_region` VALUES (6889, '中固', 4, '211282', '211282104', 'z');
INSERT INTO `sys_data_region` VALUES (6890, '八棵树', 4, '211282', '211282105', 'b');
INSERT INTO `sys_data_region` VALUES (6891, '金沟子', 4, '211282', '211282106', 'j');
INSERT INTO `sys_data_region` VALUES (6892, '八宝', 4, '211282', '211282107', 'b');
INSERT INTO `sys_data_region` VALUES (6893, '业民', 4, '211282', '211282108', 'y');
INSERT INTO `sys_data_region` VALUES (6894, '莲花', 4, '211282', '211282109', 'l');
INSERT INTO `sys_data_region` VALUES (6895, '靠山', 4, '211282', '211282110', 'k');
INSERT INTO `sys_data_region` VALUES (6896, '下肥', 4, '211282', '211282111', 'x');
INSERT INTO `sys_data_region` VALUES (6897, '松山', 4, '211282', '211282112', 's');
INSERT INTO `sys_data_region` VALUES (6898, '李家台', 4, '211282', '211282113', 'l');
INSERT INTO `sys_data_region` VALUES (6899, '马家寨', 4, '211282', '211282114', 'm');
INSERT INTO `sys_data_region` VALUES (6900, '城东', 4, '211282', '211282115', 'c');
INSERT INTO `sys_data_region` VALUES (6901, '上肥', 4, '211282', '211282116', 's');
INSERT INTO `sys_data_region` VALUES (6902, '黄旗寨', 4, '211282', '211282117', 'h');
INSERT INTO `sys_data_region` VALUES (6903, '林丰', 4, '211282', '211282217', 'l');
INSERT INTO `sys_data_region` VALUES (6904, '朝阳', 2, '21', '2113', 'c');
INSERT INTO `sys_data_region` VALUES (6905, '双塔', 3, '2113', '211302', 's');
INSERT INTO `sys_data_region` VALUES (6906, '前进', 4, '211302', '211302003', 'q');
INSERT INTO `sys_data_region` VALUES (6907, '凌河', 4, '211302', '211302004', 'l');
INSERT INTO `sys_data_region` VALUES (6908, '光明', 4, '211302', '211302005', 'g');
INSERT INTO `sys_data_region` VALUES (6909, '凌凤', 4, '211302', '211302006', 'l');
INSERT INTO `sys_data_region` VALUES (6910, '龙山', 4, '211302', '211302007', 'l');
INSERT INTO `sys_data_region` VALUES (6911, '站南', 4, '211302', '211302008', 'z');
INSERT INTO `sys_data_region` VALUES (6912, '红旗', 4, '211302', '211302009', 'h');
INSERT INTO `sys_data_region` VALUES (6913, '燕北', 4, '211302', '211302010', 'y');
INSERT INTO `sys_data_region` VALUES (6914, '双塔街道', 4, '211302', '211302012', 's');
INSERT INTO `sys_data_region` VALUES (6915, '桃花吐', 4, '211302', '211302111', 't');
INSERT INTO `sys_data_region` VALUES (6916, '他拉皋', 4, '211302', '211302113', 't');
INSERT INTO `sys_data_region` VALUES (6917, '孙家湾', 4, '211302', '211302114', 's');
INSERT INTO `sys_data_region` VALUES (6918, '长宝营子', 4, '211302', '211302212', 'c');
INSERT INTO `sys_data_region` VALUES (6919, '龙城', 3, '2113', '211303', 'l');
INSERT INTO `sys_data_region` VALUES (6920, '新华', 4, '211303', '211303004', 'x');
INSERT INTO `sys_data_region` VALUES (6921, '海龙', 4, '211303', '211303006', 'h');
INSERT INTO `sys_data_region` VALUES (6922, '龙泉', 4, '211303', '211303007', 'l');
INSERT INTO `sys_data_region` VALUES (6923, '七道泉子', 4, '211303', '211303101', 'q');
INSERT INTO `sys_data_region` VALUES (6924, '西大营子', 4, '211303', '211303102', 'x');
INSERT INTO `sys_data_region` VALUES (6925, '召都巴', 4, '211303', '211303103', 'z');
INSERT INTO `sys_data_region` VALUES (6926, '大平房', 4, '211303', '211303104', 'd');
INSERT INTO `sys_data_region` VALUES (6927, '联合', 4, '211303', '211303105', 'l');
INSERT INTO `sys_data_region` VALUES (6928, '边杖子', 4, '211303', '211303106', 'b');
INSERT INTO `sys_data_region` VALUES (6929, '朝阳县', 3, '2113', '211321', 'c');
INSERT INTO `sys_data_region` VALUES (6930, '柳城', 4, '211321', '211321001', 'l');
INSERT INTO `sys_data_region` VALUES (6931, '波罗赤', 4, '211321', '211321102', 'b');
INSERT INTO `sys_data_region` VALUES (6932, '木头城子', 4, '211321', '211321103', 'm');
INSERT INTO `sys_data_region` VALUES (6933, '二十家子', 4, '211321', '211321104', 'e');
INSERT INTO `sys_data_region` VALUES (6934, '羊山', 4, '211321', '211321105', 'y');
INSERT INTO `sys_data_region` VALUES (6935, '六家子', 4, '211321', '211321106', 'l');
INSERT INTO `sys_data_region` VALUES (6936, '瓦房子', 4, '211321', '211321107', 'w');
INSERT INTO `sys_data_region` VALUES (6937, '大庙', 4, '211321', '211321108', 'd');
INSERT INTO `sys_data_region` VALUES (6938, '古山子', 4, '211321', '211321110', 'g');
INSERT INTO `sys_data_region` VALUES (6939, '南双庙', 4, '211321', '211321111', 'n');
INSERT INTO `sys_data_region` VALUES (6940, '台子', 4, '211321', '211321112', 't');
INSERT INTO `sys_data_region` VALUES (6941, '清风岭', 4, '211321', '211321113', 'q');
INSERT INTO `sys_data_region` VALUES (6942, '胜利', 4, '211321', '211321114', 's');
INSERT INTO `sys_data_region` VALUES (6943, '七道岭', 4, '211321', '211321115', 'q');
INSERT INTO `sys_data_region` VALUES (6944, '杨树湾', 4, '211321', '211321116', 'y');
INSERT INTO `sys_data_region` VALUES (6945, '西五家子', 4, '211321', '211321211', 'x');
INSERT INTO `sys_data_region` VALUES (6946, '北沟门子', 4, '211321', '211321212', 'b');
INSERT INTO `sys_data_region` VALUES (6947, '东大道', 4, '211321', '211321214', 'd');
INSERT INTO `sys_data_region` VALUES (6948, '乌兰河硕', 4, '211321', '211321215', 'w');
INSERT INTO `sys_data_region` VALUES (6949, '东大屯', 4, '211321', '211321220', 'd');
INSERT INTO `sys_data_region` VALUES (6950, '松岭门', 4, '211321', '211321221', 's');
INSERT INTO `sys_data_region` VALUES (6951, '根德营子', 4, '211321', '211321222', 'g');
INSERT INTO `sys_data_region` VALUES (6952, '西营子', 4, '211321', '211321224', 'x');
INSERT INTO `sys_data_region` VALUES (6953, '北四家子', 4, '211321', '211321228', 'b');
INSERT INTO `sys_data_region` VALUES (6954, '王营子', 4, '211321', '211321230', 'w');
INSERT INTO `sys_data_region` VALUES (6955, '黑牛营子', 4, '211321', '211321231', 'h');
INSERT INTO `sys_data_region` VALUES (6956, '尚志', 4, '211321', '211321232', 's');
INSERT INTO `sys_data_region` VALUES (6957, '建平', 3, '2113', '211322', 'j');
INSERT INTO `sys_data_region` VALUES (6958, '叶柏寿', 4, '211322', '211322001', 'y');
INSERT INTO `sys_data_region` VALUES (6959, '红山', 4, '211322', '211322002', 'h');
INSERT INTO `sys_data_region` VALUES (6960, '铁南', 4, '211322', '211322003', 't');
INSERT INTO `sys_data_region` VALUES (6961, '万寿', 4, '211322', '211322004', 'w');
INSERT INTO `sys_data_region` VALUES (6962, '朱碌科', 4, '211322', '211322101', 'z');
INSERT INTO `sys_data_region` VALUES (6963, '建平镇', 4, '211322', '211322102', 'j');
INSERT INTO `sys_data_region` VALUES (6964, '黑水', 4, '211322', '211322103', 'h');
INSERT INTO `sys_data_region` VALUES (6965, '喀喇沁', 4, '211322', '211322104', 'k');
INSERT INTO `sys_data_region` VALUES (6966, '北二十家子', 4, '211322', '211322105', 'b');
INSERT INTO `sys_data_region` VALUES (6967, '沙海', 4, '211322', '211322106', 's');
INSERT INTO `sys_data_region` VALUES (6968, '哈拉道口', 4, '211322', '211322108', 'h');
INSERT INTO `sys_data_region` VALUES (6969, '榆树林子', 4, '211322', '211322109', 'y');
INSERT INTO `sys_data_region` VALUES (6970, '老官地', 4, '211322', '211322110', 'l');
INSERT INTO `sys_data_region` VALUES (6971, '深井', 4, '211322', '211322111', 's');
INSERT INTO `sys_data_region` VALUES (6972, '奎德素', 4, '211322', '211322112', 'k');
INSERT INTO `sys_data_region` VALUES (6973, '小塘', 4, '211322', '211322113', 'x');
INSERT INTO `sys_data_region` VALUES (6974, '马场', 4, '211322', '211322114', 'm');
INSERT INTO `sys_data_region` VALUES (6975, '昌隆', 4, '211322', '211322115', 'c');
INSERT INTO `sys_data_region` VALUES (6976, '张家营子', 4, '211322', '211322117', 'z');
INSERT INTO `sys_data_region` VALUES (6977, '青峰山', 4, '211322', '211322118', 'q');
INSERT INTO `sys_data_region` VALUES (6978, '太平庄', 4, '211322', '211322119', 't');
INSERT INTO `sys_data_region` VALUES (6979, '青松岭', 4, '211322', '211322205', 'q');
INSERT INTO `sys_data_region` VALUES (6980, '杨树岭', 4, '211322', '211322206', 'y');
INSERT INTO `sys_data_region` VALUES (6981, '罗福沟', 4, '211322', '211322209', 'l');
INSERT INTO `sys_data_region` VALUES (6982, '烧锅营子', 4, '211322', '211322211', 's');
INSERT INTO `sys_data_region` VALUES (6983, '白山', 4, '211322', '211322214', 'b');
INSERT INTO `sys_data_region` VALUES (6984, '三家', 4, '211322', '211322218', 's');
INSERT INTO `sys_data_region` VALUES (6985, '义成功', 4, '211322', '211322220', 'y');
INSERT INTO `sys_data_region` VALUES (6986, '八家国营农场', 4, '211322', '211322400', 'b');
INSERT INTO `sys_data_region` VALUES (6987, '热水国营畜牧农场', 4, '211322', '211322401', 'r');
INSERT INTO `sys_data_region` VALUES (6988, '喀喇沁左翼', 3, '2113', '211324', 'k');
INSERT INTO `sys_data_region` VALUES (6989, '大城子', 4, '211324', '211324001', 'd');
INSERT INTO `sys_data_region` VALUES (6990, '利州', 4, '211324', '211324003', 'l');
INSERT INTO `sys_data_region` VALUES (6991, '南公营子', 4, '211324', '211324101', 'n');
INSERT INTO `sys_data_region` VALUES (6992, '山嘴子', 4, '211324', '211324102', 's');
INSERT INTO `sys_data_region` VALUES (6993, '公营子', 4, '211324', '211324104', 'g');
INSERT INTO `sys_data_region` VALUES (6994, '白塔子', 4, '211324', '211324105', 'b');
INSERT INTO `sys_data_region` VALUES (6995, '中三家', 4, '211324', '211324106', 'z');
INSERT INTO `sys_data_region` VALUES (6996, '老爷庙', 4, '211324', '211324107', 'l');
INSERT INTO `sys_data_region` VALUES (6997, '六官营子', 4, '211324', '211324108', 'l');
INSERT INTO `sys_data_region` VALUES (6998, '平房子', 4, '211324', '211324109', 'p');
INSERT INTO `sys_data_region` VALUES (6999, '十二德堡', 4, '211324', '211324110', 's');
INSERT INTO `sys_data_region` VALUES (7000, '羊角沟', 4, '211324', '211324111', 'y');
INSERT INTO `sys_data_region` VALUES (7001, '甘招', 4, '211324', '211324112', 'g');
INSERT INTO `sys_data_region` VALUES (7002, '兴隆庄', 4, '211324', '211324113', 'x');
INSERT INTO `sys_data_region` VALUES (7003, '东哨', 4, '211324', '211324114', 'd');
INSERT INTO `sys_data_region` VALUES (7004, '水泉', 4, '211324', '211324115', 's');
INSERT INTO `sys_data_region` VALUES (7005, '尤杖子', 4, '211324', '211324204', 'y');
INSERT INTO `sys_data_region` VALUES (7006, '草场', 4, '211324', '211324207', 'c');
INSERT INTO `sys_data_region` VALUES (7007, '坤都营子', 4, '211324', '211324210', 'k');
INSERT INTO `sys_data_region` VALUES (7008, '大营子', 4, '211324', '211324211', 'd');
INSERT INTO `sys_data_region` VALUES (7009, '卧虎沟', 4, '211324', '211324214', 'w');
INSERT INTO `sys_data_region` VALUES (7010, '北票', 3, '2113', '211381', 'b');
INSERT INTO `sys_data_region` VALUES (7011, '城关', 4, '211381', '211381001', 'c');
INSERT INTO `sys_data_region` VALUES (7012, '南山', 4, '211381', '211381002', 'n');
INSERT INTO `sys_data_region` VALUES (7013, '冠山', 4, '211381', '211381003', 'g');
INSERT INTO `sys_data_region` VALUES (7014, '台吉街道', 4, '211381', '211381006', 't');
INSERT INTO `sys_data_region` VALUES (7015, '西官营', 4, '211381', '211381101', 'x');
INSERT INTO `sys_data_region` VALUES (7016, '大板', 4, '211381', '211381102', 'd');
INSERT INTO `sys_data_region` VALUES (7017, '上园', 4, '211381', '211381103', 's');
INSERT INTO `sys_data_region` VALUES (7018, '宝国老', 4, '211381', '211381104', 'b');
INSERT INTO `sys_data_region` VALUES (7019, '黑城子', 4, '211381', '211381105', 'h');
INSERT INTO `sys_data_region` VALUES (7020, '五间房', 4, '211381', '211381107', 'w');
INSERT INTO `sys_data_region` VALUES (7021, '台吉镇', 4, '211381', '211381108', 't');
INSERT INTO `sys_data_region` VALUES (7022, '东官营', 4, '211381', '211381109', 'd');
INSERT INTO `sys_data_region` VALUES (7023, '龙潭', 4, '211381', '211381110', 'l');
INSERT INTO `sys_data_region` VALUES (7024, '北塔', 4, '211381', '211381111', 'b');
INSERT INTO `sys_data_region` VALUES (7025, '蒙古营', 4, '211381', '211381112', 'm');
INSERT INTO `sys_data_region` VALUES (7026, '大三家', 4, '211381', '211381113', 'd');
INSERT INTO `sys_data_region` VALUES (7027, '长皋', 4, '211381', '211381201', 'c');
INSERT INTO `sys_data_region` VALUES (7028, '常河营', 4, '211381', '211381202', 'c');
INSERT INTO `sys_data_region` VALUES (7029, '小塔子', 4, '211381', '211381203', 'x');
INSERT INTO `sys_data_region` VALUES (7030, '马友营', 4, '211381', '211381204', 'm');
INSERT INTO `sys_data_region` VALUES (7031, '泉巨永', 4, '211381', '211381206', 'q');
INSERT INTO `sys_data_region` VALUES (7032, '哈尔脑', 4, '211381', '211381212', 'h');
INSERT INTO `sys_data_region` VALUES (7033, '南八家子', 4, '211381', '211381213', 'n');
INSERT INTO `sys_data_region` VALUES (7034, '章吉营', 4, '211381', '211381214', 'z');
INSERT INTO `sys_data_region` VALUES (7035, '三宝营', 4, '211381', '211381215', 's');
INSERT INTO `sys_data_region` VALUES (7036, '巴图营', 4, '211381', '211381216', 'b');
INSERT INTO `sys_data_region` VALUES (7037, '台吉营', 4, '211381', '211381218', 't');
INSERT INTO `sys_data_region` VALUES (7038, '娄家店', 4, '211381', '211381220', 'l');
INSERT INTO `sys_data_region` VALUES (7039, '北四家', 4, '211381', '211381221', 'b');
INSERT INTO `sys_data_region` VALUES (7040, '凉水河', 4, '211381', '211381223', 'l');
INSERT INTO `sys_data_region` VALUES (7041, '三宝', 4, '211381', '211381228', 's');
INSERT INTO `sys_data_region` VALUES (7042, '凌源', 3, '2113', '211382', 'l');
INSERT INTO `sys_data_region` VALUES (7043, '东城', 4, '211382', '211382001', 'd');
INSERT INTO `sys_data_region` VALUES (7044, '北街', 4, '211382', '211382002', 'b');
INSERT INTO `sys_data_region` VALUES (7045, '南街', 4, '211382', '211382003', 'n');
INSERT INTO `sys_data_region` VALUES (7046, '红山', 4, '211382', '211382004', 'h');
INSERT INTO `sys_data_region` VALUES (7047, '城关', 4, '211382', '211382007', 'c');
INSERT INTO `sys_data_region` VALUES (7048, '万元店', 4, '211382', '211382101', 'w');
INSERT INTO `sys_data_region` VALUES (7049, '宋杖子', 4, '211382', '211382102', 's');
INSERT INTO `sys_data_region` VALUES (7050, '三十家子', 4, '211382', '211382103', 's');
INSERT INTO `sys_data_region` VALUES (7051, '杨杖子', 4, '211382', '211382104', 'y');
INSERT INTO `sys_data_region` VALUES (7052, '刀尔登', 4, '211382', '211382105', 'd');
INSERT INTO `sys_data_region` VALUES (7053, '松岭子', 4, '211382', '211382106', 's');
INSERT INTO `sys_data_region` VALUES (7054, '四官营子', 4, '211382', '211382107', 's');
INSERT INTO `sys_data_region` VALUES (7055, '沟门子', 4, '211382', '211382108', 'g');
INSERT INTO `sys_data_region` VALUES (7056, '小城子', 4, '211382', '211382110', 'x');
INSERT INTO `sys_data_region` VALUES (7057, '四合当', 4, '211382', '211382111', 's');
INSERT INTO `sys_data_region` VALUES (7058, '乌兰白', 4, '211382', '211382113', 'w');
INSERT INTO `sys_data_region` VALUES (7059, '瓦房店', 4, '211382', '211382114', 'w');
INSERT INTO `sys_data_region` VALUES (7060, '大河北', 4, '211382', '211382115', 'd');
INSERT INTO `sys_data_region` VALUES (7061, '牛营子', 4, '211382', '211382116', 'n');
INSERT INTO `sys_data_region` VALUES (7062, '三道河子', 4, '211382', '211382117', 's');
INSERT INTO `sys_data_region` VALUES (7063, '刘杖子', 4, '211382', '211382118', 'l');
INSERT INTO `sys_data_region` VALUES (7064, '北炉', 4, '211382', '211382210', 'b');
INSERT INTO `sys_data_region` VALUES (7065, '三家子', 4, '211382', '211382217', 's');
INSERT INTO `sys_data_region` VALUES (7066, '佛爷洞', 4, '211382', '211382219', 'f');
INSERT INTO `sys_data_region` VALUES (7067, '大王杖子', 4, '211382', '211382220', 'd');
INSERT INTO `sys_data_region` VALUES (7068, '前进', 4, '211382', '211382222', 'q');
INSERT INTO `sys_data_region` VALUES (7069, '河坎子', 4, '211382', '211382223', 'h');
INSERT INTO `sys_data_region` VALUES (7070, '葫芦岛', 2, '21', '2114', 'h');
INSERT INTO `sys_data_region` VALUES (7071, '连山', 3, '2114', '211402', 'l');
INSERT INTO `sys_data_region` VALUES (7072, '连山街道', 4, '211402', '211402001', 'l');
INSERT INTO `sys_data_region` VALUES (7073, '站前', 4, '211402', '211402002', 'z');
INSERT INTO `sys_data_region` VALUES (7074, '渤海', 4, '211402', '211402003', 'b');
INSERT INTO `sys_data_region` VALUES (7075, '兴工', 4, '211402', '211402004', 'x');
INSERT INTO `sys_data_region` VALUES (7076, '石油', 4, '211402', '211402005', 's');
INSERT INTO `sys_data_region` VALUES (7077, '化工', 4, '211402', '211402006', 'h');
INSERT INTO `sys_data_region` VALUES (7078, '锦郊', 4, '211402', '211402010', 'j');
INSERT INTO `sys_data_region` VALUES (7079, '杨家杖子', 4, '211402', '211402011', 'y');
INSERT INTO `sys_data_region` VALUES (7080, '钢屯', 4, '211402', '211402104', 'g');
INSERT INTO `sys_data_region` VALUES (7081, '寺儿堡', 4, '211402', '211402105', 's');
INSERT INTO `sys_data_region` VALUES (7082, '新台门', 4, '211402', '211402106', 'x');
INSERT INTO `sys_data_region` VALUES (7083, '沙河营', 4, '211402', '211402201', 's');
INSERT INTO `sys_data_region` VALUES (7084, '孤竹营子', 4, '211402', '211402202', 'g');
INSERT INTO `sys_data_region` VALUES (7085, '白马石', 4, '211402', '211402203', 'b');
INSERT INTO `sys_data_region` VALUES (7086, '山神庙子', 4, '211402', '211402205', 's');
INSERT INTO `sys_data_region` VALUES (7087, '塔山', 4, '211402', '211402206', 't');
INSERT INTO `sys_data_region` VALUES (7088, '杨郊', 4, '211402', '211402210', 'y');
INSERT INTO `sys_data_region` VALUES (7089, '龙港', 3, '2114', '211403', 'l');
INSERT INTO `sys_data_region` VALUES (7090, '葫芦岛', 4, '211403', '211403001', 'h');
INSERT INTO `sys_data_region` VALUES (7091, '龙湾', 4, '211403', '211403005', 'l');
INSERT INTO `sys_data_region` VALUES (7092, '滨海', 4, '211403', '211403006', 'b');
INSERT INTO `sys_data_region` VALUES (7093, '双龙', 4, '211403', '211403007', 's');
INSERT INTO `sys_data_region` VALUES (7094, '玉皇', 4, '211403', '211403008', 'y');
INSERT INTO `sys_data_region` VALUES (7095, '连湾', 4, '211403', '211403009', 'l');
INSERT INTO `sys_data_region` VALUES (7096, '北港', 4, '211403', '211403010', 'b');
INSERT INTO `sys_data_region` VALUES (7097, '马仗房', 4, '211403', '211403011', 'm');
INSERT INTO `sys_data_region` VALUES (7098, '双树', 4, '211403', '211403211', 's');
INSERT INTO `sys_data_region` VALUES (7099, '南票', 3, '2114', '211404', 'n');
INSERT INTO `sys_data_region` VALUES (7100, '沙锅屯街道', 4, '211404', '211404002', 's');
INSERT INTO `sys_data_region` VALUES (7101, '邱皮沟', 4, '211404', '211404003', 'q');
INSERT INTO `sys_data_region` VALUES (7102, '苇子沟', 4, '211404', '211404005', 'w');
INSERT INTO `sys_data_region` VALUES (7103, '小凌河', 4, '211404', '211404007', 'x');
INSERT INTO `sys_data_region` VALUES (7104, '九龙', 4, '211404', '211404008', 'j');
INSERT INTO `sys_data_region` VALUES (7105, '龙腾', 4, '211404', '211404010', 'l');
INSERT INTO `sys_data_region` VALUES (7106, '缸窑岭', 4, '211404', '211404101', 'g');
INSERT INTO `sys_data_region` VALUES (7107, '暖池塘', 4, '211404', '211404102', 'n');
INSERT INTO `sys_data_region` VALUES (7108, '高桥', 4, '211404', '211404103', 'g');
INSERT INTO `sys_data_region` VALUES (7109, '台集屯', 4, '211404', '211404104', 't');
INSERT INTO `sys_data_region` VALUES (7110, '虹螺岘', 4, '211404', '211404105', 'h');
INSERT INTO `sys_data_region` VALUES (7111, '金星', 4, '211404', '211404106', 'j');
INSERT INTO `sys_data_region` VALUES (7112, '沙锅屯乡', 4, '211404', '211404201', 's');
INSERT INTO `sys_data_region` VALUES (7113, '黄土坎', 4, '211404', '211404203', 'h');
INSERT INTO `sys_data_region` VALUES (7114, '大兴', 4, '211404', '211404204', 'd');
INSERT INTO `sys_data_region` VALUES (7115, '张相公屯', 4, '211404', '211404205', 'z');
INSERT INTO `sys_data_region` VALUES (7116, '绥中', 3, '2114', '211421', 's');
INSERT INTO `sys_data_region` VALUES (7117, '绥中镇', 4, '211421', '211421100', 's');
INSERT INTO `sys_data_region` VALUES (7118, '西甸子', 4, '211421', '211421101', 'x');
INSERT INTO `sys_data_region` VALUES (7119, '宽邦', 4, '211421', '211421102', 'k');
INSERT INTO `sys_data_region` VALUES (7120, '大王庙', 4, '211421', '211421103', 'd');
INSERT INTO `sys_data_region` VALUES (7121, '万家', 4, '211421', '211421104', 'w');
INSERT INTO `sys_data_region` VALUES (7122, '前所', 4, '211421', '211421105', 'q');
INSERT INTO `sys_data_region` VALUES (7123, '高岭', 4, '211421', '211421106', 'g');
INSERT INTO `sys_data_region` VALUES (7124, '前卫', 4, '211421', '211421107', 'q');
INSERT INTO `sys_data_region` VALUES (7125, '荒地', 4, '211421', '211421108', 'h');
INSERT INTO `sys_data_region` VALUES (7126, '塔山屯', 4, '211421', '211421109', 't');
INSERT INTO `sys_data_region` VALUES (7127, '高台', 4, '211421', '211421113', 'g');
INSERT INTO `sys_data_region` VALUES (7128, '王宝', 4, '211421', '211421114', 'w');
INSERT INTO `sys_data_region` VALUES (7129, '沙河', 4, '211421', '211421115', 's');
INSERT INTO `sys_data_region` VALUES (7130, '小庄子', 4, '211421', '211421116', 'x');
INSERT INTO `sys_data_region` VALUES (7131, '西平坡', 4, '211421', '211421201', 'x');
INSERT INTO `sys_data_region` VALUES (7132, '葛家', 4, '211421', '211421202', 'g');
INSERT INTO `sys_data_region` VALUES (7133, '高甸子', 4, '211421', '211421204', 'g');
INSERT INTO `sys_data_region` VALUES (7134, '范家', 4, '211421', '211421206', 'f');
INSERT INTO `sys_data_region` VALUES (7135, '明水', 4, '211421', '211421207', 'm');
INSERT INTO `sys_data_region` VALUES (7136, '秋子沟', 4, '211421', '211421208', 'q');
INSERT INTO `sys_data_region` VALUES (7137, '加碑岩', 4, '211421', '211421210', 'j');
INSERT INTO `sys_data_region` VALUES (7138, '永安堡', 4, '211421', '211421211', 'y');
INSERT INTO `sys_data_region` VALUES (7139, '李家堡', 4, '211421', '211421212', 'l');
INSERT INTO `sys_data_region` VALUES (7140, '网户', 4, '211421', '211421214', 'w');
INSERT INTO `sys_data_region` VALUES (7141, '城郊', 4, '211421', '211421217', 'c');
INSERT INTO `sys_data_region` VALUES (7142, '建昌', 3, '2114', '211422', 'j');
INSERT INTO `sys_data_region` VALUES (7143, '建昌镇', 4, '211422', '211422100', 'j');
INSERT INTO `sys_data_region` VALUES (7144, '八家子', 4, '211422', '211422101', 'b');
INSERT INTO `sys_data_region` VALUES (7145, '喇嘛洞', 4, '211422', '211422102', 'l');
INSERT INTO `sys_data_region` VALUES (7146, '药王庙', 4, '211422', '211422103', 'y');
INSERT INTO `sys_data_region` VALUES (7147, '汤神庙', 4, '211422', '211422104', 't');
INSERT INTO `sys_data_region` VALUES (7148, '玲珑塔', 4, '211422', '211422105', 'l');
INSERT INTO `sys_data_region` VALUES (7149, '大屯', 4, '211422', '211422106', 'd');
INSERT INTO `sys_data_region` VALUES (7150, '牤牛营子', 4, '211422', '211422201', 'm');
INSERT INTO `sys_data_region` VALUES (7151, '素珠营子', 4, '211422', '211422203', 's');
INSERT INTO `sys_data_region` VALUES (7152, '石佛', 4, '211422', '211422204', 's');
INSERT INTO `sys_data_region` VALUES (7153, '王宝营子', 4, '211422', '211422206', 'w');
INSERT INTO `sys_data_region` VALUES (7154, '老大杖子', 4, '211422', '211422207', 'l');
INSERT INTO `sys_data_region` VALUES (7155, '要路沟', 4, '211422', '211422208', 'y');
INSERT INTO `sys_data_region` VALUES (7156, '魏家岭', 4, '211422', '211422209', 'w');
INSERT INTO `sys_data_region` VALUES (7157, '西碱厂', 4, '211422', '211422210', 'x');
INSERT INTO `sys_data_region` VALUES (7158, '头道营子', 4, '211422', '211422211', 't');
INSERT INTO `sys_data_region` VALUES (7159, '新开岭', 4, '211422', '211422212', 'x');
INSERT INTO `sys_data_region` VALUES (7160, '贺杖子', 4, '211422', '211422213', 'h');
INSERT INTO `sys_data_region` VALUES (7161, '养马甸子', 4, '211422', '211422214', 'y');
INSERT INTO `sys_data_region` VALUES (7162, '和尚房子', 4, '211422', '211422215', 'h');
INSERT INTO `sys_data_region` VALUES (7163, '杨树湾子', 4, '211422', '211422218', 'y');
INSERT INTO `sys_data_region` VALUES (7164, '黑山科', 4, '211422', '211422219', 'h');
INSERT INTO `sys_data_region` VALUES (7165, '雷家店', 4, '211422', '211422220', 'l');
INSERT INTO `sys_data_region` VALUES (7166, '小德营子', 4, '211422', '211422222', 'x');
INSERT INTO `sys_data_region` VALUES (7167, '二道湾子', 4, '211422', '211422223', 'e');
INSERT INTO `sys_data_region` VALUES (7168, '巴什罕', 4, '211422', '211422224', 'b');
INSERT INTO `sys_data_region` VALUES (7169, '娘娘庙', 4, '211422', '211422225', 'n');
INSERT INTO `sys_data_region` VALUES (7170, '谷杖子', 4, '211422', '211422226', 'g');
INSERT INTO `sys_data_region` VALUES (7171, '兴城', 3, '2114', '211481', 'x');
INSERT INTO `sys_data_region` VALUES (7172, '古城', 4, '211481', '211481001', 'g');
INSERT INTO `sys_data_region` VALUES (7173, '宁远', 4, '211481', '211481002', 'n');
INSERT INTO `sys_data_region` VALUES (7174, '城东', 4, '211481', '211481003', 'c');
INSERT INTO `sys_data_region` VALUES (7175, '温泉', 4, '211481', '211481004', 'w');
INSERT INTO `sys_data_region` VALUES (7176, '钓鱼台', 4, '211481', '211481005', 'd');
INSERT INTO `sys_data_region` VALUES (7177, '华山', 4, '211481', '211481006', 'h');
INSERT INTO `sys_data_region` VALUES (7178, '四家屯', 4, '211481', '211481007', 's');
INSERT INTO `sys_data_region` VALUES (7179, '菊花', 4, '211481', '211481008', 'j');
INSERT INTO `sys_data_region` VALUES (7180, '曹庄', 4, '211481', '211481101', 'c');
INSERT INTO `sys_data_region` VALUES (7181, '沙后所', 4, '211481', '211481103', 's');
INSERT INTO `sys_data_region` VALUES (7182, '东辛庄', 4, '211481', '211481104', 'd');
INSERT INTO `sys_data_region` VALUES (7183, '郭家', 4, '211481', '211481105', 'g');
INSERT INTO `sys_data_region` VALUES (7184, '红崖子', 4, '211481', '211481106', 'h');
INSERT INTO `sys_data_region` VALUES (7185, '徐大堡', 4, '211481', '211481107', 'x');
INSERT INTO `sys_data_region` VALUES (7186, '高家岭', 4, '211481', '211481108', 'g');
INSERT INTO `sys_data_region` VALUES (7187, '羊安', 4, '211481', '211481201', 'y');
INSERT INTO `sys_data_region` VALUES (7188, '元台子', 4, '211481', '211481203', 'y');
INSERT INTO `sys_data_region` VALUES (7189, '白塔', 4, '211481', '211481204', 'b');
INSERT INTO `sys_data_region` VALUES (7190, '望海', 4, '211481', '211481206', 'w');
INSERT INTO `sys_data_region` VALUES (7191, '刘台子', 4, '211481', '211481207', 'l');
INSERT INTO `sys_data_region` VALUES (7192, '大寨', 4, '211481', '211481208', 'd');
INSERT INTO `sys_data_region` VALUES (7193, '南大山', 4, '211481', '211481209', 'n');
INSERT INTO `sys_data_region` VALUES (7194, '围屏', 4, '211481', '211481210', 'w');
INSERT INTO `sys_data_region` VALUES (7195, '碱厂', 4, '211481', '211481212', 'j');
INSERT INTO `sys_data_region` VALUES (7196, '三道沟', 4, '211481', '211481213', 's');
INSERT INTO `sys_data_region` VALUES (7197, '旧门', 4, '211481', '211481215', 'j');
INSERT INTO `sys_data_region` VALUES (7198, '药王', 4, '211481', '211481216', 'y');
INSERT INTO `sys_data_region` VALUES (7199, '吉林', 1, '0', '22', 'j');
INSERT INTO `sys_data_region` VALUES (7200, '长春', 2, '22', '2201', 'c');
INSERT INTO `sys_data_region` VALUES (7201, '南关', 3, '2201', '220102', 'n');
INSERT INTO `sys_data_region` VALUES (7202, '南岭', 4, '220102', '220102001', 'n');
INSERT INTO `sys_data_region` VALUES (7203, '自强', 4, '220102', '220102002', 'z');
INSERT INTO `sys_data_region` VALUES (7204, '民康', 4, '220102', '220102003', 'm');
INSERT INTO `sys_data_region` VALUES (7205, '新春', 4, '220102', '220102004', 'x');
INSERT INTO `sys_data_region` VALUES (7206, '长通', 4, '220102', '220102005', 'c');
INSERT INTO `sys_data_region` VALUES (7207, '全安', 4, '220102', '220102006', 'q');
INSERT INTO `sys_data_region` VALUES (7208, '曙光', 4, '220102', '220102007', 's');
INSERT INTO `sys_data_region` VALUES (7209, '永吉', 4, '220102', '220102008', 'y');
INSERT INTO `sys_data_region` VALUES (7210, '桃源', 4, '220102', '220102009', 't');
INSERT INTO `sys_data_region` VALUES (7211, '永兴', 4, '220102', '220102010', 'y');
INSERT INTO `sys_data_region` VALUES (7212, '净月', 4, '220102', '220102011', 'j');
INSERT INTO `sys_data_region` VALUES (7213, '临河', 4, '220102', '220102012', 'l');
INSERT INTO `sys_data_region` VALUES (7214, '鸿城', 4, '220102', '220102013', 'h');
INSERT INTO `sys_data_region` VALUES (7215, '明珠', 4, '220102', '220102014', 'm');
INSERT INTO `sys_data_region` VALUES (7216, '新立城', 4, '220102', '220102100', 'x');
INSERT INTO `sys_data_region` VALUES (7217, '新湖', 4, '220102', '220102101', 'x');
INSERT INTO `sys_data_region` VALUES (7218, '玉谭', 4, '220102', '220102102', 'y');
INSERT INTO `sys_data_region` VALUES (7219, '幸福', 4, '220102', '220102200', 'x');
INSERT INTO `sys_data_region` VALUES (7220, '宽城', 3, '2201', '220103', 'k');
INSERT INTO `sys_data_region` VALUES (7221, '新发', 4, '220103', '220103001', 'x');
INSERT INTO `sys_data_region` VALUES (7222, '站前', 4, '220103', '220103002', 'z');
INSERT INTO `sys_data_region` VALUES (7223, '南广', 4, '220103', '220103003', 'n');
INSERT INTO `sys_data_region` VALUES (7224, '东广', 4, '220103', '220103004', 'd');
INSERT INTO `sys_data_region` VALUES (7225, '群英', 4, '220103', '220103005', 'q');
INSERT INTO `sys_data_region` VALUES (7226, '兴业', 4, '220103', '220103006', 'x');
INSERT INTO `sys_data_region` VALUES (7227, '凯旋', 4, '220103', '220103007', 'k');
INSERT INTO `sys_data_region` VALUES (7228, '团山', 4, '220103', '220103008', 't');
INSERT INTO `sys_data_region` VALUES (7229, '柳影', 4, '220103', '220103009', 'l');
INSERT INTO `sys_data_region` VALUES (7230, '兰家', 4, '220103', '220103101', 'l');
INSERT INTO `sys_data_region` VALUES (7231, '兴隆山', 4, '220103', '220103102', 'x');
INSERT INTO `sys_data_region` VALUES (7232, '米沙子', 4, '220103', '220103103', 'm');
INSERT INTO `sys_data_region` VALUES (7233, '万宝', 4, '220103', '220103104', 'w');
INSERT INTO `sys_data_region` VALUES (7234, '合隆', 4, '220103', '220103105', 'h');
INSERT INTO `sys_data_region` VALUES (7235, '奋进', 4, '220103', '220103200', 'f');
INSERT INTO `sys_data_region` VALUES (7236, '朝阳', 3, '2201', '220104', 'c');
INSERT INTO `sys_data_region` VALUES (7237, '前进', 4, '220104', '220104001', 'q');
INSERT INTO `sys_data_region` VALUES (7238, '桂林', 4, '220104', '220104002', 'g');
INSERT INTO `sys_data_region` VALUES (7239, '南湖', 4, '220104', '220104003', 'n');
INSERT INTO `sys_data_region` VALUES (7240, '永昌', 4, '220104', '220104004', 'y');
INSERT INTO `sys_data_region` VALUES (7241, '重庆', 4, '220104', '220104005', 'c');
INSERT INTO `sys_data_region` VALUES (7242, '清和', 4, '220104', '220104006', 'q');
INSERT INTO `sys_data_region` VALUES (7243, '红旗', 4, '220104', '220104007', 'h');
INSERT INTO `sys_data_region` VALUES (7244, '湖西', 4, '220104', '220104008', 'h');
INSERT INTO `sys_data_region` VALUES (7245, '富锋', 4, '220104', '220104009', 'f');
INSERT INTO `sys_data_region` VALUES (7246, '双德街道', 4, '220104', '220104011', 's');
INSERT INTO `sys_data_region` VALUES (7247, '飞跃', 4, '220104', '220104012', 'f');
INSERT INTO `sys_data_region` VALUES (7248, '乐山', 4, '220104', '220104101', 'l');
INSERT INTO `sys_data_region` VALUES (7249, '永春', 4, '220104', '220104102', 'y');
INSERT INTO `sys_data_region` VALUES (7250, '双德乡', 4, '220104', '220104200', 's');
INSERT INTO `sys_data_region` VALUES (7251, '二道', 3, '2201', '220105', 'e');
INSERT INTO `sys_data_region` VALUES (7252, '东盛', 4, '220105', '220105001', 'd');
INSERT INTO `sys_data_region` VALUES (7253, '吉林', 4, '220105', '220105002', 'j');
INSERT INTO `sys_data_region` VALUES (7254, '荣光', 4, '220105', '220105003', 'r');
INSERT INTO `sys_data_region` VALUES (7255, '东站', 4, '220105', '220105004', 'd');
INSERT INTO `sys_data_region` VALUES (7256, '远达', 4, '220105', '220105005', 'y');
INSERT INTO `sys_data_region` VALUES (7257, '八里堡', 4, '220105', '220105006', 'b');
INSERT INTO `sys_data_region` VALUES (7258, '东方广场', 4, '220105', '220105007', 'd');
INSERT INTO `sys_data_region` VALUES (7259, '劝农山', 4, '220105', '220105101', 'q');
INSERT INTO `sys_data_region` VALUES (7260, '泉眼', 4, '220105', '220105102', 'q');
INSERT INTO `sys_data_region` VALUES (7261, '英俊', 4, '220105', '220105103', 'y');
INSERT INTO `sys_data_region` VALUES (7262, '四家', 4, '220105', '220105201', 's');
INSERT INTO `sys_data_region` VALUES (7263, '绿园', 3, '2201', '220106', 'l');
INSERT INTO `sys_data_region` VALUES (7264, '正阳', 4, '220106', '220106001', 'z');
INSERT INTO `sys_data_region` VALUES (7265, '锦程', 4, '220106', '220106003', 'j');
INSERT INTO `sys_data_region` VALUES (7266, '春城', 4, '220106', '220106004', 'c');
INSERT INTO `sys_data_region` VALUES (7267, '青年路', 4, '220106', '220106006', 'q');
INSERT INTO `sys_data_region` VALUES (7268, '东风', 4, '220106', '220106007', 'd');
INSERT INTO `sys_data_region` VALUES (7269, '合心', 4, '220106', '220106100', 'h');
INSERT INTO `sys_data_region` VALUES (7270, '西新', 4, '220106', '220106101', 'x');
INSERT INTO `sys_data_region` VALUES (7271, '城西', 4, '220106', '220106102', 'c');
INSERT INTO `sys_data_region` VALUES (7272, '长春汽车产业开发区', 4, '220106', '220106170', 'c');
INSERT INTO `sys_data_region` VALUES (7273, '绿园经济开发区', 4, '220106', '220106400', 'l');
INSERT INTO `sys_data_region` VALUES (7274, '双阳', 3, '2201', '220112', 's');
INSERT INTO `sys_data_region` VALUES (7275, '云山', 4, '220112', '220112001', 'y');
INSERT INTO `sys_data_region` VALUES (7276, '平湖', 4, '220112', '220112002', 'p');
INSERT INTO `sys_data_region` VALUES (7277, '奢岭', 4, '220112', '220112003', 's');
INSERT INTO `sys_data_region` VALUES (7278, '山河', 4, '220112', '220112004', 's');
INSERT INTO `sys_data_region` VALUES (7279, '鹿乡', 4, '220112', '220112101', 'l');
INSERT INTO `sys_data_region` VALUES (7280, '太平', 4, '220112', '220112102', 't');
INSERT INTO `sys_data_region` VALUES (7281, '齐家', 4, '220112', '220112104', 'q');
INSERT INTO `sys_data_region` VALUES (7282, '双营子', 4, '220112', '220112203', 's');
INSERT INTO `sys_data_region` VALUES (7283, '九台', 3, '2201', '220113', 'j');
INSERT INTO `sys_data_region` VALUES (7284, '九台街道', 4, '220113', '220113001', 'j');
INSERT INTO `sys_data_region` VALUES (7285, '营城', 4, '220113', '220113002', 'y');
INSERT INTO `sys_data_region` VALUES (7286, '九郊', 4, '220113', '220113003', 'j');
INSERT INTO `sys_data_region` VALUES (7287, '西营城', 4, '220113', '220113004', 'x');
INSERT INTO `sys_data_region` VALUES (7288, '卡伦湖', 4, '220113', '220113005', 'k');
INSERT INTO `sys_data_region` VALUES (7289, '东湖', 4, '220113', '220113006', 'd');
INSERT INTO `sys_data_region` VALUES (7290, '土们岭', 4, '220113', '220113007', 't');
INSERT INTO `sys_data_region` VALUES (7291, '波泥河', 4, '220113', '220113008', 'b');
INSERT INTO `sys_data_region` VALUES (7292, '苇子沟', 4, '220113', '220113009', 'w');
INSERT INTO `sys_data_region` VALUES (7293, '兴隆', 4, '220113', '220113010', 'x');
INSERT INTO `sys_data_region` VALUES (7294, '纪家', 4, '220113', '220113011', 'j');
INSERT INTO `sys_data_region` VALUES (7295, '龙嘉', 4, '220113', '220113012', 'l');
INSERT INTO `sys_data_region` VALUES (7296, '城子街', 4, '220113', '220113014', 'c');
INSERT INTO `sys_data_region` VALUES (7297, '沐石河', 4, '220113', '220113015', 'm');
INSERT INTO `sys_data_region` VALUES (7298, '其塔木', 4, '220113', '220113102', 'q');
INSERT INTO `sys_data_region` VALUES (7299, '上河湾', 4, '220113', '220113103', 's');
INSERT INTO `sys_data_region` VALUES (7300, '胡家', 4, '220113', '220113200', 'h');
INSERT INTO `sys_data_region` VALUES (7301, '莽卡', 4, '220113', '220113201', 'm');
INSERT INTO `sys_data_region` VALUES (7302, '农安', 3, '2201', '220122', 'n');
INSERT INTO `sys_data_region` VALUES (7303, '农安镇', 4, '220122', '220122100', 'n');
INSERT INTO `sys_data_region` VALUES (7304, '伏龙泉', 4, '220122', '220122101', 'f');
INSERT INTO `sys_data_region` VALUES (7305, '哈拉海', 4, '220122', '220122102', 'h');
INSERT INTO `sys_data_region` VALUES (7306, '靠山', 4, '220122', '220122103', 'k');
INSERT INTO `sys_data_region` VALUES (7307, '开安', 4, '220122', '220122105', 'k');
INSERT INTO `sys_data_region` VALUES (7308, '烧锅', 4, '220122', '220122106', 's');
INSERT INTO `sys_data_region` VALUES (7309, '高家店', 4, '220122', '220122107', 'g');
INSERT INTO `sys_data_region` VALUES (7310, '华家', 4, '220122', '220122109', 'h');
INSERT INTO `sys_data_region` VALUES (7311, '三盛玉', 4, '220122', '220122111', 's');
INSERT INTO `sys_data_region` VALUES (7312, '巴吉垒', 4, '220122', '220122112', 'b');
INSERT INTO `sys_data_region` VALUES (7313, '三岗', 4, '220122', '220122113', 's');
INSERT INTO `sys_data_region` VALUES (7314, '前岗', 4, '220122', '220122201', 'q');
INSERT INTO `sys_data_region` VALUES (7315, '龙王', 4, '220122', '220122202', 'l');
INSERT INTO `sys_data_region` VALUES (7316, '万顺', 4, '220122', '220122204', 'w');
INSERT INTO `sys_data_region` VALUES (7317, '杨树林', 4, '220122', '220122205', 'y');
INSERT INTO `sys_data_region` VALUES (7318, '永安', 4, '220122', '220122207', 'y');
INSERT INTO `sys_data_region` VALUES (7319, '青山口', 4, '220122', '220122208', 'q');
INSERT INTO `sys_data_region` VALUES (7320, '黄鱼圈', 4, '220122', '220122209', 'h');
INSERT INTO `sys_data_region` VALUES (7321, '新农', 4, '220122', '220122210', 'x');
INSERT INTO `sys_data_region` VALUES (7322, '万金塔', 4, '220122', '220122211', 'w');
INSERT INTO `sys_data_region` VALUES (7323, '小城子', 4, '220122', '220122212', 'x');
INSERT INTO `sys_data_region` VALUES (7324, '洼中高农场', 4, '220122', '220122400', 'w');
INSERT INTO `sys_data_region` VALUES (7325, '榆树', 3, '2201', '220182', 'y');
INSERT INTO `sys_data_region` VALUES (7326, '华昌', 4, '220182', '220182001', 'h');
INSERT INTO `sys_data_region` VALUES (7327, '正阳', 4, '220182', '220182002', 'z');
INSERT INTO `sys_data_region` VALUES (7328, '培英', 4, '220182', '220182003', 'p');
INSERT INTO `sys_data_region` VALUES (7329, '城郊', 4, '220182', '220182004', 'c');
INSERT INTO `sys_data_region` VALUES (7330, '五棵树', 4, '220182', '220182100', 'w');
INSERT INTO `sys_data_region` VALUES (7331, '弓棚', 4, '220182', '220182101', 'g');
INSERT INTO `sys_data_region` VALUES (7332, '闵家', 4, '220182', '220182102', 'm');
INSERT INTO `sys_data_region` VALUES (7333, '大坡', 4, '220182', '220182103', 'd');
INSERT INTO `sys_data_region` VALUES (7334, '黑林', 4, '220182', '220182104', 'h');
INSERT INTO `sys_data_region` VALUES (7335, '土桥', 4, '220182', '220182105', 't');
INSERT INTO `sys_data_region` VALUES (7336, '新立', 4, '220182', '220182106', 'x');
INSERT INTO `sys_data_region` VALUES (7337, '大岭', 4, '220182', '220182107', 'd');
INSERT INTO `sys_data_region` VALUES (7338, '于家', 4, '220182', '220182108', 'y');
INSERT INTO `sys_data_region` VALUES (7339, '泗河', 4, '220182', '220182109', 's');
INSERT INTO `sys_data_region` VALUES (7340, '八号', 4, '220182', '220182110', 'b');
INSERT INTO `sys_data_region` VALUES (7341, '刘家', 4, '220182', '220182111', 'l');
INSERT INTO `sys_data_region` VALUES (7342, '秀水', 4, '220182', '220182112', 'x');
INSERT INTO `sys_data_region` VALUES (7343, '保寿', 4, '220182', '220182113', 'b');
INSERT INTO `sys_data_region` VALUES (7344, '新庄', 4, '220182', '220182115', 'x');
INSERT INTO `sys_data_region` VALUES (7345, '育民', 4, '220182', '220182200', 'y');
INSERT INTO `sys_data_region` VALUES (7346, '红星', 4, '220182', '220182201', 'h');
INSERT INTO `sys_data_region` VALUES (7347, '太安', 4, '220182', '220182203', 't');
INSERT INTO `sys_data_region` VALUES (7348, '先峰', 4, '220182', '220182204', 'x');
INSERT INTO `sys_data_region` VALUES (7349, '青山', 4, '220182', '220182208', 'q');
INSERT INTO `sys_data_region` VALUES (7350, '延和', 4, '220182', '220182209', 'y');
INSERT INTO `sys_data_region` VALUES (7351, '恩育', 4, '220182', '220182210', 'e');
INSERT INTO `sys_data_region` VALUES (7352, '城发', 4, '220182', '220182211', 'c');
INSERT INTO `sys_data_region` VALUES (7353, '环城', 4, '220182', '220182213', 'h');
INSERT INTO `sys_data_region` VALUES (7354, '德惠', 3, '2201', '220183', 'd');
INSERT INTO `sys_data_region` VALUES (7355, '胜利', 4, '220183', '220183001', 's');
INSERT INTO `sys_data_region` VALUES (7356, '建设', 4, '220183', '220183002', 'j');
INSERT INTO `sys_data_region` VALUES (7357, '惠发', 4, '220183', '220183004', 'h');
INSERT INTO `sys_data_region` VALUES (7358, '夏家店', 4, '220183', '220183005', 'x');
INSERT INTO `sys_data_region` VALUES (7359, '大青嘴', 4, '220183', '220183100', 'd');
INSERT INTO `sys_data_region` VALUES (7360, '郭家', 4, '220183', '220183101', 'g');
INSERT INTO `sys_data_region` VALUES (7361, '松花江', 4, '220183', '220183102', 's');
INSERT INTO `sys_data_region` VALUES (7362, '达家沟', 4, '220183', '220183103', 'd');
INSERT INTO `sys_data_region` VALUES (7363, '大房身', 4, '220183', '220183104', 'd');
INSERT INTO `sys_data_region` VALUES (7364, '岔路口', 4, '220183', '220183105', 'c');
INSERT INTO `sys_data_region` VALUES (7365, '朱城子', 4, '220183', '220183106', 'z');
INSERT INTO `sys_data_region` VALUES (7366, '布海', 4, '220183', '220183110', 'b');
INSERT INTO `sys_data_region` VALUES (7367, '天台', 4, '220183', '220183111', 't');
INSERT INTO `sys_data_region` VALUES (7368, '菜园子', 4, '220183', '220183112', 'c');
INSERT INTO `sys_data_region` VALUES (7369, '同太', 4, '220183', '220183200', 't');
INSERT INTO `sys_data_region` VALUES (7370, '边岗', 4, '220183', '220183202', 'b');
INSERT INTO `sys_data_region` VALUES (7371, '五台', 4, '220183', '220183203', 'w');
INSERT INTO `sys_data_region` VALUES (7372, '朝阳', 4, '220183', '220183204', 'z');
INSERT INTO `sys_data_region` VALUES (7373, '公主岭', 3, '2201', '220184', 'g');
INSERT INTO `sys_data_region` VALUES (7374, '河南', 4, '220184', '220184001', 'h');
INSERT INTO `sys_data_region` VALUES (7375, '河北', 4, '220184', '220184002', 'h');
INSERT INTO `sys_data_region` VALUES (7376, '东三', 4, '220184', '220184003', 'd');
INSERT INTO `sys_data_region` VALUES (7377, '岭东', 4, '220184', '220184004', 'l');
INSERT INTO `sys_data_region` VALUES (7378, '铁北', 4, '220184', '220184005', 't');
INSERT INTO `sys_data_region` VALUES (7379, '岭西', 4, '220184', '220184006', 'l');
INSERT INTO `sys_data_region` VALUES (7380, '南崴子', 4, '220184', '220184007', 'n');
INSERT INTO `sys_data_region` VALUES (7381, '刘房子', 4, '220184', '220184008', 'l');
INSERT INTO `sys_data_region` VALUES (7382, '苇子沟', 4, '220184', '220184010', 'w');
INSERT INTO `sys_data_region` VALUES (7383, '环岭', 4, '220184', '220184011', 'h');
INSERT INTO `sys_data_region` VALUES (7384, '二十家子', 4, '220184', '220184100', 'e');
INSERT INTO `sys_data_region` VALUES (7385, '黑林子', 4, '220184', '220184103', 'h');
INSERT INTO `sys_data_region` VALUES (7386, '陶家屯', 4, '220184', '220184104', 't');
INSERT INTO `sys_data_region` VALUES (7387, '范家屯', 4, '220184', '220184105', 'f');
INSERT INTO `sys_data_region` VALUES (7388, '响水', 4, '220184', '220184106', 'x');
INSERT INTO `sys_data_region` VALUES (7389, '大岭', 4, '220184', '220184107', 'd');
INSERT INTO `sys_data_region` VALUES (7390, '怀德', 4, '220184', '220184108', 'h');
INSERT INTO `sys_data_region` VALUES (7391, '双城堡', 4, '220184', '220184109', 's');
INSERT INTO `sys_data_region` VALUES (7392, '双龙', 4, '220184', '220184110', 's');
INSERT INTO `sys_data_region` VALUES (7393, '杨大城子', 4, '220184', '220184111', 'y');
INSERT INTO `sys_data_region` VALUES (7394, '毛城子', 4, '220184', '220184112', 'm');
INSERT INTO `sys_data_region` VALUES (7395, '玻璃城子', 4, '220184', '220184113', 'b');
INSERT INTO `sys_data_region` VALUES (7396, '朝阳坡', 4, '220184', '220184114', 'z');
INSERT INTO `sys_data_region` VALUES (7397, '大榆树', 4, '220184', '220184115', 'd');
INSERT INTO `sys_data_region` VALUES (7398, '秦家屯', 4, '220184', '220184116', 'q');
INSERT INTO `sys_data_region` VALUES (7399, '八屋', 4, '220184', '220184117', 'b');
INSERT INTO `sys_data_region` VALUES (7400, '十屋', 4, '220184', '220184118', 's');
INSERT INTO `sys_data_region` VALUES (7401, '桑树台', 4, '220184', '220184119', 's');
INSERT INTO `sys_data_region` VALUES (7402, '龙山', 4, '220184', '220184201', 'l');
INSERT INTO `sys_data_region` VALUES (7403, '永发', 4, '220184', '220184203', 'y');
INSERT INTO `sys_data_region` VALUES (7404, '吉林市', 2, '22', '2202', 'j');
INSERT INTO `sys_data_region` VALUES (7405, '昌邑', 3, '2202', '220202', 'c');
INSERT INTO `sys_data_region` VALUES (7406, '兴华', 4, '220202', '220202001', 'x');
INSERT INTO `sys_data_region` VALUES (7407, '文庙', 4, '220202', '220202002', 'w');
INSERT INTO `sys_data_region` VALUES (7408, '东局子', 4, '220202', '220202003', 'd');
INSERT INTO `sys_data_region` VALUES (7409, '新地号', 4, '220202', '220202004', 'x');
INSERT INTO `sys_data_region` VALUES (7410, '延安', 4, '220202', '220202005', 'y');
INSERT INTO `sys_data_region` VALUES (7411, '站前', 4, '220202', '220202006', 'z');
INSERT INTO `sys_data_region` VALUES (7412, '民主', 4, '220202', '220202007', 'm');
INSERT INTO `sys_data_region` VALUES (7413, '莲花', 4, '220202', '220202008', 'l');
INSERT INTO `sys_data_region` VALUES (7414, '通江', 4, '220202', '220202009', 't');
INSERT INTO `sys_data_region` VALUES (7415, '哈达', 4, '220202', '220202010', 'h');
INSERT INTO `sys_data_region` VALUES (7416, '新建', 4, '220202', '220202011', 'x');
INSERT INTO `sys_data_region` VALUES (7417, '延江', 4, '220202', '220202012', 'y');
INSERT INTO `sys_data_region` VALUES (7418, '双吉', 4, '220202', '220202013', 's');
INSERT INTO `sys_data_region` VALUES (7419, '九站', 4, '220202', '220202016', 'j');
INSERT INTO `sys_data_region` VALUES (7420, '吉林东市商贸示范区', 4, '220202', '220202071', 'j');
INSERT INTO `sys_data_region` VALUES (7421, '孤店子', 4, '220202', '220202100', 'g');
INSERT INTO `sys_data_region` VALUES (7422, '桦皮厂', 4, '220202', '220202101', 'h');
INSERT INTO `sys_data_region` VALUES (7423, '左家', 4, '220202', '220202102', 'z');
INSERT INTO `sys_data_region` VALUES (7424, '两家子', 4, '220202', '220202200', 'l');
INSERT INTO `sys_data_region` VALUES (7425, '土城子', 4, '220202', '220202201', 't');
INSERT INTO `sys_data_region` VALUES (7426, '龙潭', 3, '2202', '220203', 'l');
INSERT INTO `sys_data_region` VALUES (7427, '遵义', 4, '220203', '220203002', 'z');
INSERT INTO `sys_data_region` VALUES (7428, '铁东', 4, '220203', '220203003', 't');
INSERT INTO `sys_data_region` VALUES (7429, '龙潭街道', 4, '220203', '220203004', 'l');
INSERT INTO `sys_data_region` VALUES (7430, '新安', 4, '220203', '220203005', 'x');
INSERT INTO `sys_data_region` VALUES (7431, '湘潭', 4, '220203', '220203006', 'x');
INSERT INTO `sys_data_region` VALUES (7432, '龙华', 4, '220203', '220203007', 'l');
INSERT INTO `sys_data_region` VALUES (7433, '新吉林', 4, '220203', '220203008', 'x');
INSERT INTO `sys_data_region` VALUES (7434, '山前', 4, '220203', '220203009', 's');
INSERT INTO `sys_data_region` VALUES (7435, '泡子沿', 4, '220203', '220203010', 'p');
INSERT INTO `sys_data_region` VALUES (7436, '靠山', 4, '220203', '220203011', 'k');
INSERT INTO `sys_data_region` VALUES (7437, '乌拉街', 4, '220203', '220203100', 'w');
INSERT INTO `sys_data_region` VALUES (7438, '缸窑', 4, '220203', '220203101', 'g');
INSERT INTO `sys_data_region` VALUES (7439, '江密峰', 4, '220203', '220203102', 'j');
INSERT INTO `sys_data_region` VALUES (7440, '大口钦', 4, '220203', '220203103', 'd');
INSERT INTO `sys_data_region` VALUES (7441, '金珠', 4, '220203', '220203104', 'j');
INSERT INTO `sys_data_region` VALUES (7442, '江北', 4, '220203', '220203201', 'j');
INSERT INTO `sys_data_region` VALUES (7443, '龙潭经济开发区', 4, '220203', '220203400', 'l');
INSERT INTO `sys_data_region` VALUES (7444, '船营', 3, '2202', '220204', 'c');
INSERT INTO `sys_data_region` VALUES (7445, '德胜', 4, '220204', '220204001', 'd');
INSERT INTO `sys_data_region` VALUES (7446, '南京', 4, '220204', '220204002', 'n');
INSERT INTO `sys_data_region` VALUES (7447, '大东', 4, '220204', '220204003', 'd');
INSERT INTO `sys_data_region` VALUES (7448, '青岛', 4, '220204', '220204004', 'q');
INSERT INTO `sys_data_region` VALUES (7449, '向阳', 4, '220204', '220204005', 'x');
INSERT INTO `sys_data_region` VALUES (7450, '北极', 4, '220204', '220204006', 'b');
INSERT INTO `sys_data_region` VALUES (7451, '致和', 4, '220204', '220204007', 'z');
INSERT INTO `sys_data_region` VALUES (7452, '长春路', 4, '220204', '220204008', 'c');
INSERT INTO `sys_data_region` VALUES (7453, '临江', 4, '220204', '220204009', 'l');
INSERT INTO `sys_data_region` VALUES (7454, '北山', 4, '220204', '220204010', 'b');
INSERT INTO `sys_data_region` VALUES (7455, '黄旗', 4, '220204', '220204011', 'h');
INSERT INTO `sys_data_region` VALUES (7456, '大绥河', 4, '220204', '220204100', 'd');
INSERT INTO `sys_data_region` VALUES (7457, '搜登站', 4, '220204', '220204101', 's');
INSERT INTO `sys_data_region` VALUES (7458, '越北', 4, '220204', '220204102', 'y');
INSERT INTO `sys_data_region` VALUES (7459, '欢喜', 4, '220204', '220204200', 'h');
INSERT INTO `sys_data_region` VALUES (7460, '丰满', 3, '2202', '220211', 'f');
INSERT INTO `sys_data_region` VALUES (7461, '泰山', 4, '220211', '220211001', 't');
INSERT INTO `sys_data_region` VALUES (7462, '江南街道', 4, '220211', '220211002', 'j');
INSERT INTO `sys_data_region` VALUES (7463, '石井', 4, '220211', '220211003', 's');
INSERT INTO `sys_data_region` VALUES (7464, '沿丰', 4, '220211', '220211004', 'y');
INSERT INTO `sys_data_region` VALUES (7465, '丰满街道', 4, '220211', '220211005', 'f');
INSERT INTO `sys_data_region` VALUES (7466, '红旗', 4, '220211', '220211006', 'h');
INSERT INTO `sys_data_region` VALUES (7467, '高新', 4, '220211', '220211007', 'g');
INSERT INTO `sys_data_region` VALUES (7468, '旺起', 4, '220211', '220211100', 'w');
INSERT INTO `sys_data_region` VALUES (7469, '江南乡', 4, '220211', '220211200', 'j');
INSERT INTO `sys_data_region` VALUES (7470, '小白山', 4, '220211', '220211201', 'x');
INSERT INTO `sys_data_region` VALUES (7471, '前二道', 4, '220211', '220211202', 'q');
INSERT INTO `sys_data_region` VALUES (7472, '永吉', 3, '2202', '220221', 'y');
INSERT INTO `sys_data_region` VALUES (7473, '口前', 4, '220221', '220221101', 'k');
INSERT INTO `sys_data_region` VALUES (7474, '岔路河', 4, '220221', '220221102', 'c');
INSERT INTO `sys_data_region` VALUES (7475, '双河', 4, '220221', '220221103', 's');
INSERT INTO `sys_data_region` VALUES (7476, '西阳', 4, '220221', '220221104', 'x');
INSERT INTO `sys_data_region` VALUES (7477, '北大湖', 4, '220221', '220221105', 'b');
INSERT INTO `sys_data_region` VALUES (7478, '一拉溪', 4, '220221', '220221106', 'y');
INSERT INTO `sys_data_region` VALUES (7479, '万昌', 4, '220221', '220221107', 'w');
INSERT INTO `sys_data_region` VALUES (7480, '永吉经济开发区', 4, '220221', '220221172', 'y');
INSERT INTO `sys_data_region` VALUES (7481, '金家', 4, '220221', '220221203', 'j');
INSERT INTO `sys_data_region` VALUES (7482, '黄榆', 4, '220221', '220221205', 'h');
INSERT INTO `sys_data_region` VALUES (7483, '蛟河', 3, '2202', '220281', 'j');
INSERT INTO `sys_data_region` VALUES (7484, '民主', 4, '220281', '220281001', 'm');
INSERT INTO `sys_data_region` VALUES (7485, '长安', 4, '220281', '220281002', 'c');
INSERT INTO `sys_data_region` VALUES (7486, '河南', 4, '220281', '220281003', 'h');
INSERT INTO `sys_data_region` VALUES (7487, '奶子山', 4, '220281', '220281005', 'n');
INSERT INTO `sys_data_region` VALUES (7488, '新农', 4, '220281', '220281006', 'x');
INSERT INTO `sys_data_region` VALUES (7489, '拉法', 4, '220281', '220281007', 'l');
INSERT INTO `sys_data_region` VALUES (7490, '河北', 4, '220281', '220281009', 'h');
INSERT INTO `sys_data_region` VALUES (7491, '新站', 4, '220281', '220281100', 'x');
INSERT INTO `sys_data_region` VALUES (7492, '天岗', 4, '220281', '220281101', 't');
INSERT INTO `sys_data_region` VALUES (7493, '白石山', 4, '220281', '220281102', 'b');
INSERT INTO `sys_data_region` VALUES (7494, '漂河', 4, '220281', '220281103', 'p');
INSERT INTO `sys_data_region` VALUES (7495, '黄松甸', 4, '220281', '220281104', 'h');
INSERT INTO `sys_data_region` VALUES (7496, '天北', 4, '220281', '220281106', 't');
INSERT INTO `sys_data_region` VALUES (7497, '松江', 4, '220281', '220281107', 's');
INSERT INTO `sys_data_region` VALUES (7498, '庆岭', 4, '220281', '220281108', 'q');
INSERT INTO `sys_data_region` VALUES (7499, '乌林', 4, '220281', '220281200', 'w');
INSERT INTO `sys_data_region` VALUES (7500, '前进', 4, '220281', '220281202', 'q');
INSERT INTO `sys_data_region` VALUES (7501, '桦甸', 3, '2202', '220282', 'h');
INSERT INTO `sys_data_region` VALUES (7502, '明桦', 4, '220282', '220282001', 'm');
INSERT INTO `sys_data_region` VALUES (7503, '永吉', 4, '220282', '220282002', 'y');
INSERT INTO `sys_data_region` VALUES (7504, '胜利', 4, '220282', '220282003', 's');
INSERT INTO `sys_data_region` VALUES (7505, '新华', 4, '220282', '220282004', 'x');
INSERT INTO `sys_data_region` VALUES (7506, '启新', 4, '220282', '220282005', 'q');
INSERT INTO `sys_data_region` VALUES (7507, '夹皮沟', 4, '220282', '220282100', 'j');
INSERT INTO `sys_data_region` VALUES (7508, '二道甸子', 4, '220282', '220282102', 'e');
INSERT INTO `sys_data_region` VALUES (7509, '红石砬子', 4, '220282', '220282103', 'h');
INSERT INTO `sys_data_region` VALUES (7510, '八道河子', 4, '220282', '220282104', 'b');
INSERT INTO `sys_data_region` VALUES (7511, '常山', 4, '220282', '220282106', 'c');
INSERT INTO `sys_data_region` VALUES (7512, '金沙', 4, '220282', '220282107', 'j');
INSERT INTO `sys_data_region` VALUES (7513, '桦郊', 4, '220282', '220282200', 'h');
INSERT INTO `sys_data_region` VALUES (7514, '横道河子', 4, '220282', '220282202', 'h');
INSERT INTO `sys_data_region` VALUES (7515, '公吉', 4, '220282', '220282205', 'g');
INSERT INTO `sys_data_region` VALUES (7516, '舒兰', 3, '2202', '220283', 's');
INSERT INTO `sys_data_region` VALUES (7517, '北城', 4, '220283', '220283001', 'b');
INSERT INTO `sys_data_region` VALUES (7518, '南城', 4, '220283', '220283002', 'n');
INSERT INTO `sys_data_region` VALUES (7519, '环城', 4, '220283', '220283003', 'h');
INSERT INTO `sys_data_region` VALUES (7520, '吉舒', 4, '220283', '220283004', 'j');
INSERT INTO `sys_data_region` VALUES (7521, '铁东', 4, '220283', '220283005', 't');
INSERT INTO `sys_data_region` VALUES (7522, '白旗', 4, '220283', '220283100', 'b');
INSERT INTO `sys_data_region` VALUES (7523, '朝阳', 4, '220283', '220283101', 'z');
INSERT INTO `sys_data_region` VALUES (7524, '开原', 4, '220283', '220283102', 'k');
INSERT INTO `sys_data_region` VALUES (7525, '上营', 4, '220283', '220283103', 's');
INSERT INTO `sys_data_region` VALUES (7526, '水曲柳', 4, '220283', '220283104', 's');
INSERT INTO `sys_data_region` VALUES (7527, '平安', 4, '220283', '220283105', 'p');
INSERT INTO `sys_data_region` VALUES (7528, '法特', 4, '220283', '220283106', 'f');
INSERT INTO `sys_data_region` VALUES (7529, '溪河', 4, '220283', '220283107', 'x');
INSERT INTO `sys_data_region` VALUES (7530, '小城', 4, '220283', '220283108', 'x');
INSERT INTO `sys_data_region` VALUES (7531, '金马', 4, '220283', '220283109', 'j');
INSERT INTO `sys_data_region` VALUES (7532, '七里', 4, '220283', '220283200', 'q');
INSERT INTO `sys_data_region` VALUES (7533, '莲花', 4, '220283', '220283202', 'l');
INSERT INTO `sys_data_region` VALUES (7534, '亮甲山', 4, '220283', '220283203', 'l');
INSERT INTO `sys_data_region` VALUES (7535, '天德', 4, '220283', '220283204', 't');
INSERT INTO `sys_data_region` VALUES (7536, '新安', 4, '220283', '220283206', 'x');
INSERT INTO `sys_data_region` VALUES (7537, '磐石', 3, '2202', '220284', 'p');
INSERT INTO `sys_data_region` VALUES (7538, '东宁', 4, '220284', '220284001', 'd');
INSERT INTO `sys_data_region` VALUES (7539, '河南', 4, '220284', '220284002', 'h');
INSERT INTO `sys_data_region` VALUES (7540, '福安', 4, '220284', '220284003', 'f');
INSERT INTO `sys_data_region` VALUES (7541, '磐石经济开发区', 4, '220284', '220284070', 'p');
INSERT INTO `sys_data_region` VALUES (7542, '烟筒山', 4, '220284', '220284100', 'y');
INSERT INTO `sys_data_region` VALUES (7543, '明城', 4, '220284', '220284101', 'm');
INSERT INTO `sys_data_region` VALUES (7544, '红旗岭', 4, '220284', '220284102', 'h');
INSERT INTO `sys_data_region` VALUES (7545, '牛心', 4, '220284', '220284103', 'n');
INSERT INTO `sys_data_region` VALUES (7546, '石嘴', 4, '220284', '220284104', 's');
INSERT INTO `sys_data_region` VALUES (7547, '朝阳山', 4, '220284', '220284105', 'z');
INSERT INTO `sys_data_region` VALUES (7548, '富太', 4, '220284', '220284106', 'f');
INSERT INTO `sys_data_region` VALUES (7549, '呼兰', 4, '220284', '220284107', 'h');
INSERT INTO `sys_data_region` VALUES (7550, '松山', 4, '220284', '220284108', 's');
INSERT INTO `sys_data_region` VALUES (7551, '黑石', 4, '220284', '220284109', 'h');
INSERT INTO `sys_data_region` VALUES (7552, '吉昌', 4, '220284', '220284110', 'j');
INSERT INTO `sys_data_region` VALUES (7553, '取柴河', 4, '220284', '220284111', 'q');
INSERT INTO `sys_data_region` VALUES (7554, '驿马', 4, '220284', '220284112', 'y');
INSERT INTO `sys_data_region` VALUES (7555, '宝山', 4, '220284', '220284200', 'b');
INSERT INTO `sys_data_region` VALUES (7556, '四平', 2, '22', '2203', 's');
INSERT INTO `sys_data_region` VALUES (7557, '铁西', 3, '2203', '220302', 't');
INSERT INTO `sys_data_region` VALUES (7558, '仁兴', 4, '220302', '220302001', 'r');
INSERT INTO `sys_data_region` VALUES (7559, '英雄', 4, '220302', '220302002', 'y');
INSERT INTO `sys_data_region` VALUES (7560, '站前', 4, '220302', '220302003', 'z');
INSERT INTO `sys_data_region` VALUES (7561, '北沟', 4, '220302', '220302004', 'b');
INSERT INTO `sys_data_region` VALUES (7562, '十家堡', 4, '220302', '220302100', 's');
INSERT INTO `sys_data_region` VALUES (7563, '郭家店', 4, '220302', '220302101', 'g');
INSERT INTO `sys_data_region` VALUES (7564, '孟家岭', 4, '220302', '220302102', 'm');
INSERT INTO `sys_data_region` VALUES (7565, '平西', 4, '220302', '220302200', 'p');
INSERT INTO `sys_data_region` VALUES (7566, '铁东', 3, '2203', '220303', 't');
INSERT INTO `sys_data_region` VALUES (7567, '平东', 4, '220303', '220303001', 'p');
INSERT INTO `sys_data_region` VALUES (7568, '北市场', 4, '220303', '220303002', 'b');
INSERT INTO `sys_data_region` VALUES (7569, '黄土坑', 4, '220303', '220303003', 'h');
INSERT INTO `sys_data_region` VALUES (7570, '七马路', 4, '220303', '220303004', 'q');
INSERT INTO `sys_data_region` VALUES (7571, '四马路', 4, '220303', '220303005', 's');
INSERT INTO `sys_data_region` VALUES (7572, '解放', 4, '220303', '220303006', 'j');
INSERT INTO `sys_data_region` VALUES (7573, '平南', 4, '220303', '220303008', 'p');
INSERT INTO `sys_data_region` VALUES (7574, '山门', 4, '220303', '220303100', 's');
INSERT INTO `sys_data_region` VALUES (7575, '石岭子', 4, '220303', '220303103', 's');
INSERT INTO `sys_data_region` VALUES (7576, '叶赫', 4, '220303', '220303110', 'y');
INSERT INTO `sys_data_region` VALUES (7577, '四平经济开发区', 4, '220303', '220303170', 's');
INSERT INTO `sys_data_region` VALUES (7578, '城东', 4, '220303', '220303200', 'c');
INSERT INTO `sys_data_region` VALUES (7579, '梨树', 3, '2203', '220322', 'l');
INSERT INTO `sys_data_region` VALUES (7580, '梨树镇', 4, '220322', '220322100', 'l');
INSERT INTO `sys_data_region` VALUES (7581, '榆树台', 4, '220322', '220322102', 'y');
INSERT INTO `sys_data_region` VALUES (7582, '小城子', 4, '220322', '220322105', 'x');
INSERT INTO `sys_data_region` VALUES (7583, '喇嘛甸', 4, '220322', '220322106', 'l');
INSERT INTO `sys_data_region` VALUES (7584, '蔡家', 4, '220322', '220322107', 'c');
INSERT INTO `sys_data_region` VALUES (7585, '刘家馆子', 4, '220322', '220322108', 'l');
INSERT INTO `sys_data_region` VALUES (7586, '万发', 4, '220322', '220322113', 'w');
INSERT INTO `sys_data_region` VALUES (7587, '东河', 4, '220322', '220322114', 'd');
INSERT INTO `sys_data_region` VALUES (7588, '沈洋', 4, '220322', '220322115', 's');
INSERT INTO `sys_data_region` VALUES (7589, '林海', 4, '220322', '220322116', 'l');
INSERT INTO `sys_data_region` VALUES (7590, '小宽', 4, '220322', '220322117', 'x');
INSERT INTO `sys_data_region` VALUES (7591, '孤家子', 4, '220322', '220322118', 'g');
INSERT INTO `sys_data_region` VALUES (7592, '白山', 4, '220322', '220322202', 'b');
INSERT INTO `sys_data_region` VALUES (7593, '泉眼岭', 4, '220322', '220322204', 'q');
INSERT INTO `sys_data_region` VALUES (7594, '胜利', 4, '220322', '220322205', 's');
INSERT INTO `sys_data_region` VALUES (7595, '四棵树', 4, '220322', '220322206', 's');
INSERT INTO `sys_data_region` VALUES (7596, '双河', 4, '220322', '220322207', 's');
INSERT INTO `sys_data_region` VALUES (7597, '金山', 4, '220322', '220322208', 'j');
INSERT INTO `sys_data_region` VALUES (7598, '国营梨树农场', 4, '220322', '220322400', 'g');
INSERT INTO `sys_data_region` VALUES (7599, '伊通', 3, '2203', '220323', 'y');
INSERT INTO `sys_data_region` VALUES (7600, '伊通镇', 4, '220323', '220323100', 'y');
INSERT INTO `sys_data_region` VALUES (7601, '二道', 4, '220323', '220323101', 'e');
INSERT INTO `sys_data_region` VALUES (7602, '伊丹', 4, '220323', '220323102', 'y');
INSERT INTO `sys_data_region` VALUES (7603, '马鞍山', 4, '220323', '220323103', 'm');
INSERT INTO `sys_data_region` VALUES (7604, '景台', 4, '220323', '220323104', 'j');
INSERT INTO `sys_data_region` VALUES (7605, '靠山', 4, '220323', '220323105', 'k');
INSERT INTO `sys_data_region` VALUES (7606, '大孤山', 4, '220323', '220323106', 'd');
INSERT INTO `sys_data_region` VALUES (7607, '小孤山', 4, '220323', '220323107', 'x');
INSERT INTO `sys_data_region` VALUES (7608, '营城子', 4, '220323', '220323108', 'y');
INSERT INTO `sys_data_region` VALUES (7609, '西苇', 4, '220323', '220323109', 'x');
INSERT INTO `sys_data_region` VALUES (7610, '河源', 4, '220323', '220323110', 'h');
INSERT INTO `sys_data_region` VALUES (7611, '黄岭子', 4, '220323', '220323111', 'h');
INSERT INTO `sys_data_region` VALUES (7612, '新兴', 4, '220323', '220323200', 'x');
INSERT INTO `sys_data_region` VALUES (7613, '莫里青', 4, '220323', '220323201', 'm');
INSERT INTO `sys_data_region` VALUES (7614, '三道', 4, '220323', '220323203', 's');
INSERT INTO `sys_data_region` VALUES (7615, '双辽', 3, '2203', '220382', 's');
INSERT INTO `sys_data_region` VALUES (7616, '郑家屯', 4, '220382', '220382001', 'z');
INSERT INTO `sys_data_region` VALUES (7617, '辽东', 4, '220382', '220382002', 'l');
INSERT INTO `sys_data_region` VALUES (7618, '辽西', 4, '220382', '220382003', 'l');
INSERT INTO `sys_data_region` VALUES (7619, '辽南', 4, '220382', '220382004', 'l');
INSERT INTO `sys_data_region` VALUES (7620, '辽北', 4, '220382', '220382005', 'l');
INSERT INTO `sys_data_region` VALUES (7621, '红旗', 4, '220382', '220382006', 'h');
INSERT INTO `sys_data_region` VALUES (7622, '茂林', 4, '220382', '220382100', 'm');
INSERT INTO `sys_data_region` VALUES (7623, '双山', 4, '220382', '220382101', 's');
INSERT INTO `sys_data_region` VALUES (7624, '卧虎', 4, '220382', '220382102', 'w');
INSERT INTO `sys_data_region` VALUES (7625, '服先', 4, '220382', '220382103', 'f');
INSERT INTO `sys_data_region` VALUES (7626, '王奔', 4, '220382', '220382105', 'w');
INSERT INTO `sys_data_region` VALUES (7627, '玻璃山', 4, '220382', '220382106', 'b');
INSERT INTO `sys_data_region` VALUES (7628, '兴隆', 4, '220382', '220382107', 'x');
INSERT INTO `sys_data_region` VALUES (7629, '东明', 4, '220382', '220382108', 'd');
INSERT INTO `sys_data_region` VALUES (7630, '那木斯', 4, '220382', '220382200', 'n');
INSERT INTO `sys_data_region` VALUES (7631, '柳条', 4, '220382', '220382201', 'l');
INSERT INTO `sys_data_region` VALUES (7632, '新立', 4, '220382', '220382202', 'x');
INSERT INTO `sys_data_region` VALUES (7633, '永加', 4, '220382', '220382203', 'y');
INSERT INTO `sys_data_region` VALUES (7634, '双辽农场', 4, '220382', '220382400', 's');
INSERT INTO `sys_data_region` VALUES (7635, '双辽经济开发区', 4, '220382', '220382402', 's');
INSERT INTO `sys_data_region` VALUES (7636, '辽源', 2, '22', '2204', 'l');
INSERT INTO `sys_data_region` VALUES (7637, '龙山', 3, '2204', '220402', 'l');
INSERT INTO `sys_data_region` VALUES (7638, '南康', 4, '220402', '220402001', 'n');
INSERT INTO `sys_data_region` VALUES (7639, '北寿', 4, '220402', '220402002', 'b');
INSERT INTO `sys_data_region` VALUES (7640, '东吉', 4, '220402', '220402003', 'd');
INSERT INTO `sys_data_region` VALUES (7641, '西宁', 4, '220402', '220402004', 'x');
INSERT INTO `sys_data_region` VALUES (7642, '站前', 4, '220402', '220402005', 'z');
INSERT INTO `sys_data_region` VALUES (7643, '新兴', 4, '220402', '220402006', 'x');
INSERT INTO `sys_data_region` VALUES (7644, '福镇', 4, '220402', '220402007', 'f');
INSERT INTO `sys_data_region` VALUES (7645, '向阳', 4, '220402', '220402008', 'x');
INSERT INTO `sys_data_region` VALUES (7646, '辽源经济开发区', 4, '220402', '220402070', 'l');
INSERT INTO `sys_data_region` VALUES (7647, '寿山', 4, '220402', '220402100', 's');
INSERT INTO `sys_data_region` VALUES (7648, '工农', 4, '220402', '220402200', 'g');
INSERT INTO `sys_data_region` VALUES (7649, '西安', 3, '2204', '220403', 'x');
INSERT INTO `sys_data_region` VALUES (7650, '仙城', 4, '220403', '220403001', 'x');
INSERT INTO `sys_data_region` VALUES (7651, '太安', 4, '220403', '220403002', 't');
INSERT INTO `sys_data_region` VALUES (7652, '东山', 4, '220403', '220403003', 'd');
INSERT INTO `sys_data_region` VALUES (7653, '安家', 4, '220403', '220403004', 'a');
INSERT INTO `sys_data_region` VALUES (7654, '先锋', 4, '220403', '220403005', 'x');
INSERT INTO `sys_data_region` VALUES (7655, '富国', 4, '220403', '220403006', 'f');
INSERT INTO `sys_data_region` VALUES (7656, '灯塔', 4, '220403', '220403100', 'd');
INSERT INTO `sys_data_region` VALUES (7657, '东丰', 3, '2204', '220421', 'd');
INSERT INTO `sys_data_region` VALUES (7658, '吉鹿', 4, '220421', '220421001', 'j');
INSERT INTO `sys_data_region` VALUES (7659, '祥鹿', 4, '220421', '220421002', 'x');
INSERT INTO `sys_data_region` VALUES (7660, '福鹿', 4, '220421', '220421003', 'f');
INSERT INTO `sys_data_region` VALUES (7661, '东丰镇', 4, '220421', '220421100', 'd');
INSERT INTO `sys_data_region` VALUES (7662, '大阳', 4, '220421', '220421101', 'd');
INSERT INTO `sys_data_region` VALUES (7663, '横道河', 4, '220421', '220421102', 'h');
INSERT INTO `sys_data_region` VALUES (7664, '那丹伯', 4, '220421', '220421103', 'n');
INSERT INTO `sys_data_region` VALUES (7665, '猴石', 4, '220421', '220421104', 'h');
INSERT INTO `sys_data_region` VALUES (7666, '杨木林', 4, '220421', '220421105', 'y');
INSERT INTO `sys_data_region` VALUES (7667, '小四平', 4, '220421', '220421106', 'x');
INSERT INTO `sys_data_region` VALUES (7668, '黄河', 4, '220421', '220421107', 'h');
INSERT INTO `sys_data_region` VALUES (7669, '拉拉河', 4, '220421', '220421108', 'l');
INSERT INTO `sys_data_region` VALUES (7670, '沙河', 4, '220421', '220421109', 's');
INSERT INTO `sys_data_region` VALUES (7671, '南屯基', 4, '220421', '220421110', 'n');
INSERT INTO `sys_data_region` VALUES (7672, '大兴', 4, '220421', '220421111', 'd');
INSERT INTO `sys_data_region` VALUES (7673, '三合', 4, '220421', '220421201', 's');
INSERT INTO `sys_data_region` VALUES (7674, '二龙山', 4, '220421', '220421207', 'e');
INSERT INTO `sys_data_region` VALUES (7675, '东辽', 3, '2204', '220422', 'd');
INSERT INTO `sys_data_region` VALUES (7676, '白泉', 4, '220422', '220422100', 'b');
INSERT INTO `sys_data_region` VALUES (7677, '渭津', 4, '220422', '220422101', 'w');
INSERT INTO `sys_data_region` VALUES (7678, '安石', 4, '220422', '220422102', 'a');
INSERT INTO `sys_data_region` VALUES (7679, '辽河源', 4, '220422', '220422103', 'l');
INSERT INTO `sys_data_region` VALUES (7680, '泉太', 4, '220422', '220422104', 'q');
INSERT INTO `sys_data_region` VALUES (7681, '建安', 4, '220422', '220422105', 'j');
INSERT INTO `sys_data_region` VALUES (7682, '安恕', 4, '220422', '220422106', 'a');
INSERT INTO `sys_data_region` VALUES (7683, '平岗', 4, '220422', '220422107', 'p');
INSERT INTO `sys_data_region` VALUES (7684, '云顶', 4, '220422', '220422111', 'y');
INSERT INTO `sys_data_region` VALUES (7685, '凌云', 4, '220422', '220422200', 'l');
INSERT INTO `sys_data_region` VALUES (7686, '甲山', 4, '220422', '220422201', 'j');
INSERT INTO `sys_data_region` VALUES (7687, '足民', 4, '220422', '220422202', 'z');
INSERT INTO `sys_data_region` VALUES (7688, '金州', 4, '220422', '220422204', 'j');
INSERT INTO `sys_data_region` VALUES (7689, '通化', 2, '22', '2205', 't');
INSERT INTO `sys_data_region` VALUES (7690, '东昌', 3, '2205', '220502', 'd');
INSERT INTO `sys_data_region` VALUES (7691, '东昌街道', 4, '220502', '220502001', 'd');
INSERT INTO `sys_data_region` VALUES (7692, '民主', 4, '220502', '220502002', 'm');
INSERT INTO `sys_data_region` VALUES (7693, '老站', 4, '220502', '220502003', 'l');
INSERT INTO `sys_data_region` VALUES (7694, '团结', 4, '220502', '220502004', 't');
INSERT INTO `sys_data_region` VALUES (7695, '新站', 4, '220502', '220502005', 'x');
INSERT INTO `sys_data_region` VALUES (7696, '光明', 4, '220502', '220502006', 'g');
INSERT INTO `sys_data_region` VALUES (7697, '龙泉', 4, '220502', '220502007', 'l');
INSERT INTO `sys_data_region` VALUES (7698, '金厂', 4, '220502', '220502100', 'j');
INSERT INTO `sys_data_region` VALUES (7699, '通化经济开发区', 4, '220502', '220502120', 't');
INSERT INTO `sys_data_region` VALUES (7700, '环通', 4, '220502', '220502200', 'h');
INSERT INTO `sys_data_region` VALUES (7701, '江东', 4, '220502', '220502201', 'j');
INSERT INTO `sys_data_region` VALUES (7702, '二道江', 3, '2205', '220503', 'e');
INSERT INTO `sys_data_region` VALUES (7703, '桃园', 4, '220503', '220503001', 't');
INSERT INTO `sys_data_region` VALUES (7704, '东通化', 4, '220503', '220503002', 'd');
INSERT INTO `sys_data_region` VALUES (7705, '鸭园', 4, '220503', '220503100', 'y');
INSERT INTO `sys_data_region` VALUES (7706, '铁厂', 4, '220503', '220503101', 't');
INSERT INTO `sys_data_region` VALUES (7707, '五道江', 4, '220503', '220503102', 'w');
INSERT INTO `sys_data_region` VALUES (7708, '二道江乡', 4, '220503', '220503200', 'e');
INSERT INTO `sys_data_region` VALUES (7709, '通化县', 3, '2205', '220521', 't');
INSERT INTO `sys_data_region` VALUES (7710, '快大茂', 4, '220521', '220521100', 'k');
INSERT INTO `sys_data_region` VALUES (7711, '二密', 4, '220521', '220521103', 'e');
INSERT INTO `sys_data_region` VALUES (7712, '果松', 4, '220521', '220521104', 'g');
INSERT INTO `sys_data_region` VALUES (7713, '石湖', 4, '220521', '220521105', 's');
INSERT INTO `sys_data_region` VALUES (7714, '大安', 4, '220521', '220521106', 'd');
INSERT INTO `sys_data_region` VALUES (7715, '光华', 4, '220521', '220521107', 'g');
INSERT INTO `sys_data_region` VALUES (7716, '兴林', 4, '220521', '220521108', 'x');
INSERT INTO `sys_data_region` VALUES (7717, '英额布', 4, '220521', '220521109', 'y');
INSERT INTO `sys_data_region` VALUES (7718, '三棵榆树', 4, '220521', '220521110', 's');
INSERT INTO `sys_data_region` VALUES (7719, '西江', 4, '220521', '220521111', 'x');
INSERT INTO `sys_data_region` VALUES (7720, '富江', 4, '220521', '220521202', 'f');
INSERT INTO `sys_data_region` VALUES (7721, '四棚', 4, '220521', '220521203', 's');
INSERT INTO `sys_data_region` VALUES (7722, '东来', 4, '220521', '220521205', 'd');
INSERT INTO `sys_data_region` VALUES (7723, '大泉源', 4, '220521', '220521207', 'd');
INSERT INTO `sys_data_region` VALUES (7724, '金斗', 4, '220521', '220521208', 'j');
INSERT INTO `sys_data_region` VALUES (7725, '辉南', 3, '2205', '220523', 'h');
INSERT INTO `sys_data_region` VALUES (7726, '朝阳', 4, '220523', '220523100', 'z');
INSERT INTO `sys_data_region` VALUES (7727, '辉南镇', 4, '220523', '220523101', 'h');
INSERT INTO `sys_data_region` VALUES (7728, '样子哨', 4, '220523', '220523102', 'y');
INSERT INTO `sys_data_region` VALUES (7729, '杉松岗', 4, '220523', '220523103', 's');
INSERT INTO `sys_data_region` VALUES (7730, '石道河', 4, '220523', '220523104', 's');
INSERT INTO `sys_data_region` VALUES (7731, '辉发城', 4, '220523', '220523105', 'h');
INSERT INTO `sys_data_region` VALUES (7732, '抚民', 4, '220523', '220523106', 'f');
INSERT INTO `sys_data_region` VALUES (7733, '金川', 4, '220523', '220523108', 'j');
INSERT INTO `sys_data_region` VALUES (7734, '团林', 4, '220523', '220523110', 't');
INSERT INTO `sys_data_region` VALUES (7735, '庆阳', 4, '220523', '220523111', 'q');
INSERT INTO `sys_data_region` VALUES (7736, '楼街', 4, '220523', '220523200', 'l');
INSERT INTO `sys_data_region` VALUES (7737, '柳河', 3, '2205', '220524', 'l');
INSERT INTO `sys_data_region` VALUES (7738, '柳河镇', 4, '220524', '220524100', 'l');
INSERT INTO `sys_data_region` VALUES (7739, '三源浦', 4, '220524', '220524101', 's');
INSERT INTO `sys_data_region` VALUES (7740, '五道沟', 4, '220524', '220524102', 'w');
INSERT INTO `sys_data_region` VALUES (7741, '驼腰岭', 4, '220524', '220524103', 't');
INSERT INTO `sys_data_region` VALUES (7742, '孤山子', 4, '220524', '220524104', 'g');
INSERT INTO `sys_data_region` VALUES (7743, '圣水河子', 4, '220524', '220524105', 's');
INSERT INTO `sys_data_region` VALUES (7744, '罗通山', 4, '220524', '220524106', 'l');
INSERT INTO `sys_data_region` VALUES (7745, '安口', 4, '220524', '220524107', 'a');
INSERT INTO `sys_data_region` VALUES (7746, '向阳', 4, '220524', '220524108', 'x');
INSERT INTO `sys_data_region` VALUES (7747, '红石', 4, '220524', '220524109', 'h');
INSERT INTO `sys_data_region` VALUES (7748, '凉水河子', 4, '220524', '220524110', 'l');
INSERT INTO `sys_data_region` VALUES (7749, '亨通', 4, '220524', '220524111', 'h');
INSERT INTO `sys_data_region` VALUES (7750, '柳南', 4, '220524', '220524201', 'l');
INSERT INTO `sys_data_region` VALUES (7751, '时家店', 4, '220524', '220524202', 's');
INSERT INTO `sys_data_region` VALUES (7752, '姜家店', 4, '220524', '220524203', 'j');
INSERT INTO `sys_data_region` VALUES (7753, '梅河口', 3, '2205', '220581', 'm');
INSERT INTO `sys_data_region` VALUES (7754, '新华', 4, '220581', '220581001', 'x');
INSERT INTO `sys_data_region` VALUES (7755, '和平', 4, '220581', '220581002', 'h');
INSERT INTO `sys_data_region` VALUES (7756, '光明', 4, '220581', '220581003', 'g');
INSERT INTO `sys_data_region` VALUES (7757, '解放', 4, '220581', '220581004', 'j');
INSERT INTO `sys_data_region` VALUES (7758, '福民', 4, '220581', '220581005', 'f');
INSERT INTO `sys_data_region` VALUES (7759, '山城', 4, '220581', '220581100', 's');
INSERT INTO `sys_data_region` VALUES (7760, '红梅', 4, '220581', '220581101', 'h');
INSERT INTO `sys_data_region` VALUES (7761, '海龙', 4, '220581', '220581102', 'h');
INSERT INTO `sys_data_region` VALUES (7762, '新合', 4, '220581', '220581103', 'x');
INSERT INTO `sys_data_region` VALUES (7763, '曙光', 4, '220581', '220581105', 's');
INSERT INTO `sys_data_region` VALUES (7764, '中和', 4, '220581', '220581106', 'z');
INSERT INTO `sys_data_region` VALUES (7765, '黑山头', 4, '220581', '220581107', 'h');
INSERT INTO `sys_data_region` VALUES (7766, '水道', 4, '220581', '220581108', 's');
INSERT INTO `sys_data_region` VALUES (7767, '进化', 4, '220581', '220581109', 'j');
INSERT INTO `sys_data_region` VALUES (7768, '一座营', 4, '220581', '220581110', 'y');
INSERT INTO `sys_data_region` VALUES (7769, '康大营', 4, '220581', '220581111', 'k');
INSERT INTO `sys_data_region` VALUES (7770, '牛心顶', 4, '220581', '220581112', 'n');
INSERT INTO `sys_data_region` VALUES (7771, '湾龙', 4, '220581', '220581113', 'w');
INSERT INTO `sys_data_region` VALUES (7772, '杏岭', 4, '220581', '220581114', 'x');
INSERT INTO `sys_data_region` VALUES (7773, '兴华', 4, '220581', '220581115', 'x');
INSERT INTO `sys_data_region` VALUES (7774, '双兴', 4, '220581', '220581116', 's');
INSERT INTO `sys_data_region` VALUES (7775, '李炉', 4, '220581', '220581203', 'l');
INSERT INTO `sys_data_region` VALUES (7776, '小杨', 4, '220581', '220581207', 'x');
INSERT INTO `sys_data_region` VALUES (7777, '吉乐', 4, '220581', '220581209', 'j');
INSERT INTO `sys_data_region` VALUES (7778, '集安', 3, '2205', '220582', 'j');
INSERT INTO `sys_data_region` VALUES (7779, '团结', 4, '220582', '220582001', 't');
INSERT INTO `sys_data_region` VALUES (7780, '黎明', 4, '220582', '220582002', 'l');
INSERT INTO `sys_data_region` VALUES (7781, '通胜', 4, '220582', '220582003', 't');
INSERT INTO `sys_data_region` VALUES (7782, '青石', 4, '220582', '220582100', 'q');
INSERT INTO `sys_data_region` VALUES (7783, '榆林', 4, '220582', '220582101', 'y');
INSERT INTO `sys_data_region` VALUES (7784, '花甸', 4, '220582', '220582102', 'h');
INSERT INTO `sys_data_region` VALUES (7785, '头道', 4, '220582', '220582103', 't');
INSERT INTO `sys_data_region` VALUES (7786, '清河', 4, '220582', '220582104', 'q');
INSERT INTO `sys_data_region` VALUES (7787, '台上', 4, '220582', '220582105', 't');
INSERT INTO `sys_data_region` VALUES (7788, '财源', 4, '220582', '220582106', 'c');
INSERT INTO `sys_data_region` VALUES (7789, '大路', 4, '220582', '220582107', 'd');
INSERT INTO `sys_data_region` VALUES (7790, '太王', 4, '220582', '220582108', 't');
INSERT INTO `sys_data_region` VALUES (7791, '麻线', 4, '220582', '220582200', 'm');
INSERT INTO `sys_data_region` VALUES (7792, '凉水', 4, '220582', '220582201', 'l');
INSERT INTO `sys_data_region` VALUES (7793, '白山', 2, '22', '2206', 'b');
INSERT INTO `sys_data_region` VALUES (7794, '浑江', 3, '2206', '220602', 'h');
INSERT INTO `sys_data_region` VALUES (7795, '新建', 4, '220602', '220602001', 'x');
INSERT INTO `sys_data_region` VALUES (7796, '通沟', 4, '220602', '220602002', 't');
INSERT INTO `sys_data_region` VALUES (7797, '东兴', 4, '220602', '220602003', 'd');
INSERT INTO `sys_data_region` VALUES (7798, '红旗', 4, '220602', '220602004', 'h');
INSERT INTO `sys_data_region` VALUES (7799, '河口', 4, '220602', '220602005', 'h');
INSERT INTO `sys_data_region` VALUES (7800, '板石', 4, '220602', '220602006', 'b');
INSERT INTO `sys_data_region` VALUES (7801, '江北', 4, '220602', '220602007', 'j');
INSERT INTO `sys_data_region` VALUES (7802, '城南', 4, '220602', '220602008', 'c');
INSERT INTO `sys_data_region` VALUES (7803, '六道江', 4, '220602', '220602101', 'l');
INSERT INTO `sys_data_region` VALUES (7804, '红土崖', 4, '220602', '220602102', 'h');
INSERT INTO `sys_data_region` VALUES (7805, '三道沟', 4, '220602', '220602103', 's');
INSERT INTO `sys_data_region` VALUES (7806, '七道江', 4, '220602', '220602104', 'q');
INSERT INTO `sys_data_region` VALUES (7807, '江源', 3, '2206', '220605', 'j');
INSERT INTO `sys_data_region` VALUES (7808, '孙家堡子', 4, '220605', '220605001', 's');
INSERT INTO `sys_data_region` VALUES (7809, '江源街道', 4, '220605', '220605002', 'j');
INSERT INTO `sys_data_region` VALUES (7810, '正岔', 4, '220605', '220605003', 'z');
INSERT INTO `sys_data_region` VALUES (7811, '城墙', 4, '220605', '220605004', 'c');
INSERT INTO `sys_data_region` VALUES (7812, '湾沟', 4, '220605', '220605102', 'w');
INSERT INTO `sys_data_region` VALUES (7813, '松树', 4, '220605', '220605103', 's');
INSERT INTO `sys_data_region` VALUES (7814, '砟子', 4, '220605', '220605104', 'z');
INSERT INTO `sys_data_region` VALUES (7815, '石人', 4, '220605', '220605105', 's');
INSERT INTO `sys_data_region` VALUES (7816, '大阳岔', 4, '220605', '220605106', 'd');
INSERT INTO `sys_data_region` VALUES (7817, '大石人', 4, '220605', '220605107', 'd');
INSERT INTO `sys_data_region` VALUES (7818, '抚松', 3, '2206', '220621', 'f');
INSERT INTO `sys_data_region` VALUES (7819, '抚松镇', 4, '220621', '220621100', 'f');
INSERT INTO `sys_data_region` VALUES (7820, '松江河', 4, '220621', '220621101', 's');
INSERT INTO `sys_data_region` VALUES (7821, '泉阳', 4, '220621', '220621102', 'q');
INSERT INTO `sys_data_region` VALUES (7822, '露水河', 4, '220621', '220621103', 'l');
INSERT INTO `sys_data_region` VALUES (7823, '仙人桥', 4, '220621', '220621104', 'x');
INSERT INTO `sys_data_region` VALUES (7824, '万良', 4, '220621', '220621105', 'w');
INSERT INTO `sys_data_region` VALUES (7825, '新屯子', 4, '220621', '220621106', 'x');
INSERT INTO `sys_data_region` VALUES (7826, '东岗', 4, '220621', '220621107', 'd');
INSERT INTO `sys_data_region` VALUES (7827, '漫江', 4, '220621', '220621108', 'm');
INSERT INTO `sys_data_region` VALUES (7828, '北岗', 4, '220621', '220621109', 'b');
INSERT INTO `sys_data_region` VALUES (7829, '兴参', 4, '220621', '220621110', 'x');
INSERT INTO `sys_data_region` VALUES (7830, '长白山保护开发区管委会池西区', 4, '220621', '220621120', 'c');
INSERT INTO `sys_data_region` VALUES (7831, '长白山保护开发区管委会池南区', 4, '220621', '220621121', 'c');
INSERT INTO `sys_data_region` VALUES (7832, '兴隆', 4, '220621', '220621202', 'x');
INSERT INTO `sys_data_region` VALUES (7833, '抽水', 4, '220621', '220621203', 'c');
INSERT INTO `sys_data_region` VALUES (7834, '沿江', 4, '220621', '220621205', 'y');
INSERT INTO `sys_data_region` VALUES (7835, '靖宇', 3, '2206', '220622', 'j');
INSERT INTO `sys_data_region` VALUES (7836, '靖宇镇', 4, '220622', '220622100', 'j');
INSERT INTO `sys_data_region` VALUES (7837, '三道湖', 4, '220622', '220622101', 's');
INSERT INTO `sys_data_region` VALUES (7838, '龙泉', 4, '220622', '220622102', 'l');
INSERT INTO `sys_data_region` VALUES (7839, '那尔轰', 4, '220622', '220622103', 'n');
INSERT INTO `sys_data_region` VALUES (7840, '花园口', 4, '220622', '220622104', 'h');
INSERT INTO `sys_data_region` VALUES (7841, '景山', 4, '220622', '220622105', 'j');
INSERT INTO `sys_data_region` VALUES (7842, '赤松', 4, '220622', '220622106', 'c');
INSERT INTO `sys_data_region` VALUES (7843, '濛江', 4, '220622', '220622203', 'm');
INSERT INTO `sys_data_region` VALUES (7844, '长白', 3, '2206', '220623', 'c');
INSERT INTO `sys_data_region` VALUES (7845, '长白镇', 4, '220623', '220623100', 'c');
INSERT INTO `sys_data_region` VALUES (7846, '八道沟', 4, '220623', '220623101', 'b');
INSERT INTO `sys_data_region` VALUES (7847, '十四道沟', 4, '220623', '220623102', 's');
INSERT INTO `sys_data_region` VALUES (7848, '马鹿沟', 4, '220623', '220623103', 'm');
INSERT INTO `sys_data_region` VALUES (7849, '宝泉山', 4, '220623', '220623104', 'b');
INSERT INTO `sys_data_region` VALUES (7850, '新房子', 4, '220623', '220623105', 'x');
INSERT INTO `sys_data_region` VALUES (7851, '十二道沟', 4, '220623', '220623106', 's');
INSERT INTO `sys_data_region` VALUES (7852, '金华', 4, '220623', '220623200', 'j');
INSERT INTO `sys_data_region` VALUES (7853, '临江', 3, '2206', '220681', 'l');
INSERT INTO `sys_data_region` VALUES (7854, '建国', 4, '220681', '220681001', 'j');
INSERT INTO `sys_data_region` VALUES (7855, '新市', 4, '220681', '220681002', 'x');
INSERT INTO `sys_data_region` VALUES (7856, '兴隆', 4, '220681', '220681003', 'x');
INSERT INTO `sys_data_region` VALUES (7857, '大湖', 4, '220681', '220681004', 'd');
INSERT INTO `sys_data_region` VALUES (7858, '森工', 4, '220681', '220681005', 's');
INSERT INTO `sys_data_region` VALUES (7859, '大栗子', 4, '220681', '220681006', 'd');
INSERT INTO `sys_data_region` VALUES (7860, '桦树', 4, '220681', '220681101', 'h');
INSERT INTO `sys_data_region` VALUES (7861, '六道沟', 4, '220681', '220681102', 'l');
INSERT INTO `sys_data_region` VALUES (7862, '苇沙河', 4, '220681', '220681103', 'w');
INSERT INTO `sys_data_region` VALUES (7863, '花山', 4, '220681', '220681104', 'h');
INSERT INTO `sys_data_region` VALUES (7864, '闹枝', 4, '220681', '220681105', 'n');
INSERT INTO `sys_data_region` VALUES (7865, '四道沟', 4, '220681', '220681106', 's');
INSERT INTO `sys_data_region` VALUES (7866, '蚂蚁河', 4, '220681', '220681200', 'm');
INSERT INTO `sys_data_region` VALUES (7867, '松原', 2, '22', '2207', 's');
INSERT INTO `sys_data_region` VALUES (7868, '宁江', 3, '2207', '220702', 'n');
INSERT INTO `sys_data_region` VALUES (7869, '团结', 4, '220702', '220702001', 't');
INSERT INTO `sys_data_region` VALUES (7870, '文化', 4, '220702', '220702002', 'w');
INSERT INTO `sys_data_region` VALUES (7871, '民主', 4, '220702', '220702003', 'm');
INSERT INTO `sys_data_region` VALUES (7872, '临江', 4, '220702', '220702004', 'l');
INSERT INTO `sys_data_region` VALUES (7873, '新区', 4, '220702', '220702005', 'x');
INSERT INTO `sys_data_region` VALUES (7874, '前进', 4, '220702', '220702006', 'q');
INSERT INTO `sys_data_region` VALUES (7875, '和平', 4, '220702', '220702007', 'h');
INSERT INTO `sys_data_region` VALUES (7876, '工农', 4, '220702', '220702008', 'g');
INSERT INTO `sys_data_region` VALUES (7877, '沿江', 4, '220702', '220702009', 'y');
INSERT INTO `sys_data_region` VALUES (7878, '铁西', 4, '220702', '220702010', 't');
INSERT INTO `sys_data_region` VALUES (7879, '繁荣', 4, '220702', '220702011', 'f');
INSERT INTO `sys_data_region` VALUES (7880, '建设', 4, '220702', '220702012', 'j');
INSERT INTO `sys_data_region` VALUES (7881, '石化', 4, '220702', '220702013', 's');
INSERT INTO `sys_data_region` VALUES (7882, '伯都讷', 4, '220702', '220702014', 'b');
INSERT INTO `sys_data_region` VALUES (7883, '长宁', 4, '220702', '220702015', 'c');
INSERT INTO `sys_data_region` VALUES (7884, '镜湖', 4, '220702', '220702016', 'j');
INSERT INTO `sys_data_region` VALUES (7885, '滨江', 4, '220702', '220702017', 'b');
INSERT INTO `sys_data_region` VALUES (7886, '大洼', 4, '220702', '220702100', 'd');
INSERT INTO `sys_data_region` VALUES (7887, '善友', 4, '220702', '220702102', 's');
INSERT INTO `sys_data_region` VALUES (7888, '毛都站', 4, '220702', '220702103', 'm');
INSERT INTO `sys_data_region` VALUES (7889, '哈达山', 4, '220702', '220702104', 'h');
INSERT INTO `sys_data_region` VALUES (7890, '新城', 4, '220702', '220702200', 'x');
INSERT INTO `sys_data_region` VALUES (7891, '伯都', 4, '220702', '220702202', 'b');
INSERT INTO `sys_data_region` VALUES (7892, '兴原', 4, '220702', '220702204', 'x');
INSERT INTO `sys_data_region` VALUES (7893, '前郭尔罗斯', 3, '2207', '220721', 'q');
INSERT INTO `sys_data_region` VALUES (7894, '前郭尔罗斯镇', 4, '220721', '220721100', 'q');
INSERT INTO `sys_data_region` VALUES (7895, '长山', 4, '220721', '220721102', 'c');
INSERT INTO `sys_data_region` VALUES (7896, '海勃日戈', 4, '220721', '220721103', 'h');
INSERT INTO `sys_data_region` VALUES (7897, '乌兰图嘎', 4, '220721', '220721104', 'w');
INSERT INTO `sys_data_region` VALUES (7898, '查干花', 4, '220721', '220721105', 'c');
INSERT INTO `sys_data_region` VALUES (7899, '王府站', 4, '220721', '220721106', 'w');
INSERT INTO `sys_data_region` VALUES (7900, '八郎', 4, '220721', '220721107', 'b');
INSERT INTO `sys_data_region` VALUES (7901, '哈拉毛都', 4, '220721', '220721108', 'h');
INSERT INTO `sys_data_region` VALUES (7902, '查干湖', 4, '220721', '220721109', 'c');
INSERT INTO `sys_data_region` VALUES (7903, '宝甸', 4, '220721', '220721200', 'b');
INSERT INTO `sys_data_region` VALUES (7904, '平凤', 4, '220721', '220721201', 'p');
INSERT INTO `sys_data_region` VALUES (7905, '达里巴', 4, '220721', '220721205', 'd');
INSERT INTO `sys_data_region` VALUES (7906, '吉拉吐', 4, '220721', '220721206', 'j');
INSERT INTO `sys_data_region` VALUES (7907, '白依拉嘎', 4, '220721', '220721207', 'b');
INSERT INTO `sys_data_region` VALUES (7908, '洪泉', 4, '220721', '220721208', 'h');
INSERT INTO `sys_data_region` VALUES (7909, '额如', 4, '220721', '220721209', 'e');
INSERT INTO `sys_data_region` VALUES (7910, '套浩太', 4, '220721', '220721210', 't');
INSERT INTO `sys_data_region` VALUES (7911, '长龙', 4, '220721', '220721211', 'c');
INSERT INTO `sys_data_region` VALUES (7912, '乌兰塔拉', 4, '220721', '220721212', 'w');
INSERT INTO `sys_data_region` VALUES (7913, '东三家子', 4, '220721', '220721213', 'd');
INSERT INTO `sys_data_region` VALUES (7914, '浩特芒哈', 4, '220721', '220721214', 'h');
INSERT INTO `sys_data_region` VALUES (7915, '乌兰敖都', 4, '220721', '220721215', 'w');
INSERT INTO `sys_data_region` VALUES (7916, '长岭', 3, '2207', '220722', 'c');
INSERT INTO `sys_data_region` VALUES (7917, '长岭镇', 4, '220722', '220722100', 'c');
INSERT INTO `sys_data_region` VALUES (7918, '太平川', 4, '220722', '220722101', 't');
INSERT INTO `sys_data_region` VALUES (7919, '巨宝山', 4, '220722', '220722102', 'j');
INSERT INTO `sys_data_region` VALUES (7920, '太平山', 4, '220722', '220722103', 't');
INSERT INTO `sys_data_region` VALUES (7921, '前七号', 4, '220722', '220722104', 'q');
INSERT INTO `sys_data_region` VALUES (7922, '新安', 4, '220722', '220722105', 'x');
INSERT INTO `sys_data_region` VALUES (7923, '三青山', 4, '220722', '220722106', 's');
INSERT INTO `sys_data_region` VALUES (7924, '大兴', 4, '220722', '220722107', 'd');
INSERT INTO `sys_data_region` VALUES (7925, '北正', 4, '220722', '220722108', 'b');
INSERT INTO `sys_data_region` VALUES (7926, '流水', 4, '220722', '220722109', 'l');
INSERT INTO `sys_data_region` VALUES (7927, '永久', 4, '220722', '220722110', 'y');
INSERT INTO `sys_data_region` VALUES (7928, '利发盛', 4, '220722', '220722111', 'l');
INSERT INTO `sys_data_region` VALUES (7929, '太平川农业园区', 4, '220722', '220722120', 't');
INSERT INTO `sys_data_region` VALUES (7930, '双龙工业园区', 4, '220722', '220722122', 's');
INSERT INTO `sys_data_region` VALUES (7931, '长岭经济开发区', 4, '220722', '220722123', 'c');
INSERT INTO `sys_data_region` VALUES (7932, '集体', 4, '220722', '220722202', 'j');
INSERT INTO `sys_data_region` VALUES (7933, '光明', 4, '220722', '220722203', 'g');
INSERT INTO `sys_data_region` VALUES (7934, '三县堡', 4, '220722', '220722204', 's');
INSERT INTO `sys_data_region` VALUES (7935, '海青', 4, '220722', '220722205', 'h');
INSERT INTO `sys_data_region` VALUES (7936, '前进', 4, '220722', '220722206', 'q');
INSERT INTO `sys_data_region` VALUES (7937, '东岭', 4, '220722', '220722207', 'd');
INSERT INTO `sys_data_region` VALUES (7938, '腰坨子', 4, '220722', '220722209', 'y');
INSERT INTO `sys_data_region` VALUES (7939, '八十八', 4, '220722', '220722210', 'b');
INSERT INTO `sys_data_region` VALUES (7940, '三团', 4, '220722', '220722213', 's');
INSERT INTO `sys_data_region` VALUES (7941, '三十号', 4, '220722', '220722214', 's');
INSERT INTO `sys_data_region` VALUES (7942, '乾安', 3, '2207', '220723', 'q');
INSERT INTO `sys_data_region` VALUES (7943, '乾安镇', 4, '220723', '220723100', 'q');
INSERT INTO `sys_data_region` VALUES (7944, '大布苏', 4, '220723', '220723101', 'd');
INSERT INTO `sys_data_region` VALUES (7945, '水字', 4, '220723', '220723102', 's');
INSERT INTO `sys_data_region` VALUES (7946, '让字', 4, '220723', '220723103', 'r');
INSERT INTO `sys_data_region` VALUES (7947, '所字', 4, '220723', '220723104', 's');
INSERT INTO `sys_data_region` VALUES (7948, '安字', 4, '220723', '220723105', 'a');
INSERT INTO `sys_data_region` VALUES (7949, '余字', 4, '220723', '220723200', 'y');
INSERT INTO `sys_data_region` VALUES (7950, '道字', 4, '220723', '220723203', 'd');
INSERT INTO `sys_data_region` VALUES (7951, '严字', 4, '220723', '220723206', 'y');
INSERT INTO `sys_data_region` VALUES (7952, '赞字', 4, '220723', '220723207', 'z');
INSERT INTO `sys_data_region` VALUES (7953, '扶余', 3, '2207', '220781', 'f');
INSERT INTO `sys_data_region` VALUES (7954, '三岔河', 4, '220781', '220781100', 's');
INSERT INTO `sys_data_region` VALUES (7955, '长春岭', 4, '220781', '220781101', 'c');
INSERT INTO `sys_data_region` VALUES (7956, '五家站', 4, '220781', '220781102', 'w');
INSERT INTO `sys_data_region` VALUES (7957, '陶赖昭', 4, '220781', '220781103', 't');
INSERT INTO `sys_data_region` VALUES (7958, '蔡家沟', 4, '220781', '220781104', 'c');
INSERT INTO `sys_data_region` VALUES (7959, '弓棚子', 4, '220781', '220781105', 'g');
INSERT INTO `sys_data_region` VALUES (7960, '三井子', 4, '220781', '220781106', 's');
INSERT INTO `sys_data_region` VALUES (7961, '增盛', 4, '220781', '220781107', 'z');
INSERT INTO `sys_data_region` VALUES (7962, '新万发', 4, '220781', '220781108', 'x');
INSERT INTO `sys_data_region` VALUES (7963, '大林子', 4, '220781', '220781109', 'd');
INSERT INTO `sys_data_region` VALUES (7964, '新源', 4, '220781', '220781110', 'x');
INSERT INTO `sys_data_region` VALUES (7965, '得胜', 4, '220781', '220781111', 'd');
INSERT INTO `sys_data_region` VALUES (7966, '三骏', 4, '220781', '220781200', 's');
INSERT INTO `sys_data_region` VALUES (7967, '永平', 4, '220781', '220781201', 'y');
INSERT INTO `sys_data_region` VALUES (7968, '新站', 4, '220781', '220781202', 'x');
INSERT INTO `sys_data_region` VALUES (7969, '更新', 4, '220781', '220781203', 'g');
INSERT INTO `sys_data_region` VALUES (7970, '肖家', 4, '220781', '220781204', 'x');
INSERT INTO `sys_data_region` VALUES (7971, '白城', 2, '22', '2208', 'b');
INSERT INTO `sys_data_region` VALUES (7972, '洮北', 3, '2208', '220802', 't');
INSERT INTO `sys_data_region` VALUES (7973, '海明', 4, '220802', '220802001', 'h');
INSERT INTO `sys_data_region` VALUES (7974, '长庆', 4, '220802', '220802002', 'c');
INSERT INTO `sys_data_region` VALUES (7975, '瑞光', 4, '220802', '220802003', 'r');
INSERT INTO `sys_data_region` VALUES (7976, '明仁', 4, '220802', '220802004', 'm');
INSERT INTO `sys_data_region` VALUES (7977, '铁东', 4, '220802', '220802005', 't');
INSERT INTO `sys_data_region` VALUES (7978, '城南', 4, '220802', '220802006', 'c');
INSERT INTO `sys_data_region` VALUES (7979, '新立', 4, '220802', '220802007', 'x');
INSERT INTO `sys_data_region` VALUES (7980, '幸福', 4, '220802', '220802008', 'x');
INSERT INTO `sys_data_region` VALUES (7981, '新华', 4, '220802', '220802009', 'x');
INSERT INTO `sys_data_region` VALUES (7982, '保平', 4, '220802', '220802010', 'b');
INSERT INTO `sys_data_region` VALUES (7983, '西郊', 4, '220802', '220802011', 'x');
INSERT INTO `sys_data_region` VALUES (7984, '岭下', 4, '220802', '220802100', 'l');
INSERT INTO `sys_data_region` VALUES (7985, '平安', 4, '220802', '220802101', 'p');
INSERT INTO `sys_data_region` VALUES (7986, '青山', 4, '220802', '220802102', 'q');
INSERT INTO `sys_data_region` VALUES (7987, '林海', 4, '220802', '220802103', 'l');
INSERT INTO `sys_data_region` VALUES (7988, '洮河', 4, '220802', '220802104', 't');
INSERT INTO `sys_data_region` VALUES (7989, '平台', 4, '220802', '220802105', 'p');
INSERT INTO `sys_data_region` VALUES (7990, '到保', 4, '220802', '220802106', 'd');
INSERT INTO `sys_data_region` VALUES (7991, '东风', 4, '220802', '220802201', 'd');
INSERT INTO `sys_data_region` VALUES (7992, '三合', 4, '220802', '220802202', 's');
INSERT INTO `sys_data_region` VALUES (7993, '金祥', 4, '220802', '220802204', 'j');
INSERT INTO `sys_data_region` VALUES (7994, '东胜', 4, '220802', '220802205', 'd');
INSERT INTO `sys_data_region` VALUES (7995, '德顺', 4, '220802', '220802206', 'd');
INSERT INTO `sys_data_region` VALUES (7996, '洮儿河农场', 4, '220802', '220802404', 't');
INSERT INTO `sys_data_region` VALUES (7997, '镇赉', 3, '2208', '220821', 'z');
INSERT INTO `sys_data_region` VALUES (7998, '镇赉镇', 4, '220821', '220821100', 'z');
INSERT INTO `sys_data_region` VALUES (7999, '坦途', 4, '220821', '220821101', 't');
INSERT INTO `sys_data_region` VALUES (8000, '东屏', 4, '220821', '220821102', 'd');
INSERT INTO `sys_data_region` VALUES (8001, '大屯', 4, '220821', '220821103', 'd');
INSERT INTO `sys_data_region` VALUES (8002, '沿江', 4, '220821', '220821105', 'y');
INSERT INTO `sys_data_region` VALUES (8003, '五棵树', 4, '220821', '220821106', 'w');
INSERT INTO `sys_data_region` VALUES (8004, '黑鱼泡', 4, '220821', '220821107', 'h');
INSERT INTO `sys_data_region` VALUES (8005, '哈吐气', 4, '220821', '220821201', 'h');
INSERT INTO `sys_data_region` VALUES (8006, '莫莫格', 4, '220821', '220821203', 'm');
INSERT INTO `sys_data_region` VALUES (8007, '建平', 4, '220821', '220821205', 'j');
INSERT INTO `sys_data_region` VALUES (8008, '嘎什根', 4, '220821', '220821206', 'g');
INSERT INTO `sys_data_region` VALUES (8009, '四方坨子农场', 4, '220821', '220821400', 's');
INSERT INTO `sys_data_region` VALUES (8010, '白音套海牧场', 4, '220821', '220821401', 'b');
INSERT INTO `sys_data_region` VALUES (8011, '莫莫格林场', 4, '220821', '220821404', 'm');
INSERT INTO `sys_data_region` VALUES (8012, '通榆', 3, '2208', '220822', 't');
INSERT INTO `sys_data_region` VALUES (8013, '开通', 4, '220822', '220822100', 'k');
INSERT INTO `sys_data_region` VALUES (8014, '瞻榆', 4, '220822', '220822101', 'z');
INSERT INTO `sys_data_region` VALUES (8015, '双岗', 4, '220822', '220822102', 's');
INSERT INTO `sys_data_region` VALUES (8016, '兴隆山', 4, '220822', '220822103', 'x');
INSERT INTO `sys_data_region` VALUES (8017, '边昭', 4, '220822', '220822104', 'b');
INSERT INTO `sys_data_region` VALUES (8018, '鸿兴', 4, '220822', '220822105', 'h');
INSERT INTO `sys_data_region` VALUES (8019, '新华', 4, '220822', '220822107', 'x');
INSERT INTO `sys_data_region` VALUES (8020, '乌兰花', 4, '220822', '220822108', 'w');
INSERT INTO `sys_data_region` VALUES (8021, '新发', 4, '220822', '220822201', 'x');
INSERT INTO `sys_data_region` VALUES (8022, '新兴', 4, '220822', '220822202', 'x');
INSERT INTO `sys_data_region` VALUES (8023, '向海', 4, '220822', '220822204', 'x');
INSERT INTO `sys_data_region` VALUES (8024, '包拉温都', 4, '220822', '220822205', 'b');
INSERT INTO `sys_data_region` VALUES (8025, '团结', 4, '220822', '220822206', 't');
INSERT INTO `sys_data_region` VALUES (8026, '什花道', 4, '220822', '220822207', 's');
INSERT INTO `sys_data_region` VALUES (8027, '八面', 4, '220822', '220822208', 'b');
INSERT INTO `sys_data_region` VALUES (8028, '苏公坨', 4, '220822', '220822209', 's');
INSERT INTO `sys_data_region` VALUES (8029, '通榆经济开发区', 4, '220822', '220822400', 't');
INSERT INTO `sys_data_region` VALUES (8030, '三家子种牛场', 4, '220822', '220822401', 's');
INSERT INTO `sys_data_region` VALUES (8031, '良井子畜牧场', 4, '220822', '220822402', 'l');
INSERT INTO `sys_data_region` VALUES (8032, '双岗鹿场', 4, '220822', '220822403', 's');
INSERT INTO `sys_data_region` VALUES (8033, '同发牧场', 4, '220822', '220822404', 't');
INSERT INTO `sys_data_region` VALUES (8034, '新华牛场', 4, '220822', '220822405', 'x');
INSERT INTO `sys_data_region` VALUES (8035, '洮南', 3, '2208', '220881', 't');
INSERT INTO `sys_data_region` VALUES (8036, '团结', 4, '220881', '220881001', 't');
INSERT INTO `sys_data_region` VALUES (8037, '富文', 4, '220881', '220881002', 'f');
INSERT INTO `sys_data_region` VALUES (8038, '光明', 4, '220881', '220881003', 'g');
INSERT INTO `sys_data_region` VALUES (8039, '兴隆', 4, '220881', '220881004', 'x');
INSERT INTO `sys_data_region` VALUES (8040, '永康', 4, '220881', '220881005', 'y');
INSERT INTO `sys_data_region` VALUES (8041, '通达', 4, '220881', '220881006', 't');
INSERT INTO `sys_data_region` VALUES (8042, '向阳', 4, '220881', '220881007', 'x');
INSERT INTO `sys_data_region` VALUES (8043, '洮府', 4, '220881', '220881008', 't');
INSERT INTO `sys_data_region` VALUES (8044, '瓦房', 4, '220881', '220881100', 'w');
INSERT INTO `sys_data_region` VALUES (8045, '万宝镇', 4, '220881', '220881101', 'w');
INSERT INTO `sys_data_region` VALUES (8046, '黑水', 4, '220881', '220881102', 'h');
INSERT INTO `sys_data_region` VALUES (8047, '那金', 4, '220881', '220881103', 'n');
INSERT INTO `sys_data_region` VALUES (8048, '安定', 4, '220881', '220881104', 'a');
INSERT INTO `sys_data_region` VALUES (8049, '福顺', 4, '220881', '220881105', 'f');
INSERT INTO `sys_data_region` VALUES (8050, '胡力吐', 4, '220881', '220881200', 'h');
INSERT INTO `sys_data_region` VALUES (8051, '万宝乡', 4, '220881', '220881201', 'w');
INSERT INTO `sys_data_region` VALUES (8052, '聚宝', 4, '220881', '220881202', 'j');
INSERT INTO `sys_data_region` VALUES (8053, '东升', 4, '220881', '220881204', 'd');
INSERT INTO `sys_data_region` VALUES (8054, '野马', 4, '220881', '220881205', 'y');
INSERT INTO `sys_data_region` VALUES (8055, '永茂', 4, '220881', '220881206', 'y');
INSERT INTO `sys_data_region` VALUES (8056, '蛟流河', 4, '220881', '220881208', 'j');
INSERT INTO `sys_data_region` VALUES (8057, '大通', 4, '220881', '220881209', 'd');
INSERT INTO `sys_data_region` VALUES (8058, '二龙', 4, '220881', '220881212', 'e');
INSERT INTO `sys_data_region` VALUES (8059, '呼和车力', 4, '220881', '220881214', 'h');
INSERT INTO `sys_data_region` VALUES (8060, '东方红畜牧场', 4, '220881', '220881400', 'd');
INSERT INTO `sys_data_region` VALUES (8061, '永茂林场', 4, '220881', '220881401', 'y');
INSERT INTO `sys_data_region` VALUES (8062, '大安', 3, '2208', '220882', 'd');
INSERT INTO `sys_data_region` VALUES (8063, '慧阳', 4, '220882', '220882001', 'h');
INSERT INTO `sys_data_region` VALUES (8064, '临江', 4, '220882', '220882002', 'l');
INSERT INTO `sys_data_region` VALUES (8065, '长虹', 4, '220882', '220882003', 'c');
INSERT INTO `sys_data_region` VALUES (8066, '锦华', 4, '220882', '220882004', 'j');
INSERT INTO `sys_data_region` VALUES (8067, '安北', 4, '220882', '220882005', 'a');
INSERT INTO `sys_data_region` VALUES (8068, '月亮泡', 4, '220882', '220882100', 'y');
INSERT INTO `sys_data_region` VALUES (8069, '安广', 4, '220882', '220882101', 'a');
INSERT INTO `sys_data_region` VALUES (8070, '丰收', 4, '220882', '220882102', 'f');
INSERT INTO `sys_data_region` VALUES (8071, '新平安', 4, '220882', '220882103', 'x');
INSERT INTO `sys_data_region` VALUES (8072, '两家子', 4, '220882', '220882104', 'l');
INSERT INTO `sys_data_region` VALUES (8073, '舍力', 4, '220882', '220882105', 's');
INSERT INTO `sys_data_region` VALUES (8074, '大岗子', 4, '220882', '220882106', 'd');
INSERT INTO `sys_data_region` VALUES (8075, '叉干', 4, '220882', '220882107', 'c');
INSERT INTO `sys_data_region` VALUES (8076, '龙沼', 4, '220882', '220882108', 'l');
INSERT INTO `sys_data_region` VALUES (8077, '太山', 4, '220882', '220882109', 't');
INSERT INTO `sys_data_region` VALUES (8078, '四棵树', 4, '220882', '220882200', 's');
INSERT INTO `sys_data_region` VALUES (8079, '联合', 4, '220882', '220882201', 'l');
INSERT INTO `sys_data_region` VALUES (8080, '乐胜', 4, '220882', '220882203', 'l');
INSERT INTO `sys_data_region` VALUES (8081, '大赉', 4, '220882', '220882204', 'd');
INSERT INTO `sys_data_region` VALUES (8082, '红岗子', 4, '220882', '220882205', 'h');
INSERT INTO `sys_data_region` VALUES (8083, '烧锅镇', 4, '220882', '220882208', 's');
INSERT INTO `sys_data_region` VALUES (8084, '海坨', 4, '220882', '220882210', 'h');
INSERT INTO `sys_data_region` VALUES (8085, '新艾里', 4, '220882', '220882211', 'x');
INSERT INTO `sys_data_region` VALUES (8086, '舍力林场', 4, '220882', '220882403', 's');
INSERT INTO `sys_data_region` VALUES (8087, '五间房水库', 4, '220882', '220882404', 'w');
INSERT INTO `sys_data_region` VALUES (8088, '大岗子林场', 4, '220882', '220882405', 'd');
INSERT INTO `sys_data_region` VALUES (8089, '风水山牧场', 4, '220882', '220882406', 'f');
INSERT INTO `sys_data_region` VALUES (8090, '东风马场', 4, '220882', '220882407', 'd');
INSERT INTO `sys_data_region` VALUES (8091, '大安马场', 4, '220882', '220882409', 'd');
INSERT INTO `sys_data_region` VALUES (8092, '红旗饲养场', 4, '220882', '220882411', 'h');
INSERT INTO `sys_data_region` VALUES (8093, '延边', 2, '22', '2224', 'y');
INSERT INTO `sys_data_region` VALUES (8094, '延吉', 3, '2224', '222401', 'y');
INSERT INTO `sys_data_region` VALUES (8095, '进学', 4, '222401', '222401001', 'j');
INSERT INTO `sys_data_region` VALUES (8096, '北山', 4, '222401', '222401002', 'b');
INSERT INTO `sys_data_region` VALUES (8097, '新兴', 4, '222401', '222401003', 'x');
INSERT INTO `sys_data_region` VALUES (8098, '公园', 4, '222401', '222401004', 'g');
INSERT INTO `sys_data_region` VALUES (8099, '河南', 4, '222401', '222401005', 'h');
INSERT INTO `sys_data_region` VALUES (8100, '建工', 4, '222401', '222401006', 'j');
INSERT INTO `sys_data_region` VALUES (8101, '小营', 4, '222401', '222401100', 'x');
INSERT INTO `sys_data_region` VALUES (8102, '依兰', 4, '222401', '222401101', 'y');
INSERT INTO `sys_data_region` VALUES (8103, '三道湾', 4, '222401', '222401102', 's');
INSERT INTO `sys_data_region` VALUES (8104, '朝阳川', 4, '222401', '222401103', 'z');
INSERT INTO `sys_data_region` VALUES (8105, '图们', 3, '2224', '222402', 't');
INSERT INTO `sys_data_region` VALUES (8106, '向上', 4, '222402', '222402001', 'x');
INSERT INTO `sys_data_region` VALUES (8107, '新华', 4, '222402', '222402002', 'x');
INSERT INTO `sys_data_region` VALUES (8108, '月宫', 4, '222402', '222402003', 'y');
INSERT INTO `sys_data_region` VALUES (8109, '月晴', 4, '222402', '222402100', 'y');
INSERT INTO `sys_data_region` VALUES (8110, '石岘', 4, '222402', '222402101', 's');
INSERT INTO `sys_data_region` VALUES (8111, '长安', 4, '222402', '222402102', 'c');
INSERT INTO `sys_data_region` VALUES (8112, '凉水', 4, '222402', '222402103', 'l');
INSERT INTO `sys_data_region` VALUES (8113, '敦化', 3, '2224', '222403', 'd');
INSERT INTO `sys_data_region` VALUES (8114, '渤海', 4, '222403', '222403001', 'b');
INSERT INTO `sys_data_region` VALUES (8115, '胜利', 4, '222403', '222403002', 's');
INSERT INTO `sys_data_region` VALUES (8116, '民主', 4, '222403', '222403003', 'm');
INSERT INTO `sys_data_region` VALUES (8117, '丹江', 4, '222403', '222403004', 'd');
INSERT INTO `sys_data_region` VALUES (8118, '大石头', 4, '222403', '222403100', 'd');
INSERT INTO `sys_data_region` VALUES (8119, '黄泥河', 4, '222403', '222403101', 'h');
INSERT INTO `sys_data_region` VALUES (8120, '官地', 4, '222403', '222403102', 'g');
INSERT INTO `sys_data_region` VALUES (8121, '沙河沿', 4, '222403', '222403103', 's');
INSERT INTO `sys_data_region` VALUES (8122, '秋梨沟', 4, '222403', '222403104', 'q');
INSERT INTO `sys_data_region` VALUES (8123, '额穆', 4, '222403', '222403105', 'e');
INSERT INTO `sys_data_region` VALUES (8124, '贤儒', 4, '222403', '222403106', 'x');
INSERT INTO `sys_data_region` VALUES (8125, '大蒲柴河', 4, '222403', '222403107', 'd');
INSERT INTO `sys_data_region` VALUES (8126, '雁鸣湖', 4, '222403', '222403108', 'y');
INSERT INTO `sys_data_region` VALUES (8127, '江源', 4, '222403', '222403109', 'j');
INSERT INTO `sys_data_region` VALUES (8128, '江南', 4, '222403', '222403110', 'j');
INSERT INTO `sys_data_region` VALUES (8129, '大桥', 4, '222403', '222403200', 'd');
INSERT INTO `sys_data_region` VALUES (8130, '黑石', 4, '222403', '222403201', 'h');
INSERT INTO `sys_data_region` VALUES (8131, '青沟子', 4, '222403', '222403202', 'q');
INSERT INTO `sys_data_region` VALUES (8132, '翰章', 4, '222403', '222403203', 'h');
INSERT INTO `sys_data_region` VALUES (8133, '红石', 4, '222403', '222403204', 'h');
INSERT INTO `sys_data_region` VALUES (8134, '珲春', 3, '2224', '222404', 'h');
INSERT INTO `sys_data_region` VALUES (8135, '靖和', 4, '222404', '222404001', 'j');
INSERT INTO `sys_data_region` VALUES (8136, '新安', 4, '222404', '222404002', 'x');
INSERT INTO `sys_data_region` VALUES (8137, '河南', 4, '222404', '222404003', 'h');
INSERT INTO `sys_data_region` VALUES (8138, '近海', 4, '222404', '222404004', 'j');
INSERT INTO `sys_data_region` VALUES (8139, '春化', 4, '222404', '222404100', 'c');
INSERT INTO `sys_data_region` VALUES (8140, '敬信', 4, '222404', '222404101', 'j');
INSERT INTO `sys_data_region` VALUES (8141, '板石', 4, '222404', '222404102', 'b');
INSERT INTO `sys_data_region` VALUES (8142, '英安', 4, '222404', '222404103', 'y');
INSERT INTO `sys_data_region` VALUES (8143, '马川子', 4, '222404', '222404200', 'm');
INSERT INTO `sys_data_region` VALUES (8144, '杨泡', 4, '222404', '222404201', 'y');
INSERT INTO `sys_data_region` VALUES (8145, '三家子', 4, '222404', '222404202', 's');
INSERT INTO `sys_data_region` VALUES (8146, '密江', 4, '222404', '222404203', 'm');
INSERT INTO `sys_data_region` VALUES (8147, '哈达门', 4, '222404', '222404204', 'h');
INSERT INTO `sys_data_region` VALUES (8148, '龙井', 3, '2224', '222405', 'l');
INSERT INTO `sys_data_region` VALUES (8149, '安民', 4, '222405', '222405001', 'a');
INSERT INTO `sys_data_region` VALUES (8150, '龙门', 4, '222405', '222405002', 'l');
INSERT INTO `sys_data_region` VALUES (8151, '开山屯', 4, '222405', '222405100', 'k');
INSERT INTO `sys_data_region` VALUES (8152, '老头沟', 4, '222405', '222405102', 'l');
INSERT INTO `sys_data_region` VALUES (8153, '三合', 4, '222405', '222405103', 's');
INSERT INTO `sys_data_region` VALUES (8154, '东盛涌', 4, '222405', '222405104', 'd');
INSERT INTO `sys_data_region` VALUES (8155, '智新', 4, '222405', '222405105', 'z');
INSERT INTO `sys_data_region` VALUES (8156, '德新', 4, '222405', '222405200', 'd');
INSERT INTO `sys_data_region` VALUES (8157, '白金', 4, '222405', '222405201', 'b');
INSERT INTO `sys_data_region` VALUES (8158, '龙井大苏果树农场', 4, '222405', '222405401', 'l');
INSERT INTO `sys_data_region` VALUES (8159, '和龙', 3, '2224', '222406', 'h');
INSERT INTO `sys_data_region` VALUES (8160, '民惠', 4, '222406', '222406001', 'm');
INSERT INTO `sys_data_region` VALUES (8161, '光明', 4, '222406', '222406002', 'g');
INSERT INTO `sys_data_region` VALUES (8162, '文化', 4, '222406', '222406003', 'w');
INSERT INTO `sys_data_region` VALUES (8163, '八家子', 4, '222406', '222406100', 'b');
INSERT INTO `sys_data_region` VALUES (8164, '福洞', 4, '222406', '222406101', 'f');
INSERT INTO `sys_data_region` VALUES (8165, '头道', 4, '222406', '222406102', 't');
INSERT INTO `sys_data_region` VALUES (8166, '西城', 4, '222406', '222406103', 'x');
INSERT INTO `sys_data_region` VALUES (8167, '南坪', 4, '222406', '222406104', 'n');
INSERT INTO `sys_data_region` VALUES (8168, '东城', 4, '222406', '222406105', 'd');
INSERT INTO `sys_data_region` VALUES (8169, '崇善', 4, '222406', '222406106', 'c');
INSERT INTO `sys_data_region` VALUES (8170, '龙城', 4, '222406', '222406108', 'l');
INSERT INTO `sys_data_region` VALUES (8171, '汪清', 3, '2224', '222424', 'w');
INSERT INTO `sys_data_region` VALUES (8172, '大兴沟', 4, '222424', '222424101', 'd');
INSERT INTO `sys_data_region` VALUES (8173, '天桥岭', 4, '222424', '222424102', 't');
INSERT INTO `sys_data_region` VALUES (8174, '罗子沟', 4, '222424', '222424103', 'l');
INSERT INTO `sys_data_region` VALUES (8175, '百草沟', 4, '222424', '222424104', 'b');
INSERT INTO `sys_data_region` VALUES (8176, '春阳', 4, '222424', '222424105', 'c');
INSERT INTO `sys_data_region` VALUES (8177, '复兴', 4, '222424', '222424106', 'f');
INSERT INTO `sys_data_region` VALUES (8178, '东光', 4, '222424', '222424107', 'd');
INSERT INTO `sys_data_region` VALUES (8179, '汪清镇', 4, '222424', '222424109', 'w');
INSERT INTO `sys_data_region` VALUES (8180, '鸡冠', 4, '222424', '222424202', 'j');
INSERT INTO `sys_data_region` VALUES (8181, '安图', 3, '2224', '222426', 'a');
INSERT INTO `sys_data_region` VALUES (8182, '明月', 4, '222426', '222426100', 'm');
INSERT INTO `sys_data_region` VALUES (8183, '松江', 4, '222426', '222426101', 's');
INSERT INTO `sys_data_region` VALUES (8184, '二道白河', 4, '222426', '222426102', 'e');
INSERT INTO `sys_data_region` VALUES (8185, '两江', 4, '222426', '222426103', 'l');
INSERT INTO `sys_data_region` VALUES (8186, '石门', 4, '222426', '222426104', 's');
INSERT INTO `sys_data_region` VALUES (8187, '万宝', 4, '222426', '222426105', 'w');
INSERT INTO `sys_data_region` VALUES (8188, '亮兵', 4, '222426', '222426106', 'l');
INSERT INTO `sys_data_region` VALUES (8189, '长白山保护开发区管委会池北区', 4, '222426', '222426120', 'c');
INSERT INTO `sys_data_region` VALUES (8190, '新合', 4, '222426', '222426201', 'x');
INSERT INTO `sys_data_region` VALUES (8191, '永庆', 4, '222426', '222426202', 'y');
INSERT INTO `sys_data_region` VALUES (8192, '黑龙江', 1, '0', '23', 'h');
INSERT INTO `sys_data_region` VALUES (8193, '哈尔滨', 2, '23', '2301', 'h');
INSERT INTO `sys_data_region` VALUES (8194, '道里', 3, '2301', '230102', 'd');
INSERT INTO `sys_data_region` VALUES (8195, '兆麟', 4, '230102', '230102001', 'z');
INSERT INTO `sys_data_region` VALUES (8196, '新阳路', 4, '230102', '230102002', 'x');
INSERT INTO `sys_data_region` VALUES (8197, '抚顺', 4, '230102', '230102003', 'f');
INSERT INTO `sys_data_region` VALUES (8198, '共乐', 4, '230102', '230102004', 'g');
INSERT INTO `sys_data_region` VALUES (8199, '新华', 4, '230102', '230102005', 'x');
INSERT INTO `sys_data_region` VALUES (8200, '城乡路', 4, '230102', '230102006', 'c');
INSERT INTO `sys_data_region` VALUES (8201, '工农', 4, '230102', '230102007', 'g');
INSERT INTO `sys_data_region` VALUES (8202, '尚志', 4, '230102', '230102008', 's');
INSERT INTO `sys_data_region` VALUES (8203, '斯大林', 4, '230102', '230102009', 's');
INSERT INTO `sys_data_region` VALUES (8204, '通江', 4, '230102', '230102010', 't');
INSERT INTO `sys_data_region` VALUES (8205, '经纬', 4, '230102', '230102011', 'j');
INSERT INTO `sys_data_region` VALUES (8206, '工程', 4, '230102', '230102012', 'g');
INSERT INTO `sys_data_region` VALUES (8207, '安静', 4, '230102', '230102013', 'a');
INSERT INTO `sys_data_region` VALUES (8208, '安和', 4, '230102', '230102014', 'a');
INSERT INTO `sys_data_region` VALUES (8209, '正阳河', 4, '230102', '230102015', 'z');
INSERT INTO `sys_data_region` VALUES (8210, '建国', 4, '230102', '230102016', 'j');
INSERT INTO `sys_data_region` VALUES (8211, '康安', 4, '230102', '230102017', 'k');
INSERT INTO `sys_data_region` VALUES (8212, '爱建', 4, '230102', '230102018', 'a');
INSERT INTO `sys_data_region` VALUES (8213, '群力', 4, '230102', '230102019', 'q');
INSERT INTO `sys_data_region` VALUES (8214, '太平', 4, '230102', '230102101', 't');
INSERT INTO `sys_data_region` VALUES (8215, '新发', 4, '230102', '230102102', 'x');
INSERT INTO `sys_data_region` VALUES (8216, '新农', 4, '230102', '230102103', 'x');
INSERT INTO `sys_data_region` VALUES (8217, '榆树', 4, '230102', '230102104', 'y');
INSERT INTO `sys_data_region` VALUES (8218, '闫家岗农场', 4, '230102', '230102500', 'y');
INSERT INTO `sys_data_region` VALUES (8219, '南岗', 3, '2301', '230103', 'n');
INSERT INTO `sys_data_region` VALUES (8220, '花园', 4, '230103', '230103001', 'h');
INSERT INTO `sys_data_region` VALUES (8221, '奋斗路', 4, '230103', '230103002', 'f');
INSERT INTO `sys_data_region` VALUES (8222, '革新', 4, '230103', '230103003', 'g');
INSERT INTO `sys_data_region` VALUES (8223, '文化', 4, '230103', '230103004', 'w');
INSERT INTO `sys_data_region` VALUES (8224, '大成', 4, '230103', '230103005', 'd');
INSERT INTO `sys_data_region` VALUES (8225, '芦家', 4, '230103', '230103006', 'l');
INSERT INTO `sys_data_region` VALUES (8226, '荣市', 4, '230103', '230103007', 'r');
INSERT INTO `sys_data_region` VALUES (8227, '燎原', 4, '230103', '230103009', 'l');
INSERT INTO `sys_data_region` VALUES (8228, '松花江', 4, '230103', '230103010', 's');
INSERT INTO `sys_data_region` VALUES (8229, '曲线', 4, '230103', '230103011', 'q');
INSERT INTO `sys_data_region` VALUES (8230, '通达', 4, '230103', '230103012', 't');
INSERT INTO `sys_data_region` VALUES (8231, '七政', 4, '230103', '230103013', 'q');
INSERT INTO `sys_data_region` VALUES (8232, '和兴路', 4, '230103', '230103015', 'h');
INSERT INTO `sys_data_region` VALUES (8233, '哈西', 4, '230103', '230103016', 'h');
INSERT INTO `sys_data_region` VALUES (8234, '保健路', 4, '230103', '230103017', 'b');
INSERT INTO `sys_data_region` VALUES (8235, '先锋路', 4, '230103', '230103018', 'x');
INSERT INTO `sys_data_region` VALUES (8236, '新春', 4, '230103', '230103019', 'x');
INSERT INTO `sys_data_region` VALUES (8237, '跃进', 4, '230103', '230103020', 'y');
INSERT INTO `sys_data_region` VALUES (8238, '王岗', 4, '230103', '230103101', 'w');
INSERT INTO `sys_data_region` VALUES (8239, '红旗', 4, '230103', '230103201', 'h');
INSERT INTO `sys_data_region` VALUES (8240, '道外', 3, '2301', '230104', 'd');
INSERT INTO `sys_data_region` VALUES (8241, '靖宇', 4, '230104', '230104001', 'j');
INSERT INTO `sys_data_region` VALUES (8242, '太古', 4, '230104', '230104002', 't');
INSERT INTO `sys_data_region` VALUES (8243, '东莱', 4, '230104', '230104003', 'd');
INSERT INTO `sys_data_region` VALUES (8244, '滨江', 4, '230104', '230104004', 'b');
INSERT INTO `sys_data_region` VALUES (8245, '仁里', 4, '230104', '230104005', 'r');
INSERT INTO `sys_data_region` VALUES (8246, '崇俭', 4, '230104', '230104007', 'c');
INSERT INTO `sys_data_region` VALUES (8247, '振江', 4, '230104', '230104008', 'z');
INSERT INTO `sys_data_region` VALUES (8248, '东原', 4, '230104', '230104009', 'd');
INSERT INTO `sys_data_region` VALUES (8249, '大兴', 4, '230104', '230104010', 'd');
INSERT INTO `sys_data_region` VALUES (8250, '胜利', 4, '230104', '230104011', 's');
INSERT INTO `sys_data_region` VALUES (8251, '南马', 4, '230104', '230104012', 'n');
INSERT INTO `sys_data_region` VALUES (8252, '民强', 4, '230104', '230104021', 'm');
INSERT INTO `sys_data_region` VALUES (8253, '大有坊', 4, '230104', '230104022', 'd');
INSERT INTO `sys_data_region` VALUES (8254, '南直路', 4, '230104', '230104023', 'n');
INSERT INTO `sys_data_region` VALUES (8255, '化工', 4, '230104', '230104024', 'h');
INSERT INTO `sys_data_region` VALUES (8256, '火车头', 4, '230104', '230104025', 'h');
INSERT INTO `sys_data_region` VALUES (8257, '新一', 4, '230104', '230104026', 'x');
INSERT INTO `sys_data_region` VALUES (8258, '三棵树大街', 4, '230104', '230104027', 's');
INSERT INTO `sys_data_region` VALUES (8259, '水泥路', 4, '230104', '230104028', 's');
INSERT INTO `sys_data_region` VALUES (8260, '太平大街', 4, '230104', '230104029', 't');
INSERT INTO `sys_data_region` VALUES (8261, '黎华', 4, '230104', '230104030', 'l');
INSERT INTO `sys_data_region` VALUES (8262, '新乐', 4, '230104', '230104031', 'x');
INSERT INTO `sys_data_region` VALUES (8263, '南市', 4, '230104', '230104033', 'n');
INSERT INTO `sys_data_region` VALUES (8264, '团结', 4, '230104', '230104111', 't');
INSERT INTO `sys_data_region` VALUES (8265, '永源', 4, '230104', '230104112', 'y');
INSERT INTO `sys_data_region` VALUES (8266, '巨源', 4, '230104', '230104113', 'j');
INSERT INTO `sys_data_region` VALUES (8267, '民主', 4, '230104', '230104114', 'm');
INSERT INTO `sys_data_region` VALUES (8268, '青年农场', 4, '230104', '230104500', 'q');
INSERT INTO `sys_data_region` VALUES (8269, '平房', 3, '2301', '230108', 'p');
INSERT INTO `sys_data_region` VALUES (8270, '兴建', 4, '230108', '230108001', 'x');
INSERT INTO `sys_data_region` VALUES (8271, '保国', 4, '230108', '230108002', 'b');
INSERT INTO `sys_data_region` VALUES (8272, '联盟', 4, '230108', '230108003', 'l');
INSERT INTO `sys_data_region` VALUES (8273, '友协', 4, '230108', '230108004', 'y');
INSERT INTO `sys_data_region` VALUES (8274, '新疆', 4, '230108', '230108005', 'x');
INSERT INTO `sys_data_region` VALUES (8275, '新伟', 4, '230108', '230108006', 'x');
INSERT INTO `sys_data_region` VALUES (8276, '平新', 4, '230108', '230108007', 'p');
INSERT INTO `sys_data_region` VALUES (8277, '平盛', 4, '230108', '230108008', 'p');
INSERT INTO `sys_data_region` VALUES (8278, '建安', 4, '230108', '230108009', 'j');
INSERT INTO `sys_data_region` VALUES (8279, '平房镇', 4, '230108', '230108101', 'p');
INSERT INTO `sys_data_region` VALUES (8280, '松北', 3, '2301', '230109', 's');
INSERT INTO `sys_data_region` VALUES (8281, '三电', 4, '230109', '230109001', 's');
INSERT INTO `sys_data_region` VALUES (8282, '太阳岛', 4, '230109', '230109002', 't');
INSERT INTO `sys_data_region` VALUES (8283, '松浦', 4, '230109', '230109003', 's');
INSERT INTO `sys_data_region` VALUES (8284, '万宝', 4, '230109', '230109004', 'w');
INSERT INTO `sys_data_region` VALUES (8285, '松北街道', 4, '230109', '230109005', 's');
INSERT INTO `sys_data_region` VALUES (8286, '松安', 4, '230109', '230109006', 's');
INSERT INTO `sys_data_region` VALUES (8287, '松祥', 4, '230109', '230109007', 's');
INSERT INTO `sys_data_region` VALUES (8288, '船口', 4, '230109', '230109008', 'c');
INSERT INTO `sys_data_region` VALUES (8289, '对青山', 4, '230109', '230109101', 'd');
INSERT INTO `sys_data_region` VALUES (8290, '乐业', 4, '230109', '230109102', 'l');
INSERT INTO `sys_data_region` VALUES (8291, '香坊', 3, '2301', '230110', 'x');
INSERT INTO `sys_data_region` VALUES (8292, '香坊大街', 4, '230110', '230110001', 'x');
INSERT INTO `sys_data_region` VALUES (8293, '安埠', 4, '230110', '230110002', 'a');
INSERT INTO `sys_data_region` VALUES (8294, '通天', 4, '230110', '230110003', 't');
INSERT INTO `sys_data_region` VALUES (8295, '新香坊', 4, '230110', '230110004', 'x');
INSERT INTO `sys_data_region` VALUES (8296, '铁东', 4, '230110', '230110005', 't');
INSERT INTO `sys_data_region` VALUES (8297, '新成', 4, '230110', '230110006', 'x');
INSERT INTO `sys_data_region` VALUES (8298, '红旗', 4, '230110', '230110007', 'h');
INSERT INTO `sys_data_region` VALUES (8299, '六顺', 4, '230110', '230110008', 'l');
INSERT INTO `sys_data_region` VALUES (8300, '建筑', 4, '230110', '230110009', 'j');
INSERT INTO `sys_data_region` VALUES (8301, '哈平路', 4, '230110', '230110010', 'h');
INSERT INTO `sys_data_region` VALUES (8302, '安乐', 4, '230110', '230110011', 'a');
INSERT INTO `sys_data_region` VALUES (8303, '健康路', 4, '230110', '230110012', 'j');
INSERT INTO `sys_data_region` VALUES (8304, '大庆路', 4, '230110', '230110013', 'd');
INSERT INTO `sys_data_region` VALUES (8305, '进乡', 4, '230110', '230110014', 'j');
INSERT INTO `sys_data_region` VALUES (8306, '通乡', 4, '230110', '230110015', 't');
INSERT INTO `sys_data_region` VALUES (8307, '和平路', 4, '230110', '230110016', 'h');
INSERT INTO `sys_data_region` VALUES (8308, '民生路', 4, '230110', '230110017', 'm');
INSERT INTO `sys_data_region` VALUES (8309, '文政', 4, '230110', '230110018', 'w');
INSERT INTO `sys_data_region` VALUES (8310, '王兆', 4, '230110', '230110019', 'w');
INSERT INTO `sys_data_region` VALUES (8311, '黎明', 4, '230110', '230110020', 'l');
INSERT INTO `sys_data_region` VALUES (8312, '成高子', 4, '230110', '230110101', 'c');
INSERT INTO `sys_data_region` VALUES (8313, '朝阳', 4, '230110', '230110102', 'z');
INSERT INTO `sys_data_region` VALUES (8314, '幸福', 4, '230110', '230110103', 'x');
INSERT INTO `sys_data_region` VALUES (8315, '向阳', 4, '230110', '230110104', 'x');
INSERT INTO `sys_data_region` VALUES (8316, '香坊实验农场', 4, '230110', '230110500', 'x');
INSERT INTO `sys_data_region` VALUES (8317, '呼兰', 3, '2301', '230111', 'h');
INSERT INTO `sys_data_region` VALUES (8318, '呼兰街道', 4, '230111', '230111001', 'h');
INSERT INTO `sys_data_region` VALUES (8319, '兰河', 4, '230111', '230111002', 'l');
INSERT INTO `sys_data_region` VALUES (8320, '腰堡', 4, '230111', '230111003', 'y');
INSERT INTO `sys_data_region` VALUES (8321, '利民', 4, '230111', '230111004', 'l');
INSERT INTO `sys_data_region` VALUES (8322, '康金', 4, '230111', '230111005', 'k');
INSERT INTO `sys_data_region` VALUES (8323, '双井', 4, '230111', '230111006', 's');
INSERT INTO `sys_data_region` VALUES (8324, '建设路', 4, '230111', '230111007', 'j');
INSERT INTO `sys_data_region` VALUES (8325, '学院路', 4, '230111', '230111008', 'x');
INSERT INTO `sys_data_region` VALUES (8326, '长岭', 4, '230111', '230111009', 'c');
INSERT INTO `sys_data_region` VALUES (8327, '沈家', 4, '230111', '230111010', 's');
INSERT INTO `sys_data_region` VALUES (8328, '南京路', 4, '230111', '230111011', 'n');
INSERT INTO `sys_data_region` VALUES (8329, '裕民', 4, '230111', '230111012', 'y');
INSERT INTO `sys_data_region` VALUES (8330, '裕田', 4, '230111', '230111013', 'y');
INSERT INTO `sys_data_region` VALUES (8331, '裕强', 4, '230111', '230111014', 'y');
INSERT INTO `sys_data_region` VALUES (8332, '萧乡', 4, '230111', '230111015', 'x');
INSERT INTO `sys_data_region` VALUES (8333, '公园路', 4, '230111', '230111016', 'g');
INSERT INTO `sys_data_region` VALUES (8334, '利业', 4, '230111', '230111017', 'l');
INSERT INTO `sys_data_region` VALUES (8335, '二八', 4, '230111', '230111105', 'e');
INSERT INTO `sys_data_region` VALUES (8336, '石人', 4, '230111', '230111106', 's');
INSERT INTO `sys_data_region` VALUES (8337, '白奎', 4, '230111', '230111107', 'b');
INSERT INTO `sys_data_region` VALUES (8338, '方台', 4, '230111', '230111109', 'f');
INSERT INTO `sys_data_region` VALUES (8339, '莲花', 4, '230111', '230111110', 'l');
INSERT INTO `sys_data_region` VALUES (8340, '大用', 4, '230111', '230111111', 'd');
INSERT INTO `sys_data_region` VALUES (8341, '杨林', 4, '230111', '230111201', 'y');
INSERT INTO `sys_data_region` VALUES (8342, '许堡', 4, '230111', '230111203', 'x');
INSERT INTO `sys_data_region` VALUES (8343, '孟家', 4, '230111', '230111205', 'm');
INSERT INTO `sys_data_region` VALUES (8344, '呼兰农垦', 4, '230111', '230111579', 'h');
INSERT INTO `sys_data_region` VALUES (8345, '阿城', 3, '2301', '230112', 'a');
INSERT INTO `sys_data_region` VALUES (8346, '金城', 4, '230112', '230112001', 'j');
INSERT INTO `sys_data_region` VALUES (8347, '金都', 4, '230112', '230112002', 'j');
INSERT INTO `sys_data_region` VALUES (8348, '通城', 4, '230112', '230112003', 't');
INSERT INTO `sys_data_region` VALUES (8349, '河东', 4, '230112', '230112004', 'h');
INSERT INTO `sys_data_region` VALUES (8350, '阿什河', 4, '230112', '230112005', 'a');
INSERT INTO `sys_data_region` VALUES (8351, '玉泉', 4, '230112', '230112006', 'y');
INSERT INTO `sys_data_region` VALUES (8352, '新利', 4, '230112', '230112007', 'x');
INSERT INTO `sys_data_region` VALUES (8353, '舍利', 4, '230112', '230112008', 's');
INSERT INTO `sys_data_region` VALUES (8354, '双丰', 4, '230112', '230112009', 's');
INSERT INTO `sys_data_region` VALUES (8355, '小岭', 4, '230112', '230112010', 'x');
INSERT INTO `sys_data_region` VALUES (8356, '亚沟', 4, '230112', '230112011', 'y');
INSERT INTO `sys_data_region` VALUES (8357, '交界', 4, '230112', '230112012', 'j');
INSERT INTO `sys_data_region` VALUES (8358, '蜚克图', 4, '230112', '230112013', 'f');
INSERT INTO `sys_data_region` VALUES (8359, '杨树', 4, '230112', '230112014', 'y');
INSERT INTO `sys_data_region` VALUES (8360, '料甸', 4, '230112', '230112015', 'l');
INSERT INTO `sys_data_region` VALUES (8361, '平山', 4, '230112', '230112107', 'p');
INSERT INTO `sys_data_region` VALUES (8362, '松峰山', 4, '230112', '230112108', 's');
INSERT INTO `sys_data_region` VALUES (8363, '红星', 4, '230112', '230112109', 'h');
INSERT INTO `sys_data_region` VALUES (8364, '金龙山', 4, '230112', '230112110', 'j');
INSERT INTO `sys_data_region` VALUES (8365, '双城', 3, '2301', '230113', 's');
INSERT INTO `sys_data_region` VALUES (8366, '五家', 4, '230113', '230113001', 'w');
INSERT INTO `sys_data_region` VALUES (8367, '新兴', 4, '230113', '230113002', 'x');
INSERT INTO `sys_data_region` VALUES (8368, '兰棱', 4, '230113', '230113003', 'l');
INSERT INTO `sys_data_region` VALUES (8369, '周家', 4, '230113', '230113004', 'z');
INSERT INTO `sys_data_region` VALUES (8370, '公正', 4, '230113', '230113005', 'g');
INSERT INTO `sys_data_region` VALUES (8371, '承旭', 4, '230113', '230113006', 'c');
INSERT INTO `sys_data_region` VALUES (8372, '承恩', 4, '230113', '230113007', 'c');
INSERT INTO `sys_data_region` VALUES (8373, '永治', 4, '230113', '230113008', 'y');
INSERT INTO `sys_data_region` VALUES (8374, '永和', 4, '230113', '230113009', 'y');
INSERT INTO `sys_data_region` VALUES (8375, '幸福', 4, '230113', '230113010', 'x');
INSERT INTO `sys_data_region` VALUES (8376, '韩甸', 4, '230113', '230113104', 'h');
INSERT INTO `sys_data_region` VALUES (8377, '单城', 4, '230113', '230113105', 'd');
INSERT INTO `sys_data_region` VALUES (8378, '东官', 4, '230113', '230113106', 'd');
INSERT INTO `sys_data_region` VALUES (8379, '农丰', 4, '230113', '230113107', 'n');
INSERT INTO `sys_data_region` VALUES (8380, '杏山', 4, '230113', '230113108', 'x');
INSERT INTO `sys_data_region` VALUES (8381, '西官', 4, '230113', '230113110', 'x');
INSERT INTO `sys_data_region` VALUES (8382, '联兴', 4, '230113', '230113112', 'l');
INSERT INTO `sys_data_region` VALUES (8383, '永胜', 4, '230113', '230113113', 'y');
INSERT INTO `sys_data_region` VALUES (8384, '胜丰', 4, '230113', '230113114', 's');
INSERT INTO `sys_data_region` VALUES (8385, '金城', 4, '230113', '230113201', 'j');
INSERT INTO `sys_data_region` VALUES (8386, '青岭', 4, '230113', '230113202', 'q');
INSERT INTO `sys_data_region` VALUES (8387, '临江', 4, '230113', '230113206', 'l');
INSERT INTO `sys_data_region` VALUES (8388, '水泉', 4, '230113', '230113207', 's');
INSERT INTO `sys_data_region` VALUES (8389, '乐群', 4, '230113', '230113208', 'l');
INSERT INTO `sys_data_region` VALUES (8390, '万隆', 4, '230113', '230113209', 'w');
INSERT INTO `sys_data_region` VALUES (8391, '希勤', 4, '230113', '230113210', 'x');
INSERT INTO `sys_data_region` VALUES (8392, '同心', 4, '230113', '230113211', 't');
INSERT INTO `sys_data_region` VALUES (8393, '依兰', 3, '2301', '230123', 'y');
INSERT INTO `sys_data_region` VALUES (8394, '依兰镇', 4, '230123', '230123100', 'y');
INSERT INTO `sys_data_region` VALUES (8395, '达连河', 4, '230123', '230123101', 'd');
INSERT INTO `sys_data_region` VALUES (8396, '江湾', 4, '230123', '230123102', 'j');
INSERT INTO `sys_data_region` VALUES (8397, '三道岗', 4, '230123', '230123103', 's');
INSERT INTO `sys_data_region` VALUES (8398, '道台桥', 4, '230123', '230123104', 'd');
INSERT INTO `sys_data_region` VALUES (8399, '宏克力', 4, '230123', '230123105', 'h');
INSERT INTO `sys_data_region` VALUES (8400, '团山子', 4, '230123', '230123205', 't');
INSERT INTO `sys_data_region` VALUES (8401, '愚公', 4, '230123', '230123206', 'y');
INSERT INTO `sys_data_region` VALUES (8402, '迎兰', 4, '230123', '230123210', 'y');
INSERT INTO `sys_data_region` VALUES (8403, '依兰县林业局', 4, '230123', '230123400', 'y');
INSERT INTO `sys_data_region` VALUES (8404, '松花江农场', 4, '230123', '230123501', 's');
INSERT INTO `sys_data_region` VALUES (8405, '方正', 3, '2301', '230124', 'f');
INSERT INTO `sys_data_region` VALUES (8406, '方正镇', 4, '230124', '230124100', 'f');
INSERT INTO `sys_data_region` VALUES (8407, '会发', 4, '230124', '230124101', 'h');
INSERT INTO `sys_data_region` VALUES (8408, '大罗密', 4, '230124', '230124102', 'd');
INSERT INTO `sys_data_region` VALUES (8409, '得莫利', 4, '230124', '230124103', 'd');
INSERT INTO `sys_data_region` VALUES (8410, '天门', 4, '230124', '230124200', 't');
INSERT INTO `sys_data_region` VALUES (8411, '松南', 4, '230124', '230124201', 's');
INSERT INTO `sys_data_region` VALUES (8412, '德善', 4, '230124', '230124202', 'd');
INSERT INTO `sys_data_region` VALUES (8413, '宝兴', 4, '230124', '230124204', 'b');
INSERT INTO `sys_data_region` VALUES (8414, '方正林业局', 4, '230124', '230124400', 'f');
INSERT INTO `sys_data_region` VALUES (8415, '沙河农场', 4, '230124', '230124500', 's');
INSERT INTO `sys_data_region` VALUES (8416, '宾县', 3, '2301', '230125', 'b');
INSERT INTO `sys_data_region` VALUES (8417, '宾州', 4, '230125', '230125100', 'b');
INSERT INTO `sys_data_region` VALUES (8418, '居仁', 4, '230125', '230125101', 'j');
INSERT INTO `sys_data_region` VALUES (8419, '宾西', 4, '230125', '230125102', 'b');
INSERT INTO `sys_data_region` VALUES (8420, '糖坊', 4, '230125', '230125103', 't');
INSERT INTO `sys_data_region` VALUES (8421, '宾安', 4, '230125', '230125104', 'b');
INSERT INTO `sys_data_region` VALUES (8422, '新甸', 4, '230125', '230125105', 'x');
INSERT INTO `sys_data_region` VALUES (8423, '胜利', 4, '230125', '230125106', 's');
INSERT INTO `sys_data_region` VALUES (8424, '宁远', 4, '230125', '230125107', 'n');
INSERT INTO `sys_data_region` VALUES (8425, '摆渡', 4, '230125', '230125109', 'b');
INSERT INTO `sys_data_region` VALUES (8426, '平坊', 4, '230125', '230125110', 'p');
INSERT INTO `sys_data_region` VALUES (8427, '满井', 4, '230125', '230125111', 'm');
INSERT INTO `sys_data_region` VALUES (8428, '常安', 4, '230125', '230125112', 'c');
INSERT INTO `sys_data_region` VALUES (8429, '永和', 4, '230125', '230125201', 'y');
INSERT INTO `sys_data_region` VALUES (8430, '鸟河', 4, '230125', '230125203', 'n');
INSERT INTO `sys_data_region` VALUES (8431, '民和', 4, '230125', '230125204', 'm');
INSERT INTO `sys_data_region` VALUES (8432, '经建', 4, '230125', '230125205', 'j');
INSERT INTO `sys_data_region` VALUES (8433, '三宝', 4, '230125', '230125210', 's');
INSERT INTO `sys_data_region` VALUES (8434, '巴彦', 3, '2301', '230126', 'b');
INSERT INTO `sys_data_region` VALUES (8435, '巴彦镇', 4, '230126', '230126100', 'b');
INSERT INTO `sys_data_region` VALUES (8436, '兴隆', 4, '230126', '230126101', 'x');
INSERT INTO `sys_data_region` VALUES (8437, '西集', 4, '230126', '230126102', 'x');
INSERT INTO `sys_data_region` VALUES (8438, '洼兴', 4, '230126', '230126103', 'w');
INSERT INTO `sys_data_region` VALUES (8439, '龙泉', 4, '230126', '230126104', 'l');
INSERT INTO `sys_data_region` VALUES (8440, '巴彦港', 4, '230126', '230126105', 'b');
INSERT INTO `sys_data_region` VALUES (8441, '龙庙', 4, '230126', '230126106', 'l');
INSERT INTO `sys_data_region` VALUES (8442, '万发', 4, '230126', '230126107', 'w');
INSERT INTO `sys_data_region` VALUES (8443, '天增', 4, '230126', '230126108', 't');
INSERT INTO `sys_data_region` VALUES (8444, '黑山', 4, '230126', '230126110', 'h');
INSERT INTO `sys_data_region` VALUES (8445, '松花江', 4, '230126', '230126200', 's');
INSERT INTO `sys_data_region` VALUES (8446, '富江', 4, '230126', '230126202', 'f');
INSERT INTO `sys_data_region` VALUES (8447, '华山', 4, '230126', '230126204', 'h');
INSERT INTO `sys_data_region` VALUES (8448, '丰乐', 4, '230126', '230126205', 'f');
INSERT INTO `sys_data_region` VALUES (8449, '德祥', 4, '230126', '230126209', 'd');
INSERT INTO `sys_data_region` VALUES (8450, '红光', 4, '230126', '230126210', 'h');
INSERT INTO `sys_data_region` VALUES (8451, '山后', 4, '230126', '230126212', 's');
INSERT INTO `sys_data_region` VALUES (8452, '镇东', 4, '230126', '230126214', 'z');
INSERT INTO `sys_data_region` VALUES (8453, '兴隆林业局', 4, '230126', '230126400', 'x');
INSERT INTO `sys_data_region` VALUES (8454, '木兰', 3, '2301', '230127', 'm');
INSERT INTO `sys_data_region` VALUES (8455, '木兰镇', 4, '230127', '230127100', 'm');
INSERT INTO `sys_data_region` VALUES (8456, '东兴', 4, '230127', '230127101', 'd');
INSERT INTO `sys_data_region` VALUES (8457, '大贵', 4, '230127', '230127102', 'd');
INSERT INTO `sys_data_region` VALUES (8458, '利东', 4, '230127', '230127103', 'l');
INSERT INTO `sys_data_region` VALUES (8459, '柳河', 4, '230127', '230127104', 'l');
INSERT INTO `sys_data_region` VALUES (8460, '新民', 4, '230127', '230127105', 'x');
INSERT INTO `sys_data_region` VALUES (8461, '建国', 4, '230127', '230127200', 'j');
INSERT INTO `sys_data_region` VALUES (8462, '吉兴', 4, '230127', '230127203', 'j');
INSERT INTO `sys_data_region` VALUES (8463, '兴隆林业局办事处', 4, '230127', '230127400', 'x');
INSERT INTO `sys_data_region` VALUES (8464, '通河', 3, '2301', '230128', 't');
INSERT INTO `sys_data_region` VALUES (8465, '通河镇', 4, '230128', '230128100', 't');
INSERT INTO `sys_data_region` VALUES (8466, '乌鸦泡', 4, '230128', '230128101', 'w');
INSERT INTO `sys_data_region` VALUES (8467, '清河', 4, '230128', '230128102', 'q');
INSERT INTO `sys_data_region` VALUES (8468, '浓河', 4, '230128', '230128103', 'n');
INSERT INTO `sys_data_region` VALUES (8469, '凤山', 4, '230128', '230128104', 'f');
INSERT INTO `sys_data_region` VALUES (8470, '祥顺', 4, '230128', '230128105', 'x');
INSERT INTO `sys_data_region` VALUES (8471, '富林', 4, '230128', '230128106', 'f');
INSERT INTO `sys_data_region` VALUES (8472, '三站', 4, '230128', '230128107', 's');
INSERT INTO `sys_data_region` VALUES (8473, '清河林业局', 4, '230128', '230128400', 'q');
INSERT INTO `sys_data_region` VALUES (8474, '兴隆林业局办事处', 4, '230128', '230128401', 'x');
INSERT INTO `sys_data_region` VALUES (8475, '岔林河农场', 4, '230128', '230128500', 'c');
INSERT INTO `sys_data_region` VALUES (8476, '延寿', 3, '2301', '230129', 'y');
INSERT INTO `sys_data_region` VALUES (8477, '延寿镇', 4, '230129', '230129100', 'y');
INSERT INTO `sys_data_region` VALUES (8478, '六团', 4, '230129', '230129101', 'l');
INSERT INTO `sys_data_region` VALUES (8479, '中和', 4, '230129', '230129102', 'z');
INSERT INTO `sys_data_region` VALUES (8480, '加信', 4, '230129', '230129103', 'j');
INSERT INTO `sys_data_region` VALUES (8481, '延河', 4, '230129', '230129104', 'y');
INSERT INTO `sys_data_region` VALUES (8482, '玉河', 4, '230129', '230129105', 'y');
INSERT INTO `sys_data_region` VALUES (8483, '安山', 4, '230129', '230129204', 'a');
INSERT INTO `sys_data_region` VALUES (8484, '寿山', 4, '230129', '230129205', 's');
INSERT INTO `sys_data_region` VALUES (8485, '青川', 4, '230129', '230129209', 'q');
INSERT INTO `sys_data_region` VALUES (8486, '庆阳农场', 4, '230129', '230129500', 'q');
INSERT INTO `sys_data_region` VALUES (8487, '尚志', 3, '2301', '230183', 's');
INSERT INTO `sys_data_region` VALUES (8488, '尚志镇', 4, '230183', '230183100', 's');
INSERT INTO `sys_data_region` VALUES (8489, '一面坡', 4, '230183', '230183101', 'y');
INSERT INTO `sys_data_region` VALUES (8490, '苇河', 4, '230183', '230183102', 'w');
INSERT INTO `sys_data_region` VALUES (8491, '亚布力', 4, '230183', '230183103', 'y');
INSERT INTO `sys_data_region` VALUES (8492, '帽儿山', 4, '230183', '230183104', 'm');
INSERT INTO `sys_data_region` VALUES (8493, '亮河', 4, '230183', '230183105', 'l');
INSERT INTO `sys_data_region` VALUES (8494, '庆阳', 4, '230183', '230183106', 'q');
INSERT INTO `sys_data_region` VALUES (8495, '石头河子', 4, '230183', '230183107', 's');
INSERT INTO `sys_data_region` VALUES (8496, '元宝', 4, '230183', '230183108', 'y');
INSERT INTO `sys_data_region` VALUES (8497, '黑龙宫', 4, '230183', '230183109', 'h');
INSERT INTO `sys_data_region` VALUES (8498, '长寿', 4, '230183', '230183202', 'c');
INSERT INTO `sys_data_region` VALUES (8499, '乌吉密', 4, '230183', '230183204', 'w');
INSERT INTO `sys_data_region` VALUES (8500, '鱼池', 4, '230183', '230183206', 'y');
INSERT INTO `sys_data_region` VALUES (8501, '珍珠山', 4, '230183', '230183207', 'z');
INSERT INTO `sys_data_region` VALUES (8502, '老街基', 4, '230183', '230183208', 'l');
INSERT INTO `sys_data_region` VALUES (8503, '马延', 4, '230183', '230183209', 'm');
INSERT INTO `sys_data_region` VALUES (8504, '河东', 4, '230183', '230183211', 'h');
INSERT INTO `sys_data_region` VALUES (8505, '五常', 3, '2301', '230184', 'w');
INSERT INTO `sys_data_region` VALUES (8506, '五常镇', 4, '230184', '230184100', 'w');
INSERT INTO `sys_data_region` VALUES (8507, '拉林', 4, '230184', '230184101', 'l');
INSERT INTO `sys_data_region` VALUES (8508, '山河', 4, '230184', '230184102', 's');
INSERT INTO `sys_data_region` VALUES (8509, '小山子', 4, '230184', '230184103', 'x');
INSERT INTO `sys_data_region` VALUES (8510, '安家', 4, '230184', '230184104', 'a');
INSERT INTO `sys_data_region` VALUES (8511, '牛家', 4, '230184', '230184105', 'n');
INSERT INTO `sys_data_region` VALUES (8512, '杜家', 4, '230184', '230184106', 'd');
INSERT INTO `sys_data_region` VALUES (8513, '背荫河', 4, '230184', '230184107', 'b');
INSERT INTO `sys_data_region` VALUES (8514, '冲河', 4, '230184', '230184108', 'c');
INSERT INTO `sys_data_region` VALUES (8515, '沙河子', 4, '230184', '230184109', 's');
INSERT INTO `sys_data_region` VALUES (8516, '向阳', 4, '230184', '230184110', 'x');
INSERT INTO `sys_data_region` VALUES (8517, '龙凤山', 4, '230184', '230184111', 'l');
INSERT INTO `sys_data_region` VALUES (8518, '兴盛', 4, '230184', '230184200', 'x');
INSERT INTO `sys_data_region` VALUES (8519, '志广', 4, '230184', '230184201', 'z');
INSERT INTO `sys_data_region` VALUES (8520, '卫国', 4, '230184', '230184202', 'w');
INSERT INTO `sys_data_region` VALUES (8521, '常堡', 4, '230184', '230184203', 'c');
INSERT INTO `sys_data_region` VALUES (8522, '民意', 4, '230184', '230184206', 'm');
INSERT INTO `sys_data_region` VALUES (8523, '红旗', 4, '230184', '230184209', 'h');
INSERT INTO `sys_data_region` VALUES (8524, '八家子', 4, '230184', '230184210', 'b');
INSERT INTO `sys_data_region` VALUES (8525, '民乐', 4, '230184', '230184211', 'm');
INSERT INTO `sys_data_region` VALUES (8526, '营城子', 4, '230184', '230184212', 'y');
INSERT INTO `sys_data_region` VALUES (8527, '长山', 4, '230184', '230184214', 'c');
INSERT INTO `sys_data_region` VALUES (8528, '兴隆', 4, '230184', '230184215', 'x');
INSERT INTO `sys_data_region` VALUES (8529, '二河', 4, '230184', '230184216', 'e');
INSERT INTO `sys_data_region` VALUES (8530, '山河屯林业局', 4, '230184', '230184400', 's');
INSERT INTO `sys_data_region` VALUES (8531, '齐齐哈尔', 2, '23', '2302', 'q');
INSERT INTO `sys_data_region` VALUES (8532, '龙沙', 3, '2302', '230202', 'l');
INSERT INTO `sys_data_region` VALUES (8533, '五龙', 4, '230202', '230202001', 'w');
INSERT INTO `sys_data_region` VALUES (8534, '湖滨', 4, '230202', '230202002', 'h');
INSERT INTO `sys_data_region` VALUES (8535, '正阳', 4, '230202', '230202004', 'z');
INSERT INTO `sys_data_region` VALUES (8536, '彩虹', 4, '230202', '230202005', 'c');
INSERT INTO `sys_data_region` VALUES (8537, '江安', 4, '230202', '230202007', 'j');
INSERT INTO `sys_data_region` VALUES (8538, '南航', 4, '230202', '230202008', 'n');
INSERT INTO `sys_data_region` VALUES (8539, '大民', 4, '230202', '230202009', 'd');
INSERT INTO `sys_data_region` VALUES (8540, '建华', 3, '2302', '230203', 'j');
INSERT INTO `sys_data_region` VALUES (8541, '中华', 4, '230203', '230203003', 'z');
INSERT INTO `sys_data_region` VALUES (8542, '西大桥', 4, '230203', '230203004', 'x');
INSERT INTO `sys_data_region` VALUES (8543, '卜奎', 4, '230203', '230203005', 'b');
INSERT INTO `sys_data_region` VALUES (8544, '建设', 4, '230203', '230203006', 'j');
INSERT INTO `sys_data_region` VALUES (8545, '文化', 4, '230203', '230203007', 'w');
INSERT INTO `sys_data_region` VALUES (8546, '溪畔', 4, '230203', '230203008', 'x');
INSERT INTO `sys_data_region` VALUES (8547, '北华', 4, '230203', '230203009', 'b');
INSERT INTO `sys_data_region` VALUES (8548, '铁锋', 3, '2302', '230204', 't');
INSERT INTO `sys_data_region` VALUES (8549, '站前', 4, '230204', '230204001', 'z');
INSERT INTO `sys_data_region` VALUES (8550, '南浦', 4, '230204', '230204002', 'n');
INSERT INTO `sys_data_region` VALUES (8551, '通东', 4, '230204', '230204003', 't');
INSERT INTO `sys_data_region` VALUES (8552, '光荣', 4, '230204', '230204004', 'g');
INSERT INTO `sys_data_region` VALUES (8553, '龙华', 4, '230204', '230204005', 'l');
INSERT INTO `sys_data_region` VALUES (8554, '北局宅', 4, '230204', '230204006', 'b');
INSERT INTO `sys_data_region` VALUES (8555, '东湖', 4, '230204', '230204008', 'd');
INSERT INTO `sys_data_region` VALUES (8556, '种畜场', 4, '230204', '230204009', 'z');
INSERT INTO `sys_data_region` VALUES (8557, '扎龙', 4, '230204', '230204100', 'z');
INSERT INTO `sys_data_region` VALUES (8558, '昂昂溪', 3, '2302', '230205', 'a');
INSERT INTO `sys_data_region` VALUES (8559, '新兴', 4, '230205', '230205001', 'x');
INSERT INTO `sys_data_region` VALUES (8560, '新建', 4, '230205', '230205002', 'x');
INSERT INTO `sys_data_region` VALUES (8561, '林机', 4, '230205', '230205005', 'l');
INSERT INTO `sys_data_region` VALUES (8562, '道北', 4, '230205', '230205006', 'd');
INSERT INTO `sys_data_region` VALUES (8563, '水师营', 4, '230205', '230205100', 's');
INSERT INTO `sys_data_region` VALUES (8564, '榆树屯', 4, '230205', '230205101', 'y');
INSERT INTO `sys_data_region` VALUES (8565, '富拉尔基区', 3, '2302', '230206', 'f');
INSERT INTO `sys_data_region` VALUES (8566, '红岸', 4, '230206', '230206001', 'h');
INSERT INTO `sys_data_region` VALUES (8567, '沿江', 4, '230206', '230206003', 'y');
INSERT INTO `sys_data_region` VALUES (8568, '电力', 4, '230206', '230206004', 'd');
INSERT INTO `sys_data_region` VALUES (8569, '幸福', 4, '230206', '230206005', 'x');
INSERT INTO `sys_data_region` VALUES (8570, '红宝石', 4, '230206', '230206006', 'h');
INSERT INTO `sys_data_region` VALUES (8571, '北兴', 4, '230206', '230206007', 'b');
INSERT INTO `sys_data_region` VALUES (8572, '铁北', 4, '230206', '230206008', 't');
INSERT INTO `sys_data_region` VALUES (8573, '和平', 4, '230206', '230206009', 'h');
INSERT INTO `sys_data_region` VALUES (8574, '长青', 4, '230206', '230206200', 'c');
INSERT INTO `sys_data_region` VALUES (8575, '杜尔门沁', 4, '230206', '230206202', 'd');
INSERT INTO `sys_data_region` VALUES (8576, '碾子山', 3, '2302', '230207', 'n');
INSERT INTO `sys_data_region` VALUES (8577, '东安', 4, '230207', '230207001', 'd');
INSERT INTO `sys_data_region` VALUES (8578, '富强', 4, '230207', '230207002', 'f');
INSERT INTO `sys_data_region` VALUES (8579, '跃进', 4, '230207', '230207003', 'y');
INSERT INTO `sys_data_region` VALUES (8580, '繁荣', 4, '230207', '230207004', 'f');
INSERT INTO `sys_data_region` VALUES (8581, '碾子山区', 4, '230207', '230207198', 'n');
INSERT INTO `sys_data_region` VALUES (8582, '梅里斯', 3, '2302', '230208', 'm');
INSERT INTO `sys_data_region` VALUES (8583, '梅里斯街道', 4, '230208', '230208001', 'm');
INSERT INTO `sys_data_region` VALUES (8584, '雅尔塞', 4, '230208', '230208101', 'y');
INSERT INTO `sys_data_region` VALUES (8585, '卧牛吐', 4, '230208', '230208102', 'w');
INSERT INTO `sys_data_region` VALUES (8586, '达呼店', 4, '230208', '230208103', 'd');
INSERT INTO `sys_data_region` VALUES (8587, '共和', 4, '230208', '230208104', 'g');
INSERT INTO `sys_data_region` VALUES (8588, '梅里斯镇', 4, '230208', '230208105', 'm');
INSERT INTO `sys_data_region` VALUES (8589, '莽格吐', 4, '230208', '230208200', 'm');
INSERT INTO `sys_data_region` VALUES (8590, '哈拉海农场', 4, '230208', '230208501', 'h');
INSERT INTO `sys_data_region` VALUES (8591, '龙江', 3, '2302', '230221', 'l');
INSERT INTO `sys_data_region` VALUES (8592, '龙江镇', 4, '230221', '230221100', 'l');
INSERT INTO `sys_data_region` VALUES (8593, '景星', 4, '230221', '230221101', 'j');
INSERT INTO `sys_data_region` VALUES (8594, '龙兴', 4, '230221', '230221102', 'l');
INSERT INTO `sys_data_region` VALUES (8595, '山泉', 4, '230221', '230221103', 's');
INSERT INTO `sys_data_region` VALUES (8596, '七棵树', 4, '230221', '230221104', 'q');
INSERT INTO `sys_data_region` VALUES (8597, '杏山', 4, '230221', '230221105', 'x');
INSERT INTO `sys_data_region` VALUES (8598, '白山', 4, '230221', '230221106', 'b');
INSERT INTO `sys_data_region` VALUES (8599, '头站', 4, '230221', '230221107', 't');
INSERT INTO `sys_data_region` VALUES (8600, '黑岗', 4, '230221', '230221201', 'h');
INSERT INTO `sys_data_region` VALUES (8601, '广厚', 4, '230221', '230221202', 'g');
INSERT INTO `sys_data_region` VALUES (8602, '华民', 4, '230221', '230221203', 'h');
INSERT INTO `sys_data_region` VALUES (8603, '哈拉海', 4, '230221', '230221204', 'h');
INSERT INTO `sys_data_region` VALUES (8604, '鲁河', 4, '230221', '230221215', 'l');
INSERT INTO `sys_data_region` VALUES (8605, '济沁河', 4, '230221', '230221217', 'j');
INSERT INTO `sys_data_region` VALUES (8606, '依安', 3, '2302', '230223', 'y');
INSERT INTO `sys_data_region` VALUES (8607, '依安镇', 4, '230223', '230223100', 'y');
INSERT INTO `sys_data_region` VALUES (8608, '依龙', 4, '230223', '230223101', 'y');
INSERT INTO `sys_data_region` VALUES (8609, '双阳', 4, '230223', '230223102', 's');
INSERT INTO `sys_data_region` VALUES (8610, '三兴', 4, '230223', '230223103', 's');
INSERT INTO `sys_data_region` VALUES (8611, '中心', 4, '230223', '230223104', 'z');
INSERT INTO `sys_data_region` VALUES (8612, '新兴', 4, '230223', '230223105', 'x');
INSERT INTO `sys_data_region` VALUES (8613, '富饶', 4, '230223', '230223200', 'f');
INSERT INTO `sys_data_region` VALUES (8614, '解放', 4, '230223', '230223201', 'j');
INSERT INTO `sys_data_region` VALUES (8615, '阳春', 4, '230223', '230223202', 'y');
INSERT INTO `sys_data_region` VALUES (8616, '新发', 4, '230223', '230223203', 'x');
INSERT INTO `sys_data_region` VALUES (8617, '太东', 4, '230223', '230223204', 't');
INSERT INTO `sys_data_region` VALUES (8618, '上游', 4, '230223', '230223205', 's');
INSERT INTO `sys_data_region` VALUES (8619, '红星', 4, '230223', '230223206', 'h');
INSERT INTO `sys_data_region` VALUES (8620, '先锋', 4, '230223', '230223207', 'x');
INSERT INTO `sys_data_region` VALUES (8621, '新屯', 4, '230223', '230223208', 'x');
INSERT INTO `sys_data_region` VALUES (8622, '依安农场', 4, '230223', '230223500', 'y');
INSERT INTO `sys_data_region` VALUES (8623, '红旗种马场', 4, '230223', '230223501', 'h');
INSERT INTO `sys_data_region` VALUES (8624, '泰来', 3, '2302', '230224', 't');
INSERT INTO `sys_data_region` VALUES (8625, '泰来镇', 4, '230224', '230224100', 't');
INSERT INTO `sys_data_region` VALUES (8626, '平洋', 4, '230224', '230224101', 'p');
INSERT INTO `sys_data_region` VALUES (8627, '汤池', 4, '230224', '230224102', 't');
INSERT INTO `sys_data_region` VALUES (8628, '江桥', 4, '230224', '230224103', 'j');
INSERT INTO `sys_data_region` VALUES (8629, '塔子城', 4, '230224', '230224104', 't');
INSERT INTO `sys_data_region` VALUES (8630, '大兴', 4, '230224', '230224105', 'd');
INSERT INTO `sys_data_region` VALUES (8631, '和平', 4, '230224', '230224106', 'h');
INSERT INTO `sys_data_region` VALUES (8632, '克利', 4, '230224', '230224107', 'k');
INSERT INTO `sys_data_region` VALUES (8633, '胜利', 4, '230224', '230224200', 's');
INSERT INTO `sys_data_region` VALUES (8634, '宁姜', 4, '230224', '230224209', 'n');
INSERT INTO `sys_data_region` VALUES (8635, '泰来农场', 4, '230224', '230224500', 't');
INSERT INTO `sys_data_region` VALUES (8636, '甘南', 3, '2302', '230225', 'g');
INSERT INTO `sys_data_region` VALUES (8637, '甘南镇', 4, '230225', '230225100', 'g');
INSERT INTO `sys_data_region` VALUES (8638, '兴十四', 4, '230225', '230225101', 'x');
INSERT INTO `sys_data_region` VALUES (8639, '平阳', 4, '230225', '230225102', 'p');
INSERT INTO `sys_data_region` VALUES (8640, '东阳', 4, '230225', '230225103', 'd');
INSERT INTO `sys_data_region` VALUES (8641, '巨宝', 4, '230225', '230225104', 'j');
INSERT INTO `sys_data_region` VALUES (8642, '长山', 4, '230225', '230225201', 'c');
INSERT INTO `sys_data_region` VALUES (8643, '中兴', 4, '230225', '230225202', 'z');
INSERT INTO `sys_data_region` VALUES (8644, '兴隆', 4, '230225', '230225203', 'x');
INSERT INTO `sys_data_region` VALUES (8645, '宝山', 4, '230225', '230225204', 'b');
INSERT INTO `sys_data_region` VALUES (8646, '查哈阳', 4, '230225', '230225206', 'c');
INSERT INTO `sys_data_region` VALUES (8647, '查哈阳农场', 4, '230225', '230225500', 'c');
INSERT INTO `sys_data_region` VALUES (8648, '北京市双河农场', 4, '230225', '230225580', 'b');
INSERT INTO `sys_data_region` VALUES (8649, '富裕', 3, '2302', '230227', 'f');
INSERT INTO `sys_data_region` VALUES (8650, '富裕镇', 4, '230227', '230227100', 'f');
INSERT INTO `sys_data_region` VALUES (8651, '富路', 4, '230227', '230227101', 'f');
INSERT INTO `sys_data_region` VALUES (8652, '富海', 4, '230227', '230227102', 'f');
INSERT INTO `sys_data_region` VALUES (8653, '二道湾', 4, '230227', '230227103', 'e');
INSERT INTO `sys_data_region` VALUES (8654, '龙安桥', 4, '230227', '230227104', 'l');
INSERT INTO `sys_data_region` VALUES (8655, '塔哈', 4, '230227', '230227105', 't');
INSERT INTO `sys_data_region` VALUES (8656, '繁荣', 4, '230227', '230227200', 'f');
INSERT INTO `sys_data_region` VALUES (8657, '绍文', 4, '230227', '230227201', 's');
INSERT INTO `sys_data_region` VALUES (8658, '忠厚', 4, '230227', '230227202', 'z');
INSERT INTO `sys_data_region` VALUES (8659, '友谊', 4, '230227', '230227203', 'y');
INSERT INTO `sys_data_region` VALUES (8660, '富裕牧场', 4, '230227', '230227500', 'f');
INSERT INTO `sys_data_region` VALUES (8661, '繁荣种畜场', 4, '230227', '230227501', 'f');
INSERT INTO `sys_data_region` VALUES (8662, '克山', 3, '2302', '230229', 'k');
INSERT INTO `sys_data_region` VALUES (8663, '克山镇', 4, '230229', '230229100', 'k');
INSERT INTO `sys_data_region` VALUES (8664, '北兴', 4, '230229', '230229101', 'b');
INSERT INTO `sys_data_region` VALUES (8665, '西城', 4, '230229', '230229102', 'x');
INSERT INTO `sys_data_region` VALUES (8666, '古城', 4, '230229', '230229103', 'g');
INSERT INTO `sys_data_region` VALUES (8667, '北联', 4, '230229', '230229104', 'b');
INSERT INTO `sys_data_region` VALUES (8668, '西河', 4, '230229', '230229105', 'x');
INSERT INTO `sys_data_region` VALUES (8669, '双河', 4, '230229', '230229106', 's');
INSERT INTO `sys_data_region` VALUES (8670, '河南', 4, '230229', '230229200', 'h');
INSERT INTO `sys_data_region` VALUES (8671, '河北', 4, '230229', '230229203', 'h');
INSERT INTO `sys_data_region` VALUES (8672, '古北', 4, '230229', '230229204', 'g');
INSERT INTO `sys_data_region` VALUES (8673, '西联', 4, '230229', '230229205', 'x');
INSERT INTO `sys_data_region` VALUES (8674, '发展', 4, '230229', '230229206', 'f');
INSERT INTO `sys_data_region` VALUES (8675, '西建', 4, '230229', '230229207', 'x');
INSERT INTO `sys_data_region` VALUES (8676, '向华', 4, '230229', '230229208', 'x');
INSERT INTO `sys_data_region` VALUES (8677, '曙光', 4, '230229', '230229210', 's');
INSERT INTO `sys_data_region` VALUES (8678, '克山农场', 4, '230229', '230229500', 'k');
INSERT INTO `sys_data_region` VALUES (8679, '克东', 3, '2302', '230230', 'k');
INSERT INTO `sys_data_region` VALUES (8680, '克东镇', 4, '230230', '230230100', 'k');
INSERT INTO `sys_data_region` VALUES (8681, '宝泉', 4, '230230', '230230101', 'b');
INSERT INTO `sys_data_region` VALUES (8682, '乾丰', 4, '230230', '230230102', 'q');
INSERT INTO `sys_data_region` VALUES (8683, '玉岗', 4, '230230', '230230103', 'y');
INSERT INTO `sys_data_region` VALUES (8684, '蒲峪路', 4, '230230', '230230104', 'p');
INSERT INTO `sys_data_region` VALUES (8685, '润津', 4, '230230', '230230202', 'r');
INSERT INTO `sys_data_region` VALUES (8686, '昌盛', 4, '230230', '230230204', 'c');
INSERT INTO `sys_data_region` VALUES (8687, '发展林场', 4, '230230', '230230403', 'f');
INSERT INTO `sys_data_region` VALUES (8688, '东兴林场', 4, '230230', '230230404', 'd');
INSERT INTO `sys_data_region` VALUES (8689, '拜泉', 3, '2302', '230231', 'b');
INSERT INTO `sys_data_region` VALUES (8690, '拜泉镇', 4, '230231', '230231100', 'b');
INSERT INTO `sys_data_region` VALUES (8691, '三道', 4, '230231', '230231101', 's');
INSERT INTO `sys_data_region` VALUES (8692, '兴农', 4, '230231', '230231102', 'x');
INSERT INTO `sys_data_region` VALUES (8693, '长春', 4, '230231', '230231103', 'c');
INSERT INTO `sys_data_region` VALUES (8694, '龙泉', 4, '230231', '230231104', 'l');
INSERT INTO `sys_data_region` VALUES (8695, '国富', 4, '230231', '230231105', 'g');
INSERT INTO `sys_data_region` VALUES (8696, '富强', 4, '230231', '230231106', 'f');
INSERT INTO `sys_data_region` VALUES (8697, '新生', 4, '230231', '230231200', 'x');
INSERT INTO `sys_data_region` VALUES (8698, '兴国', 4, '230231', '230231201', 'x');
INSERT INTO `sys_data_region` VALUES (8699, '上升', 4, '230231', '230231203', 's');
INSERT INTO `sys_data_region` VALUES (8700, '兴华', 4, '230231', '230231204', 'x');
INSERT INTO `sys_data_region` VALUES (8701, '大众', 4, '230231', '230231206', 'd');
INSERT INTO `sys_data_region` VALUES (8702, '丰产', 4, '230231', '230231209', 'f');
INSERT INTO `sys_data_region` VALUES (8703, '永勤', 4, '230231', '230231210', 'y');
INSERT INTO `sys_data_region` VALUES (8704, '爱农', 4, '230231', '230231212', 'a');
INSERT INTO `sys_data_region` VALUES (8705, '时中', 4, '230231', '230231214', 's');
INSERT INTO `sys_data_region` VALUES (8706, '讷河', 3, '2302', '230281', 'n');
INSERT INTO `sys_data_region` VALUES (8707, '通江', 4, '230281', '230281001', 't');
INSERT INTO `sys_data_region` VALUES (8708, '雨亭', 4, '230281', '230281002', 'y');
INSERT INTO `sys_data_region` VALUES (8709, '拉哈', 4, '230281', '230281101', 'l');
INSERT INTO `sys_data_region` VALUES (8710, '二克浅', 4, '230281', '230281102', 'e');
INSERT INTO `sys_data_region` VALUES (8711, '学田', 4, '230281', '230281103', 'x');
INSERT INTO `sys_data_region` VALUES (8712, '龙河', 4, '230281', '230281104', 'l');
INSERT INTO `sys_data_region` VALUES (8713, '讷南', 4, '230281', '230281105', 'n');
INSERT INTO `sys_data_region` VALUES (8714, '六合', 4, '230281', '230281106', 'l');
INSERT INTO `sys_data_region` VALUES (8715, '长发', 4, '230281', '230281107', 'c');
INSERT INTO `sys_data_region` VALUES (8716, '通南', 4, '230281', '230281108', 't');
INSERT INTO `sys_data_region` VALUES (8717, '同义', 4, '230281', '230281109', 't');
INSERT INTO `sys_data_region` VALUES (8718, '九井', 4, '230281', '230281110', 'j');
INSERT INTO `sys_data_region` VALUES (8719, '老莱', 4, '230281', '230281111', 'l');
INSERT INTO `sys_data_region` VALUES (8720, '孔国', 4, '230281', '230281201', 'k');
INSERT INTO `sys_data_region` VALUES (8721, '和盛', 4, '230281', '230281207', 'h');
INSERT INTO `sys_data_region` VALUES (8722, '同心', 4, '230281', '230281208', 't');
INSERT INTO `sys_data_region` VALUES (8723, '兴旺', 4, '230281', '230281210', 'x');
INSERT INTO `sys_data_region` VALUES (8724, '龙河镇保安林场', 4, '230281', '230281400', 'l');
INSERT INTO `sys_data_region` VALUES (8725, '龙河镇茂山林场', 4, '230281', '230281401', 'l');
INSERT INTO `sys_data_region` VALUES (8726, '龙河镇国庆林场', 4, '230281', '230281402', 'l');
INSERT INTO `sys_data_region` VALUES (8727, '老莱镇宽余林场', 4, '230281', '230281404', 'l');
INSERT INTO `sys_data_region` VALUES (8728, '红五月农场', 4, '230281', '230281406', 'h');
INSERT INTO `sys_data_region` VALUES (8729, '龙河镇青色草原种畜场', 4, '230281', '230281584', 'l');
INSERT INTO `sys_data_region` VALUES (8730, '鸡西', 2, '23', '2303', 'j');
INSERT INTO `sys_data_region` VALUES (8731, '鸡冠', 3, '2303', '230302', 'j');
INSERT INTO `sys_data_region` VALUES (8732, '向阳', 4, '230302', '230302001', 'x');
INSERT INTO `sys_data_region` VALUES (8733, '南山', 4, '230302', '230302002', 'n');
INSERT INTO `sys_data_region` VALUES (8734, '立新', 4, '230302', '230302003', 'l');
INSERT INTO `sys_data_region` VALUES (8735, '东风', 4, '230302', '230302004', 'd');
INSERT INTO `sys_data_region` VALUES (8736, '红军路', 4, '230302', '230302005', 'h');
INSERT INTO `sys_data_region` VALUES (8737, '西鸡西', 4, '230302', '230302006', 'x');
INSERT INTO `sys_data_region` VALUES (8738, '西山', 4, '230302', '230302007', 'x');
INSERT INTO `sys_data_region` VALUES (8739, '红星', 4, '230302', '230302200', 'h');
INSERT INTO `sys_data_region` VALUES (8740, '西郊', 4, '230302', '230302201', 'x');
INSERT INTO `sys_data_region` VALUES (8741, '恒山', 3, '2303', '230303', 'h');
INSERT INTO `sys_data_region` VALUES (8742, '桦木林', 4, '230303', '230303001', 'h');
INSERT INTO `sys_data_region` VALUES (8743, '大恒山', 4, '230303', '230303002', 'd');
INSERT INTO `sys_data_region` VALUES (8744, '二道河子', 4, '230303', '230303004', 'e');
INSERT INTO `sys_data_region` VALUES (8745, '张新', 4, '230303', '230303005', 'z');
INSERT INTO `sys_data_region` VALUES (8746, '柳毛街道', 4, '230303', '230303007', 'l');
INSERT INTO `sys_data_region` VALUES (8747, '红旗', 4, '230303', '230303200', 'h');
INSERT INTO `sys_data_region` VALUES (8748, '柳毛乡', 4, '230303', '230303201', 'l');
INSERT INTO `sys_data_region` VALUES (8749, '滴道', 3, '2303', '230304', 'd');
INSERT INTO `sys_data_region` VALUES (8750, '东兴', 4, '230304', '230304001', 'd');
INSERT INTO `sys_data_region` VALUES (8751, '矿里', 4, '230304', '230304002', 'k');
INSERT INTO `sys_data_region` VALUES (8752, '洗煤', 4, '230304', '230304003', 'x');
INSERT INTO `sys_data_region` VALUES (8753, '大通沟', 4, '230304', '230304004', 'd');
INSERT INTO `sys_data_region` VALUES (8754, '滴道河', 4, '230304', '230304200', 'd');
INSERT INTO `sys_data_region` VALUES (8755, '兰岭', 4, '230304', '230304201', 'l');
INSERT INTO `sys_data_region` VALUES (8756, '梨树', 3, '2303', '230305', 'l');
INSERT INTO `sys_data_region` VALUES (8757, '街里', 4, '230305', '230305001', 'j');
INSERT INTO `sys_data_region` VALUES (8758, '穆棱', 4, '230305', '230305002', 'm');
INSERT INTO `sys_data_region` VALUES (8759, '平岗', 4, '230305', '230305003', 'p');
INSERT INTO `sys_data_region` VALUES (8760, '碱场', 4, '230305', '230305004', 'j');
INSERT INTO `sys_data_region` VALUES (8761, '石磷', 4, '230305', '230305005', 's');
INSERT INTO `sys_data_region` VALUES (8762, '梨树镇', 4, '230305', '230305101', 'l');
INSERT INTO `sys_data_region` VALUES (8763, '城子河', 3, '2303', '230306', 'c');
INSERT INTO `sys_data_region` VALUES (8764, '中心', 4, '230306', '230306001', 'z');
INSERT INTO `sys_data_region` VALUES (8765, '正阳', 4, '230306', '230306002', 'z');
INSERT INTO `sys_data_region` VALUES (8766, '城西', 4, '230306', '230306004', 'c');
INSERT INTO `sys_data_region` VALUES (8767, '杏花', 4, '230306', '230306005', 'x');
INSERT INTO `sys_data_region` VALUES (8768, '长青', 4, '230306', '230306200', 'c');
INSERT INTO `sys_data_region` VALUES (8769, '永丰', 4, '230306', '230306201', 'y');
INSERT INTO `sys_data_region` VALUES (8770, '麻山', 3, '2303', '230307', 'm');
INSERT INTO `sys_data_region` VALUES (8771, '麻山街道', 4, '230307', '230307001', 'm');
INSERT INTO `sys_data_region` VALUES (8772, '麻山镇', 4, '230307', '230307101', 'm');
INSERT INTO `sys_data_region` VALUES (8773, '鸡东', 3, '2303', '230321', 'j');
INSERT INTO `sys_data_region` VALUES (8774, '鸡东镇', 4, '230321', '230321100', 'j');
INSERT INTO `sys_data_region` VALUES (8775, '平阳', 4, '230321', '230321101', 'p');
INSERT INTO `sys_data_region` VALUES (8776, '向阳', 4, '230321', '230321102', 'x');
INSERT INTO `sys_data_region` VALUES (8777, '哈达', 4, '230321', '230321103', 'h');
INSERT INTO `sys_data_region` VALUES (8778, '永安', 4, '230321', '230321104', 'y');
INSERT INTO `sys_data_region` VALUES (8779, '永和', 4, '230321', '230321105', 'y');
INSERT INTO `sys_data_region` VALUES (8780, '东海', 4, '230321', '230321106', 'd');
INSERT INTO `sys_data_region` VALUES (8781, '兴农', 4, '230321', '230321107', 'x');
INSERT INTO `sys_data_region` VALUES (8782, '鸡林', 4, '230321', '230321200', 'j');
INSERT INTO `sys_data_region` VALUES (8783, '明德', 4, '230321', '230321205', 'm');
INSERT INTO `sys_data_region` VALUES (8784, '下亮子', 4, '230321', '230321206', 'x');
INSERT INTO `sys_data_region` VALUES (8785, '虎林', 3, '2303', '230381', 'h');
INSERT INTO `sys_data_region` VALUES (8786, '虎林镇', 4, '230381', '230381100', 'h');
INSERT INTO `sys_data_region` VALUES (8787, '东方红', 4, '230381', '230381101', 'd');
INSERT INTO `sys_data_region` VALUES (8788, '迎春', 4, '230381', '230381102', 'y');
INSERT INTO `sys_data_region` VALUES (8789, '虎头', 4, '230381', '230381103', 'h');
INSERT INTO `sys_data_region` VALUES (8790, '杨岗', 4, '230381', '230381104', 'y');
INSERT INTO `sys_data_region` VALUES (8791, '宝东', 4, '230381', '230381106', 'b');
INSERT INTO `sys_data_region` VALUES (8792, '东诚', 4, '230381', '230381107', 'd');
INSERT INTO `sys_data_region` VALUES (8793, '新乐', 4, '230381', '230381203', 'x');
INSERT INTO `sys_data_region` VALUES (8794, '伟光', 4, '230381', '230381204', 'w');
INSERT INTO `sys_data_region` VALUES (8795, '珍宝岛', 4, '230381', '230381206', 'z');
INSERT INTO `sys_data_region` VALUES (8796, '阿北', 4, '230381', '230381207', 'a');
INSERT INTO `sys_data_region` VALUES (8797, '东方红林业局', 4, '230381', '230381400', 'd');
INSERT INTO `sys_data_region` VALUES (8798, '八五０农场', 4, '230381', '230381500', 'b');
INSERT INTO `sys_data_region` VALUES (8799, '八五四农场', 4, '230381', '230381501', 'b');
INSERT INTO `sys_data_region` VALUES (8800, '八五六农场', 4, '230381', '230381502', 'b');
INSERT INTO `sys_data_region` VALUES (8801, '八五八农场', 4, '230381', '230381503', 'b');
INSERT INTO `sys_data_region` VALUES (8802, '庆丰农场', 4, '230381', '230381504', 'q');
INSERT INTO `sys_data_region` VALUES (8803, '云山农场', 4, '230381', '230381505', 'y');
INSERT INTO `sys_data_region` VALUES (8804, '密山', 3, '2303', '230382', 'm');
INSERT INTO `sys_data_region` VALUES (8805, '中心', 4, '230382', '230382001', 'z');
INSERT INTO `sys_data_region` VALUES (8806, '密山镇', 4, '230382', '230382100', 'm');
INSERT INTO `sys_data_region` VALUES (8807, '连珠山', 4, '230382', '230382101', 'l');
INSERT INTO `sys_data_region` VALUES (8808, '当壁', 4, '230382', '230382102', 'd');
INSERT INTO `sys_data_region` VALUES (8809, '知一', 4, '230382', '230382103', 'z');
INSERT INTO `sys_data_region` VALUES (8810, '黑台', 4, '230382', '230382104', 'h');
INSERT INTO `sys_data_region` VALUES (8811, '兴凯', 4, '230382', '230382105', 'x');
INSERT INTO `sys_data_region` VALUES (8812, '裴德', 4, '230382', '230382106', 'p');
INSERT INTO `sys_data_region` VALUES (8813, '白鱼湾', 4, '230382', '230382107', 'b');
INSERT INTO `sys_data_region` VALUES (8814, '柳毛', 4, '230382', '230382200', 'l');
INSERT INTO `sys_data_region` VALUES (8815, '杨木', 4, '230382', '230382201', 'y');
INSERT INTO `sys_data_region` VALUES (8816, '兴凯湖', 4, '230382', '230382202', 'x');
INSERT INTO `sys_data_region` VALUES (8817, '承紫河', 4, '230382', '230382203', 'c');
INSERT INTO `sys_data_region` VALUES (8818, '二人班', 4, '230382', '230382206', 'e');
INSERT INTO `sys_data_region` VALUES (8819, '太平', 4, '230382', '230382208', 't');
INSERT INTO `sys_data_region` VALUES (8820, '和平', 4, '230382', '230382210', 'h');
INSERT INTO `sys_data_region` VALUES (8821, '富源', 4, '230382', '230382212', 'f');
INSERT INTO `sys_data_region` VALUES (8822, '经济开发区管理委员会', 4, '230382', '230382482', 'j');
INSERT INTO `sys_data_region` VALUES (8823, '八五五农场', 4, '230382', '230382502', 'b');
INSERT INTO `sys_data_region` VALUES (8824, '八五七农场', 4, '230382', '230382503', 'b');
INSERT INTO `sys_data_region` VALUES (8825, '八五一一农场', 4, '230382', '230382504', 'b');
INSERT INTO `sys_data_region` VALUES (8826, '兴凯湖农场', 4, '230382', '230382505', 'x');
INSERT INTO `sys_data_region` VALUES (8827, '鹤岗', 2, '23', '2304', 'h');
INSERT INTO `sys_data_region` VALUES (8828, '向阳', 3, '2304', '230402', 'x');
INSERT INTO `sys_data_region` VALUES (8829, '光明', 4, '230402', '230402001', 'g');
INSERT INTO `sys_data_region` VALUES (8830, '红军', 4, '230402', '230402002', 'h');
INSERT INTO `sys_data_region` VALUES (8831, '胜利', 4, '230402', '230402003', 's');
INSERT INTO `sys_data_region` VALUES (8832, '南翼', 4, '230402', '230402004', 'n');
INSERT INTO `sys_data_region` VALUES (8833, '北山', 4, '230402', '230402005', 'b');
INSERT INTO `sys_data_region` VALUES (8834, '工农', 3, '2304', '230403', 'g');
INSERT INTO `sys_data_region` VALUES (8835, '育才', 4, '230403', '230403001', 'y');
INSERT INTO `sys_data_region` VALUES (8836, '团结', 4, '230403', '230403002', 't');
INSERT INTO `sys_data_region` VALUES (8837, '湖滨', 4, '230403', '230403003', 'h');
INSERT INTO `sys_data_region` VALUES (8838, '解放', 4, '230403', '230403004', 'j');
INSERT INTO `sys_data_region` VALUES (8839, '新南', 4, '230403', '230403005', 'x');
INSERT INTO `sys_data_region` VALUES (8840, '红旗', 4, '230403', '230403006', 'h');
INSERT INTO `sys_data_region` VALUES (8841, '南山', 3, '2304', '230404', 'n');
INSERT INTO `sys_data_region` VALUES (8842, '铁西', 4, '230404', '230404001', 't');
INSERT INTO `sys_data_region` VALUES (8843, '铁东', 4, '230404', '230404002', 't');
INSERT INTO `sys_data_region` VALUES (8844, '六号', 4, '230404', '230404003', 'l');
INSERT INTO `sys_data_region` VALUES (8845, '大陆', 4, '230404', '230404004', 'd');
INSERT INTO `sys_data_region` VALUES (8846, '富力', 4, '230404', '230404005', 'f');
INSERT INTO `sys_data_region` VALUES (8847, '鹿林山', 4, '230404', '230404006', 'l');
INSERT INTO `sys_data_region` VALUES (8848, '兴安', 3, '2304', '230405', 'x');
INSERT INTO `sys_data_region` VALUES (8849, '兴安路', 4, '230405', '230405001', 'x');
INSERT INTO `sys_data_region` VALUES (8850, '兴建路', 4, '230405', '230405002', 'x');
INSERT INTO `sys_data_region` VALUES (8851, '兴长路', 4, '230405', '230405003', 'x');
INSERT INTO `sys_data_region` VALUES (8852, '峻德路', 4, '230405', '230405004', 'j');
INSERT INTO `sys_data_region` VALUES (8853, '河东路', 4, '230405', '230405005', 'h');
INSERT INTO `sys_data_region` VALUES (8854, '红旗', 4, '230405', '230405100', 'h');
INSERT INTO `sys_data_region` VALUES (8855, '东山', 3, '2304', '230406', 'd');
INSERT INTO `sys_data_region` VALUES (8856, '东山街道', 4, '230406', '230406001', 'd');
INSERT INTO `sys_data_region` VALUES (8857, '三街', 4, '230406', '230406002', 's');
INSERT INTO `sys_data_region` VALUES (8858, '工人村', 4, '230406', '230406003', 'g');
INSERT INTO `sys_data_region` VALUES (8859, '新一', 4, '230406', '230406004', 'x');
INSERT INTO `sys_data_region` VALUES (8860, '鹤兴', 4, '230406', '230406005', 'h');
INSERT INTO `sys_data_region` VALUES (8861, '光宇', 4, '230406', '230406006', 'g');
INSERT INTO `sys_data_region` VALUES (8862, '新华', 4, '230406', '230406100', 'x');
INSERT INTO `sys_data_region` VALUES (8863, '蔬园', 4, '230406', '230406201', 's');
INSERT INTO `sys_data_region` VALUES (8864, '东方红', 4, '230406', '230406202', 'd');
INSERT INTO `sys_data_region` VALUES (8865, '鹤岗市林业局', 4, '230406', '230406400', 'h');
INSERT INTO `sys_data_region` VALUES (8866, '新华农场', 4, '230406', '230406500', 'x');
INSERT INTO `sys_data_region` VALUES (8867, '兴山', 3, '2304', '230407', 'x');
INSERT INTO `sys_data_region` VALUES (8868, '沟南', 4, '230407', '230407001', 'g');
INSERT INTO `sys_data_region` VALUES (8869, '沟北', 4, '230407', '230407002', 'g');
INSERT INTO `sys_data_region` VALUES (8870, '岭南', 4, '230407', '230407003', 'l');
INSERT INTO `sys_data_region` VALUES (8871, '岭北', 4, '230407', '230407004', 'l');
INSERT INTO `sys_data_region` VALUES (8872, '萝北', 3, '2304', '230421', 'l');
INSERT INTO `sys_data_region` VALUES (8873, '凤翔', 4, '230421', '230421100', 'f');
INSERT INTO `sys_data_region` VALUES (8874, '鹤北', 4, '230421', '230421101', 'h');
INSERT INTO `sys_data_region` VALUES (8875, '名山', 4, '230421', '230421102', 'm');
INSERT INTO `sys_data_region` VALUES (8876, '团结', 4, '230421', '230421103', 't');
INSERT INTO `sys_data_region` VALUES (8877, '肇兴', 4, '230421', '230421104', 'z');
INSERT INTO `sys_data_region` VALUES (8878, '云山', 4, '230421', '230421105', 'y');
INSERT INTO `sys_data_region` VALUES (8879, '东明', 4, '230421', '230421200', 'd');
INSERT INTO `sys_data_region` VALUES (8880, '太平沟', 4, '230421', '230421203', 't');
INSERT INTO `sys_data_region` VALUES (8881, '萝北县林业局', 4, '230421', '230421400', 'l');
INSERT INTO `sys_data_region` VALUES (8882, '江滨农场', 4, '230421', '230421501', 'j');
INSERT INTO `sys_data_region` VALUES (8883, '军川农场', 4, '230421', '230421502', 'j');
INSERT INTO `sys_data_region` VALUES (8884, '名山农场', 4, '230421', '230421503', 'm');
INSERT INTO `sys_data_region` VALUES (8885, '延军农场', 4, '230421', '230421504', 'y');
INSERT INTO `sys_data_region` VALUES (8886, '共青农场', 4, '230421', '230421505', 'g');
INSERT INTO `sys_data_region` VALUES (8887, '宝泉岭农场', 4, '230421', '230421506', 'b');
INSERT INTO `sys_data_region` VALUES (8888, '萝北县农业局', 4, '230421', '230421580', 'l');
INSERT INTO `sys_data_region` VALUES (8889, '绥滨', 3, '2304', '230422', 's');
INSERT INTO `sys_data_region` VALUES (8890, '绥滨镇', 4, '230422', '230422100', 's');
INSERT INTO `sys_data_region` VALUES (8891, '绥东', 4, '230422', '230422101', 's');
INSERT INTO `sys_data_region` VALUES (8892, '忠仁', 4, '230422', '230422102', 'z');
INSERT INTO `sys_data_region` VALUES (8893, '连生', 4, '230422', '230422200', 'l');
INSERT INTO `sys_data_region` VALUES (8894, '北岗', 4, '230422', '230422201', 'b');
INSERT INTO `sys_data_region` VALUES (8895, '富强', 4, '230422', '230422202', 'f');
INSERT INTO `sys_data_region` VALUES (8896, '北山', 4, '230422', '230422203', 'b');
INSERT INTO `sys_data_region` VALUES (8897, '福兴', 4, '230422', '230422204', 'f');
INSERT INTO `sys_data_region` VALUES (8898, '新富', 4, '230422', '230422205', 'x');
INSERT INTO `sys_data_region` VALUES (8899, '绥滨西林场', 4, '230422', '230422400', 's');
INSERT INTO `sys_data_region` VALUES (8900, '中兴边防林场', 4, '230422', '230422401', 'z');
INSERT INTO `sys_data_region` VALUES (8901, '二九０农场', 4, '230422', '230422500', 'e');
INSERT INTO `sys_data_region` VALUES (8902, '绥滨农场', 4, '230422', '230422501', 's');
INSERT INTO `sys_data_region` VALUES (8903, '普阳农场', 4, '230422', '230422503', 'p');
INSERT INTO `sys_data_region` VALUES (8904, '双鸭山', 2, '23', '2305', 's');
INSERT INTO `sys_data_region` VALUES (8905, '尖山', 3, '2305', '230502', 'j');
INSERT INTO `sys_data_region` VALUES (8906, '二马路', 4, '230502', '230502001', 'e');
INSERT INTO `sys_data_region` VALUES (8907, '八马路', 4, '230502', '230502002', 'b');
INSERT INTO `sys_data_region` VALUES (8908, '中心站', 4, '230502', '230502003', 'z');
INSERT INTO `sys_data_region` VALUES (8909, '富安', 4, '230502', '230502004', 'f');
INSERT INTO `sys_data_region` VALUES (8910, '窑地', 4, '230502', '230502005', 'y');
INSERT INTO `sys_data_region` VALUES (8911, '长安', 4, '230502', '230502006', 'c');
INSERT INTO `sys_data_region` VALUES (8912, '铁西', 4, '230502', '230502007', 't');
INSERT INTO `sys_data_region` VALUES (8913, '安邦', 4, '230502', '230502200', 'a');
INSERT INTO `sys_data_region` VALUES (8914, '岭东', 3, '2305', '230503', 'l');
INSERT INTO `sys_data_region` VALUES (8915, '中山', 4, '230503', '230503001', 'z');
INSERT INTO `sys_data_region` VALUES (8916, '北山', 4, '230503', '230503002', 'b');
INSERT INTO `sys_data_region` VALUES (8917, '南山', 4, '230503', '230503003', 'n');
INSERT INTO `sys_data_region` VALUES (8918, '东山', 4, '230503', '230503004', 'd');
INSERT INTO `sys_data_region` VALUES (8919, '中心', 4, '230503', '230503005', 'z');
INSERT INTO `sys_data_region` VALUES (8920, '西山', 4, '230503', '230503006', 'x');
INSERT INTO `sys_data_region` VALUES (8921, '长胜', 4, '230503', '230503200', 'c');
INSERT INTO `sys_data_region` VALUES (8922, '岭东区青山旅游公司', 4, '230503', '230503400', 'l');
INSERT INTO `sys_data_region` VALUES (8923, '岭东区岭东经营所', 4, '230503', '230503401', 'l');
INSERT INTO `sys_data_region` VALUES (8924, '四方台', 3, '2305', '230505', 's');
INSERT INTO `sys_data_region` VALUES (8925, '振兴中路', 4, '230505', '230505001', 'z');
INSERT INTO `sys_data_region` VALUES (8926, '振兴东路', 4, '230505', '230505002', 'z');
INSERT INTO `sys_data_region` VALUES (8927, '集贤', 4, '230505', '230505004', 'j');
INSERT INTO `sys_data_region` VALUES (8928, '太保', 4, '230505', '230505101', 't');
INSERT INTO `sys_data_region` VALUES (8929, '宝山', 3, '2305', '230506', 'b');
INSERT INTO `sys_data_region` VALUES (8930, '红旗', 4, '230506', '230506001', 'h');
INSERT INTO `sys_data_region` VALUES (8931, '跃进', 4, '230506', '230506002', 'y');
INSERT INTO `sys_data_region` VALUES (8932, '东保卫', 4, '230506', '230506003', 'd');
INSERT INTO `sys_data_region` VALUES (8933, '七星街道', 4, '230506', '230506004', 'q');
INSERT INTO `sys_data_region` VALUES (8934, '双阳', 4, '230506', '230506005', 's');
INSERT INTO `sys_data_region` VALUES (8935, '新安', 4, '230506', '230506006', 'x');
INSERT INTO `sys_data_region` VALUES (8936, '电厂', 4, '230506', '230506007', 'd');
INSERT INTO `sys_data_region` VALUES (8937, '七星镇', 4, '230506', '230506101', 'q');
INSERT INTO `sys_data_region` VALUES (8938, '双鸭山农场', 4, '230506', '230506500', 's');
INSERT INTO `sys_data_region` VALUES (8939, '集贤', 3, '2305', '230521', 'j');
INSERT INTO `sys_data_region` VALUES (8940, '福利', 4, '230521', '230521100', 'f');
INSERT INTO `sys_data_region` VALUES (8941, '集贤镇', 4, '230521', '230521101', 'j');
INSERT INTO `sys_data_region` VALUES (8942, '升昌', 4, '230521', '230521102', 's');
INSERT INTO `sys_data_region` VALUES (8943, '丰乐', 4, '230521', '230521103', 'f');
INSERT INTO `sys_data_region` VALUES (8944, '太平', 4, '230521', '230521104', 't');
INSERT INTO `sys_data_region` VALUES (8945, '腰屯', 4, '230521', '230521201', 'y');
INSERT INTO `sys_data_region` VALUES (8946, '兴安', 4, '230521', '230521202', 'x');
INSERT INTO `sys_data_region` VALUES (8947, '永安', 4, '230521', '230521204', 'y');
INSERT INTO `sys_data_region` VALUES (8948, '太平林场', 4, '230521', '230521401', 't');
INSERT INTO `sys_data_region` VALUES (8949, '七星林场', 4, '230521', '230521403', 'q');
INSERT INTO `sys_data_region` VALUES (8950, '爱林林场', 4, '230521', '230521405', 'a');
INSERT INTO `sys_data_region` VALUES (8951, '二九一农场', 4, '230521', '230521500', 'e');
INSERT INTO `sys_data_region` VALUES (8952, '友谊', 3, '2305', '230522', 'y');
INSERT INTO `sys_data_region` VALUES (8953, '友谊镇', 4, '230522', '230522100', 'y');
INSERT INTO `sys_data_region` VALUES (8954, '友谊农场', 4, '230522', '230522502', 'y');
INSERT INTO `sys_data_region` VALUES (8955, '宝清', 3, '2305', '230523', 'b');
INSERT INTO `sys_data_region` VALUES (8956, '宝清镇', 4, '230523', '230523100', 'b');
INSERT INTO `sys_data_region` VALUES (8957, '七星泡', 4, '230523', '230523101', 'q');
INSERT INTO `sys_data_region` VALUES (8958, '青原', 4, '230523', '230523102', 'q');
INSERT INTO `sys_data_region` VALUES (8959, '夹信子', 4, '230523', '230523103', 'j');
INSERT INTO `sys_data_region` VALUES (8960, '龙头', 4, '230523', '230523104', 'l');
INSERT INTO `sys_data_region` VALUES (8961, '小城子', 4, '230523', '230523105', 'x');
INSERT INTO `sys_data_region` VALUES (8962, '朝阳', 4, '230523', '230523106', 'z');
INSERT INTO `sys_data_region` VALUES (8963, '万金山', 4, '230523', '230523203', 'w');
INSERT INTO `sys_data_region` VALUES (8964, '尖山子', 4, '230523', '230523204', 'j');
INSERT INTO `sys_data_region` VALUES (8965, '七星河', 4, '230523', '230523209', 'q');
INSERT INTO `sys_data_region` VALUES (8966, '双鸭山林业局上游经营所', 4, '230523', '230523400', 's');
INSERT INTO `sys_data_region` VALUES (8967, '五九七农场', 4, '230523', '230523500', 'w');
INSERT INTO `sys_data_region` VALUES (8968, '八五二农场', 4, '230523', '230523501', 'b');
INSERT INTO `sys_data_region` VALUES (8969, '八五三农场', 4, '230523', '230523502', 'b');
INSERT INTO `sys_data_region` VALUES (8970, '饶河', 3, '2305', '230524', 'r');
INSERT INTO `sys_data_region` VALUES (8971, '饶河镇', 4, '230524', '230524100', 'r');
INSERT INTO `sys_data_region` VALUES (8972, '小佳河', 4, '230524', '230524101', 'x');
INSERT INTO `sys_data_region` VALUES (8973, '西丰', 4, '230524', '230524102', 'x');
INSERT INTO `sys_data_region` VALUES (8974, '五林洞', 4, '230524', '230524103', 'w');
INSERT INTO `sys_data_region` VALUES (8975, '西林子', 4, '230524', '230524200', 'x');
INSERT INTO `sys_data_region` VALUES (8976, '四排', 4, '230524', '230524201', 's');
INSERT INTO `sys_data_region` VALUES (8977, '大佳河', 4, '230524', '230524203', 'd');
INSERT INTO `sys_data_region` VALUES (8978, '山里', 4, '230524', '230524204', 's');
INSERT INTO `sys_data_region` VALUES (8979, '大通河', 4, '230524', '230524207', 'd');
INSERT INTO `sys_data_region` VALUES (8980, '饶河农场', 4, '230524', '230524500', 'r');
INSERT INTO `sys_data_region` VALUES (8981, '红旗岭农场', 4, '230524', '230524501', 'h');
INSERT INTO `sys_data_region` VALUES (8982, '八五九农场', 4, '230524', '230524502', 'b');
INSERT INTO `sys_data_region` VALUES (8983, '胜利农场', 4, '230524', '230524503', 's');
INSERT INTO `sys_data_region` VALUES (8984, '红卫农场', 4, '230524', '230524504', 'h');
INSERT INTO `sys_data_region` VALUES (8985, '大庆', 2, '23', '2306', 'd');
INSERT INTO `sys_data_region` VALUES (8986, '萨尔图', 3, '2306', '230602', 's');
INSERT INTO `sys_data_region` VALUES (8987, '萨尔图街道', 4, '230602', '230602001', 's');
INSERT INTO `sys_data_region` VALUES (8988, '铁人', 4, '230602', '230602005', 't');
INSERT INTO `sys_data_region` VALUES (8989, '友谊', 4, '230602', '230602006', 'y');
INSERT INTO `sys_data_region` VALUES (8990, '富强', 4, '230602', '230602007', 'f');
INSERT INTO `sys_data_region` VALUES (8991, '拥军', 4, '230602', '230602008', 'y');
INSERT INTO `sys_data_region` VALUES (8992, '会战', 4, '230602', '230602009', 'h');
INSERT INTO `sys_data_region` VALUES (8993, '火炬', 4, '230602', '230602010', 'h');
INSERT INTO `sys_data_region` VALUES (8994, '东风', 4, '230602', '230602011', 'd');
INSERT INTO `sys_data_region` VALUES (8995, '东安', 4, '230602', '230602012', 'd');
INSERT INTO `sys_data_region` VALUES (8996, '龙凤', 3, '2306', '230603', 'l');
INSERT INTO `sys_data_region` VALUES (8997, '龙凤街道', 4, '230603', '230603001', 'l');
INSERT INTO `sys_data_region` VALUES (8998, '兴化', 4, '230603', '230603002', 'x');
INSERT INTO `sys_data_region` VALUES (8999, '卧里屯', 4, '230603', '230603007', 'w');
INSERT INTO `sys_data_region` VALUES (9000, '东光', 4, '230603', '230603008', 'd');
INSERT INTO `sys_data_region` VALUES (9001, '三永', 4, '230603', '230603009', 's');
INSERT INTO `sys_data_region` VALUES (9002, '开发区黎明', 4, '230603', '230603010', 'k');
INSERT INTO `sys_data_region` VALUES (9003, '龙凤镇', 4, '230603', '230603100', 'l');
INSERT INTO `sys_data_region` VALUES (9004, '让胡路', 3, '2306', '230604', 'r');
INSERT INTO `sys_data_region` VALUES (9005, '龙岗', 4, '230604', '230604001', 'l');
INSERT INTO `sys_data_region` VALUES (9006, '银浪', 4, '230604', '230604002', 'y');
INSERT INTO `sys_data_region` VALUES (9007, '奋斗', 4, '230604', '230604004', 'f');
INSERT INTO `sys_data_region` VALUES (9008, '庆新', 4, '230604', '230604005', 'q');
INSERT INTO `sys_data_region` VALUES (9009, '西宾', 4, '230604', '230604007', 'x');
INSERT INTO `sys_data_region` VALUES (9010, '乘风', 4, '230604', '230604009', 'c');
INSERT INTO `sys_data_region` VALUES (9011, '喇嘛甸', 4, '230604', '230604101', 'l');
INSERT INTO `sys_data_region` VALUES (9012, '红骥牧场', 4, '230604', '230604580', 'h');
INSERT INTO `sys_data_region` VALUES (9013, '星火牧场', 4, '230604', '230604581', 'x');
INSERT INTO `sys_data_region` VALUES (9014, '银浪牧场', 4, '230604', '230604582', 'y');
INSERT INTO `sys_data_region` VALUES (9015, '红岗', 3, '2306', '230605', 'h');
INSERT INTO `sys_data_region` VALUES (9016, '红岗街道', 4, '230605', '230605001', 'h');
INSERT INTO `sys_data_region` VALUES (9017, '八百垧', 4, '230605', '230605004', 'b');
INSERT INTO `sys_data_region` VALUES (9018, '杏南', 4, '230605', '230605005', 'x');
INSERT INTO `sys_data_region` VALUES (9019, '解放', 4, '230605', '230605006', 'j');
INSERT INTO `sys_data_region` VALUES (9020, '创业', 4, '230605', '230605007', 'c');
INSERT INTO `sys_data_region` VALUES (9021, '杏树岗', 4, '230605', '230605100', 'x');
INSERT INTO `sys_data_region` VALUES (9022, '大同', 3, '2306', '230606', 'd');
INSERT INTO `sys_data_region` VALUES (9023, '庆葡', 4, '230606', '230606001', 'q');
INSERT INTO `sys_data_region` VALUES (9024, '高台子镇街道', 4, '230606', '230606002', 'g');
INSERT INTO `sys_data_region` VALUES (9025, '林源镇街道', 4, '230606', '230606004', 'l');
INSERT INTO `sys_data_region` VALUES (9026, '立志', 4, '230606', '230606005', 'l');
INSERT INTO `sys_data_region` VALUES (9027, '新华', 4, '230606', '230606006', 'x');
INSERT INTO `sys_data_region` VALUES (9028, '大同镇街道', 4, '230606', '230606007', 'd');
INSERT INTO `sys_data_region` VALUES (9029, '大同镇', 4, '230606', '230606100', 'd');
INSERT INTO `sys_data_region` VALUES (9030, '高台子', 4, '230606', '230606101', 'g');
INSERT INTO `sys_data_region` VALUES (9031, '太阳升', 4, '230606', '230606102', 't');
INSERT INTO `sys_data_region` VALUES (9032, '林源', 4, '230606', '230606103', 'l');
INSERT INTO `sys_data_region` VALUES (9033, '祝三', 4, '230606', '230606200', 'z');
INSERT INTO `sys_data_region` VALUES (9034, '老山头', 4, '230606', '230606203', 'l');
INSERT INTO `sys_data_region` VALUES (9035, '八井子', 4, '230606', '230606205', 'b');
INSERT INTO `sys_data_region` VALUES (9036, '双榆树', 4, '230606', '230606206', 's');
INSERT INTO `sys_data_region` VALUES (9037, '和平牧场', 4, '230606', '230606500', 'h');
INSERT INTO `sys_data_region` VALUES (9038, '肇州', 3, '2306', '230621', 'z');
INSERT INTO `sys_data_region` VALUES (9039, '肇州镇', 4, '230621', '230621100', 'z');
INSERT INTO `sys_data_region` VALUES (9040, '永乐', 4, '230621', '230621101', 'y');
INSERT INTO `sys_data_region` VALUES (9041, '丰乐', 4, '230621', '230621102', 'f');
INSERT INTO `sys_data_region` VALUES (9042, '朝阳沟', 4, '230621', '230621103', 'z');
INSERT INTO `sys_data_region` VALUES (9043, '兴城', 4, '230621', '230621104', 'x');
INSERT INTO `sys_data_region` VALUES (9044, '二井', 4, '230621', '230621105', 'e');
INSERT INTO `sys_data_region` VALUES (9045, '双发', 4, '230621', '230621202', 's');
INSERT INTO `sys_data_region` VALUES (9046, '托古', 4, '230621', '230621203', 't');
INSERT INTO `sys_data_region` VALUES (9047, '朝阳', 4, '230621', '230621205', 'z');
INSERT INTO `sys_data_region` VALUES (9048, '永胜', 4, '230621', '230621206', 'y');
INSERT INTO `sys_data_region` VALUES (9049, '榆树', 4, '230621', '230621208', 'y');
INSERT INTO `sys_data_region` VALUES (9050, '新福', 4, '230621', '230621211', 'x');
INSERT INTO `sys_data_region` VALUES (9051, '卫星种畜场', 4, '230621', '230621581', 'w');
INSERT INTO `sys_data_region` VALUES (9052, '肇源', 3, '2306', '230622', 'z');
INSERT INTO `sys_data_region` VALUES (9053, '肇源镇', 4, '230622', '230622100', 'z');
INSERT INTO `sys_data_region` VALUES (9054, '三站', 4, '230622', '230622101', 's');
INSERT INTO `sys_data_region` VALUES (9055, '二站', 4, '230622', '230622102', 'e');
INSERT INTO `sys_data_region` VALUES (9056, '茂兴', 4, '230622', '230622103', 'm');
INSERT INTO `sys_data_region` VALUES (9057, '古龙', 4, '230622', '230622104', 'g');
INSERT INTO `sys_data_region` VALUES (9058, '新站', 4, '230622', '230622105', 'x');
INSERT INTO `sys_data_region` VALUES (9059, '头台', 4, '230622', '230622106', 't');
INSERT INTO `sys_data_region` VALUES (9060, '古恰', 4, '230622', '230622107', 'g');
INSERT INTO `sys_data_region` VALUES (9061, '福兴', 4, '230622', '230622200', 'f');
INSERT INTO `sys_data_region` VALUES (9062, '薄荷台', 4, '230622', '230622201', 'b');
INSERT INTO `sys_data_region` VALUES (9063, '和平', 4, '230622', '230622203', 'h');
INSERT INTO `sys_data_region` VALUES (9064, '超等', 4, '230622', '230622207', 'c');
INSERT INTO `sys_data_region` VALUES (9065, '民意', 4, '230622', '230622208', 'm');
INSERT INTO `sys_data_region` VALUES (9066, '义顺', 4, '230622', '230622210', 'y');
INSERT INTO `sys_data_region` VALUES (9067, '浩德', 4, '230622', '230622211', 'h');
INSERT INTO `sys_data_region` VALUES (9068, '大兴', 4, '230622', '230622212', 'd');
INSERT INTO `sys_data_region` VALUES (9069, '林甸', 3, '2306', '230623', 'l');
INSERT INTO `sys_data_region` VALUES (9070, '林甸镇', 4, '230623', '230623100', 'l');
INSERT INTO `sys_data_region` VALUES (9071, '红旗', 4, '230623', '230623101', 'h');
INSERT INTO `sys_data_region` VALUES (9072, '花园', 4, '230623', '230623102', 'h');
INSERT INTO `sys_data_region` VALUES (9073, '四季青', 4, '230623', '230623103', 's');
INSERT INTO `sys_data_region` VALUES (9074, '鹤鸣湖', 4, '230623', '230623104', 'h');
INSERT INTO `sys_data_region` VALUES (9075, '东兴', 4, '230623', '230623200', 'd');
INSERT INTO `sys_data_region` VALUES (9076, '宏伟', 4, '230623', '230623202', 'h');
INSERT INTO `sys_data_region` VALUES (9077, '四合', 4, '230623', '230623206', 's');
INSERT INTO `sys_data_region` VALUES (9078, '长青林场', 4, '230623', '230623400', 'c');
INSERT INTO `sys_data_region` VALUES (9079, '巨浪牧场', 4, '230623', '230623500', 'j');
INSERT INTO `sys_data_region` VALUES (9080, '国营苇场', 4, '230623', '230623580', 'g');
INSERT INTO `sys_data_region` VALUES (9081, '新兴畜牧场', 4, '230623', '230623581', 'x');
INSERT INTO `sys_data_region` VALUES (9082, '杜尔伯特', 3, '2306', '230624', 'd');
INSERT INTO `sys_data_region` VALUES (9083, '杜尔伯特镇', 4, '230624', '230624100', 'd');
INSERT INTO `sys_data_region` VALUES (9084, '胡吉吐莫', 4, '230624', '230624101', 'h');
INSERT INTO `sys_data_region` VALUES (9085, '烟筒屯', 4, '230624', '230624102', 'y');
INSERT INTO `sys_data_region` VALUES (9086, '他拉哈', 4, '230624', '230624103', 't');
INSERT INTO `sys_data_region` VALUES (9087, '连环湖', 4, '230624', '230624104', 'l');
INSERT INTO `sys_data_region` VALUES (9088, '一心', 4, '230624', '230624200', 'y');
INSERT INTO `sys_data_region` VALUES (9089, '克尔台', 4, '230624', '230624201', 'k');
INSERT INTO `sys_data_region` VALUES (9090, '敖林西伯', 4, '230624', '230624203', 'a');
INSERT INTO `sys_data_region` VALUES (9091, '巴彦查干', 4, '230624', '230624204', 'b');
INSERT INTO `sys_data_region` VALUES (9092, '腰新', 4, '230624', '230624205', 'y');
INSERT INTO `sys_data_region` VALUES (9093, '江湾', 4, '230624', '230624206', 'j');
INSERT INTO `sys_data_region` VALUES (9094, '绿色草原牧场', 4, '230624', '230624500', 'l');
INSERT INTO `sys_data_region` VALUES (9095, '大山种羊场', 4, '230624', '230624501', 'd');
INSERT INTO `sys_data_region` VALUES (9096, '伊春', 2, '23', '2307', 'y');
INSERT INTO `sys_data_region` VALUES (9097, '伊美', 3, '2307', '230717', 'y');
INSERT INTO `sys_data_region` VALUES (9098, '朝阳', 4, '230717', '230717001', 'z');
INSERT INTO `sys_data_region` VALUES (9099, '前进', 4, '230717', '230717002', 'q');
INSERT INTO `sys_data_region` VALUES (9100, '红升', 4, '230717', '230717003', 'h');
INSERT INTO `sys_data_region` VALUES (9101, '旭日', 4, '230717', '230717004', 'x');
INSERT INTO `sys_data_region` VALUES (9102, '新欣', 4, '230717', '230717005', 'x');
INSERT INTO `sys_data_region` VALUES (9103, '南郡', 4, '230717', '230717006', 'n');
INSERT INTO `sys_data_region` VALUES (9104, '东升', 4, '230717', '230717100', 'd');
INSERT INTO `sys_data_region` VALUES (9105, '美溪', 4, '230717', '230717101', 'm');
INSERT INTO `sys_data_region` VALUES (9106, '伊东经营所', 4, '230717', '230717406', 'y');
INSERT INTO `sys_data_region` VALUES (9107, '伊青经营所', 4, '230717', '230717408', 'y');
INSERT INTO `sys_data_region` VALUES (9108, '伊林经营所', 4, '230717', '230717411', 'y');
INSERT INTO `sys_data_region` VALUES (9109, '青山口林场', 4, '230717', '230717421', 'q');
INSERT INTO `sys_data_region` VALUES (9110, '金沙河林场', 4, '230717', '230717422', 'j');
INSERT INTO `sys_data_region` VALUES (9111, '大西林林场', 4, '230717', '230717423', 'd');
INSERT INTO `sys_data_region` VALUES (9112, '桦皮羌子林场', 4, '230717', '230717424', 'h');
INSERT INTO `sys_data_region` VALUES (9113, '碧仓库林场', 4, '230717', '230717425', 'b');
INSERT INTO `sys_data_region` VALUES (9114, '乌翠', 3, '2307', '230718', 'w');
INSERT INTO `sys_data_region` VALUES (9115, '乌马河', 4, '230718', '230718001', 'w');
INSERT INTO `sys_data_region` VALUES (9116, '锦山', 4, '230718', '230718002', 'j');
INSERT INTO `sys_data_region` VALUES (9117, '曙光', 4, '230718', '230718003', 's');
INSERT INTO `sys_data_region` VALUES (9118, '向阳', 4, '230718', '230718004', 'x');
INSERT INTO `sys_data_region` VALUES (9119, '解放经营所', 4, '230718', '230718400', 'j');
INSERT INTO `sys_data_region` VALUES (9120, '么河经营所', 4, '230718', '230718403', 'm');
INSERT INTO `sys_data_region` VALUES (9121, '冲锋经营所', 4, '230718', '230718404', 'c');
INSERT INTO `sys_data_region` VALUES (9122, '翠峦河经营所', 4, '230718', '230718405', 'c');
INSERT INTO `sys_data_region` VALUES (9123, '抚育河经营所', 4, '230718', '230718406', 'f');
INSERT INTO `sys_data_region` VALUES (9124, '尖山河经营所', 4, '230718', '230718407', 'j');
INSERT INTO `sys_data_region` VALUES (9125, '前进经营所', 4, '230718', '230718409', 'q');
INSERT INTO `sys_data_region` VALUES (9126, '翠岭经营所', 4, '230718', '230718410', 'c');
INSERT INTO `sys_data_region` VALUES (9127, '河北经营所', 4, '230718', '230718411', 'h');
INSERT INTO `sys_data_region` VALUES (9128, '育苗经营所', 4, '230718', '230718412', 'y');
INSERT INTO `sys_data_region` VALUES (9129, '安全经营所', 4, '230718', '230718413', 'a');
INSERT INTO `sys_data_region` VALUES (9130, '昆仑气林场', 4, '230718', '230718414', 'k');
INSERT INTO `sys_data_region` VALUES (9131, '东方红农场', 4, '230718', '230718415', 'd');
INSERT INTO `sys_data_region` VALUES (9132, '开源河林场', 4, '230718', '230718416', 'k');
INSERT INTO `sys_data_region` VALUES (9133, '青山林场', 4, '230718', '230718417', 'q');
INSERT INTO `sys_data_region` VALUES (9134, '西岭林场', 4, '230718', '230718418', 'x');
INSERT INTO `sys_data_region` VALUES (9135, '伊敏林场', 4, '230718', '230718419', 'y');
INSERT INTO `sys_data_region` VALUES (9136, '友好', 3, '2307', '230719', 'y');
INSERT INTO `sys_data_region` VALUES (9137, '友好街道', 4, '230719', '230719001', 'y');
INSERT INTO `sys_data_region` VALUES (9138, '双子河', 4, '230719', '230719003', 's');
INSERT INTO `sys_data_region` VALUES (9139, '铁林', 4, '230719', '230719004', 't');
INSERT INTO `sys_data_region` VALUES (9140, '上甘岭', 4, '230719', '230719100', 's');
INSERT INTO `sys_data_region` VALUES (9141, '三合经营所', 4, '230719', '230719400', 's');
INSERT INTO `sys_data_region` VALUES (9142, '松园林场', 4, '230719', '230719401', 's');
INSERT INTO `sys_data_region` VALUES (9143, '中心经营所', 4, '230719', '230719402', 'z');
INSERT INTO `sys_data_region` VALUES (9144, '永青经营所', 4, '230719', '230719403', 'y');
INSERT INTO `sys_data_region` VALUES (9145, '碧云经营所', 4, '230719', '230719404', 'b');
INSERT INTO `sys_data_region` VALUES (9146, '友谊经营所', 4, '230719', '230719405', 'y');
INSERT INTO `sys_data_region` VALUES (9147, '青杨经营所', 4, '230719', '230719406', 'q');
INSERT INTO `sys_data_region` VALUES (9148, '岭峰林场', 4, '230719', '230719407', 'l');
INSERT INTO `sys_data_region` VALUES (9149, '奋斗林场', 4, '230719', '230719408', 'f');
INSERT INTO `sys_data_region` VALUES (9150, '东卡林场', 4, '230719', '230719409', 'd');
INSERT INTO `sys_data_region` VALUES (9151, '鸡爪河林场', 4, '230719', '230719410', 'j');
INSERT INTO `sys_data_region` VALUES (9152, '绿源林场', 4, '230719', '230719411', 'l');
INSERT INTO `sys_data_region` VALUES (9153, '广川经营所', 4, '230719', '230719412', 'g');
INSERT INTO `sys_data_region` VALUES (9154, '朝阳经营所', 4, '230719', '230719413', 'z');
INSERT INTO `sys_data_region` VALUES (9155, '查山经营所', 4, '230719', '230719415', 'c');
INSERT INTO `sys_data_region` VALUES (9156, '红山经营所', 4, '230719', '230719417', 'h');
INSERT INTO `sys_data_region` VALUES (9157, '卫国林场', 4, '230719', '230719418', 'w');
INSERT INTO `sys_data_region` VALUES (9158, '蔚兰经营所', 4, '230719', '230719419', 'w');
INSERT INTO `sys_data_region` VALUES (9159, '青山农场', 4, '230719', '230719420', 'q');
INSERT INTO `sys_data_region` VALUES (9160, '美林经营所', 4, '230719', '230719421', 'm');
INSERT INTO `sys_data_region` VALUES (9161, '永绪经营所', 4, '230719', '230719422', 'y');
INSERT INTO `sys_data_region` VALUES (9162, '溪水经营所', 4, '230719', '230719423', 'x');
INSERT INTO `sys_data_region` VALUES (9163, '长青经营所', 4, '230719', '230719424', 'c');
INSERT INTO `sys_data_region` VALUES (9164, '嘉荫', 3, '2307', '230722', 'j');
INSERT INTO `sys_data_region` VALUES (9165, '朝阳', 4, '230722', '230722100', 'z');
INSERT INTO `sys_data_region` VALUES (9166, '乌云', 4, '230722', '230722101', 'w');
INSERT INTO `sys_data_region` VALUES (9167, '乌拉嘎', 4, '230722', '230722102', 'w');
INSERT INTO `sys_data_region` VALUES (9168, '保兴', 4, '230722', '230722103', 'b');
INSERT INTO `sys_data_region` VALUES (9169, '常胜', 4, '230722', '230722200', 'c');
INSERT INTO `sys_data_region` VALUES (9170, '向阳', 4, '230722', '230722201', 'x');
INSERT INTO `sys_data_region` VALUES (9171, '沪嘉', 4, '230722', '230722202', 'h');
INSERT INTO `sys_data_region` VALUES (9172, '红光', 4, '230722', '230722203', 'h');
INSERT INTO `sys_data_region` VALUES (9173, '青山', 4, '230722', '230722205', 'q');
INSERT INTO `sys_data_region` VALUES (9174, '嘉荫农场', 4, '230722', '230722500', 'j');
INSERT INTO `sys_data_region` VALUES (9175, '汤旺', 3, '2307', '230723', 't');
INSERT INTO `sys_data_region` VALUES (9176, '乌伊岭', 4, '230723', '230723100', 'w');
INSERT INTO `sys_data_region` VALUES (9177, '汤旺河', 4, '230723', '230723101', 't');
INSERT INTO `sys_data_region` VALUES (9178, '丰林', 3, '2307', '230724', 'f');
INSERT INTO `sys_data_region` VALUES (9179, '新青', 4, '230724', '230724100', 'x');
INSERT INTO `sys_data_region` VALUES (9180, '红星', 4, '230724', '230724101', 'h');
INSERT INTO `sys_data_region` VALUES (9181, '五营', 4, '230724', '230724102', 'w');
INSERT INTO `sys_data_region` VALUES (9182, '大箐山', 3, '2307', '230725', 'd');
INSERT INTO `sys_data_region` VALUES (9183, '带岭', 4, '230725', '230725001', 'd');
INSERT INTO `sys_data_region` VALUES (9184, '朗乡', 4, '230725', '230725101', 'l');
INSERT INTO `sys_data_region` VALUES (9185, '大青川林场', 4, '230725', '230725400', 'd');
INSERT INTO `sys_data_region` VALUES (9186, '东方红林场', 4, '230725', '230725401', 'd');
INSERT INTO `sys_data_region` VALUES (9187, '秀水林场', 4, '230725', '230725402', 'x');
INSERT INTO `sys_data_region` VALUES (9188, '永翠林场', 4, '230725', '230725403', 'y');
INSERT INTO `sys_data_region` VALUES (9189, '明月林场', 4, '230725', '230725404', 'm');
INSERT INTO `sys_data_region` VALUES (9190, '红光林场', 4, '230725', '230725405', 'h');
INSERT INTO `sys_data_region` VALUES (9191, '秋沙鸭自然保护区', 4, '230725', '230725406', 'q');
INSERT INTO `sys_data_region` VALUES (9192, '北列林场', 4, '230725', '230725407', 'b');
INSERT INTO `sys_data_region` VALUES (9193, '南列林场', 4, '230725', '230725408', 'n');
INSERT INTO `sys_data_region` VALUES (9194, '寒月林场', 4, '230725', '230725409', 'h');
INSERT INTO `sys_data_region` VALUES (9195, '环山林场', 4, '230725', '230725410', 'h');
INSERT INTO `sys_data_region` VALUES (9196, '凉水自然保护区', 4, '230725', '230725411', 'l');
INSERT INTO `sys_data_region` VALUES (9197, '朗乡林业局', 4, '230725', '230725412', 'l');
INSERT INTO `sys_data_region` VALUES (9198, '南岔', 3, '2307', '230726', 'n');
INSERT INTO `sys_data_region` VALUES (9199, '南岔镇', 4, '230726', '230726100', 'n');
INSERT INTO `sys_data_region` VALUES (9200, '晨明', 4, '230726', '230726101', 'c');
INSERT INTO `sys_data_region` VALUES (9201, '浩良河', 4, '230726', '230726102', 'h');
INSERT INTO `sys_data_region` VALUES (9202, '迎春', 4, '230726', '230726200', 'y');
INSERT INTO `sys_data_region` VALUES (9203, '三岔河林场', 4, '230726', '230726400', 's');
INSERT INTO `sys_data_region` VALUES (9204, '四合营林场', 4, '230726', '230726401', 's');
INSERT INTO `sys_data_region` VALUES (9205, '亮子河林场', 4, '230726', '230726402', 'l');
INSERT INTO `sys_data_region` VALUES (9206, '石头河林场', 4, '230726', '230726403', 's');
INSERT INTO `sys_data_region` VALUES (9207, '岩石经营所', 4, '230726', '230726405', 'y');
INSERT INTO `sys_data_region` VALUES (9208, '奋斗经营所', 4, '230726', '230726406', 'f');
INSERT INTO `sys_data_region` VALUES (9209, '桦阳经营所', 4, '230726', '230726407', 'h');
INSERT INTO `sys_data_region` VALUES (9210, '浩良河经营所', 4, '230726', '230726408', 'h');
INSERT INTO `sys_data_region` VALUES (9211, '南岔经营所', 4, '230726', '230726410', 'n');
INSERT INTO `sys_data_region` VALUES (9212, '威岭经营所', 4, '230726', '230726411', 'w');
INSERT INTO `sys_data_region` VALUES (9213, '松青经营所', 4, '230726', '230726413', 's');
INSERT INTO `sys_data_region` VALUES (9214, '柳树经营所', 4, '230726', '230726414', 'l');
INSERT INTO `sys_data_region` VALUES (9215, '金林', 3, '2307', '230751', 'j');
INSERT INTO `sys_data_region` VALUES (9216, '西林', 4, '230751', '230751100', 'x');
INSERT INTO `sys_data_region` VALUES (9217, '金山屯', 4, '230751', '230751101', 'j');
INSERT INTO `sys_data_region` VALUES (9218, '丰茂林场', 4, '230751', '230751405', 'f');
INSERT INTO `sys_data_region` VALUES (9219, '铁力', 3, '2307', '230781', 't');
INSERT INTO `sys_data_region` VALUES (9220, '铁力镇', 4, '230781', '230781100', 't');
INSERT INTO `sys_data_region` VALUES (9221, '双丰', 4, '230781', '230781101', 's');
INSERT INTO `sys_data_region` VALUES (9222, '桃山', 4, '230781', '230781102', 't');
INSERT INTO `sys_data_region` VALUES (9223, '神树', 4, '230781', '230781105', 's');
INSERT INTO `sys_data_region` VALUES (9224, '年丰', 4, '230781', '230781200', 'n');
INSERT INTO `sys_data_region` VALUES (9225, '工农', 4, '230781', '230781201', 'g');
INSERT INTO `sys_data_region` VALUES (9226, '王杨', 4, '230781', '230781202', 'w');
INSERT INTO `sys_data_region` VALUES (9227, '铁力林业局', 4, '230781', '230781400', 't');
INSERT INTO `sys_data_region` VALUES (9228, '双丰林业局', 4, '230781', '230781401', 's');
INSERT INTO `sys_data_region` VALUES (9229, '桃山林业局', 4, '230781', '230781402', 't');
INSERT INTO `sys_data_region` VALUES (9230, '铁力农场', 4, '230781', '230781500', 't');
INSERT INTO `sys_data_region` VALUES (9231, '佳木斯', 2, '23', '2308', 'j');
INSERT INTO `sys_data_region` VALUES (9232, '向阳', 3, '2308', '230803', 'x');
INSERT INTO `sys_data_region` VALUES (9233, '西林', 4, '230803', '230803001', 'x');
INSERT INTO `sys_data_region` VALUES (9234, '桥南', 4, '230803', '230803003', 'q');
INSERT INTO `sys_data_region` VALUES (9235, '长安', 4, '230803', '230803005', 'c');
INSERT INTO `sys_data_region` VALUES (9236, '建设', 4, '230803', '230803006', 'j');
INSERT INTO `sys_data_region` VALUES (9237, '学府', 4, '230803', '230803010', 'x');
INSERT INTO `sys_data_region` VALUES (9238, '向阳区直辖地域', 4, '230803', '230803198', 'x');
INSERT INTO `sys_data_region` VALUES (9239, '前进', 3, '2308', '230804', 'q');
INSERT INTO `sys_data_region` VALUES (9240, '永安', 4, '230804', '230804007', 'y');
INSERT INTO `sys_data_region` VALUES (9241, '港湾', 4, '230804', '230804008', 'g');
INSERT INTO `sys_data_region` VALUES (9242, '和平', 4, '230804', '230804009', 'h');
INSERT INTO `sys_data_region` VALUES (9243, '山水', 4, '230804', '230804010', 's');
INSERT INTO `sys_data_region` VALUES (9244, '前进区农垦', 4, '230804', '230804579', 'q');
INSERT INTO `sys_data_region` VALUES (9245, '东风', 3, '2308', '230805', 'd');
INSERT INTO `sys_data_region` VALUES (9246, '晓云', 4, '230805', '230805007', 'x');
INSERT INTO `sys_data_region` VALUES (9247, '佳东', 4, '230805', '230805008', 'j');
INSERT INTO `sys_data_region` VALUES (9248, '建国街道', 4, '230805', '230805009', 'j');
INSERT INTO `sys_data_region` VALUES (9249, '佳南', 4, '230805', '230805010', 'j');
INSERT INTO `sys_data_region` VALUES (9250, '建国镇', 4, '230805', '230805101', 'j');
INSERT INTO `sys_data_region` VALUES (9251, '松江', 4, '230805', '230805200', 's');
INSERT INTO `sys_data_region` VALUES (9252, '东风区农垦', 4, '230805', '230805579', 'd');
INSERT INTO `sys_data_region` VALUES (9253, '郊区', 3, '2308', '230811', 'j');
INSERT INTO `sys_data_region` VALUES (9254, '友谊', 4, '230811', '230811003', 'y');
INSERT INTO `sys_data_region` VALUES (9255, '云环', 4, '230811', '230811008', 'y');
INSERT INTO `sys_data_region` VALUES (9256, '英俊', 4, '230811', '230811009', 'y');
INSERT INTO `sys_data_region` VALUES (9257, '红旗', 4, '230811', '230811010', 'h');
INSERT INTO `sys_data_region` VALUES (9258, '大来', 4, '230811', '230811101', 'd');
INSERT INTO `sys_data_region` VALUES (9259, '敖其', 4, '230811', '230811102', 'a');
INSERT INTO `sys_data_region` VALUES (9260, '望江', 4, '230811', '230811103', 'w');
INSERT INTO `sys_data_region` VALUES (9261, '长发', 4, '230811', '230811104', 'c');
INSERT INTO `sys_data_region` VALUES (9262, '莲江口', 4, '230811', '230811105', 'l');
INSERT INTO `sys_data_region` VALUES (9263, '西格木', 4, '230811', '230811106', 'x');
INSERT INTO `sys_data_region` VALUES (9264, '沿江', 4, '230811', '230811107', 'y');
INSERT INTO `sys_data_region` VALUES (9265, '四丰', 4, '230811', '230811108', 's');
INSERT INTO `sys_data_region` VALUES (9266, '长青', 4, '230811', '230811200', 'c');
INSERT INTO `sys_data_region` VALUES (9267, '平安', 4, '230811', '230811208', 'p');
INSERT INTO `sys_data_region` VALUES (9268, '群胜', 4, '230811', '230811211', 'q');
INSERT INTO `sys_data_region` VALUES (9269, '桦南', 3, '2308', '230822', 'h');
INSERT INTO `sys_data_region` VALUES (9270, '驼腰子', 4, '230822', '230822103', 't');
INSERT INTO `sys_data_region` VALUES (9271, '石头河子', 4, '230822', '230822104', 's');
INSERT INTO `sys_data_region` VALUES (9272, '桦南镇', 4, '230822', '230822106', 'h');
INSERT INTO `sys_data_region` VALUES (9273, '土龙山', 4, '230822', '230822107', 't');
INSERT INTO `sys_data_region` VALUES (9274, '孟家岗', 4, '230822', '230822108', 'm');
INSERT INTO `sys_data_region` VALUES (9275, '闫家', 4, '230822', '230822109', 'y');
INSERT INTO `sys_data_region` VALUES (9276, '柳毛河', 4, '230822', '230822110', 'l');
INSERT INTO `sys_data_region` VALUES (9277, '金沙', 4, '230822', '230822205', 'j');
INSERT INTO `sys_data_region` VALUES (9278, '梨树', 4, '230822', '230822213', 'l');
INSERT INTO `sys_data_region` VALUES (9279, '明义', 4, '230822', '230822214', 'm');
INSERT INTO `sys_data_region` VALUES (9280, '大八浪', 4, '230822', '230822215', 'd');
INSERT INTO `sys_data_region` VALUES (9281, '五道岗', 4, '230822', '230822216', 'w');
INSERT INTO `sys_data_region` VALUES (9282, '桦川', 3, '2308', '230826', 'h');
INSERT INTO `sys_data_region` VALUES (9283, '横头山', 4, '230826', '230826101', 'h');
INSERT INTO `sys_data_region` VALUES (9284, '苏家店', 4, '230826', '230826103', 's');
INSERT INTO `sys_data_region` VALUES (9285, '悦来', 4, '230826', '230826104', 'y');
INSERT INTO `sys_data_region` VALUES (9286, '新城', 4, '230826', '230826105', 'x');
INSERT INTO `sys_data_region` VALUES (9287, '四马架', 4, '230826', '230826108', 's');
INSERT INTO `sys_data_region` VALUES (9288, '东河', 4, '230826', '230826201', 'd');
INSERT INTO `sys_data_region` VALUES (9289, '梨丰', 4, '230826', '230826202', 'l');
INSERT INTO `sys_data_region` VALUES (9290, '创业', 4, '230826', '230826205', 'c');
INSERT INTO `sys_data_region` VALUES (9291, '星火', 4, '230826', '230826207', 'x');
INSERT INTO `sys_data_region` VALUES (9292, '江川农场', 4, '230826', '230826500', 'j');
INSERT INTO `sys_data_region` VALUES (9293, '宝山农场', 4, '230826', '230826501', 'b');
INSERT INTO `sys_data_region` VALUES (9294, '汤原', 3, '2308', '230828', 't');
INSERT INTO `sys_data_region` VALUES (9295, '香兰', 4, '230828', '230828101', 'x');
INSERT INTO `sys_data_region` VALUES (9296, '鹤立', 4, '230828', '230828102', 'h');
INSERT INTO `sys_data_region` VALUES (9297, '竹帘', 4, '230828', '230828103', 'z');
INSERT INTO `sys_data_region` VALUES (9298, '汤原镇', 4, '230828', '230828104', 't');
INSERT INTO `sys_data_region` VALUES (9299, '汤旺', 4, '230828', '230828201', 't');
INSERT INTO `sys_data_region` VALUES (9300, '胜利', 4, '230828', '230828203', 's');
INSERT INTO `sys_data_region` VALUES (9301, '吉祥', 4, '230828', '230828208', 'j');
INSERT INTO `sys_data_region` VALUES (9302, '振兴', 4, '230828', '230828209', 'z');
INSERT INTO `sys_data_region` VALUES (9303, '太平川', 4, '230828', '230828210', 't');
INSERT INTO `sys_data_region` VALUES (9304, '永发', 4, '230828', '230828211', 'y');
INSERT INTO `sys_data_region` VALUES (9305, '鹤立林业局', 4, '230828', '230828400', 'h');
INSERT INTO `sys_data_region` VALUES (9306, '汤原农场', 4, '230828', '230828500', 't');
INSERT INTO `sys_data_region` VALUES (9307, '梧桐河农场', 4, '230828', '230828501', 'w');
INSERT INTO `sys_data_region` VALUES (9308, '同江', 3, '2308', '230881', 't');
INSERT INTO `sys_data_region` VALUES (9309, '同江镇', 4, '230881', '230881100', 't');
INSERT INTO `sys_data_region` VALUES (9310, '乐业', 4, '230881', '230881101', 'l');
INSERT INTO `sys_data_region` VALUES (9311, '三村', 4, '230881', '230881102', 's');
INSERT INTO `sys_data_region` VALUES (9312, '临江', 4, '230881', '230881103', 'l');
INSERT INTO `sys_data_region` VALUES (9313, '向阳', 4, '230881', '230881104', 'x');
INSERT INTO `sys_data_region` VALUES (9314, '青河', 4, '230881', '230881105', 'q');
INSERT INTO `sys_data_region` VALUES (9315, '街津口', 4, '230881', '230881204', 'j');
INSERT INTO `sys_data_region` VALUES (9316, '八岔', 4, '230881', '230881205', 'b');
INSERT INTO `sys_data_region` VALUES (9317, '金川', 4, '230881', '230881206', 'j');
INSERT INTO `sys_data_region` VALUES (9318, '银川', 4, '230881', '230881207', 'y');
INSERT INTO `sys_data_region` VALUES (9319, '勤得利农场', 4, '230881', '230881500', 'q');
INSERT INTO `sys_data_region` VALUES (9320, '青龙山农场', 4, '230881', '230881501', 'q');
INSERT INTO `sys_data_region` VALUES (9321, '前进农场', 4, '230881', '230881502', 'q');
INSERT INTO `sys_data_region` VALUES (9322, '洪河农场', 4, '230881', '230881503', 'h');
INSERT INTO `sys_data_region` VALUES (9323, '鸭绿河农场', 4, '230881', '230881504', 'y');
INSERT INTO `sys_data_region` VALUES (9324, '浓江农场', 4, '230881', '230881505', 'n');
INSERT INTO `sys_data_region` VALUES (9325, '富锦', 3, '2308', '230882', 'f');
INSERT INTO `sys_data_region` VALUES (9326, '城东', 4, '230882', '230882002', 'c');
INSERT INTO `sys_data_region` VALUES (9327, '城西', 4, '230882', '230882003', 'c');
INSERT INTO `sys_data_region` VALUES (9328, '富锦镇', 4, '230882', '230882101', 'f');
INSERT INTO `sys_data_region` VALUES (9329, '长安', 4, '230882', '230882103', 'c');
INSERT INTO `sys_data_region` VALUES (9330, '砚山', 4, '230882', '230882106', 'y');
INSERT INTO `sys_data_region` VALUES (9331, '头林', 4, '230882', '230882107', 't');
INSERT INTO `sys_data_region` VALUES (9332, '兴隆岗', 4, '230882', '230882108', 'x');
INSERT INTO `sys_data_region` VALUES (9333, '宏胜', 4, '230882', '230882109', 'h');
INSERT INTO `sys_data_region` VALUES (9334, '向阳川', 4, '230882', '230882110', 'x');
INSERT INTO `sys_data_region` VALUES (9335, '二龙山', 4, '230882', '230882111', 'e');
INSERT INTO `sys_data_region` VALUES (9336, '锦山', 4, '230882', '230882113', 'j');
INSERT INTO `sys_data_region` VALUES (9337, '大榆树', 4, '230882', '230882114', 'd');
INSERT INTO `sys_data_region` VALUES (9338, '上街基', 4, '230882', '230882119', 's');
INSERT INTO `sys_data_region` VALUES (9339, '七星农场', 4, '230882', '230882501', 'q');
INSERT INTO `sys_data_region` VALUES (9340, '大兴农场', 4, '230882', '230882502', 'd');
INSERT INTO `sys_data_region` VALUES (9341, '创业农场', 4, '230882', '230882503', 'c');
INSERT INTO `sys_data_region` VALUES (9342, '抚远', 3, '2308', '230883', 'f');
INSERT INTO `sys_data_region` VALUES (9343, '抚远镇', 4, '230883', '230883100', 'f');
INSERT INTO `sys_data_region` VALUES (9344, '寒葱沟', 4, '230883', '230883101', 'h');
INSERT INTO `sys_data_region` VALUES (9345, '浓桥', 4, '230883', '230883102', 'n');
INSERT INTO `sys_data_region` VALUES (9346, '乌苏', 4, '230883', '230883103', 'w');
INSERT INTO `sys_data_region` VALUES (9347, '通江', 4, '230883', '230883105', 't');
INSERT INTO `sys_data_region` VALUES (9348, '海清', 4, '230883', '230883106', 'h');
INSERT INTO `sys_data_region` VALUES (9349, '浓江', 4, '230883', '230883201', 'n');
INSERT INTO `sys_data_region` VALUES (9350, '别拉洪', 4, '230883', '230883203', 'b');
INSERT INTO `sys_data_region` VALUES (9351, '鸭南', 4, '230883', '230883204', 'y');
INSERT INTO `sys_data_region` VALUES (9352, '前哨农场', 4, '230883', '230883500', 'q');
INSERT INTO `sys_data_region` VALUES (9353, '前锋农场', 4, '230883', '230883501', 'q');
INSERT INTO `sys_data_region` VALUES (9354, '二道河农场', 4, '230883', '230883502', 'e');
INSERT INTO `sys_data_region` VALUES (9355, '七台河', 2, '23', '2309', 'q');
INSERT INTO `sys_data_region` VALUES (9356, '新兴', 3, '2309', '230902', 'x');
INSERT INTO `sys_data_region` VALUES (9357, '兴华', 4, '230902', '230902001', 'x');
INSERT INTO `sys_data_region` VALUES (9358, '新城', 4, '230902', '230902002', 'x');
INSERT INTO `sys_data_region` VALUES (9359, '新立', 4, '230902', '230902003', 'x');
INSERT INTO `sys_data_region` VALUES (9360, '新建', 4, '230902', '230902004', 'x');
INSERT INTO `sys_data_region` VALUES (9361, '北山', 4, '230902', '230902005', 'b');
INSERT INTO `sys_data_region` VALUES (9362, '河南', 4, '230902', '230902006', 'h');
INSERT INTO `sys_data_region` VALUES (9363, '新合', 4, '230902', '230902007', 'x');
INSERT INTO `sys_data_region` VALUES (9364, '缸窑沟', 4, '230902', '230902008', 'g');
INSERT INTO `sys_data_region` VALUES (9365, '新安', 4, '230902', '230902009', 'x');
INSERT INTO `sys_data_region` VALUES (9366, '越秀', 4, '230902', '230902010', 'y');
INSERT INTO `sys_data_region` VALUES (9367, '兴乐社区服务站', 4, '230902', '230902012', 'x');
INSERT INTO `sys_data_region` VALUES (9368, '兴富社区服务站', 4, '230902', '230902013', 'x');
INSERT INTO `sys_data_region` VALUES (9369, '兴秀社区服务站', 4, '230902', '230902014', 'x');
INSERT INTO `sys_data_region` VALUES (9370, '兴平社区服务站', 4, '230902', '230902015', 'x');
INSERT INTO `sys_data_region` VALUES (9371, '兴和社区服务站', 4, '230902', '230902016', 'x');
INSERT INTO `sys_data_region` VALUES (9372, '兴城社区服务站', 4, '230902', '230902017', 'x');
INSERT INTO `sys_data_region` VALUES (9373, '红旗', 4, '230902', '230902100', 'h');
INSERT INTO `sys_data_region` VALUES (9374, '长兴', 4, '230902', '230902200', 'c');
INSERT INTO `sys_data_region` VALUES (9375, '桦南林业局', 4, '230902', '230902400', 'h');
INSERT INTO `sys_data_region` VALUES (9376, '种畜场', 4, '230902', '230902480', 'z');
INSERT INTO `sys_data_region` VALUES (9377, '北兴农场', 4, '230902', '230902500', 'b');
INSERT INTO `sys_data_region` VALUES (9378, '黑龙江红兴隆农垦宝利采金', 4, '230902', '230902579', 'h');
INSERT INTO `sys_data_region` VALUES (9379, '桃山', 3, '2309', '230903', 't');
INSERT INTO `sys_data_region` VALUES (9380, '桃东', 4, '230903', '230903001', 't');
INSERT INTO `sys_data_region` VALUES (9381, '桃南', 4, '230903', '230903002', 't');
INSERT INTO `sys_data_region` VALUES (9382, '桃西', 4, '230903', '230903003', 't');
INSERT INTO `sys_data_region` VALUES (9383, '桃北', 4, '230903', '230903004', 't');
INSERT INTO `sys_data_region` VALUES (9384, '桃源', 4, '230903', '230903005', 't');
INSERT INTO `sys_data_region` VALUES (9385, '桃山街道', 4, '230903', '230903006', 't');
INSERT INTO `sys_data_region` VALUES (9386, '运销社区服务站', 4, '230903', '230903009', 'y');
INSERT INTO `sys_data_region` VALUES (9387, '广平社区服务站', 4, '230903', '230903011', 'g');
INSERT INTO `sys_data_region` VALUES (9388, '夏日社区服务站', 4, '230903', '230903012', 'x');
INSERT INTO `sys_data_region` VALUES (9389, '万宝河', 4, '230903', '230903100', 'w');
INSERT INTO `sys_data_region` VALUES (9390, '茄子河', 3, '2309', '230904', 'q');
INSERT INTO `sys_data_region` VALUES (9391, '东风', 4, '230904', '230904001', 'd');
INSERT INTO `sys_data_region` VALUES (9392, '向阳', 4, '230904', '230904002', 'x');
INSERT INTO `sys_data_region` VALUES (9393, '富强', 4, '230904', '230904003', 'f');
INSERT INTO `sys_data_region` VALUES (9394, '新富', 4, '230904', '230904004', 'x');
INSERT INTO `sys_data_region` VALUES (9395, '龙湖', 4, '230904', '230904005', 'l');
INSERT INTO `sys_data_region` VALUES (9396, '茄子河镇', 4, '230904', '230904100', 'q');
INSERT INTO `sys_data_region` VALUES (9397, '宏伟', 4, '230904', '230904101', 'h');
INSERT INTO `sys_data_region` VALUES (9398, '铁山', 4, '230904', '230904200', 't');
INSERT INTO `sys_data_region` VALUES (9399, '中心河', 4, '230904', '230904201', 'z');
INSERT INTO `sys_data_region` VALUES (9400, '勃利', 3, '2309', '230921', 'b');
INSERT INTO `sys_data_region` VALUES (9401, '新起', 4, '230921', '230921001', 'x');
INSERT INTO `sys_data_region` VALUES (9402, '新华', 4, '230921', '230921002', 'x');
INSERT INTO `sys_data_region` VALUES (9403, '元明', 4, '230921', '230921003', 'y');
INSERT INTO `sys_data_region` VALUES (9404, '铁西', 4, '230921', '230921004', 't');
INSERT INTO `sys_data_region` VALUES (9405, '城西', 4, '230921', '230921005', 'c');
INSERT INTO `sys_data_region` VALUES (9406, '勃利镇', 4, '230921', '230921100', 'b');
INSERT INTO `sys_data_region` VALUES (9407, '小五站', 4, '230921', '230921101', 'x');
INSERT INTO `sys_data_region` VALUES (9408, '大四站', 4, '230921', '230921102', 'd');
INSERT INTO `sys_data_region` VALUES (9409, '双河', 4, '230921', '230921103', 's');
INSERT INTO `sys_data_region` VALUES (9410, '倭肯', 4, '230921', '230921104', 'w');
INSERT INTO `sys_data_region` VALUES (9411, '青山', 4, '230921', '230921200', 'q');
INSERT INTO `sys_data_region` VALUES (9412, '永恒', 4, '230921', '230921202', 'y');
INSERT INTO `sys_data_region` VALUES (9413, '抢垦', 4, '230921', '230921203', 'q');
INSERT INTO `sys_data_region` VALUES (9414, '杏树', 4, '230921', '230921204', 'x');
INSERT INTO `sys_data_region` VALUES (9415, '吉兴', 4, '230921', '230921205', 'j');
INSERT INTO `sys_data_region` VALUES (9416, '牡丹江', 2, '23', '2310', 'm');
INSERT INTO `sys_data_region` VALUES (9417, '东安', 3, '2310', '231002', 'd');
INSERT INTO `sys_data_region` VALUES (9418, '新安', 4, '231002', '231002001', 'x');
INSERT INTO `sys_data_region` VALUES (9419, '长安', 4, '231002', '231002002', 'c');
INSERT INTO `sys_data_region` VALUES (9420, '七星', 4, '231002', '231002003', 'q');
INSERT INTO `sys_data_region` VALUES (9421, '五星', 4, '231002', '231002004', 'w');
INSERT INTO `sys_data_region` VALUES (9422, '东兴', 4, '231002', '231002005', 'd');
INSERT INTO `sys_data_region` VALUES (9423, '兴隆', 4, '231002', '231002100', 'x');
INSERT INTO `sys_data_region` VALUES (9424, '阳明', 3, '2310', '231003', 'y');
INSERT INTO `sys_data_region` VALUES (9425, '阳明街道', 4, '231003', '231003001', 'y');
INSERT INTO `sys_data_region` VALUES (9426, '前进', 4, '231003', '231003002', 'q');
INSERT INTO `sys_data_region` VALUES (9427, '新兴', 4, '231003', '231003003', 'x');
INSERT INTO `sys_data_region` VALUES (9428, '桦林橡胶厂', 4, '231003', '231003004', 'h');
INSERT INTO `sys_data_region` VALUES (9429, '铁岭', 4, '231003', '231003100', 't');
INSERT INTO `sys_data_region` VALUES (9430, '桦林', 4, '231003', '231003101', 'h');
INSERT INTO `sys_data_region` VALUES (9431, '磨刀石', 4, '231003', '231003102', 'm');
INSERT INTO `sys_data_region` VALUES (9432, '五林', 4, '231003', '231003103', 'w');
INSERT INTO `sys_data_region` VALUES (9433, '爱民', 3, '2310', '231004', 'a');
INSERT INTO `sys_data_region` VALUES (9434, '向阳', 4, '231004', '231004001', 'x');
INSERT INTO `sys_data_region` VALUES (9435, '黄花', 4, '231004', '231004002', 'h');
INSERT INTO `sys_data_region` VALUES (9436, '铁北', 4, '231004', '231004003', 't');
INSERT INTO `sys_data_region` VALUES (9437, '新华', 4, '231004', '231004004', 'x');
INSERT INTO `sys_data_region` VALUES (9438, '大庆', 4, '231004', '231004005', 'd');
INSERT INTO `sys_data_region` VALUES (9439, '兴平', 4, '231004', '231004006', 'x');
INSERT INTO `sys_data_region` VALUES (9440, '北山', 4, '231004', '231004007', 'b');
INSERT INTO `sys_data_region` VALUES (9441, '三道关', 4, '231004', '231004100', 's');
INSERT INTO `sys_data_region` VALUES (9442, '西安', 3, '2310', '231005', 'x');
INSERT INTO `sys_data_region` VALUES (9443, '先锋', 4, '231005', '231005001', 'x');
INSERT INTO `sys_data_region` VALUES (9444, '火炬', 4, '231005', '231005002', 'h');
INSERT INTO `sys_data_region` VALUES (9445, '立新', 4, '231005', '231005003', 'l');
INSERT INTO `sys_data_region` VALUES (9446, '牡丹', 4, '231005', '231005004', 'm');
INSERT INTO `sys_data_region` VALUES (9447, '江滨', 4, '231005', '231005005', 'j');
INSERT INTO `sys_data_region` VALUES (9448, '沿江', 4, '231005', '231005006', 'y');
INSERT INTO `sys_data_region` VALUES (9449, '温春', 4, '231005', '231005100', 'w');
INSERT INTO `sys_data_region` VALUES (9450, '海南', 4, '231005', '231005200', 'h');
INSERT INTO `sys_data_region` VALUES (9451, '林口', 3, '2310', '231025', 'l');
INSERT INTO `sys_data_region` VALUES (9452, '林口镇', 4, '231025', '231025100', 'l');
INSERT INTO `sys_data_region` VALUES (9453, '古城', 4, '231025', '231025101', 'g');
INSERT INTO `sys_data_region` VALUES (9454, '刁翎', 4, '231025', '231025102', 'd');
INSERT INTO `sys_data_region` VALUES (9455, '朱家', 4, '231025', '231025104', 'z');
INSERT INTO `sys_data_region` VALUES (9456, '柳树', 4, '231025', '231025105', 'l');
INSERT INTO `sys_data_region` VALUES (9457, '三道通', 4, '231025', '231025106', 's');
INSERT INTO `sys_data_region` VALUES (9458, '龙爪', 4, '231025', '231025107', 'l');
INSERT INTO `sys_data_region` VALUES (9459, '莲花', 4, '231025', '231025108', 'l');
INSERT INTO `sys_data_region` VALUES (9460, '青山', 4, '231025', '231025110', 'q');
INSERT INTO `sys_data_region` VALUES (9461, '建堂', 4, '231025', '231025111', 'j');
INSERT INTO `sys_data_region` VALUES (9462, '奎山', 4, '231025', '231025112', 'k');
INSERT INTO `sys_data_region` VALUES (9463, '绥芬河', 3, '2310', '231081', 's');
INSERT INTO `sys_data_region` VALUES (9464, '绥芬河镇', 4, '231081', '231081100', 's');
INSERT INTO `sys_data_region` VALUES (9465, '阜宁', 4, '231081', '231081101', 'f');
INSERT INTO `sys_data_region` VALUES (9466, '海林', 3, '2310', '231083', 'h');
INSERT INTO `sys_data_region` VALUES (9467, '海林镇', 4, '231083', '231083100', 'h');
INSERT INTO `sys_data_region` VALUES (9468, '长汀', 4, '231083', '231083101', 'c');
INSERT INTO `sys_data_region` VALUES (9469, '横道', 4, '231083', '231083102', 'h');
INSERT INTO `sys_data_region` VALUES (9470, '山市', 4, '231083', '231083103', 's');
INSERT INTO `sys_data_region` VALUES (9471, '柴河', 4, '231083', '231083104', 'c');
INSERT INTO `sys_data_region` VALUES (9472, '二道', 4, '231083', '231083105', 'e');
INSERT INTO `sys_data_region` VALUES (9473, '新安', 4, '231083', '231083106', 'x');
INSERT INTO `sys_data_region` VALUES (9474, '三道', 4, '231083', '231083107', 's');
INSERT INTO `sys_data_region` VALUES (9475, '宁安', 3, '2310', '231084', 'n');
INSERT INTO `sys_data_region` VALUES (9476, '城区', 4, '231084', '231084001', 'c');
INSERT INTO `sys_data_region` VALUES (9477, '宁安镇', 4, '231084', '231084100', 'n');
INSERT INTO `sys_data_region` VALUES (9478, '东京城', 4, '231084', '231084101', 'd');
INSERT INTO `sys_data_region` VALUES (9479, '渤海', 4, '231084', '231084102', 'b');
INSERT INTO `sys_data_region` VALUES (9480, '石岩', 4, '231084', '231084103', 's');
INSERT INTO `sys_data_region` VALUES (9481, '沙兰', 4, '231084', '231084104', 's');
INSERT INTO `sys_data_region` VALUES (9482, '海浪', 4, '231084', '231084105', 'h');
INSERT INTO `sys_data_region` VALUES (9483, '兰岗', 4, '231084', '231084106', 'l');
INSERT INTO `sys_data_region` VALUES (9484, '镜泊', 4, '231084', '231084107', 'j');
INSERT INTO `sys_data_region` VALUES (9485, '江南', 4, '231084', '231084202', 'j');
INSERT INTO `sys_data_region` VALUES (9486, '卧龙', 4, '231084', '231084206', 'w');
INSERT INTO `sys_data_region` VALUES (9487, '马河', 4, '231084', '231084208', 'm');
INSERT INTO `sys_data_region` VALUES (9488, '三陵', 4, '231084', '231084211', 's');
INSERT INTO `sys_data_region` VALUES (9489, '东京城林业局', 4, '231084', '231084400', 'd');
INSERT INTO `sys_data_region` VALUES (9490, '穆棱', 3, '2310', '231085', 'm');
INSERT INTO `sys_data_region` VALUES (9491, '八面通', 4, '231085', '231085100', 'b');
INSERT INTO `sys_data_region` VALUES (9492, '穆棱镇', 4, '231085', '231085101', 'm');
INSERT INTO `sys_data_region` VALUES (9493, '下城子', 4, '231085', '231085102', 'x');
INSERT INTO `sys_data_region` VALUES (9494, '马桥河', 4, '231085', '231085103', 'm');
INSERT INTO `sys_data_region` VALUES (9495, '兴源', 4, '231085', '231085104', 'x');
INSERT INTO `sys_data_region` VALUES (9496, '河西', 4, '231085', '231085105', 'h');
INSERT INTO `sys_data_region` VALUES (9497, '福禄', 4, '231085', '231085200', 'f');
INSERT INTO `sys_data_region` VALUES (9498, '共和', 4, '231085', '231085202', 'g');
INSERT INTO `sys_data_region` VALUES (9499, '八面通林业局', 4, '231085', '231085400', 'b');
INSERT INTO `sys_data_region` VALUES (9500, '穆棱林业局', 4, '231085', '231085401', 'm');
INSERT INTO `sys_data_region` VALUES (9501, '东宁', 3, '2310', '231086', 'd');
INSERT INTO `sys_data_region` VALUES (9502, '东宁镇', 4, '231086', '231086100', 'd');
INSERT INTO `sys_data_region` VALUES (9503, '三岔口', 4, '231086', '231086101', 's');
INSERT INTO `sys_data_region` VALUES (9504, '大肚川', 4, '231086', '231086102', 'd');
INSERT INTO `sys_data_region` VALUES (9505, '老黑山', 4, '231086', '231086103', 'l');
INSERT INTO `sys_data_region` VALUES (9506, '道河', 4, '231086', '231086104', 'd');
INSERT INTO `sys_data_region` VALUES (9507, '绥阳', 4, '231086', '231086105', 's');
INSERT INTO `sys_data_region` VALUES (9508, '黑河', 2, '23', '2311', 'h');
INSERT INTO `sys_data_region` VALUES (9509, '爱辉', 3, '2311', '231102', 'a');
INSERT INTO `sys_data_region` VALUES (9510, '花园', 4, '231102', '231102001', 'h');
INSERT INTO `sys_data_region` VALUES (9511, '兴安', 4, '231102', '231102002', 'x');
INSERT INTO `sys_data_region` VALUES (9512, '海兰', 4, '231102', '231102003', 'h');
INSERT INTO `sys_data_region` VALUES (9513, '西兴', 4, '231102', '231102004', 'x');
INSERT INTO `sys_data_region` VALUES (9514, '西岗子', 4, '231102', '231102101', 'x');
INSERT INTO `sys_data_region` VALUES (9515, '瑷珲', 4, '231102', '231102102', 'a');
INSERT INTO `sys_data_region` VALUES (9516, '罕达汽', 4, '231102', '231102103', 'h');
INSERT INTO `sys_data_region` VALUES (9517, '幸福', 4, '231102', '231102200', 'x');
INSERT INTO `sys_data_region` VALUES (9518, '四嘉子', 4, '231102', '231102201', 's');
INSERT INTO `sys_data_region` VALUES (9519, '坤河', 4, '231102', '231102202', 'k');
INSERT INTO `sys_data_region` VALUES (9520, '上马厂', 4, '231102', '231102203', 's');
INSERT INTO `sys_data_region` VALUES (9521, '张地营子', 4, '231102', '231102204', 'z');
INSERT INTO `sys_data_region` VALUES (9522, '西峰山', 4, '231102', '231102205', 'x');
INSERT INTO `sys_data_region` VALUES (9523, '新生', 4, '231102', '231102206', 'x');
INSERT INTO `sys_data_region` VALUES (9524, '二站', 4, '231102', '231102207', 'e');
INSERT INTO `sys_data_region` VALUES (9525, '锦河农场', 4, '231102', '231102500', 'j');
INSERT INTO `sys_data_region` VALUES (9526, '逊克', 3, '2311', '231123', 'x');
INSERT INTO `sys_data_region` VALUES (9527, '奇克街道', 4, '231123', '231123001', 'q');
INSERT INTO `sys_data_region` VALUES (9528, '逊河', 4, '231123', '231123101', 'x');
INSERT INTO `sys_data_region` VALUES (9529, '奇克镇', 4, '231123', '231123102', 'q');
INSERT INTO `sys_data_region` VALUES (9530, '克林', 4, '231123', '231123103', 'k');
INSERT INTO `sys_data_region` VALUES (9531, '干岔子', 4, '231123', '231123201', 'g');
INSERT INTO `sys_data_region` VALUES (9532, '松树沟', 4, '231123', '231123202', 's');
INSERT INTO `sys_data_region` VALUES (9533, '车陆', 4, '231123', '231123203', 'c');
INSERT INTO `sys_data_region` VALUES (9534, '新鄂', 4, '231123', '231123204', 'x');
INSERT INTO `sys_data_region` VALUES (9535, '新兴', 4, '231123', '231123205', 'x');
INSERT INTO `sys_data_region` VALUES (9536, '宝山', 4, '231123', '231123207', 'b');
INSERT INTO `sys_data_region` VALUES (9537, '逊克农场', 4, '231123', '231123500', 'x');
INSERT INTO `sys_data_region` VALUES (9538, '孙吴', 3, '2311', '231124', 's');
INSERT INTO `sys_data_region` VALUES (9539, '孙吴镇', 4, '231124', '231124100', 's');
INSERT INTO `sys_data_region` VALUES (9540, '辰清', 4, '231124', '231124101', 'c');
INSERT INTO `sys_data_region` VALUES (9541, '西兴', 4, '231124', '231124201', 'x');
INSERT INTO `sys_data_region` VALUES (9542, '沿江', 4, '231124', '231124202', 'y');
INSERT INTO `sys_data_region` VALUES (9543, '腰屯', 4, '231124', '231124203', 'y');
INSERT INTO `sys_data_region` VALUES (9544, '卧牛河', 4, '231124', '231124204', 'w');
INSERT INTO `sys_data_region` VALUES (9545, '群山', 4, '231124', '231124205', 'q');
INSERT INTO `sys_data_region` VALUES (9546, '奋斗', 4, '231124', '231124206', 'f');
INSERT INTO `sys_data_region` VALUES (9547, '红旗', 4, '231124', '231124207', 'h');
INSERT INTO `sys_data_region` VALUES (9548, '正阳山', 4, '231124', '231124208', 'z');
INSERT INTO `sys_data_region` VALUES (9549, '清溪', 4, '231124', '231124210', 'q');
INSERT INTO `sys_data_region` VALUES (9550, '正阳林场', 4, '231124', '231124404', 'z');
INSERT INTO `sys_data_region` VALUES (9551, '红旗林场', 4, '231124', '231124408', 'h');
INSERT INTO `sys_data_region` VALUES (9552, '红色边疆农场', 4, '231124', '231124500', 'h');
INSERT INTO `sys_data_region` VALUES (9553, '北安', 3, '2311', '231181', 'b');
INSERT INTO `sys_data_region` VALUES (9554, '兆麟', 4, '231181', '231181001', 'z');
INSERT INTO `sys_data_region` VALUES (9555, '和平', 4, '231181', '231181002', 'h');
INSERT INTO `sys_data_region` VALUES (9556, '北岗', 4, '231181', '231181003', 'b');
INSERT INTO `sys_data_region` VALUES (9557, '庆华', 4, '231181', '231181004', 'q');
INSERT INTO `sys_data_region` VALUES (9558, '铁西', 4, '231181', '231181005', 't');
INSERT INTO `sys_data_region` VALUES (9559, '铁南', 4, '231181', '231181006', 't');
INSERT INTO `sys_data_region` VALUES (9560, '通北', 4, '231181', '231181101', 't');
INSERT INTO `sys_data_region` VALUES (9561, '赵光', 4, '231181', '231181102', 'z');
INSERT INTO `sys_data_region` VALUES (9562, '海星', 4, '231181', '231181103', 'h');
INSERT INTO `sys_data_region` VALUES (9563, '石泉', 4, '231181', '231181104', 's');
INSERT INTO `sys_data_region` VALUES (9564, '二井', 4, '231181', '231181105', 'e');
INSERT INTO `sys_data_region` VALUES (9565, '城郊', 4, '231181', '231181200', 'c');
INSERT INTO `sys_data_region` VALUES (9566, '东胜', 4, '231181', '231181201', 'd');
INSERT INTO `sys_data_region` VALUES (9567, '杨家', 4, '231181', '231181203', 'y');
INSERT INTO `sys_data_region` VALUES (9568, '主星', 4, '231181', '231181207', 'z');
INSERT INTO `sys_data_region` VALUES (9569, '通北林业局', 4, '231181', '231181400', 't');
INSERT INTO `sys_data_region` VALUES (9570, '长水河农场', 4, '231181', '231181501', 'c');
INSERT INTO `sys_data_region` VALUES (9571, '红星农场', 4, '231181', '231181503', 'h');
INSERT INTO `sys_data_region` VALUES (9572, '建设农场', 4, '231181', '231181504', 'j');
INSERT INTO `sys_data_region` VALUES (9573, '五大连池', 3, '2311', '231182', 'w');
INSERT INTO `sys_data_region` VALUES (9574, '青山', 4, '231182', '231182001', 'q');
INSERT INTO `sys_data_region` VALUES (9575, '龙镇', 4, '231182', '231182101', 'l');
INSERT INTO `sys_data_region` VALUES (9576, '和平', 4, '231182', '231182102', 'h');
INSERT INTO `sys_data_region` VALUES (9577, '五大连池镇', 4, '231182', '231182103', 'w');
INSERT INTO `sys_data_region` VALUES (9578, '双泉', 4, '231182', '231182104', 's');
INSERT INTO `sys_data_region` VALUES (9579, '新发', 4, '231182', '231182105', 'x');
INSERT INTO `sys_data_region` VALUES (9580, '团结', 4, '231182', '231182106', 't');
INSERT INTO `sys_data_region` VALUES (9581, '兴隆', 4, '231182', '231182107', 'x');
INSERT INTO `sys_data_region` VALUES (9582, '建设', 4, '231182', '231182203', 'j');
INSERT INTO `sys_data_region` VALUES (9583, '太平', 4, '231182', '231182205', 't');
INSERT INTO `sys_data_region` VALUES (9584, '兴安', 4, '231182', '231182208', 'x');
INSERT INTO `sys_data_region` VALUES (9585, '朝阳', 4, '231182', '231182210', 'z');
INSERT INTO `sys_data_region` VALUES (9586, '元青山林场', 4, '231182', '231182406', 'y');
INSERT INTO `sys_data_region` VALUES (9587, '三九六林场', 4, '231182', '231182407', 's');
INSERT INTO `sys_data_region` VALUES (9588, '小兴安林场', 4, '231182', '231182408', 'x');
INSERT INTO `sys_data_region` VALUES (9589, '二龙山林场', 4, '231182', '231182409', 'e');
INSERT INTO `sys_data_region` VALUES (9590, '朝阳林场', 4, '231182', '231182410', 'z');
INSERT INTO `sys_data_region` VALUES (9591, '引龙河林场', 4, '231182', '231182411', 'y');
INSERT INTO `sys_data_region` VALUES (9592, '焦得布林场', 4, '231182', '231182412', 'j');
INSERT INTO `sys_data_region` VALUES (9593, '小孤山林场', 4, '231182', '231182414', 'x');
INSERT INTO `sys_data_region` VALUES (9594, '药泉林场', 4, '231182', '231182415', 'y');
INSERT INTO `sys_data_region` VALUES (9595, '沾河林业局', 4, '231182', '231182417', 'z');
INSERT INTO `sys_data_region` VALUES (9596, '莲花管理委员会', 4, '231182', '231182418', 'l');
INSERT INTO `sys_data_region` VALUES (9597, '畜牧场', 4, '231182', '231182429', 'x');
INSERT INTO `sys_data_region` VALUES (9598, '龙门农场', 4, '231182', '231182501', 'l');
INSERT INTO `sys_data_region` VALUES (9599, '襄河农场', 4, '231182', '231182502', 'x');
INSERT INTO `sys_data_region` VALUES (9600, '龙镇农场', 4, '231182', '231182503', 'l');
INSERT INTO `sys_data_region` VALUES (9601, '二龙山农场', 4, '231182', '231182504', 'e');
INSERT INTO `sys_data_region` VALUES (9602, '引龙河农场', 4, '231182', '231182505', 'y');
INSERT INTO `sys_data_region` VALUES (9603, '尾山农场', 4, '231182', '231182506', 'w');
INSERT INTO `sys_data_region` VALUES (9604, '格球山农场', 4, '231182', '231182507', 'g');
INSERT INTO `sys_data_region` VALUES (9605, '五大连池农场', 4, '231182', '231182508', 'w');
INSERT INTO `sys_data_region` VALUES (9606, '嫩江', 3, '2311', '231183', 'n');
INSERT INTO `sys_data_region` VALUES (9607, '嫩江镇', 4, '231183', '231183100', 'n');
INSERT INTO `sys_data_region` VALUES (9608, '伊拉哈', 4, '231183', '231183101', 'y');
INSERT INTO `sys_data_region` VALUES (9609, '双山', 4, '231183', '231183102', 's');
INSERT INTO `sys_data_region` VALUES (9610, '多宝山', 4, '231183', '231183103', 'd');
INSERT INTO `sys_data_region` VALUES (9611, '海江', 4, '231183', '231183104', 'h');
INSERT INTO `sys_data_region` VALUES (9612, '前进', 4, '231183', '231183105', 'q');
INSERT INTO `sys_data_region` VALUES (9613, '长福', 4, '231183', '231183106', 'c');
INSERT INTO `sys_data_region` VALUES (9614, '科洛', 4, '231183', '231183107', 'k');
INSERT INTO `sys_data_region` VALUES (9615, '霍龙门', 4, '231183', '231183108', 'h');
INSERT INTO `sys_data_region` VALUES (9616, '临江', 4, '231183', '231183202', 'l');
INSERT INTO `sys_data_region` VALUES (9617, '联兴', 4, '231183', '231183206', 'l');
INSERT INTO `sys_data_region` VALUES (9618, '白云', 4, '231183', '231183207', 'b');
INSERT INTO `sys_data_region` VALUES (9619, '塔溪', 4, '231183', '231183208', 't');
INSERT INTO `sys_data_region` VALUES (9620, '长江', 4, '231183', '231183211', 'c');
INSERT INTO `sys_data_region` VALUES (9621, '九三管理局局直', 4, '231183', '231183500', 'j');
INSERT INTO `sys_data_region` VALUES (9622, '鹤山农场', 4, '231183', '231183501', 'h');
INSERT INTO `sys_data_region` VALUES (9623, '大西江农场', 4, '231183', '231183502', 'd');
INSERT INTO `sys_data_region` VALUES (9624, '尖山农场', 4, '231183', '231183503', 'j');
INSERT INTO `sys_data_region` VALUES (9625, '荣军农场', 4, '231183', '231183504', 'r');
INSERT INTO `sys_data_region` VALUES (9626, '七星泡农场', 4, '231183', '231183506', 'q');
INSERT INTO `sys_data_region` VALUES (9627, '嫩江农场', 4, '231183', '231183507', 'n');
INSERT INTO `sys_data_region` VALUES (9628, '山河农场', 4, '231183', '231183508', 's');
INSERT INTO `sys_data_region` VALUES (9629, '建边农场', 4, '231183', '231183510', 'j');
INSERT INTO `sys_data_region` VALUES (9630, '绥化', 2, '23', '2312', 's');
INSERT INTO `sys_data_region` VALUES (9631, '北林', 3, '2312', '231202', 'b');
INSERT INTO `sys_data_region` VALUES (9632, '紫来', 4, '231202', '231202001', 'z');
INSERT INTO `sys_data_region` VALUES (9633, '爱路', 4, '231202', '231202002', 'a');
INSERT INTO `sys_data_region` VALUES (9634, '大有', 4, '231202', '231202003', 'd');
INSERT INTO `sys_data_region` VALUES (9635, '吉泰', 4, '231202', '231202004', 'j');
INSERT INTO `sys_data_region` VALUES (9636, '东兴', 4, '231202', '231202005', 'd');
INSERT INTO `sys_data_region` VALUES (9637, '北林街道', 4, '231202', '231202006', 'b');
INSERT INTO `sys_data_region` VALUES (9638, '朝旭', 4, '231202', '231202007', 'c');
INSERT INTO `sys_data_region` VALUES (9639, '春雷', 4, '231202', '231202008', 'c');
INSERT INTO `sys_data_region` VALUES (9640, '北辰', 4, '231202', '231202009', 'b');
INSERT INTO `sys_data_region` VALUES (9641, '康庄', 4, '231202', '231202010', 'k');
INSERT INTO `sys_data_region` VALUES (9642, '先锋', 4, '231202', '231202011', 'x');
INSERT INTO `sys_data_region` VALUES (9643, '东城', 4, '231202', '231202012', 'd');
INSERT INTO `sys_data_region` VALUES (9644, '宝山', 4, '231202', '231202101', 'b');
INSERT INTO `sys_data_region` VALUES (9645, '绥胜', 4, '231202', '231202102', 's');
INSERT INTO `sys_data_region` VALUES (9646, '西长发', 4, '231202', '231202103', 'x');
INSERT INTO `sys_data_region` VALUES (9647, '永安', 4, '231202', '231202104', 'y');
INSERT INTO `sys_data_region` VALUES (9648, '太平川', 4, '231202', '231202105', 't');
INSERT INTO `sys_data_region` VALUES (9649, '秦家', 4, '231202', '231202106', 'q');
INSERT INTO `sys_data_region` VALUES (9650, '双河', 4, '231202', '231202107', 's');
INSERT INTO `sys_data_region` VALUES (9651, '三河', 4, '231202', '231202108', 's');
INSERT INTO `sys_data_region` VALUES (9652, '四方台', 4, '231202', '231202109', 's');
INSERT INTO `sys_data_region` VALUES (9653, '津河', 4, '231202', '231202110', 'j');
INSERT INTO `sys_data_region` VALUES (9654, '张维', 4, '231202', '231202111', 'z');
INSERT INTO `sys_data_region` VALUES (9655, '东津', 4, '231202', '231202113', 'd');
INSERT INTO `sys_data_region` VALUES (9656, '东富', 4, '231202', '231202114', 'd');
INSERT INTO `sys_data_region` VALUES (9657, '兴福', 4, '231202', '231202115', 'x');
INSERT INTO `sys_data_region` VALUES (9658, '三井', 4, '231202', '231202116', 's');
INSERT INTO `sys_data_region` VALUES (9659, '红旗', 4, '231202', '231202201', 'h');
INSERT INTO `sys_data_region` VALUES (9660, '连岗', 4, '231202', '231202202', 'l');
INSERT INTO `sys_data_region` VALUES (9661, '新华', 4, '231202', '231202203', 'x');
INSERT INTO `sys_data_region` VALUES (9662, '五营', 4, '231202', '231202212', 'w');
INSERT INTO `sys_data_region` VALUES (9663, '兴和', 4, '231202', '231202213', 'x');
INSERT INTO `sys_data_region` VALUES (9664, '望奎', 3, '2312', '231221', 'w');
INSERT INTO `sys_data_region` VALUES (9665, '望奎镇', 4, '231221', '231221100', 'w');
INSERT INTO `sys_data_region` VALUES (9666, '通江', 4, '231221', '231221101', 't');
INSERT INTO `sys_data_region` VALUES (9667, '卫星', 4, '231221', '231221102', 'w');
INSERT INTO `sys_data_region` VALUES (9668, '海丰', 4, '231221', '231221103', 'h');
INSERT INTO `sys_data_region` VALUES (9669, '莲花', 4, '231221', '231221104', 'l');
INSERT INTO `sys_data_region` VALUES (9670, '惠七', 4, '231221', '231221105', 'h');
INSERT INTO `sys_data_region` VALUES (9671, '先锋', 4, '231221', '231221106', 'x');
INSERT INTO `sys_data_region` VALUES (9672, '火箭', 4, '231221', '231221107', 'h');
INSERT INTO `sys_data_region` VALUES (9673, '东郊', 4, '231221', '231221108', 'd');
INSERT INTO `sys_data_region` VALUES (9674, '灯塔', 4, '231221', '231221109', 'd');
INSERT INTO `sys_data_region` VALUES (9675, '灵山', 4, '231221', '231221202', 'l');
INSERT INTO `sys_data_region` VALUES (9676, '后三', 4, '231221', '231221203', 'h');
INSERT INTO `sys_data_region` VALUES (9677, '东升', 4, '231221', '231221209', 'd');
INSERT INTO `sys_data_region` VALUES (9678, '恭六', 4, '231221', '231221210', 'g');
INSERT INTO `sys_data_region` VALUES (9679, '厢白', 4, '231221', '231221211', 'x');
INSERT INTO `sys_data_region` VALUES (9680, '兰西', 3, '2312', '231222', 'l');
INSERT INTO `sys_data_region` VALUES (9681, '兰西镇', 4, '231222', '231222100', 'l');
INSERT INTO `sys_data_region` VALUES (9682, '榆林', 4, '231222', '231222101', 'y');
INSERT INTO `sys_data_region` VALUES (9683, '临江', 4, '231222', '231222102', 'l');
INSERT INTO `sys_data_region` VALUES (9684, '平山', 4, '231222', '231222103', 'p');
INSERT INTO `sys_data_region` VALUES (9685, '远大', 4, '231222', '231222104', 'y');
INSERT INTO `sys_data_region` VALUES (9686, '红光', 4, '231222', '231222105', 'h');
INSERT INTO `sys_data_region` VALUES (9687, '康荣', 4, '231222', '231222106', 'k');
INSERT INTO `sys_data_region` VALUES (9688, '燎原', 4, '231222', '231222107', 'l');
INSERT INTO `sys_data_region` VALUES (9689, '奋斗', 4, '231222', '231222108', 'f');
INSERT INTO `sys_data_region` VALUES (9690, '北安', 4, '231222', '231222202', 'b');
INSERT INTO `sys_data_region` VALUES (9691, '长江', 4, '231222', '231222203', 'c');
INSERT INTO `sys_data_region` VALUES (9692, '兰河', 4, '231222', '231222204', 'l');
INSERT INTO `sys_data_region` VALUES (9693, '红星', 4, '231222', '231222205', 'h');
INSERT INTO `sys_data_region` VALUES (9694, '长岗', 4, '231222', '231222207', 'c');
INSERT INTO `sys_data_region` VALUES (9695, '星火', 4, '231222', '231222210', 'x');
INSERT INTO `sys_data_region` VALUES (9696, '青冈', 3, '2312', '231223', 'q');
INSERT INTO `sys_data_region` VALUES (9697, '青冈镇', 4, '231223', '231223100', 'q');
INSERT INTO `sys_data_region` VALUES (9698, '中和', 4, '231223', '231223101', 'z');
INSERT INTO `sys_data_region` VALUES (9699, '祯祥', 4, '231223', '231223102', 'z');
INSERT INTO `sys_data_region` VALUES (9700, '兴华', 4, '231223', '231223103', 'x');
INSERT INTO `sys_data_region` VALUES (9701, '永丰', 4, '231223', '231223104', 'y');
INSERT INTO `sys_data_region` VALUES (9702, '芦河', 4, '231223', '231223105', 'l');
INSERT INTO `sys_data_region` VALUES (9703, '柞岗', 4, '231223', '231223106', 'z');
INSERT INTO `sys_data_region` VALUES (9704, '民政', 4, '231223', '231223107', 'm');
INSERT INTO `sys_data_region` VALUES (9705, '劳动', 4, '231223', '231223108', 'l');
INSERT INTO `sys_data_region` VALUES (9706, '迎春', 4, '231223', '231223109', 'y');
INSERT INTO `sys_data_region` VALUES (9707, '德胜', 4, '231223', '231223110', 'd');
INSERT INTO `sys_data_region` VALUES (9708, '昌盛', 4, '231223', '231223111', 'c');
INSERT INTO `sys_data_region` VALUES (9709, '建设', 4, '231223', '231223202', 'j');
INSERT INTO `sys_data_region` VALUES (9710, '新村', 4, '231223', '231223203', 'x');
INSERT INTO `sys_data_region` VALUES (9711, '连丰', 4, '231223', '231223212', 'l');
INSERT INTO `sys_data_region` VALUES (9712, '庆安', 3, '2312', '231224', 'q');
INSERT INTO `sys_data_region` VALUES (9713, '民乐', 4, '231224', '231224101', 'm');
INSERT INTO `sys_data_region` VALUES (9714, '大罗', 4, '231224', '231224102', 'd');
INSERT INTO `sys_data_region` VALUES (9715, '平安', 4, '231224', '231224103', 'p');
INSERT INTO `sys_data_region` VALUES (9716, '勤劳', 4, '231224', '231224104', 'q');
INSERT INTO `sys_data_region` VALUES (9717, '久胜', 4, '231224', '231224105', 'j');
INSERT INTO `sys_data_region` VALUES (9718, '庆安镇', 4, '231224', '231224106', 'q');
INSERT INTO `sys_data_region` VALUES (9719, '同乐', 4, '231224', '231224107', 't');
INSERT INTO `sys_data_region` VALUES (9720, '柳河', 4, '231224', '231224108', 'l');
INSERT INTO `sys_data_region` VALUES (9721, '建民', 4, '231224', '231224201', 'j');
INSERT INTO `sys_data_region` VALUES (9722, '巨宝山', 4, '231224', '231224202', 'j');
INSERT INTO `sys_data_region` VALUES (9723, '丰收', 4, '231224', '231224206', 'f');
INSERT INTO `sys_data_region` VALUES (9724, '发展', 4, '231224', '231224208', 'f');
INSERT INTO `sys_data_region` VALUES (9725, '致富', 4, '231224', '231224210', 'z');
INSERT INTO `sys_data_region` VALUES (9726, '欢胜', 4, '231224', '231224211', 'h');
INSERT INTO `sys_data_region` VALUES (9727, '国有林场管理局', 4, '231224', '231224400', 'g');
INSERT INTO `sys_data_region` VALUES (9728, '柳河农场', 4, '231224', '231224500', 'l');
INSERT INTO `sys_data_region` VALUES (9729, '明水', 3, '2312', '231225', 'm');
INSERT INTO `sys_data_region` VALUES (9730, '明水镇', 4, '231225', '231225100', 'm');
INSERT INTO `sys_data_region` VALUES (9731, '兴仁', 4, '231225', '231225101', 'x');
INSERT INTO `sys_data_region` VALUES (9732, '永兴', 4, '231225', '231225102', 'y');
INSERT INTO `sys_data_region` VALUES (9733, '崇德', 4, '231225', '231225103', 'c');
INSERT INTO `sys_data_region` VALUES (9734, '通达', 4, '231225', '231225104', 't');
INSERT INTO `sys_data_region` VALUES (9735, '双兴', 4, '231225', '231225105', 's');
INSERT INTO `sys_data_region` VALUES (9736, '永久', 4, '231225', '231225203', 'y');
INSERT INTO `sys_data_region` VALUES (9737, '树人', 4, '231225', '231225204', 's');
INSERT INTO `sys_data_region` VALUES (9738, '光荣', 4, '231225', '231225205', 'g');
INSERT INTO `sys_data_region` VALUES (9739, '繁荣', 4, '231225', '231225206', 'f');
INSERT INTO `sys_data_region` VALUES (9740, '通泉', 4, '231225', '231225207', 't');
INSERT INTO `sys_data_region` VALUES (9741, '育林', 4, '231225', '231225208', 'y');
INSERT INTO `sys_data_region` VALUES (9742, '绥棱', 3, '2312', '231226', 's');
INSERT INTO `sys_data_region` VALUES (9743, '绥棱镇', 4, '231226', '231226100', 's');
INSERT INTO `sys_data_region` VALUES (9744, '上集', 4, '231226', '231226101', 's');
INSERT INTO `sys_data_region` VALUES (9745, '四海店', 4, '231226', '231226102', 's');
INSERT INTO `sys_data_region` VALUES (9746, '双岔河', 4, '231226', '231226103', 's');
INSERT INTO `sys_data_region` VALUES (9747, '阁山', 4, '231226', '231226104', 'g');
INSERT INTO `sys_data_region` VALUES (9748, '长山', 4, '231226', '231226105', 'c');
INSERT INTO `sys_data_region` VALUES (9749, '靠山', 4, '231226', '231226200', 'k');
INSERT INTO `sys_data_region` VALUES (9750, '后头', 4, '231226', '231226201', 'h');
INSERT INTO `sys_data_region` VALUES (9751, '克音河', 4, '231226', '231226205', 'k');
INSERT INTO `sys_data_region` VALUES (9752, '绥中', 4, '231226', '231226206', 's');
INSERT INTO `sys_data_region` VALUES (9753, '泥尔河', 4, '231226', '231226207', 'n');
INSERT INTO `sys_data_region` VALUES (9754, '阁山林场', 4, '231226', '231226400', 'g');
INSERT INTO `sys_data_region` VALUES (9755, '半截河林场', 4, '231226', '231226403', 'b');
INSERT INTO `sys_data_region` VALUES (9756, '绥棱农场', 4, '231226', '231226500', 's');
INSERT INTO `sys_data_region` VALUES (9757, '种马场', 4, '231226', '231226580', 'z');
INSERT INTO `sys_data_region` VALUES (9758, '安达', 3, '2312', '231281', 'a');
INSERT INTO `sys_data_region` VALUES (9759, '铁西', 4, '231281', '231281001', 't');
INSERT INTO `sys_data_region` VALUES (9760, '新兴', 4, '231281', '231281002', 'x');
INSERT INTO `sys_data_region` VALUES (9761, '安虹', 4, '231281', '231281003', 'a');
INSERT INTO `sys_data_region` VALUES (9762, '东城', 4, '231281', '231281004', 'd');
INSERT INTO `sys_data_region` VALUES (9763, '安达镇', 4, '231281', '231281100', 'a');
INSERT INTO `sys_data_region` VALUES (9764, '任民', 4, '231281', '231281101', 'r');
INSERT INTO `sys_data_region` VALUES (9765, '吉兴岗', 4, '231281', '231281102', 'j');
INSERT INTO `sys_data_region` VALUES (9766, '万宝山', 4, '231281', '231281103', 'w');
INSERT INTO `sys_data_region` VALUES (9767, '昌德', 4, '231281', '231281104', 'c');
INSERT INTO `sys_data_region` VALUES (9768, '升平', 4, '231281', '231281105', 's');
INSERT INTO `sys_data_region` VALUES (9769, '羊草', 4, '231281', '231281106', 'y');
INSERT INTO `sys_data_region` VALUES (9770, '老虎岗', 4, '231281', '231281107', 'l');
INSERT INTO `sys_data_region` VALUES (9771, '中本', 4, '231281', '231281108', 'z');
INSERT INTO `sys_data_region` VALUES (9772, '太平庄', 4, '231281', '231281109', 't');
INSERT INTO `sys_data_region` VALUES (9773, '卧里屯', 4, '231281', '231281110', 'w');
INSERT INTO `sys_data_region` VALUES (9774, '古大湖', 4, '231281', '231281111', 'g');
INSERT INTO `sys_data_region` VALUES (9775, '火石山', 4, '231281', '231281112', 'h');
INSERT INTO `sys_data_region` VALUES (9776, '先源', 4, '231281', '231281209', 'x');
INSERT INTO `sys_data_region` VALUES (9777, '安达畜牧场', 4, '231281', '231281500', 'a');
INSERT INTO `sys_data_region` VALUES (9778, '东湖水库管理站', 4, '231281', '231281584', 'd');
INSERT INTO `sys_data_region` VALUES (9779, '肇东', 3, '2312', '231282', 'z');
INSERT INTO `sys_data_region` VALUES (9780, '朝阳区', 4, '231282', '231282001', 'z');
INSERT INTO `sys_data_region` VALUES (9781, '东升区', 4, '231282', '231282002', 'd');
INSERT INTO `sys_data_region` VALUES (9782, '西园区', 4, '231282', '231282003', 'x');
INSERT INTO `sys_data_region` VALUES (9783, '正阳区', 4, '231282', '231282004', 'z');
INSERT INTO `sys_data_region` VALUES (9784, '肇东镇', 4, '231282', '231282100', 'z');
INSERT INTO `sys_data_region` VALUES (9785, '昌五', 4, '231282', '231282101', 'c');
INSERT INTO `sys_data_region` VALUES (9786, '宋站', 4, '231282', '231282102', 's');
INSERT INTO `sys_data_region` VALUES (9787, '五站', 4, '231282', '231282103', 'w');
INSERT INTO `sys_data_region` VALUES (9788, '尚家', 4, '231282', '231282104', 's');
INSERT INTO `sys_data_region` VALUES (9789, '姜家', 4, '231282', '231282105', 'j');
INSERT INTO `sys_data_region` VALUES (9790, '里木店', 4, '231282', '231282106', 'l');
INSERT INTO `sys_data_region` VALUES (9791, '四站', 4, '231282', '231282107', 's');
INSERT INTO `sys_data_region` VALUES (9792, '涝洲', 4, '231282', '231282108', 'l');
INSERT INTO `sys_data_region` VALUES (9793, '五里明', 4, '231282', '231282109', 'w');
INSERT INTO `sys_data_region` VALUES (9794, '西八里', 4, '231282', '231282110', 'x');
INSERT INTO `sys_data_region` VALUES (9795, '海城', 4, '231282', '231282111', 'h');
INSERT INTO `sys_data_region` VALUES (9796, '太平', 4, '231282', '231282201', 't');
INSERT INTO `sys_data_region` VALUES (9797, '向阳', 4, '231282', '231282204', 'x');
INSERT INTO `sys_data_region` VALUES (9798, '洪河', 4, '231282', '231282205', 'h');
INSERT INTO `sys_data_region` VALUES (9799, '跃进', 4, '231282', '231282206', 'y');
INSERT INTO `sys_data_region` VALUES (9800, '黎明', 4, '231282', '231282210', 'l');
INSERT INTO `sys_data_region` VALUES (9801, '德昌', 4, '231282', '231282212', 'd');
INSERT INTO `sys_data_region` VALUES (9802, '宣化', 4, '231282', '231282213', 'x');
INSERT INTO `sys_data_region` VALUES (9803, '安民', 4, '231282', '231282214', 'a');
INSERT INTO `sys_data_region` VALUES (9804, '明久', 4, '231282', '231282215', 'm');
INSERT INTO `sys_data_region` VALUES (9805, '海伦', 3, '2312', '231283', 'h');
INSERT INTO `sys_data_region` VALUES (9806, '海伦镇', 4, '231283', '231283100', 'h');
INSERT INTO `sys_data_region` VALUES (9807, '海北', 4, '231283', '231283101', 'h');
INSERT INTO `sys_data_region` VALUES (9808, '伦河', 4, '231283', '231283102', 'l');
INSERT INTO `sys_data_region` VALUES (9809, '共合', 4, '231283', '231283103', 'g');
INSERT INTO `sys_data_region` VALUES (9810, '海兴', 4, '231283', '231283104', 'h');
INSERT INTO `sys_data_region` VALUES (9811, '祥富', 4, '231283', '231283105', 'x');
INSERT INTO `sys_data_region` VALUES (9812, '东风', 4, '231283', '231283106', 'd');
INSERT INTO `sys_data_region` VALUES (9813, '百祥', 4, '231283', '231283107', 'b');
INSERT INTO `sys_data_region` VALUES (9814, '向荣', 4, '231283', '231283108', 'x');
INSERT INTO `sys_data_region` VALUES (9815, '长发', 4, '231283', '231283109', 'c');
INSERT INTO `sys_data_region` VALUES (9816, '永富', 4, '231283', '231283110', 'y');
INSERT INTO `sys_data_region` VALUES (9817, '前进', 4, '231283', '231283111', 'q');
INSERT INTO `sys_data_region` VALUES (9818, '联发', 4, '231283', '231283112', 'l');
INSERT INTO `sys_data_region` VALUES (9819, '共荣', 4, '231283', '231283113', 'g');
INSERT INTO `sys_data_region` VALUES (9820, '东林', 4, '231283', '231283114', 'd');
INSERT INTO `sys_data_region` VALUES (9821, '永和', 4, '231283', '231283115', 'y');
INSERT INTO `sys_data_region` VALUES (9822, '海南', 4, '231283', '231283208', 'h');
INSERT INTO `sys_data_region` VALUES (9823, '乐业', 4, '231283', '231283210', 'l');
INSERT INTO `sys_data_region` VALUES (9824, '福民', 4, '231283', '231283211', 'f');
INSERT INTO `sys_data_region` VALUES (9825, '丰山', 4, '231283', '231283212', 'f');
INSERT INTO `sys_data_region` VALUES (9826, '爱民', 4, '231283', '231283218', 'a');
INSERT INTO `sys_data_region` VALUES (9827, '扎音河', 4, '231283', '231283220', 'z');
INSERT INTO `sys_data_region` VALUES (9828, '双录', 4, '231283', '231283221', 's');
INSERT INTO `sys_data_region` VALUES (9829, '东方红水库地区', 4, '231283', '231283401', 'd');
INSERT INTO `sys_data_region` VALUES (9830, '海伦农场', 4, '231283', '231283500', 'h');
INSERT INTO `sys_data_region` VALUES (9831, '红光农场', 4, '231283', '231283501', 'h');
INSERT INTO `sys_data_region` VALUES (9832, '大兴安岭', 2, '23', '2327', 'd');
INSERT INTO `sys_data_region` VALUES (9833, '漠河', 3, '2327', '232701', 'm');
INSERT INTO `sys_data_region` VALUES (9834, '西林吉', 4, '232701', '232701100', 'x');
INSERT INTO `sys_data_region` VALUES (9835, '图强', 4, '232701', '232701101', 't');
INSERT INTO `sys_data_region` VALUES (9836, '阿木尔', 4, '232701', '232701102', 'a');
INSERT INTO `sys_data_region` VALUES (9837, '兴安', 4, '232701', '232701103', 'x');
INSERT INTO `sys_data_region` VALUES (9838, '北极', 4, '232701', '232701104', 'b');
INSERT INTO `sys_data_region` VALUES (9839, '加格达奇区', 3, '2327', '232718', 'j');
INSERT INTO `sys_data_region` VALUES (9840, '东山', 4, '232718', '232718001', 'd');
INSERT INTO `sys_data_region` VALUES (9841, '卫东', 4, '232718', '232718002', 'w');
INSERT INTO `sys_data_region` VALUES (9842, '红旗', 4, '232718', '232718003', 'h');
INSERT INTO `sys_data_region` VALUES (9843, '长虹', 4, '232718', '232718004', 'c');
INSERT INTO `sys_data_region` VALUES (9844, '曙光', 4, '232718', '232718005', 's');
INSERT INTO `sys_data_region` VALUES (9845, '光明', 4, '232718', '232718006', 'g');
INSERT INTO `sys_data_region` VALUES (9846, '小扬气', 4, '232718', '232718100', 'x');
INSERT INTO `sys_data_region` VALUES (9847, '劲松', 4, '232718', '232718101', 'j');
INSERT INTO `sys_data_region` VALUES (9848, '古源', 4, '232718', '232718102', 'g');
INSERT INTO `sys_data_region` VALUES (9849, '加北', 4, '232718', '232718200', 'j');
INSERT INTO `sys_data_region` VALUES (9850, '白桦', 4, '232718', '232718201', 'b');
INSERT INTO `sys_data_region` VALUES (9851, '加格达奇林业局', 4, '232718', '232718400', 'j');
INSERT INTO `sys_data_region` VALUES (9852, '呼玛', 3, '2327', '232721', 'h');
INSERT INTO `sys_data_region` VALUES (9853, '呼玛镇', 4, '232721', '232721100', 'h');
INSERT INTO `sys_data_region` VALUES (9854, '韩家园', 4, '232721', '232721101', 'h');
INSERT INTO `sys_data_region` VALUES (9855, '新林', 4, '232721', '232721103', 'x');
INSERT INTO `sys_data_region` VALUES (9856, '翠岗', 4, '232721', '232721104', 'c');
INSERT INTO `sys_data_region` VALUES (9857, '塔源', 4, '232721', '232721105', 't');
INSERT INTO `sys_data_region` VALUES (9858, '大乌苏', 4, '232721', '232721106', 'd');
INSERT INTO `sys_data_region` VALUES (9859, '塔尔根', 4, '232721', '232721107', 't');
INSERT INTO `sys_data_region` VALUES (9860, '碧洲', 4, '232721', '232721108', 'b');
INSERT INTO `sys_data_region` VALUES (9861, '宏图', 4, '232721', '232721109', 'h');
INSERT INTO `sys_data_region` VALUES (9862, '呼中', 4, '232721', '232721110', 'h');
INSERT INTO `sys_data_region` VALUES (9863, '碧水', 4, '232721', '232721111', 'b');
INSERT INTO `sys_data_region` VALUES (9864, '呼源', 4, '232721', '232721112', 'h');
INSERT INTO `sys_data_region` VALUES (9865, '宏伟', 4, '232721', '232721113', 'h');
INSERT INTO `sys_data_region` VALUES (9866, '三卡', 4, '232721', '232721200', 's');
INSERT INTO `sys_data_region` VALUES (9867, '金山', 4, '232721', '232721201', 'j');
INSERT INTO `sys_data_region` VALUES (9868, '兴华', 4, '232721', '232721202', 'x');
INSERT INTO `sys_data_region` VALUES (9869, '鸥浦', 4, '232721', '232721203', 'o');
INSERT INTO `sys_data_region` VALUES (9870, '白银纳', 4, '232721', '232721204', 'b');
INSERT INTO `sys_data_region` VALUES (9871, '北疆', 4, '232721', '232721205', 'b');
INSERT INTO `sys_data_region` VALUES (9872, '韩家园林业局', 4, '232721', '232721400', 'h');
INSERT INTO `sys_data_region` VALUES (9873, '塔河', 3, '2327', '232722', 't');
INSERT INTO `sys_data_region` VALUES (9874, '塔河镇', 4, '232722', '232722100', 't');
INSERT INTO `sys_data_region` VALUES (9875, '瓦拉干', 4, '232722', '232722101', 'w');
INSERT INTO `sys_data_region` VALUES (9876, '盘古', 4, '232722', '232722102', 'p');
INSERT INTO `sys_data_region` VALUES (9877, '十八站', 4, '232722', '232722200', 's');
INSERT INTO `sys_data_region` VALUES (9878, '依西肯', 4, '232722', '232722201', 'y');
INSERT INTO `sys_data_region` VALUES (9879, '开库康', 4, '232722', '232722202', 'k');
INSERT INTO `sys_data_region` VALUES (9880, '上海', 1, '0', '31', 's');
INSERT INTO `sys_data_region` VALUES (9881, '上海', 2, '31', '3101', 's');
INSERT INTO `sys_data_region` VALUES (9882, '黄浦', 3, '3101', '310101', 'h');
INSERT INTO `sys_data_region` VALUES (9883, '南京东路', 4, '310101', '310101002', 'n');
INSERT INTO `sys_data_region` VALUES (9884, '外滩', 4, '310101', '310101013', 'w');
INSERT INTO `sys_data_region` VALUES (9885, '半淞园路', 4, '310101', '310101015', 'b');
INSERT INTO `sys_data_region` VALUES (9886, '小东门', 4, '310101', '310101017', 'x');
INSERT INTO `sys_data_region` VALUES (9887, '豫园', 4, '310101', '310101018', 'y');
INSERT INTO `sys_data_region` VALUES (9888, '老西门', 4, '310101', '310101019', 'l');
INSERT INTO `sys_data_region` VALUES (9889, '五里桥', 4, '310101', '310101020', 'w');
INSERT INTO `sys_data_region` VALUES (9890, '打浦桥', 4, '310101', '310101021', 'd');
INSERT INTO `sys_data_region` VALUES (9891, '淮海中路', 4, '310101', '310101022', 'h');
INSERT INTO `sys_data_region` VALUES (9892, '瑞金二路', 4, '310101', '310101023', 'r');
INSERT INTO `sys_data_region` VALUES (9893, '徐汇', 3, '3101', '310104', 'x');
INSERT INTO `sys_data_region` VALUES (9894, '天平路', 4, '310104', '310104003', 't');
INSERT INTO `sys_data_region` VALUES (9895, '湖南路', 4, '310104', '310104004', 'h');
INSERT INTO `sys_data_region` VALUES (9896, '斜土路', 4, '310104', '310104007', 'x');
INSERT INTO `sys_data_region` VALUES (9897, '枫林路', 4, '310104', '310104008', 'f');
INSERT INTO `sys_data_region` VALUES (9898, '长桥', 4, '310104', '310104010', 'c');
INSERT INTO `sys_data_region` VALUES (9899, '田林', 4, '310104', '310104011', 't');
INSERT INTO `sys_data_region` VALUES (9900, '虹梅路', 4, '310104', '310104012', 'h');
INSERT INTO `sys_data_region` VALUES (9901, '康健新村', 4, '310104', '310104013', 'k');
INSERT INTO `sys_data_region` VALUES (9902, '徐家汇', 4, '310104', '310104014', 'x');
INSERT INTO `sys_data_region` VALUES (9903, '凌云路', 4, '310104', '310104015', 'l');
INSERT INTO `sys_data_region` VALUES (9904, '龙华', 4, '310104', '310104016', 'l');
INSERT INTO `sys_data_region` VALUES (9905, '漕河泾', 4, '310104', '310104017', 'c');
INSERT INTO `sys_data_region` VALUES (9906, '华泾', 4, '310104', '310104103', 'h');
INSERT INTO `sys_data_region` VALUES (9907, '长宁', 3, '3101', '310105', 'c');
INSERT INTO `sys_data_region` VALUES (9908, '华阳路', 4, '310105', '310105001', 'h');
INSERT INTO `sys_data_region` VALUES (9909, '江苏路', 4, '310105', '310105002', 'j');
INSERT INTO `sys_data_region` VALUES (9910, '新华路', 4, '310105', '310105004', 'x');
INSERT INTO `sys_data_region` VALUES (9911, '周家桥', 4, '310105', '310105005', 'z');
INSERT INTO `sys_data_region` VALUES (9912, '天山路', 4, '310105', '310105006', 't');
INSERT INTO `sys_data_region` VALUES (9913, '仙霞新村', 4, '310105', '310105008', 'x');
INSERT INTO `sys_data_region` VALUES (9914, '虹桥', 4, '310105', '310105009', 'h');
INSERT INTO `sys_data_region` VALUES (9915, '程家桥', 4, '310105', '310105010', 'c');
INSERT INTO `sys_data_region` VALUES (9916, '北新泾', 4, '310105', '310105011', 'b');
INSERT INTO `sys_data_region` VALUES (9917, '新泾', 4, '310105', '310105102', 'x');
INSERT INTO `sys_data_region` VALUES (9918, '静安', 3, '3101', '310106', 'j');
INSERT INTO `sys_data_region` VALUES (9919, '江宁路', 4, '310106', '310106006', 'j');
INSERT INTO `sys_data_region` VALUES (9920, '石门二路', 4, '310106', '310106011', 's');
INSERT INTO `sys_data_region` VALUES (9921, '南京西路', 4, '310106', '310106012', 'n');
INSERT INTO `sys_data_region` VALUES (9922, '静安寺', 4, '310106', '310106013', 'j');
INSERT INTO `sys_data_region` VALUES (9923, '曹家渡', 4, '310106', '310106014', 'c');
INSERT INTO `sys_data_region` VALUES (9924, '天目西路', 4, '310106', '310106015', 't');
INSERT INTO `sys_data_region` VALUES (9925, '北站', 4, '310106', '310106016', 'b');
INSERT INTO `sys_data_region` VALUES (9926, '宝山路', 4, '310106', '310106017', 'b');
INSERT INTO `sys_data_region` VALUES (9927, '共和新路', 4, '310106', '310106018', 'g');
INSERT INTO `sys_data_region` VALUES (9928, '大宁路', 4, '310106', '310106019', 'd');
INSERT INTO `sys_data_region` VALUES (9929, '彭浦新村', 4, '310106', '310106020', 'p');
INSERT INTO `sys_data_region` VALUES (9930, '临汾路', 4, '310106', '310106021', 'l');
INSERT INTO `sys_data_region` VALUES (9931, '芷江西路', 4, '310106', '310106022', 'z');
INSERT INTO `sys_data_region` VALUES (9932, '彭浦', 4, '310106', '310106100', 'p');
INSERT INTO `sys_data_region` VALUES (9933, '普陀', 3, '3101', '310107', 'p');
INSERT INTO `sys_data_region` VALUES (9934, '曹杨新村', 4, '310107', '310107005', 'c');
INSERT INTO `sys_data_region` VALUES (9935, '长风新村', 4, '310107', '310107014', 'c');
INSERT INTO `sys_data_region` VALUES (9936, '长寿路', 4, '310107', '310107015', 'c');
INSERT INTO `sys_data_region` VALUES (9937, '甘泉路', 4, '310107', '310107016', 'g');
INSERT INTO `sys_data_region` VALUES (9938, '石泉路', 4, '310107', '310107017', 's');
INSERT INTO `sys_data_region` VALUES (9939, '宜川路', 4, '310107', '310107020', 'y');
INSERT INTO `sys_data_region` VALUES (9940, '真如镇', 4, '310107', '310107021', 'z');
INSERT INTO `sys_data_region` VALUES (9941, '万里', 4, '310107', '310107022', 'w');
INSERT INTO `sys_data_region` VALUES (9942, '长征', 4, '310107', '310107102', 'c');
INSERT INTO `sys_data_region` VALUES (9943, '桃浦', 4, '310107', '310107103', 't');
INSERT INTO `sys_data_region` VALUES (9944, '虹口', 3, '3101', '310109', 'h');
INSERT INTO `sys_data_region` VALUES (9945, '欧阳路', 4, '310109', '310109009', 'o');
INSERT INTO `sys_data_region` VALUES (9946, '曲阳路', 4, '310109', '310109010', 'q');
INSERT INTO `sys_data_region` VALUES (9947, '广中路', 4, '310109', '310109011', 'g');
INSERT INTO `sys_data_region` VALUES (9948, '嘉兴路', 4, '310109', '310109014', 'j');
INSERT INTO `sys_data_region` VALUES (9949, '凉城新村', 4, '310109', '310109016', 'l');
INSERT INTO `sys_data_region` VALUES (9950, '四川北路', 4, '310109', '310109017', 's');
INSERT INTO `sys_data_region` VALUES (9951, '北外滩', 4, '310109', '310109018', 'b');
INSERT INTO `sys_data_region` VALUES (9952, '江湾镇', 4, '310109', '310109019', 'j');
INSERT INTO `sys_data_region` VALUES (9953, '杨浦', 3, '3101', '310110', 'y');
INSERT INTO `sys_data_region` VALUES (9954, '定海路', 4, '310110', '310110001', 'd');
INSERT INTO `sys_data_region` VALUES (9955, '平凉路', 4, '310110', '310110006', 'p');
INSERT INTO `sys_data_region` VALUES (9956, '江浦路', 4, '310110', '310110008', 'j');
INSERT INTO `sys_data_region` VALUES (9957, '四平路', 4, '310110', '310110009', 's');
INSERT INTO `sys_data_region` VALUES (9958, '控江路', 4, '310110', '310110012', 'k');
INSERT INTO `sys_data_region` VALUES (9959, '长白新村', 4, '310110', '310110013', 'c');
INSERT INTO `sys_data_region` VALUES (9960, '延吉新村', 4, '310110', '310110015', 'y');
INSERT INTO `sys_data_region` VALUES (9961, '殷行', 4, '310110', '310110016', 'y');
INSERT INTO `sys_data_region` VALUES (9962, '大桥', 4, '310110', '310110018', 'd');
INSERT INTO `sys_data_region` VALUES (9963, '五角场', 4, '310110', '310110019', 'w');
INSERT INTO `sys_data_region` VALUES (9964, '新江湾城', 4, '310110', '310110020', 'x');
INSERT INTO `sys_data_region` VALUES (9965, '长海路', 4, '310110', '310110021', 'c');
INSERT INTO `sys_data_region` VALUES (9966, '闵行', 3, '3101', '310112', 'm');
INSERT INTO `sys_data_region` VALUES (9967, '江川路', 4, '310112', '310112001', 'j');
INSERT INTO `sys_data_region` VALUES (9968, '古美', 4, '310112', '310112006', 'g');
INSERT INTO `sys_data_region` VALUES (9969, '新虹', 4, '310112', '310112008', 'x');
INSERT INTO `sys_data_region` VALUES (9970, '浦锦', 4, '310112', '310112009', 'p');
INSERT INTO `sys_data_region` VALUES (9971, '莘庄', 4, '310112', '310112101', 'x');
INSERT INTO `sys_data_region` VALUES (9972, '七宝', 4, '310112', '310112102', 'q');
INSERT INTO `sys_data_region` VALUES (9973, '颛桥', 4, '310112', '310112103', 'z');
INSERT INTO `sys_data_region` VALUES (9974, '华漕', 4, '310112', '310112106', 'h');
INSERT INTO `sys_data_region` VALUES (9975, '虹桥', 4, '310112', '310112107', 'h');
INSERT INTO `sys_data_region` VALUES (9976, '梅陇', 4, '310112', '310112108', 'm');
INSERT INTO `sys_data_region` VALUES (9977, '吴泾', 4, '310112', '310112110', 'w');
INSERT INTO `sys_data_region` VALUES (9978, '马桥', 4, '310112', '310112112', 'm');
INSERT INTO `sys_data_region` VALUES (9979, '浦江', 4, '310112', '310112114', 'p');
INSERT INTO `sys_data_region` VALUES (9980, '莘庄工业区', 4, '310112', '310112501', 'x');
INSERT INTO `sys_data_region` VALUES (9981, '宝山', 3, '3101', '310113', 'b');
INSERT INTO `sys_data_region` VALUES (9982, '友谊路', 4, '310113', '310113003', 'y');
INSERT INTO `sys_data_region` VALUES (9983, '吴淞', 4, '310113', '310113007', 'w');
INSERT INTO `sys_data_region` VALUES (9984, '张庙', 4, '310113', '310113008', 'z');
INSERT INTO `sys_data_region` VALUES (9985, '罗店', 4, '310113', '310113101', 'l');
INSERT INTO `sys_data_region` VALUES (9986, '大场', 4, '310113', '310113102', 'd');
INSERT INTO `sys_data_region` VALUES (9987, '杨行', 4, '310113', '310113103', 'y');
INSERT INTO `sys_data_region` VALUES (9988, '月浦', 4, '310113', '310113104', 'y');
INSERT INTO `sys_data_region` VALUES (9989, '罗泾', 4, '310113', '310113106', 'l');
INSERT INTO `sys_data_region` VALUES (9990, '顾村', 4, '310113', '310113109', 'g');
INSERT INTO `sys_data_region` VALUES (9991, '高境', 4, '310113', '310113111', 'g');
INSERT INTO `sys_data_region` VALUES (9992, '庙行', 4, '310113', '310113112', 'm');
INSERT INTO `sys_data_region` VALUES (9993, '淞南', 4, '310113', '310113113', 's');
INSERT INTO `sys_data_region` VALUES (9994, '嘉定', 3, '3101', '310114', 'j');
INSERT INTO `sys_data_region` VALUES (9995, '新成路', 4, '310114', '310114001', 'x');
INSERT INTO `sys_data_region` VALUES (9996, '真新', 4, '310114', '310114002', 'z');
INSERT INTO `sys_data_region` VALUES (9997, '菊园', 4, '310114', '310114003', 'j');
INSERT INTO `sys_data_region` VALUES (9998, '嘉定镇', 4, '310114', '310114004', 'j');
INSERT INTO `sys_data_region` VALUES (9999, '南翔', 4, '310114', '310114102', 'n');
INSERT INTO `sys_data_region` VALUES (10000, '安亭', 4, '310114', '310114103', 'a');
INSERT INTO `sys_data_region` VALUES (10001, '马陆', 4, '310114', '310114106', 'm');
INSERT INTO `sys_data_region` VALUES (10002, '徐行', 4, '310114', '310114109', 'x');
INSERT INTO `sys_data_region` VALUES (10003, '华亭', 4, '310114', '310114111', 'h');
INSERT INTO `sys_data_region` VALUES (10004, '外冈', 4, '310114', '310114114', 'w');
INSERT INTO `sys_data_region` VALUES (10005, '江桥', 4, '310114', '310114118', 'j');
INSERT INTO `sys_data_region` VALUES (10006, '浦东新区', 3, '3101', '310115', 'p');
INSERT INTO `sys_data_region` VALUES (10007, '潍坊新村', 4, '310115', '310115004', 'w');
INSERT INTO `sys_data_region` VALUES (10008, '陆家嘴', 4, '310115', '310115005', 'l');
INSERT INTO `sys_data_region` VALUES (10009, '周家渡', 4, '310115', '310115007', 'z');
INSERT INTO `sys_data_region` VALUES (10010, '塘桥', 4, '310115', '310115008', 't');
INSERT INTO `sys_data_region` VALUES (10011, '上钢新村', 4, '310115', '310115009', 's');
INSERT INTO `sys_data_region` VALUES (10012, '南码头路', 4, '310115', '310115010', 'n');
INSERT INTO `sys_data_region` VALUES (10013, '沪东新村', 4, '310115', '310115011', 'h');
INSERT INTO `sys_data_region` VALUES (10014, '金杨新村', 4, '310115', '310115012', 'j');
INSERT INTO `sys_data_region` VALUES (10015, '洋泾', 4, '310115', '310115013', 'y');
INSERT INTO `sys_data_region` VALUES (10016, '浦兴路', 4, '310115', '310115014', 'p');
INSERT INTO `sys_data_region` VALUES (10017, '东明路', 4, '310115', '310115015', 'd');
INSERT INTO `sys_data_region` VALUES (10018, '花木', 4, '310115', '310115016', 'h');
INSERT INTO `sys_data_region` VALUES (10019, '川沙新', 4, '310115', '310115103', 'c');
INSERT INTO `sys_data_region` VALUES (10020, '高桥', 4, '310115', '310115104', 'g');
INSERT INTO `sys_data_region` VALUES (10021, '北蔡', 4, '310115', '310115105', 'b');
INSERT INTO `sys_data_region` VALUES (10022, '合庆', 4, '310115', '310115110', 'h');
INSERT INTO `sys_data_region` VALUES (10023, '唐镇', 4, '310115', '310115114', 't');
INSERT INTO `sys_data_region` VALUES (10024, '曹路', 4, '310115', '310115117', 'c');
INSERT INTO `sys_data_region` VALUES (10025, '金桥', 4, '310115', '310115120', 'j');
INSERT INTO `sys_data_region` VALUES (10026, '高行', 4, '310115', '310115121', 'g');
INSERT INTO `sys_data_region` VALUES (10027, '高东', 4, '310115', '310115123', 'g');
INSERT INTO `sys_data_region` VALUES (10028, '张江', 4, '310115', '310115125', 'z');
INSERT INTO `sys_data_region` VALUES (10029, '三林', 4, '310115', '310115130', 's');
INSERT INTO `sys_data_region` VALUES (10030, '惠南', 4, '310115', '310115131', 'h');
INSERT INTO `sys_data_region` VALUES (10031, '周浦', 4, '310115', '310115132', 'z');
INSERT INTO `sys_data_region` VALUES (10032, '新场', 4, '310115', '310115133', 'x');
INSERT INTO `sys_data_region` VALUES (10033, '大团', 4, '310115', '310115134', 'd');
INSERT INTO `sys_data_region` VALUES (10034, '康桥', 4, '310115', '310115136', 'k');
INSERT INTO `sys_data_region` VALUES (10035, '航头', 4, '310115', '310115137', 'h');
INSERT INTO `sys_data_region` VALUES (10036, '祝桥', 4, '310115', '310115139', 'z');
INSERT INTO `sys_data_region` VALUES (10037, '泥城', 4, '310115', '310115140', 'n');
INSERT INTO `sys_data_region` VALUES (10038, '宣桥', 4, '310115', '310115141', 'x');
INSERT INTO `sys_data_region` VALUES (10039, '书院', 4, '310115', '310115142', 's');
INSERT INTO `sys_data_region` VALUES (10040, '万祥', 4, '310115', '310115143', 'w');
INSERT INTO `sys_data_region` VALUES (10041, '老港', 4, '310115', '310115144', 'l');
INSERT INTO `sys_data_region` VALUES (10042, '南汇新城', 4, '310115', '310115145', 'n');
INSERT INTO `sys_data_region` VALUES (10043, '金山', 3, '3101', '310116', 'j');
INSERT INTO `sys_data_region` VALUES (10044, '石化', 4, '310116', '310116001', 's');
INSERT INTO `sys_data_region` VALUES (10045, '朱泾', 4, '310116', '310116101', 'z');
INSERT INTO `sys_data_region` VALUES (10046, '枫泾', 4, '310116', '310116102', 'f');
INSERT INTO `sys_data_region` VALUES (10047, '张堰', 4, '310116', '310116103', 'z');
INSERT INTO `sys_data_region` VALUES (10048, '亭林', 4, '310116', '310116104', 't');
INSERT INTO `sys_data_region` VALUES (10049, '吕巷', 4, '310116', '310116105', 'l');
INSERT INTO `sys_data_region` VALUES (10050, '廊下', 4, '310116', '310116107', 'l');
INSERT INTO `sys_data_region` VALUES (10051, '金山卫', 4, '310116', '310116109', 'j');
INSERT INTO `sys_data_region` VALUES (10052, '漕泾', 4, '310116', '310116112', 'c');
INSERT INTO `sys_data_region` VALUES (10053, '山阳', 4, '310116', '310116113', 's');
INSERT INTO `sys_data_region` VALUES (10054, '松江', 3, '3101', '310117', 's');
INSERT INTO `sys_data_region` VALUES (10055, '岳阳', 4, '310117', '310117001', 'y');
INSERT INTO `sys_data_region` VALUES (10056, '永丰', 4, '310117', '310117002', 'y');
INSERT INTO `sys_data_region` VALUES (10057, '方松', 4, '310117', '310117003', 'f');
INSERT INTO `sys_data_region` VALUES (10058, '中山', 4, '310117', '310117004', 'z');
INSERT INTO `sys_data_region` VALUES (10059, '广富林', 4, '310117', '310117005', 'g');
INSERT INTO `sys_data_region` VALUES (10060, '九里亭', 4, '310117', '310117006', 'j');
INSERT INTO `sys_data_region` VALUES (10061, '泗泾', 4, '310117', '310117102', 's');
INSERT INTO `sys_data_region` VALUES (10062, '佘山', 4, '310117', '310117103', 's');
INSERT INTO `sys_data_region` VALUES (10063, '车墩', 4, '310117', '310117104', 'c');
INSERT INTO `sys_data_region` VALUES (10064, '新桥', 4, '310117', '310117105', 'x');
INSERT INTO `sys_data_region` VALUES (10065, '洞泾', 4, '310117', '310117106', 'd');
INSERT INTO `sys_data_region` VALUES (10066, '九亭', 4, '310117', '310117107', 'j');
INSERT INTO `sys_data_region` VALUES (10067, '泖港', 4, '310117', '310117109', 'm');
INSERT INTO `sys_data_region` VALUES (10068, '石湖荡', 4, '310117', '310117116', 's');
INSERT INTO `sys_data_region` VALUES (10069, '新浜', 4, '310117', '310117117', 'x');
INSERT INTO `sys_data_region` VALUES (10070, '叶榭', 4, '310117', '310117120', 'y');
INSERT INTO `sys_data_region` VALUES (10071, '小昆山', 4, '310117', '310117121', 'x');
INSERT INTO `sys_data_region` VALUES (10072, '松江工业区', 4, '310117', '310117501', 's');
INSERT INTO `sys_data_region` VALUES (10073, '青浦', 3, '3101', '310118', 'q');
INSERT INTO `sys_data_region` VALUES (10074, '夏阳', 4, '310118', '310118001', 'x');
INSERT INTO `sys_data_region` VALUES (10075, '盈浦', 4, '310118', '310118002', 'y');
INSERT INTO `sys_data_region` VALUES (10076, '香花桥', 4, '310118', '310118003', 'x');
INSERT INTO `sys_data_region` VALUES (10077, '朱家角', 4, '310118', '310118102', 'z');
INSERT INTO `sys_data_region` VALUES (10078, '练塘', 4, '310118', '310118103', 'l');
INSERT INTO `sys_data_region` VALUES (10079, '金泽', 4, '310118', '310118104', 'j');
INSERT INTO `sys_data_region` VALUES (10080, '赵巷', 4, '310118', '310118105', 'z');
INSERT INTO `sys_data_region` VALUES (10081, '徐泾', 4, '310118', '310118106', 'x');
INSERT INTO `sys_data_region` VALUES (10082, '华新', 4, '310118', '310118107', 'h');
INSERT INTO `sys_data_region` VALUES (10083, '重固', 4, '310118', '310118109', 'z');
INSERT INTO `sys_data_region` VALUES (10084, '白鹤', 4, '310118', '310118110', 'b');
INSERT INTO `sys_data_region` VALUES (10085, '奉贤', 3, '3101', '310120', 'f');
INSERT INTO `sys_data_region` VALUES (10086, '南桥', 4, '310120', '310120101', 'n');
INSERT INTO `sys_data_region` VALUES (10087, '奉城', 4, '310120', '310120102', 'f');
INSERT INTO `sys_data_region` VALUES (10088, '庄行', 4, '310120', '310120104', 'z');
INSERT INTO `sys_data_region` VALUES (10089, '金汇', 4, '310120', '310120106', 'j');
INSERT INTO `sys_data_region` VALUES (10090, '四团', 4, '310120', '310120109', 's');
INSERT INTO `sys_data_region` VALUES (10091, '青村', 4, '310120', '310120111', 'q');
INSERT INTO `sys_data_region` VALUES (10092, '柘林', 4, '310120', '310120118', 'z');
INSERT INTO `sys_data_region` VALUES (10093, '海湾', 4, '310120', '310120123', 'h');
INSERT INTO `sys_data_region` VALUES (10094, '崇明', 3, '3101', '310151', 'c');
INSERT INTO `sys_data_region` VALUES (10095, '城桥', 4, '310151', '310151100', 'c');
INSERT INTO `sys_data_region` VALUES (10096, '堡镇', 4, '310151', '310151101', 'b');
INSERT INTO `sys_data_region` VALUES (10097, '新河', 4, '310151', '310151102', 'x');
INSERT INTO `sys_data_region` VALUES (10098, '庙镇', 4, '310151', '310151103', 'm');
INSERT INTO `sys_data_region` VALUES (10099, '竖新', 4, '310151', '310151104', 's');
INSERT INTO `sys_data_region` VALUES (10100, '向化', 4, '310151', '310151105', 'x');
INSERT INTO `sys_data_region` VALUES (10101, '三星', 4, '310151', '310151106', 's');
INSERT INTO `sys_data_region` VALUES (10102, '港沿', 4, '310151', '310151107', 'g');
INSERT INTO `sys_data_region` VALUES (10103, '中兴', 4, '310151', '310151108', 'z');
INSERT INTO `sys_data_region` VALUES (10104, '陈家', 4, '310151', '310151109', 'c');
INSERT INTO `sys_data_region` VALUES (10105, '绿华', 4, '310151', '310151110', 'l');
INSERT INTO `sys_data_region` VALUES (10106, '港西', 4, '310151', '310151111', 'g');
INSERT INTO `sys_data_region` VALUES (10107, '建设', 4, '310151', '310151112', 'j');
INSERT INTO `sys_data_region` VALUES (10108, '新海', 4, '310151', '310151113', 'x');
INSERT INTO `sys_data_region` VALUES (10109, '东平', 4, '310151', '310151114', 'd');
INSERT INTO `sys_data_region` VALUES (10110, '长兴', 4, '310151', '310151115', 'c');
INSERT INTO `sys_data_region` VALUES (10111, '新村', 4, '310151', '310151200', 'x');
INSERT INTO `sys_data_region` VALUES (10112, '横沙', 4, '310151', '310151201', 'h');
INSERT INTO `sys_data_region` VALUES (10113, '东平林场', 4, '310151', '310151410', 'd');
INSERT INTO `sys_data_region` VALUES (10114, '江苏', 1, '0', '32', 'j');
INSERT INTO `sys_data_region` VALUES (10115, '南京', 2, '32', '3201', 'n');
INSERT INTO `sys_data_region` VALUES (10116, '玄武', 3, '3201', '320102', 'x');
INSERT INTO `sys_data_region` VALUES (10117, '梅园新村', 4, '320102', '320102002', 'm');
INSERT INTO `sys_data_region` VALUES (10118, '新街口', 4, '320102', '320102003', 'x');
INSERT INTO `sys_data_region` VALUES (10119, '玄武门', 4, '320102', '320102005', 'x');
INSERT INTO `sys_data_region` VALUES (10120, '锁金村', 4, '320102', '320102007', 's');
INSERT INTO `sys_data_region` VALUES (10121, '红山', 4, '320102', '320102008', 'h');
INSERT INTO `sys_data_region` VALUES (10122, '孝陵卫', 4, '320102', '320102009', 'x');
INSERT INTO `sys_data_region` VALUES (10123, '玄武湖', 4, '320102', '320102010', 'x');
INSERT INTO `sys_data_region` VALUES (10124, '秦淮', 3, '3201', '320104', 'q');
INSERT INTO `sys_data_region` VALUES (10125, '秦虹', 4, '320104', '320104001', 'q');
INSERT INTO `sys_data_region` VALUES (10126, '夫子庙', 4, '320104', '320104002', 'f');
INSERT INTO `sys_data_region` VALUES (10127, '双塘', 4, '320104', '320104004', 's');
INSERT INTO `sys_data_region` VALUES (10128, '中华门', 4, '320104', '320104006', 'z');
INSERT INTO `sys_data_region` VALUES (10129, '红花', 4, '320104', '320104007', 'h');
INSERT INTO `sys_data_region` VALUES (10130, '洪武路', 4, '320104', '320104008', 'h');
INSERT INTO `sys_data_region` VALUES (10131, '五老村', 4, '320104', '320104009', 'w');
INSERT INTO `sys_data_region` VALUES (10132, '大光路', 4, '320104', '320104010', 'd');
INSERT INTO `sys_data_region` VALUES (10133, '瑞金路', 4, '320104', '320104011', 'r');
INSERT INTO `sys_data_region` VALUES (10134, '月牙湖', 4, '320104', '320104012', 'y');
INSERT INTO `sys_data_region` VALUES (10135, '光华路', 4, '320104', '320104013', 'g');
INSERT INTO `sys_data_region` VALUES (10136, '朝天宫', 4, '320104', '320104014', 'c');
INSERT INTO `sys_data_region` VALUES (10137, '建邺', 3, '3201', '320105', 'j');
INSERT INTO `sys_data_region` VALUES (10138, '兴隆', 4, '320105', '320105006', 'x');
INSERT INTO `sys_data_region` VALUES (10139, '南苑', 4, '320105', '320105007', 'n');
INSERT INTO `sys_data_region` VALUES (10140, '双闸', 4, '320105', '320105008', 's');
INSERT INTO `sys_data_region` VALUES (10141, '沙洲', 4, '320105', '320105009', 's');
INSERT INTO `sys_data_region` VALUES (10142, '江心洲', 4, '320105', '320105010', 'j');
INSERT INTO `sys_data_region` VALUES (10143, '莫愁湖', 4, '320105', '320105011', 'm');
INSERT INTO `sys_data_region` VALUES (10144, '鼓楼', 3, '3201', '320106', 'g');
INSERT INTO `sys_data_region` VALUES (10145, '宁海路', 4, '320106', '320106001', 'n');
INSERT INTO `sys_data_region` VALUES (10146, '华侨路', 4, '320106', '320106002', 'h');
INSERT INTO `sys_data_region` VALUES (10147, '湖南路', 4, '320106', '320106003', 'h');
INSERT INTO `sys_data_region` VALUES (10148, '中央门', 4, '320106', '320106004', 'z');
INSERT INTO `sys_data_region` VALUES (10149, '挹江门', 4, '320106', '320106005', 'y');
INSERT INTO `sys_data_region` VALUES (10150, '江东', 4, '320106', '320106006', 'j');
INSERT INTO `sys_data_region` VALUES (10151, '凤凰', 4, '320106', '320106007', 'f');
INSERT INTO `sys_data_region` VALUES (10152, '下关', 4, '320106', '320106008', 'x');
INSERT INTO `sys_data_region` VALUES (10153, '热河南路', 4, '320106', '320106009', 'r');
INSERT INTO `sys_data_region` VALUES (10154, '幕府山', 4, '320106', '320106010', 'm');
INSERT INTO `sys_data_region` VALUES (10155, '建宁路', 4, '320106', '320106011', 'j');
INSERT INTO `sys_data_region` VALUES (10156, '宝塔桥', 4, '320106', '320106012', 'b');
INSERT INTO `sys_data_region` VALUES (10157, '小市', 4, '320106', '320106013', 'x');
INSERT INTO `sys_data_region` VALUES (10158, '浦口', 3, '3201', '320111', 'p');
INSERT INTO `sys_data_region` VALUES (10159, '泰山', 4, '320111', '320111001', 't');
INSERT INTO `sys_data_region` VALUES (10160, '顶山', 4, '320111', '320111002', 'd');
INSERT INTO `sys_data_region` VALUES (10161, '沿江', 4, '320111', '320111003', 'y');
INSERT INTO `sys_data_region` VALUES (10162, '江浦', 4, '320111', '320111004', 'j');
INSERT INTO `sys_data_region` VALUES (10163, '桥林', 4, '320111', '320111005', 'q');
INSERT INTO `sys_data_region` VALUES (10164, '汤泉', 4, '320111', '320111006', 't');
INSERT INTO `sys_data_region` VALUES (10165, '盘城', 4, '320111', '320111007', 'p');
INSERT INTO `sys_data_region` VALUES (10166, '星甸', 4, '320111', '320111008', 'x');
INSERT INTO `sys_data_region` VALUES (10167, '永宁', 4, '320111', '320111009', 'y');
INSERT INTO `sys_data_region` VALUES (10168, '老山林场', 4, '320111', '320111400', 'l');
INSERT INTO `sys_data_region` VALUES (10169, '汤泉农场', 4, '320111', '320111401', 't');
INSERT INTO `sys_data_region` VALUES (10170, '栖霞', 3, '3201', '320113', 'q');
INSERT INTO `sys_data_region` VALUES (10171, '尧化', 4, '320113', '320113001', 'y');
INSERT INTO `sys_data_region` VALUES (10172, '马群', 4, '320113', '320113002', 'm');
INSERT INTO `sys_data_region` VALUES (10173, '迈皋桥', 4, '320113', '320113003', 'm');
INSERT INTO `sys_data_region` VALUES (10174, '燕子矶', 4, '320113', '320113004', 'y');
INSERT INTO `sys_data_region` VALUES (10175, '仙林', 4, '320113', '320113005', 'x');
INSERT INTO `sys_data_region` VALUES (10176, '龙潭', 4, '320113', '320113007', 'l');
INSERT INTO `sys_data_region` VALUES (10177, '栖霞街道', 4, '320113', '320113008', 'q');
INSERT INTO `sys_data_region` VALUES (10178, '八卦洲', 4, '320113', '320113009', 'b');
INSERT INTO `sys_data_region` VALUES (10179, '西岗', 4, '320113', '320113010', 'x');
INSERT INTO `sys_data_region` VALUES (10180, '雨花台', 3, '3201', '320114', 'y');
INSERT INTO `sys_data_region` VALUES (10181, '赛虹桥', 4, '320114', '320114002', 's');
INSERT INTO `sys_data_region` VALUES (10182, '雨花', 4, '320114', '320114003', 'y');
INSERT INTO `sys_data_region` VALUES (10183, '西善桥', 4, '320114', '320114004', 'x');
INSERT INTO `sys_data_region` VALUES (10184, '板桥', 4, '320114', '320114005', 'b');
INSERT INTO `sys_data_region` VALUES (10185, '铁心桥', 4, '320114', '320114006', 't');
INSERT INTO `sys_data_region` VALUES (10186, '梅山', 4, '320114', '320114008', 'm');
INSERT INTO `sys_data_region` VALUES (10187, '古雄', 4, '320114', '320114009', 'g');
INSERT INTO `sys_data_region` VALUES (10188, '江宁', 3, '3201', '320115', 'j');
INSERT INTO `sys_data_region` VALUES (10189, '东山', 4, '320115', '320115001', 'd');
INSERT INTO `sys_data_region` VALUES (10190, '禄口', 4, '320115', '320115004', 'l');
INSERT INTO `sys_data_region` VALUES (10191, '淳化', 4, '320115', '320115005', 'c');
INSERT INTO `sys_data_region` VALUES (10192, '麒麟', 4, '320115', '320115006', 'q');
INSERT INTO `sys_data_region` VALUES (10193, '横溪', 4, '320115', '320115007', 'h');
INSERT INTO `sys_data_region` VALUES (10194, '江宁街道', 4, '320115', '320115008', 'j');
INSERT INTO `sys_data_region` VALUES (10195, '谷里', 4, '320115', '320115009', 'g');
INSERT INTO `sys_data_region` VALUES (10196, '汤山', 4, '320115', '320115010', 't');
INSERT INTO `sys_data_region` VALUES (10197, '秣陵', 4, '320115', '320115011', 'm');
INSERT INTO `sys_data_region` VALUES (10198, '湖熟', 4, '320115', '320115012', 'h');
INSERT INTO `sys_data_region` VALUES (10199, '六合', 3, '3201', '320116', 'l');
INSERT INTO `sys_data_region` VALUES (10200, '龙池', 4, '320116', '320116001', 'l');
INSERT INTO `sys_data_region` VALUES (10201, '雄州', 4, '320116', '320116002', 'x');
INSERT INTO `sys_data_region` VALUES (10202, '横梁', 4, '320116', '320116003', 'h');
INSERT INTO `sys_data_region` VALUES (10203, '金牛湖', 4, '320116', '320116004', 'j');
INSERT INTO `sys_data_region` VALUES (10204, '程桥', 4, '320116', '320116005', 'c');
INSERT INTO `sys_data_region` VALUES (10205, '马鞍', 4, '320116', '320116006', 'm');
INSERT INTO `sys_data_region` VALUES (10206, '龙袍', 4, '320116', '320116007', 'l');
INSERT INTO `sys_data_region` VALUES (10207, '冶山', 4, '320116', '320116008', 'y');
INSERT INTO `sys_data_region` VALUES (10208, '大厂', 4, '320116', '320116010', 'd');
INSERT INTO `sys_data_region` VALUES (10209, '葛塘', 4, '320116', '320116011', 'g');
INSERT INTO `sys_data_region` VALUES (10210, '长芦', 4, '320116', '320116012', 'c');
INSERT INTO `sys_data_region` VALUES (10211, '竹镇', 4, '320116', '320116110', 'z');
INSERT INTO `sys_data_region` VALUES (10212, '溧水', 3, '3201', '320117', 'l');
INSERT INTO `sys_data_region` VALUES (10213, '永阳', 4, '320117', '320117001', 'y');
INSERT INTO `sys_data_region` VALUES (10214, '柘塘', 4, '320117', '320117002', 'z');
INSERT INTO `sys_data_region` VALUES (10215, '东屏', 4, '320117', '320117003', 'd');
INSERT INTO `sys_data_region` VALUES (10216, '石湫', 4, '320117', '320117004', 's');
INSERT INTO `sys_data_region` VALUES (10217, '洪蓝', 4, '320117', '320117005', 'h');
INSERT INTO `sys_data_region` VALUES (10218, '白马', 4, '320117', '320117101', 'b');
INSERT INTO `sys_data_region` VALUES (10219, '晶桥', 4, '320117', '320117106', 'j');
INSERT INTO `sys_data_region` VALUES (10220, '和凤', 4, '320117', '320117107', 'h');
INSERT INTO `sys_data_region` VALUES (10221, '高淳', 3, '3201', '320118', 'g');
INSERT INTO `sys_data_region` VALUES (10222, '淳溪', 4, '320118', '320118001', 'c');
INSERT INTO `sys_data_region` VALUES (10223, '古柏', 4, '320118', '320118002', 'g');
INSERT INTO `sys_data_region` VALUES (10224, '漆桥', 4, '320118', '320118003', 'q');
INSERT INTO `sys_data_region` VALUES (10225, '固城', 4, '320118', '320118004', 'g');
INSERT INTO `sys_data_region` VALUES (10226, '东坝', 4, '320118', '320118005', 'd');
INSERT INTO `sys_data_region` VALUES (10227, '桠溪', 4, '320118', '320118006', 'y');
INSERT INTO `sys_data_region` VALUES (10228, '阳江', 4, '320118', '320118101', 'y');
INSERT INTO `sys_data_region` VALUES (10229, '砖墙', 4, '320118', '320118102', 'z');
INSERT INTO `sys_data_region` VALUES (10230, '无锡', 2, '32', '3202', 'w');
INSERT INTO `sys_data_region` VALUES (10231, '锡山', 3, '3202', '320205', 'x');
INSERT INTO `sys_data_region` VALUES (10232, '东亭', 4, '320205', '320205001', 'd');
INSERT INTO `sys_data_region` VALUES (10233, '安镇', 4, '320205', '320205002', 'a');
INSERT INTO `sys_data_region` VALUES (10234, '东北塘', 4, '320205', '320205003', 'd');
INSERT INTO `sys_data_region` VALUES (10235, '云林', 4, '320205', '320205004', 'y');
INSERT INTO `sys_data_region` VALUES (10236, '厚桥', 4, '320205', '320205005', 'h');
INSERT INTO `sys_data_region` VALUES (10237, '羊尖', 4, '320205', '320205102', 'y');
INSERT INTO `sys_data_region` VALUES (10238, '鹅湖', 4, '320205', '320205104', 'e');
INSERT INTO `sys_data_region` VALUES (10239, '锡北', 4, '320205', '320205106', 'x');
INSERT INTO `sys_data_region` VALUES (10240, '东港', 4, '320205', '320205107', 'd');
INSERT INTO `sys_data_region` VALUES (10241, '惠山', 3, '3202', '320206', 'h');
INSERT INTO `sys_data_region` VALUES (10242, '堰桥', 4, '320206', '320206001', 'y');
INSERT INTO `sys_data_region` VALUES (10243, '长安', 4, '320206', '320206002', 'c');
INSERT INTO `sys_data_region` VALUES (10244, '钱桥', 4, '320206', '320206003', 'q');
INSERT INTO `sys_data_region` VALUES (10245, '前洲', 4, '320206', '320206004', 'q');
INSERT INTO `sys_data_region` VALUES (10246, '玉祁', 4, '320206', '320206005', 'y');
INSERT INTO `sys_data_region` VALUES (10247, '洛社', 4, '320206', '320206103', 'l');
INSERT INTO `sys_data_region` VALUES (10248, '阳山', 4, '320206', '320206105', 'y');
INSERT INTO `sys_data_region` VALUES (10249, '滨湖', 3, '3202', '320211', 'b');
INSERT INTO `sys_data_region` VALUES (10250, '河埒', 4, '320211', '320211001', 'h');
INSERT INTO `sys_data_region` VALUES (10251, '荣巷', 4, '320211', '320211002', 'r');
INSERT INTO `sys_data_region` VALUES (10252, '蠡湖', 4, '320211', '320211003', 'l');
INSERT INTO `sys_data_region` VALUES (10253, '蠡园', 4, '320211', '320211004', 'l');
INSERT INTO `sys_data_region` VALUES (10254, '华庄', 4, '320211', '320211006', 'h');
INSERT INTO `sys_data_region` VALUES (10255, '太湖', 4, '320211', '320211007', 't');
INSERT INTO `sys_data_region` VALUES (10256, '雪浪', 4, '320211', '320211008', 'x');
INSERT INTO `sys_data_region` VALUES (10257, '马山', 4, '320211', '320211009', 'm');
INSERT INTO `sys_data_region` VALUES (10258, '胡埭', 4, '320211', '320211104', 'h');
INSERT INTO `sys_data_region` VALUES (10259, '梁溪', 3, '3202', '320213', 'l');
INSERT INTO `sys_data_region` VALUES (10260, '崇安寺', 4, '320213', '320213001', 'c');
INSERT INTO `sys_data_region` VALUES (10261, '通江', 4, '320213', '320213002', 't');
INSERT INTO `sys_data_region` VALUES (10262, '广瑞路', 4, '320213', '320213003', 'g');
INSERT INTO `sys_data_region` VALUES (10263, '上马墩', 4, '320213', '320213004', 's');
INSERT INTO `sys_data_region` VALUES (10264, '江海', 4, '320213', '320213005', 'j');
INSERT INTO `sys_data_region` VALUES (10265, '广益', 4, '320213', '320213006', 'g');
INSERT INTO `sys_data_region` VALUES (10266, '迎龙桥', 4, '320213', '320213007', 'y');
INSERT INTO `sys_data_region` VALUES (10267, '南禅寺', 4, '320213', '320213008', 'n');
INSERT INTO `sys_data_region` VALUES (10268, '清名桥', 4, '320213', '320213009', 'q');
INSERT INTO `sys_data_region` VALUES (10269, '金星', 4, '320213', '320213010', 'j');
INSERT INTO `sys_data_region` VALUES (10270, '金匮', 4, '320213', '320213011', 'j');
INSERT INTO `sys_data_region` VALUES (10271, '扬名', 4, '320213', '320213012', 'y');
INSERT INTO `sys_data_region` VALUES (10272, '北大街', 4, '320213', '320213013', 'b');
INSERT INTO `sys_data_region` VALUES (10273, '惠山', 4, '320213', '320213014', 'h');
INSERT INTO `sys_data_region` VALUES (10274, '山北', 4, '320213', '320213015', 's');
INSERT INTO `sys_data_region` VALUES (10275, '黄巷', 4, '320213', '320213016', 'h');
INSERT INTO `sys_data_region` VALUES (10276, '五河', 4, '320213', '320213017', 'w');
INSERT INTO `sys_data_region` VALUES (10277, '新吴', 3, '3202', '320214', 'x');
INSERT INTO `sys_data_region` VALUES (10278, '新安', 4, '320214', '320214001', 'x');
INSERT INTO `sys_data_region` VALUES (10279, '旺庄', 4, '320214', '320214002', 'w');
INSERT INTO `sys_data_region` VALUES (10280, '硕放', 4, '320214', '320214003', 's');
INSERT INTO `sys_data_region` VALUES (10281, '江溪', 4, '320214', '320214004', 'j');
INSERT INTO `sys_data_region` VALUES (10282, '梅村', 4, '320214', '320214005', 'm');
INSERT INTO `sys_data_region` VALUES (10283, '鸿山', 4, '320214', '320214006', 'h');
INSERT INTO `sys_data_region` VALUES (10284, '江阴', 3, '3202', '320281', 'j');
INSERT INTO `sys_data_region` VALUES (10285, '澄江', 4, '320281', '320281001', 'c');
INSERT INTO `sys_data_region` VALUES (10286, '南闸', 4, '320281', '320281004', 'n');
INSERT INTO `sys_data_region` VALUES (10287, '云亭', 4, '320281', '320281005', 'y');
INSERT INTO `sys_data_region` VALUES (10288, '城东', 4, '320281', '320281006', 'c');
INSERT INTO `sys_data_region` VALUES (10289, '夏港', 4, '320281', '320281008', 'x');
INSERT INTO `sys_data_region` VALUES (10290, '申港', 4, '320281', '320281009', 's');
INSERT INTO `sys_data_region` VALUES (10291, '利港', 4, '320281', '320281010', 'l');
INSERT INTO `sys_data_region` VALUES (10292, '璜土', 4, '320281', '320281101', 'h');
INSERT INTO `sys_data_region` VALUES (10293, '月城', 4, '320281', '320281106', 'y');
INSERT INTO `sys_data_region` VALUES (10294, '青阳', 4, '320281', '320281107', 'q');
INSERT INTO `sys_data_region` VALUES (10295, '徐霞客', 4, '320281', '320281108', 'x');
INSERT INTO `sys_data_region` VALUES (10296, '华士', 4, '320281', '320281113', 'h');
INSERT INTO `sys_data_region` VALUES (10297, '周庄', 4, '320281', '320281114', 'z');
INSERT INTO `sys_data_region` VALUES (10298, '新桥', 4, '320281', '320281115', 'x');
INSERT INTO `sys_data_region` VALUES (10299, '长泾', 4, '320281', '320281116', 'c');
INSERT INTO `sys_data_region` VALUES (10300, '顾山', 4, '320281', '320281117', 'g');
INSERT INTO `sys_data_region` VALUES (10301, '祝塘', 4, '320281', '320281119', 'z');
INSERT INTO `sys_data_region` VALUES (10302, '宜兴', 3, '3202', '320282', 'y');
INSERT INTO `sys_data_region` VALUES (10303, '新庄', 4, '320282', '320282001', 'x');
INSERT INTO `sys_data_region` VALUES (10304, '宜城', 4, '320282', '320282002', 'y');
INSERT INTO `sys_data_region` VALUES (10305, '屺亭', 4, '320282', '320282003', 'q');
INSERT INTO `sys_data_region` VALUES (10306, '新街', 4, '320282', '320282005', 'x');
INSERT INTO `sys_data_region` VALUES (10307, '芳桥', 4, '320282', '320282006', 'f');
INSERT INTO `sys_data_region` VALUES (10308, '张渚', 4, '320282', '320282101', 'z');
INSERT INTO `sys_data_region` VALUES (10309, '西渚', 4, '320282', '320282102', 'x');
INSERT INTO `sys_data_region` VALUES (10310, '太华', 4, '320282', '320282103', 't');
INSERT INTO `sys_data_region` VALUES (10311, '徐舍', 4, '320282', '320282105', 'x');
INSERT INTO `sys_data_region` VALUES (10312, '官林', 4, '320282', '320282108', 'g');
INSERT INTO `sys_data_region` VALUES (10313, '杨巷', 4, '320282', '320282109', 'y');
INSERT INTO `sys_data_region` VALUES (10314, '新建', 4, '320282', '320282111', 'x');
INSERT INTO `sys_data_region` VALUES (10315, '和桥', 4, '320282', '320282114', 'h');
INSERT INTO `sys_data_region` VALUES (10316, '高塍', 4, '320282', '320282115', 'g');
INSERT INTO `sys_data_region` VALUES (10317, '万石', 4, '320282', '320282118', 'w');
INSERT INTO `sys_data_region` VALUES (10318, '周铁', 4, '320282', '320282119', 'z');
INSERT INTO `sys_data_region` VALUES (10319, '丁蜀', 4, '320282', '320282123', 'd');
INSERT INTO `sys_data_region` VALUES (10320, '湖??', 4, '320282', '320282125', 'h');
INSERT INTO `sys_data_region` VALUES (10321, '徐州', 2, '32', '3203', 'x');
INSERT INTO `sys_data_region` VALUES (10322, '鼓楼', 3, '3203', '320302', 'g');
INSERT INTO `sys_data_region` VALUES (10323, '丰财', 4, '320302', '320302001', 'f');
INSERT INTO `sys_data_region` VALUES (10324, '环城', 4, '320302', '320302002', 'h');
INSERT INTO `sys_data_region` VALUES (10325, '黄楼', 4, '320302', '320302003', 'h');
INSERT INTO `sys_data_region` VALUES (10326, '牌楼', 4, '320302', '320302004', 'p');
INSERT INTO `sys_data_region` VALUES (10327, '琵琶', 4, '320302', '320302008', 'p');
INSERT INTO `sys_data_region` VALUES (10328, '铜沛', 4, '320302', '320302011', 't');
INSERT INTO `sys_data_region` VALUES (10329, '九里', 4, '320302', '320302012', 'j');
INSERT INTO `sys_data_region` VALUES (10330, '金山桥', 4, '320302', '320302013', 'j');
INSERT INTO `sys_data_region` VALUES (10331, '东环', 4, '320302', '320302014', 'd');
INSERT INTO `sys_data_region` VALUES (10332, '云龙', 3, '3203', '320303', 'y');
INSERT INTO `sys_data_region` VALUES (10333, '彭城', 4, '320303', '320303001', 'p');
INSERT INTO `sys_data_region` VALUES (10334, '子房', 4, '320303', '320303005', 'z');
INSERT INTO `sys_data_region` VALUES (10335, '黄山', 4, '320303', '320303007', 'h');
INSERT INTO `sys_data_region` VALUES (10336, '骆驼山', 4, '320303', '320303008', 'l');
INSERT INTO `sys_data_region` VALUES (10337, '大郭庄', 4, '320303', '320303010', 'd');
INSERT INTO `sys_data_region` VALUES (10338, '翠屏山', 4, '320303', '320303011', 'c');
INSERT INTO `sys_data_region` VALUES (10339, '潘塘', 4, '320303', '320303012', 'p');
INSERT INTO `sys_data_region` VALUES (10340, '大龙湖', 4, '320303', '320303013', 'd');
INSERT INTO `sys_data_region` VALUES (10341, '汉风', 4, '320303', '320303014', 'h');
INSERT INTO `sys_data_region` VALUES (10342, '贾汪', 3, '3203', '320305', 'j');
INSERT INTO `sys_data_region` VALUES (10343, '大泉', 4, '320305', '320305003', 'd');
INSERT INTO `sys_data_region` VALUES (10344, '老矿', 4, '320305', '320305004', 'l');
INSERT INTO `sys_data_region` VALUES (10345, '大吴', 4, '320305', '320305005', 'd');
INSERT INTO `sys_data_region` VALUES (10346, '潘安湖', 4, '320305', '320305006', 'p');
INSERT INTO `sys_data_region` VALUES (10347, '大庙', 4, '320305', '320305007', 'd');
INSERT INTO `sys_data_region` VALUES (10348, '大黄山', 4, '320305', '320305008', 'd');
INSERT INTO `sys_data_region` VALUES (10349, '茱萸山', 4, '320305', '320305009', 'z');
INSERT INTO `sys_data_region` VALUES (10350, '青山泉', 4, '320305', '320305102', 'q');
INSERT INTO `sys_data_region` VALUES (10351, '紫庄', 4, '320305', '320305104', 'z');
INSERT INTO `sys_data_region` VALUES (10352, '塔山', 4, '320305', '320305105', 't');
INSERT INTO `sys_data_region` VALUES (10353, '汴塘', 4, '320305', '320305106', 'b');
INSERT INTO `sys_data_region` VALUES (10354, '江庄', 4, '320305', '320305107', 'j');
INSERT INTO `sys_data_region` VALUES (10355, '泉山', 3, '3203', '320311', 'q');
INSERT INTO `sys_data_region` VALUES (10356, '王陵', 4, '320311', '320311001', 'w');
INSERT INTO `sys_data_region` VALUES (10357, '永安', 4, '320311', '320311003', 'y');
INSERT INTO `sys_data_region` VALUES (10358, '湖滨', 4, '320311', '320311004', 'h');
INSERT INTO `sys_data_region` VALUES (10359, '段庄', 4, '320311', '320311005', 'd');
INSERT INTO `sys_data_region` VALUES (10360, '翟山', 4, '320311', '320311006', 'd');
INSERT INTO `sys_data_region` VALUES (10361, '奎山', 4, '320311', '320311007', 'k');
INSERT INTO `sys_data_region` VALUES (10362, '和平', 4, '320311', '320311008', 'h');
INSERT INTO `sys_data_region` VALUES (10363, '泰山', 4, '320311', '320311011', 't');
INSERT INTO `sys_data_region` VALUES (10364, '金山', 4, '320311', '320311012', 'j');
INSERT INTO `sys_data_region` VALUES (10365, '七里沟', 4, '320311', '320311014', 'q');
INSERT INTO `sys_data_region` VALUES (10366, '火花', 4, '320311', '320311015', 'h');
INSERT INTO `sys_data_region` VALUES (10367, '苏山', 4, '320311', '320311016', 's');
INSERT INTO `sys_data_region` VALUES (10368, '庞庄', 4, '320311', '320311017', 'p');
INSERT INTO `sys_data_region` VALUES (10369, '桃园', 4, '320311', '320311018', 't');
INSERT INTO `sys_data_region` VALUES (10370, '铜山', 3, '3203', '320312', 't');
INSERT INTO `sys_data_region` VALUES (10371, '利国街道', 4, '320312', '320312002', 'l');
INSERT INTO `sys_data_region` VALUES (10372, '张集街道', 4, '320312', '320312003', 'z');
INSERT INTO `sys_data_region` VALUES (10373, '垞城', 4, '320312', '320312004', 'c');
INSERT INTO `sys_data_region` VALUES (10374, '电厂', 4, '320312', '320312005', 'd');
INSERT INTO `sys_data_region` VALUES (10375, '拾屯', 4, '320312', '320312008', 's');
INSERT INTO `sys_data_region` VALUES (10376, '铜山街道', 4, '320312', '320312009', 't');
INSERT INTO `sys_data_region` VALUES (10377, '三堡', 4, '320312', '320312010', 's');
INSERT INTO `sys_data_region` VALUES (10378, '新区', 4, '320312', '320312011', 'x');
INSERT INTO `sys_data_region` VALUES (10379, '沿湖', 4, '320312', '320312012', 'y');
INSERT INTO `sys_data_region` VALUES (10380, '何桥', 4, '320312', '320312102', 'h');
INSERT INTO `sys_data_region` VALUES (10381, '黄集', 4, '320312', '320312103', 'h');
INSERT INTO `sys_data_region` VALUES (10382, '马坡', 4, '320312', '320312104', 'm');
INSERT INTO `sys_data_region` VALUES (10383, '郑集', 4, '320312', '320312105', 'z');
INSERT INTO `sys_data_region` VALUES (10384, '柳新', 4, '320312', '320312106', 'l');
INSERT INTO `sys_data_region` VALUES (10385, '刘集', 4, '320312', '320312107', 'l');
INSERT INTO `sys_data_region` VALUES (10386, '大彭', 4, '320312', '320312108', 'd');
INSERT INTO `sys_data_region` VALUES (10387, '汉王', 4, '320312', '320312109', 'h');
INSERT INTO `sys_data_region` VALUES (10388, '棠张', 4, '320312', '320312111', 't');
INSERT INTO `sys_data_region` VALUES (10389, '张集镇', 4, '320312', '320312112', 'z');
INSERT INTO `sys_data_region` VALUES (10390, '房村', 4, '320312', '320312113', 'f');
INSERT INTO `sys_data_region` VALUES (10391, '伊庄', 4, '320312', '320312114', 'y');
INSERT INTO `sys_data_region` VALUES (10392, '单集', 4, '320312', '320312115', 'd');
INSERT INTO `sys_data_region` VALUES (10393, '徐庄', 4, '320312', '320312117', 'x');
INSERT INTO `sys_data_region` VALUES (10394, '大许', 4, '320312', '320312118', 'd');
INSERT INTO `sys_data_region` VALUES (10395, '茅村', 4, '320312', '320312119', 'm');
INSERT INTO `sys_data_region` VALUES (10396, '柳泉', 4, '320312', '320312120', 'l');
INSERT INTO `sys_data_region` VALUES (10397, '利国镇', 4, '320312', '320312121', 'l');
INSERT INTO `sys_data_region` VALUES (10398, '丰县', 3, '3203', '320321', 'f');
INSERT INTO `sys_data_region` VALUES (10399, '中阳里', 4, '320321', '320321001', 'z');
INSERT INTO `sys_data_region` VALUES (10400, '凤城', 4, '320321', '320321002', 'f');
INSERT INTO `sys_data_region` VALUES (10401, '孙楼', 4, '320321', '320321003', 's');
INSERT INTO `sys_data_region` VALUES (10402, '首羡', 4, '320321', '320321102', 's');
INSERT INTO `sys_data_region` VALUES (10403, '顺河', 4, '320321', '320321103', 's');
INSERT INTO `sys_data_region` VALUES (10404, '常店', 4, '320321', '320321104', 'c');
INSERT INTO `sys_data_region` VALUES (10405, '欢口', 4, '320321', '320321105', 'h');
INSERT INTO `sys_data_region` VALUES (10406, '师寨', 4, '320321', '320321106', 's');
INSERT INTO `sys_data_region` VALUES (10407, '华山', 4, '320321', '320321107', 'h');
INSERT INTO `sys_data_region` VALUES (10408, '梁寨', 4, '320321', '320321108', 'l');
INSERT INTO `sys_