create PROCEDURE [dbo].[PROC_SETCOMMENT]
  @table_name VARCHAR(200),
  @column_name VARCHAR(200),
  @comment VARCHAR(200)
AS
BEGIN
  IF @column_name is null or @column_name=''
  BEGIN
    IF (SELECT COUNT(1) FROM fn_listextendedproperty('MS_Description', 'user', 'dbo', 
        'TABLE', @table_name,null,null)) > 0
      EXECUTE sp_updateextendedproperty 'MS_Description', @comment, 'user', 'dbo', 
        'TABLE', @table_name
    ELSE
      EXECUTE sp_addextendedproperty 'MS_Description', @comment, 'user', 'dbo', 
        'TABLE', @table_name
  END
  ELSE
  BEGIN
    IF (SELECT COUNT(1) FROM fn_listextendedproperty('MS_Description', 'user', 'dbo', 
        'TABLE', @table_name, 'COLUMN', @column_name)) > 0
      EXECUTE sp_updateextendedproperty 'MS_Description', @comment, 'user', 'dbo', 
        'TABLE', @table_name, 'COLUMN', @column_name
    ELSE
      EXECUTE sp_addextendedproperty 'MS_Description', @comment, 'user', 'dbo', 
        'TABLE', @table_name, 'COLUMN', @column_name
  END
END
GO

CREATE TABLE [sys_app] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(50) NOT NULL,
  [name] VARCHAR(200) NOT NULL,
  [description] VARCHAR(2000),
  [version] VARCHAR(20) NOT NULL,
  [developer_id] INT,
  [category_id] INT NOT NULL,
  [status] SMALLINT,
  [deploy] VARCHAR(10),
  [terminal] VARCHAR(45),
  [url_phone] VARCHAR(500),
  [url_pad] VARCHAR(500),
  [url_web] VARCHAR(500),
  [icon_path] VARCHAR(500),
  [createtime] DATETIME,
  [lastupdate] DATETIME,
  [mark] INT,
  [install_count] INT,
  [market_status] INT,
  [order_no] INT,
  [url_phone_detail] VARCHAR(500),
  [url_pad_detail] VARCHAR(500),
  [url_web_detail] VARCHAR(500),
  [icon_code] VARCHAR(45),
  [titlebar_color] VARCHAR(10),
  [init_service] VARCHAR(100),
  [default] SMALLINT,
  [free] SMALLINT,
  [msg_group] SMALLINT,
  [get_badge_service] VARCHAR(300),
  [pc_open_type] SMALLINT,
  [pc_show_on_sysbar] SMALLINT,
  [url_pc] VARCHAR(500),
  [url_pc_detail] VARCHAR(500),
  PRIMARY KEY ([id])
)
GO 

ALTER TABLE [sys_app] ADD DEFAULT (0) FOR [category_id] 
GO 

INSERT INTO sys_app VALUES ('sys/org','组织结构',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/user/index.tfp','{"icon":"iconfont icon-org","color":"#ffffff","bg":"#0288d1"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/user/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/role','系统群组',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/role/index.tfp','{"icon":"iconfont icon-role","color":"#ffffff","bg":"#ff8f00"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/role/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/appManage','应用管理',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/app/index.tfp','{"icon":"iconfont icon-project","color":"#ffffff","bg":"#0288d1"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/app/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/scheduleTask','计划任务','','1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/scheduled_task/index.tfp','{"icon":"iconfont icon-plan","color":"#ffffff","bg":"#fbc02d"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/scheduled_task/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/bgService','后台服务',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/bg_service/index.tfp','{"icon":"iconfont icon-default","color":"#ffffff","bg":"#0277bd"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/bg_service/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/attach','附件管理',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/app_attach/index.tfp',
'{"type":"iconfont","class":"iconfont icon-file","color":"#ffffff","bgColor":"#9c27b0"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/app_attach/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/datadic','数据字典',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,
'/app/sys/data_dic/index.tfp','{"type":"iconfont","class":"iconfont icon-regulations","color":"#ffffff","bgColor":"#7b1fa2"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/data_dic/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/encodingrule','编码规则',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/encoding_rule/index.tfp',
'{"icon":"iconfont icon-news","color":"#ffffff","bg":"#42bd41"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/encoding_rule/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/log','系统日志',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/log/index.tfp','{"icon":"iconfont icon-news","color":"#ffffff","bg":"#42bd41"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/log/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/setting','系统设置',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/settings/index.tfp','{"icon":"iconfont icon-systemset","color":"#ffffff","bg":"#d01716"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'/app/sys/settings/index.tfp',NULL)
GO
INSERT INTO sys_app VALUES ('sys/info','系统信息',NULL,'1.0.000',1,1,0,'server','web',NULL,NULL,'/app/sys/sysinfo/index.tfp','{"icon":"iconfont icon-journal","color":"#ffffff","bg":"#6a1b9a"}','2015-10-13 15:16:31','2015-10-13 15:16:31',
NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'/app/sys/sysinfo/index.tfp',NULL)
GO

CREATE TABLE [sys_app_attach_type]  (
  [id] INT IDENTITY(1,1),
  [app_code] VARCHAR(20),
  [app_name] VARCHAR(45),
  [create_time] DATETIME,
  [creater_id] INT,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_app_attach] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(50) NOT NULL,
  [name] VARCHAR(200) NOT NULL,
  [size] INT NOT NULL,
  [type] VARCHAR(20),
  [app_code] VARCHAR(20) NOT NULL,
  [app_data_id] INT,
  [uploader_id] INT NOT NULL,
  [upload_time] DATETIME NOT NULL,
  [save_path] VARCHAR(500) NOT NULL,
  [org_id] INT NOT NULL,
  [uploader_name] VARCHAR(10),
  PRIMARY KEY ([id])
)
GO 

CREATE TABLE [sys_app_auth] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [org_id] INT,
  [app_id] INT,
  [owner_type] VARCHAR(10),
  [owner_id] INT,
  [opration_id] INT,
  [terminal] VARCHAR(10),
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_app_auth VALUES (1,1,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,2,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,3,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,4,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,5,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,6,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,7,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,8,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,9,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,10,'role',1,NULL,'web')
GO
INSERT INTO sys_app_auth VALUES (1,11,'role',1,NULL,'web')
GO

CREATE TABLE [sys_app_category] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [name] VARCHAR(50) NOT NULL,
  [parent_id] INT NOT NULL,
  [icon_code] VARCHAR(200),
  [group_apps] SMALLINT,
  [order_no] INT,
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_app_category VALUES ('系统维护',0,NULL,NULL,NULL)
GO

CREATE TABLE [sys_app_opration] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [app_id] INT NOT NULL,
  [name] VARCHAR(50) NOT NULL,
  [service_path] VARCHAR(200) NOT NULL,
  [terminal] VARCHAR(10),
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '添加部门信息', '/app/sys/service/dep/add', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '修改部门信息', '/app/sys/service/dep/update', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '删除部门信息', '/app/sys/service/dep/delete', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '添加用户信息', '/app/sys/service/user/add', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '修改用户信息', '/app/sys/service/user/update', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '删除用户信息', '/app/sys/service/user/delete', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '禁用用户信息', '/app/sys/service/user/disable', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '启用用户信息', '/app/sys/service/user/enable', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '恢复用户密码', '/app/sys/service/user/recoveryPwd', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '导出用户信息', '/app/sys/service/user/exportGetList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '查看用户信息', '/app/sys/service/user/preUpdate', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '设置用户头像', '/app/sys/service/user/setHeadManage', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '查看操作权限', '/app/sys/service/user/getDataPageOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '添加操作权限', '/app/sys/service/app/addOprationAuth', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '删除操作权限', '/app/sys/service/app/deleteOprationAuth', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '查看管辖部门', '/app/sys/service/user/getSubDepList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '添加管辖部门', '/app/sys/service/user/addSubDep', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '删除管辖部门', '/app/sys/service/user/deleteSubDep', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '查看任职部门', '/app/sys/service/user/getDepList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '添加任职部门', '/app/sys/service/user/addDep', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (1, '删除任职部门', '/app/sys/service/user/deleteDep', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '添加群组信息', '/app/sys/service/role/add', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '修改群组信息', '/app/sys/service/role/update', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '删除群组信息', '/app/sys/service/role/delete', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '添加用户信息', '/app/sys/service/role/addUser', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '删除用户信息', '/app/sys/service/role/deleteUser', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '查看操作权限', '/app/sys/service/role/getDataPageOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '添加操作权限', '/app/sys/service/app/addOprationAuth', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '删除操作权限', '/app/sys/service/app/deleteOprationAuth', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (2, '设置管理员', '/app/sys/service/role/setAdmin', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '添加应用分类', '/app/sys/service/app/addCategory', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '修改应用分类', '/app/sys/service/app/updateCategory', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '删除应用分类', '/app/sys/service/app/deleteCategory', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '查询应用列表', '/app/sys/service/app/getList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '添加应用信息', '/app/sys/service/app/add', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '修改应用信息', '/app/sys/service/app/update', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '删除应用信息', '/app/sys/service/app/delete', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '禁用应用信息', '/app/sys/service/app/disable', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '启用应用信息', '/app/sys/service/app/enable', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '查询访问权限列表', '/app/sys/service/app/getAuthList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '删除访问权限信息', '/app/sys/service/app/deleteAuth', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '查询操作权限', '/app/sys/service/app/getOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '添加操作权限', '/app/sys/service/app/addOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '修改操作权限', '/app/sys/service/app/updateOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '删除操作权限', '/app/sys/service/app/deleteOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '添加权限信息', '/app/sys/service/app/addAuth', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '查询应用信息', '/app/sys/service/app/get', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '查询应用分类', '/app/sys/service/app/getCategory', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (3, '查看操作列表', '/app/sys/service/app/getDataPageOpration', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '查询任务列表', '/app/sys/service/scheduled_task/getList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '添加任务信息', '/app/sys/service/scheduled_task/add', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '修改任务信息', '/app/sys/service/scheduled_task/update', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '删除任务信息', '/app/sys/service/scheduled_task/delete', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '禁用任务信息', '/app/sys/service/scheduled_task/disable', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '启用任务信息', '/app/sys/service/scheduled_task/enable', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (4, '查询任务信息', '/app/sys/service/scheduled_task/get', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '查询服务列表', '/app/sys/service/bg_service/getList', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '添加服务信息', '/app/sys/service/bg_service/add', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '修改服务信息', '/app/sys/service/bg_service/update', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '删除服务信息', '/app/sys/service/bg_service/delete', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '停止服务信息', '/app/sys/service/bg_service/stop', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '启用服务信息', '/app/sys/service/bg_service/start', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (5, '查询服务信息', '/app/sys/service/bg_service/get', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询文件下载列表', '/app/sys/service/log/getListDownload', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询错误日志列表', '/app/sys/service/log/getListError', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询登录日志列表', '/app/sys/service/log/getListLogin', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询请求日志列表', '/app/sys/service/log/getListRequest', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询动态请求列表', '/app/sys/service/log/getListService', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询文件上传列表', '/app/sys/service/log/getListUpload', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询静态请求列表', '/app/sys/service/log/getListStatic', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询数据库操作列表', '/app/sys/service/log/getListSql', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询错误详细信息', '/app/sys/service/log/getDetailError', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询动态服务请求信息', '/app/sys/service/log/getDetailService', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (7, '查询数据库操作信息', '/app/sys/service/log/getDetailSql', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '查询系统激活信息', '/app/sys/service/org/get', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '生成SI文件', '/app/sys/service/org/createSI', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '查询附件信息', '/app/sys/service/setting/getAttachInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '修改附件信息', '/app/sys/service/setting/setAttachInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '查询基本参数信息', '/app/sys/service/setting/getBaseInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '修改基本参数信息', '/app/sys/service/setting/setBaseInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '查询日志信息', '/app/sys/service/setting/getLogInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '修改日志信息', '/app/sys/service/setting/setLogInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '查询数据库信息', '/app/sys/service/setting/getDBInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '修改数据库信息', '/app/sys/service/setting/setDBInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '查询Web服务器信息', '/app/sys/service/setting/getWebServerInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (8, '修改Web服务器信息', '/app/sys/service/setting/setWebServerInfo', 'all')
GO 
INSERT INTO sys_app_opration (app_id, name, service_path, terminal) VALUES (9, '查询系统信息', '/app/sys/service/setting/getSysInfo', 'all')
GO 

CREATE TABLE [sys_app_update] (
  [app_id] INT NOT NULL,
  [description] VARCHAR(5000),
  [creater_id] INT,
  [createtime] DATETIME,
  [version] VARCHAR(45),
  PRIMARY KEY ([app_id])
)
GO 

CREATE TABLE [sys_dep] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(10) NOT NULL,
  [name] VARCHAR(100) NOT NULL,
  [fullname] VARCHAR(200),
  [org_id] INT NOT NULL,
  [status] SMALLINT NOT NULL,
  [description] VARCHAR(500),
  [parent_id] INT NOT NULL,
  [creater_id] INT NOT NULL,
  [createtime] DATETIME NOT NULL,
  PRIMARY KEY ([id])
)
GO 

ALTER TABLE [sys_dep] ADD DEFAULT (0) FOR [parent_id] 
GO 

INSERT INTO sys_dep VALUES ('1001','默认部门','默认部门',1,0,'',0,1,'2015-03-09 18:59:26')
GO

CREATE TABLE [sys_dep_user] (
  [org_id] INT NOT NULL,
  [dep_id] INT NOT NULL,
  [user_id] INT NOT NULL,
  [creater_id] INT,
  [createtime] DATETIME,
  PRIMARY KEY ([org_id],[dep_id],[user_id])
)
GO 

INSERT INTO sys_dep_user VALUES (1,1,1,1,'2015-04-30 13:22:16')
GO

CREATE TABLE [sys_log_download] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [req_id] VARCHAR(20),
  [req_time] SMALLDATETIME,
  [session_id] VARCHAR(50),
  [org_id] INT,
  [org_code] VARCHAR(50),
  [user_id] INT,
  [login_name] VARCHAR(200),
  [terminal] VARCHAR(20),
  [app_code] VARCHAR(50),
  [app_data_id] INT,
  [file_id] INT,
  [file_code] VARCHAR(50),
  [file_name] VARCHAR(200),
  [file_size] INT,
  [file_path] VARCHAR(500),
  [thumbnail] SMALLINT,
  CONSTRAINT pk_sys_log_download PRIMARY KEY([id])
)
GO 

CREATE TABLE [sys_log_error] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [req_id] VARCHAR(20),
  [req_time] SMALLDATETIME,
  [session_id] VARCHAR(50),
  [org_id] INT,
  [org_code] VARCHAR(50),
  [user_id] INT,
  [login_name] VARCHAR(200),
  [type] VARCHAR(20),
  [message] VARCHAR(500),
  [stack] TEXT,
  CONSTRAINT pk_sys_log_error PRIMARY KEY([id])
)
GO 
 
CREATE TABLE [sys_log_request] (
  [id] VARCHAR(20) NOT NULL,
  [ip] VARCHAR(50),
  [port] INT,
  [req_time] SMALLDATETIME,
  [req_ms] SMALLINT,
  [type] VARCHAR(20),
  [path] VARCHAR(500),
  [host] VARCHAR(50),
  [protocol] VARCHAR(10),
  [method] VARCHAR(10),
  [user_agent] VARCHAR(500),
  [response_code] INT,
  [response_message] VARCHAR(500),
  [res_time] SMALLDATETIME,
  [res_ms] SMALLINT,
  [use_time] INT,
  CONSTRAINT pk_sys_log_request PRIMARY KEY([id])
)
GO 

CREATE TABLE [sys_log_service] (
  [id] VARCHAR(20) NOT NULL,
  [session_id] VARCHAR(50),
  [org_id] INT,
  [org_code] VARCHAR(50),
  [user_id] INT,
  [login_name] VARCHAR(200),
  [app_code] VARCHAR(50),
  [terminal] VARCHAR(20),
  [path] VARCHAR(500),
  [header_data] TEXT,
  [req_data] TEXT,
  [res_data] TEXT,
  [res_code] SMALLINT,
  [err_msg] VARCHAR(500),
  [start_time] SMALLDATETIME,
  [start_ms] SMALLINT,
  [end_time] SMALLDATETIME,
  [end_ms] SMALLINT,
  [use_time] INT,
  CONSTRAINT pk_sys_log_service PRIMARY KEY([id])
)
GO

CREATE TABLE [sys_log_sql] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [req_id] VARCHAR(20),
  [session_id] VARCHAR(50),
  [org_id] INT,
  [org_code] VARCHAR(50),
  [user_id] INT,
  [login_name] VARCHAR(200),
  [sql_text] TEXT,
  [params] TEXT,
  [err_code] SMALLINT,
  [err_msg] TEXT,
  [start_time] SMALLDATETIME,
  [start_ms] SMALLINT,
  [end_time] SMALLDATETIME,
  [end_ms] SMALLINT,
  [use_time] INT,
  CONSTRAINT pk_sys_log_sql PRIMARY KEY([id])
)
GO 

CREATE TABLE [sys_log_static] (
  [id] VARCHAR(20) NOT NULL,
  [req_time] SMALLDATETIME,
  [real_url] VARCHAR(500),
  [content_type] VARCHAR(50),
  [content_size] INT,
  [range_start] INT,
  [range_end] INT,
  [compress_type] VARCHAR(50),
  [last_modified] SMALLDATETIME,
  CONSTRAINT pk_sys_log_static PRIMARY KEY([id])
)
GO 

CREATE TABLE [sys_log_upload] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [req_id] VARCHAR(20),
  [req_time] SMALLDATETIME,
  [session_id] VARCHAR(50),
  [org_id] INT,
  [org_code] VARCHAR(50),
  [user_id] INT,
  [login_name] VARCHAR(200),
  [terminal] VARCHAR(20),
  [app_code] VARCHAR(50),
  [app_data_id] INT,
  [file_code] VARCHAR(50),
  [file_name] VARCHAR(200),
  [file_size] INT,
  CONSTRAINT pk_sys_log_upload PRIMARY KEY([id])
)
GO  

CREATE TABLE [sys_msg] (
  [id] INT NOT NULL,
  [org_id] INT NOT NULL,
  [type] VARCHAR(50) NOT NULL,
  [sender_id] INT NOT NULL,
  [sender_ctype] VARCHAR(20),
  [send_time] DATETIME NOT NULL,
  [title] VARCHAR(200),
  [summary] VARCHAR(500),
  [icon] VARCHAR(200),
  [sound] VARCHAR(200),
  [open_type] SMALLINT,
  [open_content] VARCHAR(200),
  [group_display] SMALLINT,
  [receiver_ctype] VARCHAR(20),
  [to_self] SMALLINT,
  [to_all] SMALLINT,
  [retain_days] INT,
  [data] TEXT,
  PRIMARY KEY ([id])
)
GO 

CREATE TABLE [sys_msg_receive] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [org_id] INT,
  [msg_id] INT,
  [receiver_id] INT,
  [receiver_name] VARCHAR(50),
  [receive_status_phone] SMALLINT,
  [receive_status_pad] SMALLINT,
  [receive_status_pc] SMALLINT,
  [receive_status_web] SMALLINT,
  [receive_time_phone] DATETIME,
  [receive_time_pad] DATETIME,
  [receive_time_pc] DATETIME,
  [receive_time_web] DATETIME,
  [read_time] DATETIME,
  [read_client_type] VARCHAR(50),
  [delete_status] SMALLINT,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_org] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(16) NOT NULL,
  [name] VARCHAR(200) NOT NULL,
  [description] VARCHAR(500),
  [status] TINYINT NOT NULL,
  [user_count] INT,
  [createtime] DATETIME,
  [creater_id] INT,
  [last_update] DATETIME,
  [default_pwd] VARCHAR(100),
  [look_all] SMALLINT,
  [look_self_bureau] SMALLINT,
  [look_self_dep] SMALLINT,
  [look_leader] SMALLINT,
  [look_under] SMALLINT,
  [create_group] SMALLINT,
  [disable_chat] SMALLINT,
  [only_app_center] SMALLINT,
  [logo_image] VARCHAR(200),
  [launch_image] VARCHAR(200),
  [custom_install_package] SMALLINT,
  [allow_add_friend] SMALLINT,
  [show_nickname_in_user_list] SMALLINT,
  [show_post_in_user_list] SMALLINT,
  [show_motto_in_user_list] SMALLINT,
  [show_type_in_role_list] SMALLINT,
  [show_description_in_role_list] SMALLINT,
  [client_view_title_bgcolor] VARCHAR(45),
  [client_button_bgcolor] VARCHAR(45),
  [disable_work_circle] SMALLINT,
  [app_center_url] VARCHAR(200),
  [app_center_title] VARCHAR(45),
  [work_circle_title] VARCHAR(45),
  [disable_address_book] SMALLINT,
  [allow_regist] SMALLINT,
  [agent_id] INT,
  [msg_center_title] VARCHAR(20),
  [show_netstatus_in_user_list] SMALLINT,
  [user_cell_left_info] VARCHAR(45),
  [user_cell_right_info] VARCHAR(45),
  [user_cell_bottom_info] VARCHAR(45),
  [regist_url] VARCHAR(200),
  [disable_appmarket] SMALLINT,
  [show_app_center_banner] SMALLINT,
  [app_center_banner_height] INT,
  [bind_client_device] SMALLINT,
  [disable_chpwd] INT,
  [disable_taskmsg] INT,
  [disable_msg_center] INT,
  [appcenter_netdisk] INT,
  [bottom_mail] INT,
  [disable_app_center] INT,
  [disable_set_ad] INT,
  [disable_set_logo] INT,
  [disable_set_slogan] INT,
  [disable_set_launch_image] INT,
  [remark] VARCHAR(500),
  [apns_channel] INT,
  [server_device_code] VARCHAR(64),
  [mps_addr] VARCHAR(100),
  [mps_port] INT,
  [web_addr] VARCHAR(100),
  [web_port] INT,
  [tcpfile_addr] VARCHAR(100),
  [tcpfile_port] INT,
  [httpfile_addr] VARCHAR(100),
  [httpfile_port] INT,
  [ddns_type] VARCHAR(10),
  [disk_limit] INT,
  [disk_limit_unit] VARCHAR(2),
  [file_size_limit] INT,
  [auth_end_date] DATETIME,
  [online_play_addr] VARCHAR(200),
  [watermark_path] VARCHAR(200),
  [ignore_pc_online] SMALLINT,
  [hide_about] SMALLINT,
  [auth_key] VARCHAR(32),
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_org VALUES ('taskmsg','任讯信息','',0,20,'2015-05-01 18:18:31',1,'2020-11-01 23:05:58','f9429ab0b5f04baf1e9dd1cef50cbd8f',
1,1,0,1,0,1,0,0,NULL,NULL,0,0,0,0,0,1,0,NULL,NULL,0,'','','',0,0,NULL,NULL,0,'loginname','tel_work','email',
NULL,NULL,1,400,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
'f84707a40cf74ec18b3eefb76f16d58a')
GO

CREATE TABLE [sys_org_app] (
  [org_id] INT NOT NULL,
  [app_id] INT NOT NULL,
  [status] INT NOT NULL,
  [category_id] INT NOT NULL,
  [installer_id] INT NOT NULL,
  [install_time] DATETIME NOT NULL,
  [order_no] INT,
  [titlebar_color] VARCHAR(10),
  PRIMARY KEY ([org_id],[app_id])
)
GO 

INSERT INTO sys_org_app VALUES (1,1,0,1,1,'2015-10-13 15:16:31',1,NULL)
GO
INSERT INTO sys_org_app VALUES (1,2,0,1,1,'2015-10-13 15:16:31',2,NULL)
GO
INSERT INTO sys_org_app VALUES (1,3,0,1,1,'2015-10-13 15:16:31',3,NULL)
GO
INSERT INTO sys_org_app VALUES (1,4,0,1,1,'2015-10-13 15:16:31',4,NULL)
GO
INSERT INTO sys_org_app VALUES (1,5,0,1,1,'2015-10-13 15:16:31',5,NULL)
GO
INSERT INTO sys_org_app VALUES (1,6,0,1,1,'2015-10-13 15:16:31',6,NULL)
GO
INSERT INTO sys_org_app VALUES (1,7,0,1,1,'2020-04-07 17:04:04',7,NULL)
GO
INSERT INTO sys_org_app VALUES (1,8,0,1,1,'2020-04-07 17:04:41',8,NULL)
GO
INSERT INTO sys_org_app VALUES (1,9,0,1,1,'2022-01-29 21:30:09',9,NULL)
GO
INSERT INTO sys_org_app VALUES (1,10,0,1,1,'2022-01-29 21:30:09',10,NULL)
GO
INSERT INTO sys_org_app VALUES (1,11,0,1,1,'2022-01-29 21:30:09',11,NULL)
GO

CREATE TABLE [sys_org_app_category] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(20),
  [name] VARCHAR(45) NOT NULL,
  [parent_id] INT NOT NULL,
  [org_id] INT NOT NULL,
  [group_apps] SMALLINT,
  [icon_code] VARCHAR(200),
  [order_no] INT,
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_org_app_category VALUES ('sys','系统维护',0,1,NULL,NULL,9999)
GO

CREATE TABLE [sys_role] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [name] VARCHAR(50) NOT NULL,
  [org_id] INT NOT NULL,
  [code] VARCHAR(4) NOT NULL,
  [description] VARCHAR(500),
  [creater_id] INT NOT NULL,
  [createtime] DATETIME NOT NULL,
  [status] TINYINT NOT NULL,
  [type] VARCHAR(45),
  [allow_apply_join] SMALLINT,
  [head_id] INT,
  [only_app_center] SMALLINT,
  [disable_address_book] SMALLINT,
  [disable_work_circle] SMALLINT,
  [disable_app_center] SMALLINT,
  [disable_taskmsg] SMALLINT,
  [disk_limit] SMALLINT,
  [disk_limit_unit] VARCHAR(45),
  [file_size_limit] SMALLINT,
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_role VALUES ('系统管理员',1,'1',NULL,1,'2015-03-10 16:41:49',0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)
GO
INSERT INTO sys_role VALUES ('所有人',1,'9999',NULL,1,'2015-03-10 16:41:49',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)
GO

CREATE TABLE [sys_role_type] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [org_id] INT,
  [name] VARCHAR(45),
  [creater_id] INT,
  [createtime] DATETIME,
  [code] VARCHAR(10),
  PRIMARY KEY ([id])
)
GO 

CREATE TABLE [sys_role_user] (
  [org_id] INT NOT NULL,
  [role_id] INT NOT NULL,
  [user_id] INT NOT NULL,
  [creater_id] INT,
  [createtime] DATETIME,
  [is_admin] SMALLINT,
  PRIMARY KEY ([org_id],[role_id],[user_id])
)
GO 

INSERT INTO sys_role_user VALUES (1,1,1,1,'2015-12-21 16:09:26',1)
GO

CREATE TABLE [sys_scheduled_task] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [org_id] INT,
  [name] VARCHAR(200),
  [type] SMALLINT,
  [exe_time] VARCHAR(45),
  [period_type] VARCHAR(45),
  [period_range] VARCHAR(100),
  [service] VARCHAR(200),
  [status] SMALLINT,
  [creater_id] INT,
  [createtime] DATETIME,
  [last_exe_time] DATETIME,
  [next_exe_time] DATETIME,
  [start_date] DATETIME,
  [end_date] DATETIME,
  [server_id] VARCHAR(45),
  [tag] VARCHAR(200),
  [sys_task] SMALLINT,
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_scheduled_task VALUES (1,'清理附件缓存',1,'00:10:00','day',NULL,'/sys/service/app/clearAttachCache',0,1,'2020-04-21 09:00:00',
NULL,NULL,'2020-04-21 09:00:00',NULL,'TaskMsgServer',NULL,1)
GO

CREATE TABLE [sys_session] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(45),
  [org_id] INT,
  [user_id] INT,
  [create_time] DATETIME,
  [end_time] DATETIME,
  [last_update] DATETIME,
  [last_address] VARCHAR(45),
  [last_port] INT,
  [server_type] VARCHAR(25),
  [client_type] VARCHAR(15),
  [client_version] VARCHAR(10),
  [client_net_type] VARCHAR(45),
  [client_os] VARCHAR(45),
  [client_os_version] VARCHAR(45),
  [device_manufactor] VARCHAR(45),
  [device_model] VARCHAR(45),
  [device_id] VARCHAR(45),
  [device_token] VARCHAR(200),
  [operator_name] VARCHAR(45),
  [status] SMALLINT,
  PRIMARY KEY ([id])
)
GO 

CREATE TABLE [sys_user] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [code] VARCHAR(16) NOT NULL,
  [name] VARCHAR(20) NOT NULL,
  [loginname] VARCHAR(20) NOT NULL,
  [password] VARCHAR(50) NOT NULL,
  [org_id] INT NOT NULL,
  [status] TINYINT NOT NULL,
  [mobile] VARCHAR(20),
  [email] VARCHAR(50),
  [motto] VARCHAR(100),
  [creater_id] INT NOT NULL,
  [createtime] DATETIME NOT NULL,
  [lastlogintime] DATETIME,
  [lastloginip] VARCHAR(30),
  [sex] SMALLINT,
  [post] VARCHAR(50),
  [create_group] SMALLINT,
  [look_all] SMALLINT,
  [look_self_bureau] SMALLINT,
  [look_self_dep] SMALLINT,
  [look_leader] SMALLINT,
  [look_under] SMALLINT,
  [province] VARCHAR(45),
  [city] VARCHAR(45),
  [district] VARCHAR(45),
  [address] VARCHAR(500),
  [nickname] VARCHAR(45),
  [tel_short] VARCHAR(10),
  [tel_work] VARCHAR(20),
  [tel_home] VARCHAR(20),
  [tel_other] VARCHAR(20),
  [only_app_center] SMALLINT,
  [disable_address_book] SMALLINT,
  [disable_work_circle] SMALLINT,
  [device_manufactor] VARCHAR(20),
  [device_model] VARCHAR(50),
  [device_id] VARCHAR(50),
  [not_bind_device] SMALLINT,
  [client_type] VARCHAR(20),
  [client_version] VARCHAR(10),
  [client_os_version] VARCHAR(10),
  [operator_name] VARCHAR(10),
  [net_type] VARCHAR(10),
  [head_id] INT,
  [last_update_pwd] DATETIME,
  [disable_app_center] SMALLINT,
  [disable_taskmsg] SMALLINT,
  [disable_chpwd] INT,
  [disk_limit] INT,
  [disk_limit_unit] VARCHAR(2),
  [file_size_limit] INT,
  [bind_ca] INT,
  [bind_ca_id] VARCHAR(45),
  [theme_id] VARCHAR(45),
  [othercode] VARCHAR(500),
  PRIMARY KEY ([id])
)
GO 

INSERT INTO sys_user VALUES ('999999','管理员','admin','f9429ab0b5f04baf1e9dd1cef50cbd8f',1,0,'13504997777','123@sina.com','123',1,
'2015-03-09 19:01:54','2017-04-22 14:09:24',NULL,0,NULL,1,1,1,1,1,1,NULL,NULL,NULL,NULL,'123123','2','3','4','5',NULL,NULL,NULL,NULL,NULL,NULL,0,
'androidphone','0.2.018',NULL,NULL,'3g',27,'2020-06-27 12:03:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1',NULL)
GO

CREATE TABLE [sys_user_post] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [org_id] INT,
  [name] VARCHAR(45),
  [creater_id] INT,
  [createtime] DATETIME,
  [code] VARCHAR(10),
  PRIMARY KEY ([id])
)
GO 

CREATE TABLE [sys_user_subdep] (
  [user_id] INT NOT NULL,
  [dep_id] INT NOT NULL,
  [org_id] INT,
  PRIMARY KEY ([user_id],[dep_id])
)
GO 

CREATE TABLE [sys_setting] (
  [id] INT IDENTITY(1,1) NOT NULL,
  [org_id] INT NOT NULL,
  [json] VARCHAR(500),
  [param] VARCHAR(500),
  [web_json] VARCHAR(500),
  [web_param] VARCHAR(500),
  [mobile_json] VARCHAR(500),
  [mobile_param] VARCHAR(500),
  [pad_json] VARCHAR(500),
  [pad_param] VARCHAR(500),
  [pc_json] VARCHAR(500),
  [pc_param] VARCHAR(500),
  [safe_json] VARCHAR(2000),
  [safe_param] VARCHAR(2000),
  [msg_json] VARCHAR(2000),
  [msg_param] VARCHAR(2000),
  [address_json] VARCHAR(2000),
  [address_param] VARCHAR(2000),
  [file_json] VARCHAR(2000),
  [file_param] VARCHAR(2000),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_client_version] (
  [id] int IDENTITY(1,1) NOT NULL,
  [client_type] varchar(50),
  [client_code] varchar(50),
  [version] varchar(50),
  [os_type] varchar(50),
  [description] text,
  [url] varchar(200),
  [enforce] int,
  [creator_id] int,
  [createtime] datetime,
  [status] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_post] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [code] varchar(50),
  [name] varchar(200) NOT NULL,
  [parent_id] int NOT NULL,
  [parent_ids] varchar(400),
  [description] varchar(400),
  [status] smallint,
  [creater_id] int,
  [createtime] datetime,
  [last_modifier_id] int,
  [last_modify_time] datetime,
  [deleter_id] int,
  [delete_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_level] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [code] varchar(50),
  [name] varchar(200) NOT NULL,
  [description] varchar(400),
  [status] smallint,
  [creater_id] int,
  [createtime] datetime,
  [last_modifier_id] int,
  [last_modify_time] datetime,
  [deleter_id] int,
  [delete_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_layer] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [code] varchar(50),
  [name] varchar(200) NOT NULL,
  [description] varchar(400),
  [status] smallint,
  [creater_id] int,
  [createtime] datetime,
  [last_modifier_id] int,
  [last_modify_time] datetime,
  [deleter_id] int,
  [delete_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_user_friend] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [user_id] int,
  [group_id] int,
  [friend_id] int,
  [status] smallint,
  [createtime] datetime,
  [delete_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_user_friend_group] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [user_id] int,
  [code] varchar(50),
  [name] varchar(200),
  [status] smallint,
  [createtime] datetime,
  [delete_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_user_sign]  (
	[id] INT IDENTITY(1,1) NOT NULL,
	[org_id] INT,
	[user_id] INT,
	[sign_type] VARCHAR(20),
	[sign_code] VARCHAR(50),
	[sign_password] VARCHAR(50),
	[sign_comment] VARCHAR(200),
	[sign_status] smallint,
	[creater_id] INT,
	[createtime] datetime,
	[deleter_id] INT,
	[delete_time] datetime,
	PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_data_dictype] (
  [id] int IDENTITY(1,1) NOT NULL,
  [name] varchar(20) NOT NULL,
  [parent_id] int,
  [id_full_path] varchar(100),
  [org_id] int,
  [status] int,
  [code] varchar(50),
  [tacit] varchar(50),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_data_dic] (
  [id] int IDENTITY(1,1) NOT NULL,
  [name] varchar(200) NOT NULL,
  [type_id] int,
  [code] varchar(10),
  [status] smallint,
  [org_id] int,
  [type_code] varchar(45),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_data_region] (
  [id] int IDENTITY(1,1) NOT NULL,
  [name] varchar(100) NOT NULL,
  [level] tinyint,
  [parent_code] varchar(20),
  [code] varchar(20),
  [first_letter] varchar(2),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_encodingrule] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [pk_type] varchar(50),
  [pk_code] varchar(50),
  [clear_mode] varchar(2),
  [update_mode] varchar(2),
  [sn_type] varchar(2),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_encodingrule_item] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [encodingrule_id] int,
  [order_number] int,
  [encoding_type] varchar(20),
  [encoding_count] int,
  [encoding_content] varchar(50),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [sys_encodingrule_sn] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [encodingrule_id] int,
  [fk_type] varchar(50),
  [fk_code] varchar(200),
  [encoding_year] int,
  [encoding_month] int,
  [encoding_date] int,
  [sn] int,
  PRIMARY KEY ([id])
)
GO

insert into sys_data_dictype([name],[parent_id],[org_id],[status],[code]) values('系统数据',0,1,0,'system')
GO

update sys_data_dictype set [id_full_path]=('/'+cast([id] as varchar(20))+'/') where [name]='系统数据'
GO

insert into sys_data_dictype([name],[parent_id],[org_id],[status],[code]) 
select '编码规则',[id],1,0,'encodingrule' from sys_data_dictype where [name]='系统数据'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on a.[name]='编码规则' and b.id=a.parent_id
GO

insert into sys_data_dictype([name],[parent_id],[org_id],[status],[code]) 
select '清零方式',[id],1,0,'encodingrule-clear-mode' from sys_data_dictype where [name]='编码规则'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on a.[name]='清零方式' and b.id=a.parent_id
GO

insert into sys_data_dictype([name],[parent_id],[org_id],[status],[code]) 
select '更新方式',[id],1,0,'encodingrule-update-mode' from sys_data_dictype where [name]='编码规则'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on a.[name]='更新方式' and b.id=a.parent_id
GO

insert into sys_data_dictype([name],[parent_id],[org_id],[status],[code]) 
select '流水号类型',[id],1,0,'encodingrule-sn-type' from sys_data_dictype where [name]='编码规则'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on a.[name]='流水号类型' and b.id=a.parent_id
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '不清零', id, 'N', 0, 1, code from sys_data_dictype where code='encodingrule-clear-mode'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按月清零', id, 'M', 0, 1, code from sys_data_dictype where code='encodingrule-clear-mode'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按日清零', id, 'D', 0, 1, code from sys_data_dictype where code='encodingrule-clear-mode'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '读取时更新', id, 'R', 0, 1, code from sys_data_dictype where code='encodingrule-update-mode'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '写入时更新', id, 'W', 0, 1, code from sys_data_dictype where code='encodingrule-update-mode'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按组织生成', id, 'O', 0, 1, code from sys_data_dictype where code='encodingrule-sn-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按部门生成', id, 'D', 0, 1, code from sys_data_dictype where code='encodingrule-sn-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '按用户生成', id, 'U', 0, 1, code from sys_data_dictype where code='encodingrule-sn-type'
GO

CREATE TABLE [im_dep_mute] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [dep_id] int,
  [user_id] int,
  [mute_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_group] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [code] varchar(50),
  [name] varchar(200),
  [description] varchar(500),
  [type] varchar(20),
  [user_id] int,
  [app_code] varchar(50),
  [app_data_id] int,
  [set_name] smallint,
  [status] smallint,
  [createtime] datetime,
  [creater_id] int,
  [delete_time] datetime,
  [delete_user_id] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_group_mute] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [group_id] int,
  [user_id] int,
  [mute_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_group_user] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [group_id] int,
  [user_id] int,
  [favorite] smallint,
  [param_json] varchar(500),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg] (
  [id] int NOT NULL,
  [org_id] int,
  [content_type] varchar(20),
  [group_type] varchar(20),
  [group_id] int,
  [group_name] varchar(200),
  [receiver_id] int,
  [receiver_name] varchar(200),
  [at_user_ids] varchar(200),
  [content] text,
  [revoke_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg_dir] (
  [id] int NOT NULL,
  [org_id] int,
  [dir_name] varchar(200),
  [dir_size] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg_dir_file] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [msg_id] int,
  [file_code] varchar(50),
  [file_name] varchar(200),
  [file_path] varchar(2000),
  [file_size] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg_file] (
  [id] int NOT NULL,
  [org_id] int,
  [file_code] varchar(50),
  [file_name] varchar(200),
  [file_path] varchar(2000),
  [file_size] int,
  [file_type] varchar(50),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg_image] (
  [id] int NOT NULL,
  [org_id] int,
  [width] int,
  [height] int,
  [thumbnail] int,
  [thumbnail_size] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg_video] (
  [id] int NOT NULL,
  [org_id] int,
  [seconds] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_msg_voice] (
  [id] int NOT NULL,
  [org_id] int,
  [seconds] int,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_role_mute] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [role_id] int,
  [user_id] int,
  [mute_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_setting] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int NOT NULL,
  [mobile_json] varchar(500),
  [mobile_param] varchar(500),
  [pc_json] varchar(500),
  [pc_param] varchar(500),
  [pad_json] varchar(500),
  [pad_param] varchar(500),
  [look_json] varchar(500),
  [look_param] varchar(500),
  [show_json] varchar(500),
  [show_param] varchar(500),
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_user_view] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [user_id] int,
  [view_type] smallint,
  [range_mark] int,
  [range_auth] varchar(4000),
  [status] smallint,
  [creater_id] int,
  [createtime] datetime,
  [deleter_id] int,
  [delete_time] datetime,
  PRIMARY KEY ([id])
)
GO

CREATE TABLE [im_user_view_power] (
  [id] int IDENTITY(1,1) NOT NULL,
  [org_id] int,
  [view_id] int,
  [range_type] varchar(20),
  [relation_id] int,
  [relation_name] varchar(50),
  [relation_remarks] varchar(200),
  PRIMARY KEY ([id])
)
GO

CREATE VIEW vsys_org_app 
AS
    SELECT 
        a.id AS app_id,
        a.name AS app_name,
        a.code AS app_code,
        a.description AS description,
        a.developer_id AS developer_id,
        c.code AS developer_code,
        c.name AS developer_name,
        a.version AS version,
        a.deploy AS deploy,
        a.terminal AS terminal,
        a.url_phone AS url_phone,
        a.url_pad AS url_pad,
        a.url_pc AS url_pc,
        a.url_web AS url_web,
        a.url_phone_detail AS url_phone_detail,
        a.url_pad_detail AS url_pad_detail,
        a.url_pc_detail AS url_pc_detail,
        a.url_web_detail AS url_web_detail,
        a.icon_path AS icon_path,
        a.icon_code AS icon_code,
        a.titlebar_color AS titlebar_color,
        a.get_badge_service AS get_badge_service,
        a.msg_group AS msg_group,
        a.createtime AS createtime,
        a.lastupdate AS lastupdate,
        a.pc_open_type AS pc_open_type,
        a.pc_show_on_sysbar AS pc_show_on_sysbar,
        b.org_id AS org_id,
        b.status AS status,
        b.category_id AS category_id,
        b.installer_id AS installer_id,
        b.install_time AS install_time,
        b.order_no AS order_no
    FROM
        sys_app a
        JOIN sys_org_app b
	ON 
        a.id = b.app_id
        JOIN sys_org c
    ON
        a.developer_id = c.id
GO

CREATE VIEW vsys_app_auth 
AS
    SELECT 
        a.id AS id,
        a.owner_type AS owner_type,
        a.owner_id AS owner_id,
        a.opration_id AS opration_id,
        c.name AS opration_name,
        c.service_path AS service_path,
        (CASE
            WHEN a.opration_id is null THEN a.terminal
            ELSE c.terminal
        END) AS auth_terminal,
        (CASE a.owner_type
            WHEN
                'role'
            THEN
                (SELECT 
                        sys_role.name
                    FROM
                        sys_role
                    WHERE
                        sys_role.id = a.owner_id
                            AND sys_role.org_id = a.org_id)
            WHEN
                'dep'
            THEN
                (SELECT 
                        sys_dep.name
                    FROM
                        sys_dep
                    WHERE
                        sys_dep.id = a.owner_id
                            AND sys_dep.org_id = a.org_id)
            ELSE (SELECT 
                    sys_user.name
                FROM
                    sys_user
                WHERE
                    sys_user.id = a.owner_id
                        AND sys_user.org_id = a.org_id)
        END) AS owner_name,
        b.app_id AS app_id,
        b.app_name AS app_name,
        b.app_code AS app_code,
        b.description AS description,
        b.developer_id AS developer_id,
        b.developer_code AS developer_code,
        b.developer_name AS developer_name,
        b.version AS version,
        b.deploy AS deploy,
        b.terminal AS terminal,
        b.url_phone AS url_phone,
        b.url_pad AS url_pad,
        b.url_pc AS url_pc,
        b.url_web AS url_web,
        b.icon_path AS icon_path,
        b.icon_code AS icon_code,
        b.url_phone_detail AS url_phone_detail,
        b.url_pad_detail AS url_pad_detail,
        b.url_pc_detail AS url_pc_detail,
        b.url_web_detail AS url_web_detail,
        b.titlebar_color AS titlebar_color,
        b.msg_group AS msg_group,
        b.createtime AS createtime,
        b.lastupdate AS lastupdate,
        b.org_id AS org_id,
        b.status AS status,
        b.category_id AS category_id,
        b.installer_id AS installer_id,
        b.install_time AS install_time,
        b.order_no AS order_no,
        b.get_badge_service AS get_badge_service,
        b.pc_open_type AS pc_open_type,
        b.pc_show_on_sysbar AS pc_show_on_sysbar
    FROM
        sys_app_auth a
        JOIN vsys_org_app b
	ON
        a.app_id = b.app_id
            AND a.org_id = b.org_id
        LEFT JOIN sys_app_opration c 
	ON 
        c.id = a.opration_id 
GO

CREATE VIEW vsys_log_download AS
SELECT a.id, a.file_id, a.file_code, a.file_name, a.file_size, a.file_path, a.app_code, 
a.app_data_id, a.thumbnail, a.session_id, b.req_time, b.req_ms, b.ip, b.res_time, b.res_ms, b.use_time
FROM  dbo.sys_log_download AS a LEFT JOIN dbo.sys_log_request AS b ON a.req_id = b.id
GO

CREATE VIEW vsys_log_service 
AS
    SELECT 
        a.id AS id,
        a.session_id AS session_id,
        a.path AS path,
        a.req_data AS req_data,
        a.res_data AS res_data,
        a.res_code AS res_code,
        a.err_msg AS err_msg,
        b.req_time AS req_time,
        b.req_ms AS req_ms,
        b.ip AS ip,
        b.res_time AS res_time,
        b.res_ms AS res_ms,
        b.use_time AS use_time
    FROM
        sys_log_service a
        JOIN sys_log_request b
    ON
        a.id = b.id
GO

CREATE VIEW vsys_log_static 
AS
    SELECT 
        a.id AS id,
        a.content_type AS content_type,
        a.content_size AS content_size,
        a.range_start AS range_start,
        a.range_end AS range_end,
        a.compress_type AS compress_type,
        a.last_modified AS last_modified,
        b.req_time AS req_time,
        b.req_ms AS req_ms,
        b.ip AS ip,
        b.path AS path,
        b.response_code AS response_code,
        b.res_time AS res_time,
        b.res_ms AS res_ms,
        b.use_time AS use_time
    FROM
        sys_log_static a
        JOIN sys_log_request b
    ON
        a.id = b.id
GO

CREATE VIEW vsys_log_upload 
AS
    SELECT 
        a.id AS id,
        a.file_code AS file_code,
        a.file_name AS file_name,
        a.file_size AS file_size,
        a.app_code AS app_code,
        a.app_data_id AS app_data_id,
        a.session_id AS session_id,
        b.req_time AS req_time,
        b.req_ms AS req_ms,
        b.ip AS ip,
        b.res_time AS res_time,
        b.res_ms AS res_ms,
        b.use_time AS use_time
    FROM
        sys_log_upload a
        JOIN sys_log_request b
    ON
        a.id = b.id
GO

CREATE VIEW vsys_role_user 
AS
    SELECT 
        a.org_id AS org_id,
        a.role_id AS role_id,
        a.user_id AS user_id,
        a.creater_id AS creater_id,
        a.createtime AS createtime,
        a.is_admin AS is_admin,
        b.name AS role_name,
        c.name AS user_name,
        c.code AS user_code,
        c.sex AS user_sex,
        c.status AS user_status
    FROM
        sys_role_user a
        JOIN sys_role b
	ON
        a.org_id = b.org_id
            AND a.role_id = b.id
        JOIN sys_user c
    ON
        a.org_id = c.org_id
            AND a.user_id = c.id
GO

CREATE VIEW vsys_user 
AS
    SELECT 
        a.id AS id,
        a.code AS code,
        a.name AS name,
        a.loginname AS loginname,
        a.password AS password,
        a.org_id AS org_id,
        a.status AS status,
        a.mobile AS mobile,
        a.email AS email,
        a.motto AS motto,
        a.creater_id AS creater_id,
        a.createtime AS createtime,
        a.lastLoginTime AS lastLoginTime,
        a.lastLoginIp AS lastLoginIp,
        a.sex AS sex,
        a.post AS post,
        a.create_group AS create_group,
        a.look_all AS look_all,
        a.look_self_bureau AS look_self_bureau,
        a.look_self_dep AS look_self_dep,
        a.look_leader AS look_leader,
        a.look_under AS look_under,
        a.province AS province,
        a.city AS city,
        a.district AS district,
        a.address AS address,
        a.nickname AS nickname,
        a.tel_short AS tel_short,
        a.tel_work AS tel_work,
        a.tel_home AS tel_home,
        a.tel_other AS tel_other,
        a.only_app_center AS only_app_center,
        a.disable_address_book AS disable_address_book,
        a.disable_work_circle AS disable_work_circle,
        a.device_id AS device_id,
        a.not_bind_device AS not_bind_device,
        a.head_id AS head_id,
        a.disable_taskmsg AS disable_taskmsg,
        a.disable_app_center AS disable_app_center,
        a.client_version AS client_version,
        a.disable_chpwd AS disable_chpwd,
        a.disk_limit AS disk_limit,
        a.disk_limit_unit AS disk_limit_unit,
        a.file_size_limit AS file_size_limit,
        a.bind_ca AS bind_ca,
        a.bind_ca_id AS bind_ca_id,
        a.theme_id AS theme_id,
        a.othercode AS othercode,
        (SELECT 
                top 1 c.dep_id
            FROM
                sys_dep_user c
            WHERE
                a.org_id = c.org_id
                    AND c.user_id = a.id
            ) AS dep_id,
        (SELECT 
                top 1 e.name
            FROM
                sys_dep_user d
                JOIN sys_dep e
            on
                d.org_id = e.org_id
                    AND d.dep_id = e.id
            WHERE
                d.org_id = a.org_id
                    AND d.user_id = a.id
            ) AS dep_name,
        (SELECT 
                top 1 e.code
            FROM
                sys_dep_user d
                JOIN sys_dep e
            on
                d.org_id = e.org_id
                    AND d.dep_id = e.id
            WHERE
                d.org_id = a.org_id
                    AND d.user_id = a.id
            ) AS dep_code
    FROM
        sys_user a
GO

CREATE VIEW vsys_user_sign 
AS 
  SELECT
    u.org_id AS org_id,
    u.id AS user_id,
    u.name AS user_name,
    u.dep_id AS dep_id,
    u.dep_name AS dep_name,
    null AS post_id,
    null AS post_name,
    u.status AS status,
    us.sign_type AS sign_type,
    ISNULL( us.sign_password, u.password ) AS sign_password,
    us.sign_code AS sign_code,
    us.id AS sign_id 
  FROM
    vsys_user as u
    JOIN sys_user_sign as us ON 
    (
    ( u.org_id = us.org_id ) 
    AND ( u.id = us.user_id ) 
    AND ( us.sign_status = 0 ) 
    ) 
GO

CREATE VIEW vim_msg_send 
AS 
  select 
    a.id as id,
    a.org_id as org_id,
    a.type as type,
    a.sender_id as sender_id,
    a.sender_ctype as sender_ctype,
    a.send_time as send_time,
    a.title as title,
    a.summary as summary,
    a.icon as icon,
    a.sound as sound,
    a.open_type as open_type,
    a.open_content as open_content,
    a.group_display as group_display,
    a.receiver_ctype as receiver_ctype,
    a.to_self as to_self,
    a.to_all as to_all,
    a.retain_days as retain_days,
    b.content_type as content_type,
    b.group_type as group_type,
    b.group_id as group_id,
    b.group_name as group_name,
    b.receiver_id as receiver_id,
    b.receiver_name as receiver_name,
    b.at_user_ids as at_user_ids,
    b.content as content,
    b.revoke_time as revoke_time,
    c.file_code as file_code,
    c.file_name as file_name,
    c.file_size as file_size,
    c.file_type as file_type,
    d.width as width,
    d.height as height,
    d.thumbnail as thumbnail,
    d.thumbnail_size as thumbnail_size,
    e.seconds as voice_seconds,
    f.seconds as video_seconds,
    g.dir_name as dir_name,
    g.dir_size as dir_size 
  from ((((((sys_msg as a
  join im_msg as b on
      ((b.id = a.id)))
  left join im_msg_file as c on
      ((c.id = a.id)))
  left join im_msg_image as d on
      ((d.id = a.id)))
  left join im_msg_voice as e on
      ((e.id = a.id)))
  left join im_msg_video as f on
      ((f.id = a.id)))
  left join im_msg_dir as g on
      ((g.id = a.id)))
GO

CREATE PROCEDURE [dbo].[psys_encodingrule_get]
	@p_org_id int,
	@p_pk_type VARCHAR(200),
	@p_pk_code VARCHAR(200),
	@p_date datetime,
	@p_user_id int,
	@p_fk_type VARCHAR(200),
	@p_fk_code VARCHAR(200),
	@p_update_mode char(2)
AS
BEGIN
  Declare @f_encodingrule_id int
  Declare @f_clear_mode char(2)
  Declare @f_update_mode char(2)
  Declare @f_sn_type char(2)
  Declare @f_encoding_type varchar(20)
  Declare @f_encoding_count int
  Declare @f_encoding_content varchar(20)
  Declare @f_order_number int
  Declare @f_user_name VARCHAR(200)
  Declare @f_user_code VARCHAR(50)
  Declare @f_com_id int
  Declare @f_com_name VARCHAR(200)
  Declare @f_com_code VARCHAR(50)
  Declare @f_dep_id int
  Declare @f_dep_name VARCHAR(200)
  Declare @f_dep_code VARCHAR(50)
  Declare @f_fk_type VARCHAR(200)
  Declare @f_fk_code VARCHAR(200)
  Declare @f_encoding_sn_id int
  Declare @f_encoding_year int
  Declare @f_encoding_month int
  Declare @f_encoding_date int
  Declare @f_sn int
  Declare @p_encoding VARCHAR(200)

  select @f_user_code=isnull(code,''),@f_user_name=isnull(name,''),@f_com_id=0,@f_com_code='',@f_com_name='',@f_dep_id=dep_id,@f_dep_code='',@f_dep_name=isnull(dep_name,'') from vsys_user where org_id=@p_org_id and id=@p_user_id
  select @f_encodingrule_id=id,@f_clear_mode=clear_mode,@f_update_mode=update_mode,@f_sn_type=sn_type from sys_encodingrule where org_id=@p_org_id and pk_type=@p_pk_type and pk_code=@p_pk_code;

  set @p_encoding='';
  if @f_encodingrule_id is not null 
  begin
    Declare c_item cursor for (select encoding_type,encoding_count,encoding_content,order_number from sys_encodingrule_item where org_id=@p_org_id and encodingrule_id=@f_encodingrule_id) order by order_number
	open c_item
	print @@FETCH_STATUS
    fetch next from c_item into @f_encoding_type,@f_encoding_count,@f_encoding_content,@f_order_number
    while @@FETCH_STATUS=0
    begin
	  if @f_encoding_type='YYYYMMDD'  
		set @p_encoding=@p_encoding+CONVERT(varchar(10),@p_date,112)
      else if @f_encoding_type='YYYY'  
		set @p_encoding=@p_encoding+cast(YEAR(@p_date) as varchar(4))
	  else if @f_encoding_type='YY'  
	    set @p_encoding=@p_encoding+right(cast(YEAR(@p_date) as varchar(4)),2)
	  else if @f_encoding_type='MM'  
		set @p_encoding=@p_encoding+right(replicate('0',2)+ltrim(cast(MONTH(@p_date) as varchar(4))),2)
	  else if @f_encoding_type='DD'  
		set @p_encoding=@p_encoding+right(replicate('0',2)+ltrim(cast(DAY(@p_date) as varchar(4))),2)
      else if @f_encoding_type='COMID' 
	    set @p_encoding=@p_encoding+@f_com_id
	  else if @f_encoding_type='COMCODE'
	    set @p_encoding=@p_encoding+@f_com_code
      else if @f_encoding_type='COMNAME'
	    set @p_encoding=@p_encoding+@f_com_name
      else if @f_encoding_type='USERID'
	    set @p_encoding=@p_encoding+@p_user_id
	  else if @f_encoding_type='USERCODE'
	    set @p_encoding=@p_encoding+@f_user_code
      else if @f_encoding_type='USERNAME' 
	    set @p_encoding=@p_encoding+@f_user_name
      else if @f_encoding_type='DEPID'
	    set @p_encoding=@p_encoding+@f_dep_id
      else if @f_encoding_type='DEPCODE'
	    set @p_encoding=@p_encoding+@f_dep_code
      else if @f_encoding_type='DEPNAME'
	    set @p_encoding=@p_encoding+@f_dep_name
      else if @f_encoding_type='OTHER'
	    set @p_encoding=@p_encoding+@p_fk_code
	  else if @f_encoding_type='SN'
	    begin
		  if @f_sn_type='C'
		    begin
			  set @f_fk_type='C';
              set @f_fk_code=@f_com_id;
		    end
		  else if @f_sn_type='D'
		    begin
			  set @f_fk_type='D';
              set @f_fk_code=@f_dep_id;
		    end
		  else if @f_sn_type='U'
		    begin
			  set @f_fk_type='U';
              set @f_fk_code=@p_user_id;
		    end
		  else if @f_sn_type='F'
		    begin
			  set @f_fk_type=@p_fk_type
              set @f_fk_code=@p_fk_code;
		    end
		  else
		    begin
			  set @f_fk_type=''
			  set @f_fk_code=''
			end
		  
		  select @f_encoding_sn_id=id,@f_encoding_year=encoding_year,@f_encoding_month=encoding_month,@f_encoding_date=encoding_date,@f_sn=sn from sys_encodingrule_sn where org_id=@p_org_id and encodingrule_id=@f_encodingrule_id and fk_type=@f_fk_type and fk_code=@f_fk_code
          if @f_encoding_sn_id is null 
		    begin
			  set @f_sn=1;
              if @f_update_mode=@p_update_mode
                insert into sys_encodingrule_sn(org_id,encodingrule_id,fk_type,fk_code,encoding_year,encoding_month,encoding_date,sn) values(@p_org_id,@f_encodingrule_id,@f_fk_type,@f_fk_code,YEAR(@p_date),MONTH(@p_date),DAY(@p_date),1);
              else
                insert into sys_encodingrule_sn(org_id,encodingrule_id,fk_type,fk_code,encoding_year,encoding_month,encoding_date,sn) values(@p_org_id,@f_encodingrule_id,@f_fk_type,@f_fk_code,YEAR(@p_date),MONTH(@p_date),DAY(@p_date),0);
			end
		  else
		    begin
		      if @f_clear_mode='Y'
			    begin
			      if @f_encoding_year<>YEAR(@p_date) set @f_sn=0
			    end
			  else if @f_clear_mode='M'
			    begin
			      if @f_encoding_year<>YEAR(@p_date) or @f_encoding_month<>MONTH(@p_date) set @f_sn=0
		        end
		  	  else if @f_clear_mode='D'
			    begin
			      if @f_encoding_year<>YEAR(@p_date) or @f_encoding_month<>MONTH(@p_date) or @f_encoding_date<>DAY(@p_date) set @f_sn=0
			    end
			  else
		        begin
			      set @f_clear_mode='N'
			    end
			  set @f_encoding_year=YEAR(@p_date);
              set @f_encoding_month=MONTH(@p_date);
              set @f_encoding_date=DAY(@p_date);
              set @f_sn=@f_sn+1;
			  if @f_update_mode=@p_update_mode
                update sys_encodingrule_sn set sn=@f_sn,encoding_year=@f_encoding_year,encoding_month=@f_encoding_month,encoding_date=@f_encoding_date where org_id=@p_org_id and encodingrule_id=@f_encodingrule_id and fk_type=@f_fk_type and fk_code=@f_fk_code;
            end
		  set @p_encoding=@p_encoding+right(replicate('0',@f_encoding_count)+ltrim(@f_sn),@f_encoding_count)
		end
	  else
        set @p_encoding=@p_encoding+@f_encoding_content

	  fetch next from c_item into @f_encoding_type,@f_encoding_count,@f_encoding_content,@f_order_number
	end
    close c_item
    deallocate c_item
  end
  select @p_encoding as code
END
GO

CREATE TABLE pm_customer (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(10) DEFAULT NULL,
  name varchar(200) NOT NULL,
  scale varchar(4) DEFAULT NULL,
  trade varchar(4) DEFAULT NULL,
  grade varchar(4) DEFAULT NULL,
  source varchar(4) DEFAULT NULL,
  telephone varchar(45) DEFAULT NULL,
  contacts varchar(20) DEFAULT NULL,
  site varchar(200) DEFAULT NULL,
  province varchar(10) DEFAULT NULL,
  city varchar(10) DEFAULT NULL,
  district varchar(16) DEFAULT NULL,
  address varchar(500) DEFAULT NULL,
  tax_number varchar(20) DEFAULT NULL,
  bank_name varchar(200) DEFAULT NULL,
  bank_account varchar(20) DEFAULT NULL,
  status varchar(4) DEFAULT NULL,
  remarks varchar(2000) DEFAULT NULL,
  salesman_id int DEFAULT NULL,
  creater_id int DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_entry_warehouse_bill (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(20) NOT NULL,
  business_bill_id int DEFAULT NULL,
  business_bill_type varchar(10) DEFAULT NULL,
  business_bill_code varchar(45) DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  create_time datetime NOT NULL,
  operator_id int NOT NULL,
  comment varchar(200) DEFAULT NULL,
  storehouse_id int DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_entry_warehouse_detail (
  id int IDENTITY(1,1) NOT NULL,
  bill_id int DEFAULT NULL,
  matter_id int DEFAULT NULL,
  quantity decimal(16,4) DEFAULT NULL,
  unit varchar(10) DEFAULT NULL,
  price decimal(16,2) DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_financial_accounts (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(20) NOT NULL,
  name varchar(45) NOT NULL,
  type varchar(10) NOT NULL,
  bank varchar(200) DEFAULT NULL,
  account varchar(45) DEFAULT NULL,
  remaining_sum decimal(16,2) DEFAULT NULL,
  status smallint DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_financial_expense (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(20) DEFAULT NULL,
  operator_id int DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  status int DEFAULT NULL,
  auditor_id int DEFAULT NULL,
  audit_time datetime DEFAULT NULL,
  audit_comment varchar(200) DEFAULT NULL,
  account_id int DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_financial_expense_details (
  id int IDENTITY(1,1) NOT NULL,
  bill_id int DEFAULT NULL,
  subject_id int DEFAULT NULL,
  expend_date datetime DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  abstract varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_financial_income_pay_details (
  id int IDENTITY(1,1) NOT NULL,
  bill_id int DEFAULT NULL,
  bill_no varchar(20) DEFAULT NULL,
  type varchar(4) DEFAULT NULL,
  subject_code varchar(10) DEFAULT NULL,
  billing_date datetime DEFAULT NULL,
  operator_id int DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  account_id int DEFAULT NULL,
  summary varchar(500) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_financial_subject (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(10) DEFAULT NULL,
  name varchar(20) DEFAULT NULL,
  type varchar(10) DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  status smallint DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_matter (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(10) NOT NULL,
  name varchar(100) NOT NULL,
  model varchar(200) DEFAULT NULL,
  unit varchar(10) NOT NULL,
  price decimal(16,2) DEFAULT NULL,
  comment varchar(500) DEFAULT NULL,
  type_id int DEFAULT NULL,
  status smallint DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_matter_type (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(45) DEFAULT NULL,
  name varchar(20) NOT NULL,
  parent_id int,
  id_full_path varchar(100) DEFAULT NULL,
  status int DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_out_warehouse_bill (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(20) DEFAULT NULL,
  business_bill_id int DEFAULT NULL,
  business_bill_type varchar(10) DEFAULT NULL,
  business_bill_code varchar(45) DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  operator_id int DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  storehouse_id int DEFAULT NULL,
  sale_order_id int DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_out_warehouse_detail (
  id int IDENTITY(1,1) NOT NULL,
  bill_id int DEFAULT NULL,
  matter_id int DEFAULT NULL,
  quantity decimal(16,4) DEFAULT NULL,
  unit varchar(10) DEFAULT NULL,
  price decimal(16,2) DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_purchase_order (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(20) NOT NULL,
  supplier_id int NOT NULL,
  contacts varchar(10) DEFAULT NULL,
  contact_number varchar(20) DEFAULT NULL,
  total_amount decimal(16,2) NOT NULL,
  order_amount decimal(16,2) NOT NULL,
  discount_amount decimal(16,2) DEFAULT NULL,
  actual_amount decimal(16,2) NOT NULL,
  pay_amount decimal(16,2) DEFAULT NULL,
  pay_account int DEFAULT NULL,
  create_time datetime NOT NULL,
  operator_id int NOT NULL,
  comment varchar(200) DEFAULT NULL,
  auditor_id int DEFAULT NULL,
  audit_time datetime DEFAULT NULL,
  audit_comment varchar(200) DEFAULT NULL,
  status smallint NOT NULL,
  apply_date date DEFAULT NULL,
  storehouse_id int DEFAULT NULL,
  PRIMARY KEY (id)
) 
GO

CREATE TABLE pm_purchase_order_detail (
  id int IDENTITY(1,1) NOT NULL,
  bill_id int NOT NULL,
  matter_id int DEFAULT NULL,
  quantity decimal(16,4) DEFAULT NULL,
  unit varchar(20) DEFAULT NULL,
  price decimal(16,2) DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_purchase_payment (
  id int IDENTITY(1,1) NOT NULL,
  bill_code varchar(20) DEFAULT NULL,
  pay_date datetime DEFAULT NULL,
  operator_id int DEFAULT NULL,
  supplier_id int DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  discount_amount decimal(16,2) DEFAULT NULL,
  actual_amount decimal(16,2) DEFAULT NULL,
  pay_account int DEFAULT NULL,
  comment varchar(500) DEFAULT NULL,
  audit_status smallint DEFAULT NULL,
  auditor_id int DEFAULT NULL,
  audit_time datetime DEFAULT NULL,
  audit_result varchar(10) DEFAULT NULL,
  audit_comment varchar(45) DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_purchase_payment_details (
  id int IDENTITY(1,1) NOT NULL,
  purchase_bill_id int DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  payment_bill_id int DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_sale_order (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(20) DEFAULT NULL,
  customer_id int DEFAULT NULL,
  contacts varchar(10) DEFAULT NULL,
  contact_number varchar(45) DEFAULT NULL,
  delivery_method varchar(10) DEFAULT NULL,
  delivery_date date DEFAULT NULL,
  shipping_address varchar(200) DEFAULT NULL,
  invoice_type varchar(10) DEFAULT NULL,
  invoice_status smallint DEFAULT NULL,
  invoice_date date DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  tax_rate decimal(16,2) DEFAULT NULL,
  tax_amount decimal(16,2) DEFAULT NULL,
  order_amount decimal(16,2) DEFAULT NULL,
  discount_amount decimal(16,2) DEFAULT NULL,
  actual_amount decimal(16,2) DEFAULT NULL,
  received_amount decimal(16,2) DEFAULT NULL,
  order_time datetime DEFAULT NULL,
  operator_id int DEFAULT NULL,
  order_status smallint DEFAULT NULL,
  comment varchar(45) DEFAULT NULL,
  designer_id int DEFAULT NULL,
  design_finish_time datetime DEFAULT NULL,
  maker_id int DEFAULT NULL,
  make_finish_time datetime DEFAULT NULL,
  installer_id int DEFAULT NULL,
  install_finish_time datetime DEFAULT NULL,
  auditor_id int DEFAULT NULL,
  audit_time datetime DEFAULT NULL,
  audit_comment varchar(500) DEFAULT NULL,
  collection_account int DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_sale_order_detail (
  id int IDENTITY(1,1) NOT NULL,
  order_id int NOT NULL,
  service_id int NOT NULL,
  pricing_method_name varchar(20) DEFAULT NULL,
  quantity decimal(16,2) NOT NULL,
  unit varchar(20) NOT NULL,
  price decimal(16,2) NOT NULL,
  amount decimal(16,2) NOT NULL,
  comment varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_sale_payment (
  id int IDENTITY(1,1) NOT NULL,
  bill_code varchar(20) DEFAULT NULL,
  receipt_date datetime DEFAULT NULL,
  operator_id int DEFAULT NULL,
  customer_id int DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  discount_amount decimal(16,2) DEFAULT NULL,
  actual_amount decimal(16,2) DEFAULT NULL,
  collection_account int DEFAULT NULL,
  comment varchar(500) DEFAULT NULL,
  audit_status smallint DEFAULT NULL,
  auditor_id int DEFAULT NULL,
  audit_time datetime DEFAULT NULL,
  audit_result varchar(10) DEFAULT NULL,
  audit_comment varchar(45) DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_sale_payment_details (
  id int IDENTITY(1,1) NOT NULL,
  order_id int DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  payment_id int DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_sale_refund (
  id int IDENTITY(1,1) NOT NULL,
  bill_code varchar(20) DEFAULT NULL,
  refund_date datetime DEFAULT NULL,
  operator_id int DEFAULT NULL,
  customer_id int DEFAULT NULL,
  total_amount decimal(16,2) DEFAULT NULL,
  actual_amount decimal(16,2) DEFAULT NULL,
  refund_account int DEFAULT NULL,
  comment varchar(500) DEFAULT NULL,
  audit_status smallint DEFAULT NULL,
  auditor_id int DEFAULT NULL,
  audit_time datetime DEFAULT NULL,
  audit_result varchar(10) DEFAULT NULL,
  audit_comment varchar(45) DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_sale_refund_details (
  id int IDENTITY(1,1) NOT NULL,
  order_id int DEFAULT NULL,
  amount decimal(16,2) DEFAULT NULL,
  refund_id int DEFAULT NULL,
  PRIMARY KEY (id)
) 
GO

CREATE TABLE pm_service_item (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(10) NOT NULL,
  name varchar(100) NOT NULL,
  model varchar(200) DEFAULT NULL,
  pricing_method varchar(45) DEFAULT NULL,
  unit varchar(10) NOT NULL,
  price decimal(16,2) DEFAULT NULL,
  comment varchar(500) DEFAULT NULL,
  type_id int DEFAULT NULL,
  status smallint DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_service_type (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(45) DEFAULT NULL,
  name varchar(20) NOT NULL,
  parent_id int DEFAULT '0',
  id_full_path varchar(100) DEFAULT NULL,
  status int DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_stock (
  id int IDENTITY(1,1) NOT NULL,
  matter_id int DEFAULT NULL,
  storehouse_id int DEFAULT NULL,
  quantity decimal(16,4) DEFAULT NULL,
  price decimal(16,2) DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_storehouse (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(10) DEFAULT NULL,
  name varchar(45) NOT NULL,
  address varchar(200) DEFAULT NULL,
  comment varchar(200) DEFAULT NULL,
  status smallint DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE TABLE pm_supplier (
  id int IDENTITY(1,1) NOT NULL,
  code varchar(10) DEFAULT NULL,
  name varchar(200) DEFAULT NULL,
  contacts varchar(10) DEFAULT NULL,
  telephone varchar(20) DEFAULT NULL,
  address varchar(200) DEFAULT NULL,
  tax_number varchar(20) DEFAULT NULL,
  bank_name varchar(100) DEFAULT NULL,
  bank_account varchar(45) DEFAULT NULL,
  remarks varchar(200) DEFAULT NULL,
  status smallint DEFAULT NULL,
  creater_id int DEFAULT NULL,
  create_time datetime DEFAULT NULL,
  PRIMARY KEY (id)
)
GO

CREATE VIEW vpm_customer AS select a.id AS id,a.code AS code,a.name AS name,
a.scale AS scale,a.trade AS trade,a.grade AS grade,a.source AS source,
a.telephone AS telephone,a.contacts AS contacts,a.site AS site,a.province AS province,
a.city AS city,a.district AS district,a.address AS address,a.tax_number AS tax_number,
a.bank_name AS bank_name,a.bank_account AS bank_account,a.status AS status,
a.remarks AS remarks,a.salesman_id AS salesman_id,a.creater_id AS creater_id,
a.create_time AS create_time,b.name AS salesman_name,c.name AS creater_name,
(select sys_data_dic.name from sys_data_dic where ((sys_data_dic.type_code = 'customer-scale') 
and (sys_data_dic.code = a.scale))) AS scale_name,(select sys_data_dic.name from sys_data_dic 
where ((sys_data_dic.type_code = 'customer-trade') and (sys_data_dic.code = a.trade))) AS trade_name,
(select sys_data_dic.name from sys_data_dic where ((sys_data_dic.type_code = 'customer-grade') 
and (sys_data_dic.code = a.grade))) AS grade_name,(select sys_data_dic.name from sys_data_dic 
where ((sys_data_dic.type_code = 'customer-source') and (sys_data_dic.code = a.source))) AS source_name,
(select sys_data_dic.name from sys_data_dic where ((sys_data_dic.type_code = 'customer-status') 
and (sys_data_dic.code = a.status))) AS status_name,(select sys_data_region.name from sys_data_region 
where (sys_data_region.code = a.province)) AS province_name,(select sys_data_region.name 
from sys_data_region where (sys_data_region.code = a.city)) AS city_name,
(select sys_data_region.name from sys_data_region where (sys_data_region.code = a.district)) AS district_name 
from pm_customer a,sys_user b,sys_user c 
where ((a.salesman_id = b.id) and (a.creater_id = c.id))
GO

CREATE VIEW vpm_entry_warehouse_bill AS 
select a.id AS id,a.code AS code,a.business_bill_id AS business_bill_id,
a.business_bill_type AS business_bill_type,a.total_amount AS total_amount,
a.create_time AS create_time,a.operator_id AS operator_id,a.comment AS comment,
a.storehouse_id AS storehouse_id,a.business_bill_code AS business_bill_code,
b.name AS operator_name,c.name AS storehouse_name 
from pm_entry_warehouse_bill a,sys_user b,pm_storehouse c 
where ((a.operator_id = b.id) and (a.storehouse_id = c.id))
GO

CREATE VIEW vpm_entry_warehouse_detail AS 
select a.id AS id,a.bill_id AS bill_id,a.matter_id AS matter_id,
a.quantity AS quantity,a.unit AS unit,a.price AS price,a.amount AS amount,
a.comment AS comment,b.code AS matter_code,b.name AS matter_name,
b.model AS matter_model,c.code AS bill_code,c.business_bill_id AS business_bill_id,
c.business_bill_type AS business_bill_type,c.create_time AS create_time,
c.operator_id AS operator_id,c.storehouse_id AS storehouse_id,c.business_bill_code AS business_bill_code,
c.operator_name AS operator_name,c.storehouse_name AS storehouse_name 
from pm_entry_warehouse_detail a,pm_matter b,vpm_entry_warehouse_bill c 
where ((a.matter_id = b.id) and (a.bill_id = c.id))
GO

CREATE VIEW vpm_financial_expense AS select a.id AS id,a.code AS code,a.operator_id AS operator_id,
a.create_time AS create_time,a.total_amount AS total_amount,a.comment AS comment,
a.status AS status,a.auditor_id AS auditor_id,a.audit_time AS audit_time,
a.audit_comment AS audit_comment,a.account_id AS account_id,b.name AS operator_name,
(select sys_user.name from sys_user where (sys_user.id = a.auditor_id)) AS auditor_name,
(select pm_financial_accounts.name from pm_financial_accounts where (pm_financial_accounts.id = a.account_id)) 
AS account_name from pm_financial_expense a,sys_user b where (a.operator_id = b.id)
GO

CREATE VIEW vpm_financial_expense_details AS select a.id AS id,a.bill_id AS bill_id,
a.subject_id AS subject_id,a.expend_date AS expend_date,a.amount AS amount,
a.abstract AS abstract,b.code AS subject_code,b.name AS subject_name 
from pm_financial_expense_details a,pm_financial_subject b where (a.subject_id = b.id)
GO

CREATE VIEW vpm_financial_income_pay_details AS select a.id AS id,a.bill_id AS bill_id,
a.bill_no AS bill_no,a.type AS type,a.subject_code AS subject_code,
a.billing_date AS billing_date,a.operator_id AS operator_id,a.amount AS amount,
a.account_id AS account_id,a.summary AS summary,b.name AS operator_name,
c.name AS account_name,d.name AS subject_name 
from pm_financial_income_pay_details a,sys_user b,pm_financial_accounts c,pm_financial_subject d
where ((a.operator_id = b.id) and (a.account_id = c.id) and (a.subject_code = d.code))
GO

CREATE VIEW vpm_out_warehouse_bill AS 
select a.id AS id,a.code AS code,a.business_bill_id AS business_bill_id,
a.business_bill_type AS business_bill_type,a.business_bill_code AS business_bill_code,
a.total_amount AS total_amount,a.create_time AS create_time,a.operator_id AS operator_id,
a.comment AS comment,a.storehouse_id AS storehouse_id,a.sale_order_id AS sale_order_id,
b.name AS operator_name,c.name AS storehouse_name,(select pm_sale_order.code 
from pm_sale_order where (pm_sale_order.id = a.sale_order_id)) AS sale_order_code 
from pm_out_warehouse_bill a,sys_user b,pm_storehouse c 
where ((a.operator_id = b.id) and (a.storehouse_id = c.id))
GO

CREATE VIEW vpm_out_warehouse_detail AS 
select a.id AS id,a.bill_id AS bill_id,a.matter_id AS matter_id,a.quantity AS quantity,
a.unit AS unit,a.price AS price,a.amount AS amount,a.comment AS comment,
b.name AS matter_name,b.model AS matter_model,c.code AS bill_code,
c.business_bill_id AS business_bill_id,c.business_bill_type AS business_bill_type,
c.create_time AS create_time,c.operator_id AS operator_id,c.storehouse_id AS storehouse_id,
c.business_bill_code AS business_bill_code,c.operator_name AS operator_name,c.storehouse_name AS storehouse_name 
from pm_out_warehouse_detail a,pm_matter b,vpm_out_warehouse_bill c 
where ((a.matter_id = b.id) and (a.bill_id = c.id))
GO

CREATE VIEW vpm_purchase_order AS select a.id AS id,a.code AS code,a.supplier_id AS supplier_id,
a.apply_date AS apply_date,a.contacts AS contacts,a.contact_number AS contact_number,
a.total_amount AS total_amount,a.order_amount AS order_amount,a.discount_amount AS discount_amount,
a.actual_amount AS actual_amount,a.pay_amount AS pay_amount,a.pay_account AS pay_account,
a.create_time AS create_time,a.operator_id AS operator_id,a.comment AS comment,
a.auditor_id AS auditor_id,a.audit_time AS audit_time,a.audit_comment AS audit_comment,
a.status AS status,a.storehouse_id AS storehouse_id,b.name AS supplier_name,
c.name AS operator_name,d.name AS storehouse_name,(select pm_financial_accounts.name 
from pm_financial_accounts where (pm_financial_accounts.id = a.pay_account)) AS account_name,
(select sys_user.name from sys_user where (sys_user.id = a.auditor_id)) AS auditor_name 
from pm_purchase_order a,pm_supplier b,sys_user c,pm_storehouse d 
where ((a.supplier_id = b.id) and (a.operator_id = c.id) and (a.storehouse_id = d.id))
GO

CREATE VIEW vpm_purchase_order_detail AS select a.id AS id,a.code AS code,a.apply_date AS apply_date,
a.supplier_id AS supplier_id,a.contacts AS contacts,a.contact_number AS contact_number,
a.total_amount AS total_amount,a.order_amount AS order_amount,a.discount_amount AS discount_amount,
a.actual_amount AS actual_amount,a.pay_amount AS pay_amount,a.pay_account AS pay_account,
a.create_time AS create_time,a.operator_id AS operator_id,a.comment AS comment,
a.auditor_id AS auditor_id,a.audit_time AS audit_time,a.audit_comment AS audit_comment,
a.status AS status,a.supplier_name AS supplier_name,a.operator_name AS operator_name,
a.account_name AS account_name,a.auditor_name AS auditor_name,b.id AS detail_id,
b.matter_id AS matter_id,b.quantity AS quantity,b.unit AS unit,b.price AS price,
b.amount AS amount,b.comment AS detail_comment,c.code AS matter_code,c.name AS matter_name,
c.model AS matter_model from vpm_purchase_order a,pm_purchase_order_detail b,pm_matter c
where ((a.id = b.bill_id) and (b.matter_id = c.id))
GO

CREATE VIEW vpm_purchase_payment AS select a.id AS id,a.bill_code AS bill_code,
a.pay_date AS pay_date,a.operator_id AS operator_id,a.supplier_id AS supplier_id,
a.total_amount AS total_amount,a.discount_amount AS discount_amount,a.actual_amount AS actual_amount,
a.pay_account AS pay_account,a.comment AS comment,a.audit_status AS audit_status,
a.auditor_id AS auditor_id,a.audit_time AS audit_time,a.audit_result AS audit_result,
a.audit_comment AS audit_comment,a.create_time AS create_time,b.name AS operator_name,
c.name AS supplier_name,d.name AS account_name,(select sys_user.name from sys_user 
where (sys_user.id = a.auditor_id)) AS auditor_name from pm_purchase_payment a,sys_user b,
pm_supplier c,pm_financial_accounts d where ((a.operator_id = b.id) 
and (a.supplier_id = c.id) and (a.pay_account = d.id))
GO

CREATE VIEW vpm_purchase_payment_details AS select a.id AS id,a.purchase_bill_id AS purchase_bill_id,
a.amount AS amount,a.payment_bill_id AS payment_bill_id,a.comment AS comment,b.code AS code,
b.apply_date AS apply_date,b.actual_amount AS actual_amount from pm_purchase_payment_details a, 
vpm_purchase_order b where (a.purchase_bill_id = b.id)
GO

CREATE VIEW vpm_sale_order AS select a.id AS id,a.code AS code,a.customer_id AS customer_id,
a.contacts AS contacts,a.contact_number AS contact_number,a.delivery_method AS delivery_method,
a.delivery_date AS delivery_date,a.shipping_address AS shipping_address,a.invoice_type AS invoice_type,
a.invoice_status AS invoice_status,a.invoice_date AS invoice_date,a.total_amount AS total_amount,
a.tax_rate AS tax_rate,a.tax_amount AS tax_amount,a.order_amount AS order_amount,
a.discount_amount AS discount_amount,a.actual_amount AS actual_amount,a.received_amount AS received_amount,
a.order_time AS order_time,a.operator_id AS operator_id,a.order_status AS order_status,
a.comment AS comment,b.name AS operator_name,c.name AS customer_name,a.designer_id AS designer_id,
a.design_finish_time AS design_finish_time,a.maker_id AS maker_id,a.make_finish_time AS make_finish_time,
a.installer_id AS installer_id,a.install_finish_time AS install_finish_time,a.auditor_id AS auditor_id,
a.audit_time AS audit_time,a.audit_comment AS audit_comment,a.collection_account AS collection_account,
(select sys_user.name from sys_user where (sys_user.id = a.designer_id)) AS designer_name,
(select sys_user.name from sys_user where (sys_user.id = a.maker_id)) AS maker_name,
(select sys_user.name from sys_user where (sys_user.id = a.installer_id)) AS installer_name,
(select sys_user.name from sys_user where (sys_user.id = a.auditor_id)) AS auditor_name,
(select sys_data_dic.name from sys_data_dic where ((sys_data_dic.type_code = 'delivery-method') 
and (sys_data_dic.code = a.delivery_method))) AS delivery_method_name 
from pm_sale_order a,sys_user b,pm_customer c
where ((a.operator_id = b.id) and (c.id = a.customer_id))
GO

CREATE VIEW vpm_sale_order_detail AS 
select a.id AS id,a.order_id AS order_id,a.service_id AS service_id,
a.pricing_method_name AS pricing_method_name,a.quantity AS quantity,a.unit AS unit,
a.price AS price,a.amount AS amount,a.comment AS comment,b.name AS service_name,
b.type_id AS service_type_id,c.name AS service_type_name,d.order_time AS order_time,
d.operator_id AS operator_id,d.order_status AS order_status,d.customer_id AS customer_id 
from pm_sale_order_detail a,pm_service_item b,pm_service_type c,pm_sale_order d 
where ((a.service_id = b.id) and (b.type_id = c.id) and (a.order_id = d.id))
GO

CREATE VIEW vpm_sale_payment AS select p.id AS id,p.bill_code AS bill_code,
p.receipt_date AS receipt_date,p.operator_id AS operator_id,p.customer_id AS customer_id,
p.total_amount AS total_amount,p.discount_amount AS discount_amount,p.actual_amount AS actual_amount,
p.collection_account AS collection_account,p.comment AS comment,p.audit_status AS audit_status,
p.auditor_id AS auditor_id,p.audit_time AS audit_time,p.audit_result AS audit_result,
p.audit_comment AS audit_comment,p.create_time AS create_time,u.name AS operator_name,
c.name AS customer_name,a.name AS account_name,(select sys_user.name from sys_user 
where (sys_user.id = p.auditor_id)) AS auditor_name from pm_sale_payment p,sys_user u, 
pm_customer c,pm_financial_accounts a where ((p.operator_id = u.id) 
and (p.customer_id = c.id) and (p.collection_account = a.id))
GO

CREATE VIEW vpm_sale_payment_details AS select a.id AS id,a.bill_code AS bill_code,
a.receipt_date AS receipt_date,a.operator_id AS operator_id,a.customer_id AS customer_id,
a.total_amount AS total_amount,a.discount_amount AS discount_amount,a.actual_amount AS actual_amount,
a.collection_account AS collection_account,a.comment AS comment,a.audit_status AS audit_status,
a.auditor_id AS auditor_id,a.audit_time AS audit_time,a.audit_result AS audit_result,
a.audit_comment AS audit_comment,a.create_time AS create_time,a.operator_name AS operator_name,
a.customer_name AS customer_name,a.account_name AS account_name,a.auditor_name AS auditor_name,
b.id AS detail_id,b.amount AS amount,b.order_id AS order_id,c.code AS order_code,
c.order_time AS order_time,c.operator_name AS order_operator_name,c.actual_amount AS order_actual_amount,
c.received_amount AS order_received_amount 
from vpm_sale_payment a,pm_sale_payment_details b,vpm_sale_order c 
where ((b.payment_id = a.id) and (b.order_id = c.id))
GO

CREATE VIEW vpm_sale_refund AS select p.id AS id,p.bill_code AS bill_code,p.refund_date AS refund_date,
p.operator_id AS operator_id,p.customer_id AS customer_id,p.total_amount AS total_amount,
p.actual_amount AS actual_amount,p.refund_account AS refund_account,p.comment AS comment,
p.audit_status AS audit_status,p.auditor_id AS auditor_id,p.audit_time AS audit_time,
p.audit_result AS audit_result,p.audit_comment AS audit_comment,p.create_time AS create_time,
u.name AS operator_name,c.name AS customer_name,a.name AS account_name,
(select sys_user.name from sys_user where (sys_user.id = p.auditor_id)) AS auditor_name 
from pm_sale_refund p,sys_user u,pm_customer c,pm_financial_accounts a
where ((p.operator_id = u.id) and (p.customer_id = c.id) and (p.refund_account = a.id))
GO

CREATE VIEW vpm_sale_refund_details AS select a.id AS id,a.bill_code AS bill_code,
a.refund_date AS refund_date,a.operator_id AS operator_id,a.customer_id AS customer_id,
a.total_amount AS total_amount,a.actual_amount AS actual_amount,a.refund_account AS refund_account,
a.comment AS comment,a.audit_status AS audit_status,a.auditor_id AS auditor_id,
a.audit_time AS audit_time,a.audit_result AS audit_result,a.audit_comment AS audit_comment,
a.create_time AS create_time,a.operator_name AS operator_name,a.customer_name AS customer_name,
a.account_name AS account_name,a.auditor_name AS auditor_name,b.id AS detail_id,b.amount AS amount,
b.order_id AS order_id,c.code AS order_code,c.order_time AS order_time,
c.operator_name AS order_operator_name,c.actual_amount AS order_actual_amount,
c.received_amount AS order_received_amount from vpm_sale_refund a,pm_sale_refund_details b, 
vpm_sale_order c where ((b.refund_id = a.id) and (b.order_id = c.id))
GO

CREATE VIEW vpm_stock AS select a.id AS id,a.matter_id AS matter_id,a.storehouse_id AS storehouse_id,
a.quantity AS quantity,a.price AS price,b.code AS matter_code,b.name AS matter_name,
b.model AS matter_model,c.name AS storehouse_name from pm_stock a,pm_matter b, 
pm_storehouse c where ((a.matter_id = b.id) and (a.storehouse_id = c.id))
GO

INSERT INTO pm_financial_accounts VALUES ('01','现金','01',NULL,'',0.00,0),
('02','工商银行','02','工商银行','8888888',0.00,0),('03','建设银行','02','建设银行','6666666',0.00,0),
('04','支付宝','03',NULL,'',0.00,0),('05','微信','03','',NULL,0.00,0)
GO

INSERT INTO pm_financial_subject VALUES ('1001','销售收入','10',NULL,NULL),('1001','销售收入','10',NULL,0),
('1002','其他收入','10',NULL,0),('2001','销售退单','20',NULL,0),('2002','材料采购','20',NULL,0),
('2003','外协加工','20',NULL,0),('2004','其他支出','20',NULL,0),('2005','物流费','20',NULL,0),
('3001','办公用品','30',NULL,0),('3002','水电费','30',NULL,0),('3003','通讯费','30',NULL,0)
GO

INSERT INTO pm_service_type VALUES ('01','喷绘',0,'/1/',0),('02','标识标牌',0,'/2/',0),('03','雕刻切割',0,'/3/',0),
('04','公关策划',0,'/4/',0),('05','活动物料',0,'/5/',0),('06','图文快印',0,'/6/',0),('07','商务印刷',0,'/7/',0),
('08','光电产品',0,'/8/',0),('09','其他',0,'/9/',0),('0101','室外写真',1,'/1/10/',0),('0102','UV户外写真',1,'/1/11/',0),
('0103','UV5米卷材喷印',1,'/1/12/',0),('0106','喷绘',1,'/1/13/',0),('0110','条幅',1,'/1/14/',0),
('0201','立体字',2,'/2/15/',0),('0202','科室门牌',2,'/2/16/',0),('0203','形象标识',2,'/2/17/',0),
('0204','奖牌/铭牌',2,'/2/18/',0),('0301','装饰艺术',3,'/3/19/',0),('0302','来料代工',3,'/3/20/',0),
('0401','道具制作',4,'/4/21/',0),('0402','设计/策划',4,'/4/22/',0),('0501','轻工',5,'/5/23/',0),
('0502','重工',5,'/5/24/',0),('0601','工程图',6,'/6/25/',0),('0602','彩色',6,'/6/26/',0),
('0603','黑白',6,'/6/27/',0),('0701','单页类',7,'/7/28/',0),('0702','折页类',7,'/7/29/',0),
('0704','书刊类',7,'/7/30/',0),('0801','室内',8,'/8/31/',0),('0802','室外',8,'/8/32/',0),
('0803','开关电源',8,'/8/33/',0)
GO

INSERT INTO pm_service_item VALUES ('010101','加厚背胶PP',NULL,'01','01',15.00,NULL,13,0),
('010102','010102',NULL,'01','01',35.00,NULL,13,-1),('010102','背胶+冷裱板',NULL,'01','01',30.00,NULL,13,0),
('010301','UV灯片',NULL,'01','01',10.00,NULL,11,0),('010302','PET灯片',NULL,'01','01',10.00,NULL,1,0),
('010303','宣影布',NULL,'01','01',20.00,NULL,11,0),('020101','LED冲孔字>1m',NULL,'01','01',760.00,NULL,15,0),
('020103','侧光冲孔字>1m',NULL,'01','01',600.00,NULL,15,0),('020105','芙蓉板字>1m',NULL,'01','01',90.00,NULL,15,0),
('040901','040901',NULL,'05','05',10.00,NULL,28,0),('040902','200克铜板纸',NULL,'05','05',10.00,NULL,28,0)
GO

INSERT INTO sys_app(code,name,version,developer_id,category_id,status,deploy,terminal,url_web,icon_path,createtime,lastupdate)
VALUES ('pm_sale_customer','客户管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/customer/index.tfp',
'{"type":"iconfont","class":"iconfont icon-dep","color":"#ffffff","bgColor":"#039be5"}',getdate(),getdate()),
('pm_sale_service','服务项目','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/service/index.tfp',
'{"type":"iconfont","class":"iconfont icon-gongyingshangxinxi","color":"#ffffff","bgColor":"#ff8f00"}',getdate(),getdate()),
('pm_sale_order','销售下单','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/order/index.tfp',
'{"type":"iconfont","class":"iconfont icon-achievement","color":"#ffffff","bgColor":"#ffa000"}',getdate(),getdate()),
('pm_sale_order_audit','订单审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/order/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-get","color":"#ffffff","bgColor":"#ff8f00"}',getdate(),getdate()),
('pm_sale_my_orders','我的订单','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/order/indexMy.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-account","color":"#ffffff","bgColor":"#0277bd"}',getdate(),getdate()),
('pm_sale_refund','销售退单','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/refund/index.tfp',
'{"type":"iconfont","class":"iconfont icon-payment","color":"#ffffff","bgColor":"#e91e63"}',getdate(),getdate()),
('pm_sale_payment','销售收款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/payment/index.tfp',
'{"type":"iconfont","class":"iconfont icon-collection","color":"#ffffff","bgColor":"#f48fb1"}',getdate(),getdate()),
('pm_sale_stat','销售统计','1.0.000',1,1,0,'server','web','/app/ProjectMaster/sale/stat/index.tfp',
'{"type":"iconfont","class":"iconfont icon-chart","color":"#ffffff","bgColor":"#6a1b9a"}',getdate(),getdate()),
('pm_purchase_supplier','供应商管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/supplier/index.tfp',
'{"type":"iconfont","class":"iconfont icon-role","color":"#ffffff","bgColor":"#0288d1"}',getdate(),getdate()),
('pm_purchase_order','采购申请','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/order/index.tfp',
'{"type":"iconfont","class":"iconfont icon-purchase","color":"#ffffff","bgColor":"#9c27b0"}',getdate(),getdate()),
('pm_purchase_order_audit','采购审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/order/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-get","color":"#ffffff","bgColor":"#0277bd"}',getdate(),getdate()),
('pm_purchase_payment','采购付款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/payment/index.tfp',
'{"type":"iconfont","class":"iconfont icon-payment","color":"#ffffff","bgColor":"#ff8f00"}',getdate(),getdate()),
('pm_purchase_payment_audit','付款审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/payment/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-signature","color":"#ffffff","bgColor":"#ffa000"}',getdate(),getdate()),
('pm_purchase_stat','采购统计','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/stat/index.tfp',
'{"type":"iconfont","class":"iconfont icon-chart","color":"#ffffff","bgColor":"#c41411"}',getdate(),getdate()),
('pm_stock_storehouse','仓库管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/storehouse/index.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-inventory","color":"#ffffff","bgColor":"#ff8f00"}',getdate(),getdate()),
('pm_stock_matter','物料管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/matter/index.tfp',
'{"type":"iconfont","class":"iconfont icon-kucun","color":"#ffffff","bgColor":"#ff8f00"}',getdate(),getdate()),
('pm_stock_matter_receive','物料领用','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/receive/index.tfp',
'{"type":"iconfont","class":"iconfont icon-record","color":"#ffffff","bgColor":"#0a7e07"}',getdate(),getdate()),
('pm_stock_now','即时库存','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/stock/index.tfp',
'{"type":"iconfont","class":"iconfont icon-shangpinguanli","color":"#ffffff","bgColor":"#c41411"}',getdate(),getdate()),
('pm_stock_entry_warehouse','入库明细','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/matter/indexEntry.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-enter","color":"#ffffff","bgColor":"#0a7e07"}',getdate(),getdate()),
('pm_stock_out_warehouse','出库明细','1.0.000',1,1,0,'server','web','/app/ProjectMaster/purchase/matter/indexOut.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-leave","color":"#ffffff","bgColor":"#d81b60"}',getdate(),getdate()),
('pm_finance_accounts','账户管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/account/index.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-balance","color":"#ffffff","bgColor":"#0a8f08"}',getdate(),getdate()),
('pm_finance_subject','科目管理','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/subject/index.tfp',
'{"type":"iconfont","class":"iconfont icon-budget","color":"#ffffff","bgColor":"#9c27b0"}',getdate(),getdate()),
('pm_finance_income_pay_details','收支明细','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/income_pay_details/index.tfp',
'{"type":"iconfont","class":"iconfont icon-erp-voucher","color":"#ffffff","bgColor":"#ff8f00"}',getdate(),getdate()),
('pm_finance_receivable','应收账款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/receivable/index.tfp',
'{"type":"iconfont","class":"iconfont icon-assignment","color":"#ffffff","bgColor":"#259b24"}',getdate(),getdate()),
('pm_finance_payable','应付账款','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/payable/index.tfp',
'{"type":"iconfont","class":"iconfont icon-reporting","color":"#ffffff","bgColor":"#0277bd"}',getdate(),getdate()),
('pm_finance_expense','费用报销','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/expense/index.tfp',
'{"type":"iconfont","class":"iconfont icon-invoice","color":"#ffffff","bgColor":"#c41411"}',getdate(),getdate()),
('pm_finance_expense_audit','报销审核','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/expense/indexAudit.tfp',
'{"type":"iconfont","class":"iconfont icon-get","color":"#ffffff","bgColor":"#0277bd"}',getdate(),getdate()),
('pm_finance_stat','财务统计','1.0.000',1,1,0,'server','web','/app/ProjectMaster/finance/stat/index.tfp',
'{"type":"iconfont","class":"iconfont icon-chart","color":"#ffffff","bgColor":"#c41411"}',getdate(),getdate())
GO

insert into sys_app_auth(org_id,app_id,owner_type,owner_id,terminal)
select 1,id,'role',1,'web' from sys_app where url_web like '/app/ProjectMaster/%'
GO

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_sale','销售管理',0,1,'{"type":"iconfont","class":"iconfont icon-app","color":"#ffffff","bgColor":"#ffc107"}', 31)
GO

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_purchase','采购管理',0,1,'{"type":"iconfont","class":"iconfont icon-erp-enter","color":"#ffffff","bgColor":"#0288d1"}', 32)
GO

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_stock','库存管理',0,1,'{"type":"iconfont","class":"iconfont icon-kucun","color":"#ffffff","bgColor":"#9c27b0"}', 33)
GO

insert into sys_org_app_category(code,name,parent_id,org_id,icon_code,order_no)
values('pm_finance','财务管理',0,1,'{"type":"iconfont","class":"iconfont icon-erp-voucher","color":"#ffffff","bgColor":"#c41411"}', 34)
GO

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_sale'),1,getdate(),id from sys_app where code like 'pm_sale_%'
GO

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_purchase'),1,getdate(),id from sys_app where code like 'pm_purchase_%'
GO

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_stock'),1,getdate(),id from sys_app where code like 'pm_stock%'
GO

insert into sys_org_app(org_id,app_id,status,category_id,installer_id,install_time,order_no)
select 1,id,0,(select id from sys_org_app_category where code='pm_finance'),1,getdate(),id from sys_app where code like 'pm_finance_%'
GO

insert into sys_data_dictype([name],[parent_id],[org_id],[status],[code]) 
select '计量单位',[id],1,0,'unit' from sys_data_dictype where [name]='系统数据'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on a.[name]='计量单位' and b.id=a.parent_id
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '平方米', id, '01', 0, 1, code from sys_data_dictype where code='unit'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) values('财务管理',0,1,0,'finance')
GO

update sys_data_dictype set id_full_path=('/'+cast([id] as varchar(20))+'/') where code='finance'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '账户类型',id,1,0,'financial-accounts-type' from sys_data_dictype where code='finance'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '科目类型',id,1,0,'financial-subject-type' from sys_data_dictype where code='finance'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on b.id=a.parent_id and
a.[code] in ('financial-accounts-type', 'financial-subject-type')
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '现金', id, '01', 0, 1, code from sys_data_dictype where code='financial-accounts-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '银行', id, '02', 0, 1, code from sys_data_dictype where code='financial-accounts-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '虚拟账户', id, '03', 0, 1, code from sys_data_dictype where code='financial-accounts-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '经营收入', id, '10', 0, 1, code from sys_data_dictype where code='financial-subject-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '经营支出', id, '20', 0, 1, code from sys_data_dictype where code='financial-subject-type'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '管理费用', id, '30', 0, 1, code from sys_data_dictype where code='financial-subject-type'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) values('销售管理',0,1,0,'sale')
GO

update sys_data_dictype set id_full_path=('/'+cast([id] as varchar(20))+'/') where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '客户来源',id,1,0,'customer-source' from sys_data_dictype where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '客户等级',id,1,0,'customer-grade' from sys_data_dictype where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '客户规模',id,1,0,'customer-scale' from sys_data_dictype where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '所属行业',id,1,0,'customer-trade' from sys_data_dictype where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '客户状态',id,1,0,'customer-status' from sys_data_dictype where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '计价方式',id,1,0,'pricing-method' from sys_data_dictype where code='sale'
GO

insert into sys_data_dictype(name,parent_id,org_id,status,code) 
select '交付方式',id,1,0,'delivery-method' from sys_data_dictype where code='sale'
GO

update a set a.[id_full_path]=(b.id_full_path+cast(a.[id] as varchar(20))+'/') 
from sys_data_dictype a inner join sys_data_dictype b on b.id=a.parent_id and
a.[code] in ('customer-source', 'customer-grade','customer-scale','customer-trade','customer-status','pricing-method','delivery-method')
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '电话咨询', id, '01', 0, 1, code from sys_data_dictype where code='customer-source'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '朋友介绍', id, '02', 0, 1, code from sys_data_dictype where code='customer-source'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '网站咨询', id, '03', 0, 1, code from sys_data_dictype where code='customer-source'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select 'A级', id, '01', 0, 1, code from sys_data_dictype where code='customer-grade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select 'C级', id, '02', 0, 1, code from sys_data_dictype where code='customer-grade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select 'C级', id, '03', 0, 1, code from sys_data_dictype where code='customer-grade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '小微', id, '01', 0, 1, code from sys_data_dictype where code='customer-scale'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '中型', id, '02', 0, 1, code from sys_data_dictype where code='customer-scale'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '大型', id, '03', 0, 1, code from sys_data_dictype where code='customer-scale'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '政府', id, '01', 0, 1, code from sys_data_dictype where code='customer-trade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '教育', id, '02', 0, 1, code from sys_data_dictype where code='customer-trade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '医疗', id, '03', 0, 1, code from sys_data_dictype where code='customer-trade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '金融', id, '04', 0, 1, code from sys_data_dictype where code='customer-trade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '商贸', id, '05', 0, 1, code from sys_data_dictype where code='customer-trade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '生产制造', id, '06', 0, 1, code from sys_data_dictype where code='customer-trade'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '潜在客户', id, '01', 0, 1, code from sys_data_dictype where code='customer-status'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '目标客户', id, '02', 0, 1, code from sys_data_dictype where code='customer-status'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '签约客户', id, '03', 0, 1, code from sys_data_dictype where code='customer-status'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '流失客户', id, '04', 0, 1, code from sys_data_dictype where code='customer-status'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '非目标客户', id, '05', 0, 1, code from sys_data_dictype where code='customer-status'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '面积', id, '01', 0, 1, code from sys_data_dictype where code='pricing-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '次数', id, '02', 0, 1, code from sys_data_dictype where code='pricing-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '时间', id, '03', 0, 1, code from sys_data_dictype where code='pricing-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '人天', id, '04', 0, 1, code from sys_data_dictype where code='pricing-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '数量', id, '05', 0, 1, code from sys_data_dictype where code='pricing-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '客户自提', id, '01', 0, 1, code from sys_data_dictype where code='delivery-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '送货上门', id, '02', 0, 1, code from sys_data_dictype where code='delivery-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '送货安装', id, '03', 0, 1, code from sys_data_dictype where code='delivery-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '物流发货', id, '04', 0, 1, code from sys_data_dictype where code='delivery-method'
GO

insert into sys_data_dic(name,type_id,code,status,org_id,type_code) 
select '快递发货', id, '05', 0, 1, code from sys_data_dictype where code='delivery-method'
GO

INSERT INTO sys_encodingrule(org_id,pk_type,pk_code,clear_mode,update_mode,sn_type) VALUES 
(1,'销售订单编码','sale_order','Y','R','O'),
(1,'销售收款单编码','sale_payment','Y','R','O'),
(1,'销售退款单编码','sale_refund','Y','R','O'),
(1,'采购单编码','purchase_order','Y','R','O'),
(1,'采购付款单编码','purchase_payment','Y','R','O'),
(1,'物料领用单编码','matter_receive','Y','R','O'),
(1,'物料入库单编码','matter_entry','Y','R','O'),
(1,'物料出库单编码','matter_out','Y','R','O'),
(1,'费用报销单编码','financial_expense','Y','R','O')
GO

INSERT INTO sys_encodingrule_item(org_id,encodingrule_id,order_number,encoding_type,encoding_count,encoding_content) VALUES 
(1,1,1,'NO',NULL,'XS'),
(1,1,2,'YYYY',NULL,NULL),
(1,1,3,'SN',4,NULL),
(1,2,1,'NO',NULL,'XSSK'),
(1,2,2,'YYYY',NULL,NULL),
(1,2,3,'SN',4,NULL),
(1,3,1,'NO',NULL,'XSTK'),
(1,3,2,'YYYY',NULL,NULL),
(1,3,3,'SN',4,NULL),
(1,4,1,'NO',NULL,'CG'),
(1,4,2,'YYYY',NULL,NULL),
(1,4,3,'SN',4,NULL),
(1,5,1,'NO',NULL,'CGFK'),
(1,5,2,'YYYY',NULL,NULL),
(1,5,3,'SN',4,NULL),
(1,6,1,'NO',NULL,'WLLY'),
(1,6,2,'YYYY',NULL,NULL),
(1,6,3,'SN',4,NULL),
(1,7,1,'NO',NULL,'WLRK'),
(1,7,2,'YYYY',NULL,NULL),
(1,7,3,'SN',4,NULL),
(1,8,1,'NO',NULL,'WLCK'),
(1,8,2,'YYYY',NULL,NULL),
(1,8,3,'SN',4,NULL),
(1,9,1,'NO',NULL,'FY'),
(1,9,2,'YYYY',NULL,NULL),
(1,9,3,'SN',4,NULL)
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('currenttime') AND TYPE = 'FN') 
 DROP FUNCTION [currenttime] 
GO

CREATE FUNCTION [dbo].[currenttime]() 
RETURNS datetime 
BEGIN
  RETURN GETDATE();
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('datetimetovarchar') AND TYPE = 'FN') 
 DROP FUNCTION [datetimetovarchar] 
GO

CREATE FUNCTION [dbo].[datetimetovarchar](@v datetime) 
RETURNS nvarchar(1000) AS   
BEGIN
  RETURN CONVERT(nvarchar(1000), @v, 20);
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('datetovarchar') AND TYPE = 'FN') 
 DROP FUNCTION [datetovarchar] 
GO

CREATE FUNCTION [dbo].[datetovarchar](@v datetime) 
RETURNS nvarchar(1000) AS 
BEGIN
  RETURN CONVERT(nvarchar(1000), @v, 23);
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('decimaltovarchar') AND TYPE = 'FN') 
 DROP FUNCTION [decimaltovarchar] 
GO

CREATE FUNCTION [dbo].[decimaltovarchar] (@v decimal(18,6))  
RETURNS nvarchar(1000) AS  
BEGIN 
return cast(@v as nvarchar(1000))
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('getdatediff') AND TYPE = 'FN') 
 DROP FUNCTION [getdatediff] 
GO

CREATE FUNCTION [dbo].[getdatediff] (@d1 datetime, @d2 datetime)  
RETURNS int AS  
BEGIN 
return DATEDIFF(Day, @d1, @d2)
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('getdatetimediff') AND TYPE = 'FN') 
 DROP FUNCTION [getdatetimediff] 
GO

CREATE FUNCTION [dbo].[getdatetimediff] (@d1 datetime, @d2 datetime)  
RETURNS int AS  
BEGIN 
return DATEDIFF(second, @d1, @d2)
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('getname') AND TYPE = 'FN') 
 DROP FUNCTION [getname] 
GO

CREATE FUNCTION [dbo].[getname] (@srx nvarchar(1000))  
RETURNS nvarchar(1000) AS  
BEGIN 
Declare @i int
Declare @return nvarchar(1000)
set @i=charindex(',',@srx)
if @i>0 
begin
set @return=substring(@srx,charindex(',',@srx)+1,len(@srx))
end
else
begin
set 
@return=@srx
end
return @return
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('getnames') AND TYPE = 'FN') 
 DROP FUNCTION [getnames] 
GO

CREATE FUNCTION [dbo].[getnames] (@srx nvarchar(1000))
RETURNS nvarchar(1000) AS  
BEGIN 
Declare @i int
Declare @return nvarchar(1000)
set @i=charindex('#',@srx)
if @i>0 
begin
set @return=substring(@srx,charindex('#',@srx)+1,len(@srx))
end
else
begin
set 
@return=@srx
end
return @return
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('getnumber') AND TYPE = 'FN') 
 DROP FUNCTION [getnumber] 
GO

CREATE FUNCTION [dbo].[getnumber] (@srx nvarchar(1000))  
RETURNS nvarchar(1000) AS  
BEGIN 
Declare @i int
Declare @return nvarchar(1000)
set @i=charindex(',',@srx)
if @i>0 
begin
set @return=substring(@srx,0,charindex(',',@srx))
end
else
begin
set 
@return=@srx
end
return @return
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('getnumbers') AND TYPE = 'FN') 
 DROP FUNCTION [getnumbers] 
GO

CREATE FUNCTION [dbo].[getnumbers] (@srx nvarchar(1000))  
RETURNS nvarchar(1000) AS  
BEGIN 
Declare @i int
Declare @return nvarchar(1000)
set @i=charindex('#',@srx)
if @i>0 
begin
set @return=substring(@srx,0,charindex('#',@srx))
end
else
begin
set 
@return=@srx
end
return @return
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('ifisnull') AND TYPE = 'FN') 
 DROP FUNCTION [ifisnull] 
GO

CREATE FUNCTION [dbo].[ifisnull] (@a nvarchar(1000), @b nvarchar(1000))  
RETURNS nvarchar(1000) AS  
BEGIN 
RETURN ISNULL(@a, @b);
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('inttovarchar') AND TYPE = 'FN') 
 DROP FUNCTION [inttovarchar] 
GO

CREATE FUNCTION [dbo].[inttovarchar] (@v int)  
RETURNS nvarchar(1000) AS  
BEGIN 
RETURN CONVERT(nvarchar(1000), @v);
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('moneytovarchar') AND TYPE = 'FN') 
 DROP FUNCTION [moneytovarchar] 
GO

CREATE FUNCTION [dbo].[moneytovarchar] (@v decimal(18,2))  
RETURNS nvarchar(1000) AS  
BEGIN 
RETURN CONVERT(nvarchar(1000), @v);
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('split') AND TYPE = 'FN') 
 DROP FUNCTION [split] 
GO

CREATE FUNCTION [dbo].[split] (@str nvarchar(1000), @s nvarchar(100), @i int)  
RETURNS nvarchar(1000) AS  
BEGIN 
Declare @ls int;
Declare @ll int;
Declare @lc int;
Declare @k int;
Declare @p int;
Declare @q int;
Declare @tmpstr nvarchar(1000);
Declare @splstr nvarchar(1000);
Declare @v nvarchar(1000);
set @ls = len(@s);
set @ll = len(@str)-len(replace(@str,@s,''));
set @lc = @ll/@ls;
if @i>0 and @i<=@lc+1 
 begin
	set @q = @i;
 end;
else if @i<0 and -@i<=@lc+1 
 begin
	set @q = (@lc + 1) + @i + 1;
 end;
else 
 begin
	set @q = 0;
    set @v = '';
 end;
set @tmpstr = @str;
set @p = 1;
set @k=CHARINDEX(@s,@tmpstr);
while @k<>0 and @q>0
 BEGIN
	SET @splstr = SUBSTRING(@tmpstr,1,@k-1);
	SET @tmpstr = SUBSTRING(@tmpstr,@k+1,LEN(@tmpstr)-@k);
    SET @k=CHARINDEX(@s,@tmpstr);
	if @p=@q
	BEGIN
	 set @v = @splstr;
	 set @k = 0;
	END
	else 
	BEGIN
	 set @p = @p + 1;
	END
END;
set @splstr = @tmpstr;
if @v is null and len(@splstr)>0 and @q>0
 BEGIN
	set @v = @splstr
 END
RETURN @v;
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('strindex') AND TYPE = 'FN') 
 DROP FUNCTION [strindex] 
GO

CREATE FUNCTION [dbo].[strindex] (@a1 nvarchar(1000), @a2 nvarchar(1000))  
RETURNS int AS  
BEGIN 
RETURN CHARINDEX(@a2,@a1);
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('varchartodate') AND TYPE = 'FN') 
 DROP FUNCTION [varchartodate] 
GO

CREATE FUNCTION [dbo].[varchartodate] (@v nvarchar(1000))  
RETURNS date AS  
BEGIN 
if(@v='') return ''
if(@v is null) return ''
if(ISDATE(@v)=0) return ''
return cast(@v as date)
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('varchartodatetime') AND TYPE = 'FN') 
 DROP FUNCTION [varchartodatetime] 
GO

CREATE FUNCTION [dbo].[varchartodatetime] (@v nvarchar(1000))  
RETURNS datetime AS  
BEGIN 
if(@v='') return ''
if(@v is null) return ''
if(ISDATE(@v)=0) return ''
return cast(@v as datetime)
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('varchartodecimal') AND TYPE = 'FN') 
 DROP FUNCTION [varchartodecimal] 
GO

CREATE FUNCTION [dbo].[varchartodecimal] (@v nvarchar(1000))  
RETURNS decimal(18,6) AS  
BEGIN 
if(@v='') return 0
if(@v is null) return 0
if(isnumeric(@v)=0) return 0
return cast(@v as decimal(18,6))
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('varchartoint') AND TYPE = 'FN') 
 DROP FUNCTION [varchartoint] 
GO

CREATE FUNCTION [dbo].[varchartoint] (@v nvarchar(1000))  
RETURNS int AS  
BEGIN 
if(@v='') return 0
if(@v is null) return 0
if(isnumeric(@v)=0) return 0
return cast(@v as int)
END
GO


IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('varchartomoney') AND TYPE = 'FN') 
 DROP FUNCTION [varchartomoney] 
GO

CREATE FUNCTION [dbo].[varchartomoney] (@v nvarchar(1000))  
RETURNS decimal(18,2) AS  
BEGIN 
if(@v='') return 0
if(@v is null) return 0
if(isnumeric(@v)=0) return 0
return cast(@v as decimal(18,2))
END
GO

IF EXISTS (SELECT 1 FROM SYSOBJECTS WHERE ID = OBJECT_ID('varchartonumber') AND TYPE = 'FN') 
 DROP FUNCTION [varchartonumber] 
GO

CREATE FUNCTION [dbo].[varchartonumber] (@v nvarchar(1000))
RETURNS decimal(18,0) AS  
BEGIN 
if(@v='') return 0
if(@v is null) return 0
if(isnumeric(@v)=0) return 0
return cast(@v as decimal(18,0))
END
GO





INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北京', 1, '0', '11', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北京', 2, '11', '1101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 3, '1101', '110101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东华门', 4, '110101', '110101001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景山', 4, '110101', '110101002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交道口', 4, '110101', '110101003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安定门', 4, '110101', '110101004', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北新桥', 4, '110101', '110101005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东四', 4, '110101', '110101006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳门', 4, '110101', '110101007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建国门', 4, '110101', '110101008', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东直门', 4, '110101', '110101009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平里', 4, '110101', '110101010', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前门', 4, '110101', '110101011', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崇文门外', 4, '110101', '110101012', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东花市', 4, '110101', '110101013', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙潭', 4, '110101', '110101014', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('体育馆路', 4, '110101', '110101015', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天坛', 4, '110101', '110101016', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永定门外', 4, '110101', '110101017', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 3, '1101', '110102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西长安街', 4, '110102', '110102001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新街口', 4, '110102', '110102003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('月坛', 4, '110102', '110102007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('展览路', 4, '110102', '110102009', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德胜', 4, '110102', '110102010', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金融街', 4, '110102', '110102011', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('什刹海', 4, '110102', '110102012', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大栅栏', 4, '110102', '110102013', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天桥', 4, '110102', '110102014', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('椿树', 4, '110102', '110102015', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶然亭', 4, '110102', '110102016', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广安门内', 4, '110102', '110102017', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛街', 4, '110102', '110102018', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白纸坊', 4, '110102', '110102019', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广安门外', 4, '110102', '110102020', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 3, '1101', '110105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建外', 4, '110105', '110105001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝外', 4, '110105', '110105002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼家楼', 4, '110105', '110105003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三里屯', 4, '110105', '110105004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左家庄', 4, '110105', '110105005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香河园', 4, '110105', '110105006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平街', 4, '110105', '110105007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安贞', 4, '110105', '110105008', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亚运村', 4, '110105', '110105009', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小关', 4, '110105', '110105010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('酒仙桥', 4, '110105', '110105011', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麦子店', 4, '110105', '110105012', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团结湖', 4, '110105', '110105013', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六里屯', 4, '110105', '110105014', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里庄', 4, '110105', '110105015', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双井', 4, '110105', '110105016', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('劲松', 4, '110105', '110105017', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潘家园', 4, '110105', '110105018', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('垡头', 4, '110105', '110105019', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '110105', '110105025', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望京', 4, '110105', '110105026', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奥运村', 4, '110105', '110105031', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('首都机场', 4, '110105', '110105043', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东湖', 4, '110105', '110105044', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南磨房', 4, '110105', '110105221', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高碑店', 4, '110105', '110105222', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('将台', 4, '110105', '110105223', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太阳宫', 4, '110105', '110105224', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小红门', 4, '110105', '110105227', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十八里店', 4, '110105', '110105228', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平房', 4, '110105', '110105229', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '110105', '110105230', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('来广营', 4, '110105', '110105232', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常营', 4, '110105', '110105233', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三间房', 4, '110105', '110105234', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('管庄', 4, '110105', '110105235', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金盏', 4, '110105', '110105236', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙河', 4, '110105', '110105237', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔各庄', 4, '110105', '110105238', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东坝', 4, '110105', '110105239', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑庄户', 4, '110105', '110105240', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豆各庄', 4, '110105', '110105241', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王四营', 4, '110105', '110105242', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰台', 3, '1101', '110106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('右安门', 4, '110106', '110106001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平桥', 4, '110106', '110106002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西罗园', 4, '110106', '110106003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大红门', 4, '110106', '110106004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南苑', 4, '110106', '110106005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东高地', 4, '110106', '110106006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东铁匠营', 4, '110106', '110106007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六里桥', 4, '110106', '110106008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰台街道', 4, '110106', '110106009', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新村', 4, '110106', '110106010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长辛店', 4, '110106', '110106011', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云岗', 4, '110106', '110106012', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方庄', 4, '110106', '110106013', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宛平城', 4, '110106', '110106014', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家堡', 4, '110106', '110106015', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和义', 4, '110106', '110106016', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花乡', 4, '110106', '110106018', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成寿寺', 4, '110106', '110106020', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石榴庄', 4, '110106', '110106021', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北宫', 4, '110106', '110106100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王佐', 4, '110106', '110106101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卢沟桥', 4, '110106', '110106201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石景山', 3, '1101', '110107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八宝山', 4, '110107', '110107001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老山', 4, '110107', '110107002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八角', 4, '110107', '110107003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '110107', '110107004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苹果园', 4, '110107', '110107005', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金顶街', 4, '110107', '110107006', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广宁', 4, '110107', '110107009', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五里坨', 4, '110107', '110107010', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲁谷', 4, '110107', '110107011', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海淀', 3, '1101', '110108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万寿路', 4, '110108', '110108001', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永定路', 4, '110108', '110108002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊坊店', 4, '110108', '110108003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘家口', 4, '110108', '110108004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里庄', 4, '110108', '110108005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫竹院', 4, '110108', '110108006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北下关', 4, '110108', '110108007', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北太平庄', 4, '110108', '110108008', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('学院路', 4, '110108', '110108010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中关村', 4, '110108', '110108011', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海淀街道', 4, '110108', '110108012', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青龙桥', 4, '110108', '110108013', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清华园', 4, '110108', '110108014', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕园', 4, '110108', '110108015', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香山', 4, '110108', '110108016', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河', 4, '110108', '110108017', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花园路', 4, '110108', '110108018', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西三旗', 4, '110108', '110108019', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马连洼', 4, '110108', '110108020', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田村路', 4, '110108', '110108021', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上地', 4, '110108', '110108022', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光', 4, '110108', '110108025', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉', 4, '110108', '110108101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四季青', 4, '110108', '110108102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西北旺', 4, '110108', '110108103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家坨', 4, '110108', '110108104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上庄', 4, '110108', '110108105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海淀镇', 4, '110108', '110108123', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东升', 4, '110108', '110108124', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('门头沟', 3, '1101', '110109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大峪', 4, '110109', '110109001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城子', 4, '110109', '110109002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东辛房', 4, '110109', '110109003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大台', 4, '110109', '110109004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潭柘寺', 4, '110109', '110109101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永定', 4, '110109', '110109102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉', 4, '110109', '110109103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('军庄', 4, '110109', '110109104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雁翅', 4, '110109', '110109105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('斋堂', 4, '110109', '110109106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清水', 4, '110109', '110109107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('妙峰山', 4, '110109', '110109108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王平', 4, '110109', '110109109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('房山', 3, '1101', '110111', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '110111', '110111001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新镇', 4, '110111', '110111002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '110111', '110111004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '110111', '110111005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎风', 4, '110111', '110111006', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('星城', 4, '110111', '110111007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拱辰', 4, '110111', '110111011', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西潞', 4, '110111', '110111012', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎村', 4, '110111', '110111101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窦店', 4, '110111', '110111103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石楼', 4, '110111', '110111104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长阳', 4, '110111', '110111105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 4, '110111', '110111107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长沟', 4, '110111', '110111108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大石窝', 4, '110111', '110111109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张坊', 4, '110111', '110111110', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十渡', 4, '110111', '110111111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青龙湖', 4, '110111', '110111112', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩村河', 4, '110111', '110111115', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('良乡', 4, '110111', '110111116', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周口店', 4, '110111', '110111117', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('琉璃河', 4, '110111', '110111118', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霞云岭', 4, '110111', '110111208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南窖', 4, '110111', '110111209', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佛子庄', 4, '110111', '110111210', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大安山', 4, '110111', '110111211', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史家营', 4, '110111', '110111212', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲洼', 4, '110111', '110111213', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通州', 3, '1101', '110112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中仓', 4, '110112', '110112001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '110112', '110112002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北苑', 4, '110112', '110112003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉桥', 4, '110112', '110112004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞源', 4, '110112', '110112005', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通运', 4, '110112', '110112006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文景', 4, '110112', '110112009', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九棵树', 4, '110112', '110112010', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临河里', 4, '110112', '110112011', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨庄', 4, '110112', '110112012', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞邑', 4, '110112', '110112013', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋庄', 4, '110112', '110112104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家湾', 4, '110112', '110112105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('漷县', 4, '110112', '110112106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马驹桥', 4, '110112', '110112109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西集', 4, '110112', '110112110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台湖', 4, '110112', '110112114', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永乐店', 4, '110112', '110112117', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞城', 4, '110112', '110112119', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永顺', 4, '110112', '110112120', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梨园', 4, '110112', '110112121', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于家务', 4, '110112', '110112209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('顺义', 3, '1101', '110113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '110113', '110113001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明', 4, '110113', '110113002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石园', 4, '110113', '110113010', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('空港', 4, '110113', '110113011', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双丰', 4, '110113', '110113012', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旺泉', 4, '110113', '110113013', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高丽营', 4, '110113', '110113101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李桥', 4, '110113', '110113104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李遂', 4, '110113', '110113105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南彩', 4, '110113', '110113106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北务', 4, '110113', '110113108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孙各庄', 4, '110113', '110113109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张镇', 4, '110113', '110113110', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙湾屯', 4, '110113', '110113111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木林', 4, '110113', '110113112', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北小营', 4, '110113', '110113113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北石槽', 4, '110113', '110113115', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵全营', 4, '110113', '110113116', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仁和', 4, '110113', '110113117', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后沙峪', 4, '110113', '110113118', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天竺', 4, '110113', '110113119', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨镇', 4, '110113', '110113120', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛栏山', 4, '110113', '110113121', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南法信', 4, '110113', '110113122', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马坡', 4, '110113', '110113123', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌平', 3, '1101', '110114', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城北', 4, '110114', '110114001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城南', 4, '110114', '110114005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天通苑北', 4, '110114', '110114006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天通苑南', 4, '110114', '110114007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霍营', 4, '110114', '110114008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('回龙观', 4, '110114', '110114009', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泽园', 4, '110114', '110114010', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史各庄', 4, '110114', '110114011', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳坊', 4, '110114', '110114104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小汤山', 4, '110114', '110114110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南邵', 4, '110114', '110114111', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔村', 4, '110114', '110114112', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百善', 4, '110114', '110114113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北七家', 4, '110114', '110114115', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴寿', 4, '110114', '110114116', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('流村', 4, '110114', '110114118', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十三陵', 4, '110114', '110114119', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延寿', 4, '110114', '110114120', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南口', 4, '110114', '110114121', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马池口', 4, '110114', '110114122', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河', 4, '110114', '110114123', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东小口', 4, '110114', '110114125', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴', 3, '1101', '110115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴丰', 4, '110115', '110115001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林校路', 4, '110115', '110115002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清源', 4, '110115', '110115003', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('观音寺', 4, '110115', '110115009', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天宫院', 4, '110115', '110115010', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高米店', 4, '110115', '110115011', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荣华', 4, '110115', '110115012', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('博兴', 4, '110115', '110115013', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青云店', 4, '110115', '110115103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('采育', 4, '110115', '110115104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安定', 4, '110115', '110115105', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('礼贤', 4, '110115', '110115106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆垡', 4, '110115', '110115107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞各庄', 4, '110115', '110115108', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北臧村', 4, '110115', '110115109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏善庄', 4, '110115', '110115110', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长子营', 4, '110115', '110115111', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亦庄', 4, '110115', '110115112', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄村', 4, '110115', '110115113', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧宫', 4, '110115', '110115114', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西红门', 4, '110115', '110115115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瀛海', 4, '110115', '110115116', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀柔', 3, '1101', '110116', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉河', 4, '110116', '110116001', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙山', 4, '110116', '110116002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北房', 4, '110116', '110116102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨宋', 4, '110116', '110116103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥梓', 4, '110116', '110116105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀北', 4, '110116', '110116106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤河口', 4, '110116', '110116107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渤海', 4, '110116', '110116108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九渡河', 4, '110116', '110116109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('琉璃庙', 4, '110116', '110116110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝山', 4, '110116', '110116111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀柔镇', 4, '110116', '110116112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雁栖', 4, '110116', '110116113', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庙城', 4, '110116', '110116114', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长哨营', 4, '110116', '110116211', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喇叭沟门', 4, '110116', '110116213', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平谷', 3, '1101', '110117', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '110117', '110117001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴谷', 4, '110117', '110117002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东高村', 4, '110117', '110117101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山东庄', 4, '110117', '110117102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南独乐河', 4, '110117', '110117104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大华山', 4, '110117', '110117105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏各庄', 4, '110117', '110117106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马昌营', 4, '110117', '110117108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王辛庄', 4, '110117', '110117110', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴庄', 4, '110117', '110117111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家店', 4, '110117', '110117112', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镇罗营', 4, '110117', '110117114', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平谷镇', 4, '110117', '110117115', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峪口', 4, '110117', '110117116', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马坊', 4, '110117', '110117117', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金海湖', 4, '110117', '110117118', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄松峪', 4, '110117', '110117213', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('熊儿寨', 4, '110117', '110117214', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('密云', 3, '1101', '110118', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼', 4, '110118', '110118001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('果园', 4, '110118', '110118002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('密云镇', 4, '110118', '110118100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('溪翁庄', 4, '110118', '110118101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西田各庄', 4, '110118', '110118102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里堡', 4, '110118', '110118103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河南寨', 4, '110118', '110118104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨各庄', 4, '110118', '110118105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('穆家峪', 4, '110118', '110118106', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太师屯', 4, '110118', '110118107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高岭', 4, '110118', '110118108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('不老屯', 4, '110118', '110118109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯家峪', 4, '110118', '110118110', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古北口', 4, '110118', '110118111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大城子', 4, '110118', '110118112', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东邵渠', 4, '110118', '110118113', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北庄', 4, '110118', '110118114', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城子', 4, '110118', '110118115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石城', 4, '110118', '110118116', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('檀营满族蒙族', 4, '110118', '110118203', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延庆', 3, '1101', '110119', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百泉', 4, '110119', '110119001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香水园', 4, '110119', '110119002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('儒林', 4, '110119', '110119003', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延庆镇', 4, '110119', '110119100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康庄', 4, '110119', '110119101', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八达岭', 4, '110119', '110119102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永宁', 4, '110119', '110119103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧县', 4, '110119', '110119104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张山营', 4, '110119', '110119105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四海', 4, '110119', '110119106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千家店', 4, '110119', '110119107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈家营', 4, '110119', '110119108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大榆树', 4, '110119', '110119109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('井庄', 4, '110119', '110119110', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大庄科', 4, '110119', '110119207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘斌堡', 4, '110119', '110119209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香营', 4, '110119', '110119210', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('珍珠泉', 4, '110119', '110119214', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津', 1, '0', '12', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津', 2, '12', '1201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 3, '1201', '120101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('劝业场', 4, '120101', '120101001', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小白楼', 4, '120101', '120101002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五大道', 4, '120101', '120101003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新兴', 4, '120101', '120101004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南营门', 4, '120101', '120101005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南市', 4, '120101', '120101006', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 3, '1201', '120102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王庄', 4, '120102', '120102001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大直沽', 4, '120102', '120102002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中山门', 4, '120102', '120102003', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富民路', 4, '120102', '120102004', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二号桥', 4, '120102', '120102005', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('春华', 4, '120102', '120102006', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐家口', 4, '120102', '120102007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳楼', 4, '120102', '120102008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常州道', 4, '120102', '120102009', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上杭路', 4, '120102', '120102010', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东新', 4, '120102', '120102011', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲁山道', 4, '120102', '120102012', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 3, '1201', '120103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营门', 4, '120103', '120103001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下瓦房', 4, '120103', '120103002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃园', 4, '120103', '120103003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('挂甲寺', 4, '120103', '120103004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马场', 4, '120103', '120103005', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('越秀路', 4, '120103', '120103006', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊路', 4, '120103', '120103007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天塔', 4, '120103', '120103008', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尖山', 4, '120103', '120103009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈塘庄', 4, '120103', '120103010', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳林', 4, '120103', '120103011', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东海', 4, '120103', '120103012', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梅江', 4, '120103', '120103013', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太湖路', 4, '120103', '120103014', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南开', 3, '1201', '120104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长虹', 4, '120104', '120104001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼', 4, '120104', '120104002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴南', 4, '120104', '120104003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广开', 4, '120104', '120104004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万兴', 4, '120104', '120104005', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('学府', 4, '120104', '120104006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳路', 4, '120104', '120104007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘉陵道', 4, '120104', '120104008', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王顶堤', 4, '120104', '120104009', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水上公园', 4, '120104', '120104010', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('体育中心', 4, '120104', '120104011', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华苑', 4, '120104', '120104012', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 3, '1201', '120105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光复道', 4, '120105', '120105001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望海楼', 4, '120105', '120105002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸿顺里', 4, '120105', '120105003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开河', 4, '120105', '120105004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东路', 4, '120105', '120105005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建昌道', 4, '120105', '120105006', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁园', 4, '120105', '120105007', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王串场', 4, '120105', '120105008', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江都路', 4, '120105', '120105009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('月牙河', 4, '120105', '120105010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红桥', 3, '1201', '120106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西于庄', 4, '120106', '120106001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('咸阳北路', 4, '120106', '120106003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丁字沽', 4, '120106', '120106004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西沽', 4, '120106', '120106005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三条石', 4, '120106', '120106006', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邵公庄', 4, '120106', '120106008', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芥园', 4, '120106', '120106009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铃铛阁', 4, '120106', '120106010', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大胡同', 4, '120106', '120106011', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东丽', 3, '1201', '120110', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张贵庄', 4, '120110', '120110001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰年村', 4, '120110', '120110002', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万新', 4, '120110', '120110003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('无瑕', 4, '120110', '120110004', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新立', 4, '120110', '120110005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华明', 4, '120110', '120110006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金钟', 4, '120110', '120110007', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('军粮城', 4, '120110', '120110008', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金桥', 4, '120110', '120110009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东丽湖', 4, '120110', '120110010', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津开发区西区', 4, '120110', '120110400', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津航空物流区', 4, '120110', '120110401', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津空港经济区', 4, '120110', '120110402', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东丽区开发区', 4, '120110', '120110403', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('综合保税区', 4, '120110', '120110405', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨海新区建设管理委员会', 4, '120110', '120110407', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西青', 3, '1201', '120111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西营门', 4, '120111', '120111001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李七庄', 4, '120111', '120111002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('津门湖', 4, '120111', '120111005', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中北', 4, '120111', '120111100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨柳青', 4, '120111', '120111101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛口', 4, '120111', '120111102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家窝', 4, '120111', '120111103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('精武', 4, '120111', '120111104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大寺', 4, '120111', '120111105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王稳庄', 4, '120111', '120111106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开发区西青微电子小区', 4, '120111', '120111400', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新技术产业园区', 4, '120111', '120111401', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西青区开发区', 4, '120111', '120111450', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('津南', 3, '1201', '120112', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双林', 4, '120112', '120112002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('咸水沽', 4, '120112', '120112100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛沽', 4, '120112', '120112101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小站', 4, '120112', '120112102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双港', 4, '120112', '120112103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛庄', 4, '120112', '120112104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双桥河', 4, '120112', '120112106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里台', 4, '120112', '120112107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北闸口', 4, '120112', '120112108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁路十八局', 4, '120112', '120112401', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('津南开发区东区', 4, '120112', '120112404', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('津南开发区西区', 4, '120112', '120112405', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海河教育园区', 4, '120112', '120112407', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北辰', 3, '1201', '120113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('果园新村', 4, '120113', '120113001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('集贤里', 4, '120113', '120113002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('普东', 4, '120113', '120113003', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瑞景', 4, '120113', '120113004', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佳荣里', 4, '120113', '120113005', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天穆', 4, '120113', '120113100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北仓', 4, '120113', '120113101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双街', 4, '120113', '120113102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双口', 4, '120113', '120113103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青光', 4, '120113', '120113104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宜兴埠', 4, '120113', '120113106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小淀', 4, '120113', '120113107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大张庄', 4, '120113', '120113108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西堤头', 4, '120113', '120113111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科技园区北区', 4, '120113', '120113400', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科技园区南区', 4, '120113', '120113401', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津医药医疗器械工业园', 4, '120113', '120113402', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津陆路港物流装备产业园', 4, '120113', '120113403', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津风电产业园', 4, '120113', '120113404', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光农场', 4, '120113', '120113501', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清', 3, '1201', '120114', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨村', 4, '120114', '120114001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下朱庄', 4, '120114', '120114002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东蒲洼', 4, '120114', '120114003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄庄', 4, '120114', '120114004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐官屯', 4, '120114', '120114005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('运河西', 4, '120114', '120114006', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梅厂', 4, '120114', '120114101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大碱厂', 4, '120114', '120114102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔黄口', 4, '120114', '120114103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大良', 4, '120114', '120114104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下伍旗', 4, '120114', '120114105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南蔡村', 4, '120114', '120114106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孟庄', 4, '120114', '120114107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泗村店', 4, '120114', '120114108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西务', 4, '120114', '120114109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '120114', '120114110', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东马圈', 4, '120114', '120114111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄花店', 4, '120114', '120114112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石各庄', 4, '120114', '120114113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王庆坨', 4, '120114', '120114114', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汊沽港', 4, '120114', '120114115', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北屯', 4, '120114', '120114116', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上马台', 4, '120114', '120114117', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王古庄', 4, '120114', '120114118', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈咀', 4, '120114', '120114119', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白古屯', 4, '120114', '120114120', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹子里', 4, '120114', '120114121', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大黄堡', 4, '120114', '120114122', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豆张庄', 4, '120114', '120114123', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高村', 4, '120114', '120114124', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津开发区逸仙科学工业园', 4, '120114', '120114400', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清区开发区', 4, '120114', '120114401', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清商务区', 4, '120114', '120114402', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清京滨园', 4, '120114', '120114403', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清汽车园', 4, '120114', '120114405', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清科技谷', 4, '120114', '120114406', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武清农场', 4, '120114', '120114500', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝坻', 3, '1201', '120115', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海滨', 4, '120115', '120115001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝平', 4, '120115', '120115002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钰华', 4, '120115', '120115003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周良', 4, '120115', '120115004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝霞', 4, '120115', '120115007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潮阳', 4, '120115', '120115008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大口屯', 4, '120115', '120115101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王卜庄', 4, '120115', '120115103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方家庄', 4, '120115', '120115104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林亭口', 4, '120115', '120115105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八门城', 4, '120115', '120115106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大钟庄', 4, '120115', '120115107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新安', 4, '120115', '120115108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霍各庄', 4, '120115', '120115111', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开口', 4, '120115', '120115113', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大唐庄', 4, '120115', '120115115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛道口', 4, '120115', '120115119', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史各庄', 4, '120115', '120115120', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝各庄', 4, '120115', '120115121', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛家牌', 4, '120115', '120115123', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尔王庄', 4, '120115', '120115124', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄庄', 4, '120115', '120115125', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('口东', 4, '120115', '120115126', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大白庄', 4, '120115', '120115127', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天宝工业园区', 4, '120115', '120115453', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九园工业园区', 4, '120115', '120115454', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('京津新城', 4, '120115', '120115455', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里自沽农场', 4, '120115', '120115500', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大钟农场', 4, '120115', '120115502', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨海新区', 3, '1201', '120116', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杭州道', 4, '120116', '120116005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新河', 4, '120116', '120116006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大沽', 4, '120116', '120116007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新北', 4, '120116', '120116008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北塘', 4, '120116', '120116009', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡家园', 4, '120116', '120116011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泰达', 4, '120116', '120116012', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汉沽', 4, '120116', '120116021', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寨上', 4, '120116', '120116022', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古林', 4, '120116', '120116033', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海滨', 4, '120116', '120116034', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塘沽', 4, '120116', '120116036', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茶淀', 4, '120116', '120116037', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大港', 4, '120116', '120116038', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '120116', '120116100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家泊', 4, '120116', '120116102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '120116', '120116105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小王庄', 4, '120116', '120116106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中塘', 4, '120116', '120116107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保税区', 4, '120116', '120116401', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津滨海新区高新技术产业开发区', 4, '120116', '120116402', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东疆保税港区', 4, '120116', '120116403', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临港经济区', 4, '120116', '120116405', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中新天津生态城', 4, '120116', '120116406', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南港工业区', 4, '120116', '120116408', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁河', 3, '1201', '120117', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芦台', 4, '120117', '120117001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥北', 4, '120117', '120117002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁河镇', 4, '120117', '120117101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苗庄', 4, '120117', '120117102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰台', 4, '120117', '120117103', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岳龙', 4, '120117', '120117104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('板桥', 4, '120117', '120117105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潘庄', 4, '120117', '120117106', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('造甲城', 4, '120117', '120117107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七里海', 4, '120117', '120117108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大北涧沽', 4, '120117', '120117109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东棘坨', 4, '120117', '120117110', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('俵口', 4, '120117', '120117111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('廉庄', 4, '120117', '120117112', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北淮淀', 4, '120117', '120117113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁河区贸易开发区', 4, '120117', '120117400', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁河区经济开发区', 4, '120117', '120117401', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁河县现代产业园区', 4, '120117', '120117451', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津潘庄工业区', 4, '120117', '120117452', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潘庄农场', 4, '120117', '120117500', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('静海', 3, '1201', '120118', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('静海镇', 4, '120118', '120118100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐官屯', 4, '120118', '120118101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独流', 4, '120118', '120118102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王口', 4, '120118', '120118103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台头', 4, '120118', '120118104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('子牙', 4, '120118', '120118105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈官屯', 4, '120118', '120118106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中旺', 4, '120118', '120118107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大邱庄', 4, '120118', '120118108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡公庄', 4, '120118', '120118109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁头', 4, '120118', '120118110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团泊', 4, '120118', '120118111', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塘', 4, '120118', '120118112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大丰堆', 4, '120118', '120118113', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沿庄', 4, '120118', '120118114', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西翟庄', 4, '120118', '120118115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('良王庄', 4, '120118', '120118200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨成庄', 4, '120118', '120118201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津静海经济开发区', 4, '120118', '120118400', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天津子牙工业园区', 4, '120118', '120118402', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团泊新城', 4, '120118', '120118403', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓟州', 3, '1201', '120119', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文昌', 4, '120119', '120119001', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渔阳', 4, '120119', '120119100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洇溜', 4, '120119', '120119101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官庄', 4, '120119', '120119102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马伸桥', 4, '120119', '120119103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下营', 4, '120119', '120119104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邦均', 4, '120119', '120119105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('别山', 4, '120119', '120119106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尤古庄', 4, '120119', '120119108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上仓', 4, '120119', '120119109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下仓', 4, '120119', '120119111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗庄子', 4, '120119', '120119112', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白涧', 4, '120119', '120119113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯家营', 4, '120119', '120119115', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑梓', 4, '120119', '120119116', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东施古', 4, '120119', '120119117', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下窝头', 4, '120119', '120119118', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨津庄', 4, '120119', '120119119', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('出头岭', 4, '120119', '120119120', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西龙虎峪', 4, '120119', '120119121', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('穿芳峪', 4, '120119', '120119122', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东二营', 4, '120119', '120119123', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('许家台', 4, '120119', '120119124', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('礼明庄', 4, '120119', '120119125', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东赵各庄', 4, '120119', '120119126', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('州河湾', 4, '120119', '120119127', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙各庄', 4, '120119', '120119203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 1, '0', '13', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石家庄', 2, '13', '1301', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长安', 3, '1301', '130102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建北', 4, '130102', '130102001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青园', 4, '130102', '130102002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广安', 4, '130102', '130102003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('育才', 4, '130102', '130102004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('跃进', 4, '130102', '130102005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '130102', '130102007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长丰', 4, '130102', '130102010', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谈固', 4, '130102', '130102011', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中山东路', 4, '130102', '130102012', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜康', 4, '130102', '130102013', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建安', 4, '130102', '130102014', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜北', 4, '130102', '130102015', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西兆通', 4, '130102', '130102100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南村', 4, '130102', '130102101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高营', 4, '130102', '130102102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃园', 4, '130102', '130102103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥西', 3, '1301', '130104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东里', 4, '130104', '130104001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中山', 4, '130104', '130104002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南长', 4, '130104', '130104004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('维明', 4, '130104', '130104005', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊', 4, '130104', '130104007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '130104', '130104008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新石', 4, '130104', '130104009', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苑东', 4, '130104', '130104010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西里', 4, '130104', '130104011', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振头', 4, '130104', '130104012', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留营', 4, '130104', '130104013', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长兴', 4, '130104', '130104014', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东华', 4, '130104', '130104015', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('休门', 4, '130104', '130104016', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭后', 4, '130104', '130104017', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '130104', '130104018', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汇通', 4, '130104', '130104019', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 3, '1301', '130105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('革新街', 4, '130105', '130105001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华路', 4, '130105', '130105003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁安', 4, '130105', '130105004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东焦', 4, '130105', '130105005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西苑', 4, '130105', '130105006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合作路', 4, '130105', '130105007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('联盟', 4, '130105', '130105008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石岗', 4, '130105', '130105009', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天苑', 4, '130105', '130105011', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北苑', 4, '130105', '130105012', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵陵铺路', 4, '130105', '130105013', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵佗路', 4, '130105', '130105014', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大郭', 4, '130105', '130105015', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西三庄', 4, '130105', '130105016', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜北', 4, '130105', '130105017', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('井陉矿区', 3, '1301', '130107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('矿市', 4, '130107', '130107001', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四微', 4, '130107', '130107002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾庄', 4, '130107', '130107100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤山', 4, '130107', '130107101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横涧', 4, '130107', '130107200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕华', 3, '1301', '130108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕兴', 4, '130108', '130108001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕强', 4, '130108', '130108002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东苑', 4, '130108', '130108003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建通', 4, '130108', '130108004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('槐底', 4, '130108', '130108005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕华路', 4, '130108', '130108006', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕东', 4, '130108', '130108007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长江', 4, '130108', '130108008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太行', 4, '130108', '130108009', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕翔', 4, '130108', '130108010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建华南', 4, '130108', '130108011', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋营', 4, '130108', '130108100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方村', 4, '130108', '130108101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('藁城', 3, '1301', '130109', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('廉州', 4, '130109', '130109100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴安', 4, '130109', '130109101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾市庄', 4, '130109', '130109102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南营', 4, '130109', '130109103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梅花', 4, '130109', '130109104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岗上', 4, '130109', '130109105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丘头', 4, '130109', '130109106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南董', 4, '130109', '130109107', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家庄', 4, '130109', '130109108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南孟', 4, '130109', '130109109', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('增村', 4, '130109', '130109110', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常安', 4, '130109', '130109111', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西关', 4, '130109', '130109112', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九门', 4, '130109', '130109200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹿泉', 3, '1301', '130110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('获鹿', 4, '130110', '130110100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铜冶', 4, '130110', '130110101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寺家庄', 4, '130110', '130110102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上庄', 4, '130110', '130110103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李村', 4, '130110', '130110104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宜安', 4, '130110', '130110105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄壁庄', 4, '130110', '130110106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河', 4, '130110', '130110107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山尹村', 4, '130110', '130110108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石井', 4, '130110', '130110200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白鹿泉', 4, '130110', '130110201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上寨', 4, '130110', '130110202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北鹿泉经济开发区', 4, '130110', '130110500', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栾城', 3, '1301', '130111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栾城镇', 4, '130111', '130111100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郄马', 4, '130111', '130111101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冶河', 4, '130111', '130111102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窦妪', 4, '130111', '130111103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楼底', 4, '130111', '130111104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南高', 4, '130111', '130111200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳林屯', 4, '130111', '130111201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西营', 4, '130111', '130111202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('井陉', 3, '1301', '130121', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('微水', 4, '130121', '130121100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上安', 4, '130121', '130121101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天长', 4, '130121', '130121102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秀林', 4, '130121', '130121103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南峪', 4, '130121', '130121104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('威州', 4, '130121', '130121105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小作', 4, '130121', '130121106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南障城', 4, '130121', '130121107', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苍岩山', 4, '130121', '130121108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('测鱼', 4, '130121', '130121109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴家窑', 4, '130121', '130121200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北正', 4, '130121', '130121201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于家', 4, '130121', '130121202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙庄', 4, '130121', '130121203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南陉', 4, '130121', '130121204', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛庄', 4, '130121', '130121205', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南王庄', 4, '130121', '130121206', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正定', 3, '1301', '130123', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('诸福屯', 4, '130123', '130123001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三里屯', 4, '130123', '130123002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正定镇', 4, '130123', '130123100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城铺', 4, '130123', '130123102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新安', 4, '130123', '130123103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南岗', 4, '130123', '130123104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲阳桥', 4, '130123', '130123105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南牛', 4, '130123', '130123200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南楼', 4, '130123', '130123201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西平乐', 4, '130123', '130123202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('行唐', 3, '1301', '130125', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙州', 4, '130125', '130125100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南桥', 4, '130125', '130125101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上碑', 4, '130125', '130125102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('口头', 4, '130125', '130125103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独羊岗', 4, '130125', '130125200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安香', 4, '130125', '130125201', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('只里', 4, '130125', '130125202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('市同', 4, '130125', '130125203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翟营', 4, '130125', '130125204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城寨', 4, '130125', '130125205', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上方', 4, '130125', '130125206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉亭', 4, '130125', '130125207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北河', 4, '130125', '130125208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上阎庄', 4, '130125', '130125209', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九口子', 4, '130125', '130125210', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵寿', 3, '1301', '130126', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵寿镇', 4, '130126', '130126100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青同', 4, '130126', '130126101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔上', 4, '130126', '130126102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈庄', 4, '130126', '130126103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('慈峪', 4, '130126', '130126104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔头', 4, '130126', '130126105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三圣院', 4, '130126', '130126200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北洼', 4, '130126', '130126201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛城', 4, '130126', '130126202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狗台', 4, '130126', '130126203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南寨', 4, '130126', '130126204', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南燕川', 4, '130126', '130126205', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北谭庄', 4, '130126', '130126206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寨头', 4, '130126', '130126207', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南营', 4, '130126', '130126208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高邑', 3, '1301', '130127', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高邑镇', 4, '130127', '130127100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营', 4, '130127', '130127101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富村', 4, '130127', '130127102', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万城', 4, '130127', '130127103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中韩', 4, '130127', '130127104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深泽', 3, '1301', '130128', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深泽镇', 4, '130128', '130128100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁杆', 4, '130128', '130128101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵八', 4, '130128', '130128102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大桥头', 4, '130128', '130128103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白庄', 4, '130128', '130128200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留村', 4, '130128', '130128201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赞皇', 3, '1301', '130129', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赞皇镇', 4, '130129', '130129100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('院头', 4, '130129', '130129101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南邢郭', 4, '130129', '130129102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嶂石岩', 4, '130129', '130129103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西龙门', 4, '130129', '130129200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南清河', 4, '130129', '130129202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西阳泽', 4, '130129', '130129203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土门', 4, '130129', '130129204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄北坪', 4, '130129', '130129205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('许亭', 4, '130129', '130129207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张楞', 4, '130129', '130129208', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('无极', 3, '1301', '130130', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('无极镇', 4, '130130', '130130100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七汲', 4, '130130', '130130101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张段固', 4, '130130', '130130102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北苏', 4, '130130', '130130103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭庄', 4, '130130', '130130104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大陈', 4, '130130', '130130105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高头', 4, '130130', '130130200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝庄', 4, '130130', '130130201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东侯坊', 4, '130130', '130130202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里城道', 4, '130130', '130130203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南流', 4, '130130', '130130204', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平山', 3, '1301', '130131', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平山镇', 4, '130131', '130131100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东回舍', 4, '130131', '130131101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温塘', 4, '130131', '130131102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南甸', 4, '130131', '130131103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岗南', 4, '130131', '130131104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古月', 4, '130131', '130131105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下槐', 4, '130131', '130131106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟家庄', 4, '130131', '130131107', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小觉', 4, '130131', '130131108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蛟潭庄', 4, '130131', '130131109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西柏坡', 4, '130131', '130131110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下口', 4, '130131', '130131111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西大吾', 4, '130131', '130131200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上三汲', 4, '130131', '130131201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两河', 4, '130131', '130131202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东王坡', 4, '130131', '130131203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家庄', 4, '130131', '130131204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宅北', 4, '130131', '130131205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北冶', 4, '130131', '130131207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上观音堂', 4, '130131', '130131209', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家桥', 4, '130131', '130131210', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营里', 4, '130131', '130131211', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合河口', 4, '130131', '130131212', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元氏', 3, '1301', '130132', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城区', 4, '130132', '130132001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('槐阳', 4, '130132', '130132100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('殷村', 4, '130132', '130132101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南佐', 4, '130132', '130132102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋曹', 4, '130132', '130132103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南因', 4, '130132', '130132104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姬村', 4, '130132', '130132105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北褚', 4, '130132', '130132106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马村', 4, '130132', '130132107', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东张', 4, '130132', '130132201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵同', 4, '130132', '130132202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏村', 4, '130132', '130132204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏阳', 4, '130132', '130132205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北正', 4, '130132', '130132206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前仙', 4, '130132', '130132207', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑水河', 4, '130132', '130132208', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵县', 3, '1301', '130133', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵州', 4, '130133', '130133100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('范庄', 4, '130133', '130133101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北王里', 4, '130133', '130133102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新寨店', 4, '130133', '130133103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩村', 4, '130133', '130133104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南柏舍', 4, '130133', '130133105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河店', 4, '130133', '130133106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王西章', 4, '130133', '130133107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前大章', 4, '130133', '130133200', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谢庄', 4, '130133', '130133201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高村', 4, '130133', '130133202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛集', 3, '1301', '130181', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛集镇', 4, '130181', '130181100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧城', 4, '130181', '130181101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张古庄', 4, '130181', '130181102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('位伯', 4, '130181', '130181103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新垒头', 4, '130181', '130181104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '130181', '130181105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南智丘', 4, '130181', '130181106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王口', 4, '130181', '130181107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天宫营', 4, '130181', '130181200', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前营', 4, '130181', '130181201', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马庄', 4, '130181', '130181202', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和睦井', 4, '130181', '130181203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田家庄', 4, '130181', '130181204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中里厢', 4, '130181', '130181205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小辛庄', 4, '130181', '130181206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋州', 3, '1301', '130183', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋州镇', 4, '130183', '130183100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('总十庄', 4, '130183', '130183101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营里', 4, '130183', '130183102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃园', 4, '130183', '130183103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东卓宿', 4, '130183', '130183104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马于', 4, '130183', '130183105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小樵', 4, '130183', '130183106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('槐树', 4, '130183', '130183107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东里庄', 4, '130183', '130183108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周家庄', 4, '130183', '130183201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新乐', 3, '1301', '130184', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长寿', 4, '130184', '130184001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化皮', 4, '130184', '130184101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('承安', 4, '130184', '130184102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正莫', 4, '130184', '130184103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大岳', 4, '130184', '130184104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜固', 4, '130184', '130184105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邯邰', 4, '130184', '130184106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东王', 4, '130184', '130184107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马头铺', 4, '130184', '130184108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('协神', 4, '130184', '130184200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木村', 4, '130184', '130184201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭家庄', 4, '130184', '130184202', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐山', 2, '13', '1302', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路南', 3, '1302', '130202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('学院南路', 4, '130202', '130202001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊', 4, '130202', '130202002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广场', 4, '130202', '130202003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永红桥', 4, '130202', '130202004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小山', 4, '130202', '130202005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文化北后街', 4, '130202', '130202006', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钱家营矿区', 4, '130202', '130202007', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('惠民', 4, '130202', '130202008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家屯', 4, '130202', '130202009', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('稻地', 4, '130202', '130202100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('女织寨', 4, '130202', '130202101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路北', 3, '1302', '130203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乔屯', 4, '130203', '130203001', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文化路', 4, '130203', '130203002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钓鱼台', 4, '130203', '130203003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东新村', 4, '130203', '130203004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('缸窑', 4, '130203', '130203005', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('机场路', 4, '130203', '130203006', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北路', 4, '130203', '130203007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙东', 4, '130203', '130203008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大里', 4, '130203', '130203009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明', 4, '130203', '130203010', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翔云道', 4, '130203', '130203011', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高新技术开发区', 4, '130203', '130203012', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩城', 4, '130203', '130203100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('果园', 4, '130203', '130203101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古冶', 3, '1302', '130204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林西', 4, '130204', '130204001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐家庄', 4, '130204', '130204002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古冶街道', 4, '130204', '130204003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵各庄', 4, '130204', '130204004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('京华', 4, '130204', '130204005', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('范各庄', 4, '130204', '130204100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卑家店', 4, '130204', '130204101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王辇庄', 4, '130204', '130204201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('习家套', 4, '130204', '130204202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大庄坨', 4, '130204', '130204203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开平', 3, '1302', '130205', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家沟', 4, '130205', '130205001', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开平街道', 4, '130205', '130205002', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('税务庄', 4, '130205', '130205003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陡电', 4, '130205', '130205005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荆各庄', 4, '130205', '130205006', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开平镇', 4, '130205', '130205100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栗园', 4, '130205', '130205101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('越河', 4, '130205', '130205102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双桥', 4, '130205', '130205103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郑庄子', 4, '130205', '130205104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洼里', 4, '130205', '130205105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰南', 3, '1302', '130207', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华路', 4, '130207', '130207002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰南镇', 4, '130207', '130207100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小集', 4, '130207', '130207103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄各庄', 4, '130207', '130207104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西葛', 4, '130207', '130207105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大新庄', 4, '130207', '130207106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钱营', 4, '130207', '130207107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐坊', 4, '130207', '130207108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王兰庄', 4, '130207', '130207109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳树酄', 4, '130207', '130207110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑沿子', 4, '130207', '130207111', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大齐各庄', 4, '130207', '130207113', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海北', 4, '130207', '130207114', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南孙庄', 4, '130207', '130207116', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东田庄', 4, '130207', '130207202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尖字沽', 4, '130207', '130207203', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰润', 3, '1302', '130208', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平路', 4, '130208', '130208001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕山路', 4, '130208', '130208002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浭阳', 4, '130208', '130208003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰润镇', 4, '130208', '130208100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老庄子', 4, '130208', '130208101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('任各庄', 4, '130208', '130208102', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左家坞', 4, '130208', '130208103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉河头', 4, '130208', '130208104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王官营', 4, '130208', '130208105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('火石营', 4, '130208', '130208106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔河', 4, '130208', '130208108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新军屯', 4, '130208', '130208109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小张各庄', 4, '130208', '130208110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰登坞', 4, '130208', '130208111', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李钊庄', 4, '130208', '130208112', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白官屯', 4, '130208', '130208113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石各庄', 4, '130208', '130208114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙流河', 4, '130208', '130208115', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七树庄', 4, '130208', '130208116', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨官林', 4, '130208', '130208117', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银城铺', 4, '130208', '130208118', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常庄', 4, '130208', '130208119', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姜家营', 4, '130208', '130208202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('欢喜庄', 4, '130208', '130208205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家营', 4, '130208', '130208208', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹妃甸', 3, '1302', '130209', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐海', 4, '130209', '130209100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳赞', 4, '130209', '130209101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨海', 4, '130209', '130209102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('一农场', 4, '130209', '130209401', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三农场', 4, '130209', '130209403', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四农场', 4, '130209', '130209404', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五农场', 4, '130209', '130209405', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六农场', 4, '130209', '130209406', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七农场', 4, '130209', '130209407', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八农场', 4, '130209', '130209408', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九农场', 4, '130209', '130209409', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十农场', 4, '130209', '130209410', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十一农场', 4, '130209', '130209411', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里海养殖场', 4, '130209', '130209413', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南堡经济开发区', 4, '130209', '130209450', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹妃甸工业区', 4, '130209', '130209451', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦南', 3, '1302', '130224', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊路', 4, '130224', '130224001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('倴城', 4, '130224', '130224100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋道口', 4, '130224', '130224101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长凝', 4, '130224', '130224102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡各庄', 4, '130224', '130224103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坨里', 4, '130224', '130224104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚王庄', 4, '130224', '130224105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('司各庄', 4, '130224', '130224106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安各庄', 4, '130224', '130224107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扒齿港', 4, '130224', '130224108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('程庄', 4, '130224', '130224109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青坨营', 4, '130224', '130224110', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏各庄', 4, '130224', '130224111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南堡', 4, '130224', '130224114', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方各庄', 4, '130224', '130224115', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东黄坨', 4, '130224', '130224116', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马城', 4, '130224', '130224117', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐亭', 3, '1302', '130225', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐安', 4, '130225', '130225001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐亭镇', 4, '130225', '130225100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤家河', 4, '130225', '130225101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡家坨', 4, '130225', '130225102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王滩', 4, '130225', '130225103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('闫各庄', 4, '130225', '130225104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马头营', 4, '130225', '130225105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新寨', 4, '130225', '130225106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汀流河', 4, '130225', '130225107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姜各庄', 4, '130225', '130225108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛庄', 4, '130225', '130225109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中堡', 4, '130225', '130225110', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大相各庄', 4, '130225', '130225111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞各庄', 4, '130225', '130225201', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古河', 4, '130225', '130225203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迁西', 3, '1302', '130227', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栗乡', 4, '130227', '130227008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴城', 4, '130227', '130227100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金厂峪', 4, '130227', '130227101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洒河桥', 4, '130227', '130227102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平寨', 4, '130227', '130227103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗家屯', 4, '130227', '130227104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东荒峪', 4, '130227', '130227105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新集', 4, '130227', '130227106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三屯营', 4, '130227', '130227107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦阳', 4, '130227', '130227108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汉儿庄', 4, '130227', '130227109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新庄子', 4, '130227', '130227110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东莲花院', 4, '130227', '130227111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白庙子', 4, '130227', '130227112', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上营', 4, '130227', '130227113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渔户寨', 4, '130227', '130227203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧城', 4, '130227', '130227204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尹庄', 4, '130227', '130227205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉田', 3, '1302', '130229', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉田镇', 4, '130229', '130229100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亮甲店', 4, '130229', '130229101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸦鸿桥', 4, '130229', '130229102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窝洛沽', 4, '130229', '130229103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石臼窝', 4, '130229', '130229104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虹桥', 4, '130229', '130229105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('散水头', 4, '130229', '130229106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林南仓', 4, '130229', '130229107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林西', 4, '130229', '130229108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家板桥', 4, '130229', '130229109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彩亭桥', 4, '130229', '130229110', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤树', 4, '130229', '130229111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大安', 4, '130229', '130229112', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐自头', 4, '130229', '130229113', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家屯', 4, '130229', '130229114', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家套', 4, '130229', '130229115', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈家铺', 4, '130229', '130229116', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林头屯', 4, '130229', '130229201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潮洛窝', 4, '130229', '130229203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家桥', 4, '130229', '130229205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('遵化', 3, '1302', '130281', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华明路', 4, '130281', '130281001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文化路', 4, '130281', '130281002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('遵化镇', 4, '130281', '130281100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堡子店', 4, '130281', '130281101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马兰峪', 4, '130281', '130281102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安城', 4, '130281', '130281103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东新庄', 4, '130281', '130281104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新店子', 4, '130281', '130281105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('党峪', 4, '130281', '130281106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('地北头', 4, '130281', '130281107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东旧寨', 4, '130281', '130281108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁厂', 4, '130281', '130281109', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家洼', 4, '130281', '130281110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建明', 4, '130281', '130281111', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门', 4, '130281', '130281112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔家庄', 4, '130281', '130281113', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西留村', 4, '130281', '130281114', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴旺寨', 4, '130281', '130281115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西三里', 4, '130281', '130281116', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西下营', 4, '130281', '130281203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤泉', 4, '130281', '130281204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东陵', 4, '130281', '130281205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘备寨', 4, '130281', '130281206', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团瓢庄', 4, '130281', '130281207', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娘娘庄', 4, '130281', '130281208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('候家寨', 4, '130281', '130281210', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小厂', 4, '130281', '130281211', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迁安', 3, '1302', '130283', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨店子', 4, '130283', '130283004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迁安镇', 4, '130283', '130283100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏官营', 4, '130283', '130283101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨各庄', 4, '130283', '130283102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建昌营', 4, '130283', '130283103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵店子', 4, '130283', '130283104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('野鸡坨', 4, '130283', '130283105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大崔庄', 4, '130283', '130283106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡园', 4, '130283', '130283108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马兰庄', 4, '130283', '130283109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河驿', 4, '130283', '130283110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木厂口', 4, '130283', '130283111', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上射雁庄', 4, '130283', '130283112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平庄', 4, '130283', '130283113', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扣庄', 4, '130283', '130283114', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大五里', 4, '130283', '130283115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五重安', 4, '130283', '130283116', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭店子', 4, '130283', '130283117', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎家店', 4, '130283', '130283118', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦州', 3, '1302', '130284', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '130284', '130284002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦城路', 4, '130284', '130284003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('响嘡', 4, '130284', '130284004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东安各庄', 4, '130284', '130284102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雷庄', 4, '130284', '130284103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茨榆坨', 4, '130284', '130284104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榛子', 4, '130284', '130284105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨柳庄', 4, '130284', '130284106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('油榨', 4, '130284', '130284107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古马', 4, '130284', '130284108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小马庄', 4, '130284', '130284109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九百户', 4, '130284', '130284110', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王店子', 4, '130284', '130284111', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秦皇岛', 2, '13', '1303', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海港', 3, '1303', '130302', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文化路', 4, '130302', '130302001', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海滨路', 4, '130302', '130302002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北环路', 4, '130302', '130302003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设大街', 4, '130302', '130302004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '130302', '130302005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西港路', 4, '130302', '130302006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕山大街', 4, '130302', '130302007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('港城大街', 4, '130302', '130302008', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东环路', 4, '130302', '130302009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔岭', 4, '130302', '130302010', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('珠江道', 4, '130302', '130302011', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄河道', 4, '130302', '130302012', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腾飞路', 4, '130302', '130302013', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东港', 4, '130302', '130302100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西港', 4, '130302', '130302102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海阳', 4, '130302', '130302103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北港', 4, '130302', '130302104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜庄', 4, '130302', '130302105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门寨', 4, '130302', '130302106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('驻操营', 4, '130302', '130302107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山海关', 3, '1303', '130303', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南关', 4, '130303', '130303001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东街', 4, '130303', '130303002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西街', 4, '130303', '130303003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路南', 4, '130303', '130303004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('船厂路', 4, '130303', '130303005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第一关', 4, '130303', '130303100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石河', 4, '130303', '130303101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟姜', 4, '130303', '130303102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渤海', 4, '130303', '130303200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北戴河', 3, '1303', '130304', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西山', 4, '130304', '130304001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东山', 4, '130304', '130304002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海滨', 4, '130304', '130304100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('戴河', 4, '130304', '130304101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛头崖', 4, '130304', '130304102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('抚宁', 3, '1303', '130306', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('骊城', 4, '130306', '130306001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('抚宁镇', 4, '130306', '130306100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留守营', 4, '130306', '130306101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆关', 4, '130306', '130306102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台营', 4, '130306', '130306105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大新寨', 4, '130306', '130306106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坟坨', 4, '130306', '130306107', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茶棚', 4, '130306', '130306200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青龙', 3, '1303', '130321', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青龙镇', 4, '130321', '130321100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祖山', 4, '130321', '130321101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木头凳', 4, '130321', '130321102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双山子', 4, '130321', '130321103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马圈子', 4, '130321', '130321104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖营子', 4, '130321', '130321105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大巫岚', 4, '130321', '130321106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土门子', 4, '130321', '130321107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八道河', 4, '130321', '130321108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隔河头', 4, '130321', '130321109', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娄杖子', 4, '130321', '130321111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤凰山', 4, '130321', '130321200', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙王庙', 4, '130321', '130321201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三星口', 4, '130321', '130321202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('干沟', 4, '130321', '130321203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大石岭', 4, '130321', '130321206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官场', 4, '130321', '130321208', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茨榆山', 4, '130321', '130321209', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平方子', 4, '130321', '130321210', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安子岭', 4, '130321', '130321211', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱杖子', 4, '130321', '130321212', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草碾', 4, '130321', '130321213', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七道河', 4, '130321', '130321214', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三拨子', 4, '130321', '130321217', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凉水河', 4, '130321', '130321218', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌黎', 3, '1303', '130322', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌黎镇', 4, '130322', '130322100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('靖安', 4, '130322', '130322101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安山', 4, '130322', '130322102', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙家店', 4, '130322', '130322103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泥井', 4, '130322', '130322104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大蒲河', 4, '130322', '130322105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新集', 4, '130322', '130322106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘台庄', 4, '130322', '130322107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱各庄', 4, '130322', '130322108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荒佃庄', 4, '130322', '130322109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茹荷', 4, '130322', '130322110', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团林', 4, '130322', '130322201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛条港', 4, '130322', '130322202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马坨店', 4, '130322', '130322203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两山', 4, '130322', '130322206', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里铺', 4, '130322', '130322207', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卢龙', 3, '1303', '130324', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卢龙镇', 4, '130324', '130324100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潘庄', 4, '130324', '130324101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕河营', 4, '130324', '130324102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双望', 4, '130324', '130324103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘田各庄', 4, '130324', '130324104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门', 4, '130324', '130324105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木井', 4, '130324', '130324106', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈官屯', 4, '130324', '130324107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蛤泊', 4, '130324', '130324108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下寨', 4, '130324', '130324200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家营', 4, '130324', '130324201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('印庄', 4, '130324', '130324203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邯郸', 2, '13', '1304', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邯山', 3, '1304', '130402', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('火磨', 4, '130402', '130402001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陵园', 4, '130402', '130402002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明路', 4, '130402', '130402003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滏东', 4, '130402', '130402004', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗城头', 4, '130402', '130402005', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渚河路', 4, '130402', '130402006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浴新南', 4, '130402', '130402007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('农林路', 4, '130402', '130402008', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贸东', 4, '130402', '130402009', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贸西', 4, '130402', '130402010', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北张庄', 4, '130402', '130402100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马头', 4, '130402', '130402101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河沙镇', 4, '130402', '130402102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高臾', 4, '130402', '130402103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光禄', 4, '130402', '130402104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马庄', 4, '130402', '130402200', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南堡', 4, '130402', '130402201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('代召', 4, '130402', '130402202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛庄营', 4, '130402', '130402203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花官营', 4, '130402', '130402204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台城', 4, '130402', '130402206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丛台', 3, '1304', '130403', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丛台西', 4, '130403', '130403001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('联纺西', 4, '130403', '130403002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('联纺东', 4, '130403', '130403003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明桥', 4, '130403', '130403004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丛台东', 4, '130403', '130403005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四季青', 4, '130403', '130403006', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '130403', '130403007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华', 4, '130403', '130403008', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('人民路', 4, '130403', '130403009', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳林桥', 4, '130403', '130403010', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尚璧', 4, '130403', '130403101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南沿村', 4, '130403', '130403102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄粱梦', 4, '130403', '130403103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏曹', 4, '130403', '130403200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南吕固', 4, '130403', '130403201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兼庄', 4, '130403', '130403202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三陵', 4, '130403', '130403203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小西堡', 4, '130403', '130403204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚寨', 4, '130403', '130403205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('复兴', 3, '1304', '130404', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利桥', 4, '130404', '130404001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百家村', 4, '130404', '130404002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁路大院', 4, '130404', '130404003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化林路', 4, '130404', '130404004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞村', 4, '130404', '130404005', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石化', 4, '130404', '130404007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('户村', 4, '130404', '130404100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林坛', 4, '130404', '130404101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭家寨', 4, '130404', '130404200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康庄', 4, '130404', '130404201', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城', 4, '130404', '130404202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峰峰矿区', 3, '1304', '130406', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滏阳东路', 4, '130406', '130406001', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临水', 4, '130406', '130406100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峰峰', 4, '130406', '130406101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新坡', 4, '130406', '130406102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大社', 4, '130406', '130406103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和村', 4, '130406', '130406104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义井', 4, '130406', '130406105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭城', 4, '130406', '130406106', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('界城', 4, '130406', '130406107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大峪', 4, '130406', '130406108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肥乡', 3, '1304', '130407', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肥乡镇', 4, '130407', '130407100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天台山', 4, '130407', '130407101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛安镇', 4, '130407', '130407102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大寺上', 4, '130407', '130407103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东漳堡', 4, '130407', '130407104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛演堡', 4, '130407', '130407105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西吕营', 4, '130407', '130407106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元固', 4, '130407', '130407107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北高', 4, '130407', '130407108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永年', 3, '1304', '130408', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临洺关', 4, '130408', '130408100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大北汪', 4, '130408', '130408101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张西堡', 4, '130408', '130408102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广府', 4, '130408', '130408103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永合会', 4, '130408', '130408105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘营', 4, '130408', '130408106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东杨庄', 4, '130408', '130408107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('讲武', 4, '130408', '130408108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西苏', 4, '130408', '130408109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('界河店', 4, '130408', '130408201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘汉', 4, '130408', '130408203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正西', 4, '130408', '130408204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲陌', 4, '130408', '130408206', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛庄堡', 4, '130408', '130408207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小龙马', 4, '130408', '130408208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西河庄', 4, '130408', '130408211', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西阳城', 4, '130408', '130408213', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临漳', 3, '1304', '130423', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临漳镇', 4, '130423', '130423100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南东坊', 4, '130423', '130423101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙陶集', 4, '130423', '130423102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳园', 4, '130423', '130423103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('称勾集', 4, '130423', '130423104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邺城', 4, '130423', '130423105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章里集', 4, '130423', '130423106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张村集', 4, '130423', '130423107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('砖寨营', 4, '130423', '130423108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('习文', 4, '130423', '130423109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狄邱', 4, '130423', '130423200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西羊羔', 4, '130423', '130423202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜村集', 4, '130423', '130423204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏鹤集', 4, '130423', '130423208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成安', 3, '1304', '130424', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成安镇', 4, '130424', '130424100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('商城', 4, '130424', '130424101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('漳河店', 4, '130424', '130424102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家疃', 4, '130424', '130424103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北乡义', 4, '130424', '130424104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道东堡', 4, '130424', '130424105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛义', 4, '130424', '130424200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏寺营', 4, '130424', '130424201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长巷', 4, '130424', '130424204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大名', 3, '1304', '130425', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大名镇', 4, '130425', '130425100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨桥', 4, '130425', '130425101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万堤', 4, '130425', '130425102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙王庙', 4, '130425', '130425103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('束馆', 4, '130425', '130425104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金滩', 4, '130425', '130425105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙圪塔', 4, '130425', '130425106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大街', 4, '130425', '130425107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铺上', 4, '130425', '130425108', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙甘店', 4, '130425', '130425109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北峰', 4, '130425', '130425110', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄金堤', 4, '130425', '130425111', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王村', 4, '130425', '130425201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧治', 4, '130425', '130425205', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西未庄', 4, '130425', '130425206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西付集', 4, '130425', '130425208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('埝头', 4, '130425', '130425209', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张铁集', 4, '130425', '130425211', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红庙', 4, '130425', '130425212', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营镇', 4, '130425', '130425213', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涉县', 3, '1304', '130426', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安', 4, '130426', '130426001', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涉城', 4, '130426', '130426100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河南店', 4, '130426', '130426101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('索堡', 4, '130426', '130426102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西戌', 4, '130426', '130426103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('井店', 4, '130426', '130426104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('更乐', 4, '130426', '130426105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固新', 4, '130426', '130426106', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西达', 4, '130426', '130426107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('偏城', 4, '130426', '130426108', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神头', 4, '130426', '130426200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽城', 4, '130426', '130426201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('偏店', 4, '130426', '130426202', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙虎', 4, '130426', '130426203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木井', 4, '130426', '130426204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('关防', 4, '130426', '130426205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合漳', 4, '130426', '130426206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹿头', 4, '130426', '130426207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磁县', 3, '1304', '130427', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磁州', 4, '130427', '130427100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('讲武城', 4, '130427', '130427103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岳城', 4, '130427', '130427104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('观台', 4, '130427', '130427105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白土', 4, '130427', '130427107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄沙', 4, '130427', '130427108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路村营', 4, '130427', '130427200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西固义', 4, '130427', '130427201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('时村营', 4, '130427', '130427204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶泉', 4, '130427', '130427207', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('都党', 4, '130427', '130427208', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北贾璧', 4, '130427', '130427209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邱县', 3, '1304', '130430', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新马头', 4, '130430', '130430100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邱城', 4, '130430', '130430101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁二庄', 4, '130430', '130430102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香城固', 4, '130430', '130430103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城营', 4, '130430', '130430104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南辛店', 4, '130430', '130430201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈村', 4, '130430', '130430204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸡泽', 3, '1304', '130431', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸡泽镇', 4, '130431', '130431100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小寨', 4, '130431', '130431101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塔', 4, '130431', '130431102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹庄', 4, '130431', '130431103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浮图店', 4, '130431', '130431104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴官营', 4, '130431', '130431105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('风正', 4, '130431', '130431202', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广平', 3, '1304', '130432', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广平镇', 4, '130432', '130432100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平固店', 4, '130432', '130432101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜营', 4, '130432', '130432102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南阳堡', 4, '130432', '130432103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里铺', 4, '130432', '130432104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南韩村', 4, '130432', '130432105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东张孟', 4, '130432', '130432106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('馆陶', 3, '1304', '130433', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('馆陶镇', 4, '130433', '130433100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('房寨', 4, '130433', '130433101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴堡', 4, '130433', '130433102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏僧寨', 4, '130433', '130433103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寿山寺', 4, '130433', '130433200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王桥', 4, '130433', '130433201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南徐村', 4, '130433', '130433202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路桥', 4, '130433', '130433203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏县', 3, '1304', '130434', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏城', 4, '130434', '130434100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德政', 4, '130434', '130434101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北皋', 4, '130434', '130434102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双井', 4, '130434', '130434103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牙里', 4, '130434', '130434104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('车往', 4, '130434', '130434105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('回隆', 4, '130434', '130434106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张二庄', 4, '130434', '130434107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东代固', 4, '130434', '130434108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('院堡', 4, '130434', '130434109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南双庙', 4, '130434', '130434110', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('棘针寨', 4, '130434', '130434111', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('边马', 4, '130434', '130434112', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泊口', 4, '130434', '130434113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仕望集', 4, '130434', '130434114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙口集', 4, '130434', '130434202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('野胡拐', 4, '130434', '130434203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前大磨', 4, '130434', '130434205', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大辛庄', 4, '130434', '130434208', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大马村', 4, '130434', '130434209', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北台头', 4, '130434', '130434212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲周', 3, '1304', '130435', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲周镇', 4, '130435', '130435100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安寨', 4, '130435', '130435101', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯村', 4, '130435', '130435102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河南疃', 4, '130435', '130435103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第四疃', 4, '130435', '130435104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白寨', 4, '130435', '130435105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('槐桥', 4, '130435', '130435200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南里岳', 4, '130435', '130435201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河道', 4, '130435', '130435203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('依庄', 4, '130435', '130435204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武安', 3, '1304', '130481', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武安镇', 4, '130481', '130481100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康二城', 4, '130481', '130481101', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('午汲', 4, '130481', '130481102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磁山', 4, '130481', '130481103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伯延', 4, '130481', '130481104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('淑村', 4, '130481', '130481105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大同', 4, '130481', '130481106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邑城', 4, '130481', '130481107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('矿山', 4, '130481', '130481108', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贺进', 4, '130481', '130481109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳邑', 4, '130481', '130481110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徘徊', 4, '130481', '130481111', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冶陶', 4, '130481', '130481112', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上团城', 4, '130481', '130481200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北安庄', 4, '130481', '130481201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北安乐', 4, '130481', '130481202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西土山', 4, '130481', '130481203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西寺庄', 4, '130481', '130481204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('活水', 4, '130481', '130481205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石洞', 4, '130481', '130481206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('管陶', 4, '130481', '130481207', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家庄', 4, '130481', '130481208', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邢台', 2, '13', '1305', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('襄都', 3, '1305', '130502', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南长街', 4, '130502', '130502001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北大街', 4, '130502', '130502002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西大街', 4, '130502', '130502003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西门里', 4, '130502', '130502004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豫让桥', 4, '130502', '130502005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉东', 4, '130502', '130502006', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东郭村', 4, '130502', '130502100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王快', 4, '130502', '130502101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晏家屯', 4, '130502', '130502102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祝村', 4, '130502', '130502103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东汪', 4, '130502', '130502104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大梁庄', 4, '130502', '130502200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('市高新技术开发区', 4, '130502', '130502400', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('信都', 3, '1305', '130503', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钢铁路', 4, '130503', '130503001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中兴路', 4, '130503', '130503002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达活泉', 4, '130503', '130503003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张宽', 4, '130503', '130503004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章村', 4, '130503', '130503005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华大街', 4, '130503', '130503006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团结路', 4, '130503', '130503007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉西', 4, '130503', '130503008', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大郭', 4, '130503', '130503100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李村', 4, '130503', '130503101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南石门', 4, '130503', '130503102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊范', 4, '130503', '130503103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皇寺', 4, '130503', '130503104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('会宁', 4, '130503', '130503105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西黄村', 4, '130503', '130503106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路罗', 4, '130503', '130503107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('将军墓', 4, '130503', '130503108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浆水', 4, '130503', '130503109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋家庄', 4, '130503', '130503110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太子井', 4, '130503', '130503200', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉寺', 4, '130503', '130503201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北小庄', 4, '130503', '130503202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城计头', 4, '130503', '130503203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白岸', 4, '130503', '130503204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冀家村', 4, '130503', '130503205', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('任泽', 3, '1305', '130505', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('任城', 4, '130505', '130505100', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邢家湾', 4, '130505', '130505101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛店', 4, '130505', '130505102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天口', 4, '130505', '130505103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西固城', 4, '130505', '130505200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永福庄', 4, '130505', '130505201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '130505', '130505202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('骆庄', 4, '130505', '130505204', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南和', 3, '1305', '130506', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和阳', 4, '130506', '130506100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾宋', 4, '130506', '130506101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝桥', 4, '130506', '130506102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三思', 4, '130506', '130506103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河郭', 4, '130506', '130506104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东三召', 4, '130506', '130506200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎里', 4, '130506', '130506201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史召', 4, '130506', '130506203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临城', 3, '1305', '130522', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临城镇', 4, '130522', '130522100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东镇', 4, '130522', '130522101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝庄', 4, '130522', '130522102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西竖', 4, '130522', '130522103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑城', 4, '130522', '130522104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸭鸽营', 4, '130522', '130522201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石城', 4, '130522', '130522203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵庄', 4, '130522', '130522205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('内丘', 3, '1305', '130523', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('内丘镇', 4, '130523', '130523100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孟村', 4, '130523', '130523101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金店', 4, '130523', '130523102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官庄', 4, '130523', '130523103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳林', 4, '130523', '130523104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五郭店', 4, '130523', '130523200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南赛', 4, '130523', '130523203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('獐獏', 4, '130523', '130523204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯家庄', 4, '130523', '130523205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏乡', 3, '1305', '130524', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏乡镇', 4, '130524', '130524100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固城店', 4, '130524', '130524101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西汪', 4, '130524', '130524102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙华', 4, '130524', '130524103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家庄', 4, '130524', '130524200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('内步', 4, '130524', '130524203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆尧', 3, '1305', '130525', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆尧镇', 4, '130525', '130525100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏家庄', 4, '130525', '130525101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尹村', 4, '130525', '130525102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山口', 4, '130525', '130525103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲子', 4, '130525', '130525104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固城', 4, '130525', '130525105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东良', 4, '130525', '130525106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北楼', 4, '130525', '130525200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双碑', 4, '130525', '130525202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛家桥', 4, '130525', '130525203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千户营', 4, '130525', '130525204', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大张庄', 4, '130525', '130525205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁晋', 3, '1305', '130528', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁北', 4, '130528', '130528001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤凰', 4, '130528', '130528100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河渠', 4, '130528', '130528101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北河庄', 4, '130528', '130528102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('耿庄桥', 4, '130528', '130528103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东汪', 4, '130528', '130528104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾家口', 4, '130528', '130528105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四芝兰', 4, '130528', '130528106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大陆村', 4, '130528', '130528107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('换马店', 4, '130528', '130528108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家庄', 4, '130528', '130528109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐邱', 4, '130528', '130528110', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大曹庄', 4, '130528', '130528111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯口', 4, '130528', '130528112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纪昌庄', 4, '130528', '130528202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北鱼', 4, '130528', '130528205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐家河', 4, '130528', '130528206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨鹿', 3, '1305', '130529', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨鹿镇', 4, '130529', '130529100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王虎寨', 4, '130529', '130529101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西郭城', 4, '130529', '130529102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官亭', 4, '130529', '130529103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎疃', 4, '130529', '130529104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小吕寨', 4, '130529', '130529105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家营', 4, '130529', '130529106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('观寨', 4, '130529', '130529107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堤村', 4, '130529', '130529200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张王疃', 4, '130529', '130529201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新河', 3, '1305', '130530', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新河镇', 4, '130530', '130530100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寻寨', 4, '130530', '130530101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白神首', 4, '130530', '130530200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荆家庄', 4, '130530', '130530201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西流', 4, '130530', '130530202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仁让里', 4, '130530', '130530203', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广宗', 3, '1305', '130531', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广宗镇', 4, '130531', '130531100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯家寨', 4, '130531', '130531101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北塘疃', 4, '130531', '130531102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('核桃园', 4, '130531', '130531103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葫芦', 4, '130531', '130531200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大平台', 4, '130531', '130531201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('件只', 4, '130531', '130531202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东召', 4, '130531', '130531204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平乡', 3, '1305', '130532', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰州', 4, '130532', '130532100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平乡镇', 4, '130532', '130532101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河古庙', 4, '130532', '130532102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('节固', 4, '130532', '130532200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('油召', 4, '130532', '130532201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田付村', 4, '130532', '130532202', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寻召', 4, '130532', '130532203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('威县', 3, '1305', '130533', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洺州', 4, '130533', '130533100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梨园屯', 4, '130533', '130533101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章台', 4, '130533', '130533102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯贯', 4, '130533', '130533103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七级', 4, '130533', '130533104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贺营', 4, '130533', '130533105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方家营', 4, '130533', '130533106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常庄', 4, '130533', '130533107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第什营', 4, '130533', '130533108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵村', 4, '130533', '130533109', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贺钊', 4, '130533', '130533110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固献', 4, '130533', '130533111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枣园', 4, '130533', '130533202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家营', 4, '130533', '130533206', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常屯', 4, '130533', '130533207', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高公庄', 4, '130533', '130533209', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河', 3, '1305', '130534', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛仙庄', 4, '130534', '130534100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连庄', 4, '130534', '130534101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('油坊', 4, '130534', '130534102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谢炉', 4, '130534', '130534103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王官庄', 4, '130534', '130534104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坝营', 4, '130534', '130534105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临西', 3, '1305', '130535', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临西镇', 4, '130535', '130535100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '130535', '130535101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下堡寺', 4, '130535', '130535102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尖冢', 4, '130535', '130535103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老官寨', 4, '130535', '130535104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吕寨', 4, '130535', '130535105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大刘庄', 4, '130535', '130535106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东枣园', 4, '130535', '130535200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('摇鞍镇', 4, '130535', '130535203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南宫', 3, '1305', '130581', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤岗', 4, '130581', '130581001', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南杜', 4, '130581', '130581002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北胡', 4, '130581', '130581003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西丁', 4, '130581', '130581004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏村', 4, '130581', '130581100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大高村', 4, '130581', '130581101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('垂杨', 4, '130581', '130581102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明化', 4, '130581', '130581103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段芦头', 4, '130581', '130581104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫冢', 4, '130581', '130581105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大村', 4, '130581', '130581200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南便村', 4, '130581', '130581201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '130581', '130581202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王道寨', 4, '130581', '130581203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛吴村', 4, '130581', '130581204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河', 3, '1305', '130582', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('褡裢', 4, '130582', '130582001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥东', 4, '130582', '130582002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥西', 4, '130582', '130582003', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赞善', 4, '130582', '130582004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周庄', 4, '130582', '130582005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '130582', '130582101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔', 4, '130582', '130582102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里亭', 4, '130582', '130582103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('綦村', 4, '130582', '130582104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河城', 4, '130582', '130582105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留村', 4, '130582', '130582106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('册井', 4, '130582', '130582201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘石岗', 4, '130582', '130582202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴关', 4, '130582', '130582203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蝉房', 4, '130582', '130582204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保定', 2, '13', '1306', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('竞秀', 3, '1306', '130602', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先锋', 4, '130602', '130602001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新市场', 4, '130602', '130602002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风路', 4, '130602', '130602003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建南', 4, '130602', '130602004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩北', 4, '130602', '130602005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大激店', 4, '130602', '130602100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('颉庄', 4, '130602', '130602200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富昌', 4, '130602', '130602201', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩村', 4, '130602', '130602202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南奇', 4, '130602', '130602203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大马坊', 4, '130602', '130602205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保定国家高新区', 4, '130602', '130602400', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲池', 3, '1306', '130606', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平里', 4, '130606', '130606001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五四路', 4, '130606', '130606002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西关', 4, '130606', '130606003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华路', 4, '130606', '130606004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东关', 4, '130606', '130606005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('联盟路', 4, '130606', '130606006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红星', 4, '130606', '130606007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕华', 4, '130606', '130606008', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永华', 4, '130606', '130606009', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南关', 4, '130606', '130606010', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百楼', 4, '130606', '130606100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩庄', 4, '130606', '130606200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东金庄', 4, '130606', '130606201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨庄', 4, '130606', '130606203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大园', 4, '130606', '130606204', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('焦庄', 4, '130606', '130606205', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五尧', 4, '130606', '130606206', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满城', 3, '1306', '130607', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满城镇', 4, '130607', '130607100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大册营', 4, '130607', '130607101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神星', 4, '130607', '130607102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南韩村', 4, '130607', '130607103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方顺桥', 4, '130607', '130607104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于家庄', 4, '130607', '130607105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('要庄', 4, '130607', '130607203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白龙', 4, '130607', '130607204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石井', 4, '130607', '130607205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坨南', 4, '130607', '130607206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家台', 4, '130607', '130607207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贤台', 4, '130607', '130607208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清苑', 3, '1306', '130608', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清苑镇', 4, '130608', '130608100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冉庄', 4, '130608', '130608101', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳城', 4, '130608', '130608102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏村', 4, '130608', '130608103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温仁', 4, '130608', '130608104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张登', 4, '130608', '130608105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大庄', 4, '130608', '130608106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('臧村', 4, '130608', '130608107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望亭', 4, '130608', '130608108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东闾', 4, '130608', '130608109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白团', 4, '130608', '130608200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北店', 4, '130608', '130608201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石桥', 4, '130608', '130608202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李庄', 4, '130608', '130608203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北王力', 4, '130608', '130608204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('何桥', 4, '130608', '130608206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙村', 4, '130608', '130608207', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎庄', 4, '130608', '130608208', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐水', 3, '1306', '130609', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安肃', 4, '130609', '130609100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔庄', 4, '130609', '130609101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大因', 4, '130609', '130609102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('遂城', 4, '130609', '130609103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高林村', 4, '130609', '130609104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王店', 4, '130609', '130609105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('漕河', 4, '130609', '130609106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留村', 4, '130609', '130609107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东史端', 4, '130609', '130609108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正村', 4, '130609', '130609109', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('户木', 4, '130609', '130609203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瀑河', 4, '130609', '130609204', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东釜山', 4, '130609', '130609205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义联庄', 4, '130609', '130609206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涞水', 3, '1306', '130623', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涞水镇', 4, '130623', '130623100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永阳', 4, '130623', '130623101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义安', 4, '130623', '130623102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石亭', 4, '130623', '130623103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵各庄', 4, '130623', '130623104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九龙', 4, '130623', '130623105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三坡', 4, '130623', '130623106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('一渡', 4, '130623', '130623107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娄村', 4, '130623', '130623108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王村', 4, '130623', '130623109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明义', 4, '130623', '130623110', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东文山', 4, '130623', '130623111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('其中口', 4, '130623', '130623205', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙门口', 4, '130623', '130623206', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡家庄', 4, '130623', '130623207', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜平', 3, '1306', '130624', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜平镇', 4, '130624', '130624100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉关', 4, '130624', '130624101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平阳', 4, '130624', '130624102', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城南庄', 4, '130624', '130624103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天生桥', 4, '130624', '130624104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王林口', 4, '130624', '130624105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('砂窝', 4, '130624', '130624106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北果园', 4, '130624', '130624107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台峪', 4, '130624', '130624202', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大台', 4, '130624', '130624203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史家寨', 4, '130624', '130624204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴王口', 4, '130624', '130624206', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下庄', 4, '130624', '130624207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('定兴', 3, '1306', '130626', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('定兴镇', 4, '130626', '130626100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固城', 4, '130626', '130626101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贤寓', 4, '130626', '130626102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北河', 4, '130626', '130626103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天宫寺', 4, '130626', '130626104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小朱庄', 4, '130626', '130626105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚村', 4, '130626', '130626106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨村', 4, '130626', '130626107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高里', 4, '130626', '130626108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('内章', 4, '130626', '130626109', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东落堡', 4, '130626', '130626200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家庄', 4, '130626', '130626202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖村', 4, '130626', '130626204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳卓', 4, '130626', '130626205', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北南蔡', 4, '130626', '130626208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李郁庄', 4, '130626', '130626209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐县', 3, '1306', '130627', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仁厚', 4, '130627', '130627100', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王京', 4, '130627', '130627101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高昌', 4, '130627', '130627102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北罗', 4, '130627', '130627103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白合', 4, '130627', '130627104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('军城', 4, '130627', '130627105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('川里', 4, '130627', '130627106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长古城', 4, '130627', '130627107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗庄', 4, '130627', '130627108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北店头', 4, '130627', '130627109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐家佐', 4, '130627', '130627110', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('都亭', 4, '130627', '130627201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南店头', 4, '130627', '130627202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雹水', 4, '130627', '130627205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大洋', 4, '130627', '130627206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迷城', 4, '130627', '130627207', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊角', 4, '130627', '130627209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门', 4, '130627', '130627210', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄石口', 4, '130627', '130627211', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('倒马关', 4, '130627', '130627212', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高阳', 3, '1306', '130628', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦华', 4, '130628', '130628001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞口', 4, '130628', '130628101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西演', 4, '130628', '130628102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邢家南', 4, '130628', '130628103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋庄', 4, '130628', '130628104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小王果庄', 4, '130628', '130628105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲口', 4, '130628', '130628106', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞家佐', 4, '130628', '130628107', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙化', 4, '130628', '130628204', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('容城', 3, '1306', '130629', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('容城镇', 4, '130629', '130629100', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小里', 4, '130629', '130629101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南张', 4, '130629', '130629102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河', 4, '130629', '130629103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晾马台', 4, '130629', '130629104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八于', 4, '130629', '130629200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾光', 4, '130629', '130629201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平王', 4, '130629', '130629203', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涞源', 3, '1306', '130630', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涞源镇', 4, '130630', '130630100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银坊', 4, '130630', '130630101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('走马驿', 4, '130630', '130630102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水堡', 4, '130630', '130630103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王安', 4, '130630', '130630104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白石山', 4, '130630', '130630106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南屯', 4, '130630', '130630107', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家庄', 4, '130630', '130630108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉坊', 4, '130630', '130630109', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北石佛', 4, '130630', '130630110', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南马庄', 4, '130630', '130630202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金家井', 4, '130630', '130630204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留家庄', 4, '130630', '130630205', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上庄', 4, '130630', '130630206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东团堡', 4, '130630', '130630207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔崖驿', 4, '130630', '130630208', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌龙沟', 4, '130630', '130630209', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望都', 3, '1306', '130631', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望都镇', 4, '130631', '130631100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固店', 4, '130631', '130631101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾村', 4, '130631', '130631102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中韩庄', 4, '130631', '130631103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寺庄', 4, '130631', '130631104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵庄', 4, '130631', '130631105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高岭', 4, '130631', '130631106', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑堡', 4, '130631', '130631202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安新', 3, '1306', '130632', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安新镇', 4, '130632', '130632100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王', 4, '130632', '130632101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三台', 4, '130632', '130632102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('端村', 4, '130632', '130632103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵北口', 4, '130632', '130632104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('同口', 4, '130632', '130632105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘李庄', 4, '130632', '130632106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安州', 4, '130632', '130632107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老河头', 4, '130632', '130632108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('圈头', 4, '130632', '130632200', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寨里', 4, '130632', '130632201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芦庄', 4, '130632', '130632202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('易县', 3, '1306', '130633', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('易州', 4, '130633', '130633100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁格庄', 4, '130633', '130633101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西陵', 4, '130633', '130633102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裴山', 4, '130633', '130633103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塘湖', 4, '130633', '130633104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狼牙山', 4, '130633', '130633105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('良岗', 4, '130633', '130633106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫荆关', 4, '130633', '130633107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高村', 4, '130633', '130633108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥头', 4, '130633', '130633200', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白马', 4, '130633', '130633201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('流井', 4, '130633', '130633202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高陌', 4, '130633', '130633204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大龙华', 4, '130633', '130633205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安格庄', 4, '130633', '130633206', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌云册', 4, '130633', '130633207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西山北', 4, '130633', '130633208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尉都', 4, '130633', '130633209', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独乐', 4, '130633', '130633210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七峪', 4, '130633', '130633211', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富岗', 4, '130633', '130633212', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坡仓', 4, '130633', '130633213', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛岗', 4, '130633', '130633214', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥家河', 4, '130633', '130633215', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘河净', 4, '130633', '130633216', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡家峪', 4, '130633', '130633217', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城司', 4, '130633', '130633218', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲阳', 3, '1306', '130634', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恒州', 4, '130634', '130634100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵山', 4, '130634', '130634101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕赵', 4, '130634', '130634102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊平', 4, '130634', '130634103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文德', 4, '130634', '130634104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晓林', 4, '130634', '130634105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邸村', 4, '130634', '130634106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐村', 4, '130634', '130634107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孝墓', 4, '130634', '130634108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('产德', 4, '130634', '130634109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下河', 4, '130634', '130634110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路庄子', 4, '130634', '130634200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庄窠', 4, '130634', '130634202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东旺', 4, '130634', '130634205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('党城', 4, '130634', '130634210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郎家庄', 4, '130634', '130634211', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('范家庄', 4, '130634', '130634212', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北台', 4, '130634', '130634213', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蠡县', 3, '1306', '130635', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蠡吾', 4, '130635', '130635100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留史', 4, '130635', '130635101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大百尺', 4, '130635', '130635102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛兴', 4, '130635', '130635103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北郭丹', 4, '130635', '130635104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万安', 4, '130635', '130635105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑园', 4, '130635', '130635106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南庄', 4, '130635', '130635107', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大曲堤', 4, '130635', '130635108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲍墟', 4, '130635', '130635109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小陈', 4, '130635', '130635110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林堡', 4, '130635', '130635201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北埝头', 4, '130635', '130635202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('顺平', 3, '1306', '130636', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲阳', 4, '130636', '130636100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高于铺', 4, '130636', '130636101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腰山', 4, '130636', '130636102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲上', 4, '130636', '130636103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神南', 4, '130636', '130636104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安阳', 4, '130636', '130636105', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白云', 4, '130636', '130636106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河口', 4, '130636', '130636202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台鱼', 4, '130636', '130636204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大悲', 4, '130636', '130636205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('博野', 3, '1306', '130637', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('博野镇', 4, '130637', '130637100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小店', 4, '130637', '130637101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('程委', 4, '130637', '130637102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东墟', 4, '130637', '130637103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北杨', 4, '130637', '130637104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东', 4, '130637', '130637105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南小王', 4, '130637', '130637106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雄县', 3, '1306', '130638', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雄州', 4, '130638', '130638100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昝岗', 4, '130638', '130638101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营', 4, '130638', '130638102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙湾', 4, '130638', '130638103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱各庄', 4, '130638', '130638104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('米家务', 4, '130638', '130638105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双堂', 4, '130638', '130638203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张岗', 4, '130638', '130638204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北沙口', 4, '130638', '130638205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涿州', 3, '1306', '130681', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塔', 4, '130681', '130681001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃园', 4, '130681', '130681002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清凉寺', 4, '130681', '130681003', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松林店', 4, '130681', '130681100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('码头', 4, '130681', '130681101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城坊', 4, '130681', '130681102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高官庄', 4, '130681', '130681103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百尺竿', 4, '130681', '130681104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东仙坡', 4, '130681', '130681105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义和庄', 4, '130681', '130681106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豆庄', 4, '130681', '130681107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刁窝', 4, '130681', '130681108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林家屯', 4, '130681', '130681109', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙家庄', 4, '130681', '130681204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开发区管理委员会', 4, '130681', '130681400', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('定州', 3, '1306', '130682', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城区', 4, '130682', '130682001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城区', 4, '130682', '130682002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城区', 4, '130682', '130682003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长安路', 4, '130682', '130682004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留早', 4, '130682', '130682100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清风店', 4, '130682', '130682101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞村', 4, '130682', '130682102', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('砖路', 4, '130682', '130682103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明月店', 4, '130682', '130682104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('叮咛店', 4, '130682', '130682105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东亭', 4, '130682', '130682106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大辛庄', 4, '130682', '130682107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东旺', 4, '130682', '130682108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高蓬', 4, '130682', '130682109', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邢邑', 4, '130682', '130682110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李亲顾', 4, '130682', '130682111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('子位', 4, '130682', '130682112', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('息冢', 4, '130682', '130682113', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周村', 4, '130682', '130682114', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开元', 4, '130682', '130682116', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东留春', 4, '130682', '130682203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('号头庄', 4, '130682', '130682204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家庄', 4, '130682', '130682205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大鹿庄', 4, '130682', '130682206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '130682', '130682208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安国', 3, '1306', '130683', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('药都', 4, '130683', '130683001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祁州路', 4, '130683', '130683002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伍仁桥', 4, '130683', '130683101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石佛', 4, '130683', '130683102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郑章', 4, '130683', '130683103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大五女', 4, '130683', '130683104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西伏落', 4, '130683', '130683105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '130683', '130683106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明官店', 4, '130683', '130683200', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南娄底', 4, '130683', '130683201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北段村', 4, '130683', '130683204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高碑店', 3, '1306', '130684', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '130684', '130684001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('军城', 4, '130684', '130684002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东盛', 4, '130684', '130684003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城', 4, '130684', '130684004', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴华', 4, '130684', '130684005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方官', 4, '130684', '130684100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '130684', '130684101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泗庄', 4, '130684', '130684102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛立庄', 4, '130684', '130684104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东马营', 4, '130684', '130684105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白沟', 4, '130684', '130684106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张六庄', 4, '130684', '130684107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖官营', 4, '130684', '130684108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛桥', 4, '130684', '130684109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家营', 4, '130684', '130684110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家口', 2, '13', '1307', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥东', 3, '1307', '130702', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗楼', 4, '130702', '130702001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利北路', 4, '130702', '130702002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五一路', 4, '130702', '130702003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花园街', 4, '130702', '130702004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工业路', 4, '130702', '130702005', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南站', 4, '130702', '130702006', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马路东', 4, '130702', '130702007', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚家庄', 4, '130702', '130702100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大仓盖', 4, '130702', '130702101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老鸦庄', 4, '130702', '130702102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东望山', 4, '130702', '130702200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥西', 3, '1307', '130703', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明德南街', 4, '130703', '130703001', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大境门', 4, '130703', '130703002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明德北', 4, '130703', '130703003', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华街', 4, '130703', '130703004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堡子里', 4, '130703', '130703005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南营坊', 4, '130703', '130703006', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工人新村', 4, '130703', '130703007', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东窑子', 4, '130703', '130703100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈家屯', 4, '130703', '130703101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚家房', 4, '130703', '130703104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宣化', 3, '1307', '130705', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天泰寺街', 4, '130705', '130705001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皇城', 4, '130705', '130705002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南关', 4, '130705', '130705003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大街', 4, '130705', '130705004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大北街', 4, '130705', '130705005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工业街', 4, '130705', '130705006', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建国街', 4, '130705', '130705007', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞家堡', 4, '130705', '130705100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洋河南', 4, '130705', '130705101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深井', 4, '130705', '130705102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崞村', 4, '130705', '130705103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾家营', 4, '130705', '130705104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('顾家营', 4, '130705', '130705105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙岭子', 4, '130705', '130705107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵川', 4, '130705', '130705108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江家屯', 4, '130705', '130705109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河子西', 4, '130705', '130705110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯家庙', 4, '130705', '130705112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('春光', 4, '130705', '130705201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家湾', 4, '130705', '130705203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔儿村', 4, '130705', '130705204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家堡', 4, '130705', '130705206', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下花园', 3, '1307', '130706', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城镇', 4, '130706', '130706001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('煤矿', 4, '130706', '130706002', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花园', 4, '130706', '130706200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛庄子', 4, '130706', '130706201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('定方水', 4, '130706', '130706202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段家堡', 4, '130706', '130706203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万全', 3, '1307', '130708', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孔家庄', 4, '130708', '130708100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万全镇', 4, '130708', '130708101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洗马林', 4, '130708', '130708102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭磊庄', 4, '130708', '130708103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('膳房堡', 4, '130708', '130708200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北新屯', 4, '130708', '130708201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宣平堡', 4, '130708', '130708202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高庙堡', 4, '130708', '130708203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧堡', 4, '130708', '130708204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安家堡', 4, '130708', '130708205', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北沙城', 4, '130708', '130708206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崇礼', 3, '1307', '130709', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西湾子街道', 4, '130709', '130709001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西湾子镇', 4, '130709', '130709100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家营', 4, '130709', '130709101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四台嘴', 4, '130709', '130709200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗营', 4, '130709', '130709201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石窑子', 4, '130709', '130709202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('驿马图', 4, '130709', '130709203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石嘴子', 4, '130709', '130709204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狮子沟', 4, '130709', '130709205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清三营', 4, '130709', '130709206', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白旗', 4, '130709', '130709207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张北', 3, '1307', '130722', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张北镇', 4, '130722', '130722100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公会', 4, '130722', '130722101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二台', 4, '130722', '130722102', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大囫囵', 4, '130722', '130722103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小二台', 4, '130722', '130722104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙沟', 4, '130722', '130722105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('油篓沟', 4, '130722', '130722106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河', 4, '130722', '130722107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台路沟', 4, '130722', '130722200', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('馒头营', 4, '130722', '130722202', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二泉井', 4, '130722', '130722203', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('单晶河', 4, '130722', '130722204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海流图', 4, '130722', '130722206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两面井', 4, '130722', '130722207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大西湾', 4, '130722', '130722208', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝家营', 4, '130722', '130722209', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白庙滩', 4, '130722', '130722210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('战海', 4, '130722', '130722212', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三号', 4, '130722', '130722213', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宇宙营', 4, '130722', '130722214', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康保', 3, '1307', '130723', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康保镇', 4, '130723', '130723100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张纪', 4, '130723', '130723101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土城子', 4, '130723', '130723102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邓油坊', 4, '130723', '130723103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家地', 4, '130723', '130723104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('照阳河', 4, '130723', '130723105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('屯垦', 4, '130723', '130723106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎油房', 4, '130723', '130723200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丹清河', 4, '130723', '130723201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈咇嘎', 4, '130723', '130723202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二号卜', 4, '130723', '130723203', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芦家营', 4, '130723', '130723204', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('忠义', 4, '130723', '130723205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('处长地', 4, '130723', '130723206', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满德堂', 4, '130723', '130723207', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康保牧场', 4, '130723', '130723500', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沽源', 3, '1307', '130724', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平定堡', 4, '130724', '130724100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小厂', 4, '130724', '130724101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄盖淖', 4, '130724', '130724102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九连城', 4, '130724', '130724103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高山堡', 4, '130724', '130724200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小河子', 4, '130724', '130724201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二道渠', 4, '130724', '130724202', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大二号', 4, '130724', '130724203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('闪电河', 4, '130724', '130724204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长梁', 4, '130724', '130724205', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰源店', 4, '130724', '130724206', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西辛营', 4, '130724', '130724207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲花滩', 4, '130724', '130724208', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白土窑', 4, '130724', '130724209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尚义', 3, '1307', '130725', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南壕堑', 4, '130725', '130725100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大青沟', 4, '130725', '130725101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八道沟', 4, '130725', '130725102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红土梁', 4, '130725', '130725103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小蒜沟', 4, '130725', '130725104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三工地', 4, '130725', '130725105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满井', 4, '130725', '130725106', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营盘', 4, '130725', '130725200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大苏计', 4, '130725', '130725201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石井', 4, '130725', '130725202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七甲', 4, '130725', '130725205', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('套里庄', 4, '130725', '130725206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甲石河', 4, '130725', '130725207', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下马圈', 4, '130725', '130725208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔚县', 3, '1307', '130726', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔚州', 4, '130726', '130726100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('代王城', 4, '130726', '130726101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西合营', 4, '130726', '130726102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉家庄', 4, '130726', '130726103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白乐', 4, '130726', '130726104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('暖泉', 4, '130726', '130726105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南留庄', 4, '130726', '130726106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北水泉', 4, '130726', '130726107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃花', 4, '130726', '130726108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳眷', 4, '130726', '130726109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋家庄', 4, '130726', '130726110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下宫村', 4, '130726', '130726200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南杨庄', 4, '130726', '130726202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏树', 4, '130726', '130726203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常宁', 4, '130726', '130726204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涌泉庄', 4, '130726', '130726205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨庄窠', 4, '130726', '130726206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南岭庄', 4, '130726', '130726207', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈家洼', 4, '130726', '130726208', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄梅', 4, '130726', '130726209', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白草村', 4, '130726', '130726210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草沟堡', 4, '130726', '130726211', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳原', 3, '1307', '130727', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '130727', '130727100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '130727', '130727101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化稍营', 4, '130727', '130727102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('揣骨疃', 4, '130727', '130727103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东井集', 4, '130727', '130727104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('要家庄', 4, '130727', '130727200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东坊城堡', 4, '130727', '130727201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('井儿沟', 4, '130727', '130727202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三马坊', 4, '130727', '130727203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高墙', 4, '130727', '130727204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大田洼', 4, '130727', '130727205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛堡', 4, '130727', '130727206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马圈堡', 4, '130727', '130727207', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浮图讲', 4, '130727', '130727208', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀安', 3, '1307', '130728', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴沟堡', 4, '130728', '130728100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左卫', 4, '130728', '130728101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头百户', 4, '130728', '130728102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀安城', 4, '130728', '130728103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渡口堡', 4, '130728', '130728200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第六屯', 4, '130728', '130728201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西湾堡', 4, '130728', '130728202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西沙城', 4, '130728', '130728203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平庄', 4, '130728', '130728204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王虎屯', 4, '130728', '130728205', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第三堡', 4, '130728', '130728206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀来', 3, '1307', '130730', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙城', 4, '130730', '130730100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北辛堡', 4, '130730', '130730101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新保安', 4, '130730', '130730102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东花园', 4, '130730', '130730103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官厅', 4, '130730', '130730104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑园', 4, '130730', '130730105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('存瑞', 4, '130730', '130730106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土木', 4, '130730', '130730107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大黄庄', 4, '130730', '130730108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西八里', 4, '130730', '130730109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小南辛堡', 4, '130730', '130730110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狼山', 4, '130730', '130730200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸡鸣驿', 4, '130730', '130730203', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东八里', 4, '130730', '130730205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瑞云观', 4, '130730', '130730207', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙庄子', 4, '130730', '130730208', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家楼', 4, '130730', '130730210', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涿鹿', 3, '1307', '130731', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涿鹿镇', 4, '130731', '130731100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家堡', 4, '130731', '130731101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武家沟', 4, '130731', '130731102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五堡', 4, '130731', '130731103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保岱', 4, '130731', '130731104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('矾山', 4, '130731', '130731105', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大堡', 4, '130731', '130731106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '130731', '130731107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东小庄', 4, '130731', '130731108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉屯', 4, '130731', '130731109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河南', 4, '130731', '130731110', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蟒石口', 4, '130731', '130731111', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辉耀', 4, '130731', '130731112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧佛寺', 4, '130731', '130731113', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栾庄', 4, '130731', '130731201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑山寺', 4, '130731', '130731204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谢家堡', 4, '130731', '130731206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤城', 3, '1307', '130732', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤城镇', 4, '130732', '130732100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田家窑', 4, '130732', '130732101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙关', 4, '130732', '130732102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雕鹗', 4, '130732', '130732103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独石口', 4, '130732', '130732104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白草', 4, '130732', '130732105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙门所', 4, '130732', '130732106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后城', 4, '130732', '130732107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东卯', 4, '130732', '130732108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('炮梁', 4, '130732', '130732200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大海陀', 4, '130732', '130732201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镇宁堡', 4, '130732', '130732202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马营', 4, '130732', '130732203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云州', 4, '130732', '130732204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道川', 4, '130732', '130732205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东万口', 4, '130732', '130732206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茨营子', 4, '130732', '130732207', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('样田', 4, '130732', '130732208', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('承德', 2, '13', '1308', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双桥', 3, '1308', '130802', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西大街', 4, '130802', '130802001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头道牌楼', 4, '130802', '130802002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潘家沟', 4, '130802', '130802003', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华路', 4, '130802', '130802004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华路', 4, '130802', '130802005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石洞子沟', 4, '130802', '130802006', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥东', 4, '130802', '130802007', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泉沟', 4, '130802', '130802100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狮子沟', 4, '130802', '130802101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛圈子沟', 4, '130802', '130802102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大石庙', 4, '130802', '130802103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯营子', 4, '130802', '130802104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双峰寺', 4, '130802', '130802105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上板城', 4, '130802', '130802106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('承德市高新技术开发区', 4, '130802', '130802401', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双滦', 3, '1308', '130803', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钢城', 4, '130803', '130803001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元宝山', 4, '130803', '130803002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秀水', 4, '130803', '130803003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塔山', 4, '130803', '130803100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦河', 4, '130803', '130803101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大庙', 4, '130803', '130803102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('偏桥子', 4, '130803', '130803103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西地', 4, '130803', '130803104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈栅子', 4, '130803', '130803105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹰手营子矿区', 3, '1308', '130804', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁北路', 4, '130804', '130804001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹰手营子', 4, '130804', '130804100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北马圈子', 4, '130804', '130804101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寿王坟', 4, '130804', '130804102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汪家庄', 4, '130804', '130804103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('承德县', 3, '1308', '130821', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下板城', 4, '130821', '130821100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甲山', 4, '130821', '130821102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六沟', 4, '130821', '130821103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三沟', 4, '130821', '130821104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头沟', 4, '130821', '130821105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高寺台', 4, '130821', '130821106', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三家', 4, '130821', '130821107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鞍匠', 4, '130821', '130821108', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上谷', 4, '130821', '130821109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磴上', 4, '130821', '130821110', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石灰窑', 4, '130821', '130821111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新杖子', 4, '130821', '130821112', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东小白旗', 4, '130821', '130821200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘杖子', 4, '130821', '130821202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟家院', 4, '130821', '130821204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营子', 4, '130821', '130821205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八家', 4, '130821', '130821206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满杖子', 4, '130821', '130821208', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五道河', 4, '130821', '130821210', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔沟', 4, '130821', '130821211', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岗子', 4, '130821', '130821212', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两家', 4, '130821', '130821214', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仓子', 4, '130821', '130821216', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 3, '1308', '130822', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆镇', 4, '130822', '130822100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('半壁山', 4, '130822', '130822101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('挂兰峪', 4, '130822', '130822102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青松岭', 4, '130822', '130822103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六道河', 4, '130822', '130822104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安堡', 4, '130822', '130822105', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北营房', 4, '130822', '130822106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤山子', 4, '130822', '130822107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓝旗营', 4, '130822', '130822108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雾灵山', 4, '130822', '130822109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家营', 4, '130822', '130822110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大杖子', 4, '130822', '130822111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道河', 4, '130822', '130822112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蘑菇峪', 4, '130822', '130822113', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大水泉', 4, '130822', '130822114', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南天门', 4, '130822', '130822200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八卦岭', 4, '130822', '130822202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陡子峪', 4, '130822', '130822203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上石洞', 4, '130822', '130822204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安子岭', 4, '130822', '130822211', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦平', 3, '1308', '130824', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中兴路', 4, '130824', '130824001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦平镇', 4, '130824', '130824100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长山峪', 4, '130824', '130824101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '130824', '130824102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金沟屯', 4, '130824', '130824103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虎什哈', 4, '130824', '130824104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴克什营', 4, '130824', '130824105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张百湾', 4, '130824', '130824106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('付营子', 4, '130824', '130824107', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '130824', '130824108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('火斗山', 4, '130824', '130824109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两间房', 4, '130824', '130824110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小营', 4, '130824', '130824111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平坊', 4, '130824', '130824200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安纯沟门', 4, '130824', '130824201', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西沟', 4, '130824', '130824206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邓厂', 4, '130824', '130824207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五道营子', 4, '130824', '130824208', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马营子', 4, '130824', '130824209', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('付家店', 4, '130824', '130824210', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆化', 3, '1308', '130825', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安州', 4, '130825', '130825001', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆化镇', 4, '130825', '130825100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩麻营', 4, '130825', '130825101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中关', 4, '130825', '130825102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七家', 4, '130825', '130825103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤头沟', 4, '130825', '130825104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张三营', 4, '130825', '130825105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐三营', 4, '130825', '130825106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓝旗', 4, '130825', '130825107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('步古沟', 4, '130825', '130825108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家屯', 4, '130825', '130825109', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茅荆坝', 4, '130825', '130825110', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荒地', 4, '130825', '130825200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章吉营', 4, '130825', '130825201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尹家营', 4, '130825', '130825203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庙子沟', 4, '130825', '130825204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('偏坡营', 4, '130825', '130825205', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山湾', 4, '130825', '130825206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八达营', 4, '130825', '130825207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平庄', 4, '130825', '130825208', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧屯', 4, '130825', '130825209', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西阿超', 4, '130825', '130825210', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碱房', 4, '130825', '130825212', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩家店', 4, '130825', '130825213', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湾沟门', 4, '130825', '130825214', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰宁', 3, '1308', '130826', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新丰路', 4, '130826', '130826001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大阁', 4, '130826', '130826100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大滩', 4, '130826', '130826101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鱼儿山', 4, '130826', '130826102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土城', 4, '130826', '130826103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄旗', 4, '130826', '130826104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤山', 4, '130826', '130826105', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('波罗诺', 4, '130826', '130826106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑山咀', 4, '130826', '130826107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天桥', 4, '130826', '130826108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡麻营', 4, '130826', '130826109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('将军营', 4, '130826', '130826110', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万胜永', 4, '130826', '130826200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四岔口', 4, '130826', '130826201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家店', 4, '130826', '130826202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('外沟门', 4, '130826', '130826203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草原', 4, '130826', '130826204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窟窿山', 4, '130826', '130826205', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小坝子', 4, '130826', '130826206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五道营', 4, '130826', '130826207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('选将营', 4, '130826', '130826209', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西官营', 4, '130826', '130826210', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王营', 4, '130826', '130826211', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北头营', 4, '130826', '130826212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石人沟', 4, '130826', '130826214', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤河', 4, '130826', '130826215', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨木栅子', 4, '130826', '130826216', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宽城', 3, '1308', '130827', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宽城镇', 4, '130827', '130827100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙须门', 4, '130827', '130827101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峪耳崖', 4, '130827', '130827102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('板城', 4, '130827', '130827103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤道河', 4, '130827', '130827104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桲罗台', 4, '130827', '130827105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碾子峪', 4, '130827', '130827106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亮甲台', 4, '130827', '130827107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化皮溜子', 4, '130827', '130827108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松岭', 4, '130827', '130827109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塌山', 4, '130827', '130827201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟子岭', 4, '130827', '130827203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独石沟', 4, '130827', '130827204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铧尖', 4, '130827', '130827207', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东黄花川', 4, '130827', '130827208', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇子沟', 4, '130827', '130827210', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大字沟门', 4, '130827', '130827211', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大石柱子', 4, '130827', '130827212', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('围场', 3, '1308', '130828', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('围场镇', 4, '130828', '130828100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四合永', 4, '130828', '130828101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克勒沟', 4, '130828', '130828102', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('棋盘山', 4, '130828', '130828103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('半截塔', 4, '130828', '130828104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳地', 4, '130828', '130828105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳湾', 4, '130828', '130828106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腰站', 4, '130828', '130828107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙头山', 4, '130828', '130828108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新拨', 4, '130828', '130828109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('御道口', 4, '130828', '130828110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城子', 4, '130828', '130828111', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道坝子', 4, '130828', '130828200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土坎', 4, '130828', '130828203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四道沟', 4, '130828', '130828204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓝旗卡伦', 4, '130828', '130828205', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银窝沟', 4, '130828', '130828206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新地', 4, '130828', '130828207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广发永', 4, '130828', '130828208', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('育太和', 4, '130828', '130828209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家湾', 4, '130828', '130828210', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家湾', 4, '130828', '130828211', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大唤起', 4, '130828', '130828212', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈里哈', 4, '130828', '130828213', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家湾', 4, '130828', '130828215', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝元栈', 4, '130828', '130828216', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山湾子', 4, '130828', '130828217', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三义永', 4, '130828', '130828218', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姜家店', 4, '130828', '130828219', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下伙房', 4, '130828', '130828220', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕格柏', 4, '130828', '130828221', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牌楼', 4, '130828', '130828222', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老窝铺', 4, '130828', '130828224', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石桌子', 4, '130828', '130828226', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大头山', 4, '130828', '130828227', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南山嘴', 4, '130828', '130828228', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西龙头', 4, '130828', '130828229', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塞罕坝机械林场', 4, '130828', '130828450', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国营御道口牧场', 4, '130828', '130828500', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平泉', 3, '1308', '130881', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平泉镇', 4, '130881', '130881100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土梁子', 4, '130881', '130881101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆树林子', 4, '130881', '130881102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨树岭', 4, '130881', '130881103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七沟', 4, '130881', '130881104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小寺沟', 4, '130881', '130881105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('党坝', 4, '130881', '130881106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧龙', 4, '130881', '130881109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南五十家子', 4, '130881', '130881110', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北五十家子', 4, '130881', '130881111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桲椤树', 4, '130881', '130881112', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳溪', 4, '130881', '130881113', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王土房', 4, '130881', '130881200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七家岱', 4, '130881', '130881203', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平北', 4, '130881', '130881204', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茅兰沟', 4, '130881', '130881206', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台头山', 4, '130881', '130881207', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松树台', 4, '130881', '130881209', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道虎沟', 4, '130881', '130881210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沧州', 2, '13', '1309', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 3, '1309', '130902', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设北街', 4, '130902', '130902001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('车站', 4, '130902', '130902002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大街', 4, '130902', '130902003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东环中街', 4, '130902', '130902004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道东', 4, '130902', '130902005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小赵庄', 4, '130902', '130902200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沧州开发区', 4, '130902', '130902400', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('运河', 3, '1309', '130903', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水月寺街', 4, '130903', '130903001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南环中路', 4, '130903', '130903002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南湖', 4, '130903', '130903003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('市场', 4, '130903', '130903004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西环中街', 4, '130903', '130903005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公园', 4, '130903', '130903006', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小王庄', 4, '130903', '130903100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南陈屯', 4, '130903', '130903101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沧县', 3, '1309', '130921', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧州', 4, '130921', '130921100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴济', 4, '130921', '130921101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜生', 4, '130921', '130921102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔尔庄', 4, '130921', '130921103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李天木', 4, '130921', '130921104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚官屯', 4, '130921', '130921105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纸房头', 4, '130921', '130921106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛官屯', 4, '130921', '130921200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('捷地', 4, '130921', '130921201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张官屯', 4, '130921', '130921202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('风化店', 4, '130921', '130921204', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜林', 4, '130921', '130921206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汪家铺', 4, '130921', '130921207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家庙', 4, '130921', '130921208', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仵龙堂', 4, '130921', '130921209', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大官厅', 4, '130921', '130921210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高川', 4, '130921', '130921211', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄递铺', 4, '130921', '130921212', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大褚村', 4, '130921', '130921213', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青县', 3, '1309', '130922', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清州', 4, '130922', '130922100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金牛', 4, '130922', '130922101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新兴', 4, '130922', '130922102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('流河', 4, '130922', '130922103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木门店', 4, '130922', '130922104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马厂', 4, '130922', '130922105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盘古', 4, '130922', '130922106', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹寺', 4, '130922', '130922107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上伍', 4, '130922', '130922200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈嘴', 4, '130922', '130922203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青县农场', 4, '130922', '130922400', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东光', 3, '1309', '130923', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东光镇', 4, '130923', '130923100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连镇', 4, '130923', '130923101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('找王', 4, '130923', '130923102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秦村', 4, '130923', '130923103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灯明寺', 4, '130923', '130923104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南霞口', 4, '130923', '130923105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大单', 4, '130923', '130923106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙王李', 4, '130923', '130923107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于桥', 4, '130923', '130923201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海兴', 3, '1309', '130924', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏基', 4, '130924', '130924100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛集', 4, '130924', '130924101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高湾', 4, '130924', '130924102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵毛陶', 4, '130924', '130924103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香坊', 4, '130924', '130924201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小山', 4, '130924', '130924202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张会亭', 4, '130924', '130924203', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海兴县农场', 4, '130924', '130924400', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青先农场', 4, '130924', '130924401', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青锋农场', 4, '130924', '130924402', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盐山', 3, '1309', '130925', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盐山镇', 4, '130925', '130925100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望树', 4, '130925', '130925101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庆云', 4, '130925', '130925102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩集', 4, '130925', '130925103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千童', 4, '130925', '130925104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('圣佛', 4, '130925', '130925105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('边务', 4, '130925', '130925106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小庄', 4, '130925', '130925107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨集', 4, '130925', '130925108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小营', 4, '130925', '130925201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟店', 4, '130925', '130925203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常庄', 4, '130925', '130925204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肃宁', 3, '1309', '130926', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肃宁镇', 4, '130926', '130926100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家村', 4, '130926', '130926101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窝北', 4, '130926', '130926102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尚村', 4, '130926', '130926103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万里', 4, '130926', '130926104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('师素', 4, '130926', '130926105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北留善寺', 4, '130926', '130926106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('付家佐', 4, '130926', '130926107', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邵庄', 4, '130926', '130926205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南皮', 3, '1309', '130927', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南皮镇', 4, '130927', '130927100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯家口', 4, '130927', '130927101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寨子', 4, '130927', '130927102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲍官屯', 4, '130927', '130927103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王寺', 4, '130927', '130927104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌马营', 4, '130927', '130927105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞灌', 4, '130927', '130927106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大浪淀', 4, '130927', '130927200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘八里', 4, '130927', '130927201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴桥', 3, '1309', '130928', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑园', 4, '130928', '130928100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁城', 4, '130928', '130928101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于集', 4, '130928', '130928102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁集', 4, '130928', '130928103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安陵', 4, '130928', '130928104', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹家洼', 4, '130928', '130928200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋门', 4, '130928', '130928201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家寺', 4, '130928', '130928202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沟店铺', 4, '130928', '130928203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('何庄', 4, '130928', '130928204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('献县', 3, '1309', '130929', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐寿', 4, '130929', '130929100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('淮镇', 4, '130929', '130929101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭庄', 4, '130929', '130929102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河城街', 4, '130929', '130929103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩村', 4, '130929', '130929104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陌南', 4, '130929', '130929105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈庄', 4, '130929', '130929106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段村', 4, '130929', '130929107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高官', 4, '130929', '130929108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十五级', 4, '130929', '130929109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('商林', 4, '130929', '130929206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('本斋', 4, '130929', '130929208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张村', 4, '130929', '130929209', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临河', 4, '130929', '130929210', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小平王', 4, '130929', '130929211', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('垒头', 4, '130929', '130929213', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南河头', 4, '130929', '130929214', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '130929', '130929215', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟村', 3, '1309', '130930', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟村镇', 4, '130930', '130930100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新县', 4, '130930', '130930101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛店', 4, '130930', '130930102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高寨', 4, '130930', '130930103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋庄子', 4, '130930', '130930200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛进庄', 4, '130930', '130930201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泊头', 3, '1309', '130981', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放', 4, '130981', '130981001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '130981', '130981002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼', 4, '130981', '130981003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泊镇', 4, '130981', '130981100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交河', 4, '130981', '130981101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐桥', 4, '130981', '130981102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寺门村', 4, '130981', '130981103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝村', 4, '130981', '130981104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富镇', 4, '130981', '130981105', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文庙', 4, '130981', '130981106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洼里王', 4, '130981', '130981107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四营', 4, '130981', '130981108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王武庄', 4, '130981', '130981201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营子', 4, '130981', '130981202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西辛店', 4, '130981', '130981204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('任丘', 3, '1309', '130982', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华路', 4, '130982', '130982001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西环路', 4, '130982', '130982002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永丰路', 4, '130982', '130982003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华路', 4, '130982', '130982004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('出岸', 4, '130982', '130982100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门桥', 4, '130982', '130982101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吕公堡', 4, '130982', '130982102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长丰', 4, '130982', '130982103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄚州', 4, '130982', '130982104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苟各庄', 4, '130982', '130982105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛中驿', 4, '130982', '130982106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁召', 4, '130982', '130982107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麻家坞', 4, '130982', '130982108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北辛庄', 4, '130982', '130982109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('议论堡', 4, '130982', '130982110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青塔', 4, '130982', '130982204', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七间房', 4, '130982', '130982206', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北汉', 4, '130982', '130982207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于村', 4, '130982', '130982208', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华北石油管理局', 4, '130982', '130982400', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开发区管理委员会', 4, '130982', '130982500', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄骅', 3, '1309', '130983', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('骅东', 4, '130983', '130983001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('骅中', 4, '130983', '130983002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('骅西', 4, '130983', '130983003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄骅镇', 4, '130983', '130983100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南排河', 4, '130983', '130983101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吕桥', 4, '130983', '130983102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧城', 4, '130983', '130983103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐家务', 4, '130983', '130983104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滕庄子', 4, '130983', '130983105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊二庄', 4, '130983', '130983106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常郭', 4, '130983', '130983107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官庄', 4, '130983', '130983204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新村', 4, '130983', '130983206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊三木', 4, '130983', '130983207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大港管理区', 4, '130983', '130983400', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国营中捷农场', 4, '130983', '130983401', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临港化工园区', 4, '130983', '130983403', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河间', 3, '1309', '130984', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瀛州路', 4, '130984', '130984001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城垣西路', 4, '130984', '130984002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('米各庄', 4, '130984', '130984101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景和', 4, '130984', '130984102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧佛堂', 4, '130984', '130984103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('束城', 4, '130984', '130984104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留古寺', 4, '130984', '130984105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河桥', 4, '130984', '130984106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('诗经村', 4, '130984', '130984107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尊祖庄', 4, '130984', '130984108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴村', 4, '130984', '130984109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('行别营', 4, '130984', '130984110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('故仙', 4, '130984', '130984111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黎民居', 4, '130984', '130984201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙洼', 4, '130984', '130984203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西九吉', 4, '130984', '130984204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北石槽', 4, '130984', '130984205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('果子洼', 4, '130984', '130984206', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('时村', 4, '130984', '130984209', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙华店', 4, '130984', '130984212', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('廊坊', 2, '13', '1310', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安次', 3, '1310', '131002', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银河南路', 4, '131002', '131002001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明西道', 4, '131002', '131002002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永华道', 4, '131002', '131002003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('落垡', 4, '131002', '131002100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('码头', 4, '131002', '131002101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛渔城', 4, '131002', '131002102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东沽港', 4, '131002', '131002103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨税务', 4, '131002', '131002104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北史家务', 4, '131002', '131002105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('调河头', 4, '131002', '131002106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仇庄', 4, '131002', '131002107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广阳', 3, '1310', '131003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银河北路', 4, '131003', '131003001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('爱民东道', 4, '131003', '131003002', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放道', 4, '131003', '131003003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开路', 4, '131003', '131003004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新源道', 4, '131003', '131003005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南尖塔', 4, '131003', '131003100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万庄', 4, '131003', '131003101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九州', 4, '131003', '131003102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北旺', 4, '131003', '131003103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('廊坊经济技术开发区', 4, '131003', '131003450', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固安', 3, '1310', '131022', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固安镇', 4, '131022', '131022100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宫村', 4, '131022', '131022101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳泉', 4, '131022', '131022102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛驼', 4, '131022', '131022103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马庄', 4, '131022', '131022104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东湾', 4, '131022', '131022105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渠沟', 4, '131022', '131022106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭村', 4, '131022', '131022201', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('礼让店', 4, '131022', '131022203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永清', 3, '1310', '131023', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城区', 4, '131023', '131023001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永清镇', 4, '131023', '131023100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩村', 4, '131023', '131023101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后弈', 4, '131023', '131023102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('别古庄', 4, '131023', '131023103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里澜城', 4, '131023', '131023104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('管家务', 4, '131023', '131023200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹家务', 4, '131023', '131023201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙虎庄', 4, '131023', '131023202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘街', 4, '131023', '131023203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三圣口', 4, '131023', '131023204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香河', 3, '1310', '131024', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('淑阳', 4, '131024', '131024100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒋辛屯', 4, '131024', '131024101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渠口', 4, '131024', '131024102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安头屯', 4, '131024', '131024103', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安平', 4, '131024', '131024104', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘宋', 4, '131024', '131024105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五百户', 4, '131024', '131024106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钳屯', 4, '131024', '131024107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钱旺', 4, '131024', '131024108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大城', 3, '1310', '131025', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平舒', 4, '131025', '131025100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旺村', 4, '131025', '131025101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大尚屯', 4, '131025', '131025102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南赵扶', 4, '131025', '131025103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留各庄', 4, '131025', '131025104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('权村', 4, '131025', '131025105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里坦', 4, '131025', '131025106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广安', 4, '131025', '131025107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北魏', 4, '131025', '131025108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('臧屯', 4, '131025', '131025109', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('摩配园区管委会', 4, '131025', '131025400', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文安', 3, '1310', '131026', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文安镇', 4, '131026', '131026100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新镇', 4, '131026', '131026101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏桥', 4, '131026', '131026102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大柳河', 4, '131026', '131026103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左各庄', 4, '131026', '131026104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滩里', 4, '131026', '131026105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史各庄', 4, '131026', '131026106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵各庄', 4, '131026', '131026107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆宫', 4, '131026', '131026108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大留镇', 4, '131026', '131026109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙氏', 4, '131026', '131026110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德归', 4, '131026', '131026111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大围河', 4, '131026', '131026200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大厂', 3, '1310', '131028', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大厂镇', 4, '131028', '131028100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏垫', 4, '131028', '131028101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祁各庄', 4, '131028', '131028102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈府', 4, '131028', '131028103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邵府', 4, '131028', '131028104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霸州', 3, '1310', '131081', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裕华', 4, '131081', '131081001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霸州镇', 4, '131081', '131081100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南孟', 4, '131081', '131081101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('信安', 4, '131081', '131081102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堂二里', 4, '131081', '131081103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('煎茶铺', 4, '131081', '131081104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜芳', 4, '131081', '131081105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扬芬港', 4, '131081', '131081106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康仙庄', 4, '131081', '131081107', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王庄子', 4, '131081', '131081108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔河集', 4, '131081', '131081200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东杨庄', 4, '131081', '131081202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东段', 4, '131081', '131081204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三河', 3, '1310', '131082', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼎盛东', 4, '131082', '131082001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泃阳西', 4, '131082', '131082002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泃阳', 4, '131082', '131082100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李旗庄', 4, '131082', '131082101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨庄', 4, '131082', '131082102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皇庄', 4, '131082', '131082103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新集', 4, '131082', '131082104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段甲岭', 4, '131082', '131082105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土庄', 4, '131082', '131082106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高楼', 4, '131082', '131082107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐心庄', 4, '131082', '131082108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕郊', 4, '131082', '131082109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕郊经济技术开发区', 4, '131082', '131082450', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('衡水', 2, '13', '1311', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃城', 3, '1311', '131102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '131102', '131102001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '131102', '131102002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路北', 4, '131102', '131102003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华大街', 4, '131102', '131102004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郑家河沿', 4, '131102', '131102100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵家圈', 4, '131102', '131102101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邓庄', 4, '131102', '131102102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('何家庄', 4, '131102', '131102200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大麻森', 4, '131102', '131102201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彭杜村', 4, '131102', '131102203', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('衡水高新技术产业开发区', 4, '131102', '131102400', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('衡水湖自然保护区管理处', 4, '131102', '131102401', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冀州', 3, '1311', '131103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冀州镇', 4, '131103', '131103100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官道李', 4, '131103', '131103101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南午村', 4, '131103', '131103102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周村', 4, '131103', '131103103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('码头李', 4, '131103', '131103104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西王', 4, '131103', '131103105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏家屯', 4, '131103', '131103107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('门家庄', 4, '131103', '131103200', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐家庄', 4, '131103', '131103201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北漳淮', 4, '131103', '131103202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小寨', 4, '131103', '131103203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枣强', 3, '1311', '131121', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枣强镇', 4, '131121', '131121100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恩察', 4, '131121', '131121101', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营', 4, '131121', '131121102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘉会', 4, '131121', '131121103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马屯', 4, '131121', '131121104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖张', 4, '131121', '131121105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张秀屯', 4, '131121', '131121106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新屯', 4, '131121', '131121107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐林', 4, '131121', '131121108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王均', 4, '131121', '131121202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王常', 4, '131121', '131121204', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武邑', 3, '1311', '131122', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武邑镇', 4, '131122', '131122100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清凉店', 4, '131122', '131122101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('审坡', 4, '131122', '131122102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵桥', 4, '131122', '131122103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩庄', 4, '131122', '131122104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖桥头', 4, '131122', '131122105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙店', 4, '131122', '131122106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('圈头', 4, '131122', '131122201', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大紫塔', 4, '131122', '131122203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武强', 3, '1311', '131123', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武强镇', 4, '131123', '131123100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('街关', 4, '131123', '131123101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周窝', 4, '131123', '131123102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东孙庄', 4, '131123', '131123103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豆村', 4, '131123', '131123104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北代', 4, '131123', '131123201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('饶阳', 3, '1311', '131124', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('饶阳镇', 4, '131124', '131124100', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大尹村', 4, '131124', '131124101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五公', 4, '131124', '131124102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大官亭', 4, '131124', '131124103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王同岳', 4, '131124', '131124104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东里满', 4, '131124', '131124105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留楚', 4, '131124', '131124106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安平', 3, '1311', '131125', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安平镇', 4, '131125', '131125100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马店', 4, '131125', '131125101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南王庄', 4, '131125', '131125102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大子文', 4, '131125', '131125103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东黄城', 4, '131125', '131125104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大何庄', 4, '131125', '131125200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('程油子', 4, '131125', '131125201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西两洼', 4, '131125', '131125202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('故城', 3, '1311', '131126', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郑口', 4, '131126', '131126100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏庄', 4, '131126', '131126101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青罕', 4, '131126', '131126102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('故城镇', 4, '131126', '131126103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武官寨', 4, '131126', '131126104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('饶阳店', 4, '131126', '131126105', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('军屯', 4, '131126', '131126106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建国', 4, '131126', '131126107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西半屯', 4, '131126', '131126108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('房庄', 4, '131126', '131126109', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三朗', 4, '131126', '131126110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛庄', 4, '131126', '131126200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里老', 4, '131126', '131126201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景县', 3, '1311', '131127', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景州', 4, '131127', '131127100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙华', 4, '131127', '131127101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广川', 4, '131127', '131127102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王瞳', 4, '131127', '131127103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洚河流', 4, '131127', '131127104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安陵', 4, '131127', '131127105', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜桥', 4, '131127', '131127106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王谦寺', 4, '131127', '131127107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留智庙', 4, '131127', '131127108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北留智', 4, '131127', '131127109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁集', 4, '131127', '131127110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘集', 4, '131127', '131127200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连镇', 4, '131127', '131127201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温城', 4, '131127', '131127203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后留名府', 4, '131127', '131127204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青兰', 4, '131127', '131127205', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜城', 3, '1311', '131128', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜城镇', 4, '131128', '131128100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '131128', '131128101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('码头', 4, '131128', '131128102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霞口', 4, '131128', '131128103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔家庙', 4, '131128', '131128104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('漫河', 4, '131128', '131128105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建桥', 4, '131128', '131128201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒋坊', 4, '131128', '131128202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大白', 4, '131128', '131128203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王集', 4, '131128', '131128204', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深州', 3, '1311', '131182', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐奉', 4, '131182', '131182100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深州镇', 4, '131182', '131182101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辰时', 4, '131182', '131182102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆科', 4, '131182', '131182103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏家桥', 4, '131182', '131182104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大堤', 4, '131182', '131182105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前磨头', 4, '131182', '131182106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家井', 4, '131182', '131182107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('护驾迟', 4, '131182', '131182108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '131182', '131182109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高古庄', 4, '131182', '131182110', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北溪村', 4, '131182', '131182111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大冯营', 4, '131182', '131182112', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兵曹', 4, '131182', '131182200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('穆村', 4, '131182', '131182201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东安庄', 4, '131182', '131182202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乔屯', 4, '131182', '131182206', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山西', 1, '0', '14', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太原', 2, '14', '1401', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小店', 3, '1401', '140105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坞城', 4, '140105', '140105001', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营盘', 4, '140105', '140105002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北营', 4, '140105', '140105003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平阳路', 4, '140105', '140105004', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄陵', 4, '140105', '140105005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小店街道', 4, '140105', '140105006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙城', 4, '140105', '140105007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北格', 4, '140105', '140105100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西温庄', 4, '140105', '140105200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家堡', 4, '140105', '140105201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太原高新技术产业开发区', 4, '140105', '140105401', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太原经济技术开发区', 4, '140105', '140105501', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎泽', 3, '1401', '140106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳巷', 4, '140106', '140106001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文庙', 4, '140106', '140106002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庙前', 4, '140106', '140106003', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎泽街道', 4, '140106', '140106004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥东', 4, '140106', '140106005', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老军营', 4, '140106', '140106006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝庄', 4, '140106', '140106100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏花岭', 3, '1401', '140107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨轮', 4, '140107', '140107001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三桥', 4, '140107', '140107002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼', 4, '140107', '140107003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏花岭街道', 4, '140107', '140107004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坝陵桥', 4, '140107', '140107005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大东关', 4, '140107', '140107006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('职工新街', 4, '140107', '140107007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敦化坊', 4, '140107', '140107008', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涧河', 4, '140107', '140107009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家峪', 4, '140107', '140107010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中涧河', 4, '140107', '140107100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尖草坪', 3, '1401', '140108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尖草坪街道', 4, '140108', '140108001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光社', 4, '140108', '140108002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上兰', 4, '140108', '140108003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南寨', 4, '140108', '140108004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎新', 4, '140108', '140108005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '140108', '140108006', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汇丰', 4, '140108', '140108007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴村', 4, '140108', '140108008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '140108', '140108009', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '140108', '140108100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳曲', 4, '140108', '140108101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏板', 4, '140108', '140108201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西墕', 4, '140108', '140108202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万柏林', 3, '1401', '140109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千峰', 4, '140109', '140109001', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下元', 4, '140109', '140109002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '140109', '140109003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴华', 4, '140109', '140109004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万柏林街道', 4, '140109', '140109005', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜儿坪', 4, '140109', '140109006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白家庄', 4, '140109', '140109007', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南寒', 4, '140109', '140109008', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西铭', 4, '140109', '140109009', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小井峪', 4, '140109', '140109010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东社', 4, '140109', '140109012', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长风西街', 4, '140109', '140109014', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神堂沟', 4, '140109', '140109015', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王化', 4, '140109', '140109016', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋源', 3, '1401', '140110', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义井', 4, '140110', '140110001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗城', 4, '140110', '140110002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋源街道', 4, '140110', '140110003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金胜', 4, '140110', '140110100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋祠', 4, '140110', '140110101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚村', 4, '140110', '140110102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清徐', 3, '1401', '140121', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清源', 4, '140121', '140121100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐沟', 4, '140121', '140121101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东于', 4, '140121', '140121102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟封', 4, '140121', '140121103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马峪', 4, '140121', '140121200', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳杜', 4, '140121', '140121201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西谷', 4, '140121', '140121202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王答', 4, '140121', '140121203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('集义', 4, '140121', '140121204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳曲', 3, '1401', '140122', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄寨', 4, '140122', '140122100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大盂', 4, '140122', '140122101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东黄水', 4, '140122', '140122102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泥屯', 4, '140122', '140122103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高村', 4, '140122', '140122200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯村', 4, '140122', '140122201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌井店', 4, '140122', '140122202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西凌井', 4, '140122', '140122203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨兴', 4, '140122', '140122205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娄烦', 3, '1401', '140123', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娄烦镇', 4, '140123', '140123100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('静游', 4, '140123', '140123101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜交曲', 4, '140123', '140123102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家庄', 4, '140123', '140123201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盖家庄', 4, '140123', '140123202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('米峪镇', 4, '140123', '140123203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天池店', 4, '140123', '140123204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古交', 3, '1401', '140181', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东曲', 4, '140181', '140181001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西曲', 4, '140181', '140181002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃园', 4, '140181', '140181003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('屯兰', 4, '140181', '140181004', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河口', 4, '140181', '140181100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镇城底', 4, '140181', '140181101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马兰', 4, '140181', '140181102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘉乐泉', 4, '140181', '140181201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梭峪', 4, '140181', '140181202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔口', 4, '140181', '140181203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常安', 4, '140181', '140181204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('原相', 4, '140181', '140181205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邢家社', 4, '140181', '140181206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大同', 2, '14', '1402', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新荣', 3, '1402', '140212', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新荣镇', 4, '140212', '140212100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古店', 4, '140212', '140212101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花园屯', 4, '140212', '140212102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('破鲁堡', 4, '140212', '140212200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家窑', 4, '140212', '140212202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西村', 4, '140212', '140212206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堡子湾', 4, '140212', '140212209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平城', 3, '1402', '140213', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泊寺', 4, '140213', '140213013', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新旺', 4, '140213', '140213201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马军营', 4, '140213', '140213205', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云冈', 3, '1402', '140214', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高山', 4, '140214', '140214101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云冈镇', 4, '140214', '140214102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('口泉', 4, '140214', '140214200', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西韩岭', 4, '140214', '140214206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平旺', 4, '140214', '140214207', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸦儿崖', 4, '140214', '140214210', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云州', 3, '1402', '140215', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西坪', 4, '140215', '140215100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('倍加造', 4, '140215', '140215101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周士庄', 4, '140215', '140215102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉家庄', 4, '140215', '140215201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峰峪', 4, '140215', '140215202', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜庄', 4, '140215', '140215204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('党留庄', 4, '140215', '140215205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('聚乐', 4, '140215', '140215209', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('许堡', 4, '140215', '140215211', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳高', 3, '1402', '140221', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉', 4, '140221', '140221100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗文皂', 4, '140221', '140221101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大白登', 4, '140221', '140221102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王官屯', 4, '140221', '140221103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '140221', '140221104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东小村', 4, '140221', '140221105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友宰', 4, '140221', '140221106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长城', 4, '140221', '140221201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狮子屯', 4, '140221', '140221204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下深井', 4, '140221', '140221209', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鳌石', 4, '140221', '140221212', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天镇', 3, '1402', '140222', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉泉', 4, '140222', '140222100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谷前堡', 4, '140222', '140222101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('米薪关', 4, '140222', '140222102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('逯家湾', 4, '140222', '140222103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新平堡', 4, '140222', '140222104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三十里铺', 4, '140222', '140222200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾家屯', 4, '140222', '140222204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵家沟', 4, '140222', '140222206', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南高崖', 4, '140222', '140222208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张西河', 4, '140222', '140222209', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家皂', 4, '140222', '140222210', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广灵', 3, '1402', '140223', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('壶泉', 4, '140223', '140223100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南村', 4, '140223', '140223101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁庄', 4, '140223', '140223102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('加斗', 4, '140223', '140223103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('作疃', 4, '140223', '140223104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('一斗泉', 4, '140223', '140223200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蕉山', 4, '140223', '140223202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宜兴', 4, '140223', '140223206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵丘', 3, '1402', '140224', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武灵', 4, '140224', '140224100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东河南', 4, '140224', '140224101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上寨', 4, '140224', '140224102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('落水河', 4, '140224', '140224200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵北', 4, '140224', '140224205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石家田', 4, '140224', '140224206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳科', 4, '140224', '140224207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白崖台', 4, '140224', '140224208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红石塄', 4, '140224', '140224210', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下关', 4, '140224', '140224212', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独峪', 4, '140224', '140224213', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浑源', 3, '1402', '140225', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安', 4, '140225', '140225100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西坊城', 4, '140225', '140225101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡村', 4, '140225', '140225102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙圪坨', 4, '140225', '140225103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王庄堡', 4, '140225', '140225104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青磁窑', 4, '140225', '140225106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东坊城', 4, '140225', '140225201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裴村', 4, '140225', '140225203', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('驼峰', 4, '140225', '140225204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西留村', 4, '140225', '140225205', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下韩村', 4, '140225', '140225206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南榆林', 4, '140225', '140225208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴城', 4, '140225', '140225210', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大仁庄', 4, '140225', '140225213', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千佛岭', 4, '140225', '140225215', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官儿', 4, '140225', '140225218', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左云', 3, '1402', '140226', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云兴', 4, '140226', '140226100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹊儿山', 4, '140226', '140226101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('店湾', 4, '140226', '140226102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('管家堡', 4, '140226', '140226200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家场', 4, '140226', '140226201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三屯', 4, '140226', '140226205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马道头', 4, '140226', '140226206', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小京庄', 4, '140226', '140226207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳泉', 2, '14', '1403', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城区', 3, '1403', '140302', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上站', 4, '140302', '140302001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下站', 4, '140302', '140302002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北大街', 4, '140302', '140302003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南山路', 4, '140302', '140302004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义井', 4, '140302', '140302005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('矿区', 3, '1403', '140303', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平潭街', 4, '140303', '140303001', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥头', 4, '140303', '140303002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡洼', 4, '140303', '140303003', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛鱼', 4, '140303', '140303004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙坪', 4, '140303', '140303005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贵石沟', 4, '140303', '140303006', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郊区', 3, '1403', '140311', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荫营', 4, '140311', '140311100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河底', 4, '140311', '140311101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义井', 4, '140311', '140311102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平坦', 4, '140311', '140311103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西南舁', 4, '140311', '140311200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家庄', 4, '140311', '140311201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家庄', 4, '140311', '140311202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧街', 4, '140311', '140311203', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开发区', 4, '140311', '140311400', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平定', 3, '1403', '140321', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冠山', 4, '140321', '140321100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冶西', 4, '140321', '140321101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锁簧', 4, '140321', '140321102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张庄', 4, '140321', '140321103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东回', 4, '140321', '140321104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏井', 4, '140321', '140321105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娘子关', 4, '140321', '140321106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨城', 4, '140321', '140321107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门口', 4, '140321', '140321200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔口', 4, '140321', '140321201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盂县', 3, '1403', '140322', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秀水', 4, '140322', '140322100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙家庄', 4, '140322', '140322101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路家村', 4, '140322', '140322102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南娄', 4, '140322', '140322103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛村', 4, '140322', '140322104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苌池', 4, '140322', '140322105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上社', 4, '140322', '140322106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西烟', 4, '140322', '140322107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仙人', 4, '140322', '140322200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北下庄', 4, '140322', '140322201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家寨', 4, '140322', '140322203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西潘', 4, '140322', '140322204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东梁', 4, '140322', '140322205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长治', 2, '14', '1404', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞州', 3, '1404', '140403', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东街', 4, '140403', '140403001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西街', 4, '140403', '140403002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英雄南路', 4, '140403', '140403003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英雄中路', 4, '140403', '140403004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫金街', 4, '140403', '140403005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太行东街', 4, '140403', '140403006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太行西街', 4, '140403', '140403007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延安南路', 4, '140403', '140403008', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常青', 4, '140403', '140403009', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五马', 4, '140403', '140403010', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堠北庄', 4, '140403', '140403013', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老顶山', 4, '140403', '140403014', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大辛庄', 4, '140403', '140403015', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马厂', 4, '140403', '140403103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄碾', 4, '140403', '140403104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西白兔', 4, '140403', '140403105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上党', 3, '1404', '140404', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩店', 4, '140404', '140404001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏店', 4, '140404', '140404101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荫城', 4, '140404', '140404102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西火', 4, '140404', '140404103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八义', 4, '140404', '140404104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝家庄', 4, '140404', '140404106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西池', 4, '140404', '140404201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北呈', 4, '140404', '140404202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东和', 4, '140404', '140404203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南宋', 4, '140404', '140404205', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('屯留', 3, '1404', '140405', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麟绛', 4, '140405', '140405001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上村', 4, '140405', '140405101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渔泽', 4, '140405', '140405102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('余吾', 4, '140405', '140405103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吾元', 4, '140405', '140405104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张店', 4, '140405', '140405105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰宜', 4, '140405', '140405106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李高', 4, '140405', '140405200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路村', 4, '140405', '140405201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河神庙', 4, '140405', '140405202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞城', 3, '1404', '140406', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞华', 4, '140406', '140406001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成家川', 4, '140406', '140406002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翟店', 4, '140406', '140406004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('店上', 4, '140406', '140406100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('微子', 4, '140406', '140406101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛安泉', 4, '140406', '140406102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史回', 4, '140406', '140406104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄牛蹄', 4, '140406', '140406201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('襄垣', 3, '1404', '140423', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古韩', 4, '140423', '140423100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王桥', 4, '140423', '140423101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯堡', 4, '140423', '140423102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏店', 4, '140423', '140423103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虒亭', 4, '140423', '140423104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西营', 4, '140423', '140423105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王村', 4, '140423', '140423106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下良', 4, '140423', '140423107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('善福', 4, '140423', '140423109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平顺', 3, '1404', '140425', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青羊', 4, '140425', '140425100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙溪', 4, '140425', '140425101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石城', 4, '140425', '140425102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苗庄', 4, '140425', '140425103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉峡关', 4, '140425', '140425106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西沟', 4, '140425', '140425200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东寺头', 4, '140425', '140425201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虹梯关', 4, '140425', '140425202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳高', 4, '140425', '140425203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北耽车', 4, '140425', '140425204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北社', 4, '140425', '140425206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黎城', 3, '1404', '140426', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东阳关', 4, '140426', '140426101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上遥', 4, '140426', '140426102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西井', 4, '140426', '140426103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄崖洞', 4, '140426', '140426104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黎侯', 4, '140426', '140426105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪井', 4, '140426', '140426106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西仵', 4, '140426', '140426107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('程家山', 4, '140426', '140426108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('壶关', 3, '1404', '140427', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉', 4, '140427', '140427100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百尺', 4, '140427', '140427101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('店上', 4, '140427', '140427102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋庄', 4, '140427', '140427103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('树掌', 4, '140427', '140427104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大峡谷', 4, '140427', '140427105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('集店', 4, '140427', '140427108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄山', 4, '140427', '140427201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东井岭', 4, '140427', '140427202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石坡', 4, '140427', '140427203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长子', 3, '1404', '140428', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丹朱', 4, '140428', '140428100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲍店', 4, '140428', '140428101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石哲', 4, '140428', '140428102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大堡头', 4, '140428', '140428103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('慈林', 4, '140428', '140428104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('色头', 4, '140428', '140428105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南漳', 4, '140428', '140428106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋村', 4, '140428', '140428108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南陈', 4, '140428', '140428109', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碾张', 4, '140428', '140428201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常张', 4, '140428', '140428202', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武乡', 3, '1404', '140429', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰州', 4, '140429', '140429100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪水', 4, '140429', '140429101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蟠龙', 4, '140429', '140429102', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('监漳', 4, '140429', '140429103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('故城', 4, '140429', '140429104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩北', 4, '140429', '140429107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大有', 4, '140429', '140429202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾豁', 4, '140429', '140429203', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上司', 4, '140429', '140429205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石北', 4, '140429', '140429206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涌泉', 4, '140429', '140429207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('分水岭', 4, '140429', '140429208', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沁县', 3, '1404', '140430', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('定昌', 4, '140430', '140430100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭村', 4, '140430', '140430101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('故县', 4, '140430', '140430102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新店', 4, '140430', '140430103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('漳源', 4, '140430', '140430104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('册村', 4, '140430', '140430105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沁州黄', 4, '140430', '140430107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南里', 4, '140430', '140430108', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松村', 4, '140430', '140430109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛寺', 4, '140430', '140430203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨安', 4, '140430', '140430206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沁源', 3, '1404', '140431', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沁河', 4, '140431', '140431100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵空山', 4, '140431', '140431102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王和', 4, '140431', '140431103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王陶', 4, '140431', '140431105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景凤', 4, '140431', '140431107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭道', 4, '140431', '140431108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中峪', 4, '140431', '140431200', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('法中', 4, '140431', '140431201', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交口', 4, '140431', '140431202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('聪子峪', 4, '140431', '140431203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩洪', 4, '140431', '140431204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤石桥', 4, '140431', '140431207', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋城', 2, '14', '1405', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城区', 3, '1405', '140502', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东街', 4, '140502', '140502001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西街', 4, '140502', '140502002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南街', 4, '140502', '140502003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北街', 4, '140502', '140502004', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钟家庄', 4, '140502', '140502006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西上庄', 4, '140502', '140502007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开发区', 4, '140502', '140502009', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北石店', 4, '140502', '140502100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沁水', 3, '1405', '140521', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙港', 4, '140521', '140521100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中村', 4, '140521', '140521101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郑庄', 4, '140521', '140521102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('端氏', 4, '140521', '140521103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘉峰', 4, '140521', '140521104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郑村', 4, '140521', '140521105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柿庄', 4, '140521', '140521106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土沃', 4, '140521', '140521201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张村', 4, '140521', '140521202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡底', 4, '140521', '140521204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固县', 4, '140521', '140521205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里', 4, '140521', '140521206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳城', 3, '1405', '140522', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤城', 4, '140522', '140522100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北留', 4, '140522', '140522101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('润城', 4, '140522', '140522102', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('町店', 4, '140522', '140522103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芹池', 4, '140522', '140522104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('次营', 4, '140522', '140522105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横河', 4, '140522', '140522106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 4, '140522', '140522107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蟒河', 4, '140522', '140522108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东冶', 4, '140522', '140522109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白桑', 4, '140522', '140522113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('演礼', 4, '140522', '140522114', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寺头', 4, '140522', '140522201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西河', 4, '140522', '140522202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('董封', 4, '140522', '140522205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陵川', 3, '1405', '140524', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崇文', 4, '140524', '140524100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('礼义', 4, '140524', '140524101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('附城', 4, '140524', '140524102', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西河底', 4, '140524', '140524103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平城', 4, '140524', '140524104', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨村', 4, '140524', '140524105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潞城', 4, '140524', '140524106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夺火', 4, '140524', '140524204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马圪当', 4, '140524', '140524206', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古郊', 4, '140524', '140524207', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六泉', 4, '140524', '140524209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泽州', 3, '1405', '140525', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南村', 4, '140525', '140525100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下村', 4, '140525', '140525101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大东沟', 4, '140525', '140525102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周村', 4, '140525', '140525103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('犁川', 4, '140525', '140525104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋庙铺', 4, '140525', '140525105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金村', 4, '140525', '140525106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高都', 4, '140525', '140525107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴公', 4, '140525', '140525108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大阳', 4, '140525', '140525109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山河', 4, '140525', '140525110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大箕', 4, '140525', '140525111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳树口', 4, '140525', '140525112', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北义城', 4, '140525', '140525113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南岭', 4, '140525', '140525114', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('川底', 4, '140525', '140525115', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高平', 3, '1405', '140581', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城', 4, '140581', '140581001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '140581', '140581002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城', 4, '140581', '140581003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('米山', 4, '140581', '140581100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三甲', 4, '140581', '140581101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈区', 4, '140581', '140581102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北诗', 4, '140581', '140581103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '140581', '140581104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马村', 4, '140581', '140581105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('野川', 4, '140581', '140581106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寺庄', 4, '140581', '140581107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神农', 4, '140581', '140581108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建宁', 4, '140581', '140581202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石末', 4, '140581', '140581204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('原村', 4, '140581', '140581207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朔州', 2, '14', '1406', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朔城', 3, '1406', '140602', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城', 4, '140602', '140602001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城', 4, '140602', '140602002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神头街道', 4, '140602', '140602003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北旺庄', 4, '140602', '140602004', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神头镇', 4, '140602', '140602100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('利民', 4, '140602', '140602101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下团堡', 4, '140602', '140602200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小平易', 4, '140602', '140602201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滋润', 4, '140602', '140602202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南榆林', 4, '140602', '140602204', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾庄', 4, '140602', '140602205', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙塄河', 4, '140602', '140602206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窑子头', 4, '140602', '140602207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张蔡庄', 4, '140602', '140602208', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平鲁', 3, '1406', '140603', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('井坪', 4, '140603', '140603100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤凰城', 4, '140603', '140603101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白堂', 4, '140603', '140603200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶村', 4, '140603', '140603201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下水头', 4, '140603', '140603202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双碾', 4, '140603', '140603203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阻虎', 4, '140603', '140603204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高石庄', 4, '140603', '140603205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西水界', 4, '140603', '140603206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下面高', 4, '140603', '140603207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳堡', 4, '140603', '140603209', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆岭', 4, '140603', '140603210', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山阴', 3, '1406', '140621', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉井', 4, '140621', '140621100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北周庄', 4, '140621', '140621101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '140621', '140621102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岱岳', 4, '140621', '140621103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广武', 4, '140621', '140621104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴马营', 4, '140621', '140621200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马营', 4, '140621', '140621201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下喇叭', 4, '140621', '140621202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合盛堡', 4, '140621', '140621203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安荣', 4, '140621', '140621205', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛圐圙', 4, '140621', '140621206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马营庄', 4, '140621', '140621209', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('应县', 3, '1406', '140622', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金城', 4, '140622', '140622100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南河种', 4, '140622', '140622101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下社', 4, '140622', '140622102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镇子梁', 4, '140622', '140622200', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义井', 4, '140622', '140622201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('臧寨', 4, '140622', '140622202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大黄巍', 4, '140622', '140622203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏寨', 4, '140622', '140622204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下马峪', 4, '140622', '140622205', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南泉', 4, '140622', '140622206', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大临河', 4, '140622', '140622207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白马石', 4, '140622', '140622208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('右玉', 3, '1406', '140623', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '140623', '140623100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('右卫', 4, '140623', '140623101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('威远', 4, '140623', '140623102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元堡子', 4, '140623', '140623103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛心堡', 4, '140623', '140623200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家堡', 4, '140623', '140623202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨千河', 4, '140623', '140623204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李达窑', 4, '140623', '140623205', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀仁', 3, '1406', '140681', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云西', 4, '140681', '140681001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云中', 4, '140681', '140681002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云东', 4, '140681', '140681003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴家窑', 4, '140681', '140681101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金沙滩', 4, '140681', '140681102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛家皂', 4, '140681', '140681103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('何家堡', 4, '140681', '140681200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新家园', 4, '140681', '140681201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亲和', 4, '140681', '140681202', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海北头', 4, '140681', '140681203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河头', 4, '140681', '140681205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋中', 2, '14', '1407', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆次', 3, '1407', '140702', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北关', 4, '140702', '140702001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦纶', 4, '140702', '140702002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '140702', '140702003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西南', 4, '140702', '140702004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路西', 4, '140702', '140702005', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('经纬', 4, '140702', '140702006', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安宁', 4, '140702', '140702007', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新建', 4, '140702', '140702008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋华', 4, '140702', '140702009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌金山', 4, '140702', '140702100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东阳', 4, '140702', '140702101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长凝', 4, '140702', '140702103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北田', 4, '140702', '140702104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('修文', 4, '140702', '140702105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家堡', 4, '140702', '140702200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张庆', 4, '140702', '140702201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庄子', 4, '140702', '140702202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东赵', 4, '140702', '140702203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋中经济开发区', 4, '140702', '140702400', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太谷', 3, '1407', '140703', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡村', 4, '140703', '140703101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('范村', 4, '140703', '140703102', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水秀', 4, '140703', '140703103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯城', 4, '140703', '140703200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北洸', 4, '140703', '140703201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳邑', 4, '140703', '140703203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小白', 4, '140703', '140703204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('任村', 4, '140703', '140703205', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆社', 3, '1407', '140721', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('箕城', 4, '140721', '140721100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云簇', 4, '140721', '140721101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝北', 4, '140721', '140721102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('社城', 4, '140721', '140721103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河峪', 4, '140721', '140721200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北寨', 4, '140721', '140721201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西马', 4, '140721', '140721202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左权', 3, '1407', '140722', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽阳', 4, '140722', '140722100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桐峪', 4, '140722', '140722101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麻田', 4, '140722', '140722102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芹泉', 4, '140722', '140722103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拐儿', 4, '140722', '140722104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石匣', 4, '140722', '140722200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊角', 4, '140722', '140722202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寒王', 4, '140722', '140722203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和顺', 3, '1407', '140723', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义兴', 4, '140723', '140723100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李阳', 4, '140723', '140723101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松烟', 4, '140723', '140723102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青城', 4, '140723', '140723103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横岭', 4, '140723', '140723104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喂马', 4, '140723', '140723200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平松', 4, '140723', '140723201', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马坊', 4, '140723', '140723203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昔阳', 3, '1407', '140724', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐平', 4, '140724', '140724100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皋落', 4, '140724', '140724101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冶头', 4, '140724', '140724102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沾尚', 4, '140724', '140724103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大寨', 4, '140724', '140724104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家庄', 4, '140724', '140724201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('界都', 4, '140724', '140724202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三都', 4, '140724', '140724203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵壁', 4, '140724', '140724204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孔氏', 4, '140724', '140724205', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寿阳', 3, '1407', '140725', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 4, '140725', '140725100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南燕竹', 4, '140725', '140725101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宗艾', 4, '140725', '140725102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平头', 4, '140725', '140725103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松塔', 4, '140725', '140725104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西洛', 4, '140725', '140725105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尹灵芝', 4, '140725', '140725106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平舒', 4, '140725', '140725200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解愁', 4, '140725', '140725201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温家庄', 4, '140725', '140725202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景尚', 4, '140725', '140725203', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊头崖', 4, '140725', '140725205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祁县', 3, '1407', '140727', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昭余', 4, '140727', '140727100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东观', 4, '140727', '140727101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古县', 4, '140727', '140727102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾令', 4, '140727', '140727103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城赵', 4, '140727', '140727104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('来远', 4, '140727', '140727105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峪口', 4, '140727', '140727201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平遥', 3, '1407', '140728', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '140728', '140728001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东', 4, '140728', '140728002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城西', 4, '140728', '140728003', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古陶', 4, '140728', '140728100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段村', 4, '140728', '140728101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东泉', 4, '140728', '140728102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪善', 4, '140728', '140728103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁固', 4, '140728', '140728104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南政', 4, '140728', '140728200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中都', 4, '140728', '140728201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岳壁', 4, '140728', '140728202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卜宜', 4, '140728', '140728203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱坑', 4, '140728', '140728205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('襄垣', 4, '140728', '140728206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜家庄', 4, '140728', '140728207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香乐', 4, '140728', '140728208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵石', 3, '1407', '140729', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翠峰', 4, '140729', '140729101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('静升', 4, '140729', '140729102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两渡', 4, '140729', '140729103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏门', 4, '140729', '140729104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南关', 4, '140729', '140729105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段纯', 4, '140729', '140729106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王禹', 4, '140729', '140729202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坛镇', 4, '140729', '140729203', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家墕', 4, '140729', '140729204', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交口', 4, '140729', '140729205', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('介休', 3, '1407', '140781', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北关', 4, '140781', '140781001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西关', 4, '140781', '140781002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东南', 4, '140781', '140781003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西南', 4, '140781', '140781004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北坛', 4, '140781', '140781005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义安', 4, '140781', '140781100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张兰', 4, '140781', '140781101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连福', 4, '140781', '140781102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪山', 4, '140781', '140781103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义棠', 4, '140781', '140781104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙凤', 4, '140781', '140781105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绵山', 4, '140781', '140781106', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '140781', '140781200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋古', 4, '140781', '140781201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('运城', 2, '14', '1408', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盐湖', 3, '1408', '140802', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中城', 4, '140802', '140802001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '140802', '140802002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '140802', '140802003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城', 4, '140802', '140802004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城', 4, '140802', '140802005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安邑', 4, '140802', '140802006', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大渠', 4, '140802', '140802007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚孟', 4, '140802', '140802008', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙居', 4, '140802', '140802100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶村', 4, '140802', '140802101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东郭', 4, '140802', '140802102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三路里', 4, '140802', '140802103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北相', 4, '140802', '140802104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泓芝驿', 4, '140802', '140802105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解州', 4, '140802', '140802106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('席张', 4, '140802', '140802200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金井', 4, '140802', '140802201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯村', 4, '140802', '140802202', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王范', 4, '140802', '140802203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上郭', 4, '140802', '140802204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上王', 4, '140802', '140802205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临猗', 3, '1408', '140821', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('猗氏', 4, '140821', '140821100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嵋阳', 4, '140821', '140821101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临晋', 4, '140821', '140821102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七级', 4, '140821', '140821103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东张', 4, '140821', '140821104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙吉', 4, '140821', '140821105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三管', 4, '140821', '140821106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛杜', 4, '140821', '140821107', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('耽子', 4, '140821', '140821108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('角杯', 4, '140821', '140821109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楚侯', 4, '140821', '140821200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庙上', 4, '140821', '140821201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北辛', 4, '140821', '140821203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北景', 4, '140821', '140821205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万荣', 3, '1408', '140822', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解店', 4, '140822', '140822100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通化', 4, '140822', '140822101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汉薛', 4, '140822', '140822102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荣河', 4, '140822', '140822103', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高村', 4, '140822', '140822105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万泉', 4, '140822', '140822200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里望', 4, '140822', '140822201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西村', 4, '140822', '140822202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南张', 4, '140822', '140822203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皇甫', 4, '140822', '140822205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾村', 4, '140822', '140822206', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王显', 4, '140822', '140822207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光华', 4, '140822', '140822208', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裴庄', 4, '140822', '140822209', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('闻喜', 3, '1408', '140823', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桐城', 4, '140823', '140823100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家庄', 4, '140823', '140823101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('畖底', 4, '140823', '140823102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛店', 4, '140823', '140823103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东镇', 4, '140823', '140823104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('礼元', 4, '140823', '140823105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河底', 4, '140823', '140823106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳隅', 4, '140823', '140823107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯村', 4, '140823', '140823108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裴社', 4, '140823', '140823109', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后宫', 4, '140823', '140823204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石门', 4, '140823', '140823205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('稷山', 3, '1408', '140824', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('稷峰', 4, '140824', '140824100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西社', 4, '140824', '140824101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化峪', 4, '140824', '140824102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翟店', 4, '140824', '140824103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河', 4, '140824', '140824104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡村', 4, '140824', '140824200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太阳', 4, '140824', '140824201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新绛', 3, '1408', '140825', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙兴', 4, '140825', '140825100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三泉', 4, '140825', '140825101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泽掌', 4, '140825', '140825102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北张', 4, '140825', '140825103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古交', 4, '140825', '140825104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万安', 4, '140825', '140825105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳王', 4, '140825', '140825106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉掌', 4, '140825', '140825107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横桥', 4, '140825', '140825108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绛县', 3, '1408', '140826', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古绛', 4, '140826', '140826100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横水', 4, '140826', '140826101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈村', 4, '140826', '140826102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卫庄', 4, '140826', '140826103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磨里', 4, '140826', '140826104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南樊', 4, '140826', '140826105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安峪', 4, '140826', '140826106', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大交', 4, '140826', '140826107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝庄', 4, '140826', '140826200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冷口', 4, '140826', '140826201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('垣曲', 3, '1408', '140827', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '140827', '140827100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('历山', 4, '140827', '140827101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '140827', '140827102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王茅', 4, '140827', '140827103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛家湾', 4, '140827', '140827104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英言', 4, '140827', '140827105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲掌', 4, '140827', '140827200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解峪', 4, '140827', '140827202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华峰', 4, '140827', '140827203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长直', 4, '140827', '140827204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皋落', 4, '140827', '140827205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏县', 3, '1408', '140828', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瑶峰', 4, '140828', '140828100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庙前', 4, '140828', '140828101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裴介', 4, '140828', '140828102', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水头', 4, '140828', '140828103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('埝掌', 4, '140828', '140828104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泗交', 4, '140828', '140828105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('禹王', 4, '140828', '140828106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尉郭', 4, '140828', '140828200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡张', 4, '140828', '140828202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大里', 4, '140828', '140828203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祁家河', 4, '140828', '140828204', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平陆', 3, '1408', '140829', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('圣人涧', 4, '140829', '140829100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常乐', 4, '140829', '140829101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张店', 4, '140829', '140829102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张村', 4, '140829', '140829103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹川', 4, '140829', '140829104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三门', 4, '140829', '140829105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('部官', 4, '140829', '140829107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪池', 4, '140829', '140829200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜马', 4, '140829', '140829201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芮城', 3, '1408', '140830', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古魏', 4, '140830', '140830100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('风陵渡', 4, '140830', '140830101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陌南', 4, '140830', '140830102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西陌', 4, '140830', '140830103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永乐', 4, '140830', '140830104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王', 4, '140830', '140830105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳城', 4, '140830', '140830106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南磑', 4, '140830', '140830107', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东垆', 4, '140830', '140830200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('学张', 4, '140830', '140830202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永济', 3, '1408', '140881', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城西', 4, '140881', '140881001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城北', 4, '140881', '140881002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东', 4, '140881', '140881003', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虞乡', 4, '140881', '140881100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卿头', 4, '140881', '140881101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开张', 4, '140881', '140881102', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栲栳', 4, '140881', '140881103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲州', 4, '140881', '140881104', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩阳', 4, '140881', '140881105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张营', 4, '140881', '140881106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河津', 3, '1408', '140882', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城区', 4, '140882', '140882001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清涧', 4, '140882', '140882002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵家庄', 4, '140882', '140882003', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳村', 4, '140882', '140882004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('樊村', 4, '140882', '140882100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('僧楼', 4, '140882', '140882101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴家', 4, '140882', '140882102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小梁', 4, '140882', '140882200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下化', 4, '140882', '140882204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('忻州', 2, '14', '1409', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('忻府', 3, '1409', '140902', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秀容', 4, '140902', '140902001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长征', 4, '140902', '140902002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新建路', 4, '140902', '140902003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云中路', 4, '140902', '140902004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九原街', 4, '140902', '140902005', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旭来街', 4, '140902', '140902006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥西', 4, '140902', '140902007', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奇村', 4, '140902', '140902101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三交', 4, '140902', '140902102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庄磨', 4, '140902', '140902103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豆罗', 4, '140902', '140902104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('董村', 4, '140902', '140902105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西张', 4, '140902', '140902106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('忻口', 4, '140902', '140902109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合索', 4, '140902', '140902110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兰村', 4, '140902', '140902206', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东楼', 4, '140902', '140902209', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北义井', 4, '140902', '140902210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('定襄', 3, '1409', '140921', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晋昌', 4, '140921', '140921100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河边', 4, '140921', '140921101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宏道', 4, '140921', '140921102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('季庄', 4, '140921', '140921104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒋村', 4, '140921', '140921105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南王', 4, '140921', '140921201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神山', 4, '140921', '140921203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('受禄', 4, '140921', '140921205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五台', 3, '1409', '140922', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台城', 4, '140922', '140922100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台怀', 4, '140922', '140922101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('耿镇', 4, '140922', '140922102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('豆村', 4, '140922', '140922103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白家庄', 4, '140922', '140922104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东冶', 4, '140922', '140922105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建安', 4, '140922', '140922107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沟南', 4, '140922', '140922200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东雷', 4, '140922', '140922201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高洪口', 4, '140922', '140922202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('门限石', 4, '140922', '140922203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈家庄', 4, '140922', '140922204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒋坊', 4, '140922', '140922207', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳白', 4, '140922', '140922209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茹村', 4, '140922', '140922210', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石咀', 4, '140922', '140922211', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金岗库', 4, '140922', '140922212', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('代县', 3, '1409', '140923', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上馆', 4, '140923', '140923100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳明堡', 4, '140923', '140923101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峨口', 4, '140923', '140923102', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('聂营', 4, '140923', '140923103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枣林', 4, '140923', '140923104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峪口', 4, '140923', '140923108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新高', 4, '140923', '140923200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上磨坊', 4, '140923', '140923202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雁门关', 4, '140923', '140923204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('繁峙', 3, '1409', '140924', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('繁城', 4, '140924', '140924100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('砂河', 4, '140924', '140924101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营', 4, '140924', '140924102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平型关', 4, '140924', '140924103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下茹越', 4, '140924', '140924201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光裕堡', 4, '140924', '140924203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('集义庄', 4, '140924', '140924204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东山', 4, '140924', '140924207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金山铺', 4, '140924', '140924209', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神堂堡', 4, '140924', '140924213', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岩头', 4, '140924', '140924215', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁武', 3, '1409', '140925', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤凰', 4, '140925', '140925100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳方口', 4, '140925', '140925101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东寨', 4, '140925', '140925102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石家庄', 4, '140925', '140925103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁化', 4, '140925', '140925105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛家洼', 4, '140925', '140925200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('余庄', 4, '140925', '140925201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('涔山', 4, '140925', '140925202', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西马坊', 4, '140925', '140925204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迭台寺', 4, '140925', '140925206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀道', 4, '140925', '140925208', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东马坊', 4, '140925', '140925209', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('静乐', 3, '1409', '140926', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹅城', 4, '140926', '140926100', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜家村', 4, '140926', '140926101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康家会', 4, '140926', '140926102', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰润', 4, '140926', '140926103', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双路', 4, '140926', '140926104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王村', 4, '140926', '140926106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段家寨', 4, '140926', '140926204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛村', 4, '140926', '140926205', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神峪沟', 4, '140926', '140926207', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娘子神', 4, '140926', '140926208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娑婆', 4, '140926', '140926209', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤泥窊', 4, '140926', '140926210', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('神池', 3, '1409', '140927', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉', 4, '140927', '140927100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义井', 4, '140927', '140927101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八角', 4, '140927', '140927102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东湖', 4, '140927', '140927200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贺职', 4, '140927', '140927203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长畛', 4, '140927', '140927204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('烈堡', 4, '140927', '140927205', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大严备', 4, '140927', '140927206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五寨', 3, '1409', '140928', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('砚城', 4, '140928', '140928100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小河头', 4, '140928', '140928101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三岔', 4, '140928', '140928102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前所', 4, '140928', '140928200', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家坪', 4, '140928', '140928201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙家坪', 4, '140928', '140928202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡会', 4, '140928', '140928204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩家楼', 4, '140928', '140928206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东秀庄', 4, '140928', '140928207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏岭子', 4, '140928', '140928208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岢岚', 3, '1409', '140929', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岚漪', 4, '140929', '140929100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三井', 4, '140929', '140929101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋家沟', 4, '140929', '140929102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家会', 4, '140929', '140929201', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家沟', 4, '140929', '140929203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水峪贯', 4, '140929', '140929204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西豹峪', 4, '140929', '140929206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉', 4, '140929', '140929208', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳坪', 4, '140929', '140929209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大涧', 4, '140929', '140929211', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河曲', 3, '1409', '140930', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西口', 4, '140930', '140930100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楼子营', 4, '140930', '140930101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家塔', 4, '140930', '140930102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巡镇', 4, '140930', '140930103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧县', 4, '140930', '140930104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙泉', 4, '140930', '140930105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹿固', 4, '140930', '140930200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('单寨', 4, '140930', '140930202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土沟', 4, '140930', '140930203', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙坪', 4, '140930', '140930205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('社梁', 4, '140930', '140930206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保德', 3, '1409', '140931', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东关', 4, '140931', '140931100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义门', 4, '140931', '140931101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥头', 4, '140931', '140931102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家湾', 4, '140931', '140931103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙家沟', 4, '140931', '140931105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腰庄', 4, '140931', '140931200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩家川', 4, '140931', '140931201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林遮峪', 4, '140931', '140931202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯家川', 4, '140931', '140931203', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土崖塔', 4, '140931', '140931204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南河沟', 4, '140931', '140931208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('偏关', 3, '1409', '140932', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新关', 4, '140932', '140932100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老营', 4, '140932', '140932102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万家寨', 4, '140932', '140932103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尚峪', 4, '140932', '140932106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老牛湾', 4, '140932', '140932108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窑头', 4, '140932', '140932200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楼沟', 4, '140932', '140932201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泉', 4, '140932', '140932204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('原平', 3, '1409', '140981', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城', 4, '140981', '140981001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城', 4, '140981', '140981002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新原', 4, '140981', '140981004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉祥', 4, '140981', '140981005', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏龙口', 4, '140981', '140981101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崞阳', 4, '140981', '140981102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大牛店', 4, '140981', '140981103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎庄', 4, '140981', '140981104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('轩岗', 4, '140981', '140981106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云水', 4, '140981', '140981107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('同川', 4, '140981', '140981108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('子干', 4, '140981', '140981202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中阳', 4, '140981', '140981203', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沿沟', 4, '140981', '140981204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大林', 4, '140981', '140981205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西镇', 4, '140981', '140981206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家庄', 4, '140981', '140981208', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段家堡', 4, '140981', '140981210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临汾', 2, '14', '1410', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尧都', 3, '1410', '141002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放路', 4, '141002', '141002001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼西', 4, '141002', '141002002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水塔', 4, '141002', '141002003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南街', 4, '141002', '141002004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乡贤', 4, '141002', '141002005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛寺', 4, '141002', '141002006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路东', 4, '141002', '141002007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('车站', 4, '141002', '141002008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汾河', 4, '141002', '141002009', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '141002', '141002010', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('屯里', 4, '141002', '141002100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乔李', 4, '141002', '141002101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大阳', 4, '141002', '141002102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('县底', 4, '141002', '141002103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘村', 4, '141002', '141002104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金殿', 4, '141002', '141002105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴村', 4, '141002', '141002106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土门', 4, '141002', '141002107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏村', 4, '141002', '141002108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尧庙', 4, '141002', '141002109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段店', 4, '141002', '141002200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾得', 4, '141002', '141002201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('一平垣', 4, '141002', '141002203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枕头', 4, '141002', '141002204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲沃', 3, '1410', '141021', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐昌', 4, '141021', '141021100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('史村', 4, '141021', '141021101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲村', 4, '141021', '141021102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高显', 4, '141021', '141021103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里村', 4, '141021', '141021104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北董', 4, '141021', '141021200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨谈', 4, '141021', '141021201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翼城', 3, '1410', '141022', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐兴', 4, '141022', '141022100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南梁', 4, '141022', '141022101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('里砦', 4, '141022', '141022102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆化', 4, '141022', '141022103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥上', 4, '141022', '141022104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西阎', 4, '141022', '141022105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王庄', 4, '141022', '141022107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中卫', 4, '141022', '141022200', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南唐', 4, '141022', '141022201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('襄汾', 3, '1410', '141023', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '141023', '141023100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵康', 4, '141023', '141023101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汾城', 4, '141023', '141023102', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南贾', 4, '141023', '141023103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '141023', '141023104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('襄陵', 4, '141023', '141023105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邓庄', 4, '141023', '141023106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶寺', 4, '141023', '141023200', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永固', 4, '141023', '141023201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('景毛', 4, '141023', '141023202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西贾', 4, '141023', '141023203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南辛店', 4, '141023', '141023204', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大邓', 4, '141023', '141023205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪洞', 3, '1410', '141024', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大槐树', 4, '141024', '141024100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘亭', 4, '141024', '141024101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲亭', 4, '141024', '141024102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏堡', 4, '141024', '141024103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广胜寺', 4, '141024', '141024104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明姜', 4, '141024', '141024105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵城', 4, '141024', '141024106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万安', 4, '141024', '141024107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家垣', 4, '141024', '141024108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛村', 4, '141024', '141024109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('淹底', 4, '141024', '141024200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴唐寺', 4, '141024', '141024201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('堤村', 4, '141024', '141024202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙马', 4, '141024', '141024204', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山目', 4, '141024', '141024207', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古县', 3, '1410', '141025', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岳阳', 4, '141025', '141025100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北平', 4, '141025', '141025101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古阳', 4, '141025', '141025102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧县', 4, '141025', '141025103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三合', 4, '141025', '141025104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南垣', 4, '141025', '141025202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安泽', 3, '1410', '141026', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('府城', 4, '141026', '141026100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和川', 4, '141026', '141026101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐城', 4, '141026', '141026102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冀氏', 4, '141026', '141026103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('良马', 4, '141026', '141026104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马壁', 4, '141026', '141026105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浮山', 3, '1410', '141027', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天坛', 4, '141027', '141027100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('响水河', 4, '141027', '141027101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北王', 4, '141027', '141027102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张庄', 4, '141027', '141027103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东张', 4, '141027', '141027201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('槐埝', 4, '141027', '141027202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寨圪塔', 4, '141027', '141027206', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉县', 3, '1410', '141028', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉昌', 4, '141028', '141028100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('屯里', 4, '141028', '141028101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('壶口', 4, '141028', '141028102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('车城', 4, '141028', '141028200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文城', 4, '141028', '141028201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏山寺', 4, '141028', '141028203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中垛', 4, '141028', '141028204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乡宁', 3, '1410', '141029', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌宁', 4, '141029', '141029100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光华', 4, '141029', '141029101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台头', 4, '141029', '141029102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('管头', 4, '141029', '141029103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西坡', 4, '141029', '141029104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双鹤', 4, '141029', '141029200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('关王庙', 4, '141029', '141029201', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尉庄', 4, '141029', '141029202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西交口', 4, '141029', '141029203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枣岭', 4, '141029', '141029204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大宁', 3, '1410', '141030', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昕水', 4, '141030', '141030100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲峨', 4, '141030', '141030101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太古', 4, '141030', '141030102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三多', 4, '141030', '141030200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太德', 4, '141030', '141030201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隰县', 3, '1410', '141031', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉', 4, '141031', '141031100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('午城', 4, '141031', '141031101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土', 4, '141031', '141031102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳头升', 4, '141031', '141031200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寨子', 4, '141031', '141031201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下李', 4, '141031', '141031203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城南', 4, '141031', '141031204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永和', 3, '1410', '141032', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芝河', 4, '141032', '141032100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑壁', 4, '141032', '141032101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坡头', 4, '141032', '141032203', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望海寺', 4, '141032', '141032205', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乾坤湾', 4, '141032', '141032206', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楼山', 4, '141032', '141032207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲县', 3, '1410', '141033', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲城', 4, '141033', '141033100', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛关', 4, '141033', '141033101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑龙关', 4, '141033', '141033102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克城', 4, '141033', '141033103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乔家湾', 4, '141033', '141033105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山中', 4, '141033', '141033200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古县', 4, '141033', '141033201', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太林', 4, '141033', '141033204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汾西', 3, '1410', '141034', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安', 4, '141034', '141034100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('对竹', 4, '141034', '141034101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('勍香', 4, '141034', '141034102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '141034', '141034103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('僧念', 4, '141034', '141034104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佃坪', 4, '141034', '141034200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团柏', 4, '141034', '141034201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('侯马', 3, '1410', '141081', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路东', 4, '141081', '141081001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路西', 4, '141081', '141081002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浍滨', 4, '141081', '141081003', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上马', 4, '141081', '141081004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张村', 4, '141081', '141081005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新田', 4, '141081', '141081200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高村', 4, '141081', '141081201', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤城', 4, '141081', '141081202', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霍州', 3, '1410', '141082', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼', 4, '141082', '141082001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北环路', 4, '141082', '141082002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南环路', 4, '141082', '141082003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开元街', 4, '141082', '141082004', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('退沙', 4, '141082', '141082005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白龙', 4, '141082', '141082100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛置', 4, '141082', '141082101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大张', 4, '141082', '141082102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李曹', 4, '141082', '141082103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶唐峪', 4, '141082', '141082200', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三教', 4, '141082', '141082201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('师庄', 4, '141082', '141082202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吕梁', 2, '14', '1411', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('离石', 3, '1411', '141102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤山', 4, '141102', '141102001', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城北', 4, '141102', '141102002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '141102', '141102003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲花池', 4, '141102', '141102004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田家会', 4, '141102', '141102005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西属巴', 4, '141102', '141102006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交口', 4, '141102', '141102007', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴城', 4, '141102', '141102100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('信义', 4, '141102', '141102104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枣林', 4, '141102', '141102201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坪头', 4, '141102', '141102202', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文水', 3, '1411', '141121', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤城', 4, '141121', '141121100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开栅', 4, '141121', '141121101', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南庄', 4, '141121', '141121102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南安', 4, '141121', '141121103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘胡兰', 4, '141121', '141121104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下曲', 4, '141121', '141121105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孝义', 4, '141121', '141121106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南武', 4, '141121', '141121200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '141121', '141121201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北张', 4, '141121', '141121202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马西', 4, '141121', '141121203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西槽头', 4, '141121', '141121204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交城', 3, '1411', '141122', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天宁', 4, '141122', '141122100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏家营', 4, '141122', '141122101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西营', 4, '141122', '141122102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水峪贯', 4, '141122', '141122103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西社', 4, '141122', '141122104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庞泉沟', 4, '141122', '141122105', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪相', 4, '141122', '141122107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东坡底', 4, '141122', '141122202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴县', 3, '1411', '141123', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔚汾', 4, '141123', '141123100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏家滩', 4, '141123', '141123101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瓦塘', 4, '141123', '141123102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康宁', 4, '141123', '141123103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家村', 4, '141123', '141123104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗峪口', 4, '141123', '141123105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡家会', 4, '141123', '141123106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交楼申', 4, '141123', '141123200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东会', 4, '141123', '141123202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固贤', 4, '141123', '141123203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奥家湾', 4, '141123', '141123204', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡家崖', 4, '141123', '141123205', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟家坪', 4, '141123', '141123207', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵家坪', 4, '141123', '141123208', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('圪垯上', 4, '141123', '141123209', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临县', 3, '1411', '141124', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临泉', 4, '141124', '141124100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白文', 4, '141124', '141124101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城庄', 4, '141124', '141124102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兔坂', 4, '141124', '141124103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克虎', 4, '141124', '141124104', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三交', 4, '141124', '141124105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湍水头', 4, '141124', '141124106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林家坪', 4, '141124', '141124107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('招贤', 4, '141124', '141124108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碛口', 4, '141124', '141124109', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家会', 4, '141124', '141124110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丛罗峪', 4, '141124', '141124111', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲峪', 4, '141124', '141124112', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木瓜坪', 4, '141124', '141124200', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安业', 4, '141124', '141124201', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉坪', 4, '141124', '141124202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青凉寺', 4, '141124', '141124203', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石白头', 4, '141124', '141124204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雷家碛', 4, '141124', '141124205', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第八堡', 4, '141124', '141124206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大禹', 4, '141124', '141124207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('车赶', 4, '141124', '141124208', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安家庄', 4, '141124', '141124209', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳林', 3, '1411', '141125', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳林镇', 4, '141125', '141125100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('穆村', 4, '141125', '141125101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛村', 4, '141125', '141125102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庄上', 4, '141125', '141125103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留誉', 4, '141125', '141125104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下三交', 4, '141125', '141125105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成家庄', 4, '141125', '141125106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟门', 4, '141125', '141125107', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金家庄', 4, '141125', '141125108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈家湾', 4, '141125', '141125109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家湾', 4, '141125', '141125200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾家垣', 4, '141125', '141125201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家沟', 4, '141125', '141125204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石西', 4, '141125', '141125205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西王家沟', 4, '141125', '141125206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石楼', 3, '1411', '141126', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵泉', 4, '141126', '141126100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗村', 4, '141126', '141126101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义牒', 4, '141126', '141126102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小蒜', 4, '141126', '141126103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛关', 4, '141126', '141126104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙交', 4, '141126', '141126200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和合', 4, '141126', '141126201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹家垣', 4, '141126', '141126203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('裴沟', 4, '141126', '141126204', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岚县', 3, '1411', '141127', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东村', 4, '141127', '141127100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岚城', 4, '141127', '141127101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('普明', 4, '141127', '141127102', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('界河口', 4, '141127', '141127103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上明', 4, '141127', '141127201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王狮', 4, '141127', '141127202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家庄', 4, '141127', '141127203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('顺会', 4, '141127', '141127204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('社科', 4, '141127', '141127206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方山', 3, '1411', '141128', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('圪洞', 4, '141128', '141128100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马坊', 4, '141128', '141128101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峪口', 4, '141128', '141128102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大武', 4, '141128', '141128103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北武当', 4, '141128', '141128104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('积翠', 4, '141128', '141128105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中阳', 3, '1411', '141129', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁乡', 4, '141129', '141129100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金罗', 4, '141129', '141129101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枝柯', 4, '141129', '141129102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武家庄', 4, '141129', '141129103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('暖泉', 4, '141129', '141129104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下枣林', 4, '141129', '141129201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交口', 3, '1411', '141130', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水头', 4, '141130', '141130100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康城', 4, '141130', '141130101', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双池', 4, '141130', '141130102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃红坡', 4, '141130', '141130103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石口', 4, '141130', '141130104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('回龙', 4, '141130', '141130105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉', 4, '141130', '141130202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孝义', 3, '1411', '141181', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新义', 4, '141181', '141181001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中阳楼', 4, '141181', '141181002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振兴', 4, '141181', '141181003', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜溪湖', 4, '141181', '141181004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崇文', 4, '141181', '141181005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兑镇', 4, '141181', '141181100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳泉曲', 4, '141181', '141181101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下堡', 4, '141181', '141181102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西辛庄', 4, '141181', '141181103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高阳', 4, '141181', '141181104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梧桐', 4, '141181', '141181105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柱濮', 4, '141181', '141181106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孝堡', 4, '141181', '141181107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下栅', 4, '141181', '141181201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('驿马', 4, '141181', '141181202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜村', 4, '141181', '141181204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汾阳', 3, '1411', '141182', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文峰', 4, '141182', '141182001', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太和桥', 4, '141182', '141182002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西河', 4, '141182', '141182003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贾家庄', 4, '141182', '141182100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏花村', 4, '141182', '141182101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冀村', 4, '141182', '141182102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖家庄', 4, '141182', '141182103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('演武', 4, '141182', '141182104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三泉', 4, '141182', '141182105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石庄', 4, '141182', '141182106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家庄', 4, '141182', '141182107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峪道河', 4, '141182', '141182108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栗家庄', 4, '141182', '141182109', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阳城', 4, '141182', '141182110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('内蒙古', 1, '0', '15', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼和浩特', 2, '15', '1501', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 3, '1501', '150102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡林路', 4, '150102', '150102002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中山东路', 4, '150102', '150102003', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东街', 4, '150102', '150102004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西街', 4, '150102', '150102005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风路', 4, '150102', '150102006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎新路', 4, '150102', '150102007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成吉思汗大街', 4, '150102', '150102008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保合少', 4, '150102', '150102101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('回民', 3, '1501', '150103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华西路', 4, '150103', '150103001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中山西路', 4, '150103', '150103002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明路', 4, '150103', '150103003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海拉尔西路', 4, '150103', '150103004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('环河路', 4, '150103', '150103005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通道街', 4, '150103', '150103006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钢铁路', 4, '150103', '150103007', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('攸攸板', 4, '150103', '150103100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉泉', 3, '1501', '150104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大南街', 4, '150104', '150104001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小召前街', 4, '150104', '150104002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂尔多斯路', 4, '150104', '150104003', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆巷', 4, '150104', '150104004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长和廊', 4, '150104', '150104005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石东路', 4, '150104', '150104006', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西菜园', 4, '150104', '150104007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昭君路', 4, '150104', '150104009', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小黑河', 4, '150104', '150104100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛罕', 3, '1501', '150105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('人民路', 4, '150105', '150105001', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大学西路', 4, '150105', '150105002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰察布东路', 4, '150105', '150105003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大学东路', 4, '150105', '150105004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中专路', 4, '150105', '150105005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昭乌达路', 4, '150105', '150105006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦', 4, '150105', '150105007', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敕勒川路', 4, '150105', '150105008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆林', 4, '150105', '150105101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄合少', 4, '150105', '150105103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金河', 4, '150105', '150105104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('如意开发区', 4, '150105', '150105401', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土默特左旗', 3, '1501', '150121', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察素齐', 4, '150121', '150121100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毕克齐', 4, '150121', '150121101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('善岱', 4, '150121', '150121102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白庙子', 4, '150121', '150121103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台阁牧', 4, '150121', '150121104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙尔沁', 4, '150121', '150121105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敕勒川', 4, '150121', '150121106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北什轴', 4, '150121', '150121207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔布赛', 4, '150121', '150121208', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('托克托', 3, '1501', '150122', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双河', 4, '150122', '150122100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新营子', 4, '150122', '150122101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五申', 4, '150122', '150122102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '150122', '150122103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伍什家', 4, '150122', '150122104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和林格尔', 3, '1501', '150123', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '150123', '150123100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盛乐', 4, '150123', '150123101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新店子', 4, '150123', '150123102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巧什营', 4, '150123', '150123103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('舍必崖', 4, '150123', '150123203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大红城', 4, '150123', '150123205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊群沟', 4, '150123', '150123206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑老夭', 4, '150123', '150123207', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清水河', 3, '1501', '150124', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喇嘛湾', 4, '150124', '150124100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '150124', '150124101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宏河', 4, '150124', '150124102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老牛湾', 4, '150124', '150124103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('窑沟', 4, '150124', '150124201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北堡', 4, '150124', '150124203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韭菜庄', 4, '150124', '150124208', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五良太', 4, '150124', '150124209', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武川', 3, '1501', '150125', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('可可以力更', 4, '150125', '150125100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈乐', 4, '150125', '150125101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西乌兰不浪', 4, '150125', '150125102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大青山', 4, '150125', '150125200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德胜沟', 4, '150125', '150125204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上秃亥', 4, '150125', '150125205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈拉合少', 4, '150125', '150125213', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二份子', 4, '150125', '150125214', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('耗赖山', 4, '150125', '150125215', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武川金三角开发区', 4, '150125', '150125403', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('包头', 2, '15', '1502', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东河', 3, '1502', '150202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平路', 4, '150202', '150202001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('财神庙', 4, '150202', '150202002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西脑包', 4, '150202', '150202003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南门外', 4, '150202', '150202004', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南圪洞', 4, '150202', '150202005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东站', 4, '150202', '150202006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('回民', 4, '150202', '150202007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二里半', 4, '150202', '150202008', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东街道', 4, '150202', '150202009', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 4, '150202', '150202010', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东兴', 4, '150202', '150202011', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨圪塄', 4, '150202', '150202012', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东镇', 4, '150202', '150202100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙尔沁', 4, '150202', '150202101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昆都仑', 3, '1502', '150203', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('少先路', 4, '150203', '150203001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昆北', 4, '150203', '150203002', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沼潭', 4, '150203', '150203003', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林荫路', 4, '150203', '150203004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊大街', 4, '150203', '150203005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔丁大街', 4, '150203', '150203006', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团结大街', 4, '150203', '150203007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鞍山道', 4, '150203', '150203008', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进道', 4, '150203', '150203009', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('市府东路', 4, '150203', '150203010', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白云路', 4, '150203', '150203011', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄河西路', 4, '150203', '150203012', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昆工路', 4, '150203', '150203013', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昆河', 4, '150203', '150203100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卜尔汉图', 4, '150203', '150203101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('包钢厂区', 4, '150203', '150203400', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青山', 3, '1502', '150204', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先锋道', 4, '150204', '150204001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('幸福路', 4, '150204', '150204002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万青路', 4, '150204', '150204003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富强路', 4, '150204', '150204004', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科学路', 4, '150204', '150204005', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青山路', 4, '150204', '150204006', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('自由路', 4, '150204', '150204007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌素图', 4, '150204', '150204008', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青福', 4, '150204', '150204100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴胜', 4, '150204', '150204101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石拐', 3, '1502', '150205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石拐街道', 4, '150205', '150205001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大发', 4, '150205', '150205002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大磁', 4, '150205', '150205003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五当沟', 4, '150205', '150205004', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白狐沟', 4, '150205', '150205005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大德恒', 4, '150205', '150205006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五当召', 4, '150205', '150205100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉忽伦图苏木', 4, '150205', '150205200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工业园区管理委员会', 4, '150205', '150205400', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白云鄂博矿区', 3, '1502', '150206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('矿山路', 4, '150206', '150206001', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通阳道', 4, '150206', '150206002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九原', 3, '1502', '150207', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河', 4, '150207', '150207001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛汗', 4, '150207', '150207002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('萨如拉', 4, '150207', '150207003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音席勒', 4, '150207', '150207004', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('稀土路', 4, '150207', '150207005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麻池', 4, '150207', '150207103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈业胡同', 4, '150207', '150207104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈林格尔', 4, '150207', '150207105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万水泉', 4, '150207', '150207106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿嘎如泰苏木', 4, '150207', '150207205', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土默特右旗', 3, '1502', '150221', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('萨拉齐', 4, '150221', '150221100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双龙', 4, '150221', '150221101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('美岱召', 4, '150221', '150221102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沟门', 4, '150221', '150221103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('将军尧', 4, '150221', '150221104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明沙淖', 4, '150221', '150221202', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海子', 4, '150221', '150221203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏波盖', 4, '150221', '150221212', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九峰山生态管理委员会', 4, '150221', '150221500', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固阳', 3, '1502', '150222', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金山', 4, '150222', '150222100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西斗铺', 4, '150222', '150222101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下湿壕', 4, '150222', '150222102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银号', 4, '150222', '150222103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀朔', 4, '150222', '150222104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴顺西', 4, '150222', '150222105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达尔罕茂明安联合旗', 3, '1502', '150223', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('百灵庙', 4, '150223', '150223100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满都拉', 4, '150223', '150223101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('希拉穆仁', 4, '150223', '150223102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明安', 4, '150223', '150223103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音花', 4, '150223', '150223104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石宝', 4, '150223', '150223105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌克忽洞', 4, '150223', '150223106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达尔汗苏木', 4, '150223', '150223216', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音敖包苏木', 4, '150223', '150223217', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干哈达苏木', 4, '150223', '150223218', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西河', 4, '150223', '150223219', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小文公', 4, '150223', '150223220', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌海', 2, '15', '1503', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海勃湾', 3, '1503', '150302', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '150302', '150302001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华西', 4, '150302', '150302002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤凰岭', 4, '150302', '150302003', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海北', 4, '150302', '150302004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '150302', '150302005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卡布其', 4, '150302', '150302006', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千里山', 4, '150302', '150302108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海勃湾千里山工业园区', 4, '150302', '150302400', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海南', 3, '1503', '150303', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西卓子山', 4, '150303', '150303001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拉僧仲', 4, '150303', '150303002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拉僧庙', 4, '150303', '150303101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公乌素', 4, '150303', '150303102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音陶亥', 4, '150303', '150303103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌达', 3, '1503', '150304', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音赛', 4, '150304', '150304001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道坎', 4, '150304', '150304002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五虎山', 4, '150304', '150304003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁家沟', 4, '150304', '150304004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新达', 4, '150304', '150304005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨海', 4, '150304', '150304006', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏海图', 4, '150304', '150304007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰淖尔', 4, '150304', '150304100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌达经济开发区', 4, '150304', '150304400', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤峰', 2, '15', '1504', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山', 3, '1504', '150402', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西屯', 4, '150402', '150402001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三中街', 4, '150402', '150402002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永巨', 4, '150402', '150402003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '150402', '150402004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南新街', 4, '150402', '150402005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '150402', '150402006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁南', 4, '150402', '150402007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长青', 4, '150402', '150402008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈达', 4, '150402', '150402009', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '150402', '150402010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥北', 4, '150402', '150402011', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红庙子', 4, '150402', '150402100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文钟', 4, '150402', '150402102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山工业园区', 4, '150402', '150402400', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山物流园区', 4, '150402', '150402401', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山区农畜产品加工产业园区', 4, '150402', '150402402', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元宝山', 3, '1504', '150403', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西露天', 4, '150403', '150403001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平庄城区', 4, '150403', '150403002', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平庄东城', 4, '150403', '150403003', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平庄西城', 4, '150403', '150403004', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云杉路', 4, '150403', '150403005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马林', 4, '150403', '150403006', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('风水沟', 4, '150403', '150403100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元宝山镇', 4, '150403', '150403101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('美丽河', 4, '150403', '150403102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平庄', 4, '150403', '150403103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五家', 4, '150403', '150403104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小五家', 4, '150403', '150403201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤峰市资源型经济转型开发试验区', 4, '150403', '150403400', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松山', 3, '1504', '150404', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振兴', 4, '150404', '150404001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '150404', '150404002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松州', 4, '150404', '150404003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 4, '150404', '150404004', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('穆家营子', 4, '150404', '150404100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('初头朗', 4, '150404', '150404101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大庙', 4, '150404', '150404102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王府', 4, '150404', '150404103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老府', 4, '150404', '150404104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈拉道口', 4, '150404', '150404105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上官地', 4, '150404', '150404106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安庆', 4, '150404', '150404107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平地', 4, '150404', '150404108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('当铺地', 4, '150404', '150404200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏家店', 4, '150404', '150404201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城子', 4, '150404', '150404202', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大夫营子', 4, '150404', '150404203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岗子', 4, '150404', '150404204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉龙', 4, '150404', '150404400', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('全宁', 4, '150404', '150404401', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴安', 4, '150404', '150404407', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿鲁科尔沁旗', 3, '1504', '150421', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天山', 4, '150421', '150421100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天山口', 4, '150421', '150421101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双胜', 4, '150421', '150421102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坤都', 4, '150421', '150421103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦花', 4, '150421', '150421104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绍根', 4, '150421', '150421105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎嘎斯台', 4, '150421', '150421106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新民', 4, '150421', '150421200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先锋', 4, '150421', '150421201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罕苏木苏木', 4, '150421', '150421202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛汉塔拉苏木', 4, '150421', '150421203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴拉奇如德苏木', 4, '150421', '150421204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦温都尔苏木', 4, '150421', '150421205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰哈达', 4, '150421', '150421206', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴林左旗', 3, '1504', '150422', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林东', 4, '150422', '150422100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆昌', 4, '150422', '150422101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十三敖包', 4, '150422', '150422102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碧流台', 4, '150422', '150422103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富河', 4, '150422', '150422104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音勿拉', 4, '150422', '150422105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈拉哈达', 4, '150422', '150422106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干哈达苏木', 4, '150422', '150422200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰达坝苏木', 4, '150422', '150422201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三山', 4, '150422', '150422202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花加拉嘎', 4, '150422', '150422203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林东西城', 4, '150422', '150422403', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林东东城', 4, '150422', '150422404', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴林右旗', 3, '1504', '150423', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大板', 4, '150423', '150423100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('索博日嘎', 4, '150423', '150423101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝日勿苏', 4, '150423', '150423102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干诺尔', 4, '150423', '150423103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦琥硕', 4, '150423', '150423105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西拉沐沦苏木', 4, '150423', '150423200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦塔拉苏木', 4, '150423', '150423201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('幸福之路苏木', 4, '150423', '150423202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干沐沦苏木', 4, '150423', '150423204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林西', 3, '1504', '150424', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官地', 4, '150424', '150424100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城子', 4, '150424', '150424101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新林', 4, '150424', '150424102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五十家子', 4, '150424', '150424103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林西镇', 4, '150424', '150424104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大井', 4, '150424', '150424105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('统部', 4, '150424', '150424106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营子', 4, '150424', '150424200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十二吐', 4, '150424', '150424201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城北街道筹备处', 4, '150424', '150424400', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城南街道筹备处', 4, '150424', '150424401', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('内蒙古林西工业园区', 4, '150424', '150424402', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克什克腾旗', 3, '1504', '150425', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('经棚', 4, '150425', '150425100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宇宙地', 4, '150425', '150425102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土城子', 4, '150425', '150425103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达来诺日', 4, '150425', '150425104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('同兴', 4, '150425', '150425105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万合永', 4, '150425', '150425106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芝瑞', 4, '150425', '150425108', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开地', 4, '150425', '150425208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山子', 4, '150425', '150425214', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达日罕乌拉苏木', 4, '150425', '150425219', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦查干苏木', 4, '150425', '150425221', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浩来呼热苏木', 4, '150425', '150425222', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰布统苏木', 4, '150425', '150425223', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克旗经棚街道筹备处', 4, '150425', '150425400', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('热水塘温泉疗养旅游开发区管委会', 4, '150425', '150425401', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翁牛特旗', 3, '1504', '150426', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌丹', 4, '150426', '150426100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌敦套海', 4, '150426', '150426101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五分地', 4, '150426', '150426102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥头', 4, '150426', '150426103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广德公', 4, '150426', '150426104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梧桐花', 4, '150426', '150426105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海拉苏', 4, '150426', '150426106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亿合公', 4, '150426', '150426107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放营子', 4, '150426', '150426200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿什罕苏木', 4, '150426', '150426201', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新苏莫苏木', 4, '150426', '150426202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音套海苏木', 4, '150426', '150426203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛山东', 4, '150426', '150426204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('格日僧苏木', 4, '150426', '150426205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉龙工业园区', 4, '150426', '150426400', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫城街道筹备处', 4, '150426', '150426402', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('全宁街道筹备处', 4, '150426', '150426403', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喀喇沁旗', 3, '1504', '150428', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦山', 4, '150428', '150428100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('美林', 4, '150428', '150428101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王爷府', 4, '150428', '150428102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小牛群', 4, '150428', '150428103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛家营子', 4, '150428', '150428104', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乃林', 4, '150428', '150428105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西桥', 4, '150428', '150428106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十家', 4, '150428', '150428200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南台子', 4, '150428', '150428201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赤峰市和美工贸园区', 4, '150428', '150428402', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁城', 3, '1504', '150429', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天义', 4, '150429', '150429100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小城子', 4, '150429', '150429101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大城子', 4, '150429', '150429102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里罕', 4, '150429', '150429103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑里河', 4, '150429', '150429104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甸子', 4, '150429', '150429105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大双庙', 4, '150429', '150429106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汐子', 4, '150429', '150429107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大明', 4, '150429', '150429108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('忙农', 4, '150429', '150429109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五化', 4, '150429', '150429110', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('必斯营子', 4, '150429', '150429111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三座店', 4, '150429', '150429112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('一肯中', 4, '150429', '150429202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('存金沟', 4, '150429', '150429203', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖汉旗', 3, '1504', '150430', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新惠', 4, '150430', '150430100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四家子', 4, '150430', '150430101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长胜', 4, '150430', '150430102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贝子府', 4, '150430', '150430103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四道湾子', 4, '150430', '150430104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下洼', 4, '150430', '150430105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金厂沟梁', 4, '150430', '150430106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆洼', 4, '150430', '150430107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄羊洼', 4, '150430', '150430108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古鲁板蒿', 4, '150430', '150430109', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛古吐', 4, '150430', '150430110', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木头营子', 4, '150430', '150430202', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰收', 4, '150430', '150430204', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玛尼罕', 4, '150430', '150430205', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('萨力巴', 4, '150430', '150430206', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖润苏莫苏木', 4, '150430', '150430207', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖汉旗新惠工业园区', 4, '150430', '150430401', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通辽', 2, '15', '1505', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁', 3, '1505', '150502', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁街道', 4, '150502', '150502001', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西门', 4, '150502', '150502002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永清', 4, '150502', '150502003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明仁', 4, '150502', '150502004', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('施介', 4, '150502', '150502005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团结', 4, '150502', '150502006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东郊', 4, '150502', '150502007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁路', 4, '150502', '150502008', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('电厂', 4, '150502', '150502009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霍林河', 4, '150502', '150502010', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '150502', '150502011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红星', 4, '150502', '150502012', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建国', 4, '150502', '150502013', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '150502', '150502014', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '150502', '150502015', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大林', 4, '150502', '150502100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钱家店', 4, '150502', '150502101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('余粮堡', 4, '150502', '150502102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木里图', 4, '150502', '150502104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰田', 4, '150502', '150502106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河', 4, '150502', '150502108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('育新', 4, '150502', '150502110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庆和', 4, '150502', '150502113', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖力布皋', 4, '150502', '150502114', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽河', 4, '150502', '150502130', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莫力庙苏木', 4, '150502', '150502200', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哲南农场', 4, '150502', '150502400', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三义堂农场', 4, '150502', '150502401', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('半截店牧场', 4, '150502', '150502405', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁左翼中旗', 3, '1505', '150521', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保康镇', 4, '150521', '150521100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝龙山', 4, '150521', '150521101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('舍伯吐', 4, '150521', '150521102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦塔拉', 4, '150521', '150521103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('门达', 4, '150521', '150521104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('架玛吐', 4, '150521', '150521105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腰林毛都', 4, '150521', '150521106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('希伯花', 4, '150521', '150521107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花吐古拉', 4, '150521', '150521108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('代力吉', 4, '150521', '150521109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('努日木', 4, '150521', '150521110', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('图布信苏木', 4, '150521', '150521204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('协代苏木', 4, '150521', '150521207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白兴吐苏木', 4, '150521', '150521210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花胡硕苏木', 4, '150521', '150521212', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖包苏木', 4, '150521', '150521213', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '150521', '150521214', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音塔拉农场', 4, '150521', '150521400', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('珠日河牧场', 4, '150521', '150521401', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰库牧场', 4, '150521', '150521402', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保康街道', 4, '150521', '150521403', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁左翼后旗', 3, '1505', '150522', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金宝屯', 4, '150522', '150522101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉尔嘎朗', 4, '150522', '150522102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双胜', 4, '150522', '150522103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿古拉', 4, '150522', '150522107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝鲁吐', 4, '150522', '150522109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海鲁吐', 4, '150522', '150522110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘旗卡', 4, '150522', '150522111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常胜', 4, '150522', '150522112', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查日苏', 4, '150522', '150522113', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('努古斯台', 4, '150522', '150522136', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿都沁苏木', 4, '150522', '150522208', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茂道吐苏木', 4, '150522', '150522209', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴胡塔苏木', 4, '150522', '150522210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('散都苏木', 4, '150522', '150522211', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦毛都苏木', 4, '150522', '150522212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利农场', 4, '150522', '150522400', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟根达坝牧场', 4, '150522', '150522401', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查金台牧场', 4, '150522', '150522402', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大青沟管理局', 4, '150522', '150522404', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈日乌苏种畜场', 4, '150522', '150522405', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝鲁吐林场', 4, '150522', '150522408', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊胡塔林场', 4, '150522', '150522410', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌旦塔拉林场', 4, '150522', '150522411', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开鲁', 3, '1505', '150523', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开鲁镇', 4, '150523', '150523100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大榆树', 4, '150523', '150523103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑龙坝', 4, '150523', '150523104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麦新', 4, '150523', '150523105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建华', 4, '150523', '150523108', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小街基', 4, '150523', '150523109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '150523', '150523111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉日嘎郎吐', 4, '150523', '150523112', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东来', 4, '150523', '150523113', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义和塔拉', 4, '150523', '150523114', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河牧场', 4, '150523', '150523400', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽河农场', 4, '150523', '150523401', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库伦旗', 3, '1505', '150524', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库伦街道', 4, '150524', '150524000', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库伦镇', 4, '150524', '150524100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六家子', 4, '150524', '150524101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额勒顺', 4, '150524', '150524103', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扣河子', 4, '150524', '150524104', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音花', 4, '150524', '150524105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茫汗苏木', 4, '150524', '150524203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泉', 4, '150524', '150524204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先进苏木', 4, '150524', '150524205', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奈曼旗', 3, '1505', '150525', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大沁他拉', 4, '150525', '150525100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八仙筒', 4, '150525', '150525101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青龙山', 4, '150525', '150525102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东明', 4, '150525', '150525103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('治安', 4, '150525', '150525104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义隆永', 4, '150525', '150525105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新镇', 4, '150525', '150525106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙日浩来', 4, '150525', '150525109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄花塔拉苏木', 4, '150525', '150525201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('固日班花苏木', 4, '150525', '150525202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音他拉苏木', 4, '150525', '150525203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明仁苏木', 4, '150525', '150525205', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土城子', 4, '150525', '150525206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇莲苏', 4, '150525', '150525207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国有六号农场', 4, '150525', '150525400', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎鲁特旗', 3, '1505', '150526', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲁北', 4, '150526', '150526100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨日河', 4, '150526', '150526101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄花山', 4, '150526', '150526103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴雅尔吐胡硕', 4, '150526', '150526104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘎亥图', 4, '150526', '150526105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香山', 4, '150526', '150526106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿日昆都楞', 4, '150526', '150526107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('格日朝鲁苏木', 4, '150526', '150526203', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌力吉木仁苏木', 4, '150526', '150526204', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦塔拉苏木', 4, '150526', '150526209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道老杜苏木', 4, '150526', '150526210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前德门苏木', 4, '150526', '150526211', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰哈达苏木', 4, '150526', '150526212', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查布嘎图苏木', 4, '150526', '150526213', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌额格其苏木', 4, '150526', '150526214', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌日根塔拉农场', 4, '150526', '150526402', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘎达苏种畜场', 4, '150526', '150526403', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霍林郭勒', 3, '1505', '150581', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('珠斯花', 4, '150581', '150581001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莫斯台', 4, '150581', '150581002', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝日呼吉尔', 4, '150581', '150581003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达来胡硕', 4, '150581', '150581004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙尔呼热', 4, '150581', '150581005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂尔多斯', 2, '15', '1506', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东胜', 3, '1506', '150602', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交通', 4, '150602', '150602001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公园', 4, '150602', '150602002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林荫', 4, '150602', '150602003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '150602', '150602004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富兴', 4, '150602', '150602005', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天骄', 4, '150602', '150602006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('诃额伦', 4, '150602', '150602007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音门克', 4, '150602', '150602008', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('民族', 4, '150602', '150602009', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('幸福', 4, '150602', '150602010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纺织', 4, '150602', '150602011', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴胜路', 4, '150602', '150602012', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泊尔江海子', 4, '150602', '150602106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罕台', 4, '150602', '150602107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铜川', 4, '150602', '150602108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康巴什', 3, '1506', '150603', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈巴格希', 4, '150603', '150603001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青春山', 4, '150603', '150603002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '150603', '150603003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达拉特旗', 3, '1506', '150621', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡尼', 4, '150621', '150621001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西园', 4, '150621', '150621002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔', 4, '150621', '150621003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工业', 4, '150621', '150621004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昭君街道', 4, '150621', '150621005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平原', 4, '150621', '150621006', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王爱召', 4, '150621', '150621108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('树林召', 4, '150621', '150621109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昭君镇', 4, '150621', '150621110', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白泥井', 4, '150621', '150621111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉格斯太', 4, '150621', '150621112', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中和西', 4, '150621', '150621113', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恩格贝', 4, '150621', '150621114', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('展旦召苏木', 4, '150621', '150621201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂尔多斯市生态示范区管理委员会', 4, '150621', '150621401', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('准格尔旗', 3, '1506', '150622', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊', 4, '150622', '150622001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓝天', 4, '150622', '150622002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 4, '150622', '150622003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎泽', 4, '150622', '150622004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛家湾', 4, '150622', '150622114', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙圪堵', 4, '150622', '150622115', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙口', 4, '150622', '150622116', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('准格尔召', 4, '150622', '150622117', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纳日松', 4, '150622', '150622118', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大路', 4, '150622', '150622119', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('布尔陶亥苏木', 4, '150622', '150622206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十二连城', 4, '150622', '150622207', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('暖水', 4, '150622', '150622208', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('准格尔经济开发区', 4, '150622', '150622400', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂托克前旗', 3, '1506', '150623', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖勒召其', 4, '150623', '150623105', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上海庙', 4, '150623', '150623106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昂素', 4, '150623', '150623107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城川', 4, '150623', '150623108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂托克旗', 3, '1506', '150624', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒙西', 4, '150624', '150624100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰', 4, '150624', '150624101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('棋盘井', 4, '150624', '150624102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木凯淖尔', 4, '150624', '150624103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏米图苏木', 4, '150624', '150624200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔巴斯苏木', 4, '150624', '150624203', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杭锦旗', 3, '1506', '150625', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡尼', 4, '150625', '150625100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴拉贡', 4, '150625', '150625101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉日嘎朗图', 4, '150625', '150625102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼和木都', 4, '150625', '150625103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('独贵塔拉', 4, '150625', '150625104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊和乌素苏木', 4, '150625', '150625206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌审旗', 3, '1506', '150626', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌审召', 4, '150626', '150626106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('图克', 4, '150626', '150626107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘎鲁图', 4, '150626', '150626108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰陶勒盖', 4, '150626', '150626109', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('无定河', 4, '150626', '150626110', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏力德苏木', 4, '150626', '150626203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊金霍洛旗', 3, '1506', '150627', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿勒腾席热', 4, '150627', '150627100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('札萨克', 4, '150627', '150627107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红庆河', 4, '150627', '150627108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊金霍洛', 4, '150627', '150627109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰木伦', 4, '150627', '150627110', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纳林陶亥', 4, '150627', '150627111', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏布尔嘎', 4, '150627', '150627113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼伦贝尔', 2, '15', '1507', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海拉尔', 3, '1507', '150702', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正阳', 4, '150702', '150702001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('靠山', 4, '150702', '150702003', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('健康', 4, '150702', '150702004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '150702', '150702005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼伦', 4, '150702', '150702006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '150702', '150702007', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奋斗', 4, '150702', '150702101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈克', 4, '150702', '150702102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎赉诺尔区', 3, '1507', '150703', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第一', 4, '150703', '150703001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第二', 4, '150703', '150703002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第三', 4, '150703', '150703003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第四', 4, '150703', '150703004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('第五', 4, '150703', '150703005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵泉', 4, '150703', '150703006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿荣旗', 3, '1507', '150721', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('那吉', 4, '150721', '150721100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六合', 4, '150721', '150721102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亚东', 4, '150721', '150721104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('复兴', 4, '150721', '150721105', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霍尔奇', 4, '150721', '150721106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳峪', 4, '150721', '150721108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三岔河', 4, '150721', '150721109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得力其', 4, '150721', '150721200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查巴奇', 4, '150721', '150721201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('音河', 4, '150721', '150721202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新发', 4, '150721', '150721203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('那吉屯农场', 4, '150721', '150721400', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莫力达瓦', 3, '1507', '150722', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尼尔基', 4, '150722', '150722100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红彦', 4, '150722', '150722101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝山', 4, '150722', '150722102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈达阳', 4, '150722', '150722103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔拉', 4, '150722', '150722104', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西瓦尔图', 4, '150722', '150722106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腾克', 4, '150722', '150722108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔温敖宝', 4, '150722', '150722110', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汉古尔河', 4, '150722', '150722120', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奎勒河', 4, '150722', '150722121', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦', 4, '150722', '150722200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜拉尔', 4, '150722', '150722203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库如奇', 4, '150722', '150722204', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国营甘河农场', 4, '150722', '150722400', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国营巴彦农场', 4, '150722', '150722401', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国营欧肯河农场', 4, '150722', '150722402', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国营东方红农场', 4, '150722', '150722403', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂伦春自治旗', 3, '1507', '150723', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿里河', 4, '150723', '150723100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('诺敏', 4, '150723', '150723102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌鲁布铁', 4, '150723', '150723104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大杨树', 4, '150723', '150723105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宜里', 4, '150723', '150723107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘河', 4, '150723', '150723109', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克一河', 4, '150723', '150723113', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉文', 4, '150723', '150723114', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古里', 4, '150723', '150723200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('托扎敏', 4, '150723', '150723216', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭管理局诺敏河农场', 4, '150723', '150723400', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭农场管理局扎赉河农场', 4, '150723', '150723402', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭农场管理局古里农场', 4, '150723', '150723403', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭农场管理局东方红农场', 4, '150723', '150723412', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭农场管理局欧肯河农场', 4, '150723', '150723413', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭林管局毕拉河林业局', 4, '150723', '150723414', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴安岭林管局乌尔其汗林业局', 4, '150723', '150723417', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂温克族自治旗', 3, '1507', '150724', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊敏河', 4, '150724', '150724101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦托海', 4, '150724', '150724102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红花尔基', 4, '150724', '150724104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大雁', 4, '150724', '150724105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦塔拉', 4, '150724', '150724200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊敏苏木', 4, '150724', '150724201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辉苏木', 4, '150724', '150724202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡尼河东苏木', 4, '150724', '150724203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡尼河西苏木', 4, '150724', '150724204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦嵯岗苏木', 4, '150724', '150724205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈巴尔虎旗', 3, '1507', '150725', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦库仁', 4, '150725', '150725100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝日希勒', 4, '150725', '150725101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼和诺尔', 4, '150725', '150725102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂温克民族苏木', 4, '150725', '150725201', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东乌珠尔苏木', 4, '150725', '150725202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦哈达苏木', 4, '150725', '150725203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈旗西乌珠尔苏木', 4, '150725', '150725204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈巴尔虎旗国营哈图达牧场', 4, '150725', '150725501', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈旗国营浩特陶海农牧场', 4, '150725', '150725502', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈旗国营特泥河牧场', 4, '150725', '150725503', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新巴尔虎左旗', 3, '1507', '150726', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿木古郎', 4, '150726', '150726100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嵯岗', 4, '150726', '150726101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新宝力格苏木', 4, '150726', '150726202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌布尔宝力格苏木', 4, '150726', '150726203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉布胡郎图苏木', 4, '150726', '150726204', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罕达盖苏木', 4, '150726', '150726205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘珠尔苏木', 4, '150726', '150726206', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嵯岗双娃牧场', 4, '150726', '150726400', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新巴尔虎右旗', 3, '1507', '150727', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉坦额莫勒', 4, '150727', '150727100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼伦', 4, '150727', '150727101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿日哈沙特', 4, '150727', '150727102', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('克尔伦苏木', 4, '150727', '150727204', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贝尔苏木', 4, '150727', '150727206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达赉苏木', 4, '150727', '150727207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝格德乌拉苏木', 4, '150727', '150727208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖尔金牧场', 4, '150727', '150727500', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满洲里', 3, '1507', '150781', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道北', 4, '150781', '150781001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴华', 4, '150781', '150781002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东山', 4, '150781', '150781003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道南', 4, '150781', '150781004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开河', 4, '150781', '150781100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牙克石', 3, '1507', '150782', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '150782', '150782001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '150782', '150782002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新工', 4, '150782', '150782003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永兴', 4, '150782', '150782004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '150782', '150782005', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('暖泉', 4, '150782', '150782006', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东兴', 4, '150782', '150782007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('免渡河', 4, '150782', '150782101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('博克图', 4, '150782', '150782103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绰河源', 4, '150782', '150782105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌尔其汉', 4, '150782', '150782108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库都尔', 4, '150782', '150782109', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('图里河', 4, '150782', '150782110', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌奴耳', 4, '150782', '150782111', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔尔气', 4, '150782', '150782112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊图里河', 4, '150782', '150782113', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莫拐农场', 4, '150782', '150782400', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牙克石农场', 4, '150782', '150782401', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('免渡河农场', 4, '150782', '150782402', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎兰屯', 3, '1507', '150783', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴华', 4, '150783', '150783001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正阳', 4, '150783', '150783002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('繁荣', 4, '150783', '150783003', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '150783', '150783004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 4, '150783', '150783005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '150783', '150783006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高台子', 4, '150783', '150783007', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磨菇气', 4, '150783', '150783100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧牛河', 4, '150783', '150783106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成吉思汗', 4, '150783', '150783108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河湾', 4, '150783', '150783109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈多河', 4, '150783', '150783110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浩饶山', 4, '150783', '150783112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴河', 4, '150783', '150783113', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中和', 4, '150783', '150783114', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达斡尔民族', 4, '150783', '150783200', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂伦春民族', 4, '150783', '150783201', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('萨马街', 4, '150783', '150783204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洼堤', 4, '150783', '150783205', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河湾农场', 4, '150783', '150783400', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绰尔河农场', 4, '150783', '150783401', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎兰屯马场', 4, '150783', '150783402', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成吉思汗牧场', 4, '150783', '150783403', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公安部后勤供应处农场', 4, '150783', '150783404', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南木林业局', 4, '150783', '150783405', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴河林业局', 4, '150783', '150783406', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎兰屯市林业局', 4, '150783', '150783407', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额尔古纳', 3, '1507', '150784', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拉布大林', 4, '150784', '150784001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上库力', 4, '150784', '150784002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莫尔道嘎', 4, '150784', '150784100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑山头', 4, '150784', '150784101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恩和哈达', 4, '150784', '150784102', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三河', 4, '150784', '150784200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒙兀室韦苏木', 4, '150784', '150784201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恩和', 4, '150784', '150784203', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奇乾', 4, '150784', '150784204', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('根河', 3, '1507', '150785', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '150785', '150785001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '150785', '150785002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('森工', 4, '150785', '150785003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金河', 4, '150785', '150785102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿龙山', 4, '150785', '150785103', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满归', 4, '150785', '150785104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得耳布尔', 4, '150785', '150785105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖鲁古雅', 4, '150785', '150785200', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦淖尔', 2, '15', '1508', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临河', 3, '1508', '150802', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团结', 4, '150802', '150802001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('车站', 4, '150802', '150802002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先锋', 4, '150802', '150802003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放', 4, '150802', '150802004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华街道', 4, '150802', '150802005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东环', 4, '150802', '150802006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁南', 4, '150802', '150802007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西环', 4, '150802', '150802008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北环', 4, '150802', '150802009', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金川', 4, '150802', '150802010', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汇丰', 4, '150802', '150802011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狼山', 4, '150802', '150802100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华镇', 4, '150802', '150802101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('干召庙', 4, '150802', '150802102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰图克', 4, '150802', '150802104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双河', 4, '150802', '150802107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '150802', '150802109', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白脑包', 4, '150802', '150802110', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八一', 4, '150802', '150802200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光', 4, '150802', '150802201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('狼山农场', 4, '150802', '150802400', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临河农场', 4, '150802', '150802401', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五原', 3, '1508', '150821', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆兴昌', 4, '150821', '150821100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔尔湖', 4, '150821', '150821101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦套海', 4, '150821', '150821102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新公中', 4, '150821', '150821104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天吉泰', 4, '150821', '150821105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜丰', 4, '150821', '150821106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银定图', 4, '150821', '150821107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('复兴', 4, '150821', '150821108', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和胜', 4, '150821', '150821200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磴口', 3, '1508', '150822', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦高勒', 4, '150822', '150822100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆盛合', 4, '150822', '150822103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渡口', 4, '150822', '150822104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('补隆淖', 4, '150822', '150822105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙金套海苏木', 4, '150822', '150822202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰布和农场', 4, '150822', '150822500', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦套海农场', 4, '150822', '150822501', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈腾套海农场', 4, '150822', '150822502', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('包尔盖农场', 4, '150822', '150822503', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纳林套海农场', 4, '150822', '150822504', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙漠林业实验中心农场', 4, '150822', '150822505', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉特前旗', 3, '1508', '150823', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉山', 4, '150823', '150823101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白彦花', 4, '150823', '150823102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新安', 4, '150823', '150823103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大佘太', 4, '150823', '150823104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西小召', 4, '150823', '150823106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明安', 4, '150823', '150823108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先锋', 4, '150823', '150823109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小佘太', 4, '150823', '150823110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏独仑', 4, '150823', '150823111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额尔登布拉格苏木', 4, '150823', '150823209', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙德格苏木', 4, '150823', '150823210', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉特中旗', 3, '1508', '150824', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德岭山', 4, '150824', '150824100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石哈河', 4, '150824', '150824101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海流图', 4, '150824', '150824102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌加河', 4, '150824', '150824103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘其毛都', 4, '150824', '150824105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温更', 4, '150824', '150824106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音乌兰苏木', 4, '150824', '150824203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼勒斯太苏木', 4, '150824', '150824205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新忽热苏木', 4, '150824', '150824207', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('川井苏木', 4, '150824', '150824208', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉特后旗', 3, '1508', '150825', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音宝力格', 4, '150825', '150825100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼和温都尔', 4, '150825', '150825101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潮格温都尔', 4, '150825', '150825103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('获各琦苏木', 4, '150825', '150825204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音前达门苏木', 4, '150825', '150825207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌盖苏木', 4, '150825', '150825208', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杭锦后旗', 3, '1508', '150826', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头道桥', 4, '150826', '150826101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二道桥', 4, '150826', '150826102', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道桥', 4, '150826', '150826103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团结', 4, '150826', '150826104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双庙', 4, '150826', '150826105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蛮会', 4, '150826', '150826106', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陕坝', 4, '150826', '150826107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙海', 4, '150826', '150826108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒙海', 4, '150826', '150826109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太阳庙农场', 4, '150826', '150826500', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰察布', 2, '15', '1509', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('集宁', 3, '1509', '150902', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新体路', 4, '150902', '150902001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥东', 4, '150902', '150902002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进路', 4, '150902', '150902003', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常青', 4, '150902', '150902004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虎山', 4, '150902', '150902005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥西', 4, '150902', '150902006', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华街', 4, '150902', '150902007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉山', 4, '150902', '150902008', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白海子', 4, '150902', '150902101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马莲渠', 4, '150902', '150902205', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卓资', 3, '1509', '150921', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卓资山', 4, '150921', '150921100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旗下营', 4, '150921', '150921101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十八台', 4, '150921', '150921102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音锡勒', 4, '150921', '150921103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梨花', 4, '150921', '150921104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大榆树', 4, '150921', '150921203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红召', 4, '150921', '150921208', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('复兴', 4, '150921', '150921209', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化德', 3, '1509', '150922', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长顺', 4, '150922', '150922100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七号', 4, '150922', '150922101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 4, '150922', '150922102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德包图', 4, '150922', '150922205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公腊胡洞', 4, '150922', '150922207', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音特拉', 4, '150922', '150922208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('商都', 3, '1509', '150923', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七台', 4, '150923', '150923100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十八顷', 4, '150923', '150923101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大黑沙土', 4, '150923', '150923102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西井子', 4, '150923', '150923103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('屯垦队', 4, '150923', '150923104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小海子', 4, '150923', '150923105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大库伦', 4, '150923', '150923205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卯都', 4, '150923', '150923206', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玻璃忽镜', 4, '150923', '150923207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三大顷', 4, '150923', '150923208', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴和', 3, '1509', '150924', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '150924', '150924100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张皋', 4, '150924', '150924101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛乌素', 4, '150924', '150924102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鄂尔栋', 4, '150924', '150924103', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('店子', 4, '150924', '150924105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大库联', 4, '150924', '150924202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('民族团结', 4, '150924', '150924205', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大同夭', 4, '150924', '150924206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五股泉', 4, '150924', '150924207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凉城', 3, '1509', '150925', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岱海', 4, '150925', '150925100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('麦胡图', 4, '150925', '150925101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永兴', 4, '150925', '150925102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六苏木', 4, '150925', '150925103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蛮汉', 4, '150925', '150925104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸿茅', 4, '150925', '150925105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天成', 4, '150925', '150925204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹碾', 4, '150925', '150925207', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察哈尔右翼前旗', 3, '1509', '150926', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土贵乌拉', 4, '150926', '150926100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平地泉', 4, '150926', '150926101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玫瑰营', 4, '150926', '150926102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音塔拉', 4, '150926', '150926104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄旗海', 4, '150926', '150926105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉哈', 4, '150926', '150926202', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄茂营', 4, '150926', '150926203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三岔口', 4, '150926', '150926208', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老圈沟', 4, '150926', '150926209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察右前旗天皮山冶金化工工业园区', 4, '150926', '150926400', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察哈尔右翼中旗', 3, '1509', '150927', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科布尔', 4, '150927', '150927100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁沙盖', 4, '150927', '150927101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌素图', 4, '150927', '150927102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广益隆', 4, '150927', '150927103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄羊城', 4, '150927', '150927104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宏盘', 4, '150927', '150927203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦', 4, '150927', '150927204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大滩', 4, '150927', '150927211', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰哈页苏木', 4, '150927', '150927214', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库伦苏木', 4, '150927', '150927215', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察右中旗土城子', 4, '150927', '150927216', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辉腾锡勒园区管理委员会', 4, '150927', '150927400', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察哈尔右翼后旗', 3, '1509', '150928', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察哈尔右翼后旗土牧尔台', 4, '150928', '150928100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红格尔图', 4, '150928', '150928101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音察干', 4, '150928', '150928102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贲红', 4, '150928', '150928103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大六号', 4, '150928', '150928105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('当郎忽洞苏木', 4, '150928', '150928204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察哈尔右翼后旗锡勒', 4, '150928', '150928206', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰哈达苏木', 4, '150928', '150928207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四子王旗', 3, '1509', '150929', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四子王旗乌兰花', 4, '150929', '150929100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('供济堂', 4, '150929', '150929101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉生太', 4, '150929', '150929102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('库伦图', 4, '150929', '150929103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音朝克图', 4, '150929', '150929104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东八号', 4, '150929', '150929208', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('忽鸡图', 4, '150929', '150929211', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干补力格苏木', 4, '150929', '150929215', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('脑木更苏木', 4, '150929', '150929219', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红格尔苏木', 4, '150929', '150929223', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江岸苏木', 4, '150929', '150929225', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴音敖包苏木', 4, '150929', '150929227', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大黑河', 4, '150929', '150929228', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰镇', 3, '1509', '150981', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城区', 4, '150981', '150981001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧城区', 4, '150981', '150981002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城区', 4, '150981', '150981003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工业区', 4, '150981', '150981004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城区', 4, '150981', '150981005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑土台', 4, '150981', '150981101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆盛庄', 4, '150981', '150981102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巨宝庄', 4, '150981', '150981103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红砂坝', 4, '150981', '150981104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三义泉', 4, '150981', '150981105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浑源窑', 4, '150981', '150981201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官屯堡', 4, '150981', '150981205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元山子', 4, '150981', '150981206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴安', 2, '15', '1522', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰浩特', 3, '1522', '152201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('爱国', 4, '152201', '152201001', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '152201', '152201002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴安', 4, '152201', '152201003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '152201', '152201004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 4, '152201', '152201005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('都林', 4, '152201', '152201006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五一', 4, '152201', '152201007', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城郊', 4, '152201', '152201008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰哈达', 4, '152201', '152201101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛根庙', 4, '152201', '152201102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太本站', 4, '152201', '152201103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义勒力特', 4, '152201', '152201104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼和马场', 4, '152201', '152201401', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔山', 3, '1522', '152202', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林海', 4, '152202', '152202001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '152202', '152202002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉', 4, '152202', '152202003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊尔施', 4, '152202', '152202004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔山市天池', 4, '152202', '152202100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白狼', 4, '152202', '152202101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五岔沟', 4, '152202', '152202102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明水河', 4, '152202', '152202103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁右翼前旗', 3, '1522', '152221', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('索伦', 4, '152221', '152221100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大石寨', 4, '152221', '152221101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('归流河', 4, '152221', '152221102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('察尔森', 4, '152221', '152221103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁', 4, '152221', '152221104', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额尔格图', 4, '152221', '152221110', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德伯斯', 4, '152221', '152221111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('居力很', 4, '152221', '152221119', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('俄体', 4, '152221', '152221120', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满族屯', 4, '152221', '152221203', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰毛都苏木', 4, '152221', '152221205', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿力得尔苏木', 4, '152221', '152221207', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴日嘎斯台', 4, '152221', '152221208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃合木苏木', 4, '152221', '152221209', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('跃进马场', 4, '152221', '152221400', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('索伦牧场', 4, '152221', '152221401', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿力得尔牧场', 4, '152221', '152221403', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公主陵牧场', 4, '152221', '152221404', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绿水种畜场', 4, '152221', '152221405', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科右前旗工业园区', 4, '152221', '152221407', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('科尔沁右翼中旗', 3, '1522', '152222', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦呼舒', 4, '152222', '152222100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高力板', 4, '152222', '152222101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吐列毛都', 4, '152222', '152222102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴仁哲里木', 4, '152222', '152222103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杜尔基', 4, '152222', '152222104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('好腰苏木', 4, '152222', '152222105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新佳木苏木', 4, '152222', '152222203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('代钦塔拉苏木', 4, '152222', '152222206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈日诺尔苏木', 4, '152222', '152222207', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦茫哈苏木', 4, '152222', '152222208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦淖尔苏木', 4, '152222', '152222209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额木庭高勒苏木', 4, '152222', '152222210', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('布敦化牧场', 4, '152222', '152222400', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吐列毛杜农场', 4, '152222', '152222401', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟恩套力盖矿区工作部', 4, '152222', '152222402', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('布敦化矿区工作部', 4, '152222', '152222403', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎赉特旗', 3, '1522', '152223', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('音德尔', 4, '152223', '152223100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新林', 4, '152223', '152223101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦高勒', 4, '152223', '152223102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡尔勒', 4, '152223', '152223103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔本格勒', 4, '152223', '152223104', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴达尔胡', 4, '152223', '152223105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('图牧吉', 4, '152223', '152223107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('好力保', 4, '152223', '152223108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦乌兰苏木', 4, '152223', '152223210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('努文木仁', 4, '152223', '152223211', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦扎拉嘎', 4, '152223', '152223212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉达尔吐苏木', 4, '152223', '152223213', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝力根花苏木', 4, '152223', '152223214', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('种畜场', 4, '152223', '152223404', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八一牧场', 4, '152223', '152223405', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴达尔胡农场', 4, '152223', '152223406', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('突泉', 3, '1522', '152224', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('突泉镇', 4, '152224', '152224100', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六户', 4, '152224', '152224101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东杜尔基', 4, '152224', '152224102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安', 4, '152224', '152224103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泉', 4, '152224', '152224104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝石', 4, '152224', '152224105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九龙', 4, '152224', '152224200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '152224', '152224201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('学田', 4, '152224', '152224202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东杜尔基国营农场', 4, '152224', '152224400', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡林郭勒', 2, '15', '1525', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二连浩特', 3, '1525', '152501', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('格日勒敖都苏木', 4, '152501', '152501200', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二连浩特市社区建设管理局', 4, '152501', '152501400', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二连边境经济技术合作区', 4, '152501', '152501401', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锡林浩特', 3, '1525', '152502', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('希日塔拉', 4, '152502', '152502001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝力根', 4, '152502', '152502002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杭盖', 4, '152502', '152502003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楚古兰', 4, '152502', '152502004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额尔敦', 4, '152502', '152502005', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南郊', 4, '152502', '152502006', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦锡勒', 4, '152502', '152502007', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦查干', 4, '152502', '152502008', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔善宝拉格', 4, '152502', '152502100', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝力根苏木', 4, '152502', '152502200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝克乌拉苏木', 4, '152502', '152502201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦宝拉格苏木', 4, '152502', '152502202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿旗德力格尔工业园区', 4, '152502', '152502401', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白音库伦牧场', 4, '152502', '152502500', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贝力克牧场', 4, '152502', '152502501', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛登牧场', 4, '152502', '152502502', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿巴嘎旗', 3, '1525', '152522', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('别力古台', 4, '152522', '152522100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪格尔高勒', 4, '152522', '152522101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干淖尔', 4, '152522', '152522102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('那仁宝拉格苏木', 4, '152522', '152522200', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊和高勒苏木', 4, '152522', '152522201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉尔嘎郎图苏木', 4, '152522', '152522202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦图嘎苏木', 4, '152522', '152522203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏尼特左旗', 3, '1525', '152523', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满都拉图', 4, '152523', '152523100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('查干敖包', 4, '152523', '152523101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦淖尔', 4, '152523', '152523102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦乌拉苏木', 4, '152523', '152523200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛罕高毕苏木', 4, '152523', '152523201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洪格尔苏木', 4, '152523', '152523202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达来苏木', 4, '152523', '152523203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏尼特左旗芒来循环经济产业园区', 4, '152523', '152523400', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恩格尔河灌区', 4, '152523', '152523500', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏尼特右旗', 3, '1525', '152524', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛汉塔拉', 4, '152524', '152524100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱日和', 4, '152524', '152524101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌日根塔拉', 4, '152524', '152524102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑宝拉格苏木', 4, '152524', '152524200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额仁淖尔苏木', 4, '152524', '152524201', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛罕乌力吉苏木', 4, '152524', '152524202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿其图乌拉苏木', 4, '152524', '152524203', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东乌珠穆沁旗', 3, '1525', '152525', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌里雅斯太', 4, '152525', '152525100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道特淖尔', 4, '152525', '152525101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘎达布其', 4, '152525', '152525102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满都胡宝拉格', 4, '152525', '152525103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额吉淖尔', 4, '152525', '152525104', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦胡硕', 4, '152525', '152525105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼热图淖尔苏木', 4, '152525', '152525200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('萨麦苏木', 4, '152525', '152525201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘎海乐苏木', 4, '152525', '152525202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉坦合力苏木', 4, '152525', '152525203', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌里雅斯太工业区', 4, '152525', '152525400', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈拉盖图农牧场', 4, '152525', '152525500', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贺斯格乌拉农牧场', 4, '152525', '152525501', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉盖牧场', 4, '152525', '152525502', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝格达乌拉总场', 4, '152525', '152525503', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西乌珠穆沁旗', 3, '1525', '152526', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴拉嘎尔高勒', 4, '152526', '152526100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦花', 4, '152526', '152526101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉仁高勒', 4, '152526', '152526102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浩勒图高勒', 4, '152526', '152526103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高日罕', 4, '152526', '152526104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦胡硕苏木', 4, '152526', '152526200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰哈拉嘎苏木', 4, '152526', '152526201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林业总场', 4, '152526', '152526500', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太仆寺旗', 3, '1525', '152527', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝昌', 4, '152527', '152527100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千斤沟', 4, '152527', '152527101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '152527', '152527102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('骆驼山', 4, '152527', '152527103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永丰', 4, '152527', '152527104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('幸福', 4, '152527', '152527200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贡宝拉格苏木', 4, '152527', '152527201', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镶黄旗', 3, '1525', '152528', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新宝拉格', 4, '152528', '152528100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦塔拉', 4, '152528', '152528101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翁贡乌拉苏木', 4, '152528', '152528200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝格达音高勒苏木', 4, '152528', '152528201', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正镶白旗', 3, '1525', '152529', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明安图', 4, '152529', '152529100', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('星耀', 4, '152529', '152529101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊和淖尔苏木', 4, '152529', '152529200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰查布苏木', 4, '152529', '152529201', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝拉根陶海苏木', 4, '152529', '152529202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额里图种畜场', 4, '152529', '152529500', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哲日根图林场', 4, '152529', '152529502', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正蓝旗', 3, '1525', '152530', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上都', 4, '152530', '152530100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑根达来', 4, '152530', '152530101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈毕日嘎', 4, '152530', '152530102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝绍代苏木', 4, '152530', '152530200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('那日图苏木', 4, '152530', '152530201', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛音呼都嘎苏木', 4, '152530', '152530202', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎格斯台苏木', 4, '152530', '152530203', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五一种畜场总场', 4, '152530', '152530500', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑城子示范区', 4, '152530', '152530501', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('多伦', 3, '1525', '152531', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大北沟', 4, '152531', '152531100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('多伦淖尔', 4, '152531', '152531101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滦源', 4, '152531', '152531102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡木山', 4, '152531', '152531201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西干沟', 4, '152531', '152531202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉善', 2, '15', '1529', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉善左旗', 3, '1529', '152921', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦浩特', 4, '152921', '152921100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('嘉尔嘎勒赛汉', 4, '152921', '152921101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温都尔勒图', 4, '152921', '152921102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉兰泰', 4, '152921', '152921103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌斯太', 4, '152921', '152921104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴润别立', 4, '152921', '152921105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宗别立', 4, '152921', '152921107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖伦布拉格', 4, '152921', '152921108', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腾格里额里斯', 4, '152921', '152921109', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦木仁苏木', 4, '152921', '152921203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌力吉苏木', 4, '152921', '152921207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额尔克哈什哈苏木', 4, '152921', '152921210', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦诺日公苏木', 4, '152921', '152921212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银根苏木', 4, '152921', '152921213', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('超格图呼热苏木', 4, '152921', '152921214', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦浩特额鲁特', 4, '152921', '152921402', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦浩特南环路', 4, '152921', '152921403', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦浩特新华', 4, '152921', '152921404', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦浩特王府', 4, '152921', '152921405', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉善右旗', 3, '1529', '152922', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴丹吉林', 4, '152922', '152922100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雅布赖', 4, '152922', '152922101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉腾敖包', 4, '152922', '152922103', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿拉腾朝格苏木', 4, '152922', '152922201', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曼德拉苏木', 4, '152922', '152922205', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔木素布拉格苏木', 4, '152922', '152922206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦高勒苏木', 4, '152922', '152922207', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('额济纳旗', 3, '1529', '152923', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '152923', '152923101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达来呼布', 4, '152923', '152923102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈日布日格德音乌拉', 4, '152923', '152923103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛汉陶来苏木', 4, '152923', '152923200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马鬃山苏木', 4, '152923', '152923204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏泊淖尔苏木', 4, '152923', '152923205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴彦陶来苏木', 4, '152923', '152923206', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温图高勒苏木', 4, '152923', '152923207', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽宁', 1, '0', '21', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈阳', 2, '21', '2101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 3, '2101', '210102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浑河湾', 4, '210102', '210102001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '210102', '210102002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太原街', 4, '210102', '210102005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北市场', 4, '210102', '210102010', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南市场', 4, '210102', '210102014', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马路湾', 4, '210102', '210102016', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南湖', 4, '210102', '210102019', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长白', 4, '210102', '210102021', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈水湾', 4, '210102', '210102022', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浑河站西', 4, '210102', '210102023', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈河', 3, '2101', '210103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨河', 4, '210103', '210103005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万莲', 4, '210103', '210103006', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱剪炉', 4, '210103', '210103013', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北站', 4, '210103', '210103014', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('风雨坛', 4, '210103', '210103015', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五里河', 4, '210103', '210103017', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皇城', 4, '210103', '210103018', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马官桥', 4, '210103', '210103019', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南塔', 4, '210103', '210103020', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东陵', 4, '210103', '210103021', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉园', 4, '210103', '210103022', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大东', 3, '2101', '210104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大北', 4, '210104', '210104002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万泉', 4, '210104', '210104003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文官', 4, '210104', '210104006', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二台子', 4, '210104', '210104007', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东站', 4, '210104', '210104009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长安', 4, '210104', '210104012', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东塔', 4, '210104', '210104015', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('津桥', 4, '210104', '210104016', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进', 4, '210104', '210104017', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上园', 4, '210104', '210104018', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皇姑', 3, '2101', '210105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('舍利塔', 4, '210105', '210105020', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄河', 4, '210105', '210105021', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三台子', 4, '210105', '210105022', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新乐', 4, '210105', '210105023', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明廉', 4, '210105', '210105025', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华山', 4, '210105', '210105028', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北塔', 4, '210105', '210105029', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陵东', 4, '210105', '210105030', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四台子', 4, '210105', '210105031', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸭绿江', 4, '210105', '210105032', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 3, '2101', '210106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昆明湖', 4, '210106', '210106001', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工人村', 4, '210106', '210106003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('启工', 4, '210106', '210106007', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴顺', 4, '210106', '210106011', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('笃工', 4, '210106', '210106013', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴华', 4, '210106', '210106015', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('霁虹', 4, '210106', '210106019', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌空', 4, '210106', '210106020', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('重工', 4, '210106', '210106023', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翟家', 4, '210106', '210106025', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大青中朝友谊', 4, '210106', '210106026', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大潘', 4, '210106', '210106027', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高花', 4, '210106', '210106028', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彰驿站', 4, '210106', '210106029', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家屯', 3, '2101', '210111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放', 4, '210111', '210111001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('民主', 4, '210111', '210111003', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中兴', 4, '210111', '210111005', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林盛', 4, '210111', '210111009', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河', 4, '210111', '210111010', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十里河', 4, '210111', '210111011', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈相', 4, '210111', '210111012', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永乐', 4, '210111', '210111015', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佟沟', 4, '210111', '210111018', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八一红菱', 4, '210111', '210111019', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈水', 4, '210111', '210111020', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白清姚千', 4, '210111', '210111021', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浑南', 3, '2101', '210112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃仙', 4, '210112', '210112005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深井子', 4, '210112', '210112006', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祝家', 4, '210112', '210112007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔', 4, '210112', '210112008', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李相', 4, '210112', '210112010', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五三', 4, '210112', '210112014', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浑河站东', 4, '210112', '210112015', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东湖', 4, '210112', '210112016', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高坎', 4, '210112', '210112017', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满堂', 4, '210112', '210112018', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王滨', 4, '210112', '210112019', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汪家', 4, '210112', '210112021', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈北新区', 3, '2101', '210113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城子', 4, '210113', '210113001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清水台', 4, '210113', '210113002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('道义', 4, '210113', '210113003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辉山', 4, '210113', '210113004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虎石台', 4, '210113', '210113005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('财落', 4, '210113', '210113006', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆台', 4, '210113', '210113008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄家', 4, '210113', '210113011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马刚', 4, '210113', '210113014', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正良', 4, '210113', '210113015', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于洪', 3, '2101', '210114', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('迎宾路', 4, '210114', '210114001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陵西', 4, '210114', '210114003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东湖', 4, '210114', '210114004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平罗', 4, '210114', '210114005', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马三家', 4, '210114', '210114006', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙岭', 4, '210114', '210114007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('造化', 4, '210114', '210114008', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北陵', 4, '210114', '210114011', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南阳湖', 4, '210114', '210114013', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光辉', 4, '210114', '210114014', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽中', 3, '2101', '210115', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲西', 4, '210115', '210115001', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒲东', 4, '210115', '210115002', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('茨榆坨', 4, '210115', '210115003', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城郊', 4, '210115', '210115004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于家房', 4, '210115', '210115101', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱家房', 4, '210115', '210115102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冷子堡', 4, '210115', '210115103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘二堡', 4, '210115', '210115104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满都户', 4, '210115', '210115107', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨士岗', 4, '210115', '210115108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('肖寨门', 4, '210115', '210115109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六间房', 4, '210115', '210115110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('养士堡', 4, '210115', '210115111', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('潘家堡', 4, '210115', '210115112', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老大房', 4, '210115', '210115118', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大黑岗子', 4, '210115', '210115119', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛心坨', 4, '210115', '210115120', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四方台', 4, '210115', '210115121', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长滩', 4, '210115', '210115122', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新民屯', 4, '210115', '210115123', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康平', 3, '2101', '210123', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北三家子', 4, '210123', '210123001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '210123', '210123002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东关', 4, '210123', '210123003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小城子', 4, '210123', '210123101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张强', 4, '210123', '210123102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('方家屯', 4, '210123', '210123103', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郝官屯', 4, '210123', '210123105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二牛所口', 4, '210123', '210123106', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北四家子', 4, '210123', '210123203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两家子', 4, '210123', '210123204', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海洲窝堡', 4, '210123', '210123206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙金台', 4, '210123', '210123208', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳树屯', 4, '210123', '210123209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西关屯', 4, '210123', '210123210', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东升', 4, '210123', '210123211', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('法库', 3, '2101', '210124', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉祥', 4, '210124', '210124001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙山', 4, '210124', '210124002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孤家子', 4, '210124', '210124101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三面船', 4, '210124', '210124102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秀水河子', 4, '210124', '210124103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('叶茂台', 4, '210124', '210124104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('登仕堡子', 4, '210124', '210124105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏家沟', 4, '210124', '210124106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丁家房', 4, '210124', '210124107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟家', 4, '210124', '210124108', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十间房', 4, '210124', '210124109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯贝堡', 4, '210124', '210124120', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('依牛堡子', 4, '210124', '210124121', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('包家屯', 4, '210124', '210124123', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('慈恩寺', 4, '210124', '210124201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '210124', '210124203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四家子', 4, '210124', '210124208', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双台子', 4, '210124', '210124209', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧牛石', 4, '210124', '210124210', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新民', 3, '2101', '210181', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '210181', '210181001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽滨', 4, '210181', '210181002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '210181', '210181003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新柳', 4, '210181', '210181004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大红旗', 4, '210181', '210181101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁山', 4, '210181', '210181102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公主屯', 4, '210181', '210181103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 4, '210181', '210181104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前当堡', 4, '210181', '210181105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大民屯', 4, '210181', '210181106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大柳屯', 4, '210181', '210181107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆堡', 4, '210181', '210181108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡台', 4, '210181', '210181109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('法哈牛', 4, '210181', '210181110', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳河沟', 4, '210181', '210181111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高台子', 4, '210181', '210181112', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗家房', 4, '210181', '210181113', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道岗子', 4, '210181', '210181114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周坨子', 4, '210181', '210181115', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东蛇山子', 4, '210181', '210181116', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶家屯', 4, '210181', '210181117', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家屯', 4, '210181', '210181118', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金五台子', 4, '210181', '210181119', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新农村', 4, '210181', '210181120', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '210181', '210181205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卢家屯', 4, '210181', '210181206', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姚堡', 4, '210181', '210181207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于家窝堡', 4, '210181', '210181209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大连', 2, '21', '2102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中山', 3, '2102', '210202', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃源', 4, '210202', '210202011', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老虎滩', 4, '210202', '210202012', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海军广场', 4, '210202', '210202014', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('人民路', 4, '210202', '210202019', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青泥洼桥', 4, '210202', '210202020', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葵英', 4, '210202', '210202021', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西岗', 3, '2102', '210203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('香炉礁', 4, '210203', '210203001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八一路', 4, '210203', '210203010', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白云', 4, '210203', '210203013', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('日新', 4, '210203', '210203016', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('人民广场', 4, '210203', '210203017', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河口', 3, '2102', '210204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('春柳', 4, '210204', '210204006', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马栏', 4, '210204', '210204008', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南沙河口', 4, '210204', '210204009', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑石礁', 4, '210204', '210204010', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家', 4, '210204', '210204011', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('星海湾', 4, '210204', '210204017', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西安路', 4, '210204', '210204018', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘井子', 3, '2102', '210211', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周水子', 4, '210211', '210211001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘井子街道', 4, '210211', '210211004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南关岭', 4, '210211', '210211006', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泡崖', 4, '210211', '210211007', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('机场', 4, '210211', '210211010', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辛寨子', 4, '210211', '210211014', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '210211', '210211015', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大连湾', 4, '210211', '210211017', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('椒金山', 4, '210211', '210211018', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉水', 4, '210211', '210211019', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营城子', 4, '210211', '210211021', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('革镇堡', 4, '210211', '210211022', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌水', 4, '210211', '210211023', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七贤岭', 4, '210211', '210211024', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中华路', 4, '210211', '210211025', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旅顺口', 3, '2102', '210212', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水师营', 4, '210212', '210212005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁山', 4, '210212', '210212006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双岛湾', 4, '210212', '210212007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长城', 4, '210212', '210212009', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙头', 4, '210212', '210212010', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江西', 4, '210212', '210212013', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙王塘', 4, '210212', '210212014', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得胜', 4, '210212', '210212015', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三涧堡', 4, '210212', '210212016', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('登峰', 4, '210212', '210212017', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金州', 3, '2102', '210213', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拥政', 4, '210213', '210213001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友谊', 4, '210213', '210213002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '210213', '210213008', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先进', 4, '210213', '210213009', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华家', 4, '210213', '210213010', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('登沙河', 4, '210213', '210213014', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏树', 4, '210213', '210213015', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大魏家', 4, '210213', '210213017', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向应', 4, '210213', '210213018', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七顶山', 4, '210213', '210213019', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马桥子', 4, '210213', '210213020', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海青岛', 4, '210213', '210213021', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孤山', 4, '210213', '210213022', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湾里', 4, '210213', '210213023', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('董家沟', 4, '210213', '210213024', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金石滩', 4, '210213', '210213025', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得胜', 4, '210213', '210213027', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大李家', 4, '210213', '210213028', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二十里堡', 4, '210213', '210213029', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亮甲店', 4, '210213', '210213030', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('炮台', 4, '210213', '210213031', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('复州湾', 4, '210213', '210213032', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三十里堡', 4, '210213', '210213033', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石河', 4, '210213', '210213034', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光中', 4, '210213', '210213035', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('普兰店', 3, '2102', '210214', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰荣', 4, '210214', '210214001', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 4, '210214', '210214002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大刘家', 4, '210214', '210214007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨树房', 4, '210214', '210214008', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('皮口', 4, '210214', '210214009', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城子坦', 4, '210214', '210214010', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐家房', 4, '210214', '210214011', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大谭', 4, '210214', '210214012', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲山', 4, '210214', '210214013', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安波', 4, '210214', '210214014', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙包', 4, '210214', '210214015', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('星台', 4, '210214', '210214016', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐甲', 4, '210214', '210214017', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('墨盘', 4, '210214', '210214018', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('同益', 4, '210214', '210214019', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塔', 4, '210214', '210214020', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四平', 4, '210214', '210214021', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '210214', '210214022', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长海', 3, '2102', '210224', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大长山岛', 4, '210224', '210224100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('獐子岛', 4, '210224', '210224101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广鹿岛', 4, '210224', '210224102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小长山岛', 4, '210224', '210224103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海洋岛', 4, '210224', '210224104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瓦房店', 3, '2102', '210281', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '210281', '210281001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文兰', 4, '210281', '210281002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岭东', 4, '210281', '210281003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('共济', 4, '210281', '210281004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 4, '210281', '210281005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祝华', 4, '210281', '210281006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岗店', 4, '210281', '210281007', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九龙', 4, '210281', '210281008', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太阳', 4, '210281', '210281009', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长兴岛', 4, '210281', '210281010', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('交流岛', 4, '210281', '210281011', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('复州城', 4, '210281', '210281101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松树', 4, '210281', '210281103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得利寺', 4, '210281', '210281105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万家岭', 4, '210281', '210281106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('许屯', 4, '210281', '210281107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永宁', 4, '210281', '210281108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谢屯', 4, '210281', '210281109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老虎屯', 4, '210281', '210281112', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红沿河', 4, '210281', '210281113', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李官', 4, '210281', '210281115', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仙浴湾', 4, '210281', '210281116', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瓦窝', 4, '210281', '210281117', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元台', 4, '210281', '210281118', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵屯', 4, '210281', '210281201', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土城', 4, '210281', '210281203', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎店', 4, '210281', '210281204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西杨', 4, '210281', '210281205', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('驼山', 4, '210281', '210281206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三台', 4, '210281', '210281208', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泡崖', 4, '210281', '210281210', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家', 4, '210281', '210281212', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庄河', 3, '2102', '210283', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '210283', '210283001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '210283', '210283002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴达', 4, '210283', '210283003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌盛', 4, '210283', '210283004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明阳', 4, '210283', '210283005', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青堆', 4, '210283', '210283101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐岭', 4, '210283', '210283102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑岛', 4, '210283', '210283104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('栗子房', 4, '210283', '210283105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营', 4, '210283', '210283107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔岭', 4, '210283', '210283108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仙人洞', 4, '210283', '210283109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓉花山', 4, '210283', '210283110', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长岭', 4, '210283', '210283111', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荷花山', 4, '210283', '210283112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城山', 4, '210283', '210283113', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明山', 4, '210283', '210283114', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大郑', 4, '210283', '210283115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家', 4, '210283', '210283116', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴炉', 4, '210283', '210283118', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鞍子山', 4, '210283', '210283204', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平岭', 4, '210283', '210283208', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('步云山', 4, '210283', '210283209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桂云花', 4, '210283', '210283211', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兰店', 4, '210283', '210283214', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石城', 4, '210283', '210283216', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鞍山', 2, '21', '2103', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 3, '2103', '210302', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放', 4, '210302', '210302002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山南', 4, '210302', '210302003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('园林', 4, '210302', '210302004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '210302', '210302006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '210302', '210302008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湖南', 4, '210302', '210302011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新兴', 4, '210302', '210302013', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧堡', 4, '210302', '210302014', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孤山', 4, '210302', '210302015', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 3, '2103', '210303', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('繁荣', 4, '210303', '210303002', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八家子', 4, '210303', '210303003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('共和', 4, '210303', '210303005', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永乐', 4, '210303', '210303006', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南华', 4, '210303', '210303008', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大陆', 4, '210303', '210303009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永发', 4, '210303', '210303012', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达道湾', 4, '210303', '210303013', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁远', 4, '210303', '210303014', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('立山', 3, '2103', '210304', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('友好', 4, '210304', '210304001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双山', 4, '210304', '210304004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('立山街道', 4, '210304', '210304006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光', 4, '210304', '210304008', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灵山', 4, '210304', '210304009', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深沟寺', 4, '210304', '210304014', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河', 4, '210304', '210304015', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐大山', 4, '210304', '210304019', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千山', 4, '210304', '210304020', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千山', 3, '2103', '210311', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤岗子', 4, '210311', '210311001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东鞍山', 4, '210311', '210311002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐家房', 4, '210311', '210311102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘泉', 4, '210311', '210311111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '210311', '210311112', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台安', 3, '2103', '210321', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八角台', 4, '210321', '210321001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台东', 4, '210321', '210321002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西佛', 4, '210321', '210321101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开河', 4, '210321', '210321102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄沙坨', 4, '210321', '210321103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高力房', 4, '210321', '210321104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑林', 4, '210321', '210321105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富家', 4, '210321', '210321106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达牛', 4, '210321', '210321107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韭菜台', 4, '210321', '210321109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新台', 4, '210321', '210321110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桓洞', 4, '210321', '210321111', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岫岩', 3, '2103', '210323', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜昌', 4, '210323', '210323001', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雅河', 4, '210323', '210323003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 4, '210323', '210323004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三家子', 4, '210323', '210323101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石庙子', 4, '210323', '210323102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄花甸', 4, '210323', '210323103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营子', 4, '210323', '210323104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏子沟', 4, '210323', '210323105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('偏岭', 4, '210323', '210323106', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈达碑', 4, '210323', '210323107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新甸', 4, '210323', '210323108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洋河', 4, '210323', '210323109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家堡', 4, '210323', '210323111', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清凉山', 4, '210323', '210323112', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石灰窑', 4, '210323', '210323113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前营', 4, '210323', '210323114', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙潭', 4, '210323', '210323115', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牧牛', 4, '210323', '210323116', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('药山', 4, '210323', '210323117', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大房身', 4, '210323', '210323118', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 4, '210323', '210323119', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗营子', 4, '210323', '210323206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岭沟', 4, '210323', '210323211', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哨子河', 4, '210323', '210323212', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海城', 3, '2103', '210381', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海州', 4, '210381', '210381001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴海', 4, '210381', '210381002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('响堂', 4, '210381', '210381003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东四', 4, '210381', '210381004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉', 4, '210381', '210381006', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤山', 4, '210381', '210381101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔沟', 4, '210381', '210381102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('接文', 4, '210381', '210381103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('析木', 4, '210381', '210381104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马风', 4, '210381', '210381105', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牌楼', 4, '210381', '210381107', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里', 4, '210381', '210381108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛祁', 4, '210381', '210381109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英落', 4, '210381', '210381110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('感王', 4, '210381', '210381111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西柳', 4, '210381', '210381112', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中小', 4, '210381', '210381113', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王石', 4, '210381', '210381114', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南台', 4, '210381', '210381115', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腾鳌', 4, '210381', '210381118', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('耿庄', 4, '210381', '210381121', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛庄', 4, '210381', '210381123', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西四', 4, '210381', '210381124', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望台', 4, '210381', '210381125', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温香', 4, '210381', '210381126', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高坨', 4, '210381', '210381127', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('抚顺', 2, '21', '2104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新抚', 3, '2104', '210402', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '210402', '210402001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('福民', 4, '210402', '210402005', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新抚街道', 4, '210402', '210402007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆林', 4, '210402', '210402009', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安台', 4, '210402', '210402011', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘山', 4, '210402', '210402019', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千金', 4, '210402', '210402200', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东洲', 3, '2104', '210403', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东洲街道', 4, '210403', '210403002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('搭连', 4, '210403', '210403004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙凤', 4, '210403', '210403005', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新屯', 4, '210403', '210403006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万新', 4, '210403', '210403007', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老虎台', 4, '210403', '210403008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章党街道', 4, '210403', '210403012', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章党镇', 4, '210403', '210403100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈达', 4, '210403', '210403101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碾盘', 4, '210403', '210403202', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兰山', 4, '210403', '210403203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望花', 3, '2104', '210404', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工农', 4, '210404', '210404002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '210404', '210404003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '210404', '210404004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明', 4, '210404', '210404005', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朴屯', 4, '210404', '210404006', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('演武', 4, '210404', '210404007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李石', 4, '210404', '210404011', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔峪', 4, '210404', '210404101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拉古', 4, '210404', '210404200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('顺城', 3, '2104', '210411', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长春', 4, '210411', '210411002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛布', 4, '210411', '210411003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('将军堡', 4, '210411', '210411004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '210411', '210411005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('抚顺城', 4, '210411', '210411007', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前甸', 4, '210411', '210411102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 4, '210411', '210411201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('会元', 4, '210411', '210411205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('抚顺县', 3, '2104', '210421', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石文', 4, '210421', '210421101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后安', 4, '210421', '210421102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('救兵', 4, '210421', '210421103', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上马', 4, '210421', '210421104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马圈子', 4, '210421', '210421204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('峡河', 4, '210421', '210421209', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海浪', 4, '210421', '210421211', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤图', 4, '210421', '210421216', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新宾', 3, '2104', '210422', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新宾镇', 4, '210422', '210422100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旺清门', 4, '210422', '210422101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永陵', 4, '210422', '210422102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平顶山', 4, '210422', '210422103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大四平', 4, '210422', '210422104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇子峪', 4, '210422', '210422105', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木奇', 4, '210422', '210422106', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上夹河', 4, '210422', '210422108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南杂木', 4, '210422', '210422109', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红升', 4, '210422', '210422202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('响水河子', 4, '210422', '210422203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红庙子', 4, '210422', '210422204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北四平', 4, '210422', '210422205', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆树', 4, '210422', '210422207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下夹河', 4, '210422', '210422208', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清原', 3, '2104', '210423', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清原镇', 4, '210423', '210423100', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红透山', 4, '210423', '210423101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北三家', 4, '210423', '210423102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草市', 4, '210423', '210423103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英额门', 4, '210423', '210423104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南口前', 4, '210423', '210423105', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南山城', 4, '210423', '210423106', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湾甸子', 4, '210423', '210423107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大孤家', 4, '210423', '210423108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏家堡', 4, '210423', '210423109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土口子', 4, '210423', '210423203', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敖家堡', 4, '210423', '210423206', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大苏河', 4, '210423', '210423207', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('枸乃甸', 4, '210423', '210423208', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('本溪', 2, '21', '2105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平山', 3, '2105', '210502', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南地', 4, '210502', '210502001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平山街道', 4, '210502', '210502003', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东明', 4, '210502', '210502004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('崔东', 4, '210502', '210502005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '210502', '210502007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('千金', 4, '210502', '210502008', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桥北', 4, '210502', '210502012', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('溪湖', 3, '2105', '210503', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河东', 4, '210503', '210503001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '210503', '210503003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彩屯', 4, '210503', '210503005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '210503', '210503009', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石桥子', 4, '210503', '210503010', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('日月岛', 4, '210503', '210503012', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('火连寨', 4, '210503', '210503013', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明山', 3, '2105', '210504', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北地', 4, '210504', '210504002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高峪', 4, '210504', '210504004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明山街道', 4, '210504', '210504005', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新明', 4, '210504', '210504008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛心台', 4, '210504', '210504009', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧龙', 4, '210504', '210504010', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高台子', 4, '210504', '210504011', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南芬', 3, '2105', '210505', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南芬街道', 4, '210505', '210505001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('思山岭', 4, '210505', '210505004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下马塘', 4, '210505', '210505005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('本溪满族自治县', 3, '2105', '210521', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('观音阁', 4, '210521', '210521003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小市', 4, '210521', '210521100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草河掌', 4, '210521', '210521101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草河城', 4, '210521', '210521102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草河口', 4, '210521', '210521103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连山关', 4, '210521', '210521104', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河城', 4, '210521', '210521106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田师傅', 4, '210521', '210521109', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南甸子', 4, '210521', '210521110', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碱厂', 4, '210521', '210521111', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高官', 4, '210521', '210521112', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东营坊', 4, '210521', '210521202', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桓仁', 3, '2105', '210522', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八卦城', 4, '210522', '210522001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桓仁镇', 4, '210522', '210522100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('普乐堡', 4, '210522', '210522101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二棚甸子', 4, '210522', '210522102', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙尖子', 4, '210522', '210522103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五里甸子', 4, '210522', '210522104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里甸子', 4, '210522', '210522108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华来', 4, '210522', '210522110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '210522', '210522111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雅河', 4, '210522', '210522201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '210522', '210522202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑沟', 4, '210522', '210522206', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北甸子', 4, '210522', '210522208', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丹东', 2, '21', '2106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元宝', 3, '2106', '210602', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七道', 4, '210602', '210602002', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九道', 4, '210602', '210602004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴东', 4, '210602', '210602006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广济', 4, '210602', '210602007', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金山', 4, '210602', '210602101', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振兴', 3, '2106', '210603', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '210603', '210603002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临江', 4, '210603', '210603003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('帽盔山', 4, '210603', '210603005', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纤维', 4, '210603', '210603006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永昌', 4, '210603', '210603007', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('花园', 4, '210603', '210603008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('浪头', 4, '210603', '210603101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安民', 4, '210603', '210603102', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤池', 4, '210603', '210603103', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振安', 3, '2106', '210604', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸭绿江', 4, '210604', '210604001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金矿', 4, '210604', '210604003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('珍珠', 4, '210604', '210604004', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平湾', 4, '210604', '210604005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('同兴', 4, '210604', '210604102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五龙背', 4, '210604', '210604104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('楼房', 4, '210604', '210604105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九连城', 4, '210604', '210604106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤山城', 4, '210604', '210604107', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宽甸', 3, '2106', '210624', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宽甸镇', 4, '210624', '210624100', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灌水', 4, '210624', '210624101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('硼海', 4, '210624', '210624102', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红石', 4, '210624', '210624103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛甸子', 4, '210624', '210624104', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长甸', 4, '210624', '210624105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永甸', 4, '210624', '210624106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平哨', 4, '210624', '210624108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青山沟', 4, '210624', '210624109', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛毛坞', 4, '210624', '210624110', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大川头', 4, '210624', '210624111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青椅山', 4, '210624', '210624112', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨木川', 4, '210624', '210624113', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虎山', 4, '210624', '210624114', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振江', 4, '210624', '210624115', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('步达远', 4, '210624', '210624116', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大西岔', 4, '210624', '210624117', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八河川', 4, '210624', '210624118', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双山子', 4, '210624', '210624119', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石湖沟', 4, '210624', '210624201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下露河', 4, '210624', '210624202', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古楼子', 4, '210624', '210624206', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东港', 3, '2106', '210681', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大东', 4, '210681', '210681001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新兴', 4, '210681', '210681002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '210681', '210681003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤山', 4, '210681', '210681101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前阳', 4, '210681', '210681104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长安', 4, '210681', '210681105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十字街', 4, '210681', '210681106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长山', 4, '210681', '210681107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北井子', 4, '210681', '210681108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('椅圈', 4, '210681', '210681109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土坎', 4, '210681', '210681110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家店', 4, '210681', '210681113', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙王庙', 4, '210681', '210681114', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小甸子', 4, '210681', '210681115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('菩萨庙', 4, '210681', '210681117', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑沟', 4, '210681', '210681118', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新农', 4, '210681', '210681119', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合隆', 4, '210681', '210681204', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤城', 3, '2106', '210682', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤凰城', 4, '210682', '210682001', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凤山', 4, '210682', '210682002', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草河', 4, '210682', '210682003', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝山', 4, '210682', '210682101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白旗', 4, '210682', '210682102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙里寨', 4, '210682', '210682103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '210682', '210682104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蓝旗', 4, '210682', '210682105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('边门', 4, '210682', '210682107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东汤', 4, '210682', '210682110', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石城', 4, '210682', '210682111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴', 4, '210682', '210682112', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('爱阳', 4, '210682', '210682113', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赛马', 4, '210682', '210682114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('弟兄山', 4, '210682', '210682115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸡冠山', 4, '210682', '210682116', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家河', 4, '210682', '210682117', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通远堡', 4, '210682', '210682118', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四门子', 4, '210682', '210682119', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青城子', 4, '210682', '210682120', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大堡', 4, '210682', '210682201', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦州', 2, '21', '2107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古塔', 3, '2107', '210702', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石油', 4, '210702', '210702002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('敬业', 4, '210702', '210702004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保安', 4, '210702', '210702005', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('士英', 4, '210702', '210702009', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '210702', '210702011', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌河', 3, '2107', '210703', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石桥子', 4, '210703', '210703002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙江', 4, '210703', '210703003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榴花', 4, '210703', '210703004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('康宁', 4, '210703', '210703008', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦铁', 4, '210703', '210703009', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫荆', 4, '210703', '210703011', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太和', 3, '2107', '210711', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太和街道', 4, '210711', '210711004', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大薛', 4, '210711', '210711008', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天桥', 4, '210711', '210711010', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新民', 4, '210711', '210711011', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营盘', 4, '210711', '210711012', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('女儿河', 4, '210711', '210711013', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杏山', 4, '210711', '210711014', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌南', 4, '210711', '210711015', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松山', 4, '210711', '210711016', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娘娘宫', 4, '210711', '210711017', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑山', 3, '2107', '210726', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑山街道', 4, '210726', '210726001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大虎山', 4, '210726', '210726002', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芳山', 4, '210726', '210726101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白厂门', 4, '210726', '210726102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常兴', 4, '210726', '210726103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('姜屯', 4, '210726', '210726104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('励家', 4, '210726', '210726105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绕阳河', 4, '210726', '210726106', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('半拉门', 4, '210726', '210726107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('无梁殿', 4, '210726', '210726108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡家', 4, '210726', '210726109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新立屯', 4, '210726', '210726110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八道壕', 4, '210726', '210726111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四家子', 4, '210726', '210726113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新兴', 4, '210726', '210726114', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小东', 4, '210726', '210726115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太和', 4, '210726', '210726116', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镇安', 4, '210726', '210726117', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英城子', 4, '210726', '210726201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('段家', 4, '210726', '210726209', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴', 4, '210726', '210726210', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('薛屯', 4, '210726', '210726212', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义县', 3, '2107', '210727', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义州', 4, '210727', '210727001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '210727', '210727002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘龙台', 4, '210727', '210727101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七里河', 4, '210727', '210727102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大榆树堡', 4, '210727', '210727103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('稍户营子', 4, '210727', '210727104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九道岭', 4, '210727', '210727105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高台子', 4, '210727', '210727106', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瓦子峪', 4, '210727', '210727108', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头台', 4, '210727', '210727109', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家堡', 4, '210727', '210727110', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前杨', 4, '210727', '210727111', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头道河', 4, '210727', '210727112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('留龙沟', 4, '210727', '210727113', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('聚粮屯', 4, '210727', '210727114', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白庙子', 4, '210727', '210727115', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('地藏寺', 4, '210727', '210727203', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大定堡', 4, '210727', '210727205', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌海', 3, '2107', '210781', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大凌河', 4, '210781', '210781001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金城', 4, '210781', '210781002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八千', 4, '210781', '210781003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石山', 4, '210781', '210781101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('余积', 4, '210781', '210781102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双羊', 4, '210781', '210781103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('班吉塔', 4, '210781', '210781104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈家台', 4, '210781', '210781105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三台子', 4, '210781', '210781106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('右卫', 4, '210781', '210781107', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阎家', 4, '210781', '210781108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新庄子', 4, '210781', '210781109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('翠岩', 4, '210781', '210781112', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安屯', 4, '210781', '210781113', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大业', 4, '210781', '210781114', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白台子', 4, '210781', '210781116', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温滴楼', 4, '210781', '210781117', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建业', 4, '210781', '210781118', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('板石沟', 4, '210781', '210781212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谢屯', 4, '210781', '210781217', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北镇', 3, '2107', '210782', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北镇街道', 4, '210782', '210782004', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('广宁', 4, '210782', '210782006', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富屯', 4, '210782', '210782007', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沟帮子', 4, '210782', '210782008', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大市', 4, '210782', '210782101', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗罗堡', 4, '210782', '210782102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常兴店', 4, '210782', '210782103', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正安', 4, '210782', '210782104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('闾阳', 4, '210782', '210782105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中安', 4, '210782', '210782106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('廖屯', 4, '210782', '210782107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵屯', 4, '210782', '210782109', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青堆子', 4, '210782', '210782110', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高山子', 4, '210782', '210782111', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴家', 4, '210782', '210782113', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲍家', 4, '210782', '210782203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '210782', '210782206', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳家', 4, '210782', '210782209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营口', 2, '21', '2108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 3, '2108', '210802', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八田地', 4, '210802', '210802001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建丰', 4, '210802', '210802002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '210802', '210802003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('跃进', 4, '210802', '210802004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东兴', 4, '210802', '210802008', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西市', 3, '2108', '210803', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得胜', 4, '210803', '210803004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五台子', 4, '210803', '210803005', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渔市', 4, '210803', '210803010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨海', 4, '210803', '210803011', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清华', 4, '210803', '210803012', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽宁营口沿海产业基地', 4, '210803', '210803401', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鲅鱼圈', 3, '2108', '210804', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红海', 4, '210804', '210804001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海星', 4, '210804', '210804002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望海', 4, '210804', '210804005', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('熊岳', 4, '210804', '210804100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('芦屯', 4, '210804', '210804102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '210804', '210804103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老边', 3, '2108', '210811', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老边街道', 4, '210811', '210811003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('路南', 4, '210811', '210811101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳树', 4, '210811', '210811102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('边城', 4, '210811', '210811103', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盖州', 3, '2108', '210881', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鼓楼', 4, '210881', '210881001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西城', 4, '210881', '210881002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '210881', '210881003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太阳升', 4, '210881', '210881004', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团山', 4, '210881', '210881005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西海', 4, '210881', '210881006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九垅地', 4, '210881', '210881007', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('归州', 4, '210881', '210881008', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高屯', 4, '210881', '210881102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙岗', 4, '210881', '210881105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九寨', 4, '210881', '210881109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万福', 4, '210881', '210881110', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧龙泉', 4, '210881', '210881111', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青石岭', 4, '210881', '210881112', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('暖泉', 4, '210881', '210881113', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榜式堡', 4, '210881', '210881116', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团甸', 4, '210881', '210881117', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双台', 4, '210881', '210881118', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨运', 4, '210881', '210881119', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐屯', 4, '210881', '210881120', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('什字街', 4, '210881', '210881121', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('矿洞沟', 4, '210881', '210881122', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈屯', 4, '210881', '210881123', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梁屯', 4, '210881', '210881124', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小石棚', 4, '210881', '210881216', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('果园', 4, '210881', '210881217', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二台', 4, '210881', '210881218', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大石桥', 3, '2108', '210882', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金桥', 4, '210882', '210882003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钢都', 4, '210882', '210882004', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南楼', 4, '210882', '210882005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镁都', 4, '210882', '210882007', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水源', 4, '210882', '210882101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沟沿', 4, '210882', '210882102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石佛', 4, '210882', '210882103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高坎', 4, '210882', '210882104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旗口', 4, '210882', '210882105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虎庄', 4, '210882', '210882106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('官屯', 4, '210882', '210882107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('博洛铺', 4, '210882', '210882112', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安', 4, '210882', '210882113', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤池', 4, '210882', '210882114', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建一', 4, '210882', '210882115', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土岭', 4, '210882', '210882116', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('周家', 4, '210882', '210882117', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜新', 2, '21', '2109', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海州', 3, '2109', '210902', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和平', 4, '210902', '210902001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '210902', '210902002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五龙', 4, '210902', '210902003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西山', 4, '210902', '210902004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 4, '210902', '210902005', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安西部', 4, '210902', '210902006', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('韩家店', 4, '210902', '210902101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新邱', 3, '2109', '210903', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('街基', 4, '210903', '210903001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新发屯', 4, '210903', '210903002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长营子', 4, '210903', '210903101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 3, '2109', '210904', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红树', 4, '210904', '210904001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高德', 4, '210904', '210904002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙家湾', 4, '210904', '210904003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泉', 4, '210904', '210904101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河门', 3, '2109', '210905', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河', 4, '210905', '210905001', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新北', 4, '210905', '210905002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河西', 4, '210905', '210905101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌龙坝', 4, '210905', '210905102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('细河', 3, '2109', '210911', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉新', 4, '210911', '210911001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉龙', 4, '210911', '210911002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉丰', 4, '210911', '210911003', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四合', 4, '210911', '210911102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜新蒙古族自治县', 3, '2109', '210921', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城区', 4, '210921', '210921001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阜新镇', 4, '210921', '210921100', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东梁', 4, '210921', '210921102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佛寺', 4, '210921', '210921103', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伊吗图', 4, '210921', '210921104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧庙', 4, '210921', '210921105', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('务欢池', 4, '210921', '210921106', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '210921', '210921107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大巴', 4, '210921', '210921108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泡子', 4, '210921', '210921109', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十家子', 4, '210921', '210921110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王府', 4, '210921', '210921111', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于寺', 4, '210921', '210921112', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富荣', 4, '210921', '210921113', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新民', 4, '210921', '210921114', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('福兴地', 4, '210921', '210921115', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安地', 4, '210921', '210921116', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙拉', 4, '210921', '210921117', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大固本', 4, '210921', '210921118', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大五家子', 4, '210921', '210921119', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大板', 4, '210921', '210921120', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('招束沟', 4, '210921', '210921121', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八家子', 4, '210921', '210921122', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('扎兰营子', 4, '210921', '210921123', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔营子', 4, '210921', '210921124', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红帽子', 4, '210921', '210921125', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蜘蛛山', 4, '210921', '210921126', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七家子', 4, '210921', '210921127', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('紫都台', 4, '210921', '210921128', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化石戈', 4, '210921', '210921129', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈达户稍', 4, '210921', '210921130', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老河土', 4, '210921', '210921131', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '210921', '210921132', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧凤沟', 4, '210921', '210921203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苍土', 4, '210921', '210921211', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('国华', 4, '210921', '210921222', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彰武', 3, '2109', '210922', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('彰武镇', 4, '210922', '210922100', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈尔套', 4, '210922', '210922101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章古台', 4, '210922', '210922102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五峰', 4, '210922', '210922103', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冯家', 4, '210922', '210922104', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后新秋', 4, '210922', '210922105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东六家子', 4, '210922', '210922106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿尔乡', 4, '210922', '210922107', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前福兴地', 4, '210922', '210922108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双庙', 4, '210922', '210922109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大四家子', 4, '210922', '210922110', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇子沟', 4, '210922', '210922111', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆山', 4, '210922', '210922112', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('满堂红', 4, '210922', '210922113', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四合城', 4, '210922', '210922114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大冷', 4, '210922', '210922115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安', 4, '210922', '210922116', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两家子', 4, '210922', '210922117', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆堡', 4, '210922', '210922118', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四堡子', 4, '210922', '210922119', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西六家子', 4, '210922', '210922120', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大德', 4, '210922', '210922121', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二道河子', 4, '210922', '210922202', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰田', 4, '210922', '210922209', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽阳', 2, '21', '2110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔', 3, '2110', '211002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文圣', 4, '211002', '211002016', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('武圣', 4, '211002', '211002017', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南门', 4, '211002', '211002018', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('襄平', 4, '211002', '211002019', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文圣', 3, '2110', '211003', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庆阳', 4, '211003', '211003004', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东京陵', 4, '211003', '211003008', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '211003', '211003009', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗大台', 4, '211003', '211003100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小屯', 4, '211003', '211003101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宏伟', 3, '2110', '211004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工农', 4, '211004', '211004001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光华', 4, '211004', '211004002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新村', 4, '211004', '211004003', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长征', 4, '211004', '211004004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光', 4, '211004', '211004101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兰家', 4, '211004', '211004102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('弓长岭', 3, '2110', '211005', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苏家', 4, '211005', '211005001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团山', 4, '211005', '211005002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安平街道', 4, '211005', '211005003', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤河', 4, '211005', '211005101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安平乡', 4, '211005', '211005201', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太子河', 3, '2110', '211011', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 4, '211011', '211011004', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('祁家', 4, '211011', '211011101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家', 4, '211011', '211011102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙岭', 4, '211011', '211011103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东宁卫', 4, '211011', '211011204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽阳县', 3, '2110', '211021', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('首山', 4, '211021', '211021100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘二堡', 4, '211021', '211021101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小北河', 4, '211021', '211021103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄泥洼', 4, '211021', '211021104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐马寨', 4, '211021', '211021106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('穆家', 4, '211021', '211021107', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳壕', 4, '211021', '211021108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河栏', 4, '211021', '211021110', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('隆昌', 4, '211021', '211021111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八会', 4, '211021', '211021112', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寒岭', 4, '211021', '211021113', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 4, '211021', '211021115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下达河', 4, '211021', '211021201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉洞峪', 4, '211021', '211021202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甜水', 4, '211021', '211021206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('灯塔', 3, '2110', '211081', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('烟台', 4, '211081', '211081001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万宝桥', 4, '211081', '211081002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '211081', '211081003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佟二堡', 4, '211081', '211081101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铧子', 4, '211081', '211081102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张台子', 4, '211081', '211081103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西大窑', 4, '211081', '211081104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈旦堡', 4, '211081', '211081105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西马峰', 4, '211081', '211081106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳条寨', 4, '211081', '211081107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳河子', 4, '211081', '211081108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河南', 4, '211081', '211081111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五星', 4, '211081', '211081114', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸡冠山', 4, '211081', '211081205', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盘锦', 2, '21', '2111', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双台子', 3, '2111', '211102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '211102', '211102002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '211102', '211102003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '211102', '211102004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽河', 4, '211102', '211102005', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 4, '211102', '211102008', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双盛', 4, '211102', '211102009', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陆家', 4, '211102', '211102100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆台', 3, '2111', '211103', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振兴', 4, '211103', '211103001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 4, '211103', '211103002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渤海', 4, '211103', '211103003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新工', 4, '211103', '211103004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光', 4, '211103', '211103007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('欢喜岭', 4, '211103', '211103008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('创新', 4, '211103', '211103016', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴盛', 4, '211103', '211103017', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴海', 4, '211103', '211103018', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东郭', 4, '211103', '211103019', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('惠宾', 4, '211103', '211103020', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大洼', 3, '2111', '211104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大洼街道', 4, '211104', '211104001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆树', 4, '211104', '211104002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田家', 4, '211104', '211104003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王家', 4, '211104', '211104004', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于楼', 4, '211104', '211104006', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二界沟', 4, '211104', '211104009', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '211104', '211104103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开', 4, '211104', '211104104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清水', 4, '211104', '211104106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新兴', 4, '211104', '211104107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西安', 4, '211104', '211104108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新立', 4, '211104', '211104109', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('唐家', 4, '211104', '211104112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安', 4, '211104', '211104113', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('赵圈河', 4, '211104', '211104114', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('田庄台', 4, '211104', '211104115', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('盘山', 3, '2111', '211122', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '211122', '211122001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高升', 4, '211122', '211122002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('得胜', 4, '211122', '211122003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙岭', 4, '211122', '211122101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡家', 4, '211122', '211122103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城子', 4, '211122', '211122107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坝墙子', 4, '211122', '211122108', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陈家', 4, '211122', '211122110', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甜水', 4, '211122', '211122111', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吴家', 4, '211122', '211122112', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石新', 4, '211122', '211122114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊圈子', 4, '211122', '211122115', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁岭', 2, '21', '2112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('银州', 3, '2112', '211202', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '211202', '211202001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('工人', 4, '211202', '211202002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 4, '211202', '211202003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铜钟', 4, '211202', '211202004', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柴河', 4, '211202', '211202005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岭东', 4, '211202', '211202006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('辽海', 4, '211202', '211202007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙山', 4, '211202', '211202201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁岭经济开发区', 4, '211202', '211202401', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清河', 3, '2112', '211204', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '211204', '211204001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '211204', '211204002', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张相', 4, '211204', '211204101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨木林子', 4, '211204', '211204102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('聂家', 4, '211204', '211204203', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁岭县', 3, '2112', '211221', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新台子', 4, '211221', '211221101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('阿吉', 4, '211221', '211221102', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平顶堡', 4, '211221', '211221103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大甸子', 4, '211221', '211221104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凡河', 4, '211221', '211221105', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('腰堡', 4, '211221', '211221106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('镇西堡', 4, '211221', '211221107', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡牛', 4, '211221', '211221108', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李千户', 4, '211221', '211221109', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('熊官屯', 4, '211221', '211221111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横道河子', 4, '211221', '211221112', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双井子', 4, '211221', '211221113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸡冠山', 4, '211221', '211221208', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白旗寨', 4, '211221', '211221209', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西丰', 3, '2112', '211223', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西丰镇', 4, '211223', '211223100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平岗', 4, '211223', '211223101', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郜家店', 4, '211223', '211223102', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凉泉', 4, '211223', '211223103', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('振兴', 4, '211223', '211223104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('安民', 4, '211223', '211223105', 'a');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天德', 4, '211223', '211223106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('房木', 4, '211223', '211223107', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柏榆', 4, '211223', '211223109', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('更刻', 4, '211223', '211223110', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钓鱼', 4, '211223', '211223111', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶然', 4, '211223', '211223112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德兴', 4, '211223', '211223204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明德', 4, '211223', '211223206', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('成平', 4, '211223', '211223209', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和隆', 4, '211223', '211223211', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营厂', 4, '211223', '211223212', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金星', 4, '211223', '211223213', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌图', 3, '2112', '211224', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌图镇', 4, '211224', '211224100', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老城', 4, '211224', '211224101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八面城', 4, '211224', '211224102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三江口', 4, '211224', '211224103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金家', 4, '211224', '211224104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝力', 4, '211224', '211224105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉头', 4, '211224', '211224106', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双庙子', 4, '211224', '211224107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亮中桥', 4, '211224', '211224108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马仲河', 4, '211224', '211224109', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛家店', 4, '211224', '211224110', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老四平', 4, '211224', '211224111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大洼', 4, '211224', '211224112', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头道', 4, '211224', '211224113', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鴜鹭树', 4, '211224', '211224114', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('傅家', 4, '211224', '211224115', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四合', 4, '211224', '211224117', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 4, '211224', '211224118', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古榆树', 4, '211224', '211224119', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七家子', 4, '211224', '211224120', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东嘎', 4, '211224', '211224121', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四面城', 4, '211224', '211224122', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前双井', 4, '211224', '211224123', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通江口', 4, '211224', '211224124', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大四家子', 4, '211224', '211224125', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曲家店', 4, '211224', '211224126', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安堡', 4, '211224', '211224130', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下二台', 4, '211224', '211224131', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '211224', '211224132', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十八家子', 4, '211224', '211224133', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('后窑', 4, '211224', '211224134', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴', 4, '211224', '211224135', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长发', 4, '211224', '211224136', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('调兵山', 3, '2112', '211281', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兀术', 4, '211281', '211281001', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('调兵山街道', 4, '211281', '211281002', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晓明', 4, '211281', '211281102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大明', 4, '211281', '211281103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('晓南', 4, '211281', '211281105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开原', 3, '2112', '211282', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新城', 4, '211282', '211282001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老城', 4, '211282', '211282002', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开原街道', 4, '211282', '211282003', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('威远堡', 4, '211282', '211282102', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庆云堡', 4, '211282', '211282103', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中固', 4, '211282', '211282104', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八棵树', 4, '211282', '211282105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金沟子', 4, '211282', '211282106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八宝', 4, '211282', '211282107', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('业民', 4, '211282', '211282108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲花', 4, '211282', '211282109', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('靠山', 4, '211282', '211282110', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('下肥', 4, '211282', '211282111', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松山', 4, '211282', '211282112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家台', 4, '211282', '211282113', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马家寨', 4, '211282', '211282114', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东', 4, '211282', '211282115', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上肥', 4, '211282', '211282116', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄旗寨', 4, '211282', '211282117', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林丰', 4, '211282', '211282217', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 2, '21', '2113', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塔', 3, '2113', '211302', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进', 4, '211302', '211302003', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌河', 4, '211302', '211302004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('光明', 4, '211302', '211302005', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌凤', 4, '211302', '211302006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙山', 4, '211302', '211302007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站南', 4, '211302', '211302008', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '211302', '211302009', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('燕北', 4, '211302', '211302010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双塔街道', 4, '211302', '211302012', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃花吐', 4, '211302', '211302111', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('他拉皋', 4, '211302', '211302113', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孙家湾', 4, '211302', '211302114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长宝营子', 4, '211302', '211302212', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙城', 3, '2113', '211303', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '211303', '211303004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('海龙', 4, '211303', '211303006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙泉', 4, '211303', '211303007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七道泉子', 4, '211303', '211303101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西大营子', 4, '211303', '211303102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('召都巴', 4, '211303', '211303103', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大平房', 4, '211303', '211303104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('联合', 4, '211303', '211303105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('边杖子', 4, '211303', '211303106', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳县', 3, '2113', '211321', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳城', 4, '211321', '211321001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('波罗赤', 4, '211321', '211321102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('木头城子', 4, '211321', '211321103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二十家子', 4, '211321', '211321104', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊山', 4, '211321', '211321105', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六家子', 4, '211321', '211321106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瓦房子', 4, '211321', '211321107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大庙', 4, '211321', '211321108', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古山子', 4, '211321', '211321110', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南双庙', 4, '211321', '211321111', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台子', 4, '211321', '211321112', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清风岭', 4, '211321', '211321113', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '211321', '211321114', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七道岭', 4, '211321', '211321115', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨树湾', 4, '211321', '211321116', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西五家子', 4, '211321', '211321211', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北沟门子', 4, '211321', '211321212', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东大道', 4, '211321', '211321214', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰河硕', 4, '211321', '211321215', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东大屯', 4, '211321', '211321220', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松岭门', 4, '211321', '211321221', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('根德营子', 4, '211321', '211321222', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西营子', 4, '211321', '211321224', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北四家子', 4, '211321', '211321228', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王营子', 4, '211321', '211321230', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑牛营子', 4, '211321', '211321231', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尚志', 4, '211321', '211321232', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建平', 3, '2113', '211322', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('叶柏寿', 4, '211322', '211322001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山', 4, '211322', '211322002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁南', 4, '211322', '211322003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万寿', 4, '211322', '211322004', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱碌科', 4, '211322', '211322101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建平镇', 4, '211322', '211322102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑水', 4, '211322', '211322103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喀喇沁', 4, '211322', '211322104', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北二十家子', 4, '211322', '211322105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙海', 4, '211322', '211322106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈拉道口', 4, '211322', '211322108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆树林子', 4, '211322', '211322109', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老官地', 4, '211322', '211322110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('深井', 4, '211322', '211322111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奎德素', 4, '211322', '211322112', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小塘', 4, '211322', '211322113', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马场', 4, '211322', '211322114', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌隆', 4, '211322', '211322115', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张家营子', 4, '211322', '211322117', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青峰山', 4, '211322', '211322118', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平庄', 4, '211322', '211322119', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青松岭', 4, '211322', '211322205', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨树岭', 4, '211322', '211322206', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('罗福沟', 4, '211322', '211322209', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('烧锅营子', 4, '211322', '211322211', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白山', 4, '211322', '211322214', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三家', 4, '211322', '211322218', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('义成功', 4, '211322', '211322220', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八家国营农场', 4, '211322', '211322400', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('热水国营畜牧农场', 4, '211322', '211322401', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喀喇沁左翼', 3, '2113', '211324', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大城子', 4, '211324', '211324001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('利州', 4, '211324', '211324003', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南公营子', 4, '211324', '211324101', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山嘴子', 4, '211324', '211324102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公营子', 4, '211324', '211324104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔子', 4, '211324', '211324105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('中三家', 4, '211324', '211324106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老爷庙', 4, '211324', '211324107', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('六官营子', 4, '211324', '211324108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平房子', 4, '211324', '211324109', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十二德堡', 4, '211324', '211324110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊角沟', 4, '211324', '211324111', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('甘招', 4, '211324', '211324112', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆庄', 4, '211324', '211324113', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东哨', 4, '211324', '211324114', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水泉', 4, '211324', '211324115', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('尤杖子', 4, '211324', '211324204', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('草场', 4, '211324', '211324207', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('坤都营子', 4, '211324', '211324210', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大营子', 4, '211324', '211324211', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卧虎沟', 4, '211324', '211324214', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北票', 3, '2113', '211381', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '211381', '211381001', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南山', 4, '211381', '211381002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('冠山', 4, '211381', '211381003', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台吉街道', 4, '211381', '211381006', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西官营', 4, '211381', '211381101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大板', 4, '211381', '211381102', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上园', 4, '211381', '211381103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝国老', 4, '211381', '211381104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑城子', 4, '211381', '211381105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五间房', 4, '211381', '211381107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台吉镇', 4, '211381', '211381108', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东官营', 4, '211381', '211381109', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙潭', 4, '211381', '211381110', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北塔', 4, '211381', '211381111', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蒙古营', 4, '211381', '211381112', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大三家', 4, '211381', '211381113', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长皋', 4, '211381', '211381201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常河营', 4, '211381', '211381202', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小塔子', 4, '211381', '211381203', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马友营', 4, '211381', '211381204', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉巨永', 4, '211381', '211381206', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈尔脑', 4, '211381', '211381212', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南八家子', 4, '211381', '211381213', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('章吉营', 4, '211381', '211381214', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三宝营', 4, '211381', '211381215', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴图营', 4, '211381', '211381216', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台吉营', 4, '211381', '211381218', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娄家店', 4, '211381', '211381220', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北四家', 4, '211381', '211381221', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凉水河', 4, '211381', '211381223', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三宝', 4, '211381', '211381228', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凌源', 3, '2113', '211382', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东城', 4, '211382', '211382001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北街', 4, '211382', '211382002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南街', 4, '211382', '211382003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红山', 4, '211382', '211382004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城关', 4, '211382', '211382007', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万元店', 4, '211382', '211382101', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宋杖子', 4, '211382', '211382102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三十家子', 4, '211382', '211382103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨杖子', 4, '211382', '211382104', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刀尔登', 4, '211382', '211382105', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松岭子', 4, '211382', '211382106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四官营子', 4, '211382', '211382107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沟门子', 4, '211382', '211382108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小城子', 4, '211382', '211382110', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四合当', 4, '211382', '211382111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌兰白', 4, '211382', '211382113', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('瓦房店', 4, '211382', '211382114', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大河北', 4, '211382', '211382115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛营子', 4, '211382', '211382116', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道河子', 4, '211382', '211382117', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘杖子', 4, '211382', '211382118', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北炉', 4, '211382', '211382210', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三家子', 4, '211382', '211382217', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('佛爷洞', 4, '211382', '211382219', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王杖子', 4, '211382', '211382220', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进', 4, '211382', '211382222', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河坎子', 4, '211382', '211382223', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葫芦岛', 2, '21', '2114', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连山', 3, '2114', '211402', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连山街道', 4, '211402', '211402001', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '211402', '211402002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('渤海', 4, '211402', '211402003', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴工', 4, '211402', '211402004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石油', 4, '211402', '211402005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('化工', 4, '211402', '211402006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦郊', 4, '211402', '211402010', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨家杖子', 4, '211402', '211402011', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钢屯', 4, '211402', '211402104', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('寺儿堡', 4, '211402', '211402105', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新台门', 4, '211402', '211402106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河营', 4, '211402', '211402201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤竹营子', 4, '211402', '211402202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白马石', 4, '211402', '211402203', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山神庙子', 4, '211402', '211402205', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔山', 4, '211402', '211402206', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨郊', 4, '211402', '211402210', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙港', 3, '2114', '211403', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葫芦岛', 4, '211403', '211403001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙湾', 4, '211403', '211403005', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('滨海', 4, '211403', '211403006', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双龙', 4, '211403', '211403007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉皇', 4, '211403', '211403008', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('连湾', 4, '211403', '211403009', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北港', 4, '211403', '211403010', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('马仗房', 4, '211403', '211403011', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双树', 4, '211403', '211403211', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南票', 3, '2114', '211404', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙锅屯街道', 4, '211404', '211404002', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('邱皮沟', 4, '211404', '211404003', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇子沟', 4, '211404', '211404005', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小凌河', 4, '211404', '211404007', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九龙', 4, '211404', '211404008', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙腾', 4, '211404', '211404010', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('缸窑岭', 4, '211404', '211404101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('暖池塘', 4, '211404', '211404102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高桥', 4, '211404', '211404103', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('台集屯', 4, '211404', '211404104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('虹螺岘', 4, '211404', '211404105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金星', 4, '211404', '211404106', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙锅屯乡', 4, '211404', '211404201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土坎', 4, '211404', '211404203', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大兴', 4, '211404', '211404204', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('张相公屯', 4, '211404', '211404205', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绥中', 3, '2114', '211421', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绥中镇', 4, '211421', '211421100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西甸子', 4, '211421', '211421101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宽邦', 4, '211421', '211421102', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大王庙', 4, '211421', '211421103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万家', 4, '211421', '211421104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前所', 4, '211421', '211421105', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高岭', 4, '211421', '211421106', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前卫', 4, '211421', '211421107', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荒地', 4, '211421', '211421108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('塔山屯', 4, '211421', '211421109', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高台', 4, '211421', '211421113', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王宝', 4, '211421', '211421114', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙河', 4, '211421', '211421115', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小庄子', 4, '211421', '211421116', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西平坡', 4, '211421', '211421201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('葛家', 4, '211421', '211421202', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高甸子', 4, '211421', '211421204', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('范家', 4, '211421', '211421206', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明水', 4, '211421', '211421207', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秋子沟', 4, '211421', '211421208', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('加碑岩', 4, '211421', '211421210', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安堡', 4, '211421', '211421211', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('李家堡', 4, '211421', '211421212', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('网户', 4, '211421', '211421214', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城郊', 4, '211421', '211421217', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建昌', 3, '2114', '211422', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建昌镇', 4, '211422', '211422100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八家子', 4, '211422', '211422101', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喇嘛洞', 4, '211422', '211422102', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('药王庙', 4, '211422', '211422103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('汤神庙', 4, '211422', '211422104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玲珑塔', 4, '211422', '211422105', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大屯', 4, '211422', '211422106', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牤牛营子', 4, '211422', '211422201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('素珠营子', 4, '211422', '211422203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石佛', 4, '211422', '211422204', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('王宝营子', 4, '211422', '211422206', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('老大杖子', 4, '211422', '211422207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('要路沟', 4, '211422', '211422208', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('魏家岭', 4, '211422', '211422209', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西碱厂', 4, '211422', '211422210', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('头道营子', 4, '211422', '211422211', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新开岭', 4, '211422', '211422212', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('贺杖子', 4, '211422', '211422213', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('养马甸子', 4, '211422', '211422214', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('和尚房子', 4, '211422', '211422215', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨树湾子', 4, '211422', '211422218', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑山科', 4, '211422', '211422219', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('雷家店', 4, '211422', '211422220', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小德营子', 4, '211422', '211422222', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二道湾子', 4, '211422', '211422223', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴什罕', 4, '211422', '211422224', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('娘娘庙', 4, '211422', '211422225', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('谷杖子', 4, '211422', '211422226', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴城', 3, '2114', '211481', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('古城', 4, '211481', '211481001', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宁远', 4, '211481', '211481002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东', 4, '211481', '211481003', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('温泉', 4, '211481', '211481004', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('钓鱼台', 4, '211481', '211481005', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华山', 4, '211481', '211481006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四家屯', 4, '211481', '211481007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('菊花', 4, '211481', '211481008', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曹庄', 4, '211481', '211481101', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沙后所', 4, '211481', '211481103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东辛庄', 4, '211481', '211481104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家', 4, '211481', '211481105', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红崖子', 4, '211481', '211481106', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('徐大堡', 4, '211481', '211481107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家岭', 4, '211481', '211481108', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('羊安', 4, '211481', '211481201', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('元台子', 4, '211481', '211481203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白塔', 4, '211481', '211481204', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('望海', 4, '211481', '211481206', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘台子', 4, '211481', '211481207', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大寨', 4, '211481', '211481208', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南大山', 4, '211481', '211481209', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('围屏', 4, '211481', '211481210', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('碱厂', 4, '211481', '211481212', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三道沟', 4, '211481', '211481213', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旧门', 4, '211481', '211481215', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('药王', 4, '211481', '211481216', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉林', 1, '0', '22', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长春', 2, '22', '2201', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南关', 3, '2201', '220102', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南岭', 4, '220102', '220102001', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('自强', 4, '220102', '220102002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('民康', 4, '220102', '220102003', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新春', 4, '220102', '220102004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长通', 4, '220102', '220102005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('全安', 4, '220102', '220102006', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('曙光', 4, '220102', '220102007', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永吉', 4, '220102', '220102008', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桃源', 4, '220102', '220102009', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永兴', 4, '220102', '220102010', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('净月', 4, '220102', '220102011', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临河', 4, '220102', '220102012', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鸿城', 4, '220102', '220102013', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明珠', 4, '220102', '220102014', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新立城', 4, '220102', '220102100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新湖', 4, '220102', '220102101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玉谭', 4, '220102', '220102102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('幸福', 4, '220102', '220102200', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宽城', 3, '2201', '220103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新发', 4, '220103', '220103001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '220103', '220103002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南广', 4, '220103', '220103003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东广', 4, '220103', '220103004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('群英', 4, '220103', '220103005', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴业', 4, '220103', '220103006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('凯旋', 4, '220103', '220103007', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('团山', 4, '220103', '220103008', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('柳影', 4, '220103', '220103009', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兰家', 4, '220103', '220103101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆山', 4, '220103', '220103102', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('米沙子', 4, '220103', '220103103', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万宝', 4, '220103', '220103104', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合隆', 4, '220103', '220103105', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奋进', 4, '220103', '220103200', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 3, '2201', '220104', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进', 4, '220104', '220104001', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桂林', 4, '220104', '220104002', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南湖', 4, '220104', '220104003', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永昌', 4, '220104', '220104004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('重庆', 4, '220104', '220104005', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('清和', 4, '220104', '220104006', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '220104', '220104007', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湖西', 4, '220104', '220104008', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富锋', 4, '220104', '220104009', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双德街道', 4, '220104', '220104011', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('飞跃', 4, '220104', '220104012', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乐山', 4, '220104', '220104101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永春', 4, '220104', '220104102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双德乡', 4, '220104', '220104200', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二道', 3, '2201', '220105', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东盛', 4, '220105', '220105001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉林', 4, '220105', '220105002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('荣光', 4, '220105', '220105003', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东站', 4, '220105', '220105004', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('远达', 4, '220105', '220105005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八里堡', 4, '220105', '220105006', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东方广场', 4, '220105', '220105007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('劝农山', 4, '220105', '220105101', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泉眼', 4, '220105', '220105102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英俊', 4, '220105', '220105103', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四家', 4, '220105', '220105201', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绿园', 3, '2201', '220106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正阳', 4, '220106', '220106001', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('锦程', 4, '220106', '220106003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('春城', 4, '220106', '220106004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青年路', 4, '220106', '220106006', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东风', 4, '220106', '220106007', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('合心', 4, '220106', '220106100', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西新', 4, '220106', '220106101', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城西', 4, '220106', '220106102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长春汽车产业开发区', 4, '220106', '220106170', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('绿园经济开发区', 4, '220106', '220106400', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双阳', 3, '2201', '220112', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('云山', 4, '220112', '220112001', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平湖', 4, '220112', '220112002', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奢岭', 4, '220112', '220112003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山河', 4, '220112', '220112004', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('鹿乡', 4, '220112', '220112101', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太平', 4, '220112', '220112102', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('齐家', 4, '220112', '220112104', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双营子', 4, '220112', '220112203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九台', 3, '2201', '220113', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九台街道', 4, '220113', '220113001', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('营城', 4, '220113', '220113002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九郊', 4, '220113', '220113003', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西营城', 4, '220113', '220113004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('卡伦湖', 4, '220113', '220113005', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东湖', 4, '220113', '220113006', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土们岭', 4, '220113', '220113007', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('波泥河', 4, '220113', '220113008', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇子沟', 4, '220113', '220113009', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴隆', 4, '220113', '220113010', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('纪家', 4, '220113', '220113011', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙嘉', 4, '220113', '220113012', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城子街', 4, '220113', '220113014', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沐石河', 4, '220113', '220113015', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('其塔木', 4, '220113', '220113102', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上河湾', 4, '220113', '220113103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胡家', 4, '220113', '220113200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莽卡', 4, '220113', '220113201', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('农安', 3, '2201', '220122', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('农安镇', 4, '220122', '220122100', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('伏龙泉', 4, '220122', '220122101', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈拉海', 4, '220122', '220122102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('靠山', 4, '220122', '220122103', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开安', 4, '220122', '220122105', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('烧锅', 4, '220122', '220122106', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高家店', 4, '220122', '220122107', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华家', 4, '220122', '220122109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三盛玉', 4, '220122', '220122111', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('巴吉垒', 4, '220122', '220122112', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('三岗', 4, '220122', '220122113', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前岗', 4, '220122', '220122201', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙王', 4, '220122', '220122202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万顺', 4, '220122', '220122204', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨树林', 4, '220122', '220122205', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永安', 4, '220122', '220122207', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青山口', 4, '220122', '220122208', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄鱼圈', 4, '220122', '220122209', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新农', 4, '220122', '220122210', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万金塔', 4, '220122', '220122211', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小城子', 4, '220122', '220122212', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('洼中高农场', 4, '220122', '220122400', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆树', 3, '2201', '220182', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('华昌', 4, '220182', '220182001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('正阳', 4, '220182', '220182002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('培英', 4, '220182', '220182003', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城郊', 4, '220182', '220182004', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五棵树', 4, '220182', '220182100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('弓棚', 4, '220182', '220182101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('闵家', 4, '220182', '220182102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大坡', 4, '220182', '220182103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑林', 4, '220182', '220182104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土桥', 4, '220182', '220182105', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新立', 4, '220182', '220182106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大岭', 4, '220182', '220182107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('于家', 4, '220182', '220182108', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泗河', 4, '220182', '220182109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八号', 4, '220182', '220182110', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家', 4, '220182', '220182111', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秀水', 4, '220182', '220182112', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('保寿', 4, '220182', '220182113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新庄', 4, '220182', '220182115', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('育民', 4, '220182', '220182200', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红星', 4, '220182', '220182201', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('太安', 4, '220182', '220182203', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('先峰', 4, '220182', '220182204', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青山', 4, '220182', '220182208', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延和', 4, '220182', '220182209', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('恩育', 4, '220182', '220182210', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城发', 4, '220182', '220182211', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('环城', 4, '220182', '220182213', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德惠', 3, '2201', '220183', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '220183', '220183001', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('建设', 4, '220183', '220183002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('惠发', 4, '220183', '220183004', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夏家店', 4, '220183', '220183005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大青嘴', 4, '220183', '220183100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家', 4, '220183', '220183101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松花江', 4, '220183', '220183102', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('达家沟', 4, '220183', '220183103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大房身', 4, '220183', '220183104', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔路口', 4, '220183', '220183105', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朱城子', 4, '220183', '220183106', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('布海', 4, '220183', '220183110', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天台', 4, '220183', '220183111', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('菜园子', 4, '220183', '220183112', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('同太', 4, '220183', '220183200', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('边岗', 4, '220183', '220183202', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('五台', 4, '220183', '220183203', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 4, '220183', '220183204', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公主岭', 3, '2201', '220184', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河南', 4, '220184', '220184001', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 4, '220184', '220184002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东三', 4, '220184', '220184003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岭东', 4, '220184', '220184004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁北', 4, '220184', '220184005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岭西', 4, '220184', '220184006', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南崴子', 4, '220184', '220184007', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘房子', 4, '220184', '220184008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('苇子沟', 4, '220184', '220184010', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('环岭', 4, '220184', '220184011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二十家子', 4, '220184', '220184100', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑林子', 4, '220184', '220184103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('陶家屯', 4, '220184', '220184104', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('范家屯', 4, '220184', '220184105', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('响水', 4, '220184', '220184106', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大岭', 4, '220184', '220184107', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('怀德', 4, '220184', '220184108', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双城堡', 4, '220184', '220184109', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双龙', 4, '220184', '220184110', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('杨大城子', 4, '220184', '220184111', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('毛城子', 4, '220184', '220184112', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('玻璃城子', 4, '220184', '220184113', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳坡', 4, '220184', '220184114', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大榆树', 4, '220184', '220184115', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('秦家屯', 4, '220184', '220184116', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八屋', 4, '220184', '220184117', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十屋', 4, '220184', '220184118', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桑树台', 4, '220184', '220184119', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙山', 4, '220184', '220184201', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永发', 4, '220184', '220184203', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉林市', 2, '22', '2202', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('昌邑', 3, '2202', '220202', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('兴华', 4, '220202', '220202001', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('文庙', 4, '220202', '220202002', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东局子', 4, '220202', '220202003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新地号', 4, '220202', '220202004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延安', 4, '220202', '220202005', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '220202', '220202006', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('民主', 4, '220202', '220202007', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲花', 4, '220202', '220202008', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('通江', 4, '220202', '220202009', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('哈达', 4, '220202', '220202010', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新建', 4, '220202', '220202011', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('延江', 4, '220202', '220202012', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双吉', 4, '220202', '220202013', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('九站', 4, '220202', '220202016', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉林东市商贸示范区', 4, '220202', '220202071', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤店子', 4, '220202', '220202100', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桦皮厂', 4, '220202', '220202101', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('左家', 4, '220202', '220202102', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('两家子', 4, '220202', '220202200', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('土城子', 4, '220202', '220202201', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙潭', 3, '2202', '220203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('遵义', 4, '220203', '220203002', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 4, '220203', '220203003', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙潭街道', 4, '220203', '220203004', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新安', 4, '220203', '220203005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('湘潭', 4, '220203', '220203006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙华', 4, '220203', '220203007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新吉林', 4, '220203', '220203008', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山前', 4, '220203', '220203009', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泡子沿', 4, '220203', '220203010', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('靠山', 4, '220203', '220203011', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌拉街', 4, '220203', '220203100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('缸窑', 4, '220203', '220203101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江密峰', 4, '220203', '220203102', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大口钦', 4, '220203', '220203103', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金珠', 4, '220203', '220203104', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江北', 4, '220203', '220203201', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('龙潭经济开发区', 4, '220203', '220203400', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('船营', 3, '2202', '220204', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('德胜', 4, '220204', '220204001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南京', 4, '220204', '220204002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大东', 4, '220204', '220204003', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('青岛', 4, '220204', '220204004', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('向阳', 4, '220204', '220204005', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北极', 4, '220204', '220204006', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('致和', 4, '220204', '220204007', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长春路', 4, '220204', '220204008', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('临江', 4, '220204', '220204009', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北山', 4, '220204', '220204010', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄旗', 4, '220204', '220204011', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('大绥河', 4, '220204', '220204100', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('搜登站', 4, '220204', '220204101', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('越北', 4, '220204', '220204102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('欢喜', 4, '220204', '220204200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰满', 3, '2202', '220211', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('泰山', 4, '220211', '220211001', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江南街道', 4, '220211', '220211002', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石井', 4, '220211', '220211003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沿丰', 4, '220211', '220211004', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('丰满街道', 4, '220211', '220211005', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗', 4, '220211', '220211006', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('高新', 4, '220211', '220211007', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('旺起', 4, '220211', '220211100', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('江南乡', 4, '220211', '220211200', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小白山', 4, '220211', '220211201', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前二道', 4, '220211', '220211202', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永吉', 3, '2202', '220221', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('口前', 4, '220221', '220221101', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('岔路河', 4, '220221', '220221102', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('双河', 4, '220221', '220221103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('西阳', 4, '220221', '220221104', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北大湖', 4, '220221', '220221105', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('一拉溪', 4, '220221', '220221106', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万昌', 4, '220221', '220221107', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永吉经济开发区', 4, '220221', '220221172', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金家', 4, '220221', '220221203', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄榆', 4, '220221', '220221205', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蛟河', 3, '2202', '220281', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('民主', 4, '220281', '220281001', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('长安', 4, '220281', '220281002', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河南', 4, '220281', '220281003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('奶子山', 4, '220281', '220281005', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新农', 4, '220281', '220281006', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('拉法', 4, '220281', '220281007', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河北', 4, '220281', '220281009', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新站', 4, '220281', '220281100', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天岗', 4, '220281', '220281101', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白石山', 4, '220281', '220281102', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('漂河', 4, '220281', '220281103', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄松甸', 4, '220281', '220281104', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天北', 4, '220281', '220281106', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松江', 4, '220281', '220281107', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('庆岭', 4, '220281', '220281108', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('乌林', 4, '220281', '220281200', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('前进', 4, '220281', '220281202', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桦甸', 3, '2202', '220282', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明桦', 4, '220282', '220282001', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('永吉', 4, '220282', '220282002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('胜利', 4, '220282', '220282003', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新华', 4, '220282', '220282004', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('启新', 4, '220282', '220282005', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('夹皮沟', 4, '220282', '220282100', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('二道甸子', 4, '220282', '220282102', 'e');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红石砬子', 4, '220282', '220282103', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('八道河子', 4, '220282', '220282104', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('常山', 4, '220282', '220282106', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金沙', 4, '220282', '220282107', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('桦郊', 4, '220282', '220282200', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('横道河子', 4, '220282', '220282202', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('公吉', 4, '220282', '220282205', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('舒兰', 3, '2202', '220283', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北城', 4, '220283', '220283001', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('南城', 4, '220283', '220283002', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('环城', 4, '220283', '220283003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉舒', 4, '220283', '220283004', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 4, '220283', '220283005', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('白旗', 4, '220283', '220283100', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳', 4, '220283', '220283101', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('开原', 4, '220283', '220283102', 'k');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('上营', 4, '220283', '220283103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('水曲柳', 4, '220283', '220283104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平安', 4, '220283', '220283105', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('法特', 4, '220283', '220283106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('溪河', 4, '220283', '220283107', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小城', 4, '220283', '220283108', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('金马', 4, '220283', '220283109', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七里', 4, '220283', '220283200', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('莲花', 4, '220283', '220283202', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('亮甲山', 4, '220283', '220283203', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('天德', 4, '220283', '220283204', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('新安', 4, '220283', '220283206', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磐石', 3, '2202', '220284', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东宁', 4, '220284', '220284001', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('河南', 4, '220284', '220284002', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('福安', 4, '220284', '220284003', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('磐石经济开发区', 4, '220284', '220284070', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('烟筒山', 4, '220284', '220284100', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('明城', 4, '220284', '220284101', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('红旗岭', 4, '220284', '220284102', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('牛心', 4, '220284', '220284103', 'n');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石嘴', 4, '220284', '220284104', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('朝阳山', 4, '220284', '220284105', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('富太', 4, '220284', '220284106', 'f');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('呼兰', 4, '220284', '220284107', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('松山', 4, '220284', '220284108', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黑石', 4, '220284', '220284109', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('吉昌', 4, '220284', '220284110', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('取柴河', 4, '220284', '220284111', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('驿马', 4, '220284', '220284112', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('宝山', 4, '220284', '220284200', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四平', 2, '22', '2203', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁西', 3, '2203', '220302', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('仁兴', 4, '220302', '220302001', 'r');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('英雄', 4, '220302', '220302002', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('站前', 4, '220302', '220302003', 'z');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北沟', 4, '220302', '220302004', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('十家堡', 4, '220302', '220302100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('郭家店', 4, '220302', '220302101', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孟家岭', 4, '220302', '220302102', 'm');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平西', 4, '220302', '220302200', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('铁东', 3, '2203', '220303', 't');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平东', 4, '220303', '220303001', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('北市场', 4, '220303', '220303002', 'b');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('黄土坑', 4, '220303', '220303003', 'h');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('七马路', 4, '220303', '220303004', 'q');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四马路', 4, '220303', '220303005', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('解放', 4, '220303', '220303006', 'j');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('平南', 4, '220303', '220303008', 'p');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('山门', 4, '220303', '220303100', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('石岭子', 4, '220303', '220303103', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('叶赫', 4, '220303', '220303110', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('四平经济开发区', 4, '220303', '220303170', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('城东', 4, '220303', '220303200', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梨树', 3, '2203', '220322', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('梨树镇', 4, '220322', '220322100', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('榆树台', 4, '220322', '220322102', 'y');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小城子', 4, '220322', '220322105', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('喇嘛甸', 4, '220322', '220322106', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('蔡家', 4, '220322', '220322107', 'c');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('刘家馆子', 4, '220322', '220322108', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('万发', 4, '220322', '220322113', 'w');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('东河', 4, '220322', '220322114', 'd');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('沈洋', 4, '220322', '220322115', 's');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('林海', 4, '220322', '220322116', 'l');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('小宽', 4, '220322', '220322117', 'x');
INSERT INTO sys_data_region(name,level,parent_code,code,first_letter) VALUES ('孤家子', 4, '220322', '220322118', 'g');
INSERT INTO sys_data_region(name,level,parent_code,code,fi