var Service = require('Service');
var utils = require('utils');
var util = require('util');
var ClientVersion = require('../../dao/sys_client_version');

/**
 * 获得客户端版本
 */
var getClientVersion = function() {
    Service.call(this);
};

util.inherits(getClientVersion, Service);

module.exports = getClientVersion;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
getClientVersion.prototype.process = function(req, res) {
    if (!req.clientType) {
        this.onLogicError(1, '请提供客户端类型！', res);
        return;
    }
    if (!req.clientVersion) {
        this.onLogicError(2, '请提供客户端版本！', res);
        return;
    }

    req.clientType = req.clientType.toLowerCase();
    if (req.clientType != 'iphone' && req.clientType != 'ipad' &&
        req.clientType != 'androidphone' && req.clientType != 'androidpad' &&
        req.clientType != 'pc') {
        this.onLogicError(3, '不支持客户端类型：' + req.clientType + '！', res);
        return;
    }

    var params = [req.clientType];
    var where = '';
    if (req.status) {
        where += ' and status=?';
        params.push(req.status);
    }

    var self = this;
    var dao = new ClientVersion(this);
    dao.query({
        fields: 'version,description,url,enforce',
        where: 'client_type=?' + where,
        params: params,
        order: 'createtime desc',
        limit: 1
    }, function(rows) {
        if (rows.length > 0 && rows[0].version != req.clientVersion) {
            res.version = rows[0].version;
            res.downAddress = rows[0].url;
            res.description = rows[0].description;
            res.enforce = rows[0].enforce;
            self.end(res);
        } else {
            self.onLogicError(4, '当前已是最新版本');
            return;
        }
    });
};