var util = require('util');
var Service = require('Service');
var utils = require('utils');
var AttachDao = require('../../dao/app_attach');
var User = require('../../dao/vuser');
var DepUser = require('../../dao/dep_user');
var UserSubDep = require('../../dao/user_subdep');

var GetUserInfo = function() {
    Service.call(this);
    this.enableTransaction = false;
};

util.inherits(GetUserInfo, Service);

module.exports = GetUserInfo;

GetUserInfo.prototype.process = function(req, res) {
    var self = this;
    if (!req.userId) {
        req.userId = req.session.userId;
    }
    req.session.cache.get('user', parseInt(req.userId), function(err, user) {
        if (err) {
            self.onLogicError(3, '请提供正确的用户编号！');
            return;
        }
        res.user = user;
        var daoAttach = new AttachDao(self);
        daoAttach.query({
            fields: 'code,name',
            where: 'code=\'' + user.head_code + '\''
        }, function(rows) {
            if (rows.length > 0) {
                res.head = {
                    code: rows[0].code,
                    name: rows[0].name
                }
            }
            self.getDepInfo(req, res);
        });
    });
};

GetUserInfo.prototype.getUserInfo = function(req, res) {
    var self = this;
    var dao = new User(this);
    dao.query({
            fields: 'id,code,name,loginname,mobile,email,sex,head_id,' +
                'nickname,tel_short,tel_work,tel_home,tel_other',
            where: 'org_id=' + req.session.orgId + ' and id=' + req.userId
        },
        function(rows) {
            res.user = rows[0];
            self.getDepInfo(req, res);
        });
}

GetUserInfo.prototype.getDepInfo = function(req, res) {
    var self = this;
    var daoDepUser = new DepUser(self);
    daoDepUser.query({
        fields: "user_id,dep_id,0 as post_id,0 as level_id,(select name from sys_dep where id=dep_id) " +
            "as dep_name, '' as post_name,dep_id as order_number,'' as level_name",
        where: 'org_id=? and user_id=?',
        params: [req.session.orgId, req.userId],
        order: 'order_number asc'
    }, function(rows) {
        res.deps = rows;
        res.subDeps = [];
        self.end(res);
        return;
        self.getSubDepInfo(req, res);
    })
}

GetUserInfo.prototype.getSubDepInfo = function(req, res) {
    var self = this;
    var userDao = new UserSubDep(this);
    userDao.query({
        fields: 'sys_user_subdep.id,sys_user_subdep.order_number,sys_user_subdep.dep_id,sys_dep.name,' +
            'sys_user_subdep.layer_id,(sys_layer.name) as layerName',
        where: 'sys_user_subdep.org_id=? and sys_user_subdep.user_id=?',
        params: [req.session.orgId, req.userId],
        join: 'sys_dep on sys_dep.org_id=' + req.session.orgId + ' and sys_dep.id=sys_user_subdep.dep_id' +
            ' left join sys_layer on sys_layer.org_id=' + req.session.orgId + ' and sys_layer.id=sys_user_subdep.layer_id',
        order: 'sys_user_subdep.order_number asc'
    }, function(rows) {
        res.subDeps = [];
        for (var i = 0; i < rows.length; i++) {
            var dep = {};
            dep.id = rows[i].id;
            dep.depId = rows[i].dep_id;
            dep.depName = rows[i].name;
            dep.layerId = rows[i].layer_id;
            dep.layerName = rows[i].layerName;
            res.subDeps.push(dep);
        }
        self.end(res);
    })
}