var Service = require('Service');
var util = require('util');
var CacheBll = require('../../bll/Cache');

/**
 * 根据角色信息获取用户信息
 */
var GetListUserByRole = function () {
    Service.call(this);
};

util.inherits(GetListUserByRole, Service);

module.exports = GetListUserByRole;

GetListUserByRole.prototype.process = function (req, res) {
    var self = this;
    var cacheDao = new CacheBll(this);
    var args = {};
    args.role_id = req.data + '';
    if (req.include_deps)
        args.include_deps = 'Y';
    if (req.keyword)
        args.keyword = req.keyword;
    if (req.companyId) {
        args.com_id = req.companyId;
    }
    req.session.cache.getSubObjs('role', args.role_id, 'user', 'users', function (err, users) {
        if (err) {
            self.onLogicError(1, err.message);
            return;
        }
        res.rows = users;
        self.end(res);
    });
};
