var Service = require('Service');
var util = require('util');
var CacheBll = require('../../bll/Cache');


/**
 * 根据部门信息获取用户信息
 */
var GetListUserByDep = function () {
    Service.call(this);
    this.id = 0;
};

util.inherits(GetListUserByDep, Service);

module.exports = GetListUserByDep;

//根据部门Dtree的id 查找table数据
GetListUserByDep.prototype.process = function (req, res) {
    var self = this;
    var cacheDao = new CacheBll(this);
    var args = {};
    args.dep_id = req.data;
    if (req.include_deps)
        args.include_deps = 'Y';
    if (req.keyword)
        args.keyword = req.keyword;
    req.session.cache.getSubObjs('dep', args.dep_id, 'user', 'users', function (err, users) {
        if (err) {
            self.onLogicError(1, err.message);
            return;
        }
        res.rows = users;
        self.end(res);
    });
};