var Service = require('Service');
var util = require('util');

/**
 * 获得部门列表
 */
var GetListDep = function() {
	this.list = [];
	Service.call(this);
};

util.inherits(GetListDep, Service);

module.exports = GetListDep;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
GetListDep.prototype.process = function(req, res) {
	req.selectList = req.selectList || [];
	var self = this;
	var where = "";
	if (req.keyword) {
		where += "#{name}.search('" + req.keyword + "')!=-1 && ";
	}
	if (req.external_sign == 0) where += "!#{external_sign} && #{company_sign}!=1 && " //只内部
	if (req.external_sign == 1) where += "#{external_sign}==1 && " //只外部
	if (req.company_sign == 0) where += "!#{company_sign} && #{external_sign}!=1 && " //只部门
	if (req.company_sign == 1) where += "#{company_sign}==1 && " //只单位
	if (req.companyId && req.companyId > 0) {
		where += '#{parent_ids}!=null && #{parent_ids}.indexOf(",' + req.companyId + ',")!=-1';
	} else {
		where += ' 1==1';
	}
	req.session.cache.getList("mdep", {
		"where": where
	}, function(err, deps) {
		if (err) {
			self.onLogicError(1, err.message, req, res);
			return;
		}
		
		self.eachData(req, res, deps, 0);
	});
};

GetListDep.prototype.eachData = function(req, res, deps, index) {
	var self = this;
	if (deps.length == index) {
		res.rows = this.list;
		self.end(res);
		return;
	}
	var dep = deps[index];
	index++;
	req.session.cache.len("mdep", "#{parent_id}==" + dep.id, function(err, ret) {
		if (err) {
			self.onError(err);
			return;
		}
		dep.child_count = ret;
		dep.checkArr = "0";
		if (req.companyId && req.companyId > 0) {
			if (dep.id == req.companyId) {
				dep.parent_id = 0;
				dep.spread = true;
			}
		}
		if (req.keyword) dep.parent_id = "0";
		self.list.push(dep);
		self.eachData(req, res, deps, index);
	});
};
