var Service = require('Service');
var util = require('util');
var CacheBll = require('../../bll/Cache');

/**
 * 查询部门与同级别职员
 */
var PreUpdate = function () {
    Service.call(this);
    this.enableTransaction = false;
};

util.inherits(PreUpdate, Service);

module.exports = PreUpdate;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
PreUpdate.prototype.process = function (req, res) {
    if (req.keyword) {
        this.getUsersByKeyword(req, res);
        return;
    }
    if (!req.parent_id && req.parent_id != '0') {
        this.onLogicError(1, '请提供上级编号！');
        return;
    }

    if (req.nodeId) req.parent_id = req.nodeId;
    var self = this;

    if (req.parent_id != 0) {
        req.session.cache.get('dep', req.parent_id, function (err, parentDep) {
            if (err) {
                self.onLogicError(2, err);
                return;
            }
            req.parent_name = parentDep.name;
            req.parentDep = parentDep;
            self.getDeps(req, res);
        });
    } else {
        self.getDeps(req, res);
    }
};

PreUpdate.prototype.getDeps = function (req, res) {
    var self = this;
    req.session.cache.getList('dep', '#{parent_id}=='+req.parent_id, function (err, deps) {
        if (err) {
            self.onLogicError(3, err.message);
            return;
        }
        res.rows = [];
        for (var i = 0; i < deps.length; i++) {
            var dep = {};
            dep.id = deps[i].id;
            dep.name = deps[i].name;
            dep.parent_id = deps[i].parent_id;
            dep.company_sign = deps[i].company_sign;
            dep.external_sign = deps[i].external_sign;
            dep.last = true;
            dep.basicData = {
                type: 'dep'
            };
            res.rows.push(dep);
        }
        if((req.parent_id+'')=='0') {
            self.end(res);
            return;
        }

        self.getUsers(req, res, deps);
    });
};

PreUpdate.prototype.getUsers = function (req, res, deps) {
    var self = this;
    req.session.cache.getList('user', ['${1}.contains(#{id})', req.parentDep.users], function (err, users) {
        if (err) {
            self.onLogicError(3, err.message);
            return;
        }
        for (var i = 0; i < users.length; i++) {
            var user = {};
            user.id = 'user_' + users[i].id;
            user.code = users[i].code;
            user.name = users[i].name;
            user.parent_id = req.parent_id;
            user.basicData = {
                type: 'user',
                dep_name: users[i].dep_name,
                post_name: users[i].post_name,
                sex: users[i].sex,
                head_code: users[i].head_code,
                head_id: users[i].head_id
            };
            res.rows.push(user);
        }
        self.end(res);
    });
}

PreUpdate.prototype.getUsersByKeyword = function (req, res, deps) {
    var self = this;
    req.session.cache.getList('user', "#{name}.indexOf('"+req.keyword+"')>=0", function (err, users) {
        if (err) {
            self.onLogicError(3, err.message);
            return;
        }
        res.rows = [];
        for (var i = 0; i < users.length; i++) {
            var user = {};
            user.id = 'user_' + users[i].id;
            user.code = users[i].code;
            user.name = users[i].name;
            user.parent_id = req.parent_id;
            user.basicData = {
                type: 'user',
                dep_name: users[i].dep_name,
                post_name: users[i].post_name,
                sex: users[i].sex,
                head_code: users[i].head_code,
                head_id: users[i].head_id
            };
            res.rows.push(user);
        }
        self.end(res);
    });
}