var Service = require('Service');
var utils = require('utils');
var util = require('util');
var User = require('../../../sys/dao/user');
var Org = require('../../../sys/dao/org');

/**
 * 修改用户
 */
var MupateUserInfo = function () {
    Service.call(this);
};

util.inherits(MupateUserInfo, Service);

module.exports = MupateUserInfo;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MupateUserInfo.prototype.process = function (req, res, cb) {
    if (req.mobile && !utils.isPhone(req.mobile)) {
        this.onLogicError(1, '请提供正确的手机号！', req, res, cb);
        return;
    }
    if (req.email && !utils.isEmail(req.email)) {
        this.onLogicError(2, '请提供正确的邮件地址！', req, res, cb);
        return;
    }

    var user = {};
    user.mobile = req.mobile;
    user.email = req.email;
    user.tel_short = req.tel_short;
    user.tel_work = req.tel_work;
    user.tel_home = req.tel_home;
    user.tel_other = req.tel_other;

    var self = this;
    var dao = new User(this);
    dao.update(user, { where: 'id=' + req.session.userId + ' and org_id=' + req.session.orgId }, function (ret) {
        self.updateCache(req, res, user, cb);
    });
};

MupateUserInfo.prototype.updateCache = function (req, res, user, cb) {
    var self = this;
    var orgDao = new Org(this);
    orgDao.setLastUpdate(req.session.orgId, function (lastUpdate) {
        req.session.cache.set('user', parseInt(req.session.userId), user, true, function (err) {
            if (err) {
                self.onLogicError(6, err.message, req, res, cb);
                return;
            }
            self.end(res);
        });
    });
};