var Service = require('Service');
var User = require('../../../sys/dao/user');
var util = require('util');
var utils = require('utils');
var crypto = require('crypto');
var SettingDao = require('../../dao/sys_setting');

/**
 * 修改自己的登录密码
 */
var MupdateSelePwd = function () {
    Service.call(this);
    this.checkAuthority = false;
};

util.inherits(MupdateSelePwd, Service);

module.exports = MupdateSelePwd;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MupdateSelePwd.prototype.process = function (req, res) {
    if (req.serverType == 'im') res.type = 'updateSelfPwdRet';

    if (!req.oldPwd) {
        this.onLogicError(1, '请提供原密码！');
        return;
    }

    if (!req.newPwd) {
        this.onLogicError(2, '新密码不能为空！');
        return;
    }

    if (req.newPwd.length < 4) {
        this.onLogicError(3, '密码长度不能小于4位！');
        return;
    }

    if (req.newPwd.length > 20) {
        this.onLogicError(4, '密码长度不能超过20！');
        return;
    }

    var reg = /\s|'/i;
    if (reg.test(req.newPwd)) {
        this.onLogicError(5, '密码不能包含单引号和空格！');
        return;
    }

    var self = this;
    var settingDao = new SettingDao(this);
    var userDao = (new User(this));

    // 查密码效验设置信息
    settingDao.query({
        fields: "sys_setting.safe_json,org.default_pwd",
        where: 'sys_setting.org_id=?',
        join: 'sys_org as org on org.id=sys_setting.org_id',
        params: [req.session.orgId]
    }, function (rows) {
        if (rows.length > 0 && rows[0].safe_json) {
            var safe_json = JSON.parse(rows[0].safe_json);
            var md52 = crypto.createHash('md5');
            md52.update(req.newPwd);
            var newPwd = md52.digest('hex');

            if (safe_json.forced_password == '1' && newPwd == rows[0].default_pwd) {
                self.onLogicError(6, '不能设置为默认密码！');
                return;
            }

            var list1 = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'];
            var list2 = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
            var list3 = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
            var list4 = ['!', '@', '#', '$', '%', '^', '&', '*', '?','~','_','-','+','=','\\'];
            if (safe_json.safety_level == '0') {
                // 四位
                if (req.newPwd.length < 4) {
                    self.onLogicError(5, '密码长度不能小于4位！');
                    return;
                }
            } else if (safe_json.safety_level == '1') {
                // 六位、字母、数字
                if (req.newPwd.length < 4) {
                    self.onLogicError(5, '密码长度不能小于6位！');
                    return;
                }
                var dBool = false;
                var xBool = false;
                var sBool = false;
                var tBool = false;
                var index = 0;
                for (var i = 0; i < req.newPwd.length; i++) {
                    if (list1.contains(req.newPwd[i]) && !xBool) {
                        xBool = true;
                        index++;
                    } else if (list2.contains(req.newPwd[i]) && !dBool) {
                        dBool = true;
                        index++;
                    } else if (list3.contains(req.newPwd[i]) && !sBool) {
                        sBool = true;
                        index++;
                    } else if (list4.contains(req.newPwd[i]) && !tBool) {
                        tBool = true;
                        index++;
                    }
                }
                if (index < 2) {
                    self.onLogicError(6, '弱密码强度，至少含有大写字符、小写字符、数字、特殊字符中的两种！');
                    return;
                }
            } else if (safe_json.safety_level == '2') {
                // 六位、小写字母、数字、特殊字符
                // 六位、字母、数字
                if (req.newPwd.length < 4) {
                    self.onLogicError(5, '密码长度不能小于6位！');
                    return;
                }
                var dBool = false;
                var xBool = false;
                var sBool = false;
                var tBool = false;
                var index = 0;
                for (var i = 0; i < req.newPwd.length; i++) {
                    if (list1.contains(req.newPwd[i]) && !xBool) {
                        xBool = true;
                        index++;
                    } else if (list3.contains(req.newPwd[i]) && !sBool) {
                        sBool = true;
                        index++;
                    } else if (list4.contains(req.newPwd[i]) && !tBool) {
                        tBool = true;
                        index++;
                    }
                }
                if (index < 3) {
                    self.onLogicError(6, '弱密码强度，需要含有小写字符、数字、特殊字符！');
                    return;
                }
            }else  if (safe_json.safety_level == '3') {
                // 六位、大写字母、小写字母、数字、特殊字符
                // 六位、字母、数字
                if (req.newPwd.length < 4) {
                    self.onLogicError(5, '密码长度不能小于6位！');
                    return;
                }
                var dBool = false;
                var xBool = false;
                var sBool = false;
                var tBool = false;
                var index = 0;
                for (var i = 0; i < req.newPwd.length; i++) {
                    if (list1.contains(req.newPwd[i]) && !xBool) {
                        xBool = true;
                        index++;
                    } else if (list2.contains(req.newPwd[i]) && !dBool) {
                        dBool = true;
                        index++;
                    } else if (list3.contains(req.newPwd[i]) && !sBool) {
                        sBool = true;
                        index++;
                    } else if (list4.contains(req.newPwd[i]) && !tBool) {
                        tBool = true;
                        index++;
                    }
                }
                if (index < 4) {
                    self.onLogicError(6, '弱密码强度，需要含有大写字符、小写字符、数字、特殊字符！');
                    return;
                }
            }
        }

        userDao.query({
            fields: 'password', where: 'org_id=' + req.session.orgId
                + ' and id=' + req.session.userId
        }, function (users) {
            if (users.length == 0) {
                self.onLogicError(4, '用户信息有误！');
                return;
            }

            //加密
            var md5 = crypto.createHash('md5');
            md5.update(req.oldPwd);
            req.oldPwd = md5.digest('hex');

            var user = users[0];
            if (user.password != (req.oldPwd + '')) {
                self.onLogicError(5, '原密码不正确！');
                return;
            }

            var md52 = crypto.createHash('md5');
            md52.update(req.newPwd);
            req.newPwd = md52.digest('hex');

            var userInfo = {};
            userInfo.password = req.newPwd;
            if (!req.fromOtherSys) userInfo.last_update_pwd = new Date();
            userDao.update(userInfo, {
                where: 'org_id=' + req.session.orgId
                    + ' and id=' + req.session.userId
            }, function (ret) {
                req.session.cache.set('user', req.session.userId, { password: req.newPwd }, true, function (err) {
                    if (err) {
                        self.onLogicError(3, err.message);
                        return;
                    }
                    self.end(res);
                });
            });
        });
    });
};