var Service = require('Service');
var util = require('util');
var utils = require('utils');
var DepDao = require('../../dao/dep');
var UserSubDep = require('../../dao/user_subdep');

/**
 * 获得管辖部门列表
 */
var MgetListSub = function() { 
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(MgetListSub, Service);

module.exports = MgetListSub;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MgetListSub.prototype.process =  function(req, res) {
  if(!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.userId)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }

  res.deps = [];
  this.end(res);
  return;

  var self = this;
  var depDao = new DepDao(this);
  var userDao = new UserSubDep(this);
  userDao.query({
    fields:'sys_user_subdep.id,sys_user_subdep.order_number,sys_user_subdep.dep_id,(sys_dep.name) as dep_name,'
           +'sys_user_subdep.layer_id,(sys_layer.name) as layer_name',
    where:'sys_user_subdep.org_id=? and sys_user_subdep.user_id=?',
    params:[req.session.orgId, req.userId],
    join:'sys_dep on sys_dep.org_id='+req.session.orgId+' and sys_dep.id=sys_user_subdep.dep_id'
         +' left join sys_layer on sys_layer.org_id='+req.session.orgId+' and sys_layer.id=sys_user_subdep.layer_id',
    order:'sys_user_subdep.order_number asc'
  }, function(rows){
    res.deps = [];
    for(var i=0;i<rows.length;i++) {
      var dep = {};
      dep.id = rows[i].id; 
      dep.depId = rows[i].dep_id;
      dep.depName = rows[i].dep_name;
      dep.layerId = rows[i].layer_id;
      dep.layerName = rows[i].layer_name;
      res.deps.push(dep);
    }
    self.end(res);
  })
};

MgetListSub.prototype.setDepPath =  function(req, dep) {
  var depTmp = dep;
  var parent_id = req.session.org.deps[depTmp.depId].parent_id;
  while(parent_id>0) {
    depTmp = req.session.org.deps[parent_id];
    dep.name = depTmp.name + '-'+dep.name;
    parent_id = depTmp.parent_id;
  }
};