var Service = require('Service');
var utils = require('utils');
var Dep = require('../../dao/dep');
var Post = require('../../dao/post');
var DepUser = require('../../dao/dep_user');
var util = require('util');

/**
 * 获得用户所在部门列表
 */
var MgetDepList = function() { 
  Service.call(this);
  this.checkAuthority = false;
};

util.inherits(MgetDepList, Service);

module.exports = MgetDepList;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MgetDepList.prototype.process =  function(req, res, cb) {
  if(!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if(!utils.isInt(req.userId)) {
    this.onLogicError(2, '请提供正确的用户编号！');
    return;
  }

  res.deps = [];
  var self = this;
  var daoDepUser = new DepUser(self);
  var where = '';
  /*if(req.chief==true){
    where += ' and order_number=?';
  }else{
    where = ' and order_number>?';
  }*/
  daoDepUser.query({fields:'0 as id,user_id,dep_id,0 as post_id,0 as level_id,(select name from sys_dep where id=dep_id) '+
    'as dep_name, null as post_name,0 as order_number,null as level_name', 
    where:'org_id=? and user_id=?'+where,
    params:[req.session.orgId, req.userId, 1],order:'dep_id asc'}, function(rows){
    res.deps = rows;
    self.end(res);
  })
};