var Service = require('Service');
var util = require('util');
var UserBll = require('../../bll/UserBll');

/**
 * 获取职员列表√
 */
var MGet = function () {
  Service.call(this);
};

util.inherits(MGet, Service);

module.exports = MGet;

/**
 * 获取职员√
 * @param  {Object} req 服务请求对象
 * id
 * @param  {Object} res 服务响应对象
 * level
 */
MGet.prototype.process = function (req, res, cb) {
  var self = this;
  var userBll = new UserBll(self);

  //获取
  userBll.get_user(req, { "id": req.id }, function (user, msg) {
    if (msg) {
      self.onLogicError(1, msg, req, res, cb);
      return;
    }
    res.user = user;

    if (cb) cb(req, res);
    else self.end(res);
  });
};