var Service = require('Service');
var util = require('util');
var OrgBll = require('../../bll/OrgBll');
var RoleBll = require('../../bll/RoleBll');
var CacheBll = require('../../bll/Cache');

/**
 * 修改角色√
 */
var MUpdate = function () {
  Service.call(this);
};

util.inherits(MUpdate, Service);

module.exports = MUpdate;

/**
 * 修改角色√
 * @param  {Object} req 服务请求对象
 * id code name description
 * @param  {Object} res 服务响应对象
 * id
 */
MUpdate.prototype.process = function (req, res, cb) {
  var self = this;
  var orgBll = new OrgBll(self);
  var roleBll = new RoleBll(self);
  var cacheBll = new CacheBll(self);

  var role = {
    "id": req.id,
    "code": req.code,
    "name": req.name,
    "type_id": req.type_id,
    "description": req.description
  };

  console.log(role);

  //获取原数据
  roleBll.get_role(req, { "id": role.id }, function (o_role, msgg) {
    if (msgg) {
      self.onLogicError(1, msgg, req, res, cb);
      return;
    }
    //验证
    roleBll.verify_update_role(req, { "role": role, "o_role": o_role }, function (ret0, msg0) {
      if (msg0) {
        self.onLogicError(1, msg0, req, res, cb);
        return;
      }
      //处理库
      roleBll.update_role(req, { "role": role, "o_role": o_role }, function (ret, msg) {
        if (msg) {
          self.onLogicError(1, msg, req, res, cb);
          return;
        }
        if (ret.role == null) {
          self.onLogicError(1, '角色未修改成功！', req, res, cb);
          return;
        }
        //写日志
        orgBll.write_log(req, { "operate_type": "update_role", "operate_content": "修改角色:" + ret.role.id + "(" + ret.role.name + "_" + ret.role.code + ")" }, function (retl, msgl) {
          if (msgl) {
            self.onLogicError(1, msgl, req, res, cb);
            return;
          }

          console.log(1111);
          //处理缓存
          cacheBll.updateMRole(req, { "role": ret.role, "o_role": o_role }, function (err) {
            if (err) {
              self.onLogicError(3, err.message, req, res, cb);
              return;
            }
            console.log(22222);
            res.id = ret.role.id;
            console.log(33333);
            if (cb) cb(req, res);
            else self.end(res);

            // req.session.cache.getList('mrole', [], function (err, objs) {
            //   res.objs = objs;
            //   self.end(res);
            // });
          });
        });
      });
    });
  });
};