var Service = require('Service');
var RoleUser = require('../../dao/role_user');
var utils = require('utils');
var util = require('util');

/**
 * 设置管理员
 */
var MsetAdmin = function () {
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(MsetAdmin, Service);

module.exports = MsetAdmin;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MsetAdmin.prototype.process = function (req, res) {
  if (!req.userId) {
    this.onLogicError(1, '请提供用户编号！');
    return;
  }
  if (!utils.isInt(req.userId)) {
    this.onLogicError(1, '请提供正确的用户编号！');
    return;
  }
  if (!req.roleId) {
    this.onLogicError(2, '请提供群组编号！');
    return;
  }
  if (!utils.isInt(req.roleId)) {
    this.onLogicError(2, '请提供正确的群组编号！');
    return;
  }
  var isAdmin = 0;
  if (req.isAdmin) isAdmin = 1;
  var self = this;
  var dao = new RoleUser(this);
  dao.update({ is_admin: isAdmin }, {
    where: 'org_id='
      + req.session.orgId + ' and role_id=' + req.roleId
      + ' and user_id=' + req.userId
  }, function () {
    self.end(res);
  });
};