var Service = require('Service');
var util = require('util');
var RoleBll = require('../../bll/RoleBll');

/**
 * 获取角色列表√
 */
var MList = function () {
  Service.call(this);
};

util.inherits(MList, Service);

module.exports = MList;

/**
 * 获取角色列表√
 * @param  {Object} req 服务请求对象
 * keyword within_id without_id
 * @param  {Object} res 服务响应对象
 * list
 */
MList.prototype.process = function (req, res, cb) {
  var self = this;
  var roleBll = new RoleBll(self);
  //列表
  roleBll.list_role(req, {
    "keyword": req.keyword,
    "within_id": req.within_id,
    "without_id": req.without_id
  }, function (list, msg) {
    if (msg) {
      self.onLogicError(1, msg, req, res, cb);
      return;
    }
    res.rows = list;

    if (cb) cb(req, res);
    else self.end(res);
  });
};