var Service = require('Service');
var util = require('util');
var OrgBll = require('../../bll/OrgBll');
var RoleBll = require('../../bll/RoleBll');
var CacheBll = require('../../bll/Cache');

/**
 * 添加角色√
 */
var MInsert = function () {
  Service.call(this);
};

util.inherits(MInsert, Service);

module.exports = MInsert;

/**
 * 添加角色√
 * @param  {Object} req 服务请求对象
 * code name description
 * @param  {Object} res 服务响应对象
 * id
 */
MInsert.prototype.process = function (req, res, cb) {
  var self = this;
  var orgBll = new OrgBll(self);
  var roleBll = new RoleBll(self);
  var cacheBll = new CacheBll(self);

  var role = {
    "code": req.code,
    "name": req.name,
    "type_id": req.type_id,
    "description": req.description
  };

  //验证
  roleBll.verify_insert_role(req, { "role": role }, function (ret0, msg0) {
    if (msg0) {
      self.onLogicError(1, msg0, req, res, cb);
      return;
    }
    //处理库
    roleBll.insert_role(req, { "role": role }, function (ret, msg) {
      if (msg) {
        self.onLogicError(1, msg, req, res, cb);
        return;
      }
      if (ret.role == null) {
        self.onLogicError(1, '角色未添加成功！', req, res, cb);
        return;
      }
      //写日志
      orgBll.write_log(req, { "operate_type": "insert_role", "operate_content": "添加角色:" + ret.role.id + "(" + ret.role.name + "_" + ret.role.code + ")" }, function (retl, msgl) {
        if (msgl) {
          self.onLogicError(1, msgl, req, res, cb);
          return;
        }
        //处理缓存
        cacheBll.insertMRole(req, { "role": ret.role }, function (retc, err) {
          if (err) {
            self.onLogicError(3, err.message, req, res, cb);
            return;
          }
          res.id = ret.role.id;
          if (cb) cb(req, res);
          else self.end(res);

          // req.session.cache.getList('mrole', [], function (err, objs) {
          //   res.objs = objs;
          //   self.end(res);
          // });
        });
      });
    });
  });
};