var Service = require('Service');
var util = require('util');
var utils = require('utils');
var RoleDao = require('../../dao/vrole_user');

/**
 * 获得角色用户列表
 */
var MgetListUser = function () {
  Service.call(this);
  this.enableTransaction = false;
};

util.inherits(MgetListUser, Service);

module.exports = MgetListUser;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MgetListUser.prototype.process = function (req, res) {
  if (!req.id) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if (!utils.isInt(req.id)) {
    this.onLogicError(2, '请提供正确的角色编号！');
    return;
  }
  var self = this;
  var roleDao = new RoleDao(this);
  var where = '';
  var params = null;
  if (req.keyword) {
    where = ' and (user_name like ?)';
    params = ['%' + req.keyword + '%'];
  }
  if (req.showAll) {
    // 显示离职人员
  }
  roleDao.queryDataPage(req, {
    fields: '* ,(select loginname from tm_user where id = vsys_role_user.user_id) as loginname,' +
      '(select dep_name from vsys_user where org_id=vsys_role_user.org_id and id=vsys_role_user.user_id) as dep_name',
    where: 'role_id=' + req.id + ' and org_id=' + req.session.orgId + where, params: params, order: 'is_admin desc'
  },
    function (dataPage) {
      res.dataPage = dataPage;
      self.emit('end', res);
    });
};