var Service = require('Service');
var util = require('util');
var RoleTypeDao = require('../../dao/role_type');

/**
 * 获得角色列表
 */
var MgetListType = function () {
  Service.call(this);
};

util.inherits(MgetListType, Service);

module.exports = MgetListType;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
MgetListType.prototype.process = function (req, res) {
  var self = this;
  var dao0 = new RoleTypeDao(this);
  dao0.query({
    fields: 'id,code,name,createtime',
    where: 'org_id=?',
    params: [req.session.orgId],
    order: 'code ASC, id ASC'
  }, function (rows) {
    res.rows = rows;
    self.end(res);
  });
};