var Service = require('Service');
var util = require('util');
var CacheBll = require('../../bll/Cache');

/**
 * 获取当前用户角色√
 */
var MgetListByUser = function () {
  Service.call(this);
};

util.inherits(MgetListByUser, Service);

module.exports = MgetListByUser;

/**
 * 获取角色列表√
 * @param  {Object} req 服务请求对象
 * keyword within_id without_id
 * @param  {Object} res 服务响应对象
 * list
 */
MgetListByUser.prototype.process = function (req, res, cb) {
  var self = this;
  var cacheBll = new CacheBll(self);
  var user_id = req.session.userId;
  if (req.user_id) {
    user_id = req.user_id;
  }
  //列表
  req.session.cache.get('user', user_id, function (err, user) {
    if (err) {
      self.onLogicError(1, err);
      return;
    }
    req.session.cache.getList('role', ['${1}.contains(#{id}) && #{name}!="所有人"', user.roles], function (err2, roles) {
      if (err2) {
        self.onLogicError(1, err2);
        return;
      }
      res.rows = roles;
      self.end(res);
    });
  });
};