var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/org_app_auth');

/**
 * 获取应用权限
 */
var MgetListApp = function () {
  Service.call(this);
};

util.inherits(MgetListApp, Service);

module.exports = MgetListApp;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
MgetListApp.prototype.process = function (req, res) {
  var self = this;
  var dao = new Dao(this);
  if (!req.roleId) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if (!utils.isInt(req.roleId)) {
    this.onLogicError(2, '请提供正确的角色编号！');
    return;
  }
  if (!req.terminal) {
    this.onLogicError(2, '请提供终端类型！');
    return;
  }

  dao.queryDataPage(req, {
    fields: 'sys_org_app_auth.app_id, sys_org_app_auth.id, sys_org_app_auth.owner_id,sys_org_app.name,sys_org_app.status,sys_org_app.terminal',
    where: 'sys_org_app_auth.org_id=? and sys_org_app_auth.owner_id=? and sys_org_app_auth.owner_type=\'role\' and sys_org_app_auth.terminal=? and sys_org_app.status=0',
    order: 'sys_org_app_auth.id desc',
    join: 'sys_org_app on sys_org_app_auth.app_id=sys_org_app.id',
    // group: 'sys_org_app_auth.app_id',
    order: 'id ASC',
    params: [req.session.orgId, req.roleId, req.terminal]
  }, function (dataPage) {
    res.dataPage = dataPage;
    self.end(res);
  });
};