var Service = require('Service');
var util = require('util');
var RoleBll = require('../../bll/RoleBll');

/**
 * 获取角色代码√
 */
var MGetCode = function () {
  Service.call(this);
};

util.inherits(MGetCode, Service);

module.exports = MGetCode;

/**
 * 获取角色代码√
 * @param  {Object} req 服务请求对象
 * parent_id
 * @param  {Object} res 服务响应对象
 * info
 */
MGetCode.prototype.process = function (req, res, cb) {
  var self = this;
  var roleBll = new RoleBll(self);

  //获取
  roleBll.getCode_role(req, { "parent_id": req.parent_id }, function (info, msg) {
    if (msg) {
      self.onLogicError(1, msg, req, res, cb);
      return;
    }
    res.info = info;

    if (cb) cb(req, res);
    else self.end(res);
  });
};