var Service = require('Service');
var util = require('util');
var RoleBll = require('../../bll/RoleBll');
var RoleType = require('../../dao/role_type');

/**
 * 获取角色列表√
 */
var MGet = function () {
  Service.call(this);
};

util.inherits(MGet, Service);

module.exports = MGet;

/**
 * 获取角色√
 * @param  {Object} req 服务请求对象
 * id
 * @param  {Object} res 服务响应对象
 * role
 */
MGet.prototype.process = function (req, res, cb) {
  var self = this;
  var roleBll = new RoleBll(self);
  var roleType = new RoleType(self);

  //获取
  roleBll.getv_role(req, { "id": req.id }, function (role, msg) {
    if (msg) {
      self.onLogicError(1, msg, req, res, cb);
      return;
    }
    res.role = role;

    roleType.query({
      field: 'id,name,code',
      where: 'org_id=' + req.session.orgId,
      order: 'code asc'
    }, function (rows) {
      res.types = rows;
      if (cb) cb(req, res);
      else self.end(res);
    });
  });
};