var Service = require('Service');
var util = require('util');
var OrgBll = require('../../bll/OrgBll');
var RoleBll = require('../../bll/RoleBll');
var CacheBll = require('../../bll/Cache');

/**
 * 启用角色√
 */
var Menable = function () {
    Service.call(this);
};

util.inherits(Menable, Service);

module.exports = Menable;

/**
 * 启用角色√
 * @param  {Object} req 服务请求对象
 * id
 * @param  {Object} res 服务响应对象
 */
Menable.prototype.process = function (req, res, cb) {
    var self = this;

    var orgBll = new OrgBll(self);
    var roleBll = new RoleBll(self);
    var cacheBll = new CacheBll(self);

    //验证
    roleBll.verify_enable_role(req, { "id": req.id }, function (ret0, msg0) {
        if (msg0) {
            self.onLogicError(1, msg0, req, res, cb);
            return;
        }
        //处理库
        roleBll.enable_role(req, { "id": req.id }, function (ret, msg) {
            if (msg) {
                self.onLogicError(2, msg, req, res, cb);
                return;
            }
            if (ret.id == null) {
                self.onLogicError(3, '角色未启用成功！', req, res, cb);
                return;
            }
            //处理库启用角色对应的职员数据
            roleBll.enable_role_user(req, { "id": req.id }, function (mOwnRoles) {
                //写日志
                orgBll.write_log(req, { "operate_type": "enable_role", "operate_content": "启用角色:" + ret.id }, function (retl, msgl) {
                    if (msgl) {
                        self.onLogicError(4, msgl, req, res, cb);
                        return;
                    }
                    //获取
                    roleBll.getv_role(req, { "id": req.id }, function (role, msg) {
                        if (msg) {
                            self.onLogicError(5, msg, req, res, cb);
                            return;
                        }
                        //处理缓存
                        cacheBll.insertMRole(req, { "role": role }, function (retc, err) {
                            if (err) {
                                self.onLogicError(6, err.message, req, res, cb);
                                return;
                            }
                            if (mOwnRoles && mOwnRoles.length > 0) {
                                cacheBll.insertMOwnRole(req, { "mOwnRoles": mOwnRoles }, function (retc, err1) {
                                    if (err1) {
                                        self.onLogicError(7, err1.message, req, res, cb);
                                        return;
                                    }
                                    if (cb) cb(req, res);
                                    else self.end(res);
                                });
                            } else {
                                if (cb) cb(req, res);
                                else self.end(res);
                            }
                        });
                    });

                });
            });
        });
    });
};