var Service = require('Service');
var util = require('util');
var OrgBll = require('../../bll/OrgBll');
var RoleBll = require('../../bll/RoleBll');
var CacheBll = require('../../bll/Cache');

/**
 * 停用角色√
 */
var Mdisable = function () {
  Service.call(this);
};

util.inherits(Mdisable, Service);

module.exports = Mdisable;

/**
 * 停用角色√
 * @param  {Object} req 服务请求对象
 * id
 * @param  {Object} res 服务响应对象
 */
Mdisable.prototype.process = function (req, res, cb) {
  var self = this;

  var orgBll = new OrgBll(self);
  var roleBll = new RoleBll(self);
  var cacheBll = new CacheBll(self);

  //验证
  roleBll.verify_disable_role(req, { "id": req.id }, function (ret0, msg0) {
    if (msg0) {
      self.onLogicError(1, msg0, req, res, cb);
      return;
    }
    //处理库
    roleBll.disable_role(req, { "id": req.id }, function (ret, msg) {
      if (msg) {
        self.onLogicError(1, msg, req, res, cb);
        return;
      }
      if (ret.id == null) {
        self.onLogicError(1, '角色未停用成功！', req, res, cb);
        return;
      }
      //写日志
      orgBll.write_log(req, { "operate_type": "disable_role", "operate_content": "停用角色:" + ret.id }, function (retl, msgl) {
        if (msgl) {
          self.onLogicError(1, msgl, req, res, cb);
          return;
        }
        //处理缓存
        cacheBll.deleteMRole(req, { "id": ret.id }, function (err) {
          if (err) {
            self.onLogicError(3, err.message, req, res, cb);
            return;
          }
          //处理角色人员缓存
          cacheBll.deleteMOwnRole(req, { "role_id": ret.id }, function (ret, err1) {
            if (err1) {
              self.onLogicError(3, err1.message, req, res, cb);
              return;
            }

            if (cb) cb(req, res);
            else self.end(res);
          });
        });
      });
    });
  });
};