var Service = require('Service');
var utils = require('utils');
var util = require('util');
// var Role_User = require('../../dao/role_user');
// var Org = require('../../dao/org');
var OrgBll = require('../../bll/OrgBll');
var RoleBll = require('../../bll/RoleBll');
var CacheBll = require('../../bll/Cache');

/**
 * 删除角色用户
 */
var MdeleteUser = function () {
  Service.call(this);
};

util.inherits(MdeleteUser, Service);

module.exports = MdeleteUser;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MdeleteUser.prototype.process = function (req, res, cb) {
  var self = this;

  var orgBll = new OrgBll(self);
  var roleBll = new RoleBll(self);
  var cacheBll = new CacheBll(self);

  var obj = {};
  obj.user_ids = req.user_id + '';
  obj.role_id = req.roleId + '';
  //验证
  roleBll.verify_delete_role_user(req, obj, function (ret0, msg0) {
    if (msg0) {
      self.onLogicError(1, msg0, req, res, cb);
      return;
    }
    //查询
    roleBll.getList_role_user(req, obj, function (roleUsers, msg1) {
      if (msg1) {
        self.onLogicError(1, msg1, req, res, cb);
        return;
      }
      //处理库
      roleBll.delete_role_user(req, obj, function (ret, msg2) {
        if (msg2) {
          self.onLogicError(1, msg2, req, res, cb);
          return;
        }
        var operate_content = '删除角色职员:';
        for (var i = 0; i < roleUsers.length; i++) {
          if (operate_content) operate_content += '，';
          operate_content += roleUsers[i].role_id + '_' + roleUsers[i].user_id;
        }
        //写日志
        orgBll.write_log(req, { "operate_type": "delete_role_user", "operate_content": operate_content }, function (retl, msg3) {
          if (msg3) {
            self.onLogicError(1, msg3, req, res, cb);
            return;
          }
          //处理缓存
          cacheBll.deleteMOwnRole(req, obj, function (retc, errc) {
            if (errc) {
              self.onLogicError(3, errc.message, req, res, cb);
              return;
            }

            if (cb) cb(req, res);
            else self.end(res);
          });
        });
      });
    });
  });
};