var Service = require('Service');
var util = require('util');
var utils = require('utils');
var Dao = require('../../dao/org_app_auth');

/**
 * 删除应用权限
 */
var MdeleteApp = function () {
  Service.call(this);
};

util.inherits(MdeleteApp, Service);

module.exports = MdeleteApp;

/**
 * 处理服务请求
 * @param {Object} req 服务请求对象
 * @param {Object} res 服务响应对象
 */
MdeleteApp.prototype.process = function (req, res) {
  if (!req.appId) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if (!req.roleId) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if (!req.terminal) {
    this.onLogicError(1, '请提供终端类型！');
    return;
  }
  var arrAppId = utils.strToIntArray(req.appId);
  if (arrAppId.length == 0) {
    this.onLogicError(4, '请提供正确的应用编号！');
    return;
  }
  arrAppId = arrAppId.join();
  var self = this;
  var dao = new Dao(this);
  dao.delete({
    where: 'org_id=? and app_id in (' + arrAppId + ') and owner_type=\'role\' and owner_id=? and terminal=?',
    params: [req.session.orgId, req.roleId, req.terminal]
  }, function () {
    req.session.cache.del('org_app_auth', '[' + arrAppId + '].contains(#{app_id}) && #{owner_type}=="role" && #{owner_id}==' + req.roleId +
      ' && #{terminal}=="' + req.terminal + '"', function (err) {
        if (err) {
          self.onError(err);
          return;
        }
        self.end(res);
      });
  });
};