var Service = require('Service');
var utils = require('utils');
var RoleType = require('../../dao/role_type');
var util = require('util');

/**
 * 添加类型
 */
var MaddType = function () {
  Service.call(this);
};

util.inherits(MaddType, Service);

module.exports = MaddType;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MaddType.prototype.process = function (req, res, cb) {
  if (!req.code) {
    this.onLogicError(1, '请提供编码！');
    return;
  }
  if (!req.name) {
    this.onLogicError(2, '请提供名称！');
    return;
  }

  var self = this;
  var dao = new RoleType(this);
  dao.query({
    where: 'name=? and org_id=' + req.session.orgId,
    fields: 'id',
    params: [req.name]
  }, function (rows) {
    if (rows.length > 0) {
      self.onLogicError(3, '名称已经存在！');
      return;
    }
    var type = {};
    type.org_id = req.session.orgId;
    type.code = req.code;
    type.name = req.name;
    type.creater_id = req.session.userId;
    type.createtime = new Date();
    dao.create(type, function (ret) {
      res.id = ret.insertId;
      self.end(res);
    });
  });
};