var Service = require('Service');
var utils = require('utils');
var Dao = require('../../dao/org_app_auth');
var uuid = require('node-uuid');
var util = require('util');
var fs = require('fs');

/**
 * 应用权限
 */
var MaddApp = function () {
  Service.call(this);
};

util.inherits(MaddApp, Service);

module.exports = MaddApp;

/**
 * 处理服务请求
 * @param  {Object} req 服务请求对象
 * @param  {Object} res 服务响应对象
 */
MaddApp.prototype.process = function (req, res) {
  if (!req.appId) {
    this.onLogicError(1, '请提供应用编号！');
    return;
  }
  if (!req.roleId) {
    this.onLogicError(1, '请提供角色编号！');
    return;
  }
  if (!req.terminal) {
    this.onLogicError(1, '请提供终端类型！');
    return;
  }
  var arrAppId = utils.strToIntArray(req.appId);
  if (arrAppId.length == 0) {
    this.onLogicError(4, '请提供正确的应用编号！');
    return;
  }
  this.addAuth(req, res, arrAppId, 0);
};

MaddApp.prototype.addAuth = function (req, res, arr, index) {
  var self = this;
  var dao = new Dao(this);
  if (index >= arr.length) {
    self.end(res);
  } else {
    var appId = parseInt(arr[index]);
    var options = {
      where: 'org_id=? and app_id=? and owner_type=? and owner_id =? and terminal=?',
      params: [req.session.orgId, appId, 'role', req.roleId, req.terminal]
    };
    dao.delete(options, function () {
      dao.execute('insert into sys_org_app_auth(org_id,app_id,owner_type,owner_id,terminal) values(?,?,?,?,?)',
        [req.session.orgId, appId, 'role', req.roleId, req.terminal],
        function () {
          dao.query(options, function (auths) {
            req.session.cache.del('org_app_auth', "#{app_id}==" + appId + " && #{owner_type}=='role' && #{terminal}=='" + req.terminal + "' && #{owner_id}==" + req.roleId, function (err1) {
              if (err1) {
                self.onError(err1);
                return;
              }
              var params = [];
              var auth = auths[0];
              params.push({
                modelName: 'org_app_auth',
                key: auth.id,
                value: auth
              });
              req.session.cache.mset(params, function (err2) {
                if (err2) {
                  self.onError(err2);
                  return;
                }
                index++;
                self.addAuth(req, res, arr, index);
              });
            });
          });
        });
    });
  }
};