var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendGroup = require('../../dao/user_friend_group');

/**
 * 修改分组
 **/

var updateGroup = function() {
    Service.call(this);
};

util.inherits(updateGroup, Service);

module.exports = updateGroup;

updateGroup.prototype.process = function(req, res) {
    if (!req.data.name) {
        this.onLogicError(1, '请提供分组名称！');
        return;
    }
    if (req.data.name.length > 10) {
        this.onLogicError(2, '分组名称最大长度为10！');
        return;

    }
    var self = this;
    var friendGroup = new FriendGroup(this);

    self.pipe(require('./getGroup'), req, res, function(data) {
        if (data) {
            self.onLogicError(2, '该分组名称已存在！');
        } else {
            var obj = {}
            obj.name = req.data.name;
            friendGroup.update(obj, {
                where: 'org_id=' + req.session.orgId + ' and id=' + parseInt(req.data.id) + ' and user_id=' + req.session.userId
            }, function(ret) {
                return self.end(res);
            });
        }
    });
}