var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendGroup = require('../../dao/user_friend_group');

/**
 * 获取单条分组数据
 **/

var getGroup = function() {
    Service.call(this);
};

util.inherits(getGroup, Service);

module.exports = getGroup;

getGroup.prototype.process = function(req, res, cb) {
    var self = this;
    var friendGroup = new FriendGroup(this);

    var where = '';
    var params = [req.session.orgId, req.session.userId];
    if (req.data && req.data.name) {
        where += ' and name=?';
        params.push(req.data.name);
        if (req.id) {
            where += ' and id<>?';
            params.push(req.id);
        }
    } else {
        where += ' and id=?';
        params.push(req.id);
    }

    friendGroup.query({
        fields: '*',
        where: 'org_id=? and user_id=? and status=0' + where,
        order: "id ASC",
        params: params
    }, function(rows) {
        res.data = rows[0];
        if (cb) {
            cb(res.data);
        } else {
            return self.end(res);
        }
    });
}