var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendGroup = require('../../dao/user_friend_group');
var FriendDao = require('../../dao/user_friend');

/**
 * 获取分类数据
 **/

var getArray = function() {
    Service.call(this);
};

util.inherits(getArray, Service);

module.exports = getArray;

getArray.prototype.process = function(req, res) {
    var self = this;

    if (req.keyword || req.group_id > 0) {
        self.getUsers(req, res);
    } else {
        var where = 'org_id=? and user_id=? and status=0';
        var params = [req.session.orgId, req.session.userId]
        var friendGroup = new FriendGroup(this);
        friendGroup.query({
            where: where,
            params: params,
        }, function(rows) {
            res.data = rows;
            self.getUsers(req, res);
        });
    }

}

getArray.prototype.getUsers = function(req, res) {
    var self = this;
    var dao = new FriendDao(this);
    var where = " and sys_user_friend.status=0";
    if (req.keyword) {
        where += ' and u.name like \'%' + req.keyword + '%\''
    } else {
        where += ' and sys_user_friend.group_id = ' + req.group_id
    }
    dao.query({
        fields: 'sys_user_friend.*,u.name,u.sex,u.mobile,u.email,u.dep_name,u.head_id',
        where: 'sys_user_friend.org_id = ? and sys_user_friend.user_id = ?' + where,
        leftJoin: 'vsys_user u on u.id = sys_user_friend.friend_id',
        params: [req.session.orgId, req.session.userId]
    }, function(rows) {
        if (!res.data) res.data = [];
        for (var i = 0; i < rows.length; i++) {
            res.data.push(rows[i]);
        }
        return self.end(res);
    });
};