var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendDao = require('../../dao/user_friend');

/**
 * 获取单条分组数据
 **/

var Get = function() {
    Service.call(this);
};

util.inherits(Get, Service);

module.exports = Get;

Get.prototype.process = function(req, res) {
    if (!req.id) {
        this.onLogicError(1, '请提供编号！');
        return;
    }

    var self = this;
    var dao = new FriendDao(this);

    dao.query({
        fields: '*,(select name from vsys_user where id=sys_user_friend.friend_id) as friend_name',
        where: 'org_id=? and user_id=? and id=?',
        params: [req.session.orgId, req.session.userId, req.id]
    }, function(rows) {
        res.data = rows[0];
        return self.end(res);
    });
}