var Service = require('Service');
var utils = require('utils');
var util = require('util');
var FriendGroup = require('../../dao/user_friend_group');
var FriendDao = require('../../dao/user_friend');

/**
 * 删除分组数据
 **/

var deleteGroup = function() {
    Service.call(this);
};

util.inherits(deleteGroup, Service);

module.exports = deleteGroup;

deleteGroup.prototype.process = function(req, res) {
    var self = this;
    var dao = new FriendDao(this);

    dao.query({
        fields: 'id',
        where: 'org_id=? and user_id=? and status=0 and group_id in (' + req.ids + ')',
        params: [req.session.orgId, req.session.userId]
    }, function(rows) {
        if (rows.length > 0) {
            self.onLogicError(1, '当前分组下还有联系人数据，请先删除分组下联系人！');
        } else {
            var friendGroup = new FriendGroup(self);
            var obj = {}
            obj.delete_time = new Date();
            obj.status = 1;
            friendGroup.update(obj, {
                where: 'org_id=' + req.session.orgId + ' and id in (' + req.ids + ') and user_id=' + req.session.userId
            }, function(ret) {
                return self.end(res);
            });
        }
    });
};